// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS CodeCommit
///
/// Client for invoking operations on AWS CodeCommit. Each operation on AWS CodeCommit is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codecommit::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codecommit::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codecommit::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateApprovalRuleTemplateWithRepository`](crate::client::fluent_builders::AssociateApprovalRuleTemplateWithRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::AssociateApprovalRuleTemplateWithRepository::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::AssociateApprovalRuleTemplateWithRepository::set_approval_rule_template_name): <p>The name for the approval rule template. </p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::AssociateApprovalRuleTemplateWithRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::AssociateApprovalRuleTemplateWithRepository::set_repository_name): <p>The name of the repository that you want to associate with the template.</p>
    /// - On success, responds with [`AssociateApprovalRuleTemplateWithRepositoryOutput`](crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput)

    /// - On failure, responds with [`SdkError<AssociateApprovalRuleTemplateWithRepositoryError>`](crate::error::AssociateApprovalRuleTemplateWithRepositoryError)
    pub fn associate_approval_rule_template_with_repository(
        &self,
    ) -> fluent_builders::AssociateApprovalRuleTemplateWithRepository {
        fluent_builders::AssociateApprovalRuleTemplateWithRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchAssociateApprovalRuleTemplateWithRepositories`](crate::client::fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories::set_approval_rule_template_name): <p>The name of the template you want to associate with one or more repositories.</p>
    ///   - [`repository_names(Vec<String>)`](crate::client::fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories::repository_names) / [`set_repository_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories::set_repository_names): <p>The names of the repositories you want to associate with the template.</p> <note>   <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>  </note>
    /// - On success, responds with [`BatchAssociateApprovalRuleTemplateWithRepositoriesOutput`](crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput) with field(s):
    ///   - [`associated_repository_names(Option<Vec<String>>)`](crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput::associated_repository_names): <p>A list of names of the repositories that have been associated with the template.</p>
    ///   - [`errors(Option<Vec<BatchAssociateApprovalRuleTemplateWithRepositoriesError>>)`](crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput::errors): <p>A list of any errors that might have occurred while attempting to create the association between the template and the repositories.</p>
    /// - On failure, responds with [`SdkError<BatchAssociateApprovalRuleTemplateWithRepositoriesError>`](crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesError)
    pub fn batch_associate_approval_rule_template_with_repositories(
        &self,
    ) -> fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories {
        fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`BatchDescribeMergeConflicts`](crate::client::fluent_builders::BatchDescribeMergeConflicts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_repository_name): <p>The name of the repository that contains the merge conflicts you want to review.</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`merge_option(MergeOptionTypeEnum)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::merge_option) / [`set_merge_option(Option<MergeOptionTypeEnum>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_merge_option): <p>The merge option or strategy you want to use to merge the code.</p>
    ///   - [`max_merge_hunks(i32)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::max_merge_hunks) / [`set_max_merge_hunks(Option<i32>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_max_merge_hunks): <p>The maximum number of merge hunks to include in the output.</p>
    ///   - [`max_conflict_files(i32)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::max_conflict_files) / [`set_max_conflict_files(Option<i32>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_max_conflict_files): <p>The maximum number of files to include in the output.</p>
    ///   - [`file_paths(Vec<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::file_paths) / [`set_file_paths(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_file_paths): <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::BatchDescribeMergeConflicts::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    /// - On success, responds with [`BatchDescribeMergeConflictsOutput`](crate::output::BatchDescribeMergeConflictsOutput) with field(s):
    ///   - [`conflicts(Option<Vec<Conflict>>)`](crate::output::BatchDescribeMergeConflictsOutput::conflicts): <p>A list of conflicts for each file, including the conflict metadata and the hunks of the differences between the files.</p>
    ///   - [`next_token(Option<String>)`](crate::output::BatchDescribeMergeConflictsOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    ///   - [`errors(Option<Vec<BatchDescribeMergeConflictsError>>)`](crate::output::BatchDescribeMergeConflictsOutput::errors): <p>A list of any errors returned while describing the merge conflicts for each file.</p>
    ///   - [`destination_commit_id(Option<String>)`](crate::output::BatchDescribeMergeConflictsOutput::destination_commit_id): <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    ///   - [`source_commit_id(Option<String>)`](crate::output::BatchDescribeMergeConflictsOutput::source_commit_id): <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    ///   - [`base_commit_id(Option<String>)`](crate::output::BatchDescribeMergeConflictsOutput::base_commit_id): <p>The commit ID of the merge base.</p>
    /// - On failure, responds with [`SdkError<BatchDescribeMergeConflictsError>`](crate::error::BatchDescribeMergeConflictsError)
    pub fn batch_describe_merge_conflicts(&self) -> fluent_builders::BatchDescribeMergeConflicts {
        fluent_builders::BatchDescribeMergeConflicts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDisassociateApprovalRuleTemplateFromRepositories`](crate::client::fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories::set_approval_rule_template_name): <p>The name of the template that you want to disassociate from one or more repositories.</p>
    ///   - [`repository_names(Vec<String>)`](crate::client::fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories::repository_names) / [`set_repository_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories::set_repository_names): <p>The repository names that you want to disassociate from the approval rule template.</p> <note>   <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>  </note>
    /// - On success, responds with [`BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput`](crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput) with field(s):
    ///   - [`disassociated_repository_names(Option<Vec<String>>)`](crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput::disassociated_repository_names): <p>A list of repository names that have had their association with the template removed.</p>
    ///   - [`errors(Option<Vec<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>>)`](crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput::errors): <p>A list of any errors that might have occurred while attempting to remove the association between the template and the repositories.</p>
    /// - On failure, responds with [`SdkError<BatchDisassociateApprovalRuleTemplateFromRepositoriesError>`](crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesError)
    pub fn batch_disassociate_approval_rule_template_from_repositories(
        &self,
    ) -> fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories {
        fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the [`BatchGetCommits`](crate::client::fluent_builders::BatchGetCommits) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`commit_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetCommits::commit_ids) / [`set_commit_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetCommits::set_commit_ids): <p>The full commit IDs of the commits to get information about.</p> <note>   <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p>  </note>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::BatchGetCommits::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::BatchGetCommits::set_repository_name): <p>The name of the repository that contains the commits.</p>
    /// - On success, responds with [`BatchGetCommitsOutput`](crate::output::BatchGetCommitsOutput) with field(s):
    ///   - [`commits(Option<Vec<Commit>>)`](crate::output::BatchGetCommitsOutput::commits): <p>An array of commit data type objects, each of which contains information about a specified commit.</p>
    ///   - [`errors(Option<Vec<BatchGetCommitsError>>)`](crate::output::BatchGetCommitsOutput::errors): <p>Returns any commit IDs for which information could not be found. For example, if one of the commit IDs was a shortened SHA ID or that commit was not found in the specified repository, the ID returns an error object with more information.</p>
    /// - On failure, responds with [`SdkError<BatchGetCommitsError>`](crate::error::BatchGetCommitsError)
    pub fn batch_get_commits(&self) -> fluent_builders::BatchGetCommits {
        fluent_builders::BatchGetCommits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetRepositories`](crate::client::fluent_builders::BatchGetRepositories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_names(Vec<String>)`](crate::client::fluent_builders::BatchGetRepositories::repository_names) / [`set_repository_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetRepositories::set_repository_names): <p>The names of the repositories to get information about.</p> <note>   <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>  </note>
    /// - On success, responds with [`BatchGetRepositoriesOutput`](crate::output::BatchGetRepositoriesOutput) with field(s):
    ///   - [`repositories(Option<Vec<RepositoryMetadata>>)`](crate::output::BatchGetRepositoriesOutput::repositories): <p>A list of repositories returned by the batch get repositories operation.</p>
    ///   - [`repositories_not_found(Option<Vec<String>>)`](crate::output::BatchGetRepositoriesOutput::repositories_not_found): <p>Returns a list of repository names for which information could not be found.</p>
    /// - On failure, responds with [`SdkError<BatchGetRepositoriesError>`](crate::error::BatchGetRepositoriesError)
    pub fn batch_get_repositories(&self) -> fluent_builders::BatchGetRepositories {
        fluent_builders::BatchGetRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateApprovalRuleTemplate`](crate::client::fluent_builders::CreateApprovalRuleTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::CreateApprovalRuleTemplate::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::CreateApprovalRuleTemplate::set_approval_rule_template_name): <p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>
    ///   - [`approval_rule_template_content(impl Into<String>)`](crate::client::fluent_builders::CreateApprovalRuleTemplate::approval_rule_template_content) / [`set_approval_rule_template_content(Option<String>)`](crate::client::fluent_builders::CreateApprovalRuleTemplate::set_approval_rule_template_content): <p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note>   <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p>   <ul>    <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>     <ul>      <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>      <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>     </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>    <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>   </ul>   <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>  </note>
    ///   - [`approval_rule_template_description(impl Into<String>)`](crate::client::fluent_builders::CreateApprovalRuleTemplate::approval_rule_template_description) / [`set_approval_rule_template_description(Option<String>)`](crate::client::fluent_builders::CreateApprovalRuleTemplate::set_approval_rule_template_description): <p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>
    /// - On success, responds with [`CreateApprovalRuleTemplateOutput`](crate::output::CreateApprovalRuleTemplateOutput) with field(s):
    ///   - [`approval_rule_template(Option<ApprovalRuleTemplate>)`](crate::output::CreateApprovalRuleTemplateOutput::approval_rule_template): <p>The content and structure of the created approval rule template.</p>
    /// - On failure, responds with [`SdkError<CreateApprovalRuleTemplateError>`](crate::error::CreateApprovalRuleTemplateError)
    pub fn create_approval_rule_template(&self) -> fluent_builders::CreateApprovalRuleTemplate {
        fluent_builders::CreateApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBranch`](crate::client::fluent_builders::CreateBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_repository_name): <p>The name of the repository in which you want to create the new branch.</p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_branch_name): <p>The name of the new branch to create.</p>
    ///   - [`commit_id(impl Into<String>)`](crate::client::fluent_builders::CreateBranch::commit_id) / [`set_commit_id(Option<String>)`](crate::client::fluent_builders::CreateBranch::set_commit_id): <p>The ID of the commit to point the new branch to.</p>
    /// - On success, responds with [`CreateBranchOutput`](crate::output::CreateBranchOutput)

    /// - On failure, responds with [`SdkError<CreateBranchError>`](crate::error::CreateBranchError)
    pub fn create_branch(&self) -> fluent_builders::CreateBranch {
        fluent_builders::CreateBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCommit`](crate::client::fluent_builders::CreateCommit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::CreateCommit::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::CreateCommit::set_repository_name): <p>The name of the repository where you create the commit.</p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::CreateCommit::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::CreateCommit::set_branch_name): <p>The name of the branch where you create the commit.</p>
    ///   - [`parent_commit_id(impl Into<String>)`](crate::client::fluent_builders::CreateCommit::parent_commit_id) / [`set_parent_commit_id(Option<String>)`](crate::client::fluent_builders::CreateCommit::set_parent_commit_id): <p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>
    ///   - [`author_name(impl Into<String>)`](crate::client::fluent_builders::CreateCommit::author_name) / [`set_author_name(Option<String>)`](crate::client::fluent_builders::CreateCommit::set_author_name): <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::CreateCommit::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::CreateCommit::set_email): <p>The email address of the person who created the commit.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::CreateCommit::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::CreateCommit::set_commit_message): <p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
    ///   - [`keep_empty_folders(bool)`](crate::client::fluent_builders::CreateCommit::keep_empty_folders) / [`set_keep_empty_folders(bool)`](crate::client::fluent_builders::CreateCommit::set_keep_empty_folders): <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>
    ///   - [`put_files(Vec<PutFileEntry>)`](crate::client::fluent_builders::CreateCommit::put_files) / [`set_put_files(Option<Vec<PutFileEntry>>)`](crate::client::fluent_builders::CreateCommit::set_put_files): <p>The files to add or update in this commit.</p>
    ///   - [`delete_files(Vec<DeleteFileEntry>)`](crate::client::fluent_builders::CreateCommit::delete_files) / [`set_delete_files(Option<Vec<DeleteFileEntry>>)`](crate::client::fluent_builders::CreateCommit::set_delete_files): <p>The files to delete in this commit. These files still exist in earlier commits.</p>
    ///   - [`set_file_modes(Vec<SetFileModeEntry>)`](crate::client::fluent_builders::CreateCommit::set_file_modes) / [`set_set_file_modes(Option<Vec<SetFileModeEntry>>)`](crate::client::fluent_builders::CreateCommit::set_set_file_modes): <p>The file modes to update for files in this commit.</p>
    /// - On success, responds with [`CreateCommitOutput`](crate::output::CreateCommitOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::CreateCommitOutput::commit_id): <p>The full commit ID of the commit that contains your committed file changes.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::CreateCommitOutput::tree_id): <p>The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.</p>
    ///   - [`files_added(Option<Vec<FileMetadata>>)`](crate::output::CreateCommitOutput::files_added): <p>The files added as part of the committed file changes.</p>
    ///   - [`files_updated(Option<Vec<FileMetadata>>)`](crate::output::CreateCommitOutput::files_updated): <p>The files updated as part of the commited file changes.</p>
    ///   - [`files_deleted(Option<Vec<FileMetadata>>)`](crate::output::CreateCommitOutput::files_deleted): <p>The files deleted as part of the committed file changes.</p>
    /// - On failure, responds with [`SdkError<CreateCommitError>`](crate::error::CreateCommitError)
    pub fn create_commit(&self) -> fluent_builders::CreateCommit {
        fluent_builders::CreateCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePullRequest`](crate::client::fluent_builders::CreatePullRequest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::CreatePullRequest::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::CreatePullRequest::set_title): <p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePullRequest::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePullRequest::set_description): <p>A description of the pull request.</p>
    ///   - [`targets(Vec<Target>)`](crate::client::fluent_builders::CreatePullRequest::targets) / [`set_targets(Option<Vec<Target>>)`](crate::client::fluent_builders::CreatePullRequest::set_targets): <p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreatePullRequest::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreatePullRequest::set_client_request_token): <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note>   <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>  </note>
    /// - On success, responds with [`CreatePullRequestOutput`](crate::output::CreatePullRequestOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::CreatePullRequestOutput::pull_request): <p>Information about the newly created pull request.</p>
    /// - On failure, responds with [`SdkError<CreatePullRequestError>`](crate::error::CreatePullRequestError)
    pub fn create_pull_request(&self) -> fluent_builders::CreatePullRequest {
        fluent_builders::CreatePullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePullRequestApprovalRule`](crate::client::fluent_builders::CreatePullRequestApprovalRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::CreatePullRequestApprovalRule::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::CreatePullRequestApprovalRule::set_pull_request_id): <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
    ///   - [`approval_rule_name(impl Into<String>)`](crate::client::fluent_builders::CreatePullRequestApprovalRule::approval_rule_name) / [`set_approval_rule_name(Option<String>)`](crate::client::fluent_builders::CreatePullRequestApprovalRule::set_approval_rule_name): <p>The name for the approval rule.</p>
    ///   - [`approval_rule_content(impl Into<String>)`](crate::client::fluent_builders::CreatePullRequestApprovalRule::approval_rule_content) / [`set_approval_rule_content(Option<String>)`](crate::client::fluent_builders::CreatePullRequestApprovalRule::set_approval_rule_content): <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note>   <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>   <ul>    <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p>     <ul>      <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>      <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>     </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>    <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>   </ul>   <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>  </note>
    /// - On success, responds with [`CreatePullRequestApprovalRuleOutput`](crate::output::CreatePullRequestApprovalRuleOutput) with field(s):
    ///   - [`approval_rule(Option<ApprovalRule>)`](crate::output::CreatePullRequestApprovalRuleOutput::approval_rule): <p>Information about the created approval rule.</p>
    /// - On failure, responds with [`SdkError<CreatePullRequestApprovalRuleError>`](crate::error::CreatePullRequestApprovalRuleError)
    pub fn create_pull_request_approval_rule(
        &self,
    ) -> fluent_builders::CreatePullRequestApprovalRule {
        fluent_builders::CreatePullRequestApprovalRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRepository`](crate::client::fluent_builders::CreateRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_repository_name): <p>The name of the new repository to be created.</p> <note>   <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p>  </note>
    ///   - [`repository_description(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::repository_description) / [`set_repository_description(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_repository_description): <p>A comment or description about the new repository.</p> <note>   <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>  </note>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRepository::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRepository::set_tags): <p>One or more tag key-value pairs to use when tagging this repository.</p>
    /// - On success, responds with [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput) with field(s):
    ///   - [`repository_metadata(Option<RepositoryMetadata>)`](crate::output::CreateRepositoryOutput::repository_metadata): <p>Information about the newly created repository.</p>
    /// - On failure, responds with [`SdkError<CreateRepositoryError>`](crate::error::CreateRepositoryError)
    pub fn create_repository(&self) -> fluent_builders::CreateRepository {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUnreferencedMergeCommit`](crate::client::fluent_builders::CreateUnreferencedMergeCommit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_repository_name): <p>The name of the repository where you want to create the unreferenced merge commit.</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`merge_option(MergeOptionTypeEnum)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::merge_option) / [`set_merge_option(Option<MergeOptionTypeEnum>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_merge_option): <p>The merge option or strategy you want to use to merge the code.</p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`author_name(impl Into<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::author_name) / [`set_author_name(Option<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_author_name): <p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_email): <p>The email address for the person who created the unreferenced commit.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_commit_message): <p>The commit message for the unreferenced commit.</p>
    ///   - [`keep_empty_folders(bool)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::keep_empty_folders) / [`set_keep_empty_folders(bool)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_keep_empty_folders): <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
    ///   - [`conflict_resolution(ConflictResolution)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::conflict_resolution) / [`set_conflict_resolution(Option<ConflictResolution>)`](crate::client::fluent_builders::CreateUnreferencedMergeCommit::set_conflict_resolution): <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    /// - On success, responds with [`CreateUnreferencedMergeCommitOutput`](crate::output::CreateUnreferencedMergeCommitOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::CreateUnreferencedMergeCommitOutput::commit_id): <p>The full commit ID of the commit that contains your merge results.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::CreateUnreferencedMergeCommitOutput::tree_id): <p>The full SHA-1 pointer of the tree information for the commit that contains the merge results.</p>
    /// - On failure, responds with [`SdkError<CreateUnreferencedMergeCommitError>`](crate::error::CreateUnreferencedMergeCommitError)
    pub fn create_unreferenced_merge_commit(
        &self,
    ) -> fluent_builders::CreateUnreferencedMergeCommit {
        fluent_builders::CreateUnreferencedMergeCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteApprovalRuleTemplate`](crate::client::fluent_builders::DeleteApprovalRuleTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::DeleteApprovalRuleTemplate::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::DeleteApprovalRuleTemplate::set_approval_rule_template_name): <p>The name of the approval rule template to delete.</p>
    /// - On success, responds with [`DeleteApprovalRuleTemplateOutput`](crate::output::DeleteApprovalRuleTemplateOutput) with field(s):
    ///   - [`approval_rule_template_id(Option<String>)`](crate::output::DeleteApprovalRuleTemplateOutput::approval_rule_template_id): <p>The system-generated ID of the deleted approval rule template. If the template has been previously deleted, the only response is a 200 OK.</p>
    /// - On failure, responds with [`SdkError<DeleteApprovalRuleTemplateError>`](crate::error::DeleteApprovalRuleTemplateError)
    pub fn delete_approval_rule_template(&self) -> fluent_builders::DeleteApprovalRuleTemplate {
        fluent_builders::DeleteApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBranch`](crate::client::fluent_builders::DeleteBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBranch::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DeleteBranch::set_repository_name): <p>The name of the repository that contains the branch to be deleted.</p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::DeleteBranch::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::DeleteBranch::set_branch_name): <p>The name of the branch to delete.</p>
    /// - On success, responds with [`DeleteBranchOutput`](crate::output::DeleteBranchOutput) with field(s):
    ///   - [`deleted_branch(Option<BranchInfo>)`](crate::output::DeleteBranchOutput::deleted_branch): <p>Information about the branch deleted by the operation, including the branch name and the commit ID that was the tip of the branch.</p>
    /// - On failure, responds with [`SdkError<DeleteBranchError>`](crate::error::DeleteBranchError)
    pub fn delete_branch(&self) -> fluent_builders::DeleteBranch {
        fluent_builders::DeleteBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCommentContent`](crate::client::fluent_builders::DeleteCommentContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`comment_id(impl Into<String>)`](crate::client::fluent_builders::DeleteCommentContent::comment_id) / [`set_comment_id(Option<String>)`](crate::client::fluent_builders::DeleteCommentContent::set_comment_id): <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    /// - On success, responds with [`DeleteCommentContentOutput`](crate::output::DeleteCommentContentOutput) with field(s):
    ///   - [`comment(Option<Comment>)`](crate::output::DeleteCommentContentOutput::comment): <p>Information about the comment you just deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteCommentContentError>`](crate::error::DeleteCommentContentError)
    pub fn delete_comment_content(&self) -> fluent_builders::DeleteCommentContent {
        fluent_builders::DeleteCommentContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFile`](crate::client::fluent_builders::DeleteFile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFile::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DeleteFile::set_repository_name): <p>The name of the repository that contains the file to delete.</p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::DeleteFile::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::DeleteFile::set_branch_name): <p>The name of the branch where the commit that deletes the file is made.</p>
    ///   - [`file_path(impl Into<String>)`](crate::client::fluent_builders::DeleteFile::file_path) / [`set_file_path(Option<String>)`](crate::client::fluent_builders::DeleteFile::set_file_path): <p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>
    ///   - [`parent_commit_id(impl Into<String>)`](crate::client::fluent_builders::DeleteFile::parent_commit_id) / [`set_parent_commit_id(Option<String>)`](crate::client::fluent_builders::DeleteFile::set_parent_commit_id): <p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>
    ///   - [`keep_empty_folders(bool)`](crate::client::fluent_builders::DeleteFile::keep_empty_folders) / [`set_keep_empty_folders(bool)`](crate::client::fluent_builders::DeleteFile::set_keep_empty_folders): <p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::DeleteFile::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::DeleteFile::set_commit_message): <p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteFile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteFile::set_name): <p>The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::DeleteFile::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::DeleteFile::set_email): <p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>
    /// - On success, responds with [`DeleteFileOutput`](crate::output::DeleteFileOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::DeleteFileOutput::commit_id): <p>The full commit ID of the commit that contains the change that deletes the file.</p>
    ///   - [`blob_id(Option<String>)`](crate::output::DeleteFileOutput::blob_id): <p>The blob ID removed from the tree as part of deleting the file.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::DeleteFileOutput::tree_id): <p>The full SHA-1 pointer of the tree information for the commit that contains the delete file change.</p>
    ///   - [`file_path(Option<String>)`](crate::output::DeleteFileOutput::file_path): <p>The fully qualified path to the file to be deleted, including the full name and extension of that file.</p>
    /// - On failure, responds with [`SdkError<DeleteFileError>`](crate::error::DeleteFileError)
    pub fn delete_file(&self) -> fluent_builders::DeleteFile {
        fluent_builders::DeleteFile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePullRequestApprovalRule`](crate::client::fluent_builders::DeletePullRequestApprovalRule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::DeletePullRequestApprovalRule::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::DeletePullRequestApprovalRule::set_pull_request_id): <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
    ///   - [`approval_rule_name(impl Into<String>)`](crate::client::fluent_builders::DeletePullRequestApprovalRule::approval_rule_name) / [`set_approval_rule_name(Option<String>)`](crate::client::fluent_builders::DeletePullRequestApprovalRule::set_approval_rule_name): <p>The name of the approval rule you want to delete.</p>
    /// - On success, responds with [`DeletePullRequestApprovalRuleOutput`](crate::output::DeletePullRequestApprovalRuleOutput) with field(s):
    ///   - [`approval_rule_id(Option<String>)`](crate::output::DeletePullRequestApprovalRuleOutput::approval_rule_id): <p>The ID of the deleted approval rule. </p> <note>   <p>If the approval rule was deleted in an earlier API call, the response is 200 OK without content.</p>  </note>
    /// - On failure, responds with [`SdkError<DeletePullRequestApprovalRuleError>`](crate::error::DeletePullRequestApprovalRuleError)
    pub fn delete_pull_request_approval_rule(
        &self,
    ) -> fluent_builders::DeletePullRequestApprovalRule {
        fluent_builders::DeletePullRequestApprovalRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DeleteRepository::set_repository_name): <p>The name of the repository to delete.</p>
    /// - On success, responds with [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput) with field(s):
    ///   - [`repository_id(Option<String>)`](crate::output::DeleteRepositoryOutput::repository_id): <p>The ID of the repository that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteRepositoryError>`](crate::error::DeleteRepositoryError)
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMergeConflicts`](crate::client::fluent_builders::DescribeMergeConflicts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMergeConflicts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_repository_name): <p>The name of the repository where you want to get information about a merge conflict.</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`merge_option(MergeOptionTypeEnum)`](crate::client::fluent_builders::DescribeMergeConflicts::merge_option) / [`set_merge_option(Option<MergeOptionTypeEnum>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_merge_option): <p>The merge option or strategy you want to use to merge the code.</p>
    ///   - [`max_merge_hunks(i32)`](crate::client::fluent_builders::DescribeMergeConflicts::max_merge_hunks) / [`set_max_merge_hunks(Option<i32>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_max_merge_hunks): <p>The maximum number of merge hunks to include in the output.</p>
    ///   - [`file_path(impl Into<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::file_path) / [`set_file_path(Option<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_file_path): <p>The path of the target files used to describe the conflicts. </p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::DescribeMergeConflicts::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::DescribeMergeConflicts::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMergeConflicts::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    /// - On success, responds with [`DescribeMergeConflictsOutput`](crate::output::DescribeMergeConflictsOutput) with field(s):
    ///   - [`conflict_metadata(Option<ConflictMetadata>)`](crate::output::DescribeMergeConflictsOutput::conflict_metadata): <p>Contains metadata about the conflicts found in the merge.</p>
    ///   - [`merge_hunks(Option<Vec<MergeHunk>>)`](crate::output::DescribeMergeConflictsOutput::merge_hunks): <p>A list of merge hunks of the differences between the files or lines.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMergeConflictsOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    ///   - [`destination_commit_id(Option<String>)`](crate::output::DescribeMergeConflictsOutput::destination_commit_id): <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    ///   - [`source_commit_id(Option<String>)`](crate::output::DescribeMergeConflictsOutput::source_commit_id): <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    ///   - [`base_commit_id(Option<String>)`](crate::output::DescribeMergeConflictsOutput::base_commit_id): <p>The commit ID of the merge base.</p>
    /// - On failure, responds with [`SdkError<DescribeMergeConflictsError>`](crate::error::DescribeMergeConflictsError)
    pub fn describe_merge_conflicts(&self) -> fluent_builders::DescribeMergeConflicts {
        fluent_builders::DescribeMergeConflicts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePullRequestEvents`](crate::client::fluent_builders::DescribePullRequestEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePullRequestEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribePullRequestEvents::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::DescribePullRequestEvents::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`pull_request_event_type(PullRequestEventType)`](crate::client::fluent_builders::DescribePullRequestEvents::pull_request_event_type) / [`set_pull_request_event_type(Option<PullRequestEventType>)`](crate::client::fluent_builders::DescribePullRequestEvents::set_pull_request_event_type): <p>Optional. The pull request event type about which you want to return information.</p>
    ///   - [`actor_arn(impl Into<String>)`](crate::client::fluent_builders::DescribePullRequestEvents::actor_arn) / [`set_actor_arn(Option<String>)`](crate::client::fluent_builders::DescribePullRequestEvents::set_actor_arn): <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribePullRequestEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribePullRequestEvents::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribePullRequestEvents::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribePullRequestEvents::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
    /// - On success, responds with [`DescribePullRequestEventsOutput`](crate::output::DescribePullRequestEventsOutput) with field(s):
    ///   - [`pull_request_events(Option<Vec<PullRequestEvent>>)`](crate::output::DescribePullRequestEventsOutput::pull_request_events): <p>Information about the pull request events.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribePullRequestEventsOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    /// - On failure, responds with [`SdkError<DescribePullRequestEventsError>`](crate::error::DescribePullRequestEventsError)
    pub fn describe_pull_request_events(&self) -> fluent_builders::DescribePullRequestEvents {
        fluent_builders::DescribePullRequestEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateApprovalRuleTemplateFromRepository`](crate::client::fluent_builders::DisassociateApprovalRuleTemplateFromRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateApprovalRuleTemplateFromRepository::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::DisassociateApprovalRuleTemplateFromRepository::set_approval_rule_template_name): <p>The name of the approval rule template to disassociate from a specified repository.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateApprovalRuleTemplateFromRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::DisassociateApprovalRuleTemplateFromRepository::set_repository_name): <p>The name of the repository you want to disassociate from the template.</p>
    /// - On success, responds with [`DisassociateApprovalRuleTemplateFromRepositoryOutput`](crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput)

    /// - On failure, responds with [`SdkError<DisassociateApprovalRuleTemplateFromRepositoryError>`](crate::error::DisassociateApprovalRuleTemplateFromRepositoryError)
    pub fn disassociate_approval_rule_template_from_repository(
        &self,
    ) -> fluent_builders::DisassociateApprovalRuleTemplateFromRepository {
        fluent_builders::DisassociateApprovalRuleTemplateFromRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EvaluatePullRequestApprovalRules`](crate::client::fluent_builders::EvaluatePullRequestApprovalRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::EvaluatePullRequestApprovalRules::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::EvaluatePullRequestApprovalRules::set_pull_request_id): <p>The system-generated ID of the pull request you want to evaluate.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::EvaluatePullRequestApprovalRules::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::EvaluatePullRequestApprovalRules::set_revision_id): <p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <code>GetPullRequest</code>.</p>
    /// - On success, responds with [`EvaluatePullRequestApprovalRulesOutput`](crate::output::EvaluatePullRequestApprovalRulesOutput) with field(s):
    ///   - [`evaluation(Option<Evaluation>)`](crate::output::EvaluatePullRequestApprovalRulesOutput::evaluation): <p>The result of the evaluation, including the names of the rules whose conditions have been met (if any), the names of the rules whose conditions have not been met (if any), whether the pull request is in the approved state, and whether the pull request approval rule has been set aside by an override. </p>
    /// - On failure, responds with [`SdkError<EvaluatePullRequestApprovalRulesError>`](crate::error::EvaluatePullRequestApprovalRulesError)
    pub fn evaluate_pull_request_approval_rules(
        &self,
    ) -> fluent_builders::EvaluatePullRequestApprovalRules {
        fluent_builders::EvaluatePullRequestApprovalRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetApprovalRuleTemplate`](crate::client::fluent_builders::GetApprovalRuleTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::GetApprovalRuleTemplate::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::GetApprovalRuleTemplate::set_approval_rule_template_name): <p>The name of the approval rule template for which you want to get information.</p>
    /// - On success, responds with [`GetApprovalRuleTemplateOutput`](crate::output::GetApprovalRuleTemplateOutput) with field(s):
    ///   - [`approval_rule_template(Option<ApprovalRuleTemplate>)`](crate::output::GetApprovalRuleTemplateOutput::approval_rule_template): <p>The content and structure of the approval rule template.</p>
    /// - On failure, responds with [`SdkError<GetApprovalRuleTemplateError>`](crate::error::GetApprovalRuleTemplateError)
    pub fn get_approval_rule_template(&self) -> fluent_builders::GetApprovalRuleTemplate {
        fluent_builders::GetApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBlob`](crate::client::fluent_builders::GetBlob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetBlob::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetBlob::set_repository_name): <p>The name of the repository that contains the blob.</p>
    ///   - [`blob_id(impl Into<String>)`](crate::client::fluent_builders::GetBlob::blob_id) / [`set_blob_id(Option<String>)`](crate::client::fluent_builders::GetBlob::set_blob_id): <p>The ID of the blob, which is its SHA-1 pointer.</p>
    /// - On success, responds with [`GetBlobOutput`](crate::output::GetBlobOutput) with field(s):
    ///   - [`content(Option<Blob>)`](crate::output::GetBlobOutput::content): <p>The content of the blob, usually a file.</p>
    /// - On failure, responds with [`SdkError<GetBlobError>`](crate::error::GetBlobError)
    pub fn get_blob(&self) -> fluent_builders::GetBlob {
        fluent_builders::GetBlob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBranch`](crate::client::fluent_builders::GetBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetBranch::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetBranch::set_repository_name): <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::GetBranch::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::GetBranch::set_branch_name): <p>The name of the branch for which you want to retrieve information.</p>
    /// - On success, responds with [`GetBranchOutput`](crate::output::GetBranchOutput) with field(s):
    ///   - [`branch(Option<BranchInfo>)`](crate::output::GetBranchOutput::branch): <p>The name of the branch.</p>
    /// - On failure, responds with [`SdkError<GetBranchError>`](crate::error::GetBranchError)
    pub fn get_branch(&self) -> fluent_builders::GetBranch {
        fluent_builders::GetBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetComment`](crate::client::fluent_builders::GetComment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`comment_id(impl Into<String>)`](crate::client::fluent_builders::GetComment::comment_id) / [`set_comment_id(Option<String>)`](crate::client::fluent_builders::GetComment::set_comment_id): <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    /// - On success, responds with [`GetCommentOutput`](crate::output::GetCommentOutput) with field(s):
    ///   - [`comment(Option<Comment>)`](crate::output::GetCommentOutput::comment): <p>The contents of the comment.</p>
    /// - On failure, responds with [`SdkError<GetCommentError>`](crate::error::GetCommentError)
    pub fn get_comment(&self) -> fluent_builders::GetComment {
        fluent_builders::GetComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCommentReactions`](crate::client::fluent_builders::GetCommentReactions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCommentReactions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`comment_id(impl Into<String>)`](crate::client::fluent_builders::GetCommentReactions::comment_id) / [`set_comment_id(Option<String>)`](crate::client::fluent_builders::GetCommentReactions::set_comment_id): <p>The ID of the comment for which you want to get reactions information.</p>
    ///   - [`reaction_user_arn(impl Into<String>)`](crate::client::fluent_builders::GetCommentReactions::reaction_user_arn) / [`set_reaction_user_arn(Option<String>)`](crate::client::fluent_builders::GetCommentReactions::set_reaction_user_arn): <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCommentReactions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCommentReactions::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCommentReactions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetCommentReactions::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>
    /// - On success, responds with [`GetCommentReactionsOutput`](crate::output::GetCommentReactionsOutput) with field(s):
    ///   - [`reactions_for_comment(Option<Vec<ReactionForComment>>)`](crate::output::GetCommentReactionsOutput::reactions_for_comment): <p>An array of reactions to the specified comment.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetCommentReactionsOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    /// - On failure, responds with [`SdkError<GetCommentReactionsError>`](crate::error::GetCommentReactionsError)
    pub fn get_comment_reactions(&self) -> fluent_builders::GetCommentReactions {
        fluent_builders::GetCommentReactions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCommentsForComparedCommit`](crate::client::fluent_builders::GetCommentsForComparedCommit) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCommentsForComparedCommit::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::set_repository_name): <p>The name of the repository where you want to compare commits.</p>
    ///   - [`before_commit_id(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::before_commit_id) / [`set_before_commit_id(Option<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::set_before_commit_id): <p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>
    ///   - [`after_commit_id(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::after_commit_id) / [`set_after_commit_id(Option<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::set_after_commit_id): <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::set_next_token): <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCommentsForComparedCommit::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetCommentsForComparedCommit::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>
    /// - On success, responds with [`GetCommentsForComparedCommitOutput`](crate::output::GetCommentsForComparedCommitOutput) with field(s):
    ///   - [`comments_for_compared_commit_data(Option<Vec<CommentsForComparedCommit>>)`](crate::output::GetCommentsForComparedCommitOutput::comments_for_compared_commit_data): <p>A list of comment objects on the compared commit.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetCommentsForComparedCommitOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    /// - On failure, responds with [`SdkError<GetCommentsForComparedCommitError>`](crate::error::GetCommentsForComparedCommitError)
    pub fn get_comments_for_compared_commit(
        &self,
    ) -> fluent_builders::GetCommentsForComparedCommit {
        fluent_builders::GetCommentsForComparedCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCommentsForPullRequest`](crate::client::fluent_builders::GetCommentsForPullRequest) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCommentsForPullRequest::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::set_repository_name): <p>The name of the repository that contains the pull request.</p>
    ///   - [`before_commit_id(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::before_commit_id) / [`set_before_commit_id(Option<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::set_before_commit_id): <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
    ///   - [`after_commit_id(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::after_commit_id) / [`set_after_commit_id(Option<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::set_after_commit_id): <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCommentsForPullRequest::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCommentsForPullRequest::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetCommentsForPullRequest::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>
    /// - On success, responds with [`GetCommentsForPullRequestOutput`](crate::output::GetCommentsForPullRequestOutput) with field(s):
    ///   - [`comments_for_pull_request_data(Option<Vec<CommentsForPullRequest>>)`](crate::output::GetCommentsForPullRequestOutput::comments_for_pull_request_data): <p>An array of comment objects on the pull request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetCommentsForPullRequestOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    /// - On failure, responds with [`SdkError<GetCommentsForPullRequestError>`](crate::error::GetCommentsForPullRequestError)
    pub fn get_comments_for_pull_request(&self) -> fluent_builders::GetCommentsForPullRequest {
        fluent_builders::GetCommentsForPullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCommit`](crate::client::fluent_builders::GetCommit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetCommit::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetCommit::set_repository_name): <p>The name of the repository to which the commit was made.</p>
    ///   - [`commit_id(impl Into<String>)`](crate::client::fluent_builders::GetCommit::commit_id) / [`set_commit_id(Option<String>)`](crate::client::fluent_builders::GetCommit::set_commit_id): <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
    /// - On success, responds with [`GetCommitOutput`](crate::output::GetCommitOutput) with field(s):
    ///   - [`commit(Option<Commit>)`](crate::output::GetCommitOutput::commit): <p>A commit data type object that contains information about the specified commit.</p>
    /// - On failure, responds with [`SdkError<GetCommitError>`](crate::error::GetCommitError)
    pub fn get_commit(&self) -> fluent_builders::GetCommit {
        fluent_builders::GetCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDifferences`](crate::client::fluent_builders::GetDifferences) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDifferences::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetDifferences::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetDifferences::set_repository_name): <p>The name of the repository where you want to get differences.</p>
    ///   - [`before_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetDifferences::before_commit_specifier) / [`set_before_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetDifferences::set_before_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>
    ///   - [`after_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetDifferences::after_commit_specifier) / [`set_after_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetDifferences::set_after_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
    ///   - [`before_path(impl Into<String>)`](crate::client::fluent_builders::GetDifferences::before_path) / [`set_before_path(Option<String>)`](crate::client::fluent_builders::GetDifferences::set_before_path): <p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>
    ///   - [`after_path(impl Into<String>)`](crate::client::fluent_builders::GetDifferences::after_path) / [`set_after_path(Option<String>)`](crate::client::fluent_builders::GetDifferences::set_after_path): <p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDifferences::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetDifferences::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDifferences::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDifferences::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    /// - On success, responds with [`GetDifferencesOutput`](crate::output::GetDifferencesOutput) with field(s):
    ///   - [`differences(Option<Vec<Difference>>)`](crate::output::GetDifferencesOutput::differences): <p>A data type object that contains information about the differences, including whether the difference is added, modified, or deleted (A, D, M).</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDifferencesOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    /// - On failure, responds with [`SdkError<GetDifferencesError>`](crate::error::GetDifferencesError)
    pub fn get_differences(&self) -> fluent_builders::GetDifferences {
        fluent_builders::GetDifferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFile`](crate::client::fluent_builders::GetFile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetFile::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetFile::set_repository_name): <p>The name of the repository that contains the file.</p>
    ///   - [`commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetFile::commit_specifier) / [`set_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetFile::set_commit_specifier): <p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>
    ///   - [`file_path(impl Into<String>)`](crate::client::fluent_builders::GetFile::file_path) / [`set_file_path(Option<String>)`](crate::client::fluent_builders::GetFile::set_file_path): <p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>
    /// - On success, responds with [`GetFileOutput`](crate::output::GetFileOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::GetFileOutput::commit_id): <p>The full commit ID of the commit that contains the content returned by GetFile.</p>
    ///   - [`blob_id(Option<String>)`](crate::output::GetFileOutput::blob_id): <p>The blob ID of the object that represents the file content.</p>
    ///   - [`file_path(Option<String>)`](crate::output::GetFileOutput::file_path): <p>The fully qualified path to the specified file. Returns the name and extension of the file.</p>
    ///   - [`file_mode(Option<FileModeTypeEnum>)`](crate::output::GetFileOutput::file_mode): <p>The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.</p> <note>   <p>The file mode permissions returned by this API are not the standard file mode permission values, such as 100644, but rather extrapolated values. See the supported return values.</p>  </note>
    ///   - [`file_size(i64)`](crate::output::GetFileOutput::file_size): <p>The size of the contents of the file, in bytes.</p>
    ///   - [`file_content(Option<Blob>)`](crate::output::GetFileOutput::file_content): <p>The base-64 encoded binary data object that represents the content of the file.</p>
    /// - On failure, responds with [`SdkError<GetFileError>`](crate::error::GetFileError)
    pub fn get_file(&self) -> fluent_builders::GetFile {
        fluent_builders::GetFile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFolder`](crate::client::fluent_builders::GetFolder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetFolder::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetFolder::set_repository_name): <p>The name of the repository.</p>
    ///   - [`commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetFolder::commit_specifier) / [`set_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetFolder::set_commit_specifier): <p>A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>
    ///   - [`folder_path(impl Into<String>)`](crate::client::fluent_builders::GetFolder::folder_path) / [`set_folder_path(Option<String>)`](crate::client::fluent_builders::GetFolder::set_folder_path): <p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>
    /// - On success, responds with [`GetFolderOutput`](crate::output::GetFolderOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::GetFolderOutput::commit_id): <p>The full commit ID used as a reference for the returned version of the folder content.</p>
    ///   - [`folder_path(Option<String>)`](crate::output::GetFolderOutput::folder_path): <p>The fully qualified path of the folder whose contents are returned.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::GetFolderOutput::tree_id): <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
    ///   - [`sub_folders(Option<Vec<Folder>>)`](crate::output::GetFolderOutput::sub_folders): <p>The list of folders that exist under the specified folder, if any.</p>
    ///   - [`files(Option<Vec<File>>)`](crate::output::GetFolderOutput::files): <p>The list of files in the specified folder, if any.</p>
    ///   - [`symbolic_links(Option<Vec<SymbolicLink>>)`](crate::output::GetFolderOutput::symbolic_links): <p>The list of symbolic links to other files and folders in the specified folder, if any.</p>
    ///   - [`sub_modules(Option<Vec<SubModule>>)`](crate::output::GetFolderOutput::sub_modules): <p>The list of submodules in the specified folder, if any.</p>
    /// - On failure, responds with [`SdkError<GetFolderError>`](crate::error::GetFolderError)
    pub fn get_folder(&self) -> fluent_builders::GetFolder {
        fluent_builders::GetFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMergeCommit`](crate::client::fluent_builders::GetMergeCommit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetMergeCommit::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetMergeCommit::set_repository_name): <p>The name of the repository that contains the merge commit about which you want to get information.</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetMergeCommit::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetMergeCommit::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetMergeCommit::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetMergeCommit::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::GetMergeCommit::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::GetMergeCommit::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::GetMergeCommit::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::GetMergeCommit::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    /// - On success, responds with [`GetMergeCommitOutput`](crate::output::GetMergeCommitOutput) with field(s):
    ///   - [`source_commit_id(Option<String>)`](crate::output::GetMergeCommitOutput::source_commit_id): <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    ///   - [`destination_commit_id(Option<String>)`](crate::output::GetMergeCommitOutput::destination_commit_id): <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    ///   - [`base_commit_id(Option<String>)`](crate::output::GetMergeCommitOutput::base_commit_id): <p>The commit ID of the merge base.</p>
    ///   - [`merged_commit_id(Option<String>)`](crate::output::GetMergeCommitOutput::merged_commit_id): <p>The commit ID for the merge commit created when the source branch was merged into the destination branch. If the fast-forward merge strategy was used, there is no merge commit.</p>
    /// - On failure, responds with [`SdkError<GetMergeCommitError>`](crate::error::GetMergeCommitError)
    pub fn get_merge_commit(&self) -> fluent_builders::GetMergeCommit {
        fluent_builders::GetMergeCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMergeConflicts`](crate::client::fluent_builders::GetMergeConflicts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetMergeConflicts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetMergeConflicts::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetMergeConflicts::set_repository_name): <p>The name of the repository where the pull request was created.</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetMergeConflicts::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetMergeConflicts::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetMergeConflicts::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetMergeConflicts::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`merge_option(MergeOptionTypeEnum)`](crate::client::fluent_builders::GetMergeConflicts::merge_option) / [`set_merge_option(Option<MergeOptionTypeEnum>)`](crate::client::fluent_builders::GetMergeConflicts::set_merge_option): <p>The merge option or strategy you want to use to merge the code. </p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::GetMergeConflicts::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::GetMergeConflicts::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`max_conflict_files(i32)`](crate::client::fluent_builders::GetMergeConflicts::max_conflict_files) / [`set_max_conflict_files(Option<i32>)`](crate::client::fluent_builders::GetMergeConflicts::set_max_conflict_files): <p>The maximum number of files to include in the output.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::GetMergeConflicts::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::GetMergeConflicts::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetMergeConflicts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetMergeConflicts::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    /// - On success, responds with [`GetMergeConflictsOutput`](crate::output::GetMergeConflictsOutput) with field(s):
    ///   - [`mergeable(bool)`](crate::output::GetMergeConflictsOutput::mergeable): <p>A Boolean value that indicates whether the code is mergeable by the specified merge option.</p>
    ///   - [`destination_commit_id(Option<String>)`](crate::output::GetMergeConflictsOutput::destination_commit_id): <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    ///   - [`source_commit_id(Option<String>)`](crate::output::GetMergeConflictsOutput::source_commit_id): <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    ///   - [`base_commit_id(Option<String>)`](crate::output::GetMergeConflictsOutput::base_commit_id): <p>The commit ID of the merge base.</p>
    ///   - [`conflict_metadata_list(Option<Vec<ConflictMetadata>>)`](crate::output::GetMergeConflictsOutput::conflict_metadata_list): <p>A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this list is always empty.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetMergeConflictsOutput::next_token): <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    /// - On failure, responds with [`SdkError<GetMergeConflictsError>`](crate::error::GetMergeConflictsError)
    pub fn get_merge_conflicts(&self) -> fluent_builders::GetMergeConflicts {
        fluent_builders::GetMergeConflicts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMergeOptions`](crate::client::fluent_builders::GetMergeOptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetMergeOptions::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetMergeOptions::set_repository_name): <p>The name of the repository that contains the commits about which you want to get merge options.</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetMergeOptions::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetMergeOptions::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::GetMergeOptions::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::GetMergeOptions::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::GetMergeOptions::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::GetMergeOptions::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::GetMergeOptions::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::GetMergeOptions::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    /// - On success, responds with [`GetMergeOptionsOutput`](crate::output::GetMergeOptionsOutput) with field(s):
    ///   - [`merge_options(Option<Vec<MergeOptionTypeEnum>>)`](crate::output::GetMergeOptionsOutput::merge_options): <p>The merge option or strategy used to merge the code.</p>
    ///   - [`source_commit_id(Option<String>)`](crate::output::GetMergeOptionsOutput::source_commit_id): <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    ///   - [`destination_commit_id(Option<String>)`](crate::output::GetMergeOptionsOutput::destination_commit_id): <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    ///   - [`base_commit_id(Option<String>)`](crate::output::GetMergeOptionsOutput::base_commit_id): <p>The commit ID of the merge base.</p>
    /// - On failure, responds with [`SdkError<GetMergeOptionsError>`](crate::error::GetMergeOptionsError)
    pub fn get_merge_options(&self) -> fluent_builders::GetMergeOptions {
        fluent_builders::GetMergeOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPullRequest`](crate::client::fluent_builders::GetPullRequest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::GetPullRequest::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::GetPullRequest::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    /// - On success, responds with [`GetPullRequestOutput`](crate::output::GetPullRequestOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::GetPullRequestOutput::pull_request): <p>Information about the specified pull request.</p>
    /// - On failure, responds with [`SdkError<GetPullRequestError>`](crate::error::GetPullRequestError)
    pub fn get_pull_request(&self) -> fluent_builders::GetPullRequest {
        fluent_builders::GetPullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPullRequestApprovalStates`](crate::client::fluent_builders::GetPullRequestApprovalStates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::GetPullRequestApprovalStates::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::GetPullRequestApprovalStates::set_pull_request_id): <p>The system-generated ID for the pull request.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::GetPullRequestApprovalStates::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::GetPullRequestApprovalStates::set_revision_id): <p>The system-generated ID for the pull request revision.</p>
    /// - On success, responds with [`GetPullRequestApprovalStatesOutput`](crate::output::GetPullRequestApprovalStatesOutput) with field(s):
    ///   - [`approvals(Option<Vec<Approval>>)`](crate::output::GetPullRequestApprovalStatesOutput::approvals): <p>Information about users who have approved the pull request.</p>
    /// - On failure, responds with [`SdkError<GetPullRequestApprovalStatesError>`](crate::error::GetPullRequestApprovalStatesError)
    pub fn get_pull_request_approval_states(
        &self,
    ) -> fluent_builders::GetPullRequestApprovalStates {
        fluent_builders::GetPullRequestApprovalStates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPullRequestOverrideState`](crate::client::fluent_builders::GetPullRequestOverrideState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::GetPullRequestOverrideState::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::GetPullRequestOverrideState::set_pull_request_id): <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::GetPullRequestOverrideState::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::GetPullRequestOverrideState::set_revision_id): <p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <code>GetPullRequest</code>.</p>
    /// - On success, responds with [`GetPullRequestOverrideStateOutput`](crate::output::GetPullRequestOverrideStateOutput) with field(s):
    ///   - [`overridden(bool)`](crate::output::GetPullRequestOverrideStateOutput::overridden): <p>A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all approval rules still apply (FALSE).</p>
    ///   - [`overrider(Option<String>)`](crate::output::GetPullRequestOverrideStateOutput::overrider): <p>The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>
    /// - On failure, responds with [`SdkError<GetPullRequestOverrideStateError>`](crate::error::GetPullRequestOverrideStateError)
    pub fn get_pull_request_override_state(&self) -> fluent_builders::GetPullRequestOverrideState {
        fluent_builders::GetPullRequestOverrideState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRepository`](crate::client::fluent_builders::GetRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetRepository::set_repository_name): <p>The name of the repository to get information about.</p>
    /// - On success, responds with [`GetRepositoryOutput`](crate::output::GetRepositoryOutput) with field(s):
    ///   - [`repository_metadata(Option<RepositoryMetadata>)`](crate::output::GetRepositoryOutput::repository_metadata): <p>Information about the repository.</p>
    /// - On failure, responds with [`SdkError<GetRepositoryError>`](crate::error::GetRepositoryError)
    pub fn get_repository(&self) -> fluent_builders::GetRepository {
        fluent_builders::GetRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRepositoryTriggers`](crate::client::fluent_builders::GetRepositoryTriggers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryTriggers::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::GetRepositoryTriggers::set_repository_name): <p>The name of the repository for which the trigger is configured.</p>
    /// - On success, responds with [`GetRepositoryTriggersOutput`](crate::output::GetRepositoryTriggersOutput) with field(s):
    ///   - [`configuration_id(Option<String>)`](crate::output::GetRepositoryTriggersOutput::configuration_id): <p>The system-generated unique ID for the trigger.</p>
    ///   - [`triggers(Option<Vec<RepositoryTrigger>>)`](crate::output::GetRepositoryTriggersOutput::triggers): <p>The JSON block of configuration information for each trigger.</p>
    /// - On failure, responds with [`SdkError<GetRepositoryTriggersError>`](crate::error::GetRepositoryTriggersError)
    pub fn get_repository_triggers(&self) -> fluent_builders::GetRepositoryTriggers {
        fluent_builders::GetRepositoryTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApprovalRuleTemplates`](crate::client::fluent_builders::ListApprovalRuleTemplates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApprovalRuleTemplates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApprovalRuleTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApprovalRuleTemplates::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApprovalRuleTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApprovalRuleTemplates::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    /// - On success, responds with [`ListApprovalRuleTemplatesOutput`](crate::output::ListApprovalRuleTemplatesOutput) with field(s):
    ///   - [`approval_rule_template_names(Option<Vec<String>>)`](crate::output::ListApprovalRuleTemplatesOutput::approval_rule_template_names): <p>The names of all the approval rule templates found in the AWS Region for your AWS account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApprovalRuleTemplatesOutput::next_token): <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    /// - On failure, responds with [`SdkError<ListApprovalRuleTemplatesError>`](crate::error::ListApprovalRuleTemplatesError)
    pub fn list_approval_rule_templates(&self) -> fluent_builders::ListApprovalRuleTemplates {
        fluent_builders::ListApprovalRuleTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociatedApprovalRuleTemplatesForRepository`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::set_repository_name): <p>The name of the repository for which you want to list all associated approval rule templates.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    /// - On success, responds with [`ListAssociatedApprovalRuleTemplatesForRepositoryOutput`](crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput) with field(s):
    ///   - [`approval_rule_template_names(Option<Vec<String>>)`](crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput::approval_rule_template_names): <p>The names of all approval rule templates associated with the repository.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput::next_token): <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    /// - On failure, responds with [`SdkError<ListAssociatedApprovalRuleTemplatesForRepositoryError>`](crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryError)
    pub fn list_associated_approval_rule_templates_for_repository(
        &self,
    ) -> fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository {
        fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBranches`](crate::client::fluent_builders::ListBranches) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBranches::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::ListBranches::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::ListBranches::set_repository_name): <p>The name of the repository that contains the branches.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBranches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBranches::set_next_token): <p>An enumeration token that allows the operation to batch the results.</p>
    /// - On success, responds with [`ListBranchesOutput`](crate::output::ListBranchesOutput) with field(s):
    ///   - [`branches(Option<Vec<String>>)`](crate::output::ListBranchesOutput::branches): <p>The list of branch names.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBranchesOutput::next_token): <p>An enumeration token that returns the batch of the results.</p>
    /// - On failure, responds with [`SdkError<ListBranchesError>`](crate::error::ListBranchesError)
    pub fn list_branches(&self) -> fluent_builders::ListBranches {
        fluent_builders::ListBranches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPullRequests`](crate::client::fluent_builders::ListPullRequests) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPullRequests::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::ListPullRequests::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::ListPullRequests::set_repository_name): <p>The name of the repository for which you want to list pull requests.</p>
    ///   - [`author_arn(impl Into<String>)`](crate::client::fluent_builders::ListPullRequests::author_arn) / [`set_author_arn(Option<String>)`](crate::client::fluent_builders::ListPullRequests::set_author_arn): <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>
    ///   - [`pull_request_status(PullRequestStatusEnum)`](crate::client::fluent_builders::ListPullRequests::pull_request_status) / [`set_pull_request_status(Option<PullRequestStatusEnum>)`](crate::client::fluent_builders::ListPullRequests::set_pull_request_status): <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPullRequests::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPullRequests::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPullRequests::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPullRequests::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    /// - On success, responds with [`ListPullRequestsOutput`](crate::output::ListPullRequestsOutput) with field(s):
    ///   - [`pull_request_ids(Option<Vec<String>>)`](crate::output::ListPullRequestsOutput::pull_request_ids): <p>The system-generated IDs of the pull requests.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPullRequestsOutput::next_token): <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    /// - On failure, responds with [`SdkError<ListPullRequestsError>`](crate::error::ListPullRequestsError)
    pub fn list_pull_requests(&self) -> fluent_builders::ListPullRequests {
        fluent_builders::ListPullRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRepositories`](crate::client::fluent_builders::ListRepositories) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRepositories::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRepositories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRepositories::set_next_token): <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
    ///   - [`sort_by(SortByEnum)`](crate::client::fluent_builders::ListRepositories::sort_by) / [`set_sort_by(Option<SortByEnum>)`](crate::client::fluent_builders::ListRepositories::set_sort_by): <p>The criteria used to sort the results of a list repositories operation.</p>
    ///   - [`order(OrderEnum)`](crate::client::fluent_builders::ListRepositories::order) / [`set_order(Option<OrderEnum>)`](crate::client::fluent_builders::ListRepositories::set_order): <p>The order in which to sort the results of a list repositories operation.</p>
    /// - On success, responds with [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput) with field(s):
    ///   - [`repositories(Option<Vec<RepositoryNameIdPair>>)`](crate::output::ListRepositoriesOutput::repositories): <p>Lists the repositories called by the list repositories operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRepositoriesOutput::next_token): <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
    /// - On failure, responds with [`SdkError<ListRepositoriesError>`](crate::error::ListRepositoriesError)
    pub fn list_repositories(&self) -> fluent_builders::ListRepositories {
        fluent_builders::ListRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRepositoriesForApprovalRuleTemplate`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate::set_approval_rule_template_name): <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate::set_max_results): <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    /// - On success, responds with [`ListRepositoriesForApprovalRuleTemplateOutput`](crate::output::ListRepositoriesForApprovalRuleTemplateOutput) with field(s):
    ///   - [`repository_names(Option<Vec<String>>)`](crate::output::ListRepositoriesForApprovalRuleTemplateOutput::repository_names): <p>A list of repository names that are associated with the specified approval rule template.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRepositoriesForApprovalRuleTemplateOutput::next_token): <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    /// - On failure, responds with [`SdkError<ListRepositoriesForApprovalRuleTemplateError>`](crate::error::ListRepositoriesForApprovalRuleTemplateError)
    pub fn list_repositories_for_approval_rule_template(
        &self,
    ) -> fluent_builders::ListRepositoriesForApprovalRuleTemplate {
        fluent_builders::ListRepositoriesForApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_next_token): <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tag key and value pairs associated with the specified resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTagsForResourceOutput::next_token): <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergeBranchesByFastForward`](crate::client::fluent_builders::MergeBranchesByFastForward) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::set_repository_name): <p>The name of the repository where you want to merge two branches.</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`target_branch(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::target_branch) / [`set_target_branch(Option<String>)`](crate::client::fluent_builders::MergeBranchesByFastForward::set_target_branch): <p>The branch where the merge is applied.</p>
    /// - On success, responds with [`MergeBranchesByFastForwardOutput`](crate::output::MergeBranchesByFastForwardOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::MergeBranchesByFastForwardOutput::commit_id): <p>The commit ID of the merge in the destination or target branch.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::MergeBranchesByFastForwardOutput::tree_id): <p>The tree ID of the merge in the destination or target branch.</p>
    /// - On failure, responds with [`SdkError<MergeBranchesByFastForwardError>`](crate::error::MergeBranchesByFastForwardError)
    pub fn merge_branches_by_fast_forward(&self) -> fluent_builders::MergeBranchesByFastForward {
        fluent_builders::MergeBranchesByFastForward::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergeBranchesBySquash`](crate::client::fluent_builders::MergeBranchesBySquash) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_repository_name): <p>The name of the repository where you want to merge two branches.</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`target_branch(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::target_branch) / [`set_target_branch(Option<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_target_branch): <p>The branch where the merge is applied. </p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::MergeBranchesBySquash::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::MergeBranchesBySquash::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`author_name(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::author_name) / [`set_author_name(Option<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_author_name): <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_email): <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_commit_message): <p>The commit message for the merge.</p>
    ///   - [`keep_empty_folders(bool)`](crate::client::fluent_builders::MergeBranchesBySquash::keep_empty_folders) / [`set_keep_empty_folders(bool)`](crate::client::fluent_builders::MergeBranchesBySquash::set_keep_empty_folders): <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
    ///   - [`conflict_resolution(ConflictResolution)`](crate::client::fluent_builders::MergeBranchesBySquash::conflict_resolution) / [`set_conflict_resolution(Option<ConflictResolution>)`](crate::client::fluent_builders::MergeBranchesBySquash::set_conflict_resolution): <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    /// - On success, responds with [`MergeBranchesBySquashOutput`](crate::output::MergeBranchesBySquashOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::MergeBranchesBySquashOutput::commit_id): <p>The commit ID of the merge in the destination or target branch.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::MergeBranchesBySquashOutput::tree_id): <p>The tree ID of the merge in the destination or target branch.</p>
    /// - On failure, responds with [`SdkError<MergeBranchesBySquashError>`](crate::error::MergeBranchesBySquashError)
    pub fn merge_branches_by_squash(&self) -> fluent_builders::MergeBranchesBySquash {
        fluent_builders::MergeBranchesBySquash::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergeBranchesByThreeWay`](crate::client::fluent_builders::MergeBranchesByThreeWay) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_repository_name): <p>The name of the repository where you want to merge two branches.</p>
    ///   - [`source_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::source_commit_specifier) / [`set_source_commit_specifier(Option<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_source_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`destination_commit_specifier(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::destination_commit_specifier) / [`set_destination_commit_specifier(Option<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_destination_commit_specifier): <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    ///   - [`target_branch(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::target_branch) / [`set_target_branch(Option<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_target_branch): <p>The branch where the merge is applied. </p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::MergeBranchesByThreeWay::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::MergeBranchesByThreeWay::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`author_name(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::author_name) / [`set_author_name(Option<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_author_name): <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_email): <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_commit_message): <p>The commit message to include in the commit information for the merge.</p>
    ///   - [`keep_empty_folders(bool)`](crate::client::fluent_builders::MergeBranchesByThreeWay::keep_empty_folders) / [`set_keep_empty_folders(bool)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_keep_empty_folders): <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    ///   - [`conflict_resolution(ConflictResolution)`](crate::client::fluent_builders::MergeBranchesByThreeWay::conflict_resolution) / [`set_conflict_resolution(Option<ConflictResolution>)`](crate::client::fluent_builders::MergeBranchesByThreeWay::set_conflict_resolution): <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    /// - On success, responds with [`MergeBranchesByThreeWayOutput`](crate::output::MergeBranchesByThreeWayOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::MergeBranchesByThreeWayOutput::commit_id): <p>The commit ID of the merge in the destination or target branch.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::MergeBranchesByThreeWayOutput::tree_id): <p>The tree ID of the merge in the destination or target branch.</p>
    /// - On failure, responds with [`SdkError<MergeBranchesByThreeWayError>`](crate::error::MergeBranchesByThreeWayError)
    pub fn merge_branches_by_three_way(&self) -> fluent_builders::MergeBranchesByThreeWay {
        fluent_builders::MergeBranchesByThreeWay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergePullRequestByFastForward`](crate::client::fluent_builders::MergePullRequestByFastForward) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByFastForward::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::MergePullRequestByFastForward::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByFastForward::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::MergePullRequestByFastForward::set_repository_name): <p>The name of the repository where the pull request was created.</p>
    ///   - [`source_commit_id(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByFastForward::source_commit_id) / [`set_source_commit_id(Option<String>)`](crate::client::fluent_builders::MergePullRequestByFastForward::set_source_commit_id): <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    /// - On success, responds with [`MergePullRequestByFastForwardOutput`](crate::output::MergePullRequestByFastForwardOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::MergePullRequestByFastForwardOutput::pull_request): <p>Information about the specified pull request, including the merge.</p>
    /// - On failure, responds with [`SdkError<MergePullRequestByFastForwardError>`](crate::error::MergePullRequestByFastForwardError)
    pub fn merge_pull_request_by_fast_forward(
        &self,
    ) -> fluent_builders::MergePullRequestByFastForward {
        fluent_builders::MergePullRequestByFastForward::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergePullRequestBySquash`](crate::client::fluent_builders::MergePullRequestBySquash) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_repository_name): <p>The name of the repository where the pull request was created.</p>
    ///   - [`source_commit_id(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::source_commit_id) / [`set_source_commit_id(Option<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_source_commit_id): <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::MergePullRequestBySquash::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::MergePullRequestBySquash::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_commit_message): <p>The commit message to include in the commit information for the merge.</p>
    ///   - [`author_name(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::author_name) / [`set_author_name(Option<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_author_name): <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_email): <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    ///   - [`keep_empty_folders(bool)`](crate::client::fluent_builders::MergePullRequestBySquash::keep_empty_folders) / [`set_keep_empty_folders(bool)`](crate::client::fluent_builders::MergePullRequestBySquash::set_keep_empty_folders): <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    ///   - [`conflict_resolution(ConflictResolution)`](crate::client::fluent_builders::MergePullRequestBySquash::conflict_resolution) / [`set_conflict_resolution(Option<ConflictResolution>)`](crate::client::fluent_builders::MergePullRequestBySquash::set_conflict_resolution): <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    /// - On success, responds with [`MergePullRequestBySquashOutput`](crate::output::MergePullRequestBySquashOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::MergePullRequestBySquashOutput::pull_request): <p>Returns information about a pull request.</p>
    /// - On failure, responds with [`SdkError<MergePullRequestBySquashError>`](crate::error::MergePullRequestBySquashError)
    pub fn merge_pull_request_by_squash(&self) -> fluent_builders::MergePullRequestBySquash {
        fluent_builders::MergePullRequestBySquash::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergePullRequestByThreeWay`](crate::client::fluent_builders::MergePullRequestByThreeWay) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_repository_name): <p>The name of the repository where the pull request was created.</p>
    ///   - [`source_commit_id(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::source_commit_id) / [`set_source_commit_id(Option<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_source_commit_id): <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    ///   - [`conflict_detail_level(ConflictDetailLevelTypeEnum)`](crate::client::fluent_builders::MergePullRequestByThreeWay::conflict_detail_level) / [`set_conflict_detail_level(Option<ConflictDetailLevelTypeEnum>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_conflict_detail_level): <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    ///   - [`conflict_resolution_strategy(ConflictResolutionStrategyTypeEnum)`](crate::client::fluent_builders::MergePullRequestByThreeWay::conflict_resolution_strategy) / [`set_conflict_resolution_strategy(Option<ConflictResolutionStrategyTypeEnum>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_conflict_resolution_strategy): <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_commit_message): <p>The commit message to include in the commit information for the merge.</p>
    ///   - [`author_name(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::author_name) / [`set_author_name(Option<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_author_name): <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_email): <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    ///   - [`keep_empty_folders(bool)`](crate::client::fluent_builders::MergePullRequestByThreeWay::keep_empty_folders) / [`set_keep_empty_folders(bool)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_keep_empty_folders): <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    ///   - [`conflict_resolution(ConflictResolution)`](crate::client::fluent_builders::MergePullRequestByThreeWay::conflict_resolution) / [`set_conflict_resolution(Option<ConflictResolution>)`](crate::client::fluent_builders::MergePullRequestByThreeWay::set_conflict_resolution): <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    /// - On success, responds with [`MergePullRequestByThreeWayOutput`](crate::output::MergePullRequestByThreeWayOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::MergePullRequestByThreeWayOutput::pull_request): <p>Returns information about a pull request.</p>
    /// - On failure, responds with [`SdkError<MergePullRequestByThreeWayError>`](crate::error::MergePullRequestByThreeWayError)
    pub fn merge_pull_request_by_three_way(&self) -> fluent_builders::MergePullRequestByThreeWay {
        fluent_builders::MergePullRequestByThreeWay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`OverridePullRequestApprovalRules`](crate::client::fluent_builders::OverridePullRequestApprovalRules) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::OverridePullRequestApprovalRules::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::OverridePullRequestApprovalRules::set_pull_request_id): <p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <code>GetPullRequest</code>.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::OverridePullRequestApprovalRules::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::OverridePullRequestApprovalRules::set_revision_id): <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>
    ///   - [`override_status(OverrideStatus)`](crate::client::fluent_builders::OverridePullRequestApprovalRules::override_status) / [`set_override_status(Option<OverrideStatus>)`](crate::client::fluent_builders::OverridePullRequestApprovalRules::set_override_status): <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>
    /// - On success, responds with [`OverridePullRequestApprovalRulesOutput`](crate::output::OverridePullRequestApprovalRulesOutput)

    /// - On failure, responds with [`SdkError<OverridePullRequestApprovalRulesError>`](crate::error::OverridePullRequestApprovalRulesError)
    pub fn override_pull_request_approval_rules(
        &self,
    ) -> fluent_builders::OverridePullRequestApprovalRules {
        fluent_builders::OverridePullRequestApprovalRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PostCommentForComparedCommit`](crate::client::fluent_builders::PostCommentForComparedCommit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::set_repository_name): <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
    ///   - [`before_commit_id(impl Into<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::before_commit_id) / [`set_before_commit_id(Option<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::set_before_commit_id): <p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>
    ///   - [`after_commit_id(impl Into<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::after_commit_id) / [`set_after_commit_id(Option<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::set_after_commit_id): <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
    ///   - [`location(Location)`](crate::client::fluent_builders::PostCommentForComparedCommit::location) / [`set_location(Option<Location>)`](crate::client::fluent_builders::PostCommentForComparedCommit::set_location): <p>The location of the comparison where you want to comment.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::set_content): <p>The content of the comment you want to make.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::PostCommentForComparedCommit::set_client_request_token): <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    /// - On success, responds with [`PostCommentForComparedCommitOutput`](crate::output::PostCommentForComparedCommitOutput) with field(s):
    ///   - [`repository_name(Option<String>)`](crate::output::PostCommentForComparedCommitOutput::repository_name): <p>The name of the repository where you posted a comment on the comparison between commits.</p>
    ///   - [`before_commit_id(Option<String>)`](crate::output::PostCommentForComparedCommitOutput::before_commit_id): <p>In the directionality you established, the full commit ID of the before commit.</p>
    ///   - [`after_commit_id(Option<String>)`](crate::output::PostCommentForComparedCommitOutput::after_commit_id): <p>In the directionality you established, the full commit ID of the after commit.</p>
    ///   - [`before_blob_id(Option<String>)`](crate::output::PostCommentForComparedCommitOutput::before_blob_id): <p>In the directionality you established, the blob ID of the before blob.</p>
    ///   - [`after_blob_id(Option<String>)`](crate::output::PostCommentForComparedCommitOutput::after_blob_id): <p>In the directionality you established, the blob ID of the after blob.</p>
    ///   - [`location(Option<Location>)`](crate::output::PostCommentForComparedCommitOutput::location): <p>The location of the comment in the comparison between the two commits.</p>
    ///   - [`comment(Option<Comment>)`](crate::output::PostCommentForComparedCommitOutput::comment): <p>The content of the comment you posted.</p>
    /// - On failure, responds with [`SdkError<PostCommentForComparedCommitError>`](crate::error::PostCommentForComparedCommitError)
    pub fn post_comment_for_compared_commit(
        &self,
    ) -> fluent_builders::PostCommentForComparedCommit {
        fluent_builders::PostCommentForComparedCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PostCommentForPullRequest`](crate::client::fluent_builders::PostCommentForPullRequest) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::set_repository_name): <p>The name of the repository where you want to post a comment on a pull request.</p>
    ///   - [`before_commit_id(impl Into<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::before_commit_id) / [`set_before_commit_id(Option<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::set_before_commit_id): <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
    ///   - [`after_commit_id(impl Into<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::after_commit_id) / [`set_after_commit_id(Option<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::set_after_commit_id): <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
    ///   - [`location(Location)`](crate::client::fluent_builders::PostCommentForPullRequest::location) / [`set_location(Option<Location>)`](crate::client::fluent_builders::PostCommentForPullRequest::set_location): <p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::set_content): <p>The content of your comment on the change.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::PostCommentForPullRequest::set_client_request_token): <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    /// - On success, responds with [`PostCommentForPullRequestOutput`](crate::output::PostCommentForPullRequestOutput) with field(s):
    ///   - [`repository_name(Option<String>)`](crate::output::PostCommentForPullRequestOutput::repository_name): <p>The name of the repository where you posted a comment on a pull request.</p>
    ///   - [`pull_request_id(Option<String>)`](crate::output::PostCommentForPullRequestOutput::pull_request_id): <p>The system-generated ID of the pull request. </p>
    ///   - [`before_commit_id(Option<String>)`](crate::output::PostCommentForPullRequestOutput::before_commit_id): <p>The full commit ID of the commit in the source branch used to create the pull request, or in the case of an updated pull request, the full commit ID of the commit used to update the pull request.</p>
    ///   - [`after_commit_id(Option<String>)`](crate::output::PostCommentForPullRequestOutput::after_commit_id): <p>The full commit ID of the commit in the destination branch where the pull request is merged.</p>
    ///   - [`before_blob_id(Option<String>)`](crate::output::PostCommentForPullRequestOutput::before_blob_id): <p>In the directionality of the pull request, the blob ID of the before blob.</p>
    ///   - [`after_blob_id(Option<String>)`](crate::output::PostCommentForPullRequestOutput::after_blob_id): <p>In the directionality of the pull request, the blob ID of the after blob.</p>
    ///   - [`location(Option<Location>)`](crate::output::PostCommentForPullRequestOutput::location): <p>The location of the change where you posted your comment.</p>
    ///   - [`comment(Option<Comment>)`](crate::output::PostCommentForPullRequestOutput::comment): <p>The content of the comment you posted.</p>
    /// - On failure, responds with [`SdkError<PostCommentForPullRequestError>`](crate::error::PostCommentForPullRequestError)
    pub fn post_comment_for_pull_request(&self) -> fluent_builders::PostCommentForPullRequest {
        fluent_builders::PostCommentForPullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PostCommentReply`](crate::client::fluent_builders::PostCommentReply) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`in_reply_to(impl Into<String>)`](crate::client::fluent_builders::PostCommentReply::in_reply_to) / [`set_in_reply_to(Option<String>)`](crate::client::fluent_builders::PostCommentReply::set_in_reply_to): <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::PostCommentReply::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::PostCommentReply::set_client_request_token): <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::PostCommentReply::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::PostCommentReply::set_content): <p>The contents of your reply to a comment.</p>
    /// - On success, responds with [`PostCommentReplyOutput`](crate::output::PostCommentReplyOutput) with field(s):
    ///   - [`comment(Option<Comment>)`](crate::output::PostCommentReplyOutput::comment): <p>Information about the reply to a comment.</p>
    /// - On failure, responds with [`SdkError<PostCommentReplyError>`](crate::error::PostCommentReplyError)
    pub fn post_comment_reply(&self) -> fluent_builders::PostCommentReply {
        fluent_builders::PostCommentReply::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutCommentReaction`](crate::client::fluent_builders::PutCommentReaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`comment_id(impl Into<String>)`](crate::client::fluent_builders::PutCommentReaction::comment_id) / [`set_comment_id(Option<String>)`](crate::client::fluent_builders::PutCommentReaction::set_comment_id): <p>The ID of the comment to which you want to add or update a reaction.</p>
    ///   - [`reaction_value(impl Into<String>)`](crate::client::fluent_builders::PutCommentReaction::reaction_value) / [`set_reaction_value(Option<String>)`](crate::client::fluent_builders::PutCommentReaction::set_reaction_value): <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
    /// - On success, responds with [`PutCommentReactionOutput`](crate::output::PutCommentReactionOutput)

    /// - On failure, responds with [`SdkError<PutCommentReactionError>`](crate::error::PutCommentReactionError)
    pub fn put_comment_reaction(&self) -> fluent_builders::PutCommentReaction {
        fluent_builders::PutCommentReaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFile`](crate::client::fluent_builders::PutFile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PutFile::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PutFile::set_repository_name): <p>The name of the repository where you want to add or update the file.</p>
    ///   - [`branch_name(impl Into<String>)`](crate::client::fluent_builders::PutFile::branch_name) / [`set_branch_name(Option<String>)`](crate::client::fluent_builders::PutFile::set_branch_name): <p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>
    ///   - [`file_content(Blob)`](crate::client::fluent_builders::PutFile::file_content) / [`set_file_content(Option<Blob>)`](crate::client::fluent_builders::PutFile::set_file_content): <p>The content of the file, in binary object format. </p>
    ///   - [`file_path(impl Into<String>)`](crate::client::fluent_builders::PutFile::file_path) / [`set_file_path(Option<String>)`](crate::client::fluent_builders::PutFile::set_file_path): <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note>   <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p>  </note>
    ///   - [`file_mode(FileModeTypeEnum)`](crate::client::fluent_builders::PutFile::file_mode) / [`set_file_mode(Option<FileModeTypeEnum>)`](crate::client::fluent_builders::PutFile::set_file_mode): <p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>
    ///   - [`parent_commit_id(impl Into<String>)`](crate::client::fluent_builders::PutFile::parent_commit_id) / [`set_parent_commit_id(Option<String>)`](crate::client::fluent_builders::PutFile::set_parent_commit_id): <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p>  <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>
    ///   - [`commit_message(impl Into<String>)`](crate::client::fluent_builders::PutFile::commit_message) / [`set_commit_message(Option<String>)`](crate::client::fluent_builders::PutFile::set_commit_message): <p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutFile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutFile::set_name): <p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>
    ///   - [`email(impl Into<String>)`](crate::client::fluent_builders::PutFile::email) / [`set_email(Option<String>)`](crate::client::fluent_builders::PutFile::set_email): <p>An email address for the person adding or updating the file.</p>
    /// - On success, responds with [`PutFileOutput`](crate::output::PutFileOutput) with field(s):
    ///   - [`commit_id(Option<String>)`](crate::output::PutFileOutput::commit_id): <p>The full SHA ID of the commit that contains this file change.</p>
    ///   - [`blob_id(Option<String>)`](crate::output::PutFileOutput::blob_id): <p>The ID of the blob, which is its SHA-1 pointer.</p>
    ///   - [`tree_id(Option<String>)`](crate::output::PutFileOutput::tree_id): <p>The full SHA-1 pointer of the tree information for the commit that contains this file change.</p>
    /// - On failure, responds with [`SdkError<PutFileError>`](crate::error::PutFileError)
    pub fn put_file(&self) -> fluent_builders::PutFile {
        fluent_builders::PutFile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRepositoryTriggers`](crate::client::fluent_builders::PutRepositoryTriggers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::PutRepositoryTriggers::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::PutRepositoryTriggers::set_repository_name): <p>The name of the repository where you want to create or update the trigger.</p>
    ///   - [`triggers(Vec<RepositoryTrigger>)`](crate::client::fluent_builders::PutRepositoryTriggers::triggers) / [`set_triggers(Option<Vec<RepositoryTrigger>>)`](crate::client::fluent_builders::PutRepositoryTriggers::set_triggers): <p>The JSON block of configuration information for each trigger.</p>
    /// - On success, responds with [`PutRepositoryTriggersOutput`](crate::output::PutRepositoryTriggersOutput) with field(s):
    ///   - [`configuration_id(Option<String>)`](crate::output::PutRepositoryTriggersOutput::configuration_id): <p>The system-generated unique ID for the create or update operation.</p>
    /// - On failure, responds with [`SdkError<PutRepositoryTriggersError>`](crate::error::PutRepositoryTriggersError)
    pub fn put_repository_triggers(&self) -> fluent_builders::PutRepositoryTriggers {
        fluent_builders::PutRepositoryTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The key-value pair to use when tagging this repository.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestRepositoryTriggers`](crate::client::fluent_builders::TestRepositoryTriggers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::TestRepositoryTriggers::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::TestRepositoryTriggers::set_repository_name): <p>The name of the repository in which to test the triggers.</p>
    ///   - [`triggers(Vec<RepositoryTrigger>)`](crate::client::fluent_builders::TestRepositoryTriggers::triggers) / [`set_triggers(Option<Vec<RepositoryTrigger>>)`](crate::client::fluent_builders::TestRepositoryTriggers::set_triggers): <p>The list of triggers to test.</p>
    /// - On success, responds with [`TestRepositoryTriggersOutput`](crate::output::TestRepositoryTriggersOutput) with field(s):
    ///   - [`successful_executions(Option<Vec<String>>)`](crate::output::TestRepositoryTriggersOutput::successful_executions): <p>The list of triggers that were successfully tested. This list provides the names of the triggers that were successfully tested, separated by commas.</p>
    ///   - [`failed_executions(Option<Vec<RepositoryTriggerExecutionFailure>>)`](crate::output::TestRepositoryTriggersOutput::failed_executions): <p>The list of triggers that were not tested. This list provides the names of the triggers that could not be tested, separated by commas.</p>
    /// - On failure, responds with [`SdkError<TestRepositoryTriggersError>`](crate::error::TestRepositoryTriggersError)
    pub fn test_repository_triggers(&self) -> fluent_builders::TestRepositoryTriggers {
        fluent_builders::TestRepositoryTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag key for each tag that you want to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApprovalRuleTemplateContent`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent::set_approval_rule_template_name): <p>The name of the approval rule template where you want to update the content of the rule. </p>
    ///   - [`new_rule_content(impl Into<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent::new_rule_content) / [`set_new_rule_content(Option<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent::set_new_rule_content): <p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>
    ///   - [`existing_rule_content_sha256(impl Into<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent::existing_rule_content_sha256) / [`set_existing_rule_content_sha256(Option<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent::set_existing_rule_content_sha256): <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
    /// - On success, responds with [`UpdateApprovalRuleTemplateContentOutput`](crate::output::UpdateApprovalRuleTemplateContentOutput) with field(s):
    ///   - [`approval_rule_template(Option<ApprovalRuleTemplate>)`](crate::output::UpdateApprovalRuleTemplateContentOutput::approval_rule_template): <p>Returns information about an approval rule template.</p>
    /// - On failure, responds with [`SdkError<UpdateApprovalRuleTemplateContentError>`](crate::error::UpdateApprovalRuleTemplateContentError)
    pub fn update_approval_rule_template_content(
        &self,
    ) -> fluent_builders::UpdateApprovalRuleTemplateContent {
        fluent_builders::UpdateApprovalRuleTemplateContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApprovalRuleTemplateDescription`](crate::client::fluent_builders::UpdateApprovalRuleTemplateDescription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateDescription::approval_rule_template_name) / [`set_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateDescription::set_approval_rule_template_name): <p>The name of the template for which you want to update the description.</p>
    ///   - [`approval_rule_template_description(impl Into<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateDescription::approval_rule_template_description) / [`set_approval_rule_template_description(Option<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateDescription::set_approval_rule_template_description): <p>The updated description of the approval rule template.</p>
    /// - On success, responds with [`UpdateApprovalRuleTemplateDescriptionOutput`](crate::output::UpdateApprovalRuleTemplateDescriptionOutput) with field(s):
    ///   - [`approval_rule_template(Option<ApprovalRuleTemplate>)`](crate::output::UpdateApprovalRuleTemplateDescriptionOutput::approval_rule_template): <p>The structure and content of the updated approval rule template.</p>
    /// - On failure, responds with [`SdkError<UpdateApprovalRuleTemplateDescriptionError>`](crate::error::UpdateApprovalRuleTemplateDescriptionError)
    pub fn update_approval_rule_template_description(
        &self,
    ) -> fluent_builders::UpdateApprovalRuleTemplateDescription {
        fluent_builders::UpdateApprovalRuleTemplateDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateApprovalRuleTemplateName`](crate::client::fluent_builders::UpdateApprovalRuleTemplateName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`old_approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateName::old_approval_rule_template_name) / [`set_old_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateName::set_old_approval_rule_template_name): <p>The current name of the approval rule template.</p>
    ///   - [`new_approval_rule_template_name(impl Into<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateName::new_approval_rule_template_name) / [`set_new_approval_rule_template_name(Option<String>)`](crate::client::fluent_builders::UpdateApprovalRuleTemplateName::set_new_approval_rule_template_name): <p>The new name you want to apply to the approval rule template.</p>
    /// - On success, responds with [`UpdateApprovalRuleTemplateNameOutput`](crate::output::UpdateApprovalRuleTemplateNameOutput) with field(s):
    ///   - [`approval_rule_template(Option<ApprovalRuleTemplate>)`](crate::output::UpdateApprovalRuleTemplateNameOutput::approval_rule_template): <p>The structure and content of the updated approval rule template.</p>
    /// - On failure, responds with [`SdkError<UpdateApprovalRuleTemplateNameError>`](crate::error::UpdateApprovalRuleTemplateNameError)
    pub fn update_approval_rule_template_name(
        &self,
    ) -> fluent_builders::UpdateApprovalRuleTemplateName {
        fluent_builders::UpdateApprovalRuleTemplateName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateComment`](crate::client::fluent_builders::UpdateComment) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`comment_id(impl Into<String>)`](crate::client::fluent_builders::UpdateComment::comment_id) / [`set_comment_id(Option<String>)`](crate::client::fluent_builders::UpdateComment::set_comment_id): <p>The system-generated ID of the comment you want to update. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::UpdateComment::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::UpdateComment::set_content): <p>The updated content to replace the existing content of the comment.</p>
    /// - On success, responds with [`UpdateCommentOutput`](crate::output::UpdateCommentOutput) with field(s):
    ///   - [`comment(Option<Comment>)`](crate::output::UpdateCommentOutput::comment): <p>Information about the updated comment.</p>
    /// - On failure, responds with [`SdkError<UpdateCommentError>`](crate::error::UpdateCommentError)
    pub fn update_comment(&self) -> fluent_builders::UpdateComment {
        fluent_builders::UpdateComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDefaultBranch`](crate::client::fluent_builders::UpdateDefaultBranch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDefaultBranch::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::UpdateDefaultBranch::set_repository_name): <p>The name of the repository to set or change the default branch for.</p>
    ///   - [`default_branch_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDefaultBranch::default_branch_name) / [`set_default_branch_name(Option<String>)`](crate::client::fluent_builders::UpdateDefaultBranch::set_default_branch_name): <p>The name of the branch to set as the default.</p>
    /// - On success, responds with [`UpdateDefaultBranchOutput`](crate::output::UpdateDefaultBranchOutput)

    /// - On failure, responds with [`SdkError<UpdateDefaultBranchError>`](crate::error::UpdateDefaultBranchError)
    pub fn update_default_branch(&self) -> fluent_builders::UpdateDefaultBranch {
        fluent_builders::UpdateDefaultBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePullRequestApprovalRuleContent`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::set_pull_request_id): <p>The system-generated ID of the pull request.</p>
    ///   - [`approval_rule_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::approval_rule_name) / [`set_approval_rule_name(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::set_approval_rule_name): <p>The name of the approval rule you want to update.</p>
    ///   - [`existing_rule_content_sha256(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::existing_rule_content_sha256) / [`set_existing_rule_content_sha256(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::set_existing_rule_content_sha256): <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
    ///   - [`new_rule_content(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::new_rule_content) / [`set_new_rule_content(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent::set_new_rule_content): <p>The updated content for the approval rule.</p> <note>   <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>   <ul>    <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>     <ul>      <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>      <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>     </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>    <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>   </ul>   <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>  </note>
    /// - On success, responds with [`UpdatePullRequestApprovalRuleContentOutput`](crate::output::UpdatePullRequestApprovalRuleContentOutput) with field(s):
    ///   - [`approval_rule(Option<ApprovalRule>)`](crate::output::UpdatePullRequestApprovalRuleContentOutput::approval_rule): <p>Information about the updated approval rule.</p>
    /// - On failure, responds with [`SdkError<UpdatePullRequestApprovalRuleContentError>`](crate::error::UpdatePullRequestApprovalRuleContentError)
    pub fn update_pull_request_approval_rule_content(
        &self,
    ) -> fluent_builders::UpdatePullRequestApprovalRuleContent {
        fluent_builders::UpdatePullRequestApprovalRuleContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePullRequestApprovalState`](crate::client::fluent_builders::UpdatePullRequestApprovalState) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalState::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalState::set_pull_request_id): <p>The system-generated ID of the pull request.</p>
    ///   - [`revision_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalState::revision_id) / [`set_revision_id(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestApprovalState::set_revision_id): <p>The system-generated ID of the revision.</p>
    ///   - [`approval_state(ApprovalState)`](crate::client::fluent_builders::UpdatePullRequestApprovalState::approval_state) / [`set_approval_state(Option<ApprovalState>)`](crate::client::fluent_builders::UpdatePullRequestApprovalState::set_approval_state): <p>The approval state to associate with the user on the pull request.</p>
    /// - On success, responds with [`UpdatePullRequestApprovalStateOutput`](crate::output::UpdatePullRequestApprovalStateOutput)

    /// - On failure, responds with [`SdkError<UpdatePullRequestApprovalStateError>`](crate::error::UpdatePullRequestApprovalStateError)
    pub fn update_pull_request_approval_state(
        &self,
    ) -> fluent_builders::UpdatePullRequestApprovalState {
        fluent_builders::UpdatePullRequestApprovalState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePullRequestDescription`](crate::client::fluent_builders::UpdatePullRequestDescription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestDescription::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestDescription::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestDescription::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestDescription::set_description): <p>The updated content of the description for the pull request. This content replaces the existing description.</p>
    /// - On success, responds with [`UpdatePullRequestDescriptionOutput`](crate::output::UpdatePullRequestDescriptionOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::UpdatePullRequestDescriptionOutput::pull_request): <p>Information about the updated pull request.</p>
    /// - On failure, responds with [`SdkError<UpdatePullRequestDescriptionError>`](crate::error::UpdatePullRequestDescriptionError)
    pub fn update_pull_request_description(&self) -> fluent_builders::UpdatePullRequestDescription {
        fluent_builders::UpdatePullRequestDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePullRequestStatus`](crate::client::fluent_builders::UpdatePullRequestStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestStatus::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestStatus::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`pull_request_status(PullRequestStatusEnum)`](crate::client::fluent_builders::UpdatePullRequestStatus::pull_request_status) / [`set_pull_request_status(Option<PullRequestStatusEnum>)`](crate::client::fluent_builders::UpdatePullRequestStatus::set_pull_request_status): <p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>
    /// - On success, responds with [`UpdatePullRequestStatusOutput`](crate::output::UpdatePullRequestStatusOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::UpdatePullRequestStatusOutput::pull_request): <p>Information about the pull request.</p>
    /// - On failure, responds with [`SdkError<UpdatePullRequestStatusError>`](crate::error::UpdatePullRequestStatusError)
    pub fn update_pull_request_status(&self) -> fluent_builders::UpdatePullRequestStatus {
        fluent_builders::UpdatePullRequestStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePullRequestTitle`](crate::client::fluent_builders::UpdatePullRequestTitle) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`pull_request_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestTitle::pull_request_id) / [`set_pull_request_id(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestTitle::set_pull_request_id): <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    ///   - [`title(impl Into<String>)`](crate::client::fluent_builders::UpdatePullRequestTitle::title) / [`set_title(Option<String>)`](crate::client::fluent_builders::UpdatePullRequestTitle::set_title): <p>The updated title of the pull request. This replaces the existing title.</p>
    /// - On success, responds with [`UpdatePullRequestTitleOutput`](crate::output::UpdatePullRequestTitleOutput) with field(s):
    ///   - [`pull_request(Option<PullRequest>)`](crate::output::UpdatePullRequestTitleOutput::pull_request): <p>Information about the updated pull request.</p>
    /// - On failure, responds with [`SdkError<UpdatePullRequestTitleError>`](crate::error::UpdatePullRequestTitleError)
    pub fn update_pull_request_title(&self) -> fluent_builders::UpdatePullRequestTitle {
        fluent_builders::UpdatePullRequestTitle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRepositoryDescription`](crate::client::fluent_builders::UpdateRepositoryDescription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRepositoryDescription::repository_name) / [`set_repository_name(Option<String>)`](crate::client::fluent_builders::UpdateRepositoryDescription::set_repository_name): <p>The name of the repository to set or change the comment or description for.</p>
    ///   - [`repository_description(impl Into<String>)`](crate::client::fluent_builders::UpdateRepositoryDescription::repository_description) / [`set_repository_description(Option<String>)`](crate::client::fluent_builders::UpdateRepositoryDescription::set_repository_description): <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
    /// - On success, responds with [`UpdateRepositoryDescriptionOutput`](crate::output::UpdateRepositoryDescriptionOutput)

    /// - On failure, responds with [`SdkError<UpdateRepositoryDescriptionError>`](crate::error::UpdateRepositoryDescriptionError)
    pub fn update_repository_description(&self) -> fluent_builders::UpdateRepositoryDescription {
        fluent_builders::UpdateRepositoryDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRepositoryName`](crate::client::fluent_builders::UpdateRepositoryName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`old_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRepositoryName::old_name) / [`set_old_name(Option<String>)`](crate::client::fluent_builders::UpdateRepositoryName::set_old_name): <p>The current name of the repository.</p>
    ///   - [`new_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRepositoryName::new_name) / [`set_new_name(Option<String>)`](crate::client::fluent_builders::UpdateRepositoryName::set_new_name): <p>The new name for the repository.</p>
    /// - On success, responds with [`UpdateRepositoryNameOutput`](crate::output::UpdateRepositoryNameOutput)

    /// - On failure, responds with [`SdkError<UpdateRepositoryNameError>`](crate::error::UpdateRepositoryNameError)
    pub fn update_repository_name(&self) -> fluent_builders::UpdateRepositoryName {
        fluent_builders::UpdateRepositoryName::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateApprovalRuleTemplateWithRepository`.
    ///
    /// <p>Creates an association between an approval rule template and a specified repository. Then, the next time a pull request is created in the repository where the destination reference (if specified) matches the destination reference (branch) for the pull request, an approval rule that matches the template conditions is automatically created for that pull request. If no destination references are specified in the template, an approval rule that matches the template contents is created for all pull requests in that repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateApprovalRuleTemplateWithRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_approval_rule_template_with_repository_input::Builder,
    }
    impl AssociateApprovalRuleTemplateWithRepository {
        /// Creates a new `AssociateApprovalRuleTemplateWithRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateApprovalRuleTemplateWithRepositoryError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the approval rule template. </p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name for the approval rule template. </p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The name of the repository that you want to associate with the template.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that you want to associate with the template.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateApprovalRuleTemplateWithRepositories`.
    ///
    /// <p>Creates an association between an approval rule template and one or more specified repositories. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchAssociateApprovalRuleTemplateWithRepositories {
        handle: std::sync::Arc<super::Handle>,
        inner:
            crate::input::batch_associate_approval_rule_template_with_repositories_input::Builder,
    }
    impl BatchAssociateApprovalRuleTemplateWithRepositories {
        /// Creates a new `BatchAssociateApprovalRuleTemplateWithRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template you want to associate with one or more repositories.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the template you want to associate with one or more repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The names of the repositories you want to associate with the template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(input.into());
            self
        }
        /// <p>The names of the repositories you want to associate with the template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDescribeMergeConflicts`.
    ///
    /// <p>Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDescribeMergeConflicts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_describe_merge_conflicts_input::Builder,
    }
    impl BatchDescribeMergeConflicts {
        /// Creates a new `BatchDescribeMergeConflicts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDescribeMergeConflictsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDescribeMergeConflictsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn max_merge_hunks(mut self, input: i32) -> Self {
            self.inner = self.inner.max_merge_hunks(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn set_max_merge_hunks(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_merge_hunks(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn max_conflict_files(mut self, input: i32) -> Self {
            self.inner = self.inner.max_conflict_files(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn set_max_conflict_files(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_conflict_files(input);
            self
        }
        /// Appends an item to `filePaths`.
        ///
        /// To override the contents of this collection use [`set_file_paths`](Self::set_file_paths).
        ///
        /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
        pub fn file_paths(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_paths(input.into());
            self
        }
        /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
        pub fn set_file_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_paths(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateApprovalRuleTemplateFromRepositories`.
    ///
    /// <p>Removes the association between an approval rule template and one or more specified repositories. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDisassociateApprovalRuleTemplateFromRepositories {
                            handle: std::sync::Arc<super::Handle>,
                            inner: crate::input::batch_disassociate_approval_rule_template_from_repositories_input::Builder
                        }
    impl BatchDisassociateApprovalRuleTemplateFromRepositories {
        /// Creates a new `BatchDisassociateApprovalRuleTemplateFromRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The repository names that you want to disassociate from the approval rule template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(input.into());
            self
        }
        /// <p>The repository names that you want to disassociate from the approval rule template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetCommits`.
    ///
    /// <p>Returns information about the contents of one or more commits in a repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetCommits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_commits_input::Builder,
    }
    impl BatchGetCommits {
        /// Creates a new `BatchGetCommits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetCommitsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetCommitsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `commitIds`.
        ///
        /// To override the contents of this collection use [`set_commit_ids`](Self::set_commit_ids).
        ///
        /// <p>The full commit IDs of the commits to get information about.</p> <note>
        /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p>
        /// </note>
        pub fn commit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_ids(input.into());
            self
        }
        /// <p>The full commit IDs of the commits to get information about.</p> <note>
        /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p>
        /// </note>
        pub fn set_commit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_commit_ids(input);
            self
        }
        /// <p>The name of the repository that contains the commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetRepositories`.
    ///
    /// <p>Returns information about one or more repositories.</p> <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetRepositories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_repositories_input::Builder,
    }
    impl BatchGetRepositories {
        /// Creates a new `BatchGetRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetRepositoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The names of the repositories to get information about.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(input.into());
            self
        }
        /// <p>The names of the repositories to get information about.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApprovalRuleTemplate`.
    ///
    /// <p>Creates a template for approval rules that can then be associated with one or more repositories in your AWS account. When you associate a template with a repository, AWS CodeCommit creates an approval rule that matches the conditions of the template for all pull requests that meet the conditions of the template. For more information, see <code>AssociateApprovalRuleTemplateWithRepository</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApprovalRuleTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_approval_rule_template_input::Builder,
    }
    impl CreateApprovalRuleTemplate {
        /// Creates a new `CreateApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApprovalRuleTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note>
        /// <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn approval_rule_template_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_content(input.into());
            self
        }
        /// <p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note>
        /// <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn set_approval_rule_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_content(input);
            self
        }
        /// <p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>
        pub fn approval_rule_template_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_description(input.into());
            self
        }
        /// <p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>
        pub fn set_approval_rule_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBranch`.
    ///
    /// <p>Creates a branch in a repository and points the branch to a commit.</p> <note>
    /// <p>Calling the create branch operation does not set a repository's default branch. To do this, call the update default branch operation.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_branch_input::Builder,
    }
    impl CreateBranch {
        /// Creates a new `CreateBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository in which you want to create the new branch.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository in which you want to create the new branch.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the new branch to create.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p>The name of the new branch to create.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The ID of the commit to point the new branch to.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_id(input.into());
            self
        }
        /// <p>The ID of the commit to point the new branch to.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCommit`.
    ///
    /// <p>Creates a commit for a repository on the tip of a specified branch.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCommit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_commit_input::Builder,
    }
    impl CreateCommit {
        /// Creates a new `CreateCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCommitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you create the commit.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you create the commit.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch where you create the commit.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p>The name of the branch where you create the commit.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>
        pub fn parent_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_commit_id(input.into());
            self
        }
        /// <p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_commit_id(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person who created the commit.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the person who created the commit.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// Appends an item to `putFiles`.
        ///
        /// To override the contents of this collection use [`set_put_files`](Self::set_put_files).
        ///
        /// <p>The files to add or update in this commit.</p>
        pub fn put_files(mut self, input: crate::model::PutFileEntry) -> Self {
            self.inner = self.inner.put_files(input);
            self
        }
        /// <p>The files to add or update in this commit.</p>
        pub fn set_put_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutFileEntry>>,
        ) -> Self {
            self.inner = self.inner.set_put_files(input);
            self
        }
        /// Appends an item to `deleteFiles`.
        ///
        /// To override the contents of this collection use [`set_delete_files`](Self::set_delete_files).
        ///
        /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
        pub fn delete_files(mut self, input: crate::model::DeleteFileEntry) -> Self {
            self.inner = self.inner.delete_files(input);
            self
        }
        /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
        pub fn set_delete_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
        ) -> Self {
            self.inner = self.inner.set_delete_files(input);
            self
        }
        /// Appends an item to `setFileModes`.
        ///
        /// To override the contents of this collection use [`set_set_file_modes`](Self::set_set_file_modes).
        ///
        /// <p>The file modes to update for files in this commit.</p>
        pub fn set_file_modes(mut self, input: crate::model::SetFileModeEntry) -> Self {
            self.inner = self.inner.set_file_modes(input);
            self
        }
        /// <p>The file modes to update for files in this commit.</p>
        pub fn set_set_file_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
        ) -> Self {
            self.inner = self.inner.set_set_file_modes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePullRequest`.
    ///
    /// <p>Creates a pull request in the specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePullRequest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pull_request_input::Builder,
    }
    impl CreatePullRequest {
        /// Creates a new `CreatePullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePullRequestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(input.into());
            self
        }
        /// <p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>A description of the pull request.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the pull request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
        /// </note>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
        /// </note>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePullRequestApprovalRule`.
    ///
    /// <p>Creates an approval rule for a pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePullRequestApprovalRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_pull_request_approval_rule_input::Builder,
    }
    impl CreatePullRequestApprovalRule {
        /// Creates a new `CreatePullRequestApprovalRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePullRequestApprovalRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePullRequestApprovalRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name for the approval rule.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_name(input.into());
            self
        }
        /// <p>The name for the approval rule.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_name(input);
            self
        }
        /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note>
        /// <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn approval_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_content(input.into());
            self
        }
        /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note>
        /// <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn set_approval_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p>Creates a new, empty repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl CreateRepository {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new repository to be created.</p> <note>
        /// <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p>
        /// </note>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the new repository to be created.</p> <note>
        /// <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p>
        /// </note>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>A comment or description about the new repository.</p> <note>
        /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
        /// </note>
        pub fn repository_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_description(input.into());
            self
        }
        /// <p>A comment or description about the new repository.</p> <note>
        /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
        /// </note>
        pub fn set_repository_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUnreferencedMergeCommit`.
    ///
    /// <p>Creates an unreferenced commit that represents the result of merging two branches using a specified merge strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the fast-forward merge strategy because that strategy does not create a merge commit.</p> <note>
    /// <p>This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUnreferencedMergeCommit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_unreferenced_merge_commit_input::Builder,
    }
    impl CreateUnreferencedMergeCommit {
        /// Creates a new `CreateUnreferencedMergeCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUnreferencedMergeCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUnreferencedMergeCommitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(input.into());
            self
        }
        /// <p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address for the person who created the unreferenced commit.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address for the person who created the unreferenced commit.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message for the unreferenced commit.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>The commit message for the unreferenced commit.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApprovalRuleTemplate`.
    ///
    /// <p>Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests already created with the template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApprovalRuleTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_approval_rule_template_input::Builder,
    }
    impl DeleteApprovalRuleTemplate {
        /// Creates a new `DeleteApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApprovalRuleTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template to delete.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the approval rule template to delete.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBranch`.
    ///
    /// <p>Deletes a branch from a repository, unless that branch is the default branch for the repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_branch_input::Builder,
    }
    impl DeleteBranch {
        /// Creates a new `DeleteBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the branch to be deleted.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the branch to be deleted.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch to delete.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p>The name of the branch to delete.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCommentContent`.
    ///
    /// <p>Deletes the content of a comment made on a change, file, or commit in a repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCommentContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_comment_content_input::Builder,
    }
    impl DeleteCommentContent {
        /// Creates a new `DeleteCommentContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCommentContentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCommentContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(input.into());
            self
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFile`.
    ///
    /// <p>Deletes a specified file from a specified branch. A commit is created on the branch that contains the revision. The file still exists in the commits earlier to the commit that contains the deletion.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_file_input::Builder,
    }
    impl DeleteFile {
        /// Creates a new `DeleteFile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the file to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the file to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch where the commit that deletes the file is made.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p>The name of the branch where the commit that deletes the file is made.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(input.into());
            self
        }
        /// <p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
        /// <p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>
        pub fn parent_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_commit_id(input.into());
            self
        }
        /// <p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_commit_id(input);
            self
        }
        /// <p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(input);
            self
        }
        /// <p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePullRequestApprovalRule`.
    ///
    /// <p>Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the pull request was created. You cannot delete an approval rule from a merged or closed pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePullRequestApprovalRule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_pull_request_approval_rule_input::Builder,
    }
    impl DeletePullRequestApprovalRule {
        /// Creates a new `DeletePullRequestApprovalRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePullRequestApprovalRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePullRequestApprovalRuleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the approval rule you want to delete.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_name(input.into());
            self
        }
        /// <p>The name of the approval rule you want to delete.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p>Deletes a repository. If a specified repository was already deleted, a null repository ID is returned.</p> <important>
    /// <p>Deleting a repository also deletes all associated objects and metadata. After a repository is deleted, all future push calls to the deleted repository fail.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl DeleteRepository {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMergeConflicts`.
    ///
    /// <p>Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy. If the merge option for the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMergeConflicts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_merge_conflicts_input::Builder,
    }
    impl DescribeMergeConflicts {
        /// Creates a new `DescribeMergeConflicts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMergeConflictsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMergeConflictsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMergeConflictsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeMergeConflictsPaginator {
            crate::paginator::DescribeMergeConflictsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the repository where you want to get information about a merge conflict.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to get information about a merge conflict.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn max_merge_hunks(mut self, input: i32) -> Self {
            self.inner = self.inner.max_merge_hunks(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn set_max_merge_hunks(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_merge_hunks(input);
            self
        }
        /// <p>The path of the target files used to describe the conflicts. </p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(input.into());
            self
        }
        /// <p>The path of the target files used to describe the conflicts. </p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePullRequestEvents`.
    ///
    /// <p>Returns information about one or more pull request events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePullRequestEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_pull_request_events_input::Builder,
    }
    impl DescribePullRequestEvents {
        /// Creates a new `DescribePullRequestEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePullRequestEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePullRequestEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribePullRequestEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribePullRequestEventsPaginator {
            crate::paginator::DescribePullRequestEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>Optional. The pull request event type about which you want to return information.</p>
        pub fn pull_request_event_type(
            mut self,
            input: crate::model::PullRequestEventType,
        ) -> Self {
            self.inner = self.inner.pull_request_event_type(input);
            self
        }
        /// <p>Optional. The pull request event type about which you want to return information.</p>
        pub fn set_pull_request_event_type(
            mut self,
            input: std::option::Option<crate::model::PullRequestEventType>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_event_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>
        pub fn actor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.actor_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>
        pub fn set_actor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_actor_arn(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateApprovalRuleTemplateFromRepository`.
    ///
    /// <p>Removes the association between a template and a repository so that approval rules based on the template are not automatically created when pull requests are created in the specified repository. This does not delete any approval rules previously created for pull requests through the template association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateApprovalRuleTemplateFromRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_approval_rule_template_from_repository_input::Builder,
    }
    impl DisassociateApprovalRuleTemplateFromRepository {
        /// Creates a new `DisassociateApprovalRuleTemplateFromRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The name of the repository you want to disassociate from the template.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository you want to disassociate from the template.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EvaluatePullRequestApprovalRules`.
    ///
    /// <p>Evaluates whether a pull request has met all the conditions specified in its associated approval rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EvaluatePullRequestApprovalRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::evaluate_pull_request_approval_rules_input::Builder,
    }
    impl EvaluatePullRequestApprovalRules {
        /// Creates a new `EvaluatePullRequestApprovalRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EvaluatePullRequestApprovalRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::EvaluatePullRequestApprovalRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request you want to evaluate.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request you want to evaluate.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <code>GetPullRequest</code>.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <code>GetPullRequest</code>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApprovalRuleTemplate`.
    ///
    /// <p>Returns information about a specified approval rule template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetApprovalRuleTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_approval_rule_template_input::Builder,
    }
    impl GetApprovalRuleTemplate {
        /// Creates a new `GetApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApprovalRuleTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template for which you want to get information.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the approval rule template for which you want to get information.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlob`.
    ///
    /// <p>Returns the base-64 encoded content of an individual blob in a repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBlob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_blob_input::Builder,
    }
    impl GetBlob {
        /// Creates a new `GetBlob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the blob.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the blob.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blob_id(input.into());
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_blob_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBranch`.
    ///
    /// <p>Returns information about a repository branch, including its name and the last commit ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_branch_input::Builder,
    }
    impl GetBranch {
        /// Creates a new `GetBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch for which you want to retrieve information.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p>The name of the branch for which you want to retrieve information.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComment`.
    ///
    /// <p>Returns the content of a comment made on a change, file, or commit in a repository. </p> <note>
    /// <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetComment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_comment_input::Builder,
    }
    impl GetComment {
        /// Creates a new `GetComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(input.into());
            self
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommentReactions`.
    ///
    /// <p>Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCommentReactions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_comment_reactions_input::Builder,
    }
    impl GetCommentReactions {
        /// Creates a new `GetCommentReactions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentReactionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentReactionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCommentReactionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCommentReactionsPaginator {
            crate::paginator::GetCommentReactionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The ID of the comment for which you want to get reactions information.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(input.into());
            self
        }
        /// <p>The ID of the comment for which you want to get reactions information.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
        pub fn reaction_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reaction_user_arn(input.into());
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
        pub fn set_reaction_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reaction_user_arn(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommentsForComparedCommit`.
    ///
    /// <p>Returns information about comments made on the comparison between two commits.</p> <note>
    /// <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCommentsForComparedCommit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_comments_for_compared_commit_input::Builder,
    }
    impl GetCommentsForComparedCommit {
        /// Creates a new `GetCommentsForComparedCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentsForComparedCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentsForComparedCommitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCommentsForComparedCommitPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCommentsForComparedCommitPaginator {
            crate::paginator::GetCommentsForComparedCommitPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the repository where you want to compare commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to compare commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommentsForPullRequest`.
    ///
    /// <p>Returns comments made on a pull request.</p> <note>
    /// <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of reactions from active identities, use GetCommentReactions.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCommentsForPullRequest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_comments_for_pull_request_input::Builder,
    }
    impl GetCommentsForPullRequest {
        /// Creates a new `GetCommentsForPullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentsForPullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentsForPullRequestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCommentsForPullRequestPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCommentsForPullRequestPaginator {
            crate::paginator::GetCommentsForPullRequestPaginator::new(self.handle, self.inner)
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommit`.
    ///
    /// <p>Returns information about a commit, including commit message and committer information.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCommit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_commit_input::Builder,
    }
    impl GetCommit {
        /// Creates a new `GetCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to which the commit was made.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to which the commit was made.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_id(input.into());
            self
        }
        /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDifferences`.
    ///
    /// <p>Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDifferences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_differences_input::Builder,
    }
    impl GetDifferences {
        /// Creates a new `GetDifferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDifferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDifferencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDifferencesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDifferencesPaginator {
            crate::paginator::GetDifferencesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the repository where you want to get differences.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to get differences.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>
        pub fn before_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>
        pub fn set_before_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
        pub fn after_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
        pub fn set_after_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_specifier(input);
            self
        }
        /// <p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>
        pub fn before_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_path(input.into());
            self
        }
        /// <p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>
        pub fn set_before_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_before_path(input);
            self
        }
        /// <p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>
        pub fn after_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_path(input.into());
            self
        }
        /// <p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>
        pub fn set_after_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after_path(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFile`.
    ///
    /// <p>Returns the base-64 encoded contents of a specified file and its metadata.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_file_input::Builder,
    }
    impl GetFile {
        /// Creates a new `GetFile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the file.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the file.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>
        pub fn commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_specifier(input.into());
            self
        }
        /// <p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>
        pub fn set_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_specifier(input);
            self
        }
        /// <p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(input.into());
            self
        }
        /// <p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFolder`.
    ///
    /// <p>Returns the contents of a specified folder in a repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFolder {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_folder_input::Builder,
    }
    impl GetFolder {
        /// Creates a new `GetFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFolderError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>
        pub fn commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_specifier(input.into());
            self
        }
        /// <p>A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>
        pub fn set_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_specifier(input);
            self
        }
        /// <p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>
        pub fn folder_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_path(input.into());
            self
        }
        /// <p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>
        pub fn set_folder_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMergeCommit`.
    ///
    /// <p>Returns information about a specified merge commit.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMergeCommit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_merge_commit_input::Builder,
    }
    impl GetMergeCommit {
        /// Creates a new `GetMergeCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMergeCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMergeCommitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMergeConflicts`.
    ///
    /// <p>Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMergeConflicts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_merge_conflicts_input::Builder,
    }
    impl GetMergeConflicts {
        /// Creates a new `GetMergeConflicts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMergeConflictsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMergeConflictsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetMergeConflictsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetMergeConflictsPaginator {
            crate::paginator::GetMergeConflictsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code. </p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code. </p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn max_conflict_files(mut self, input: i32) -> Self {
            self.inner = self.inner.max_conflict_files(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn set_max_conflict_files(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_conflict_files(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMergeOptions`.
    ///
    /// <p>Returns information about the merge options available for merging two specified branches. For details about why a merge option is not available, use GetMergeConflicts or DescribeMergeConflicts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMergeOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_merge_options_input::Builder,
    }
    impl GetMergeOptions {
        /// Creates a new `GetMergeOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMergeOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMergeOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPullRequest`.
    ///
    /// <p>Gets information about a pull request in a specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPullRequest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_pull_request_input::Builder,
    }
    impl GetPullRequest {
        /// Creates a new `GetPullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPullRequestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPullRequestApprovalStates`.
    ///
    /// <p>Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more approval rules applied to them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPullRequestApprovalStates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_pull_request_approval_states_input::Builder,
    }
    impl GetPullRequestApprovalStates {
        /// Creates a new `GetPullRequestApprovalStates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPullRequestApprovalStatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPullRequestApprovalStatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID for the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID for the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID for the pull request revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The system-generated ID for the pull request revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPullRequestOverrideState`.
    ///
    /// <p>Returns information about whether approval rules have been set aside (overridden) for a pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPullRequestOverrideState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_pull_request_override_state_input::Builder,
    }
    impl GetPullRequestOverrideState {
        /// Creates a new `GetPullRequestOverrideState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPullRequestOverrideStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPullRequestOverrideStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <code>GetPullRequest</code>.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <code>GetPullRequest</code>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepository`.
    ///
    /// <p>Returns information about a repository.</p> <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_repository_input::Builder,
    }
    impl GetRepository {
        /// Creates a new `GetRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to get information about.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to get information about.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryTriggers`.
    ///
    /// <p>Gets information about triggers configured for a repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRepositoryTriggers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_repository_triggers_input::Builder,
    }
    impl GetRepositoryTriggers {
        /// Creates a new `GetRepositoryTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryTriggersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository for which the trigger is configured.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository for which the trigger is configured.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApprovalRuleTemplates`.
    ///
    /// <p>Lists all approval rule templates in the specified AWS Region in your AWS account. If an AWS Region is not specified, the AWS Region where you are signed in is used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApprovalRuleTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_approval_rule_templates_input::Builder,
    }
    impl ListApprovalRuleTemplates {
        /// Creates a new `ListApprovalRuleTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApprovalRuleTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApprovalRuleTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApprovalRuleTemplatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApprovalRuleTemplatesPaginator {
            crate::paginator::ListApprovalRuleTemplatesPaginator::new(self.handle, self.inner)
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedApprovalRuleTemplatesForRepository`.
    ///
    /// <p>Lists all approval rule templates that are associated with a specified repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociatedApprovalRuleTemplatesForRepository {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_associated_approval_rule_templates_for_repository_input::Builder,
    }
    impl ListAssociatedApprovalRuleTemplatesForRepository {
        /// Creates a new `ListAssociatedApprovalRuleTemplatesForRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAssociatedApprovalRuleTemplatesForRepositoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListAssociatedApprovalRuleTemplatesForRepositoryPaginator {
            crate::paginator::ListAssociatedApprovalRuleTemplatesForRepositoryPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBranches`.
    ///
    /// <p>Gets information about one or more branches in a repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBranches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_branches_input::Builder,
    }
    impl ListBranches {
        /// Creates a new `ListBranches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBranchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBranchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBranchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBranchesPaginator {
            crate::paginator::ListBranchesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the repository that contains the branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository that contains the branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPullRequests`.
    ///
    /// <p>Returns a list of pull requests for a specified repository. The return list can be refined by pull request status or pull request author ARN.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPullRequests {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_pull_requests_input::Builder,
    }
    impl ListPullRequests {
        /// Creates a new `ListPullRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPullRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPullRequestsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPullRequestsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPullRequestsPaginator {
            crate::paginator::ListPullRequestsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the repository for which you want to list pull requests.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository for which you want to list pull requests.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>
        pub fn author_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_arn(input.into());
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>
        pub fn set_author_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_arn(input);
            self
        }
        /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
        pub fn pull_request_status(mut self, input: crate::model::PullRequestStatusEnum) -> Self {
            self.inner = self.inner.pull_request_status(input);
            self
        }
        /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_status(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositories`.
    ///
    /// <p>Gets information about one or more repositories.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRepositories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_repositories_input::Builder,
    }
    impl ListRepositories {
        /// Creates a new `ListRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRepositoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRepositoriesPaginator {
            crate::paginator::ListRepositoriesPaginator::new(self.handle, self.inner)
        }
        /// <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria used to sort the results of a list repositories operation.</p>
        pub fn sort_by(mut self, input: crate::model::SortByEnum) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The criteria used to sort the results of a list repositories operation.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::SortByEnum>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The order in which to sort the results of a list repositories operation.</p>
        pub fn order(mut self, input: crate::model::OrderEnum) -> Self {
            self.inner = self.inner.order(input);
            self
        }
        /// <p>The order in which to sort the results of a list repositories operation.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderEnum>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositoriesForApprovalRuleTemplate`.
    ///
    /// <p>Lists all repositories associated with the specified approval rule template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRepositoriesForApprovalRuleTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_repositories_for_approval_rule_template_input::Builder,
    }
    impl ListRepositoriesForApprovalRuleTemplate {
        /// Creates a new `ListRepositoriesForApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesForApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListRepositoriesForApprovalRuleTemplateError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRepositoriesForApprovalRuleTemplatePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRepositoriesForApprovalRuleTemplatePaginator {
            crate::paginator::ListRepositoriesForApprovalRuleTemplatePaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the<i> AWS CodeCommit User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeBranchesByFastForward`.
    ///
    /// <p>Merges two branches using the fast-forward merge strategy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergeBranchesByFastForward {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_branches_by_fast_forward_input::Builder,
    }
    impl MergeBranchesByFastForward {
        /// Creates a new `MergeBranchesByFastForward`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeBranchesByFastForwardOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeBranchesByFastForwardError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch where the merge is applied.</p>
        pub fn target_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_branch(input.into());
            self
        }
        /// <p>The branch where the merge is applied.</p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_branch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeBranchesBySquash`.
    ///
    /// <p>Merges two branches using the squash merge strategy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergeBranchesBySquash {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_branches_by_squash_input::Builder,
    }
    impl MergeBranchesBySquash {
        /// Creates a new `MergeBranchesBySquash`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeBranchesBySquashOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeBranchesBySquashError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn target_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_branch(input.into());
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_branch(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>The commit message for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeBranchesByThreeWay`.
    ///
    /// <p>Merges two specified branches using the three-way merge strategy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergeBranchesByThreeWay {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_branches_by_three_way_input::Builder,
    }
    impl MergeBranchesByThreeWay {
        /// Creates a new `MergeBranchesByThreeWay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeBranchesByThreeWayOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeBranchesByThreeWayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.destination_commit_specifier(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn target_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_branch(input.into());
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_branch(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergePullRequestByFastForward`.
    ///
    /// <p>Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergePullRequestByFastForward {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_pull_request_by_fast_forward_input::Builder,
    }
    impl MergePullRequestByFastForward {
        /// Creates a new `MergePullRequestByFastForward`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergePullRequestByFastForwardOutput,
            aws_smithy_http::result::SdkError<crate::error::MergePullRequestByFastForwardError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergePullRequestBySquash`.
    ///
    /// <p>Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergePullRequestBySquash {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_pull_request_by_squash_input::Builder,
    }
    impl MergePullRequestBySquash {
        /// Creates a new `MergePullRequestBySquash`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergePullRequestBySquashOutput,
            aws_smithy_http::result::SdkError<crate::error::MergePullRequestBySquashError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_id(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergePullRequestByThreeWay`.
    ///
    /// <p>Attempts to merge the source commit of a pull request into the specified destination branch for that pull request at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergePullRequestByThreeWay {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_pull_request_by_three_way_input::Builder,
    }
    impl MergePullRequestByThreeWay {
        /// Creates a new `MergePullRequestByThreeWay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergePullRequestByThreeWayOutput,
            aws_smithy_http::result::SdkError<crate::error::MergePullRequestByThreeWayError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_id(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `OverridePullRequestApprovalRules`.
    ///
    /// <p>Sets aside (overrides) all approval rule requirements for a specified pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct OverridePullRequestApprovalRules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::override_pull_request_approval_rules_input::Builder,
    }
    impl OverridePullRequestApprovalRules {
        /// Creates a new `OverridePullRequestApprovalRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::OverridePullRequestApprovalRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::OverridePullRequestApprovalRulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <code>GetPullRequest</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <code>GetPullRequest</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>
        pub fn override_status(mut self, input: crate::model::OverrideStatus) -> Self {
            self.inner = self.inner.override_status(input);
            self
        }
        /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>
        pub fn set_override_status(
            mut self,
            input: std::option::Option<crate::model::OverrideStatus>,
        ) -> Self {
            self.inner = self.inner.set_override_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostCommentForComparedCommit`.
    ///
    /// <p>Posts a comment on the comparison between two commits.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PostCommentForComparedCommit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::post_comment_for_compared_commit_input::Builder,
    }
    impl PostCommentForComparedCommit {
        /// Creates a new `PostCommentForComparedCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostCommentForComparedCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::PostCommentForComparedCommitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>The location of the comparison where you want to comment.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The location of the comparison where you want to comment.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The content of the comment you want to make.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the comment you want to make.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostCommentForPullRequest`.
    ///
    /// <p>Posts a comment on a pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PostCommentForPullRequest {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::post_comment_for_pull_request_input::Builder,
    }
    impl PostCommentForPullRequest {
        /// Creates a new `PostCommentForPullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostCommentForPullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::PostCommentForPullRequestError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where you want to post a comment on a pull request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to post a comment on a pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.inner = self.inner.location(input);
            self
        }
        /// <p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The content of your comment on the change.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of your comment on the change.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostCommentReply`.
    ///
    /// <p>Posts a comment in reply to an existing comment on a comparison between commits or a pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PostCommentReply {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::post_comment_reply_input::Builder,
    }
    impl PostCommentReply {
        /// Creates a new `PostCommentReply`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostCommentReplyOutput,
            aws_smithy_http::result::SdkError<crate::error::PostCommentReplyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn in_reply_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.in_reply_to(input.into());
            self
        }
        /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_in_reply_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_in_reply_to(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The contents of your reply to a comment.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The contents of your reply to a comment.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutCommentReaction`.
    ///
    /// <p>Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutCommentReaction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_comment_reaction_input::Builder,
    }
    impl PutCommentReaction {
        /// Creates a new `PutCommentReaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutCommentReactionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutCommentReactionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the comment to which you want to add or update a reaction.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(input.into());
            self
        }
        /// <p>The ID of the comment to which you want to add or update a reaction.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
        /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
        pub fn reaction_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reaction_value(input.into());
            self
        }
        /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
        pub fn set_reaction_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reaction_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFile`.
    ///
    /// <p>Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_file_input::Builder,
    }
    impl PutFile {
        /// Creates a new `PutFile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFileOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to add or update the file.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to add or update the file.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(input.into());
            self
        }
        /// <p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The content of the file, in binary object format. </p>
        pub fn file_content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.file_content(input);
            self
        }
        /// <p>The content of the file, in binary object format. </p>
        pub fn set_file_content(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_file_content(input);
            self
        }
        /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note>
        /// <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p>
        /// </note>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(input.into());
            self
        }
        /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note>
        /// <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p>
        /// </note>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
        /// <p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.inner = self.inner.file_mode(input);
            self
        }
        /// <p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_file_mode(input);
            self
        }
        /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
        /// <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>
        pub fn parent_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_commit_id(input.into());
            self
        }
        /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
        /// <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_commit_id(input);
            self
        }
        /// <p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(input.into());
            self
        }
        /// <p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An email address for the person adding or updating the file.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(input.into());
            self
        }
        /// <p>An email address for the person adding or updating the file.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRepositoryTriggers`.
    ///
    /// <p>Replaces all triggers for a repository. Used to create or delete triggers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRepositoryTriggers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_repository_triggers_input::Builder,
    }
    impl PutRepositoryTriggers {
        /// Creates a new `PutRepositoryTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRepositoryTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRepositoryTriggersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to create or update the trigger.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository where you want to create or update the trigger.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn triggers(mut self, input: crate::model::RepositoryTrigger) -> Self {
            self.inner = self.inner.triggers(input);
            self
        }
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair to use when tagging this repository.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value pair to use when tagging this repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestRepositoryTriggers`.
    ///
    /// <p>Tests the functionality of repository triggers by sending information to the trigger target. If real data is available in the repository, the test sends data from the last commit. If no data is available, sample data is generated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestRepositoryTriggers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_repository_triggers_input::Builder,
    }
    impl TestRepositoryTriggers {
        /// Creates a new `TestRepositoryTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestRepositoryTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::TestRepositoryTriggersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository in which to test the triggers.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository in which to test the triggers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The list of triggers to test.</p>
        pub fn triggers(mut self, input: crate::model::RepositoryTrigger) -> Self {
            self.inner = self.inner.triggers(input);
            self
        }
        /// <p>The list of triggers to test.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApprovalRuleTemplateContent`.
    ///
    /// <p>Updates the content of an approval rule template. You can change the number of required approvals, the membership of the approval rule, and whether an approval pool is defined.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApprovalRuleTemplateContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_approval_rule_template_content_input::Builder,
    }
    impl UpdateApprovalRuleTemplateContent {
        /// Creates a new `UpdateApprovalRuleTemplateContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApprovalRuleTemplateContentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApprovalRuleTemplateContentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>
        pub fn new_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_rule_content(input.into());
            self
        }
        /// <p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>
        pub fn set_new_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_rule_content(input);
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn existing_rule_content_sha256(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.existing_rule_content_sha256(input.into());
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn set_existing_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_existing_rule_content_sha256(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApprovalRuleTemplateDescription`.
    ///
    /// <p>Updates the description for a specified approval rule template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApprovalRuleTemplateDescription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_approval_rule_template_description_input::Builder,
    }
    impl UpdateApprovalRuleTemplateDescription {
        /// Creates a new `UpdateApprovalRuleTemplateDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApprovalRuleTemplateDescriptionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateApprovalRuleTemplateDescriptionError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template for which you want to update the description.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_name(input.into());
            self
        }
        /// <p>The name of the template for which you want to update the description.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The updated description of the approval rule template.</p>
        pub fn approval_rule_template_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_description(input.into());
            self
        }
        /// <p>The updated description of the approval rule template.</p>
        pub fn set_approval_rule_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApprovalRuleTemplateName`.
    ///
    /// <p>Updates the name of a specified approval rule template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApprovalRuleTemplateName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_approval_rule_template_name_input::Builder,
    }
    impl UpdateApprovalRuleTemplateName {
        /// Creates a new `UpdateApprovalRuleTemplateName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApprovalRuleTemplateNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApprovalRuleTemplateNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current name of the approval rule template.</p>
        pub fn old_approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.old_approval_rule_template_name(input.into());
            self
        }
        /// <p>The current name of the approval rule template.</p>
        pub fn set_old_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_old_approval_rule_template_name(input);
            self
        }
        /// <p>The new name you want to apply to the approval rule template.</p>
        pub fn new_approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.new_approval_rule_template_name(input.into());
            self
        }
        /// <p>The new name you want to apply to the approval rule template.</p>
        pub fn set_new_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_approval_rule_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComment`.
    ///
    /// <p>Replaces the contents of a comment.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateComment {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_comment_input::Builder,
    }
    impl UpdateComment {
        /// Creates a new `UpdateComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCommentError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the comment you want to update. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(input.into());
            self
        }
        /// <p>The system-generated ID of the comment you want to update. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
        /// <p>The updated content to replace the existing content of the comment.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The updated content to replace the existing content of the comment.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDefaultBranch`.
    ///
    /// <p>Sets or changes the default branch name for the specified repository.</p> <note>
    /// <p>If you use this operation to change the default branch name to the current default branch name, a success message is returned even though the default branch did not change.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDefaultBranch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_default_branch_input::Builder,
    }
    impl UpdateDefaultBranch {
        /// Creates a new `UpdateDefaultBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDefaultBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDefaultBranchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to set or change the default branch for.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to set or change the default branch for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch to set as the default.</p>
        pub fn default_branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_branch_name(input.into());
            self
        }
        /// <p>The name of the branch to set as the default.</p>
        pub fn set_default_branch_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestApprovalRuleContent`.
    ///
    /// <p>Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and the approval pool for approvers. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePullRequestApprovalRuleContent {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pull_request_approval_rule_content_input::Builder,
    }
    impl UpdatePullRequestApprovalRuleContent {
        /// Creates a new `UpdatePullRequestApprovalRuleContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestApprovalRuleContentOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdatePullRequestApprovalRuleContentError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the approval rule you want to update.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_name(input.into());
            self
        }
        /// <p>The name of the approval rule you want to update.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_name(input);
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn existing_rule_content_sha256(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.existing_rule_content_sha256(input.into());
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn set_existing_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_existing_rule_content_sha256(input);
            self
        }
        /// <p>The updated content for the approval rule.</p> <note>
        /// <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn new_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_rule_content(input.into());
            self
        }
        /// <p>The updated content for the approval rule.</p> <note>
        /// <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn set_new_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_rule_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestApprovalState`.
    ///
    /// <p>Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the request is made.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePullRequestApprovalState {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pull_request_approval_state_input::Builder,
    }
    impl UpdatePullRequestApprovalState {
        /// Creates a new `UpdatePullRequestApprovalState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestApprovalStateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestApprovalStateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID of the revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(input.into());
            self
        }
        /// <p>The system-generated ID of the revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>The approval state to associate with the user on the pull request.</p>
        pub fn approval_state(mut self, input: crate::model::ApprovalState) -> Self {
            self.inner = self.inner.approval_state(input);
            self
        }
        /// <p>The approval state to associate with the user on the pull request.</p>
        pub fn set_approval_state(
            mut self,
            input: std::option::Option<crate::model::ApprovalState>,
        ) -> Self {
            self.inner = self.inner.set_approval_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestDescription`.
    ///
    /// <p>Replaces the contents of the description of a pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePullRequestDescription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pull_request_description_input::Builder,
    }
    impl UpdatePullRequestDescription {
        /// Creates a new `UpdatePullRequestDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestDescriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestDescriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The updated content of the description for the pull request. This content replaces the existing description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The updated content of the description for the pull request. This content replaces the existing description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestStatus`.
    ///
    /// <p>Updates the status of a pull request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePullRequestStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pull_request_status_input::Builder,
    }
    impl UpdatePullRequestStatus {
        /// Creates a new `UpdatePullRequestStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>
        pub fn pull_request_status(mut self, input: crate::model::PullRequestStatusEnum) -> Self {
            self.inner = self.inner.pull_request_status(input);
            self
        }
        /// <p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestTitle`.
    ///
    /// <p>Replaces the title of a pull request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePullRequestTitle {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_pull_request_title_input::Builder,
    }
    impl UpdatePullRequestTitle {
        /// Creates a new `UpdatePullRequestTitle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestTitleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestTitleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The updated title of the pull request. This replaces the existing title.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(input.into());
            self
        }
        /// <p>The updated title of the pull request. This replaces the existing title.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRepositoryDescription`.
    ///
    /// <p>Sets or changes the comment or description for a repository.</p> <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRepositoryDescription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_repository_description_input::Builder,
    }
    impl UpdateRepositoryDescription {
        /// Creates a new `UpdateRepositoryDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRepositoryDescriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryDescriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to set or change the comment or description for.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(input.into());
            self
        }
        /// <p>The name of the repository to set or change the comment or description for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
        pub fn repository_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_description(input.into());
            self
        }
        /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
        pub fn set_repository_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRepositoryName`.
    ///
    /// <p>Renames a repository. The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. The suffix .git is prohibited. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the AWS CodeCommit User Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRepositoryName {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_repository_name_input::Builder,
    }
    impl UpdateRepositoryName {
        /// Creates a new `UpdateRepositoryName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRepositoryNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryNameError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current name of the repository.</p>
        pub fn old_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.old_name(input.into());
            self
        }
        /// <p>The current name of the repository.</p>
        pub fn set_old_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_old_name(input);
            self
        }
        /// <p>The new name for the repository.</p>
        pub fn new_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_name(input.into());
            self
        }
        /// <p>The new name for the repository.</p>
        pub fn set_new_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_new_name(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
