// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateApprovalRuleTemplateWithRepositoryInput`](crate::input::AssociateApprovalRuleTemplateWithRepositoryInput)
pub mod associate_approval_rule_template_with_repository_input {
    /// A builder for [`AssociateApprovalRuleTemplateWithRepositoryInput`](crate::input::AssociateApprovalRuleTemplateWithRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the approval rule template. </p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name for the approval rule template. </p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// <p>The name of the repository that you want to associate with the template.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that you want to associate with the template.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateApprovalRuleTemplateWithRepositoryInput`](crate::input::AssociateApprovalRuleTemplateWithRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateApprovalRuleTemplateWithRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::AssociateApprovalRuleTemplateWithRepositoryInput {
                    approval_rule_template_name: self.approval_rule_template_name,
                    repository_name: self.repository_name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type AssociateApprovalRuleTemplateWithRepositoryInputOperationOutputAlias =
    crate::operation::AssociateApprovalRuleTemplateWithRepository;
#[doc(hidden)]
pub type AssociateApprovalRuleTemplateWithRepositoryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateApprovalRuleTemplateWithRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`AssociateApprovalRuleTemplateWithRepository`](crate::operation::AssociateApprovalRuleTemplateWithRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateApprovalRuleTemplateWithRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateApprovalRuleTemplateWithRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateApprovalRuleTemplateWithRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateApprovalRuleTemplateWithRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.AssociateApprovalRuleTemplateWithRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_approval_rule_template_with_repository(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateApprovalRuleTemplateWithRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateApprovalRuleTemplateWithRepository",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateApprovalRuleTemplateWithRepositoryInput`](crate::input::AssociateApprovalRuleTemplateWithRepositoryInput)
    pub fn builder() -> crate::input::associate_approval_rule_template_with_repository_input::Builder
    {
        crate::input::associate_approval_rule_template_with_repository_input::Builder::default()
    }
}

/// See [`BatchAssociateApprovalRuleTemplateWithRepositoriesInput`](crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput)
pub mod batch_associate_approval_rule_template_with_repositories_input {
    /// A builder for [`BatchAssociateApprovalRuleTemplateWithRepositoriesInput`](crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the template you want to associate with one or more repositories.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the template you want to associate with one or more repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// Appends an item to `repository_names`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The names of the repositories you want to associate with the template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repository_names.unwrap_or_default();
            v.push(input.into());
            self.repository_names = Some(v);
            self
        }
        /// <p>The names of the repositories you want to associate with the template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repository_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateApprovalRuleTemplateWithRepositoriesInput`](crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput {
                    approval_rule_template_name: self.approval_rule_template_name,
                    repository_names: self.repository_names,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchAssociateApprovalRuleTemplateWithRepositoriesInputOperationOutputAlias =
    crate::operation::BatchAssociateApprovalRuleTemplateWithRepositories;
#[doc(hidden)]
pub type BatchAssociateApprovalRuleTemplateWithRepositoriesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchAssociateApprovalRuleTemplateWithRepositoriesInput {
    /// Consumes the builder and constructs an Operation<[`BatchAssociateApprovalRuleTemplateWithRepositories`](crate::operation::BatchAssociateApprovalRuleTemplateWithRepositories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchAssociateApprovalRuleTemplateWithRepositories,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.BatchAssociateApprovalRuleTemplateWithRepositories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_associate_approval_rule_template_with_repositories(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchAssociateApprovalRuleTemplateWithRepositories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchAssociateApprovalRuleTemplateWithRepositories",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchAssociateApprovalRuleTemplateWithRepositoriesInput`](crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInput)
    pub fn builder(
    ) -> crate::input::batch_associate_approval_rule_template_with_repositories_input::Builder {
        crate::input::batch_associate_approval_rule_template_with_repositories_input::Builder::default()
    }
}

/// See [`BatchDescribeMergeConflictsInput`](crate::input::BatchDescribeMergeConflictsInput)
pub mod batch_describe_merge_conflicts_input {
    /// A builder for [`BatchDescribeMergeConflictsInput`](crate::input::BatchDescribeMergeConflictsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
        pub(crate) max_merge_hunks: std::option::Option<i32>,
        pub(crate) max_conflict_files: std::option::Option<i32>,
        pub(crate) file_paths: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.merge_option = Some(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.merge_option = input;
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn max_merge_hunks(mut self, input: i32) -> Self {
            self.max_merge_hunks = Some(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn set_max_merge_hunks(mut self, input: std::option::Option<i32>) -> Self {
            self.max_merge_hunks = input;
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn max_conflict_files(mut self, input: i32) -> Self {
            self.max_conflict_files = Some(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn set_max_conflict_files(mut self, input: std::option::Option<i32>) -> Self {
            self.max_conflict_files = input;
            self
        }
        /// Appends an item to `file_paths`.
        ///
        /// To override the contents of this collection use [`set_file_paths`](Self::set_file_paths).
        ///
        /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
        pub fn file_paths(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.file_paths.unwrap_or_default();
            v.push(input.into());
            self.file_paths = Some(v);
            self
        }
        /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
        pub fn set_file_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.file_paths = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeMergeConflictsInput`](crate::input::BatchDescribeMergeConflictsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDescribeMergeConflictsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDescribeMergeConflictsInput {
                repository_name: self.repository_name,
                destination_commit_specifier: self.destination_commit_specifier,
                source_commit_specifier: self.source_commit_specifier,
                merge_option: self.merge_option,
                max_merge_hunks: self.max_merge_hunks,
                max_conflict_files: self.max_conflict_files,
                file_paths: self.file_paths,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDescribeMergeConflictsInputOperationOutputAlias =
    crate::operation::BatchDescribeMergeConflicts;
#[doc(hidden)]
pub type BatchDescribeMergeConflictsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDescribeMergeConflictsInput {
    /// Consumes the builder and constructs an Operation<[`BatchDescribeMergeConflicts`](crate::operation::BatchDescribeMergeConflicts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDescribeMergeConflicts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDescribeMergeConflictsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDescribeMergeConflictsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDescribeMergeConflictsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.BatchDescribeMergeConflicts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_describe_merge_conflicts(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDescribeMergeConflicts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDescribeMergeConflicts",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDescribeMergeConflictsInput`](crate::input::BatchDescribeMergeConflictsInput)
    pub fn builder() -> crate::input::batch_describe_merge_conflicts_input::Builder {
        crate::input::batch_describe_merge_conflicts_input::Builder::default()
    }
}

/// See [`BatchDisassociateApprovalRuleTemplateFromRepositoriesInput`](crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput)
pub mod batch_disassociate_approval_rule_template_from_repositories_input {
    /// A builder for [`BatchDisassociateApprovalRuleTemplateFromRepositoriesInput`](crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// Appends an item to `repository_names`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The repository names that you want to disassociate from the approval rule template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repository_names.unwrap_or_default();
            v.push(input.into());
            self.repository_names = Some(v);
            self
        }
        /// <p>The repository names that you want to disassociate from the approval rule template.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repository_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateApprovalRuleTemplateFromRepositoriesInput`](crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput {
                    approval_rule_template_name: self.approval_rule_template_name,
                    repository_names: self.repository_names,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type BatchDisassociateApprovalRuleTemplateFromRepositoriesInputOperationOutputAlias =
    crate::operation::BatchDisassociateApprovalRuleTemplateFromRepositories;
#[doc(hidden)]
pub type BatchDisassociateApprovalRuleTemplateFromRepositoriesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchDisassociateApprovalRuleTemplateFromRepositoriesInput {
    /// Consumes the builder and constructs an Operation<[`BatchDisassociateApprovalRuleTemplateFromRepositories`](crate::operation::BatchDisassociateApprovalRuleTemplateFromRepositories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDisassociateApprovalRuleTemplateFromRepositories,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.BatchDisassociateApprovalRuleTemplateFromRepositories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_disassociate_approval_rule_template_from_repositories(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDisassociateApprovalRuleTemplateFromRepositories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDisassociateApprovalRuleTemplateFromRepositories",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchDisassociateApprovalRuleTemplateFromRepositoriesInput`](crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInput)
    pub fn builder(
    ) -> crate::input::batch_disassociate_approval_rule_template_from_repositories_input::Builder
    {
        crate::input::batch_disassociate_approval_rule_template_from_repositories_input::Builder::default()
    }
}

/// See [`BatchGetCommitsInput`](crate::input::BatchGetCommitsInput)
pub mod batch_get_commits_input {
    /// A builder for [`BatchGetCommitsInput`](crate::input::BatchGetCommitsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `commit_ids`.
        ///
        /// To override the contents of this collection use [`set_commit_ids`](Self::set_commit_ids).
        ///
        /// <p>The full commit IDs of the commits to get information about.</p> <note>
        /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p>
        /// </note>
        pub fn commit_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.commit_ids.unwrap_or_default();
            v.push(input.into());
            self.commit_ids = Some(v);
            self
        }
        /// <p>The full commit IDs of the commits to get information about.</p> <note>
        /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p>
        /// </note>
        pub fn set_commit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.commit_ids = input;
            self
        }
        /// <p>The name of the repository that contains the commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetCommitsInput`](crate::input::BatchGetCommitsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetCommitsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetCommitsInput {
                commit_ids: self.commit_ids,
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetCommitsInputOperationOutputAlias = crate::operation::BatchGetCommits;
#[doc(hidden)]
pub type BatchGetCommitsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetCommitsInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetCommits`](crate::operation::BatchGetCommits)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetCommits,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetCommitsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetCommitsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetCommitsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.BatchGetCommits",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_commits(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetCommits::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetCommits",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetCommitsInput`](crate::input::BatchGetCommitsInput)
    pub fn builder() -> crate::input::batch_get_commits_input::Builder {
        crate::input::batch_get_commits_input::Builder::default()
    }
}

/// See [`BatchGetRepositoriesInput`](crate::input::BatchGetRepositoriesInput)
pub mod batch_get_repositories_input {
    /// A builder for [`BatchGetRepositoriesInput`](crate::input::BatchGetRepositoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `repository_names`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The names of the repositories to get information about.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repository_names.unwrap_or_default();
            v.push(input.into());
            self.repository_names = Some(v);
            self
        }
        /// <p>The names of the repositories to get information about.</p> <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repository_names = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetRepositoriesInput`](crate::input::BatchGetRepositoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetRepositoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetRepositoriesInput {
                repository_names: self.repository_names,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetRepositoriesInputOperationOutputAlias = crate::operation::BatchGetRepositories;
#[doc(hidden)]
pub type BatchGetRepositoriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetRepositoriesInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetRepositories`](crate::operation::BatchGetRepositories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetRepositories,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetRepositoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetRepositoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetRepositoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.BatchGetRepositories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_repositories(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetRepositories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetRepositories",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetRepositoriesInput`](crate::input::BatchGetRepositoriesInput)
    pub fn builder() -> crate::input::batch_get_repositories_input::Builder {
        crate::input::batch_get_repositories_input::Builder::default()
    }
}

/// See [`CreateApprovalRuleTemplateInput`](crate::input::CreateApprovalRuleTemplateInput)
pub mod create_approval_rule_template_input {
    /// A builder for [`CreateApprovalRuleTemplateInput`](crate::input::CreateApprovalRuleTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) approval_rule_template_content: std::option::Option<std::string::String>,
        pub(crate) approval_rule_template_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// <p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note>
        /// <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn approval_rule_template_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_content = Some(input.into());
            self
        }
        /// <p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note>
        /// <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn set_approval_rule_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_content = input;
            self
        }
        /// <p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>
        pub fn approval_rule_template_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_description = Some(input.into());
            self
        }
        /// <p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>
        pub fn set_approval_rule_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApprovalRuleTemplateInput`](crate::input::CreateApprovalRuleTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateApprovalRuleTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateApprovalRuleTemplateInput {
                approval_rule_template_name: self.approval_rule_template_name,
                approval_rule_template_content: self.approval_rule_template_content,
                approval_rule_template_description: self.approval_rule_template_description,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateApprovalRuleTemplateInputOperationOutputAlias =
    crate::operation::CreateApprovalRuleTemplate;
#[doc(hidden)]
pub type CreateApprovalRuleTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateApprovalRuleTemplateInput {
    /// Consumes the builder and constructs an Operation<[`CreateApprovalRuleTemplate`](crate::operation::CreateApprovalRuleTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateApprovalRuleTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateApprovalRuleTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateApprovalRuleTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateApprovalRuleTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.CreateApprovalRuleTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_approval_rule_template(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateApprovalRuleTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateApprovalRuleTemplate",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateApprovalRuleTemplateInput`](crate::input::CreateApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::create_approval_rule_template_input::Builder {
        crate::input::create_approval_rule_template_input::Builder::default()
    }
}

/// See [`CreateBranchInput`](crate::input::CreateBranchInput)
pub mod create_branch_input {
    /// A builder for [`CreateBranchInput`](crate::input::CreateBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository in which you want to create the new branch.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository in which you want to create the new branch.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the new branch to create.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the new branch to create.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p>The ID of the commit to point the new branch to.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The ID of the commit to point the new branch to.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBranchInput`](crate::input::CreateBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBranchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBranchInput {
                repository_name: self.repository_name,
                branch_name: self.branch_name,
                commit_id: self.commit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBranchInputOperationOutputAlias = crate::operation::CreateBranch;
#[doc(hidden)]
pub type CreateBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBranchInput {
    /// Consumes the builder and constructs an Operation<[`CreateBranch`](crate::operation::CreateBranch)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBranchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBranchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBranchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.CreateBranch",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_branch(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBranch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBranch",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBranchInput`](crate::input::CreateBranchInput)
    pub fn builder() -> crate::input::create_branch_input::Builder {
        crate::input::create_branch_input::Builder::default()
    }
}

/// See [`CreateCommitInput`](crate::input::CreateCommitInput)
pub mod create_commit_input {
    /// A builder for [`CreateCommitInput`](crate::input::CreateCommitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) parent_commit_id: std::option::Option<std::string::String>,
        pub(crate) author_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) keep_empty_folders: std::option::Option<bool>,
        pub(crate) put_files: std::option::Option<std::vec::Vec<crate::model::PutFileEntry>>,
        pub(crate) delete_files: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
        pub(crate) set_file_modes:
            std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
    }
    impl Builder {
        /// <p>The name of the repository where you create the commit.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you create the commit.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the branch where you create the commit.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the branch where you create the commit.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>
        pub fn parent_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_commit_id = Some(input.into());
            self
        }
        /// <p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_commit_id = input;
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_name = Some(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_name = input;
            self
        }
        /// <p>The email address of the person who created the commit.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the person who created the commit.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.keep_empty_folders = Some(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.keep_empty_folders = input;
            self
        }
        /// Appends an item to `put_files`.
        ///
        /// To override the contents of this collection use [`set_put_files`](Self::set_put_files).
        ///
        /// <p>The files to add or update in this commit.</p>
        pub fn put_files(mut self, input: crate::model::PutFileEntry) -> Self {
            let mut v = self.put_files.unwrap_or_default();
            v.push(input);
            self.put_files = Some(v);
            self
        }
        /// <p>The files to add or update in this commit.</p>
        pub fn set_put_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutFileEntry>>,
        ) -> Self {
            self.put_files = input;
            self
        }
        /// Appends an item to `delete_files`.
        ///
        /// To override the contents of this collection use [`set_delete_files`](Self::set_delete_files).
        ///
        /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
        pub fn delete_files(mut self, input: crate::model::DeleteFileEntry) -> Self {
            let mut v = self.delete_files.unwrap_or_default();
            v.push(input);
            self.delete_files = Some(v);
            self
        }
        /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
        pub fn set_delete_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
        ) -> Self {
            self.delete_files = input;
            self
        }
        /// Appends an item to `set_file_modes`.
        ///
        /// To override the contents of this collection use [`set_set_file_modes`](Self::set_set_file_modes).
        ///
        /// <p>The file modes to update for files in this commit.</p>
        pub fn set_file_modes(mut self, input: crate::model::SetFileModeEntry) -> Self {
            let mut v = self.set_file_modes.unwrap_or_default();
            v.push(input);
            self.set_file_modes = Some(v);
            self
        }
        /// <p>The file modes to update for files in this commit.</p>
        pub fn set_set_file_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
        ) -> Self {
            self.set_file_modes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCommitInput`](crate::input::CreateCommitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCommitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCommitInput {
                repository_name: self.repository_name,
                branch_name: self.branch_name,
                parent_commit_id: self.parent_commit_id,
                author_name: self.author_name,
                email: self.email,
                commit_message: self.commit_message,
                keep_empty_folders: self.keep_empty_folders.unwrap_or_default(),
                put_files: self.put_files,
                delete_files: self.delete_files,
                set_file_modes: self.set_file_modes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCommitInputOperationOutputAlias = crate::operation::CreateCommit;
#[doc(hidden)]
pub type CreateCommitInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCommitInput {
    /// Consumes the builder and constructs an Operation<[`CreateCommit`](crate::operation::CreateCommit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCommit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCommitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCommitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCommitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.CreateCommit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_commit(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCommit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCommit",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCommitInput`](crate::input::CreateCommitInput)
    pub fn builder() -> crate::input::create_commit_input::Builder {
        crate::input::create_commit_input::Builder::default()
    }
}

/// See [`CreatePullRequestInput`](crate::input::CreatePullRequestInput)
pub mod create_pull_request_input {
    /// A builder for [`CreatePullRequestInput`](crate::input::CreatePullRequestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>A description of the pull request.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the pull request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input);
            self.targets = Some(v);
            self
        }
        /// <p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
        /// </note>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
        /// </note>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePullRequestInput`](crate::input::CreatePullRequestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePullRequestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePullRequestInput {
                title: self.title,
                description: self.description,
                targets: self.targets,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePullRequestInputOperationOutputAlias = crate::operation::CreatePullRequest;
#[doc(hidden)]
pub type CreatePullRequestInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePullRequestInput {
    /// Consumes the builder and constructs an Operation<[`CreatePullRequest`](crate::operation::CreatePullRequest)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePullRequest,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePullRequestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePullRequestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePullRequestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.CreatePullRequest",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_pull_request(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePullRequest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePullRequest",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePullRequestInput`](crate::input::CreatePullRequestInput)
    pub fn builder() -> crate::input::create_pull_request_input::Builder {
        crate::input::create_pull_request_input::Builder::default()
    }
}

/// See [`CreatePullRequestApprovalRuleInput`](crate::input::CreatePullRequestApprovalRuleInput)
pub mod create_pull_request_approval_rule_input {
    /// A builder for [`CreatePullRequestApprovalRuleInput`](crate::input::CreatePullRequestApprovalRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) approval_rule_name: std::option::Option<std::string::String>,
        pub(crate) approval_rule_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name for the approval rule.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_name = Some(input.into());
            self
        }
        /// <p>The name for the approval rule.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_name = input;
            self
        }
        /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note>
        /// <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn approval_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_content = Some(input.into());
            self
        }
        /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note>
        /// <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn set_approval_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_content = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePullRequestApprovalRuleInput`](crate::input::CreatePullRequestApprovalRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePullRequestApprovalRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePullRequestApprovalRuleInput {
                pull_request_id: self.pull_request_id,
                approval_rule_name: self.approval_rule_name,
                approval_rule_content: self.approval_rule_content,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePullRequestApprovalRuleInputOperationOutputAlias =
    crate::operation::CreatePullRequestApprovalRule;
#[doc(hidden)]
pub type CreatePullRequestApprovalRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreatePullRequestApprovalRuleInput {
    /// Consumes the builder and constructs an Operation<[`CreatePullRequestApprovalRule`](crate::operation::CreatePullRequestApprovalRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePullRequestApprovalRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreatePullRequestApprovalRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreatePullRequestApprovalRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreatePullRequestApprovalRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.CreatePullRequestApprovalRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_pull_request_approval_rule(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePullRequestApprovalRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePullRequestApprovalRule",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreatePullRequestApprovalRuleInput`](crate::input::CreatePullRequestApprovalRuleInput)
    pub fn builder() -> crate::input::create_pull_request_approval_rule_input::Builder {
        crate::input::create_pull_request_approval_rule_input::Builder::default()
    }
}

/// See [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
pub mod create_repository_input {
    /// A builder for [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) repository_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the new repository to be created.</p> <note>
        /// <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p>
        /// </note>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the new repository to be created.</p> <note>
        /// <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p>
        /// </note>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>A comment or description about the new repository.</p> <note>
        /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
        /// </note>
        pub fn repository_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_description = Some(input.into());
            self
        }
        /// <p>A comment or description about the new repository.</p> <note>
        /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
        /// </note>
        pub fn set_repository_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRepositoryInput {
                repository_name: self.repository_name,
                repository_description: self.repository_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRepositoryInputOperationOutputAlias = crate::operation::CreateRepository;
#[doc(hidden)]
pub type CreateRepositoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`CreateRepository`](crate::operation::CreateRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.CreateRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_repository(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRepository",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
}

/// See [`CreateUnreferencedMergeCommitInput`](crate::input::CreateUnreferencedMergeCommitInput)
pub mod create_unreferenced_merge_commit_input {
    /// A builder for [`CreateUnreferencedMergeCommitInput`](crate::input::CreateUnreferencedMergeCommitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) author_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) keep_empty_folders: std::option::Option<bool>,
        pub(crate) conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.merge_option = Some(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.merge_option = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_name = Some(input.into());
            self
        }
        /// <p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_name = input;
            self
        }
        /// <p>The email address for the person who created the unreferenced commit.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address for the person who created the unreferenced commit.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The commit message for the unreferenced commit.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>The commit message for the unreferenced commit.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.keep_empty_folders = Some(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.keep_empty_folders = input;
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.conflict_resolution = Some(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.conflict_resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUnreferencedMergeCommitInput`](crate::input::CreateUnreferencedMergeCommitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUnreferencedMergeCommitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUnreferencedMergeCommitInput {
                repository_name: self.repository_name,
                source_commit_specifier: self.source_commit_specifier,
                destination_commit_specifier: self.destination_commit_specifier,
                merge_option: self.merge_option,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                author_name: self.author_name,
                email: self.email,
                commit_message: self.commit_message,
                keep_empty_folders: self.keep_empty_folders.unwrap_or_default(),
                conflict_resolution: self.conflict_resolution,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUnreferencedMergeCommitInputOperationOutputAlias =
    crate::operation::CreateUnreferencedMergeCommit;
#[doc(hidden)]
pub type CreateUnreferencedMergeCommitInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateUnreferencedMergeCommitInput {
    /// Consumes the builder and constructs an Operation<[`CreateUnreferencedMergeCommit`](crate::operation::CreateUnreferencedMergeCommit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUnreferencedMergeCommit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUnreferencedMergeCommitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUnreferencedMergeCommitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUnreferencedMergeCommitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.CreateUnreferencedMergeCommit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_unreferenced_merge_commit(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUnreferencedMergeCommit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUnreferencedMergeCommit",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUnreferencedMergeCommitInput`](crate::input::CreateUnreferencedMergeCommitInput)
    pub fn builder() -> crate::input::create_unreferenced_merge_commit_input::Builder {
        crate::input::create_unreferenced_merge_commit_input::Builder::default()
    }
}

/// See [`DeleteApprovalRuleTemplateInput`](crate::input::DeleteApprovalRuleTemplateInput)
pub mod delete_approval_rule_template_input {
    /// A builder for [`DeleteApprovalRuleTemplateInput`](crate::input::DeleteApprovalRuleTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the approval rule template to delete.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule template to delete.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApprovalRuleTemplateInput`](crate::input::DeleteApprovalRuleTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteApprovalRuleTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteApprovalRuleTemplateInput {
                approval_rule_template_name: self.approval_rule_template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteApprovalRuleTemplateInputOperationOutputAlias =
    crate::operation::DeleteApprovalRuleTemplate;
#[doc(hidden)]
pub type DeleteApprovalRuleTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteApprovalRuleTemplateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteApprovalRuleTemplate`](crate::operation::DeleteApprovalRuleTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteApprovalRuleTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteApprovalRuleTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteApprovalRuleTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteApprovalRuleTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DeleteApprovalRuleTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_approval_rule_template(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteApprovalRuleTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteApprovalRuleTemplate",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteApprovalRuleTemplateInput`](crate::input::DeleteApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::delete_approval_rule_template_input::Builder {
        crate::input::delete_approval_rule_template_input::Builder::default()
    }
}

/// See [`DeleteBranchInput`](crate::input::DeleteBranchInput)
pub mod delete_branch_input {
    /// A builder for [`DeleteBranchInput`](crate::input::DeleteBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the branch to be deleted.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the branch to be deleted.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the branch to delete.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the branch to delete.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBranchInput`](crate::input::DeleteBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBranchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBranchInput {
                repository_name: self.repository_name,
                branch_name: self.branch_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBranchInputOperationOutputAlias = crate::operation::DeleteBranch;
#[doc(hidden)]
pub type DeleteBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBranchInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBranch`](crate::operation::DeleteBranch)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBranchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBranchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBranchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DeleteBranch",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_branch(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBranch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBranch",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBranchInput`](crate::input::DeleteBranchInput)
    pub fn builder() -> crate::input::delete_branch_input::Builder {
        crate::input::delete_branch_input::Builder::default()
    }
}

/// See [`DeleteCommentContentInput`](crate::input::DeleteCommentContentInput)
pub mod delete_comment_content_input {
    /// A builder for [`DeleteCommentContentInput`](crate::input::DeleteCommentContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCommentContentInput`](crate::input::DeleteCommentContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCommentContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCommentContentInput {
                comment_id: self.comment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCommentContentInputOperationOutputAlias = crate::operation::DeleteCommentContent;
#[doc(hidden)]
pub type DeleteCommentContentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCommentContentInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCommentContent`](crate::operation::DeleteCommentContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCommentContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCommentContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCommentContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCommentContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DeleteCommentContent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_comment_content(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCommentContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCommentContent",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCommentContentInput`](crate::input::DeleteCommentContentInput)
    pub fn builder() -> crate::input::delete_comment_content_input::Builder {
        crate::input::delete_comment_content_input::Builder::default()
    }
}

/// See [`DeleteFileInput`](crate::input::DeleteFileInput)
pub mod delete_file_input {
    /// A builder for [`DeleteFileInput`](crate::input::DeleteFileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) parent_commit_id: std::option::Option<std::string::String>,
        pub(crate) keep_empty_folders: std::option::Option<bool>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the file to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the file to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the branch where the commit that deletes the file is made.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the branch where the commit that deletes the file is made.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>
        pub fn parent_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_commit_id = Some(input.into());
            self
        }
        /// <p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_commit_id = input;
            self
        }
        /// <p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.keep_empty_folders = Some(input);
            self
        }
        /// <p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.keep_empty_folders = input;
            self
        }
        /// <p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileInput`](crate::input::DeleteFileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFileInput {
                repository_name: self.repository_name,
                branch_name: self.branch_name,
                file_path: self.file_path,
                parent_commit_id: self.parent_commit_id,
                keep_empty_folders: self.keep_empty_folders.unwrap_or_default(),
                commit_message: self.commit_message,
                name: self.name,
                email: self.email,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFileInputOperationOutputAlias = crate::operation::DeleteFile;
#[doc(hidden)]
pub type DeleteFileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteFileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFile`](crate::operation::DeleteFile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DeleteFile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_file(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFile",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFileInput`](crate::input::DeleteFileInput)
    pub fn builder() -> crate::input::delete_file_input::Builder {
        crate::input::delete_file_input::Builder::default()
    }
}

/// See [`DeletePullRequestApprovalRuleInput`](crate::input::DeletePullRequestApprovalRuleInput)
pub mod delete_pull_request_approval_rule_input {
    /// A builder for [`DeletePullRequestApprovalRuleInput`](crate::input::DeletePullRequestApprovalRuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) approval_rule_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the approval rule you want to delete.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule you want to delete.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePullRequestApprovalRuleInput`](crate::input::DeletePullRequestApprovalRuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePullRequestApprovalRuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePullRequestApprovalRuleInput {
                pull_request_id: self.pull_request_id,
                approval_rule_name: self.approval_rule_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePullRequestApprovalRuleInputOperationOutputAlias =
    crate::operation::DeletePullRequestApprovalRule;
#[doc(hidden)]
pub type DeletePullRequestApprovalRuleInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeletePullRequestApprovalRuleInput {
    /// Consumes the builder and constructs an Operation<[`DeletePullRequestApprovalRule`](crate::operation::DeletePullRequestApprovalRule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePullRequestApprovalRule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePullRequestApprovalRuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePullRequestApprovalRuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePullRequestApprovalRuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DeletePullRequestApprovalRule",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_pull_request_approval_rule(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePullRequestApprovalRule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePullRequestApprovalRule",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePullRequestApprovalRuleInput`](crate::input::DeletePullRequestApprovalRuleInput)
    pub fn builder() -> crate::input::delete_pull_request_approval_rule_input::Builder {
        crate::input::delete_pull_request_approval_rule_input::Builder::default()
    }
}

/// See [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
pub mod delete_repository_input {
    /// A builder for [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRepositoryInput {
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRepositoryInputOperationOutputAlias = crate::operation::DeleteRepository;
#[doc(hidden)]
pub type DeleteRepositoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRepository`](crate::operation::DeleteRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DeleteRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_repository(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRepository",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
}

/// See [`DescribeMergeConflictsInput`](crate::input::DescribeMergeConflictsInput)
pub mod describe_merge_conflicts_input {
    /// A builder for [`DescribeMergeConflictsInput`](crate::input::DescribeMergeConflictsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
        pub(crate) max_merge_hunks: std::option::Option<i32>,
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to get information about a merge conflict.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to get information about a merge conflict.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.merge_option = Some(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.merge_option = input;
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn max_merge_hunks(mut self, input: i32) -> Self {
            self.max_merge_hunks = Some(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn set_max_merge_hunks(mut self, input: std::option::Option<i32>) -> Self {
            self.max_merge_hunks = input;
            self
        }
        /// <p>The path of the target files used to describe the conflicts. </p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The path of the target files used to describe the conflicts. </p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMergeConflictsInput`](crate::input::DescribeMergeConflictsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMergeConflictsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMergeConflictsInput {
                repository_name: self.repository_name,
                destination_commit_specifier: self.destination_commit_specifier,
                source_commit_specifier: self.source_commit_specifier,
                merge_option: self.merge_option,
                max_merge_hunks: self.max_merge_hunks,
                file_path: self.file_path,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMergeConflictsInputOperationOutputAlias = crate::operation::DescribeMergeConflicts;
#[doc(hidden)]
pub type DescribeMergeConflictsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMergeConflictsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMergeConflicts`](crate::operation::DescribeMergeConflicts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMergeConflicts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMergeConflictsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMergeConflictsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMergeConflictsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DescribeMergeConflicts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_merge_conflicts(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMergeConflicts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMergeConflicts",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMergeConflictsInput`](crate::input::DescribeMergeConflictsInput)
    pub fn builder() -> crate::input::describe_merge_conflicts_input::Builder {
        crate::input::describe_merge_conflicts_input::Builder::default()
    }
}

/// See [`DescribePullRequestEventsInput`](crate::input::DescribePullRequestEventsInput)
pub mod describe_pull_request_events_input {
    /// A builder for [`DescribePullRequestEventsInput`](crate::input::DescribePullRequestEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) pull_request_event_type: std::option::Option<crate::model::PullRequestEventType>,
        pub(crate) actor_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>Optional. The pull request event type about which you want to return information.</p>
        pub fn pull_request_event_type(
            mut self,
            input: crate::model::PullRequestEventType,
        ) -> Self {
            self.pull_request_event_type = Some(input);
            self
        }
        /// <p>Optional. The pull request event type about which you want to return information.</p>
        pub fn set_pull_request_event_type(
            mut self,
            input: std::option::Option<crate::model::PullRequestEventType>,
        ) -> Self {
            self.pull_request_event_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>
        pub fn actor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.actor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>
        pub fn set_actor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.actor_arn = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePullRequestEventsInput`](crate::input::DescribePullRequestEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePullRequestEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePullRequestEventsInput {
                pull_request_id: self.pull_request_id,
                pull_request_event_type: self.pull_request_event_type,
                actor_arn: self.actor_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePullRequestEventsInputOperationOutputAlias =
    crate::operation::DescribePullRequestEvents;
#[doc(hidden)]
pub type DescribePullRequestEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePullRequestEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePullRequestEvents`](crate::operation::DescribePullRequestEvents)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePullRequestEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePullRequestEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePullRequestEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePullRequestEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DescribePullRequestEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_pull_request_events(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePullRequestEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePullRequestEvents",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePullRequestEventsInput`](crate::input::DescribePullRequestEventsInput)
    pub fn builder() -> crate::input::describe_pull_request_events_input::Builder {
        crate::input::describe_pull_request_events_input::Builder::default()
    }
}

/// See [`DisassociateApprovalRuleTemplateFromRepositoryInput`](crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput)
pub mod disassociate_approval_rule_template_from_repository_input {
    /// A builder for [`DisassociateApprovalRuleTemplateFromRepositoryInput`](crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// <p>The name of the repository you want to disassociate from the template.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository you want to disassociate from the template.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateApprovalRuleTemplateFromRepositoryInput`](crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput {
                    approval_rule_template_name: self.approval_rule_template_name,
                    repository_name: self.repository_name,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DisassociateApprovalRuleTemplateFromRepositoryInputOperationOutputAlias =
    crate::operation::DisassociateApprovalRuleTemplateFromRepository;
#[doc(hidden)]
pub type DisassociateApprovalRuleTemplateFromRepositoryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateApprovalRuleTemplateFromRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateApprovalRuleTemplateFromRepository`](crate::operation::DisassociateApprovalRuleTemplateFromRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateApprovalRuleTemplateFromRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.DisassociateApprovalRuleTemplateFromRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disassociate_approval_rule_template_from_repository(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateApprovalRuleTemplateFromRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateApprovalRuleTemplateFromRepository",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateApprovalRuleTemplateFromRepositoryInput`](crate::input::DisassociateApprovalRuleTemplateFromRepositoryInput)
    pub fn builder(
    ) -> crate::input::disassociate_approval_rule_template_from_repository_input::Builder {
        crate::input::disassociate_approval_rule_template_from_repository_input::Builder::default()
    }
}

/// See [`EvaluatePullRequestApprovalRulesInput`](crate::input::EvaluatePullRequestApprovalRulesInput)
pub mod evaluate_pull_request_approval_rules_input {
    /// A builder for [`EvaluatePullRequestApprovalRulesInput`](crate::input::EvaluatePullRequestApprovalRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request you want to evaluate.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request you want to evaluate.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <code>GetPullRequest</code>.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <code>GetPullRequest</code>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluatePullRequestApprovalRulesInput`](crate::input::EvaluatePullRequestApprovalRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EvaluatePullRequestApprovalRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EvaluatePullRequestApprovalRulesInput {
                pull_request_id: self.pull_request_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type EvaluatePullRequestApprovalRulesInputOperationOutputAlias =
    crate::operation::EvaluatePullRequestApprovalRules;
#[doc(hidden)]
pub type EvaluatePullRequestApprovalRulesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl EvaluatePullRequestApprovalRulesInput {
    /// Consumes the builder and constructs an Operation<[`EvaluatePullRequestApprovalRules`](crate::operation::EvaluatePullRequestApprovalRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EvaluatePullRequestApprovalRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EvaluatePullRequestApprovalRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EvaluatePullRequestApprovalRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EvaluatePullRequestApprovalRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.EvaluatePullRequestApprovalRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_evaluate_pull_request_approval_rules(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EvaluatePullRequestApprovalRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EvaluatePullRequestApprovalRules",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EvaluatePullRequestApprovalRulesInput`](crate::input::EvaluatePullRequestApprovalRulesInput)
    pub fn builder() -> crate::input::evaluate_pull_request_approval_rules_input::Builder {
        crate::input::evaluate_pull_request_approval_rules_input::Builder::default()
    }
}

/// See [`GetApprovalRuleTemplateInput`](crate::input::GetApprovalRuleTemplateInput)
pub mod get_approval_rule_template_input {
    /// A builder for [`GetApprovalRuleTemplateInput`](crate::input::GetApprovalRuleTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the approval rule template for which you want to get information.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule template for which you want to get information.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApprovalRuleTemplateInput`](crate::input::GetApprovalRuleTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetApprovalRuleTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetApprovalRuleTemplateInput {
                approval_rule_template_name: self.approval_rule_template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetApprovalRuleTemplateInputOperationOutputAlias =
    crate::operation::GetApprovalRuleTemplate;
#[doc(hidden)]
pub type GetApprovalRuleTemplateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetApprovalRuleTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetApprovalRuleTemplate`](crate::operation::GetApprovalRuleTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetApprovalRuleTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetApprovalRuleTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetApprovalRuleTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetApprovalRuleTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetApprovalRuleTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_approval_rule_template(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetApprovalRuleTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetApprovalRuleTemplate",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetApprovalRuleTemplateInput`](crate::input::GetApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::get_approval_rule_template_input::Builder {
        crate::input::get_approval_rule_template_input::Builder::default()
    }
}

/// See [`GetBlobInput`](crate::input::GetBlobInput)
pub mod get_blob_input {
    /// A builder for [`GetBlobInput`](crate::input::GetBlobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) blob_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the blob.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the blob.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlobInput`](crate::input::GetBlobInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBlobInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBlobInput {
                repository_name: self.repository_name,
                blob_id: self.blob_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBlobInputOperationOutputAlias = crate::operation::GetBlob;
#[doc(hidden)]
pub type GetBlobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBlobInput {
    /// Consumes the builder and constructs an Operation<[`GetBlob`](crate::operation::GetBlob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBlob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBlobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBlobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBlobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetBlob",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_blob(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBlob::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetBlob",
                    "codecommit",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBlobInput`](crate::input::GetBlobInput)
    pub fn builder() -> crate::input::get_blob_input::Builder {
        crate::input::get_blob_input::Builder::default()
    }
}

/// See [`GetBranchInput`](crate::input::GetBranchInput)
pub mod get_branch_input {
    /// A builder for [`GetBranchInput`](crate::input::GetBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the branch for which you want to retrieve information.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the branch for which you want to retrieve information.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBranchInput`](crate::input::GetBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetBranchInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetBranchInput {
                repository_name: self.repository_name,
                branch_name: self.branch_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBranchInputOperationOutputAlias = crate::operation::GetBranch;
#[doc(hidden)]
pub type GetBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBranchInput {
    /// Consumes the builder and constructs an Operation<[`GetBranch`](crate::operation::GetBranch)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBranchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBranchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBranchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetBranch",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_branch(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetBranch::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetBranch",
                    "codecommit",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBranchInput`](crate::input::GetBranchInput)
    pub fn builder() -> crate::input::get_branch_input::Builder {
        crate::input::get_branch_input::Builder::default()
    }
}

/// See [`GetCommentInput`](crate::input::GetCommentInput)
pub mod get_comment_input {
    /// A builder for [`GetCommentInput`](crate::input::GetCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentInput`](crate::input::GetCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCommentInput {
                comment_id: self.comment_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCommentInputOperationOutputAlias = crate::operation::GetComment;
#[doc(hidden)]
pub type GetCommentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCommentInput {
    /// Consumes the builder and constructs an Operation<[`GetComment`](crate::operation::GetComment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetComment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCommentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCommentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCommentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetComment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_comment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetComment",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCommentInput`](crate::input::GetCommentInput)
    pub fn builder() -> crate::input::get_comment_input::Builder {
        crate::input::get_comment_input::Builder::default()
    }
}

/// See [`GetCommentReactionsInput`](crate::input::GetCommentReactionsInput)
pub mod get_comment_reactions_input {
    /// A builder for [`GetCommentReactionsInput`](crate::input::GetCommentReactionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
        pub(crate) reaction_user_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ID of the comment for which you want to get reactions information.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The ID of the comment for which you want to get reactions information.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
        pub fn reaction_user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.reaction_user_arn = Some(input.into());
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
        pub fn set_reaction_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reaction_user_arn = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentReactionsInput`](crate::input::GetCommentReactionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCommentReactionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCommentReactionsInput {
                comment_id: self.comment_id,
                reaction_user_arn: self.reaction_user_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCommentReactionsInputOperationOutputAlias = crate::operation::GetCommentReactions;
#[doc(hidden)]
pub type GetCommentReactionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCommentReactionsInput {
    /// Consumes the builder and constructs an Operation<[`GetCommentReactions`](crate::operation::GetCommentReactions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCommentReactions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCommentReactionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCommentReactionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCommentReactionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetCommentReactions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_comment_reactions(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCommentReactions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCommentReactions",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCommentReactionsInput`](crate::input::GetCommentReactionsInput)
    pub fn builder() -> crate::input::get_comment_reactions_input::Builder {
        crate::input::get_comment_reactions_input::Builder::default()
    }
}

/// See [`GetCommentsForComparedCommitInput`](crate::input::GetCommentsForComparedCommitInput)
pub mod get_comments_for_compared_commit_input {
    /// A builder for [`GetCommentsForComparedCommitInput`](crate::input::GetCommentsForComparedCommitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to compare commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to compare commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentsForComparedCommitInput`](crate::input::GetCommentsForComparedCommitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCommentsForComparedCommitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCommentsForComparedCommitInput {
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCommentsForComparedCommitInputOperationOutputAlias =
    crate::operation::GetCommentsForComparedCommit;
#[doc(hidden)]
pub type GetCommentsForComparedCommitInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetCommentsForComparedCommitInput {
    /// Consumes the builder and constructs an Operation<[`GetCommentsForComparedCommit`](crate::operation::GetCommentsForComparedCommit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCommentsForComparedCommit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCommentsForComparedCommitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCommentsForComparedCommitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCommentsForComparedCommitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetCommentsForComparedCommit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_comments_for_compared_commit(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCommentsForComparedCommit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCommentsForComparedCommit",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCommentsForComparedCommitInput`](crate::input::GetCommentsForComparedCommitInput)
    pub fn builder() -> crate::input::get_comments_for_compared_commit_input::Builder {
        crate::input::get_comments_for_compared_commit_input::Builder::default()
    }
}

/// See [`GetCommentsForPullRequestInput`](crate::input::GetCommentsForPullRequestInput)
pub mod get_comments_for_pull_request_input {
    /// A builder for [`GetCommentsForPullRequestInput`](crate::input::GetCommentsForPullRequestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentsForPullRequestInput`](crate::input::GetCommentsForPullRequestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCommentsForPullRequestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCommentsForPullRequestInput {
                pull_request_id: self.pull_request_id,
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCommentsForPullRequestInputOperationOutputAlias =
    crate::operation::GetCommentsForPullRequest;
#[doc(hidden)]
pub type GetCommentsForPullRequestInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCommentsForPullRequestInput {
    /// Consumes the builder and constructs an Operation<[`GetCommentsForPullRequest`](crate::operation::GetCommentsForPullRequest)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCommentsForPullRequest,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCommentsForPullRequestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCommentsForPullRequestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCommentsForPullRequestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetCommentsForPullRequest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_comments_for_pull_request(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCommentsForPullRequest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCommentsForPullRequest",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCommentsForPullRequestInput`](crate::input::GetCommentsForPullRequestInput)
    pub fn builder() -> crate::input::get_comments_for_pull_request_input::Builder {
        crate::input::get_comments_for_pull_request_input::Builder::default()
    }
}

/// See [`GetCommitInput`](crate::input::GetCommitInput)
pub mod get_commit_input {
    /// A builder for [`GetCommitInput`](crate::input::GetCommitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository to which the commit was made.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to which the commit was made.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommitInput`](crate::input::GetCommitInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetCommitInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetCommitInput {
                repository_name: self.repository_name,
                commit_id: self.commit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCommitInputOperationOutputAlias = crate::operation::GetCommit;
#[doc(hidden)]
pub type GetCommitInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCommitInput {
    /// Consumes the builder and constructs an Operation<[`GetCommit`](crate::operation::GetCommit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCommit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCommitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCommitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCommitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetCommit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_commit(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetCommit::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetCommit",
                    "codecommit",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCommitInput`](crate::input::GetCommitInput)
    pub fn builder() -> crate::input::get_commit_input::Builder {
        crate::input::get_commit_input::Builder::default()
    }
}

/// See [`GetDifferencesInput`](crate::input::GetDifferencesInput)
pub mod get_differences_input {
    /// A builder for [`GetDifferencesInput`](crate::input::GetDifferencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) after_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) before_path: std::option::Option<std::string::String>,
        pub(crate) after_path: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to get differences.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to get differences.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>
        pub fn before_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>
        pub fn set_before_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
        pub fn after_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
        pub fn set_after_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_specifier = input;
            self
        }
        /// <p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>
        pub fn before_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_path = Some(input.into());
            self
        }
        /// <p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>
        pub fn set_before_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.before_path = input;
            self
        }
        /// <p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>
        pub fn after_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_path = Some(input.into());
            self
        }
        /// <p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>
        pub fn set_after_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.after_path = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDifferencesInput`](crate::input::GetDifferencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDifferencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDifferencesInput {
                repository_name: self.repository_name,
                before_commit_specifier: self.before_commit_specifier,
                after_commit_specifier: self.after_commit_specifier,
                before_path: self.before_path,
                after_path: self.after_path,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDifferencesInputOperationOutputAlias = crate::operation::GetDifferences;
#[doc(hidden)]
pub type GetDifferencesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDifferencesInput {
    /// Consumes the builder and constructs an Operation<[`GetDifferences`](crate::operation::GetDifferences)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDifferences,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDifferencesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDifferencesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDifferencesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetDifferences",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_differences(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDifferences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDifferences",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDifferencesInput`](crate::input::GetDifferencesInput)
    pub fn builder() -> crate::input::get_differences_input::Builder {
        crate::input::get_differences_input::Builder::default()
    }
}

/// See [`GetFileInput`](crate::input::GetFileInput)
pub mod get_file_input {
    /// A builder for [`GetFileInput`](crate::input::GetFileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) commit_specifier: std::option::Option<std::string::String>,
        pub(crate) file_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the file.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the file.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>
        pub fn commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_specifier = Some(input.into());
            self
        }
        /// <p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>
        pub fn set_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_specifier = input;
            self
        }
        /// <p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFileInput`](crate::input::GetFileInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetFileInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetFileInput {
                repository_name: self.repository_name,
                commit_specifier: self.commit_specifier,
                file_path: self.file_path,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFileInputOperationOutputAlias = crate::operation::GetFile;
#[doc(hidden)]
pub type GetFileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFileInput {
    /// Consumes the builder and constructs an Operation<[`GetFile`](crate::operation::GetFile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetFile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_file(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetFile::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetFile",
                    "codecommit",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFileInput`](crate::input::GetFileInput)
    pub fn builder() -> crate::input::get_file_input::Builder {
        crate::input::get_file_input::Builder::default()
    }
}

/// See [`GetFolderInput`](crate::input::GetFolderInput)
pub mod get_folder_input {
    /// A builder for [`GetFolderInput`](crate::input::GetFolderInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) commit_specifier: std::option::Option<std::string::String>,
        pub(crate) folder_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>
        pub fn commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_specifier = Some(input.into());
            self
        }
        /// <p>A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>
        pub fn set_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_specifier = input;
            self
        }
        /// <p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>
        pub fn folder_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>
        pub fn set_folder_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_path = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderInput`](crate::input::GetFolderInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetFolderInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetFolderInput {
                repository_name: self.repository_name,
                commit_specifier: self.commit_specifier,
                folder_path: self.folder_path,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFolderInputOperationOutputAlias = crate::operation::GetFolder;
#[doc(hidden)]
pub type GetFolderInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFolderInput {
    /// Consumes the builder and constructs an Operation<[`GetFolder`](crate::operation::GetFolder)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFolder,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFolderInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFolderInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFolderInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetFolder",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_folder(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetFolder::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetFolder",
                    "codecommit",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFolderInput`](crate::input::GetFolderInput)
    pub fn builder() -> crate::input::get_folder_input::Builder {
        crate::input::get_folder_input::Builder::default()
    }
}

/// See [`GetMergeCommitInput`](crate::input::GetMergeCommitInput)
pub mod get_merge_commit_input {
    /// A builder for [`GetMergeCommitInput`](crate::input::GetMergeCommitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMergeCommitInput`](crate::input::GetMergeCommitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMergeCommitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMergeCommitInput {
                repository_name: self.repository_name,
                source_commit_specifier: self.source_commit_specifier,
                destination_commit_specifier: self.destination_commit_specifier,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMergeCommitInputOperationOutputAlias = crate::operation::GetMergeCommit;
#[doc(hidden)]
pub type GetMergeCommitInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMergeCommitInput {
    /// Consumes the builder and constructs an Operation<[`GetMergeCommit`](crate::operation::GetMergeCommit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMergeCommit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMergeCommitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMergeCommitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMergeCommitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetMergeCommit",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_merge_commit(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMergeCommit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMergeCommit",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMergeCommitInput`](crate::input::GetMergeCommitInput)
    pub fn builder() -> crate::input::get_merge_commit_input::Builder {
        crate::input::get_merge_commit_input::Builder::default()
    }
}

/// See [`GetMergeConflictsInput`](crate::input::GetMergeConflictsInput)
pub mod get_merge_conflicts_input {
    /// A builder for [`GetMergeConflictsInput`](crate::input::GetMergeConflictsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) max_conflict_files: std::option::Option<i32>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code. </p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.merge_option = Some(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code. </p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.merge_option = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn max_conflict_files(mut self, input: i32) -> Self {
            self.max_conflict_files = Some(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn set_max_conflict_files(mut self, input: std::option::Option<i32>) -> Self {
            self.max_conflict_files = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMergeConflictsInput`](crate::input::GetMergeConflictsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMergeConflictsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMergeConflictsInput {
                repository_name: self.repository_name,
                destination_commit_specifier: self.destination_commit_specifier,
                source_commit_specifier: self.source_commit_specifier,
                merge_option: self.merge_option,
                conflict_detail_level: self.conflict_detail_level,
                max_conflict_files: self.max_conflict_files,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMergeConflictsInputOperationOutputAlias = crate::operation::GetMergeConflicts;
#[doc(hidden)]
pub type GetMergeConflictsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMergeConflictsInput {
    /// Consumes the builder and constructs an Operation<[`GetMergeConflicts`](crate::operation::GetMergeConflicts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMergeConflicts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMergeConflictsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMergeConflictsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMergeConflictsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetMergeConflicts",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_merge_conflicts(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMergeConflicts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMergeConflicts",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMergeConflictsInput`](crate::input::GetMergeConflictsInput)
    pub fn builder() -> crate::input::get_merge_conflicts_input::Builder {
        crate::input::get_merge_conflicts_input::Builder::default()
    }
}

/// See [`GetMergeOptionsInput`](crate::input::GetMergeOptionsInput)
pub mod get_merge_options_input {
    /// A builder for [`GetMergeOptionsInput`](crate::input::GetMergeOptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMergeOptionsInput`](crate::input::GetMergeOptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMergeOptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMergeOptionsInput {
                repository_name: self.repository_name,
                source_commit_specifier: self.source_commit_specifier,
                destination_commit_specifier: self.destination_commit_specifier,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMergeOptionsInputOperationOutputAlias = crate::operation::GetMergeOptions;
#[doc(hidden)]
pub type GetMergeOptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMergeOptionsInput {
    /// Consumes the builder and constructs an Operation<[`GetMergeOptions`](crate::operation::GetMergeOptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMergeOptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMergeOptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMergeOptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMergeOptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetMergeOptions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_merge_options(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMergeOptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMergeOptions",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMergeOptionsInput`](crate::input::GetMergeOptionsInput)
    pub fn builder() -> crate::input::get_merge_options_input::Builder {
        crate::input::get_merge_options_input::Builder::default()
    }
}

/// See [`GetPullRequestInput`](crate::input::GetPullRequestInput)
pub mod get_pull_request_input {
    /// A builder for [`GetPullRequestInput`](crate::input::GetPullRequestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPullRequestInput`](crate::input::GetPullRequestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPullRequestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPullRequestInput {
                pull_request_id: self.pull_request_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPullRequestInputOperationOutputAlias = crate::operation::GetPullRequest;
#[doc(hidden)]
pub type GetPullRequestInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPullRequestInput {
    /// Consumes the builder and constructs an Operation<[`GetPullRequest`](crate::operation::GetPullRequest)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPullRequest,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPullRequestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPullRequestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPullRequestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetPullRequest",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_pull_request(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPullRequest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPullRequest",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPullRequestInput`](crate::input::GetPullRequestInput)
    pub fn builder() -> crate::input::get_pull_request_input::Builder {
        crate::input::get_pull_request_input::Builder::default()
    }
}

/// See [`GetPullRequestApprovalStatesInput`](crate::input::GetPullRequestApprovalStatesInput)
pub mod get_pull_request_approval_states_input {
    /// A builder for [`GetPullRequestApprovalStatesInput`](crate::input::GetPullRequestApprovalStatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID for the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID for the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The system-generated ID for the pull request revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID for the pull request revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPullRequestApprovalStatesInput`](crate::input::GetPullRequestApprovalStatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPullRequestApprovalStatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPullRequestApprovalStatesInput {
                pull_request_id: self.pull_request_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPullRequestApprovalStatesInputOperationOutputAlias =
    crate::operation::GetPullRequestApprovalStates;
#[doc(hidden)]
pub type GetPullRequestApprovalStatesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetPullRequestApprovalStatesInput {
    /// Consumes the builder and constructs an Operation<[`GetPullRequestApprovalStates`](crate::operation::GetPullRequestApprovalStates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPullRequestApprovalStates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPullRequestApprovalStatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPullRequestApprovalStatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPullRequestApprovalStatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetPullRequestApprovalStates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_pull_request_approval_states(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPullRequestApprovalStates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPullRequestApprovalStates",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPullRequestApprovalStatesInput`](crate::input::GetPullRequestApprovalStatesInput)
    pub fn builder() -> crate::input::get_pull_request_approval_states_input::Builder {
        crate::input::get_pull_request_approval_states_input::Builder::default()
    }
}

/// See [`GetPullRequestOverrideStateInput`](crate::input::GetPullRequestOverrideStateInput)
pub mod get_pull_request_override_state_input {
    /// A builder for [`GetPullRequestOverrideStateInput`](crate::input::GetPullRequestOverrideStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <code>GetPullRequest</code>.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <code>GetPullRequest</code>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPullRequestOverrideStateInput`](crate::input::GetPullRequestOverrideStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPullRequestOverrideStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPullRequestOverrideStateInput {
                pull_request_id: self.pull_request_id,
                revision_id: self.revision_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPullRequestOverrideStateInputOperationOutputAlias =
    crate::operation::GetPullRequestOverrideState;
#[doc(hidden)]
pub type GetPullRequestOverrideStateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetPullRequestOverrideStateInput {
    /// Consumes the builder and constructs an Operation<[`GetPullRequestOverrideState`](crate::operation::GetPullRequestOverrideState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPullRequestOverrideState,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPullRequestOverrideStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPullRequestOverrideStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPullRequestOverrideStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetPullRequestOverrideState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_pull_request_override_state(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPullRequestOverrideState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPullRequestOverrideState",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPullRequestOverrideStateInput`](crate::input::GetPullRequestOverrideStateInput)
    pub fn builder() -> crate::input::get_pull_request_override_state_input::Builder {
        crate::input::get_pull_request_override_state_input::Builder::default()
    }
}

/// See [`GetRepositoryInput`](crate::input::GetRepositoryInput)
pub mod get_repository_input {
    /// A builder for [`GetRepositoryInput`](crate::input::GetRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository to get information about.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to get information about.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryInput`](crate::input::GetRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRepositoryInput {
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRepositoryInputOperationOutputAlias = crate::operation::GetRepository;
#[doc(hidden)]
pub type GetRepositoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`GetRepository`](crate::operation::GetRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_repository(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRepository",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRepositoryInput`](crate::input::GetRepositoryInput)
    pub fn builder() -> crate::input::get_repository_input::Builder {
        crate::input::get_repository_input::Builder::default()
    }
}

/// See [`GetRepositoryTriggersInput`](crate::input::GetRepositoryTriggersInput)
pub mod get_repository_triggers_input {
    /// A builder for [`GetRepositoryTriggersInput`](crate::input::GetRepositoryTriggersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository for which the trigger is configured.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository for which the trigger is configured.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryTriggersInput`](crate::input::GetRepositoryTriggersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRepositoryTriggersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRepositoryTriggersInput {
                repository_name: self.repository_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRepositoryTriggersInputOperationOutputAlias = crate::operation::GetRepositoryTriggers;
#[doc(hidden)]
pub type GetRepositoryTriggersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRepositoryTriggersInput {
    /// Consumes the builder and constructs an Operation<[`GetRepositoryTriggers`](crate::operation::GetRepositoryTriggers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRepositoryTriggers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRepositoryTriggersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRepositoryTriggersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRepositoryTriggersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.GetRepositoryTriggers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_repository_triggers(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRepositoryTriggers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRepositoryTriggers",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRepositoryTriggersInput`](crate::input::GetRepositoryTriggersInput)
    pub fn builder() -> crate::input::get_repository_triggers_input::Builder {
        crate::input::get_repository_triggers_input::Builder::default()
    }
}

/// See [`ListApprovalRuleTemplatesInput`](crate::input::ListApprovalRuleTemplatesInput)
pub mod list_approval_rule_templates_input {
    /// A builder for [`ListApprovalRuleTemplatesInput`](crate::input::ListApprovalRuleTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApprovalRuleTemplatesInput`](crate::input::ListApprovalRuleTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApprovalRuleTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApprovalRuleTemplatesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApprovalRuleTemplatesInputOperationOutputAlias =
    crate::operation::ListApprovalRuleTemplates;
#[doc(hidden)]
pub type ListApprovalRuleTemplatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListApprovalRuleTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListApprovalRuleTemplates`](crate::operation::ListApprovalRuleTemplates)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApprovalRuleTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApprovalRuleTemplatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApprovalRuleTemplatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApprovalRuleTemplatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.ListApprovalRuleTemplates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_approval_rule_templates(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApprovalRuleTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApprovalRuleTemplates",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApprovalRuleTemplatesInput`](crate::input::ListApprovalRuleTemplatesInput)
    pub fn builder() -> crate::input::list_approval_rule_templates_input::Builder {
        crate::input::list_approval_rule_templates_input::Builder::default()
    }
}

/// See [`ListAssociatedApprovalRuleTemplatesForRepositoryInput`](crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput)
pub mod list_associated_approval_rule_templates_for_repository_input {
    /// A builder for [`ListAssociatedApprovalRuleTemplatesForRepositoryInput`](crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedApprovalRuleTemplatesForRepositoryInput`](crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput {
                    repository_name: self.repository_name,
                    next_token: self.next_token,
                    max_results: self.max_results,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListAssociatedApprovalRuleTemplatesForRepositoryInputOperationOutputAlias =
    crate::operation::ListAssociatedApprovalRuleTemplatesForRepository;
#[doc(hidden)]
pub type ListAssociatedApprovalRuleTemplatesForRepositoryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAssociatedApprovalRuleTemplatesForRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociatedApprovalRuleTemplatesForRepository`](crate::operation::ListAssociatedApprovalRuleTemplatesForRepository)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociatedApprovalRuleTemplatesForRepository,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.ListAssociatedApprovalRuleTemplatesForRepository",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_associated_approval_rule_templates_for_repository(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociatedApprovalRuleTemplatesForRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociatedApprovalRuleTemplatesForRepository",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAssociatedApprovalRuleTemplatesForRepositoryInput`](crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInput)
    pub fn builder(
    ) -> crate::input::list_associated_approval_rule_templates_for_repository_input::Builder {
        crate::input::list_associated_approval_rule_templates_for_repository_input::Builder::default(
        )
    }
}

/// See [`ListBranchesInput`](crate::input::ListBranchesInput)
pub mod list_branches_input {
    /// A builder for [`ListBranchesInput`](crate::input::ListBranchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBranchesInput`](crate::input::ListBranchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListBranchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListBranchesInput {
                repository_name: self.repository_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBranchesInputOperationOutputAlias = crate::operation::ListBranches;
#[doc(hidden)]
pub type ListBranchesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBranchesInput {
    /// Consumes the builder and constructs an Operation<[`ListBranches`](crate::operation::ListBranches)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBranches,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBranchesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBranchesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBranchesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.ListBranches",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_branches(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListBranches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListBranches",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBranchesInput`](crate::input::ListBranchesInput)
    pub fn builder() -> crate::input::list_branches_input::Builder {
        crate::input::list_branches_input::Builder::default()
    }
}

/// See [`ListPullRequestsInput`](crate::input::ListPullRequestsInput)
pub mod list_pull_requests_input {
    /// A builder for [`ListPullRequestsInput`](crate::input::ListPullRequestsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) author_arn: std::option::Option<std::string::String>,
        pub(crate) pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the repository for which you want to list pull requests.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository for which you want to list pull requests.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>
        pub fn author_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_arn = Some(input.into());
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>
        pub fn set_author_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_arn = input;
            self
        }
        /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
        pub fn pull_request_status(mut self, input: crate::model::PullRequestStatusEnum) -> Self {
            self.pull_request_status = Some(input);
            self
        }
        /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.pull_request_status = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPullRequestsInput`](crate::input::ListPullRequestsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPullRequestsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPullRequestsInput {
                repository_name: self.repository_name,
                author_arn: self.author_arn,
                pull_request_status: self.pull_request_status,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPullRequestsInputOperationOutputAlias = crate::operation::ListPullRequests;
#[doc(hidden)]
pub type ListPullRequestsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPullRequestsInput {
    /// Consumes the builder and constructs an Operation<[`ListPullRequests`](crate::operation::ListPullRequests)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPullRequests,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPullRequestsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPullRequestsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPullRequestsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.ListPullRequests",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_pull_requests(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPullRequests::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPullRequests",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPullRequestsInput`](crate::input::ListPullRequestsInput)
    pub fn builder() -> crate::input::list_pull_requests_input::Builder {
        crate::input::list_pull_requests_input::Builder::default()
    }
}

/// See [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
pub mod list_repositories_input {
    /// A builder for [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::SortByEnum>,
        pub(crate) order: std::option::Option<crate::model::OrderEnum>,
    }
    impl Builder {
        /// <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The criteria used to sort the results of a list repositories operation.</p>
        pub fn sort_by(mut self, input: crate::model::SortByEnum) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The criteria used to sort the results of a list repositories operation.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::SortByEnum>) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The order in which to sort the results of a list repositories operation.</p>
        pub fn order(mut self, input: crate::model::OrderEnum) -> Self {
            self.order = Some(input);
            self
        }
        /// <p>The order in which to sort the results of a list repositories operation.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderEnum>) -> Self {
            self.order = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRepositoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRepositoriesInput {
                next_token: self.next_token,
                sort_by: self.sort_by,
                order: self.order,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRepositoriesInputOperationOutputAlias = crate::operation::ListRepositories;
#[doc(hidden)]
pub type ListRepositoriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRepositoriesInput {
    /// Consumes the builder and constructs an Operation<[`ListRepositories`](crate::operation::ListRepositories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRepositories,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRepositoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRepositoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRepositoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.ListRepositories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_repositories(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRepositories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRepositories",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
    pub fn builder() -> crate::input::list_repositories_input::Builder {
        crate::input::list_repositories_input::Builder::default()
    }
}

/// See [`ListRepositoriesForApprovalRuleTemplateInput`](crate::input::ListRepositoriesForApprovalRuleTemplateInput)
pub mod list_repositories_for_approval_rule_template_input {
    /// A builder for [`ListRepositoriesForApprovalRuleTemplateInput`](crate::input::ListRepositoriesForApprovalRuleTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesForApprovalRuleTemplateInput`](crate::input::ListRepositoriesForApprovalRuleTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRepositoriesForApprovalRuleTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRepositoriesForApprovalRuleTemplateInput {
                approval_rule_template_name: self.approval_rule_template_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRepositoriesForApprovalRuleTemplateInputOperationOutputAlias =
    crate::operation::ListRepositoriesForApprovalRuleTemplate;
#[doc(hidden)]
pub type ListRepositoriesForApprovalRuleTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListRepositoriesForApprovalRuleTemplateInput {
    /// Consumes the builder and constructs an Operation<[`ListRepositoriesForApprovalRuleTemplate`](crate::operation::ListRepositoriesForApprovalRuleTemplate)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRepositoriesForApprovalRuleTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRepositoriesForApprovalRuleTemplateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRepositoriesForApprovalRuleTemplateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRepositoriesForApprovalRuleTemplateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.ListRepositoriesForApprovalRuleTemplate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_repositories_for_approval_rule_template(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRepositoriesForApprovalRuleTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRepositoriesForApprovalRuleTemplate",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRepositoriesForApprovalRuleTemplateInput`](crate::input::ListRepositoriesForApprovalRuleTemplateInput)
    pub fn builder() -> crate::input::list_repositories_for_approval_rule_template_input::Builder {
        crate::input::list_repositories_for_approval_rule_template_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`MergeBranchesByFastForwardInput`](crate::input::MergeBranchesByFastForwardInput)
pub mod merge_branches_by_fast_forward_input {
    /// A builder for [`MergeBranchesByFastForwardInput`](crate::input::MergeBranchesByFastForwardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) target_branch: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The branch where the merge is applied.</p>
        pub fn target_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_branch = Some(input.into());
            self
        }
        /// <p>The branch where the merge is applied.</p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_branch = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeBranchesByFastForwardInput`](crate::input::MergeBranchesByFastForwardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergeBranchesByFastForwardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergeBranchesByFastForwardInput {
                repository_name: self.repository_name,
                source_commit_specifier: self.source_commit_specifier,
                destination_commit_specifier: self.destination_commit_specifier,
                target_branch: self.target_branch,
            })
        }
    }
}
#[doc(hidden)]
pub type MergeBranchesByFastForwardInputOperationOutputAlias =
    crate::operation::MergeBranchesByFastForward;
#[doc(hidden)]
pub type MergeBranchesByFastForwardInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl MergeBranchesByFastForwardInput {
    /// Consumes the builder and constructs an Operation<[`MergeBranchesByFastForward`](crate::operation::MergeBranchesByFastForward)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergeBranchesByFastForward,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MergeBranchesByFastForwardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MergeBranchesByFastForwardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MergeBranchesByFastForwardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.MergeBranchesByFastForward",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_merge_branches_by_fast_forward(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergeBranchesByFastForward::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergeBranchesByFastForward",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MergeBranchesByFastForwardInput`](crate::input::MergeBranchesByFastForwardInput)
    pub fn builder() -> crate::input::merge_branches_by_fast_forward_input::Builder {
        crate::input::merge_branches_by_fast_forward_input::Builder::default()
    }
}

/// See [`MergeBranchesBySquashInput`](crate::input::MergeBranchesBySquashInput)
pub mod merge_branches_by_squash_input {
    /// A builder for [`MergeBranchesBySquashInput`](crate::input::MergeBranchesBySquashInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) target_branch: std::option::Option<std::string::String>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) author_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) keep_empty_folders: std::option::Option<bool>,
        pub(crate) conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn target_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_branch = Some(input.into());
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_branch = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_name = Some(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_name = input;
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The commit message for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>The commit message for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.keep_empty_folders = Some(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.keep_empty_folders = input;
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.conflict_resolution = Some(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.conflict_resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeBranchesBySquashInput`](crate::input::MergeBranchesBySquashInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergeBranchesBySquashInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergeBranchesBySquashInput {
                repository_name: self.repository_name,
                source_commit_specifier: self.source_commit_specifier,
                destination_commit_specifier: self.destination_commit_specifier,
                target_branch: self.target_branch,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                author_name: self.author_name,
                email: self.email,
                commit_message: self.commit_message,
                keep_empty_folders: self.keep_empty_folders.unwrap_or_default(),
                conflict_resolution: self.conflict_resolution,
            })
        }
    }
}
#[doc(hidden)]
pub type MergeBranchesBySquashInputOperationOutputAlias = crate::operation::MergeBranchesBySquash;
#[doc(hidden)]
pub type MergeBranchesBySquashInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl MergeBranchesBySquashInput {
    /// Consumes the builder and constructs an Operation<[`MergeBranchesBySquash`](crate::operation::MergeBranchesBySquash)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergeBranchesBySquash,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MergeBranchesBySquashInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MergeBranchesBySquashInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MergeBranchesBySquashInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.MergeBranchesBySquash",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_merge_branches_by_squash(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergeBranchesBySquash::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergeBranchesBySquash",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MergeBranchesBySquashInput`](crate::input::MergeBranchesBySquashInput)
    pub fn builder() -> crate::input::merge_branches_by_squash_input::Builder {
        crate::input::merge_branches_by_squash_input::Builder::default()
    }
}

/// See [`MergeBranchesByThreeWayInput`](crate::input::MergeBranchesByThreeWayInput)
pub mod merge_branches_by_three_way_input {
    /// A builder for [`MergeBranchesByThreeWayInput`](crate::input::MergeBranchesByThreeWayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) destination_commit_specifier: std::option::Option<std::string::String>,
        pub(crate) target_branch: std::option::Option<std::string::String>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) author_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) keep_empty_folders: std::option::Option<bool>,
        pub(crate) conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_specifier = input;
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = Some(input.into());
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_specifier = input;
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn target_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_branch = Some(input.into());
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_branch = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_name = Some(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_name = input;
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.keep_empty_folders = Some(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.keep_empty_folders = input;
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.conflict_resolution = Some(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.conflict_resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeBranchesByThreeWayInput`](crate::input::MergeBranchesByThreeWayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergeBranchesByThreeWayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergeBranchesByThreeWayInput {
                repository_name: self.repository_name,
                source_commit_specifier: self.source_commit_specifier,
                destination_commit_specifier: self.destination_commit_specifier,
                target_branch: self.target_branch,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                author_name: self.author_name,
                email: self.email,
                commit_message: self.commit_message,
                keep_empty_folders: self.keep_empty_folders.unwrap_or_default(),
                conflict_resolution: self.conflict_resolution,
            })
        }
    }
}
#[doc(hidden)]
pub type MergeBranchesByThreeWayInputOperationOutputAlias =
    crate::operation::MergeBranchesByThreeWay;
#[doc(hidden)]
pub type MergeBranchesByThreeWayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl MergeBranchesByThreeWayInput {
    /// Consumes the builder and constructs an Operation<[`MergeBranchesByThreeWay`](crate::operation::MergeBranchesByThreeWay)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergeBranchesByThreeWay,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MergeBranchesByThreeWayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MergeBranchesByThreeWayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MergeBranchesByThreeWayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.MergeBranchesByThreeWay",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_merge_branches_by_three_way(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergeBranchesByThreeWay::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergeBranchesByThreeWay",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MergeBranchesByThreeWayInput`](crate::input::MergeBranchesByThreeWayInput)
    pub fn builder() -> crate::input::merge_branches_by_three_way_input::Builder {
        crate::input::merge_branches_by_three_way_input::Builder::default()
    }
}

/// See [`MergePullRequestByFastForwardInput`](crate::input::MergePullRequestByFastForwardInput)
pub mod merge_pull_request_by_fast_forward_input {
    /// A builder for [`MergePullRequestByFastForwardInput`](crate::input::MergePullRequestByFastForwardInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MergePullRequestByFastForwardInput`](crate::input::MergePullRequestByFastForwardInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergePullRequestByFastForwardInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergePullRequestByFastForwardInput {
                pull_request_id: self.pull_request_id,
                repository_name: self.repository_name,
                source_commit_id: self.source_commit_id,
            })
        }
    }
}
#[doc(hidden)]
pub type MergePullRequestByFastForwardInputOperationOutputAlias =
    crate::operation::MergePullRequestByFastForward;
#[doc(hidden)]
pub type MergePullRequestByFastForwardInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl MergePullRequestByFastForwardInput {
    /// Consumes the builder and constructs an Operation<[`MergePullRequestByFastForward`](crate::operation::MergePullRequestByFastForward)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergePullRequestByFastForward,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MergePullRequestByFastForwardInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MergePullRequestByFastForwardInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MergePullRequestByFastForwardInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.MergePullRequestByFastForward",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_merge_pull_request_by_fast_forward(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergePullRequestByFastForward::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergePullRequestByFastForward",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MergePullRequestByFastForwardInput`](crate::input::MergePullRequestByFastForwardInput)
    pub fn builder() -> crate::input::merge_pull_request_by_fast_forward_input::Builder {
        crate::input::merge_pull_request_by_fast_forward_input::Builder::default()
    }
}

/// See [`MergePullRequestBySquashInput`](crate::input::MergePullRequestBySquashInput)
pub mod merge_pull_request_by_squash_input {
    /// A builder for [`MergePullRequestBySquashInput`](crate::input::MergePullRequestBySquashInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) author_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) keep_empty_folders: std::option::Option<bool>,
        pub(crate) conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_name = Some(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_name = input;
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.keep_empty_folders = Some(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.keep_empty_folders = input;
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.conflict_resolution = Some(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.conflict_resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`MergePullRequestBySquashInput`](crate::input::MergePullRequestBySquashInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergePullRequestBySquashInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergePullRequestBySquashInput {
                pull_request_id: self.pull_request_id,
                repository_name: self.repository_name,
                source_commit_id: self.source_commit_id,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                commit_message: self.commit_message,
                author_name: self.author_name,
                email: self.email,
                keep_empty_folders: self.keep_empty_folders.unwrap_or_default(),
                conflict_resolution: self.conflict_resolution,
            })
        }
    }
}
#[doc(hidden)]
pub type MergePullRequestBySquashInputOperationOutputAlias =
    crate::operation::MergePullRequestBySquash;
#[doc(hidden)]
pub type MergePullRequestBySquashInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl MergePullRequestBySquashInput {
    /// Consumes the builder and constructs an Operation<[`MergePullRequestBySquash`](crate::operation::MergePullRequestBySquash)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergePullRequestBySquash,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MergePullRequestBySquashInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MergePullRequestBySquashInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MergePullRequestBySquashInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.MergePullRequestBySquash",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_merge_pull_request_by_squash(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergePullRequestBySquash::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergePullRequestBySquash",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MergePullRequestBySquashInput`](crate::input::MergePullRequestBySquashInput)
    pub fn builder() -> crate::input::merge_pull_request_by_squash_input::Builder {
        crate::input::merge_pull_request_by_squash_input::Builder::default()
    }
}

/// See [`MergePullRequestByThreeWayInput`](crate::input::MergePullRequestByThreeWayInput)
pub mod merge_pull_request_by_three_way_input {
    /// A builder for [`MergePullRequestByThreeWayInput`](crate::input::MergePullRequestByThreeWayInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) conflict_detail_level:
            std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        pub(crate) conflict_resolution_strategy:
            std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) author_name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) keep_empty_folders: std::option::Option<bool>,
        pub(crate) conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            input: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.conflict_detail_level = Some(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.conflict_detail_level = input;
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            input: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.conflict_resolution_strategy = Some(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.conflict_resolution_strategy = input;
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn author_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_name = Some(input.into());
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_name = input;
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, input: bool) -> Self {
            self.keep_empty_folders = Some(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.keep_empty_folders = input;
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.conflict_resolution = Some(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.conflict_resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`MergePullRequestByThreeWayInput`](crate::input::MergePullRequestByThreeWayInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergePullRequestByThreeWayInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergePullRequestByThreeWayInput {
                pull_request_id: self.pull_request_id,
                repository_name: self.repository_name,
                source_commit_id: self.source_commit_id,
                conflict_detail_level: self.conflict_detail_level,
                conflict_resolution_strategy: self.conflict_resolution_strategy,
                commit_message: self.commit_message,
                author_name: self.author_name,
                email: self.email,
                keep_empty_folders: self.keep_empty_folders.unwrap_or_default(),
                conflict_resolution: self.conflict_resolution,
            })
        }
    }
}
#[doc(hidden)]
pub type MergePullRequestByThreeWayInputOperationOutputAlias =
    crate::operation::MergePullRequestByThreeWay;
#[doc(hidden)]
pub type MergePullRequestByThreeWayInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl MergePullRequestByThreeWayInput {
    /// Consumes the builder and constructs an Operation<[`MergePullRequestByThreeWay`](crate::operation::MergePullRequestByThreeWay)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergePullRequestByThreeWay,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MergePullRequestByThreeWayInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MergePullRequestByThreeWayInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MergePullRequestByThreeWayInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.MergePullRequestByThreeWay",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_merge_pull_request_by_three_way(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergePullRequestByThreeWay::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergePullRequestByThreeWay",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MergePullRequestByThreeWayInput`](crate::input::MergePullRequestByThreeWayInput)
    pub fn builder() -> crate::input::merge_pull_request_by_three_way_input::Builder {
        crate::input::merge_pull_request_by_three_way_input::Builder::default()
    }
}

/// See [`OverridePullRequestApprovalRulesInput`](crate::input::OverridePullRequestApprovalRulesInput)
pub mod override_pull_request_approval_rules_input {
    /// A builder for [`OverridePullRequestApprovalRulesInput`](crate::input::OverridePullRequestApprovalRulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) override_status: std::option::Option<crate::model::OverrideStatus>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <code>GetPullRequest</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <code>GetPullRequest</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>
        pub fn override_status(mut self, input: crate::model::OverrideStatus) -> Self {
            self.override_status = Some(input);
            self
        }
        /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>
        pub fn set_override_status(
            mut self,
            input: std::option::Option<crate::model::OverrideStatus>,
        ) -> Self {
            self.override_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OverridePullRequestApprovalRulesInput`](crate::input::OverridePullRequestApprovalRulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::OverridePullRequestApprovalRulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::OverridePullRequestApprovalRulesInput {
                pull_request_id: self.pull_request_id,
                revision_id: self.revision_id,
                override_status: self.override_status,
            })
        }
    }
}
#[doc(hidden)]
pub type OverridePullRequestApprovalRulesInputOperationOutputAlias =
    crate::operation::OverridePullRequestApprovalRules;
#[doc(hidden)]
pub type OverridePullRequestApprovalRulesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl OverridePullRequestApprovalRulesInput {
    /// Consumes the builder and constructs an Operation<[`OverridePullRequestApprovalRules`](crate::operation::OverridePullRequestApprovalRules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::OverridePullRequestApprovalRules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::OverridePullRequestApprovalRulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::OverridePullRequestApprovalRulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::OverridePullRequestApprovalRulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.OverridePullRequestApprovalRules",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_override_pull_request_approval_rules(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::OverridePullRequestApprovalRules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "OverridePullRequestApprovalRules",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`OverridePullRequestApprovalRulesInput`](crate::input::OverridePullRequestApprovalRulesInput)
    pub fn builder() -> crate::input::override_pull_request_approval_rules_input::Builder {
        crate::input::override_pull_request_approval_rules_input::Builder::default()
    }
}

/// See [`PostCommentForComparedCommitInput`](crate::input::PostCommentForComparedCommitInput)
pub mod post_comment_for_compared_commit_input {
    /// A builder for [`PostCommentForComparedCommitInput`](crate::input::PostCommentForComparedCommitInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>The location of the comparison where you want to comment.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the comparison where you want to comment.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The content of the comment you want to make.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the comment you want to make.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`PostCommentForComparedCommitInput`](crate::input::PostCommentForComparedCommitInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PostCommentForComparedCommitInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PostCommentForComparedCommitInput {
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                location: self.location,
                content: self.content,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type PostCommentForComparedCommitInputOperationOutputAlias =
    crate::operation::PostCommentForComparedCommit;
#[doc(hidden)]
pub type PostCommentForComparedCommitInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl PostCommentForComparedCommitInput {
    /// Consumes the builder and constructs an Operation<[`PostCommentForComparedCommit`](crate::operation::PostCommentForComparedCommit)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PostCommentForComparedCommit,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PostCommentForComparedCommitInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PostCommentForComparedCommitInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PostCommentForComparedCommitInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.PostCommentForComparedCommit",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_post_comment_for_compared_commit(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PostCommentForComparedCommit::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PostCommentForComparedCommit",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PostCommentForComparedCommitInput`](crate::input::PostCommentForComparedCommitInput)
    pub fn builder() -> crate::input::post_comment_for_compared_commit_input::Builder {
        crate::input::post_comment_for_compared_commit_input::Builder::default()
    }
}

/// See [`PostCommentForPullRequestInput`](crate::input::PostCommentForPullRequestInput)
pub mod post_comment_for_pull_request_input {
    /// A builder for [`PostCommentForPullRequestInput`](crate::input::PostCommentForPullRequestInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the repository where you want to post a comment on a pull request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to post a comment on a pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The content of your comment on the change.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of your comment on the change.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`PostCommentForPullRequestInput`](crate::input::PostCommentForPullRequestInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PostCommentForPullRequestInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PostCommentForPullRequestInput {
                pull_request_id: self.pull_request_id,
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                location: self.location,
                content: self.content,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type PostCommentForPullRequestInputOperationOutputAlias =
    crate::operation::PostCommentForPullRequest;
#[doc(hidden)]
pub type PostCommentForPullRequestInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PostCommentForPullRequestInput {
    /// Consumes the builder and constructs an Operation<[`PostCommentForPullRequest`](crate::operation::PostCommentForPullRequest)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PostCommentForPullRequest,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PostCommentForPullRequestInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PostCommentForPullRequestInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PostCommentForPullRequestInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.PostCommentForPullRequest",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_post_comment_for_pull_request(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PostCommentForPullRequest::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PostCommentForPullRequest",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PostCommentForPullRequestInput`](crate::input::PostCommentForPullRequestInput)
    pub fn builder() -> crate::input::post_comment_for_pull_request_input::Builder {
        crate::input::post_comment_for_pull_request_input::Builder::default()
    }
}

/// See [`PostCommentReplyInput`](crate::input::PostCommentReplyInput)
pub mod post_comment_reply_input {
    /// A builder for [`PostCommentReplyInput`](crate::input::PostCommentReplyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) in_reply_to: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn in_reply_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.in_reply_to = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_in_reply_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.in_reply_to = input;
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The contents of your reply to a comment.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The contents of your reply to a comment.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`PostCommentReplyInput`](crate::input::PostCommentReplyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PostCommentReplyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PostCommentReplyInput {
                in_reply_to: self.in_reply_to,
                client_request_token: self.client_request_token,
                content: self.content,
            })
        }
    }
}
#[doc(hidden)]
pub type PostCommentReplyInputOperationOutputAlias = crate::operation::PostCommentReply;
#[doc(hidden)]
pub type PostCommentReplyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PostCommentReplyInput {
    /// Consumes the builder and constructs an Operation<[`PostCommentReply`](crate::operation::PostCommentReply)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PostCommentReply,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PostCommentReplyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PostCommentReplyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PostCommentReplyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.PostCommentReply",
            );
            Ok(builder)
        }
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_post_comment_reply(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PostCommentReply::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PostCommentReply",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PostCommentReplyInput`](crate::input::PostCommentReplyInput)
    pub fn builder() -> crate::input::post_comment_reply_input::Builder {
        crate::input::post_comment_reply_input::Builder::default()
    }
}

/// See [`PutCommentReactionInput`](crate::input::PutCommentReactionInput)
pub mod put_comment_reaction_input {
    /// A builder for [`PutCommentReactionInput`](crate::input::PutCommentReactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
        pub(crate) reaction_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the comment to which you want to add or update a reaction.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The ID of the comment to which you want to add or update a reaction.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
        pub fn reaction_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.reaction_value = Some(input.into());
            self
        }
        /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
        pub fn set_reaction_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reaction_value = input;
            self
        }
        /// Consumes the builder and constructs a [`PutCommentReactionInput`](crate::input::PutCommentReactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutCommentReactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutCommentReactionInput {
                comment_id: self.comment_id,
                reaction_value: self.reaction_value,
            })
        }
    }
}
#[doc(hidden)]
pub type PutCommentReactionInputOperationOutputAlias = crate::operation::PutCommentReaction;
#[doc(hidden)]
pub type PutCommentReactionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutCommentReactionInput {
    /// Consumes the builder and constructs an Operation<[`PutCommentReaction`](crate::operation::PutCommentReaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutCommentReaction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutCommentReactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutCommentReactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutCommentReactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.PutCommentReaction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_comment_reaction(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutCommentReaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutCommentReaction",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutCommentReactionInput`](crate::input::PutCommentReactionInput)
    pub fn builder() -> crate::input::put_comment_reaction_input::Builder {
        crate::input::put_comment_reaction_input::Builder::default()
    }
}

/// See [`PutFileInput`](crate::input::PutFileInput)
pub mod put_file_input {
    /// A builder for [`PutFileInput`](crate::input::PutFileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) file_content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
        pub(crate) parent_commit_id: std::option::Option<std::string::String>,
        pub(crate) commit_message: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to add or update the file.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to add or update the file.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p>The content of the file, in binary object format. </p>
        pub fn file_content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.file_content = Some(input);
            self
        }
        /// <p>The content of the file, in binary object format. </p>
        pub fn set_file_content(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.file_content = input;
            self
        }
        /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note>
        /// <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p>
        /// </note>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note>
        /// <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p>
        /// </note>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
        /// <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>
        pub fn parent_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
        /// <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_commit_id = input;
            self
        }
        /// <p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>
        pub fn commit_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_message = Some(input.into());
            self
        }
        /// <p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.commit_message = input;
            self
        }
        /// <p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An email address for the person adding or updating the file.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>An email address for the person adding or updating the file.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFileInput`](crate::input::PutFileInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PutFileInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PutFileInput {
                repository_name: self.repository_name,
                branch_name: self.branch_name,
                file_content: self.file_content,
                file_path: self.file_path,
                file_mode: self.file_mode,
                parent_commit_id: self.parent_commit_id,
                commit_message: self.commit_message,
                name: self.name,
                email: self.email,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFileInputOperationOutputAlias = crate::operation::PutFile;
#[doc(hidden)]
pub type PutFileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutFileInput {
    /// Consumes the builder and constructs an Operation<[`PutFile`](crate::operation::PutFile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutFileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutFileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutFileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.PutFile",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_file(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::PutFile::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "PutFile",
                    "codecommit",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutFileInput`](crate::input::PutFileInput)
    pub fn builder() -> crate::input::put_file_input::Builder {
        crate::input::put_file_input::Builder::default()
    }
}

/// See [`PutRepositoryTriggersInput`](crate::input::PutRepositoryTriggersInput)
pub mod put_repository_triggers_input {
    /// A builder for [`PutRepositoryTriggersInput`](crate::input::PutRepositoryTriggersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
    }
    impl Builder {
        /// <p>The name of the repository where you want to create or update the trigger.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you want to create or update the trigger.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn triggers(mut self, input: crate::model::RepositoryTrigger) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input);
            self.triggers = Some(v);
            self
        }
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRepositoryTriggersInput`](crate::input::PutRepositoryTriggersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRepositoryTriggersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRepositoryTriggersInput {
                repository_name: self.repository_name,
                triggers: self.triggers,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRepositoryTriggersInputOperationOutputAlias = crate::operation::PutRepositoryTriggers;
#[doc(hidden)]
pub type PutRepositoryTriggersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutRepositoryTriggersInput {
    /// Consumes the builder and constructs an Operation<[`PutRepositoryTriggers`](crate::operation::PutRepositoryTriggers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRepositoryTriggers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRepositoryTriggersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRepositoryTriggersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRepositoryTriggersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.PutRepositoryTriggers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_repository_triggers(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRepositoryTriggers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRepositoryTriggers",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRepositoryTriggersInput`](crate::input::PutRepositoryTriggersInput)
    pub fn builder() -> crate::input::put_repository_triggers_input::Builder {
        crate::input::put_repository_triggers_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair to use when tagging this repository.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The key-value pair to use when tagging this repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.TagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestRepositoryTriggersInput`](crate::input::TestRepositoryTriggersInput)
pub mod test_repository_triggers_input {
    /// A builder for [`TestRepositoryTriggersInput`](crate::input::TestRepositoryTriggersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
    }
    impl Builder {
        /// <p>The name of the repository in which to test the triggers.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository in which to test the triggers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The list of triggers to test.</p>
        pub fn triggers(mut self, input: crate::model::RepositoryTrigger) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input);
            self.triggers = Some(v);
            self
        }
        /// <p>The list of triggers to test.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// Consumes the builder and constructs a [`TestRepositoryTriggersInput`](crate::input::TestRepositoryTriggersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestRepositoryTriggersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestRepositoryTriggersInput {
                repository_name: self.repository_name,
                triggers: self.triggers,
            })
        }
    }
}
#[doc(hidden)]
pub type TestRepositoryTriggersInputOperationOutputAlias = crate::operation::TestRepositoryTriggers;
#[doc(hidden)]
pub type TestRepositoryTriggersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TestRepositoryTriggersInput {
    /// Consumes the builder and constructs an Operation<[`TestRepositoryTriggers`](crate::operation::TestRepositoryTriggers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestRepositoryTriggers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestRepositoryTriggersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestRepositoryTriggersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestRepositoryTriggersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.TestRepositoryTriggers",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_test_repository_triggers(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestRepositoryTriggers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestRepositoryTriggers",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestRepositoryTriggersInput`](crate::input::TestRepositoryTriggersInput)
    pub fn builder() -> crate::input::test_repository_triggers_input::Builder {
        crate::input::test_repository_triggers_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UntagResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateApprovalRuleTemplateContentInput`](crate::input::UpdateApprovalRuleTemplateContentInput)
pub mod update_approval_rule_template_content_input {
    /// A builder for [`UpdateApprovalRuleTemplateContentInput`](crate::input::UpdateApprovalRuleTemplateContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) new_rule_content: std::option::Option<std::string::String>,
        pub(crate) existing_rule_content_sha256: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// <p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>
        pub fn new_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_rule_content = Some(input.into());
            self
        }
        /// <p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>
        pub fn set_new_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_rule_content = input;
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn existing_rule_content_sha256(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.existing_rule_content_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn set_existing_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.existing_rule_content_sha256 = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApprovalRuleTemplateContentInput`](crate::input::UpdateApprovalRuleTemplateContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApprovalRuleTemplateContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApprovalRuleTemplateContentInput {
                approval_rule_template_name: self.approval_rule_template_name,
                new_rule_content: self.new_rule_content,
                existing_rule_content_sha256: self.existing_rule_content_sha256,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApprovalRuleTemplateContentInputOperationOutputAlias =
    crate::operation::UpdateApprovalRuleTemplateContent;
#[doc(hidden)]
pub type UpdateApprovalRuleTemplateContentInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApprovalRuleTemplateContentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApprovalRuleTemplateContent`](crate::operation::UpdateApprovalRuleTemplateContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApprovalRuleTemplateContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApprovalRuleTemplateContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApprovalRuleTemplateContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApprovalRuleTemplateContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdateApprovalRuleTemplateContent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_approval_rule_template_content(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApprovalRuleTemplateContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApprovalRuleTemplateContent",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateContentInput`](crate::input::UpdateApprovalRuleTemplateContentInput)
    pub fn builder() -> crate::input::update_approval_rule_template_content_input::Builder {
        crate::input::update_approval_rule_template_content_input::Builder::default()
    }
}

/// See [`UpdateApprovalRuleTemplateDescriptionInput`](crate::input::UpdateApprovalRuleTemplateDescriptionInput)
pub mod update_approval_rule_template_description_input {
    /// A builder for [`UpdateApprovalRuleTemplateDescriptionInput`](crate::input::UpdateApprovalRuleTemplateDescriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) approval_rule_template_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the template for which you want to update the description.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the template for which you want to update the description.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// <p>The updated description of the approval rule template.</p>
        pub fn approval_rule_template_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_description = Some(input.into());
            self
        }
        /// <p>The updated description of the approval rule template.</p>
        pub fn set_approval_rule_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApprovalRuleTemplateDescriptionInput`](crate::input::UpdateApprovalRuleTemplateDescriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApprovalRuleTemplateDescriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApprovalRuleTemplateDescriptionInput {
                approval_rule_template_name: self.approval_rule_template_name,
                approval_rule_template_description: self.approval_rule_template_description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApprovalRuleTemplateDescriptionInputOperationOutputAlias =
    crate::operation::UpdateApprovalRuleTemplateDescription;
#[doc(hidden)]
pub type UpdateApprovalRuleTemplateDescriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApprovalRuleTemplateDescriptionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApprovalRuleTemplateDescription`](crate::operation::UpdateApprovalRuleTemplateDescription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApprovalRuleTemplateDescription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApprovalRuleTemplateDescriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApprovalRuleTemplateDescriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApprovalRuleTemplateDescriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdateApprovalRuleTemplateDescription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_approval_rule_template_description(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApprovalRuleTemplateDescription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApprovalRuleTemplateDescription",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateDescriptionInput`](crate::input::UpdateApprovalRuleTemplateDescriptionInput)
    pub fn builder() -> crate::input::update_approval_rule_template_description_input::Builder {
        crate::input::update_approval_rule_template_description_input::Builder::default()
    }
}

/// See [`UpdateApprovalRuleTemplateNameInput`](crate::input::UpdateApprovalRuleTemplateNameInput)
pub mod update_approval_rule_template_name_input {
    /// A builder for [`UpdateApprovalRuleTemplateNameInput`](crate::input::UpdateApprovalRuleTemplateNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) old_approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) new_approval_rule_template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current name of the approval rule template.</p>
        pub fn old_approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.old_approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The current name of the approval rule template.</p>
        pub fn set_old_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.old_approval_rule_template_name = input;
            self
        }
        /// <p>The new name you want to apply to the approval rule template.</p>
        pub fn new_approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.new_approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The new name you want to apply to the approval rule template.</p>
        pub fn set_new_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_approval_rule_template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApprovalRuleTemplateNameInput`](crate::input::UpdateApprovalRuleTemplateNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateApprovalRuleTemplateNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateApprovalRuleTemplateNameInput {
                old_approval_rule_template_name: self.old_approval_rule_template_name,
                new_approval_rule_template_name: self.new_approval_rule_template_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateApprovalRuleTemplateNameInputOperationOutputAlias =
    crate::operation::UpdateApprovalRuleTemplateName;
#[doc(hidden)]
pub type UpdateApprovalRuleTemplateNameInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateApprovalRuleTemplateNameInput {
    /// Consumes the builder and constructs an Operation<[`UpdateApprovalRuleTemplateName`](crate::operation::UpdateApprovalRuleTemplateName)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateApprovalRuleTemplateName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateApprovalRuleTemplateNameInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateApprovalRuleTemplateNameInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateApprovalRuleTemplateNameInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdateApprovalRuleTemplateName",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_approval_rule_template_name(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateApprovalRuleTemplateName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateApprovalRuleTemplateName",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateNameInput`](crate::input::UpdateApprovalRuleTemplateNameInput)
    pub fn builder() -> crate::input::update_approval_rule_template_name_input::Builder {
        crate::input::update_approval_rule_template_name_input::Builder::default()
    }
}

/// See [`UpdateCommentInput`](crate::input::UpdateCommentInput)
pub mod update_comment_input {
    /// A builder for [`UpdateCommentInput`](crate::input::UpdateCommentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the comment you want to update. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the comment you want to update. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// <p>The updated content to replace the existing content of the comment.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The updated content to replace the existing content of the comment.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCommentInput`](crate::input::UpdateCommentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCommentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCommentInput {
                comment_id: self.comment_id,
                content: self.content,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCommentInputOperationOutputAlias = crate::operation::UpdateComment;
#[doc(hidden)]
pub type UpdateCommentInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCommentInput {
    /// Consumes the builder and constructs an Operation<[`UpdateComment`](crate::operation::UpdateComment)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateComment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCommentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCommentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCommentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdateComment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_comment(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateComment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateComment",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCommentInput`](crate::input::UpdateCommentInput)
    pub fn builder() -> crate::input::update_comment_input::Builder {
        crate::input::update_comment_input::Builder::default()
    }
}

/// See [`UpdateDefaultBranchInput`](crate::input::UpdateDefaultBranchInput)
pub mod update_default_branch_input {
    /// A builder for [`UpdateDefaultBranchInput`](crate::input::UpdateDefaultBranchInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) default_branch_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository to set or change the default branch for.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to set or change the default branch for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the branch to set as the default.</p>
        pub fn default_branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_branch_name = Some(input.into());
            self
        }
        /// <p>The name of the branch to set as the default.</p>
        pub fn set_default_branch_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_branch_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDefaultBranchInput`](crate::input::UpdateDefaultBranchInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDefaultBranchInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDefaultBranchInput {
                repository_name: self.repository_name,
                default_branch_name: self.default_branch_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDefaultBranchInputOperationOutputAlias = crate::operation::UpdateDefaultBranch;
#[doc(hidden)]
pub type UpdateDefaultBranchInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDefaultBranchInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDefaultBranch`](crate::operation::UpdateDefaultBranch)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDefaultBranch,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDefaultBranchInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDefaultBranchInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDefaultBranchInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdateDefaultBranch",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_default_branch(&self)?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDefaultBranch::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDefaultBranch",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDefaultBranchInput`](crate::input::UpdateDefaultBranchInput)
    pub fn builder() -> crate::input::update_default_branch_input::Builder {
        crate::input::update_default_branch_input::Builder::default()
    }
}

/// See [`UpdatePullRequestApprovalRuleContentInput`](crate::input::UpdatePullRequestApprovalRuleContentInput)
pub mod update_pull_request_approval_rule_content_input {
    /// A builder for [`UpdatePullRequestApprovalRuleContentInput`](crate::input::UpdatePullRequestApprovalRuleContentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) approval_rule_name: std::option::Option<std::string::String>,
        pub(crate) existing_rule_content_sha256: std::option::Option<std::string::String>,
        pub(crate) new_rule_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the approval rule you want to update.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule you want to update.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_name = input;
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn existing_rule_content_sha256(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.existing_rule_content_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
        pub fn set_existing_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.existing_rule_content_sha256 = input;
            self
        }
        /// <p>The updated content for the approval rule.</p> <note>
        /// <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn new_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_rule_content = Some(input.into());
            self
        }
        /// <p>The updated content for the approval rule.</p> <note>
        /// <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
        /// <ul>
        /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
        /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
        /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
        /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
        /// </note>
        pub fn set_new_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_rule_content = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestApprovalRuleContentInput`](crate::input::UpdatePullRequestApprovalRuleContentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePullRequestApprovalRuleContentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePullRequestApprovalRuleContentInput {
                pull_request_id: self.pull_request_id,
                approval_rule_name: self.approval_rule_name,
                existing_rule_content_sha256: self.existing_rule_content_sha256,
                new_rule_content: self.new_rule_content,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePullRequestApprovalRuleContentInputOperationOutputAlias =
    crate::operation::UpdatePullRequestApprovalRuleContent;
#[doc(hidden)]
pub type UpdatePullRequestApprovalRuleContentInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePullRequestApprovalRuleContentInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePullRequestApprovalRuleContent`](crate::operation::UpdatePullRequestApprovalRuleContent)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePullRequestApprovalRuleContent,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePullRequestApprovalRuleContentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePullRequestApprovalRuleContentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePullRequestApprovalRuleContentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdatePullRequestApprovalRuleContent",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pull_request_approval_rule_content(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePullRequestApprovalRuleContent::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePullRequestApprovalRuleContent",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestApprovalRuleContentInput`](crate::input::UpdatePullRequestApprovalRuleContentInput)
    pub fn builder() -> crate::input::update_pull_request_approval_rule_content_input::Builder {
        crate::input::update_pull_request_approval_rule_content_input::Builder::default()
    }
}

/// See [`UpdatePullRequestApprovalStateInput`](crate::input::UpdatePullRequestApprovalStateInput)
pub mod update_pull_request_approval_state_input {
    /// A builder for [`UpdatePullRequestApprovalStateInput`](crate::input::UpdatePullRequestApprovalStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) approval_state: std::option::Option<crate::model::ApprovalState>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The system-generated ID of the revision.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The approval state to associate with the user on the pull request.</p>
        pub fn approval_state(mut self, input: crate::model::ApprovalState) -> Self {
            self.approval_state = Some(input);
            self
        }
        /// <p>The approval state to associate with the user on the pull request.</p>
        pub fn set_approval_state(
            mut self,
            input: std::option::Option<crate::model::ApprovalState>,
        ) -> Self {
            self.approval_state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestApprovalStateInput`](crate::input::UpdatePullRequestApprovalStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePullRequestApprovalStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePullRequestApprovalStateInput {
                pull_request_id: self.pull_request_id,
                revision_id: self.revision_id,
                approval_state: self.approval_state,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePullRequestApprovalStateInputOperationOutputAlias =
    crate::operation::UpdatePullRequestApprovalState;
#[doc(hidden)]
pub type UpdatePullRequestApprovalStateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePullRequestApprovalStateInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePullRequestApprovalState`](crate::operation::UpdatePullRequestApprovalState)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePullRequestApprovalState,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePullRequestApprovalStateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePullRequestApprovalStateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePullRequestApprovalStateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdatePullRequestApprovalState",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pull_request_approval_state(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePullRequestApprovalState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePullRequestApprovalState",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestApprovalStateInput`](crate::input::UpdatePullRequestApprovalStateInput)
    pub fn builder() -> crate::input::update_pull_request_approval_state_input::Builder {
        crate::input::update_pull_request_approval_state_input::Builder::default()
    }
}

/// See [`UpdatePullRequestDescriptionInput`](crate::input::UpdatePullRequestDescriptionInput)
pub mod update_pull_request_description_input {
    /// A builder for [`UpdatePullRequestDescriptionInput`](crate::input::UpdatePullRequestDescriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The updated content of the description for the pull request. This content replaces the existing description.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The updated content of the description for the pull request. This content replaces the existing description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestDescriptionInput`](crate::input::UpdatePullRequestDescriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePullRequestDescriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePullRequestDescriptionInput {
                pull_request_id: self.pull_request_id,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePullRequestDescriptionInputOperationOutputAlias =
    crate::operation::UpdatePullRequestDescription;
#[doc(hidden)]
pub type UpdatePullRequestDescriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePullRequestDescriptionInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePullRequestDescription`](crate::operation::UpdatePullRequestDescription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePullRequestDescription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePullRequestDescriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePullRequestDescriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePullRequestDescriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdatePullRequestDescription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pull_request_description(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePullRequestDescription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePullRequestDescription",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestDescriptionInput`](crate::input::UpdatePullRequestDescriptionInput)
    pub fn builder() -> crate::input::update_pull_request_description_input::Builder {
        crate::input::update_pull_request_description_input::Builder::default()
    }
}

/// See [`UpdatePullRequestStatusInput`](crate::input::UpdatePullRequestStatusInput)
pub mod update_pull_request_status_input {
    /// A builder for [`UpdatePullRequestStatusInput`](crate::input::UpdatePullRequestStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>
        pub fn pull_request_status(mut self, input: crate::model::PullRequestStatusEnum) -> Self {
            self.pull_request_status = Some(input);
            self
        }
        /// <p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.pull_request_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestStatusInput`](crate::input::UpdatePullRequestStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePullRequestStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePullRequestStatusInput {
                pull_request_id: self.pull_request_id,
                pull_request_status: self.pull_request_status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePullRequestStatusInputOperationOutputAlias =
    crate::operation::UpdatePullRequestStatus;
#[doc(hidden)]
pub type UpdatePullRequestStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePullRequestStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePullRequestStatus`](crate::operation::UpdatePullRequestStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePullRequestStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePullRequestStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePullRequestStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePullRequestStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdatePullRequestStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pull_request_status(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePullRequestStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePullRequestStatus",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestStatusInput`](crate::input::UpdatePullRequestStatusInput)
    pub fn builder() -> crate::input::update_pull_request_status_input::Builder {
        crate::input::update_pull_request_status_input::Builder::default()
    }
}

/// See [`UpdatePullRequestTitleInput`](crate::input::UpdatePullRequestTitleInput)
pub mod update_pull_request_title_input {
    /// A builder for [`UpdatePullRequestTitleInput`](crate::input::UpdatePullRequestTitleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The updated title of the pull request. This replaces the existing title.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The updated title of the pull request. This replaces the existing title.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestTitleInput`](crate::input::UpdatePullRequestTitleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePullRequestTitleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePullRequestTitleInput {
                pull_request_id: self.pull_request_id,
                title: self.title,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePullRequestTitleInputOperationOutputAlias = crate::operation::UpdatePullRequestTitle;
#[doc(hidden)]
pub type UpdatePullRequestTitleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePullRequestTitleInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePullRequestTitle`](crate::operation::UpdatePullRequestTitle)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePullRequestTitle,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePullRequestTitleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePullRequestTitleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePullRequestTitleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdatePullRequestTitle",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_pull_request_title(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePullRequestTitle::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePullRequestTitle",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestTitleInput`](crate::input::UpdatePullRequestTitleInput)
    pub fn builder() -> crate::input::update_pull_request_title_input::Builder {
        crate::input::update_pull_request_title_input::Builder::default()
    }
}

/// See [`UpdateRepositoryDescriptionInput`](crate::input::UpdateRepositoryDescriptionInput)
pub mod update_repository_description_input {
    /// A builder for [`UpdateRepositoryDescriptionInput`](crate::input::UpdateRepositoryDescriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) repository_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository to set or change the comment or description for.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository to set or change the comment or description for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
        pub fn repository_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_description = Some(input.into());
            self
        }
        /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
        pub fn set_repository_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRepositoryDescriptionInput`](crate::input::UpdateRepositoryDescriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRepositoryDescriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRepositoryDescriptionInput {
                repository_name: self.repository_name,
                repository_description: self.repository_description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRepositoryDescriptionInputOperationOutputAlias =
    crate::operation::UpdateRepositoryDescription;
#[doc(hidden)]
pub type UpdateRepositoryDescriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRepositoryDescriptionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRepositoryDescription`](crate::operation::UpdateRepositoryDescription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRepositoryDescription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRepositoryDescriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRepositoryDescriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRepositoryDescriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdateRepositoryDescription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_repository_description(&self)?
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRepositoryDescription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRepositoryDescription",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryDescriptionInput`](crate::input::UpdateRepositoryDescriptionInput)
    pub fn builder() -> crate::input::update_repository_description_input::Builder {
        crate::input::update_repository_description_input::Builder::default()
    }
}

/// See [`UpdateRepositoryNameInput`](crate::input::UpdateRepositoryNameInput)
pub mod update_repository_name_input {
    /// A builder for [`UpdateRepositoryNameInput`](crate::input::UpdateRepositoryNameInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) old_name: std::option::Option<std::string::String>,
        pub(crate) new_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current name of the repository.</p>
        pub fn old_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.old_name = Some(input.into());
            self
        }
        /// <p>The current name of the repository.</p>
        pub fn set_old_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.old_name = input;
            self
        }
        /// <p>The new name for the repository.</p>
        pub fn new_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_name = Some(input.into());
            self
        }
        /// <p>The new name for the repository.</p>
        pub fn set_new_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.new_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRepositoryNameInput`](crate::input::UpdateRepositoryNameInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRepositoryNameInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRepositoryNameInput {
                old_name: self.old_name,
                new_name: self.new_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRepositoryNameInputOperationOutputAlias = crate::operation::UpdateRepositoryName;
#[doc(hidden)]
pub type UpdateRepositoryNameInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRepositoryNameInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRepositoryName`](crate::operation::UpdateRepositoryName)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRepositoryName,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRepositoryNameInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRepositoryNameInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRepositoryNameInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "CodeCommit_20150413.UpdateRepositoryName",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_repository_name(
                &self,
            )?,
        );
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRepositoryName::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRepositoryName",
            "codecommit",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryNameInput`](crate::input::UpdateRepositoryNameInput)
    pub fn builder() -> crate::input::update_repository_name_input::Builder {
        crate::input::update_repository_name_input::Builder::default()
    }
}

/// <p>Represents the input of an update repository description operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRepositoryNameInput {
    /// <p>The current name of the repository.</p>
    pub old_name: std::option::Option<std::string::String>,
    /// <p>The new name for the repository.</p>
    pub new_name: std::option::Option<std::string::String>,
}
impl UpdateRepositoryNameInput {
    /// <p>The current name of the repository.</p>
    pub fn old_name(&self) -> std::option::Option<&str> {
        self.old_name.as_deref()
    }
    /// <p>The new name for the repository.</p>
    pub fn new_name(&self) -> std::option::Option<&str> {
        self.new_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateRepositoryNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRepositoryNameInput");
        formatter.field("old_name", &self.old_name);
        formatter.field("new_name", &self.new_name);
        formatter.finish()
    }
}

/// <p>Represents the input of an update repository description operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRepositoryDescriptionInput {
    /// <p>The name of the repository to set or change the comment or description for.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
    pub repository_description: std::option::Option<std::string::String>,
}
impl UpdateRepositoryDescriptionInput {
    /// <p>The name of the repository to set or change the comment or description for.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
    pub fn repository_description(&self) -> std::option::Option<&str> {
        self.repository_description.as_deref()
    }
}
impl std::fmt::Debug for UpdateRepositoryDescriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRepositoryDescriptionInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("repository_description", &self.repository_description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestTitleInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The updated title of the pull request. This replaces the existing title.</p>
    pub title: std::option::Option<std::string::String>,
}
impl UpdatePullRequestTitleInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The updated title of the pull request. This replaces the existing title.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
}
impl std::fmt::Debug for UpdatePullRequestTitleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestTitleInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("title", &self.title);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestStatusInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>
    pub pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
}
impl UpdatePullRequestStatusInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The status of the pull request. The only valid operations are to update the status from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or from <code>CLOSED</code> to <code>CLOSED</code>.</p>
    pub fn pull_request_status(&self) -> std::option::Option<&crate::model::PullRequestStatusEnum> {
        self.pull_request_status.as_ref()
    }
}
impl std::fmt::Debug for UpdatePullRequestStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestStatusInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("pull_request_status", &self.pull_request_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestDescriptionInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The updated content of the description for the pull request. This content replaces the existing description.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdatePullRequestDescriptionInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The updated content of the description for the pull request. This content replaces the existing description.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdatePullRequestDescriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestDescriptionInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestApprovalStateInput {
    /// <p>The system-generated ID of the pull request.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The system-generated ID of the revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The approval state to associate with the user on the pull request.</p>
    pub approval_state: std::option::Option<crate::model::ApprovalState>,
}
impl UpdatePullRequestApprovalStateInput {
    /// <p>The system-generated ID of the pull request.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The system-generated ID of the revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The approval state to associate with the user on the pull request.</p>
    pub fn approval_state(&self) -> std::option::Option<&crate::model::ApprovalState> {
        self.approval_state.as_ref()
    }
}
impl std::fmt::Debug for UpdatePullRequestApprovalStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestApprovalStateInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("approval_state", &self.approval_state);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestApprovalRuleContentInput {
    /// <p>The system-generated ID of the pull request.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the approval rule you want to update.</p>
    pub approval_rule_name: std::option::Option<std::string::String>,
    /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
    pub existing_rule_content_sha256: std::option::Option<std::string::String>,
    /// <p>The updated content for the approval rule.</p> <note>
    /// <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
    /// <ul>
    /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
    /// <ul>
    /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
    /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
    /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
    /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
    /// </ul>
    /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    pub new_rule_content: std::option::Option<std::string::String>,
}
impl UpdatePullRequestApprovalRuleContentInput {
    /// <p>The system-generated ID of the pull request.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the approval rule you want to update.</p>
    pub fn approval_rule_name(&self) -> std::option::Option<&str> {
        self.approval_rule_name.as_deref()
    }
    /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
    pub fn existing_rule_content_sha256(&self) -> std::option::Option<&str> {
        self.existing_rule_content_sha256.as_deref()
    }
    /// <p>The updated content for the approval rule.</p> <note>
    /// <p>When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
    /// <ul>
    /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
    /// <ul>
    /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
    /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
    /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
    /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
    /// </ul>
    /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    pub fn new_rule_content(&self) -> std::option::Option<&str> {
        self.new_rule_content.as_deref()
    }
}
impl std::fmt::Debug for UpdatePullRequestApprovalRuleContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestApprovalRuleContentInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("approval_rule_name", &self.approval_rule_name);
        formatter.field(
            "existing_rule_content_sha256",
            &self.existing_rule_content_sha256,
        );
        formatter.field("new_rule_content", &self.new_rule_content);
        formatter.finish()
    }
}

/// <p>Represents the input of an update default branch operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDefaultBranchInput {
    /// <p>The name of the repository to set or change the default branch for.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the branch to set as the default.</p>
    pub default_branch_name: std::option::Option<std::string::String>,
}
impl UpdateDefaultBranchInput {
    /// <p>The name of the repository to set or change the default branch for.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the branch to set as the default.</p>
    pub fn default_branch_name(&self) -> std::option::Option<&str> {
        self.default_branch_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateDefaultBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDefaultBranchInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("default_branch_name", &self.default_branch_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCommentInput {
    /// <p>The system-generated ID of the comment you want to update. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub comment_id: std::option::Option<std::string::String>,
    /// <p>The updated content to replace the existing content of the comment.</p>
    pub content: std::option::Option<std::string::String>,
}
impl UpdateCommentInput {
    /// <p>The system-generated ID of the comment you want to update. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
    /// <p>The updated content to replace the existing content of the comment.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
}
impl std::fmt::Debug for UpdateCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCommentInput");
        formatter.field("comment_id", &self.comment_id);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApprovalRuleTemplateNameInput {
    /// <p>The current name of the approval rule template.</p>
    pub old_approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The new name you want to apply to the approval rule template.</p>
    pub new_approval_rule_template_name: std::option::Option<std::string::String>,
}
impl UpdateApprovalRuleTemplateNameInput {
    /// <p>The current name of the approval rule template.</p>
    pub fn old_approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.old_approval_rule_template_name.as_deref()
    }
    /// <p>The new name you want to apply to the approval rule template.</p>
    pub fn new_approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.new_approval_rule_template_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateApprovalRuleTemplateNameInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApprovalRuleTemplateNameInput");
        formatter.field(
            "old_approval_rule_template_name",
            &self.old_approval_rule_template_name,
        );
        formatter.field(
            "new_approval_rule_template_name",
            &self.new_approval_rule_template_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApprovalRuleTemplateDescriptionInput {
    /// <p>The name of the template for which you want to update the description.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The updated description of the approval rule template.</p>
    pub approval_rule_template_description: std::option::Option<std::string::String>,
}
impl UpdateApprovalRuleTemplateDescriptionInput {
    /// <p>The name of the template for which you want to update the description.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The updated description of the approval rule template.</p>
    pub fn approval_rule_template_description(&self) -> std::option::Option<&str> {
        self.approval_rule_template_description.as_deref()
    }
}
impl std::fmt::Debug for UpdateApprovalRuleTemplateDescriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApprovalRuleTemplateDescriptionInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field(
            "approval_rule_template_description",
            &self.approval_rule_template_description,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApprovalRuleTemplateContentInput {
    /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>
    pub new_rule_content: std::option::Option<std::string::String>,
    /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
    pub existing_rule_content_sha256: std::option::Option<std::string::String>,
}
impl UpdateApprovalRuleTemplateContentInput {
    /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The content that replaces the existing content of the rule. Content statements must be complete. You cannot provide only the changes.</p>
    pub fn new_rule_content(&self) -> std::option::Option<&str> {
        self.new_rule_content.as_deref()
    }
    /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using <code>GetPullRequest</code>.</p>
    pub fn existing_rule_content_sha256(&self) -> std::option::Option<&str> {
        self.existing_rule_content_sha256.as_deref()
    }
}
impl std::fmt::Debug for UpdateApprovalRuleTemplateContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApprovalRuleTemplateContentInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field("new_rule_content", &self.new_rule_content);
        formatter.field(
            "existing_rule_content_sha256",
            &self.existing_rule_content_sha256,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag key for each tag that you want to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag key for each tag that you want to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// <p>Represents the input of a test repository triggers operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestRepositoryTriggersInput {
    /// <p>The name of the repository in which to test the triggers.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The list of triggers to test.</p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
}
impl TestRepositoryTriggersInput {
    /// <p>The name of the repository in which to test the triggers.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The list of triggers to test.</p>
    pub fn triggers(&self) -> std::option::Option<&[crate::model::RepositoryTrigger]> {
        self.triggers.as_deref()
    }
}
impl std::fmt::Debug for TestRepositoryTriggersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestRepositoryTriggersInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("triggers", &self.triggers);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key-value pair to use when tagging this repository.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key-value pair to use when tagging this repository.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p>Represents the input of a put repository triggers operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRepositoryTriggersInput {
    /// <p>The name of the repository where you want to create or update the trigger.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The JSON block of configuration information for each trigger.</p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
}
impl PutRepositoryTriggersInput {
    /// <p>The name of the repository where you want to create or update the trigger.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The JSON block of configuration information for each trigger.</p>
    pub fn triggers(&self) -> std::option::Option<&[crate::model::RepositoryTrigger]> {
        self.triggers.as_deref()
    }
}
impl std::fmt::Debug for PutRepositoryTriggersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRepositoryTriggersInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("triggers", &self.triggers);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFileInput {
    /// <p>The name of the repository where you want to add or update the file.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p>The content of the file, in binary object format. </p>
    pub file_content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note>
    /// <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p>
    /// </note>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
    /// <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>
    pub parent_commit_id: std::option::Option<std::string::String>,
    /// <p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An email address for the person adding or updating the file.</p>
    pub email: std::option::Option<std::string::String>,
}
impl PutFileInput {
    /// <p>The name of the repository where you want to add or update the file.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p>The content of the file, in binary object format. </p>
    pub fn file_content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.file_content.as_ref()
    }
    /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p> <note>
    /// <p>If the path does not currently exist in the repository, the path is created as part of adding the file.</p>
    /// </note>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The file mode permissions of the blob. Valid file mode permissions are listed here.</p>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
    /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
    /// <p>The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.</p>
    pub fn parent_commit_id(&self) -> std::option::Option<&str> {
        self.parent_commit_id.as_deref()
    }
    /// <p>A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An email address for the person adding or updating the file.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
}
impl std::fmt::Debug for PutFileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFileInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("file_content", &self.file_content);
        formatter.field("file_path", &self.file_path);
        formatter.field("file_mode", &self.file_mode);
        formatter.field("parent_commit_id", &self.parent_commit_id);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("name", &self.name);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutCommentReactionInput {
    /// <p>The ID of the comment to which you want to add or update a reaction.</p>
    pub comment_id: std::option::Option<std::string::String>,
    /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
    pub reaction_value: std::option::Option<std::string::String>,
}
impl PutCommentReactionInput {
    /// <p>The ID of the comment to which you want to add or update a reaction.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
    /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none. For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
    pub fn reaction_value(&self) -> std::option::Option<&str> {
        self.reaction_value.as_deref()
    }
}
impl std::fmt::Debug for PutCommentReactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutCommentReactionInput");
        formatter.field("comment_id", &self.comment_id);
        formatter.field("reaction_value", &self.reaction_value);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostCommentReplyInput {
    /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub in_reply_to: std::option::Option<std::string::String>,
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The contents of your reply to a comment.</p>
    pub content: std::option::Option<std::string::String>,
}
impl PostCommentReplyInput {
    /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub fn in_reply_to(&self) -> std::option::Option<&str> {
        self.in_reply_to.as_deref()
    }
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The contents of your reply to a comment.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
}
impl std::fmt::Debug for PostCommentReplyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostCommentReplyInput");
        formatter.field("in_reply_to", &self.in_reply_to);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("content", &self.content);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostCommentForPullRequestInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository where you want to post a comment on a pull request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The content of your comment on the change.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl PostCommentForPullRequestInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the repository where you want to post a comment on a pull request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>The location of the change where you want to post your comment. If no location is provided, the comment is posted as a general comment on the pull request difference between the before commit ID and the after commit ID.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>The content of your comment on the change.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for PostCommentForPullRequestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostCommentForPullRequestInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("location", &self.location);
        formatter.field("content", &self.content);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostCommentForComparedCommitInput {
    /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>The location of the comparison where you want to comment.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The content of the comment you want to make.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl PostCommentForComparedCommitInput {
    /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>To establish the directionality of the comparison, the full commit ID of the before commit. Required for commenting on any commit unless that commit is the initial commit.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>The location of the comparison where you want to comment.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>The content of the comment you want to make.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for PostCommentForComparedCommitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostCommentForComparedCommitInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("location", &self.location);
        formatter.field("content", &self.content);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OverridePullRequestApprovalRulesInput {
    /// <p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <code>GetPullRequest</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>
    pub override_status: std::option::Option<crate::model::OverrideStatus>,
}
impl OverridePullRequestApprovalRulesInput {
    /// <p>The system-generated ID of the pull request for which you want to override all approval rule requirements. To get this information, use <code>GetPullRequest</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request. To get the revision ID, use GetPullRequest.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply approval rule requirements (REVOKE). REVOKE status is not stored.</p>
    pub fn override_status(&self) -> std::option::Option<&crate::model::OverrideStatus> {
        self.override_status.as_ref()
    }
}
impl std::fmt::Debug for OverridePullRequestApprovalRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OverridePullRequestApprovalRulesInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("override_status", &self.override_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergePullRequestByThreeWayInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository where the pull request was created.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>The commit message to include in the commit information for the merge.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub author_name: std::option::Option<std::string::String>,
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub keep_empty_folders: bool,
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
}
impl MergePullRequestByThreeWayInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the repository where the pull request was created.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>The commit message to include in the commit information for the merge.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub fn author_name(&self) -> std::option::Option<&str> {
        self.author_name.as_deref()
    }
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub fn keep_empty_folders(&self) -> bool {
        self.keep_empty_folders
    }
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub fn conflict_resolution(&self) -> std::option::Option<&crate::model::ConflictResolution> {
        self.conflict_resolution.as_ref()
    }
}
impl std::fmt::Debug for MergePullRequestByThreeWayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergePullRequestByThreeWayInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("commit_message", &self.commit_message);
        formatter.field("author_name", &self.author_name);
        formatter.field("email", &self.email);
        formatter.field("keep_empty_folders", &self.keep_empty_folders);
        formatter.field("conflict_resolution", &self.conflict_resolution);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergePullRequestBySquashInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository where the pull request was created.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>The commit message to include in the commit information for the merge.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub author_name: std::option::Option<std::string::String>,
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub keep_empty_folders: bool,
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
}
impl MergePullRequestBySquashInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the repository where the pull request was created.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>The commit message to include in the commit information for the merge.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub fn author_name(&self) -> std::option::Option<&str> {
        self.author_name.as_deref()
    }
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub fn keep_empty_folders(&self) -> bool {
        self.keep_empty_folders
    }
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub fn conflict_resolution(&self) -> std::option::Option<&crate::model::ConflictResolution> {
        self.conflict_resolution.as_ref()
    }
}
impl std::fmt::Debug for MergePullRequestBySquashInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergePullRequestBySquashInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("commit_message", &self.commit_message);
        formatter.field("author_name", &self.author_name);
        formatter.field("email", &self.email);
        formatter.field("keep_empty_folders", &self.keep_empty_folders);
        formatter.field("conflict_resolution", &self.conflict_resolution);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergePullRequestByFastForwardInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository where the pull request was created.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
}
impl MergePullRequestByFastForwardInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the repository where the pull request was created.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
}
impl std::fmt::Debug for MergePullRequestByFastForwardInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergePullRequestByFastForwardInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeBranchesByThreeWayInput {
    /// <p>The name of the repository where you want to merge two branches.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch where the merge is applied. </p>
    pub target_branch: std::option::Option<std::string::String>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub author_name: std::option::Option<std::string::String>,
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The commit message to include in the commit information for the merge.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub keep_empty_folders: bool,
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
}
impl MergeBranchesByThreeWayInput {
    /// <p>The name of the repository where you want to merge two branches.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The branch where the merge is applied. </p>
    pub fn target_branch(&self) -> std::option::Option<&str> {
        self.target_branch.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub fn author_name(&self) -> std::option::Option<&str> {
        self.author_name.as_deref()
    }
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The commit message to include in the commit information for the merge.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub fn keep_empty_folders(&self) -> bool {
        self.keep_empty_folders
    }
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub fn conflict_resolution(&self) -> std::option::Option<&crate::model::ConflictResolution> {
        self.conflict_resolution.as_ref()
    }
}
impl std::fmt::Debug for MergeBranchesByThreeWayInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeBranchesByThreeWayInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("target_branch", &self.target_branch);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("author_name", &self.author_name);
        formatter.field("email", &self.email);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("keep_empty_folders", &self.keep_empty_folders);
        formatter.field("conflict_resolution", &self.conflict_resolution);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeBranchesBySquashInput {
    /// <p>The name of the repository where you want to merge two branches.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch where the merge is applied. </p>
    pub target_branch: std::option::Option<std::string::String>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub author_name: std::option::Option<std::string::String>,
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The commit message for the merge.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub keep_empty_folders: bool,
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
}
impl MergeBranchesBySquashInput {
    /// <p>The name of the repository where you want to merge two branches.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The branch where the merge is applied. </p>
    pub fn target_branch(&self) -> std::option::Option<&str> {
        self.target_branch.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub fn author_name(&self) -> std::option::Option<&str> {
        self.author_name.as_deref()
    }
    /// <p>The email address of the person merging the branches. This information is used in the commit information for the merge.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The commit message for the merge.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub fn keep_empty_folders(&self) -> bool {
        self.keep_empty_folders
    }
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub fn conflict_resolution(&self) -> std::option::Option<&crate::model::ConflictResolution> {
        self.conflict_resolution.as_ref()
    }
}
impl std::fmt::Debug for MergeBranchesBySquashInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeBranchesBySquashInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("target_branch", &self.target_branch);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("author_name", &self.author_name);
        formatter.field("email", &self.email);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("keep_empty_folders", &self.keep_empty_folders);
        formatter.field("conflict_resolution", &self.conflict_resolution);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeBranchesByFastForwardInput {
    /// <p>The name of the repository where you want to merge two branches.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch where the merge is applied.</p>
    pub target_branch: std::option::Option<std::string::String>,
}
impl MergeBranchesByFastForwardInput {
    /// <p>The name of the repository where you want to merge two branches.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The branch where the merge is applied.</p>
    pub fn target_branch(&self) -> std::option::Option<&str> {
        self.target_branch.as_deref()
    }
}
impl std::fmt::Debug for MergeBranchesByFastForwardInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeBranchesByFastForwardInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("target_branch", &self.target_branch);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information about tags, if any.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesForApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListRepositoriesForApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListRepositoriesForApprovalRuleTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesForApprovalRuleTemplateInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Represents the input of a list repositories operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesInput {
    /// <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The criteria used to sort the results of a list repositories operation.</p>
    pub sort_by: std::option::Option<crate::model::SortByEnum>,
    /// <p>The order in which to sort the results of a list repositories operation.</p>
    pub order: std::option::Option<crate::model::OrderEnum>,
}
impl ListRepositoriesInput {
    /// <p>An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit, another page of 1,000 records is retrieved.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The criteria used to sort the results of a list repositories operation.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SortByEnum> {
        self.sort_by.as_ref()
    }
    /// <p>The order in which to sort the results of a list repositories operation.</p>
    pub fn order(&self) -> std::option::Option<&crate::model::OrderEnum> {
        self.order.as_ref()
    }
}
impl std::fmt::Debug for ListRepositoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("order", &self.order);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPullRequestsInput {
    /// <p>The name of the repository for which you want to list pull requests.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>
    pub author_arn: std::option::Option<std::string::String>,
    /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
    pub pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListPullRequestsInput {
    /// <p>The name of the repository for which you want to list pull requests.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results to pull requests created by that user.</p>
    pub fn author_arn(&self) -> std::option::Option<&str> {
        self.author_arn.as_deref()
    }
    /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
    pub fn pull_request_status(&self) -> std::option::Option<&crate::model::PullRequestStatusEnum> {
        self.pull_request_status.as_ref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListPullRequestsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPullRequestsInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("author_arn", &self.author_arn);
        formatter.field("pull_request_status", &self.pull_request_status);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Represents the input of a list branches operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBranchesInput {
    /// <p>The name of the repository that contains the branches.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An enumeration token that allows the operation to batch the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBranchesInput {
    /// <p>The name of the repository that contains the branches.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An enumeration token that allows the operation to batch the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBranchesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBranchesInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedApprovalRuleTemplatesForRepositoryInput {
    /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAssociatedApprovalRuleTemplatesForRepositoryInput {
    /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAssociatedApprovalRuleTemplatesForRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociatedApprovalRuleTemplatesForRepositoryInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApprovalRuleTemplatesInput {
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListApprovalRuleTemplatesInput {
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListApprovalRuleTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApprovalRuleTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

/// <p>Represents the input of a get repository triggers operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryTriggersInput {
    /// <p>The name of the repository for which the trigger is configured.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl GetRepositoryTriggersInput {
    /// <p>The name of the repository for which the trigger is configured.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryTriggersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryTriggersInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a get repository operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryInput {
    /// <p>The name of the repository to get information about.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl GetRepositoryInput {
    /// <p>The name of the repository to get information about.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPullRequestOverrideStateInput {
    /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <code>GetPullRequest</code>.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetPullRequestOverrideStateInput {
    /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The system-generated ID of the revision for the pull request. To retrieve the most recent revision ID, use <code>GetPullRequest</code>.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetPullRequestOverrideStateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPullRequestOverrideStateInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPullRequestApprovalStatesInput {
    /// <p>The system-generated ID for the pull request.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The system-generated ID for the pull request revision.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl GetPullRequestApprovalStatesInput {
    /// <p>The system-generated ID for the pull request.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The system-generated ID for the pull request revision.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for GetPullRequestApprovalStatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPullRequestApprovalStatesInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPullRequestInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
}
impl GetPullRequestInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
}
impl std::fmt::Debug for GetPullRequestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPullRequestInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMergeOptionsInput {
    /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
}
impl GetMergeOptionsInput {
    /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
}
impl std::fmt::Debug for GetMergeOptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMergeOptionsInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMergeConflictsInput {
    /// <p>The name of the repository where the pull request was created.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The merge option or strategy you want to use to merge the code. </p>
    pub merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>The maximum number of files to include in the output.</p>
    pub max_conflict_files: std::option::Option<i32>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetMergeConflictsInput {
    /// <p>The name of the repository where the pull request was created.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The merge option or strategy you want to use to merge the code. </p>
    pub fn merge_option(&self) -> std::option::Option<&crate::model::MergeOptionTypeEnum> {
        self.merge_option.as_ref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>The maximum number of files to include in the output.</p>
    pub fn max_conflict_files(&self) -> std::option::Option<i32> {
        self.max_conflict_files
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetMergeConflictsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMergeConflictsInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field("merge_option", &self.merge_option);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field("max_conflict_files", &self.max_conflict_files);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMergeCommitInput {
    /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
}
impl GetMergeCommitInput {
    /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
}
impl std::fmt::Debug for GetMergeCommitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMergeCommitInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderInput {
    /// <p>The name of the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>
    pub commit_specifier: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>
    pub folder_path: std::option::Option<std::string::String>,
}
impl GetFolderInput {
    /// <p>The name of the repository.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>A fully qualified reference used to identify a commit that contains the version of the folder's content to return. A fully qualified reference can be a commit ID, branch name, tag, or reference such as HEAD. If no specifier is provided, the folder content is returned as it exists in the HEAD commit.</p>
    pub fn commit_specifier(&self) -> std::option::Option<&str> {
        self.commit_specifier.as_deref()
    }
    /// <p>The fully qualified path to the folder whose contents are returned, including the folder name. For example, /examples is a fully-qualified path to a folder named examples that was created off of the root directory (/) of a repository. </p>
    pub fn folder_path(&self) -> std::option::Option<&str> {
        self.folder_path.as_deref()
    }
}
impl std::fmt::Debug for GetFolderInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("commit_specifier", &self.commit_specifier);
        formatter.field("folder_path", &self.folder_path);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFileInput {
    /// <p>The name of the repository that contains the file.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>
    pub commit_specifier: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>
    pub file_path: std::option::Option<std::string::String>,
}
impl GetFileInput {
    /// <p>The name of the repository that contains the file.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The fully quaified reference that identifies the commit that contains the file. For example, you can specify a full commit ID, a tag, a branch name, or a reference such as refs/heads/master. If none is provided, the head commit is used.</p>
    pub fn commit_specifier(&self) -> std::option::Option<&str> {
        self.commit_specifier.as_deref()
    }
    /// <p>The fully qualified path to the file, including the full name and extension of the file. For example, /examples/file.md is the fully qualified path to a file named file.md in a folder named examples.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
}
impl std::fmt::Debug for GetFileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFileInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("commit_specifier", &self.commit_specifier);
        formatter.field("file_path", &self.file_path);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDifferencesInput {
    /// <p>The name of the repository where you want to get differences.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>
    pub before_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
    pub after_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>
    pub before_path: std::option::Option<std::string::String>,
    /// <p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>
    pub after_path: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDifferencesInput {
    /// <p>The name of the repository where you want to get differences.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, the full commit ID). Optional. If not specified, all changes before the <code>afterCommitSpecifier</code> value are shown. If you do not use <code>beforeCommitSpecifier</code> in your request, consider limiting the results with <code>maxResults</code>.</p>
    pub fn before_commit_specifier(&self) -> std::option::Option<&str> {
        self.before_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
    pub fn after_commit_specifier(&self) -> std::option::Option<&str> {
        self.after_commit_specifier.as_deref()
    }
    /// <p>The file path in which to check for differences. Limits the results to this path. Can also be used to specify the previous name of a directory or folder. If <code>beforePath</code> and <code>afterPath</code> are not specified, differences are shown for all paths.</p>
    pub fn before_path(&self) -> std::option::Option<&str> {
        self.before_path.as_deref()
    }
    /// <p>The file path in which to check differences. Limits the results to this path. Can also be used to specify the changed name of a directory or folder, if it has changed. If not specified, differences are shown for all paths.</p>
    pub fn after_path(&self) -> std::option::Option<&str> {
        self.after_path.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDifferencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDifferencesInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_specifier", &self.before_commit_specifier);
        formatter.field("after_commit_specifier", &self.after_commit_specifier);
        formatter.field("before_path", &self.before_path);
        formatter.field("after_path", &self.after_path);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a get commit operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommitInput {
    /// <p>The name of the repository to which the commit was made.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
    pub commit_id: std::option::Option<std::string::String>,
}
impl GetCommitInput {
    /// <p>The name of the repository to which the commit was made.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
}
impl std::fmt::Debug for GetCommitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommitInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("commit_id", &self.commit_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentsForPullRequestInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that contains the pull request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetCommentsForPullRequestInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the repository that contains the pull request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments. You can return up to 500 comments with a single request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetCommentsForPullRequestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentsForPullRequestInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentsForComparedCommitInput {
    /// <p>The name of the repository where you want to compare commits.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetCommentsForComparedCommitInput {
    /// <p>The name of the repository where you want to compare commits.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>To establish the directionality of the comparison, the full commit ID of the before commit.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>To establish the directionality of the comparison, the full commit ID of the after commit.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments, but you can configure up to 500.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetCommentsForComparedCommitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentsForComparedCommitInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentReactionsInput {
    /// <p>The ID of the comment for which you want to get reactions information.</p>
    pub comment_id: std::option::Option<std::string::String>,
    /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
    pub reaction_user_arn: std::option::Option<std::string::String>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetCommentReactionsInput {
    /// <p>The ID of the comment for which you want to get reactions information.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
    /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
    pub fn reaction_user_arn(&self) -> std::option::Option<&str> {
        self.reaction_user_arn.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is the same as the allowed maximum, 1,000.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetCommentReactionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentReactionsInput");
        formatter.field("comment_id", &self.comment_id);
        formatter.field("reaction_user_arn", &self.reaction_user_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentInput {
    /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub comment_id: std::option::Option<std::string::String>,
}
impl GetCommentInput {
    /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
}
impl std::fmt::Debug for GetCommentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentInput");
        formatter.field("comment_id", &self.comment_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a get branch operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBranchInput {
    /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the branch for which you want to retrieve information.</p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl GetBranchInput {
    /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the branch for which you want to retrieve information.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
}
impl std::fmt::Debug for GetBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBranchInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}

/// <p>Represents the input of a get blob operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlobInput {
    /// <p>The name of the repository that contains the blob.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
    pub blob_id: std::option::Option<std::string::String>,
}
impl GetBlobInput {
    /// <p>The name of the repository that contains the blob.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
}
impl std::fmt::Debug for GetBlobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlobInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("blob_id", &self.blob_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template for which you want to get information.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
}
impl GetApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template for which you want to get information.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
}
impl std::fmt::Debug for GetApprovalRuleTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApprovalRuleTemplateInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluatePullRequestApprovalRulesInput {
    /// <p>The system-generated ID of the pull request you want to evaluate.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <code>GetPullRequest</code>.</p>
    pub revision_id: std::option::Option<std::string::String>,
}
impl EvaluatePullRequestApprovalRulesInput {
    /// <p>The system-generated ID of the pull request you want to evaluate.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The system-generated ID for the pull request revision. To retrieve the most recent revision ID for a pull request, use <code>GetPullRequest</code>.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
}
impl std::fmt::Debug for EvaluatePullRequestApprovalRulesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluatePullRequestApprovalRulesInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("revision_id", &self.revision_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateApprovalRuleTemplateFromRepositoryInput {
    /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The name of the repository you want to disassociate from the template.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl DisassociateApprovalRuleTemplateFromRepositoryInput {
    /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The name of the repository you want to disassociate from the template.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for DisassociateApprovalRuleTemplateFromRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateApprovalRuleTemplateFromRepositoryInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePullRequestEventsInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>Optional. The pull request event type about which you want to return information.</p>
    pub pull_request_event_type: std::option::Option<crate::model::PullRequestEventType>,
    /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>
    pub actor_arn: std::option::Option<std::string::String>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
    pub max_results: std::option::Option<i32>,
}
impl DescribePullRequestEventsInput {
    /// <p>The system-generated ID of the pull request. To get this ID, use <code>ListPullRequests</code>.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>Optional. The pull request event type about which you want to return information.</p>
    pub fn pull_request_event_type(
        &self,
    ) -> std::option::Option<&crate::model::PullRequestEventType> {
        self.pull_request_event_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.</p>
    pub fn actor_arn(&self) -> std::option::Option<&str> {
        self.actor_arn.as_deref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for DescribePullRequestEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePullRequestEventsInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("pull_request_event_type", &self.pull_request_event_type);
        formatter.field("actor_arn", &self.actor_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMergeConflictsInput {
    /// <p>The name of the repository where you want to get information about a merge conflict.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The merge option or strategy you want to use to merge the code.</p>
    pub merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
    /// <p>The maximum number of merge hunks to include in the output.</p>
    pub max_merge_hunks: std::option::Option<i32>,
    /// <p>The path of the target files used to describe the conflicts. </p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMergeConflictsInput {
    /// <p>The name of the repository where you want to get information about a merge conflict.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The merge option or strategy you want to use to merge the code.</p>
    pub fn merge_option(&self) -> std::option::Option<&crate::model::MergeOptionTypeEnum> {
        self.merge_option.as_ref()
    }
    /// <p>The maximum number of merge hunks to include in the output.</p>
    pub fn max_merge_hunks(&self) -> std::option::Option<i32> {
        self.max_merge_hunks
    }
    /// <p>The path of the target files used to describe the conflicts. </p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMergeConflictsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMergeConflictsInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field("merge_option", &self.merge_option);
        formatter.field("max_merge_hunks", &self.max_merge_hunks);
        formatter.field("file_path", &self.file_path);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// <p>Represents the input of a delete repository operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryInput {
    /// <p>The name of the repository to delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl DeleteRepositoryInput {
    /// <p>The name of the repository to delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePullRequestApprovalRuleInput {
    /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the approval rule you want to delete.</p>
    pub approval_rule_name: std::option::Option<std::string::String>,
}
impl DeletePullRequestApprovalRuleInput {
    /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the approval rule you want to delete.</p>
    pub fn approval_rule_name(&self) -> std::option::Option<&str> {
        self.approval_rule_name.as_deref()
    }
}
impl std::fmt::Debug for DeletePullRequestApprovalRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePullRequestApprovalRuleInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("approval_rule_name", &self.approval_rule_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileInput {
    /// <p>The name of the repository that contains the file to delete.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the branch where the commit that deletes the file is made.</p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>
    pub parent_commit_id: std::option::Option<std::string::String>,
    /// <p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
    pub keep_empty_folders: bool,
    /// <p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>
    pub email: std::option::Option<std::string::String>,
}
impl DeleteFileInput {
    /// <p>The name of the repository that contains the file to delete.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the branch where the commit that deletes the file is made.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p>The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.</p>
    pub fn parent_commit_id(&self) -> std::option::Option<&str> {
        self.parent_commit_id.as_deref()
    }
    /// <p>If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
    pub fn keep_empty_folders(&self) -> bool {
        self.keep_empty_folders
    }
    /// <p>The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("file_path", &self.file_path);
        formatter.field("parent_commit_id", &self.parent_commit_id);
        formatter.field("keep_empty_folders", &self.keep_empty_folders);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("name", &self.name);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCommentContentInput {
    /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub comment_id: std::option::Option<std::string::String>,
}
impl DeleteCommentContentInput {
    /// <p>The unique, system-generated ID of the comment. To get this ID, use <code>GetCommentsForComparedCommit</code> or <code>GetCommentsForPullRequest</code>.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteCommentContentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCommentContentInput");
        formatter.field("comment_id", &self.comment_id);
        formatter.finish()
    }
}

/// <p>Represents the input of a delete branch operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBranchInput {
    /// <p>The name of the repository that contains the branch to be deleted.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the branch to delete.</p>
    pub branch_name: std::option::Option<std::string::String>,
}
impl DeleteBranchInput {
    /// <p>The name of the repository that contains the branch to be deleted.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the branch to delete.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBranchInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("branch_name", &self.branch_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template to delete.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
}
impl DeleteApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template to delete.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteApprovalRuleTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApprovalRuleTemplateInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUnreferencedMergeCommitInput {
    /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The merge option or strategy you want to use to merge the code.</p>
    pub merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>
    pub author_name: std::option::Option<std::string::String>,
    /// <p>The email address for the person who created the unreferenced commit.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The commit message for the unreferenced commit.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub keep_empty_folders: bool,
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
}
impl CreateUnreferencedMergeCommitInput {
    /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The merge option or strategy you want to use to merge the code.</p>
    pub fn merge_option(&self) -> std::option::Option<&crate::model::MergeOptionTypeEnum> {
        self.merge_option.as_ref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.</p>
    pub fn author_name(&self) -> std::option::Option<&str> {
        self.author_name.as_deref()
    }
    /// <p>The email address for the person who created the unreferenced commit.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The commit message for the unreferenced commit.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.</p>
    pub fn keep_empty_folders(&self) -> bool {
        self.keep_empty_folders
    }
    /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.</p>
    pub fn conflict_resolution(&self) -> std::option::Option<&crate::model::ConflictResolution> {
        self.conflict_resolution.as_ref()
    }
}
impl std::fmt::Debug for CreateUnreferencedMergeCommitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUnreferencedMergeCommitInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("merge_option", &self.merge_option);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("author_name", &self.author_name);
        formatter.field("email", &self.email);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("keep_empty_folders", &self.keep_empty_folders);
        formatter.field("conflict_resolution", &self.conflict_resolution);
        formatter.finish()
    }
}

/// <p>Represents the input of a create repository operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryInput {
    /// <p>The name of the new repository to be created.</p> <note>
    /// <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p>
    /// </note>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>A comment or description about the new repository.</p> <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
    /// </note>
    pub repository_description: std::option::Option<std::string::String>,
    /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRepositoryInput {
    /// <p>The name of the new repository to be created.</p> <note>
    /// <p>The repository name must be unique across the calling AWS account. Repository names are limited to 100 alphanumeric, dash, and underscore characters, and cannot include certain characters. For more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The suffix .git is prohibited.</p>
    /// </note>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>A comment or description about the new repository.</p> <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious code. Make sure that you HTML-encode the description field in any application that uses this API to display the repository description on a webpage.</p>
    /// </note>
    pub fn repository_description(&self) -> std::option::Option<&str> {
        self.repository_description.as_deref()
    }
    /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("repository_description", &self.repository_description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePullRequestApprovalRuleInput {
    /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name for the approval rule.</p>
    pub approval_rule_name: std::option::Option<std::string::String>,
    /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note>
    /// <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
    /// <ul>
    /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p>
    /// <ul>
    /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
    /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
    /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
    /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
    /// </ul>
    /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    pub approval_rule_content: std::option::Option<std::string::String>,
}
impl CreatePullRequestApprovalRuleInput {
    /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name for the approval rule.</p>
    pub fn approval_rule_name(&self) -> std::option::Option<&str> {
        self.approval_rule_name.as_deref()
    }
    /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information about approval pools, see the AWS CodeCommit User Guide.</p> <note>
    /// <p>When you create the content of the approval rule, you can specify approvers in an approval pool in one of two ways:</p>
    /// <ul>
    /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following would be counted as approvals coming from that user:</p>
    /// <ul>
    /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
    /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
    /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
    /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
    /// </ul>
    /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    pub fn approval_rule_content(&self) -> std::option::Option<&str> {
        self.approval_rule_content.as_deref()
    }
}
impl std::fmt::Debug for CreatePullRequestApprovalRuleInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePullRequestApprovalRuleInput");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("approval_rule_name", &self.approval_rule_name);
        formatter.field("approval_rule_content", &self.approval_rule_content);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePullRequestInput {
    /// <p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>A description of the pull request.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::Target>>,
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note>
    /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
    /// </note>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl CreatePullRequestInput {
    /// <p>The title of the pull request. This title is used to identify the pull request to other users in the repository.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>A description of the pull request.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::Target]> {
        self.targets.as_deref()
    }
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p> <note>
    /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an idempotency token is created for you.</p>
    /// </note>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for CreatePullRequestInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePullRequestInput");
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("targets", &self.targets);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCommitInput {
    /// <p>The name of the repository where you create the commit.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the branch where you create the commit.</p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>
    pub parent_commit_id: std::option::Option<std::string::String>,
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub author_name: std::option::Option<std::string::String>,
    /// <p>The email address of the person who created the commit.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
    pub commit_message: std::option::Option<std::string::String>,
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>
    pub keep_empty_folders: bool,
    /// <p>The files to add or update in this commit.</p>
    pub put_files: std::option::Option<std::vec::Vec<crate::model::PutFileEntry>>,
    /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
    pub delete_files: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
    /// <p>The file modes to update for files in this commit.</p>
    pub set_file_modes: std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
}
impl CreateCommitInput {
    /// <p>The name of the repository where you create the commit.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the branch where you create the commit.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p>The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.</p>
    pub fn parent_commit_id(&self) -> std::option::Option<&str> {
        self.parent_commit_id.as_deref()
    }
    /// <p>The name of the author who created the commit. This information is used as both the author and committer for the commit.</p>
    pub fn author_name(&self) -> std::option::Option<&str> {
        self.author_name.as_deref()
    }
    /// <p>The email address of the person who created the commit.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.</p>
    pub fn commit_message(&self) -> std::option::Option<&str> {
        self.commit_message.as_deref()
    }
    /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.</p>
    pub fn keep_empty_folders(&self) -> bool {
        self.keep_empty_folders
    }
    /// <p>The files to add or update in this commit.</p>
    pub fn put_files(&self) -> std::option::Option<&[crate::model::PutFileEntry]> {
        self.put_files.as_deref()
    }
    /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
    pub fn delete_files(&self) -> std::option::Option<&[crate::model::DeleteFileEntry]> {
        self.delete_files.as_deref()
    }
    /// <p>The file modes to update for files in this commit.</p>
    pub fn set_file_modes(&self) -> std::option::Option<&[crate::model::SetFileModeEntry]> {
        self.set_file_modes.as_deref()
    }
}
impl std::fmt::Debug for CreateCommitInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCommitInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("parent_commit_id", &self.parent_commit_id);
        formatter.field("author_name", &self.author_name);
        formatter.field("email", &self.email);
        formatter.field("commit_message", &self.commit_message);
        formatter.field("keep_empty_folders", &self.keep_empty_folders);
        formatter.field("put_files", &self.put_files);
        formatter.field("delete_files", &self.delete_files);
        formatter.field("set_file_modes", &self.set_file_modes);
        formatter.finish()
    }
}

/// <p>Represents the input of a create branch operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBranchInput {
    /// <p>The name of the repository in which you want to create the new branch.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the new branch to create.</p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p>The ID of the commit to point the new branch to.</p>
    pub commit_id: std::option::Option<std::string::String>,
}
impl CreateBranchInput {
    /// <p>The name of the repository in which you want to create the new branch.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the new branch to create.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p>The ID of the commit to point the new branch to.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBranchInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBranchInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("branch_name", &self.branch_name);
        formatter.field("commit_id", &self.commit_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note>
    /// <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p>
    /// <ul>
    /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
    /// <ul>
    /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
    /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
    /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
    /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
    /// </ul>
    /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    pub approval_rule_template_content: std::option::Option<std::string::String>,
    /// <p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>
    pub approval_rule_template_description: std::option::Option<std::string::String>,
}
impl CreateApprovalRuleTemplateInput {
    /// <p>The name of the approval rule template. Provide descriptive names, because this name is applied to the approval rules created automatically in associated repositories.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The content of the approval rule that is created on pull requests in associated repositories. If you specify one or more destination references (branches), approval rules are created in an associated repository only if their destination references (branches) match those specified in the template.</p> <note>
    /// <p>When you create the content of the approval rule template, you can specify approvers in an approval pool in one of two ways:</p>
    /// <ul>
    /// <li> <p> <b>CodeCommitApprovers</b>: This option only requires an AWS account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the AWS account <i>123456789012</i> and <i>Mary_Major</i>, all of the following are counted as approvals coming from that user:</p>
    /// <ul>
    /// <li> <p>An IAM user in the account (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p> </li>
    /// <li> <p>A federated user identified in IAM as Mary_Major (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p> </li>
    /// </ul> <p>This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of <i>Mary_Major</i> (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>) unless you include a wildcard (*Mary_Major).</p> </li>
    /// <li> <p> <b>Fully qualified ARN</b>: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role. </p> </li>
    /// </ul>
    /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>.</p>
    /// </note>
    pub fn approval_rule_template_content(&self) -> std::option::Option<&str> {
        self.approval_rule_template_content.as_deref()
    }
    /// <p>The description of the approval rule template. Consider providing a description that explains what this template does and when it might be appropriate to associate it with repositories.</p>
    pub fn approval_rule_template_description(&self) -> std::option::Option<&str> {
        self.approval_rule_template_description.as_deref()
    }
}
impl std::fmt::Debug for CreateApprovalRuleTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApprovalRuleTemplateInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field(
            "approval_rule_template_content",
            &self.approval_rule_template_content,
        );
        formatter.field(
            "approval_rule_template_description",
            &self.approval_rule_template_description,
        );
        formatter.finish()
    }
}

/// <p>Represents the input of a batch get repositories operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetRepositoriesInput {
    /// <p>The names of the repositories to get information about.</p> <note>
    /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
    /// </note>
    pub repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetRepositoriesInput {
    /// <p>The names of the repositories to get information about.</p> <note>
    /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
    /// </note>
    pub fn repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.repository_names.as_deref()
    }
}
impl std::fmt::Debug for BatchGetRepositoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetRepositoriesInput");
        formatter.field("repository_names", &self.repository_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetCommitsInput {
    /// <p>The full commit IDs of the commits to get information about.</p> <note>
    /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p>
    /// </note>
    pub commit_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the repository that contains the commits.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl BatchGetCommitsInput {
    /// <p>The full commit IDs of the commits to get information about.</p> <note>
    /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA IDs.</p>
    /// </note>
    pub fn commit_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.commit_ids.as_deref()
    }
    /// <p>The name of the repository that contains the commits.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for BatchGetCommitsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetCommitsInput");
        formatter.field("commit_ids", &self.commit_ids);
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateApprovalRuleTemplateFromRepositoriesInput {
    /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The repository names that you want to disassociate from the approval rule template.</p> <note>
    /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
    /// </note>
    pub repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDisassociateApprovalRuleTemplateFromRepositoriesInput {
    /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The repository names that you want to disassociate from the approval rule template.</p> <note>
    /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
    /// </note>
    pub fn repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.repository_names.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateApprovalRuleTemplateFromRepositoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchDisassociateApprovalRuleTemplateFromRepositoriesInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field("repository_names", &self.repository_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDescribeMergeConflictsInput {
    /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub destination_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub source_commit_specifier: std::option::Option<std::string::String>,
    /// <p>The merge option or strategy you want to use to merge the code.</p>
    pub merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
    /// <p>The maximum number of merge hunks to include in the output.</p>
    pub max_merge_hunks: std::option::Option<i32>,
    /// <p>The maximum number of files to include in the output.</p>
    pub max_conflict_files: std::option::Option<i32>,
    /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
    pub file_paths: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub conflict_detail_level: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub conflict_resolution_strategy:
        std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl BatchDescribeMergeConflictsInput {
    /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn destination_commit_specifier(&self) -> std::option::Option<&str> {
        self.destination_commit_specifier.as_deref()
    }
    /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).</p>
    pub fn source_commit_specifier(&self) -> std::option::Option<&str> {
        self.source_commit_specifier.as_deref()
    }
    /// <p>The merge option or strategy you want to use to merge the code.</p>
    pub fn merge_option(&self) -> std::option::Option<&crate::model::MergeOptionTypeEnum> {
        self.merge_option.as_ref()
    }
    /// <p>The maximum number of merge hunks to include in the output.</p>
    pub fn max_merge_hunks(&self) -> std::option::Option<i32> {
        self.max_merge_hunks
    }
    /// <p>The maximum number of files to include in the output.</p>
    pub fn max_conflict_files(&self) -> std::option::Option<i32> {
        self.max_conflict_files
    }
    /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
    pub fn file_paths(&self) -> std::option::Option<&[std::string::String]> {
        self.file_paths.as_deref()
    }
    /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.</p>
    pub fn conflict_detail_level(
        &self,
    ) -> std::option::Option<&crate::model::ConflictDetailLevelTypeEnum> {
        self.conflict_detail_level.as_ref()
    }
    /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.</p>
    pub fn conflict_resolution_strategy(
        &self,
    ) -> std::option::Option<&crate::model::ConflictResolutionStrategyTypeEnum> {
        self.conflict_resolution_strategy.as_ref()
    }
    /// <p>An enumeration token that, when provided in a request, returns the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for BatchDescribeMergeConflictsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDescribeMergeConflictsInput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field(
            "destination_commit_specifier",
            &self.destination_commit_specifier,
        );
        formatter.field("source_commit_specifier", &self.source_commit_specifier);
        formatter.field("merge_option", &self.merge_option);
        formatter.field("max_merge_hunks", &self.max_merge_hunks);
        formatter.field("max_conflict_files", &self.max_conflict_files);
        formatter.field("file_paths", &self.file_paths);
        formatter.field("conflict_detail_level", &self.conflict_detail_level);
        formatter.field(
            "conflict_resolution_strategy",
            &self.conflict_resolution_strategy,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateApprovalRuleTemplateWithRepositoriesInput {
    /// <p>The name of the template you want to associate with one or more repositories.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The names of the repositories you want to associate with the template.</p> <note>
    /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
    /// </note>
    pub repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchAssociateApprovalRuleTemplateWithRepositoriesInput {
    /// <p>The name of the template you want to associate with one or more repositories.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The names of the repositories you want to associate with the template.</p> <note>
    /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
    /// </note>
    pub fn repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.repository_names.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateApprovalRuleTemplateWithRepositoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchAssociateApprovalRuleTemplateWithRepositoriesInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field("repository_names", &self.repository_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateApprovalRuleTemplateWithRepositoryInput {
    /// <p>The name for the approval rule template. </p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The name of the repository that you want to associate with the template.</p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl AssociateApprovalRuleTemplateWithRepositoryInput {
    /// <p>The name for the approval rule template. </p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The name of the repository that you want to associate with the template.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for AssociateApprovalRuleTemplateWithRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateApprovalRuleTemplateWithRepositoryInput");
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}
