// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS CodeCommit
///
/// Client for invoking operations on AWS CodeCommit. Each operation on AWS CodeCommit is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codecommit::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codecommit::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codecommit::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateApprovalRuleTemplateWithRepository` operation.
    ///
    /// See [`AssociateApprovalRuleTemplateWithRepository`](crate::client::fluent_builders::AssociateApprovalRuleTemplateWithRepository) for more information about the
    /// operation and its arguments.
    pub fn associate_approval_rule_template_with_repository(
        &self,
    ) -> fluent_builders::AssociateApprovalRuleTemplateWithRepository<C, M, R> {
        fluent_builders::AssociateApprovalRuleTemplateWithRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchAssociateApprovalRuleTemplateWithRepositories` operation.
    ///
    /// See [`BatchAssociateApprovalRuleTemplateWithRepositories`](crate::client::fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories) for more information about the
    /// operation and its arguments.
    pub fn batch_associate_approval_rule_template_with_repositories(
        &self,
    ) -> fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories<C, M, R> {
        fluent_builders::BatchAssociateApprovalRuleTemplateWithRepositories::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the `BatchDescribeMergeConflicts` operation.
    ///
    /// See [`BatchDescribeMergeConflicts`](crate::client::fluent_builders::BatchDescribeMergeConflicts) for more information about the
    /// operation and its arguments.
    pub fn batch_describe_merge_conflicts(
        &self,
    ) -> fluent_builders::BatchDescribeMergeConflicts<C, M, R> {
        fluent_builders::BatchDescribeMergeConflicts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDisassociateApprovalRuleTemplateFromRepositories` operation.
    ///
    /// See [`BatchDisassociateApprovalRuleTemplateFromRepositories`](crate::client::fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories) for more information about the
    /// operation and its arguments.
    pub fn batch_disassociate_approval_rule_template_from_repositories(
        &self,
    ) -> fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories<C, M, R> {
        fluent_builders::BatchDisassociateApprovalRuleTemplateFromRepositories::new(
            self.handle.clone(),
        )
    }
    /// Constructs a fluent builder for the `BatchGetCommits` operation.
    ///
    /// See [`BatchGetCommits`](crate::client::fluent_builders::BatchGetCommits) for more information about the
    /// operation and its arguments.
    pub fn batch_get_commits(&self) -> fluent_builders::BatchGetCommits<C, M, R> {
        fluent_builders::BatchGetCommits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetRepositories` operation.
    ///
    /// See [`BatchGetRepositories`](crate::client::fluent_builders::BatchGetRepositories) for more information about the
    /// operation and its arguments.
    pub fn batch_get_repositories(&self) -> fluent_builders::BatchGetRepositories<C, M, R> {
        fluent_builders::BatchGetRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApprovalRuleTemplate` operation.
    ///
    /// See [`CreateApprovalRuleTemplate`](crate::client::fluent_builders::CreateApprovalRuleTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_approval_rule_template(
        &self,
    ) -> fluent_builders::CreateApprovalRuleTemplate<C, M, R> {
        fluent_builders::CreateApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBranch` operation.
    ///
    /// See [`CreateBranch`](crate::client::fluent_builders::CreateBranch) for more information about the
    /// operation and its arguments.
    pub fn create_branch(&self) -> fluent_builders::CreateBranch<C, M, R> {
        fluent_builders::CreateBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCommit` operation.
    ///
    /// See [`CreateCommit`](crate::client::fluent_builders::CreateCommit) for more information about the
    /// operation and its arguments.
    pub fn create_commit(&self) -> fluent_builders::CreateCommit<C, M, R> {
        fluent_builders::CreateCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePullRequest` operation.
    ///
    /// See [`CreatePullRequest`](crate::client::fluent_builders::CreatePullRequest) for more information about the
    /// operation and its arguments.
    pub fn create_pull_request(&self) -> fluent_builders::CreatePullRequest<C, M, R> {
        fluent_builders::CreatePullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePullRequestApprovalRule` operation.
    ///
    /// See [`CreatePullRequestApprovalRule`](crate::client::fluent_builders::CreatePullRequestApprovalRule) for more information about the
    /// operation and its arguments.
    pub fn create_pull_request_approval_rule(
        &self,
    ) -> fluent_builders::CreatePullRequestApprovalRule<C, M, R> {
        fluent_builders::CreatePullRequestApprovalRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRepository` operation.
    ///
    /// See [`CreateRepository`](crate::client::fluent_builders::CreateRepository) for more information about the
    /// operation and its arguments.
    pub fn create_repository(&self) -> fluent_builders::CreateRepository<C, M, R> {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUnreferencedMergeCommit` operation.
    ///
    /// See [`CreateUnreferencedMergeCommit`](crate::client::fluent_builders::CreateUnreferencedMergeCommit) for more information about the
    /// operation and its arguments.
    pub fn create_unreferenced_merge_commit(
        &self,
    ) -> fluent_builders::CreateUnreferencedMergeCommit<C, M, R> {
        fluent_builders::CreateUnreferencedMergeCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApprovalRuleTemplate` operation.
    ///
    /// See [`DeleteApprovalRuleTemplate`](crate::client::fluent_builders::DeleteApprovalRuleTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_approval_rule_template(
        &self,
    ) -> fluent_builders::DeleteApprovalRuleTemplate<C, M, R> {
        fluent_builders::DeleteApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBranch` operation.
    ///
    /// See [`DeleteBranch`](crate::client::fluent_builders::DeleteBranch) for more information about the
    /// operation and its arguments.
    pub fn delete_branch(&self) -> fluent_builders::DeleteBranch<C, M, R> {
        fluent_builders::DeleteBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCommentContent` operation.
    ///
    /// See [`DeleteCommentContent`](crate::client::fluent_builders::DeleteCommentContent) for more information about the
    /// operation and its arguments.
    pub fn delete_comment_content(&self) -> fluent_builders::DeleteCommentContent<C, M, R> {
        fluent_builders::DeleteCommentContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFile` operation.
    ///
    /// See [`DeleteFile`](crate::client::fluent_builders::DeleteFile) for more information about the
    /// operation and its arguments.
    pub fn delete_file(&self) -> fluent_builders::DeleteFile<C, M, R> {
        fluent_builders::DeleteFile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePullRequestApprovalRule` operation.
    ///
    /// See [`DeletePullRequestApprovalRule`](crate::client::fluent_builders::DeletePullRequestApprovalRule) for more information about the
    /// operation and its arguments.
    pub fn delete_pull_request_approval_rule(
        &self,
    ) -> fluent_builders::DeletePullRequestApprovalRule<C, M, R> {
        fluent_builders::DeletePullRequestApprovalRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepository` operation.
    ///
    /// See [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) for more information about the
    /// operation and its arguments.
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository<C, M, R> {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMergeConflicts` operation.
    ///
    /// See [`DescribeMergeConflicts`](crate::client::fluent_builders::DescribeMergeConflicts) for more information about the
    /// operation and its arguments.
    pub fn describe_merge_conflicts(&self) -> fluent_builders::DescribeMergeConflicts<C, M, R> {
        fluent_builders::DescribeMergeConflicts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePullRequestEvents` operation.
    ///
    /// See [`DescribePullRequestEvents`](crate::client::fluent_builders::DescribePullRequestEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_pull_request_events(
        &self,
    ) -> fluent_builders::DescribePullRequestEvents<C, M, R> {
        fluent_builders::DescribePullRequestEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateApprovalRuleTemplateFromRepository` operation.
    ///
    /// See [`DisassociateApprovalRuleTemplateFromRepository`](crate::client::fluent_builders::DisassociateApprovalRuleTemplateFromRepository) for more information about the
    /// operation and its arguments.
    pub fn disassociate_approval_rule_template_from_repository(
        &self,
    ) -> fluent_builders::DisassociateApprovalRuleTemplateFromRepository<C, M, R> {
        fluent_builders::DisassociateApprovalRuleTemplateFromRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EvaluatePullRequestApprovalRules` operation.
    ///
    /// See [`EvaluatePullRequestApprovalRules`](crate::client::fluent_builders::EvaluatePullRequestApprovalRules) for more information about the
    /// operation and its arguments.
    pub fn evaluate_pull_request_approval_rules(
        &self,
    ) -> fluent_builders::EvaluatePullRequestApprovalRules<C, M, R> {
        fluent_builders::EvaluatePullRequestApprovalRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetApprovalRuleTemplate` operation.
    ///
    /// See [`GetApprovalRuleTemplate`](crate::client::fluent_builders::GetApprovalRuleTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_approval_rule_template(&self) -> fluent_builders::GetApprovalRuleTemplate<C, M, R> {
        fluent_builders::GetApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBlob` operation.
    ///
    /// See [`GetBlob`](crate::client::fluent_builders::GetBlob) for more information about the
    /// operation and its arguments.
    pub fn get_blob(&self) -> fluent_builders::GetBlob<C, M, R> {
        fluent_builders::GetBlob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBranch` operation.
    ///
    /// See [`GetBranch`](crate::client::fluent_builders::GetBranch) for more information about the
    /// operation and its arguments.
    pub fn get_branch(&self) -> fluent_builders::GetBranch<C, M, R> {
        fluent_builders::GetBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetComment` operation.
    ///
    /// See [`GetComment`](crate::client::fluent_builders::GetComment) for more information about the
    /// operation and its arguments.
    pub fn get_comment(&self) -> fluent_builders::GetComment<C, M, R> {
        fluent_builders::GetComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCommentReactions` operation.
    ///
    /// See [`GetCommentReactions`](crate::client::fluent_builders::GetCommentReactions) for more information about the
    /// operation and its arguments.
    pub fn get_comment_reactions(&self) -> fluent_builders::GetCommentReactions<C, M, R> {
        fluent_builders::GetCommentReactions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCommentsForComparedCommit` operation.
    ///
    /// See [`GetCommentsForComparedCommit`](crate::client::fluent_builders::GetCommentsForComparedCommit) for more information about the
    /// operation and its arguments.
    pub fn get_comments_for_compared_commit(
        &self,
    ) -> fluent_builders::GetCommentsForComparedCommit<C, M, R> {
        fluent_builders::GetCommentsForComparedCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCommentsForPullRequest` operation.
    ///
    /// See [`GetCommentsForPullRequest`](crate::client::fluent_builders::GetCommentsForPullRequest) for more information about the
    /// operation and its arguments.
    pub fn get_comments_for_pull_request(
        &self,
    ) -> fluent_builders::GetCommentsForPullRequest<C, M, R> {
        fluent_builders::GetCommentsForPullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCommit` operation.
    ///
    /// See [`GetCommit`](crate::client::fluent_builders::GetCommit) for more information about the
    /// operation and its arguments.
    pub fn get_commit(&self) -> fluent_builders::GetCommit<C, M, R> {
        fluent_builders::GetCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDifferences` operation.
    ///
    /// See [`GetDifferences`](crate::client::fluent_builders::GetDifferences) for more information about the
    /// operation and its arguments.
    pub fn get_differences(&self) -> fluent_builders::GetDifferences<C, M, R> {
        fluent_builders::GetDifferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFile` operation.
    ///
    /// See [`GetFile`](crate::client::fluent_builders::GetFile) for more information about the
    /// operation and its arguments.
    pub fn get_file(&self) -> fluent_builders::GetFile<C, M, R> {
        fluent_builders::GetFile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFolder` operation.
    ///
    /// See [`GetFolder`](crate::client::fluent_builders::GetFolder) for more information about the
    /// operation and its arguments.
    pub fn get_folder(&self) -> fluent_builders::GetFolder<C, M, R> {
        fluent_builders::GetFolder::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMergeCommit` operation.
    ///
    /// See [`GetMergeCommit`](crate::client::fluent_builders::GetMergeCommit) for more information about the
    /// operation and its arguments.
    pub fn get_merge_commit(&self) -> fluent_builders::GetMergeCommit<C, M, R> {
        fluent_builders::GetMergeCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMergeConflicts` operation.
    ///
    /// See [`GetMergeConflicts`](crate::client::fluent_builders::GetMergeConflicts) for more information about the
    /// operation and its arguments.
    pub fn get_merge_conflicts(&self) -> fluent_builders::GetMergeConflicts<C, M, R> {
        fluent_builders::GetMergeConflicts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMergeOptions` operation.
    ///
    /// See [`GetMergeOptions`](crate::client::fluent_builders::GetMergeOptions) for more information about the
    /// operation and its arguments.
    pub fn get_merge_options(&self) -> fluent_builders::GetMergeOptions<C, M, R> {
        fluent_builders::GetMergeOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPullRequest` operation.
    ///
    /// See [`GetPullRequest`](crate::client::fluent_builders::GetPullRequest) for more information about the
    /// operation and its arguments.
    pub fn get_pull_request(&self) -> fluent_builders::GetPullRequest<C, M, R> {
        fluent_builders::GetPullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPullRequestApprovalStates` operation.
    ///
    /// See [`GetPullRequestApprovalStates`](crate::client::fluent_builders::GetPullRequestApprovalStates) for more information about the
    /// operation and its arguments.
    pub fn get_pull_request_approval_states(
        &self,
    ) -> fluent_builders::GetPullRequestApprovalStates<C, M, R> {
        fluent_builders::GetPullRequestApprovalStates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPullRequestOverrideState` operation.
    ///
    /// See [`GetPullRequestOverrideState`](crate::client::fluent_builders::GetPullRequestOverrideState) for more information about the
    /// operation and its arguments.
    pub fn get_pull_request_override_state(
        &self,
    ) -> fluent_builders::GetPullRequestOverrideState<C, M, R> {
        fluent_builders::GetPullRequestOverrideState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepository` operation.
    ///
    /// See [`GetRepository`](crate::client::fluent_builders::GetRepository) for more information about the
    /// operation and its arguments.
    pub fn get_repository(&self) -> fluent_builders::GetRepository<C, M, R> {
        fluent_builders::GetRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepositoryTriggers` operation.
    ///
    /// See [`GetRepositoryTriggers`](crate::client::fluent_builders::GetRepositoryTriggers) for more information about the
    /// operation and its arguments.
    pub fn get_repository_triggers(&self) -> fluent_builders::GetRepositoryTriggers<C, M, R> {
        fluent_builders::GetRepositoryTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApprovalRuleTemplates` operation.
    ///
    /// See [`ListApprovalRuleTemplates`](crate::client::fluent_builders::ListApprovalRuleTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_approval_rule_templates(
        &self,
    ) -> fluent_builders::ListApprovalRuleTemplates<C, M, R> {
        fluent_builders::ListApprovalRuleTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociatedApprovalRuleTemplatesForRepository` operation.
    ///
    /// See [`ListAssociatedApprovalRuleTemplatesForRepository`](crate::client::fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository) for more information about the
    /// operation and its arguments.
    pub fn list_associated_approval_rule_templates_for_repository(
        &self,
    ) -> fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository<C, M, R> {
        fluent_builders::ListAssociatedApprovalRuleTemplatesForRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBranches` operation.
    ///
    /// See [`ListBranches`](crate::client::fluent_builders::ListBranches) for more information about the
    /// operation and its arguments.
    pub fn list_branches(&self) -> fluent_builders::ListBranches<C, M, R> {
        fluent_builders::ListBranches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPullRequests` operation.
    ///
    /// See [`ListPullRequests`](crate::client::fluent_builders::ListPullRequests) for more information about the
    /// operation and its arguments.
    pub fn list_pull_requests(&self) -> fluent_builders::ListPullRequests<C, M, R> {
        fluent_builders::ListPullRequests::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRepositories` operation.
    ///
    /// See [`ListRepositories`](crate::client::fluent_builders::ListRepositories) for more information about the
    /// operation and its arguments.
    pub fn list_repositories(&self) -> fluent_builders::ListRepositories<C, M, R> {
        fluent_builders::ListRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRepositoriesForApprovalRuleTemplate` operation.
    ///
    /// See [`ListRepositoriesForApprovalRuleTemplate`](crate::client::fluent_builders::ListRepositoriesForApprovalRuleTemplate) for more information about the
    /// operation and its arguments.
    pub fn list_repositories_for_approval_rule_template(
        &self,
    ) -> fluent_builders::ListRepositoriesForApprovalRuleTemplate<C, M, R> {
        fluent_builders::ListRepositoriesForApprovalRuleTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergeBranchesByFastForward` operation.
    ///
    /// See [`MergeBranchesByFastForward`](crate::client::fluent_builders::MergeBranchesByFastForward) for more information about the
    /// operation and its arguments.
    pub fn merge_branches_by_fast_forward(
        &self,
    ) -> fluent_builders::MergeBranchesByFastForward<C, M, R> {
        fluent_builders::MergeBranchesByFastForward::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergeBranchesBySquash` operation.
    ///
    /// See [`MergeBranchesBySquash`](crate::client::fluent_builders::MergeBranchesBySquash) for more information about the
    /// operation and its arguments.
    pub fn merge_branches_by_squash(&self) -> fluent_builders::MergeBranchesBySquash<C, M, R> {
        fluent_builders::MergeBranchesBySquash::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergeBranchesByThreeWay` operation.
    ///
    /// See [`MergeBranchesByThreeWay`](crate::client::fluent_builders::MergeBranchesByThreeWay) for more information about the
    /// operation and its arguments.
    pub fn merge_branches_by_three_way(&self) -> fluent_builders::MergeBranchesByThreeWay<C, M, R> {
        fluent_builders::MergeBranchesByThreeWay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergePullRequestByFastForward` operation.
    ///
    /// See [`MergePullRequestByFastForward`](crate::client::fluent_builders::MergePullRequestByFastForward) for more information about the
    /// operation and its arguments.
    pub fn merge_pull_request_by_fast_forward(
        &self,
    ) -> fluent_builders::MergePullRequestByFastForward<C, M, R> {
        fluent_builders::MergePullRequestByFastForward::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergePullRequestBySquash` operation.
    ///
    /// See [`MergePullRequestBySquash`](crate::client::fluent_builders::MergePullRequestBySquash) for more information about the
    /// operation and its arguments.
    pub fn merge_pull_request_by_squash(
        &self,
    ) -> fluent_builders::MergePullRequestBySquash<C, M, R> {
        fluent_builders::MergePullRequestBySquash::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergePullRequestByThreeWay` operation.
    ///
    /// See [`MergePullRequestByThreeWay`](crate::client::fluent_builders::MergePullRequestByThreeWay) for more information about the
    /// operation and its arguments.
    pub fn merge_pull_request_by_three_way(
        &self,
    ) -> fluent_builders::MergePullRequestByThreeWay<C, M, R> {
        fluent_builders::MergePullRequestByThreeWay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `OverridePullRequestApprovalRules` operation.
    ///
    /// See [`OverridePullRequestApprovalRules`](crate::client::fluent_builders::OverridePullRequestApprovalRules) for more information about the
    /// operation and its arguments.
    pub fn override_pull_request_approval_rules(
        &self,
    ) -> fluent_builders::OverridePullRequestApprovalRules<C, M, R> {
        fluent_builders::OverridePullRequestApprovalRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PostCommentForComparedCommit` operation.
    ///
    /// See [`PostCommentForComparedCommit`](crate::client::fluent_builders::PostCommentForComparedCommit) for more information about the
    /// operation and its arguments.
    pub fn post_comment_for_compared_commit(
        &self,
    ) -> fluent_builders::PostCommentForComparedCommit<C, M, R> {
        fluent_builders::PostCommentForComparedCommit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PostCommentForPullRequest` operation.
    ///
    /// See [`PostCommentForPullRequest`](crate::client::fluent_builders::PostCommentForPullRequest) for more information about the
    /// operation and its arguments.
    pub fn post_comment_for_pull_request(
        &self,
    ) -> fluent_builders::PostCommentForPullRequest<C, M, R> {
        fluent_builders::PostCommentForPullRequest::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PostCommentReply` operation.
    ///
    /// See [`PostCommentReply`](crate::client::fluent_builders::PostCommentReply) for more information about the
    /// operation and its arguments.
    pub fn post_comment_reply(&self) -> fluent_builders::PostCommentReply<C, M, R> {
        fluent_builders::PostCommentReply::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutCommentReaction` operation.
    ///
    /// See [`PutCommentReaction`](crate::client::fluent_builders::PutCommentReaction) for more information about the
    /// operation and its arguments.
    pub fn put_comment_reaction(&self) -> fluent_builders::PutCommentReaction<C, M, R> {
        fluent_builders::PutCommentReaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFile` operation.
    ///
    /// See [`PutFile`](crate::client::fluent_builders::PutFile) for more information about the
    /// operation and its arguments.
    pub fn put_file(&self) -> fluent_builders::PutFile<C, M, R> {
        fluent_builders::PutFile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRepositoryTriggers` operation.
    ///
    /// See [`PutRepositoryTriggers`](crate::client::fluent_builders::PutRepositoryTriggers) for more information about the
    /// operation and its arguments.
    pub fn put_repository_triggers(&self) -> fluent_builders::PutRepositoryTriggers<C, M, R> {
        fluent_builders::PutRepositoryTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestRepositoryTriggers` operation.
    ///
    /// See [`TestRepositoryTriggers`](crate::client::fluent_builders::TestRepositoryTriggers) for more information about the
    /// operation and its arguments.
    pub fn test_repository_triggers(&self) -> fluent_builders::TestRepositoryTriggers<C, M, R> {
        fluent_builders::TestRepositoryTriggers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApprovalRuleTemplateContent` operation.
    ///
    /// See [`UpdateApprovalRuleTemplateContent`](crate::client::fluent_builders::UpdateApprovalRuleTemplateContent) for more information about the
    /// operation and its arguments.
    pub fn update_approval_rule_template_content(
        &self,
    ) -> fluent_builders::UpdateApprovalRuleTemplateContent<C, M, R> {
        fluent_builders::UpdateApprovalRuleTemplateContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApprovalRuleTemplateDescription` operation.
    ///
    /// See [`UpdateApprovalRuleTemplateDescription`](crate::client::fluent_builders::UpdateApprovalRuleTemplateDescription) for more information about the
    /// operation and its arguments.
    pub fn update_approval_rule_template_description(
        &self,
    ) -> fluent_builders::UpdateApprovalRuleTemplateDescription<C, M, R> {
        fluent_builders::UpdateApprovalRuleTemplateDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApprovalRuleTemplateName` operation.
    ///
    /// See [`UpdateApprovalRuleTemplateName`](crate::client::fluent_builders::UpdateApprovalRuleTemplateName) for more information about the
    /// operation and its arguments.
    pub fn update_approval_rule_template_name(
        &self,
    ) -> fluent_builders::UpdateApprovalRuleTemplateName<C, M, R> {
        fluent_builders::UpdateApprovalRuleTemplateName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateComment` operation.
    ///
    /// See [`UpdateComment`](crate::client::fluent_builders::UpdateComment) for more information about the
    /// operation and its arguments.
    pub fn update_comment(&self) -> fluent_builders::UpdateComment<C, M, R> {
        fluent_builders::UpdateComment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDefaultBranch` operation.
    ///
    /// See [`UpdateDefaultBranch`](crate::client::fluent_builders::UpdateDefaultBranch) for more information about the
    /// operation and its arguments.
    pub fn update_default_branch(&self) -> fluent_builders::UpdateDefaultBranch<C, M, R> {
        fluent_builders::UpdateDefaultBranch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePullRequestApprovalRuleContent` operation.
    ///
    /// See [`UpdatePullRequestApprovalRuleContent`](crate::client::fluent_builders::UpdatePullRequestApprovalRuleContent) for more information about the
    /// operation and its arguments.
    pub fn update_pull_request_approval_rule_content(
        &self,
    ) -> fluent_builders::UpdatePullRequestApprovalRuleContent<C, M, R> {
        fluent_builders::UpdatePullRequestApprovalRuleContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePullRequestApprovalState` operation.
    ///
    /// See [`UpdatePullRequestApprovalState`](crate::client::fluent_builders::UpdatePullRequestApprovalState) for more information about the
    /// operation and its arguments.
    pub fn update_pull_request_approval_state(
        &self,
    ) -> fluent_builders::UpdatePullRequestApprovalState<C, M, R> {
        fluent_builders::UpdatePullRequestApprovalState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePullRequestDescription` operation.
    ///
    /// See [`UpdatePullRequestDescription`](crate::client::fluent_builders::UpdatePullRequestDescription) for more information about the
    /// operation and its arguments.
    pub fn update_pull_request_description(
        &self,
    ) -> fluent_builders::UpdatePullRequestDescription<C, M, R> {
        fluent_builders::UpdatePullRequestDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePullRequestStatus` operation.
    ///
    /// See [`UpdatePullRequestStatus`](crate::client::fluent_builders::UpdatePullRequestStatus) for more information about the
    /// operation and its arguments.
    pub fn update_pull_request_status(&self) -> fluent_builders::UpdatePullRequestStatus<C, M, R> {
        fluent_builders::UpdatePullRequestStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePullRequestTitle` operation.
    ///
    /// See [`UpdatePullRequestTitle`](crate::client::fluent_builders::UpdatePullRequestTitle) for more information about the
    /// operation and its arguments.
    pub fn update_pull_request_title(&self) -> fluent_builders::UpdatePullRequestTitle<C, M, R> {
        fluent_builders::UpdatePullRequestTitle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRepositoryDescription` operation.
    ///
    /// See [`UpdateRepositoryDescription`](crate::client::fluent_builders::UpdateRepositoryDescription) for more information about the
    /// operation and its arguments.
    pub fn update_repository_description(
        &self,
    ) -> fluent_builders::UpdateRepositoryDescription<C, M, R> {
        fluent_builders::UpdateRepositoryDescription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRepositoryName` operation.
    ///
    /// See [`UpdateRepositoryName`](crate::client::fluent_builders::UpdateRepositoryName) for more information about the
    /// operation and its arguments.
    pub fn update_repository_name(&self) -> fluent_builders::UpdateRepositoryName<C, M, R> {
        fluent_builders::UpdateRepositoryName::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateApprovalRuleTemplateWithRepository`.
    ///
    /// <p>Creates an association between an approval rule template and a specified repository.
    /// Then, the next time a pull request is created in the repository where the destination
    /// reference (if specified) matches the destination reference (branch) for the pull
    /// request, an approval rule that matches the template conditions is automatically created
    /// for that pull request. If no destination references are specified in the template, an
    /// approval rule that matches the template contents is created for all pull requests in
    /// that repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateApprovalRuleTemplateWithRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_approval_rule_template_with_repository_input::Builder,
    }
    impl<C, M, R> AssociateApprovalRuleTemplateWithRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateApprovalRuleTemplateWithRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AssociateApprovalRuleTemplateWithRepositoryError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateApprovalRuleTemplateWithRepositoryInputOperationOutputAlias,
                crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput,
                crate::error::AssociateApprovalRuleTemplateWithRepositoryError,
                crate::input::AssociateApprovalRuleTemplateWithRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the approval rule template. </p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name for the approval rule template. </p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The name of the repository that you want to associate with the template.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that you want to associate with the template.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchAssociateApprovalRuleTemplateWithRepositories`.
    ///
    /// <p>Creates an association between an approval rule template and one or more specified repositories. </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchAssociateApprovalRuleTemplateWithRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner:
            crate::input::batch_associate_approval_rule_template_with_repositories_input::Builder,
    }
    impl<C, M, R> BatchAssociateApprovalRuleTemplateWithRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchAssociateApprovalRuleTemplateWithRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput, aws_smithy_http::result::SdkError<crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInputOperationOutputAlias,
                                    crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput,
                                    crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesError,
                                    crate::input::BatchAssociateApprovalRuleTemplateWithRepositoriesInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template you want to associate with one or more repositories.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the template you want to associate with one or more repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The names of the repositories you want to associate with the template.</p>
        /// <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(inp);
            self
        }
        /// <p>The names of the repositories you want to associate with the template.</p>
        /// <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDescribeMergeConflicts`.
    ///
    /// <p>Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the squash or three-way merge strategy.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDescribeMergeConflicts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_describe_merge_conflicts_input::Builder,
    }
    impl<C, M, R> BatchDescribeMergeConflicts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDescribeMergeConflicts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDescribeMergeConflictsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDescribeMergeConflictsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDescribeMergeConflictsInputOperationOutputAlias,
                crate::output::BatchDescribeMergeConflictsOutput,
                crate::error::BatchDescribeMergeConflictsError,
                crate::input::BatchDescribeMergeConflictsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the merge conflicts you want to review.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, inp: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(inp);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn max_merge_hunks(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_merge_hunks(inp);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn set_max_merge_hunks(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_merge_hunks(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn max_conflict_files(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_conflict_files(inp);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn set_max_conflict_files(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_conflict_files(input);
            self
        }
        /// Appends an item to `filePaths`.
        ///
        /// To override the contents of this collection use [`set_file_paths`](Self::set_file_paths).
        ///
        /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
        pub fn file_paths(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_paths(inp);
            self
        }
        /// <p>The path of the target files used to describe the conflicts. If not specified, the default is all conflict files.</p>
        pub fn set_file_paths(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_file_paths(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDisassociateApprovalRuleTemplateFromRepositories`.
    ///
    /// <p>Removes the association between an approval rule template and one or more specified repositories. </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDisassociateApprovalRuleTemplateFromRepositories<C = aws_smithy_client::erase::DynConnector, M= crate::middleware::DefaultMiddleware, R= aws_smithy_client::retry::Standard> {
                            handle: std::sync::Arc<super::Handle<C, M, R>>,
                            inner: crate::input::batch_disassociate_approval_rule_template_from_repositories_input::Builder
                        }
    impl<C, M, R> BatchDisassociateApprovalRuleTemplateFromRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDisassociateApprovalRuleTemplateFromRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput, aws_smithy_http::result::SdkError<crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInputOperationOutputAlias,
                                    crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput,
                                    crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesError,
                                    crate::input::BatchDisassociateApprovalRuleTemplateFromRepositoriesInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the template that you want to disassociate from one or more repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The repository names that you want to disassociate from the approval rule
        /// template.</p>
        /// <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(inp);
            self
        }
        /// <p>The repository names that you want to disassociate from the approval rule
        /// template.</p>
        /// <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetCommits`.
    ///
    /// <p>Returns information about the contents of one or more commits in a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetCommits<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_commits_input::Builder,
    }
    impl<C, M, R> BatchGetCommits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetCommits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetCommitsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetCommitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetCommitsInputOperationOutputAlias,
                crate::output::BatchGetCommitsOutput,
                crate::error::BatchGetCommitsError,
                crate::input::BatchGetCommitsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `commitIds`.
        ///
        /// To override the contents of this collection use [`set_commit_ids`](Self::set_commit_ids).
        ///
        /// <p>The full commit IDs of the commits to get information about.</p>
        /// <note>
        /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA
        /// IDs.</p>
        /// </note>
        pub fn commit_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_ids(inp);
            self
        }
        /// <p>The full commit IDs of the commits to get information about.</p>
        /// <note>
        /// <p>You must supply the full SHA IDs of each commit. You cannot use shortened SHA
        /// IDs.</p>
        /// </note>
        pub fn set_commit_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_commit_ids(input);
            self
        }
        /// <p>The name of the repository that contains the commits.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetRepositories`.
    ///
    /// <p>Returns information about one or more repositories.</p>
    /// <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid
    /// Unicode characters. Applications that do not HTML-encode the description and display
    /// it in a webpage can expose users to potentially malicious code. Make sure that you
    /// HTML-encode the description field in any application that uses this API to display
    /// the repository description on a webpage.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_repositories_input::Builder,
    }
    impl<C, M, R> BatchGetRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetRepositoriesInputOperationOutputAlias,
                crate::output::BatchGetRepositoriesOutput,
                crate::error::BatchGetRepositoriesError,
                crate::input::BatchGetRepositoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `repositoryNames`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>The names of the repositories to get information about.</p>
        /// <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn repository_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_names(inp);
            self
        }
        /// <p>The names of the repositories to get information about.</p>
        /// <note>
        /// <p>The length constraint limit is for each string in the array. The array itself can be empty.</p>
        /// </note>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_repository_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApprovalRuleTemplate`.
    ///
    /// <p>Creates a template for approval rules that can then be associated with one or more
    /// repositories in your AWS account. When you associate a template with a repository, AWS
    /// CodeCommit creates an approval rule that matches the conditions of the template for all
    /// pull requests that meet the conditions of the template. For more information, see
    /// <a>AssociateApprovalRuleTemplateWithRepository</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateApprovalRuleTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_approval_rule_template_input::Builder,
    }
    impl<C, M, R> CreateApprovalRuleTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApprovalRuleTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApprovalRuleTemplateInputOperationOutputAlias,
                crate::output::CreateApprovalRuleTemplateOutput,
                crate::error::CreateApprovalRuleTemplateError,
                crate::input::CreateApprovalRuleTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template. Provide descriptive names, because this name
        /// is applied to the approval rules created automatically in associated
        /// repositories.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the approval rule template. Provide descriptive names, because this name
        /// is applied to the approval rules created automatically in associated
        /// repositories.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The content of the approval rule that is created on pull requests in associated
        /// repositories. If you specify one or more destination references (branches), approval
        /// rules are created in an associated repository only if their destination references
        /// (branches) match those specified in the template.</p>
        /// <note>
        /// <p>When you create the content of the approval rule template, you can specify
        /// approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>CodeCommitApprovers</b>: This option only
        /// requires an AWS account and a resource. It can be used for both IAM users
        /// and federated access users whose name matches the provided resource name.
        /// This is a very powerful option that offers a great deal of flexibility. For
        /// example, if you specify the AWS account <i>123456789012</i>
        /// and <i>Mary_Major</i>, all of the following are counted as
        /// approvals coming from that user:</p>
        /// <ul>
        /// <li>
        /// <p>An IAM user in the account
        /// (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p>
        /// </li>
        /// <li>
        /// <p>A federated user identified in IAM as Mary_Major
        /// (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p>
        /// </li>
        /// </ul>
        /// <p>This option does not recognize an active session of someone assuming the
        /// role of CodeCommitReview with a role session name of
        /// <i>Mary_Major</i>
        /// (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>)
        /// unless you include a wildcard (*Mary_Major).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Fully qualified ARN</b>: This option allows
        /// you to specify the fully qualified Amazon Resource Name (ARN) of the IAM
        /// user or role. </p>
        /// </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        ///
        /// </note>
        pub fn approval_rule_template_content(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_content(inp);
            self
        }
        /// <p>The content of the approval rule that is created on pull requests in associated
        /// repositories. If you specify one or more destination references (branches), approval
        /// rules are created in an associated repository only if their destination references
        /// (branches) match those specified in the template.</p>
        /// <note>
        /// <p>When you create the content of the approval rule template, you can specify
        /// approvers in an approval pool in one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>CodeCommitApprovers</b>: This option only
        /// requires an AWS account and a resource. It can be used for both IAM users
        /// and federated access users whose name matches the provided resource name.
        /// This is a very powerful option that offers a great deal of flexibility. For
        /// example, if you specify the AWS account <i>123456789012</i>
        /// and <i>Mary_Major</i>, all of the following are counted as
        /// approvals coming from that user:</p>
        /// <ul>
        /// <li>
        /// <p>An IAM user in the account
        /// (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p>
        /// </li>
        /// <li>
        /// <p>A federated user identified in IAM as Mary_Major
        /// (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p>
        /// </li>
        /// </ul>
        /// <p>This option does not recognize an active session of someone assuming the
        /// role of CodeCommitReview with a role session name of
        /// <i>Mary_Major</i>
        /// (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>)
        /// unless you include a wildcard (*Mary_Major).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Fully qualified ARN</b>: This option allows
        /// you to specify the fully qualified Amazon Resource Name (ARN) of the IAM
        /// user or role. </p>
        /// </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        ///
        /// </note>
        pub fn set_approval_rule_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_content(input);
            self
        }
        /// <p>The description of the approval rule template. Consider providing a description that
        /// explains what this template does and when it might be appropriate to associate it with
        /// repositories.</p>
        pub fn approval_rule_template_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_description(inp);
            self
        }
        /// <p>The description of the approval rule template. Consider providing a description that
        /// explains what this template does and when it might be appropriate to associate it with
        /// repositories.</p>
        pub fn set_approval_rule_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBranch`.
    ///
    /// <p>Creates a branch in a repository and points the branch to a commit.</p>
    /// <note>
    /// <p>Calling the create branch operation does not set a repository's default branch. To do this, call the update default branch operation.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_branch_input::Builder,
    }
    impl<C, M, R> CreateBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBranchInputOperationOutputAlias,
                crate::output::CreateBranchOutput,
                crate::error::CreateBranchError,
                crate::input::CreateBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository in which you want to create the new branch.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository in which you want to create the new branch.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the new branch to create.</p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p>The name of the new branch to create.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The ID of the commit to point the new branch to.</p>
        pub fn commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_id(inp);
            self
        }
        /// <p>The ID of the commit to point the new branch to.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCommit`.
    ///
    /// <p>Creates a commit for a repository on the tip of a specified branch.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCommit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_commit_input::Builder,
    }
    impl<C, M, R> CreateCommit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCommitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCommitInputOperationOutputAlias,
                crate::output::CreateCommitOutput,
                crate::error::CreateCommitError,
                crate::input::CreateCommitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you create the commit.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you create the commit.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch where you create the commit.</p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p>The name of the branch where you create the commit.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The ID of the commit that is the parent of the commit you create. Not required if this
        /// is an empty repository.</p>
        pub fn parent_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_commit_id(inp);
            self
        }
        /// <p>The ID of the commit that is the parent of the commit you create. Not required if this
        /// is an empty repository.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_commit_id(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn author_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(inp);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person who created the commit.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the person who created the commit.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message you want to include in the commit. Commit messages are limited to
        /// 256 KB. If no message is specified, a default message is used.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>The commit message you want to include in the commit. Commit messages are limited to
        /// 256 KB. If no message is specified, a default message is used.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a ..gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn keep_empty_folders(mut self, inp: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(inp);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a ..gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// Appends an item to `putFiles`.
        ///
        /// To override the contents of this collection use [`set_put_files`](Self::set_put_files).
        ///
        /// <p>The files to add or update in this commit.</p>
        pub fn put_files(mut self, inp: impl Into<crate::model::PutFileEntry>) -> Self {
            self.inner = self.inner.put_files(inp);
            self
        }
        /// <p>The files to add or update in this commit.</p>
        pub fn set_put_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutFileEntry>>,
        ) -> Self {
            self.inner = self.inner.set_put_files(input);
            self
        }
        /// Appends an item to `deleteFiles`.
        ///
        /// To override the contents of this collection use [`set_delete_files`](Self::set_delete_files).
        ///
        /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
        pub fn delete_files(mut self, inp: impl Into<crate::model::DeleteFileEntry>) -> Self {
            self.inner = self.inner.delete_files(inp);
            self
        }
        /// <p>The files to delete in this commit. These files still exist in earlier commits.</p>
        pub fn set_delete_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
        ) -> Self {
            self.inner = self.inner.set_delete_files(input);
            self
        }
        /// Appends an item to `setFileModes`.
        ///
        /// To override the contents of this collection use [`set_set_file_modes`](Self::set_set_file_modes).
        ///
        /// <p>The file modes to update for files in this commit.</p>
        pub fn set_file_modes(mut self, inp: impl Into<crate::model::SetFileModeEntry>) -> Self {
            self.inner = self.inner.set_file_modes(inp);
            self
        }
        /// <p>The file modes to update for files in this commit.</p>
        pub fn set_set_file_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
        ) -> Self {
            self.inner = self.inner.set_set_file_modes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePullRequest`.
    ///
    /// <p>Creates a pull request in the specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePullRequest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_pull_request_input::Builder,
    }
    impl<C, M, R> CreatePullRequest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePullRequestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePullRequestInputOperationOutputAlias,
                crate::output::CreatePullRequestOutput,
                crate::error::CreatePullRequestError,
                crate::input::CreatePullRequestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The title of the pull request. This title is used to identify the pull request to
        /// other users in the repository.</p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>The title of the pull request. This title is used to identify the pull request to
        /// other users in the repository.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
        /// <p>A description of the pull request.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the pull request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets for the pull request, including the source of the code to be reviewed (the
        /// source branch) and the destination where the creator of the pull request intends the
        /// code to be merged after the pull request is closed (the destination branch).</p>
        pub fn targets(mut self, inp: impl Into<crate::model::Target>) -> Self {
            self.inner = self.inner.targets(inp);
            self
        }
        /// <p>The targets for the pull request, including the source of the code to be reviewed (the
        /// source branch) and the destination where the creator of the pull request intends the
        /// code to be merged after the pull request is closed (the destination branch).</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        /// <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
        /// idempotency token is created for you.</p>
        /// </note>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        /// <note>
        /// <p>The AWS SDKs prepopulate client request tokens. If you are using an AWS SDK, an
        /// idempotency token is created for you.</p>
        /// </note>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePullRequestApprovalRule`.
    ///
    /// <p>Creates an approval rule for a pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePullRequestApprovalRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_pull_request_approval_rule_input::Builder,
    }
    impl<C, M, R> CreatePullRequestApprovalRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePullRequestApprovalRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePullRequestApprovalRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePullRequestApprovalRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePullRequestApprovalRuleInputOperationOutputAlias,
                crate::output::CreatePullRequestApprovalRuleOutput,
                crate::error::CreatePullRequestApprovalRuleError,
                crate::input::CreatePullRequestApprovalRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request for which you want to create the approval rule.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name for the approval rule.</p>
        pub fn approval_rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_name(inp);
            self
        }
        /// <p>The name for the approval rule.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_name(input);
            self
        }
        /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information
        /// about approval pools, see the AWS CodeCommit User Guide.</p>
        /// <note>
        /// <p>When you create the content of the approval rule, you can specify approvers in an
        /// approval pool in one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>CodeCommitApprovers</b>: This option only
        /// requires an AWS account and a resource. It can be used for both IAM users
        /// and federated access users whose name matches the provided resource name.
        /// This is a very powerful option that offers a great deal of flexibility. For
        /// example, if you specify the AWS account <i>123456789012</i>
        /// and <i>Mary_Major</i>, all of the following would be counted
        /// as approvals coming from that user:</p>
        /// <ul>
        /// <li>
        /// <p>An IAM user in the account
        /// (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p>
        /// </li>
        /// <li>
        /// <p>A federated user identified in IAM as Mary_Major
        /// (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p>
        /// </li>
        /// </ul>
        /// <p>This option does not recognize an active session of someone assuming the
        /// role of CodeCommitReview with a role session name of
        /// <i>Mary_Major</i>
        /// (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>)
        /// unless you include a wildcard (*Mary_Major).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Fully qualified ARN</b>: This option allows
        /// you to specify the fully qualified Amazon Resource Name (ARN) of the IAM
        /// user or role. </p>
        /// </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        ///
        /// </note>
        pub fn approval_rule_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_content(inp);
            self
        }
        /// <p>The content of the approval rule, including the number of approvals needed and the structure of an approval pool defined for approvals, if any. For more information
        /// about approval pools, see the AWS CodeCommit User Guide.</p>
        /// <note>
        /// <p>When you create the content of the approval rule, you can specify approvers in an
        /// approval pool in one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>CodeCommitApprovers</b>: This option only
        /// requires an AWS account and a resource. It can be used for both IAM users
        /// and federated access users whose name matches the provided resource name.
        /// This is a very powerful option that offers a great deal of flexibility. For
        /// example, if you specify the AWS account <i>123456789012</i>
        /// and <i>Mary_Major</i>, all of the following would be counted
        /// as approvals coming from that user:</p>
        /// <ul>
        /// <li>
        /// <p>An IAM user in the account
        /// (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p>
        /// </li>
        /// <li>
        /// <p>A federated user identified in IAM as Mary_Major
        /// (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p>
        /// </li>
        /// </ul>
        /// <p>This option does not recognize an active session of someone assuming the
        /// role of CodeCommitReview with a role session name of
        /// <i>Mary_Major</i>
        /// (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>)
        /// unless you include a wildcard (*Mary_Major).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Fully qualified ARN</b>: This option allows
        /// you to specify the fully qualified Amazon Resource Name (ARN) of the IAM
        /// user or role. </p>
        /// </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see
        /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        ///
        /// </note>
        pub fn set_approval_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p>Creates a new, empty repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl<C, M, R> CreateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRepositoryInputOperationOutputAlias,
                crate::output::CreateRepositoryOutput,
                crate::error::CreateRepositoryError,
                crate::input::CreateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new repository to be created.</p>
        /// <note>
        /// <p>The repository name must be unique across the calling AWS account. Repository names
        /// are limited to 100 alphanumeric, dash, and underscore characters, and cannot include
        /// certain characters. For more information about the limits on repository names, see
        /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The
        /// suffix .git is prohibited.</p>
        /// </note>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the new repository to be created.</p>
        /// <note>
        /// <p>The repository name must be unique across the calling AWS account. Repository names
        /// are limited to 100 alphanumeric, dash, and underscore characters, and cannot include
        /// certain characters. For more information about the limits on repository names, see
        /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the <i>AWS CodeCommit User Guide</i>. The
        /// suffix .git is prohibited.</p>
        /// </note>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>A comment or description about the new repository.</p>
        /// <note>
        /// <p>The description field for a repository accepts all HTML characters and all valid
        /// Unicode characters. Applications that do not HTML-encode the description and display
        /// it in a webpage can expose users to potentially malicious code. Make sure that you
        /// HTML-encode the description field in any application that uses this API to display
        /// the repository description on a webpage.</p>
        /// </note>
        pub fn repository_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_description(inp);
            self
        }
        /// <p>A comment or description about the new repository.</p>
        /// <note>
        /// <p>The description field for a repository accepts all HTML characters and all valid
        /// Unicode characters. Applications that do not HTML-encode the description and display
        /// it in a webpage can expose users to potentially malicious code. Make sure that you
        /// HTML-encode the description field in any application that uses this API to display
        /// the repository description on a webpage.</p>
        /// </note>
        pub fn set_repository_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_description(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tag key-value pairs to use when tagging this repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUnreferencedMergeCommit`.
    ///
    /// <p>Creates an unreferenced commit that represents the result of merging two branches
    /// using a specified merge strategy. This can help you determine the outcome of a potential
    /// merge. This API cannot be used with the fast-forward merge strategy because that
    /// strategy does not create a merge commit.</p>
    /// <note>
    /// <p>This unreferenced merge commit
    /// can only be accessed using the GetCommit API or through git commands such as git fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateUnreferencedMergeCommit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_unreferenced_merge_commit_input::Builder,
    }
    impl<C, M, R> CreateUnreferencedMergeCommit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUnreferencedMergeCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUnreferencedMergeCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUnreferencedMergeCommitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUnreferencedMergeCommitInputOperationOutputAlias,
                crate::output::CreateUnreferencedMergeCommitOutput,
                crate::error::CreateUnreferencedMergeCommitError,
                crate::input::CreateUnreferencedMergeCommitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to create the unreferenced merge commit.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, inp: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(inp);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The name of the author who created the unreferenced commit. This information is used
        /// as both the author and committer for the commit.</p>
        pub fn author_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(inp);
            self
        }
        /// <p>The name of the author who created the unreferenced commit. This information is used
        /// as both the author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address for the person who created the unreferenced commit.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address for the person who created the unreferenced commit.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message for the unreferenced commit.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>The commit message for the unreferenced commit.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If this is specified as true, a .gitkeep file is
        /// created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, inp: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(inp);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If this is specified as true, a .gitkeep file is
        /// created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, inp: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(inp);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApprovalRuleTemplate`.
    ///
    /// <p>Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests already created with the template.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteApprovalRuleTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_approval_rule_template_input::Builder,
    }
    impl<C, M, R> DeleteApprovalRuleTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApprovalRuleTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApprovalRuleTemplateInputOperationOutputAlias,
                crate::output::DeleteApprovalRuleTemplateOutput,
                crate::error::DeleteApprovalRuleTemplateError,
                crate::input::DeleteApprovalRuleTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template to delete.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the approval rule template to delete.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBranch`.
    ///
    /// <p>Deletes a branch from a repository, unless that branch is the default branch for the repository. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_branch_input::Builder,
    }
    impl<C, M, R> DeleteBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBranchInputOperationOutputAlias,
                crate::output::DeleteBranchOutput,
                crate::error::DeleteBranchError,
                crate::input::DeleteBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the branch to be deleted.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the branch to be deleted.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch to delete.</p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p>The name of the branch to delete.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCommentContent`.
    ///
    /// <p>Deletes the content of a comment made on a change, file, or commit in a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCommentContent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_comment_content_input::Builder,
    }
    impl<C, M, R> DeleteCommentContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCommentContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCommentContentOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCommentContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCommentContentInputOperationOutputAlias,
                crate::output::DeleteCommentContentOutput,
                crate::error::DeleteCommentContentError,
                crate::input::DeleteCommentContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use  <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn comment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(inp);
            self
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use  <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFile`.
    ///
    /// <p>Deletes a specified file from a specified branch. A commit is created on the branch
    /// that contains the revision. The file still exists in the commits earlier to the commit
    /// that contains the deletion.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_file_input::Builder,
    }
    impl<C, M, R> DeleteFile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFileInputOperationOutputAlias,
                crate::output::DeleteFileOutput,
                crate::error::DeleteFileError,
                crate::input::DeleteFileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the file to delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the file to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch where the commit that deletes the file is made.</p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p>The name of the branch where the commit that deletes the file is made.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The fully qualified path to the file that to be deleted, including the full name and
        /// extension of that file. For example, /examples/file.md is a fully qualified path to a
        /// file named file.md in a folder named examples.</p>
        pub fn file_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(inp);
            self
        }
        /// <p>The fully qualified path to the file that to be deleted, including the full name and
        /// extension of that file. For example, /examples/file.md is a fully qualified path to a
        /// file named file.md in a folder named examples.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
        /// <p>The ID of the commit that is the tip of the branch where you want to create the commit
        /// that deletes the file. This must be the HEAD commit for the branch. The commit that
        /// deletes the file is created from this commit ID.</p>
        pub fn parent_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_commit_id(inp);
            self
        }
        /// <p>The ID of the commit that is the tip of the branch where you want to create the commit
        /// that deletes the file. This must be the HEAD commit for the branch. The commit that
        /// deletes the file is created from this commit ID.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_commit_id(input);
            self
        }
        /// <p>If a file is the only object in the folder or directory, specifies whether to delete
        /// the folder or directory that contains the file. By default, empty folders are deleted.
        /// This includes empty folders that are part of the directory structure. For example, if
        /// the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the
        /// last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
        pub fn keep_empty_folders(mut self, inp: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(inp);
            self
        }
        /// <p>If a file is the only object in the folder or directory, specifies whether to delete
        /// the folder or directory that contains the file. By default, empty folders are deleted.
        /// This includes empty folders that are part of the directory structure. For example, if
        /// the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the
        /// last file in dir4 also deletes the empty folders dir4, dir3, and dir2.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>The commit message you want to include as part of deleting the file. Commit messages
        /// are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>The commit message you want to include as part of deleting the file. Commit messages
        /// are limited to 256 KB. If no message is specified, a default message is used.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the author of the commit that deletes the file. If no name is specified,
        /// the user's ARN is used as the author name and committer name.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the author of the commit that deletes the file. If no name is specified,
        /// the user's ARN is used as the author name and committer name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The email address for the commit that deletes the file. If no email address is
        /// specified, the email address is left blank.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address for the commit that deletes the file. If no email address is
        /// specified, the email address is left blank.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePullRequestApprovalRule`.
    ///
    /// <p>Deletes an approval rule from a specified pull request. Approval rules can be deleted from a pull request only if the pull request is open, and if the
    /// approval rule was created specifically for a pull request and not generated from an approval rule template associated with the repository where the
    /// pull request was created. You cannot delete an approval rule from a merged or closed pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePullRequestApprovalRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_pull_request_approval_rule_input::Builder,
    }
    impl<C, M, R> DeletePullRequestApprovalRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePullRequestApprovalRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePullRequestApprovalRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePullRequestApprovalRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePullRequestApprovalRuleInputOperationOutputAlias,
                crate::output::DeletePullRequestApprovalRuleOutput,
                crate::error::DeletePullRequestApprovalRuleError,
                crate::input::DeletePullRequestApprovalRuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request that contains the approval rule you want to delete.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the approval rule you want to delete.</p>
        pub fn approval_rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_name(inp);
            self
        }
        /// <p>The name of the approval rule you want to delete.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p>Deletes a repository. If a specified repository was already deleted, a null repository
    /// ID is returned.</p>
    /// <important>
    /// <p>Deleting a repository also deletes all associated objects and metadata. After a repository is
    /// deleted, all future push calls to the deleted repository fail.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl<C, M, R> DeleteRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryInputOperationOutputAlias,
                crate::output::DeleteRepositoryOutput,
                crate::error::DeleteRepositoryError,
                crate::input::DeleteRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to delete.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to delete.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMergeConflicts`.
    ///
    /// <p>Returns information about one or more merge conflicts in the attempted merge of two
    /// commit specifiers using the squash or three-way merge strategy. If the merge option for
    /// the attempted merge is specified as FAST_FORWARD_MERGE, an exception is thrown.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMergeConflicts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_merge_conflicts_input::Builder,
    }
    impl<C, M, R> DescribeMergeConflicts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMergeConflicts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMergeConflictsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMergeConflictsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMergeConflictsInputOperationOutputAlias,
                crate::output::DescribeMergeConflictsOutput,
                crate::error::DescribeMergeConflictsError,
                crate::input::DescribeMergeConflictsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to get information about a merge conflict.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to get information about a merge conflict.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn merge_option(mut self, inp: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(inp);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn max_merge_hunks(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_merge_hunks(inp);
            self
        }
        /// <p>The maximum number of merge hunks to include in the output.</p>
        pub fn set_max_merge_hunks(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_merge_hunks(input);
            self
        }
        /// <p>The path of the target files used to describe the conflicts. </p>
        pub fn file_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(inp);
            self
        }
        /// <p>The path of the target files used to describe the conflicts. </p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePullRequestEvents`.
    ///
    /// <p>Returns information about one or more pull request events.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePullRequestEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pull_request_events_input::Builder,
    }
    impl<C, M, R> DescribePullRequestEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePullRequestEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePullRequestEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePullRequestEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePullRequestEventsInputOperationOutputAlias,
                crate::output::DescribePullRequestEventsOutput,
                crate::error::DescribePullRequestEventsError,
                crate::input::DescribePullRequestEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>Optional. The pull request event type about which you want to return information.</p>
        pub fn pull_request_event_type(mut self, inp: crate::model::PullRequestEventType) -> Self {
            self.inner = self.inner.pull_request_event_type(inp);
            self
        }
        /// <p>Optional. The pull request event type about which you want to return information.</p>
        pub fn set_pull_request_event_type(
            mut self,
            input: std::option::Option<crate::model::PullRequestEventType>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_event_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event.
        /// Examples include updating the pull request with more commits or changing the status of a
        /// pull request.</p>
        pub fn actor_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.actor_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event.
        /// Examples include updating the pull request with more commits or changing the status of a
        /// pull request.</p>
        pub fn set_actor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_actor_arn(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.
        /// The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.
        /// The default is 100 events, which is also the maximum number of events that can be returned in a result.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateApprovalRuleTemplateFromRepository`.
    ///
    /// <p>Removes the association between a template and a repository so that approval rules
    /// based on the template are not automatically created when pull requests are created in
    /// the specified repository. This does not delete any approval rules previously created for
    /// pull requests through the template association.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateApprovalRuleTemplateFromRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_approval_rule_template_from_repository_input::Builder,
    }
    impl<C, M, R> DisassociateApprovalRuleTemplateFromRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateApprovalRuleTemplateFromRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput, aws_smithy_http::result::SdkError<crate::error::DisassociateApprovalRuleTemplateFromRepositoryError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::DisassociateApprovalRuleTemplateFromRepositoryInputOperationOutputAlias,
                                    crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput,
                                    crate::error::DisassociateApprovalRuleTemplateFromRepositoryError,
                                    crate::input::DisassociateApprovalRuleTemplateFromRepositoryInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the approval rule template to disassociate from a specified repository.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The name of the repository you want to disassociate from the template.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository you want to disassociate from the template.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EvaluatePullRequestApprovalRules`.
    ///
    /// <p>Evaluates whether a pull request has met all the conditions specified in its associated approval rules.</p>
    #[derive(std::fmt::Debug)]
    pub struct EvaluatePullRequestApprovalRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::evaluate_pull_request_approval_rules_input::Builder,
    }
    impl<C, M, R> EvaluatePullRequestApprovalRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EvaluatePullRequestApprovalRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EvaluatePullRequestApprovalRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::EvaluatePullRequestApprovalRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EvaluatePullRequestApprovalRulesInputOperationOutputAlias,
                crate::output::EvaluatePullRequestApprovalRulesOutput,
                crate::error::EvaluatePullRequestApprovalRulesError,
                crate::input::EvaluatePullRequestApprovalRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request you want to evaluate.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request you want to evaluate.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID for the pull request revision. To retrieve the most recent
        /// revision ID for a pull request, use
        /// <a>GetPullRequest</a>.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>The system-generated ID for the pull request revision. To retrieve the most recent
        /// revision ID for a pull request, use
        /// <a>GetPullRequest</a>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetApprovalRuleTemplate`.
    ///
    /// <p>Returns information about a specified approval rule template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetApprovalRuleTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_approval_rule_template_input::Builder,
    }
    impl<C, M, R> GetApprovalRuleTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetApprovalRuleTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetApprovalRuleTemplateInputOperationOutputAlias,
                crate::output::GetApprovalRuleTemplateOutput,
                crate::error::GetApprovalRuleTemplateError,
                crate::input::GetApprovalRuleTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template for which you want to get information.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the approval rule template for which you want to get information.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlob`.
    ///
    /// <p>Returns the base-64 encoded content of an individual blob in a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBlob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_blob_input::Builder,
    }
    impl<C, M, R> GetBlob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlobInputOperationOutputAlias,
                crate::output::GetBlobOutput,
                crate::error::GetBlobError,
                crate::input::GetBlobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the blob.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the blob.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn blob_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blob_id(inp);
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_blob_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBranch`.
    ///
    /// <p>Returns information about a repository branch, including its name and the last commit ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_branch_input::Builder,
    }
    impl<C, M, R> GetBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBranchInputOperationOutputAlias,
                crate::output::GetBranchOutput,
                crate::error::GetBranchError,
                crate::input::GetBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the branch for which you want to retrieve information.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch for which you want to retrieve information.</p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p>The name of the branch for which you want to retrieve information.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetComment`.
    ///
    /// <p>Returns the content of a comment made on a change, file, or commit in a repository. </p>
    /// <note>
    /// <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of
    /// reactions from active identities, use GetCommentReactions.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetComment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_comment_input::Builder,
    }
    impl<C, M, R> GetComment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCommentInputOperationOutputAlias,
                crate::output::GetCommentOutput,
                crate::error::GetCommentError,
                crate::input::GetCommentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use  <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn comment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(inp);
            self
        }
        /// <p>The unique, system-generated ID of the comment. To get this ID, use  <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommentReactions`.
    ///
    /// <p>Returns information about reactions to a specified comment ID. Reactions from users who have been deleted will not be included in the count.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCommentReactions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_comment_reactions_input::Builder,
    }
    impl<C, M, R> GetCommentReactions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCommentReactions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentReactionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentReactionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCommentReactionsInputOperationOutputAlias,
                crate::output::GetCommentReactionsOutput,
                crate::error::GetCommentReactionsError,
                crate::input::GetCommentReactionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the comment for which you want to get reactions information.</p>
        pub fn comment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(inp);
            self
        }
        /// <p>The ID of the comment for which you want to get reactions information.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
        pub fn reaction_user_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reaction_user_arn(inp);
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user or identity for which you want to get reaction information.</p>
        pub fn set_reaction_user_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reaction_user_arn(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.  The default is the same as the allowed maximum, 1,000.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.  The default is the same as the allowed maximum, 1,000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommentsForComparedCommit`.
    ///
    /// <p>Returns information about comments made on the comparison between two commits.</p>
    /// <note>
    /// <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of
    /// reactions from active identities, use GetCommentReactions.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetCommentsForComparedCommit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_comments_for_compared_commit_input::Builder,
    }
    impl<C, M, R> GetCommentsForComparedCommit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCommentsForComparedCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentsForComparedCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentsForComparedCommitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCommentsForComparedCommitInputOperationOutputAlias,
                crate::output::GetCommentsForComparedCommitOutput,
                crate::error::GetCommentsForComparedCommitError,
                crate::input::GetCommentsForComparedCommitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to compare commits.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to compare commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before
        /// commit.</p>
        pub fn before_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(inp);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before
        /// commit.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after
        /// commit.</p>
        pub fn after_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(inp);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after
        /// commit.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that when provided in a request, returns the next batch of the results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The
        /// default is 100 comments, but you can configure up to 500.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The
        /// default is 100 comments, but you can configure up to 500.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommentsForPullRequest`.
    ///
    /// <p>Returns comments made on a pull request.</p>
    /// <note>
    /// <p>Reaction counts might include numbers from user identities who were deleted after the reaction was made. For a count of
    /// reactions from active identities, use GetCommentReactions.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetCommentsForPullRequest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_comments_for_pull_request_input::Builder,
    }
    impl<C, M, R> GetCommentsForPullRequest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCommentsForPullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommentsForPullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommentsForPullRequestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCommentsForPullRequestInputOperationOutputAlias,
                crate::output::GetCommentsForPullRequestOutput,
                crate::error::GetCommentsForPullRequestError,
                crate::input::GetCommentsForPullRequestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn before_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
        pub fn after_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the comment was made.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments.
        /// You can return up to 500 comments with a single request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results. The default is 100 comments.
        /// You can return up to 500 comments with a single request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCommit`.
    ///
    /// <p>Returns information about a commit, including commit message and committer information.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCommit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_commit_input::Builder,
    }
    impl<C, M, R> GetCommit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCommitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCommitInputOperationOutputAlias,
                crate::output::GetCommitOutput,
                crate::error::GetCommitError,
                crate::input::GetCommitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to which the commit was made.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to which the commit was made.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
        pub fn commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_id(inp);
            self
        }
        /// <p>The commit ID. Commit IDs are the full SHA ID of the commit.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_commit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDifferences`.
    ///
    /// <p>Returns information about the differences in a valid commit specifier (such as a
    /// branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be
    /// limited to a specified path.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDifferences<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_differences_input::Builder,
    }
    impl<C, M, R> GetDifferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDifferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDifferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDifferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDifferencesInputOperationOutputAlias,
                crate::output::GetDifferencesOutput,
                crate::error::GetDifferencesError,
                crate::input::GetDifferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to get differences.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to get differences.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, the full commit ID). Optional. If not specified, all changes before the
        /// <code>afterCommitSpecifier</code> value are shown. If you do not use
        /// <code>beforeCommitSpecifier</code> in your request, consider limiting the results
        /// with <code>maxResults</code>.</p>
        pub fn before_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, the full commit ID). Optional. If not specified, all changes before the
        /// <code>afterCommitSpecifier</code> value are shown. If you do not use
        /// <code>beforeCommitSpecifier</code> in your request, consider limiting the results
        /// with <code>maxResults</code>.</p>
        pub fn set_before_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
        pub fn after_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit.</p>
        pub fn set_after_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_specifier(input);
            self
        }
        /// <p>The file path in which to check for differences. Limits the results to this path. Can
        /// also be used to specify the previous name of a directory or folder. If
        /// <code>beforePath</code> and <code>afterPath</code> are not specified, differences
        /// are shown for all paths.</p>
        pub fn before_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_path(inp);
            self
        }
        /// <p>The file path in which to check for differences. Limits the results to this path. Can
        /// also be used to specify the previous name of a directory or folder. If
        /// <code>beforePath</code> and <code>afterPath</code> are not specified, differences
        /// are shown for all paths.</p>
        pub fn set_before_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_before_path(input);
            self
        }
        /// <p>The file path in which to check differences. Limits the results to this path. Can also
        /// be used to specify the changed name of a directory or folder, if it has changed. If not
        /// specified, differences are shown for all paths.</p>
        pub fn after_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_path(inp);
            self
        }
        /// <p>The file path in which to check differences. Limits the results to this path. Can also
        /// be used to specify the changed name of a directory or folder, if it has changed. If not
        /// specified, differences are shown for all paths.</p>
        pub fn set_after_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_after_path(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFile`.
    ///
    /// <p>Returns the base-64 encoded contents of a specified file and its metadata.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_file_input::Builder,
    }
    impl<C, M, R> GetFile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFileInputOperationOutputAlias,
                crate::output::GetFileOutput,
                crate::error::GetFileError,
                crate::input::GetFileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the file.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the file.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The fully quaified reference that identifies the commit that contains the file. For
        /// example, you can specify a full commit ID, a tag, a branch name, or a reference such as
        /// refs/heads/master. If none is provided, the head commit is used.</p>
        pub fn commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_specifier(inp);
            self
        }
        /// <p>The fully quaified reference that identifies the commit that contains the file. For
        /// example, you can specify a full commit ID, a tag, a branch name, or a reference such as
        /// refs/heads/master. If none is provided, the head commit is used.</p>
        pub fn set_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_specifier(input);
            self
        }
        /// <p>The fully qualified path to the file, including the full name and extension of the
        /// file. For example, /examples/file.md is the fully qualified path to a file named file.md
        /// in a folder named examples.</p>
        pub fn file_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(inp);
            self
        }
        /// <p>The fully qualified path to the file, including the full name and extension of the
        /// file. For example, /examples/file.md is the fully qualified path to a file named file.md
        /// in a folder named examples.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFolder`.
    ///
    /// <p>Returns the contents of a specified folder in a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFolder<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_folder_input::Builder,
    }
    impl<C, M, R> GetFolder<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFolder`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFolderOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFolderError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFolderInputOperationOutputAlias,
                crate::output::GetFolderOutput,
                crate::error::GetFolderError,
                crate::input::GetFolderInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>A fully qualified reference used to identify a commit that contains the version of the
        /// folder's content to return. A fully qualified reference can be a commit ID, branch name,
        /// tag, or reference such as HEAD. If no specifier is provided, the folder content is
        /// returned as it exists in the HEAD commit.</p>
        pub fn commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_specifier(inp);
            self
        }
        /// <p>A fully qualified reference used to identify a commit that contains the version of the
        /// folder's content to return. A fully qualified reference can be a commit ID, branch name,
        /// tag, or reference such as HEAD. If no specifier is provided, the folder content is
        /// returned as it exists in the HEAD commit.</p>
        pub fn set_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_specifier(input);
            self
        }
        /// <p>The fully qualified path to the folder whose contents are returned, including the
        /// folder name. For example, /examples is a fully-qualified path to a folder named examples
        /// that was created off of the root directory (/) of a repository. </p>
        pub fn folder_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.folder_path(inp);
            self
        }
        /// <p>The fully qualified path to the folder whose contents are returned, including the
        /// folder name. For example, /examples is a fully-qualified path to a folder named examples
        /// that was created off of the root directory (/) of a repository. </p>
        pub fn set_folder_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_folder_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMergeCommit`.
    ///
    /// <p>Returns information about a specified merge commit.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMergeCommit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_merge_commit_input::Builder,
    }
    impl<C, M, R> GetMergeCommit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMergeCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMergeCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMergeCommitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMergeCommitInputOperationOutputAlias,
                crate::output::GetMergeCommitOutput,
                crate::error::GetMergeCommitError,
                crate::input::GetMergeCommitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the merge commit about which you want to get information.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMergeConflicts`.
    ///
    /// <p>Returns information about merge conflicts between the before and after commit IDs for a pull request in a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMergeConflicts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_merge_conflicts_input::Builder,
    }
    impl<C, M, R> GetMergeConflicts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMergeConflicts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMergeConflictsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMergeConflictsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMergeConflictsInputOperationOutputAlias,
                crate::output::GetMergeConflictsOutput,
                crate::error::GetMergeConflictsError,
                crate::input::GetMergeConflictsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.  </p>
        pub fn merge_option(mut self, inp: crate::model::MergeOptionTypeEnum) -> Self {
            self.inner = self.inner.merge_option(inp);
            self
        }
        /// <p>The merge option or strategy you want to use to merge the code.  </p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_merge_option(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn max_conflict_files(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_conflict_files(inp);
            self
        }
        /// <p>The maximum number of files to include in the output.</p>
        pub fn set_max_conflict_files(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_conflict_files(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMergeOptions`.
    ///
    /// <p>Returns information about the merge options available for merging two specified
    /// branches. For details about why a merge option is not available, use GetMergeConflicts
    /// or DescribeMergeConflicts.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMergeOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_merge_options_input::Builder,
    }
    impl<C, M, R> GetMergeOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMergeOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMergeOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMergeOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMergeOptionsInputOperationOutputAlias,
                crate::output::GetMergeOptionsOutput,
                crate::error::GetMergeOptionsError,
                crate::input::GetMergeOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the commits about which you want to get merge options.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPullRequest`.
    ///
    /// <p>Gets information about a pull request in a specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPullRequest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_pull_request_input::Builder,
    }
    impl<C, M, R> GetPullRequest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPullRequestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPullRequestInputOperationOutputAlias,
                crate::output::GetPullRequestOutput,
                crate::error::GetPullRequestError,
                crate::input::GetPullRequestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPullRequestApprovalStates`.
    ///
    /// <p>Gets information about the approval states for a specified pull request. Approval states only apply to pull requests that have one or more
    /// approval rules applied to them.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPullRequestApprovalStates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_pull_request_approval_states_input::Builder,
    }
    impl<C, M, R> GetPullRequestApprovalStates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPullRequestApprovalStates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPullRequestApprovalStatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPullRequestApprovalStatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPullRequestApprovalStatesInputOperationOutputAlias,
                crate::output::GetPullRequestApprovalStatesOutput,
                crate::error::GetPullRequestApprovalStatesError,
                crate::input::GetPullRequestApprovalStatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID for the pull request.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID for the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID for the pull request revision.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>The system-generated ID for the pull request revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPullRequestOverrideState`.
    ///
    /// <p>Returns information about whether approval rules have been set aside (overridden) for a
    /// pull request, and if so, the Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetPullRequestOverrideState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_pull_request_override_state_input::Builder,
    }
    impl<C, M, R> GetPullRequestOverrideState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPullRequestOverrideState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPullRequestOverrideStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPullRequestOverrideStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPullRequestOverrideStateInputOperationOutputAlias,
                crate::output::GetPullRequestOverrideStateOutput,
                crate::error::GetPullRequestOverrideStateError,
                crate::input::GetPullRequestOverrideStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The ID of the pull request for which you want to get information about whether approval rules have been set aside (overridden).</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID of the revision for the pull request. To retrieve the most
        /// recent revision ID, use
        /// <a>GetPullRequest</a>.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>The system-generated ID of the revision for the pull request. To retrieve the most
        /// recent revision ID, use
        /// <a>GetPullRequest</a>.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepository`.
    ///
    /// <p>Returns information about a repository.</p>
    ///
    /// <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid
    /// Unicode characters. Applications that do not HTML-encode the description and display
    /// it in a webpage can expose users to potentially malicious code. Make sure that you
    /// HTML-encode the description field in any application that uses this API to display
    /// the repository description on a webpage.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_input::Builder,
    }
    impl<C, M, R> GetRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryInputOperationOutputAlias,
                crate::output::GetRepositoryOutput,
                crate::error::GetRepositoryError,
                crate::input::GetRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to get information about.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to get information about.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryTriggers`.
    ///
    /// <p>Gets information about triggers configured for a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRepositoryTriggers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_triggers_input::Builder,
    }
    impl<C, M, R> GetRepositoryTriggers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryTriggersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryTriggersInputOperationOutputAlias,
                crate::output::GetRepositoryTriggersOutput,
                crate::error::GetRepositoryTriggersError,
                crate::input::GetRepositoryTriggersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository for which the trigger is configured.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository for which the trigger is configured.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApprovalRuleTemplates`.
    ///
    /// <p>Lists all approval rule templates in the specified AWS Region in your AWS account. If
    /// an AWS Region is not specified, the AWS Region where you are signed in is used.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApprovalRuleTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_approval_rule_templates_input::Builder,
    }
    impl<C, M, R> ListApprovalRuleTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApprovalRuleTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApprovalRuleTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApprovalRuleTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApprovalRuleTemplatesInputOperationOutputAlias,
                crate::output::ListApprovalRuleTemplatesOutput,
                crate::error::ListApprovalRuleTemplatesError,
                crate::input::ListApprovalRuleTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAssociatedApprovalRuleTemplatesForRepository`.
    ///
    /// <p>Lists all approval rule templates that are associated with a specified repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociatedApprovalRuleTemplatesForRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associated_approval_rule_templates_for_repository_input::Builder,
    }
    impl<C, M, R> ListAssociatedApprovalRuleTemplatesForRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociatedApprovalRuleTemplatesForRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput, aws_smithy_http::result::SdkError<crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInputOperationOutputAlias,
                                    crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput,
                                    crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryError,
                                    crate::input::ListAssociatedApprovalRuleTemplatesForRepositoryInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository for which you want to list all associated approval rule templates.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBranches`.
    ///
    /// <p>Gets information about one or more branches in a repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBranches<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_branches_input::Builder,
    }
    impl<C, M, R> ListBranches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBranches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBranchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBranchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBranchesInputOperationOutputAlias,
                crate::output::ListBranchesOutput,
                crate::error::ListBranchesError,
                crate::input::ListBranchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository that contains the branches.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository that contains the branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPullRequests`.
    ///
    /// <p>Returns a list of pull requests for a specified repository. The return list can be refined by pull request
    /// status or pull request author ARN.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPullRequests<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_pull_requests_input::Builder,
    }
    impl<C, M, R> ListPullRequests<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPullRequests`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPullRequestsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPullRequestsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPullRequestsInputOperationOutputAlias,
                crate::output::ListPullRequestsOutput,
                crate::error::ListPullRequestsError,
                crate::input::ListPullRequestsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository for which you want to list pull requests.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository for which you want to list pull requests.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results
        /// to pull requests created by that user.</p>
        pub fn author_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_arn(inp);
            self
        }
        /// <p>Optional. The Amazon Resource Name (ARN) of the user who created the pull request. If used, this filters the results
        /// to pull requests created by that user.</p>
        pub fn set_author_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_arn(input);
            self
        }
        /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
        pub fn pull_request_status(mut self, inp: crate::model::PullRequestStatusEnum) -> Self {
            self.inner = self.inner.pull_request_status(inp);
            self
        }
        /// <p>Optional. The status of the pull request. If used, this refines the results to the pull requests that match the specified status.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_status(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositories`.
    ///
    /// <p>Gets information about one or more repositories.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repositories_input::Builder,
    }
    impl<C, M, R> ListRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoriesInputOperationOutputAlias,
                crate::output::ListRepositoriesOutput,
                crate::error::ListRepositoriesError,
                crate::input::ListRepositoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An enumeration token that allows the operation to batch the results of the operation.
        /// Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit,
        /// another page of 1,000 records is retrieved.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results of the operation.
        /// Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit,
        /// another page of 1,000 records is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria used to sort the results of a list repositories operation.</p>
        pub fn sort_by(mut self, inp: crate::model::SortByEnum) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The criteria used to sort the results of a list repositories operation.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<crate::model::SortByEnum>) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The order in which to sort the results of a list repositories operation.</p>
        pub fn order(mut self, inp: crate::model::OrderEnum) -> Self {
            self.inner = self.inner.order(inp);
            self
        }
        /// <p>The order in which to sort the results of a list repositories operation.</p>
        pub fn set_order(mut self, input: std::option::Option<crate::model::OrderEnum>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositoriesForApprovalRuleTemplate`.
    ///
    /// <p>Lists all repositories associated with the specified approval rule template.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRepositoriesForApprovalRuleTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repositories_for_approval_rule_template_input::Builder,
    }
    impl<C, M, R> ListRepositoriesForApprovalRuleTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositoriesForApprovalRuleTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesForApprovalRuleTemplateOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListRepositoriesForApprovalRuleTemplateError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoriesForApprovalRuleTemplateInputOperationOutputAlias,
                crate::output::ListRepositoriesForApprovalRuleTemplateOutput,
                crate::error::ListRepositoriesForApprovalRuleTemplateError,
                crate::input::ListRepositoriesForApprovalRuleTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the approval rule template for which you want to list repositories that are associated with that template.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>A non-zero, non-negative integer used to limit the number of returned results.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS
    /// CodeCommit. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the<i> AWS CodeCommit User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information
        /// about tags, if any.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource for which you want to get information
        /// about tags, if any.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An enumeration token that, when provided in a request, returns the next batch of the
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeBranchesByFastForward`.
    ///
    /// <p>Merges two branches using the fast-forward merge strategy.</p>
    #[derive(std::fmt::Debug)]
    pub struct MergeBranchesByFastForward<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_branches_by_fast_forward_input::Builder,
    }
    impl<C, M, R> MergeBranchesByFastForward<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergeBranchesByFastForward`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeBranchesByFastForwardOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeBranchesByFastForwardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergeBranchesByFastForwardInputOperationOutputAlias,
                crate::output::MergeBranchesByFastForwardOutput,
                crate::error::MergeBranchesByFastForwardError,
                crate::input::MergeBranchesByFastForwardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch where the merge is applied.</p>
        pub fn target_branch(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_branch(inp);
            self
        }
        /// <p>The branch where the merge is applied.</p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_branch(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeBranchesBySquash`.
    ///
    /// <p>Merges two branches using the squash merge strategy.</p>
    #[derive(std::fmt::Debug)]
    pub struct MergeBranchesBySquash<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_branches_by_squash_input::Builder,
    }
    impl<C, M, R> MergeBranchesBySquash<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergeBranchesBySquash`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeBranchesBySquashOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeBranchesBySquashError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergeBranchesBySquashInputOperationOutputAlias,
                crate::output::MergeBranchesBySquashOutput,
                crate::error::MergeBranchesBySquashError,
                crate::input::MergeBranchesBySquashInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn target_branch(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_branch(inp);
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_branch(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn author_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(inp);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message for the merge.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>The commit message for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If this is specified as true, a .gitkeep file is
        /// created for empty folders. The default is false.</p>
        pub fn keep_empty_folders(mut self, inp: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(inp);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If this is specified as true, a .gitkeep file is
        /// created for empty folders. The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, inp: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(inp);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeBranchesByThreeWay`.
    ///
    /// <p>Merges two specified branches using the three-way merge strategy.</p>
    #[derive(std::fmt::Debug)]
    pub struct MergeBranchesByThreeWay<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_branches_by_three_way_input::Builder,
    }
    impl<C, M, R> MergeBranchesByThreeWay<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergeBranchesByThreeWay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeBranchesByThreeWayOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeBranchesByThreeWayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergeBranchesByThreeWayInputOperationOutputAlias,
                crate::output::MergeBranchesByThreeWayOutput,
                crate::error::MergeBranchesByThreeWayError,
                crate::input::MergeBranchesByThreeWayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to merge two branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn source_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_source_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_specifier(input);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn destination_commit_specifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_commit_specifier(inp);
            self
        }
        /// <p>The branch, tag, HEAD, or other fully qualified reference used to identify a commit
        /// (for example, a branch name or a full commit ID).</p>
        pub fn set_destination_commit_specifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_commit_specifier(input);
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn target_branch(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_branch(inp);
            self
        }
        /// <p>The branch where the merge is applied. </p>
        pub fn set_target_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_branch(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn author_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(inp);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a .gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn keep_empty_folders(mut self, inp: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(inp);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a .gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, inp: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(inp);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergePullRequestByFastForward`.
    ///
    /// <p>Attempts to merge the source commit of a pull request into the specified destination
    /// branch for that pull request at the specified commit using the fast-forward merge strategy. If the merge is successful, it closes the pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct MergePullRequestByFastForward<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_pull_request_by_fast_forward_input::Builder,
    }
    impl<C, M, R> MergePullRequestByFastForward<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergePullRequestByFastForward`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergePullRequestByFastForwardOutput,
            aws_smithy_http::result::SdkError<crate::error::MergePullRequestByFastForwardError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergePullRequestByFastForwardInputOperationOutputAlias,
                crate::output::MergePullRequestByFastForwardOutput,
                crate::error::MergePullRequestByFastForwardError,
                crate::input::MergePullRequestByFastForwardInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an
        /// exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an
        /// exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergePullRequestBySquash`.
    ///
    /// <p>Attempts to merge the source commit of a pull request into the specified destination
    /// branch for that pull request at the specified commit using the squash merge strategy. If the merge is successful, it closes the pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct MergePullRequestBySquash<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_pull_request_by_squash_input::Builder,
    }
    impl<C, M, R> MergePullRequestBySquash<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergePullRequestBySquash`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergePullRequestBySquashOutput,
            aws_smithy_http::result::SdkError<crate::error::MergePullRequestBySquashError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergePullRequestBySquashInputOperationOutputAlias,
                crate::output::MergePullRequestBySquashOutput,
                crate::error::MergePullRequestBySquashError,
                crate::input::MergePullRequestBySquashInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an
        /// exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an
        /// exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_id(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn author_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(inp);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a .gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn keep_empty_folders(mut self, inp: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(inp);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a .gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, inp: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(inp);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergePullRequestByThreeWay`.
    ///
    /// <p>Attempts to merge the source commit of a pull request into the specified destination
    /// branch for that pull request at the specified commit using the three-way merge strategy. If the merge is successful, it closes the pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct MergePullRequestByThreeWay<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_pull_request_by_three_way_input::Builder,
    }
    impl<C, M, R> MergePullRequestByThreeWay<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergePullRequestByThreeWay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergePullRequestByThreeWayOutput,
            aws_smithy_http::result::SdkError<crate::error::MergePullRequestByThreeWayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergePullRequestByThreeWayInputOperationOutputAlias,
                crate::output::MergePullRequestByThreeWayOutput,
                crate::error::MergePullRequestByThreeWayError,
                crate::input::MergePullRequestByThreeWayInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an
        /// exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn source_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an
        /// exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_commit_id(input);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn conflict_detail_level(
            mut self,
            inp: crate::model::ConflictDetailLevelTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_detail_level(inp);
            self
        }
        /// <p>The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used,
        /// which returns a not-mergeable result if the same file has differences in both branches.
        /// If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in
        /// both branches has differences on the same line.</p>
        pub fn set_conflict_detail_level(
            mut self,
            input: std::option::Option<crate::model::ConflictDetailLevelTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_detail_level(input);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn conflict_resolution_strategy(
            mut self,
            inp: crate::model::ConflictResolutionStrategyTypeEnum,
        ) -> Self {
            self.inner = self.inner.conflict_resolution_strategy(inp);
            self
        }
        /// <p>Specifies which branch to use when resolving conflicts, or whether to attempt
        /// automatically merging two versions of a file. The default is NONE, which requires any
        /// conflicts to be resolved manually before the merge operation is successful.</p>
        pub fn set_conflict_resolution_strategy(
            mut self,
            input: std::option::Option<crate::model::ConflictResolutionStrategyTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution_strategy(input);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>The commit message to include in the commit information for the merge.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn author_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.author_name(inp);
            self
        }
        /// <p>The name of the author who created the commit. This information is used as both the
        /// author and committer for the commit.</p>
        pub fn set_author_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_author_name(input);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>The email address of the person merging the branches. This information is used in the
        /// commit information for the merge.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a .gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn keep_empty_folders(mut self, inp: bool) -> Self {
            self.inner = self.inner.keep_empty_folders(inp);
            self
        }
        /// <p>If the commit contains deletions, whether to keep a folder or folder structure if the
        /// changes leave the folders empty. If true, a .gitkeep file is created for empty folders.
        /// The default is false.</p>
        pub fn set_keep_empty_folders(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_keep_empty_folders(input);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn conflict_resolution(mut self, inp: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(inp);
            self
        }
        /// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
        /// resolving conflicts during a merge.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `OverridePullRequestApprovalRules`.
    ///
    /// <p>Sets aside (overrides) all approval rule requirements for a specified pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct OverridePullRequestApprovalRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::override_pull_request_approval_rules_input::Builder,
    }
    impl<C, M, R> OverridePullRequestApprovalRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `OverridePullRequestApprovalRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::OverridePullRequestApprovalRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::OverridePullRequestApprovalRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::OverridePullRequestApprovalRulesInputOperationOutputAlias,
                crate::output::OverridePullRequestApprovalRulesOutput,
                crate::error::OverridePullRequestApprovalRulesError,
                crate::input::OverridePullRequestApprovalRulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request for which you want to override all
        /// approval rule requirements. To get this information, use
        /// <a>GetPullRequest</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request for which you want to override all
        /// approval rule requirements. To get this information, use
        /// <a>GetPullRequest</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request.
        /// To get the revision ID, use GetPullRequest.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>The system-generated ID of the most recent revision of the pull request. You cannot override approval rules for anything but the most recent revision of a pull request.
        /// To get the revision ID, use GetPullRequest.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply
        /// approval rule requirements (REVOKE). REVOKE status is not stored.</p>
        pub fn override_status(mut self, inp: crate::model::OverrideStatus) -> Self {
            self.inner = self.inner.override_status(inp);
            self
        }
        /// <p>Whether you want to set aside approval rule requirements for the pull request (OVERRIDE) or revoke a previous override and apply
        /// approval rule requirements (REVOKE). REVOKE status is not stored.</p>
        pub fn set_override_status(
            mut self,
            input: std::option::Option<crate::model::OverrideStatus>,
        ) -> Self {
            self.inner = self.inner.set_override_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostCommentForComparedCommit`.
    ///
    /// <p>Posts a comment on the comparison between two commits.</p>
    #[derive(std::fmt::Debug)]
    pub struct PostCommentForComparedCommit<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::post_comment_for_compared_commit_input::Builder,
    }
    impl<C, M, R> PostCommentForComparedCommit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PostCommentForComparedCommit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostCommentForComparedCommitOutput,
            aws_smithy_http::result::SdkError<crate::error::PostCommentForComparedCommitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PostCommentForComparedCommitInputOperationOutputAlias,
                crate::output::PostCommentForComparedCommitOutput,
                crate::error::PostCommentForComparedCommitError,
                crate::input::PostCommentForComparedCommitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to post a comment on the comparison between commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before
        /// commit. Required for commenting on any commit unless that commit is the initial
        /// commit.</p>
        pub fn before_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(inp);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the before
        /// commit. Required for commenting on any commit unless that commit is the initial
        /// commit.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after
        /// commit.</p>
        pub fn after_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(inp);
            self
        }
        /// <p>To establish the directionality of the comparison, the full commit ID of the after
        /// commit.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>The location of the comparison where you want to comment.</p>
        pub fn location(mut self, inp: crate::model::Location) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The location of the comparison where you want to comment.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The content of the comment you want to make.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the comment you want to make.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostCommentForPullRequest`.
    ///
    /// <p>Posts a comment on a pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct PostCommentForPullRequest<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::post_comment_for_pull_request_input::Builder,
    }
    impl<C, M, R> PostCommentForPullRequest<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PostCommentForPullRequest`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostCommentForPullRequestOutput,
            aws_smithy_http::result::SdkError<crate::error::PostCommentForPullRequestError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PostCommentForPullRequestInputOperationOutputAlias,
                crate::output::PostCommentForPullRequestOutput,
                crate::error::PostCommentForPullRequestError,
                crate::input::PostCommentForPullRequestInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the repository where you want to post a comment on a pull request.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to post a comment on a pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn before_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.before_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was created.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_before_commit_id(input);
            self
        }
        /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
        pub fn after_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.after_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the commit in the source branch that is the current tip of the branch for the pull request when you post the comment.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_after_commit_id(input);
            self
        }
        /// <p>The location of the change where you want to post your comment. If no location is
        /// provided, the comment is posted as a general comment on the pull request difference
        /// between the before commit ID and the after commit ID.</p>
        pub fn location(mut self, inp: crate::model::Location) -> Self {
            self.inner = self.inner.location(inp);
            self
        }
        /// <p>The location of the change where you want to post your comment. If no location is
        /// provided, the comment is posted as a general comment on the pull request difference
        /// between the before commit ID and the after commit ID.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.inner = self.inner.set_location(input);
            self
        }
        /// <p>The content of your comment on the change.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of your comment on the change.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PostCommentReply`.
    ///
    /// <p>Posts a comment in reply to an existing comment on a comparison between commits or a pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct PostCommentReply<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::post_comment_reply_input::Builder,
    }
    impl<C, M, R> PostCommentReply<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PostCommentReply`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PostCommentReplyOutput,
            aws_smithy_http::result::SdkError<crate::error::PostCommentReplyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PostCommentReplyInputOperationOutputAlias,
                crate::output::PostCommentReplyOutput,
                crate::error::PostCommentReplyError,
                crate::input::PostCommentReplyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn in_reply_to(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.in_reply_to(inp);
            self
        }
        /// <p>The system-generated ID of the comment to which you want to reply. To get this ID, use <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn set_in_reply_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_in_reply_to(input);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The contents of your reply to a comment.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The contents of your reply to a comment.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutCommentReaction`.
    ///
    /// <p>Adds or updates a reaction to a specified comment for the user whose identity is used to make the request. You can only add or
    /// update a reaction for yourself. You cannot add, modify, or delete a reaction for another user.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutCommentReaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_comment_reaction_input::Builder,
    }
    impl<C, M, R> PutCommentReaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutCommentReaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutCommentReactionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutCommentReactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutCommentReactionInputOperationOutputAlias,
                crate::output::PutCommentReactionOutput,
                crate::error::PutCommentReactionError,
                crate::input::PutCommentReactionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the comment to which you want to add or update a reaction.</p>
        pub fn comment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(inp);
            self
        }
        /// <p>The ID of the comment to which you want to add or update a reaction.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
        /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none.
        /// For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
        pub fn reaction_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reaction_value(inp);
            self
        }
        /// <p>The emoji reaction you want to add or update. To remove a reaction, provide a value of blank or null. You can also provide the value of none.
        /// For information about emoji reaction values supported in AWS CodeCommit, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-commit-comment.html#emoji-reaction-table">AWS CodeCommit User Guide</a>.</p>
        pub fn set_reaction_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reaction_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFile`.
    ///
    /// <p>Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutFile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_file_input::Builder,
    }
    impl<C, M, R> PutFile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFileOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFileInputOperationOutputAlias,
                crate::output::PutFileOutput,
                crate::error::PutFileError,
                crate::input::PutFileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to add or update the file.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to add or update the file.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch where you want to add or update the file. If this is an empty
        /// repository, this branch is created.</p>
        pub fn branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_name(inp);
            self
        }
        /// <p>The name of the branch where you want to add or update the file. If this is an empty
        /// repository, this branch is created.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_branch_name(input);
            self
        }
        /// <p>The content of the file, in binary object format. </p>
        pub fn file_content(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.file_content(inp);
            self
        }
        /// <p>The content of the file, in binary object format. </p>
        pub fn set_file_content(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_file_content(input);
            self
        }
        /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p>
        /// <note>
        /// <p>If the path does not currently exist in the repository, the path is created as part of adding
        /// the file.</p>
        /// </note>
        pub fn file_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_path(inp);
            self
        }
        /// <p>The name of the file you want to add or update, including the relative path to the file in the repository.</p>
        /// <note>
        /// <p>If the path does not currently exist in the repository, the path is created as part of adding
        /// the file.</p>
        /// </note>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_path(input);
            self
        }
        /// <p>The file mode permissions of the blob. Valid file mode permissions are listed
        /// here.</p>
        pub fn file_mode(mut self, inp: crate::model::FileModeTypeEnum) -> Self {
            self.inner = self.inner.file_mode(inp);
            self
        }
        /// <p>The file mode permissions of the blob. Valid file mode permissions are listed
        /// here.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.inner = self.inner.set_file_mode(input);
            self
        }
        /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository,
        /// no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
        /// <p>The commit ID must match the ID of the head commit at the time of the operation.
        /// Otherwise, an error occurs, and the file is not added or updated.</p>
        pub fn parent_commit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_commit_id(inp);
            self
        }
        /// <p>The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository,
        /// no commit ID is required. If this is not an empty repository, a commit ID is required. </p>
        /// <p>The commit ID must match the ID of the head commit at the time of the operation.
        /// Otherwise, an error occurs, and the file is not added or updated.</p>
        pub fn set_parent_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_commit_id(input);
            self
        }
        /// <p>A message about why this file was added or updated. Although it is optional, a message
        /// makes the commit history for your repository more useful.</p>
        pub fn commit_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.commit_message(inp);
            self
        }
        /// <p>A message about why this file was added or updated. Although it is optional, a message
        /// makes the commit history for your repository more useful.</p>
        pub fn set_commit_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_commit_message(input);
            self
        }
        /// <p>The name of the person adding or updating the file. Although it is optional, a name
        /// makes the commit history for your repository more useful.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the person adding or updating the file. Although it is optional, a name
        /// makes the commit history for your repository more useful.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An email address for the person adding or updating the file.</p>
        pub fn email(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email(inp);
            self
        }
        /// <p>An email address for the person adding or updating the file.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_email(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRepositoryTriggers`.
    ///
    /// <p>Replaces all triggers for a repository. Used to create or delete triggers.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutRepositoryTriggers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_repository_triggers_input::Builder,
    }
    impl<C, M, R> PutRepositoryTriggers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRepositoryTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRepositoryTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRepositoryTriggersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRepositoryTriggersInputOperationOutputAlias,
                crate::output::PutRepositoryTriggersOutput,
                crate::error::PutRepositoryTriggersError,
                crate::input::PutRepositoryTriggersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository where you want to create or update the trigger.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository where you want to create or update the trigger.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn triggers(mut self, inp: impl Into<crate::model::RepositoryTrigger>) -> Self {
            self.inner = self.inner.triggers(inp);
            self
        }
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for a resource in AWS CodeCommit. For a list of valid resources
    /// in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add or update tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pair to use when tagging this repository.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The key-value pair to use when tagging this repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestRepositoryTriggers`.
    ///
    /// <p>Tests the functionality of repository triggers by sending information to the trigger
    /// target. If real data is available in the repository, the test sends data from the last
    /// commit. If no data is available, sample data is generated.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestRepositoryTriggers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_repository_triggers_input::Builder,
    }
    impl<C, M, R> TestRepositoryTriggers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestRepositoryTriggers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestRepositoryTriggersOutput,
            aws_smithy_http::result::SdkError<crate::error::TestRepositoryTriggersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestRepositoryTriggersInputOperationOutputAlias,
                crate::output::TestRepositoryTriggersOutput,
                crate::error::TestRepositoryTriggersError,
                crate::input::TestRepositoryTriggersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository in which to test the triggers.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository in which to test the triggers.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The list of triggers to test.</p>
        pub fn triggers(mut self, inp: impl Into<crate::model::RepositoryTrigger>) -> Self {
            self.inner = self.inner.triggers(inp);
            self
        }
        /// <p>The list of triggers to test.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
        ) -> Self {
            self.inner = self.inner.set_triggers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags for a resource in AWS CodeCommit. For a list of valid resources in AWS
    /// CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the <i>AWS CodeCommit User
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to remove tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApprovalRuleTemplateContent`.
    ///
    /// <p>Updates the content of an approval rule template. You can change the number of
    /// required approvals, the membership of the approval rule, and whether an approval pool is
    /// defined.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApprovalRuleTemplateContent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_approval_rule_template_content_input::Builder,
    }
    impl<C, M, R> UpdateApprovalRuleTemplateContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApprovalRuleTemplateContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApprovalRuleTemplateContentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApprovalRuleTemplateContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApprovalRuleTemplateContentInputOperationOutputAlias,
                crate::output::UpdateApprovalRuleTemplateContentOutput,
                crate::error::UpdateApprovalRuleTemplateContentError,
                crate::input::UpdateApprovalRuleTemplateContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the approval rule template where you want to update the content of the rule. </p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The content that replaces the existing content of the rule. Content statements must be
        /// complete. You cannot provide only the changes.</p>
        pub fn new_rule_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_rule_content(inp);
            self
        }
        /// <p>The content that replaces the existing content of the rule. Content statements must be
        /// complete. You cannot provide only the changes.</p>
        pub fn set_new_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_rule_content(input);
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this
        /// information by using
        /// <a>GetPullRequest</a>.</p>
        pub fn existing_rule_content_sha256(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.existing_rule_content_sha256(inp);
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this
        /// information by using
        /// <a>GetPullRequest</a>.</p>
        pub fn set_existing_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_existing_rule_content_sha256(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApprovalRuleTemplateDescription`.
    ///
    /// <p>Updates the description for a specified approval rule template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApprovalRuleTemplateDescription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_approval_rule_template_description_input::Builder,
    }
    impl<C, M, R> UpdateApprovalRuleTemplateDescription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApprovalRuleTemplateDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApprovalRuleTemplateDescriptionOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateApprovalRuleTemplateDescriptionError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApprovalRuleTemplateDescriptionInputOperationOutputAlias,
                crate::output::UpdateApprovalRuleTemplateDescriptionOutput,
                crate::error::UpdateApprovalRuleTemplateDescriptionError,
                crate::input::UpdateApprovalRuleTemplateDescriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the template for which you want to update the description.</p>
        pub fn approval_rule_template_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_template_name(inp);
            self
        }
        /// <p>The name of the template for which you want to update the description.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_name(input);
            self
        }
        /// <p>The updated description of the approval rule template.</p>
        pub fn approval_rule_template_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.approval_rule_template_description(inp);
            self
        }
        /// <p>The updated description of the approval rule template.</p>
        pub fn set_approval_rule_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_template_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApprovalRuleTemplateName`.
    ///
    /// <p>Updates the name of a specified approval rule template.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateApprovalRuleTemplateName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_approval_rule_template_name_input::Builder,
    }
    impl<C, M, R> UpdateApprovalRuleTemplateName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApprovalRuleTemplateName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApprovalRuleTemplateNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApprovalRuleTemplateNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApprovalRuleTemplateNameInputOperationOutputAlias,
                crate::output::UpdateApprovalRuleTemplateNameOutput,
                crate::error::UpdateApprovalRuleTemplateNameError,
                crate::input::UpdateApprovalRuleTemplateNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current name of the approval rule template.</p>
        pub fn old_approval_rule_template_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.old_approval_rule_template_name(inp);
            self
        }
        /// <p>The current name of the approval rule template.</p>
        pub fn set_old_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_old_approval_rule_template_name(input);
            self
        }
        /// <p>The new name you want to apply to the approval rule template.</p>
        pub fn new_approval_rule_template_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.new_approval_rule_template_name(inp);
            self
        }
        /// <p>The new name you want to apply to the approval rule template.</p>
        pub fn set_new_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_approval_rule_template_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateComment`.
    ///
    /// <p>Replaces the contents of a comment.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateComment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_comment_input::Builder,
    }
    impl<C, M, R> UpdateComment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateComment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCommentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCommentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCommentInputOperationOutputAlias,
                crate::output::UpdateCommentOutput,
                crate::error::UpdateCommentError,
                crate::input::UpdateCommentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the comment you want to update. To get this ID, use <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn comment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.comment_id(inp);
            self
        }
        /// <p>The system-generated ID of the comment you want to update. To get this ID, use <a>GetCommentsForComparedCommit</a>
        /// or <a>GetCommentsForPullRequest</a>.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_comment_id(input);
            self
        }
        /// <p>The updated content to replace the existing content of the comment.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The updated content to replace the existing content of the comment.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDefaultBranch`.
    ///
    /// <p>Sets or changes the default branch name for the specified repository.</p>
    /// <note>
    /// <p>If you use this operation to change the default branch name to the current default branch name, a success message is returned even though the default branch did not change.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDefaultBranch<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_default_branch_input::Builder,
    }
    impl<C, M, R> UpdateDefaultBranch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDefaultBranch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDefaultBranchOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDefaultBranchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDefaultBranchInputOperationOutputAlias,
                crate::output::UpdateDefaultBranchOutput,
                crate::error::UpdateDefaultBranchError,
                crate::input::UpdateDefaultBranchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to set or change the default branch for.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to set or change the default branch for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The name of the branch to set as the default.</p>
        pub fn default_branch_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_branch_name(inp);
            self
        }
        /// <p>The name of the branch to set as the default.</p>
        pub fn set_default_branch_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_branch_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestApprovalRuleContent`.
    ///
    /// <p>Updates the structure of an approval rule created specifically for a pull request. For example, you can change the number of required approvers and
    /// the approval pool for approvers. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePullRequestApprovalRuleContent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_pull_request_approval_rule_content_input::Builder,
    }
    impl<C, M, R> UpdatePullRequestApprovalRuleContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePullRequestApprovalRuleContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestApprovalRuleContentOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdatePullRequestApprovalRuleContentError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePullRequestApprovalRuleContentInputOperationOutputAlias,
                crate::output::UpdatePullRequestApprovalRuleContentOutput,
                crate::error::UpdatePullRequestApprovalRuleContentError,
                crate::input::UpdatePullRequestApprovalRuleContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The name of the approval rule you want to update.</p>
        pub fn approval_rule_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.approval_rule_name(inp);
            self
        }
        /// <p>The name of the approval rule you want to update.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_approval_rule_name(input);
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this
        /// information by using
        /// <a>GetPullRequest</a>.</p>
        pub fn existing_rule_content_sha256(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.existing_rule_content_sha256(inp);
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule. You can retrieve this
        /// information by using
        /// <a>GetPullRequest</a>.</p>
        pub fn set_existing_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_existing_rule_content_sha256(input);
            self
        }
        /// <p>The updated content for the approval rule.</p>
        /// <note>
        /// <p>When you update the content of the approval rule, you can specify approvers in an
        /// approval pool in one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>CodeCommitApprovers</b>: This option only
        /// requires an AWS account and a resource. It can be used for both IAM users
        /// and federated access users whose name matches the provided resource name.
        /// This is a very powerful option that offers a great deal of flexibility. For
        /// example, if you specify the AWS account <i>123456789012</i>
        /// and <i>Mary_Major</i>, all of the following are counted as
        /// approvals coming from that user:</p>
        /// <ul>
        /// <li>
        /// <p>An IAM user in the account
        /// (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p>
        /// </li>
        /// <li>
        /// <p>A federated user identified in IAM as Mary_Major
        /// (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p>
        /// </li>
        /// </ul>
        /// <p>This option does not recognize an active session of someone assuming the
        /// role of CodeCommitReview with a role session name of
        /// <i>Mary_Major</i>
        /// (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>)
        /// unless you include a wildcard (*Mary_Major).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Fully qualified ARN</b>: This option allows
        /// you to specify the fully qualified Amazon Resource Name (ARN) of the IAM
        /// user or role. </p>
        /// </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        ///
        /// </note>
        pub fn new_rule_content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_rule_content(inp);
            self
        }
        /// <p>The updated content for the approval rule.</p>
        /// <note>
        /// <p>When you update the content of the approval rule, you can specify approvers in an
        /// approval pool in one of two ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>CodeCommitApprovers</b>: This option only
        /// requires an AWS account and a resource. It can be used for both IAM users
        /// and federated access users whose name matches the provided resource name.
        /// This is a very powerful option that offers a great deal of flexibility. For
        /// example, if you specify the AWS account <i>123456789012</i>
        /// and <i>Mary_Major</i>, all of the following are counted as
        /// approvals coming from that user:</p>
        /// <ul>
        /// <li>
        /// <p>An IAM user in the account
        /// (arn:aws:iam::<i>123456789012</i>:user/<i>Mary_Major</i>)</p>
        /// </li>
        /// <li>
        /// <p>A federated user identified in IAM as Mary_Major
        /// (arn:aws:sts::<i>123456789012</i>:federated-user/<i>Mary_Major</i>)</p>
        /// </li>
        /// </ul>
        /// <p>This option does not recognize an active session of someone assuming the
        /// role of CodeCommitReview with a role session name of
        /// <i>Mary_Major</i>
        /// (arn:aws:sts::<i>123456789012</i>:assumed-role/CodeCommitReview/<i>Mary_Major</i>)
        /// unless you include a wildcard (*Mary_Major).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Fully qualified ARN</b>: This option allows
        /// you to specify the fully qualified Amazon Resource Name (ARN) of the IAM
        /// user or role. </p>
        /// </li>
        /// </ul>
        /// <p>For more information about IAM ARNs, wildcards, and formats, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
        /// Identifiers</a> in the <i>IAM User Guide</i>.</p>
        ///
        /// </note>
        pub fn set_new_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_rule_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestApprovalState`.
    ///
    /// <p>Updates the state of a user's approval on a pull request. The user is derived from the signed-in account when the request is made.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePullRequestApprovalState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_pull_request_approval_state_input::Builder,
    }
    impl<C, M, R> UpdatePullRequestApprovalState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePullRequestApprovalState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestApprovalStateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestApprovalStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePullRequestApprovalStateInputOperationOutputAlias,
                crate::output::UpdatePullRequestApprovalStateOutput,
                crate::error::UpdatePullRequestApprovalStateError,
                crate::input::UpdatePullRequestApprovalStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The system-generated ID of the revision.</p>
        pub fn revision_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_id(inp);
            self
        }
        /// <p>The system-generated ID of the revision.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_revision_id(input);
            self
        }
        /// <p>The approval state to associate with the user on the pull request.</p>
        pub fn approval_state(mut self, inp: crate::model::ApprovalState) -> Self {
            self.inner = self.inner.approval_state(inp);
            self
        }
        /// <p>The approval state to associate with the user on the pull request.</p>
        pub fn set_approval_state(
            mut self,
            input: std::option::Option<crate::model::ApprovalState>,
        ) -> Self {
            self.inner = self.inner.set_approval_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestDescription`.
    ///
    /// <p>Replaces the contents of the description of a pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePullRequestDescription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_pull_request_description_input::Builder,
    }
    impl<C, M, R> UpdatePullRequestDescription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePullRequestDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestDescriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestDescriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePullRequestDescriptionInputOperationOutputAlias,
                crate::output::UpdatePullRequestDescriptionOutput,
                crate::error::UpdatePullRequestDescriptionError,
                crate::input::UpdatePullRequestDescriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The updated content of the description for the pull request. This content replaces the
        /// existing description.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The updated content of the description for the pull request. This content replaces the
        /// existing description.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestStatus`.
    ///
    /// <p>Updates the status of a pull request. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePullRequestStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_pull_request_status_input::Builder,
    }
    impl<C, M, R> UpdatePullRequestStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePullRequestStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePullRequestStatusInputOperationOutputAlias,
                crate::output::UpdatePullRequestStatusOutput,
                crate::error::UpdatePullRequestStatusError,
                crate::input::UpdatePullRequestStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The status of the pull request. The only valid operations are to update the status
        /// from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or
        /// from <code>CLOSED</code> to <code>CLOSED</code>.</p>
        pub fn pull_request_status(mut self, inp: crate::model::PullRequestStatusEnum) -> Self {
            self.inner = self.inner.pull_request_status(inp);
            self
        }
        /// <p>The status of the pull request. The only valid operations are to update the status
        /// from <code>OPEN</code> to <code>OPEN</code>, <code>OPEN</code> to <code>CLOSED</code> or
        /// from <code>CLOSED</code> to <code>CLOSED</code>.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePullRequestTitle`.
    ///
    /// <p>Replaces the title of a pull request.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePullRequestTitle<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_pull_request_title_input::Builder,
    }
    impl<C, M, R> UpdatePullRequestTitle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePullRequestTitle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePullRequestTitleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestTitleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePullRequestTitleInputOperationOutputAlias,
                crate::output::UpdatePullRequestTitleOutput,
                crate::error::UpdatePullRequestTitleError,
                crate::input::UpdatePullRequestTitleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn pull_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pull_request_id(inp);
            self
        }
        /// <p>The system-generated ID of the pull request. To get this ID, use <a>ListPullRequests</a>.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pull_request_id(input);
            self
        }
        /// <p>The updated title of the pull request. This replaces the existing title.</p>
        pub fn title(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.title(inp);
            self
        }
        /// <p>The updated title of the pull request. This replaces the existing title.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_title(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRepositoryDescription`.
    ///
    /// <p>Sets or changes the comment or description for a repository.</p>
    /// <note>
    /// <p>The description field for a repository accepts all HTML characters and all valid
    /// Unicode characters. Applications that do not HTML-encode the description and display
    /// it in a webpage can expose users to potentially malicious code. Make sure that you
    /// HTML-encode the description field in any application that uses this API to display
    /// the repository description on a webpage.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRepositoryDescription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_repository_description_input::Builder,
    }
    impl<C, M, R> UpdateRepositoryDescription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRepositoryDescription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRepositoryDescriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryDescriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRepositoryDescriptionInputOperationOutputAlias,
                crate::output::UpdateRepositoryDescriptionOutput,
                crate::error::UpdateRepositoryDescriptionError,
                crate::input::UpdateRepositoryDescriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the repository to set or change the comment or description for.</p>
        pub fn repository_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_name(inp);
            self
        }
        /// <p>The name of the repository to set or change the comment or description for.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_name(input);
            self
        }
        /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
        pub fn repository_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_description(inp);
            self
        }
        /// <p>The new comment or description for the specified repository. Repository descriptions are limited to 1,000 characters.</p>
        pub fn set_repository_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRepositoryName`.
    ///
    /// <p>Renames a repository. The repository name must be unique across the calling AWS
    /// account. Repository names are limited to 100 alphanumeric, dash, and underscore
    /// characters, and cannot include certain characters. The suffix .git is prohibited. For
    /// more information about the limits on repository names, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Limits</a> in the AWS CodeCommit
    /// User Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRepositoryName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_repository_name_input::Builder,
    }
    impl<C, M, R> UpdateRepositoryName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRepositoryName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRepositoryNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRepositoryNameInputOperationOutputAlias,
                crate::output::UpdateRepositoryNameOutput,
                crate::error::UpdateRepositoryNameError,
                crate::input::UpdateRepositoryNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The current name of the repository.</p>
        pub fn old_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.old_name(inp);
            self
        }
        /// <p>The current name of the repository.</p>
        pub fn set_old_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_old_name(input);
            self
        }
        /// <p>The new name for the repository.</p>
        pub fn new_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_name(inp);
            self
        }
        /// <p>The new name for the repository.</p>
        pub fn set_new_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_new_name(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
