// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The specified Amazon Resource Name (ARN) does not exist in the AWS account.</p>
    ActorDoesNotExistException(crate::error::ActorDoesNotExistException),
    /// <p>The content for the approval rule is empty. You must provide some content for an approval rule. The content cannot be null.</p>
    ApprovalRuleContentRequiredException(crate::error::ApprovalRuleContentRequiredException),
    /// <p>The specified approval rule does not exist.</p>
    ApprovalRuleDoesNotExistException(crate::error::ApprovalRuleDoesNotExistException),
    /// <p>An approval rule with that name already exists. Approval rule names must be unique within the scope of a pull request.</p>
    ApprovalRuleNameAlreadyExistsException(crate::error::ApprovalRuleNameAlreadyExistsException),
    /// <p>An approval rule name is required, but was not specified.</p>
    ApprovalRuleNameRequiredException(crate::error::ApprovalRuleNameRequiredException),
    /// <p>The content for the approval rule template is empty. You must provide some content for an approval rule template. The content cannot be null.</p>
    ApprovalRuleTemplateContentRequiredException(
        crate::error::ApprovalRuleTemplateContentRequiredException,
    ),
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>The approval rule template is associated with one or more repositories. You cannot delete a template that is associated with a repository. Remove all associations, and then try again.</p>
    ApprovalRuleTemplateInUseException(crate::error::ApprovalRuleTemplateInUseException),
    /// <p>You cannot create an approval rule template with that name because a template with that name already exists in this AWS Region for your AWS account. Approval rule template names must be unique.</p>
    ApprovalRuleTemplateNameAlreadyExistsException(
        crate::error::ApprovalRuleTemplateNameAlreadyExistsException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>An approval state is required, but was not specified.</p>
    ApprovalStateRequiredException(crate::error::ApprovalStateRequiredException),
    /// <p>The specified Amazon Resource Name (ARN) does not exist in the AWS account.</p>
    AuthorDoesNotExistException(crate::error::AuthorDoesNotExistException),
    /// <p>The before commit ID and the after commit ID are the same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</p>
    BeforeCommitIdAndAfterCommitIdAreSameException(
        crate::error::BeforeCommitIdAndAfterCommitIdAreSameException,
    ),
    /// <p>The specified blob does not exist.</p>
    BlobIdDoesNotExistException(crate::error::BlobIdDoesNotExistException),
    /// <p>A blob ID is required, but was not specified.</p>
    BlobIdRequiredException(crate::error::BlobIdRequiredException),
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>Cannot create the branch with the specified name because the commit conflicts with an existing branch with the same name. Branch names must be unique.</p>
    BranchNameExistsException(crate::error::BranchNameExistsException),
    /// <p>The specified branch name is not valid because it is a tag name. Enter the name of a branch in the repository. For a list of valid branch names, use <code>ListBranches</code>.</p>
    BranchNameIsTagNameException(crate::error::BranchNameIsTagNameException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The approval rule cannot be deleted from the pull request because it was created by an approval rule template and applied to the pull request automatically.</p>
    CannotDeleteApprovalRuleFromTemplateException(
        crate::error::CannotDeleteApprovalRuleFromTemplateException,
    ),
    /// <p>The approval rule cannot be modified for the pull request because it was created by an approval rule template and applied to the pull request automatically.</p>
    CannotModifyApprovalRuleFromTemplateException(
        crate::error::CannotModifyApprovalRuleFromTemplateException,
    ),
    /// <p>A client request token is required. A client request token is an unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.</p>
    ClientRequestTokenRequiredException(crate::error::ClientRequestTokenRequiredException),
    /// <p>The comment is empty. You must provide some content for a comment. The content cannot be null.</p>
    CommentContentRequiredException(crate::error::CommentContentRequiredException),
    /// <p>The comment is too large. Comments are limited to 1,000 characters.</p>
    CommentContentSizeLimitExceededException(
        crate::error::CommentContentSizeLimitExceededException,
    ),
    /// <p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>
    CommentDeletedException(crate::error::CommentDeletedException),
    /// <p>No comment exists with the provided ID. Verify that you have used the correct ID, and then try again.</p>
    CommentDoesNotExistException(crate::error::CommentDoesNotExistException),
    /// <p>The comment ID is missing or null. A comment ID is required.</p>
    CommentIdRequiredException(crate::error::CommentIdRequiredException),
    /// <p>You cannot modify or delete this comment. Only comment authors can modify or delete their comments.</p>
    CommentNotCreatedByCallerException(crate::error::CommentNotCreatedByCallerException),
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>The specified commit ID does not exist.</p>
    CommitIdDoesNotExistException(crate::error::CommitIdDoesNotExistException),
    /// <p>A commit ID was not specified.</p>
    CommitIdRequiredException(crate::error::CommitIdRequiredException),
    /// <p>The maximum number of allowed commit IDs in a batch request is 100. Verify that your batch requests contains no more than 100 commit IDs, and then try again.</p>
    CommitIdsLimitExceededException(crate::error::CommitIdsLimitExceededException),
    /// <p>A list of commit IDs is required, but was either not specified or the list was empty.</p>
    CommitIdsListRequiredException(crate::error::CommitIdsListRequiredException),
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>The specified branch is the default branch for the repository, and cannot be deleted. To delete this branch, you must first set another branch as the default branch.</p>
    DefaultBranchCannotBeDeletedException(crate::error::DefaultBranchCannotBeDeletedException),
    /// <p>A file cannot be added to the repository because the specified path name has the same name as a file that already exists in this repository. Either provide a different name for the file, or specify a different path for the file.</p>
    DirectoryNameConflictsWithFileNameException(
        crate::error::DirectoryNameConflictsWithFileNameException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The commit cannot be created because both a source file and file content have been specified for the same file. You cannot provide both. Either specify a source file or provide the file content directly.</p>
    FileContentAndSourceFileSpecifiedException(
        crate::error::FileContentAndSourceFileSpecifiedException,
    ),
    /// <p>The file cannot be added because it is empty. Empty files cannot be added to the repository with this API.</p>
    FileContentRequiredException(crate::error::FileContentRequiredException),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file content change size is 7 MB. Consider making these changes using a Git client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>The specified file does not exist. Verify that you have used the correct file name, full path, and extension.</p>
    FileDoesNotExistException(crate::error::FileDoesNotExistException),
    /// <p>The commit cannot be created because no files have been specified as added, updated, or changed (PutFile or DeleteFile) for the commit.</p>
    FileEntryRequiredException(crate::error::FileEntryRequiredException),
    /// <p>The commit cannot be created because no file mode has been specified. A file mode is required to update mode permissions for a file.</p>
    FileModeRequiredException(crate::error::FileModeRequiredException),
    /// <p>A file cannot be added to the repository because the specified file name has the same name as a directory in this repository. Either provide another name for the file, or add the file in a directory that does not match the file name.</p>
    FileNameConflictsWithDirectoryNameException(
        crate::error::FileNameConflictsWithDirectoryNameException,
    ),
    /// <p>The commit cannot be created because a specified file path points to a submodule. Verify that the destination files have valid file paths that do not point to a submodule.</p>
    FilePathConflictsWithSubmodulePathException(
        crate::error::FilePathConflictsWithSubmodulePathException,
    ),
    /// <p>The specified file exceeds the file size limit for AWS CodeCommit. For more information about limits in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>
    FileTooLargeException(crate::error::FileTooLargeException),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified folder does not exist. Either the folder name is not correct, or you did not enter the full path to the folder.</p>
    FolderDoesNotExistException(crate::error::FolderDoesNotExistException),
    /// <p>The client request token is not valid. Either the token is not in a valid format, or the token has been used in a previous request and cannot be reused.</p>
    IdempotencyParameterMismatchException(crate::error::IdempotencyParameterMismatchException),
    /// <p>The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the user who initiated the change for the pull request, and then try again.</p>
    InvalidActorArnException(crate::error::InvalidActorArnException),
    /// <p>The content for the approval rule is not valid.</p>
    InvalidApprovalRuleContentException(crate::error::InvalidApprovalRuleContentException),
    /// <p>The name for the approval rule is not valid.</p>
    InvalidApprovalRuleNameException(crate::error::InvalidApprovalRuleNameException),
    /// <p>The content of the approval rule template is not valid.</p>
    InvalidApprovalRuleTemplateContentException(
        crate::error::InvalidApprovalRuleTemplateContentException,
    ),
    /// <p>The description for the approval rule template is not valid because it exceeds the maximum characters allowed for a description. For more information about limits in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateDescriptionException(
        crate::error::InvalidApprovalRuleTemplateDescriptionException,
    ),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1 and 100 valid characters in length. For more information about limits in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>The state for the approval is not valid. Valid values include APPROVE and REVOKE. </p>
    InvalidApprovalStateException(crate::error::InvalidApprovalStateException),
    /// <p>The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the author of the pull request, and then try again.</p>
    InvalidAuthorArnException(crate::error::InvalidAuthorArnException),
    /// <p>The specified blob is not valid.</p>
    InvalidBlobIdException(crate::error::InvalidBlobIdException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The client request token is not valid.</p>
    InvalidClientRequestTokenException(crate::error::InvalidClientRequestTokenException),
    /// <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
    InvalidCommentIdException(crate::error::InvalidCommentIdException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution list is not valid.</p>
    InvalidConflictResolutionException(crate::error::InvalidConflictResolutionException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified deletion parameter is not valid.</p>
    InvalidDeletionParameterException(crate::error::InvalidDeletionParameterException),
    /// <p>The pull request description is not valid. Descriptions cannot be more than 1,000 characters.</p>
    InvalidDescriptionException(crate::error::InvalidDescriptionException),
    /// <p>The destination commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID. </p>
    InvalidDestinationCommitSpecifierException(
        crate::error::InvalidDestinationCommitSpecifierException,
    ),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The location of the file is not valid. Make sure that you include the file name and extension.</p>
    InvalidFileLocationException(crate::error::InvalidFileLocationException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <code>PutFile</code>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The position is not valid. Make sure that the line number exists in the version of the file you want to comment on.</p>
    InvalidFilePositionException(crate::error::InvalidFilePositionException),
    /// <p>The specified value for the number of conflict files to return is not valid.</p>
    InvalidMaxConflictFilesException(crate::error::InvalidMaxConflictFilesException),
    /// <p>The specified value for the number of merge hunks to return is not valid.</p>
    InvalidMaxMergeHunksException(crate::error::InvalidMaxMergeHunksException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The specified merge option is not valid for this operation. Not all merge strategies are supported for all operations.</p>
    InvalidMergeOptionException(crate::error::InvalidMergeOptionException),
    /// <p>The specified sort order is not valid.</p>
    InvalidOrderException(crate::error::InvalidOrderException),
    /// <p>The override status is not valid. Valid statuses are OVERRIDE and REVOKE.</p>
    InvalidOverrideStatusException(crate::error::InvalidOverrideStatusException),
    /// <p>The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for the branch of the repository where you want to add or update a file.</p>
    InvalidParentCommitIdException(crate::error::InvalidParentCommitIdException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>The pull request event type is not valid. </p>
    InvalidPullRequestEventTypeException(crate::error::InvalidPullRequestEventTypeException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The pull request status is not valid. The only valid values are <code>OPEN</code> and <code>CLOSED</code>.</p>
    InvalidPullRequestStatusException(crate::error::InvalidPullRequestStatusException),
    /// <p>The pull request status update is not valid. The only valid update is from <code>OPEN</code> to <code>CLOSED</code>.</p>
    InvalidPullRequestStatusUpdateException(crate::error::InvalidPullRequestStatusUpdateException),
    /// <p>The Amazon Resource Name (ARN) of the user or identity is not valid.</p>
    InvalidReactionUserArnException(crate::error::InvalidReactionUserArnException),
    /// <p>The value of the reaction is not valid. For more information, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit User Guide</a>.</p>
    InvalidReactionValueException(crate::error::InvalidReactionValueException),
    /// <p>The specified reference name format is not valid. Reference names must conform to the Git references format (for example, refs/heads/master). For more information, see <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals - Git References</a> or consult your Git documentation.</p>
    InvalidReferenceNameException(crate::error::InvalidReferenceNameException),
    /// <p>Either the enum is not in a valid format, or the specified file version enum is not valid in respect to the current file version.</p>
    InvalidRelativeFileVersionEnumException(crate::error::InvalidRelativeFileVersionEnumException),
    /// <p>Automerge was specified for resolving the conflict, but the replacement type is not valid or content is missing. </p>
    InvalidReplacementContentException(crate::error::InvalidReplacementContentException),
    /// <p>Automerge was specified for resolving the conflict, but the specified replacement type is not valid.</p>
    InvalidReplacementTypeException(crate::error::InvalidReplacementTypeException),
    /// <p>The specified repository description is not valid.</p>
    InvalidRepositoryDescriptionException(crate::error::InvalidRepositoryDescriptionException),
    /// <p>A specified repository name is not valid.</p> <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other exceptions occur when a required repository parameter is missing, or when a specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>One or more branch names specified for the trigger is not valid.</p>
    InvalidRepositoryTriggerBranchNameException(
        crate::error::InvalidRepositoryTriggerBranchNameException,
    ),
    /// <p>The custom data provided for the trigger is not valid.</p>
    InvalidRepositoryTriggerCustomDataException(
        crate::error::InvalidRepositoryTriggerCustomDataException,
    ),
    /// <p>The Amazon Resource Name (ARN) for the trigger is not valid for the specified destination. The most common reason for this error is that the ARN does not meet the requirements for the service type.</p>
    InvalidRepositoryTriggerDestinationArnException(
        crate::error::InvalidRepositoryTriggerDestinationArnException,
    ),
    /// <p>One or more events specified for the trigger is not valid. Check to make sure that all events specified match the requirements for allowed events.</p>
    InvalidRepositoryTriggerEventsException(crate::error::InvalidRepositoryTriggerEventsException),
    /// <p>The name of the trigger is not valid.</p>
    InvalidRepositoryTriggerNameException(crate::error::InvalidRepositoryTriggerNameException),
    /// <p>The AWS Region for the trigger target does not match the AWS Region for the repository. Triggers must be created in the same Region as the target for the trigger.</p>
    InvalidRepositoryTriggerRegionException(crate::error::InvalidRepositoryTriggerRegionException),
    /// <p>The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</p>
    InvalidResourceArnException(crate::error::InvalidResourceArnException),
    /// <p>The revision ID is not valid. Use GetPullRequest to determine the value.</p>
    InvalidRevisionIdException(crate::error::InvalidRevisionIdException),
    /// <p>The SHA-256 hash signature for the rule content is not valid.</p>
    InvalidRuleContentSha256Exception(crate::error::InvalidRuleContentSha256Exception),
    /// <p>The specified sort by value is not valid.</p>
    InvalidSortByException(crate::error::InvalidSortByException),
    /// <p>The source commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID.</p>
    InvalidSourceCommitSpecifierException(crate::error::InvalidSourceCommitSpecifierException),
    /// <p>The specified tag is not valid. Key names cannot be prefixed with aws:.</p>
    InvalidSystemTagUsageException(crate::error::InvalidSystemTagUsageException),
    /// <p>The list of tags is not valid.</p>
    InvalidTagKeysListException(crate::error::InvalidTagKeysListException),
    /// <p>The map of tags is not valid.</p>
    InvalidTagsMapException(crate::error::InvalidTagsMapException),
    /// <p>The specified target branch is not valid.</p>
    InvalidTargetBranchException(crate::error::InvalidTargetBranchException),
    /// <p>The target for the pull request is not valid. A target must contain the full values for the repository name, source branch, and destination branch for the pull request.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>The targets for the pull request is not valid or not in a valid format. Targets are a list of target objects. Each target object must contain the full values for the repository name, source branch, and destination branch for a pull request.</p>
    InvalidTargetsException(crate::error::InvalidTargetsException),
    /// <p>The title of the pull request is not valid. Pull request titles cannot exceed 100 characters in length.</p>
    InvalidTitleException(crate::error::InvalidTitleException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The number of branches for the trigger was exceeded.</p>
    MaximumBranchesExceededException(crate::error::MaximumBranchesExceededException),
    /// <p>The number of allowed conflict resolution entries was exceeded.</p>
    MaximumConflictResolutionEntriesExceededException(
        crate::error::MaximumConflictResolutionEntriesExceededException,
    ),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of specified files to change as part of this commit exceeds the maximum number of files that can be changed in a single commit. Consider using a Git client for these changes.</p>
    MaximumFileEntriesExceededException(crate::error::MaximumFileEntriesExceededException),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>The number of approvals required for the approval rule exceeds the maximum number allowed.</p>
    MaximumNumberOfApprovalsExceededException(
        crate::error::MaximumNumberOfApprovalsExceededException,
    ),
    /// <p>You cannot create the pull request because the repository has too many open pull requests. The maximum number of open pull requests for a repository is 1,000. Close one or more open pull requests, and then try again.</p>
    MaximumOpenPullRequestsExceededException(
        crate::error::MaximumOpenPullRequestsExceededException,
    ),
    /// <p>The maximum number of allowed repository names was exceeded. Currently, this number is 100.</p>
    MaximumRepositoryNamesExceededException(crate::error::MaximumRepositoryNamesExceededException),
    /// <p>The number of triggers allowed for the repository was exceeded.</p>
    MaximumRepositoryTriggersExceededException(
        crate::error::MaximumRepositoryTriggersExceededException,
    ),
    /// <p>The maximum number of approval rule templates for a repository has been exceeded. You cannot associate more than 25 approval rule templates with a repository.</p>
    MaximumRuleTemplatesAssociatedWithRepositoryException(
        crate::error::MaximumRuleTemplatesAssociatedWithRepositoryException,
    ),
    /// <p>A merge option or stategy is required, and none was provided.</p>
    MergeOptionRequiredException(crate::error::MergeOptionRequiredException),
    /// <p>More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict resolution entry.</p>
    MultipleConflictResolutionEntriesException(
        crate::error::MultipleConflictResolutionEntriesException,
    ),
    /// <p>You cannot include more than one repository in a pull request. Make sure you have specified only one repository name in your request, and then try again.</p>
    MultipleRepositoriesInPullRequestException(
        crate::error::MultipleRepositoriesInPullRequestException,
    ),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The commit cannot be created because no changes will be made to the repository as a result of this commit. A commit must contain at least one change.</p>
    NoChangeException(crate::error::NoChangeException),
    /// <p>The maximum number of approval rule templates has been exceeded for this AWS Region. </p>
    NumberOfRuleTemplatesExceededException(crate::error::NumberOfRuleTemplatesExceededException),
    /// <p>The approval rule cannot be added. The pull request has the maximum number of approval rules associated with it.</p>
    NumberOfRulesExceededException(crate::error::NumberOfRulesExceededException),
    /// <p>The pull request has already had its approval rules set to override.</p>
    OverrideAlreadySetException(crate::error::OverrideAlreadySetException),
    /// <p>An override status is required, but no value was provided. Valid values include OVERRIDE and REVOKE.</p>
    OverrideStatusRequiredException(crate::error::OverrideStatusRequiredException),
    /// <p>The parent commit ID is not valid because it does not exist. The specified parent commit ID does not exist in the specified branch of the repository.</p>
    ParentCommitDoesNotExistException(crate::error::ParentCommitDoesNotExistException),
    /// <p>The file could not be added because the provided parent commit ID is not the current tip of the specified branch. To view the full commit ID of the current head of the branch, use <code>GetBranch</code>.</p>
    ParentCommitIdOutdatedException(crate::error::ParentCommitIdOutdatedException),
    /// <p>A parent commit ID is required. To view the full commit ID of a branch in a repository, use <code>GetBranch</code> or a Git command (for example, git pull or git log).</p>
    ParentCommitIdRequiredException(crate::error::ParentCommitIdRequiredException),
    /// <p>The specified path does not exist.</p>
    PathDoesNotExistException(crate::error::PathDoesNotExistException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request cannot be merged because one or more approval rules applied to the pull request have conditions that have not been met.</p>
    PullRequestApprovalRulesNotSatisfiedException(
        crate::error::PullRequestApprovalRulesNotSatisfiedException,
    ),
    /// <p>The approval cannot be applied because the user approving the pull request matches the user who created the pull request. You cannot approve a pull request that you created.</p>
    PullRequestCannotBeApprovedByAuthorException(
        crate::error::PullRequestCannotBeApprovedByAuthorException,
    ),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>A pull request status is required, but none was provided.</p>
    PullRequestStatusRequiredException(crate::error::PullRequestStatusRequiredException),
    /// <p>The commit cannot be created because one or more files specified in the commit reference both a file and a folder.</p>
    PutFileEntryConflictException(crate::error::PutFileEntryConflictException),
    /// <p>The number of reactions has been exceeded. Reactions are limited to one reaction per user for each individual comment ID.</p>
    ReactionLimitExceededException(crate::error::ReactionLimitExceededException),
    /// <p>A reaction value is required. </p>
    ReactionValueRequiredException(crate::error::ReactionValueRequiredException),
    /// <p>The specified reference does not exist. You must provide a full commit ID.</p>
    ReferenceDoesNotExistException(crate::error::ReferenceDoesNotExistException),
    /// <p>A reference name is required, but none was provided.</p>
    ReferenceNameRequiredException(crate::error::ReferenceNameRequiredException),
    /// <p>The specified reference is not a supported type. </p>
    ReferenceTypeNotSupportedException(crate::error::ReferenceTypeNotSupportedException),
    /// <p>USE_NEW_CONTENT was specified, but no replacement content has been provided.</p>
    ReplacementContentRequiredException(crate::error::ReplacementContentRequiredException),
    /// <p>A replacement type is required.</p>
    ReplacementTypeRequiredException(crate::error::ReplacementTypeRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository resource limit was exceeded.</p>
    RepositoryLimitExceededException(crate::error::RepositoryLimitExceededException),
    /// <p>The specified repository name already exists.</p>
    RepositoryNameExistsException(crate::error::RepositoryNameExistsException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>At least one repository name object is required, but was not specified.</p>
    RepositoryNamesRequiredException(crate::error::RepositoryNamesRequiredException),
    /// <p>The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request ID.</p>
    RepositoryNotAssociatedWithPullRequestException(
        crate::error::RepositoryNotAssociatedWithPullRequestException,
    ),
    /// <p>At least one branch name is required, but was not specified in the trigger configuration.</p>
    RepositoryTriggerBranchNameListRequiredException(
        crate::error::RepositoryTriggerBranchNameListRequiredException,
    ),
    /// <p>A destination ARN for the target service for the trigger is required, but was not specified.</p>
    RepositoryTriggerDestinationArnRequiredException(
        crate::error::RepositoryTriggerDestinationArnRequiredException,
    ),
    /// <p>At least one event for the trigger is required, but was not specified.</p>
    RepositoryTriggerEventsListRequiredException(
        crate::error::RepositoryTriggerEventsListRequiredException,
    ),
    /// <p>A name for the trigger is required, but was not specified.</p>
    RepositoryTriggerNameRequiredException(crate::error::RepositoryTriggerNameRequiredException),
    /// <p>The list of triggers for the repository is required, but was not specified.</p>
    RepositoryTriggersListRequiredException(crate::error::RepositoryTriggersListRequiredException),
    /// <p>A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid resources in AWS CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a> in the AWS CodeCommit User Guide.</p>
    ResourceArnRequiredException(crate::error::ResourceArnRequiredException),
    /// <p>The commit cannot be created because one of the changes specifies copying or moving a .gitkeep file.</p>
    RestrictedSourceFileException(crate::error::RestrictedSourceFileException),
    /// <p>A revision ID is required, but was not provided.</p>
    RevisionIdRequiredException(crate::error::RevisionIdRequiredException),
    /// <p>The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to retrieve the current revision ID.</p>
    RevisionNotCurrentException(crate::error::RevisionNotCurrentException),
    /// <p>The file was not added or updated because the content of the file is exactly the same as the content of that file in the repository and branch that you specified.</p>
    SameFileContentException(crate::error::SameFileContentException),
    /// <p>The commit cannot be created because one or more changes in this commit duplicate actions in the same file path. For example, you cannot make the same delete request to the same file in the same file path twice, or make a delete request and a move request to the same file as part of the same commit.</p>
    SamePathRequestException(crate::error::SamePathRequestException),
    /// <p>The source branch and destination branch for the pull request are the same. You must specify different branches for the source and destination.</p>
    SourceAndDestinationAreSameException(crate::error::SourceAndDestinationAreSameException),
    /// <p>The commit cannot be created because no source files or file content have been specified for the commit.</p>
    SourceFileOrContentRequiredException(crate::error::SourceFileOrContentRequiredException),
    /// <p>A list of tag keys is required. The list cannot be empty or null.</p>
    TagKeysListRequiredException(crate::error::TagKeysListRequiredException),
    /// <p>The tag policy is not valid.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>A map of tags is required.</p>
    TagsMapRequiredException(crate::error::TagsMapRequiredException),
    /// <p>A pull request target is required. It cannot be empty or null. A pull request target must contain the full values for the repository name, source branch, and destination branch for the pull request.</p>
    TargetRequiredException(crate::error::TargetRequiredException),
    /// <p>An array of target objects is required. It cannot be empty or null.</p>
    TargetsRequiredException(crate::error::TargetsRequiredException),
    /// <p>The tip of the source branch in the destination repository does not match the tip of the source branch specified in your request. The pull request might have been updated. Make sure that you have the latest changes.</p>
    TipOfSourceReferenceIsDifferentException(
        crate::error::TipOfSourceReferenceIsDifferentException,
    ),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// <p>A pull request title is required. It cannot be empty or null.</p>
    TitleRequiredException(crate::error::TitleRequiredException),
    /// <p>The maximum number of tags for an AWS CodeCommit resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::ActorDoesNotExistException(inner) => inner.fmt(f),
            Error::ApprovalRuleContentRequiredException(inner) => inner.fmt(f),
            Error::ApprovalRuleDoesNotExistException(inner) => inner.fmt(f),
            Error::ApprovalRuleNameAlreadyExistsException(inner) => inner.fmt(f),
            Error::ApprovalRuleNameRequiredException(inner) => inner.fmt(f),
            Error::ApprovalRuleTemplateContentRequiredException(inner) => inner.fmt(f),
            Error::ApprovalRuleTemplateDoesNotExistException(inner) => inner.fmt(f),
            Error::ApprovalRuleTemplateInUseException(inner) => inner.fmt(f),
            Error::ApprovalRuleTemplateNameAlreadyExistsException(inner) => inner.fmt(f),
            Error::ApprovalRuleTemplateNameRequiredException(inner) => inner.fmt(f),
            Error::ApprovalStateRequiredException(inner) => inner.fmt(f),
            Error::AuthorDoesNotExistException(inner) => inner.fmt(f),
            Error::BeforeCommitIdAndAfterCommitIdAreSameException(inner) => inner.fmt(f),
            Error::BlobIdDoesNotExistException(inner) => inner.fmt(f),
            Error::BlobIdRequiredException(inner) => inner.fmt(f),
            Error::BranchDoesNotExistException(inner) => inner.fmt(f),
            Error::BranchNameExistsException(inner) => inner.fmt(f),
            Error::BranchNameIsTagNameException(inner) => inner.fmt(f),
            Error::BranchNameRequiredException(inner) => inner.fmt(f),
            Error::CannotDeleteApprovalRuleFromTemplateException(inner) => inner.fmt(f),
            Error::CannotModifyApprovalRuleFromTemplateException(inner) => inner.fmt(f),
            Error::ClientRequestTokenRequiredException(inner) => inner.fmt(f),
            Error::CommentContentRequiredException(inner) => inner.fmt(f),
            Error::CommentContentSizeLimitExceededException(inner) => inner.fmt(f),
            Error::CommentDeletedException(inner) => inner.fmt(f),
            Error::CommentDoesNotExistException(inner) => inner.fmt(f),
            Error::CommentIdRequiredException(inner) => inner.fmt(f),
            Error::CommentNotCreatedByCallerException(inner) => inner.fmt(f),
            Error::CommitDoesNotExistException(inner) => inner.fmt(f),
            Error::CommitIdDoesNotExistException(inner) => inner.fmt(f),
            Error::CommitIdRequiredException(inner) => inner.fmt(f),
            Error::CommitIdsLimitExceededException(inner) => inner.fmt(f),
            Error::CommitIdsListRequiredException(inner) => inner.fmt(f),
            Error::CommitMessageLengthExceededException(inner) => inner.fmt(f),
            Error::CommitRequiredException(inner) => inner.fmt(f),
            Error::ConcurrentReferenceUpdateException(inner) => inner.fmt(f),
            Error::DefaultBranchCannotBeDeletedException(inner) => inner.fmt(f),
            Error::DirectoryNameConflictsWithFileNameException(inner) => inner.fmt(f),
            Error::EncryptionIntegrityChecksFailedException(inner) => inner.fmt(f),
            Error::EncryptionKeyAccessDeniedException(inner) => inner.fmt(f),
            Error::EncryptionKeyDisabledException(inner) => inner.fmt(f),
            Error::EncryptionKeyNotFoundException(inner) => inner.fmt(f),
            Error::EncryptionKeyUnavailableException(inner) => inner.fmt(f),
            Error::FileContentAndSourceFileSpecifiedException(inner) => inner.fmt(f),
            Error::FileContentRequiredException(inner) => inner.fmt(f),
            Error::FileContentSizeLimitExceededException(inner) => inner.fmt(f),
            Error::FileDoesNotExistException(inner) => inner.fmt(f),
            Error::FileEntryRequiredException(inner) => inner.fmt(f),
            Error::FileModeRequiredException(inner) => inner.fmt(f),
            Error::FileNameConflictsWithDirectoryNameException(inner) => inner.fmt(f),
            Error::FilePathConflictsWithSubmodulePathException(inner) => inner.fmt(f),
            Error::FileTooLargeException(inner) => inner.fmt(f),
            Error::FolderContentSizeLimitExceededException(inner) => inner.fmt(f),
            Error::FolderDoesNotExistException(inner) => inner.fmt(f),
            Error::IdempotencyParameterMismatchException(inner) => inner.fmt(f),
            Error::InvalidActorArnException(inner) => inner.fmt(f),
            Error::InvalidApprovalRuleContentException(inner) => inner.fmt(f),
            Error::InvalidApprovalRuleNameException(inner) => inner.fmt(f),
            Error::InvalidApprovalRuleTemplateContentException(inner) => inner.fmt(f),
            Error::InvalidApprovalRuleTemplateDescriptionException(inner) => inner.fmt(f),
            Error::InvalidApprovalRuleTemplateNameException(inner) => inner.fmt(f),
            Error::InvalidApprovalStateException(inner) => inner.fmt(f),
            Error::InvalidAuthorArnException(inner) => inner.fmt(f),
            Error::InvalidBlobIdException(inner) => inner.fmt(f),
            Error::InvalidBranchNameException(inner) => inner.fmt(f),
            Error::InvalidClientRequestTokenException(inner) => inner.fmt(f),
            Error::InvalidCommentIdException(inner) => inner.fmt(f),
            Error::InvalidCommitException(inner) => inner.fmt(f),
            Error::InvalidCommitIdException(inner) => inner.fmt(f),
            Error::InvalidConflictDetailLevelException(inner) => inner.fmt(f),
            Error::InvalidConflictResolutionException(inner) => inner.fmt(f),
            Error::InvalidConflictResolutionStrategyException(inner) => inner.fmt(f),
            Error::InvalidContinuationTokenException(inner) => inner.fmt(f),
            Error::InvalidDeletionParameterException(inner) => inner.fmt(f),
            Error::InvalidDescriptionException(inner) => inner.fmt(f),
            Error::InvalidDestinationCommitSpecifierException(inner) => inner.fmt(f),
            Error::InvalidEmailException(inner) => inner.fmt(f),
            Error::InvalidFileLocationException(inner) => inner.fmt(f),
            Error::InvalidFileModeException(inner) => inner.fmt(f),
            Error::InvalidFilePositionException(inner) => inner.fmt(f),
            Error::InvalidMaxConflictFilesException(inner) => inner.fmt(f),
            Error::InvalidMaxMergeHunksException(inner) => inner.fmt(f),
            Error::InvalidMaxResultsException(inner) => inner.fmt(f),
            Error::InvalidMergeOptionException(inner) => inner.fmt(f),
            Error::InvalidOrderException(inner) => inner.fmt(f),
            Error::InvalidOverrideStatusException(inner) => inner.fmt(f),
            Error::InvalidParentCommitIdException(inner) => inner.fmt(f),
            Error::InvalidPathException(inner) => inner.fmt(f),
            Error::InvalidPullRequestEventTypeException(inner) => inner.fmt(f),
            Error::InvalidPullRequestIdException(inner) => inner.fmt(f),
            Error::InvalidPullRequestStatusException(inner) => inner.fmt(f),
            Error::InvalidPullRequestStatusUpdateException(inner) => inner.fmt(f),
            Error::InvalidReactionUserArnException(inner) => inner.fmt(f),
            Error::InvalidReactionValueException(inner) => inner.fmt(f),
            Error::InvalidReferenceNameException(inner) => inner.fmt(f),
            Error::InvalidRelativeFileVersionEnumException(inner) => inner.fmt(f),
            Error::InvalidReplacementContentException(inner) => inner.fmt(f),
            Error::InvalidReplacementTypeException(inner) => inner.fmt(f),
            Error::InvalidRepositoryDescriptionException(inner) => inner.fmt(f),
            Error::InvalidRepositoryNameException(inner) => inner.fmt(f),
            Error::InvalidRepositoryTriggerBranchNameException(inner) => inner.fmt(f),
            Error::InvalidRepositoryTriggerCustomDataException(inner) => inner.fmt(f),
            Error::InvalidRepositoryTriggerDestinationArnException(inner) => inner.fmt(f),
            Error::InvalidRepositoryTriggerEventsException(inner) => inner.fmt(f),
            Error::InvalidRepositoryTriggerNameException(inner) => inner.fmt(f),
            Error::InvalidRepositoryTriggerRegionException(inner) => inner.fmt(f),
            Error::InvalidResourceArnException(inner) => inner.fmt(f),
            Error::InvalidRevisionIdException(inner) => inner.fmt(f),
            Error::InvalidRuleContentSha256Exception(inner) => inner.fmt(f),
            Error::InvalidSortByException(inner) => inner.fmt(f),
            Error::InvalidSourceCommitSpecifierException(inner) => inner.fmt(f),
            Error::InvalidSystemTagUsageException(inner) => inner.fmt(f),
            Error::InvalidTagKeysListException(inner) => inner.fmt(f),
            Error::InvalidTagsMapException(inner) => inner.fmt(f),
            Error::InvalidTargetBranchException(inner) => inner.fmt(f),
            Error::InvalidTargetException(inner) => inner.fmt(f),
            Error::InvalidTargetsException(inner) => inner.fmt(f),
            Error::InvalidTitleException(inner) => inner.fmt(f),
            Error::ManualMergeRequiredException(inner) => inner.fmt(f),
            Error::MaximumBranchesExceededException(inner) => inner.fmt(f),
            Error::MaximumConflictResolutionEntriesExceededException(inner) => inner.fmt(f),
            Error::MaximumFileContentToLoadExceededException(inner) => inner.fmt(f),
            Error::MaximumFileEntriesExceededException(inner) => inner.fmt(f),
            Error::MaximumItemsToCompareExceededException(inner) => inner.fmt(f),
            Error::MaximumNumberOfApprovalsExceededException(inner) => inner.fmt(f),
            Error::MaximumOpenPullRequestsExceededException(inner) => inner.fmt(f),
            Error::MaximumRepositoryNamesExceededException(inner) => inner.fmt(f),
            Error::MaximumRepositoryTriggersExceededException(inner) => inner.fmt(f),
            Error::MaximumRuleTemplatesAssociatedWithRepositoryException(inner) => inner.fmt(f),
            Error::MergeOptionRequiredException(inner) => inner.fmt(f),
            Error::MultipleConflictResolutionEntriesException(inner) => inner.fmt(f),
            Error::MultipleRepositoriesInPullRequestException(inner) => inner.fmt(f),
            Error::NameLengthExceededException(inner) => inner.fmt(f),
            Error::NoChangeException(inner) => inner.fmt(f),
            Error::NumberOfRuleTemplatesExceededException(inner) => inner.fmt(f),
            Error::NumberOfRulesExceededException(inner) => inner.fmt(f),
            Error::OverrideAlreadySetException(inner) => inner.fmt(f),
            Error::OverrideStatusRequiredException(inner) => inner.fmt(f),
            Error::ParentCommitDoesNotExistException(inner) => inner.fmt(f),
            Error::ParentCommitIdOutdatedException(inner) => inner.fmt(f),
            Error::ParentCommitIdRequiredException(inner) => inner.fmt(f),
            Error::PathDoesNotExistException(inner) => inner.fmt(f),
            Error::PathRequiredException(inner) => inner.fmt(f),
            Error::PullRequestAlreadyClosedException(inner) => inner.fmt(f),
            Error::PullRequestApprovalRulesNotSatisfiedException(inner) => inner.fmt(f),
            Error::PullRequestCannotBeApprovedByAuthorException(inner) => inner.fmt(f),
            Error::PullRequestDoesNotExistException(inner) => inner.fmt(f),
            Error::PullRequestIdRequiredException(inner) => inner.fmt(f),
            Error::PullRequestStatusRequiredException(inner) => inner.fmt(f),
            Error::PutFileEntryConflictException(inner) => inner.fmt(f),
            Error::ReactionLimitExceededException(inner) => inner.fmt(f),
            Error::ReactionValueRequiredException(inner) => inner.fmt(f),
            Error::ReferenceDoesNotExistException(inner) => inner.fmt(f),
            Error::ReferenceNameRequiredException(inner) => inner.fmt(f),
            Error::ReferenceTypeNotSupportedException(inner) => inner.fmt(f),
            Error::ReplacementContentRequiredException(inner) => inner.fmt(f),
            Error::ReplacementTypeRequiredException(inner) => inner.fmt(f),
            Error::RepositoryDoesNotExistException(inner) => inner.fmt(f),
            Error::RepositoryLimitExceededException(inner) => inner.fmt(f),
            Error::RepositoryNameExistsException(inner) => inner.fmt(f),
            Error::RepositoryNameRequiredException(inner) => inner.fmt(f),
            Error::RepositoryNamesRequiredException(inner) => inner.fmt(f),
            Error::RepositoryNotAssociatedWithPullRequestException(inner) => inner.fmt(f),
            Error::RepositoryTriggerBranchNameListRequiredException(inner) => inner.fmt(f),
            Error::RepositoryTriggerDestinationArnRequiredException(inner) => inner.fmt(f),
            Error::RepositoryTriggerEventsListRequiredException(inner) => inner.fmt(f),
            Error::RepositoryTriggerNameRequiredException(inner) => inner.fmt(f),
            Error::RepositoryTriggersListRequiredException(inner) => inner.fmt(f),
            Error::ResourceArnRequiredException(inner) => inner.fmt(f),
            Error::RestrictedSourceFileException(inner) => inner.fmt(f),
            Error::RevisionIdRequiredException(inner) => inner.fmt(f),
            Error::RevisionNotCurrentException(inner) => inner.fmt(f),
            Error::SameFileContentException(inner) => inner.fmt(f),
            Error::SamePathRequestException(inner) => inner.fmt(f),
            Error::SourceAndDestinationAreSameException(inner) => inner.fmt(f),
            Error::SourceFileOrContentRequiredException(inner) => inner.fmt(f),
            Error::TagKeysListRequiredException(inner) => inner.fmt(f),
            Error::TagPolicyException(inner) => inner.fmt(f),
            Error::TagsMapRequiredException(inner) => inner.fmt(f),
            Error::TargetRequiredException(inner) => inner.fmt(f),
            Error::TargetsRequiredException(inner) => inner.fmt(f),
            Error::TipOfSourceReferenceIsDifferentException(inner) => inner.fmt(f),
            Error::TipsDivergenceExceededException(inner) => inner.fmt(f),
            Error::TitleRequiredException(inner) => inner.fmt(f),
            Error::TooManyTagsException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::AssociateApprovalRuleTemplateWithRepositoryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AssociateApprovalRuleTemplateWithRepositoryError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::MaximumRuleTemplatesAssociatedWithRepositoryException(inner) => Error::MaximumRuleTemplatesAssociatedWithRepositoryException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::AssociateApprovalRuleTemplateWithRepositoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::MaximumRepositoryNamesExceededException(inner) => Error::MaximumRepositoryNamesExceededException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::RepositoryNamesRequiredException(inner) => Error::RepositoryNamesRequiredException(inner),
                crate::error::BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchDescribeMergeConflictsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchDescribeMergeConflictsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchDescribeMergeConflictsErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidMaxConflictFilesException(inner) => Error::InvalidMaxConflictFilesException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(inner) => Error::InvalidMaxMergeHunksException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidMergeOptionException(inner) => Error::InvalidMergeOptionException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::MergeOptionRequiredException(inner) => Error::MergeOptionRequiredException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::BatchDescribeMergeConflictsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::MaximumRepositoryNamesExceededException(inner) => Error::MaximumRepositoryNamesExceededException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::RepositoryNamesRequiredException(inner) => Error::RepositoryNamesRequiredException(inner),
                crate::error::BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetCommitsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::BatchGetCommitsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetCommitsErrorKind::CommitIdsLimitExceededException(inner) => Error::CommitIdsLimitExceededException(inner),
                crate::error::BatchGetCommitsErrorKind::CommitIdsListRequiredException(inner) => Error::CommitIdsListRequiredException(inner),
                crate::error::BatchGetCommitsErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::BatchGetCommitsErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::BatchGetCommitsErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::BatchGetCommitsErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::BatchGetCommitsErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::BatchGetCommitsErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::BatchGetCommitsErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::BatchGetCommitsErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::BatchGetCommitsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BatchGetRepositoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BatchGetRepositoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::BatchGetRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::BatchGetRepositoriesErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::BatchGetRepositoriesErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::BatchGetRepositoriesErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::BatchGetRepositoriesErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::BatchGetRepositoriesErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::BatchGetRepositoriesErrorKind::MaximumRepositoryNamesExceededException(inner) => Error::MaximumRepositoryNamesExceededException(inner),
                crate::error::BatchGetRepositoriesErrorKind::RepositoryNamesRequiredException(inner) => Error::RepositoryNamesRequiredException(inner),
                crate::error::BatchGetRepositoriesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateApprovalRuleTemplateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateApprovalRuleTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateContentRequiredException(inner) => Error::ApprovalRuleTemplateContentRequiredException(inner),
                crate::error::CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(inner) => Error::ApprovalRuleTemplateNameAlreadyExistsException(inner),
                crate::error::CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateContentException(inner) => Error::InvalidApprovalRuleTemplateContentException(inner),
                crate::error::CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateDescriptionException(inner) => Error::InvalidApprovalRuleTemplateDescriptionException(inner),
                crate::error::CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::CreateApprovalRuleTemplateErrorKind::NumberOfRuleTemplatesExceededException(inner) => Error::NumberOfRuleTemplatesExceededException(inner),
                crate::error::CreateApprovalRuleTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateBranchError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateBranchError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateBranchErrorKind::BranchNameExistsException(inner) => {
                    Error::BranchNameExistsException(inner)
                }
                crate::error::CreateBranchErrorKind::BranchNameRequiredException(inner) => {
                    Error::BranchNameRequiredException(inner)
                }
                crate::error::CreateBranchErrorKind::CommitDoesNotExistException(inner) => {
                    Error::CommitDoesNotExistException(inner)
                }
                crate::error::CreateBranchErrorKind::CommitIdRequiredException(inner) => {
                    Error::CommitIdRequiredException(inner)
                }
                crate::error::CreateBranchErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::CreateBranchErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::CreateBranchErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::CreateBranchErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::CreateBranchErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::CreateBranchErrorKind::InvalidBranchNameException(inner) => {
                    Error::InvalidBranchNameException(inner)
                }
                crate::error::CreateBranchErrorKind::InvalidCommitIdException(inner) => {
                    Error::InvalidCommitIdException(inner)
                }
                crate::error::CreateBranchErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::CreateBranchErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::CreateBranchErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::CreateBranchErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCommitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateCommitError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCommitErrorKind::BranchDoesNotExistException(inner) => Error::BranchDoesNotExistException(inner),
                crate::error::CreateCommitErrorKind::BranchNameIsTagNameException(inner) => Error::BranchNameIsTagNameException(inner),
                crate::error::CreateCommitErrorKind::BranchNameRequiredException(inner) => Error::BranchNameRequiredException(inner),
                crate::error::CreateCommitErrorKind::CommitMessageLengthExceededException(inner) => Error::CommitMessageLengthExceededException(inner),
                crate::error::CreateCommitErrorKind::DirectoryNameConflictsWithFileNameException(inner) => Error::DirectoryNameConflictsWithFileNameException(inner),
                crate::error::CreateCommitErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::CreateCommitErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::CreateCommitErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::CreateCommitErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::CreateCommitErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::CreateCommitErrorKind::FileContentAndSourceFileSpecifiedException(inner) => Error::FileContentAndSourceFileSpecifiedException(inner),
                crate::error::CreateCommitErrorKind::FileContentSizeLimitExceededException(inner) => Error::FileContentSizeLimitExceededException(inner),
                crate::error::CreateCommitErrorKind::FileDoesNotExistException(inner) => Error::FileDoesNotExistException(inner),
                crate::error::CreateCommitErrorKind::FileEntryRequiredException(inner) => Error::FileEntryRequiredException(inner),
                crate::error::CreateCommitErrorKind::FileModeRequiredException(inner) => Error::FileModeRequiredException(inner),
                crate::error::CreateCommitErrorKind::FileNameConflictsWithDirectoryNameException(inner) => Error::FileNameConflictsWithDirectoryNameException(inner),
                crate::error::CreateCommitErrorKind::FilePathConflictsWithSubmodulePathException(inner) => Error::FilePathConflictsWithSubmodulePathException(inner),
                crate::error::CreateCommitErrorKind::FolderContentSizeLimitExceededException(inner) => Error::FolderContentSizeLimitExceededException(inner),
                crate::error::CreateCommitErrorKind::InvalidBranchNameException(inner) => Error::InvalidBranchNameException(inner),
                crate::error::CreateCommitErrorKind::InvalidDeletionParameterException(inner) => Error::InvalidDeletionParameterException(inner),
                crate::error::CreateCommitErrorKind::InvalidEmailException(inner) => Error::InvalidEmailException(inner),
                crate::error::CreateCommitErrorKind::InvalidFileModeException(inner) => Error::InvalidFileModeException(inner),
                crate::error::CreateCommitErrorKind::InvalidParentCommitIdException(inner) => Error::InvalidParentCommitIdException(inner),
                crate::error::CreateCommitErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::CreateCommitErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::CreateCommitErrorKind::MaximumFileEntriesExceededException(inner) => Error::MaximumFileEntriesExceededException(inner),
                crate::error::CreateCommitErrorKind::NameLengthExceededException(inner) => Error::NameLengthExceededException(inner),
                crate::error::CreateCommitErrorKind::NoChangeException(inner) => Error::NoChangeException(inner),
                crate::error::CreateCommitErrorKind::ParentCommitDoesNotExistException(inner) => Error::ParentCommitDoesNotExistException(inner),
                crate::error::CreateCommitErrorKind::ParentCommitIdOutdatedException(inner) => Error::ParentCommitIdOutdatedException(inner),
                crate::error::CreateCommitErrorKind::ParentCommitIdRequiredException(inner) => Error::ParentCommitIdRequiredException(inner),
                crate::error::CreateCommitErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::CreateCommitErrorKind::PutFileEntryConflictException(inner) => Error::PutFileEntryConflictException(inner),
                crate::error::CreateCommitErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::CreateCommitErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::CreateCommitErrorKind::RestrictedSourceFileException(inner) => Error::RestrictedSourceFileException(inner),
                crate::error::CreateCommitErrorKind::SamePathRequestException(inner) => Error::SamePathRequestException(inner),
                crate::error::CreateCommitErrorKind::SourceFileOrContentRequiredException(inner) => Error::SourceFileOrContentRequiredException(inner),
                crate::error::CreateCommitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePullRequestError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePullRequestError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreatePullRequestErrorKind::ClientRequestTokenRequiredException(inner) => Error::ClientRequestTokenRequiredException(inner),
                crate::error::CreatePullRequestErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::CreatePullRequestErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::CreatePullRequestErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::CreatePullRequestErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::CreatePullRequestErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::CreatePullRequestErrorKind::IdempotencyParameterMismatchException(inner) => Error::IdempotencyParameterMismatchException(inner),
                crate::error::CreatePullRequestErrorKind::InvalidClientRequestTokenException(inner) => Error::InvalidClientRequestTokenException(inner),
                crate::error::CreatePullRequestErrorKind::InvalidDescriptionException(inner) => Error::InvalidDescriptionException(inner),
                crate::error::CreatePullRequestErrorKind::InvalidReferenceNameException(inner) => Error::InvalidReferenceNameException(inner),
                crate::error::CreatePullRequestErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::CreatePullRequestErrorKind::InvalidTargetException(inner) => Error::InvalidTargetException(inner),
                crate::error::CreatePullRequestErrorKind::InvalidTargetsException(inner) => Error::InvalidTargetsException(inner),
                crate::error::CreatePullRequestErrorKind::InvalidTitleException(inner) => Error::InvalidTitleException(inner),
                crate::error::CreatePullRequestErrorKind::MaximumOpenPullRequestsExceededException(inner) => Error::MaximumOpenPullRequestsExceededException(inner),
                crate::error::CreatePullRequestErrorKind::MultipleRepositoriesInPullRequestException(inner) => Error::MultipleRepositoriesInPullRequestException(inner),
                crate::error::CreatePullRequestErrorKind::ReferenceDoesNotExistException(inner) => Error::ReferenceDoesNotExistException(inner),
                crate::error::CreatePullRequestErrorKind::ReferenceNameRequiredException(inner) => Error::ReferenceNameRequiredException(inner),
                crate::error::CreatePullRequestErrorKind::ReferenceTypeNotSupportedException(inner) => Error::ReferenceTypeNotSupportedException(inner),
                crate::error::CreatePullRequestErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::CreatePullRequestErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::CreatePullRequestErrorKind::SourceAndDestinationAreSameException(inner) => Error::SourceAndDestinationAreSameException(inner),
                crate::error::CreatePullRequestErrorKind::TargetRequiredException(inner) => Error::TargetRequiredException(inner),
                crate::error::CreatePullRequestErrorKind::TargetsRequiredException(inner) => Error::TargetsRequiredException(inner),
                crate::error::CreatePullRequestErrorKind::TitleRequiredException(inner) => Error::TitleRequiredException(inner),
                crate::error::CreatePullRequestErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreatePullRequestApprovalRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreatePullRequestApprovalRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreatePullRequestApprovalRuleErrorKind::ApprovalRuleContentRequiredException(inner) => Error::ApprovalRuleContentRequiredException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameAlreadyExistsException(inner) => Error::ApprovalRuleNameAlreadyExistsException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(inner) => Error::ApprovalRuleNameRequiredException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleContentException(inner) => Error::InvalidApprovalRuleContentException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(inner) => Error::InvalidApprovalRuleNameException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::NumberOfRulesExceededException(inner) => Error::NumberOfRulesExceededException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::CreatePullRequestApprovalRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateRepositoryErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::CreateRepositoryErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::CreateRepositoryErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::CreateRepositoryErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::CreateRepositoryErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::CreateRepositoryErrorKind::InvalidRepositoryDescriptionException(inner) => Error::InvalidRepositoryDescriptionException(inner),
                crate::error::CreateRepositoryErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::CreateRepositoryErrorKind::InvalidSystemTagUsageException(inner) => Error::InvalidSystemTagUsageException(inner),
                crate::error::CreateRepositoryErrorKind::InvalidTagsMapException(inner) => Error::InvalidTagsMapException(inner),
                crate::error::CreateRepositoryErrorKind::RepositoryLimitExceededException(inner) => Error::RepositoryLimitExceededException(inner),
                crate::error::CreateRepositoryErrorKind::RepositoryNameExistsException(inner) => Error::RepositoryNameExistsException(inner),
                crate::error::CreateRepositoryErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::CreateRepositoryErrorKind::TagPolicyException(inner) => Error::TagPolicyException(inner),
                crate::error::CreateRepositoryErrorKind::TooManyTagsException(inner) => Error::TooManyTagsException(inner),
                crate::error::CreateRepositoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateUnreferencedMergeCommitError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateUnreferencedMergeCommitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateUnreferencedMergeCommitErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::CommitMessageLengthExceededException(inner) => Error::CommitMessageLengthExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::ConcurrentReferenceUpdateException(inner) => Error::ConcurrentReferenceUpdateException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::FileContentSizeLimitExceededException(inner) => Error::FileContentSizeLimitExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::FileModeRequiredException(inner) => Error::FileModeRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::FolderContentSizeLimitExceededException(inner) => Error::FolderContentSizeLimitExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionException(inner) => Error::InvalidConflictResolutionException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidEmailException(inner) => Error::InvalidEmailException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidFileModeException(inner) => Error::InvalidFileModeException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidMergeOptionException(inner) => Error::InvalidMergeOptionException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidReplacementContentException(inner) => Error::InvalidReplacementContentException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidReplacementTypeException(inner) => Error::InvalidReplacementTypeException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::ManualMergeRequiredException(inner) => Error::ManualMergeRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::MaximumConflictResolutionEntriesExceededException(inner) => Error::MaximumConflictResolutionEntriesExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::MergeOptionRequiredException(inner) => Error::MergeOptionRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::MultipleConflictResolutionEntriesException(inner) => Error::MultipleConflictResolutionEntriesException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::NameLengthExceededException(inner) => Error::NameLengthExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::ReplacementContentRequiredException(inner) => Error::ReplacementContentRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::ReplacementTypeRequiredException(inner) => Error::ReplacementTypeRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::CreateUnreferencedMergeCommitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteApprovalRuleTemplateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteApprovalRuleTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateInUseException(inner) => Error::ApprovalRuleTemplateInUseException(inner),
                crate::error::DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::DeleteApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::DeleteApprovalRuleTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteBranchError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteBranchError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteBranchErrorKind::BranchNameRequiredException(inner) => {
                    Error::BranchNameRequiredException(inner)
                }
                crate::error::DeleteBranchErrorKind::DefaultBranchCannotBeDeletedException(
                    inner,
                ) => Error::DefaultBranchCannotBeDeletedException(inner),
                crate::error::DeleteBranchErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::DeleteBranchErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::DeleteBranchErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::DeleteBranchErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::DeleteBranchErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::DeleteBranchErrorKind::InvalidBranchNameException(inner) => {
                    Error::InvalidBranchNameException(inner)
                }
                crate::error::DeleteBranchErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::DeleteBranchErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::DeleteBranchErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::DeleteBranchErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCommentContentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCommentContentError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCommentContentErrorKind::CommentDeletedException(inner) => {
                    Error::CommentDeletedException(inner)
                }
                crate::error::DeleteCommentContentErrorKind::CommentDoesNotExistException(
                    inner,
                ) => Error::CommentDoesNotExistException(inner),
                crate::error::DeleteCommentContentErrorKind::CommentIdRequiredException(inner) => {
                    Error::CommentIdRequiredException(inner)
                }
                crate::error::DeleteCommentContentErrorKind::InvalidCommentIdException(inner) => {
                    Error::InvalidCommentIdException(inner)
                }
                crate::error::DeleteCommentContentErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteFileError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteFileError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteFileErrorKind::BranchDoesNotExistException(inner) => {
                    Error::BranchDoesNotExistException(inner)
                }
                crate::error::DeleteFileErrorKind::BranchNameIsTagNameException(inner) => {
                    Error::BranchNameIsTagNameException(inner)
                }
                crate::error::DeleteFileErrorKind::BranchNameRequiredException(inner) => {
                    Error::BranchNameRequiredException(inner)
                }
                crate::error::DeleteFileErrorKind::CommitMessageLengthExceededException(inner) => {
                    Error::CommitMessageLengthExceededException(inner)
                }
                crate::error::DeleteFileErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::DeleteFileErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::DeleteFileErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::DeleteFileErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::DeleteFileErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::DeleteFileErrorKind::FileDoesNotExistException(inner) => {
                    Error::FileDoesNotExistException(inner)
                }
                crate::error::DeleteFileErrorKind::InvalidBranchNameException(inner) => {
                    Error::InvalidBranchNameException(inner)
                }
                crate::error::DeleteFileErrorKind::InvalidEmailException(inner) => {
                    Error::InvalidEmailException(inner)
                }
                crate::error::DeleteFileErrorKind::InvalidParentCommitIdException(inner) => {
                    Error::InvalidParentCommitIdException(inner)
                }
                crate::error::DeleteFileErrorKind::InvalidPathException(inner) => {
                    Error::InvalidPathException(inner)
                }
                crate::error::DeleteFileErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::DeleteFileErrorKind::NameLengthExceededException(inner) => {
                    Error::NameLengthExceededException(inner)
                }
                crate::error::DeleteFileErrorKind::ParentCommitDoesNotExistException(inner) => {
                    Error::ParentCommitDoesNotExistException(inner)
                }
                crate::error::DeleteFileErrorKind::ParentCommitIdOutdatedException(inner) => {
                    Error::ParentCommitIdOutdatedException(inner)
                }
                crate::error::DeleteFileErrorKind::ParentCommitIdRequiredException(inner) => {
                    Error::ParentCommitIdRequiredException(inner)
                }
                crate::error::DeleteFileErrorKind::PathRequiredException(inner) => {
                    Error::PathRequiredException(inner)
                }
                crate::error::DeleteFileErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::DeleteFileErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::DeleteFileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeletePullRequestApprovalRuleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeletePullRequestApprovalRuleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeletePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(inner) => Error::ApprovalRuleNameRequiredException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::CannotDeleteApprovalRuleFromTemplateException(inner) => Error::CannotDeleteApprovalRuleFromTemplateException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(inner) => Error::InvalidApprovalRuleNameException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::DeletePullRequestApprovalRuleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteRepositoryErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::DeleteRepositoryErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::DeleteRepositoryErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::DeleteRepositoryErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::DeleteRepositoryErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::DeleteRepositoryErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::DeleteRepositoryErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::DeleteRepositoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeMergeConflictsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeMergeConflictsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeMergeConflictsErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::DescribeMergeConflictsErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::DescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::DescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::DescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::DescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::DescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::DescribeMergeConflictsErrorKind::FileDoesNotExistException(inner) => Error::FileDoesNotExistException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(inner) => Error::InvalidMaxMergeHunksException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidMergeOptionException(inner) => Error::InvalidMergeOptionException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::DescribeMergeConflictsErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::DescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::DescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::DescribeMergeConflictsErrorKind::MergeOptionRequiredException(inner) => Error::MergeOptionRequiredException(inner),
                crate::error::DescribeMergeConflictsErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::DescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::DescribeMergeConflictsErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::DescribeMergeConflictsErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::DescribeMergeConflictsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribePullRequestEventsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribePullRequestEventsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribePullRequestEventsErrorKind::ActorDoesNotExistException(inner) => Error::ActorDoesNotExistException(inner),
                crate::error::DescribePullRequestEventsErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::DescribePullRequestEventsErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::DescribePullRequestEventsErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::DescribePullRequestEventsErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::DescribePullRequestEventsErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::DescribePullRequestEventsErrorKind::InvalidActorArnException(inner) => Error::InvalidActorArnException(inner),
                crate::error::DescribePullRequestEventsErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::DescribePullRequestEventsErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::DescribePullRequestEventsErrorKind::InvalidPullRequestEventTypeException(inner) => Error::InvalidPullRequestEventTypeException(inner),
                crate::error::DescribePullRequestEventsErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::DescribePullRequestEventsErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::DescribePullRequestEventsErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::DescribePullRequestEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DisassociateApprovalRuleTemplateFromRepositoryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DisassociateApprovalRuleTemplateFromRepositoryError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::DisassociateApprovalRuleTemplateFromRepositoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::EvaluatePullRequestApprovalRulesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::EvaluatePullRequestApprovalRulesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(inner) => Error::InvalidRevisionIdException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(inner) => Error::RevisionIdRequiredException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(inner) => Error::RevisionNotCurrentException(inner),
                crate::error::EvaluatePullRequestApprovalRulesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetApprovalRuleTemplateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetApprovalRuleTemplateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::GetApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::GetApprovalRuleTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBlobError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetBlobError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBlobErrorKind::BlobIdDoesNotExistException(inner) => {
                    Error::BlobIdDoesNotExistException(inner)
                }
                crate::error::GetBlobErrorKind::BlobIdRequiredException(inner) => {
                    Error::BlobIdRequiredException(inner)
                }
                crate::error::GetBlobErrorKind::EncryptionIntegrityChecksFailedException(inner) => {
                    Error::EncryptionIntegrityChecksFailedException(inner)
                }
                crate::error::GetBlobErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::GetBlobErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetBlobErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetBlobErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetBlobErrorKind::FileTooLargeException(inner) => {
                    Error::FileTooLargeException(inner)
                }
                crate::error::GetBlobErrorKind::InvalidBlobIdException(inner) => {
                    Error::InvalidBlobIdException(inner)
                }
                crate::error::GetBlobErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::GetBlobErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::GetBlobErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::GetBlobErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBranchError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetBranchError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBranchErrorKind::BranchDoesNotExistException(inner) => {
                    Error::BranchDoesNotExistException(inner)
                }
                crate::error::GetBranchErrorKind::BranchNameRequiredException(inner) => {
                    Error::BranchNameRequiredException(inner)
                }
                crate::error::GetBranchErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetBranchErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::GetBranchErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetBranchErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetBranchErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetBranchErrorKind::InvalidBranchNameException(inner) => {
                    Error::InvalidBranchNameException(inner)
                }
                crate::error::GetBranchErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::GetBranchErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::GetBranchErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::GetBranchErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCommentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCommentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCommentErrorKind::CommentDeletedException(inner) => {
                    Error::CommentDeletedException(inner)
                }
                crate::error::GetCommentErrorKind::CommentDoesNotExistException(inner) => {
                    Error::CommentDoesNotExistException(inner)
                }
                crate::error::GetCommentErrorKind::CommentIdRequiredException(inner) => {
                    Error::CommentIdRequiredException(inner)
                }
                crate::error::GetCommentErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetCommentErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::GetCommentErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetCommentErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetCommentErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetCommentErrorKind::InvalidCommentIdException(inner) => {
                    Error::InvalidCommentIdException(inner)
                }
                crate::error::GetCommentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCommentReactionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCommentReactionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCommentReactionsErrorKind::CommentDeletedException(inner) => {
                    Error::CommentDeletedException(inner)
                }
                crate::error::GetCommentReactionsErrorKind::CommentDoesNotExistException(inner) => {
                    Error::CommentDoesNotExistException(inner)
                }
                crate::error::GetCommentReactionsErrorKind::CommentIdRequiredException(inner) => {
                    Error::CommentIdRequiredException(inner)
                }
                crate::error::GetCommentReactionsErrorKind::InvalidCommentIdException(inner) => {
                    Error::InvalidCommentIdException(inner)
                }
                crate::error::GetCommentReactionsErrorKind::InvalidContinuationTokenException(
                    inner,
                ) => Error::InvalidContinuationTokenException(inner),
                crate::error::GetCommentReactionsErrorKind::InvalidMaxResultsException(inner) => {
                    Error::InvalidMaxResultsException(inner)
                }
                crate::error::GetCommentReactionsErrorKind::InvalidReactionUserArnException(
                    inner,
                ) => Error::InvalidReactionUserArnException(inner),
                crate::error::GetCommentReactionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCommentsForComparedCommitError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCommentsForComparedCommitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCommentsForComparedCommitErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::CommitIdRequiredException(inner) => Error::CommitIdRequiredException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::InvalidCommitIdException(inner) => Error::InvalidCommitIdException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::GetCommentsForComparedCommitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCommentsForPullRequestError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCommentsForPullRequestError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCommentsForPullRequestErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::CommitIdRequiredException(inner) => Error::CommitIdRequiredException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::InvalidCommitIdException(inner) => Error::InvalidCommitIdException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(inner) => Error::RepositoryNotAssociatedWithPullRequestException(inner),
                crate::error::GetCommentsForPullRequestErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCommitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCommitError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCommitErrorKind::CommitIdDoesNotExistException(inner) => {
                    Error::CommitIdDoesNotExistException(inner)
                }
                crate::error::GetCommitErrorKind::CommitIdRequiredException(inner) => {
                    Error::CommitIdRequiredException(inner)
                }
                crate::error::GetCommitErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetCommitErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::GetCommitErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetCommitErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetCommitErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetCommitErrorKind::InvalidCommitIdException(inner) => {
                    Error::InvalidCommitIdException(inner)
                }
                crate::error::GetCommitErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::GetCommitErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::GetCommitErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::GetCommitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDifferencesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDifferencesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDifferencesErrorKind::CommitDoesNotExistException(inner) => {
                    Error::CommitDoesNotExistException(inner)
                }
                crate::error::GetDifferencesErrorKind::CommitRequiredException(inner) => {
                    Error::CommitRequiredException(inner)
                }
                crate::error::GetDifferencesErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetDifferencesErrorKind::EncryptionKeyAccessDeniedException(
                    inner,
                ) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetDifferencesErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetDifferencesErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetDifferencesErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetDifferencesErrorKind::InvalidCommitException(inner) => {
                    Error::InvalidCommitException(inner)
                }
                crate::error::GetDifferencesErrorKind::InvalidCommitIdException(inner) => {
                    Error::InvalidCommitIdException(inner)
                }
                crate::error::GetDifferencesErrorKind::InvalidContinuationTokenException(inner) => {
                    Error::InvalidContinuationTokenException(inner)
                }
                crate::error::GetDifferencesErrorKind::InvalidMaxResultsException(inner) => {
                    Error::InvalidMaxResultsException(inner)
                }
                crate::error::GetDifferencesErrorKind::InvalidPathException(inner) => {
                    Error::InvalidPathException(inner)
                }
                crate::error::GetDifferencesErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::GetDifferencesErrorKind::PathDoesNotExistException(inner) => {
                    Error::PathDoesNotExistException(inner)
                }
                crate::error::GetDifferencesErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::GetDifferencesErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::GetDifferencesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFileError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetFileError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFileErrorKind::CommitDoesNotExistException(inner) => {
                    Error::CommitDoesNotExistException(inner)
                }
                crate::error::GetFileErrorKind::EncryptionIntegrityChecksFailedException(inner) => {
                    Error::EncryptionIntegrityChecksFailedException(inner)
                }
                crate::error::GetFileErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::GetFileErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetFileErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetFileErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetFileErrorKind::FileDoesNotExistException(inner) => {
                    Error::FileDoesNotExistException(inner)
                }
                crate::error::GetFileErrorKind::FileTooLargeException(inner) => {
                    Error::FileTooLargeException(inner)
                }
                crate::error::GetFileErrorKind::InvalidCommitException(inner) => {
                    Error::InvalidCommitException(inner)
                }
                crate::error::GetFileErrorKind::InvalidPathException(inner) => {
                    Error::InvalidPathException(inner)
                }
                crate::error::GetFileErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::GetFileErrorKind::PathRequiredException(inner) => {
                    Error::PathRequiredException(inner)
                }
                crate::error::GetFileErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::GetFileErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::GetFileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetFolderError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetFolderError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetFolderErrorKind::CommitDoesNotExistException(inner) => {
                    Error::CommitDoesNotExistException(inner)
                }
                crate::error::GetFolderErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetFolderErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::GetFolderErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetFolderErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetFolderErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetFolderErrorKind::FolderDoesNotExistException(inner) => {
                    Error::FolderDoesNotExistException(inner)
                }
                crate::error::GetFolderErrorKind::InvalidCommitException(inner) => {
                    Error::InvalidCommitException(inner)
                }
                crate::error::GetFolderErrorKind::InvalidPathException(inner) => {
                    Error::InvalidPathException(inner)
                }
                crate::error::GetFolderErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::GetFolderErrorKind::PathRequiredException(inner) => {
                    Error::PathRequiredException(inner)
                }
                crate::error::GetFolderErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::GetFolderErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::GetFolderErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMergeCommitError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMergeCommitError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetMergeCommitErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::GetMergeCommitErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::GetMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetMergeCommitErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetMergeCommitErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetMergeCommitErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetMergeCommitErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetMergeCommitErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::GetMergeCommitErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::GetMergeCommitErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::GetMergeCommitErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::GetMergeCommitErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::GetMergeCommitErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::GetMergeCommitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMergeConflictsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetMergeConflictsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetMergeConflictsErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::GetMergeConflictsErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::GetMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetMergeConflictsErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetMergeConflictsErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetMergeConflictsErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidDestinationCommitSpecifierException(inner) => Error::InvalidDestinationCommitSpecifierException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidMaxConflictFilesException(inner) => Error::InvalidMaxConflictFilesException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidMergeOptionException(inner) => Error::InvalidMergeOptionException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::GetMergeConflictsErrorKind::InvalidSourceCommitSpecifierException(inner) => Error::InvalidSourceCommitSpecifierException(inner),
                crate::error::GetMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::GetMergeConflictsErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::GetMergeConflictsErrorKind::MergeOptionRequiredException(inner) => Error::MergeOptionRequiredException(inner),
                crate::error::GetMergeConflictsErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::GetMergeConflictsErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::GetMergeConflictsErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::GetMergeConflictsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetMergeOptionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetMergeOptionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetMergeOptionsErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::GetMergeOptionsErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::GetMergeOptionsErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetMergeOptionsErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetMergeOptionsErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetMergeOptionsErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetMergeOptionsErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetMergeOptionsErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::GetMergeOptionsErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::GetMergeOptionsErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::GetMergeOptionsErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::GetMergeOptionsErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::GetMergeOptionsErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::GetMergeOptionsErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::GetMergeOptionsErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::GetMergeOptionsErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::GetMergeOptionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPullRequestError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetPullRequestError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetPullRequestErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetPullRequestErrorKind::EncryptionKeyAccessDeniedException(
                    inner,
                ) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetPullRequestErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetPullRequestErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetPullRequestErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetPullRequestErrorKind::InvalidPullRequestIdException(inner) => {
                    Error::InvalidPullRequestIdException(inner)
                }
                crate::error::GetPullRequestErrorKind::PullRequestDoesNotExistException(inner) => {
                    Error::PullRequestDoesNotExistException(inner)
                }
                crate::error::GetPullRequestErrorKind::PullRequestIdRequiredException(inner) => {
                    Error::PullRequestIdRequiredException(inner)
                }
                crate::error::GetPullRequestErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPullRequestApprovalStatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPullRequestApprovalStatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetPullRequestApprovalStatesErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::InvalidRevisionIdException(inner) => Error::InvalidRevisionIdException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::RevisionIdRequiredException(inner) => Error::RevisionIdRequiredException(inner),
                crate::error::GetPullRequestApprovalStatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetPullRequestOverrideStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetPullRequestOverrideStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetPullRequestOverrideStateErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::InvalidRevisionIdException(inner) => Error::InvalidRevisionIdException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::RevisionIdRequiredException(inner) => Error::RevisionIdRequiredException(inner),
                crate::error::GetPullRequestOverrideStateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRepositoryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetRepositoryError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetRepositoryErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetRepositoryErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::GetRepositoryErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::GetRepositoryErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::GetRepositoryErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::GetRepositoryErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::GetRepositoryErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::GetRepositoryErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::GetRepositoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRepositoryTriggersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRepositoryTriggersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::GetRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::GetRepositoryTriggersErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::GetRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::GetRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::GetRepositoryTriggersErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::GetRepositoryTriggersErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::GetRepositoryTriggersErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::GetRepositoryTriggersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListApprovalRuleTemplatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListApprovalRuleTemplatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListApprovalRuleTemplatesErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::ListApprovalRuleTemplatesErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::ListApprovalRuleTemplatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListBranchesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ListBranchesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListBranchesErrorKind::EncryptionIntegrityChecksFailedException(
                    inner,
                ) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::ListBranchesErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::ListBranchesErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::ListBranchesErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::ListBranchesErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::ListBranchesErrorKind::InvalidContinuationTokenException(inner) => {
                    Error::InvalidContinuationTokenException(inner)
                }
                crate::error::ListBranchesErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::ListBranchesErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::ListBranchesErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::ListBranchesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListPullRequestsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListPullRequestsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListPullRequestsErrorKind::AuthorDoesNotExistException(inner) => Error::AuthorDoesNotExistException(inner),
                crate::error::ListPullRequestsErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::ListPullRequestsErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::ListPullRequestsErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::ListPullRequestsErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::ListPullRequestsErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::ListPullRequestsErrorKind::InvalidAuthorArnException(inner) => Error::InvalidAuthorArnException(inner),
                crate::error::ListPullRequestsErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::ListPullRequestsErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::ListPullRequestsErrorKind::InvalidPullRequestStatusException(inner) => Error::InvalidPullRequestStatusException(inner),
                crate::error::ListPullRequestsErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::ListPullRequestsErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::ListPullRequestsErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::ListPullRequestsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListRepositoriesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListRepositoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListRepositoriesErrorKind::InvalidContinuationTokenException(
                    inner,
                ) => Error::InvalidContinuationTokenException(inner),
                crate::error::ListRepositoriesErrorKind::InvalidOrderException(inner) => {
                    Error::InvalidOrderException(inner)
                }
                crate::error::ListRepositoriesErrorKind::InvalidSortByException(inner) => {
                    Error::InvalidSortByException(inner)
                }
                crate::error::ListRepositoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::ListRepositoriesForApprovalRuleTemplateError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ListRepositoriesForApprovalRuleTemplateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidContinuationTokenException(inner) => Error::InvalidContinuationTokenException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidMaxResultsException(inner) => Error::InvalidMaxResultsException(inner),
                crate::error::ListRepositoriesForApprovalRuleTemplateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::InvalidRepositoryNameException(
                    inner,
                ) => Error::InvalidRepositoryNameException(inner),
                crate::error::ListTagsForResourceErrorKind::InvalidResourceArnException(inner) => {
                    Error::InvalidResourceArnException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::RepositoryDoesNotExistException(
                    inner,
                ) => Error::RepositoryDoesNotExistException(inner),
                crate::error::ListTagsForResourceErrorKind::ResourceArnRequiredException(inner) => {
                    Error::ResourceArnRequiredException(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MergeBranchesByFastForwardError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MergeBranchesByFastForwardError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::MergeBranchesByFastForwardErrorKind::BranchDoesNotExistException(inner) => Error::BranchDoesNotExistException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::BranchNameIsTagNameException(inner) => Error::BranchNameIsTagNameException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::BranchNameRequiredException(inner) => Error::BranchNameRequiredException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::ConcurrentReferenceUpdateException(inner) => Error::ConcurrentReferenceUpdateException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::InvalidBranchNameException(inner) => Error::InvalidBranchNameException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::InvalidTargetBranchException(inner) => Error::InvalidTargetBranchException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::ManualMergeRequiredException(inner) => Error::ManualMergeRequiredException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::MergeBranchesByFastForwardErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MergeBranchesBySquashError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MergeBranchesBySquashError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::MergeBranchesBySquashErrorKind::BranchDoesNotExistException(inner) => Error::BranchDoesNotExistException(inner),
                crate::error::MergeBranchesBySquashErrorKind::BranchNameIsTagNameException(inner) => Error::BranchNameIsTagNameException(inner),
                crate::error::MergeBranchesBySquashErrorKind::BranchNameRequiredException(inner) => Error::BranchNameRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::MergeBranchesBySquashErrorKind::CommitMessageLengthExceededException(inner) => Error::CommitMessageLengthExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::ConcurrentReferenceUpdateException(inner) => Error::ConcurrentReferenceUpdateException(inner),
                crate::error::MergeBranchesBySquashErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::MergeBranchesBySquashErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::MergeBranchesBySquashErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::MergeBranchesBySquashErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::MergeBranchesBySquashErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::MergeBranchesBySquashErrorKind::FileContentSizeLimitExceededException(inner) => Error::FileContentSizeLimitExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::FileModeRequiredException(inner) => Error::FileModeRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::FolderContentSizeLimitExceededException(inner) => Error::FolderContentSizeLimitExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidBranchNameException(inner) => Error::InvalidBranchNameException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidConflictResolutionException(inner) => Error::InvalidConflictResolutionException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidEmailException(inner) => Error::InvalidEmailException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidFileModeException(inner) => Error::InvalidFileModeException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidReplacementContentException(inner) => Error::InvalidReplacementContentException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidReplacementTypeException(inner) => Error::InvalidReplacementTypeException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::MergeBranchesBySquashErrorKind::InvalidTargetBranchException(inner) => Error::InvalidTargetBranchException(inner),
                crate::error::MergeBranchesBySquashErrorKind::ManualMergeRequiredException(inner) => Error::ManualMergeRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(inner) => Error::MaximumConflictResolutionEntriesExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::MultipleConflictResolutionEntriesException(inner) => Error::MultipleConflictResolutionEntriesException(inner),
                crate::error::MergeBranchesBySquashErrorKind::NameLengthExceededException(inner) => Error::NameLengthExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::ReplacementContentRequiredException(inner) => Error::ReplacementContentRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::ReplacementTypeRequiredException(inner) => Error::ReplacementTypeRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::MergeBranchesBySquashErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::MergeBranchesBySquashErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::MergeBranchesBySquashErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MergeBranchesByThreeWayError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MergeBranchesByThreeWayError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::MergeBranchesByThreeWayErrorKind::BranchDoesNotExistException(inner) => Error::BranchDoesNotExistException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::BranchNameIsTagNameException(inner) => Error::BranchNameIsTagNameException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::BranchNameRequiredException(inner) => Error::BranchNameRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::CommitMessageLengthExceededException(inner) => Error::CommitMessageLengthExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::CommitRequiredException(inner) => Error::CommitRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::ConcurrentReferenceUpdateException(inner) => Error::ConcurrentReferenceUpdateException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::FileContentSizeLimitExceededException(inner) => Error::FileContentSizeLimitExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::FileModeRequiredException(inner) => Error::FileModeRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::FolderContentSizeLimitExceededException(inner) => Error::FolderContentSizeLimitExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidBranchNameException(inner) => Error::InvalidBranchNameException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidCommitException(inner) => Error::InvalidCommitException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionException(inner) => Error::InvalidConflictResolutionException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidEmailException(inner) => Error::InvalidEmailException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidFileModeException(inner) => Error::InvalidFileModeException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidReplacementContentException(inner) => Error::InvalidReplacementContentException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidReplacementTypeException(inner) => Error::InvalidReplacementTypeException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::InvalidTargetBranchException(inner) => Error::InvalidTargetBranchException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::ManualMergeRequiredException(inner) => Error::ManualMergeRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(inner) => Error::MaximumConflictResolutionEntriesExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::MultipleConflictResolutionEntriesException(inner) => Error::MultipleConflictResolutionEntriesException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::NameLengthExceededException(inner) => Error::NameLengthExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::ReplacementContentRequiredException(inner) => Error::ReplacementContentRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::ReplacementTypeRequiredException(inner) => Error::ReplacementTypeRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::MergeBranchesByThreeWayErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MergePullRequestByFastForwardError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MergePullRequestByFastForwardError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::MergePullRequestByFastForwardErrorKind::ConcurrentReferenceUpdateException(inner) => Error::ConcurrentReferenceUpdateException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::InvalidCommitIdException(inner) => Error::InvalidCommitIdException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::ManualMergeRequiredException(inner) => Error::ManualMergeRequiredException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::PullRequestApprovalRulesNotSatisfiedException(inner) => Error::PullRequestApprovalRulesNotSatisfiedException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::ReferenceDoesNotExistException(inner) => Error::ReferenceDoesNotExistException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::RepositoryNotAssociatedWithPullRequestException(inner) => Error::RepositoryNotAssociatedWithPullRequestException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::TipOfSourceReferenceIsDifferentException(inner) => Error::TipOfSourceReferenceIsDifferentException(inner),
                crate::error::MergePullRequestByFastForwardErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MergePullRequestBySquashError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MergePullRequestBySquashError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::MergePullRequestBySquashErrorKind::CommitMessageLengthExceededException(inner) => Error::CommitMessageLengthExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::ConcurrentReferenceUpdateException(inner) => Error::ConcurrentReferenceUpdateException(inner),
                crate::error::MergePullRequestBySquashErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::MergePullRequestBySquashErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::MergePullRequestBySquashErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::MergePullRequestBySquashErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::MergePullRequestBySquashErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::MergePullRequestBySquashErrorKind::FileContentSizeLimitExceededException(inner) => Error::FileContentSizeLimitExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::FolderContentSizeLimitExceededException(inner) => Error::FolderContentSizeLimitExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidCommitIdException(inner) => Error::InvalidCommitIdException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidConflictResolutionException(inner) => Error::InvalidConflictResolutionException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidEmailException(inner) => Error::InvalidEmailException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidFileModeException(inner) => Error::InvalidFileModeException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidReplacementContentException(inner) => Error::InvalidReplacementContentException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidReplacementTypeException(inner) => Error::InvalidReplacementTypeException(inner),
                crate::error::MergePullRequestBySquashErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::MergePullRequestBySquashErrorKind::ManualMergeRequiredException(inner) => Error::ManualMergeRequiredException(inner),
                crate::error::MergePullRequestBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(inner) => Error::MaximumConflictResolutionEntriesExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::MultipleConflictResolutionEntriesException(inner) => Error::MultipleConflictResolutionEntriesException(inner),
                crate::error::MergePullRequestBySquashErrorKind::NameLengthExceededException(inner) => Error::NameLengthExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::MergePullRequestBySquashErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::MergePullRequestBySquashErrorKind::PullRequestApprovalRulesNotSatisfiedException(inner) => Error::PullRequestApprovalRulesNotSatisfiedException(inner),
                crate::error::MergePullRequestBySquashErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::MergePullRequestBySquashErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::MergePullRequestBySquashErrorKind::ReplacementContentRequiredException(inner) => Error::ReplacementContentRequiredException(inner),
                crate::error::MergePullRequestBySquashErrorKind::ReplacementTypeRequiredException(inner) => Error::ReplacementTypeRequiredException(inner),
                crate::error::MergePullRequestBySquashErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::MergePullRequestBySquashErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::MergePullRequestBySquashErrorKind::RepositoryNotAssociatedWithPullRequestException(inner) => Error::RepositoryNotAssociatedWithPullRequestException(inner),
                crate::error::MergePullRequestBySquashErrorKind::TipOfSourceReferenceIsDifferentException(inner) => Error::TipOfSourceReferenceIsDifferentException(inner),
                crate::error::MergePullRequestBySquashErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::MergePullRequestBySquashErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MergePullRequestByThreeWayError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MergePullRequestByThreeWayError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::MergePullRequestByThreeWayErrorKind::CommitMessageLengthExceededException(inner) => Error::CommitMessageLengthExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::ConcurrentReferenceUpdateException(inner) => Error::ConcurrentReferenceUpdateException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::FileContentSizeLimitExceededException(inner) => Error::FileContentSizeLimitExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::FolderContentSizeLimitExceededException(inner) => Error::FolderContentSizeLimitExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidCommitIdException(inner) => Error::InvalidCommitIdException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidConflictDetailLevelException(inner) => Error::InvalidConflictDetailLevelException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionException(inner) => Error::InvalidConflictResolutionException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionStrategyException(inner) => Error::InvalidConflictResolutionStrategyException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidEmailException(inner) => Error::InvalidEmailException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidFileModeException(inner) => Error::InvalidFileModeException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidReplacementContentException(inner) => Error::InvalidReplacementContentException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidReplacementTypeException(inner) => Error::InvalidReplacementTypeException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::ManualMergeRequiredException(inner) => Error::ManualMergeRequiredException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(inner) => Error::MaximumConflictResolutionEntriesExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::MaximumFileContentToLoadExceededException(inner) => Error::MaximumFileContentToLoadExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::MaximumItemsToCompareExceededException(inner) => Error::MaximumItemsToCompareExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::MultipleConflictResolutionEntriesException(inner) => Error::MultipleConflictResolutionEntriesException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::NameLengthExceededException(inner) => Error::NameLengthExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::PullRequestApprovalRulesNotSatisfiedException(inner) => Error::PullRequestApprovalRulesNotSatisfiedException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::ReplacementContentRequiredException(inner) => Error::ReplacementContentRequiredException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::ReplacementTypeRequiredException(inner) => Error::ReplacementTypeRequiredException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::RepositoryNotAssociatedWithPullRequestException(inner) => Error::RepositoryNotAssociatedWithPullRequestException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::TipOfSourceReferenceIsDifferentException(inner) => Error::TipOfSourceReferenceIsDifferentException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::TipsDivergenceExceededException(inner) => Error::TipsDivergenceExceededException(inner),
                crate::error::MergePullRequestByThreeWayErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::OverridePullRequestApprovalRulesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::OverridePullRequestApprovalRulesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::OverridePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::InvalidOverrideStatusException(inner) => Error::InvalidOverrideStatusException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(inner) => Error::InvalidRevisionIdException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::OverrideAlreadySetException(inner) => Error::OverrideAlreadySetException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::OverrideStatusRequiredException(inner) => Error::OverrideStatusRequiredException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(inner) => Error::RevisionIdRequiredException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(inner) => Error::RevisionNotCurrentException(inner),
                crate::error::OverridePullRequestApprovalRulesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PostCommentForComparedCommitError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PostCommentForComparedCommitError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PostCommentForComparedCommitErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(inner) => Error::BeforeCommitIdAndAfterCommitIdAreSameException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::ClientRequestTokenRequiredException(inner) => Error::ClientRequestTokenRequiredException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::CommentContentRequiredException(inner) => Error::CommentContentRequiredException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::CommentContentSizeLimitExceededException(inner) => Error::CommentContentSizeLimitExceededException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::CommitIdRequiredException(inner) => Error::CommitIdRequiredException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::IdempotencyParameterMismatchException(inner) => Error::IdempotencyParameterMismatchException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::InvalidClientRequestTokenException(inner) => Error::InvalidClientRequestTokenException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::InvalidCommitIdException(inner) => Error::InvalidCommitIdException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::InvalidFileLocationException(inner) => Error::InvalidFileLocationException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::InvalidFilePositionException(inner) => Error::InvalidFilePositionException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::InvalidRelativeFileVersionEnumException(inner) => Error::InvalidRelativeFileVersionEnumException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::PathDoesNotExistException(inner) => Error::PathDoesNotExistException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::PostCommentForComparedCommitErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PostCommentForPullRequestError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PostCommentForPullRequestError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PostCommentForPullRequestErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(inner) => Error::BeforeCommitIdAndAfterCommitIdAreSameException(inner),
                crate::error::PostCommentForPullRequestErrorKind::ClientRequestTokenRequiredException(inner) => Error::ClientRequestTokenRequiredException(inner),
                crate::error::PostCommentForPullRequestErrorKind::CommentContentRequiredException(inner) => Error::CommentContentRequiredException(inner),
                crate::error::PostCommentForPullRequestErrorKind::CommentContentSizeLimitExceededException(inner) => Error::CommentContentSizeLimitExceededException(inner),
                crate::error::PostCommentForPullRequestErrorKind::CommitDoesNotExistException(inner) => Error::CommitDoesNotExistException(inner),
                crate::error::PostCommentForPullRequestErrorKind::CommitIdRequiredException(inner) => Error::CommitIdRequiredException(inner),
                crate::error::PostCommentForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::PostCommentForPullRequestErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::PostCommentForPullRequestErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::PostCommentForPullRequestErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::PostCommentForPullRequestErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::PostCommentForPullRequestErrorKind::IdempotencyParameterMismatchException(inner) => Error::IdempotencyParameterMismatchException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidClientRequestTokenException(inner) => Error::InvalidClientRequestTokenException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidCommitIdException(inner) => Error::InvalidCommitIdException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidFileLocationException(inner) => Error::InvalidFileLocationException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidFilePositionException(inner) => Error::InvalidFilePositionException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidPathException(inner) => Error::InvalidPathException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidRelativeFileVersionEnumException(inner) => Error::InvalidRelativeFileVersionEnumException(inner),
                crate::error::PostCommentForPullRequestErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::PostCommentForPullRequestErrorKind::PathDoesNotExistException(inner) => Error::PathDoesNotExistException(inner),
                crate::error::PostCommentForPullRequestErrorKind::PathRequiredException(inner) => Error::PathRequiredException(inner),
                crate::error::PostCommentForPullRequestErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::PostCommentForPullRequestErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::PostCommentForPullRequestErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::PostCommentForPullRequestErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::PostCommentForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(inner) => Error::RepositoryNotAssociatedWithPullRequestException(inner),
                crate::error::PostCommentForPullRequestErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PostCommentReplyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PostCommentReplyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PostCommentReplyErrorKind::ClientRequestTokenRequiredException(inner) => Error::ClientRequestTokenRequiredException(inner),
                crate::error::PostCommentReplyErrorKind::CommentContentRequiredException(inner) => Error::CommentContentRequiredException(inner),
                crate::error::PostCommentReplyErrorKind::CommentContentSizeLimitExceededException(inner) => Error::CommentContentSizeLimitExceededException(inner),
                crate::error::PostCommentReplyErrorKind::CommentDoesNotExistException(inner) => Error::CommentDoesNotExistException(inner),
                crate::error::PostCommentReplyErrorKind::CommentIdRequiredException(inner) => Error::CommentIdRequiredException(inner),
                crate::error::PostCommentReplyErrorKind::IdempotencyParameterMismatchException(inner) => Error::IdempotencyParameterMismatchException(inner),
                crate::error::PostCommentReplyErrorKind::InvalidClientRequestTokenException(inner) => Error::InvalidClientRequestTokenException(inner),
                crate::error::PostCommentReplyErrorKind::InvalidCommentIdException(inner) => Error::InvalidCommentIdException(inner),
                crate::error::PostCommentReplyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutCommentReactionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutCommentReactionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutCommentReactionErrorKind::CommentDeletedException(inner) => {
                    Error::CommentDeletedException(inner)
                }
                crate::error::PutCommentReactionErrorKind::CommentDoesNotExistException(inner) => {
                    Error::CommentDoesNotExistException(inner)
                }
                crate::error::PutCommentReactionErrorKind::CommentIdRequiredException(inner) => {
                    Error::CommentIdRequiredException(inner)
                }
                crate::error::PutCommentReactionErrorKind::InvalidCommentIdException(inner) => {
                    Error::InvalidCommentIdException(inner)
                }
                crate::error::PutCommentReactionErrorKind::InvalidReactionValueException(inner) => {
                    Error::InvalidReactionValueException(inner)
                }
                crate::error::PutCommentReactionErrorKind::ReactionLimitExceededException(
                    inner,
                ) => Error::ReactionLimitExceededException(inner),
                crate::error::PutCommentReactionErrorKind::ReactionValueRequiredException(
                    inner,
                ) => Error::ReactionValueRequiredException(inner),
                crate::error::PutCommentReactionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutFileError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutFileError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutFileErrorKind::BranchDoesNotExistException(inner) => {
                    Error::BranchDoesNotExistException(inner)
                }
                crate::error::PutFileErrorKind::BranchNameIsTagNameException(inner) => {
                    Error::BranchNameIsTagNameException(inner)
                }
                crate::error::PutFileErrorKind::BranchNameRequiredException(inner) => {
                    Error::BranchNameRequiredException(inner)
                }
                crate::error::PutFileErrorKind::CommitMessageLengthExceededException(inner) => {
                    Error::CommitMessageLengthExceededException(inner)
                }
                crate::error::PutFileErrorKind::DirectoryNameConflictsWithFileNameException(
                    inner,
                ) => Error::DirectoryNameConflictsWithFileNameException(inner),
                crate::error::PutFileErrorKind::EncryptionIntegrityChecksFailedException(inner) => {
                    Error::EncryptionIntegrityChecksFailedException(inner)
                }
                crate::error::PutFileErrorKind::EncryptionKeyAccessDeniedException(inner) => {
                    Error::EncryptionKeyAccessDeniedException(inner)
                }
                crate::error::PutFileErrorKind::EncryptionKeyDisabledException(inner) => {
                    Error::EncryptionKeyDisabledException(inner)
                }
                crate::error::PutFileErrorKind::EncryptionKeyNotFoundException(inner) => {
                    Error::EncryptionKeyNotFoundException(inner)
                }
                crate::error::PutFileErrorKind::EncryptionKeyUnavailableException(inner) => {
                    Error::EncryptionKeyUnavailableException(inner)
                }
                crate::error::PutFileErrorKind::FileContentRequiredException(inner) => {
                    Error::FileContentRequiredException(inner)
                }
                crate::error::PutFileErrorKind::FileContentSizeLimitExceededException(inner) => {
                    Error::FileContentSizeLimitExceededException(inner)
                }
                crate::error::PutFileErrorKind::FileNameConflictsWithDirectoryNameException(
                    inner,
                ) => Error::FileNameConflictsWithDirectoryNameException(inner),
                crate::error::PutFileErrorKind::FilePathConflictsWithSubmodulePathException(
                    inner,
                ) => Error::FilePathConflictsWithSubmodulePathException(inner),
                crate::error::PutFileErrorKind::FolderContentSizeLimitExceededException(inner) => {
                    Error::FolderContentSizeLimitExceededException(inner)
                }
                crate::error::PutFileErrorKind::InvalidBranchNameException(inner) => {
                    Error::InvalidBranchNameException(inner)
                }
                crate::error::PutFileErrorKind::InvalidDeletionParameterException(inner) => {
                    Error::InvalidDeletionParameterException(inner)
                }
                crate::error::PutFileErrorKind::InvalidEmailException(inner) => {
                    Error::InvalidEmailException(inner)
                }
                crate::error::PutFileErrorKind::InvalidFileModeException(inner) => {
                    Error::InvalidFileModeException(inner)
                }
                crate::error::PutFileErrorKind::InvalidParentCommitIdException(inner) => {
                    Error::InvalidParentCommitIdException(inner)
                }
                crate::error::PutFileErrorKind::InvalidPathException(inner) => {
                    Error::InvalidPathException(inner)
                }
                crate::error::PutFileErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::PutFileErrorKind::NameLengthExceededException(inner) => {
                    Error::NameLengthExceededException(inner)
                }
                crate::error::PutFileErrorKind::ParentCommitDoesNotExistException(inner) => {
                    Error::ParentCommitDoesNotExistException(inner)
                }
                crate::error::PutFileErrorKind::ParentCommitIdOutdatedException(inner) => {
                    Error::ParentCommitIdOutdatedException(inner)
                }
                crate::error::PutFileErrorKind::ParentCommitIdRequiredException(inner) => {
                    Error::ParentCommitIdRequiredException(inner)
                }
                crate::error::PutFileErrorKind::PathRequiredException(inner) => {
                    Error::PathRequiredException(inner)
                }
                crate::error::PutFileErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::PutFileErrorKind::RepositoryNameRequiredException(inner) => {
                    Error::RepositoryNameRequiredException(inner)
                }
                crate::error::PutFileErrorKind::SameFileContentException(inner) => {
                    Error::SameFileContentException(inner)
                }
                crate::error::PutFileErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutRepositoryTriggersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutRepositoryTriggersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PutRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::PutRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::PutRepositoryTriggersErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::PutRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::PutRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::PutRepositoryTriggersErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(inner) => Error::InvalidRepositoryTriggerBranchNameException(inner),
                crate::error::PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(inner) => Error::InvalidRepositoryTriggerCustomDataException(inner),
                crate::error::PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(inner) => Error::InvalidRepositoryTriggerDestinationArnException(inner),
                crate::error::PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(inner) => Error::InvalidRepositoryTriggerEventsException(inner),
                crate::error::PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(inner) => Error::InvalidRepositoryTriggerNameException(inner),
                crate::error::PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(inner) => Error::InvalidRepositoryTriggerRegionException(inner),
                crate::error::PutRepositoryTriggersErrorKind::MaximumBranchesExceededException(inner) => Error::MaximumBranchesExceededException(inner),
                crate::error::PutRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(inner) => Error::MaximumRepositoryTriggersExceededException(inner),
                crate::error::PutRepositoryTriggersErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::PutRepositoryTriggersErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::PutRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(inner) => Error::RepositoryTriggerBranchNameListRequiredException(inner),
                crate::error::PutRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(inner) => Error::RepositoryTriggerDestinationArnRequiredException(inner),
                crate::error::PutRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(inner) => Error::RepositoryTriggerEventsListRequiredException(inner),
                crate::error::PutRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(inner) => Error::RepositoryTriggerNameRequiredException(inner),
                crate::error::PutRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(inner) => Error::RepositoryTriggersListRequiredException(inner),
                crate::error::PutRepositoryTriggersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidResourceArnException(inner) => {
                    Error::InvalidResourceArnException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidSystemTagUsageException(inner) => {
                    Error::InvalidSystemTagUsageException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidTagsMapException(inner) => {
                    Error::InvalidTagsMapException(inner)
                }
                crate::error::TagResourceErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::TagResourceErrorKind::ResourceArnRequiredException(inner) => {
                    Error::ResourceArnRequiredException(inner)
                }
                crate::error::TagResourceErrorKind::TagPolicyException(inner) => {
                    Error::TagPolicyException(inner)
                }
                crate::error::TagResourceErrorKind::TagsMapRequiredException(inner) => {
                    Error::TagsMapRequiredException(inner)
                }
                crate::error::TagResourceErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TestRepositoryTriggersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::TestRepositoryTriggersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::TestRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::TestRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::TestRepositoryTriggersErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::TestRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::TestRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::TestRepositoryTriggersErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(inner) => Error::InvalidRepositoryTriggerBranchNameException(inner),
                crate::error::TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(inner) => Error::InvalidRepositoryTriggerCustomDataException(inner),
                crate::error::TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(inner) => Error::InvalidRepositoryTriggerDestinationArnException(inner),
                crate::error::TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(inner) => Error::InvalidRepositoryTriggerEventsException(inner),
                crate::error::TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(inner) => Error::InvalidRepositoryTriggerNameException(inner),
                crate::error::TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(inner) => Error::InvalidRepositoryTriggerRegionException(inner),
                crate::error::TestRepositoryTriggersErrorKind::MaximumBranchesExceededException(inner) => Error::MaximumBranchesExceededException(inner),
                crate::error::TestRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(inner) => Error::MaximumRepositoryTriggersExceededException(inner),
                crate::error::TestRepositoryTriggersErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::TestRepositoryTriggersErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::TestRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(inner) => Error::RepositoryTriggerBranchNameListRequiredException(inner),
                crate::error::TestRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(inner) => Error::RepositoryTriggerDestinationArnRequiredException(inner),
                crate::error::TestRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(inner) => Error::RepositoryTriggerEventsListRequiredException(inner),
                crate::error::TestRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(inner) => Error::RepositoryTriggerNameRequiredException(inner),
                crate::error::TestRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(inner) => Error::RepositoryTriggersListRequiredException(inner),
                crate::error::TestRepositoryTriggersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::InvalidRepositoryNameException(inner) => {
                    Error::InvalidRepositoryNameException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidResourceArnException(inner) => {
                    Error::InvalidResourceArnException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidSystemTagUsageException(inner) => {
                    Error::InvalidSystemTagUsageException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidTagKeysListException(inner) => {
                    Error::InvalidTagKeysListException(inner)
                }
                crate::error::UntagResourceErrorKind::RepositoryDoesNotExistException(inner) => {
                    Error::RepositoryDoesNotExistException(inner)
                }
                crate::error::UntagResourceErrorKind::ResourceArnRequiredException(inner) => {
                    Error::ResourceArnRequiredException(inner)
                }
                crate::error::UntagResourceErrorKind::TagKeysListRequiredException(inner) => {
                    Error::TagKeysListRequiredException(inner)
                }
                crate::error::UntagResourceErrorKind::TagPolicyException(inner) => {
                    Error::TagPolicyException(inner)
                }
                crate::error::UntagResourceErrorKind::TooManyTagsException(inner) => {
                    Error::TooManyTagsException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateApprovalRuleTemplateContentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateApprovalRuleTemplateContentError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateContentRequiredException(inner) => Error::ApprovalRuleTemplateContentRequiredException(inner),
                crate::error::UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateContentException(inner) => Error::InvalidApprovalRuleTemplateContentException(inner),
                crate::error::UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::UpdateApprovalRuleTemplateContentErrorKind::InvalidRuleContentSha256Exception(inner) => Error::InvalidRuleContentSha256Exception(inner),
                crate::error::UpdateApprovalRuleTemplateContentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::UpdateApprovalRuleTemplateDescriptionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateApprovalRuleTemplateDescriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateDescriptionException(inner) => Error::InvalidApprovalRuleTemplateDescriptionException(inner),
                crate::error::UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::UpdateApprovalRuleTemplateDescriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdateApprovalRuleTemplateNameError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateApprovalRuleTemplateNameError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateDoesNotExistException(inner) => Error::ApprovalRuleTemplateDoesNotExistException(inner),
                crate::error::UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(inner) => Error::ApprovalRuleTemplateNameAlreadyExistsException(inner),
                crate::error::UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameRequiredException(inner) => Error::ApprovalRuleTemplateNameRequiredException(inner),
                crate::error::UpdateApprovalRuleTemplateNameErrorKind::InvalidApprovalRuleTemplateNameException(inner) => Error::InvalidApprovalRuleTemplateNameException(inner),
                crate::error::UpdateApprovalRuleTemplateNameErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateCommentError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateCommentError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateCommentErrorKind::CommentContentRequiredException(inner) => {
                    Error::CommentContentRequiredException(inner)
                }
                crate::error::UpdateCommentErrorKind::CommentContentSizeLimitExceededException(
                    inner,
                ) => Error::CommentContentSizeLimitExceededException(inner),
                crate::error::UpdateCommentErrorKind::CommentDeletedException(inner) => {
                    Error::CommentDeletedException(inner)
                }
                crate::error::UpdateCommentErrorKind::CommentDoesNotExistException(inner) => {
                    Error::CommentDoesNotExistException(inner)
                }
                crate::error::UpdateCommentErrorKind::CommentIdRequiredException(inner) => {
                    Error::CommentIdRequiredException(inner)
                }
                crate::error::UpdateCommentErrorKind::CommentNotCreatedByCallerException(inner) => {
                    Error::CommentNotCreatedByCallerException(inner)
                }
                crate::error::UpdateCommentErrorKind::InvalidCommentIdException(inner) => {
                    Error::InvalidCommentIdException(inner)
                }
                crate::error::UpdateCommentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDefaultBranchError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDefaultBranchError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateDefaultBranchErrorKind::BranchDoesNotExistException(inner) => Error::BranchDoesNotExistException(inner),
                crate::error::UpdateDefaultBranchErrorKind::BranchNameRequiredException(inner) => Error::BranchNameRequiredException(inner),
                crate::error::UpdateDefaultBranchErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::UpdateDefaultBranchErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::UpdateDefaultBranchErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::UpdateDefaultBranchErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::UpdateDefaultBranchErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::UpdateDefaultBranchErrorKind::InvalidBranchNameException(inner) => Error::InvalidBranchNameException(inner),
                crate::error::UpdateDefaultBranchErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::UpdateDefaultBranchErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::UpdateDefaultBranchErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::UpdateDefaultBranchErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::UpdatePullRequestApprovalRuleContentError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdatePullRequestApprovalRuleContentError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleContentRequiredException(inner) => Error::ApprovalRuleContentRequiredException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleDoesNotExistException(inner) => Error::ApprovalRuleDoesNotExistException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleNameRequiredException(inner) => Error::ApprovalRuleNameRequiredException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::CannotModifyApprovalRuleFromTemplateException(inner) => Error::CannotModifyApprovalRuleFromTemplateException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleContentException(inner) => Error::InvalidApprovalRuleContentException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleNameException(inner) => Error::InvalidApprovalRuleNameException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::InvalidRuleContentSha256Exception(inner) => Error::InvalidRuleContentSha256Exception(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::UpdatePullRequestApprovalRuleContentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestApprovalStateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdatePullRequestApprovalStateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdatePullRequestApprovalStateErrorKind::ApprovalStateRequiredException(inner) => Error::ApprovalStateRequiredException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::InvalidApprovalStateException(inner) => Error::InvalidApprovalStateException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::InvalidRevisionIdException(inner) => Error::InvalidRevisionIdException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::MaximumNumberOfApprovalsExceededException(inner) => Error::MaximumNumberOfApprovalsExceededException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::PullRequestCannotBeApprovedByAuthorException(inner) => Error::PullRequestCannotBeApprovedByAuthorException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::RevisionIdRequiredException(inner) => Error::RevisionIdRequiredException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::RevisionNotCurrentException(inner) => Error::RevisionNotCurrentException(inner),
                crate::error::UpdatePullRequestApprovalStateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestDescriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestDescriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdatePullRequestDescriptionErrorKind::InvalidDescriptionException(inner) => Error::InvalidDescriptionException(inner),
                crate::error::UpdatePullRequestDescriptionErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::UpdatePullRequestDescriptionErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::UpdatePullRequestDescriptionErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::UpdatePullRequestDescriptionErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::UpdatePullRequestDescriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdatePullRequestStatusErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::InvalidPullRequestStatusException(inner) => Error::InvalidPullRequestStatusException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::InvalidPullRequestStatusUpdateException(inner) => Error::InvalidPullRequestStatusUpdateException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::PullRequestStatusRequiredException(inner) => Error::PullRequestStatusRequiredException(inner),
                crate::error::UpdatePullRequestStatusErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestTitleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdatePullRequestTitleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdatePullRequestTitleErrorKind::InvalidPullRequestIdException(inner) => Error::InvalidPullRequestIdException(inner),
                crate::error::UpdatePullRequestTitleErrorKind::InvalidTitleException(inner) => Error::InvalidTitleException(inner),
                crate::error::UpdatePullRequestTitleErrorKind::PullRequestAlreadyClosedException(inner) => Error::PullRequestAlreadyClosedException(inner),
                crate::error::UpdatePullRequestTitleErrorKind::PullRequestDoesNotExistException(inner) => Error::PullRequestDoesNotExistException(inner),
                crate::error::UpdatePullRequestTitleErrorKind::PullRequestIdRequiredException(inner) => Error::PullRequestIdRequiredException(inner),
                crate::error::UpdatePullRequestTitleErrorKind::TitleRequiredException(inner) => Error::TitleRequiredException(inner),
                crate::error::UpdatePullRequestTitleErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryDescriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryDescriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateRepositoryDescriptionErrorKind::EncryptionIntegrityChecksFailedException(inner) => Error::EncryptionIntegrityChecksFailedException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::EncryptionKeyAccessDeniedException(inner) => Error::EncryptionKeyAccessDeniedException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::EncryptionKeyDisabledException(inner) => Error::EncryptionKeyDisabledException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::EncryptionKeyNotFoundException(inner) => Error::EncryptionKeyNotFoundException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::EncryptionKeyUnavailableException(inner) => Error::EncryptionKeyUnavailableException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::InvalidRepositoryDescriptionException(inner) => Error::InvalidRepositoryDescriptionException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::InvalidRepositoryNameException(inner) => Error::InvalidRepositoryNameException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::RepositoryDoesNotExistException(inner) => Error::RepositoryDoesNotExistException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::RepositoryNameRequiredException(inner) => Error::RepositoryNameRequiredException(inner),
                crate::error::UpdateRepositoryDescriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryNameError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryNameError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateRepositoryNameErrorKind::InvalidRepositoryNameException(
                    inner,
                ) => Error::InvalidRepositoryNameException(inner),
                crate::error::UpdateRepositoryNameErrorKind::RepositoryDoesNotExistException(
                    inner,
                ) => Error::RepositoryDoesNotExistException(inner),
                crate::error::UpdateRepositoryNameErrorKind::RepositoryNameExistsException(
                    inner,
                ) => Error::RepositoryNameExistsException(inner),
                crate::error::UpdateRepositoryNameErrorKind::RepositoryNameRequiredException(
                    inner,
                ) => Error::RepositoryNameRequiredException(inner),
                crate::error::UpdateRepositoryNameErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
