// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Returns information about a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullRequest {
    /// <p>The system-generated ID of the pull request. </p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The user-defined title of the pull request. This title is displayed in the list of
    /// pull requests to other repository users.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The user-defined description of the pull request. This description can be used to clarify what should be reviewed and other details of the request.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The day and time of the last user or system activity on the pull request, in timestamp format.</p>
    pub last_activity_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the pull request was originally created, in timestamp format.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the pull request. Pull request status can only change from <code>OPEN</code> to <code>CLOSED</code>.</p>
    pub pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
    /// <p>The Amazon Resource Name (ARN) of the user who created the pull request.</p>
    pub author_arn: std::option::Option<std::string::String>,
    /// <p>The targets of the pull request, including the source branch and destination branch for the pull request.</p>
    pub pull_request_targets: std::option::Option<std::vec::Vec<crate::model::PullRequestTarget>>,
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
    /// the request cannot be repeated with a changed parameter. If a request is received with
    /// the same parameters and a token is included, the request returns information about the
    /// initial request that used that token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The system-generated revision ID for the pull request.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The approval rules applied to the pull request.</p>
    pub approval_rules: std::option::Option<std::vec::Vec<crate::model::ApprovalRule>>,
}
impl PullRequest {
    /// <p>The system-generated ID of the pull request. </p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The user-defined title of the pull request. This title is displayed in the list of
    /// pull requests to other repository users.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The user-defined description of the pull request. This description can be used to clarify what should be reviewed and other details of the request.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The day and time of the last user or system activity on the pull request, in timestamp format.</p>
    pub fn last_activity_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_activity_date.as_ref()
    }
    /// <p>The date and time the pull request was originally created, in timestamp format.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The status of the pull request. Pull request status can only change from <code>OPEN</code> to <code>CLOSED</code>.</p>
    pub fn pull_request_status(&self) -> std::option::Option<&crate::model::PullRequestStatusEnum> {
        self.pull_request_status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user who created the pull request.</p>
    pub fn author_arn(&self) -> std::option::Option<&str> {
        self.author_arn.as_deref()
    }
    /// <p>The targets of the pull request, including the source branch and destination branch for the pull request.</p>
    pub fn pull_request_targets(&self) -> std::option::Option<&[crate::model::PullRequestTarget]> {
        self.pull_request_targets.as_deref()
    }
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
    /// the request cannot be repeated with a changed parameter. If a request is received with
    /// the same parameters and a token is included, the request returns information about the
    /// initial request that used that token.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The system-generated revision ID for the pull request.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The approval rules applied to the pull request.</p>
    pub fn approval_rules(&self) -> std::option::Option<&[crate::model::ApprovalRule]> {
        self.approval_rules.as_deref()
    }
}
impl std::fmt::Debug for PullRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullRequest");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("title", &self.title);
        formatter.field("description", &self.description);
        formatter.field("last_activity_date", &self.last_activity_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("pull_request_status", &self.pull_request_status);
        formatter.field("author_arn", &self.author_arn);
        formatter.field("pull_request_targets", &self.pull_request_targets);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("revision_id", &self.revision_id);
        formatter.field("approval_rules", &self.approval_rules);
        formatter.finish()
    }
}
/// See [`PullRequest`](crate::model::PullRequest)
pub mod pull_request {
    /// A builder for [`PullRequest`](crate::model::PullRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_activity_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
        pub(crate) author_arn: std::option::Option<std::string::String>,
        pub(crate) pull_request_targets:
            std::option::Option<std::vec::Vec<crate::model::PullRequestTarget>>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) approval_rules: std::option::Option<std::vec::Vec<crate::model::ApprovalRule>>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request. </p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. </p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The user-defined title of the pull request. This title is displayed in the list of
        /// pull requests to other repository users.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The user-defined title of the pull request. This title is displayed in the list of
        /// pull requests to other repository users.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The user-defined description of the pull request. This description can be used to clarify what should be reviewed and other details of the request.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The user-defined description of the pull request. This description can be used to clarify what should be reviewed and other details of the request.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The day and time of the last user or system activity on the pull request, in timestamp format.</p>
        pub fn last_activity_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_activity_date = Some(input);
            self
        }
        /// <p>The day and time of the last user or system activity on the pull request, in timestamp format.</p>
        pub fn set_last_activity_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_activity_date = input;
            self
        }
        /// <p>The date and time the pull request was originally created, in timestamp format.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time the pull request was originally created, in timestamp format.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The status of the pull request. Pull request status can only change from <code>OPEN</code> to <code>CLOSED</code>.</p>
        pub fn pull_request_status(mut self, input: crate::model::PullRequestStatusEnum) -> Self {
            self.pull_request_status = Some(input);
            self
        }
        /// <p>The status of the pull request. Pull request status can only change from <code>OPEN</code> to <code>CLOSED</code>.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.pull_request_status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the pull request.</p>
        pub fn author_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who created the pull request.</p>
        pub fn set_author_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_arn = input;
            self
        }
        /// Appends an item to `pull_request_targets`.
        ///
        /// To override the contents of this collection use [`set_pull_request_targets`](Self::set_pull_request_targets).
        ///
        /// <p>The targets of the pull request, including the source branch and destination branch for the pull request.</p>
        pub fn pull_request_targets(
            mut self,
            input: impl Into<crate::model::PullRequestTarget>,
        ) -> Self {
            let mut v = self.pull_request_targets.unwrap_or_default();
            v.push(input.into());
            self.pull_request_targets = Some(v);
            self
        }
        /// <p>The targets of the pull request, including the source branch and destination branch for the pull request.</p>
        pub fn set_pull_request_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PullRequestTarget>>,
        ) -> Self {
            self.pull_request_targets = input;
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The system-generated revision ID for the pull request.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The system-generated revision ID for the pull request.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// Appends an item to `approval_rules`.
        ///
        /// To override the contents of this collection use [`set_approval_rules`](Self::set_approval_rules).
        ///
        /// <p>The approval rules applied to the pull request.</p>
        pub fn approval_rules(mut self, input: impl Into<crate::model::ApprovalRule>) -> Self {
            let mut v = self.approval_rules.unwrap_or_default();
            v.push(input.into());
            self.approval_rules = Some(v);
            self
        }
        /// <p>The approval rules applied to the pull request.</p>
        pub fn set_approval_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ApprovalRule>>,
        ) -> Self {
            self.approval_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`PullRequest`](crate::model::PullRequest)
        pub fn build(self) -> crate::model::PullRequest {
            crate::model::PullRequest {
                pull_request_id: self.pull_request_id,
                title: self.title,
                description: self.description,
                last_activity_date: self.last_activity_date,
                creation_date: self.creation_date,
                pull_request_status: self.pull_request_status,
                author_arn: self.author_arn,
                pull_request_targets: self.pull_request_targets,
                client_request_token: self.client_request_token,
                revision_id: self.revision_id,
                approval_rules: self.approval_rules,
            }
        }
    }
}
impl PullRequest {
    /// Creates a new builder-style object to manufacture [`PullRequest`](crate::model::PullRequest)
    pub fn builder() -> crate::model::pull_request::Builder {
        crate::model::pull_request::Builder::default()
    }
}

/// <p>Returns information about an approval rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalRule {
    /// <p>The system-generated ID of the approval rule.</p>
    pub approval_rule_id: std::option::Option<std::string::String>,
    /// <p>The name of the approval rule.</p>
    pub approval_rule_name: std::option::Option<std::string::String>,
    /// <p>The content of the approval rule.</p>
    pub approval_rule_content: std::option::Option<std::string::String>,
    /// <p>The SHA-256 hash signature for the content of the approval rule.</p>
    pub rule_content_sha256: std::option::Option<std::string::String>,
    /// <p>The date the approval rule was most recently changed, in timestamp format.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the approval rule was created, in timestamp format.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.</p>
    pub last_modified_user: std::option::Option<std::string::String>,
    /// <p>The approval rule template used to create the rule.</p>
    pub origin_approval_rule_template:
        std::option::Option<crate::model::OriginApprovalRuleTemplate>,
}
impl ApprovalRule {
    /// <p>The system-generated ID of the approval rule.</p>
    pub fn approval_rule_id(&self) -> std::option::Option<&str> {
        self.approval_rule_id.as_deref()
    }
    /// <p>The name of the approval rule.</p>
    pub fn approval_rule_name(&self) -> std::option::Option<&str> {
        self.approval_rule_name.as_deref()
    }
    /// <p>The content of the approval rule.</p>
    pub fn approval_rule_content(&self) -> std::option::Option<&str> {
        self.approval_rule_content.as_deref()
    }
    /// <p>The SHA-256 hash signature for the content of the approval rule.</p>
    pub fn rule_content_sha256(&self) -> std::option::Option<&str> {
        self.rule_content_sha256.as_deref()
    }
    /// <p>The date the approval rule was most recently changed, in timestamp format.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the approval rule was created, in timestamp format.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.</p>
    pub fn last_modified_user(&self) -> std::option::Option<&str> {
        self.last_modified_user.as_deref()
    }
    /// <p>The approval rule template used to create the rule.</p>
    pub fn origin_approval_rule_template(
        &self,
    ) -> std::option::Option<&crate::model::OriginApprovalRuleTemplate> {
        self.origin_approval_rule_template.as_ref()
    }
}
impl std::fmt::Debug for ApprovalRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalRule");
        formatter.field("approval_rule_id", &self.approval_rule_id);
        formatter.field("approval_rule_name", &self.approval_rule_name);
        formatter.field("approval_rule_content", &self.approval_rule_content);
        formatter.field("rule_content_sha256", &self.rule_content_sha256);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_user", &self.last_modified_user);
        formatter.field(
            "origin_approval_rule_template",
            &self.origin_approval_rule_template,
        );
        formatter.finish()
    }
}
/// See [`ApprovalRule`](crate::model::ApprovalRule)
pub mod approval_rule {
    /// A builder for [`ApprovalRule`](crate::model::ApprovalRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_id: std::option::Option<std::string::String>,
        pub(crate) approval_rule_name: std::option::Option<std::string::String>,
        pub(crate) approval_rule_content: std::option::Option<std::string::String>,
        pub(crate) rule_content_sha256: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_user: std::option::Option<std::string::String>,
        pub(crate) origin_approval_rule_template:
            std::option::Option<crate::model::OriginApprovalRuleTemplate>,
    }
    impl Builder {
        /// <p>The system-generated ID of the approval rule.</p>
        pub fn approval_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the approval rule.</p>
        pub fn set_approval_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_id = input;
            self
        }
        /// <p>The name of the approval rule.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_name = input;
            self
        }
        /// <p>The content of the approval rule.</p>
        pub fn approval_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_content = Some(input.into());
            self
        }
        /// <p>The content of the approval rule.</p>
        pub fn set_approval_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_content = input;
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule.</p>
        pub fn rule_content_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_content_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule.</p>
        pub fn set_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_content_sha256 = input;
            self
        }
        /// <p>The date the approval rule was most recently changed, in timestamp format.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the approval rule was most recently changed, in timestamp format.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the approval rule was created, in timestamp format.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the approval rule was created, in timestamp format.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.</p>
        pub fn last_modified_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_user = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.</p>
        pub fn set_last_modified_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_user = input;
            self
        }
        /// <p>The approval rule template used to create the rule.</p>
        pub fn origin_approval_rule_template(
            mut self,
            input: crate::model::OriginApprovalRuleTemplate,
        ) -> Self {
            self.origin_approval_rule_template = Some(input);
            self
        }
        /// <p>The approval rule template used to create the rule.</p>
        pub fn set_origin_approval_rule_template(
            mut self,
            input: std::option::Option<crate::model::OriginApprovalRuleTemplate>,
        ) -> Self {
            self.origin_approval_rule_template = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalRule`](crate::model::ApprovalRule)
        pub fn build(self) -> crate::model::ApprovalRule {
            crate::model::ApprovalRule {
                approval_rule_id: self.approval_rule_id,
                approval_rule_name: self.approval_rule_name,
                approval_rule_content: self.approval_rule_content,
                rule_content_sha256: self.rule_content_sha256,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
                last_modified_user: self.last_modified_user,
                origin_approval_rule_template: self.origin_approval_rule_template,
            }
        }
    }
}
impl ApprovalRule {
    /// Creates a new builder-style object to manufacture [`ApprovalRule`](crate::model::ApprovalRule)
    pub fn builder() -> crate::model::approval_rule::Builder {
        crate::model::approval_rule::Builder::default()
    }
}

/// <p>Returns information about the template that created the approval rule for a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OriginApprovalRuleTemplate {
    /// <p>The ID of the template that created the approval rule.</p>
    pub approval_rule_template_id: std::option::Option<std::string::String>,
    /// <p>The name of the template that created the approval rule.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
}
impl OriginApprovalRuleTemplate {
    /// <p>The ID of the template that created the approval rule.</p>
    pub fn approval_rule_template_id(&self) -> std::option::Option<&str> {
        self.approval_rule_template_id.as_deref()
    }
    /// <p>The name of the template that created the approval rule.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
}
impl std::fmt::Debug for OriginApprovalRuleTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OriginApprovalRuleTemplate");
        formatter.field("approval_rule_template_id", &self.approval_rule_template_id);
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.finish()
    }
}
/// See [`OriginApprovalRuleTemplate`](crate::model::OriginApprovalRuleTemplate)
pub mod origin_approval_rule_template {
    /// A builder for [`OriginApprovalRuleTemplate`](crate::model::OriginApprovalRuleTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_id: std::option::Option<std::string::String>,
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the template that created the approval rule.</p>
        pub fn approval_rule_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_template_id = Some(input.into());
            self
        }
        /// <p>The ID of the template that created the approval rule.</p>
        pub fn set_approval_rule_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_id = input;
            self
        }
        /// <p>The name of the template that created the approval rule.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the template that created the approval rule.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// Consumes the builder and constructs a [`OriginApprovalRuleTemplate`](crate::model::OriginApprovalRuleTemplate)
        pub fn build(self) -> crate::model::OriginApprovalRuleTemplate {
            crate::model::OriginApprovalRuleTemplate {
                approval_rule_template_id: self.approval_rule_template_id,
                approval_rule_template_name: self.approval_rule_template_name,
            }
        }
    }
}
impl OriginApprovalRuleTemplate {
    /// Creates a new builder-style object to manufacture [`OriginApprovalRuleTemplate`](crate::model::OriginApprovalRuleTemplate)
    pub fn builder() -> crate::model::origin_approval_rule_template::Builder {
        crate::model::origin_approval_rule_template::Builder::default()
    }
}

/// <p>Returns information about a pull request target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullRequestTarget {
    /// <p>The name of the repository that contains the pull request source and destination branches.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
    pub source_reference: std::option::Option<std::string::String>,
    /// <p>The branch of the repository where the pull request changes are merged. Also known as
    /// the destination branch. </p>
    pub destination_reference: std::option::Option<std::string::String>,
    /// <p>The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or will be merged.</p>
    pub destination_commit: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the tip of the source branch used to create the pull request. If
    /// the pull request branch is updated by a push while the pull request is open, the commit
    /// ID changes to reflect the new tip of the branch.</p>
    pub source_commit: std::option::Option<std::string::String>,
    /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
    pub merge_base: std::option::Option<std::string::String>,
    /// <p>Returns metadata about the state of the merge, including whether the merge has been made.</p>
    pub merge_metadata: std::option::Option<crate::model::MergeMetadata>,
}
impl PullRequestTarget {
    /// <p>The name of the repository that contains the pull request source and destination branches.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
    pub fn source_reference(&self) -> std::option::Option<&str> {
        self.source_reference.as_deref()
    }
    /// <p>The branch of the repository where the pull request changes are merged. Also known as
    /// the destination branch. </p>
    pub fn destination_reference(&self) -> std::option::Option<&str> {
        self.destination_reference.as_deref()
    }
    /// <p>The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or will be merged.</p>
    pub fn destination_commit(&self) -> std::option::Option<&str> {
        self.destination_commit.as_deref()
    }
    /// <p>The full commit ID of the tip of the source branch used to create the pull request. If
    /// the pull request branch is updated by a push while the pull request is open, the commit
    /// ID changes to reflect the new tip of the branch.</p>
    pub fn source_commit(&self) -> std::option::Option<&str> {
        self.source_commit.as_deref()
    }
    /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
    pub fn merge_base(&self) -> std::option::Option<&str> {
        self.merge_base.as_deref()
    }
    /// <p>Returns metadata about the state of the merge, including whether the merge has been made.</p>
    pub fn merge_metadata(&self) -> std::option::Option<&crate::model::MergeMetadata> {
        self.merge_metadata.as_ref()
    }
}
impl std::fmt::Debug for PullRequestTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullRequestTarget");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_reference", &self.source_reference);
        formatter.field("destination_reference", &self.destination_reference);
        formatter.field("destination_commit", &self.destination_commit);
        formatter.field("source_commit", &self.source_commit);
        formatter.field("merge_base", &self.merge_base);
        formatter.field("merge_metadata", &self.merge_metadata);
        formatter.finish()
    }
}
/// See [`PullRequestTarget`](crate::model::PullRequestTarget)
pub mod pull_request_target {
    /// A builder for [`PullRequestTarget`](crate::model::PullRequestTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_reference: std::option::Option<std::string::String>,
        pub(crate) destination_reference: std::option::Option<std::string::String>,
        pub(crate) destination_commit: std::option::Option<std::string::String>,
        pub(crate) source_commit: std::option::Option<std::string::String>,
        pub(crate) merge_base: std::option::Option<std::string::String>,
        pub(crate) merge_metadata: std::option::Option<crate::model::MergeMetadata>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the pull request source and destination branches.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the pull request source and destination branches.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
        pub fn source_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_reference = Some(input.into());
            self
        }
        /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
        pub fn set_source_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_reference = input;
            self
        }
        /// <p>The branch of the repository where the pull request changes are merged. Also known as
        /// the destination branch. </p>
        pub fn destination_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_reference = Some(input.into());
            self
        }
        /// <p>The branch of the repository where the pull request changes are merged. Also known as
        /// the destination branch. </p>
        pub fn set_destination_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_reference = input;
            self
        }
        /// <p>The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or will be merged.</p>
        pub fn destination_commit(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit = Some(input.into());
            self
        }
        /// <p>The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or will be merged.</p>
        pub fn set_destination_commit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit = input;
            self
        }
        /// <p>The full commit ID of the tip of the source branch used to create the pull request. If
        /// the pull request branch is updated by a push while the pull request is open, the commit
        /// ID changes to reflect the new tip of the branch.</p>
        pub fn source_commit(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit = Some(input.into());
            self
        }
        /// <p>The full commit ID of the tip of the source branch used to create the pull request. If
        /// the pull request branch is updated by a push while the pull request is open, the commit
        /// ID changes to reflect the new tip of the branch.</p>
        pub fn set_source_commit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit = input;
            self
        }
        /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
        pub fn merge_base(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_base = Some(input.into());
            self
        }
        /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
        pub fn set_merge_base(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merge_base = input;
            self
        }
        /// <p>Returns metadata about the state of the merge, including whether the merge has been made.</p>
        pub fn merge_metadata(mut self, input: crate::model::MergeMetadata) -> Self {
            self.merge_metadata = Some(input);
            self
        }
        /// <p>Returns metadata about the state of the merge, including whether the merge has been made.</p>
        pub fn set_merge_metadata(
            mut self,
            input: std::option::Option<crate::model::MergeMetadata>,
        ) -> Self {
            self.merge_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`PullRequestTarget`](crate::model::PullRequestTarget)
        pub fn build(self) -> crate::model::PullRequestTarget {
            crate::model::PullRequestTarget {
                repository_name: self.repository_name,
                source_reference: self.source_reference,
                destination_reference: self.destination_reference,
                destination_commit: self.destination_commit,
                source_commit: self.source_commit,
                merge_base: self.merge_base,
                merge_metadata: self.merge_metadata,
            }
        }
    }
}
impl PullRequestTarget {
    /// Creates a new builder-style object to manufacture [`PullRequestTarget`](crate::model::PullRequestTarget)
    pub fn builder() -> crate::model::pull_request_target::Builder {
        crate::model::pull_request_target::Builder::default()
    }
}

/// <p>Returns information about a merge or potential merge between a source reference and a destination reference in a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeMetadata {
    /// <p>A Boolean value indicating whether the merge has been made.</p>
    pub is_merged: bool,
    /// <p>The Amazon Resource Name (ARN) of the user who merged the branches.</p>
    pub merged_by: std::option::Option<std::string::String>,
    /// <p>The commit ID for the merge commit, if any.</p>
    pub merge_commit_id: std::option::Option<std::string::String>,
    /// <p>The merge strategy used in the merge.</p>
    pub merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
}
impl MergeMetadata {
    /// <p>A Boolean value indicating whether the merge has been made.</p>
    pub fn is_merged(&self) -> bool {
        self.is_merged
    }
    /// <p>The Amazon Resource Name (ARN) of the user who merged the branches.</p>
    pub fn merged_by(&self) -> std::option::Option<&str> {
        self.merged_by.as_deref()
    }
    /// <p>The commit ID for the merge commit, if any.</p>
    pub fn merge_commit_id(&self) -> std::option::Option<&str> {
        self.merge_commit_id.as_deref()
    }
    /// <p>The merge strategy used in the merge.</p>
    pub fn merge_option(&self) -> std::option::Option<&crate::model::MergeOptionTypeEnum> {
        self.merge_option.as_ref()
    }
}
impl std::fmt::Debug for MergeMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeMetadata");
        formatter.field("is_merged", &self.is_merged);
        formatter.field("merged_by", &self.merged_by);
        formatter.field("merge_commit_id", &self.merge_commit_id);
        formatter.field("merge_option", &self.merge_option);
        formatter.finish()
    }
}
/// See [`MergeMetadata`](crate::model::MergeMetadata)
pub mod merge_metadata {
    /// A builder for [`MergeMetadata`](crate::model::MergeMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_merged: std::option::Option<bool>,
        pub(crate) merged_by: std::option::Option<std::string::String>,
        pub(crate) merge_commit_id: std::option::Option<std::string::String>,
        pub(crate) merge_option: std::option::Option<crate::model::MergeOptionTypeEnum>,
    }
    impl Builder {
        /// <p>A Boolean value indicating whether the merge has been made.</p>
        pub fn is_merged(mut self, input: bool) -> Self {
            self.is_merged = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the merge has been made.</p>
        pub fn set_is_merged(mut self, input: std::option::Option<bool>) -> Self {
            self.is_merged = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who merged the branches.</p>
        pub fn merged_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.merged_by = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who merged the branches.</p>
        pub fn set_merged_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merged_by = input;
            self
        }
        /// <p>The commit ID for the merge commit, if any.</p>
        pub fn merge_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID for the merge commit, if any.</p>
        pub fn set_merge_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.merge_commit_id = input;
            self
        }
        /// <p>The merge strategy used in the merge.</p>
        pub fn merge_option(mut self, input: crate::model::MergeOptionTypeEnum) -> Self {
            self.merge_option = Some(input);
            self
        }
        /// <p>The merge strategy used in the merge.</p>
        pub fn set_merge_option(
            mut self,
            input: std::option::Option<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            self.merge_option = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeMetadata`](crate::model::MergeMetadata)
        pub fn build(self) -> crate::model::MergeMetadata {
            crate::model::MergeMetadata {
                is_merged: self.is_merged.unwrap_or_default(),
                merged_by: self.merged_by,
                merge_commit_id: self.merge_commit_id,
                merge_option: self.merge_option,
            }
        }
    }
}
impl MergeMetadata {
    /// Creates a new builder-style object to manufacture [`MergeMetadata`](crate::model::MergeMetadata)
    pub fn builder() -> crate::model::merge_metadata::Builder {
        crate::model::merge_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MergeOptionTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    FastForwardMerge,
    #[allow(missing_docs)] // documentation missing in model
    SquashMerge,
    #[allow(missing_docs)] // documentation missing in model
    ThreeWayMerge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MergeOptionTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "FAST_FORWARD_MERGE" => MergeOptionTypeEnum::FastForwardMerge,
            "SQUASH_MERGE" => MergeOptionTypeEnum::SquashMerge,
            "THREE_WAY_MERGE" => MergeOptionTypeEnum::ThreeWayMerge,
            other => MergeOptionTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MergeOptionTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MergeOptionTypeEnum::from(s))
    }
}
impl MergeOptionTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MergeOptionTypeEnum::FastForwardMerge => "FAST_FORWARD_MERGE",
            MergeOptionTypeEnum::SquashMerge => "SQUASH_MERGE",
            MergeOptionTypeEnum::ThreeWayMerge => "THREE_WAY_MERGE",
            MergeOptionTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAST_FORWARD_MERGE", "SQUASH_MERGE", "THREE_WAY_MERGE"]
    }
}
impl AsRef<str> for MergeOptionTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PullRequestStatusEnum {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PullRequestStatusEnum {
    fn from(s: &str) -> Self {
        match s {
            "CLOSED" => PullRequestStatusEnum::Closed,
            "OPEN" => PullRequestStatusEnum::Open,
            other => PullRequestStatusEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PullRequestStatusEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PullRequestStatusEnum::from(s))
    }
}
impl PullRequestStatusEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PullRequestStatusEnum::Closed => "CLOSED",
            PullRequestStatusEnum::Open => "OPEN",
            PullRequestStatusEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLOSED", "OPEN"]
    }
}
impl AsRef<str> for PullRequestStatusEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApprovalState {
    #[allow(missing_docs)] // documentation missing in model
    Approve,
    #[allow(missing_docs)] // documentation missing in model
    Revoke,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApprovalState {
    fn from(s: &str) -> Self {
        match s {
            "APPROVE" => ApprovalState::Approve,
            "REVOKE" => ApprovalState::Revoke,
            other => ApprovalState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApprovalState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApprovalState::from(s))
    }
}
impl ApprovalState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApprovalState::Approve => "APPROVE",
            ApprovalState::Revoke => "REVOKE",
            ApprovalState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPROVE", "REVOKE"]
    }
}
impl AsRef<str> for ApprovalState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about a specific comment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Comment {
    /// <p>The system-generated comment ID.</p>
    pub comment_id: std::option::Option<std::string::String>,
    /// <p>The content of the comment.</p>
    pub content: std::option::Option<std::string::String>,
    /// <p>The ID of the comment for which this comment is a reply, if any.</p>
    pub in_reply_to: std::option::Option<std::string::String>,
    /// <p>The date and time the comment was created, in timestamp format.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the comment was most recently modified, in timestamp format.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the person who posted the comment.</p>
    pub author_arn: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the comment has been deleted.</p>
    pub deleted: bool,
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
    /// the request cannot be repeated with a changed parameter. If a request is received with
    /// the same parameters and a token is included, the request returns information about the
    /// initial request that used that token.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to the API.</p>
    pub caller_reactions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A string to integer map that represents the number of individual users who have responded to a comment with the specified reactions.</p>
    pub reaction_counts: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
}
impl Comment {
    /// <p>The system-generated comment ID.</p>
    pub fn comment_id(&self) -> std::option::Option<&str> {
        self.comment_id.as_deref()
    }
    /// <p>The content of the comment.</p>
    pub fn content(&self) -> std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The ID of the comment for which this comment is a reply, if any.</p>
    pub fn in_reply_to(&self) -> std::option::Option<&str> {
        self.in_reply_to.as_deref()
    }
    /// <p>The date and time the comment was created, in timestamp format.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The date and time the comment was most recently modified, in timestamp format.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the person who posted the comment.</p>
    pub fn author_arn(&self) -> std::option::Option<&str> {
        self.author_arn.as_deref()
    }
    /// <p>A Boolean value indicating whether the comment has been deleted.</p>
    pub fn deleted(&self) -> bool {
        self.deleted
    }
    /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
    /// the request cannot be repeated with a changed parameter. If a request is received with
    /// the same parameters and a token is included, the request returns information about the
    /// initial request that used that token.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to the API.</p>
    pub fn caller_reactions(&self) -> std::option::Option<&[std::string::String]> {
        self.caller_reactions.as_deref()
    }
    /// <p>A string to integer map that represents the number of individual users who have responded to a comment with the specified reactions.</p>
    pub fn reaction_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i32>> {
        self.reaction_counts.as_ref()
    }
}
impl std::fmt::Debug for Comment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Comment");
        formatter.field("comment_id", &self.comment_id);
        formatter.field("content", &self.content);
        formatter.field("in_reply_to", &self.in_reply_to);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("author_arn", &self.author_arn);
        formatter.field("deleted", &self.deleted);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("caller_reactions", &self.caller_reactions);
        formatter.field("reaction_counts", &self.reaction_counts);
        formatter.finish()
    }
}
/// See [`Comment`](crate::model::Comment)
pub mod comment {
    /// A builder for [`Comment`](crate::model::Comment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment_id: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) in_reply_to: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) author_arn: std::option::Option<std::string::String>,
        pub(crate) deleted: std::option::Option<bool>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) caller_reactions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) reaction_counts:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    }
    impl Builder {
        /// <p>The system-generated comment ID.</p>
        pub fn comment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.comment_id = Some(input.into());
            self
        }
        /// <p>The system-generated comment ID.</p>
        pub fn set_comment_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.comment_id = input;
            self
        }
        /// <p>The content of the comment.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the comment.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// <p>The ID of the comment for which this comment is a reply, if any.</p>
        pub fn in_reply_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.in_reply_to = Some(input.into());
            self
        }
        /// <p>The ID of the comment for which this comment is a reply, if any.</p>
        pub fn set_in_reply_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.in_reply_to = input;
            self
        }
        /// <p>The date and time the comment was created, in timestamp format.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time the comment was created, in timestamp format.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time the comment was most recently modified, in timestamp format.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time the comment was most recently modified, in timestamp format.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the person who posted the comment.</p>
        pub fn author_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.author_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the person who posted the comment.</p>
        pub fn set_author_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.author_arn = input;
            self
        }
        /// <p>A Boolean value indicating whether the comment has been deleted.</p>
        pub fn deleted(mut self, input: bool) -> Self {
            self.deleted = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the comment has been deleted.</p>
        pub fn set_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.deleted = input;
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, client-generated idempotency token that, when provided in a request, ensures
        /// the request cannot be repeated with a changed parameter. If a request is received with
        /// the same parameters and a token is included, the request returns information about the
        /// initial request that used that token.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Appends an item to `caller_reactions`.
        ///
        /// To override the contents of this collection use [`set_caller_reactions`](Self::set_caller_reactions).
        ///
        /// <p>The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to the API.</p>
        pub fn caller_reactions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.caller_reactions.unwrap_or_default();
            v.push(input.into());
            self.caller_reactions = Some(v);
            self
        }
        /// <p>The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to the API.</p>
        pub fn set_caller_reactions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.caller_reactions = input;
            self
        }
        /// Adds a key-value pair to `reaction_counts`.
        ///
        /// To override the contents of this collection use [`set_reaction_counts`](Self::set_reaction_counts).
        ///
        /// <p>A string to integer map that represents the number of individual users who have responded to a comment with the specified reactions.</p>
        pub fn reaction_counts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.reaction_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.reaction_counts = Some(hash_map);
            self
        }
        /// <p>A string to integer map that represents the number of individual users who have responded to a comment with the specified reactions.</p>
        pub fn set_reaction_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.reaction_counts = input;
            self
        }
        /// Consumes the builder and constructs a [`Comment`](crate::model::Comment)
        pub fn build(self) -> crate::model::Comment {
            crate::model::Comment {
                comment_id: self.comment_id,
                content: self.content,
                in_reply_to: self.in_reply_to,
                creation_date: self.creation_date,
                last_modified_date: self.last_modified_date,
                author_arn: self.author_arn,
                deleted: self.deleted.unwrap_or_default(),
                client_request_token: self.client_request_token,
                caller_reactions: self.caller_reactions,
                reaction_counts: self.reaction_counts,
            }
        }
    }
}
impl Comment {
    /// Creates a new builder-style object to manufacture [`Comment`](crate::model::Comment)
    pub fn builder() -> crate::model::comment::Builder {
        crate::model::comment::Builder::default()
    }
}

/// <p>Returns information about an approval rule template.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalRuleTemplate {
    /// <p>The system-generated ID of the approval rule template.</p>
    pub approval_rule_template_id: std::option::Option<std::string::String>,
    /// <p>The name of the approval rule template.</p>
    pub approval_rule_template_name: std::option::Option<std::string::String>,
    /// <p>The description of the approval rule template.</p>
    pub approval_rule_template_description: std::option::Option<std::string::String>,
    /// <p>The content of the approval rule template.</p>
    pub approval_rule_template_content: std::option::Option<std::string::String>,
    /// <p>The SHA-256 hash signature for the content of the approval rule template.</p>
    pub rule_content_sha256: std::option::Option<std::string::String>,
    /// <p>The date the approval rule template was most recently changed, in timestamp format.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the approval rule template was created, in timestamp format.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.</p>
    pub last_modified_user: std::option::Option<std::string::String>,
}
impl ApprovalRuleTemplate {
    /// <p>The system-generated ID of the approval rule template.</p>
    pub fn approval_rule_template_id(&self) -> std::option::Option<&str> {
        self.approval_rule_template_id.as_deref()
    }
    /// <p>The name of the approval rule template.</p>
    pub fn approval_rule_template_name(&self) -> std::option::Option<&str> {
        self.approval_rule_template_name.as_deref()
    }
    /// <p>The description of the approval rule template.</p>
    pub fn approval_rule_template_description(&self) -> std::option::Option<&str> {
        self.approval_rule_template_description.as_deref()
    }
    /// <p>The content of the approval rule template.</p>
    pub fn approval_rule_template_content(&self) -> std::option::Option<&str> {
        self.approval_rule_template_content.as_deref()
    }
    /// <p>The SHA-256 hash signature for the content of the approval rule template.</p>
    pub fn rule_content_sha256(&self) -> std::option::Option<&str> {
        self.rule_content_sha256.as_deref()
    }
    /// <p>The date the approval rule template was most recently changed, in timestamp format.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date the approval rule template was created, in timestamp format.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.</p>
    pub fn last_modified_user(&self) -> std::option::Option<&str> {
        self.last_modified_user.as_deref()
    }
}
impl std::fmt::Debug for ApprovalRuleTemplate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalRuleTemplate");
        formatter.field("approval_rule_template_id", &self.approval_rule_template_id);
        formatter.field(
            "approval_rule_template_name",
            &self.approval_rule_template_name,
        );
        formatter.field(
            "approval_rule_template_description",
            &self.approval_rule_template_description,
        );
        formatter.field(
            "approval_rule_template_content",
            &self.approval_rule_template_content,
        );
        formatter.field("rule_content_sha256", &self.rule_content_sha256);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_modified_user", &self.last_modified_user);
        formatter.finish()
    }
}
/// See [`ApprovalRuleTemplate`](crate::model::ApprovalRuleTemplate)
pub mod approval_rule_template {
    /// A builder for [`ApprovalRuleTemplate`](crate::model::ApprovalRuleTemplate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_id: std::option::Option<std::string::String>,
        pub(crate) approval_rule_template_name: std::option::Option<std::string::String>,
        pub(crate) approval_rule_template_description: std::option::Option<std::string::String>,
        pub(crate) approval_rule_template_content: std::option::Option<std::string::String>,
        pub(crate) rule_content_sha256: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified_user: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the approval rule template.</p>
        pub fn approval_rule_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_template_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the approval rule template.</p>
        pub fn set_approval_rule_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_id = input;
            self
        }
        /// <p>The name of the approval rule template.</p>
        pub fn approval_rule_template_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule template.</p>
        pub fn set_approval_rule_template_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_name = input;
            self
        }
        /// <p>The description of the approval rule template.</p>
        pub fn approval_rule_template_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_description = Some(input.into());
            self
        }
        /// <p>The description of the approval rule template.</p>
        pub fn set_approval_rule_template_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_description = input;
            self
        }
        /// <p>The content of the approval rule template.</p>
        pub fn approval_rule_template_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.approval_rule_template_content = Some(input.into());
            self
        }
        /// <p>The content of the approval rule template.</p>
        pub fn set_approval_rule_template_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_content = input;
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule template.</p>
        pub fn rule_content_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.rule_content_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA-256 hash signature for the content of the approval rule template.</p>
        pub fn set_rule_content_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rule_content_sha256 = input;
            self
        }
        /// <p>The date the approval rule template was most recently changed, in timestamp format.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date the approval rule template was most recently changed, in timestamp format.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date the approval rule template was created, in timestamp format.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date the approval rule template was created, in timestamp format.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.</p>
        pub fn last_modified_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_user = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule template.</p>
        pub fn set_last_modified_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_user = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalRuleTemplate`](crate::model::ApprovalRuleTemplate)
        pub fn build(self) -> crate::model::ApprovalRuleTemplate {
            crate::model::ApprovalRuleTemplate {
                approval_rule_template_id: self.approval_rule_template_id,
                approval_rule_template_name: self.approval_rule_template_name,
                approval_rule_template_description: self.approval_rule_template_description,
                approval_rule_template_content: self.approval_rule_template_content,
                rule_content_sha256: self.rule_content_sha256,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
                last_modified_user: self.last_modified_user,
            }
        }
    }
}
impl ApprovalRuleTemplate {
    /// Creates a new builder-style object to manufacture [`ApprovalRuleTemplate`](crate::model::ApprovalRuleTemplate)
    pub fn builder() -> crate::model::approval_rule_template::Builder {
        crate::model::approval_rule_template::Builder::default()
    }
}

/// <p>A trigger failed to run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryTriggerExecutionFailure {
    /// <p>The name of the trigger that did not run.</p>
    pub trigger: std::option::Option<std::string::String>,
    /// <p>Message information about the trigger that did not run.</p>
    pub failure_message: std::option::Option<std::string::String>,
}
impl RepositoryTriggerExecutionFailure {
    /// <p>The name of the trigger that did not run.</p>
    pub fn trigger(&self) -> std::option::Option<&str> {
        self.trigger.as_deref()
    }
    /// <p>Message information about the trigger that did not run.</p>
    pub fn failure_message(&self) -> std::option::Option<&str> {
        self.failure_message.as_deref()
    }
}
impl std::fmt::Debug for RepositoryTriggerExecutionFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryTriggerExecutionFailure");
        formatter.field("trigger", &self.trigger);
        formatter.field("failure_message", &self.failure_message);
        formatter.finish()
    }
}
/// See [`RepositoryTriggerExecutionFailure`](crate::model::RepositoryTriggerExecutionFailure)
pub mod repository_trigger_execution_failure {
    /// A builder for [`RepositoryTriggerExecutionFailure`](crate::model::RepositoryTriggerExecutionFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger: std::option::Option<std::string::String>,
        pub(crate) failure_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the trigger that did not run.</p>
        pub fn trigger(mut self, input: impl Into<std::string::String>) -> Self {
            self.trigger = Some(input.into());
            self
        }
        /// <p>The name of the trigger that did not run.</p>
        pub fn set_trigger(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trigger = input;
            self
        }
        /// <p>Message information about the trigger that did not run.</p>
        pub fn failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_message = Some(input.into());
            self
        }
        /// <p>Message information about the trigger that did not run.</p>
        pub fn set_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_message = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryTriggerExecutionFailure`](crate::model::RepositoryTriggerExecutionFailure)
        pub fn build(self) -> crate::model::RepositoryTriggerExecutionFailure {
            crate::model::RepositoryTriggerExecutionFailure {
                trigger: self.trigger,
                failure_message: self.failure_message,
            }
        }
    }
}
impl RepositoryTriggerExecutionFailure {
    /// Creates a new builder-style object to manufacture [`RepositoryTriggerExecutionFailure`](crate::model::RepositoryTriggerExecutionFailure)
    pub fn builder() -> crate::model::repository_trigger_execution_failure::Builder {
        crate::model::repository_trigger_execution_failure::Builder::default()
    }
}

/// <p>Information about a trigger for a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryTrigger {
    /// <p>The name of the trigger.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the resource that is the target for a trigger (for example, the ARN of a
    /// topic in Amazon SNS).</p>
    pub destination_arn: std::option::Option<std::string::String>,
    /// <p>Any custom data associated with the trigger to be included in the information sent to
    /// the target of the trigger.</p>
    pub custom_data: std::option::Option<std::string::String>,
    /// <p>The branches to be included in the trigger configuration. If you specify an empty
    /// array, the trigger applies to all branches.</p>
    /// <note>
    /// <p>Although no content is required in the array, you must include the array itself.</p>
    /// </note>
    pub branches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The repository events that cause the trigger to run actions in another service, such
    /// as sending a notification through Amazon SNS.
    ///
    /// </p>
    /// <note>
    /// <p>The valid value "all" cannot be used with any other values.</p>
    /// </note>
    pub events: std::option::Option<std::vec::Vec<crate::model::RepositoryTriggerEventEnum>>,
}
impl RepositoryTrigger {
    /// <p>The name of the trigger.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the resource that is the target for a trigger (for example, the ARN of a
    /// topic in Amazon SNS).</p>
    pub fn destination_arn(&self) -> std::option::Option<&str> {
        self.destination_arn.as_deref()
    }
    /// <p>Any custom data associated with the trigger to be included in the information sent to
    /// the target of the trigger.</p>
    pub fn custom_data(&self) -> std::option::Option<&str> {
        self.custom_data.as_deref()
    }
    /// <p>The branches to be included in the trigger configuration. If you specify an empty
    /// array, the trigger applies to all branches.</p>
    /// <note>
    /// <p>Although no content is required in the array, you must include the array itself.</p>
    /// </note>
    pub fn branches(&self) -> std::option::Option<&[std::string::String]> {
        self.branches.as_deref()
    }
    /// <p>The repository events that cause the trigger to run actions in another service, such
    /// as sending a notification through Amazon SNS.
    ///
    /// </p>
    /// <note>
    /// <p>The valid value "all" cannot be used with any other values.</p>
    /// </note>
    pub fn events(&self) -> std::option::Option<&[crate::model::RepositoryTriggerEventEnum]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for RepositoryTrigger {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryTrigger");
        formatter.field("name", &self.name);
        formatter.field("destination_arn", &self.destination_arn);
        formatter.field("custom_data", &self.custom_data);
        formatter.field("branches", &self.branches);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`RepositoryTrigger`](crate::model::RepositoryTrigger)
pub mod repository_trigger {
    /// A builder for [`RepositoryTrigger`](crate::model::RepositoryTrigger)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) custom_data: std::option::Option<std::string::String>,
        pub(crate) branches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) events:
            std::option::Option<std::vec::Vec<crate::model::RepositoryTriggerEventEnum>>,
    }
    impl Builder {
        /// <p>The name of the trigger.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the trigger.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the resource that is the target for a trigger (for example, the ARN of a
        /// topic in Amazon SNS).</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that is the target for a trigger (for example, the ARN of a
        /// topic in Amazon SNS).</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p>Any custom data associated with the trigger to be included in the information sent to
        /// the target of the trigger.</p>
        pub fn custom_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_data = Some(input.into());
            self
        }
        /// <p>Any custom data associated with the trigger to be included in the information sent to
        /// the target of the trigger.</p>
        pub fn set_custom_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.custom_data = input;
            self
        }
        /// Appends an item to `branches`.
        ///
        /// To override the contents of this collection use [`set_branches`](Self::set_branches).
        ///
        /// <p>The branches to be included in the trigger configuration. If you specify an empty
        /// array, the trigger applies to all branches.</p>
        /// <note>
        /// <p>Although no content is required in the array, you must include the array itself.</p>
        /// </note>
        pub fn branches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.branches.unwrap_or_default();
            v.push(input.into());
            self.branches = Some(v);
            self
        }
        /// <p>The branches to be included in the trigger configuration. If you specify an empty
        /// array, the trigger applies to all branches.</p>
        /// <note>
        /// <p>Although no content is required in the array, you must include the array itself.</p>
        /// </note>
        pub fn set_branches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.branches = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The repository events that cause the trigger to run actions in another service, such
        /// as sending a notification through Amazon SNS.
        ///
        /// </p>
        /// <note>
        /// <p>The valid value "all" cannot be used with any other values.</p>
        /// </note>
        pub fn events(
            mut self,
            input: impl Into<crate::model::RepositoryTriggerEventEnum>,
        ) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>The repository events that cause the trigger to run actions in another service, such
        /// as sending a notification through Amazon SNS.
        ///
        /// </p>
        /// <note>
        /// <p>The valid value "all" cannot be used with any other values.</p>
        /// </note>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTriggerEventEnum>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryTrigger`](crate::model::RepositoryTrigger)
        pub fn build(self) -> crate::model::RepositoryTrigger {
            crate::model::RepositoryTrigger {
                name: self.name,
                destination_arn: self.destination_arn,
                custom_data: self.custom_data,
                branches: self.branches,
                events: self.events,
            }
        }
    }
}
impl RepositoryTrigger {
    /// Creates a new builder-style object to manufacture [`RepositoryTrigger`](crate::model::RepositoryTrigger)
    pub fn builder() -> crate::model::repository_trigger::Builder {
        crate::model::repository_trigger::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RepositoryTriggerEventEnum {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    CreateReference,
    #[allow(missing_docs)] // documentation missing in model
    DeleteReference,
    #[allow(missing_docs)] // documentation missing in model
    UpdateReference,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RepositoryTriggerEventEnum {
    fn from(s: &str) -> Self {
        match s {
            "all" => RepositoryTriggerEventEnum::All,
            "createReference" => RepositoryTriggerEventEnum::CreateReference,
            "deleteReference" => RepositoryTriggerEventEnum::DeleteReference,
            "updateReference" => RepositoryTriggerEventEnum::UpdateReference,
            other => RepositoryTriggerEventEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RepositoryTriggerEventEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RepositoryTriggerEventEnum::from(s))
    }
}
impl RepositoryTriggerEventEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RepositoryTriggerEventEnum::All => "all",
            RepositoryTriggerEventEnum::CreateReference => "createReference",
            RepositoryTriggerEventEnum::DeleteReference => "deleteReference",
            RepositoryTriggerEventEnum::UpdateReference => "updateReference",
            RepositoryTriggerEventEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "all",
            "createReference",
            "deleteReference",
            "updateReference",
        ]
    }
}
impl AsRef<str> for RepositoryTriggerEventEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileModeTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    Executable,
    #[allow(missing_docs)] // documentation missing in model
    Normal,
    #[allow(missing_docs)] // documentation missing in model
    Symlink,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileModeTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "EXECUTABLE" => FileModeTypeEnum::Executable,
            "NORMAL" => FileModeTypeEnum::Normal,
            "SYMLINK" => FileModeTypeEnum::Symlink,
            other => FileModeTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileModeTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileModeTypeEnum::from(s))
    }
}
impl FileModeTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileModeTypeEnum::Executable => "EXECUTABLE",
            FileModeTypeEnum::Normal => "NORMAL",
            FileModeTypeEnum::Symlink => "SYMLINK",
            FileModeTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXECUTABLE", "NORMAL", "SYMLINK"]
    }
}
impl AsRef<str> for FileModeTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about the location of a change or comment in the comparison between two commits or a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Location {
    /// <p>The name of the file being compared, including its extension and subdirectory, if any.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The position of a change in a compared file, in line number format.</p>
    pub file_position: std::option::Option<i64>,
    /// <p>In a comparison of commits or a pull request, whether the change is in the before or
    /// after of that comparison.</p>
    pub relative_file_version: std::option::Option<crate::model::RelativeFileVersionEnum>,
}
impl Location {
    /// <p>The name of the file being compared, including its extension and subdirectory, if any.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The position of a change in a compared file, in line number format.</p>
    pub fn file_position(&self) -> std::option::Option<i64> {
        self.file_position
    }
    /// <p>In a comparison of commits or a pull request, whether the change is in the before or
    /// after of that comparison.</p>
    pub fn relative_file_version(
        &self,
    ) -> std::option::Option<&crate::model::RelativeFileVersionEnum> {
        self.relative_file_version.as_ref()
    }
}
impl std::fmt::Debug for Location {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Location");
        formatter.field("file_path", &self.file_path);
        formatter.field("file_position", &self.file_position);
        formatter.field("relative_file_version", &self.relative_file_version);
        formatter.finish()
    }
}
/// See [`Location`](crate::model::Location)
pub mod location {
    /// A builder for [`Location`](crate::model::Location)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) file_position: std::option::Option<i64>,
        pub(crate) relative_file_version:
            std::option::Option<crate::model::RelativeFileVersionEnum>,
    }
    impl Builder {
        /// <p>The name of the file being compared, including its extension and subdirectory, if any.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The name of the file being compared, including its extension and subdirectory, if any.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The position of a change in a compared file, in line number format.</p>
        pub fn file_position(mut self, input: i64) -> Self {
            self.file_position = Some(input);
            self
        }
        /// <p>The position of a change in a compared file, in line number format.</p>
        pub fn set_file_position(mut self, input: std::option::Option<i64>) -> Self {
            self.file_position = input;
            self
        }
        /// <p>In a comparison of commits or a pull request, whether the change is in the before or
        /// after of that comparison.</p>
        pub fn relative_file_version(
            mut self,
            input: crate::model::RelativeFileVersionEnum,
        ) -> Self {
            self.relative_file_version = Some(input);
            self
        }
        /// <p>In a comparison of commits or a pull request, whether the change is in the before or
        /// after of that comparison.</p>
        pub fn set_relative_file_version(
            mut self,
            input: std::option::Option<crate::model::RelativeFileVersionEnum>,
        ) -> Self {
            self.relative_file_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Location`](crate::model::Location)
        pub fn build(self) -> crate::model::Location {
            crate::model::Location {
                file_path: self.file_path,
                file_position: self.file_position,
                relative_file_version: self.relative_file_version,
            }
        }
    }
}
impl Location {
    /// Creates a new builder-style object to manufacture [`Location`](crate::model::Location)
    pub fn builder() -> crate::model::location::Builder {
        crate::model::location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelativeFileVersionEnum {
    #[allow(missing_docs)] // documentation missing in model
    After,
    #[allow(missing_docs)] // documentation missing in model
    Before,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelativeFileVersionEnum {
    fn from(s: &str) -> Self {
        match s {
            "AFTER" => RelativeFileVersionEnum::After,
            "BEFORE" => RelativeFileVersionEnum::Before,
            other => RelativeFileVersionEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelativeFileVersionEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelativeFileVersionEnum::from(s))
    }
}
impl RelativeFileVersionEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelativeFileVersionEnum::After => "AFTER",
            RelativeFileVersionEnum::Before => "BEFORE",
            RelativeFileVersionEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AFTER", "BEFORE"]
    }
}
impl AsRef<str> for RelativeFileVersionEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OverrideStatus {
    #[allow(missing_docs)] // documentation missing in model
    Override,
    #[allow(missing_docs)] // documentation missing in model
    Revoke,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OverrideStatus {
    fn from(s: &str) -> Self {
        match s {
            "OVERRIDE" => OverrideStatus::Override,
            "REVOKE" => OverrideStatus::Revoke,
            other => OverrideStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OverrideStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OverrideStatus::from(s))
    }
}
impl OverrideStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OverrideStatus::Override => "OVERRIDE",
            OverrideStatus::Revoke => "REVOKE",
            OverrideStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OVERRIDE", "REVOKE"]
    }
}
impl AsRef<str> for OverrideStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when
/// resolving conflicts during a merge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictResolution {
    /// <p>Files to have content replaced as part of the merge conflict resolution.</p>
    pub replace_contents: std::option::Option<std::vec::Vec<crate::model::ReplaceContentEntry>>,
    /// <p>Files to be deleted as part of the merge conflict resolution.</p>
    pub delete_files: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
    /// <p>File modes that are set as part of the merge conflict resolution.</p>
    pub set_file_modes: std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
}
impl ConflictResolution {
    /// <p>Files to have content replaced as part of the merge conflict resolution.</p>
    pub fn replace_contents(&self) -> std::option::Option<&[crate::model::ReplaceContentEntry]> {
        self.replace_contents.as_deref()
    }
    /// <p>Files to be deleted as part of the merge conflict resolution.</p>
    pub fn delete_files(&self) -> std::option::Option<&[crate::model::DeleteFileEntry]> {
        self.delete_files.as_deref()
    }
    /// <p>File modes that are set as part of the merge conflict resolution.</p>
    pub fn set_file_modes(&self) -> std::option::Option<&[crate::model::SetFileModeEntry]> {
        self.set_file_modes.as_deref()
    }
}
impl std::fmt::Debug for ConflictResolution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictResolution");
        formatter.field("replace_contents", &self.replace_contents);
        formatter.field("delete_files", &self.delete_files);
        formatter.field("set_file_modes", &self.set_file_modes);
        formatter.finish()
    }
}
/// See [`ConflictResolution`](crate::model::ConflictResolution)
pub mod conflict_resolution {
    /// A builder for [`ConflictResolution`](crate::model::ConflictResolution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replace_contents:
            std::option::Option<std::vec::Vec<crate::model::ReplaceContentEntry>>,
        pub(crate) delete_files: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
        pub(crate) set_file_modes:
            std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
    }
    impl Builder {
        /// Appends an item to `replace_contents`.
        ///
        /// To override the contents of this collection use [`set_replace_contents`](Self::set_replace_contents).
        ///
        /// <p>Files to have content replaced as part of the merge conflict resolution.</p>
        pub fn replace_contents(
            mut self,
            input: impl Into<crate::model::ReplaceContentEntry>,
        ) -> Self {
            let mut v = self.replace_contents.unwrap_or_default();
            v.push(input.into());
            self.replace_contents = Some(v);
            self
        }
        /// <p>Files to have content replaced as part of the merge conflict resolution.</p>
        pub fn set_replace_contents(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReplaceContentEntry>>,
        ) -> Self {
            self.replace_contents = input;
            self
        }
        /// Appends an item to `delete_files`.
        ///
        /// To override the contents of this collection use [`set_delete_files`](Self::set_delete_files).
        ///
        /// <p>Files to be deleted as part of the merge conflict resolution.</p>
        pub fn delete_files(mut self, input: impl Into<crate::model::DeleteFileEntry>) -> Self {
            let mut v = self.delete_files.unwrap_or_default();
            v.push(input.into());
            self.delete_files = Some(v);
            self
        }
        /// <p>Files to be deleted as part of the merge conflict resolution.</p>
        pub fn set_delete_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteFileEntry>>,
        ) -> Self {
            self.delete_files = input;
            self
        }
        /// Appends an item to `set_file_modes`.
        ///
        /// To override the contents of this collection use [`set_set_file_modes`](Self::set_set_file_modes).
        ///
        /// <p>File modes that are set as part of the merge conflict resolution.</p>
        pub fn set_file_modes(mut self, input: impl Into<crate::model::SetFileModeEntry>) -> Self {
            let mut v = self.set_file_modes.unwrap_or_default();
            v.push(input.into());
            self.set_file_modes = Some(v);
            self
        }
        /// <p>File modes that are set as part of the merge conflict resolution.</p>
        pub fn set_set_file_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetFileModeEntry>>,
        ) -> Self {
            self.set_file_modes = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictResolution`](crate::model::ConflictResolution)
        pub fn build(self) -> crate::model::ConflictResolution {
            crate::model::ConflictResolution {
                replace_contents: self.replace_contents,
                delete_files: self.delete_files,
                set_file_modes: self.set_file_modes,
            }
        }
    }
}
impl ConflictResolution {
    /// Creates a new builder-style object to manufacture [`ConflictResolution`](crate::model::ConflictResolution)
    pub fn builder() -> crate::model::conflict_resolution::Builder {
        crate::model::conflict_resolution::Builder::default()
    }
}

/// <p>Information about the file mode changes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetFileModeEntry {
    /// <p>The full path to the file, including the name of the file.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The file mode for the file.</p>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
}
impl SetFileModeEntry {
    /// <p>The full path to the file, including the name of the file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The file mode for the file.</p>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
}
impl std::fmt::Debug for SetFileModeEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetFileModeEntry");
        formatter.field("file_path", &self.file_path);
        formatter.field("file_mode", &self.file_mode);
        formatter.finish()
    }
}
/// See [`SetFileModeEntry`](crate::model::SetFileModeEntry)
pub mod set_file_mode_entry {
    /// A builder for [`SetFileModeEntry`](crate::model::SetFileModeEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    }
    impl Builder {
        /// <p>The full path to the file, including the name of the file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The full path to the file, including the name of the file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The file mode for the file.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The file mode for the file.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`SetFileModeEntry`](crate::model::SetFileModeEntry)
        pub fn build(self) -> crate::model::SetFileModeEntry {
            crate::model::SetFileModeEntry {
                file_path: self.file_path,
                file_mode: self.file_mode,
            }
        }
    }
}
impl SetFileModeEntry {
    /// Creates a new builder-style object to manufacture [`SetFileModeEntry`](crate::model::SetFileModeEntry)
    pub fn builder() -> crate::model::set_file_mode_entry::Builder {
        crate::model::set_file_mode_entry::Builder::default()
    }
}

/// <p>A file that is deleted as part of a commit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileEntry {
    /// <p>The full path of the file to be deleted, including the name of the file.</p>
    pub file_path: std::option::Option<std::string::String>,
}
impl DeleteFileEntry {
    /// <p>The full path of the file to be deleted, including the name of the file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileEntry");
        formatter.field("file_path", &self.file_path);
        formatter.finish()
    }
}
/// See [`DeleteFileEntry`](crate::model::DeleteFileEntry)
pub mod delete_file_entry {
    /// A builder for [`DeleteFileEntry`](crate::model::DeleteFileEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full path of the file to be deleted, including the name of the file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The full path of the file to be deleted, including the name of the file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileEntry`](crate::model::DeleteFileEntry)
        pub fn build(self) -> crate::model::DeleteFileEntry {
            crate::model::DeleteFileEntry {
                file_path: self.file_path,
            }
        }
    }
}
impl DeleteFileEntry {
    /// Creates a new builder-style object to manufacture [`DeleteFileEntry`](crate::model::DeleteFileEntry)
    pub fn builder() -> crate::model::delete_file_entry::Builder {
        crate::model::delete_file_entry::Builder::default()
    }
}

/// <p>Information about a replacement content entry in the conflict of a merge or pull request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplaceContentEntry {
    /// <p>The path of the conflicting file.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The replacement type to use when determining how to resolve the conflict.</p>
    pub replacement_type: std::option::Option<crate::model::ReplacementTypeEnum>,
    /// <p>The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.</p>
    pub content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The file mode to apply during conflict resoltion.</p>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
}
impl ReplaceContentEntry {
    /// <p>The path of the conflicting file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The replacement type to use when determining how to resolve the conflict.</p>
    pub fn replacement_type(&self) -> std::option::Option<&crate::model::ReplacementTypeEnum> {
        self.replacement_type.as_ref()
    }
    /// <p>The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.</p>
    pub fn content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.content.as_ref()
    }
    /// <p>The file mode to apply during conflict resoltion.</p>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
}
impl std::fmt::Debug for ReplaceContentEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplaceContentEntry");
        formatter.field("file_path", &self.file_path);
        formatter.field("replacement_type", &self.replacement_type);
        formatter.field("content", &self.content);
        formatter.field("file_mode", &self.file_mode);
        formatter.finish()
    }
}
/// See [`ReplaceContentEntry`](crate::model::ReplaceContentEntry)
pub mod replace_content_entry {
    /// A builder for [`ReplaceContentEntry`](crate::model::ReplaceContentEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) replacement_type: std::option::Option<crate::model::ReplacementTypeEnum>,
        pub(crate) content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    }
    impl Builder {
        /// <p>The path of the conflicting file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The path of the conflicting file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The replacement type to use when determining how to resolve the conflict.</p>
        pub fn replacement_type(mut self, input: crate::model::ReplacementTypeEnum) -> Self {
            self.replacement_type = Some(input);
            self
        }
        /// <p>The replacement type to use when determining how to resolve the conflict.</p>
        pub fn set_replacement_type(
            mut self,
            input: std::option::Option<crate::model::ReplacementTypeEnum>,
        ) -> Self {
            self.replacement_type = input;
            self
        }
        /// <p>The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.content = input;
            self
        }
        /// <p>The file mode to apply during conflict resoltion.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The file mode to apply during conflict resoltion.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplaceContentEntry`](crate::model::ReplaceContentEntry)
        pub fn build(self) -> crate::model::ReplaceContentEntry {
            crate::model::ReplaceContentEntry {
                file_path: self.file_path,
                replacement_type: self.replacement_type,
                content: self.content,
                file_mode: self.file_mode,
            }
        }
    }
}
impl ReplaceContentEntry {
    /// Creates a new builder-style object to manufacture [`ReplaceContentEntry`](crate::model::ReplaceContentEntry)
    pub fn builder() -> crate::model::replace_content_entry::Builder {
        crate::model::replace_content_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplacementTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    KeepBase,
    #[allow(missing_docs)] // documentation missing in model
    KeepDestination,
    #[allow(missing_docs)] // documentation missing in model
    KeepSource,
    #[allow(missing_docs)] // documentation missing in model
    UseNewContent,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplacementTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "KEEP_BASE" => ReplacementTypeEnum::KeepBase,
            "KEEP_DESTINATION" => ReplacementTypeEnum::KeepDestination,
            "KEEP_SOURCE" => ReplacementTypeEnum::KeepSource,
            "USE_NEW_CONTENT" => ReplacementTypeEnum::UseNewContent,
            other => ReplacementTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplacementTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplacementTypeEnum::from(s))
    }
}
impl ReplacementTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplacementTypeEnum::KeepBase => "KEEP_BASE",
            ReplacementTypeEnum::KeepDestination => "KEEP_DESTINATION",
            ReplacementTypeEnum::KeepSource => "KEEP_SOURCE",
            ReplacementTypeEnum::UseNewContent => "USE_NEW_CONTENT",
            ReplacementTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "KEEP_BASE",
            "KEEP_DESTINATION",
            "KEEP_SOURCE",
            "USE_NEW_CONTENT",
        ]
    }
}
impl AsRef<str> for ReplacementTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConflictResolutionStrategyTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    AcceptDestination,
    #[allow(missing_docs)] // documentation missing in model
    AcceptSource,
    #[allow(missing_docs)] // documentation missing in model
    Automerge,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConflictResolutionStrategyTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPT_DESTINATION" => ConflictResolutionStrategyTypeEnum::AcceptDestination,
            "ACCEPT_SOURCE" => ConflictResolutionStrategyTypeEnum::AcceptSource,
            "AUTOMERGE" => ConflictResolutionStrategyTypeEnum::Automerge,
            "NONE" => ConflictResolutionStrategyTypeEnum::None,
            other => ConflictResolutionStrategyTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConflictResolutionStrategyTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConflictResolutionStrategyTypeEnum::from(s))
    }
}
impl ConflictResolutionStrategyTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConflictResolutionStrategyTypeEnum::AcceptDestination => "ACCEPT_DESTINATION",
            ConflictResolutionStrategyTypeEnum::AcceptSource => "ACCEPT_SOURCE",
            ConflictResolutionStrategyTypeEnum::Automerge => "AUTOMERGE",
            ConflictResolutionStrategyTypeEnum::None => "NONE",
            ConflictResolutionStrategyTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPT_DESTINATION", "ACCEPT_SOURCE", "AUTOMERGE", "NONE"]
    }
}
impl AsRef<str> for ConflictResolutionStrategyTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConflictDetailLevelTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    FileLevel,
    #[allow(missing_docs)] // documentation missing in model
    LineLevel,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConflictDetailLevelTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "FILE_LEVEL" => ConflictDetailLevelTypeEnum::FileLevel,
            "LINE_LEVEL" => ConflictDetailLevelTypeEnum::LineLevel,
            other => ConflictDetailLevelTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConflictDetailLevelTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConflictDetailLevelTypeEnum::from(s))
    }
}
impl ConflictDetailLevelTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConflictDetailLevelTypeEnum::FileLevel => "FILE_LEVEL",
            ConflictDetailLevelTypeEnum::LineLevel => "LINE_LEVEL",
            ConflictDetailLevelTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FILE_LEVEL", "LINE_LEVEL"]
    }
}
impl AsRef<str> for ConflictDetailLevelTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a repository name and ID.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryNameIdPair {
    /// <p>The name associated with the repository.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The ID associated with the repository.</p>
    pub repository_id: std::option::Option<std::string::String>,
}
impl RepositoryNameIdPair {
    /// <p>The name associated with the repository.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The ID associated with the repository.</p>
    pub fn repository_id(&self) -> std::option::Option<&str> {
        self.repository_id.as_deref()
    }
}
impl std::fmt::Debug for RepositoryNameIdPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryNameIdPair");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("repository_id", &self.repository_id);
        formatter.finish()
    }
}
/// See [`RepositoryNameIdPair`](crate::model::RepositoryNameIdPair)
pub mod repository_name_id_pair {
    /// A builder for [`RepositoryNameIdPair`](crate::model::RepositoryNameIdPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) repository_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name associated with the repository.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name associated with the repository.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The ID associated with the repository.</p>
        pub fn repository_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_id = Some(input.into());
            self
        }
        /// <p>The ID associated with the repository.</p>
        pub fn set_repository_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryNameIdPair`](crate::model::RepositoryNameIdPair)
        pub fn build(self) -> crate::model::RepositoryNameIdPair {
            crate::model::RepositoryNameIdPair {
                repository_name: self.repository_name,
                repository_id: self.repository_id,
            }
        }
    }
}
impl RepositoryNameIdPair {
    /// Creates a new builder-style object to manufacture [`RepositoryNameIdPair`](crate::model::RepositoryNameIdPair)
    pub fn builder() -> crate::model::repository_name_id_pair::Builder {
        crate::model::repository_name_id_pair::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderEnum {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderEnum {
    fn from(s: &str) -> Self {
        match s {
            "ascending" => OrderEnum::Ascending,
            "descending" => OrderEnum::Descending,
            other => OrderEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderEnum::from(s))
    }
}
impl OrderEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderEnum::Ascending => "ascending",
            OrderEnum::Descending => "descending",
            OrderEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ascending", "descending"]
    }
}
impl AsRef<str> for OrderEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortByEnum {
    #[allow(missing_docs)] // documentation missing in model
    ModifiedDate,
    #[allow(missing_docs)] // documentation missing in model
    RepositoryName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortByEnum {
    fn from(s: &str) -> Self {
        match s {
            "lastModifiedDate" => SortByEnum::ModifiedDate,
            "repositoryName" => SortByEnum::RepositoryName,
            other => SortByEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortByEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortByEnum::from(s))
    }
}
impl SortByEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortByEnum::ModifiedDate => "lastModifiedDate",
            SortByEnum::RepositoryName => "repositoryName",
            SortByEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["lastModifiedDate", "repositoryName"]
    }
}
impl AsRef<str> for SortByEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryMetadata {
    /// <p>The ID of the AWS account associated with the repository.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The ID of the repository.</p>
    pub repository_id: std::option::Option<std::string::String>,
    /// <p>The repository's name.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>A comment or description about the repository.</p>
    pub repository_description: std::option::Option<std::string::String>,
    /// <p>The repository's default branch name.</p>
    pub default_branch: std::option::Option<std::string::String>,
    /// <p>The date and time the repository was last modified, in timestamp format.</p>
    pub last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time the repository was created, in timestamp format.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The URL to use for cloning the repository over HTTPS.</p>
    pub clone_url_http: std::option::Option<std::string::String>,
    /// <p>The URL to use for cloning the repository over SSH.</p>
    pub clone_url_ssh: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the repository.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl RepositoryMetadata {
    /// <p>The ID of the AWS account associated with the repository.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The ID of the repository.</p>
    pub fn repository_id(&self) -> std::option::Option<&str> {
        self.repository_id.as_deref()
    }
    /// <p>The repository's name.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>A comment or description about the repository.</p>
    pub fn repository_description(&self) -> std::option::Option<&str> {
        self.repository_description.as_deref()
    }
    /// <p>The repository's default branch name.</p>
    pub fn default_branch(&self) -> std::option::Option<&str> {
        self.default_branch.as_deref()
    }
    /// <p>The date and time the repository was last modified, in timestamp format.</p>
    pub fn last_modified_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_date.as_ref()
    }
    /// <p>The date and time the repository was created, in timestamp format.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>The URL to use for cloning the repository over HTTPS.</p>
    pub fn clone_url_http(&self) -> std::option::Option<&str> {
        self.clone_url_http.as_deref()
    }
    /// <p>The URL to use for cloning the repository over SSH.</p>
    pub fn clone_url_ssh(&self) -> std::option::Option<&str> {
        self.clone_url_ssh.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the repository.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for RepositoryMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryMetadata");
        formatter.field("account_id", &self.account_id);
        formatter.field("repository_id", &self.repository_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("repository_description", &self.repository_description);
        formatter.field("default_branch", &self.default_branch);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("clone_url_http", &self.clone_url_http);
        formatter.field("clone_url_ssh", &self.clone_url_ssh);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`RepositoryMetadata`](crate::model::RepositoryMetadata)
pub mod repository_metadata {
    /// A builder for [`RepositoryMetadata`](crate::model::RepositoryMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) repository_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) repository_description: std::option::Option<std::string::String>,
        pub(crate) default_branch: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) clone_url_http: std::option::Option<std::string::String>,
        pub(crate) clone_url_ssh: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the AWS account associated with the repository.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the AWS account associated with the repository.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The ID of the repository.</p>
        pub fn repository_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_id = Some(input.into());
            self
        }
        /// <p>The ID of the repository.</p>
        pub fn set_repository_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_id = input;
            self
        }
        /// <p>The repository's name.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The repository's name.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>A comment or description about the repository.</p>
        pub fn repository_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_description = Some(input.into());
            self
        }
        /// <p>A comment or description about the repository.</p>
        pub fn set_repository_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_description = input;
            self
        }
        /// <p>The repository's default branch name.</p>
        pub fn default_branch(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_branch = Some(input.into());
            self
        }
        /// <p>The repository's default branch name.</p>
        pub fn set_default_branch(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_branch = input;
            self
        }
        /// <p>The date and time the repository was last modified, in timestamp format.</p>
        pub fn last_modified_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_date = Some(input);
            self
        }
        /// <p>The date and time the repository was last modified, in timestamp format.</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The date and time the repository was created, in timestamp format.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time the repository was created, in timestamp format.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The URL to use for cloning the repository over HTTPS.</p>
        pub fn clone_url_http(mut self, input: impl Into<std::string::String>) -> Self {
            self.clone_url_http = Some(input.into());
            self
        }
        /// <p>The URL to use for cloning the repository over HTTPS.</p>
        pub fn set_clone_url_http(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.clone_url_http = input;
            self
        }
        /// <p>The URL to use for cloning the repository over SSH.</p>
        pub fn clone_url_ssh(mut self, input: impl Into<std::string::String>) -> Self {
            self.clone_url_ssh = Some(input.into());
            self
        }
        /// <p>The URL to use for cloning the repository over SSH.</p>
        pub fn set_clone_url_ssh(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.clone_url_ssh = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the repository.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryMetadata`](crate::model::RepositoryMetadata)
        pub fn build(self) -> crate::model::RepositoryMetadata {
            crate::model::RepositoryMetadata {
                account_id: self.account_id,
                repository_id: self.repository_id,
                repository_name: self.repository_name,
                repository_description: self.repository_description,
                default_branch: self.default_branch,
                last_modified_date: self.last_modified_date,
                creation_date: self.creation_date,
                clone_url_http: self.clone_url_http,
                clone_url_ssh: self.clone_url_ssh,
                arn: self.arn,
            }
        }
    }
}
impl RepositoryMetadata {
    /// Creates a new builder-style object to manufacture [`RepositoryMetadata`](crate::model::RepositoryMetadata)
    pub fn builder() -> crate::model::repository_metadata::Builder {
        crate::model::repository_metadata::Builder::default()
    }
}

/// <p>Returns information about a specific approval on a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Approval {
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub user_arn: std::option::Option<std::string::String>,
    /// <p>The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.</p>
    pub approval_state: std::option::Option<crate::model::ApprovalState>,
}
impl Approval {
    /// <p>The Amazon Resource Name (ARN) of the user.</p>
    pub fn user_arn(&self) -> std::option::Option<&str> {
        self.user_arn.as_deref()
    }
    /// <p>The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.</p>
    pub fn approval_state(&self) -> std::option::Option<&crate::model::ApprovalState> {
        self.approval_state.as_ref()
    }
}
impl std::fmt::Debug for Approval {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Approval");
        formatter.field("user_arn", &self.user_arn);
        formatter.field("approval_state", &self.approval_state);
        formatter.finish()
    }
}
/// See [`Approval`](crate::model::Approval)
pub mod approval {
    /// A builder for [`Approval`](crate::model::Approval)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_arn: std::option::Option<std::string::String>,
        pub(crate) approval_state: std::option::Option<crate::model::ApprovalState>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn user_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user.</p>
        pub fn set_user_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_arn = input;
            self
        }
        /// <p>The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.</p>
        pub fn approval_state(mut self, input: crate::model::ApprovalState) -> Self {
            self.approval_state = Some(input);
            self
        }
        /// <p>The state of the approval, APPROVE or REVOKE. REVOKE states are not stored.</p>
        pub fn set_approval_state(
            mut self,
            input: std::option::Option<crate::model::ApprovalState>,
        ) -> Self {
            self.approval_state = input;
            self
        }
        /// Consumes the builder and constructs a [`Approval`](crate::model::Approval)
        pub fn build(self) -> crate::model::Approval {
            crate::model::Approval {
                user_arn: self.user_arn,
                approval_state: self.approval_state,
            }
        }
    }
}
impl Approval {
    /// Creates a new builder-style object to manufacture [`Approval`](crate::model::Approval)
    pub fn builder() -> crate::model::approval::Builder {
        crate::model::approval::Builder::default()
    }
}

/// <p>Information about the metadata for a conflict in a merge operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictMetadata {
    /// <p>The path of the file that contains conflicts.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The file sizes of the file in the source, destination, and base of the merge.</p>
    pub file_sizes: std::option::Option<crate::model::FileSizes>,
    /// <p>The file modes of the file in the source, destination, and base of the merge.</p>
    pub file_modes: std::option::Option<crate::model::FileModes>,
    /// <p>Information about any object type conflicts in a merge operation.</p>
    pub object_types: std::option::Option<crate::model::ObjectTypes>,
    /// <p>The number of conflicts, including both hunk conflicts and metadata conflicts.</p>
    pub number_of_conflicts: i32,
    /// <p>A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and base of the merge.</p>
    pub is_binary_file: std::option::Option<crate::model::IsBinaryFile>,
    /// <p>A boolean value indicating whether there are conflicts in the content of a file.</p>
    pub content_conflict: bool,
    /// <p>A boolean value indicating whether there are conflicts in the file mode of a file.</p>
    pub file_mode_conflict: bool,
    /// <p>A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of a file, folder, or submodule.</p>
    pub object_type_conflict: bool,
    /// <p>Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.</p>
    pub merge_operations: std::option::Option<crate::model::MergeOperations>,
}
impl ConflictMetadata {
    /// <p>The path of the file that contains conflicts.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The file sizes of the file in the source, destination, and base of the merge.</p>
    pub fn file_sizes(&self) -> std::option::Option<&crate::model::FileSizes> {
        self.file_sizes.as_ref()
    }
    /// <p>The file modes of the file in the source, destination, and base of the merge.</p>
    pub fn file_modes(&self) -> std::option::Option<&crate::model::FileModes> {
        self.file_modes.as_ref()
    }
    /// <p>Information about any object type conflicts in a merge operation.</p>
    pub fn object_types(&self) -> std::option::Option<&crate::model::ObjectTypes> {
        self.object_types.as_ref()
    }
    /// <p>The number of conflicts, including both hunk conflicts and metadata conflicts.</p>
    pub fn number_of_conflicts(&self) -> i32 {
        self.number_of_conflicts
    }
    /// <p>A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and base of the merge.</p>
    pub fn is_binary_file(&self) -> std::option::Option<&crate::model::IsBinaryFile> {
        self.is_binary_file.as_ref()
    }
    /// <p>A boolean value indicating whether there are conflicts in the content of a file.</p>
    pub fn content_conflict(&self) -> bool {
        self.content_conflict
    }
    /// <p>A boolean value indicating whether there are conflicts in the file mode of a file.</p>
    pub fn file_mode_conflict(&self) -> bool {
        self.file_mode_conflict
    }
    /// <p>A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of a file, folder, or submodule.</p>
    pub fn object_type_conflict(&self) -> bool {
        self.object_type_conflict
    }
    /// <p>Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.</p>
    pub fn merge_operations(&self) -> std::option::Option<&crate::model::MergeOperations> {
        self.merge_operations.as_ref()
    }
}
impl std::fmt::Debug for ConflictMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictMetadata");
        formatter.field("file_path", &self.file_path);
        formatter.field("file_sizes", &self.file_sizes);
        formatter.field("file_modes", &self.file_modes);
        formatter.field("object_types", &self.object_types);
        formatter.field("number_of_conflicts", &self.number_of_conflicts);
        formatter.field("is_binary_file", &self.is_binary_file);
        formatter.field("content_conflict", &self.content_conflict);
        formatter.field("file_mode_conflict", &self.file_mode_conflict);
        formatter.field("object_type_conflict", &self.object_type_conflict);
        formatter.field("merge_operations", &self.merge_operations);
        formatter.finish()
    }
}
/// See [`ConflictMetadata`](crate::model::ConflictMetadata)
pub mod conflict_metadata {
    /// A builder for [`ConflictMetadata`](crate::model::ConflictMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) file_sizes: std::option::Option<crate::model::FileSizes>,
        pub(crate) file_modes: std::option::Option<crate::model::FileModes>,
        pub(crate) object_types: std::option::Option<crate::model::ObjectTypes>,
        pub(crate) number_of_conflicts: std::option::Option<i32>,
        pub(crate) is_binary_file: std::option::Option<crate::model::IsBinaryFile>,
        pub(crate) content_conflict: std::option::Option<bool>,
        pub(crate) file_mode_conflict: std::option::Option<bool>,
        pub(crate) object_type_conflict: std::option::Option<bool>,
        pub(crate) merge_operations: std::option::Option<crate::model::MergeOperations>,
    }
    impl Builder {
        /// <p>The path of the file that contains conflicts.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The path of the file that contains conflicts.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The file sizes of the file in the source, destination, and base of the merge.</p>
        pub fn file_sizes(mut self, input: crate::model::FileSizes) -> Self {
            self.file_sizes = Some(input);
            self
        }
        /// <p>The file sizes of the file in the source, destination, and base of the merge.</p>
        pub fn set_file_sizes(
            mut self,
            input: std::option::Option<crate::model::FileSizes>,
        ) -> Self {
            self.file_sizes = input;
            self
        }
        /// <p>The file modes of the file in the source, destination, and base of the merge.</p>
        pub fn file_modes(mut self, input: crate::model::FileModes) -> Self {
            self.file_modes = Some(input);
            self
        }
        /// <p>The file modes of the file in the source, destination, and base of the merge.</p>
        pub fn set_file_modes(
            mut self,
            input: std::option::Option<crate::model::FileModes>,
        ) -> Self {
            self.file_modes = input;
            self
        }
        /// <p>Information about any object type conflicts in a merge operation.</p>
        pub fn object_types(mut self, input: crate::model::ObjectTypes) -> Self {
            self.object_types = Some(input);
            self
        }
        /// <p>Information about any object type conflicts in a merge operation.</p>
        pub fn set_object_types(
            mut self,
            input: std::option::Option<crate::model::ObjectTypes>,
        ) -> Self {
            self.object_types = input;
            self
        }
        /// <p>The number of conflicts, including both hunk conflicts and metadata conflicts.</p>
        pub fn number_of_conflicts(mut self, input: i32) -> Self {
            self.number_of_conflicts = Some(input);
            self
        }
        /// <p>The number of conflicts, including both hunk conflicts and metadata conflicts.</p>
        pub fn set_number_of_conflicts(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_conflicts = input;
            self
        }
        /// <p>A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and base of the merge.</p>
        pub fn is_binary_file(mut self, input: crate::model::IsBinaryFile) -> Self {
            self.is_binary_file = Some(input);
            self
        }
        /// <p>A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and base of the merge.</p>
        pub fn set_is_binary_file(
            mut self,
            input: std::option::Option<crate::model::IsBinaryFile>,
        ) -> Self {
            self.is_binary_file = input;
            self
        }
        /// <p>A boolean value indicating whether there are conflicts in the content of a file.</p>
        pub fn content_conflict(mut self, input: bool) -> Self {
            self.content_conflict = Some(input);
            self
        }
        /// <p>A boolean value indicating whether there are conflicts in the content of a file.</p>
        pub fn set_content_conflict(mut self, input: std::option::Option<bool>) -> Self {
            self.content_conflict = input;
            self
        }
        /// <p>A boolean value indicating whether there are conflicts in the file mode of a file.</p>
        pub fn file_mode_conflict(mut self, input: bool) -> Self {
            self.file_mode_conflict = Some(input);
            self
        }
        /// <p>A boolean value indicating whether there are conflicts in the file mode of a file.</p>
        pub fn set_file_mode_conflict(mut self, input: std::option::Option<bool>) -> Self {
            self.file_mode_conflict = input;
            self
        }
        /// <p>A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of a file, folder, or submodule.</p>
        pub fn object_type_conflict(mut self, input: bool) -> Self {
            self.object_type_conflict = Some(input);
            self
        }
        /// <p>A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of a file, folder, or submodule.</p>
        pub fn set_object_type_conflict(mut self, input: std::option::Option<bool>) -> Self {
            self.object_type_conflict = input;
            self
        }
        /// <p>Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.</p>
        pub fn merge_operations(mut self, input: crate::model::MergeOperations) -> Self {
            self.merge_operations = Some(input);
            self
        }
        /// <p>Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.</p>
        pub fn set_merge_operations(
            mut self,
            input: std::option::Option<crate::model::MergeOperations>,
        ) -> Self {
            self.merge_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictMetadata`](crate::model::ConflictMetadata)
        pub fn build(self) -> crate::model::ConflictMetadata {
            crate::model::ConflictMetadata {
                file_path: self.file_path,
                file_sizes: self.file_sizes,
                file_modes: self.file_modes,
                object_types: self.object_types,
                number_of_conflicts: self.number_of_conflicts.unwrap_or_default(),
                is_binary_file: self.is_binary_file,
                content_conflict: self.content_conflict.unwrap_or_default(),
                file_mode_conflict: self.file_mode_conflict.unwrap_or_default(),
                object_type_conflict: self.object_type_conflict.unwrap_or_default(),
                merge_operations: self.merge_operations,
            }
        }
    }
}
impl ConflictMetadata {
    /// Creates a new builder-style object to manufacture [`ConflictMetadata`](crate::model::ConflictMetadata)
    pub fn builder() -> crate::model::conflict_metadata::Builder {
        crate::model::conflict_metadata::Builder::default()
    }
}

/// <p>Information about the file operation conflicts in a merge operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeOperations {
    /// <p>The operation (add, modify, or delete) on a file in the source of a merge or pull
    /// request.</p>
    pub source: std::option::Option<crate::model::ChangeTypeEnum>,
    /// <p>The operation on a file in the destination of a merge or pull request.</p>
    pub destination: std::option::Option<crate::model::ChangeTypeEnum>,
}
impl MergeOperations {
    /// <p>The operation (add, modify, or delete) on a file in the source of a merge or pull
    /// request.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::ChangeTypeEnum> {
        self.source.as_ref()
    }
    /// <p>The operation on a file in the destination of a merge or pull request.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::ChangeTypeEnum> {
        self.destination.as_ref()
    }
}
impl std::fmt::Debug for MergeOperations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeOperations");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`MergeOperations`](crate::model::MergeOperations)
pub mod merge_operations {
    /// A builder for [`MergeOperations`](crate::model::MergeOperations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::ChangeTypeEnum>,
        pub(crate) destination: std::option::Option<crate::model::ChangeTypeEnum>,
    }
    impl Builder {
        /// <p>The operation (add, modify, or delete) on a file in the source of a merge or pull
        /// request.</p>
        pub fn source(mut self, input: crate::model::ChangeTypeEnum) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The operation (add, modify, or delete) on a file in the source of a merge or pull
        /// request.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ChangeTypeEnum>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The operation on a file in the destination of a merge or pull request.</p>
        pub fn destination(mut self, input: crate::model::ChangeTypeEnum) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The operation on a file in the destination of a merge or pull request.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::ChangeTypeEnum>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeOperations`](crate::model::MergeOperations)
        pub fn build(self) -> crate::model::MergeOperations {
            crate::model::MergeOperations {
                source: self.source,
                destination: self.destination,
            }
        }
    }
}
impl MergeOperations {
    /// Creates a new builder-style object to manufacture [`MergeOperations`](crate::model::MergeOperations)
    pub fn builder() -> crate::model::merge_operations::Builder {
        crate::model::merge_operations::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    Added,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Modified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "A" => ChangeTypeEnum::Added,
            "D" => ChangeTypeEnum::Deleted,
            "M" => ChangeTypeEnum::Modified,
            other => ChangeTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeTypeEnum::from(s))
    }
}
impl ChangeTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeTypeEnum::Added => "A",
            ChangeTypeEnum::Deleted => "D",
            ChangeTypeEnum::Modified => "M",
            ChangeTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["A", "D", "M"]
    }
}
impl AsRef<str> for ChangeTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about whether a file is binary or textual in a merge or pull request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IsBinaryFile {
    /// <p>The binary or non-binary status of file in the source of a merge or pull request.</p>
    pub source: std::option::Option<bool>,
    /// <p>The binary or non-binary status of a file in the destination of a merge or pull request.</p>
    pub destination: std::option::Option<bool>,
    /// <p>The binary or non-binary status of a file in the base of a merge or pull request.</p>
    pub base: std::option::Option<bool>,
}
impl IsBinaryFile {
    /// <p>The binary or non-binary status of file in the source of a merge or pull request.</p>
    pub fn source(&self) -> std::option::Option<bool> {
        self.source
    }
    /// <p>The binary or non-binary status of a file in the destination of a merge or pull request.</p>
    pub fn destination(&self) -> std::option::Option<bool> {
        self.destination
    }
    /// <p>The binary or non-binary status of a file in the base of a merge or pull request.</p>
    pub fn base(&self) -> std::option::Option<bool> {
        self.base
    }
}
impl std::fmt::Debug for IsBinaryFile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IsBinaryFile");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("base", &self.base);
        formatter.finish()
    }
}
/// See [`IsBinaryFile`](crate::model::IsBinaryFile)
pub mod is_binary_file {
    /// A builder for [`IsBinaryFile`](crate::model::IsBinaryFile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<bool>,
        pub(crate) destination: std::option::Option<bool>,
        pub(crate) base: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The binary or non-binary status of file in the source of a merge or pull request.</p>
        pub fn source(mut self, input: bool) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The binary or non-binary status of file in the source of a merge or pull request.</p>
        pub fn set_source(mut self, input: std::option::Option<bool>) -> Self {
            self.source = input;
            self
        }
        /// <p>The binary or non-binary status of a file in the destination of a merge or pull request.</p>
        pub fn destination(mut self, input: bool) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The binary or non-binary status of a file in the destination of a merge or pull request.</p>
        pub fn set_destination(mut self, input: std::option::Option<bool>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The binary or non-binary status of a file in the base of a merge or pull request.</p>
        pub fn base(mut self, input: bool) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>The binary or non-binary status of a file in the base of a merge or pull request.</p>
        pub fn set_base(mut self, input: std::option::Option<bool>) -> Self {
            self.base = input;
            self
        }
        /// Consumes the builder and constructs a [`IsBinaryFile`](crate::model::IsBinaryFile)
        pub fn build(self) -> crate::model::IsBinaryFile {
            crate::model::IsBinaryFile {
                source: self.source,
                destination: self.destination,
                base: self.base,
            }
        }
    }
}
impl IsBinaryFile {
    /// Creates a new builder-style object to manufacture [`IsBinaryFile`](crate::model::IsBinaryFile)
    pub fn builder() -> crate::model::is_binary_file::Builder {
        crate::model::is_binary_file::Builder::default()
    }
}

/// <p>Information about the type of an object in a merge operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectTypes {
    /// <p>The type of the object in the source branch.</p>
    pub source: std::option::Option<crate::model::ObjectTypeEnum>,
    /// <p>The type of the object in the destination branch.</p>
    pub destination: std::option::Option<crate::model::ObjectTypeEnum>,
    /// <p>The type of the object in the base commit of the merge.</p>
    pub base: std::option::Option<crate::model::ObjectTypeEnum>,
}
impl ObjectTypes {
    /// <p>The type of the object in the source branch.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::ObjectTypeEnum> {
        self.source.as_ref()
    }
    /// <p>The type of the object in the destination branch.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::ObjectTypeEnum> {
        self.destination.as_ref()
    }
    /// <p>The type of the object in the base commit of the merge.</p>
    pub fn base(&self) -> std::option::Option<&crate::model::ObjectTypeEnum> {
        self.base.as_ref()
    }
}
impl std::fmt::Debug for ObjectTypes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectTypes");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("base", &self.base);
        formatter.finish()
    }
}
/// See [`ObjectTypes`](crate::model::ObjectTypes)
pub mod object_types {
    /// A builder for [`ObjectTypes`](crate::model::ObjectTypes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::ObjectTypeEnum>,
        pub(crate) destination: std::option::Option<crate::model::ObjectTypeEnum>,
        pub(crate) base: std::option::Option<crate::model::ObjectTypeEnum>,
    }
    impl Builder {
        /// <p>The type of the object in the source branch.</p>
        pub fn source(mut self, input: crate::model::ObjectTypeEnum) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The type of the object in the source branch.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ObjectTypeEnum>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The type of the object in the destination branch.</p>
        pub fn destination(mut self, input: crate::model::ObjectTypeEnum) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The type of the object in the destination branch.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::ObjectTypeEnum>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The type of the object in the base commit of the merge.</p>
        pub fn base(mut self, input: crate::model::ObjectTypeEnum) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>The type of the object in the base commit of the merge.</p>
        pub fn set_base(
            mut self,
            input: std::option::Option<crate::model::ObjectTypeEnum>,
        ) -> Self {
            self.base = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectTypes`](crate::model::ObjectTypes)
        pub fn build(self) -> crate::model::ObjectTypes {
            crate::model::ObjectTypes {
                source: self.source,
                destination: self.destination,
                base: self.base,
            }
        }
    }
}
impl ObjectTypes {
    /// Creates a new builder-style object to manufacture [`ObjectTypes`](crate::model::ObjectTypes)
    pub fn builder() -> crate::model::object_types::Builder {
        crate::model::object_types::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ObjectTypeEnum {
    #[allow(missing_docs)] // documentation missing in model
    Directory,
    #[allow(missing_docs)] // documentation missing in model
    File,
    #[allow(missing_docs)] // documentation missing in model
    GitLink,
    #[allow(missing_docs)] // documentation missing in model
    SymbolicLink,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ObjectTypeEnum {
    fn from(s: &str) -> Self {
        match s {
            "DIRECTORY" => ObjectTypeEnum::Directory,
            "FILE" => ObjectTypeEnum::File,
            "GIT_LINK" => ObjectTypeEnum::GitLink,
            "SYMBOLIC_LINK" => ObjectTypeEnum::SymbolicLink,
            other => ObjectTypeEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ObjectTypeEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ObjectTypeEnum::from(s))
    }
}
impl ObjectTypeEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectTypeEnum::Directory => "DIRECTORY",
            ObjectTypeEnum::File => "FILE",
            ObjectTypeEnum::GitLink => "GIT_LINK",
            ObjectTypeEnum::SymbolicLink => "SYMBOLIC_LINK",
            ObjectTypeEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DIRECTORY", "FILE", "GIT_LINK", "SYMBOLIC_LINK"]
    }
}
impl AsRef<str> for ObjectTypeEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about file modes in a merge or pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileModes {
    /// <p>The file mode of a file in the source of a merge or pull request.</p>
    pub source: std::option::Option<crate::model::FileModeTypeEnum>,
    /// <p>The file mode of a file in the destination of a merge or pull request.</p>
    pub destination: std::option::Option<crate::model::FileModeTypeEnum>,
    /// <p>The file mode of a file in the base of a merge or pull request.</p>
    pub base: std::option::Option<crate::model::FileModeTypeEnum>,
}
impl FileModes {
    /// <p>The file mode of a file in the source of a merge or pull request.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.source.as_ref()
    }
    /// <p>The file mode of a file in the destination of a merge or pull request.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.destination.as_ref()
    }
    /// <p>The file mode of a file in the base of a merge or pull request.</p>
    pub fn base(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.base.as_ref()
    }
}
impl std::fmt::Debug for FileModes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileModes");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("base", &self.base);
        formatter.finish()
    }
}
/// See [`FileModes`](crate::model::FileModes)
pub mod file_modes {
    /// A builder for [`FileModes`](crate::model::FileModes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::FileModeTypeEnum>,
        pub(crate) destination: std::option::Option<crate::model::FileModeTypeEnum>,
        pub(crate) base: std::option::Option<crate::model::FileModeTypeEnum>,
    }
    impl Builder {
        /// <p>The file mode of a file in the source of a merge or pull request.</p>
        pub fn source(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The file mode of a file in the source of a merge or pull request.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>The file mode of a file in the destination of a merge or pull request.</p>
        pub fn destination(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The file mode of a file in the destination of a merge or pull request.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>The file mode of a file in the base of a merge or pull request.</p>
        pub fn base(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>The file mode of a file in the base of a merge or pull request.</p>
        pub fn set_base(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.base = input;
            self
        }
        /// Consumes the builder and constructs a [`FileModes`](crate::model::FileModes)
        pub fn build(self) -> crate::model::FileModes {
            crate::model::FileModes {
                source: self.source,
                destination: self.destination,
                base: self.base,
            }
        }
    }
}
impl FileModes {
    /// Creates a new builder-style object to manufacture [`FileModes`](crate::model::FileModes)
    pub fn builder() -> crate::model::file_modes::Builder {
        crate::model::file_modes::Builder::default()
    }
}

/// <p>Information about the size of files in a merge or pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileSizes {
    /// <p>The  size of a file in the source of a merge or pull request.</p>
    pub source: i64,
    /// <p>The size of a file in the destination of a merge or pull request.</p>
    pub destination: i64,
    /// <p>The size of a file in the base of a merge or pull request.</p>
    pub base: i64,
}
impl FileSizes {
    /// <p>The  size of a file in the source of a merge or pull request.</p>
    pub fn source(&self) -> i64 {
        self.source
    }
    /// <p>The size of a file in the destination of a merge or pull request.</p>
    pub fn destination(&self) -> i64 {
        self.destination
    }
    /// <p>The size of a file in the base of a merge or pull request.</p>
    pub fn base(&self) -> i64 {
        self.base
    }
}
impl std::fmt::Debug for FileSizes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileSizes");
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("base", &self.base);
        formatter.finish()
    }
}
/// See [`FileSizes`](crate::model::FileSizes)
pub mod file_sizes {
    /// A builder for [`FileSizes`](crate::model::FileSizes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<i64>,
        pub(crate) destination: std::option::Option<i64>,
        pub(crate) base: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The  size of a file in the source of a merge or pull request.</p>
        pub fn source(mut self, input: i64) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>The  size of a file in the source of a merge or pull request.</p>
        pub fn set_source(mut self, input: std::option::Option<i64>) -> Self {
            self.source = input;
            self
        }
        /// <p>The size of a file in the destination of a merge or pull request.</p>
        pub fn destination(mut self, input: i64) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>The size of a file in the destination of a merge or pull request.</p>
        pub fn set_destination(mut self, input: std::option::Option<i64>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The size of a file in the base of a merge or pull request.</p>
        pub fn base(mut self, input: i64) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>The size of a file in the base of a merge or pull request.</p>
        pub fn set_base(mut self, input: std::option::Option<i64>) -> Self {
            self.base = input;
            self
        }
        /// Consumes the builder and constructs a [`FileSizes`](crate::model::FileSizes)
        pub fn build(self) -> crate::model::FileSizes {
            crate::model::FileSizes {
                source: self.source.unwrap_or_default(),
                destination: self.destination.unwrap_or_default(),
                base: self.base.unwrap_or_default(),
            }
        }
    }
}
impl FileSizes {
    /// Creates a new builder-style object to manufacture [`FileSizes`](crate::model::FileSizes)
    pub fn builder() -> crate::model::file_sizes::Builder {
        crate::model::file_sizes::Builder::default()
    }
}

/// <p>Returns information about a submodule reference in a repository folder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubModule {
    /// <p>The commit ID that contains the reference to the submodule.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the folder that contains the reference to the submodule.</p>
    pub absolute_path: std::option::Option<std::string::String>,
    /// <p>The relative path of the submodule from the folder where the query originated.</p>
    pub relative_path: std::option::Option<std::string::String>,
}
impl SubModule {
    /// <p>The commit ID that contains the reference to the submodule.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The fully qualified path to the folder that contains the reference to the submodule.</p>
    pub fn absolute_path(&self) -> std::option::Option<&str> {
        self.absolute_path.as_deref()
    }
    /// <p>The relative path of the submodule from the folder where the query originated.</p>
    pub fn relative_path(&self) -> std::option::Option<&str> {
        self.relative_path.as_deref()
    }
}
impl std::fmt::Debug for SubModule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubModule");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("absolute_path", &self.absolute_path);
        formatter.field("relative_path", &self.relative_path);
        formatter.finish()
    }
}
/// See [`SubModule`](crate::model::SubModule)
pub mod sub_module {
    /// A builder for [`SubModule`](crate::model::SubModule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) absolute_path: std::option::Option<std::string::String>,
        pub(crate) relative_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The commit ID that contains the reference to the submodule.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID that contains the reference to the submodule.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The fully qualified path to the folder that contains the reference to the submodule.</p>
        pub fn absolute_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.absolute_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the folder that contains the reference to the submodule.</p>
        pub fn set_absolute_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.absolute_path = input;
            self
        }
        /// <p>The relative path of the submodule from the folder where the query originated.</p>
        pub fn relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.relative_path = Some(input.into());
            self
        }
        /// <p>The relative path of the submodule from the folder where the query originated.</p>
        pub fn set_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relative_path = input;
            self
        }
        /// Consumes the builder and constructs a [`SubModule`](crate::model::SubModule)
        pub fn build(self) -> crate::model::SubModule {
            crate::model::SubModule {
                commit_id: self.commit_id,
                absolute_path: self.absolute_path,
                relative_path: self.relative_path,
            }
        }
    }
}
impl SubModule {
    /// Creates a new builder-style object to manufacture [`SubModule`](crate::model::SubModule)
    pub fn builder() -> crate::model::sub_module::Builder {
        crate::model::sub_module::Builder::default()
    }
}

/// <p>Returns information about a symbolic link in a repository folder.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SymbolicLink {
    /// <p>The blob ID that contains the information about the symbolic link.</p>
    pub blob_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the folder that contains the symbolic link.</p>
    pub absolute_path: std::option::Option<std::string::String>,
    /// <p>The relative path of the symbolic link from the folder where the query originated.</p>
    pub relative_path: std::option::Option<std::string::String>,
    /// <p>The file mode permissions of the blob that cotains information about the symbolic link.</p>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
}
impl SymbolicLink {
    /// <p>The blob ID that contains the information about the symbolic link.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
    /// <p>The fully qualified path to the folder that contains the symbolic link.</p>
    pub fn absolute_path(&self) -> std::option::Option<&str> {
        self.absolute_path.as_deref()
    }
    /// <p>The relative path of the symbolic link from the folder where the query originated.</p>
    pub fn relative_path(&self) -> std::option::Option<&str> {
        self.relative_path.as_deref()
    }
    /// <p>The file mode permissions of the blob that cotains information about the symbolic link.</p>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
}
impl std::fmt::Debug for SymbolicLink {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SymbolicLink");
        formatter.field("blob_id", &self.blob_id);
        formatter.field("absolute_path", &self.absolute_path);
        formatter.field("relative_path", &self.relative_path);
        formatter.field("file_mode", &self.file_mode);
        formatter.finish()
    }
}
/// See [`SymbolicLink`](crate::model::SymbolicLink)
pub mod symbolic_link {
    /// A builder for [`SymbolicLink`](crate::model::SymbolicLink)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blob_id: std::option::Option<std::string::String>,
        pub(crate) absolute_path: std::option::Option<std::string::String>,
        pub(crate) relative_path: std::option::Option<std::string::String>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    }
    impl Builder {
        /// <p>The blob ID that contains the information about the symbolic link.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The blob ID that contains the information about the symbolic link.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// <p>The fully qualified path to the folder that contains the symbolic link.</p>
        pub fn absolute_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.absolute_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the folder that contains the symbolic link.</p>
        pub fn set_absolute_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.absolute_path = input;
            self
        }
        /// <p>The relative path of the symbolic link from the folder where the query originated.</p>
        pub fn relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.relative_path = Some(input.into());
            self
        }
        /// <p>The relative path of the symbolic link from the folder where the query originated.</p>
        pub fn set_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relative_path = input;
            self
        }
        /// <p>The file mode permissions of the blob that cotains information about the symbolic link.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The file mode permissions of the blob that cotains information about the symbolic link.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`SymbolicLink`](crate::model::SymbolicLink)
        pub fn build(self) -> crate::model::SymbolicLink {
            crate::model::SymbolicLink {
                blob_id: self.blob_id,
                absolute_path: self.absolute_path,
                relative_path: self.relative_path,
                file_mode: self.file_mode,
            }
        }
    }
}
impl SymbolicLink {
    /// Creates a new builder-style object to manufacture [`SymbolicLink`](crate::model::SymbolicLink)
    pub fn builder() -> crate::model::symbolic_link::Builder {
        crate::model::symbolic_link::Builder::default()
    }
}

/// <p>Returns information about a file in a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct File {
    /// <p>The blob ID that contains the file information.</p>
    pub blob_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the file in the repository.</p>
    pub absolute_path: std::option::Option<std::string::String>,
    /// <p>The relative path of the file from the folder where the query originated.</p>
    pub relative_path: std::option::Option<std::string::String>,
    /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
}
impl File {
    /// <p>The blob ID that contains the file information.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
    /// <p>The fully qualified path to the file in the repository.</p>
    pub fn absolute_path(&self) -> std::option::Option<&str> {
        self.absolute_path.as_deref()
    }
    /// <p>The relative path of the file from the folder where the query originated.</p>
    pub fn relative_path(&self) -> std::option::Option<&str> {
        self.relative_path.as_deref()
    }
    /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
}
impl std::fmt::Debug for File {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("File");
        formatter.field("blob_id", &self.blob_id);
        formatter.field("absolute_path", &self.absolute_path);
        formatter.field("relative_path", &self.relative_path);
        formatter.field("file_mode", &self.file_mode);
        formatter.finish()
    }
}
/// See [`File`](crate::model::File)
pub mod file {
    /// A builder for [`File`](crate::model::File)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blob_id: std::option::Option<std::string::String>,
        pub(crate) absolute_path: std::option::Option<std::string::String>,
        pub(crate) relative_path: std::option::Option<std::string::String>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    }
    impl Builder {
        /// <p>The blob ID that contains the file information.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The blob ID that contains the file information.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// <p>The fully qualified path to the file in the repository.</p>
        pub fn absolute_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.absolute_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the file in the repository.</p>
        pub fn set_absolute_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.absolute_path = input;
            self
        }
        /// <p>The relative path of the file from the folder where the query originated.</p>
        pub fn relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.relative_path = Some(input.into());
            self
        }
        /// <p>The relative path of the file from the folder where the query originated.</p>
        pub fn set_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relative_path = input;
            self
        }
        /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`File`](crate::model::File)
        pub fn build(self) -> crate::model::File {
            crate::model::File {
                blob_id: self.blob_id,
                absolute_path: self.absolute_path,
                relative_path: self.relative_path,
                file_mode: self.file_mode,
            }
        }
    }
}
impl File {
    /// Creates a new builder-style object to manufacture [`File`](crate::model::File)
    pub fn builder() -> crate::model::file::Builder {
        crate::model::file::Builder::default()
    }
}

/// <p>Returns information about a folder in a repository.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Folder {
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
    pub tree_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified path of the folder in the repository.</p>
    pub absolute_path: std::option::Option<std::string::String>,
    /// <p>The relative path of the specified folder from the folder where the query originated.</p>
    pub relative_path: std::option::Option<std::string::String>,
}
impl Folder {
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
    /// <p>The fully qualified path of the folder in the repository.</p>
    pub fn absolute_path(&self) -> std::option::Option<&str> {
        self.absolute_path.as_deref()
    }
    /// <p>The relative path of the specified folder from the folder where the query originated.</p>
    pub fn relative_path(&self) -> std::option::Option<&str> {
        self.relative_path.as_deref()
    }
}
impl std::fmt::Debug for Folder {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Folder");
        formatter.field("tree_id", &self.tree_id);
        formatter.field("absolute_path", &self.absolute_path);
        formatter.field("relative_path", &self.relative_path);
        formatter.finish()
    }
}
/// See [`Folder`](crate::model::Folder)
pub mod folder {
    /// A builder for [`Folder`](crate::model::Folder)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tree_id: std::option::Option<std::string::String>,
        pub(crate) absolute_path: std::option::Option<std::string::String>,
        pub(crate) relative_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// <p>The fully qualified path of the folder in the repository.</p>
        pub fn absolute_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.absolute_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path of the folder in the repository.</p>
        pub fn set_absolute_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.absolute_path = input;
            self
        }
        /// <p>The relative path of the specified folder from the folder where the query originated.</p>
        pub fn relative_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.relative_path = Some(input.into());
            self
        }
        /// <p>The relative path of the specified folder from the folder where the query originated.</p>
        pub fn set_relative_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relative_path = input;
            self
        }
        /// Consumes the builder and constructs a [`Folder`](crate::model::Folder)
        pub fn build(self) -> crate::model::Folder {
            crate::model::Folder {
                tree_id: self.tree_id,
                absolute_path: self.absolute_path,
                relative_path: self.relative_path,
            }
        }
    }
}
impl Folder {
    /// Creates a new builder-style object to manufacture [`Folder`](crate::model::Folder)
    pub fn builder() -> crate::model::folder::Builder {
        crate::model::folder::Builder::default()
    }
}

/// <p>Returns information about a set of differences for a commit specifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Difference {
    /// <p>Information about a <code>beforeBlob</code> data type object, including the ID,
    /// the file mode permission code, and the path.</p>
    pub before_blob: std::option::Option<crate::model::BlobMetadata>,
    /// <p>Information about an <code>afterBlob</code> data type object, including the ID,
    /// the file mode permission code, and the path.</p>
    pub after_blob: std::option::Option<crate::model::BlobMetadata>,
    /// <p>Whether the change type of the difference is an addition (A), deletion (D), or modification (M).</p>
    pub change_type: std::option::Option<crate::model::ChangeTypeEnum>,
}
impl Difference {
    /// <p>Information about a <code>beforeBlob</code> data type object, including the ID,
    /// the file mode permission code, and the path.</p>
    pub fn before_blob(&self) -> std::option::Option<&crate::model::BlobMetadata> {
        self.before_blob.as_ref()
    }
    /// <p>Information about an <code>afterBlob</code> data type object, including the ID,
    /// the file mode permission code, and the path.</p>
    pub fn after_blob(&self) -> std::option::Option<&crate::model::BlobMetadata> {
        self.after_blob.as_ref()
    }
    /// <p>Whether the change type of the difference is an addition (A), deletion (D), or modification (M).</p>
    pub fn change_type(&self) -> std::option::Option<&crate::model::ChangeTypeEnum> {
        self.change_type.as_ref()
    }
}
impl std::fmt::Debug for Difference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Difference");
        formatter.field("before_blob", &self.before_blob);
        formatter.field("after_blob", &self.after_blob);
        formatter.field("change_type", &self.change_type);
        formatter.finish()
    }
}
/// See [`Difference`](crate::model::Difference)
pub mod difference {
    /// A builder for [`Difference`](crate::model::Difference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) before_blob: std::option::Option<crate::model::BlobMetadata>,
        pub(crate) after_blob: std::option::Option<crate::model::BlobMetadata>,
        pub(crate) change_type: std::option::Option<crate::model::ChangeTypeEnum>,
    }
    impl Builder {
        /// <p>Information about a <code>beforeBlob</code> data type object, including the ID,
        /// the file mode permission code, and the path.</p>
        pub fn before_blob(mut self, input: crate::model::BlobMetadata) -> Self {
            self.before_blob = Some(input);
            self
        }
        /// <p>Information about a <code>beforeBlob</code> data type object, including the ID,
        /// the file mode permission code, and the path.</p>
        pub fn set_before_blob(
            mut self,
            input: std::option::Option<crate::model::BlobMetadata>,
        ) -> Self {
            self.before_blob = input;
            self
        }
        /// <p>Information about an <code>afterBlob</code> data type object, including the ID,
        /// the file mode permission code, and the path.</p>
        pub fn after_blob(mut self, input: crate::model::BlobMetadata) -> Self {
            self.after_blob = Some(input);
            self
        }
        /// <p>Information about an <code>afterBlob</code> data type object, including the ID,
        /// the file mode permission code, and the path.</p>
        pub fn set_after_blob(
            mut self,
            input: std::option::Option<crate::model::BlobMetadata>,
        ) -> Self {
            self.after_blob = input;
            self
        }
        /// <p>Whether the change type of the difference is an addition (A), deletion (D), or modification (M).</p>
        pub fn change_type(mut self, input: crate::model::ChangeTypeEnum) -> Self {
            self.change_type = Some(input);
            self
        }
        /// <p>Whether the change type of the difference is an addition (A), deletion (D), or modification (M).</p>
        pub fn set_change_type(
            mut self,
            input: std::option::Option<crate::model::ChangeTypeEnum>,
        ) -> Self {
            self.change_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Difference`](crate::model::Difference)
        pub fn build(self) -> crate::model::Difference {
            crate::model::Difference {
                before_blob: self.before_blob,
                after_blob: self.after_blob,
                change_type: self.change_type,
            }
        }
    }
}
impl Difference {
    /// Creates a new builder-style object to manufacture [`Difference`](crate::model::Difference)
    pub fn builder() -> crate::model::difference::Builder {
        crate::model::difference::Builder::default()
    }
}

/// <p>Returns information about a specific Git blob object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlobMetadata {
    /// <p>The full ID of the blob.</p>
    pub blob_id: std::option::Option<std::string::String>,
    /// <p>The path to the blob and associated file name, if any.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The file mode permissions of the blob. File mode permission codes include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>100644</code> indicates read/write</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>100755</code> indicates read/write/execute</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>160000</code> indicates a submodule</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>120000</code> indicates a symlink</p>
    /// </li>
    /// </ul>
    pub mode: std::option::Option<std::string::String>,
}
impl BlobMetadata {
    /// <p>The full ID of the blob.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
    /// <p>The path to the blob and associated file name, if any.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>The file mode permissions of the blob. File mode permission codes include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>100644</code> indicates read/write</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>100755</code> indicates read/write/execute</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>160000</code> indicates a submodule</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>120000</code> indicates a symlink</p>
    /// </li>
    /// </ul>
    pub fn mode(&self) -> std::option::Option<&str> {
        self.mode.as_deref()
    }
}
impl std::fmt::Debug for BlobMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlobMetadata");
        formatter.field("blob_id", &self.blob_id);
        formatter.field("path", &self.path);
        formatter.field("mode", &self.mode);
        formatter.finish()
    }
}
/// See [`BlobMetadata`](crate::model::BlobMetadata)
pub mod blob_metadata {
    /// A builder for [`BlobMetadata`](crate::model::BlobMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blob_id: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) mode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full ID of the blob.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The full ID of the blob.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// <p>The path to the blob and associated file name, if any.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the blob and associated file name, if any.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The file mode permissions of the blob. File mode permission codes include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>100644</code> indicates read/write</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>100755</code> indicates read/write/execute</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>160000</code> indicates a submodule</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>120000</code> indicates a symlink</p>
        /// </li>
        /// </ul>
        pub fn mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.mode = Some(input.into());
            self
        }
        /// <p>The file mode permissions of the blob. File mode permission codes include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>100644</code> indicates read/write</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>100755</code> indicates read/write/execute</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>160000</code> indicates a submodule</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>120000</code> indicates a symlink</p>
        /// </li>
        /// </ul>
        pub fn set_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mode = input;
            self
        }
        /// Consumes the builder and constructs a [`BlobMetadata`](crate::model::BlobMetadata)
        pub fn build(self) -> crate::model::BlobMetadata {
            crate::model::BlobMetadata {
                blob_id: self.blob_id,
                path: self.path,
                mode: self.mode,
            }
        }
    }
}
impl BlobMetadata {
    /// Creates a new builder-style object to manufacture [`BlobMetadata`](crate::model::BlobMetadata)
    pub fn builder() -> crate::model::blob_metadata::Builder {
        crate::model::blob_metadata::Builder::default()
    }
}

/// <p>Returns information about a specific commit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Commit {
    /// <p>The full SHA ID of the specified commit. </p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>Tree information for the specified commit.</p>
    pub tree_id: std::option::Option<std::string::String>,
    /// <p>A list of parent commits for the specified commit. Each parent commit ID is the full commit ID.</p>
    pub parents: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The commit message associated with the specified commit.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Information about the author of the specified commit. Information includes
    /// the date in timestamp format with GMT offset, the name of the author, and the email address for the author, as configured
    /// in Git.</p>
    pub author: std::option::Option<crate::model::UserInfo>,
    /// <p>Information about the person who committed the specified commit, also known as the committer. Information includes
    /// the date in timestamp format with GMT offset, the name of the committer, and the email address for the committer, as configured
    /// in Git.</p>
    /// <p>For more information
    /// about the difference between an author and a committer in Git, see <a href="http://git-scm.com/book/ch2-3.html">Viewing the Commit History</a> in Pro Git
    /// by Scott Chacon and Ben Straub.</p>
    pub committer: std::option::Option<crate::model::UserInfo>,
    /// <p>Any other data associated with the specified commit.</p>
    pub additional_data: std::option::Option<std::string::String>,
}
impl Commit {
    /// <p>The full SHA ID of the specified commit. </p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>Tree information for the specified commit.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
    /// <p>A list of parent commits for the specified commit. Each parent commit ID is the full commit ID.</p>
    pub fn parents(&self) -> std::option::Option<&[std::string::String]> {
        self.parents.as_deref()
    }
    /// <p>The commit message associated with the specified commit.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Information about the author of the specified commit. Information includes
    /// the date in timestamp format with GMT offset, the name of the author, and the email address for the author, as configured
    /// in Git.</p>
    pub fn author(&self) -> std::option::Option<&crate::model::UserInfo> {
        self.author.as_ref()
    }
    /// <p>Information about the person who committed the specified commit, also known as the committer. Information includes
    /// the date in timestamp format with GMT offset, the name of the committer, and the email address for the committer, as configured
    /// in Git.</p>
    /// <p>For more information
    /// about the difference between an author and a committer in Git, see <a href="http://git-scm.com/book/ch2-3.html">Viewing the Commit History</a> in Pro Git
    /// by Scott Chacon and Ben Straub.</p>
    pub fn committer(&self) -> std::option::Option<&crate::model::UserInfo> {
        self.committer.as_ref()
    }
    /// <p>Any other data associated with the specified commit.</p>
    pub fn additional_data(&self) -> std::option::Option<&str> {
        self.additional_data.as_deref()
    }
}
impl std::fmt::Debug for Commit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Commit");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.field("parents", &self.parents);
        formatter.field("message", &self.message);
        formatter.field("author", &self.author);
        formatter.field("committer", &self.committer);
        formatter.field("additional_data", &self.additional_data);
        formatter.finish()
    }
}
/// See [`Commit`](crate::model::Commit)
pub mod commit {
    /// A builder for [`Commit`](crate::model::Commit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
        pub(crate) parents: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) author: std::option::Option<crate::model::UserInfo>,
        pub(crate) committer: std::option::Option<crate::model::UserInfo>,
        pub(crate) additional_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full SHA ID of the specified commit. </p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The full SHA ID of the specified commit. </p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>Tree information for the specified commit.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>Tree information for the specified commit.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Appends an item to `parents`.
        ///
        /// To override the contents of this collection use [`set_parents`](Self::set_parents).
        ///
        /// <p>A list of parent commits for the specified commit. Each parent commit ID is the full commit ID.</p>
        pub fn parents(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.parents.unwrap_or_default();
            v.push(input.into());
            self.parents = Some(v);
            self
        }
        /// <p>A list of parent commits for the specified commit. Each parent commit ID is the full commit ID.</p>
        pub fn set_parents(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.parents = input;
            self
        }
        /// <p>The commit message associated with the specified commit.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The commit message associated with the specified commit.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Information about the author of the specified commit. Information includes
        /// the date in timestamp format with GMT offset, the name of the author, and the email address for the author, as configured
        /// in Git.</p>
        pub fn author(mut self, input: crate::model::UserInfo) -> Self {
            self.author = Some(input);
            self
        }
        /// <p>Information about the author of the specified commit. Information includes
        /// the date in timestamp format with GMT offset, the name of the author, and the email address for the author, as configured
        /// in Git.</p>
        pub fn set_author(mut self, input: std::option::Option<crate::model::UserInfo>) -> Self {
            self.author = input;
            self
        }
        /// <p>Information about the person who committed the specified commit, also known as the committer. Information includes
        /// the date in timestamp format with GMT offset, the name of the committer, and the email address for the committer, as configured
        /// in Git.</p>
        /// <p>For more information
        /// about the difference between an author and a committer in Git, see <a href="http://git-scm.com/book/ch2-3.html">Viewing the Commit History</a> in Pro Git
        /// by Scott Chacon and Ben Straub.</p>
        pub fn committer(mut self, input: crate::model::UserInfo) -> Self {
            self.committer = Some(input);
            self
        }
        /// <p>Information about the person who committed the specified commit, also known as the committer. Information includes
        /// the date in timestamp format with GMT offset, the name of the committer, and the email address for the committer, as configured
        /// in Git.</p>
        /// <p>For more information
        /// about the difference between an author and a committer in Git, see <a href="http://git-scm.com/book/ch2-3.html">Viewing the Commit History</a> in Pro Git
        /// by Scott Chacon and Ben Straub.</p>
        pub fn set_committer(mut self, input: std::option::Option<crate::model::UserInfo>) -> Self {
            self.committer = input;
            self
        }
        /// <p>Any other data associated with the specified commit.</p>
        pub fn additional_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_data = Some(input.into());
            self
        }
        /// <p>Any other data associated with the specified commit.</p>
        pub fn set_additional_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_data = input;
            self
        }
        /// Consumes the builder and constructs a [`Commit`](crate::model::Commit)
        pub fn build(self) -> crate::model::Commit {
            crate::model::Commit {
                commit_id: self.commit_id,
                tree_id: self.tree_id,
                parents: self.parents,
                message: self.message,
                author: self.author,
                committer: self.committer,
                additional_data: self.additional_data,
            }
        }
    }
}
impl Commit {
    /// Creates a new builder-style object to manufacture [`Commit`](crate::model::Commit)
    pub fn builder() -> crate::model::commit::Builder {
        crate::model::commit::Builder::default()
    }
}

/// <p>Information about the user who made a specified commit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserInfo {
    /// <p>The name of the user who made the specified commit.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The email address associated with the user who made the commit, if any.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The date when the specified commit was commited, in timestamp format with GMT offset.</p>
    pub date: std::option::Option<std::string::String>,
}
impl UserInfo {
    /// <p>The name of the user who made the specified commit.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The email address associated with the user who made the commit, if any.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The date when the specified commit was commited, in timestamp format with GMT offset.</p>
    pub fn date(&self) -> std::option::Option<&str> {
        self.date.as_deref()
    }
}
impl std::fmt::Debug for UserInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserInfo");
        formatter.field("name", &self.name);
        formatter.field("email", &self.email);
        formatter.field("date", &self.date);
        formatter.finish()
    }
}
/// See [`UserInfo`](crate::model::UserInfo)
pub mod user_info {
    /// A builder for [`UserInfo`](crate::model::UserInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the user who made the specified commit.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the user who made the specified commit.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The email address associated with the user who made the commit, if any.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address associated with the user who made the commit, if any.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The date when the specified commit was commited, in timestamp format with GMT offset.</p>
        pub fn date(mut self, input: impl Into<std::string::String>) -> Self {
            self.date = Some(input.into());
            self
        }
        /// <p>The date when the specified commit was commited, in timestamp format with GMT offset.</p>
        pub fn set_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date = input;
            self
        }
        /// Consumes the builder and constructs a [`UserInfo`](crate::model::UserInfo)
        pub fn build(self) -> crate::model::UserInfo {
            crate::model::UserInfo {
                name: self.name,
                email: self.email,
                date: self.date,
            }
        }
    }
}
impl UserInfo {
    /// Creates a new builder-style object to manufacture [`UserInfo`](crate::model::UserInfo)
    pub fn builder() -> crate::model::user_info::Builder {
        crate::model::user_info::Builder::default()
    }
}

/// <p>Returns information about comments on a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommentsForPullRequest {
    /// <p>The system-generated ID of the pull request.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The name of the repository that contains the pull request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit that was the tip of the destination branch when the
    /// pull request was created. This commit is superceded by the after commit in the source
    /// branch when and if you merge the source branch into the destination branch.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit that was the tip of the source branch at the time the
    /// comment was made. </p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>The full blob ID of the file on which you want to comment on the destination commit.</p>
    pub before_blob_id: std::option::Option<std::string::String>,
    /// <p>The full blob ID of the file on which you want to comment on the source commit.</p>
    pub after_blob_id: std::option::Option<std::string::String>,
    /// <p>Location information about the comment on the pull request, including the file name,
    /// line number, and whether the version of the file where the comment was made is BEFORE
    /// (destination branch) or AFTER (source branch).</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>An array of comment objects. Each comment object contains information about a comment on the pull request.</p>
    pub comments: std::option::Option<std::vec::Vec<crate::model::Comment>>,
}
impl CommentsForPullRequest {
    /// <p>The system-generated ID of the pull request.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The name of the repository that contains the pull request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the commit that was the tip of the destination branch when the
    /// pull request was created. This commit is superceded by the after commit in the source
    /// branch when and if you merge the source branch into the destination branch.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>The full commit ID of the commit that was the tip of the source branch at the time the
    /// comment was made. </p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>The full blob ID of the file on which you want to comment on the destination commit.</p>
    pub fn before_blob_id(&self) -> std::option::Option<&str> {
        self.before_blob_id.as_deref()
    }
    /// <p>The full blob ID of the file on which you want to comment on the source commit.</p>
    pub fn after_blob_id(&self) -> std::option::Option<&str> {
        self.after_blob_id.as_deref()
    }
    /// <p>Location information about the comment on the pull request, including the file name,
    /// line number, and whether the version of the file where the comment was made is BEFORE
    /// (destination branch) or AFTER (source branch).</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>An array of comment objects. Each comment object contains information about a comment on the pull request.</p>
    pub fn comments(&self) -> std::option::Option<&[crate::model::Comment]> {
        self.comments.as_deref()
    }
}
impl std::fmt::Debug for CommentsForPullRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommentsForPullRequest");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("before_blob_id", &self.before_blob_id);
        formatter.field("after_blob_id", &self.after_blob_id);
        formatter.field("location", &self.location);
        formatter.field("comments", &self.comments);
        formatter.finish()
    }
}
/// See [`CommentsForPullRequest`](crate::model::CommentsForPullRequest)
pub mod comments_for_pull_request {
    /// A builder for [`CommentsForPullRequest`](crate::model::CommentsForPullRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) before_blob_id: std::option::Option<std::string::String>,
        pub(crate) after_blob_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) comments: std::option::Option<std::vec::Vec<crate::model::Comment>>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the commit that was the tip of the destination branch when the
        /// pull request was created. This commit is superceded by the after commit in the source
        /// branch when and if you merge the source branch into the destination branch.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit that was the tip of the destination branch when the
        /// pull request was created. This commit is superceded by the after commit in the source
        /// branch when and if you merge the source branch into the destination branch.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>The full commit ID of the commit that was the tip of the source branch at the time the
        /// comment was made. </p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit that was the tip of the source branch at the time the
        /// comment was made. </p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>The full blob ID of the file on which you want to comment on the destination commit.</p>
        pub fn before_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_blob_id = Some(input.into());
            self
        }
        /// <p>The full blob ID of the file on which you want to comment on the destination commit.</p>
        pub fn set_before_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_blob_id = input;
            self
        }
        /// <p>The full blob ID of the file on which you want to comment on the source commit.</p>
        pub fn after_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_blob_id = Some(input.into());
            self
        }
        /// <p>The full blob ID of the file on which you want to comment on the source commit.</p>
        pub fn set_after_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_blob_id = input;
            self
        }
        /// <p>Location information about the comment on the pull request, including the file name,
        /// line number, and whether the version of the file where the comment was made is BEFORE
        /// (destination branch) or AFTER (source branch).</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Location information about the comment on the pull request, including the file name,
        /// line number, and whether the version of the file where the comment was made is BEFORE
        /// (destination branch) or AFTER (source branch).</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// Appends an item to `comments`.
        ///
        /// To override the contents of this collection use [`set_comments`](Self::set_comments).
        ///
        /// <p>An array of comment objects. Each comment object contains information about a comment on the pull request.</p>
        pub fn comments(mut self, input: impl Into<crate::model::Comment>) -> Self {
            let mut v = self.comments.unwrap_or_default();
            v.push(input.into());
            self.comments = Some(v);
            self
        }
        /// <p>An array of comment objects. Each comment object contains information about a comment on the pull request.</p>
        pub fn set_comments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Comment>>,
        ) -> Self {
            self.comments = input;
            self
        }
        /// Consumes the builder and constructs a [`CommentsForPullRequest`](crate::model::CommentsForPullRequest)
        pub fn build(self) -> crate::model::CommentsForPullRequest {
            crate::model::CommentsForPullRequest {
                pull_request_id: self.pull_request_id,
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                before_blob_id: self.before_blob_id,
                after_blob_id: self.after_blob_id,
                location: self.location,
                comments: self.comments,
            }
        }
    }
}
impl CommentsForPullRequest {
    /// Creates a new builder-style object to manufacture [`CommentsForPullRequest`](crate::model::CommentsForPullRequest)
    pub fn builder() -> crate::model::comments_for_pull_request::Builder {
        crate::model::comments_for_pull_request::Builder::default()
    }
}

/// <p>Returns information about comments on the comparison between two commits.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommentsForComparedCommit {
    /// <p>The name of the repository that contains the compared commits.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit used to establish the before of the
    /// comparison.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit used to establish the after of the comparison.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>The full blob ID of the commit used to establish the before of the comparison.</p>
    pub before_blob_id: std::option::Option<std::string::String>,
    /// <p>The full blob ID of the commit used to establish the after of the comparison.</p>
    pub after_blob_id: std::option::Option<std::string::String>,
    /// <p>Location information about the comment on the comparison, including the file name,
    /// line number, and whether the version of the file where the comment was made is BEFORE or
    /// AFTER.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>An array of comment objects. Each comment object contains information about a comment on the comparison
    /// between commits.</p>
    pub comments: std::option::Option<std::vec::Vec<crate::model::Comment>>,
}
impl CommentsForComparedCommit {
    /// <p>The name of the repository that contains the compared commits.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the commit used to establish the before of the
    /// comparison.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>The full commit ID of the commit used to establish the after of the comparison.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>The full blob ID of the commit used to establish the before of the comparison.</p>
    pub fn before_blob_id(&self) -> std::option::Option<&str> {
        self.before_blob_id.as_deref()
    }
    /// <p>The full blob ID of the commit used to establish the after of the comparison.</p>
    pub fn after_blob_id(&self) -> std::option::Option<&str> {
        self.after_blob_id.as_deref()
    }
    /// <p>Location information about the comment on the comparison, including the file name,
    /// line number, and whether the version of the file where the comment was made is BEFORE or
    /// AFTER.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>An array of comment objects. Each comment object contains information about a comment on the comparison
    /// between commits.</p>
    pub fn comments(&self) -> std::option::Option<&[crate::model::Comment]> {
        self.comments.as_deref()
    }
}
impl std::fmt::Debug for CommentsForComparedCommit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommentsForComparedCommit");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("before_blob_id", &self.before_blob_id);
        formatter.field("after_blob_id", &self.after_blob_id);
        formatter.field("location", &self.location);
        formatter.field("comments", &self.comments);
        formatter.finish()
    }
}
/// See [`CommentsForComparedCommit`](crate::model::CommentsForComparedCommit)
pub mod comments_for_compared_commit {
    /// A builder for [`CommentsForComparedCommit`](crate::model::CommentsForComparedCommit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) before_blob_id: std::option::Option<std::string::String>,
        pub(crate) after_blob_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) comments: std::option::Option<std::vec::Vec<crate::model::Comment>>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the compared commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the compared commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the commit used to establish the before of the
        /// comparison.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit used to establish the before of the
        /// comparison.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>The full commit ID of the commit used to establish the after of the comparison.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit used to establish the after of the comparison.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>The full blob ID of the commit used to establish the before of the comparison.</p>
        pub fn before_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_blob_id = Some(input.into());
            self
        }
        /// <p>The full blob ID of the commit used to establish the before of the comparison.</p>
        pub fn set_before_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_blob_id = input;
            self
        }
        /// <p>The full blob ID of the commit used to establish the after of the comparison.</p>
        pub fn after_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_blob_id = Some(input.into());
            self
        }
        /// <p>The full blob ID of the commit used to establish the after of the comparison.</p>
        pub fn set_after_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_blob_id = input;
            self
        }
        /// <p>Location information about the comment on the comparison, including the file name,
        /// line number, and whether the version of the file where the comment was made is BEFORE or
        /// AFTER.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Location information about the comment on the comparison, including the file name,
        /// line number, and whether the version of the file where the comment was made is BEFORE or
        /// AFTER.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// Appends an item to `comments`.
        ///
        /// To override the contents of this collection use [`set_comments`](Self::set_comments).
        ///
        /// <p>An array of comment objects. Each comment object contains information about a comment on the comparison
        /// between commits.</p>
        pub fn comments(mut self, input: impl Into<crate::model::Comment>) -> Self {
            let mut v = self.comments.unwrap_or_default();
            v.push(input.into());
            self.comments = Some(v);
            self
        }
        /// <p>An array of comment objects. Each comment object contains information about a comment on the comparison
        /// between commits.</p>
        pub fn set_comments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Comment>>,
        ) -> Self {
            self.comments = input;
            self
        }
        /// Consumes the builder and constructs a [`CommentsForComparedCommit`](crate::model::CommentsForComparedCommit)
        pub fn build(self) -> crate::model::CommentsForComparedCommit {
            crate::model::CommentsForComparedCommit {
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                before_blob_id: self.before_blob_id,
                after_blob_id: self.after_blob_id,
                location: self.location,
                comments: self.comments,
            }
        }
    }
}
impl CommentsForComparedCommit {
    /// Creates a new builder-style object to manufacture [`CommentsForComparedCommit`](crate::model::CommentsForComparedCommit)
    pub fn builder() -> crate::model::comments_for_compared_commit::Builder {
        crate::model::comments_for_compared_commit::Builder::default()
    }
}

/// <p>Information about the reaction values provided by users on a comment.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactionForComment {
    /// <p>The reaction for a specified comment.</p>
    pub reaction: std::option::Option<crate::model::ReactionValueFormats>,
    /// <p>The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.</p>
    pub reaction_users: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A numerical count of users who reacted with the specified emoji whose identities have been subsequently deleted
    /// from IAM. While these IAM users or roles no longer exist, the reactions might still appear in total reaction counts.</p>
    pub reactions_from_deleted_users_count: std::option::Option<i32>,
}
impl ReactionForComment {
    /// <p>The reaction for a specified comment.</p>
    pub fn reaction(&self) -> std::option::Option<&crate::model::ReactionValueFormats> {
        self.reaction.as_ref()
    }
    /// <p>The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.</p>
    pub fn reaction_users(&self) -> std::option::Option<&[std::string::String]> {
        self.reaction_users.as_deref()
    }
    /// <p>A numerical count of users who reacted with the specified emoji whose identities have been subsequently deleted
    /// from IAM. While these IAM users or roles no longer exist, the reactions might still appear in total reaction counts.</p>
    pub fn reactions_from_deleted_users_count(&self) -> std::option::Option<i32> {
        self.reactions_from_deleted_users_count
    }
}
impl std::fmt::Debug for ReactionForComment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactionForComment");
        formatter.field("reaction", &self.reaction);
        formatter.field("reaction_users", &self.reaction_users);
        formatter.field(
            "reactions_from_deleted_users_count",
            &self.reactions_from_deleted_users_count,
        );
        formatter.finish()
    }
}
/// See [`ReactionForComment`](crate::model::ReactionForComment)
pub mod reaction_for_comment {
    /// A builder for [`ReactionForComment`](crate::model::ReactionForComment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reaction: std::option::Option<crate::model::ReactionValueFormats>,
        pub(crate) reaction_users: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) reactions_from_deleted_users_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The reaction for a specified comment.</p>
        pub fn reaction(mut self, input: crate::model::ReactionValueFormats) -> Self {
            self.reaction = Some(input);
            self
        }
        /// <p>The reaction for a specified comment.</p>
        pub fn set_reaction(
            mut self,
            input: std::option::Option<crate::model::ReactionValueFormats>,
        ) -> Self {
            self.reaction = input;
            self
        }
        /// Appends an item to `reaction_users`.
        ///
        /// To override the contents of this collection use [`set_reaction_users`](Self::set_reaction_users).
        ///
        /// <p>The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.</p>
        pub fn reaction_users(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reaction_users.unwrap_or_default();
            v.push(input.into());
            self.reaction_users = Some(v);
            self
        }
        /// <p>The Amazon Resource Names (ARNs) of users who have provided reactions to the comment.</p>
        pub fn set_reaction_users(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reaction_users = input;
            self
        }
        /// <p>A numerical count of users who reacted with the specified emoji whose identities have been subsequently deleted
        /// from IAM. While these IAM users or roles no longer exist, the reactions might still appear in total reaction counts.</p>
        pub fn reactions_from_deleted_users_count(mut self, input: i32) -> Self {
            self.reactions_from_deleted_users_count = Some(input);
            self
        }
        /// <p>A numerical count of users who reacted with the specified emoji whose identities have been subsequently deleted
        /// from IAM. While these IAM users or roles no longer exist, the reactions might still appear in total reaction counts.</p>
        pub fn set_reactions_from_deleted_users_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.reactions_from_deleted_users_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactionForComment`](crate::model::ReactionForComment)
        pub fn build(self) -> crate::model::ReactionForComment {
            crate::model::ReactionForComment {
                reaction: self.reaction,
                reaction_users: self.reaction_users,
                reactions_from_deleted_users_count: self.reactions_from_deleted_users_count,
            }
        }
    }
}
impl ReactionForComment {
    /// Creates a new builder-style object to manufacture [`ReactionForComment`](crate::model::ReactionForComment)
    pub fn builder() -> crate::model::reaction_for_comment::Builder {
        crate::model::reaction_for_comment::Builder::default()
    }
}

/// <p>Information about the values for reactions to a comment. AWS CodeCommit supports a limited set of reactions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReactionValueFormats {
    /// <p>The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on different operating systems.</p>
    pub emoji: std::option::Option<std::string::String>,
    /// <p>The emoji short code for the reaction. Short codes are interpreted slightly differently on different operating systems. </p>
    pub short_code: std::option::Option<std::string::String>,
    /// <p>The Unicode codepoint for the reaction.</p>
    pub unicode: std::option::Option<std::string::String>,
}
impl ReactionValueFormats {
    /// <p>The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on different operating systems.</p>
    pub fn emoji(&self) -> std::option::Option<&str> {
        self.emoji.as_deref()
    }
    /// <p>The emoji short code for the reaction. Short codes are interpreted slightly differently on different operating systems. </p>
    pub fn short_code(&self) -> std::option::Option<&str> {
        self.short_code.as_deref()
    }
    /// <p>The Unicode codepoint for the reaction.</p>
    pub fn unicode(&self) -> std::option::Option<&str> {
        self.unicode.as_deref()
    }
}
impl std::fmt::Debug for ReactionValueFormats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReactionValueFormats");
        formatter.field("emoji", &self.emoji);
        formatter.field("short_code", &self.short_code);
        formatter.field("unicode", &self.unicode);
        formatter.finish()
    }
}
/// See [`ReactionValueFormats`](crate::model::ReactionValueFormats)
pub mod reaction_value_formats {
    /// A builder for [`ReactionValueFormats`](crate::model::ReactionValueFormats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) emoji: std::option::Option<std::string::String>,
        pub(crate) short_code: std::option::Option<std::string::String>,
        pub(crate) unicode: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on different operating systems.</p>
        pub fn emoji(mut self, input: impl Into<std::string::String>) -> Self {
            self.emoji = Some(input.into());
            self
        }
        /// <p>The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on different operating systems.</p>
        pub fn set_emoji(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.emoji = input;
            self
        }
        /// <p>The emoji short code for the reaction. Short codes are interpreted slightly differently on different operating systems. </p>
        pub fn short_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.short_code = Some(input.into());
            self
        }
        /// <p>The emoji short code for the reaction. Short codes are interpreted slightly differently on different operating systems. </p>
        pub fn set_short_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.short_code = input;
            self
        }
        /// <p>The Unicode codepoint for the reaction.</p>
        pub fn unicode(mut self, input: impl Into<std::string::String>) -> Self {
            self.unicode = Some(input.into());
            self
        }
        /// <p>The Unicode codepoint for the reaction.</p>
        pub fn set_unicode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unicode = input;
            self
        }
        /// Consumes the builder and constructs a [`ReactionValueFormats`](crate::model::ReactionValueFormats)
        pub fn build(self) -> crate::model::ReactionValueFormats {
            crate::model::ReactionValueFormats {
                emoji: self.emoji,
                short_code: self.short_code,
                unicode: self.unicode,
            }
        }
    }
}
impl ReactionValueFormats {
    /// Creates a new builder-style object to manufacture [`ReactionValueFormats`](crate::model::ReactionValueFormats)
    pub fn builder() -> crate::model::reaction_value_formats::Builder {
        crate::model::reaction_value_formats::Builder::default()
    }
}

/// <p>Returns information about a branch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BranchInfo {
    /// <p>The name of the branch.</p>
    pub branch_name: std::option::Option<std::string::String>,
    /// <p>The ID of the last commit made to the branch.</p>
    pub commit_id: std::option::Option<std::string::String>,
}
impl BranchInfo {
    /// <p>The name of the branch.</p>
    pub fn branch_name(&self) -> std::option::Option<&str> {
        self.branch_name.as_deref()
    }
    /// <p>The ID of the last commit made to the branch.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
}
impl std::fmt::Debug for BranchInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BranchInfo");
        formatter.field("branch_name", &self.branch_name);
        formatter.field("commit_id", &self.commit_id);
        formatter.finish()
    }
}
/// See [`BranchInfo`](crate::model::BranchInfo)
pub mod branch_info {
    /// A builder for [`BranchInfo`](crate::model::BranchInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch_name: std::option::Option<std::string::String>,
        pub(crate) commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the branch.</p>
        pub fn branch_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_name = Some(input.into());
            self
        }
        /// <p>The name of the branch.</p>
        pub fn set_branch_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.branch_name = input;
            self
        }
        /// <p>The ID of the last commit made to the branch.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The ID of the last commit made to the branch.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BranchInfo`](crate::model::BranchInfo)
        pub fn build(self) -> crate::model::BranchInfo {
            crate::model::BranchInfo {
                branch_name: self.branch_name,
                commit_id: self.commit_id,
            }
        }
    }
}
impl BranchInfo {
    /// Creates a new builder-style object to manufacture [`BranchInfo`](crate::model::BranchInfo)
    pub fn builder() -> crate::model::branch_info::Builder {
        crate::model::branch_info::Builder::default()
    }
}

/// <p>Returns information about the approval rules applied to a pull request and whether conditions have been met.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Evaluation {
    /// <p>Whether the state of the pull request is approved.</p>
    pub approved: bool,
    /// <p>Whether the approval rule requirements for the pull request have been overridden and no longer need to be met.</p>
    pub overridden: bool,
    /// <p>The names of the approval rules that have had their conditions met.</p>
    pub approval_rules_satisfied: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of the approval rules that have not had their conditions met.</p>
    pub approval_rules_not_satisfied: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Evaluation {
    /// <p>Whether the state of the pull request is approved.</p>
    pub fn approved(&self) -> bool {
        self.approved
    }
    /// <p>Whether the approval rule requirements for the pull request have been overridden and no longer need to be met.</p>
    pub fn overridden(&self) -> bool {
        self.overridden
    }
    /// <p>The names of the approval rules that have had their conditions met.</p>
    pub fn approval_rules_satisfied(&self) -> std::option::Option<&[std::string::String]> {
        self.approval_rules_satisfied.as_deref()
    }
    /// <p>The names of the approval rules that have not had their conditions met.</p>
    pub fn approval_rules_not_satisfied(&self) -> std::option::Option<&[std::string::String]> {
        self.approval_rules_not_satisfied.as_deref()
    }
}
impl std::fmt::Debug for Evaluation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Evaluation");
        formatter.field("approved", &self.approved);
        formatter.field("overridden", &self.overridden);
        formatter.field("approval_rules_satisfied", &self.approval_rules_satisfied);
        formatter.field(
            "approval_rules_not_satisfied",
            &self.approval_rules_not_satisfied,
        );
        formatter.finish()
    }
}
/// See [`Evaluation`](crate::model::Evaluation)
pub mod evaluation {
    /// A builder for [`Evaluation`](crate::model::Evaluation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approved: std::option::Option<bool>,
        pub(crate) overridden: std::option::Option<bool>,
        pub(crate) approval_rules_satisfied:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) approval_rules_not_satisfied:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Whether the state of the pull request is approved.</p>
        pub fn approved(mut self, input: bool) -> Self {
            self.approved = Some(input);
            self
        }
        /// <p>Whether the state of the pull request is approved.</p>
        pub fn set_approved(mut self, input: std::option::Option<bool>) -> Self {
            self.approved = input;
            self
        }
        /// <p>Whether the approval rule requirements for the pull request have been overridden and no longer need to be met.</p>
        pub fn overridden(mut self, input: bool) -> Self {
            self.overridden = Some(input);
            self
        }
        /// <p>Whether the approval rule requirements for the pull request have been overridden and no longer need to be met.</p>
        pub fn set_overridden(mut self, input: std::option::Option<bool>) -> Self {
            self.overridden = input;
            self
        }
        /// Appends an item to `approval_rules_satisfied`.
        ///
        /// To override the contents of this collection use [`set_approval_rules_satisfied`](Self::set_approval_rules_satisfied).
        ///
        /// <p>The names of the approval rules that have had their conditions met.</p>
        pub fn approval_rules_satisfied(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.approval_rules_satisfied.unwrap_or_default();
            v.push(input.into());
            self.approval_rules_satisfied = Some(v);
            self
        }
        /// <p>The names of the approval rules that have had their conditions met.</p>
        pub fn set_approval_rules_satisfied(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approval_rules_satisfied = input;
            self
        }
        /// Appends an item to `approval_rules_not_satisfied`.
        ///
        /// To override the contents of this collection use [`set_approval_rules_not_satisfied`](Self::set_approval_rules_not_satisfied).
        ///
        /// <p>The names of the approval rules that have not had their conditions met.</p>
        pub fn approval_rules_not_satisfied(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.approval_rules_not_satisfied.unwrap_or_default();
            v.push(input.into());
            self.approval_rules_not_satisfied = Some(v);
            self
        }
        /// <p>The names of the approval rules that have not had their conditions met.</p>
        pub fn set_approval_rules_not_satisfied(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approval_rules_not_satisfied = input;
            self
        }
        /// Consumes the builder and constructs a [`Evaluation`](crate::model::Evaluation)
        pub fn build(self) -> crate::model::Evaluation {
            crate::model::Evaluation {
                approved: self.approved.unwrap_or_default(),
                overridden: self.overridden.unwrap_or_default(),
                approval_rules_satisfied: self.approval_rules_satisfied,
                approval_rules_not_satisfied: self.approval_rules_not_satisfied,
            }
        }
    }
}
impl Evaluation {
    /// Creates a new builder-style object to manufacture [`Evaluation`](crate::model::Evaluation)
    pub fn builder() -> crate::model::evaluation::Builder {
        crate::model::evaluation::Builder::default()
    }
}

/// <p>Returns information about a pull request event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullRequestEvent {
    /// <p>The system-generated ID of the pull request.</p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The day and time of the pull request event, in timestamp format.</p>
    pub event_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of the pull request event (for example, a status change event
    /// (PULL_REQUEST_STATUS_CHANGED) or update event
    /// (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).</p>
    pub pull_request_event_type: std::option::Option<crate::model::PullRequestEventType>,
    /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event.
    /// Examples include updating the pull request with more commits or changing the status of a
    /// pull request.</p>
    pub actor_arn: std::option::Option<std::string::String>,
    /// <p>Information about the source and destination branches for the pull request.</p>
    pub pull_request_created_event_metadata:
        std::option::Option<crate::model::PullRequestCreatedEventMetadata>,
    /// <p>Information about the change in status for the pull request event.</p>
    pub pull_request_status_changed_event_metadata:
        std::option::Option<crate::model::PullRequestStatusChangedEventMetadata>,
    /// <p>Information about the updated source branch for the pull request event. </p>
    pub pull_request_source_reference_updated_event_metadata:
        std::option::Option<crate::model::PullRequestSourceReferenceUpdatedEventMetadata>,
    /// <p>Information about the change in mergability state for the pull request event.</p>
    pub pull_request_merged_state_changed_event_metadata:
        std::option::Option<crate::model::PullRequestMergedStateChangedEventMetadata>,
    /// <p>Information about a pull request event.</p>
    pub approval_rule_event_metadata: std::option::Option<crate::model::ApprovalRuleEventMetadata>,
    /// <p>Information about an approval state change for a pull request.</p>
    pub approval_state_changed_event_metadata:
        std::option::Option<crate::model::ApprovalStateChangedEventMetadata>,
    /// <p>Information about an approval rule override event for a pull request.</p>
    pub approval_rule_overridden_event_metadata:
        std::option::Option<crate::model::ApprovalRuleOverriddenEventMetadata>,
}
impl PullRequestEvent {
    /// <p>The system-generated ID of the pull request.</p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The day and time of the pull request event, in timestamp format.</p>
    pub fn event_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.event_date.as_ref()
    }
    /// <p>The type of the pull request event (for example, a status change event
    /// (PULL_REQUEST_STATUS_CHANGED) or update event
    /// (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).</p>
    pub fn pull_request_event_type(
        &self,
    ) -> std::option::Option<&crate::model::PullRequestEventType> {
        self.pull_request_event_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event.
    /// Examples include updating the pull request with more commits or changing the status of a
    /// pull request.</p>
    pub fn actor_arn(&self) -> std::option::Option<&str> {
        self.actor_arn.as_deref()
    }
    /// <p>Information about the source and destination branches for the pull request.</p>
    pub fn pull_request_created_event_metadata(
        &self,
    ) -> std::option::Option<&crate::model::PullRequestCreatedEventMetadata> {
        self.pull_request_created_event_metadata.as_ref()
    }
    /// <p>Information about the change in status for the pull request event.</p>
    pub fn pull_request_status_changed_event_metadata(
        &self,
    ) -> std::option::Option<&crate::model::PullRequestStatusChangedEventMetadata> {
        self.pull_request_status_changed_event_metadata.as_ref()
    }
    /// <p>Information about the updated source branch for the pull request event. </p>
    pub fn pull_request_source_reference_updated_event_metadata(
        &self,
    ) -> std::option::Option<&crate::model::PullRequestSourceReferenceUpdatedEventMetadata> {
        self.pull_request_source_reference_updated_event_metadata
            .as_ref()
    }
    /// <p>Information about the change in mergability state for the pull request event.</p>
    pub fn pull_request_merged_state_changed_event_metadata(
        &self,
    ) -> std::option::Option<&crate::model::PullRequestMergedStateChangedEventMetadata> {
        self.pull_request_merged_state_changed_event_metadata
            .as_ref()
    }
    /// <p>Information about a pull request event.</p>
    pub fn approval_rule_event_metadata(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalRuleEventMetadata> {
        self.approval_rule_event_metadata.as_ref()
    }
    /// <p>Information about an approval state change for a pull request.</p>
    pub fn approval_state_changed_event_metadata(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalStateChangedEventMetadata> {
        self.approval_state_changed_event_metadata.as_ref()
    }
    /// <p>Information about an approval rule override event for a pull request.</p>
    pub fn approval_rule_overridden_event_metadata(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalRuleOverriddenEventMetadata> {
        self.approval_rule_overridden_event_metadata.as_ref()
    }
}
impl std::fmt::Debug for PullRequestEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullRequestEvent");
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("event_date", &self.event_date);
        formatter.field("pull_request_event_type", &self.pull_request_event_type);
        formatter.field("actor_arn", &self.actor_arn);
        formatter.field(
            "pull_request_created_event_metadata",
            &self.pull_request_created_event_metadata,
        );
        formatter.field(
            "pull_request_status_changed_event_metadata",
            &self.pull_request_status_changed_event_metadata,
        );
        formatter.field(
            "pull_request_source_reference_updated_event_metadata",
            &self.pull_request_source_reference_updated_event_metadata,
        );
        formatter.field(
            "pull_request_merged_state_changed_event_metadata",
            &self.pull_request_merged_state_changed_event_metadata,
        );
        formatter.field(
            "approval_rule_event_metadata",
            &self.approval_rule_event_metadata,
        );
        formatter.field(
            "approval_state_changed_event_metadata",
            &self.approval_state_changed_event_metadata,
        );
        formatter.field(
            "approval_rule_overridden_event_metadata",
            &self.approval_rule_overridden_event_metadata,
        );
        formatter.finish()
    }
}
/// See [`PullRequestEvent`](crate::model::PullRequestEvent)
pub mod pull_request_event {
    /// A builder for [`PullRequestEvent`](crate::model::PullRequestEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) event_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) pull_request_event_type: std::option::Option<crate::model::PullRequestEventType>,
        pub(crate) actor_arn: std::option::Option<std::string::String>,
        pub(crate) pull_request_created_event_metadata:
            std::option::Option<crate::model::PullRequestCreatedEventMetadata>,
        pub(crate) pull_request_status_changed_event_metadata:
            std::option::Option<crate::model::PullRequestStatusChangedEventMetadata>,
        pub(crate) pull_request_source_reference_updated_event_metadata:
            std::option::Option<crate::model::PullRequestSourceReferenceUpdatedEventMetadata>,
        pub(crate) pull_request_merged_state_changed_event_metadata:
            std::option::Option<crate::model::PullRequestMergedStateChangedEventMetadata>,
        pub(crate) approval_rule_event_metadata:
            std::option::Option<crate::model::ApprovalRuleEventMetadata>,
        pub(crate) approval_state_changed_event_metadata:
            std::option::Option<crate::model::ApprovalStateChangedEventMetadata>,
        pub(crate) approval_rule_overridden_event_metadata:
            std::option::Option<crate::model::ApprovalRuleOverriddenEventMetadata>,
    }
    impl Builder {
        /// <p>The system-generated ID of the pull request.</p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request.</p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The day and time of the pull request event, in timestamp format.</p>
        pub fn event_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.event_date = Some(input);
            self
        }
        /// <p>The day and time of the pull request event, in timestamp format.</p>
        pub fn set_event_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.event_date = input;
            self
        }
        /// <p>The type of the pull request event (for example, a status change event
        /// (PULL_REQUEST_STATUS_CHANGED) or update event
        /// (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).</p>
        pub fn pull_request_event_type(
            mut self,
            input: crate::model::PullRequestEventType,
        ) -> Self {
            self.pull_request_event_type = Some(input);
            self
        }
        /// <p>The type of the pull request event (for example, a status change event
        /// (PULL_REQUEST_STATUS_CHANGED) or update event
        /// (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).</p>
        pub fn set_pull_request_event_type(
            mut self,
            input: std::option::Option<crate::model::PullRequestEventType>,
        ) -> Self {
            self.pull_request_event_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event.
        /// Examples include updating the pull request with more commits or changing the status of a
        /// pull request.</p>
        pub fn actor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.actor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user whose actions resulted in the event.
        /// Examples include updating the pull request with more commits or changing the status of a
        /// pull request.</p>
        pub fn set_actor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.actor_arn = input;
            self
        }
        /// <p>Information about the source and destination branches for the pull request.</p>
        pub fn pull_request_created_event_metadata(
            mut self,
            input: crate::model::PullRequestCreatedEventMetadata,
        ) -> Self {
            self.pull_request_created_event_metadata = Some(input);
            self
        }
        /// <p>Information about the source and destination branches for the pull request.</p>
        pub fn set_pull_request_created_event_metadata(
            mut self,
            input: std::option::Option<crate::model::PullRequestCreatedEventMetadata>,
        ) -> Self {
            self.pull_request_created_event_metadata = input;
            self
        }
        /// <p>Information about the change in status for the pull request event.</p>
        pub fn pull_request_status_changed_event_metadata(
            mut self,
            input: crate::model::PullRequestStatusChangedEventMetadata,
        ) -> Self {
            self.pull_request_status_changed_event_metadata = Some(input);
            self
        }
        /// <p>Information about the change in status for the pull request event.</p>
        pub fn set_pull_request_status_changed_event_metadata(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusChangedEventMetadata>,
        ) -> Self {
            self.pull_request_status_changed_event_metadata = input;
            self
        }
        /// <p>Information about the updated source branch for the pull request event. </p>
        pub fn pull_request_source_reference_updated_event_metadata(
            mut self,
            input: crate::model::PullRequestSourceReferenceUpdatedEventMetadata,
        ) -> Self {
            self.pull_request_source_reference_updated_event_metadata = Some(input);
            self
        }
        /// <p>Information about the updated source branch for the pull request event. </p>
        pub fn set_pull_request_source_reference_updated_event_metadata(
            mut self,
            input: std::option::Option<
                crate::model::PullRequestSourceReferenceUpdatedEventMetadata,
            >,
        ) -> Self {
            self.pull_request_source_reference_updated_event_metadata = input;
            self
        }
        /// <p>Information about the change in mergability state for the pull request event.</p>
        pub fn pull_request_merged_state_changed_event_metadata(
            mut self,
            input: crate::model::PullRequestMergedStateChangedEventMetadata,
        ) -> Self {
            self.pull_request_merged_state_changed_event_metadata = Some(input);
            self
        }
        /// <p>Information about the change in mergability state for the pull request event.</p>
        pub fn set_pull_request_merged_state_changed_event_metadata(
            mut self,
            input: std::option::Option<crate::model::PullRequestMergedStateChangedEventMetadata>,
        ) -> Self {
            self.pull_request_merged_state_changed_event_metadata = input;
            self
        }
        /// <p>Information about a pull request event.</p>
        pub fn approval_rule_event_metadata(
            mut self,
            input: crate::model::ApprovalRuleEventMetadata,
        ) -> Self {
            self.approval_rule_event_metadata = Some(input);
            self
        }
        /// <p>Information about a pull request event.</p>
        pub fn set_approval_rule_event_metadata(
            mut self,
            input: std::option::Option<crate::model::ApprovalRuleEventMetadata>,
        ) -> Self {
            self.approval_rule_event_metadata = input;
            self
        }
        /// <p>Information about an approval state change for a pull request.</p>
        pub fn approval_state_changed_event_metadata(
            mut self,
            input: crate::model::ApprovalStateChangedEventMetadata,
        ) -> Self {
            self.approval_state_changed_event_metadata = Some(input);
            self
        }
        /// <p>Information about an approval state change for a pull request.</p>
        pub fn set_approval_state_changed_event_metadata(
            mut self,
            input: std::option::Option<crate::model::ApprovalStateChangedEventMetadata>,
        ) -> Self {
            self.approval_state_changed_event_metadata = input;
            self
        }
        /// <p>Information about an approval rule override event for a pull request.</p>
        pub fn approval_rule_overridden_event_metadata(
            mut self,
            input: crate::model::ApprovalRuleOverriddenEventMetadata,
        ) -> Self {
            self.approval_rule_overridden_event_metadata = Some(input);
            self
        }
        /// <p>Information about an approval rule override event for a pull request.</p>
        pub fn set_approval_rule_overridden_event_metadata(
            mut self,
            input: std::option::Option<crate::model::ApprovalRuleOverriddenEventMetadata>,
        ) -> Self {
            self.approval_rule_overridden_event_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`PullRequestEvent`](crate::model::PullRequestEvent)
        pub fn build(self) -> crate::model::PullRequestEvent {
            crate::model::PullRequestEvent {
                pull_request_id: self.pull_request_id,
                event_date: self.event_date,
                pull_request_event_type: self.pull_request_event_type,
                actor_arn: self.actor_arn,
                pull_request_created_event_metadata: self.pull_request_created_event_metadata,
                pull_request_status_changed_event_metadata: self
                    .pull_request_status_changed_event_metadata,
                pull_request_source_reference_updated_event_metadata: self
                    .pull_request_source_reference_updated_event_metadata,
                pull_request_merged_state_changed_event_metadata: self
                    .pull_request_merged_state_changed_event_metadata,
                approval_rule_event_metadata: self.approval_rule_event_metadata,
                approval_state_changed_event_metadata: self.approval_state_changed_event_metadata,
                approval_rule_overridden_event_metadata: self
                    .approval_rule_overridden_event_metadata,
            }
        }
    }
}
impl PullRequestEvent {
    /// Creates a new builder-style object to manufacture [`PullRequestEvent`](crate::model::PullRequestEvent)
    pub fn builder() -> crate::model::pull_request_event::Builder {
        crate::model::pull_request_event::Builder::default()
    }
}

/// <p>Returns information about an override event for approval rules for a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalRuleOverriddenEventMetadata {
    /// <p>The revision ID of the pull request when the override event occurred.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The status of the override event.</p>
    pub override_status: std::option::Option<crate::model::OverrideStatus>,
}
impl ApprovalRuleOverriddenEventMetadata {
    /// <p>The revision ID of the pull request when the override event occurred.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The status of the override event.</p>
    pub fn override_status(&self) -> std::option::Option<&crate::model::OverrideStatus> {
        self.override_status.as_ref()
    }
}
impl std::fmt::Debug for ApprovalRuleOverriddenEventMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalRuleOverriddenEventMetadata");
        formatter.field("revision_id", &self.revision_id);
        formatter.field("override_status", &self.override_status);
        formatter.finish()
    }
}
/// See [`ApprovalRuleOverriddenEventMetadata`](crate::model::ApprovalRuleOverriddenEventMetadata)
pub mod approval_rule_overridden_event_metadata {
    /// A builder for [`ApprovalRuleOverriddenEventMetadata`](crate::model::ApprovalRuleOverriddenEventMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) override_status: std::option::Option<crate::model::OverrideStatus>,
    }
    impl Builder {
        /// <p>The revision ID of the pull request when the override event occurred.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the pull request when the override event occurred.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The status of the override event.</p>
        pub fn override_status(mut self, input: crate::model::OverrideStatus) -> Self {
            self.override_status = Some(input);
            self
        }
        /// <p>The status of the override event.</p>
        pub fn set_override_status(
            mut self,
            input: std::option::Option<crate::model::OverrideStatus>,
        ) -> Self {
            self.override_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalRuleOverriddenEventMetadata`](crate::model::ApprovalRuleOverriddenEventMetadata)
        pub fn build(self) -> crate::model::ApprovalRuleOverriddenEventMetadata {
            crate::model::ApprovalRuleOverriddenEventMetadata {
                revision_id: self.revision_id,
                override_status: self.override_status,
            }
        }
    }
}
impl ApprovalRuleOverriddenEventMetadata {
    /// Creates a new builder-style object to manufacture [`ApprovalRuleOverriddenEventMetadata`](crate::model::ApprovalRuleOverriddenEventMetadata)
    pub fn builder() -> crate::model::approval_rule_overridden_event_metadata::Builder {
        crate::model::approval_rule_overridden_event_metadata::Builder::default()
    }
}

/// <p>Returns information about a change in the approval state for a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalStateChangedEventMetadata {
    /// <p>The revision ID of the pull request when the approval state changed.</p>
    pub revision_id: std::option::Option<std::string::String>,
    /// <p>The approval status for the pull request.</p>
    pub approval_status: std::option::Option<crate::model::ApprovalState>,
}
impl ApprovalStateChangedEventMetadata {
    /// <p>The revision ID of the pull request when the approval state changed.</p>
    pub fn revision_id(&self) -> std::option::Option<&str> {
        self.revision_id.as_deref()
    }
    /// <p>The approval status for the pull request.</p>
    pub fn approval_status(&self) -> std::option::Option<&crate::model::ApprovalState> {
        self.approval_status.as_ref()
    }
}
impl std::fmt::Debug for ApprovalStateChangedEventMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalStateChangedEventMetadata");
        formatter.field("revision_id", &self.revision_id);
        formatter.field("approval_status", &self.approval_status);
        formatter.finish()
    }
}
/// See [`ApprovalStateChangedEventMetadata`](crate::model::ApprovalStateChangedEventMetadata)
pub mod approval_state_changed_event_metadata {
    /// A builder for [`ApprovalStateChangedEventMetadata`](crate::model::ApprovalStateChangedEventMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision_id: std::option::Option<std::string::String>,
        pub(crate) approval_status: std::option::Option<crate::model::ApprovalState>,
    }
    impl Builder {
        /// <p>The revision ID of the pull request when the approval state changed.</p>
        pub fn revision_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision_id = Some(input.into());
            self
        }
        /// <p>The revision ID of the pull request when the approval state changed.</p>
        pub fn set_revision_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision_id = input;
            self
        }
        /// <p>The approval status for the pull request.</p>
        pub fn approval_status(mut self, input: crate::model::ApprovalState) -> Self {
            self.approval_status = Some(input);
            self
        }
        /// <p>The approval status for the pull request.</p>
        pub fn set_approval_status(
            mut self,
            input: std::option::Option<crate::model::ApprovalState>,
        ) -> Self {
            self.approval_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalStateChangedEventMetadata`](crate::model::ApprovalStateChangedEventMetadata)
        pub fn build(self) -> crate::model::ApprovalStateChangedEventMetadata {
            crate::model::ApprovalStateChangedEventMetadata {
                revision_id: self.revision_id,
                approval_status: self.approval_status,
            }
        }
    }
}
impl ApprovalStateChangedEventMetadata {
    /// Creates a new builder-style object to manufacture [`ApprovalStateChangedEventMetadata`](crate::model::ApprovalStateChangedEventMetadata)
    pub fn builder() -> crate::model::approval_state_changed_event_metadata::Builder {
        crate::model::approval_state_changed_event_metadata::Builder::default()
    }
}

/// <p>Returns information about an event for an approval rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalRuleEventMetadata {
    /// <p>The name of the approval rule.</p>
    pub approval_rule_name: std::option::Option<std::string::String>,
    /// <p>The system-generated ID of the approval rule.</p>
    pub approval_rule_id: std::option::Option<std::string::String>,
    /// <p>The content of the approval rule.</p>
    pub approval_rule_content: std::option::Option<std::string::String>,
}
impl ApprovalRuleEventMetadata {
    /// <p>The name of the approval rule.</p>
    pub fn approval_rule_name(&self) -> std::option::Option<&str> {
        self.approval_rule_name.as_deref()
    }
    /// <p>The system-generated ID of the approval rule.</p>
    pub fn approval_rule_id(&self) -> std::option::Option<&str> {
        self.approval_rule_id.as_deref()
    }
    /// <p>The content of the approval rule.</p>
    pub fn approval_rule_content(&self) -> std::option::Option<&str> {
        self.approval_rule_content.as_deref()
    }
}
impl std::fmt::Debug for ApprovalRuleEventMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalRuleEventMetadata");
        formatter.field("approval_rule_name", &self.approval_rule_name);
        formatter.field("approval_rule_id", &self.approval_rule_id);
        formatter.field("approval_rule_content", &self.approval_rule_content);
        formatter.finish()
    }
}
/// See [`ApprovalRuleEventMetadata`](crate::model::ApprovalRuleEventMetadata)
pub mod approval_rule_event_metadata {
    /// A builder for [`ApprovalRuleEventMetadata`](crate::model::ApprovalRuleEventMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_name: std::option::Option<std::string::String>,
        pub(crate) approval_rule_id: std::option::Option<std::string::String>,
        pub(crate) approval_rule_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the approval rule.</p>
        pub fn approval_rule_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_name = Some(input.into());
            self
        }
        /// <p>The name of the approval rule.</p>
        pub fn set_approval_rule_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_name = input;
            self
        }
        /// <p>The system-generated ID of the approval rule.</p>
        pub fn approval_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the approval rule.</p>
        pub fn set_approval_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_id = input;
            self
        }
        /// <p>The content of the approval rule.</p>
        pub fn approval_rule_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_content = Some(input.into());
            self
        }
        /// <p>The content of the approval rule.</p>
        pub fn set_approval_rule_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_content = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalRuleEventMetadata`](crate::model::ApprovalRuleEventMetadata)
        pub fn build(self) -> crate::model::ApprovalRuleEventMetadata {
            crate::model::ApprovalRuleEventMetadata {
                approval_rule_name: self.approval_rule_name,
                approval_rule_id: self.approval_rule_id,
                approval_rule_content: self.approval_rule_content,
            }
        }
    }
}
impl ApprovalRuleEventMetadata {
    /// Creates a new builder-style object to manufacture [`ApprovalRuleEventMetadata`](crate::model::ApprovalRuleEventMetadata)
    pub fn builder() -> crate::model::approval_rule_event_metadata::Builder {
        crate::model::approval_rule_event_metadata::Builder::default()
    }
}

/// <p>Returns information about the change in the merge state for a pull request event. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullRequestMergedStateChangedEventMetadata {
    /// <p>The name of the repository where the pull request was created.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The name of the branch that the pull request is merged into.</p>
    pub destination_reference: std::option::Option<std::string::String>,
    /// <p>Information about the merge state change event.</p>
    pub merge_metadata: std::option::Option<crate::model::MergeMetadata>,
}
impl PullRequestMergedStateChangedEventMetadata {
    /// <p>The name of the repository where the pull request was created.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The name of the branch that the pull request is merged into.</p>
    pub fn destination_reference(&self) -> std::option::Option<&str> {
        self.destination_reference.as_deref()
    }
    /// <p>Information about the merge state change event.</p>
    pub fn merge_metadata(&self) -> std::option::Option<&crate::model::MergeMetadata> {
        self.merge_metadata.as_ref()
    }
}
impl std::fmt::Debug for PullRequestMergedStateChangedEventMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullRequestMergedStateChangedEventMetadata");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("destination_reference", &self.destination_reference);
        formatter.field("merge_metadata", &self.merge_metadata);
        formatter.finish()
    }
}
/// See [`PullRequestMergedStateChangedEventMetadata`](crate::model::PullRequestMergedStateChangedEventMetadata)
pub mod pull_request_merged_state_changed_event_metadata {
    /// A builder for [`PullRequestMergedStateChangedEventMetadata`](crate::model::PullRequestMergedStateChangedEventMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) destination_reference: std::option::Option<std::string::String>,
        pub(crate) merge_metadata: std::option::Option<crate::model::MergeMetadata>,
    }
    impl Builder {
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The name of the branch that the pull request is merged into.</p>
        pub fn destination_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_reference = Some(input.into());
            self
        }
        /// <p>The name of the branch that the pull request is merged into.</p>
        pub fn set_destination_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_reference = input;
            self
        }
        /// <p>Information about the merge state change event.</p>
        pub fn merge_metadata(mut self, input: crate::model::MergeMetadata) -> Self {
            self.merge_metadata = Some(input);
            self
        }
        /// <p>Information about the merge state change event.</p>
        pub fn set_merge_metadata(
            mut self,
            input: std::option::Option<crate::model::MergeMetadata>,
        ) -> Self {
            self.merge_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`PullRequestMergedStateChangedEventMetadata`](crate::model::PullRequestMergedStateChangedEventMetadata)
        pub fn build(self) -> crate::model::PullRequestMergedStateChangedEventMetadata {
            crate::model::PullRequestMergedStateChangedEventMetadata {
                repository_name: self.repository_name,
                destination_reference: self.destination_reference,
                merge_metadata: self.merge_metadata,
            }
        }
    }
}
impl PullRequestMergedStateChangedEventMetadata {
    /// Creates a new builder-style object to manufacture [`PullRequestMergedStateChangedEventMetadata`](crate::model::PullRequestMergedStateChangedEventMetadata)
    pub fn builder() -> crate::model::pull_request_merged_state_changed_event_metadata::Builder {
        crate::model::pull_request_merged_state_changed_event_metadata::Builder::default()
    }
}

/// <p>Information about an update to the source branch of a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullRequestSourceReferenceUpdatedEventMetadata {
    /// <p>The name of the repository where the pull request was updated.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was updated.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull request was updated.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
    pub merge_base: std::option::Option<std::string::String>,
}
impl PullRequestSourceReferenceUpdatedEventMetadata {
    /// <p>The name of the repository where the pull request was updated.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was updated.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull request was updated.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
    pub fn merge_base(&self) -> std::option::Option<&str> {
        self.merge_base.as_deref()
    }
}
impl std::fmt::Debug for PullRequestSourceReferenceUpdatedEventMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullRequestSourceReferenceUpdatedEventMetadata");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("merge_base", &self.merge_base);
        formatter.finish()
    }
}
/// See [`PullRequestSourceReferenceUpdatedEventMetadata`](crate::model::PullRequestSourceReferenceUpdatedEventMetadata)
pub mod pull_request_source_reference_updated_event_metadata {
    /// A builder for [`PullRequestSourceReferenceUpdatedEventMetadata`](crate::model::PullRequestSourceReferenceUpdatedEventMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) merge_base: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where the pull request was updated.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was updated.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was updated.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the destination branch that was the tip of the branch at the time the pull request was updated.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull request was updated.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the source branch that was the tip of the branch at the time the pull request was updated.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
        pub fn merge_base(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_base = Some(input.into());
            self
        }
        /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
        pub fn set_merge_base(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merge_base = input;
            self
        }
        /// Consumes the builder and constructs a [`PullRequestSourceReferenceUpdatedEventMetadata`](crate::model::PullRequestSourceReferenceUpdatedEventMetadata)
        pub fn build(self) -> crate::model::PullRequestSourceReferenceUpdatedEventMetadata {
            crate::model::PullRequestSourceReferenceUpdatedEventMetadata {
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                merge_base: self.merge_base,
            }
        }
    }
}
impl PullRequestSourceReferenceUpdatedEventMetadata {
    /// Creates a new builder-style object to manufacture [`PullRequestSourceReferenceUpdatedEventMetadata`](crate::model::PullRequestSourceReferenceUpdatedEventMetadata)
    pub fn builder() -> crate::model::pull_request_source_reference_updated_event_metadata::Builder
    {
        crate::model::pull_request_source_reference_updated_event_metadata::Builder::default()
    }
}

/// <p>Information about a change to the status of a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullRequestStatusChangedEventMetadata {
    /// <p>The changed status of the pull request.</p>
    pub pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
}
impl PullRequestStatusChangedEventMetadata {
    /// <p>The changed status of the pull request.</p>
    pub fn pull_request_status(&self) -> std::option::Option<&crate::model::PullRequestStatusEnum> {
        self.pull_request_status.as_ref()
    }
}
impl std::fmt::Debug for PullRequestStatusChangedEventMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullRequestStatusChangedEventMetadata");
        formatter.field("pull_request_status", &self.pull_request_status);
        formatter.finish()
    }
}
/// See [`PullRequestStatusChangedEventMetadata`](crate::model::PullRequestStatusChangedEventMetadata)
pub mod pull_request_status_changed_event_metadata {
    /// A builder for [`PullRequestStatusChangedEventMetadata`](crate::model::PullRequestStatusChangedEventMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_status: std::option::Option<crate::model::PullRequestStatusEnum>,
    }
    impl Builder {
        /// <p>The changed status of the pull request.</p>
        pub fn pull_request_status(mut self, input: crate::model::PullRequestStatusEnum) -> Self {
            self.pull_request_status = Some(input);
            self
        }
        /// <p>The changed status of the pull request.</p>
        pub fn set_pull_request_status(
            mut self,
            input: std::option::Option<crate::model::PullRequestStatusEnum>,
        ) -> Self {
            self.pull_request_status = input;
            self
        }
        /// Consumes the builder and constructs a [`PullRequestStatusChangedEventMetadata`](crate::model::PullRequestStatusChangedEventMetadata)
        pub fn build(self) -> crate::model::PullRequestStatusChangedEventMetadata {
            crate::model::PullRequestStatusChangedEventMetadata {
                pull_request_status: self.pull_request_status,
            }
        }
    }
}
impl PullRequestStatusChangedEventMetadata {
    /// Creates a new builder-style object to manufacture [`PullRequestStatusChangedEventMetadata`](crate::model::PullRequestStatusChangedEventMetadata)
    pub fn builder() -> crate::model::pull_request_status_changed_event_metadata::Builder {
        crate::model::pull_request_status_changed_event_metadata::Builder::default()
    }
}

/// <p>Metadata about the pull request that is used when comparing the pull request source with its destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PullRequestCreatedEventMetadata {
    /// <p>The name of the repository where the pull request was created.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The commit ID on the source branch used when the pull request was created.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the tip of the branch specified as the destination branch when the pull request was created.</p>
    pub destination_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
    pub merge_base: std::option::Option<std::string::String>,
}
impl PullRequestCreatedEventMetadata {
    /// <p>The name of the repository where the pull request was created.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The commit ID on the source branch used when the pull request was created.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The commit ID of the tip of the branch specified as the destination branch when the pull request was created.</p>
    pub fn destination_commit_id(&self) -> std::option::Option<&str> {
        self.destination_commit_id.as_deref()
    }
    /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
    pub fn merge_base(&self) -> std::option::Option<&str> {
        self.merge_base.as_deref()
    }
}
impl std::fmt::Debug for PullRequestCreatedEventMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PullRequestCreatedEventMetadata");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("destination_commit_id", &self.destination_commit_id);
        formatter.field("merge_base", &self.merge_base);
        formatter.finish()
    }
}
/// See [`PullRequestCreatedEventMetadata`](crate::model::PullRequestCreatedEventMetadata)
pub mod pull_request_created_event_metadata {
    /// A builder for [`PullRequestCreatedEventMetadata`](crate::model::PullRequestCreatedEventMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) destination_commit_id: std::option::Option<std::string::String>,
        pub(crate) merge_base: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the pull request was created.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The commit ID on the source branch used when the pull request was created.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID on the source branch used when the pull request was created.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The commit ID of the tip of the branch specified as the destination branch when the pull request was created.</p>
        pub fn destination_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the tip of the branch specified as the destination branch when the pull request was created.</p>
        pub fn set_destination_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_id = input;
            self
        }
        /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
        pub fn merge_base(mut self, input: impl Into<std::string::String>) -> Self {
            self.merge_base = Some(input.into());
            self
        }
        /// <p>The commit ID of the most recent commit that the source branch and the destination branch have in common.</p>
        pub fn set_merge_base(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.merge_base = input;
            self
        }
        /// Consumes the builder and constructs a [`PullRequestCreatedEventMetadata`](crate::model::PullRequestCreatedEventMetadata)
        pub fn build(self) -> crate::model::PullRequestCreatedEventMetadata {
            crate::model::PullRequestCreatedEventMetadata {
                repository_name: self.repository_name,
                source_commit_id: self.source_commit_id,
                destination_commit_id: self.destination_commit_id,
                merge_base: self.merge_base,
            }
        }
    }
}
impl PullRequestCreatedEventMetadata {
    /// Creates a new builder-style object to manufacture [`PullRequestCreatedEventMetadata`](crate::model::PullRequestCreatedEventMetadata)
    pub fn builder() -> crate::model::pull_request_created_event_metadata::Builder {
        crate::model::pull_request_created_event_metadata::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PullRequestEventType {
    #[allow(missing_docs)] // documentation missing in model
    PullRequestApprovalRuleCreated,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestApprovalRuleDeleted,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestApprovalRuleOverridden,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestApprovalRuleUpdated,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestApprovalStateChanged,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestCreated,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestMergeStateChanged,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestSourceReferenceUpdated,
    #[allow(missing_docs)] // documentation missing in model
    PullRequestStatusChanged,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PullRequestEventType {
    fn from(s: &str) -> Self {
        match s {
            "PULL_REQUEST_APPROVAL_RULE_CREATED" => {
                PullRequestEventType::PullRequestApprovalRuleCreated
            }
            "PULL_REQUEST_APPROVAL_RULE_DELETED" => {
                PullRequestEventType::PullRequestApprovalRuleDeleted
            }
            "PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN" => {
                PullRequestEventType::PullRequestApprovalRuleOverridden
            }
            "PULL_REQUEST_APPROVAL_RULE_UPDATED" => {
                PullRequestEventType::PullRequestApprovalRuleUpdated
            }
            "PULL_REQUEST_APPROVAL_STATE_CHANGED" => {
                PullRequestEventType::PullRequestApprovalStateChanged
            }
            "PULL_REQUEST_CREATED" => PullRequestEventType::PullRequestCreated,
            "PULL_REQUEST_MERGE_STATE_CHANGED" => {
                PullRequestEventType::PullRequestMergeStateChanged
            }
            "PULL_REQUEST_SOURCE_REFERENCE_UPDATED" => {
                PullRequestEventType::PullRequestSourceReferenceUpdated
            }
            "PULL_REQUEST_STATUS_CHANGED" => PullRequestEventType::PullRequestStatusChanged,
            other => PullRequestEventType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PullRequestEventType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PullRequestEventType::from(s))
    }
}
impl PullRequestEventType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PullRequestEventType::PullRequestApprovalRuleCreated => {
                "PULL_REQUEST_APPROVAL_RULE_CREATED"
            }
            PullRequestEventType::PullRequestApprovalRuleDeleted => {
                "PULL_REQUEST_APPROVAL_RULE_DELETED"
            }
            PullRequestEventType::PullRequestApprovalRuleOverridden => {
                "PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN"
            }
            PullRequestEventType::PullRequestApprovalRuleUpdated => {
                "PULL_REQUEST_APPROVAL_RULE_UPDATED"
            }
            PullRequestEventType::PullRequestApprovalStateChanged => {
                "PULL_REQUEST_APPROVAL_STATE_CHANGED"
            }
            PullRequestEventType::PullRequestCreated => "PULL_REQUEST_CREATED",
            PullRequestEventType::PullRequestMergeStateChanged => {
                "PULL_REQUEST_MERGE_STATE_CHANGED"
            }
            PullRequestEventType::PullRequestSourceReferenceUpdated => {
                "PULL_REQUEST_SOURCE_REFERENCE_UPDATED"
            }
            PullRequestEventType::PullRequestStatusChanged => "PULL_REQUEST_STATUS_CHANGED",
            PullRequestEventType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "PULL_REQUEST_APPROVAL_RULE_CREATED",
            "PULL_REQUEST_APPROVAL_RULE_DELETED",
            "PULL_REQUEST_APPROVAL_RULE_OVERRIDDEN",
            "PULL_REQUEST_APPROVAL_RULE_UPDATED",
            "PULL_REQUEST_APPROVAL_STATE_CHANGED",
            "PULL_REQUEST_CREATED",
            "PULL_REQUEST_MERGE_STATE_CHANGED",
            "PULL_REQUEST_SOURCE_REFERENCE_UPDATED",
            "PULL_REQUEST_STATUS_CHANGED",
        ]
    }
}
impl AsRef<str> for PullRequestEventType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about merge hunks in a merge or pull request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeHunk {
    /// <p>A Boolean value indicating whether a combination of hunks contains a conflict.
    /// Conflicts occur when the same file or the same lines in a file were modified in both the
    /// source and destination of a merge or pull request. Valid values include true, false, and
    /// null. True when the hunk represents a conflict and one or more files contains a line
    /// conflict. File mode conflicts in a merge do not set this to true.</p>
    pub is_conflict: bool,
    /// <p>Information about the merge hunk in the source of a merge or pull request.</p>
    pub source: std::option::Option<crate::model::MergeHunkDetail>,
    /// <p>Information about the merge hunk in the destination of a merge or pull request.</p>
    pub destination: std::option::Option<crate::model::MergeHunkDetail>,
    /// <p>Information about the merge hunk in the base of a merge or pull request.</p>
    pub base: std::option::Option<crate::model::MergeHunkDetail>,
}
impl MergeHunk {
    /// <p>A Boolean value indicating whether a combination of hunks contains a conflict.
    /// Conflicts occur when the same file or the same lines in a file were modified in both the
    /// source and destination of a merge or pull request. Valid values include true, false, and
    /// null. True when the hunk represents a conflict and one or more files contains a line
    /// conflict. File mode conflicts in a merge do not set this to true.</p>
    pub fn is_conflict(&self) -> bool {
        self.is_conflict
    }
    /// <p>Information about the merge hunk in the source of a merge or pull request.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::MergeHunkDetail> {
        self.source.as_ref()
    }
    /// <p>Information about the merge hunk in the destination of a merge or pull request.</p>
    pub fn destination(&self) -> std::option::Option<&crate::model::MergeHunkDetail> {
        self.destination.as_ref()
    }
    /// <p>Information about the merge hunk in the base of a merge or pull request.</p>
    pub fn base(&self) -> std::option::Option<&crate::model::MergeHunkDetail> {
        self.base.as_ref()
    }
}
impl std::fmt::Debug for MergeHunk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeHunk");
        formatter.field("is_conflict", &self.is_conflict);
        formatter.field("source", &self.source);
        formatter.field("destination", &self.destination);
        formatter.field("base", &self.base);
        formatter.finish()
    }
}
/// See [`MergeHunk`](crate::model::MergeHunk)
pub mod merge_hunk {
    /// A builder for [`MergeHunk`](crate::model::MergeHunk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_conflict: std::option::Option<bool>,
        pub(crate) source: std::option::Option<crate::model::MergeHunkDetail>,
        pub(crate) destination: std::option::Option<crate::model::MergeHunkDetail>,
        pub(crate) base: std::option::Option<crate::model::MergeHunkDetail>,
    }
    impl Builder {
        /// <p>A Boolean value indicating whether a combination of hunks contains a conflict.
        /// Conflicts occur when the same file or the same lines in a file were modified in both the
        /// source and destination of a merge or pull request. Valid values include true, false, and
        /// null. True when the hunk represents a conflict and one or more files contains a line
        /// conflict. File mode conflicts in a merge do not set this to true.</p>
        pub fn is_conflict(mut self, input: bool) -> Self {
            self.is_conflict = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether a combination of hunks contains a conflict.
        /// Conflicts occur when the same file or the same lines in a file were modified in both the
        /// source and destination of a merge or pull request. Valid values include true, false, and
        /// null. True when the hunk represents a conflict and one or more files contains a line
        /// conflict. File mode conflicts in a merge do not set this to true.</p>
        pub fn set_is_conflict(mut self, input: std::option::Option<bool>) -> Self {
            self.is_conflict = input;
            self
        }
        /// <p>Information about the merge hunk in the source of a merge or pull request.</p>
        pub fn source(mut self, input: crate::model::MergeHunkDetail) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>Information about the merge hunk in the source of a merge or pull request.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::MergeHunkDetail>,
        ) -> Self {
            self.source = input;
            self
        }
        /// <p>Information about the merge hunk in the destination of a merge or pull request.</p>
        pub fn destination(mut self, input: crate::model::MergeHunkDetail) -> Self {
            self.destination = Some(input);
            self
        }
        /// <p>Information about the merge hunk in the destination of a merge or pull request.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::MergeHunkDetail>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// <p>Information about the merge hunk in the base of a merge or pull request.</p>
        pub fn base(mut self, input: crate::model::MergeHunkDetail) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>Information about the merge hunk in the base of a merge or pull request.</p>
        pub fn set_base(
            mut self,
            input: std::option::Option<crate::model::MergeHunkDetail>,
        ) -> Self {
            self.base = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeHunk`](crate::model::MergeHunk)
        pub fn build(self) -> crate::model::MergeHunk {
            crate::model::MergeHunk {
                is_conflict: self.is_conflict.unwrap_or_default(),
                source: self.source,
                destination: self.destination,
                base: self.base,
            }
        }
    }
}
impl MergeHunk {
    /// Creates a new builder-style object to manufacture [`MergeHunk`](crate::model::MergeHunk)
    pub fn builder() -> crate::model::merge_hunk::Builder {
        crate::model::merge_hunk::Builder::default()
    }
}

/// <p>Information about the details of a merge hunk that contains a conflict in a merge or pull request operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeHunkDetail {
    /// <p>The start position of the hunk in the merge result.</p>
    pub start_line: std::option::Option<i32>,
    /// <p>The end position of the hunk in the merge result.</p>
    pub end_line: std::option::Option<i32>,
    /// <p>The base-64 encoded content of the hunk merged region that might contain a
    /// conflict.</p>
    pub hunk_content: std::option::Option<std::string::String>,
}
impl MergeHunkDetail {
    /// <p>The start position of the hunk in the merge result.</p>
    pub fn start_line(&self) -> std::option::Option<i32> {
        self.start_line
    }
    /// <p>The end position of the hunk in the merge result.</p>
    pub fn end_line(&self) -> std::option::Option<i32> {
        self.end_line
    }
    /// <p>The base-64 encoded content of the hunk merged region that might contain a
    /// conflict.</p>
    pub fn hunk_content(&self) -> std::option::Option<&str> {
        self.hunk_content.as_deref()
    }
}
impl std::fmt::Debug for MergeHunkDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeHunkDetail");
        formatter.field("start_line", &self.start_line);
        formatter.field("end_line", &self.end_line);
        formatter.field("hunk_content", &self.hunk_content);
        formatter.finish()
    }
}
/// See [`MergeHunkDetail`](crate::model::MergeHunkDetail)
pub mod merge_hunk_detail {
    /// A builder for [`MergeHunkDetail`](crate::model::MergeHunkDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_line: std::option::Option<i32>,
        pub(crate) end_line: std::option::Option<i32>,
        pub(crate) hunk_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start position of the hunk in the merge result.</p>
        pub fn start_line(mut self, input: i32) -> Self {
            self.start_line = Some(input);
            self
        }
        /// <p>The start position of the hunk in the merge result.</p>
        pub fn set_start_line(mut self, input: std::option::Option<i32>) -> Self {
            self.start_line = input;
            self
        }
        /// <p>The end position of the hunk in the merge result.</p>
        pub fn end_line(mut self, input: i32) -> Self {
            self.end_line = Some(input);
            self
        }
        /// <p>The end position of the hunk in the merge result.</p>
        pub fn set_end_line(mut self, input: std::option::Option<i32>) -> Self {
            self.end_line = input;
            self
        }
        /// <p>The base-64 encoded content of the hunk merged region that might contain a
        /// conflict.</p>
        pub fn hunk_content(mut self, input: impl Into<std::string::String>) -> Self {
            self.hunk_content = Some(input.into());
            self
        }
        /// <p>The base-64 encoded content of the hunk merged region that might contain a
        /// conflict.</p>
        pub fn set_hunk_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.hunk_content = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeHunkDetail`](crate::model::MergeHunkDetail)
        pub fn build(self) -> crate::model::MergeHunkDetail {
            crate::model::MergeHunkDetail {
                start_line: self.start_line,
                end_line: self.end_line,
                hunk_content: self.hunk_content,
            }
        }
    }
}
impl MergeHunkDetail {
    /// Creates a new builder-style object to manufacture [`MergeHunkDetail`](crate::model::MergeHunkDetail)
    pub fn builder() -> crate::model::merge_hunk_detail::Builder {
        crate::model::merge_hunk_detail::Builder::default()
    }
}

/// <p>Returns information about a target for a pull request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Target {
    /// <p>The name of the repository that contains the pull request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
    pub source_reference: std::option::Option<std::string::String>,
    /// <p>The branch of the repository where the pull request changes are merged. Also known as
    /// the destination branch.</p>
    pub destination_reference: std::option::Option<std::string::String>,
}
impl Target {
    /// <p>The name of the repository that contains the pull request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
    pub fn source_reference(&self) -> std::option::Option<&str> {
        self.source_reference.as_deref()
    }
    /// <p>The branch of the repository where the pull request changes are merged. Also known as
    /// the destination branch.</p>
    pub fn destination_reference(&self) -> std::option::Option<&str> {
        self.destination_reference.as_deref()
    }
}
impl std::fmt::Debug for Target {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Target");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("source_reference", &self.source_reference);
        formatter.field("destination_reference", &self.destination_reference);
        formatter.finish()
    }
}
/// See [`Target`](crate::model::Target)
pub mod target {
    /// A builder for [`Target`](crate::model::Target)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) source_reference: std::option::Option<std::string::String>,
        pub(crate) destination_reference: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository that contains the pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
        pub fn source_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_reference = Some(input.into());
            self
        }
        /// <p>The branch of the repository that contains the changes for the pull request. Also known as the source branch.</p>
        pub fn set_source_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_reference = input;
            self
        }
        /// <p>The branch of the repository where the pull request changes are merged. Also known as
        /// the destination branch.</p>
        pub fn destination_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_reference = Some(input.into());
            self
        }
        /// <p>The branch of the repository where the pull request changes are merged. Also known as
        /// the destination branch.</p>
        pub fn set_destination_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_reference = input;
            self
        }
        /// Consumes the builder and constructs a [`Target`](crate::model::Target)
        pub fn build(self) -> crate::model::Target {
            crate::model::Target {
                repository_name: self.repository_name,
                source_reference: self.source_reference,
                destination_reference: self.destination_reference,
            }
        }
    }
}
impl Target {
    /// Creates a new builder-style object to manufacture [`Target`](crate::model::Target)
    pub fn builder() -> crate::model::target::Builder {
        crate::model::target::Builder::default()
    }
}

/// <p>A file to be added, updated, or deleted as part of a commit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileMetadata {
    /// <p>The full path to the file to be added or updated, including the name of the
    /// file.</p>
    pub absolute_path: std::option::Option<std::string::String>,
    /// <p>The blob ID that contains the file information.</p>
    pub blob_id: std::option::Option<std::string::String>,
    /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
}
impl FileMetadata {
    /// <p>The full path to the file to be added or updated, including the name of the
    /// file.</p>
    pub fn absolute_path(&self) -> std::option::Option<&str> {
        self.absolute_path.as_deref()
    }
    /// <p>The blob ID that contains the file information.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
    /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
}
impl std::fmt::Debug for FileMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileMetadata");
        formatter.field("absolute_path", &self.absolute_path);
        formatter.field("blob_id", &self.blob_id);
        formatter.field("file_mode", &self.file_mode);
        formatter.finish()
    }
}
/// See [`FileMetadata`](crate::model::FileMetadata)
pub mod file_metadata {
    /// A builder for [`FileMetadata`](crate::model::FileMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) absolute_path: std::option::Option<std::string::String>,
        pub(crate) blob_id: std::option::Option<std::string::String>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    }
    impl Builder {
        /// <p>The full path to the file to be added or updated, including the name of the
        /// file.</p>
        pub fn absolute_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.absolute_path = Some(input.into());
            self
        }
        /// <p>The full path to the file to be added or updated, including the name of the
        /// file.</p>
        pub fn set_absolute_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.absolute_path = input;
            self
        }
        /// <p>The blob ID that contains the file information.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The blob ID that contains the file information.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`FileMetadata`](crate::model::FileMetadata)
        pub fn build(self) -> crate::model::FileMetadata {
            crate::model::FileMetadata {
                absolute_path: self.absolute_path,
                blob_id: self.blob_id,
                file_mode: self.file_mode,
            }
        }
    }
}
impl FileMetadata {
    /// Creates a new builder-style object to manufacture [`FileMetadata`](crate::model::FileMetadata)
    pub fn builder() -> crate::model::file_metadata::Builder {
        crate::model::file_metadata::Builder::default()
    }
}

/// <p>Information about a file added or updated as part of a commit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFileEntry {
    /// <p>The full path to the file in the repository, including the name of the file.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    /// <p>The content of the file, if a source file is not specified.</p>
    pub file_content: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The name and full path of the file that contains the changes you want to make as part of the commit,
    /// if you are not providing the file content directly.</p>
    pub source_file: std::option::Option<crate::model::SourceFileSpecifier>,
}
impl PutFileEntry {
    /// <p>The full path to the file in the repository, including the name of the file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
    /// <p>The content of the file, if a source file is not specified.</p>
    pub fn file_content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.file_content.as_ref()
    }
    /// <p>The name and full path of the file that contains the changes you want to make as part of the commit,
    /// if you are not providing the file content directly.</p>
    pub fn source_file(&self) -> std::option::Option<&crate::model::SourceFileSpecifier> {
        self.source_file.as_ref()
    }
}
impl std::fmt::Debug for PutFileEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFileEntry");
        formatter.field("file_path", &self.file_path);
        formatter.field("file_mode", &self.file_mode);
        formatter.field("file_content", &self.file_content);
        formatter.field("source_file", &self.source_file);
        formatter.finish()
    }
}
/// See [`PutFileEntry`](crate::model::PutFileEntry)
pub mod put_file_entry {
    /// A builder for [`PutFileEntry`](crate::model::PutFileEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
        pub(crate) file_content: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) source_file: std::option::Option<crate::model::SourceFileSpecifier>,
    }
    impl Builder {
        /// <p>The full path to the file in the repository, including the name of the file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The full path to the file in the repository, including the name of the file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The extrapolated file mode permissions for the file. Valid values include EXECUTABLE and NORMAL.</p>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// <p>The content of the file, if a source file is not specified.</p>
        pub fn file_content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.file_content = Some(input);
            self
        }
        /// <p>The content of the file, if a source file is not specified.</p>
        pub fn set_file_content(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.file_content = input;
            self
        }
        /// <p>The name and full path of the file that contains the changes you want to make as part of the commit,
        /// if you are not providing the file content directly.</p>
        pub fn source_file(mut self, input: crate::model::SourceFileSpecifier) -> Self {
            self.source_file = Some(input);
            self
        }
        /// <p>The name and full path of the file that contains the changes you want to make as part of the commit,
        /// if you are not providing the file content directly.</p>
        pub fn set_source_file(
            mut self,
            input: std::option::Option<crate::model::SourceFileSpecifier>,
        ) -> Self {
            self.source_file = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFileEntry`](crate::model::PutFileEntry)
        pub fn build(self) -> crate::model::PutFileEntry {
            crate::model::PutFileEntry {
                file_path: self.file_path,
                file_mode: self.file_mode,
                file_content: self.file_content,
                source_file: self.source_file,
            }
        }
    }
}
impl PutFileEntry {
    /// Creates a new builder-style object to manufacture [`PutFileEntry`](crate::model::PutFileEntry)
    pub fn builder() -> crate::model::put_file_entry::Builder {
        crate::model::put_file_entry::Builder::default()
    }
}

/// <p>Information about a source file that is part of changes made in a commit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceFileSpecifier {
    /// <p>The full path to the file, including the name of the file.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>Whether to remove the source file from the parent commit.</p>
    pub is_move: bool,
}
impl SourceFileSpecifier {
    /// <p>The full path to the file, including the name of the file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>Whether to remove the source file from the parent commit.</p>
    pub fn is_move(&self) -> bool {
        self.is_move
    }
}
impl std::fmt::Debug for SourceFileSpecifier {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceFileSpecifier");
        formatter.field("file_path", &self.file_path);
        formatter.field("is_move", &self.is_move);
        formatter.finish()
    }
}
/// See [`SourceFileSpecifier`](crate::model::SourceFileSpecifier)
pub mod source_file_specifier {
    /// A builder for [`SourceFileSpecifier`](crate::model::SourceFileSpecifier)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) is_move: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The full path to the file, including the name of the file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The full path to the file, including the name of the file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>Whether to remove the source file from the parent commit.</p>
        pub fn is_move(mut self, input: bool) -> Self {
            self.is_move = Some(input);
            self
        }
        /// <p>Whether to remove the source file from the parent commit.</p>
        pub fn set_is_move(mut self, input: std::option::Option<bool>) -> Self {
            self.is_move = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceFileSpecifier`](crate::model::SourceFileSpecifier)
        pub fn build(self) -> crate::model::SourceFileSpecifier {
            crate::model::SourceFileSpecifier {
                file_path: self.file_path,
                is_move: self.is_move.unwrap_or_default(),
            }
        }
    }
}
impl SourceFileSpecifier {
    /// Creates a new builder-style object to manufacture [`SourceFileSpecifier`](crate::model::SourceFileSpecifier)
    pub fn builder() -> crate::model::source_file_specifier::Builder {
        crate::model::source_file_specifier::Builder::default()
    }
}

/// <p>Returns information about errors in a BatchGetCommits operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetCommitsError {
    /// <p>A commit ID that either could not be found or was not in a valid format.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>An error code that specifies whether the commit ID was not valid or not found.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>An error message that provides detail about why the commit ID either was not found or was not valid.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchGetCommitsError {
    /// <p>A commit ID that either could not be found or was not in a valid format.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>An error code that specifies whether the commit ID was not valid or not found.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message that provides detail about why the commit ID either was not found or was not valid.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchGetCommitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetCommitsError");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchGetCommitsError`](crate::model::BatchGetCommitsError)
pub mod batch_get_commits_error {
    /// A builder for [`BatchGetCommitsError`](crate::model::BatchGetCommitsError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A commit ID that either could not be found or was not in a valid format.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>A commit ID that either could not be found or was not in a valid format.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>An error code that specifies whether the commit ID was not valid or not found.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>An error code that specifies whether the commit ID was not valid or not found.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error message that provides detail about why the commit ID either was not found or was not valid.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message that provides detail about why the commit ID either was not found or was not valid.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetCommitsError`](crate::model::BatchGetCommitsError)
        pub fn build(self) -> crate::model::BatchGetCommitsError {
            crate::model::BatchGetCommitsError {
                commit_id: self.commit_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchGetCommitsError {
    /// Creates a new builder-style object to manufacture [`BatchGetCommitsError`](crate::model::BatchGetCommitsError)
    pub fn builder() -> crate::model::batch_get_commits_error::Builder {
        crate::model::batch_get_commits_error::Builder::default()
    }
}

/// <p>Returns information about errors in a BatchDisassociateApprovalRuleTemplateFromRepositories operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    /// <p>The name of the repository where the association with the template was not able to be removed.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An error code that specifies whether the repository name was not valid or not
    /// found.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>An error message that provides details about why the repository name was either not found or not valid.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    /// <p>The name of the repository where the association with the template was not able to be removed.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An error code that specifies whether the repository name was not valid or not
    /// found.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message that provides details about why the repository name was either not found or not valid.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchDisassociateApprovalRuleTemplateFromRepositoriesError");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchDisassociateApprovalRuleTemplateFromRepositoriesError`](crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError)
pub mod batch_disassociate_approval_rule_template_from_repositories_error {
    /// A builder for [`BatchDisassociateApprovalRuleTemplateFromRepositoriesError`](crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where the association with the template was not able to be removed.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the association with the template was not able to be removed.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An error code that specifies whether the repository name was not valid or not
        /// found.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>An error code that specifies whether the repository name was not valid or not
        /// found.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error message that provides details about why the repository name was either not found or not valid.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message that provides details about why the repository name was either not found or not valid.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateApprovalRuleTemplateFromRepositoriesError`](crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError)
        pub fn build(
            self,
        ) -> crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
            crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
                repository_name: self.repository_name,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateApprovalRuleTemplateFromRepositoriesError`](crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError)
    pub fn builder(
    ) -> crate::model::batch_disassociate_approval_rule_template_from_repositories_error::Builder
    {
        crate::model::batch_disassociate_approval_rule_template_from_repositories_error::Builder::default()
    }
}

/// <p>Returns information about errors in a BatchDescribeMergeConflicts operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDescribeMergeConflictsError {
    /// <p>The path to the file.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The name of the exception.</p>
    pub exception_name: std::option::Option<std::string::String>,
    /// <p>The message provided by the exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BatchDescribeMergeConflictsError {
    /// <p>The path to the file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The name of the exception.</p>
    pub fn exception_name(&self) -> std::option::Option<&str> {
        self.exception_name.as_deref()
    }
    /// <p>The message provided by the exception.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BatchDescribeMergeConflictsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDescribeMergeConflictsError");
        formatter.field("file_path", &self.file_path);
        formatter.field("exception_name", &self.exception_name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchDescribeMergeConflictsError`](crate::model::BatchDescribeMergeConflictsError)
pub mod batch_describe_merge_conflicts_error {
    /// A builder for [`BatchDescribeMergeConflictsError`](crate::model::BatchDescribeMergeConflictsError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) exception_name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The path to the file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The path to the file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The name of the exception.</p>
        pub fn exception_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_name = Some(input.into());
            self
        }
        /// <p>The name of the exception.</p>
        pub fn set_exception_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_name = input;
            self
        }
        /// <p>The message provided by the exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message provided by the exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeMergeConflictsError`](crate::model::BatchDescribeMergeConflictsError)
        pub fn build(self) -> crate::model::BatchDescribeMergeConflictsError {
            crate::model::BatchDescribeMergeConflictsError {
                file_path: self.file_path,
                exception_name: self.exception_name,
                message: self.message,
            }
        }
    }
}
impl BatchDescribeMergeConflictsError {
    /// Creates a new builder-style object to manufacture [`BatchDescribeMergeConflictsError`](crate::model::BatchDescribeMergeConflictsError)
    pub fn builder() -> crate::model::batch_describe_merge_conflicts_error::Builder {
        crate::model::batch_describe_merge_conflicts_error::Builder::default()
    }
}

/// <p>Information about conflicts in a merge operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Conflict {
    /// <p>Metadata about a conflict in a merge operation.</p>
    pub conflict_metadata: std::option::Option<crate::model::ConflictMetadata>,
    /// <p>A list of hunks that contain the differences between files or lines causing the conflict.</p>
    pub merge_hunks: std::option::Option<std::vec::Vec<crate::model::MergeHunk>>,
}
impl Conflict {
    /// <p>Metadata about a conflict in a merge operation.</p>
    pub fn conflict_metadata(&self) -> std::option::Option<&crate::model::ConflictMetadata> {
        self.conflict_metadata.as_ref()
    }
    /// <p>A list of hunks that contain the differences between files or lines causing the conflict.</p>
    pub fn merge_hunks(&self) -> std::option::Option<&[crate::model::MergeHunk]> {
        self.merge_hunks.as_deref()
    }
}
impl std::fmt::Debug for Conflict {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Conflict");
        formatter.field("conflict_metadata", &self.conflict_metadata);
        formatter.field("merge_hunks", &self.merge_hunks);
        formatter.finish()
    }
}
/// See [`Conflict`](crate::model::Conflict)
pub mod conflict {
    /// A builder for [`Conflict`](crate::model::Conflict)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conflict_metadata: std::option::Option<crate::model::ConflictMetadata>,
        pub(crate) merge_hunks: std::option::Option<std::vec::Vec<crate::model::MergeHunk>>,
    }
    impl Builder {
        /// <p>Metadata about a conflict in a merge operation.</p>
        pub fn conflict_metadata(mut self, input: crate::model::ConflictMetadata) -> Self {
            self.conflict_metadata = Some(input);
            self
        }
        /// <p>Metadata about a conflict in a merge operation.</p>
        pub fn set_conflict_metadata(
            mut self,
            input: std::option::Option<crate::model::ConflictMetadata>,
        ) -> Self {
            self.conflict_metadata = input;
            self
        }
        /// Appends an item to `merge_hunks`.
        ///
        /// To override the contents of this collection use [`set_merge_hunks`](Self::set_merge_hunks).
        ///
        /// <p>A list of hunks that contain the differences between files or lines causing the conflict.</p>
        pub fn merge_hunks(mut self, input: impl Into<crate::model::MergeHunk>) -> Self {
            let mut v = self.merge_hunks.unwrap_or_default();
            v.push(input.into());
            self.merge_hunks = Some(v);
            self
        }
        /// <p>A list of hunks that contain the differences between files or lines causing the conflict.</p>
        pub fn set_merge_hunks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MergeHunk>>,
        ) -> Self {
            self.merge_hunks = input;
            self
        }
        /// Consumes the builder and constructs a [`Conflict`](crate::model::Conflict)
        pub fn build(self) -> crate::model::Conflict {
            crate::model::Conflict {
                conflict_metadata: self.conflict_metadata,
                merge_hunks: self.merge_hunks,
            }
        }
    }
}
impl Conflict {
    /// Creates a new builder-style object to manufacture [`Conflict`](crate::model::Conflict)
    pub fn builder() -> crate::model::conflict::Builder {
        crate::model::conflict::Builder::default()
    }
}

/// <p>Returns information about errors in a BatchAssociateApprovalRuleTemplateWithRepositories operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    /// <p>The name of the repository where the association was not made.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>An error code that specifies whether the repository name was not valid or not found.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>An error message that provides details about why the repository name was not found or not valid.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    /// <p>The name of the repository where the association was not made.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>An error code that specifies whether the repository name was not valid or not found.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>An error message that provides details about why the repository name was not found or not valid.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchAssociateApprovalRuleTemplateWithRepositoriesError");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`BatchAssociateApprovalRuleTemplateWithRepositoriesError`](crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError)
pub mod batch_associate_approval_rule_template_with_repositories_error {
    /// A builder for [`BatchAssociateApprovalRuleTemplateWithRepositoriesError`](crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the repository where the association was not made.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where the association was not made.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>An error code that specifies whether the repository name was not valid or not found.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>An error code that specifies whether the repository name was not valid or not found.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>An error message that provides details about why the repository name was not found or not valid.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>An error message that provides details about why the repository name was not found or not valid.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateApprovalRuleTemplateWithRepositoriesError`](crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError)
        pub fn build(
            self,
        ) -> crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError {
            crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError {
                repository_name: self.repository_name,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    /// Creates a new builder-style object to manufacture [`BatchAssociateApprovalRuleTemplateWithRepositoriesError`](crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError)
    pub fn builder(
    ) -> crate::model::batch_associate_approval_rule_template_with_repositories_error::Builder {
        crate::model::batch_associate_approval_rule_template_with_repositories_error::Builder::default()
    }
}
