// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRepositoryNameOutput {}
impl std::fmt::Debug for UpdateRepositoryNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRepositoryNameOutput");
        formatter.finish()
    }
}
/// See [`UpdateRepositoryNameOutput`](crate::output::UpdateRepositoryNameOutput)
pub mod update_repository_name_output {
    /// A builder for [`UpdateRepositoryNameOutput`](crate::output::UpdateRepositoryNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateRepositoryNameOutput`](crate::output::UpdateRepositoryNameOutput)
        pub fn build(self) -> crate::output::UpdateRepositoryNameOutput {
            crate::output::UpdateRepositoryNameOutput {}
        }
    }
}
impl UpdateRepositoryNameOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryNameOutput`](crate::output::UpdateRepositoryNameOutput)
    pub fn builder() -> crate::output::update_repository_name_output::Builder {
        crate::output::update_repository_name_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRepositoryDescriptionOutput {}
impl std::fmt::Debug for UpdateRepositoryDescriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRepositoryDescriptionOutput");
        formatter.finish()
    }
}
/// See [`UpdateRepositoryDescriptionOutput`](crate::output::UpdateRepositoryDescriptionOutput)
pub mod update_repository_description_output {
    /// A builder for [`UpdateRepositoryDescriptionOutput`](crate::output::UpdateRepositoryDescriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateRepositoryDescriptionOutput`](crate::output::UpdateRepositoryDescriptionOutput)
        pub fn build(self) -> crate::output::UpdateRepositoryDescriptionOutput {
            crate::output::UpdateRepositoryDescriptionOutput {}
        }
    }
}
impl UpdateRepositoryDescriptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryDescriptionOutput`](crate::output::UpdateRepositoryDescriptionOutput)
    pub fn builder() -> crate::output::update_repository_description_output::Builder {
        crate::output::update_repository_description_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestTitleOutput {
    /// <p>Information about the updated pull request.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl UpdatePullRequestTitleOutput {
    /// <p>Information about the updated pull request.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for UpdatePullRequestTitleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestTitleOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`UpdatePullRequestTitleOutput`](crate::output::UpdatePullRequestTitleOutput)
pub mod update_pull_request_title_output {
    /// A builder for [`UpdatePullRequestTitleOutput`](crate::output::UpdatePullRequestTitleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Information about the updated pull request.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Information about the updated pull request.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestTitleOutput`](crate::output::UpdatePullRequestTitleOutput)
        pub fn build(self) -> crate::output::UpdatePullRequestTitleOutput {
            crate::output::UpdatePullRequestTitleOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl UpdatePullRequestTitleOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestTitleOutput`](crate::output::UpdatePullRequestTitleOutput)
    pub fn builder() -> crate::output::update_pull_request_title_output::Builder {
        crate::output::update_pull_request_title_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestStatusOutput {
    /// <p>Information about the pull request.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl UpdatePullRequestStatusOutput {
    /// <p>Information about the pull request.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for UpdatePullRequestStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestStatusOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`UpdatePullRequestStatusOutput`](crate::output::UpdatePullRequestStatusOutput)
pub mod update_pull_request_status_output {
    /// A builder for [`UpdatePullRequestStatusOutput`](crate::output::UpdatePullRequestStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Information about the pull request.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Information about the pull request.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestStatusOutput`](crate::output::UpdatePullRequestStatusOutput)
        pub fn build(self) -> crate::output::UpdatePullRequestStatusOutput {
            crate::output::UpdatePullRequestStatusOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl UpdatePullRequestStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestStatusOutput`](crate::output::UpdatePullRequestStatusOutput)
    pub fn builder() -> crate::output::update_pull_request_status_output::Builder {
        crate::output::update_pull_request_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestDescriptionOutput {
    /// <p>Information about the updated pull request.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl UpdatePullRequestDescriptionOutput {
    /// <p>Information about the updated pull request.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for UpdatePullRequestDescriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestDescriptionOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`UpdatePullRequestDescriptionOutput`](crate::output::UpdatePullRequestDescriptionOutput)
pub mod update_pull_request_description_output {
    /// A builder for [`UpdatePullRequestDescriptionOutput`](crate::output::UpdatePullRequestDescriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Information about the updated pull request.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Information about the updated pull request.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestDescriptionOutput`](crate::output::UpdatePullRequestDescriptionOutput)
        pub fn build(self) -> crate::output::UpdatePullRequestDescriptionOutput {
            crate::output::UpdatePullRequestDescriptionOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl UpdatePullRequestDescriptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestDescriptionOutput`](crate::output::UpdatePullRequestDescriptionOutput)
    pub fn builder() -> crate::output::update_pull_request_description_output::Builder {
        crate::output::update_pull_request_description_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestApprovalStateOutput {}
impl std::fmt::Debug for UpdatePullRequestApprovalStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestApprovalStateOutput");
        formatter.finish()
    }
}
/// See [`UpdatePullRequestApprovalStateOutput`](crate::output::UpdatePullRequestApprovalStateOutput)
pub mod update_pull_request_approval_state_output {
    /// A builder for [`UpdatePullRequestApprovalStateOutput`](crate::output::UpdatePullRequestApprovalStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdatePullRequestApprovalStateOutput`](crate::output::UpdatePullRequestApprovalStateOutput)
        pub fn build(self) -> crate::output::UpdatePullRequestApprovalStateOutput {
            crate::output::UpdatePullRequestApprovalStateOutput {}
        }
    }
}
impl UpdatePullRequestApprovalStateOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestApprovalStateOutput`](crate::output::UpdatePullRequestApprovalStateOutput)
    pub fn builder() -> crate::output::update_pull_request_approval_state_output::Builder {
        crate::output::update_pull_request_approval_state_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePullRequestApprovalRuleContentOutput {
    /// <p>Information about the updated approval rule.</p>
    pub approval_rule: std::option::Option<crate::model::ApprovalRule>,
}
impl UpdatePullRequestApprovalRuleContentOutput {
    /// <p>Information about the updated approval rule.</p>
    pub fn approval_rule(&self) -> std::option::Option<&crate::model::ApprovalRule> {
        self.approval_rule.as_ref()
    }
}
impl std::fmt::Debug for UpdatePullRequestApprovalRuleContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePullRequestApprovalRuleContentOutput");
        formatter.field("approval_rule", &self.approval_rule);
        formatter.finish()
    }
}
/// See [`UpdatePullRequestApprovalRuleContentOutput`](crate::output::UpdatePullRequestApprovalRuleContentOutput)
pub mod update_pull_request_approval_rule_content_output {
    /// A builder for [`UpdatePullRequestApprovalRuleContentOutput`](crate::output::UpdatePullRequestApprovalRuleContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule: std::option::Option<crate::model::ApprovalRule>,
    }
    impl Builder {
        /// <p>Information about the updated approval rule.</p>
        pub fn approval_rule(mut self, input: crate::model::ApprovalRule) -> Self {
            self.approval_rule = Some(input);
            self
        }
        /// <p>Information about the updated approval rule.</p>
        pub fn set_approval_rule(
            mut self,
            input: std::option::Option<crate::model::ApprovalRule>,
        ) -> Self {
            self.approval_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePullRequestApprovalRuleContentOutput`](crate::output::UpdatePullRequestApprovalRuleContentOutput)
        pub fn build(self) -> crate::output::UpdatePullRequestApprovalRuleContentOutput {
            crate::output::UpdatePullRequestApprovalRuleContentOutput {
                approval_rule: self.approval_rule,
            }
        }
    }
}
impl UpdatePullRequestApprovalRuleContentOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePullRequestApprovalRuleContentOutput`](crate::output::UpdatePullRequestApprovalRuleContentOutput)
    pub fn builder() -> crate::output::update_pull_request_approval_rule_content_output::Builder {
        crate::output::update_pull_request_approval_rule_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDefaultBranchOutput {}
impl std::fmt::Debug for UpdateDefaultBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDefaultBranchOutput");
        formatter.finish()
    }
}
/// See [`UpdateDefaultBranchOutput`](crate::output::UpdateDefaultBranchOutput)
pub mod update_default_branch_output {
    /// A builder for [`UpdateDefaultBranchOutput`](crate::output::UpdateDefaultBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UpdateDefaultBranchOutput`](crate::output::UpdateDefaultBranchOutput)
        pub fn build(self) -> crate::output::UpdateDefaultBranchOutput {
            crate::output::UpdateDefaultBranchOutput {}
        }
    }
}
impl UpdateDefaultBranchOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDefaultBranchOutput`](crate::output::UpdateDefaultBranchOutput)
    pub fn builder() -> crate::output::update_default_branch_output::Builder {
        crate::output::update_default_branch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCommentOutput {
    /// <p>Information about the updated comment.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl UpdateCommentOutput {
    /// <p>Information about the updated comment.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
}
impl std::fmt::Debug for UpdateCommentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCommentOutput");
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`UpdateCommentOutput`](crate::output::UpdateCommentOutput)
pub mod update_comment_output {
    /// A builder for [`UpdateCommentOutput`](crate::output::UpdateCommentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>Information about the updated comment.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>Information about the updated comment.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCommentOutput`](crate::output::UpdateCommentOutput)
        pub fn build(self) -> crate::output::UpdateCommentOutput {
            crate::output::UpdateCommentOutput {
                comment: self.comment,
            }
        }
    }
}
impl UpdateCommentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCommentOutput`](crate::output::UpdateCommentOutput)
    pub fn builder() -> crate::output::update_comment_output::Builder {
        crate::output::update_comment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApprovalRuleTemplateNameOutput {
    /// <p>The structure and content of the updated approval rule template.</p>
    pub approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
}
impl UpdateApprovalRuleTemplateNameOutput {
    /// <p>The structure and content of the updated approval rule template.</p>
    pub fn approval_rule_template(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalRuleTemplate> {
        self.approval_rule_template.as_ref()
    }
}
impl std::fmt::Debug for UpdateApprovalRuleTemplateNameOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApprovalRuleTemplateNameOutput");
        formatter.field("approval_rule_template", &self.approval_rule_template);
        formatter.finish()
    }
}
/// See [`UpdateApprovalRuleTemplateNameOutput`](crate::output::UpdateApprovalRuleTemplateNameOutput)
pub mod update_approval_rule_template_name_output {
    /// A builder for [`UpdateApprovalRuleTemplateNameOutput`](crate::output::UpdateApprovalRuleTemplateNameOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
    }
    impl Builder {
        /// <p>The structure and content of the updated approval rule template.</p>
        pub fn approval_rule_template(mut self, input: crate::model::ApprovalRuleTemplate) -> Self {
            self.approval_rule_template = Some(input);
            self
        }
        /// <p>The structure and content of the updated approval rule template.</p>
        pub fn set_approval_rule_template(
            mut self,
            input: std::option::Option<crate::model::ApprovalRuleTemplate>,
        ) -> Self {
            self.approval_rule_template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApprovalRuleTemplateNameOutput`](crate::output::UpdateApprovalRuleTemplateNameOutput)
        pub fn build(self) -> crate::output::UpdateApprovalRuleTemplateNameOutput {
            crate::output::UpdateApprovalRuleTemplateNameOutput {
                approval_rule_template: self.approval_rule_template,
            }
        }
    }
}
impl UpdateApprovalRuleTemplateNameOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateNameOutput`](crate::output::UpdateApprovalRuleTemplateNameOutput)
    pub fn builder() -> crate::output::update_approval_rule_template_name_output::Builder {
        crate::output::update_approval_rule_template_name_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApprovalRuleTemplateDescriptionOutput {
    /// <p>The structure and content of the updated approval rule template.</p>
    pub approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
}
impl UpdateApprovalRuleTemplateDescriptionOutput {
    /// <p>The structure and content of the updated approval rule template.</p>
    pub fn approval_rule_template(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalRuleTemplate> {
        self.approval_rule_template.as_ref()
    }
}
impl std::fmt::Debug for UpdateApprovalRuleTemplateDescriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApprovalRuleTemplateDescriptionOutput");
        formatter.field("approval_rule_template", &self.approval_rule_template);
        formatter.finish()
    }
}
/// See [`UpdateApprovalRuleTemplateDescriptionOutput`](crate::output::UpdateApprovalRuleTemplateDescriptionOutput)
pub mod update_approval_rule_template_description_output {
    /// A builder for [`UpdateApprovalRuleTemplateDescriptionOutput`](crate::output::UpdateApprovalRuleTemplateDescriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
    }
    impl Builder {
        /// <p>The structure and content of the updated approval rule template.</p>
        pub fn approval_rule_template(mut self, input: crate::model::ApprovalRuleTemplate) -> Self {
            self.approval_rule_template = Some(input);
            self
        }
        /// <p>The structure and content of the updated approval rule template.</p>
        pub fn set_approval_rule_template(
            mut self,
            input: std::option::Option<crate::model::ApprovalRuleTemplate>,
        ) -> Self {
            self.approval_rule_template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApprovalRuleTemplateDescriptionOutput`](crate::output::UpdateApprovalRuleTemplateDescriptionOutput)
        pub fn build(self) -> crate::output::UpdateApprovalRuleTemplateDescriptionOutput {
            crate::output::UpdateApprovalRuleTemplateDescriptionOutput {
                approval_rule_template: self.approval_rule_template,
            }
        }
    }
}
impl UpdateApprovalRuleTemplateDescriptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateDescriptionOutput`](crate::output::UpdateApprovalRuleTemplateDescriptionOutput)
    pub fn builder() -> crate::output::update_approval_rule_template_description_output::Builder {
        crate::output::update_approval_rule_template_description_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateApprovalRuleTemplateContentOutput {
    /// <p>Returns information about an approval rule template.</p>
    pub approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
}
impl UpdateApprovalRuleTemplateContentOutput {
    /// <p>Returns information about an approval rule template.</p>
    pub fn approval_rule_template(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalRuleTemplate> {
        self.approval_rule_template.as_ref()
    }
}
impl std::fmt::Debug for UpdateApprovalRuleTemplateContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateApprovalRuleTemplateContentOutput");
        formatter.field("approval_rule_template", &self.approval_rule_template);
        formatter.finish()
    }
}
/// See [`UpdateApprovalRuleTemplateContentOutput`](crate::output::UpdateApprovalRuleTemplateContentOutput)
pub mod update_approval_rule_template_content_output {
    /// A builder for [`UpdateApprovalRuleTemplateContentOutput`](crate::output::UpdateApprovalRuleTemplateContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
    }
    impl Builder {
        /// <p>Returns information about an approval rule template.</p>
        pub fn approval_rule_template(mut self, input: crate::model::ApprovalRuleTemplate) -> Self {
            self.approval_rule_template = Some(input);
            self
        }
        /// <p>Returns information about an approval rule template.</p>
        pub fn set_approval_rule_template(
            mut self,
            input: std::option::Option<crate::model::ApprovalRuleTemplate>,
        ) -> Self {
            self.approval_rule_template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateApprovalRuleTemplateContentOutput`](crate::output::UpdateApprovalRuleTemplateContentOutput)
        pub fn build(self) -> crate::output::UpdateApprovalRuleTemplateContentOutput {
            crate::output::UpdateApprovalRuleTemplateContentOutput {
                approval_rule_template: self.approval_rule_template,
            }
        }
    }
}
impl UpdateApprovalRuleTemplateContentOutput {
    /// Creates a new builder-style object to manufacture [`UpdateApprovalRuleTemplateContentOutput`](crate::output::UpdateApprovalRuleTemplateContentOutput)
    pub fn builder() -> crate::output::update_approval_rule_template_content_output::Builder {
        crate::output::update_approval_rule_template_content_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

/// <p>Represents the output of a test repository triggers operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestRepositoryTriggersOutput {
    /// <p>The list of triggers that were successfully tested. This list provides the names of the triggers that were successfully tested, separated by commas.</p>
    pub successful_executions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of triggers that were not tested. This list provides the names of the
    /// triggers that could not be tested, separated by commas.</p>
    pub failed_executions:
        std::option::Option<std::vec::Vec<crate::model::RepositoryTriggerExecutionFailure>>,
}
impl TestRepositoryTriggersOutput {
    /// <p>The list of triggers that were successfully tested. This list provides the names of the triggers that were successfully tested, separated by commas.</p>
    pub fn successful_executions(&self) -> std::option::Option<&[std::string::String]> {
        self.successful_executions.as_deref()
    }
    /// <p>The list of triggers that were not tested. This list provides the names of the
    /// triggers that could not be tested, separated by commas.</p>
    pub fn failed_executions(
        &self,
    ) -> std::option::Option<&[crate::model::RepositoryTriggerExecutionFailure]> {
        self.failed_executions.as_deref()
    }
}
impl std::fmt::Debug for TestRepositoryTriggersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestRepositoryTriggersOutput");
        formatter.field("successful_executions", &self.successful_executions);
        formatter.field("failed_executions", &self.failed_executions);
        formatter.finish()
    }
}
/// See [`TestRepositoryTriggersOutput`](crate::output::TestRepositoryTriggersOutput)
pub mod test_repository_triggers_output {
    /// A builder for [`TestRepositoryTriggersOutput`](crate::output::TestRepositoryTriggersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_executions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failed_executions:
            std::option::Option<std::vec::Vec<crate::model::RepositoryTriggerExecutionFailure>>,
    }
    impl Builder {
        /// Appends an item to `successful_executions`.
        ///
        /// To override the contents of this collection use [`set_successful_executions`](Self::set_successful_executions).
        ///
        /// <p>The list of triggers that were successfully tested. This list provides the names of the triggers that were successfully tested, separated by commas.</p>
        pub fn successful_executions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.successful_executions.unwrap_or_default();
            v.push(input.into());
            self.successful_executions = Some(v);
            self
        }
        /// <p>The list of triggers that were successfully tested. This list provides the names of the triggers that were successfully tested, separated by commas.</p>
        pub fn set_successful_executions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.successful_executions = input;
            self
        }
        /// Appends an item to `failed_executions`.
        ///
        /// To override the contents of this collection use [`set_failed_executions`](Self::set_failed_executions).
        ///
        /// <p>The list of triggers that were not tested. This list provides the names of the
        /// triggers that could not be tested, separated by commas.</p>
        pub fn failed_executions(
            mut self,
            input: impl Into<crate::model::RepositoryTriggerExecutionFailure>,
        ) -> Self {
            let mut v = self.failed_executions.unwrap_or_default();
            v.push(input.into());
            self.failed_executions = Some(v);
            self
        }
        /// <p>The list of triggers that were not tested. This list provides the names of the
        /// triggers that could not be tested, separated by commas.</p>
        pub fn set_failed_executions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RepositoryTriggerExecutionFailure>,
            >,
        ) -> Self {
            self.failed_executions = input;
            self
        }
        /// Consumes the builder and constructs a [`TestRepositoryTriggersOutput`](crate::output::TestRepositoryTriggersOutput)
        pub fn build(self) -> crate::output::TestRepositoryTriggersOutput {
            crate::output::TestRepositoryTriggersOutput {
                successful_executions: self.successful_executions,
                failed_executions: self.failed_executions,
            }
        }
    }
}
impl TestRepositoryTriggersOutput {
    /// Creates a new builder-style object to manufacture [`TestRepositoryTriggersOutput`](crate::output::TestRepositoryTriggersOutput)
    pub fn builder() -> crate::output::test_repository_triggers_output::Builder {
        crate::output::test_repository_triggers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

/// <p>Represents the output of a put repository triggers operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRepositoryTriggersOutput {
    /// <p>The system-generated unique ID for the create or update operation.</p>
    pub configuration_id: std::option::Option<std::string::String>,
}
impl PutRepositoryTriggersOutput {
    /// <p>The system-generated unique ID for the create or update operation.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
}
impl std::fmt::Debug for PutRepositoryTriggersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRepositoryTriggersOutput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.finish()
    }
}
/// See [`PutRepositoryTriggersOutput`](crate::output::PutRepositoryTriggersOutput)
pub mod put_repository_triggers_output {
    /// A builder for [`PutRepositoryTriggersOutput`](crate::output::PutRepositoryTriggersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated unique ID for the create or update operation.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The system-generated unique ID for the create or update operation.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRepositoryTriggersOutput`](crate::output::PutRepositoryTriggersOutput)
        pub fn build(self) -> crate::output::PutRepositoryTriggersOutput {
            crate::output::PutRepositoryTriggersOutput {
                configuration_id: self.configuration_id,
            }
        }
    }
}
impl PutRepositoryTriggersOutput {
    /// Creates a new builder-style object to manufacture [`PutRepositoryTriggersOutput`](crate::output::PutRepositoryTriggersOutput)
    pub fn builder() -> crate::output::put_repository_triggers_output::Builder {
        crate::output::put_repository_triggers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFileOutput {
    /// <p>The full SHA ID of the commit that contains this file change.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
    pub blob_id: std::option::Option<std::string::String>,
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains this file change.</p>
    pub tree_id: std::option::Option<std::string::String>,
}
impl PutFileOutput {
    /// <p>The full SHA ID of the commit that contains this file change.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains this file change.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
}
impl std::fmt::Debug for PutFileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFileOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("blob_id", &self.blob_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.finish()
    }
}
/// See [`PutFileOutput`](crate::output::PutFileOutput)
pub mod put_file_output {
    /// A builder for [`PutFileOutput`](crate::output::PutFileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) blob_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full SHA ID of the commit that contains this file change.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The full SHA ID of the commit that contains this file change.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The ID of the blob, which is its SHA-1 pointer.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains this file change.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains this file change.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFileOutput`](crate::output::PutFileOutput)
        pub fn build(self) -> crate::output::PutFileOutput {
            crate::output::PutFileOutput {
                commit_id: self.commit_id,
                blob_id: self.blob_id,
                tree_id: self.tree_id,
            }
        }
    }
}
impl PutFileOutput {
    /// Creates a new builder-style object to manufacture [`PutFileOutput`](crate::output::PutFileOutput)
    pub fn builder() -> crate::output::put_file_output::Builder {
        crate::output::put_file_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutCommentReactionOutput {}
impl std::fmt::Debug for PutCommentReactionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutCommentReactionOutput");
        formatter.finish()
    }
}
/// See [`PutCommentReactionOutput`](crate::output::PutCommentReactionOutput)
pub mod put_comment_reaction_output {
    /// A builder for [`PutCommentReactionOutput`](crate::output::PutCommentReactionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutCommentReactionOutput`](crate::output::PutCommentReactionOutput)
        pub fn build(self) -> crate::output::PutCommentReactionOutput {
            crate::output::PutCommentReactionOutput {}
        }
    }
}
impl PutCommentReactionOutput {
    /// Creates a new builder-style object to manufacture [`PutCommentReactionOutput`](crate::output::PutCommentReactionOutput)
    pub fn builder() -> crate::output::put_comment_reaction_output::Builder {
        crate::output::put_comment_reaction_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostCommentReplyOutput {
    /// <p>Information about the reply to a comment.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl PostCommentReplyOutput {
    /// <p>Information about the reply to a comment.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
}
impl std::fmt::Debug for PostCommentReplyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostCommentReplyOutput");
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`PostCommentReplyOutput`](crate::output::PostCommentReplyOutput)
pub mod post_comment_reply_output {
    /// A builder for [`PostCommentReplyOutput`](crate::output::PostCommentReplyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>Information about the reply to a comment.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>Information about the reply to a comment.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`PostCommentReplyOutput`](crate::output::PostCommentReplyOutput)
        pub fn build(self) -> crate::output::PostCommentReplyOutput {
            crate::output::PostCommentReplyOutput {
                comment: self.comment,
            }
        }
    }
}
impl PostCommentReplyOutput {
    /// Creates a new builder-style object to manufacture [`PostCommentReplyOutput`](crate::output::PostCommentReplyOutput)
    pub fn builder() -> crate::output::post_comment_reply_output::Builder {
        crate::output::post_comment_reply_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostCommentForPullRequestOutput {
    /// <p>The name of the repository where you posted a comment on a pull request.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>The system-generated ID of the pull request. </p>
    pub pull_request_id: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the source branch used to create the pull request,
    /// or in the case of an updated pull request, the full commit ID of the commit used to update the pull request.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>The full commit ID of the commit in the destination branch where the pull request is
    /// merged.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>In the directionality of the pull request, the blob ID of the before blob.</p>
    pub before_blob_id: std::option::Option<std::string::String>,
    /// <p>In the directionality of the pull request, the blob ID of the after blob.</p>
    pub after_blob_id: std::option::Option<std::string::String>,
    /// <p>The location of the change where you posted your comment.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The content of the comment you posted.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl PostCommentForPullRequestOutput {
    /// <p>The name of the repository where you posted a comment on a pull request.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>The system-generated ID of the pull request. </p>
    pub fn pull_request_id(&self) -> std::option::Option<&str> {
        self.pull_request_id.as_deref()
    }
    /// <p>The full commit ID of the commit in the source branch used to create the pull request,
    /// or in the case of an updated pull request, the full commit ID of the commit used to update the pull request.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>The full commit ID of the commit in the destination branch where the pull request is
    /// merged.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>In the directionality of the pull request, the blob ID of the before blob.</p>
    pub fn before_blob_id(&self) -> std::option::Option<&str> {
        self.before_blob_id.as_deref()
    }
    /// <p>In the directionality of the pull request, the blob ID of the after blob.</p>
    pub fn after_blob_id(&self) -> std::option::Option<&str> {
        self.after_blob_id.as_deref()
    }
    /// <p>The location of the change where you posted your comment.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>The content of the comment you posted.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
}
impl std::fmt::Debug for PostCommentForPullRequestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostCommentForPullRequestOutput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("pull_request_id", &self.pull_request_id);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("before_blob_id", &self.before_blob_id);
        formatter.field("after_blob_id", &self.after_blob_id);
        formatter.field("location", &self.location);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`PostCommentForPullRequestOutput`](crate::output::PostCommentForPullRequestOutput)
pub mod post_comment_for_pull_request_output {
    /// A builder for [`PostCommentForPullRequestOutput`](crate::output::PostCommentForPullRequestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) pull_request_id: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) before_blob_id: std::option::Option<std::string::String>,
        pub(crate) after_blob_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>The name of the repository where you posted a comment on a pull request.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you posted a comment on a pull request.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>The system-generated ID of the pull request. </p>
        pub fn pull_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pull_request_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the pull request. </p>
        pub fn set_pull_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pull_request_id = input;
            self
        }
        /// <p>The full commit ID of the commit in the source branch used to create the pull request,
        /// or in the case of an updated pull request, the full commit ID of the commit used to update the pull request.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the source branch used to create the pull request,
        /// or in the case of an updated pull request, the full commit ID of the commit used to update the pull request.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>The full commit ID of the commit in the destination branch where the pull request is
        /// merged.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit in the destination branch where the pull request is
        /// merged.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>In the directionality of the pull request, the blob ID of the before blob.</p>
        pub fn before_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_blob_id = Some(input.into());
            self
        }
        /// <p>In the directionality of the pull request, the blob ID of the before blob.</p>
        pub fn set_before_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_blob_id = input;
            self
        }
        /// <p>In the directionality of the pull request, the blob ID of the after blob.</p>
        pub fn after_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_blob_id = Some(input.into());
            self
        }
        /// <p>In the directionality of the pull request, the blob ID of the after blob.</p>
        pub fn set_after_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_blob_id = input;
            self
        }
        /// <p>The location of the change where you posted your comment.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the change where you posted your comment.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The content of the comment you posted.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>The content of the comment you posted.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`PostCommentForPullRequestOutput`](crate::output::PostCommentForPullRequestOutput)
        pub fn build(self) -> crate::output::PostCommentForPullRequestOutput {
            crate::output::PostCommentForPullRequestOutput {
                repository_name: self.repository_name,
                pull_request_id: self.pull_request_id,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                before_blob_id: self.before_blob_id,
                after_blob_id: self.after_blob_id,
                location: self.location,
                comment: self.comment,
            }
        }
    }
}
impl PostCommentForPullRequestOutput {
    /// Creates a new builder-style object to manufacture [`PostCommentForPullRequestOutput`](crate::output::PostCommentForPullRequestOutput)
    pub fn builder() -> crate::output::post_comment_for_pull_request_output::Builder {
        crate::output::post_comment_for_pull_request_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostCommentForComparedCommitOutput {
    /// <p>The name of the repository where you posted a comment on the comparison between commits.</p>
    pub repository_name: std::option::Option<std::string::String>,
    /// <p>In the directionality you established, the full commit ID of the before commit.</p>
    pub before_commit_id: std::option::Option<std::string::String>,
    /// <p>In the directionality you established, the full commit ID of the after commit.</p>
    pub after_commit_id: std::option::Option<std::string::String>,
    /// <p>In the directionality you established, the blob ID of the before blob.</p>
    pub before_blob_id: std::option::Option<std::string::String>,
    /// <p>In the directionality you established, the blob ID of the after blob.</p>
    pub after_blob_id: std::option::Option<std::string::String>,
    /// <p>The location of the comment in the comparison between the two commits.</p>
    pub location: std::option::Option<crate::model::Location>,
    /// <p>The content of the comment you posted.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl PostCommentForComparedCommitOutput {
    /// <p>The name of the repository where you posted a comment on the comparison between commits.</p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
    /// <p>In the directionality you established, the full commit ID of the before commit.</p>
    pub fn before_commit_id(&self) -> std::option::Option<&str> {
        self.before_commit_id.as_deref()
    }
    /// <p>In the directionality you established, the full commit ID of the after commit.</p>
    pub fn after_commit_id(&self) -> std::option::Option<&str> {
        self.after_commit_id.as_deref()
    }
    /// <p>In the directionality you established, the blob ID of the before blob.</p>
    pub fn before_blob_id(&self) -> std::option::Option<&str> {
        self.before_blob_id.as_deref()
    }
    /// <p>In the directionality you established, the blob ID of the after blob.</p>
    pub fn after_blob_id(&self) -> std::option::Option<&str> {
        self.after_blob_id.as_deref()
    }
    /// <p>The location of the comment in the comparison between the two commits.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::Location> {
        self.location.as_ref()
    }
    /// <p>The content of the comment you posted.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
}
impl std::fmt::Debug for PostCommentForComparedCommitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostCommentForComparedCommitOutput");
        formatter.field("repository_name", &self.repository_name);
        formatter.field("before_commit_id", &self.before_commit_id);
        formatter.field("after_commit_id", &self.after_commit_id);
        formatter.field("before_blob_id", &self.before_blob_id);
        formatter.field("after_blob_id", &self.after_blob_id);
        formatter.field("location", &self.location);
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`PostCommentForComparedCommitOutput`](crate::output::PostCommentForComparedCommitOutput)
pub mod post_comment_for_compared_commit_output {
    /// A builder for [`PostCommentForComparedCommitOutput`](crate::output::PostCommentForComparedCommitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
        pub(crate) before_commit_id: std::option::Option<std::string::String>,
        pub(crate) after_commit_id: std::option::Option<std::string::String>,
        pub(crate) before_blob_id: std::option::Option<std::string::String>,
        pub(crate) after_blob_id: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::Location>,
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>The name of the repository where you posted a comment on the comparison between commits.</p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p>The name of the repository where you posted a comment on the comparison between commits.</p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// <p>In the directionality you established, the full commit ID of the before commit.</p>
        pub fn before_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_commit_id = Some(input.into());
            self
        }
        /// <p>In the directionality you established, the full commit ID of the before commit.</p>
        pub fn set_before_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_commit_id = input;
            self
        }
        /// <p>In the directionality you established, the full commit ID of the after commit.</p>
        pub fn after_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_commit_id = Some(input.into());
            self
        }
        /// <p>In the directionality you established, the full commit ID of the after commit.</p>
        pub fn set_after_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_commit_id = input;
            self
        }
        /// <p>In the directionality you established, the blob ID of the before blob.</p>
        pub fn before_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.before_blob_id = Some(input.into());
            self
        }
        /// <p>In the directionality you established, the blob ID of the before blob.</p>
        pub fn set_before_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.before_blob_id = input;
            self
        }
        /// <p>In the directionality you established, the blob ID of the after blob.</p>
        pub fn after_blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_blob_id = Some(input.into());
            self
        }
        /// <p>In the directionality you established, the blob ID of the after blob.</p>
        pub fn set_after_blob_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_blob_id = input;
            self
        }
        /// <p>The location of the comment in the comparison between the two commits.</p>
        pub fn location(mut self, input: crate::model::Location) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The location of the comment in the comparison between the two commits.</p>
        pub fn set_location(mut self, input: std::option::Option<crate::model::Location>) -> Self {
            self.location = input;
            self
        }
        /// <p>The content of the comment you posted.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>The content of the comment you posted.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`PostCommentForComparedCommitOutput`](crate::output::PostCommentForComparedCommitOutput)
        pub fn build(self) -> crate::output::PostCommentForComparedCommitOutput {
            crate::output::PostCommentForComparedCommitOutput {
                repository_name: self.repository_name,
                before_commit_id: self.before_commit_id,
                after_commit_id: self.after_commit_id,
                before_blob_id: self.before_blob_id,
                after_blob_id: self.after_blob_id,
                location: self.location,
                comment: self.comment,
            }
        }
    }
}
impl PostCommentForComparedCommitOutput {
    /// Creates a new builder-style object to manufacture [`PostCommentForComparedCommitOutput`](crate::output::PostCommentForComparedCommitOutput)
    pub fn builder() -> crate::output::post_comment_for_compared_commit_output::Builder {
        crate::output::post_comment_for_compared_commit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OverridePullRequestApprovalRulesOutput {}
impl std::fmt::Debug for OverridePullRequestApprovalRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OverridePullRequestApprovalRulesOutput");
        formatter.finish()
    }
}
/// See [`OverridePullRequestApprovalRulesOutput`](crate::output::OverridePullRequestApprovalRulesOutput)
pub mod override_pull_request_approval_rules_output {
    /// A builder for [`OverridePullRequestApprovalRulesOutput`](crate::output::OverridePullRequestApprovalRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`OverridePullRequestApprovalRulesOutput`](crate::output::OverridePullRequestApprovalRulesOutput)
        pub fn build(self) -> crate::output::OverridePullRequestApprovalRulesOutput {
            crate::output::OverridePullRequestApprovalRulesOutput {}
        }
    }
}
impl OverridePullRequestApprovalRulesOutput {
    /// Creates a new builder-style object to manufacture [`OverridePullRequestApprovalRulesOutput`](crate::output::OverridePullRequestApprovalRulesOutput)
    pub fn builder() -> crate::output::override_pull_request_approval_rules_output::Builder {
        crate::output::override_pull_request_approval_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergePullRequestByThreeWayOutput {
    /// <p>Returns information about a pull request.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl MergePullRequestByThreeWayOutput {
    /// <p>Returns information about a pull request.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for MergePullRequestByThreeWayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergePullRequestByThreeWayOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`MergePullRequestByThreeWayOutput`](crate::output::MergePullRequestByThreeWayOutput)
pub mod merge_pull_request_by_three_way_output {
    /// A builder for [`MergePullRequestByThreeWayOutput`](crate::output::MergePullRequestByThreeWayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Returns information about a pull request.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Returns information about a pull request.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`MergePullRequestByThreeWayOutput`](crate::output::MergePullRequestByThreeWayOutput)
        pub fn build(self) -> crate::output::MergePullRequestByThreeWayOutput {
            crate::output::MergePullRequestByThreeWayOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl MergePullRequestByThreeWayOutput {
    /// Creates a new builder-style object to manufacture [`MergePullRequestByThreeWayOutput`](crate::output::MergePullRequestByThreeWayOutput)
    pub fn builder() -> crate::output::merge_pull_request_by_three_way_output::Builder {
        crate::output::merge_pull_request_by_three_way_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergePullRequestBySquashOutput {
    /// <p>Returns information about a pull request.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl MergePullRequestBySquashOutput {
    /// <p>Returns information about a pull request.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for MergePullRequestBySquashOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergePullRequestBySquashOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`MergePullRequestBySquashOutput`](crate::output::MergePullRequestBySquashOutput)
pub mod merge_pull_request_by_squash_output {
    /// A builder for [`MergePullRequestBySquashOutput`](crate::output::MergePullRequestBySquashOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Returns information about a pull request.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Returns information about a pull request.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`MergePullRequestBySquashOutput`](crate::output::MergePullRequestBySquashOutput)
        pub fn build(self) -> crate::output::MergePullRequestBySquashOutput {
            crate::output::MergePullRequestBySquashOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl MergePullRequestBySquashOutput {
    /// Creates a new builder-style object to manufacture [`MergePullRequestBySquashOutput`](crate::output::MergePullRequestBySquashOutput)
    pub fn builder() -> crate::output::merge_pull_request_by_squash_output::Builder {
        crate::output::merge_pull_request_by_squash_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergePullRequestByFastForwardOutput {
    /// <p>Information about the specified pull request, including the merge.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl MergePullRequestByFastForwardOutput {
    /// <p>Information about the specified pull request, including the merge.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for MergePullRequestByFastForwardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergePullRequestByFastForwardOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`MergePullRequestByFastForwardOutput`](crate::output::MergePullRequestByFastForwardOutput)
pub mod merge_pull_request_by_fast_forward_output {
    /// A builder for [`MergePullRequestByFastForwardOutput`](crate::output::MergePullRequestByFastForwardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Information about the specified pull request, including the merge.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Information about the specified pull request, including the merge.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`MergePullRequestByFastForwardOutput`](crate::output::MergePullRequestByFastForwardOutput)
        pub fn build(self) -> crate::output::MergePullRequestByFastForwardOutput {
            crate::output::MergePullRequestByFastForwardOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl MergePullRequestByFastForwardOutput {
    /// Creates a new builder-style object to manufacture [`MergePullRequestByFastForwardOutput`](crate::output::MergePullRequestByFastForwardOutput)
    pub fn builder() -> crate::output::merge_pull_request_by_fast_forward_output::Builder {
        crate::output::merge_pull_request_by_fast_forward_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeBranchesByThreeWayOutput {
    /// <p>The commit ID of the merge in the destination or target branch.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The tree ID of the merge in the destination or target branch.</p>
    pub tree_id: std::option::Option<std::string::String>,
}
impl MergeBranchesByThreeWayOutput {
    /// <p>The commit ID of the merge in the destination or target branch.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The tree ID of the merge in the destination or target branch.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
}
impl std::fmt::Debug for MergeBranchesByThreeWayOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeBranchesByThreeWayOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.finish()
    }
}
/// See [`MergeBranchesByThreeWayOutput`](crate::output::MergeBranchesByThreeWayOutput)
pub mod merge_branches_by_three_way_output {
    /// A builder for [`MergeBranchesByThreeWayOutput`](crate::output::MergeBranchesByThreeWayOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The commit ID of the merge in the destination or target branch.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge in the destination or target branch.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The tree ID of the merge in the destination or target branch.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The tree ID of the merge in the destination or target branch.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeBranchesByThreeWayOutput`](crate::output::MergeBranchesByThreeWayOutput)
        pub fn build(self) -> crate::output::MergeBranchesByThreeWayOutput {
            crate::output::MergeBranchesByThreeWayOutput {
                commit_id: self.commit_id,
                tree_id: self.tree_id,
            }
        }
    }
}
impl MergeBranchesByThreeWayOutput {
    /// Creates a new builder-style object to manufacture [`MergeBranchesByThreeWayOutput`](crate::output::MergeBranchesByThreeWayOutput)
    pub fn builder() -> crate::output::merge_branches_by_three_way_output::Builder {
        crate::output::merge_branches_by_three_way_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeBranchesBySquashOutput {
    /// <p>The commit ID of the merge in the destination or target branch.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The tree ID of the merge in the destination or target branch.</p>
    pub tree_id: std::option::Option<std::string::String>,
}
impl MergeBranchesBySquashOutput {
    /// <p>The commit ID of the merge in the destination or target branch.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The tree ID of the merge in the destination or target branch.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
}
impl std::fmt::Debug for MergeBranchesBySquashOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeBranchesBySquashOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.finish()
    }
}
/// See [`MergeBranchesBySquashOutput`](crate::output::MergeBranchesBySquashOutput)
pub mod merge_branches_by_squash_output {
    /// A builder for [`MergeBranchesBySquashOutput`](crate::output::MergeBranchesBySquashOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The commit ID of the merge in the destination or target branch.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge in the destination or target branch.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The tree ID of the merge in the destination or target branch.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The tree ID of the merge in the destination or target branch.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeBranchesBySquashOutput`](crate::output::MergeBranchesBySquashOutput)
        pub fn build(self) -> crate::output::MergeBranchesBySquashOutput {
            crate::output::MergeBranchesBySquashOutput {
                commit_id: self.commit_id,
                tree_id: self.tree_id,
            }
        }
    }
}
impl MergeBranchesBySquashOutput {
    /// Creates a new builder-style object to manufacture [`MergeBranchesBySquashOutput`](crate::output::MergeBranchesBySquashOutput)
    pub fn builder() -> crate::output::merge_branches_by_squash_output::Builder {
        crate::output::merge_branches_by_squash_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeBranchesByFastForwardOutput {
    /// <p>The commit ID of the merge in the destination or target branch.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The tree ID of the merge in the destination or target branch.</p>
    pub tree_id: std::option::Option<std::string::String>,
}
impl MergeBranchesByFastForwardOutput {
    /// <p>The commit ID of the merge in the destination or target branch.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The tree ID of the merge in the destination or target branch.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
}
impl std::fmt::Debug for MergeBranchesByFastForwardOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeBranchesByFastForwardOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.finish()
    }
}
/// See [`MergeBranchesByFastForwardOutput`](crate::output::MergeBranchesByFastForwardOutput)
pub mod merge_branches_by_fast_forward_output {
    /// A builder for [`MergeBranchesByFastForwardOutput`](crate::output::MergeBranchesByFastForwardOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The commit ID of the merge in the destination or target branch.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge in the destination or target branch.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The tree ID of the merge in the destination or target branch.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The tree ID of the merge in the destination or target branch.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeBranchesByFastForwardOutput`](crate::output::MergeBranchesByFastForwardOutput)
        pub fn build(self) -> crate::output::MergeBranchesByFastForwardOutput {
            crate::output::MergeBranchesByFastForwardOutput {
                commit_id: self.commit_id,
                tree_id: self.tree_id,
            }
        }
    }
}
impl MergeBranchesByFastForwardOutput {
    /// Creates a new builder-style object to manufacture [`MergeBranchesByFastForwardOutput`](crate::output::MergeBranchesByFastForwardOutput)
    pub fn builder() -> crate::output::merge_branches_by_fast_forward_output::Builder {
        crate::output::merge_branches_by_fast_forward_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tag key and value pairs associated with the specified resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tag key and value pairs associated with the specified resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key and value pairs associated with the specified resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of tag key and value pairs associated with the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tags: self.tags,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesForApprovalRuleTemplateOutput {
    /// <p>A list of repository names that are associated with the specified approval rule template.</p>
    pub repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRepositoriesForApprovalRuleTemplateOutput {
    /// <p>A list of repository names that are associated with the specified approval rule template.</p>
    pub fn repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.repository_names.as_deref()
    }
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRepositoriesForApprovalRuleTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesForApprovalRuleTemplateOutput");
        formatter.field("repository_names", &self.repository_names);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRepositoriesForApprovalRuleTemplateOutput`](crate::output::ListRepositoriesForApprovalRuleTemplateOutput)
pub mod list_repositories_for_approval_rule_template_output {
    /// A builder for [`ListRepositoriesForApprovalRuleTemplateOutput`](crate::output::ListRepositoriesForApprovalRuleTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `repository_names`.
        ///
        /// To override the contents of this collection use [`set_repository_names`](Self::set_repository_names).
        ///
        /// <p>A list of repository names that are associated with the specified approval rule template.</p>
        pub fn repository_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repository_names.unwrap_or_default();
            v.push(input.into());
            self.repository_names = Some(v);
            self
        }
        /// <p>A list of repository names that are associated with the specified approval rule template.</p>
        pub fn set_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repository_names = input;
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesForApprovalRuleTemplateOutput`](crate::output::ListRepositoriesForApprovalRuleTemplateOutput)
        pub fn build(self) -> crate::output::ListRepositoriesForApprovalRuleTemplateOutput {
            crate::output::ListRepositoriesForApprovalRuleTemplateOutput {
                repository_names: self.repository_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRepositoriesForApprovalRuleTemplateOutput {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesForApprovalRuleTemplateOutput`](crate::output::ListRepositoriesForApprovalRuleTemplateOutput)
    pub fn builder() -> crate::output::list_repositories_for_approval_rule_template_output::Builder
    {
        crate::output::list_repositories_for_approval_rule_template_output::Builder::default()
    }
}

/// <p>Represents the output of a list repositories operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesOutput {
    /// <p>Lists the repositories called by the list repositories operation.</p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::RepositoryNameIdPair>>,
    /// <p>An enumeration token that allows the operation to batch the results of the operation.
    /// Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit,
    /// another page of 1,000 records is retrieved.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRepositoriesOutput {
    /// <p>Lists the repositories called by the list repositories operation.</p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::RepositoryNameIdPair]> {
        self.repositories.as_deref()
    }
    /// <p>An enumeration token that allows the operation to batch the results of the operation.
    /// Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit,
    /// another page of 1,000 records is retrieved.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesOutput");
        formatter.field("repositories", &self.repositories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
pub mod list_repositories_output {
    /// A builder for [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories:
            std::option::Option<std::vec::Vec<crate::model::RepositoryNameIdPair>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>Lists the repositories called by the list repositories operation.</p>
        pub fn repositories(
            mut self,
            input: impl Into<crate::model::RepositoryNameIdPair>,
        ) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input.into());
            self.repositories = Some(v);
            self
        }
        /// <p>Lists the repositories called by the list repositories operation.</p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryNameIdPair>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results of the operation.
        /// Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit,
        /// another page of 1,000 records is retrieved.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the results of the operation.
        /// Batch sizes are 1,000 for list repository operations. When the client sends the token back to AWS CodeCommit,
        /// another page of 1,000 records is retrieved.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
        pub fn build(self) -> crate::output::ListRepositoriesOutput {
            crate::output::ListRepositoriesOutput {
                repositories: self.repositories,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
    pub fn builder() -> crate::output::list_repositories_output::Builder {
        crate::output::list_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPullRequestsOutput {
    /// <p>The system-generated IDs of the pull requests.</p>
    pub pull_request_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPullRequestsOutput {
    /// <p>The system-generated IDs of the pull requests.</p>
    pub fn pull_request_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.pull_request_ids.as_deref()
    }
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPullRequestsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPullRequestsOutput");
        formatter.field("pull_request_ids", &self.pull_request_ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPullRequestsOutput`](crate::output::ListPullRequestsOutput)
pub mod list_pull_requests_output {
    /// A builder for [`ListPullRequestsOutput`](crate::output::ListPullRequestsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pull_request_ids`.
        ///
        /// To override the contents of this collection use [`set_pull_request_ids`](Self::set_pull_request_ids).
        ///
        /// <p>The system-generated IDs of the pull requests.</p>
        pub fn pull_request_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pull_request_ids.unwrap_or_default();
            v.push(input.into());
            self.pull_request_ids = Some(v);
            self
        }
        /// <p>The system-generated IDs of the pull requests.</p>
        pub fn set_pull_request_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pull_request_ids = input;
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPullRequestsOutput`](crate::output::ListPullRequestsOutput)
        pub fn build(self) -> crate::output::ListPullRequestsOutput {
            crate::output::ListPullRequestsOutput {
                pull_request_ids: self.pull_request_ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPullRequestsOutput {
    /// Creates a new builder-style object to manufacture [`ListPullRequestsOutput`](crate::output::ListPullRequestsOutput)
    pub fn builder() -> crate::output::list_pull_requests_output::Builder {
        crate::output::list_pull_requests_output::Builder::default()
    }
}

/// <p>Represents the output of a list branches operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBranchesOutput {
    /// <p>The list of branch names.</p>
    pub branches: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An enumeration token that returns the batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListBranchesOutput {
    /// <p>The list of branch names.</p>
    pub fn branches(&self) -> std::option::Option<&[std::string::String]> {
        self.branches.as_deref()
    }
    /// <p>An enumeration token that returns the batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListBranchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBranchesOutput");
        formatter.field("branches", &self.branches);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBranchesOutput`](crate::output::ListBranchesOutput)
pub mod list_branches_output {
    /// A builder for [`ListBranchesOutput`](crate::output::ListBranchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branches: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `branches`.
        ///
        /// To override the contents of this collection use [`set_branches`](Self::set_branches).
        ///
        /// <p>The list of branch names.</p>
        pub fn branches(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.branches.unwrap_or_default();
            v.push(input.into());
            self.branches = Some(v);
            self
        }
        /// <p>The list of branch names.</p>
        pub fn set_branches(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.branches = input;
            self
        }
        /// <p>An enumeration token that returns the batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that returns the batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBranchesOutput`](crate::output::ListBranchesOutput)
        pub fn build(self) -> crate::output::ListBranchesOutput {
            crate::output::ListBranchesOutput {
                branches: self.branches,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBranchesOutput {
    /// Creates a new builder-style object to manufacture [`ListBranchesOutput`](crate::output::ListBranchesOutput)
    pub fn builder() -> crate::output::list_branches_output::Builder {
        crate::output::list_branches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
    /// <p>The names of all approval rule templates associated with the repository.</p>
    pub approval_rule_template_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
    /// <p>The names of all approval rule templates associated with the repository.</p>
    pub fn approval_rule_template_names(&self) -> std::option::Option<&[std::string::String]> {
        self.approval_rule_template_names.as_deref()
    }
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("ListAssociatedApprovalRuleTemplatesForRepositoryOutput");
        formatter.field(
            "approval_rule_template_names",
            &self.approval_rule_template_names,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAssociatedApprovalRuleTemplatesForRepositoryOutput`](crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput)
pub mod list_associated_approval_rule_templates_for_repository_output {
    /// A builder for [`ListAssociatedApprovalRuleTemplatesForRepositoryOutput`](crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `approval_rule_template_names`.
        ///
        /// To override the contents of this collection use [`set_approval_rule_template_names`](Self::set_approval_rule_template_names).
        ///
        /// <p>The names of all approval rule templates associated with the repository.</p>
        pub fn approval_rule_template_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.approval_rule_template_names.unwrap_or_default();
            v.push(input.into());
            self.approval_rule_template_names = Some(v);
            self
        }
        /// <p>The names of all approval rule templates associated with the repository.</p>
        pub fn set_approval_rule_template_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approval_rule_template_names = input;
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociatedApprovalRuleTemplatesForRepositoryOutput`](crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput)
        pub fn build(
            self,
        ) -> crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
            crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
                approval_rule_template_names: self.approval_rule_template_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAssociatedApprovalRuleTemplatesForRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`ListAssociatedApprovalRuleTemplatesForRepositoryOutput`](crate::output::ListAssociatedApprovalRuleTemplatesForRepositoryOutput)
    pub fn builder(
    ) -> crate::output::list_associated_approval_rule_templates_for_repository_output::Builder {
        crate::output::list_associated_approval_rule_templates_for_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListApprovalRuleTemplatesOutput {
    /// <p>The names of all the approval rule templates found in the AWS Region for your AWS account.</p>
    pub approval_rule_template_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListApprovalRuleTemplatesOutput {
    /// <p>The names of all the approval rule templates found in the AWS Region for your AWS account.</p>
    pub fn approval_rule_template_names(&self) -> std::option::Option<&[std::string::String]> {
        self.approval_rule_template_names.as_deref()
    }
    /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListApprovalRuleTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListApprovalRuleTemplatesOutput");
        formatter.field(
            "approval_rule_template_names",
            &self.approval_rule_template_names,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListApprovalRuleTemplatesOutput`](crate::output::ListApprovalRuleTemplatesOutput)
pub mod list_approval_rule_templates_output {
    /// A builder for [`ListApprovalRuleTemplatesOutput`](crate::output::ListApprovalRuleTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `approval_rule_template_names`.
        ///
        /// To override the contents of this collection use [`set_approval_rule_template_names`](Self::set_approval_rule_template_names).
        ///
        /// <p>The names of all the approval rule templates found in the AWS Region for your AWS account.</p>
        pub fn approval_rule_template_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.approval_rule_template_names.unwrap_or_default();
            v.push(input.into());
            self.approval_rule_template_names = Some(v);
            self
        }
        /// <p>The names of all the approval rule templates found in the AWS Region for your AWS account.</p>
        pub fn set_approval_rule_template_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.approval_rule_template_names = input;
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that allows the operation to batch the next results of the operation.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApprovalRuleTemplatesOutput`](crate::output::ListApprovalRuleTemplatesOutput)
        pub fn build(self) -> crate::output::ListApprovalRuleTemplatesOutput {
            crate::output::ListApprovalRuleTemplatesOutput {
                approval_rule_template_names: self.approval_rule_template_names,
                next_token: self.next_token,
            }
        }
    }
}
impl ListApprovalRuleTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListApprovalRuleTemplatesOutput`](crate::output::ListApprovalRuleTemplatesOutput)
    pub fn builder() -> crate::output::list_approval_rule_templates_output::Builder {
        crate::output::list_approval_rule_templates_output::Builder::default()
    }
}

/// <p>Represents the output of a get repository triggers operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryTriggersOutput {
    /// <p>The system-generated unique ID for the trigger.</p>
    pub configuration_id: std::option::Option<std::string::String>,
    /// <p>The JSON block of configuration information for each trigger.</p>
    pub triggers: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
}
impl GetRepositoryTriggersOutput {
    /// <p>The system-generated unique ID for the trigger.</p>
    pub fn configuration_id(&self) -> std::option::Option<&str> {
        self.configuration_id.as_deref()
    }
    /// <p>The JSON block of configuration information for each trigger.</p>
    pub fn triggers(&self) -> std::option::Option<&[crate::model::RepositoryTrigger]> {
        self.triggers.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryTriggersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryTriggersOutput");
        formatter.field("configuration_id", &self.configuration_id);
        formatter.field("triggers", &self.triggers);
        formatter.finish()
    }
}
/// See [`GetRepositoryTriggersOutput`](crate::output::GetRepositoryTriggersOutput)
pub mod get_repository_triggers_output {
    /// A builder for [`GetRepositoryTriggersOutput`](crate::output::GetRepositoryTriggersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration_id: std::option::Option<std::string::String>,
        pub(crate) triggers: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
    }
    impl Builder {
        /// <p>The system-generated unique ID for the trigger.</p>
        pub fn configuration_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.configuration_id = Some(input.into());
            self
        }
        /// <p>The system-generated unique ID for the trigger.</p>
        pub fn set_configuration_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.configuration_id = input;
            self
        }
        /// Appends an item to `triggers`.
        ///
        /// To override the contents of this collection use [`set_triggers`](Self::set_triggers).
        ///
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn triggers(mut self, input: impl Into<crate::model::RepositoryTrigger>) -> Self {
            let mut v = self.triggers.unwrap_or_default();
            v.push(input.into());
            self.triggers = Some(v);
            self
        }
        /// <p>The JSON block of configuration information for each trigger.</p>
        pub fn set_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryTrigger>>,
        ) -> Self {
            self.triggers = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryTriggersOutput`](crate::output::GetRepositoryTriggersOutput)
        pub fn build(self) -> crate::output::GetRepositoryTriggersOutput {
            crate::output::GetRepositoryTriggersOutput {
                configuration_id: self.configuration_id,
                triggers: self.triggers,
            }
        }
    }
}
impl GetRepositoryTriggersOutput {
    /// Creates a new builder-style object to manufacture [`GetRepositoryTriggersOutput`](crate::output::GetRepositoryTriggersOutput)
    pub fn builder() -> crate::output::get_repository_triggers_output::Builder {
        crate::output::get_repository_triggers_output::Builder::default()
    }
}

/// <p>Represents the output of a get repository operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryOutput {
    /// <p>Information about the repository.</p>
    pub repository_metadata: std::option::Option<crate::model::RepositoryMetadata>,
}
impl GetRepositoryOutput {
    /// <p>Information about the repository.</p>
    pub fn repository_metadata(&self) -> std::option::Option<&crate::model::RepositoryMetadata> {
        self.repository_metadata.as_ref()
    }
}
impl std::fmt::Debug for GetRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryOutput");
        formatter.field("repository_metadata", &self.repository_metadata);
        formatter.finish()
    }
}
/// See [`GetRepositoryOutput`](crate::output::GetRepositoryOutput)
pub mod get_repository_output {
    /// A builder for [`GetRepositoryOutput`](crate::output::GetRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_metadata: std::option::Option<crate::model::RepositoryMetadata>,
    }
    impl Builder {
        /// <p>Information about the repository.</p>
        pub fn repository_metadata(mut self, input: crate::model::RepositoryMetadata) -> Self {
            self.repository_metadata = Some(input);
            self
        }
        /// <p>Information about the repository.</p>
        pub fn set_repository_metadata(
            mut self,
            input: std::option::Option<crate::model::RepositoryMetadata>,
        ) -> Self {
            self.repository_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryOutput`](crate::output::GetRepositoryOutput)
        pub fn build(self) -> crate::output::GetRepositoryOutput {
            crate::output::GetRepositoryOutput {
                repository_metadata: self.repository_metadata,
            }
        }
    }
}
impl GetRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`GetRepositoryOutput`](crate::output::GetRepositoryOutput)
    pub fn builder() -> crate::output::get_repository_output::Builder {
        crate::output::get_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPullRequestOverrideStateOutput {
    /// <p>A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all approval rules still apply (FALSE).</p>
    pub overridden: bool,
    /// <p>The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>
    pub overrider: std::option::Option<std::string::String>,
}
impl GetPullRequestOverrideStateOutput {
    /// <p>A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all approval rules still apply (FALSE).</p>
    pub fn overridden(&self) -> bool {
        self.overridden
    }
    /// <p>The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>
    pub fn overrider(&self) -> std::option::Option<&str> {
        self.overrider.as_deref()
    }
}
impl std::fmt::Debug for GetPullRequestOverrideStateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPullRequestOverrideStateOutput");
        formatter.field("overridden", &self.overridden);
        formatter.field("overrider", &self.overrider);
        formatter.finish()
    }
}
/// See [`GetPullRequestOverrideStateOutput`](crate::output::GetPullRequestOverrideStateOutput)
pub mod get_pull_request_override_state_output {
    /// A builder for [`GetPullRequestOverrideStateOutput`](crate::output::GetPullRequestOverrideStateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) overridden: std::option::Option<bool>,
        pub(crate) overrider: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all approval rules still apply (FALSE).</p>
        pub fn overridden(mut self, input: bool) -> Self {
            self.overridden = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether a pull request has had its rules set aside (TRUE) or whether all approval rules still apply (FALSE).</p>
        pub fn set_overridden(mut self, input: std::option::Option<bool>) -> Self {
            self.overridden = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>
        pub fn overrider(mut self, input: impl Into<std::string::String>) -> Self {
            self.overrider = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the user or identity that overrode the rules and their requirements for the pull request.</p>
        pub fn set_overrider(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.overrider = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPullRequestOverrideStateOutput`](crate::output::GetPullRequestOverrideStateOutput)
        pub fn build(self) -> crate::output::GetPullRequestOverrideStateOutput {
            crate::output::GetPullRequestOverrideStateOutput {
                overridden: self.overridden.unwrap_or_default(),
                overrider: self.overrider,
            }
        }
    }
}
impl GetPullRequestOverrideStateOutput {
    /// Creates a new builder-style object to manufacture [`GetPullRequestOverrideStateOutput`](crate::output::GetPullRequestOverrideStateOutput)
    pub fn builder() -> crate::output::get_pull_request_override_state_output::Builder {
        crate::output::get_pull_request_override_state_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPullRequestApprovalStatesOutput {
    /// <p>Information about users who have approved the pull request.</p>
    pub approvals: std::option::Option<std::vec::Vec<crate::model::Approval>>,
}
impl GetPullRequestApprovalStatesOutput {
    /// <p>Information about users who have approved the pull request.</p>
    pub fn approvals(&self) -> std::option::Option<&[crate::model::Approval]> {
        self.approvals.as_deref()
    }
}
impl std::fmt::Debug for GetPullRequestApprovalStatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPullRequestApprovalStatesOutput");
        formatter.field("approvals", &self.approvals);
        formatter.finish()
    }
}
/// See [`GetPullRequestApprovalStatesOutput`](crate::output::GetPullRequestApprovalStatesOutput)
pub mod get_pull_request_approval_states_output {
    /// A builder for [`GetPullRequestApprovalStatesOutput`](crate::output::GetPullRequestApprovalStatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approvals: std::option::Option<std::vec::Vec<crate::model::Approval>>,
    }
    impl Builder {
        /// Appends an item to `approvals`.
        ///
        /// To override the contents of this collection use [`set_approvals`](Self::set_approvals).
        ///
        /// <p>Information about users who have approved the pull request.</p>
        pub fn approvals(mut self, input: impl Into<crate::model::Approval>) -> Self {
            let mut v = self.approvals.unwrap_or_default();
            v.push(input.into());
            self.approvals = Some(v);
            self
        }
        /// <p>Information about users who have approved the pull request.</p>
        pub fn set_approvals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Approval>>,
        ) -> Self {
            self.approvals = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPullRequestApprovalStatesOutput`](crate::output::GetPullRequestApprovalStatesOutput)
        pub fn build(self) -> crate::output::GetPullRequestApprovalStatesOutput {
            crate::output::GetPullRequestApprovalStatesOutput {
                approvals: self.approvals,
            }
        }
    }
}
impl GetPullRequestApprovalStatesOutput {
    /// Creates a new builder-style object to manufacture [`GetPullRequestApprovalStatesOutput`](crate::output::GetPullRequestApprovalStatesOutput)
    pub fn builder() -> crate::output::get_pull_request_approval_states_output::Builder {
        crate::output::get_pull_request_approval_states_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPullRequestOutput {
    /// <p>Information about the specified pull request.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl GetPullRequestOutput {
    /// <p>Information about the specified pull request.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for GetPullRequestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPullRequestOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`GetPullRequestOutput`](crate::output::GetPullRequestOutput)
pub mod get_pull_request_output {
    /// A builder for [`GetPullRequestOutput`](crate::output::GetPullRequestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Information about the specified pull request.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Information about the specified pull request.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPullRequestOutput`](crate::output::GetPullRequestOutput)
        pub fn build(self) -> crate::output::GetPullRequestOutput {
            crate::output::GetPullRequestOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl GetPullRequestOutput {
    /// Creates a new builder-style object to manufacture [`GetPullRequestOutput`](crate::output::GetPullRequestOutput)
    pub fn builder() -> crate::output::get_pull_request_output::Builder {
        crate::output::get_pull_request_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMergeOptionsOutput {
    /// <p>The merge option or strategy used to merge the code.</p>
    pub merge_options: std::option::Option<std::vec::Vec<crate::model::MergeOptionTypeEnum>>,
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub destination_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the merge base.</p>
    pub base_commit_id: std::option::Option<std::string::String>,
}
impl GetMergeOptionsOutput {
    /// <p>The merge option or strategy used to merge the code.</p>
    pub fn merge_options(&self) -> std::option::Option<&[crate::model::MergeOptionTypeEnum]> {
        self.merge_options.as_deref()
    }
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub fn destination_commit_id(&self) -> std::option::Option<&str> {
        self.destination_commit_id.as_deref()
    }
    /// <p>The commit ID of the merge base.</p>
    pub fn base_commit_id(&self) -> std::option::Option<&str> {
        self.base_commit_id.as_deref()
    }
}
impl std::fmt::Debug for GetMergeOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMergeOptionsOutput");
        formatter.field("merge_options", &self.merge_options);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("destination_commit_id", &self.destination_commit_id);
        formatter.field("base_commit_id", &self.base_commit_id);
        formatter.finish()
    }
}
/// See [`GetMergeOptionsOutput`](crate::output::GetMergeOptionsOutput)
pub mod get_merge_options_output {
    /// A builder for [`GetMergeOptionsOutput`](crate::output::GetMergeOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) merge_options:
            std::option::Option<std::vec::Vec<crate::model::MergeOptionTypeEnum>>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) destination_commit_id: std::option::Option<std::string::String>,
        pub(crate) base_commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `merge_options`.
        ///
        /// To override the contents of this collection use [`set_merge_options`](Self::set_merge_options).
        ///
        /// <p>The merge option or strategy used to merge the code.</p>
        pub fn merge_options(
            mut self,
            input: impl Into<crate::model::MergeOptionTypeEnum>,
        ) -> Self {
            let mut v = self.merge_options.unwrap_or_default();
            v.push(input.into());
            self.merge_options = Some(v);
            self
        }
        /// <p>The merge option or strategy used to merge the code.</p>
        pub fn set_merge_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MergeOptionTypeEnum>>,
        ) -> Self {
            self.merge_options = input;
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn destination_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn set_destination_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_id = input;
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn base_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn set_base_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMergeOptionsOutput`](crate::output::GetMergeOptionsOutput)
        pub fn build(self) -> crate::output::GetMergeOptionsOutput {
            crate::output::GetMergeOptionsOutput {
                merge_options: self.merge_options,
                source_commit_id: self.source_commit_id,
                destination_commit_id: self.destination_commit_id,
                base_commit_id: self.base_commit_id,
            }
        }
    }
}
impl GetMergeOptionsOutput {
    /// Creates a new builder-style object to manufacture [`GetMergeOptionsOutput`](crate::output::GetMergeOptionsOutput)
    pub fn builder() -> crate::output::get_merge_options_output::Builder {
        crate::output::get_merge_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMergeConflictsOutput {
    /// <p>A Boolean value that indicates whether the code is mergeable by the specified merge option.</p>
    pub mergeable: bool,
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub destination_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the merge base.</p>
    pub base_commit_id: std::option::Option<std::string::String>,
    /// <p>A list of metadata for any conflicting files. If the specified merge strategy is
    /// FAST_FORWARD_MERGE, this list is always empty.</p>
    pub conflict_metadata_list: std::option::Option<std::vec::Vec<crate::model::ConflictMetadata>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetMergeConflictsOutput {
    /// <p>A Boolean value that indicates whether the code is mergeable by the specified merge option.</p>
    pub fn mergeable(&self) -> bool {
        self.mergeable
    }
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub fn destination_commit_id(&self) -> std::option::Option<&str> {
        self.destination_commit_id.as_deref()
    }
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The commit ID of the merge base.</p>
    pub fn base_commit_id(&self) -> std::option::Option<&str> {
        self.base_commit_id.as_deref()
    }
    /// <p>A list of metadata for any conflicting files. If the specified merge strategy is
    /// FAST_FORWARD_MERGE, this list is always empty.</p>
    pub fn conflict_metadata_list(&self) -> std::option::Option<&[crate::model::ConflictMetadata]> {
        self.conflict_metadata_list.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetMergeConflictsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMergeConflictsOutput");
        formatter.field("mergeable", &self.mergeable);
        formatter.field("destination_commit_id", &self.destination_commit_id);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("base_commit_id", &self.base_commit_id);
        formatter.field("conflict_metadata_list", &self.conflict_metadata_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetMergeConflictsOutput`](crate::output::GetMergeConflictsOutput)
pub mod get_merge_conflicts_output {
    /// A builder for [`GetMergeConflictsOutput`](crate::output::GetMergeConflictsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mergeable: std::option::Option<bool>,
        pub(crate) destination_commit_id: std::option::Option<std::string::String>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) base_commit_id: std::option::Option<std::string::String>,
        pub(crate) conflict_metadata_list:
            std::option::Option<std::vec::Vec<crate::model::ConflictMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean value that indicates whether the code is mergeable by the specified merge option.</p>
        pub fn mergeable(mut self, input: bool) -> Self {
            self.mergeable = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether the code is mergeable by the specified merge option.</p>
        pub fn set_mergeable(mut self, input: std::option::Option<bool>) -> Self {
            self.mergeable = input;
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn destination_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn set_destination_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_id = input;
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn base_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn set_base_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_commit_id = input;
            self
        }
        /// Appends an item to `conflict_metadata_list`.
        ///
        /// To override the contents of this collection use [`set_conflict_metadata_list`](Self::set_conflict_metadata_list).
        ///
        /// <p>A list of metadata for any conflicting files. If the specified merge strategy is
        /// FAST_FORWARD_MERGE, this list is always empty.</p>
        pub fn conflict_metadata_list(
            mut self,
            input: impl Into<crate::model::ConflictMetadata>,
        ) -> Self {
            let mut v = self.conflict_metadata_list.unwrap_or_default();
            v.push(input.into());
            self.conflict_metadata_list = Some(v);
            self
        }
        /// <p>A list of metadata for any conflicting files. If the specified merge strategy is
        /// FAST_FORWARD_MERGE, this list is always empty.</p>
        pub fn set_conflict_metadata_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConflictMetadata>>,
        ) -> Self {
            self.conflict_metadata_list = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMergeConflictsOutput`](crate::output::GetMergeConflictsOutput)
        pub fn build(self) -> crate::output::GetMergeConflictsOutput {
            crate::output::GetMergeConflictsOutput {
                mergeable: self.mergeable.unwrap_or_default(),
                destination_commit_id: self.destination_commit_id,
                source_commit_id: self.source_commit_id,
                base_commit_id: self.base_commit_id,
                conflict_metadata_list: self.conflict_metadata_list,
                next_token: self.next_token,
            }
        }
    }
}
impl GetMergeConflictsOutput {
    /// Creates a new builder-style object to manufacture [`GetMergeConflictsOutput`](crate::output::GetMergeConflictsOutput)
    pub fn builder() -> crate::output::get_merge_conflicts_output::Builder {
        crate::output::get_merge_conflicts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMergeCommitOutput {
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub destination_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the merge base.</p>
    pub base_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID for the merge commit created when the source branch was merged into the
    /// destination branch. If the fast-forward merge strategy was used, there is no merge
    /// commit.</p>
    pub merged_commit_id: std::option::Option<std::string::String>,
}
impl GetMergeCommitOutput {
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub fn destination_commit_id(&self) -> std::option::Option<&str> {
        self.destination_commit_id.as_deref()
    }
    /// <p>The commit ID of the merge base.</p>
    pub fn base_commit_id(&self) -> std::option::Option<&str> {
        self.base_commit_id.as_deref()
    }
    /// <p>The commit ID for the merge commit created when the source branch was merged into the
    /// destination branch. If the fast-forward merge strategy was used, there is no merge
    /// commit.</p>
    pub fn merged_commit_id(&self) -> std::option::Option<&str> {
        self.merged_commit_id.as_deref()
    }
}
impl std::fmt::Debug for GetMergeCommitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMergeCommitOutput");
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("destination_commit_id", &self.destination_commit_id);
        formatter.field("base_commit_id", &self.base_commit_id);
        formatter.field("merged_commit_id", &self.merged_commit_id);
        formatter.finish()
    }
}
/// See [`GetMergeCommitOutput`](crate::output::GetMergeCommitOutput)
pub mod get_merge_commit_output {
    /// A builder for [`GetMergeCommitOutput`](crate::output::GetMergeCommitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) destination_commit_id: std::option::Option<std::string::String>,
        pub(crate) base_commit_id: std::option::Option<std::string::String>,
        pub(crate) merged_commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn destination_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn set_destination_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_id = input;
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn base_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn set_base_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_commit_id = input;
            self
        }
        /// <p>The commit ID for the merge commit created when the source branch was merged into the
        /// destination branch. If the fast-forward merge strategy was used, there is no merge
        /// commit.</p>
        pub fn merged_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.merged_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID for the merge commit created when the source branch was merged into the
        /// destination branch. If the fast-forward merge strategy was used, there is no merge
        /// commit.</p>
        pub fn set_merged_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.merged_commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMergeCommitOutput`](crate::output::GetMergeCommitOutput)
        pub fn build(self) -> crate::output::GetMergeCommitOutput {
            crate::output::GetMergeCommitOutput {
                source_commit_id: self.source_commit_id,
                destination_commit_id: self.destination_commit_id,
                base_commit_id: self.base_commit_id,
                merged_commit_id: self.merged_commit_id,
            }
        }
    }
}
impl GetMergeCommitOutput {
    /// Creates a new builder-style object to manufacture [`GetMergeCommitOutput`](crate::output::GetMergeCommitOutput)
    pub fn builder() -> crate::output::get_merge_commit_output::Builder {
        crate::output::get_merge_commit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFolderOutput {
    /// <p>The full commit ID used as a reference for the returned version of the folder
    /// content.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified path of the folder whose contents are returned.</p>
    pub folder_path: std::option::Option<std::string::String>,
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
    pub tree_id: std::option::Option<std::string::String>,
    /// <p>The list of folders that exist under the specified folder, if any.</p>
    pub sub_folders: std::option::Option<std::vec::Vec<crate::model::Folder>>,
    /// <p>The list of files in the specified folder, if any.</p>
    pub files: std::option::Option<std::vec::Vec<crate::model::File>>,
    /// <p>The list of symbolic links to other files and folders in the specified folder, if
    /// any.</p>
    pub symbolic_links: std::option::Option<std::vec::Vec<crate::model::SymbolicLink>>,
    /// <p>The list of submodules in the specified folder, if any.</p>
    pub sub_modules: std::option::Option<std::vec::Vec<crate::model::SubModule>>,
}
impl GetFolderOutput {
    /// <p>The full commit ID used as a reference for the returned version of the folder
    /// content.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The fully qualified path of the folder whose contents are returned.</p>
    pub fn folder_path(&self) -> std::option::Option<&str> {
        self.folder_path.as_deref()
    }
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
    /// <p>The list of folders that exist under the specified folder, if any.</p>
    pub fn sub_folders(&self) -> std::option::Option<&[crate::model::Folder]> {
        self.sub_folders.as_deref()
    }
    /// <p>The list of files in the specified folder, if any.</p>
    pub fn files(&self) -> std::option::Option<&[crate::model::File]> {
        self.files.as_deref()
    }
    /// <p>The list of symbolic links to other files and folders in the specified folder, if
    /// any.</p>
    pub fn symbolic_links(&self) -> std::option::Option<&[crate::model::SymbolicLink]> {
        self.symbolic_links.as_deref()
    }
    /// <p>The list of submodules in the specified folder, if any.</p>
    pub fn sub_modules(&self) -> std::option::Option<&[crate::model::SubModule]> {
        self.sub_modules.as_deref()
    }
}
impl std::fmt::Debug for GetFolderOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFolderOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("folder_path", &self.folder_path);
        formatter.field("tree_id", &self.tree_id);
        formatter.field("sub_folders", &self.sub_folders);
        formatter.field("files", &self.files);
        formatter.field("symbolic_links", &self.symbolic_links);
        formatter.field("sub_modules", &self.sub_modules);
        formatter.finish()
    }
}
/// See [`GetFolderOutput`](crate::output::GetFolderOutput)
pub mod get_folder_output {
    /// A builder for [`GetFolderOutput`](crate::output::GetFolderOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) folder_path: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
        pub(crate) sub_folders: std::option::Option<std::vec::Vec<crate::model::Folder>>,
        pub(crate) files: std::option::Option<std::vec::Vec<crate::model::File>>,
        pub(crate) symbolic_links: std::option::Option<std::vec::Vec<crate::model::SymbolicLink>>,
        pub(crate) sub_modules: std::option::Option<std::vec::Vec<crate::model::SubModule>>,
    }
    impl Builder {
        /// <p>The full commit ID used as a reference for the returned version of the folder
        /// content.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID used as a reference for the returned version of the folder
        /// content.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The fully qualified path of the folder whose contents are returned.</p>
        pub fn folder_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.folder_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path of the folder whose contents are returned.</p>
        pub fn set_folder_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.folder_path = input;
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the folder.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Appends an item to `sub_folders`.
        ///
        /// To override the contents of this collection use [`set_sub_folders`](Self::set_sub_folders).
        ///
        /// <p>The list of folders that exist under the specified folder, if any.</p>
        pub fn sub_folders(mut self, input: impl Into<crate::model::Folder>) -> Self {
            let mut v = self.sub_folders.unwrap_or_default();
            v.push(input.into());
            self.sub_folders = Some(v);
            self
        }
        /// <p>The list of folders that exist under the specified folder, if any.</p>
        pub fn set_sub_folders(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Folder>>,
        ) -> Self {
            self.sub_folders = input;
            self
        }
        /// Appends an item to `files`.
        ///
        /// To override the contents of this collection use [`set_files`](Self::set_files).
        ///
        /// <p>The list of files in the specified folder, if any.</p>
        pub fn files(mut self, input: impl Into<crate::model::File>) -> Self {
            let mut v = self.files.unwrap_or_default();
            v.push(input.into());
            self.files = Some(v);
            self
        }
        /// <p>The list of files in the specified folder, if any.</p>
        pub fn set_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::File>>,
        ) -> Self {
            self.files = input;
            self
        }
        /// Appends an item to `symbolic_links`.
        ///
        /// To override the contents of this collection use [`set_symbolic_links`](Self::set_symbolic_links).
        ///
        /// <p>The list of symbolic links to other files and folders in the specified folder, if
        /// any.</p>
        pub fn symbolic_links(mut self, input: impl Into<crate::model::SymbolicLink>) -> Self {
            let mut v = self.symbolic_links.unwrap_or_default();
            v.push(input.into());
            self.symbolic_links = Some(v);
            self
        }
        /// <p>The list of symbolic links to other files and folders in the specified folder, if
        /// any.</p>
        pub fn set_symbolic_links(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SymbolicLink>>,
        ) -> Self {
            self.symbolic_links = input;
            self
        }
        /// Appends an item to `sub_modules`.
        ///
        /// To override the contents of this collection use [`set_sub_modules`](Self::set_sub_modules).
        ///
        /// <p>The list of submodules in the specified folder, if any.</p>
        pub fn sub_modules(mut self, input: impl Into<crate::model::SubModule>) -> Self {
            let mut v = self.sub_modules.unwrap_or_default();
            v.push(input.into());
            self.sub_modules = Some(v);
            self
        }
        /// <p>The list of submodules in the specified folder, if any.</p>
        pub fn set_sub_modules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SubModule>>,
        ) -> Self {
            self.sub_modules = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFolderOutput`](crate::output::GetFolderOutput)
        pub fn build(self) -> crate::output::GetFolderOutput {
            crate::output::GetFolderOutput {
                commit_id: self.commit_id,
                folder_path: self.folder_path,
                tree_id: self.tree_id,
                sub_folders: self.sub_folders,
                files: self.files,
                symbolic_links: self.symbolic_links,
                sub_modules: self.sub_modules,
            }
        }
    }
}
impl GetFolderOutput {
    /// Creates a new builder-style object to manufacture [`GetFolderOutput`](crate::output::GetFolderOutput)
    pub fn builder() -> crate::output::get_folder_output::Builder {
        crate::output::get_folder_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFileOutput {
    /// <p>The full commit ID of the commit that contains the content returned by GetFile.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The blob ID of the object that represents the file content.</p>
    pub blob_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the specified file. Returns the name and extension of the
    /// file.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.</p>
    /// <note>
    /// <p>The file mode permissions returned by this API are not the standard file mode
    /// permission values, such as 100644, but rather extrapolated values. See the supported
    /// return values.</p>
    /// </note>
    pub file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
    /// <p>The size of the contents of the file, in bytes.</p>
    pub file_size: i64,
    /// <p>The base-64 encoded binary data object that represents the content of the file.</p>
    pub file_content: std::option::Option<aws_smithy_types::Blob>,
}
impl GetFileOutput {
    /// <p>The full commit ID of the commit that contains the content returned by GetFile.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The blob ID of the object that represents the file content.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
    /// <p>The fully qualified path to the specified file. Returns the name and extension of the
    /// file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.</p>
    /// <note>
    /// <p>The file mode permissions returned by this API are not the standard file mode
    /// permission values, such as 100644, but rather extrapolated values. See the supported
    /// return values.</p>
    /// </note>
    pub fn file_mode(&self) -> std::option::Option<&crate::model::FileModeTypeEnum> {
        self.file_mode.as_ref()
    }
    /// <p>The size of the contents of the file, in bytes.</p>
    pub fn file_size(&self) -> i64 {
        self.file_size
    }
    /// <p>The base-64 encoded binary data object that represents the content of the file.</p>
    pub fn file_content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.file_content.as_ref()
    }
}
impl std::fmt::Debug for GetFileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFileOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("blob_id", &self.blob_id);
        formatter.field("file_path", &self.file_path);
        formatter.field("file_mode", &self.file_mode);
        formatter.field("file_size", &self.file_size);
        formatter.field("file_content", &self.file_content);
        formatter.finish()
    }
}
/// See [`GetFileOutput`](crate::output::GetFileOutput)
pub mod get_file_output {
    /// A builder for [`GetFileOutput`](crate::output::GetFileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) blob_id: std::option::Option<std::string::String>,
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) file_mode: std::option::Option<crate::model::FileModeTypeEnum>,
        pub(crate) file_size: std::option::Option<i64>,
        pub(crate) file_content: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The full commit ID of the commit that contains the content returned by GetFile.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit that contains the content returned by GetFile.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The blob ID of the object that represents the file content.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The blob ID of the object that represents the file content.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// <p>The fully qualified path to the specified file. Returns the name and extension of the
        /// file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the specified file. Returns the name and extension of the
        /// file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.</p>
        /// <note>
        /// <p>The file mode permissions returned by this API are not the standard file mode
        /// permission values, such as 100644, but rather extrapolated values. See the supported
        /// return values.</p>
        /// </note>
        pub fn file_mode(mut self, input: crate::model::FileModeTypeEnum) -> Self {
            self.file_mode = Some(input);
            self
        }
        /// <p>The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.</p>
        /// <note>
        /// <p>The file mode permissions returned by this API are not the standard file mode
        /// permission values, such as 100644, but rather extrapolated values. See the supported
        /// return values.</p>
        /// </note>
        pub fn set_file_mode(
            mut self,
            input: std::option::Option<crate::model::FileModeTypeEnum>,
        ) -> Self {
            self.file_mode = input;
            self
        }
        /// <p>The size of the contents of the file, in bytes.</p>
        pub fn file_size(mut self, input: i64) -> Self {
            self.file_size = Some(input);
            self
        }
        /// <p>The size of the contents of the file, in bytes.</p>
        pub fn set_file_size(mut self, input: std::option::Option<i64>) -> Self {
            self.file_size = input;
            self
        }
        /// <p>The base-64 encoded binary data object that represents the content of the file.</p>
        pub fn file_content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.file_content = Some(input);
            self
        }
        /// <p>The base-64 encoded binary data object that represents the content of the file.</p>
        pub fn set_file_content(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.file_content = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFileOutput`](crate::output::GetFileOutput)
        pub fn build(self) -> crate::output::GetFileOutput {
            crate::output::GetFileOutput {
                commit_id: self.commit_id,
                blob_id: self.blob_id,
                file_path: self.file_path,
                file_mode: self.file_mode,
                file_size: self.file_size.unwrap_or_default(),
                file_content: self.file_content,
            }
        }
    }
}
impl GetFileOutput {
    /// Creates a new builder-style object to manufacture [`GetFileOutput`](crate::output::GetFileOutput)
    pub fn builder() -> crate::output::get_file_output::Builder {
        crate::output::get_file_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDifferencesOutput {
    /// <p>A data type object that contains information about the differences, including whether
    /// the difference is added, modified, or deleted (A, D, M).</p>
    pub differences: std::option::Option<std::vec::Vec<crate::model::Difference>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDifferencesOutput {
    /// <p>A data type object that contains information about the differences, including whether
    /// the difference is added, modified, or deleted (A, D, M).</p>
    pub fn differences(&self) -> std::option::Option<&[crate::model::Difference]> {
        self.differences.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDifferencesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDifferencesOutput");
        formatter.field("differences", &self.differences);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDifferencesOutput`](crate::output::GetDifferencesOutput)
pub mod get_differences_output {
    /// A builder for [`GetDifferencesOutput`](crate::output::GetDifferencesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) differences: std::option::Option<std::vec::Vec<crate::model::Difference>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `differences`.
        ///
        /// To override the contents of this collection use [`set_differences`](Self::set_differences).
        ///
        /// <p>A data type object that contains information about the differences, including whether
        /// the difference is added, modified, or deleted (A, D, M).</p>
        pub fn differences(mut self, input: impl Into<crate::model::Difference>) -> Self {
            let mut v = self.differences.unwrap_or_default();
            v.push(input.into());
            self.differences = Some(v);
            self
        }
        /// <p>A data type object that contains information about the differences, including whether
        /// the difference is added, modified, or deleted (A, D, M).</p>
        pub fn set_differences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Difference>>,
        ) -> Self {
            self.differences = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDifferencesOutput`](crate::output::GetDifferencesOutput)
        pub fn build(self) -> crate::output::GetDifferencesOutput {
            crate::output::GetDifferencesOutput {
                differences: self.differences,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDifferencesOutput {
    /// Creates a new builder-style object to manufacture [`GetDifferencesOutput`](crate::output::GetDifferencesOutput)
    pub fn builder() -> crate::output::get_differences_output::Builder {
        crate::output::get_differences_output::Builder::default()
    }
}

/// <p>Represents the output of a get commit operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommitOutput {
    /// <p>A commit data type object that contains information about the specified commit.</p>
    pub commit: std::option::Option<crate::model::Commit>,
}
impl GetCommitOutput {
    /// <p>A commit data type object that contains information about the specified commit.</p>
    pub fn commit(&self) -> std::option::Option<&crate::model::Commit> {
        self.commit.as_ref()
    }
}
impl std::fmt::Debug for GetCommitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommitOutput");
        formatter.field("commit", &self.commit);
        formatter.finish()
    }
}
/// See [`GetCommitOutput`](crate::output::GetCommitOutput)
pub mod get_commit_output {
    /// A builder for [`GetCommitOutput`](crate::output::GetCommitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit: std::option::Option<crate::model::Commit>,
    }
    impl Builder {
        /// <p>A commit data type object that contains information about the specified commit.</p>
        pub fn commit(mut self, input: crate::model::Commit) -> Self {
            self.commit = Some(input);
            self
        }
        /// <p>A commit data type object that contains information about the specified commit.</p>
        pub fn set_commit(mut self, input: std::option::Option<crate::model::Commit>) -> Self {
            self.commit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommitOutput`](crate::output::GetCommitOutput)
        pub fn build(self) -> crate::output::GetCommitOutput {
            crate::output::GetCommitOutput {
                commit: self.commit,
            }
        }
    }
}
impl GetCommitOutput {
    /// Creates a new builder-style object to manufacture [`GetCommitOutput`](crate::output::GetCommitOutput)
    pub fn builder() -> crate::output::get_commit_output::Builder {
        crate::output::get_commit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentsForPullRequestOutput {
    /// <p>An array of comment objects on the pull request.</p>
    pub comments_for_pull_request_data:
        std::option::Option<std::vec::Vec<crate::model::CommentsForPullRequest>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetCommentsForPullRequestOutput {
    /// <p>An array of comment objects on the pull request.</p>
    pub fn comments_for_pull_request_data(
        &self,
    ) -> std::option::Option<&[crate::model::CommentsForPullRequest]> {
        self.comments_for_pull_request_data.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetCommentsForPullRequestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentsForPullRequestOutput");
        formatter.field(
            "comments_for_pull_request_data",
            &self.comments_for_pull_request_data,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCommentsForPullRequestOutput`](crate::output::GetCommentsForPullRequestOutput)
pub mod get_comments_for_pull_request_output {
    /// A builder for [`GetCommentsForPullRequestOutput`](crate::output::GetCommentsForPullRequestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comments_for_pull_request_data:
            std::option::Option<std::vec::Vec<crate::model::CommentsForPullRequest>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `comments_for_pull_request_data`.
        ///
        /// To override the contents of this collection use [`set_comments_for_pull_request_data`](Self::set_comments_for_pull_request_data).
        ///
        /// <p>An array of comment objects on the pull request.</p>
        pub fn comments_for_pull_request_data(
            mut self,
            input: impl Into<crate::model::CommentsForPullRequest>,
        ) -> Self {
            let mut v = self.comments_for_pull_request_data.unwrap_or_default();
            v.push(input.into());
            self.comments_for_pull_request_data = Some(v);
            self
        }
        /// <p>An array of comment objects on the pull request.</p>
        pub fn set_comments_for_pull_request_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommentsForPullRequest>>,
        ) -> Self {
            self.comments_for_pull_request_data = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentsForPullRequestOutput`](crate::output::GetCommentsForPullRequestOutput)
        pub fn build(self) -> crate::output::GetCommentsForPullRequestOutput {
            crate::output::GetCommentsForPullRequestOutput {
                comments_for_pull_request_data: self.comments_for_pull_request_data,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCommentsForPullRequestOutput {
    /// Creates a new builder-style object to manufacture [`GetCommentsForPullRequestOutput`](crate::output::GetCommentsForPullRequestOutput)
    pub fn builder() -> crate::output::get_comments_for_pull_request_output::Builder {
        crate::output::get_comments_for_pull_request_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentsForComparedCommitOutput {
    /// <p>A list of comment objects on the compared commit.</p>
    pub comments_for_compared_commit_data:
        std::option::Option<std::vec::Vec<crate::model::CommentsForComparedCommit>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetCommentsForComparedCommitOutput {
    /// <p>A list of comment objects on the compared commit.</p>
    pub fn comments_for_compared_commit_data(
        &self,
    ) -> std::option::Option<&[crate::model::CommentsForComparedCommit]> {
        self.comments_for_compared_commit_data.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetCommentsForComparedCommitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentsForComparedCommitOutput");
        formatter.field(
            "comments_for_compared_commit_data",
            &self.comments_for_compared_commit_data,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCommentsForComparedCommitOutput`](crate::output::GetCommentsForComparedCommitOutput)
pub mod get_comments_for_compared_commit_output {
    /// A builder for [`GetCommentsForComparedCommitOutput`](crate::output::GetCommentsForComparedCommitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comments_for_compared_commit_data:
            std::option::Option<std::vec::Vec<crate::model::CommentsForComparedCommit>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `comments_for_compared_commit_data`.
        ///
        /// To override the contents of this collection use [`set_comments_for_compared_commit_data`](Self::set_comments_for_compared_commit_data).
        ///
        /// <p>A list of comment objects on the compared commit.</p>
        pub fn comments_for_compared_commit_data(
            mut self,
            input: impl Into<crate::model::CommentsForComparedCommit>,
        ) -> Self {
            let mut v = self.comments_for_compared_commit_data.unwrap_or_default();
            v.push(input.into());
            self.comments_for_compared_commit_data = Some(v);
            self
        }
        /// <p>A list of comment objects on the compared commit.</p>
        pub fn set_comments_for_compared_commit_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CommentsForComparedCommit>>,
        ) -> Self {
            self.comments_for_compared_commit_data = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentsForComparedCommitOutput`](crate::output::GetCommentsForComparedCommitOutput)
        pub fn build(self) -> crate::output::GetCommentsForComparedCommitOutput {
            crate::output::GetCommentsForComparedCommitOutput {
                comments_for_compared_commit_data: self.comments_for_compared_commit_data,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCommentsForComparedCommitOutput {
    /// Creates a new builder-style object to manufacture [`GetCommentsForComparedCommitOutput`](crate::output::GetCommentsForComparedCommitOutput)
    pub fn builder() -> crate::output::get_comments_for_compared_commit_output::Builder {
        crate::output::get_comments_for_compared_commit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentReactionsOutput {
    /// <p>An array of reactions to the specified comment.</p>
    pub reactions_for_comment: std::option::Option<std::vec::Vec<crate::model::ReactionForComment>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetCommentReactionsOutput {
    /// <p>An array of reactions to the specified comment.</p>
    pub fn reactions_for_comment(
        &self,
    ) -> std::option::Option<&[crate::model::ReactionForComment]> {
        self.reactions_for_comment.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetCommentReactionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentReactionsOutput");
        formatter.field("reactions_for_comment", &self.reactions_for_comment);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetCommentReactionsOutput`](crate::output::GetCommentReactionsOutput)
pub mod get_comment_reactions_output {
    /// A builder for [`GetCommentReactionsOutput`](crate::output::GetCommentReactionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reactions_for_comment:
            std::option::Option<std::vec::Vec<crate::model::ReactionForComment>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `reactions_for_comment`.
        ///
        /// To override the contents of this collection use [`set_reactions_for_comment`](Self::set_reactions_for_comment).
        ///
        /// <p>An array of reactions to the specified comment.</p>
        pub fn reactions_for_comment(
            mut self,
            input: impl Into<crate::model::ReactionForComment>,
        ) -> Self {
            let mut v = self.reactions_for_comment.unwrap_or_default();
            v.push(input.into());
            self.reactions_for_comment = Some(v);
            self
        }
        /// <p>An array of reactions to the specified comment.</p>
        pub fn set_reactions_for_comment(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReactionForComment>>,
        ) -> Self {
            self.reactions_for_comment = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentReactionsOutput`](crate::output::GetCommentReactionsOutput)
        pub fn build(self) -> crate::output::GetCommentReactionsOutput {
            crate::output::GetCommentReactionsOutput {
                reactions_for_comment: self.reactions_for_comment,
                next_token: self.next_token,
            }
        }
    }
}
impl GetCommentReactionsOutput {
    /// Creates a new builder-style object to manufacture [`GetCommentReactionsOutput`](crate::output::GetCommentReactionsOutput)
    pub fn builder() -> crate::output::get_comment_reactions_output::Builder {
        crate::output::get_comment_reactions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCommentOutput {
    /// <p>The contents of the comment.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl GetCommentOutput {
    /// <p>The contents of the comment.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
}
impl std::fmt::Debug for GetCommentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCommentOutput");
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`GetCommentOutput`](crate::output::GetCommentOutput)
pub mod get_comment_output {
    /// A builder for [`GetCommentOutput`](crate::output::GetCommentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>The contents of the comment.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>The contents of the comment.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCommentOutput`](crate::output::GetCommentOutput)
        pub fn build(self) -> crate::output::GetCommentOutput {
            crate::output::GetCommentOutput {
                comment: self.comment,
            }
        }
    }
}
impl GetCommentOutput {
    /// Creates a new builder-style object to manufacture [`GetCommentOutput`](crate::output::GetCommentOutput)
    pub fn builder() -> crate::output::get_comment_output::Builder {
        crate::output::get_comment_output::Builder::default()
    }
}

/// <p>Represents the output of a get branch operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBranchOutput {
    /// <p>The name of the branch.</p>
    pub branch: std::option::Option<crate::model::BranchInfo>,
}
impl GetBranchOutput {
    /// <p>The name of the branch.</p>
    pub fn branch(&self) -> std::option::Option<&crate::model::BranchInfo> {
        self.branch.as_ref()
    }
}
impl std::fmt::Debug for GetBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBranchOutput");
        formatter.field("branch", &self.branch);
        formatter.finish()
    }
}
/// See [`GetBranchOutput`](crate::output::GetBranchOutput)
pub mod get_branch_output {
    /// A builder for [`GetBranchOutput`](crate::output::GetBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) branch: std::option::Option<crate::model::BranchInfo>,
    }
    impl Builder {
        /// <p>The name of the branch.</p>
        pub fn branch(mut self, input: crate::model::BranchInfo) -> Self {
            self.branch = Some(input);
            self
        }
        /// <p>The name of the branch.</p>
        pub fn set_branch(mut self, input: std::option::Option<crate::model::BranchInfo>) -> Self {
            self.branch = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBranchOutput`](crate::output::GetBranchOutput)
        pub fn build(self) -> crate::output::GetBranchOutput {
            crate::output::GetBranchOutput {
                branch: self.branch,
            }
        }
    }
}
impl GetBranchOutput {
    /// Creates a new builder-style object to manufacture [`GetBranchOutput`](crate::output::GetBranchOutput)
    pub fn builder() -> crate::output::get_branch_output::Builder {
        crate::output::get_branch_output::Builder::default()
    }
}

/// <p>Represents the output of a get blob operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBlobOutput {
    /// <p>The content of the blob, usually a file.</p>
    pub content: std::option::Option<aws_smithy_types::Blob>,
}
impl GetBlobOutput {
    /// <p>The content of the blob, usually a file.</p>
    pub fn content(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.content.as_ref()
    }
}
impl std::fmt::Debug for GetBlobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBlobOutput");
        formatter.field("content", &self.content);
        formatter.finish()
    }
}
/// See [`GetBlobOutput`](crate::output::GetBlobOutput)
pub mod get_blob_output {
    /// A builder for [`GetBlobOutput`](crate::output::GetBlobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) content: std::option::Option<aws_smithy_types::Blob>,
    }
    impl Builder {
        /// <p>The content of the blob, usually a file.</p>
        pub fn content(mut self, input: aws_smithy_types::Blob) -> Self {
            self.content = Some(input);
            self
        }
        /// <p>The content of the blob, usually a file.</p>
        pub fn set_content(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.content = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlobOutput`](crate::output::GetBlobOutput)
        pub fn build(self) -> crate::output::GetBlobOutput {
            crate::output::GetBlobOutput {
                content: self.content,
            }
        }
    }
}
impl GetBlobOutput {
    /// Creates a new builder-style object to manufacture [`GetBlobOutput`](crate::output::GetBlobOutput)
    pub fn builder() -> crate::output::get_blob_output::Builder {
        crate::output::get_blob_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetApprovalRuleTemplateOutput {
    /// <p>The content and structure of the approval rule template.</p>
    pub approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
}
impl GetApprovalRuleTemplateOutput {
    /// <p>The content and structure of the approval rule template.</p>
    pub fn approval_rule_template(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalRuleTemplate> {
        self.approval_rule_template.as_ref()
    }
}
impl std::fmt::Debug for GetApprovalRuleTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetApprovalRuleTemplateOutput");
        formatter.field("approval_rule_template", &self.approval_rule_template);
        formatter.finish()
    }
}
/// See [`GetApprovalRuleTemplateOutput`](crate::output::GetApprovalRuleTemplateOutput)
pub mod get_approval_rule_template_output {
    /// A builder for [`GetApprovalRuleTemplateOutput`](crate::output::GetApprovalRuleTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
    }
    impl Builder {
        /// <p>The content and structure of the approval rule template.</p>
        pub fn approval_rule_template(mut self, input: crate::model::ApprovalRuleTemplate) -> Self {
            self.approval_rule_template = Some(input);
            self
        }
        /// <p>The content and structure of the approval rule template.</p>
        pub fn set_approval_rule_template(
            mut self,
            input: std::option::Option<crate::model::ApprovalRuleTemplate>,
        ) -> Self {
            self.approval_rule_template = input;
            self
        }
        /// Consumes the builder and constructs a [`GetApprovalRuleTemplateOutput`](crate::output::GetApprovalRuleTemplateOutput)
        pub fn build(self) -> crate::output::GetApprovalRuleTemplateOutput {
            crate::output::GetApprovalRuleTemplateOutput {
                approval_rule_template: self.approval_rule_template,
            }
        }
    }
}
impl GetApprovalRuleTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetApprovalRuleTemplateOutput`](crate::output::GetApprovalRuleTemplateOutput)
    pub fn builder() -> crate::output::get_approval_rule_template_output::Builder {
        crate::output::get_approval_rule_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EvaluatePullRequestApprovalRulesOutput {
    /// <p>The result of the evaluation, including the names of the rules whose conditions have been met (if any), the names of the rules whose conditions have
    /// not been met (if any), whether the pull request is in the approved state, and whether the pull request approval rule has been set aside by an override. </p>
    pub evaluation: std::option::Option<crate::model::Evaluation>,
}
impl EvaluatePullRequestApprovalRulesOutput {
    /// <p>The result of the evaluation, including the names of the rules whose conditions have been met (if any), the names of the rules whose conditions have
    /// not been met (if any), whether the pull request is in the approved state, and whether the pull request approval rule has been set aside by an override. </p>
    pub fn evaluation(&self) -> std::option::Option<&crate::model::Evaluation> {
        self.evaluation.as_ref()
    }
}
impl std::fmt::Debug for EvaluatePullRequestApprovalRulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EvaluatePullRequestApprovalRulesOutput");
        formatter.field("evaluation", &self.evaluation);
        formatter.finish()
    }
}
/// See [`EvaluatePullRequestApprovalRulesOutput`](crate::output::EvaluatePullRequestApprovalRulesOutput)
pub mod evaluate_pull_request_approval_rules_output {
    /// A builder for [`EvaluatePullRequestApprovalRulesOutput`](crate::output::EvaluatePullRequestApprovalRulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation: std::option::Option<crate::model::Evaluation>,
    }
    impl Builder {
        /// <p>The result of the evaluation, including the names of the rules whose conditions have been met (if any), the names of the rules whose conditions have
        /// not been met (if any), whether the pull request is in the approved state, and whether the pull request approval rule has been set aside by an override. </p>
        pub fn evaluation(mut self, input: crate::model::Evaluation) -> Self {
            self.evaluation = Some(input);
            self
        }
        /// <p>The result of the evaluation, including the names of the rules whose conditions have been met (if any), the names of the rules whose conditions have
        /// not been met (if any), whether the pull request is in the approved state, and whether the pull request approval rule has been set aside by an override. </p>
        pub fn set_evaluation(
            mut self,
            input: std::option::Option<crate::model::Evaluation>,
        ) -> Self {
            self.evaluation = input;
            self
        }
        /// Consumes the builder and constructs a [`EvaluatePullRequestApprovalRulesOutput`](crate::output::EvaluatePullRequestApprovalRulesOutput)
        pub fn build(self) -> crate::output::EvaluatePullRequestApprovalRulesOutput {
            crate::output::EvaluatePullRequestApprovalRulesOutput {
                evaluation: self.evaluation,
            }
        }
    }
}
impl EvaluatePullRequestApprovalRulesOutput {
    /// Creates a new builder-style object to manufacture [`EvaluatePullRequestApprovalRulesOutput`](crate::output::EvaluatePullRequestApprovalRulesOutput)
    pub fn builder() -> crate::output::evaluate_pull_request_approval_rules_output::Builder {
        crate::output::evaluate_pull_request_approval_rules_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateApprovalRuleTemplateFromRepositoryOutput {}
impl std::fmt::Debug for DisassociateApprovalRuleTemplateFromRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateApprovalRuleTemplateFromRepositoryOutput");
        formatter.finish()
    }
}
/// See [`DisassociateApprovalRuleTemplateFromRepositoryOutput`](crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput)
pub mod disassociate_approval_rule_template_from_repository_output {
    /// A builder for [`DisassociateApprovalRuleTemplateFromRepositoryOutput`](crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateApprovalRuleTemplateFromRepositoryOutput`](crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput)
        pub fn build(self) -> crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput {
            crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput {}
        }
    }
}
impl DisassociateApprovalRuleTemplateFromRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateApprovalRuleTemplateFromRepositoryOutput`](crate::output::DisassociateApprovalRuleTemplateFromRepositoryOutput)
    pub fn builder(
    ) -> crate::output::disassociate_approval_rule_template_from_repository_output::Builder {
        crate::output::disassociate_approval_rule_template_from_repository_output::Builder::default(
        )
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePullRequestEventsOutput {
    /// <p>Information about the pull request events.</p>
    pub pull_request_events: std::option::Option<std::vec::Vec<crate::model::PullRequestEvent>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribePullRequestEventsOutput {
    /// <p>Information about the pull request events.</p>
    pub fn pull_request_events(&self) -> std::option::Option<&[crate::model::PullRequestEvent]> {
        self.pull_request_events.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribePullRequestEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePullRequestEventsOutput");
        formatter.field("pull_request_events", &self.pull_request_events);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribePullRequestEventsOutput`](crate::output::DescribePullRequestEventsOutput)
pub mod describe_pull_request_events_output {
    /// A builder for [`DescribePullRequestEventsOutput`](crate::output::DescribePullRequestEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request_events:
            std::option::Option<std::vec::Vec<crate::model::PullRequestEvent>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pull_request_events`.
        ///
        /// To override the contents of this collection use [`set_pull_request_events`](Self::set_pull_request_events).
        ///
        /// <p>Information about the pull request events.</p>
        pub fn pull_request_events(
            mut self,
            input: impl Into<crate::model::PullRequestEvent>,
        ) -> Self {
            let mut v = self.pull_request_events.unwrap_or_default();
            v.push(input.into());
            self.pull_request_events = Some(v);
            self
        }
        /// <p>Information about the pull request events.</p>
        pub fn set_pull_request_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PullRequestEvent>>,
        ) -> Self {
            self.pull_request_events = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePullRequestEventsOutput`](crate::output::DescribePullRequestEventsOutput)
        pub fn build(self) -> crate::output::DescribePullRequestEventsOutput {
            crate::output::DescribePullRequestEventsOutput {
                pull_request_events: self.pull_request_events,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribePullRequestEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribePullRequestEventsOutput`](crate::output::DescribePullRequestEventsOutput)
    pub fn builder() -> crate::output::describe_pull_request_events_output::Builder {
        crate::output::describe_pull_request_events_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMergeConflictsOutput {
    /// <p>Contains metadata about the conflicts found in the merge.</p>
    pub conflict_metadata: std::option::Option<crate::model::ConflictMetadata>,
    /// <p>A list of merge hunks of the differences between the files or lines.</p>
    pub merge_hunks: std::option::Option<std::vec::Vec<crate::model::MergeHunk>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub destination_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the merge base.</p>
    pub base_commit_id: std::option::Option<std::string::String>,
}
impl DescribeMergeConflictsOutput {
    /// <p>Contains metadata about the conflicts found in the merge.</p>
    pub fn conflict_metadata(&self) -> std::option::Option<&crate::model::ConflictMetadata> {
        self.conflict_metadata.as_ref()
    }
    /// <p>A list of merge hunks of the differences between the files or lines.</p>
    pub fn merge_hunks(&self) -> std::option::Option<&[crate::model::MergeHunk]> {
        self.merge_hunks.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub fn destination_commit_id(&self) -> std::option::Option<&str> {
        self.destination_commit_id.as_deref()
    }
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The commit ID of the merge base.</p>
    pub fn base_commit_id(&self) -> std::option::Option<&str> {
        self.base_commit_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeMergeConflictsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMergeConflictsOutput");
        formatter.field("conflict_metadata", &self.conflict_metadata);
        formatter.field("merge_hunks", &self.merge_hunks);
        formatter.field("next_token", &self.next_token);
        formatter.field("destination_commit_id", &self.destination_commit_id);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("base_commit_id", &self.base_commit_id);
        formatter.finish()
    }
}
/// See [`DescribeMergeConflictsOutput`](crate::output::DescribeMergeConflictsOutput)
pub mod describe_merge_conflicts_output {
    /// A builder for [`DescribeMergeConflictsOutput`](crate::output::DescribeMergeConflictsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conflict_metadata: std::option::Option<crate::model::ConflictMetadata>,
        pub(crate) merge_hunks: std::option::Option<std::vec::Vec<crate::model::MergeHunk>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) destination_commit_id: std::option::Option<std::string::String>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) base_commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains metadata about the conflicts found in the merge.</p>
        pub fn conflict_metadata(mut self, input: crate::model::ConflictMetadata) -> Self {
            self.conflict_metadata = Some(input);
            self
        }
        /// <p>Contains metadata about the conflicts found in the merge.</p>
        pub fn set_conflict_metadata(
            mut self,
            input: std::option::Option<crate::model::ConflictMetadata>,
        ) -> Self {
            self.conflict_metadata = input;
            self
        }
        /// Appends an item to `merge_hunks`.
        ///
        /// To override the contents of this collection use [`set_merge_hunks`](Self::set_merge_hunks).
        ///
        /// <p>A list of merge hunks of the differences between the files or lines.</p>
        pub fn merge_hunks(mut self, input: impl Into<crate::model::MergeHunk>) -> Self {
            let mut v = self.merge_hunks.unwrap_or_default();
            v.push(input.into());
            self.merge_hunks = Some(v);
            self
        }
        /// <p>A list of merge hunks of the differences between the files or lines.</p>
        pub fn set_merge_hunks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MergeHunk>>,
        ) -> Self {
            self.merge_hunks = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn destination_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn set_destination_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_id = input;
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn base_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn set_base_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMergeConflictsOutput`](crate::output::DescribeMergeConflictsOutput)
        pub fn build(self) -> crate::output::DescribeMergeConflictsOutput {
            crate::output::DescribeMergeConflictsOutput {
                conflict_metadata: self.conflict_metadata,
                merge_hunks: self.merge_hunks,
                next_token: self.next_token,
                destination_commit_id: self.destination_commit_id,
                source_commit_id: self.source_commit_id,
                base_commit_id: self.base_commit_id,
            }
        }
    }
}
impl DescribeMergeConflictsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMergeConflictsOutput`](crate::output::DescribeMergeConflictsOutput)
    pub fn builder() -> crate::output::describe_merge_conflicts_output::Builder {
        crate::output::describe_merge_conflicts_output::Builder::default()
    }
}

/// <p>Represents the output of a delete repository operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryOutput {
    /// <p>The ID of the repository that was deleted.</p>
    pub repository_id: std::option::Option<std::string::String>,
}
impl DeleteRepositoryOutput {
    /// <p>The ID of the repository that was deleted.</p>
    pub fn repository_id(&self) -> std::option::Option<&str> {
        self.repository_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryOutput");
        formatter.field("repository_id", &self.repository_id);
        formatter.finish()
    }
}
/// See [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
pub mod delete_repository_output {
    /// A builder for [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the repository that was deleted.</p>
        pub fn repository_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_id = Some(input.into());
            self
        }
        /// <p>The ID of the repository that was deleted.</p>
        pub fn set_repository_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
        pub fn build(self) -> crate::output::DeleteRepositoryOutput {
            crate::output::DeleteRepositoryOutput {
                repository_id: self.repository_id,
            }
        }
    }
}
impl DeleteRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    pub fn builder() -> crate::output::delete_repository_output::Builder {
        crate::output::delete_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePullRequestApprovalRuleOutput {
    /// <p>The ID of the deleted approval rule. </p>
    /// <note>
    /// <p>If the approval rule was deleted in an earlier API call, the response is 200 OK without
    /// content.</p>
    /// </note>
    pub approval_rule_id: std::option::Option<std::string::String>,
}
impl DeletePullRequestApprovalRuleOutput {
    /// <p>The ID of the deleted approval rule. </p>
    /// <note>
    /// <p>If the approval rule was deleted in an earlier API call, the response is 200 OK without
    /// content.</p>
    /// </note>
    pub fn approval_rule_id(&self) -> std::option::Option<&str> {
        self.approval_rule_id.as_deref()
    }
}
impl std::fmt::Debug for DeletePullRequestApprovalRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePullRequestApprovalRuleOutput");
        formatter.field("approval_rule_id", &self.approval_rule_id);
        formatter.finish()
    }
}
/// See [`DeletePullRequestApprovalRuleOutput`](crate::output::DeletePullRequestApprovalRuleOutput)
pub mod delete_pull_request_approval_rule_output {
    /// A builder for [`DeletePullRequestApprovalRuleOutput`](crate::output::DeletePullRequestApprovalRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the deleted approval rule. </p>
        /// <note>
        /// <p>If the approval rule was deleted in an earlier API call, the response is 200 OK without
        /// content.</p>
        /// </note>
        pub fn approval_rule_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_id = Some(input.into());
            self
        }
        /// <p>The ID of the deleted approval rule. </p>
        /// <note>
        /// <p>If the approval rule was deleted in an earlier API call, the response is 200 OK without
        /// content.</p>
        /// </note>
        pub fn set_approval_rule_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePullRequestApprovalRuleOutput`](crate::output::DeletePullRequestApprovalRuleOutput)
        pub fn build(self) -> crate::output::DeletePullRequestApprovalRuleOutput {
            crate::output::DeletePullRequestApprovalRuleOutput {
                approval_rule_id: self.approval_rule_id,
            }
        }
    }
}
impl DeletePullRequestApprovalRuleOutput {
    /// Creates a new builder-style object to manufacture [`DeletePullRequestApprovalRuleOutput`](crate::output::DeletePullRequestApprovalRuleOutput)
    pub fn builder() -> crate::output::delete_pull_request_approval_rule_output::Builder {
        crate::output::delete_pull_request_approval_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFileOutput {
    /// <p>The full commit ID of the commit that contains the change that deletes the file.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The blob ID removed from the tree as part of deleting the file.</p>
    pub blob_id: std::option::Option<std::string::String>,
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the delete file change.</p>
    pub tree_id: std::option::Option<std::string::String>,
    /// <p>The fully qualified path to the file to be deleted, including the full name and
    /// extension of that file.</p>
    pub file_path: std::option::Option<std::string::String>,
}
impl DeleteFileOutput {
    /// <p>The full commit ID of the commit that contains the change that deletes the file.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The blob ID removed from the tree as part of deleting the file.</p>
    pub fn blob_id(&self) -> std::option::Option<&str> {
        self.blob_id.as_deref()
    }
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the delete file change.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
    /// <p>The fully qualified path to the file to be deleted, including the full name and
    /// extension of that file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
}
impl std::fmt::Debug for DeleteFileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFileOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("blob_id", &self.blob_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.field("file_path", &self.file_path);
        formatter.finish()
    }
}
/// See [`DeleteFileOutput`](crate::output::DeleteFileOutput)
pub mod delete_file_output {
    /// A builder for [`DeleteFileOutput`](crate::output::DeleteFileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) blob_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
        pub(crate) file_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full commit ID of the commit that contains the change that deletes the file.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit that contains the change that deletes the file.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The blob ID removed from the tree as part of deleting the file.</p>
        pub fn blob_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blob_id = Some(input.into());
            self
        }
        /// <p>The blob ID removed from the tree as part of deleting the file.</p>
        pub fn set_blob_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blob_id = input;
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the delete file change.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the delete file change.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// <p>The fully qualified path to the file to be deleted, including the full name and
        /// extension of that file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The fully qualified path to the file to be deleted, including the full name and
        /// extension of that file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFileOutput`](crate::output::DeleteFileOutput)
        pub fn build(self) -> crate::output::DeleteFileOutput {
            crate::output::DeleteFileOutput {
                commit_id: self.commit_id,
                blob_id: self.blob_id,
                tree_id: self.tree_id,
                file_path: self.file_path,
            }
        }
    }
}
impl DeleteFileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFileOutput`](crate::output::DeleteFileOutput)
    pub fn builder() -> crate::output::delete_file_output::Builder {
        crate::output::delete_file_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCommentContentOutput {
    /// <p>Information about the comment you just deleted.</p>
    pub comment: std::option::Option<crate::model::Comment>,
}
impl DeleteCommentContentOutput {
    /// <p>Information about the comment you just deleted.</p>
    pub fn comment(&self) -> std::option::Option<&crate::model::Comment> {
        self.comment.as_ref()
    }
}
impl std::fmt::Debug for DeleteCommentContentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCommentContentOutput");
        formatter.field("comment", &self.comment);
        formatter.finish()
    }
}
/// See [`DeleteCommentContentOutput`](crate::output::DeleteCommentContentOutput)
pub mod delete_comment_content_output {
    /// A builder for [`DeleteCommentContentOutput`](crate::output::DeleteCommentContentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comment: std::option::Option<crate::model::Comment>,
    }
    impl Builder {
        /// <p>Information about the comment you just deleted.</p>
        pub fn comment(mut self, input: crate::model::Comment) -> Self {
            self.comment = Some(input);
            self
        }
        /// <p>Information about the comment you just deleted.</p>
        pub fn set_comment(mut self, input: std::option::Option<crate::model::Comment>) -> Self {
            self.comment = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCommentContentOutput`](crate::output::DeleteCommentContentOutput)
        pub fn build(self) -> crate::output::DeleteCommentContentOutput {
            crate::output::DeleteCommentContentOutput {
                comment: self.comment,
            }
        }
    }
}
impl DeleteCommentContentOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCommentContentOutput`](crate::output::DeleteCommentContentOutput)
    pub fn builder() -> crate::output::delete_comment_content_output::Builder {
        crate::output::delete_comment_content_output::Builder::default()
    }
}

/// <p>Represents the output of a delete branch operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBranchOutput {
    /// <p>Information about the branch deleted by the operation, including the branch name and the commit ID that was the tip of the branch.</p>
    pub deleted_branch: std::option::Option<crate::model::BranchInfo>,
}
impl DeleteBranchOutput {
    /// <p>Information about the branch deleted by the operation, including the branch name and the commit ID that was the tip of the branch.</p>
    pub fn deleted_branch(&self) -> std::option::Option<&crate::model::BranchInfo> {
        self.deleted_branch.as_ref()
    }
}
impl std::fmt::Debug for DeleteBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBranchOutput");
        formatter.field("deleted_branch", &self.deleted_branch);
        formatter.finish()
    }
}
/// See [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
pub mod delete_branch_output {
    /// A builder for [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) deleted_branch: std::option::Option<crate::model::BranchInfo>,
    }
    impl Builder {
        /// <p>Information about the branch deleted by the operation, including the branch name and the commit ID that was the tip of the branch.</p>
        pub fn deleted_branch(mut self, input: crate::model::BranchInfo) -> Self {
            self.deleted_branch = Some(input);
            self
        }
        /// <p>Information about the branch deleted by the operation, including the branch name and the commit ID that was the tip of the branch.</p>
        pub fn set_deleted_branch(
            mut self,
            input: std::option::Option<crate::model::BranchInfo>,
        ) -> Self {
            self.deleted_branch = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
        pub fn build(self) -> crate::output::DeleteBranchOutput {
            crate::output::DeleteBranchOutput {
                deleted_branch: self.deleted_branch,
            }
        }
    }
}
impl DeleteBranchOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBranchOutput`](crate::output::DeleteBranchOutput)
    pub fn builder() -> crate::output::delete_branch_output::Builder {
        crate::output::delete_branch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteApprovalRuleTemplateOutput {
    /// <p>The system-generated ID of the deleted approval rule template. If the template has
    /// been previously deleted, the only response is a 200 OK.</p>
    pub approval_rule_template_id: std::option::Option<std::string::String>,
}
impl DeleteApprovalRuleTemplateOutput {
    /// <p>The system-generated ID of the deleted approval rule template. If the template has
    /// been previously deleted, the only response is a 200 OK.</p>
    pub fn approval_rule_template_id(&self) -> std::option::Option<&str> {
        self.approval_rule_template_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteApprovalRuleTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteApprovalRuleTemplateOutput");
        formatter.field("approval_rule_template_id", &self.approval_rule_template_id);
        formatter.finish()
    }
}
/// See [`DeleteApprovalRuleTemplateOutput`](crate::output::DeleteApprovalRuleTemplateOutput)
pub mod delete_approval_rule_template_output {
    /// A builder for [`DeleteApprovalRuleTemplateOutput`](crate::output::DeleteApprovalRuleTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The system-generated ID of the deleted approval rule template. If the template has
        /// been previously deleted, the only response is a 200 OK.</p>
        pub fn approval_rule_template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.approval_rule_template_id = Some(input.into());
            self
        }
        /// <p>The system-generated ID of the deleted approval rule template. If the template has
        /// been previously deleted, the only response is a 200 OK.</p>
        pub fn set_approval_rule_template_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.approval_rule_template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteApprovalRuleTemplateOutput`](crate::output::DeleteApprovalRuleTemplateOutput)
        pub fn build(self) -> crate::output::DeleteApprovalRuleTemplateOutput {
            crate::output::DeleteApprovalRuleTemplateOutput {
                approval_rule_template_id: self.approval_rule_template_id,
            }
        }
    }
}
impl DeleteApprovalRuleTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteApprovalRuleTemplateOutput`](crate::output::DeleteApprovalRuleTemplateOutput)
    pub fn builder() -> crate::output::delete_approval_rule_template_output::Builder {
        crate::output::delete_approval_rule_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUnreferencedMergeCommitOutput {
    /// <p>The full commit ID of the commit that contains your merge results.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the merge results.</p>
    pub tree_id: std::option::Option<std::string::String>,
}
impl CreateUnreferencedMergeCommitOutput {
    /// <p>The full commit ID of the commit that contains your merge results.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the merge results.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
}
impl std::fmt::Debug for CreateUnreferencedMergeCommitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUnreferencedMergeCommitOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.finish()
    }
}
/// See [`CreateUnreferencedMergeCommitOutput`](crate::output::CreateUnreferencedMergeCommitOutput)
pub mod create_unreferenced_merge_commit_output {
    /// A builder for [`CreateUnreferencedMergeCommitOutput`](crate::output::CreateUnreferencedMergeCommitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The full commit ID of the commit that contains your merge results.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit that contains your merge results.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the merge results.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the merge results.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUnreferencedMergeCommitOutput`](crate::output::CreateUnreferencedMergeCommitOutput)
        pub fn build(self) -> crate::output::CreateUnreferencedMergeCommitOutput {
            crate::output::CreateUnreferencedMergeCommitOutput {
                commit_id: self.commit_id,
                tree_id: self.tree_id,
            }
        }
    }
}
impl CreateUnreferencedMergeCommitOutput {
    /// Creates a new builder-style object to manufacture [`CreateUnreferencedMergeCommitOutput`](crate::output::CreateUnreferencedMergeCommitOutput)
    pub fn builder() -> crate::output::create_unreferenced_merge_commit_output::Builder {
        crate::output::create_unreferenced_merge_commit_output::Builder::default()
    }
}

/// <p>Represents the output of a create repository operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryOutput {
    /// <p>Information about the newly created repository.</p>
    pub repository_metadata: std::option::Option<crate::model::RepositoryMetadata>,
}
impl CreateRepositoryOutput {
    /// <p>Information about the newly created repository.</p>
    pub fn repository_metadata(&self) -> std::option::Option<&crate::model::RepositoryMetadata> {
        self.repository_metadata.as_ref()
    }
}
impl std::fmt::Debug for CreateRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryOutput");
        formatter.field("repository_metadata", &self.repository_metadata);
        formatter.finish()
    }
}
/// See [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
pub mod create_repository_output {
    /// A builder for [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_metadata: std::option::Option<crate::model::RepositoryMetadata>,
    }
    impl Builder {
        /// <p>Information about the newly created repository.</p>
        pub fn repository_metadata(mut self, input: crate::model::RepositoryMetadata) -> Self {
            self.repository_metadata = Some(input);
            self
        }
        /// <p>Information about the newly created repository.</p>
        pub fn set_repository_metadata(
            mut self,
            input: std::option::Option<crate::model::RepositoryMetadata>,
        ) -> Self {
            self.repository_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
        pub fn build(self) -> crate::output::CreateRepositoryOutput {
            crate::output::CreateRepositoryOutput {
                repository_metadata: self.repository_metadata,
            }
        }
    }
}
impl CreateRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    pub fn builder() -> crate::output::create_repository_output::Builder {
        crate::output::create_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePullRequestApprovalRuleOutput {
    /// <p>Information about the created approval rule.</p>
    pub approval_rule: std::option::Option<crate::model::ApprovalRule>,
}
impl CreatePullRequestApprovalRuleOutput {
    /// <p>Information about the created approval rule.</p>
    pub fn approval_rule(&self) -> std::option::Option<&crate::model::ApprovalRule> {
        self.approval_rule.as_ref()
    }
}
impl std::fmt::Debug for CreatePullRequestApprovalRuleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePullRequestApprovalRuleOutput");
        formatter.field("approval_rule", &self.approval_rule);
        formatter.finish()
    }
}
/// See [`CreatePullRequestApprovalRuleOutput`](crate::output::CreatePullRequestApprovalRuleOutput)
pub mod create_pull_request_approval_rule_output {
    /// A builder for [`CreatePullRequestApprovalRuleOutput`](crate::output::CreatePullRequestApprovalRuleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule: std::option::Option<crate::model::ApprovalRule>,
    }
    impl Builder {
        /// <p>Information about the created approval rule.</p>
        pub fn approval_rule(mut self, input: crate::model::ApprovalRule) -> Self {
            self.approval_rule = Some(input);
            self
        }
        /// <p>Information about the created approval rule.</p>
        pub fn set_approval_rule(
            mut self,
            input: std::option::Option<crate::model::ApprovalRule>,
        ) -> Self {
            self.approval_rule = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePullRequestApprovalRuleOutput`](crate::output::CreatePullRequestApprovalRuleOutput)
        pub fn build(self) -> crate::output::CreatePullRequestApprovalRuleOutput {
            crate::output::CreatePullRequestApprovalRuleOutput {
                approval_rule: self.approval_rule,
            }
        }
    }
}
impl CreatePullRequestApprovalRuleOutput {
    /// Creates a new builder-style object to manufacture [`CreatePullRequestApprovalRuleOutput`](crate::output::CreatePullRequestApprovalRuleOutput)
    pub fn builder() -> crate::output::create_pull_request_approval_rule_output::Builder {
        crate::output::create_pull_request_approval_rule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePullRequestOutput {
    /// <p>Information about the newly created pull request.</p>
    pub pull_request: std::option::Option<crate::model::PullRequest>,
}
impl CreatePullRequestOutput {
    /// <p>Information about the newly created pull request.</p>
    pub fn pull_request(&self) -> std::option::Option<&crate::model::PullRequest> {
        self.pull_request.as_ref()
    }
}
impl std::fmt::Debug for CreatePullRequestOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePullRequestOutput");
        formatter.field("pull_request", &self.pull_request);
        formatter.finish()
    }
}
/// See [`CreatePullRequestOutput`](crate::output::CreatePullRequestOutput)
pub mod create_pull_request_output {
    /// A builder for [`CreatePullRequestOutput`](crate::output::CreatePullRequestOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pull_request: std::option::Option<crate::model::PullRequest>,
    }
    impl Builder {
        /// <p>Information about the newly created pull request.</p>
        pub fn pull_request(mut self, input: crate::model::PullRequest) -> Self {
            self.pull_request = Some(input);
            self
        }
        /// <p>Information about the newly created pull request.</p>
        pub fn set_pull_request(
            mut self,
            input: std::option::Option<crate::model::PullRequest>,
        ) -> Self {
            self.pull_request = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePullRequestOutput`](crate::output::CreatePullRequestOutput)
        pub fn build(self) -> crate::output::CreatePullRequestOutput {
            crate::output::CreatePullRequestOutput {
                pull_request: self.pull_request,
            }
        }
    }
}
impl CreatePullRequestOutput {
    /// Creates a new builder-style object to manufacture [`CreatePullRequestOutput`](crate::output::CreatePullRequestOutput)
    pub fn builder() -> crate::output::create_pull_request_output::Builder {
        crate::output::create_pull_request_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCommitOutput {
    /// <p>The full commit ID of the commit that contains your committed file changes.</p>
    pub commit_id: std::option::Option<std::string::String>,
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.</p>
    pub tree_id: std::option::Option<std::string::String>,
    /// <p>The files added as part of the committed file changes.</p>
    pub files_added: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
    /// <p>The files updated as part of the commited file changes.</p>
    pub files_updated: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
    /// <p>The files deleted as part of the committed file changes.</p>
    pub files_deleted: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
}
impl CreateCommitOutput {
    /// <p>The full commit ID of the commit that contains your committed file changes.</p>
    pub fn commit_id(&self) -> std::option::Option<&str> {
        self.commit_id.as_deref()
    }
    /// <p>The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.</p>
    pub fn tree_id(&self) -> std::option::Option<&str> {
        self.tree_id.as_deref()
    }
    /// <p>The files added as part of the committed file changes.</p>
    pub fn files_added(&self) -> std::option::Option<&[crate::model::FileMetadata]> {
        self.files_added.as_deref()
    }
    /// <p>The files updated as part of the commited file changes.</p>
    pub fn files_updated(&self) -> std::option::Option<&[crate::model::FileMetadata]> {
        self.files_updated.as_deref()
    }
    /// <p>The files deleted as part of the committed file changes.</p>
    pub fn files_deleted(&self) -> std::option::Option<&[crate::model::FileMetadata]> {
        self.files_deleted.as_deref()
    }
}
impl std::fmt::Debug for CreateCommitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCommitOutput");
        formatter.field("commit_id", &self.commit_id);
        formatter.field("tree_id", &self.tree_id);
        formatter.field("files_added", &self.files_added);
        formatter.field("files_updated", &self.files_updated);
        formatter.field("files_deleted", &self.files_deleted);
        formatter.finish()
    }
}
/// See [`CreateCommitOutput`](crate::output::CreateCommitOutput)
pub mod create_commit_output {
    /// A builder for [`CreateCommitOutput`](crate::output::CreateCommitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commit_id: std::option::Option<std::string::String>,
        pub(crate) tree_id: std::option::Option<std::string::String>,
        pub(crate) files_added: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
        pub(crate) files_updated: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
        pub(crate) files_deleted: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
    }
    impl Builder {
        /// <p>The full commit ID of the commit that contains your committed file changes.</p>
        pub fn commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.commit_id = Some(input.into());
            self
        }
        /// <p>The full commit ID of the commit that contains your committed file changes.</p>
        pub fn set_commit_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.commit_id = input;
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.</p>
        pub fn tree_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tree_id = Some(input.into());
            self
        }
        /// <p>The full SHA-1 pointer of the tree information for the commit that contains the commited file changes.</p>
        pub fn set_tree_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tree_id = input;
            self
        }
        /// Appends an item to `files_added`.
        ///
        /// To override the contents of this collection use [`set_files_added`](Self::set_files_added).
        ///
        /// <p>The files added as part of the committed file changes.</p>
        pub fn files_added(mut self, input: impl Into<crate::model::FileMetadata>) -> Self {
            let mut v = self.files_added.unwrap_or_default();
            v.push(input.into());
            self.files_added = Some(v);
            self
        }
        /// <p>The files added as part of the committed file changes.</p>
        pub fn set_files_added(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
        ) -> Self {
            self.files_added = input;
            self
        }
        /// Appends an item to `files_updated`.
        ///
        /// To override the contents of this collection use [`set_files_updated`](Self::set_files_updated).
        ///
        /// <p>The files updated as part of the commited file changes.</p>
        pub fn files_updated(mut self, input: impl Into<crate::model::FileMetadata>) -> Self {
            let mut v = self.files_updated.unwrap_or_default();
            v.push(input.into());
            self.files_updated = Some(v);
            self
        }
        /// <p>The files updated as part of the commited file changes.</p>
        pub fn set_files_updated(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
        ) -> Self {
            self.files_updated = input;
            self
        }
        /// Appends an item to `files_deleted`.
        ///
        /// To override the contents of this collection use [`set_files_deleted`](Self::set_files_deleted).
        ///
        /// <p>The files deleted as part of the committed file changes.</p>
        pub fn files_deleted(mut self, input: impl Into<crate::model::FileMetadata>) -> Self {
            let mut v = self.files_deleted.unwrap_or_default();
            v.push(input.into());
            self.files_deleted = Some(v);
            self
        }
        /// <p>The files deleted as part of the committed file changes.</p>
        pub fn set_files_deleted(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FileMetadata>>,
        ) -> Self {
            self.files_deleted = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCommitOutput`](crate::output::CreateCommitOutput)
        pub fn build(self) -> crate::output::CreateCommitOutput {
            crate::output::CreateCommitOutput {
                commit_id: self.commit_id,
                tree_id: self.tree_id,
                files_added: self.files_added,
                files_updated: self.files_updated,
                files_deleted: self.files_deleted,
            }
        }
    }
}
impl CreateCommitOutput {
    /// Creates a new builder-style object to manufacture [`CreateCommitOutput`](crate::output::CreateCommitOutput)
    pub fn builder() -> crate::output::create_commit_output::Builder {
        crate::output::create_commit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBranchOutput {}
impl std::fmt::Debug for CreateBranchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBranchOutput");
        formatter.finish()
    }
}
/// See [`CreateBranchOutput`](crate::output::CreateBranchOutput)
pub mod create_branch_output {
    /// A builder for [`CreateBranchOutput`](crate::output::CreateBranchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateBranchOutput`](crate::output::CreateBranchOutput)
        pub fn build(self) -> crate::output::CreateBranchOutput {
            crate::output::CreateBranchOutput {}
        }
    }
}
impl CreateBranchOutput {
    /// Creates a new builder-style object to manufacture [`CreateBranchOutput`](crate::output::CreateBranchOutput)
    pub fn builder() -> crate::output::create_branch_output::Builder {
        crate::output::create_branch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateApprovalRuleTemplateOutput {
    /// <p>The content and structure of the created approval rule template.</p>
    pub approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
}
impl CreateApprovalRuleTemplateOutput {
    /// <p>The content and structure of the created approval rule template.</p>
    pub fn approval_rule_template(
        &self,
    ) -> std::option::Option<&crate::model::ApprovalRuleTemplate> {
        self.approval_rule_template.as_ref()
    }
}
impl std::fmt::Debug for CreateApprovalRuleTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateApprovalRuleTemplateOutput");
        formatter.field("approval_rule_template", &self.approval_rule_template);
        formatter.finish()
    }
}
/// See [`CreateApprovalRuleTemplateOutput`](crate::output::CreateApprovalRuleTemplateOutput)
pub mod create_approval_rule_template_output {
    /// A builder for [`CreateApprovalRuleTemplateOutput`](crate::output::CreateApprovalRuleTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_rule_template: std::option::Option<crate::model::ApprovalRuleTemplate>,
    }
    impl Builder {
        /// <p>The content and structure of the created approval rule template.</p>
        pub fn approval_rule_template(mut self, input: crate::model::ApprovalRuleTemplate) -> Self {
            self.approval_rule_template = Some(input);
            self
        }
        /// <p>The content and structure of the created approval rule template.</p>
        pub fn set_approval_rule_template(
            mut self,
            input: std::option::Option<crate::model::ApprovalRuleTemplate>,
        ) -> Self {
            self.approval_rule_template = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateApprovalRuleTemplateOutput`](crate::output::CreateApprovalRuleTemplateOutput)
        pub fn build(self) -> crate::output::CreateApprovalRuleTemplateOutput {
            crate::output::CreateApprovalRuleTemplateOutput {
                approval_rule_template: self.approval_rule_template,
            }
        }
    }
}
impl CreateApprovalRuleTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateApprovalRuleTemplateOutput`](crate::output::CreateApprovalRuleTemplateOutput)
    pub fn builder() -> crate::output::create_approval_rule_template_output::Builder {
        crate::output::create_approval_rule_template_output::Builder::default()
    }
}

/// <p>Represents the output of a batch get repositories operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetRepositoriesOutput {
    /// <p>A list of repositories returned by the batch get repositories operation.</p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::RepositoryMetadata>>,
    /// <p>Returns a list of repository names for which information could not be found.</p>
    pub repositories_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetRepositoriesOutput {
    /// <p>A list of repositories returned by the batch get repositories operation.</p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::RepositoryMetadata]> {
        self.repositories.as_deref()
    }
    /// <p>Returns a list of repository names for which information could not be found.</p>
    pub fn repositories_not_found(&self) -> std::option::Option<&[std::string::String]> {
        self.repositories_not_found.as_deref()
    }
}
impl std::fmt::Debug for BatchGetRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetRepositoriesOutput");
        formatter.field("repositories", &self.repositories);
        formatter.field("repositories_not_found", &self.repositories_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetRepositoriesOutput`](crate::output::BatchGetRepositoriesOutput)
pub mod batch_get_repositories_output {
    /// A builder for [`BatchGetRepositoriesOutput`](crate::output::BatchGetRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories:
            std::option::Option<std::vec::Vec<crate::model::RepositoryMetadata>>,
        pub(crate) repositories_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>A list of repositories returned by the batch get repositories operation.</p>
        pub fn repositories(mut self, input: impl Into<crate::model::RepositoryMetadata>) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input.into());
            self.repositories = Some(v);
            self
        }
        /// <p>A list of repositories returned by the batch get repositories operation.</p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositoryMetadata>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// Appends an item to `repositories_not_found`.
        ///
        /// To override the contents of this collection use [`set_repositories_not_found`](Self::set_repositories_not_found).
        ///
        /// <p>Returns a list of repository names for which information could not be found.</p>
        pub fn repositories_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.repositories_not_found.unwrap_or_default();
            v.push(input.into());
            self.repositories_not_found = Some(v);
            self
        }
        /// <p>Returns a list of repository names for which information could not be found.</p>
        pub fn set_repositories_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.repositories_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetRepositoriesOutput`](crate::output::BatchGetRepositoriesOutput)
        pub fn build(self) -> crate::output::BatchGetRepositoriesOutput {
            crate::output::BatchGetRepositoriesOutput {
                repositories: self.repositories,
                repositories_not_found: self.repositories_not_found,
            }
        }
    }
}
impl BatchGetRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetRepositoriesOutput`](crate::output::BatchGetRepositoriesOutput)
    pub fn builder() -> crate::output::batch_get_repositories_output::Builder {
        crate::output::batch_get_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetCommitsOutput {
    /// <p>An array of commit data type objects, each of which contains information about a specified commit.</p>
    pub commits: std::option::Option<std::vec::Vec<crate::model::Commit>>,
    /// <p>Returns any commit IDs for which information could not be found. For example, if one
    /// of the commit IDs was a shortened SHA ID or that commit was not found in the specified
    /// repository, the ID returns an error object with more information.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchGetCommitsError>>,
}
impl BatchGetCommitsOutput {
    /// <p>An array of commit data type objects, each of which contains information about a specified commit.</p>
    pub fn commits(&self) -> std::option::Option<&[crate::model::Commit]> {
        self.commits.as_deref()
    }
    /// <p>Returns any commit IDs for which information could not be found. For example, if one
    /// of the commit IDs was a shortened SHA ID or that commit was not found in the specified
    /// repository, the ID returns an error object with more information.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchGetCommitsError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchGetCommitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetCommitsOutput");
        formatter.field("commits", &self.commits);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchGetCommitsOutput`](crate::output::BatchGetCommitsOutput)
pub mod batch_get_commits_output {
    /// A builder for [`BatchGetCommitsOutput`](crate::output::BatchGetCommitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commits: std::option::Option<std::vec::Vec<crate::model::Commit>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::BatchGetCommitsError>>,
    }
    impl Builder {
        /// Appends an item to `commits`.
        ///
        /// To override the contents of this collection use [`set_commits`](Self::set_commits).
        ///
        /// <p>An array of commit data type objects, each of which contains information about a specified commit.</p>
        pub fn commits(mut self, input: impl Into<crate::model::Commit>) -> Self {
            let mut v = self.commits.unwrap_or_default();
            v.push(input.into());
            self.commits = Some(v);
            self
        }
        /// <p>An array of commit data type objects, each of which contains information about a specified commit.</p>
        pub fn set_commits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Commit>>,
        ) -> Self {
            self.commits = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Returns any commit IDs for which information could not be found. For example, if one
        /// of the commit IDs was a shortened SHA ID or that commit was not found in the specified
        /// repository, the ID returns an error object with more information.</p>
        pub fn errors(mut self, input: impl Into<crate::model::BatchGetCommitsError>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>Returns any commit IDs for which information could not be found. For example, if one
        /// of the commit IDs was a shortened SHA ID or that commit was not found in the specified
        /// repository, the ID returns an error object with more information.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchGetCommitsError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetCommitsOutput`](crate::output::BatchGetCommitsOutput)
        pub fn build(self) -> crate::output::BatchGetCommitsOutput {
            crate::output::BatchGetCommitsOutput {
                commits: self.commits,
                errors: self.errors,
            }
        }
    }
}
impl BatchGetCommitsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetCommitsOutput`](crate::output::BatchGetCommitsOutput)
    pub fn builder() -> crate::output::batch_get_commits_output::Builder {
        crate::output::batch_get_commits_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput {
    /// <p>A list of repository names that have had their association with the template
    /// removed.</p>
    pub disassociated_repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of any errors that might have occurred while attempting to remove the association between the template and the repositories.</p>
    pub errors: std::option::Option<
        std::vec::Vec<crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError>,
    >,
}
impl BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput {
    /// <p>A list of repository names that have had their association with the template
    /// removed.</p>
    pub fn disassociated_repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.disassociated_repository_names.as_deref()
    }
    /// <p>A list of any errors that might have occurred while attempting to remove the association between the template and the repositories.</p>
    pub fn errors(
        &self,
    ) -> std::option::Option<
        &[crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError],
    > {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput");
        formatter.field(
            "disassociated_repository_names",
            &self.disassociated_repository_names,
        );
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput`](crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput)
pub mod batch_disassociate_approval_rule_template_from_repositories_output {
    /// A builder for [`BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput`](crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disassociated_repository_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors: std::option::Option<
            std::vec::Vec<crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError>,
        >,
    }
    impl Builder {
        /// Appends an item to `disassociated_repository_names`.
        ///
        /// To override the contents of this collection use [`set_disassociated_repository_names`](Self::set_disassociated_repository_names).
        ///
        /// <p>A list of repository names that have had their association with the template
        /// removed.</p>
        pub fn disassociated_repository_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.disassociated_repository_names.unwrap_or_default();
            v.push(input.into());
            self.disassociated_repository_names = Some(v);
            self
        }
        /// <p>A list of repository names that have had their association with the template
        /// removed.</p>
        pub fn set_disassociated_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disassociated_repository_names = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of any errors that might have occurred while attempting to remove the association between the template and the repositories.</p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>A list of any errors that might have occurred while attempting to remove the association between the template and the repositories.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::BatchDisassociateApprovalRuleTemplateFromRepositoriesError,
                >,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput`](crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput)
        pub fn build(
            self,
        ) -> crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput {
            crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput {
                disassociated_repository_names: self.disassociated_repository_names,
                errors: self.errors,
            }
        }
    }
}
impl BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput`](crate::output::BatchDisassociateApprovalRuleTemplateFromRepositoriesOutput)
    pub fn builder(
    ) -> crate::output::batch_disassociate_approval_rule_template_from_repositories_output::Builder
    {
        crate::output::batch_disassociate_approval_rule_template_from_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDescribeMergeConflictsOutput {
    /// <p>A list of conflicts for each file, including the conflict metadata and the hunks of the differences between the files.</p>
    pub conflicts: std::option::Option<std::vec::Vec<crate::model::Conflict>>,
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of any errors returned while describing the merge conflicts for each file.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchDescribeMergeConflictsError>>,
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub destination_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub source_commit_id: std::option::Option<std::string::String>,
    /// <p>The commit ID of the merge base.</p>
    pub base_commit_id: std::option::Option<std::string::String>,
}
impl BatchDescribeMergeConflictsOutput {
    /// <p>A list of conflicts for each file, including the conflict metadata and the hunks of the differences between the files.</p>
    pub fn conflicts(&self) -> std::option::Option<&[crate::model::Conflict]> {
        self.conflicts.as_deref()
    }
    /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of any errors returned while describing the merge conflicts for each file.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchDescribeMergeConflictsError]> {
        self.errors.as_deref()
    }
    /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
    pub fn destination_commit_id(&self) -> std::option::Option<&str> {
        self.destination_commit_id.as_deref()
    }
    /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
    pub fn source_commit_id(&self) -> std::option::Option<&str> {
        self.source_commit_id.as_deref()
    }
    /// <p>The commit ID of the merge base.</p>
    pub fn base_commit_id(&self) -> std::option::Option<&str> {
        self.base_commit_id.as_deref()
    }
}
impl std::fmt::Debug for BatchDescribeMergeConflictsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDescribeMergeConflictsOutput");
        formatter.field("conflicts", &self.conflicts);
        formatter.field("next_token", &self.next_token);
        formatter.field("errors", &self.errors);
        formatter.field("destination_commit_id", &self.destination_commit_id);
        formatter.field("source_commit_id", &self.source_commit_id);
        formatter.field("base_commit_id", &self.base_commit_id);
        formatter.finish()
    }
}
/// See [`BatchDescribeMergeConflictsOutput`](crate::output::BatchDescribeMergeConflictsOutput)
pub mod batch_describe_merge_conflicts_output {
    /// A builder for [`BatchDescribeMergeConflictsOutput`](crate::output::BatchDescribeMergeConflictsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) conflicts: std::option::Option<std::vec::Vec<crate::model::Conflict>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchDescribeMergeConflictsError>>,
        pub(crate) destination_commit_id: std::option::Option<std::string::String>,
        pub(crate) source_commit_id: std::option::Option<std::string::String>,
        pub(crate) base_commit_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `conflicts`.
        ///
        /// To override the contents of this collection use [`set_conflicts`](Self::set_conflicts).
        ///
        /// <p>A list of conflicts for each file, including the conflict metadata and the hunks of the differences between the files.</p>
        pub fn conflicts(mut self, input: impl Into<crate::model::Conflict>) -> Self {
            let mut v = self.conflicts.unwrap_or_default();
            v.push(input.into());
            self.conflicts = Some(v);
            self
        }
        /// <p>A list of conflicts for each file, including the conflict metadata and the hunks of the differences between the files.</p>
        pub fn set_conflicts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Conflict>>,
        ) -> Self {
            self.conflicts = input;
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An enumeration token that can be used in a request to return the next batch of the results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of any errors returned while describing the merge conflicts for each file.</p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchDescribeMergeConflictsError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>A list of any errors returned while describing the merge conflicts for each file.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchDescribeMergeConflictsError>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn destination_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the destination commit specifier that was used in the merge evaluation.</p>
        pub fn set_destination_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_commit_id = input;
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn source_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the source commit specifier that was used in the merge evaluation.</p>
        pub fn set_source_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_commit_id = input;
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn base_commit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.base_commit_id = Some(input.into());
            self
        }
        /// <p>The commit ID of the merge base.</p>
        pub fn set_base_commit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.base_commit_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDescribeMergeConflictsOutput`](crate::output::BatchDescribeMergeConflictsOutput)
        pub fn build(self) -> crate::output::BatchDescribeMergeConflictsOutput {
            crate::output::BatchDescribeMergeConflictsOutput {
                conflicts: self.conflicts,
                next_token: self.next_token,
                errors: self.errors,
                destination_commit_id: self.destination_commit_id,
                source_commit_id: self.source_commit_id,
                base_commit_id: self.base_commit_id,
            }
        }
    }
}
impl BatchDescribeMergeConflictsOutput {
    /// Creates a new builder-style object to manufacture [`BatchDescribeMergeConflictsOutput`](crate::output::BatchDescribeMergeConflictsOutput)
    pub fn builder() -> crate::output::batch_describe_merge_conflicts_output::Builder {
        crate::output::batch_describe_merge_conflicts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchAssociateApprovalRuleTemplateWithRepositoriesOutput {
    /// <p>A list of names of the repositories that have been associated with the template.</p>
    pub associated_repository_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of any errors that might have occurred while attempting to create the association between the template and the repositories.</p>
    pub errors: std::option::Option<
        std::vec::Vec<crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError>,
    >,
}
impl BatchAssociateApprovalRuleTemplateWithRepositoriesOutput {
    /// <p>A list of names of the repositories that have been associated with the template.</p>
    pub fn associated_repository_names(&self) -> std::option::Option<&[std::string::String]> {
        self.associated_repository_names.as_deref()
    }
    /// <p>A list of any errors that might have occurred while attempting to create the association between the template and the repositories.</p>
    pub fn errors(
        &self,
    ) -> std::option::Option<&[crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError]>
    {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchAssociateApprovalRuleTemplateWithRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter =
            f.debug_struct("BatchAssociateApprovalRuleTemplateWithRepositoriesOutput");
        formatter.field(
            "associated_repository_names",
            &self.associated_repository_names,
        );
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchAssociateApprovalRuleTemplateWithRepositoriesOutput`](crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput)
pub mod batch_associate_approval_rule_template_with_repositories_output {
    /// A builder for [`BatchAssociateApprovalRuleTemplateWithRepositoriesOutput`](crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) associated_repository_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors: std::option::Option<
            std::vec::Vec<crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError>,
        >,
    }
    impl Builder {
        /// Appends an item to `associated_repository_names`.
        ///
        /// To override the contents of this collection use [`set_associated_repository_names`](Self::set_associated_repository_names).
        ///
        /// <p>A list of names of the repositories that have been associated with the template.</p>
        pub fn associated_repository_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.associated_repository_names.unwrap_or_default();
            v.push(input.into());
            self.associated_repository_names = Some(v);
            self
        }
        /// <p>A list of names of the repositories that have been associated with the template.</p>
        pub fn set_associated_repository_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.associated_repository_names = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of any errors that might have occurred while attempting to create the association between the template and the repositories.</p>
        pub fn errors(
            mut self,
            input: impl Into<crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError>,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// <p>A list of any errors that might have occurred while attempting to create the association between the template and the repositories.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<
                    crate::model::BatchAssociateApprovalRuleTemplateWithRepositoriesError,
                >,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchAssociateApprovalRuleTemplateWithRepositoriesOutput`](crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput)
        pub fn build(
            self,
        ) -> crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput {
            crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput {
                associated_repository_names: self.associated_repository_names,
                errors: self.errors,
            }
        }
    }
}
impl BatchAssociateApprovalRuleTemplateWithRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`BatchAssociateApprovalRuleTemplateWithRepositoriesOutput`](crate::output::BatchAssociateApprovalRuleTemplateWithRepositoriesOutput)
    pub fn builder(
    ) -> crate::output::batch_associate_approval_rule_template_with_repositories_output::Builder
    {
        crate::output::batch_associate_approval_rule_template_with_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateApprovalRuleTemplateWithRepositoryOutput {}
impl std::fmt::Debug for AssociateApprovalRuleTemplateWithRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateApprovalRuleTemplateWithRepositoryOutput");
        formatter.finish()
    }
}
/// See [`AssociateApprovalRuleTemplateWithRepositoryOutput`](crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput)
pub mod associate_approval_rule_template_with_repository_output {
    /// A builder for [`AssociateApprovalRuleTemplateWithRepositoryOutput`](crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateApprovalRuleTemplateWithRepositoryOutput`](crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput)
        pub fn build(self) -> crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput {
            crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput {}
        }
    }
}
impl AssociateApprovalRuleTemplateWithRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`AssociateApprovalRuleTemplateWithRepositoryOutput`](crate::output::AssociateApprovalRuleTemplateWithRepositoryOutput)
    pub fn builder(
    ) -> crate::output::associate_approval_rule_template_with_repository_output::Builder {
        crate::output::associate_approval_rule_template_with_repository_output::Builder::default()
    }
}
