// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateApprovalRuleTemplateWithRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateApprovalRuleTemplateWithRepositoryError {
    /// Kind of error that occurred.
    pub kind: AssociateApprovalRuleTemplateWithRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateApprovalRuleTemplateWithRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateApprovalRuleTemplateWithRepositoryErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The maximum number of approval rule templates for a repository has been exceeded. You cannot associate more than 25
    /// approval rule templates with a repository.</p>
    MaximumRuleTemplatesAssociatedWithRepositoryException(
        crate::error::MaximumRuleTemplatesAssociatedWithRepositoryException,
    ),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateApprovalRuleTemplateWithRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::MaximumRuleTemplatesAssociatedWithRepositoryException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for AssociateApprovalRuleTemplateWithRepositoryError
{
    fn code(&self) -> Option<&str> {
        AssociateApprovalRuleTemplateWithRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateApprovalRuleTemplateWithRepositoryError {
    /// Creates a new `AssociateApprovalRuleTemplateWithRepositoryError`.
    pub fn new(
        kind: AssociateApprovalRuleTemplateWithRepositoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateApprovalRuleTemplateWithRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateApprovalRuleTemplateWithRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateApprovalRuleTemplateWithRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateApprovalRuleTemplateWithRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(&self.kind, AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(_))
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(&self.kind, AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_))
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyUnavailableException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(&self.kind, AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(_))
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::MaximumRuleTemplatesAssociatedWithRepositoryException`.
    pub fn is_maximum_rule_templates_associated_with_repository_exception(&self) -> bool {
        matches!(&self.kind, AssociateApprovalRuleTemplateWithRepositoryErrorKind::MaximumRuleTemplatesAssociatedWithRepositoryException(_))
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryDoesNotExistException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryNameRequiredException(
                _
            )
        )
    }
}
impl std::error::Error for AssociateApprovalRuleTemplateWithRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::MaximumRuleTemplatesAssociatedWithRepositoryException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            AssociateApprovalRuleTemplateWithRepositoryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchAssociateApprovalRuleTemplateWithRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    /// Kind of error that occurred.
    pub kind: BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchAssociateApprovalRuleTemplateWithRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>The maximum number of allowed repository names was exceeded. Currently, this number is 100.</p>
    MaximumRepositoryNamesExceededException(crate::error::MaximumRepositoryNamesExceededException),
    /// <p>At least one repository name object is required, but was not specified.</p>
    RepositoryNamesRequiredException(crate::error::RepositoryNamesRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::RepositoryNamesRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for BatchAssociateApprovalRuleTemplateWithRepositoriesError
{
    fn code(&self) -> Option<&str> {
        BatchAssociateApprovalRuleTemplateWithRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    /// Creates a new `BatchAssociateApprovalRuleTemplateWithRepositoriesError`.
    pub fn new(
        kind: BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchAssociateApprovalRuleTemplateWithRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::Unhandled(
                err.into(),
            ),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchAssociateApprovalRuleTemplateWithRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::Unhandled(
                err.into(),
            ),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyDisabledException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyNotFoundException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::MaximumRepositoryNamesExceededException`.
    pub fn is_maximum_repository_names_exceeded_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_))
    }
    /// Returns `true` if the error kind is `BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::RepositoryNamesRequiredException`.
    pub fn is_repository_names_required_exception(&self) -> bool {
        matches!(&self.kind, BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::RepositoryNamesRequiredException(_))
    }
}
impl std::error::Error for BatchAssociateApprovalRuleTemplateWithRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::RepositoryNamesRequiredException(_inner) =>
            Some(_inner)
            ,
            BatchAssociateApprovalRuleTemplateWithRepositoriesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchDescribeMergeConflicts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDescribeMergeConflictsError {
    /// Kind of error that occurred.
    pub kind: BatchDescribeMergeConflictsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDescribeMergeConflicts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDescribeMergeConflictsErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified value for the number of conflict files to return is not valid.</p>
    InvalidMaxConflictFilesException(crate::error::InvalidMaxConflictFilesException),
    /// <p>The specified value for the number of merge hunks to return is not valid.</p>
    InvalidMaxMergeHunksException(crate::error::InvalidMaxMergeHunksException),
    /// <p>The specified merge option is not valid for this operation. Not all merge strategies are supported for all operations.</p>
    InvalidMergeOptionException(crate::error::InvalidMergeOptionException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>A merge option or stategy is required, and none was provided.</p>
    MergeOptionRequiredException(crate::error::MergeOptionRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDescribeMergeConflictsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDescribeMergeConflictsErrorKind::CommitDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            BatchDescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            BatchDescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(
                _inner,
            ) => _inner.fmt(f),
            BatchDescribeMergeConflictsErrorKind::InvalidContinuationTokenException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidMaxConflictFilesException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidMergeOptionException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(
                _inner,
            ) => _inner.fmt(f),
            BatchDescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(
                _inner,
            ) => _inner.fmt(f),
            BatchDescribeMergeConflictsErrorKind::MergeOptionRequiredException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::TipsDivergenceExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchDescribeMergeConflictsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDescribeMergeConflictsError {
    fn code(&self) -> Option<&str> {
        BatchDescribeMergeConflictsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDescribeMergeConflictsError {
    /// Creates a new `BatchDescribeMergeConflictsError`.
    pub fn new(kind: BatchDescribeMergeConflictsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDescribeMergeConflictsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDescribeMergeConflictsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDescribeMergeConflictsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDescribeMergeConflictsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidMaxConflictFilesException`.
    pub fn is_invalid_max_conflict_files_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidMaxConflictFilesException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException`.
    pub fn is_invalid_max_merge_hunks_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidMergeOptionException`.
    pub fn is_invalid_merge_option_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidMergeOptionException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::MergeOptionRequiredException`.
    pub fn is_merge_option_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::MergeOptionRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchDescribeMergeConflictsErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDescribeMergeConflictsErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for BatchDescribeMergeConflictsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDescribeMergeConflictsErrorKind::CommitDoesNotExistException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::CommitRequiredException(_inner) => Some(_inner),
            BatchDescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidCommitException(_inner) => Some(_inner),
            BatchDescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(
                _inner,
            ) => Some(_inner),
            BatchDescribeMergeConflictsErrorKind::InvalidContinuationTokenException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidMaxConflictFilesException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidMergeOptionException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::InvalidRepositoryNameException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(
                _inner,
            ) => Some(_inner),
            BatchDescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(
                _inner,
            ) => Some(_inner),
            BatchDescribeMergeConflictsErrorKind::MergeOptionRequiredException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::TipsDivergenceExceededException(_inner) => {
                Some(_inner)
            }
            BatchDescribeMergeConflictsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDisassociateApprovalRuleTemplateFromRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    /// Kind of error that occurred.
    pub kind: BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDisassociateApprovalRuleTemplateFromRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>The maximum number of allowed repository names was exceeded. Currently, this number is 100.</p>
    MaximumRepositoryNamesExceededException(crate::error::MaximumRepositoryNamesExceededException),
    /// <p>At least one repository name object is required, but was not specified.</p>
    RepositoryNamesRequiredException(crate::error::RepositoryNamesRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::RepositoryNamesRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for BatchDisassociateApprovalRuleTemplateFromRepositoriesError
{
    fn code(&self) -> Option<&str> {
        BatchDisassociateApprovalRuleTemplateFromRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    /// Creates a new `BatchDisassociateApprovalRuleTemplateFromRepositoriesError`.
    pub fn new(
        kind: BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDisassociateApprovalRuleTemplateFromRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::Unhandled(
                err.into(),
            ),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDisassociateApprovalRuleTemplateFromRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::Unhandled(
                err.into(),
            ),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyDisabledException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyNotFoundException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::MaximumRepositoryNamesExceededException`.
    pub fn is_maximum_repository_names_exceeded_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_))
    }
    /// Returns `true` if the error kind is `BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::RepositoryNamesRequiredException`.
    pub fn is_repository_names_required_exception(&self) -> bool {
        matches!(&self.kind, BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::RepositoryNamesRequiredException(_))
    }
}
impl std::error::Error for BatchDisassociateApprovalRuleTemplateFromRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::RepositoryNamesRequiredException(_inner) =>
            Some(_inner)
            ,
            BatchDisassociateApprovalRuleTemplateFromRepositoriesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `BatchGetCommits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetCommitsError {
    /// Kind of error that occurred.
    pub kind: BatchGetCommitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetCommits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetCommitsErrorKind {
    /// <p>The maximum number of allowed commit IDs in a batch request is 100. Verify that your batch requests contains no more than 100 commit IDs, and then try again.</p>
    CommitIdsLimitExceededException(crate::error::CommitIdsLimitExceededException),
    /// <p>A list of commit IDs is required, but was either not specified or the list was empty.</p>
    CommitIdsListRequiredException(crate::error::CommitIdsListRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetCommitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetCommitsErrorKind::CommitIdsLimitExceededException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::CommitIdsListRequiredException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetCommitsErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            BatchGetCommitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetCommitsError {
    fn code(&self) -> Option<&str> {
        BatchGetCommitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetCommitsError {
    /// Creates a new `BatchGetCommitsError`.
    pub fn new(kind: BatchGetCommitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetCommitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetCommitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetCommitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetCommitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::CommitIdsLimitExceededException`.
    pub fn is_commit_ids_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::CommitIdsLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::CommitIdsListRequiredException`.
    pub fn is_commit_ids_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::CommitIdsListRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCommitsErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCommitsErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for BatchGetCommitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetCommitsErrorKind::CommitIdsLimitExceededException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::CommitIdsListRequiredException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            BatchGetCommitsErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            BatchGetCommitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetRepositoriesError {
    /// Kind of error that occurred.
    pub kind: BatchGetRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetRepositoriesErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The maximum number of allowed repository names was exceeded. Currently, this number is 100.</p>
    MaximumRepositoryNamesExceededException(crate::error::MaximumRepositoryNamesExceededException),
    /// <p>At least one repository name object is required, but was not specified.</p>
    RepositoryNamesRequiredException(crate::error::RepositoryNamesRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoriesErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            BatchGetRepositoriesErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            BatchGetRepositoriesErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoriesErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            BatchGetRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoriesErrorKind::RepositoryNamesRequiredException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetRepositoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetRepositoriesError {
    fn code(&self) -> Option<&str> {
        BatchGetRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetRepositoriesError {
    /// Creates a new `BatchGetRepositoriesError`.
    pub fn new(kind: BatchGetRepositoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetRepositoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetRepositoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::MaximumRepositoryNamesExceededException`.
    pub fn is_maximum_repository_names_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetRepositoriesErrorKind::RepositoryNamesRequiredException`.
    pub fn is_repository_names_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetRepositoriesErrorKind::RepositoryNamesRequiredException(_)
        )
    }
}
impl std::error::Error for BatchGetRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetRepositoriesErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            BatchGetRepositoriesErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            BatchGetRepositoriesErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            BatchGetRepositoriesErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            BatchGetRepositoriesErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            BatchGetRepositoriesErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            BatchGetRepositoriesErrorKind::MaximumRepositoryNamesExceededException(_inner) => {
                Some(_inner)
            }
            BatchGetRepositoriesErrorKind::RepositoryNamesRequiredException(_inner) => Some(_inner),
            BatchGetRepositoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApprovalRuleTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateApprovalRuleTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApprovalRuleTemplateErrorKind {
    /// <p>The content for the approval rule template is empty. You must provide some content for an approval rule template. The content cannot be null.</p>
    ApprovalRuleTemplateContentRequiredException(
        crate::error::ApprovalRuleTemplateContentRequiredException,
    ),
    /// <p>You cannot create an approval rule template with that name because a template with
    /// that name already exists in this AWS Region for your AWS account. Approval rule template
    /// names must be unique.</p>
    ApprovalRuleTemplateNameAlreadyExistsException(
        crate::error::ApprovalRuleTemplateNameAlreadyExistsException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>The content of the approval rule template is not valid.</p>
    InvalidApprovalRuleTemplateContentException(
        crate::error::InvalidApprovalRuleTemplateContentException,
    ),
    /// <p>The description for the approval rule template is not valid because it exceeds the
    /// maximum characters allowed for a description. For more information about limits in AWS
    /// CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User
    /// Guide</a>.</p>
    InvalidApprovalRuleTemplateDescriptionException(
        crate::error::InvalidApprovalRuleTemplateDescriptionException,
    ),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>The maximum number of approval rule templates has been exceeded for this AWS Region. </p>
    NumberOfRuleTemplatesExceededException(crate::error::NumberOfRuleTemplatesExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApprovalRuleTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateContentRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(_inner) =>
            _inner.fmt(f)
            ,
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateContentException(_inner) =>
            _inner.fmt(f)
            ,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateDescriptionException(_inner) =>
            _inner.fmt(f)
            ,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            CreateApprovalRuleTemplateErrorKind::NumberOfRuleTemplatesExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateApprovalRuleTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApprovalRuleTemplateError {
    fn code(&self) -> Option<&str> {
        CreateApprovalRuleTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApprovalRuleTemplateError {
    /// Creates a new `CreateApprovalRuleTemplateError`.
    pub fn new(kind: CreateApprovalRuleTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApprovalRuleTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApprovalRuleTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApprovalRuleTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApprovalRuleTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateContentRequiredException`.
    pub fn is_approval_rule_template_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameAlreadyExistsException`.
    pub fn is_approval_rule_template_name_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateContentException`.
    pub fn is_invalid_approval_rule_template_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateContentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateDescriptionException`.
    pub fn is_invalid_approval_rule_template_description_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateDescriptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApprovalRuleTemplateErrorKind::NumberOfRuleTemplatesExceededException`.
    pub fn is_number_of_rule_templates_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApprovalRuleTemplateErrorKind::NumberOfRuleTemplatesExceededException(_)
        )
    }
}
impl std::error::Error for CreateApprovalRuleTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateContentRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(_inner) =>
            Some(_inner)
            ,
            CreateApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateContentException(_inner) =>
            Some(_inner)
            ,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateDescriptionException(_inner) =>
            Some(_inner)
            ,
            CreateApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            CreateApprovalRuleTemplateErrorKind::NumberOfRuleTemplatesExceededException(_inner) =>
            Some(_inner)
            ,
            CreateApprovalRuleTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBranchError {
    /// Kind of error that occurred.
    pub kind: CreateBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBranchErrorKind {
    /// <p>Cannot create the branch with the specified name because the commit conflicts with an existing branch with the same name.
    /// Branch names must be unique.</p>
    BranchNameExistsException(crate::error::BranchNameExistsException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit ID was not specified.</p>
    CommitIdRequiredException(crate::error::CommitIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBranchErrorKind::BranchNameExistsException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::CommitIdRequiredException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::InvalidCommitIdException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            CreateBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBranchError {
    fn code(&self) -> Option<&str> {
        CreateBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBranchError {
    /// Creates a new `CreateBranchError`.
    pub fn new(kind: CreateBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::BranchNameExistsException`.
    pub fn is_branch_name_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::BranchNameExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::CommitIdRequiredException`.
    pub fn is_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::CommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBranchErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBranchErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for CreateBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBranchErrorKind::BranchNameExistsException(_inner) => Some(_inner),
            CreateBranchErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            CreateBranchErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            CreateBranchErrorKind::CommitIdRequiredException(_inner) => Some(_inner),
            CreateBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            CreateBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            CreateBranchErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            CreateBranchErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            CreateBranchErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            CreateBranchErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            CreateBranchErrorKind::InvalidCommitIdException(_inner) => Some(_inner),
            CreateBranchErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            CreateBranchErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            CreateBranchErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            CreateBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCommitError {
    /// Kind of error that occurred.
    pub kind: CreateCommitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCommitErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>The specified branch name is not valid because it is a tag name. Enter the name of a
    /// branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</p>
    BranchNameIsTagNameException(crate::error::BranchNameIsTagNameException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>A file cannot be added to the repository because the specified path name has the same name as a file that already exists in this repository.
    /// Either provide a different name for the file, or specify a different path for the file.</p>
    DirectoryNameConflictsWithFileNameException(
        crate::error::DirectoryNameConflictsWithFileNameException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The commit cannot be created because both a source file and file content have been
    /// specified for the same file. You cannot provide both. Either specify a source file or
    /// provide the file content directly.</p>
    FileContentAndSourceFileSpecifiedException(
        crate::error::FileContentAndSourceFileSpecifiedException,
    ),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and
    /// the combined file content change size is 7 MB. Consider making these changes using a Git
    /// client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>The specified file does not exist. Verify that you have used the correct file name,
    /// full path, and extension.</p>
    FileDoesNotExistException(crate::error::FileDoesNotExistException),
    /// <p>The commit cannot be created because no files have been specified as added, updated, or changed (PutFile or DeleteFile) for the commit.</p>
    FileEntryRequiredException(crate::error::FileEntryRequiredException),
    /// <p>The commit cannot be created because no file mode has been specified. A file mode is
    /// required to update mode permissions for a file.</p>
    FileModeRequiredException(crate::error::FileModeRequiredException),
    /// <p>A file cannot be added to the repository because the specified file name has the same name as a directory in this repository. Either provide
    /// another name for the file, or add the file in a directory that does not match the file name.</p>
    FileNameConflictsWithDirectoryNameException(
        crate::error::FileNameConflictsWithDirectoryNameException,
    ),
    /// <p>The commit cannot be created because a specified file path points to a submodule. Verify that the destination files
    /// have valid file paths that do not point to a submodule.</p>
    FilePathConflictsWithSubmodulePathException(
        crate::error::FilePathConflictsWithSubmodulePathException,
    ),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a
    /// folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes,
    /// or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The specified deletion parameter is not valid.</p>
    InvalidDeletionParameterException(crate::error::InvalidDeletionParameterException),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for the branch of the repository where you
    /// want to add or update a file.</p>
    InvalidParentCommitIdException(crate::error::InvalidParentCommitIdException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The number of specified files to change as part of this commit exceeds the maximum number of files
    /// that can be changed in a single commit. Consider using a Git client for these changes.</p>
    MaximumFileEntriesExceededException(crate::error::MaximumFileEntriesExceededException),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The commit cannot be created because no changes will be made to the repository as a result of this commit. A commit must contain at least one change.</p>
    NoChangeException(crate::error::NoChangeException),
    /// <p>The parent commit ID is not valid because it does not exist. The specified parent commit ID does not exist in the specified branch of the repository.</p>
    ParentCommitDoesNotExistException(crate::error::ParentCommitDoesNotExistException),
    /// <p>The file could not be added because the provided parent commit ID is not the current tip of the specified branch. To view the full commit ID of the current head
    /// of the branch, use <a>GetBranch</a>.</p>
    ParentCommitIdOutdatedException(crate::error::ParentCommitIdOutdatedException),
    /// <p>A parent commit ID is required. To view the full commit ID of a branch in a repository, use <a>GetBranch</a> or a Git command
    /// (for example, git pull or git log).</p>
    ParentCommitIdRequiredException(crate::error::ParentCommitIdRequiredException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The commit cannot be created because one or more files specified in the commit reference both a file and a folder.</p>
    PutFileEntryConflictException(crate::error::PutFileEntryConflictException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The commit cannot be created because one of the changes specifies copying or moving a .gitkeep file.</p>
    RestrictedSourceFileException(crate::error::RestrictedSourceFileException),
    /// <p>The commit cannot be created because one or more changes in this commit duplicate actions in the same file path. For example,
    /// you cannot make the same delete request to the same file in the same file path twice, or make a delete request and a move request to the same
    /// file as part of the same commit.</p>
    SamePathRequestException(crate::error::SamePathRequestException),
    /// <p>The commit cannot be created because no source files or file content have been specified for the commit.</p>
    SourceFileOrContentRequiredException(crate::error::SourceFileOrContentRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCommitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCommitErrorKind::BranchDoesNotExistException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::BranchNameIsTagNameException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::CommitMessageLengthExceededException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::DirectoryNameConflictsWithFileNameException(_inner) => {
                _inner.fmt(f)
            }
            CreateCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::FileContentAndSourceFileSpecifiedException(_inner) => {
                _inner.fmt(f)
            }
            CreateCommitErrorKind::FileContentSizeLimitExceededException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::FileDoesNotExistException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::FileEntryRequiredException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::FileModeRequiredException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::FileNameConflictsWithDirectoryNameException(_inner) => {
                _inner.fmt(f)
            }
            CreateCommitErrorKind::FilePathConflictsWithSubmodulePathException(_inner) => {
                _inner.fmt(f)
            }
            CreateCommitErrorKind::FolderContentSizeLimitExceededException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::InvalidDeletionParameterException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::InvalidEmailException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::InvalidFileModeException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::InvalidParentCommitIdException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::MaximumFileEntriesExceededException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::NameLengthExceededException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::NoChangeException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::ParentCommitDoesNotExistException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::ParentCommitIdOutdatedException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::ParentCommitIdRequiredException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::PutFileEntryConflictException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::RestrictedSourceFileException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::SamePathRequestException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::SourceFileOrContentRequiredException(_inner) => _inner.fmt(f),
            CreateCommitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCommitError {
    fn code(&self) -> Option<&str> {
        CreateCommitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCommitError {
    /// Creates a new `CreateCommitError`.
    pub fn new(kind: CreateCommitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCommitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCommitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCommitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCommitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::BranchDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::BranchNameIsTagNameException`.
    pub fn is_branch_name_is_tag_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::BranchNameIsTagNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::DirectoryNameConflictsWithFileNameException`.
    pub fn is_directory_name_conflicts_with_file_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::DirectoryNameConflictsWithFileNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FileContentAndSourceFileSpecifiedException`.
    pub fn is_file_content_and_source_file_specified_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FileContentAndSourceFileSpecifiedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FileContentSizeLimitExceededException`.
    pub fn is_file_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FileContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FileDoesNotExistException`.
    pub fn is_file_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FileDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FileEntryRequiredException`.
    pub fn is_file_entry_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FileEntryRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FileModeRequiredException`.
    pub fn is_file_mode_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FileModeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FileNameConflictsWithDirectoryNameException`.
    pub fn is_file_name_conflicts_with_directory_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FileNameConflictsWithDirectoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FilePathConflictsWithSubmodulePathException`.
    pub fn is_file_path_conflicts_with_submodule_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FilePathConflictsWithSubmodulePathException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::FolderContentSizeLimitExceededException`.
    pub fn is_folder_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::FolderContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::InvalidDeletionParameterException`.
    pub fn is_invalid_deletion_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::InvalidDeletionParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(&self.kind, CreateCommitErrorKind::InvalidEmailException(_))
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::InvalidFileModeException`.
    pub fn is_invalid_file_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::InvalidFileModeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::InvalidParentCommitIdException`.
    pub fn is_invalid_parent_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::InvalidParentCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(&self.kind, CreateCommitErrorKind::InvalidPathException(_))
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::MaximumFileEntriesExceededException`.
    pub fn is_maximum_file_entries_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::MaximumFileEntriesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::NameLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::NoChangeException`.
    pub fn is_no_change_exception(&self) -> bool {
        matches!(&self.kind, CreateCommitErrorKind::NoChangeException(_))
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::ParentCommitDoesNotExistException`.
    pub fn is_parent_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::ParentCommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::ParentCommitIdOutdatedException`.
    pub fn is_parent_commit_id_outdated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::ParentCommitIdOutdatedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::ParentCommitIdRequiredException`.
    pub fn is_parent_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::ParentCommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(&self.kind, CreateCommitErrorKind::PathRequiredException(_))
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::PutFileEntryConflictException`.
    pub fn is_put_file_entry_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::PutFileEntryConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::RestrictedSourceFileException`.
    pub fn is_restricted_source_file_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::RestrictedSourceFileException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::SamePathRequestException`.
    pub fn is_same_path_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::SamePathRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCommitErrorKind::SourceFileOrContentRequiredException`.
    pub fn is_source_file_or_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCommitErrorKind::SourceFileOrContentRequiredException(_)
        )
    }
}
impl std::error::Error for CreateCommitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCommitErrorKind::BranchDoesNotExistException(_inner) => Some(_inner),
            CreateCommitErrorKind::BranchNameIsTagNameException(_inner) => Some(_inner),
            CreateCommitErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            CreateCommitErrorKind::CommitMessageLengthExceededException(_inner) => Some(_inner),
            CreateCommitErrorKind::DirectoryNameConflictsWithFileNameException(_inner) => {
                Some(_inner)
            }
            CreateCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            CreateCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            CreateCommitErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            CreateCommitErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            CreateCommitErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            CreateCommitErrorKind::FileContentAndSourceFileSpecifiedException(_inner) => {
                Some(_inner)
            }
            CreateCommitErrorKind::FileContentSizeLimitExceededException(_inner) => Some(_inner),
            CreateCommitErrorKind::FileDoesNotExistException(_inner) => Some(_inner),
            CreateCommitErrorKind::FileEntryRequiredException(_inner) => Some(_inner),
            CreateCommitErrorKind::FileModeRequiredException(_inner) => Some(_inner),
            CreateCommitErrorKind::FileNameConflictsWithDirectoryNameException(_inner) => {
                Some(_inner)
            }
            CreateCommitErrorKind::FilePathConflictsWithSubmodulePathException(_inner) => {
                Some(_inner)
            }
            CreateCommitErrorKind::FolderContentSizeLimitExceededException(_inner) => Some(_inner),
            CreateCommitErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            CreateCommitErrorKind::InvalidDeletionParameterException(_inner) => Some(_inner),
            CreateCommitErrorKind::InvalidEmailException(_inner) => Some(_inner),
            CreateCommitErrorKind::InvalidFileModeException(_inner) => Some(_inner),
            CreateCommitErrorKind::InvalidParentCommitIdException(_inner) => Some(_inner),
            CreateCommitErrorKind::InvalidPathException(_inner) => Some(_inner),
            CreateCommitErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            CreateCommitErrorKind::MaximumFileEntriesExceededException(_inner) => Some(_inner),
            CreateCommitErrorKind::NameLengthExceededException(_inner) => Some(_inner),
            CreateCommitErrorKind::NoChangeException(_inner) => Some(_inner),
            CreateCommitErrorKind::ParentCommitDoesNotExistException(_inner) => Some(_inner),
            CreateCommitErrorKind::ParentCommitIdOutdatedException(_inner) => Some(_inner),
            CreateCommitErrorKind::ParentCommitIdRequiredException(_inner) => Some(_inner),
            CreateCommitErrorKind::PathRequiredException(_inner) => Some(_inner),
            CreateCommitErrorKind::PutFileEntryConflictException(_inner) => Some(_inner),
            CreateCommitErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            CreateCommitErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            CreateCommitErrorKind::RestrictedSourceFileException(_inner) => Some(_inner),
            CreateCommitErrorKind::SamePathRequestException(_inner) => Some(_inner),
            CreateCommitErrorKind::SourceFileOrContentRequiredException(_inner) => Some(_inner),
            CreateCommitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePullRequestError {
    /// Kind of error that occurred.
    pub kind: CreatePullRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePullRequestErrorKind {
    /// <p>A client request token is required. A client request token is an unique,
    /// client-generated idempotency token that, when provided in a request, ensures the request
    /// cannot be repeated with a changed parameter. If a request is received with the same
    /// parameters and a token is included, the request returns information about the initial
    /// request that used that token.</p>
    ClientRequestTokenRequiredException(crate::error::ClientRequestTokenRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The client request token is not valid. Either the token is not in a valid format, or
    /// the token has been used in a previous request and cannot be reused.</p>
    IdempotencyParameterMismatchException(crate::error::IdempotencyParameterMismatchException),
    /// <p>The client request token is not valid.</p>
    InvalidClientRequestTokenException(crate::error::InvalidClientRequestTokenException),
    /// <p>The pull request description is not valid. Descriptions cannot be more than 1,000
    /// characters.</p>
    InvalidDescriptionException(crate::error::InvalidDescriptionException),
    /// <p>The specified reference name format is not valid. Reference names must conform to the
    /// Git references format (for example, refs/heads/master). For more information, see <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals -
    /// Git References</a> or consult your Git documentation.</p>
    InvalidReferenceNameException(crate::error::InvalidReferenceNameException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The target for the pull request is not valid. A target must contain the full values for the repository name, source branch, and destination branch for the pull request.</p>
    InvalidTargetException(crate::error::InvalidTargetException),
    /// <p>The targets for the pull request is not valid or not in a valid format. Targets are a list of target objects. Each target object must contain the full values for
    /// the repository name, source branch, and destination branch for a pull request.</p>
    InvalidTargetsException(crate::error::InvalidTargetsException),
    /// <p>The title of the pull request is not valid. Pull request titles cannot exceed 100 characters in length.</p>
    InvalidTitleException(crate::error::InvalidTitleException),
    /// <p>You cannot create the pull request because the repository has too many open pull requests.
    /// The maximum number of open pull requests for a repository is 1,000. Close one or more open pull requests, and then try again.</p>
    MaximumOpenPullRequestsExceededException(
        crate::error::MaximumOpenPullRequestsExceededException,
    ),
    /// <p>You cannot include more than one repository in a pull request. Make sure you have specified only one repository name in your request, and then try again.</p>
    MultipleRepositoriesInPullRequestException(
        crate::error::MultipleRepositoriesInPullRequestException,
    ),
    /// <p>The specified reference does not exist. You must provide a full commit ID.</p>
    ReferenceDoesNotExistException(crate::error::ReferenceDoesNotExistException),
    /// <p>A reference name is required, but none was provided.</p>
    ReferenceNameRequiredException(crate::error::ReferenceNameRequiredException),
    /// <p>The specified reference is not a supported type. </p>
    ReferenceTypeNotSupportedException(crate::error::ReferenceTypeNotSupportedException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The source branch and destination branch for the pull request are the same. You must
    /// specify different branches for the source and destination.</p>
    SourceAndDestinationAreSameException(crate::error::SourceAndDestinationAreSameException),
    /// <p>A pull request target is required. It cannot be empty or null. A pull request target must contain the full values for the repository name, source branch, and destination branch for the pull request.</p>
    TargetRequiredException(crate::error::TargetRequiredException),
    /// <p>An array of target objects is required. It cannot be empty or null.</p>
    TargetsRequiredException(crate::error::TargetsRequiredException),
    /// <p>A pull request title is required. It cannot be empty or null.</p>
    TitleRequiredException(crate::error::TitleRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePullRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePullRequestErrorKind::ClientRequestTokenRequiredException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::IdempotencyParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestErrorKind::InvalidClientRequestTokenException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::InvalidDescriptionException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::InvalidReferenceNameException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::InvalidTargetException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::InvalidTargetsException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::InvalidTitleException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::MaximumOpenPullRequestsExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestErrorKind::MultipleRepositoriesInPullRequestException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestErrorKind::ReferenceDoesNotExistException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::ReferenceNameRequiredException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::ReferenceTypeNotSupportedException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::SourceAndDestinationAreSameException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestErrorKind::TargetRequiredException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::TargetsRequiredException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::TitleRequiredException(_inner) => _inner.fmt(f),
            CreatePullRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePullRequestError {
    fn code(&self) -> Option<&str> {
        CreatePullRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePullRequestError {
    /// Creates a new `CreatePullRequestError`.
    pub fn new(kind: CreatePullRequestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePullRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePullRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePullRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePullRequestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::ClientRequestTokenRequiredException`.
    pub fn is_client_request_token_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::ClientRequestTokenRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::IdempotencyParameterMismatchException`.
    pub fn is_idempotency_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::IdempotencyParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::InvalidClientRequestTokenException`.
    pub fn is_invalid_client_request_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::InvalidClientRequestTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::InvalidDescriptionException`.
    pub fn is_invalid_description_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::InvalidDescriptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::InvalidReferenceNameException`.
    pub fn is_invalid_reference_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::InvalidReferenceNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::InvalidTargetException`.
    pub fn is_invalid_target_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::InvalidTargetException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::InvalidTargetsException`.
    pub fn is_invalid_targets_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::InvalidTargetsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::InvalidTitleException`.
    pub fn is_invalid_title_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::InvalidTitleException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::MaximumOpenPullRequestsExceededException`.
    pub fn is_maximum_open_pull_requests_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::MaximumOpenPullRequestsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::MultipleRepositoriesInPullRequestException`.
    pub fn is_multiple_repositories_in_pull_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::MultipleRepositoriesInPullRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::ReferenceDoesNotExistException`.
    pub fn is_reference_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::ReferenceDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::ReferenceNameRequiredException`.
    pub fn is_reference_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::ReferenceNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::ReferenceTypeNotSupportedException`.
    pub fn is_reference_type_not_supported_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::ReferenceTypeNotSupportedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::SourceAndDestinationAreSameException`.
    pub fn is_source_and_destination_are_same_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::SourceAndDestinationAreSameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::TargetRequiredException`.
    pub fn is_target_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::TargetRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::TargetsRequiredException`.
    pub fn is_targets_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::TargetsRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestErrorKind::TitleRequiredException`.
    pub fn is_title_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestErrorKind::TitleRequiredException(_)
        )
    }
}
impl std::error::Error for CreatePullRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePullRequestErrorKind::ClientRequestTokenRequiredException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::IdempotencyParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestErrorKind::InvalidClientRequestTokenException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::InvalidDescriptionException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::InvalidReferenceNameException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::InvalidTargetException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::InvalidTargetsException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::InvalidTitleException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::MaximumOpenPullRequestsExceededException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestErrorKind::MultipleRepositoriesInPullRequestException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestErrorKind::ReferenceDoesNotExistException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::ReferenceNameRequiredException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::ReferenceTypeNotSupportedException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::SourceAndDestinationAreSameException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestErrorKind::TargetRequiredException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::TargetsRequiredException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::TitleRequiredException(_inner) => Some(_inner),
            CreatePullRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePullRequestApprovalRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePullRequestApprovalRuleError {
    /// Kind of error that occurred.
    pub kind: CreatePullRequestApprovalRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePullRequestApprovalRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePullRequestApprovalRuleErrorKind {
    /// <p>The content for the approval rule is empty. You must provide some content for an approval rule. The content cannot be null.</p>
    ApprovalRuleContentRequiredException(crate::error::ApprovalRuleContentRequiredException),
    /// <p>An approval rule with that name already exists. Approval rule names must be unique
    /// within the scope of a pull request.</p>
    ApprovalRuleNameAlreadyExistsException(crate::error::ApprovalRuleNameAlreadyExistsException),
    /// <p>An approval rule name is required, but was not specified.</p>
    ApprovalRuleNameRequiredException(crate::error::ApprovalRuleNameRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The content for the approval rule is not valid.</p>
    InvalidApprovalRuleContentException(crate::error::InvalidApprovalRuleContentException),
    /// <p>The name for the approval rule is not valid.</p>
    InvalidApprovalRuleNameException(crate::error::InvalidApprovalRuleNameException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The approval rule cannot be added. The pull request has the maximum number of approval rules associated with it.</p>
    NumberOfRulesExceededException(crate::error::NumberOfRulesExceededException),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePullRequestApprovalRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleContentRequiredException(
                _inner,
            ) => _inner.fmt(f),
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameAlreadyExistsException(
                _inner,
            ) => _inner.fmt(f),
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleContentException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::NumberOfRulesExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            CreatePullRequestApprovalRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePullRequestApprovalRuleError {
    fn code(&self) -> Option<&str> {
        CreatePullRequestApprovalRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePullRequestApprovalRuleError {
    /// Creates a new `CreatePullRequestApprovalRuleError`.
    pub fn new(
        kind: CreatePullRequestApprovalRuleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePullRequestApprovalRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePullRequestApprovalRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePullRequestApprovalRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePullRequestApprovalRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::ApprovalRuleContentRequiredException`.
    pub fn is_approval_rule_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameAlreadyExistsException`.
    pub fn is_approval_rule_name_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException`.
    pub fn is_approval_rule_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleContentException`.
    pub fn is_invalid_approval_rule_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleContentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException`.
    pub fn is_invalid_approval_rule_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::NumberOfRulesExceededException`.
    pub fn is_number_of_rules_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::NumberOfRulesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(_)
        )
    }
}
impl std::error::Error for CreatePullRequestApprovalRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleContentRequiredException(
                _inner,
            ) => Some(_inner),
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameAlreadyExistsException(
                _inner,
            ) => Some(_inner),
            CreatePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleContentException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::NumberOfRulesExceededException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            CreatePullRequestApprovalRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRepositoryError {
    /// Kind of error that occurred.
    pub kind: CreateRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRepositoryErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified repository description is not valid.</p>
    InvalidRepositoryDescriptionException(crate::error::InvalidRepositoryDescriptionException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified tag is not valid. Key names cannot be prefixed with aws:.</p>
    InvalidSystemTagUsageException(crate::error::InvalidSystemTagUsageException),
    /// <p>The map of tags is not valid.</p>
    InvalidTagsMapException(crate::error::InvalidTagsMapException),
    /// <p>A repository resource limit was exceeded.</p>
    RepositoryLimitExceededException(crate::error::RepositoryLimitExceededException),
    /// <p>The specified repository name already exists.</p>
    RepositoryNameExistsException(crate::error::RepositoryNameExistsException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The tag policy is not valid.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>The maximum number of tags for an AWS CodeCommit resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            CreateRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::InvalidRepositoryDescriptionException(_inner) => {
                _inner.fmt(f)
            }
            CreateRepositoryErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::InvalidSystemTagUsageException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::InvalidTagsMapException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::RepositoryLimitExceededException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::RepositoryNameExistsException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRepositoryError {
    fn code(&self) -> Option<&str> {
        CreateRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRepositoryError {
    /// Creates a new `CreateRepositoryError`.
    pub fn new(kind: CreateRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidRepositoryDescriptionException`.
    pub fn is_invalid_repository_description_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidRepositoryDescriptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidSystemTagUsageException`.
    pub fn is_invalid_system_tag_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidSystemTagUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InvalidTagsMapException`.
    pub fn is_invalid_tags_map_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InvalidTagsMapException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::RepositoryLimitExceededException`.
    pub fn is_repository_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::RepositoryLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::RepositoryNameExistsException`.
    pub fn is_repository_name_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::RepositoryNameExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, CreateRepositoryErrorKind::TagPolicyException(_))
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::TooManyTagsException(_)
        )
    }
}
impl std::error::Error for CreateRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            CreateRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::InvalidRepositoryDescriptionException(_inner) => {
                Some(_inner)
            }
            CreateRepositoryErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::InvalidSystemTagUsageException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::InvalidTagsMapException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::RepositoryLimitExceededException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::RepositoryNameExistsException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::TagPolicyException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUnreferencedMergeCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUnreferencedMergeCommitError {
    /// Kind of error that occurred.
    pub kind: CreateUnreferencedMergeCommitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUnreferencedMergeCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUnreferencedMergeCommitErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and
    /// the combined file content change size is 7 MB. Consider making these changes using a Git
    /// client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>The commit cannot be created because no file mode has been specified. A file mode is
    /// required to update mode permissions for a file.</p>
    FileModeRequiredException(crate::error::FileModeRequiredException),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a
    /// folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes,
    /// or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution list is not valid.</p>
    InvalidConflictResolutionException(crate::error::InvalidConflictResolutionException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The specified merge option is not valid for this operation. Not all merge strategies are supported for all operations.</p>
    InvalidMergeOptionException(crate::error::InvalidMergeOptionException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>Automerge was specified for resolving the conflict, but the replacement type is not valid or content is missing. </p>
    InvalidReplacementContentException(crate::error::InvalidReplacementContentException),
    /// <p>Automerge was specified for resolving the conflict, but the specified replacement type is not valid.</p>
    InvalidReplacementTypeException(crate::error::InvalidReplacementTypeException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The number of allowed conflict resolution entries was exceeded.</p>
    MaximumConflictResolutionEntriesExceededException(
        crate::error::MaximumConflictResolutionEntriesExceededException,
    ),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>A merge option or stategy is required, and none was provided.</p>
    MergeOptionRequiredException(crate::error::MergeOptionRequiredException),
    /// <p>More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict resolution entry.</p>
    MultipleConflictResolutionEntriesException(
        crate::error::MultipleConflictResolutionEntriesException,
    ),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>USE_NEW_CONTENT was specified, but no replacement content has been provided.</p>
    ReplacementContentRequiredException(crate::error::ReplacementContentRequiredException),
    /// <p>A replacement type is required.</p>
    ReplacementTypeRequiredException(crate::error::ReplacementTypeRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUnreferencedMergeCommitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUnreferencedMergeCommitErrorKind::CommitDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::CommitMessageLengthExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::CommitRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::FileContentSizeLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::FileModeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::FolderContentSizeLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidCommitException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictDetailLevelException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionStrategyException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidEmailException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidFileModeException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidMergeOptionException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidPathException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidReplacementContentException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidReplacementTypeException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::ManualMergeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::MaximumConflictResolutionEntriesExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::MaximumFileContentToLoadExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::MaximumItemsToCompareExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::MergeOptionRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::MultipleConflictResolutionEntriesException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::NameLengthExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::PathRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::ReplacementContentRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::ReplacementTypeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::TipsDivergenceExceededException(_inner) =>
            _inner.fmt(f)
            ,
            CreateUnreferencedMergeCommitErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUnreferencedMergeCommitError {
    fn code(&self) -> Option<&str> {
        CreateUnreferencedMergeCommitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUnreferencedMergeCommitError {
    /// Creates a new `CreateUnreferencedMergeCommitError`.
    pub fn new(
        kind: CreateUnreferencedMergeCommitErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUnreferencedMergeCommitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUnreferencedMergeCommitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUnreferencedMergeCommitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUnreferencedMergeCommitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::ConcurrentReferenceUpdateException`.
    pub fn is_concurrent_reference_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::ConcurrentReferenceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::FileContentSizeLimitExceededException`.
    pub fn is_file_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::FileContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::FileModeRequiredException`.
    pub fn is_file_mode_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::FileModeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::FolderContentSizeLimitExceededException`.
    pub fn is_folder_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::FolderContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionException`.
    pub fn is_invalid_conflict_resolution_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidEmailException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidFileModeException`.
    pub fn is_invalid_file_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidFileModeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidMergeOptionException`.
    pub fn is_invalid_merge_option_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidMergeOptionException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidReplacementContentException`.
    pub fn is_invalid_replacement_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidReplacementContentException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidReplacementTypeException`.
    pub fn is_invalid_replacement_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidReplacementTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::ManualMergeRequiredException`.
    pub fn is_manual_merge_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::ManualMergeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::MaximumConflictResolutionEntriesExceededException`.
    pub fn is_maximum_conflict_resolution_entries_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateUnreferencedMergeCommitErrorKind::MaximumConflictResolutionEntriesExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::MergeOptionRequiredException`.
    pub fn is_merge_option_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::MergeOptionRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::MultipleConflictResolutionEntriesException`.
    pub fn is_multiple_conflict_resolution_entries_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::MultipleConflictResolutionEntriesException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::NameLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::ReplacementContentRequiredException`.
    pub fn is_replacement_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::ReplacementContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::ReplacementTypeRequiredException`.
    pub fn is_replacement_type_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::ReplacementTypeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUnreferencedMergeCommitErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUnreferencedMergeCommitErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for CreateUnreferencedMergeCommitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUnreferencedMergeCommitErrorKind::CommitDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::CommitMessageLengthExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::CommitRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::FileContentSizeLimitExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::FileModeRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::FolderContentSizeLimitExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidCommitException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictDetailLevelException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidConflictResolutionStrategyException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidEmailException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidFileModeException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidMergeOptionException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidPathException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidReplacementContentException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidReplacementTypeException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::ManualMergeRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::MaximumConflictResolutionEntriesExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::MaximumFileContentToLoadExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::MaximumItemsToCompareExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::MergeOptionRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::MultipleConflictResolutionEntriesException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::NameLengthExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::PathRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::ReplacementContentRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::ReplacementTypeRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::TipsDivergenceExceededException(_inner) =>
            Some(_inner)
            ,
            CreateUnreferencedMergeCommitErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApprovalRuleTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteApprovalRuleTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApprovalRuleTemplateErrorKind {
    /// <p>The approval rule template is associated with one or more repositories. You cannot delete a template that is associated with a repository. Remove
    /// all associations, and then try again.</p>
    ApprovalRuleTemplateInUseException(crate::error::ApprovalRuleTemplateInUseException),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApprovalRuleTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateInUseException(_inner) => {
                _inner.fmt(f)
            }
            DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(
                _inner,
            ) => _inner.fmt(f),
            DeleteApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(
                _inner,
            ) => _inner.fmt(f),
            DeleteApprovalRuleTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApprovalRuleTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteApprovalRuleTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApprovalRuleTemplateError {
    /// Creates a new `DeleteApprovalRuleTemplateError`.
    pub fn new(kind: DeleteApprovalRuleTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApprovalRuleTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApprovalRuleTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApprovalRuleTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApprovalRuleTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateInUseException`.
    pub fn is_approval_rule_template_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_)
        )
    }
}
impl std::error::Error for DeleteApprovalRuleTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateInUseException(_inner) => {
                Some(_inner)
            }
            DeleteApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(
                _inner,
            ) => Some(_inner),
            DeleteApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(
                _inner,
            ) => Some(_inner),
            DeleteApprovalRuleTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBranchError {
    /// Kind of error that occurred.
    pub kind: DeleteBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBranchErrorKind {
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The specified branch is the default branch for the repository, and cannot be deleted. To delete this branch, you must first set another branch as the default branch.</p>
    DefaultBranchCannotBeDeletedException(crate::error::DefaultBranchCannotBeDeletedException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBranchErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::DefaultBranchCannotBeDeletedException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            DeleteBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBranchError {
    fn code(&self) -> Option<&str> {
        DeleteBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBranchError {
    /// Creates a new `DeleteBranchError`.
    pub fn new(kind: DeleteBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::DefaultBranchCannotBeDeletedException`.
    pub fn is_default_branch_cannot_be_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::DefaultBranchCannotBeDeletedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBranchErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBranchErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for DeleteBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBranchErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            DeleteBranchErrorKind::DefaultBranchCannotBeDeletedException(_inner) => Some(_inner),
            DeleteBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            DeleteBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            DeleteBranchErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            DeleteBranchErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            DeleteBranchErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            DeleteBranchErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            DeleteBranchErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            DeleteBranchErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            DeleteBranchErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            DeleteBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCommentContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCommentContentError {
    /// Kind of error that occurred.
    pub kind: DeleteCommentContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCommentContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCommentContentErrorKind {
    /// <p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>
    CommentDeletedException(crate::error::CommentDeletedException),
    /// <p>No comment exists with the provided ID. Verify that you have used the correct ID, and
    /// then try again.</p>
    CommentDoesNotExistException(crate::error::CommentDoesNotExistException),
    /// <p>The comment ID is missing or null. A comment ID is required.</p>
    CommentIdRequiredException(crate::error::CommentIdRequiredException),
    /// <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
    InvalidCommentIdException(crate::error::InvalidCommentIdException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCommentContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCommentContentErrorKind::CommentDeletedException(_inner) => _inner.fmt(f),
            DeleteCommentContentErrorKind::CommentDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteCommentContentErrorKind::CommentIdRequiredException(_inner) => _inner.fmt(f),
            DeleteCommentContentErrorKind::InvalidCommentIdException(_inner) => _inner.fmt(f),
            DeleteCommentContentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCommentContentError {
    fn code(&self) -> Option<&str> {
        DeleteCommentContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCommentContentError {
    /// Creates a new `DeleteCommentContentError`.
    pub fn new(kind: DeleteCommentContentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCommentContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCommentContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCommentContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCommentContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCommentContentErrorKind::CommentDeletedException`.
    pub fn is_comment_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCommentContentErrorKind::CommentDeletedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCommentContentErrorKind::CommentDoesNotExistException`.
    pub fn is_comment_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCommentContentErrorKind::CommentDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCommentContentErrorKind::CommentIdRequiredException`.
    pub fn is_comment_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCommentContentErrorKind::CommentIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCommentContentErrorKind::InvalidCommentIdException`.
    pub fn is_invalid_comment_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCommentContentErrorKind::InvalidCommentIdException(_)
        )
    }
}
impl std::error::Error for DeleteCommentContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCommentContentErrorKind::CommentDeletedException(_inner) => Some(_inner),
            DeleteCommentContentErrorKind::CommentDoesNotExistException(_inner) => Some(_inner),
            DeleteCommentContentErrorKind::CommentIdRequiredException(_inner) => Some(_inner),
            DeleteCommentContentErrorKind::InvalidCommentIdException(_inner) => Some(_inner),
            DeleteCommentContentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFileError {
    /// Kind of error that occurred.
    pub kind: DeleteFileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFileErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>The specified branch name is not valid because it is a tag name. Enter the name of a
    /// branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</p>
    BranchNameIsTagNameException(crate::error::BranchNameIsTagNameException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified file does not exist. Verify that you have used the correct file name,
    /// full path, and extension.</p>
    FileDoesNotExistException(crate::error::FileDoesNotExistException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for the branch of the repository where you
    /// want to add or update a file.</p>
    InvalidParentCommitIdException(crate::error::InvalidParentCommitIdException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The parent commit ID is not valid because it does not exist. The specified parent commit ID does not exist in the specified branch of the repository.</p>
    ParentCommitDoesNotExistException(crate::error::ParentCommitDoesNotExistException),
    /// <p>The file could not be added because the provided parent commit ID is not the current tip of the specified branch. To view the full commit ID of the current head
    /// of the branch, use <a>GetBranch</a>.</p>
    ParentCommitIdOutdatedException(crate::error::ParentCommitIdOutdatedException),
    /// <p>A parent commit ID is required. To view the full commit ID of a branch in a repository, use <a>GetBranch</a> or a Git command
    /// (for example, git pull or git log).</p>
    ParentCommitIdRequiredException(crate::error::ParentCommitIdRequiredException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFileErrorKind::BranchDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::BranchNameIsTagNameException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::CommitMessageLengthExceededException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::FileDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::InvalidEmailException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::InvalidParentCommitIdException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::NameLengthExceededException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::ParentCommitDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::ParentCommitIdOutdatedException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::ParentCommitIdRequiredException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            DeleteFileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFileError {
    fn code(&self) -> Option<&str> {
        DeleteFileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFileError {
    /// Creates a new `DeleteFileError`.
    pub fn new(kind: DeleteFileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::BranchDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::BranchNameIsTagNameException`.
    pub fn is_branch_name_is_tag_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::BranchNameIsTagNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::FileDoesNotExistException`.
    pub fn is_file_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::FileDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(&self.kind, DeleteFileErrorKind::InvalidEmailException(_))
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::InvalidParentCommitIdException`.
    pub fn is_invalid_parent_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::InvalidParentCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(&self.kind, DeleteFileErrorKind::InvalidPathException(_))
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::NameLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::ParentCommitDoesNotExistException`.
    pub fn is_parent_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::ParentCommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::ParentCommitIdOutdatedException`.
    pub fn is_parent_commit_id_outdated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::ParentCommitIdOutdatedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::ParentCommitIdRequiredException`.
    pub fn is_parent_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::ParentCommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(&self.kind, DeleteFileErrorKind::PathRequiredException(_))
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFileErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFileErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for DeleteFileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFileErrorKind::BranchDoesNotExistException(_inner) => Some(_inner),
            DeleteFileErrorKind::BranchNameIsTagNameException(_inner) => Some(_inner),
            DeleteFileErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            DeleteFileErrorKind::CommitMessageLengthExceededException(_inner) => Some(_inner),
            DeleteFileErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            DeleteFileErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            DeleteFileErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            DeleteFileErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            DeleteFileErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            DeleteFileErrorKind::FileDoesNotExistException(_inner) => Some(_inner),
            DeleteFileErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            DeleteFileErrorKind::InvalidEmailException(_inner) => Some(_inner),
            DeleteFileErrorKind::InvalidParentCommitIdException(_inner) => Some(_inner),
            DeleteFileErrorKind::InvalidPathException(_inner) => Some(_inner),
            DeleteFileErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            DeleteFileErrorKind::NameLengthExceededException(_inner) => Some(_inner),
            DeleteFileErrorKind::ParentCommitDoesNotExistException(_inner) => Some(_inner),
            DeleteFileErrorKind::ParentCommitIdOutdatedException(_inner) => Some(_inner),
            DeleteFileErrorKind::ParentCommitIdRequiredException(_inner) => Some(_inner),
            DeleteFileErrorKind::PathRequiredException(_inner) => Some(_inner),
            DeleteFileErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            DeleteFileErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            DeleteFileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePullRequestApprovalRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePullRequestApprovalRuleError {
    /// Kind of error that occurred.
    pub kind: DeletePullRequestApprovalRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePullRequestApprovalRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePullRequestApprovalRuleErrorKind {
    /// <p>An approval rule name is required, but was not specified.</p>
    ApprovalRuleNameRequiredException(crate::error::ApprovalRuleNameRequiredException),
    /// <p>The approval rule cannot be deleted from the pull request because it was created by an
    /// approval rule template and applied to the pull request automatically.</p>
    CannotDeleteApprovalRuleFromTemplateException(
        crate::error::CannotDeleteApprovalRuleFromTemplateException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The name for the approval rule is not valid.</p>
    InvalidApprovalRuleNameException(crate::error::InvalidApprovalRuleNameException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePullRequestApprovalRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::CannotDeleteApprovalRuleFromTemplateException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            DeletePullRequestApprovalRuleErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePullRequestApprovalRuleError {
    fn code(&self) -> Option<&str> {
        DeletePullRequestApprovalRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePullRequestApprovalRuleError {
    /// Creates a new `DeletePullRequestApprovalRuleError`.
    pub fn new(
        kind: DeletePullRequestApprovalRuleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePullRequestApprovalRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePullRequestApprovalRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePullRequestApprovalRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePullRequestApprovalRuleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException`.
    pub fn is_approval_rule_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::CannotDeleteApprovalRuleFromTemplateException`.
    pub fn is_cannot_delete_approval_rule_from_template_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::CannotDeleteApprovalRuleFromTemplateException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException`.
    pub fn is_invalid_approval_rule_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(_)
        )
    }
}
impl std::error::Error for DeletePullRequestApprovalRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePullRequestApprovalRuleErrorKind::ApprovalRuleNameRequiredException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::CannotDeleteApprovalRuleFromTemplateException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::InvalidApprovalRuleNameException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::InvalidPullRequestIdException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::PullRequestAlreadyClosedException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::PullRequestDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::PullRequestIdRequiredException(_inner) =>
            Some(_inner)
            ,
            DeletePullRequestApprovalRuleErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRepositoryError {
    /// Creates a new `DeleteRepositoryError`.
    pub fn new(kind: DeleteRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for DeleteRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            DeleteRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMergeConflicts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMergeConflictsError {
    /// Kind of error that occurred.
    pub kind: DescribeMergeConflictsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMergeConflicts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMergeConflictsErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified file does not exist. Verify that you have used the correct file name,
    /// full path, and extension.</p>
    FileDoesNotExistException(crate::error::FileDoesNotExistException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified value for the number of merge hunks to return is not valid.</p>
    InvalidMaxMergeHunksException(crate::error::InvalidMaxMergeHunksException),
    /// <p>The specified merge option is not valid for this operation. Not all merge strategies are supported for all operations.</p>
    InvalidMergeOptionException(crate::error::InvalidMergeOptionException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>A merge option or stategy is required, and none was provided.</p>
    MergeOptionRequiredException(crate::error::MergeOptionRequiredException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMergeConflictsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMergeConflictsErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::FileDoesNotExistException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::InvalidContinuationTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::InvalidMergeOptionException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::MergeOptionRequiredException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            DescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::TipsDivergenceExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeMergeConflictsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMergeConflictsError {
    fn code(&self) -> Option<&str> {
        DescribeMergeConflictsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMergeConflictsError {
    /// Creates a new `DescribeMergeConflictsError`.
    pub fn new(kind: DescribeMergeConflictsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMergeConflictsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMergeConflictsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMergeConflictsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMergeConflictsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::FileDoesNotExistException`.
    pub fn is_file_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::FileDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException`.
    pub fn is_invalid_max_merge_hunks_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidMergeOptionException`.
    pub fn is_invalid_merge_option_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidMergeOptionException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::MergeOptionRequiredException`.
    pub fn is_merge_option_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::MergeOptionRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMergeConflictsErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMergeConflictsErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for DescribeMergeConflictsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMergeConflictsErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::CommitRequiredException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::FileDoesNotExistException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::InvalidCommitException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::InvalidConflictDetailLevelException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::InvalidContinuationTokenException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::InvalidMaxMergeHunksException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::InvalidMergeOptionException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::InvalidPathException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::MergeOptionRequiredException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::PathRequiredException(_inner) => Some(_inner),
            DescribeMergeConflictsErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::TipsDivergenceExceededException(_inner) => {
                Some(_inner)
            }
            DescribeMergeConflictsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePullRequestEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePullRequestEventsError {
    /// Kind of error that occurred.
    pub kind: DescribePullRequestEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePullRequestEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePullRequestEventsErrorKind {
    /// <p>The specified Amazon Resource Name (ARN) does not exist in the AWS account.</p>
    ActorDoesNotExistException(crate::error::ActorDoesNotExistException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the user who initiated the change for the pull request,
    /// and then try again.</p>
    InvalidActorArnException(crate::error::InvalidActorArnException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The pull request event type is not valid. </p>
    InvalidPullRequestEventTypeException(crate::error::InvalidPullRequestEventTypeException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePullRequestEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePullRequestEventsErrorKind::ActorDoesNotExistException(_inner) => _inner.fmt(f),
            DescribePullRequestEventsErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            DescribePullRequestEventsErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::InvalidActorArnException(_inner) => _inner.fmt(f),
            DescribePullRequestEventsErrorKind::InvalidContinuationTokenException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            DescribePullRequestEventsErrorKind::InvalidPullRequestEventTypeException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            DescribePullRequestEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePullRequestEventsError {
    fn code(&self) -> Option<&str> {
        DescribePullRequestEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePullRequestEventsError {
    /// Creates a new `DescribePullRequestEventsError`.
    pub fn new(kind: DescribePullRequestEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePullRequestEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePullRequestEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePullRequestEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePullRequestEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::ActorDoesNotExistException`.
    pub fn is_actor_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::ActorDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::InvalidActorArnException`.
    pub fn is_invalid_actor_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::InvalidActorArnException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::InvalidPullRequestEventTypeException`.
    pub fn is_invalid_pull_request_event_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::InvalidPullRequestEventTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePullRequestEventsErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePullRequestEventsErrorKind::PullRequestIdRequiredException(_)
        )
    }
}
impl std::error::Error for DescribePullRequestEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePullRequestEventsErrorKind::ActorDoesNotExistException(_inner) => Some(_inner),
            DescribePullRequestEventsErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            DescribePullRequestEventsErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::InvalidActorArnException(_inner) => Some(_inner),
            DescribePullRequestEventsErrorKind::InvalidContinuationTokenException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            DescribePullRequestEventsErrorKind::InvalidPullRequestEventTypeException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            DescribePullRequestEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateApprovalRuleTemplateFromRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateApprovalRuleTemplateFromRepositoryError {
    /// Kind of error that occurred.
    pub kind: DisassociateApprovalRuleTemplateFromRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateApprovalRuleTemplateFromRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateApprovalRuleTemplateFromRepositoryErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateApprovalRuleTemplateFromRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DisassociateApprovalRuleTemplateFromRepositoryError
{
    fn code(&self) -> Option<&str> {
        DisassociateApprovalRuleTemplateFromRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateApprovalRuleTemplateFromRepositoryError {
    /// Creates a new `DisassociateApprovalRuleTemplateFromRepositoryError`.
    pub fn new(
        kind: DisassociateApprovalRuleTemplateFromRepositoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateApprovalRuleTemplateFromRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateApprovalRuleTemplateFromRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateApprovalRuleTemplateFromRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateApprovalRuleTemplateFromRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(_))
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_))
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyDisabledException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyNotFoundException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(_))
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidRepositoryNameException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(&self.kind, DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryNameRequiredException(_))
    }
}
impl std::error::Error for DisassociateApprovalRuleTemplateFromRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            DisassociateApprovalRuleTemplateFromRepositoryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `EvaluatePullRequestApprovalRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EvaluatePullRequestApprovalRulesError {
    /// Kind of error that occurred.
    pub kind: EvaluatePullRequestApprovalRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EvaluatePullRequestApprovalRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EvaluatePullRequestApprovalRulesErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The revision ID is not valid. Use GetPullRequest to determine the value.</p>
    InvalidRevisionIdException(crate::error::InvalidRevisionIdException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>A revision ID is required, but was not provided.</p>
    RevisionIdRequiredException(crate::error::RevisionIdRequiredException),
    /// <p>The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to retrieve the current revision ID.</p>
    RevisionNotCurrentException(crate::error::RevisionNotCurrentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EvaluatePullRequestApprovalRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(
                _inner,
            ) => _inner.fmt(f),
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            EvaluatePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(_inner) => {
                _inner.fmt(f)
            }
            EvaluatePullRequestApprovalRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EvaluatePullRequestApprovalRulesError {
    fn code(&self) -> Option<&str> {
        EvaluatePullRequestApprovalRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EvaluatePullRequestApprovalRulesError {
    /// Creates a new `EvaluatePullRequestApprovalRulesError`.
    pub fn new(
        kind: EvaluatePullRequestApprovalRulesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EvaluatePullRequestApprovalRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EvaluatePullRequestApprovalRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EvaluatePullRequestApprovalRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EvaluatePullRequestApprovalRulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::InvalidRevisionIdException`.
    pub fn is_invalid_revision_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::RevisionIdRequiredException`.
    pub fn is_revision_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `EvaluatePullRequestApprovalRulesErrorKind::RevisionNotCurrentException`.
    pub fn is_revision_not_current_exception(&self) -> bool {
        matches!(
            &self.kind,
            EvaluatePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(_)
        )
    }
}
impl std::error::Error for EvaluatePullRequestApprovalRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(
                _inner,
            ) => Some(_inner),
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(
                _inner,
            ) => Some(_inner),
            EvaluatePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(_inner) => {
                Some(_inner)
            }
            EvaluatePullRequestApprovalRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetApprovalRuleTemplateError {
    /// Kind of error that occurred.
    pub kind: GetApprovalRuleTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetApprovalRuleTemplateErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetApprovalRuleTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_inner) => {
                _inner.fmt(f)
            }
            GetApprovalRuleTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetApprovalRuleTemplateError {
    fn code(&self) -> Option<&str> {
        GetApprovalRuleTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetApprovalRuleTemplateError {
    /// Creates a new `GetApprovalRuleTemplateError`.
    pub fn new(kind: GetApprovalRuleTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetApprovalRuleTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetApprovalRuleTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetApprovalRuleTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetApprovalRuleTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_)
        )
    }
}
impl std::error::Error for GetApprovalRuleTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) => {
                Some(_inner)
            }
            GetApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_inner) => {
                Some(_inner)
            }
            GetApprovalRuleTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBlob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBlobError {
    /// Kind of error that occurred.
    pub kind: GetBlobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBlob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBlobErrorKind {
    /// <p>The specified blob does not exist.</p>
    BlobIdDoesNotExistException(crate::error::BlobIdDoesNotExistException),
    /// <p>A blob ID is required, but was not specified.</p>
    BlobIdRequiredException(crate::error::BlobIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified file exceeds the file size limit for AWS CodeCommit. For more information about limits in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>
    FileTooLargeException(crate::error::FileTooLargeException),
    /// <p>The specified blob is not valid.</p>
    InvalidBlobIdException(crate::error::InvalidBlobIdException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBlobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBlobErrorKind::BlobIdDoesNotExistException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::BlobIdRequiredException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::FileTooLargeException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::InvalidBlobIdException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetBlobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBlobError {
    fn code(&self) -> Option<&str> {
        GetBlobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBlobError {
    /// Creates a new `GetBlobError`.
    pub fn new(kind: GetBlobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBlobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBlobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBlobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBlobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::BlobIdDoesNotExistException`.
    pub fn is_blob_id_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, GetBlobErrorKind::BlobIdDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::BlobIdRequiredException`.
    pub fn is_blob_id_required_exception(&self) -> bool {
        matches!(&self.kind, GetBlobErrorKind::BlobIdRequiredException(_))
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::FileTooLargeException`.
    pub fn is_file_too_large_exception(&self) -> bool {
        matches!(&self.kind, GetBlobErrorKind::FileTooLargeException(_))
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::InvalidBlobIdException`.
    pub fn is_invalid_blob_id_exception(&self) -> bool {
        matches!(&self.kind, GetBlobErrorKind::InvalidBlobIdException(_))
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlobErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlobErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetBlobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBlobErrorKind::BlobIdDoesNotExistException(_inner) => Some(_inner),
            GetBlobErrorKind::BlobIdRequiredException(_inner) => Some(_inner),
            GetBlobErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            GetBlobErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetBlobErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetBlobErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetBlobErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetBlobErrorKind::FileTooLargeException(_inner) => Some(_inner),
            GetBlobErrorKind::InvalidBlobIdException(_inner) => Some(_inner),
            GetBlobErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetBlobErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetBlobErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetBlobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBranchError {
    /// Kind of error that occurred.
    pub kind: GetBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBranchErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBranchErrorKind::BranchDoesNotExistException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBranchError {
    fn code(&self) -> Option<&str> {
        GetBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBranchError {
    /// Creates a new `GetBranchError`.
    pub fn new(kind: GetBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::BranchDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBranchErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBranchErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBranchErrorKind::BranchDoesNotExistException(_inner) => Some(_inner),
            GetBranchErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            GetBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            GetBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetBranchErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetBranchErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetBranchErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetBranchErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            GetBranchErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetBranchErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetBranchErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCommentError {
    /// Kind of error that occurred.
    pub kind: GetCommentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCommentErrorKind {
    /// <p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>
    CommentDeletedException(crate::error::CommentDeletedException),
    /// <p>No comment exists with the provided ID. Verify that you have used the correct ID, and
    /// then try again.</p>
    CommentDoesNotExistException(crate::error::CommentDoesNotExistException),
    /// <p>The comment ID is missing or null. A comment ID is required.</p>
    CommentIdRequiredException(crate::error::CommentIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
    InvalidCommentIdException(crate::error::InvalidCommentIdException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCommentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCommentErrorKind::CommentDeletedException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::CommentDoesNotExistException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::CommentIdRequiredException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::InvalidCommentIdException(_inner) => _inner.fmt(f),
            GetCommentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCommentError {
    fn code(&self) -> Option<&str> {
        GetCommentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCommentError {
    /// Creates a new `GetCommentError`.
    pub fn new(kind: GetCommentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCommentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCommentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCommentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCommentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::CommentDeletedException`.
    pub fn is_comment_deleted_exception(&self) -> bool {
        matches!(&self.kind, GetCommentErrorKind::CommentDeletedException(_))
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::CommentDoesNotExistException`.
    pub fn is_comment_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::CommentDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::CommentIdRequiredException`.
    pub fn is_comment_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::CommentIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentErrorKind::InvalidCommentIdException`.
    pub fn is_invalid_comment_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentErrorKind::InvalidCommentIdException(_)
        )
    }
}
impl std::error::Error for GetCommentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCommentErrorKind::CommentDeletedException(_inner) => Some(_inner),
            GetCommentErrorKind::CommentDoesNotExistException(_inner) => Some(_inner),
            GetCommentErrorKind::CommentIdRequiredException(_inner) => Some(_inner),
            GetCommentErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            GetCommentErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetCommentErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetCommentErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetCommentErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetCommentErrorKind::InvalidCommentIdException(_inner) => Some(_inner),
            GetCommentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCommentReactions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCommentReactionsError {
    /// Kind of error that occurred.
    pub kind: GetCommentReactionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCommentReactions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCommentReactionsErrorKind {
    /// <p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>
    CommentDeletedException(crate::error::CommentDeletedException),
    /// <p>No comment exists with the provided ID. Verify that you have used the correct ID, and
    /// then try again.</p>
    CommentDoesNotExistException(crate::error::CommentDoesNotExistException),
    /// <p>The comment ID is missing or null. A comment ID is required.</p>
    CommentIdRequiredException(crate::error::CommentIdRequiredException),
    /// <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
    InvalidCommentIdException(crate::error::InvalidCommentIdException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The Amazon Resource Name (ARN) of the user or identity is not valid.</p>
    InvalidReactionUserArnException(crate::error::InvalidReactionUserArnException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCommentReactionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCommentReactionsErrorKind::CommentDeletedException(_inner) => _inner.fmt(f),
            GetCommentReactionsErrorKind::CommentDoesNotExistException(_inner) => _inner.fmt(f),
            GetCommentReactionsErrorKind::CommentIdRequiredException(_inner) => _inner.fmt(f),
            GetCommentReactionsErrorKind::InvalidCommentIdException(_inner) => _inner.fmt(f),
            GetCommentReactionsErrorKind::InvalidContinuationTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentReactionsErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            GetCommentReactionsErrorKind::InvalidReactionUserArnException(_inner) => _inner.fmt(f),
            GetCommentReactionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCommentReactionsError {
    fn code(&self) -> Option<&str> {
        GetCommentReactionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCommentReactionsError {
    /// Creates a new `GetCommentReactionsError`.
    pub fn new(kind: GetCommentReactionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCommentReactionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCommentReactionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCommentReactionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCommentReactionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCommentReactionsErrorKind::CommentDeletedException`.
    pub fn is_comment_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentReactionsErrorKind::CommentDeletedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentReactionsErrorKind::CommentDoesNotExistException`.
    pub fn is_comment_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentReactionsErrorKind::CommentDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentReactionsErrorKind::CommentIdRequiredException`.
    pub fn is_comment_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentReactionsErrorKind::CommentIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentReactionsErrorKind::InvalidCommentIdException`.
    pub fn is_invalid_comment_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentReactionsErrorKind::InvalidCommentIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentReactionsErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentReactionsErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentReactionsErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentReactionsErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentReactionsErrorKind::InvalidReactionUserArnException`.
    pub fn is_invalid_reaction_user_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentReactionsErrorKind::InvalidReactionUserArnException(_)
        )
    }
}
impl std::error::Error for GetCommentReactionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCommentReactionsErrorKind::CommentDeletedException(_inner) => Some(_inner),
            GetCommentReactionsErrorKind::CommentDoesNotExistException(_inner) => Some(_inner),
            GetCommentReactionsErrorKind::CommentIdRequiredException(_inner) => Some(_inner),
            GetCommentReactionsErrorKind::InvalidCommentIdException(_inner) => Some(_inner),
            GetCommentReactionsErrorKind::InvalidContinuationTokenException(_inner) => Some(_inner),
            GetCommentReactionsErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            GetCommentReactionsErrorKind::InvalidReactionUserArnException(_inner) => Some(_inner),
            GetCommentReactionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCommentsForComparedCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCommentsForComparedCommitError {
    /// Kind of error that occurred.
    pub kind: GetCommentsForComparedCommitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCommentsForComparedCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCommentsForComparedCommitErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit ID was not specified.</p>
    CommitIdRequiredException(crate::error::CommitIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCommentsForComparedCommitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCommentsForComparedCommitErrorKind::CommitDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::CommitIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            GetCommentsForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::InvalidCommitIdException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::InvalidContinuationTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::InvalidMaxResultsException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForComparedCommitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCommentsForComparedCommitError {
    fn code(&self) -> Option<&str> {
        GetCommentsForComparedCommitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCommentsForComparedCommitError {
    /// Creates a new `GetCommentsForComparedCommitError`.
    pub fn new(kind: GetCommentsForComparedCommitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCommentsForComparedCommitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCommentsForComparedCommitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCommentsForComparedCommitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCommentsForComparedCommitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::CommitIdRequiredException`.
    pub fn is_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::CommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForComparedCommitErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForComparedCommitErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetCommentsForComparedCommitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCommentsForComparedCommitErrorKind::CommitDoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::CommitIdRequiredException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            GetCommentsForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::InvalidCommitIdException(_inner) => Some(_inner),
            GetCommentsForComparedCommitErrorKind::InvalidContinuationTokenException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::InvalidMaxResultsException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::InvalidRepositoryNameException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            GetCommentsForComparedCommitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCommentsForPullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCommentsForPullRequestError {
    /// Kind of error that occurred.
    pub kind: GetCommentsForPullRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCommentsForPullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCommentsForPullRequestErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit ID was not specified.</p>
    CommitIdRequiredException(crate::error::CommitIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request ID.</p>
    RepositoryNotAssociatedWithPullRequestException(
        crate::error::RepositoryNotAssociatedWithPullRequestException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCommentsForPullRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCommentsForPullRequestErrorKind::CommitDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::CommitIdRequiredException(_inner) => _inner.fmt(f),
            GetCommentsForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            GetCommentsForPullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::InvalidCommitIdException(_inner) => _inner.fmt(f),
            GetCommentsForPullRequestErrorKind::InvalidContinuationTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            GetCommentsForPullRequestErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetCommentsForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(
                _inner,
            ) => _inner.fmt(f),
            GetCommentsForPullRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCommentsForPullRequestError {
    fn code(&self) -> Option<&str> {
        GetCommentsForPullRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCommentsForPullRequestError {
    /// Creates a new `GetCommentsForPullRequestError`.
    pub fn new(kind: GetCommentsForPullRequestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCommentsForPullRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCommentsForPullRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCommentsForPullRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCommentsForPullRequestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::CommitIdRequiredException`.
    pub fn is_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::CommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommentsForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException`.
    pub fn is_repository_not_associated_with_pull_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommentsForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(_)
        )
    }
}
impl std::error::Error for GetCommentsForPullRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCommentsForPullRequestErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            GetCommentsForPullRequestErrorKind::CommitIdRequiredException(_inner) => Some(_inner),
            GetCommentsForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            GetCommentsForPullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::InvalidCommitIdException(_inner) => Some(_inner),
            GetCommentsForPullRequestErrorKind::InvalidContinuationTokenException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            GetCommentsForPullRequestErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::InvalidRepositoryNameException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            GetCommentsForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(
                _inner,
            ) => Some(_inner),
            GetCommentsForPullRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCommitError {
    /// Kind of error that occurred.
    pub kind: GetCommitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCommitErrorKind {
    /// <p>The specified commit ID does not exist.</p>
    CommitIdDoesNotExistException(crate::error::CommitIdDoesNotExistException),
    /// <p>A commit ID was not specified.</p>
    CommitIdRequiredException(crate::error::CommitIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCommitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCommitErrorKind::CommitIdDoesNotExistException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::CommitIdRequiredException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::InvalidCommitIdException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetCommitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCommitError {
    fn code(&self) -> Option<&str> {
        GetCommitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCommitError {
    /// Creates a new `GetCommitError`.
    pub fn new(kind: GetCommitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCommitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCommitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCommitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCommitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::CommitIdDoesNotExistException`.
    pub fn is_commit_id_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::CommitIdDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::CommitIdRequiredException`.
    pub fn is_commit_id_required_exception(&self) -> bool {
        matches!(&self.kind, GetCommitErrorKind::CommitIdRequiredException(_))
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(&self.kind, GetCommitErrorKind::InvalidCommitIdException(_))
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCommitErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCommitErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetCommitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCommitErrorKind::CommitIdDoesNotExistException(_inner) => Some(_inner),
            GetCommitErrorKind::CommitIdRequiredException(_inner) => Some(_inner),
            GetCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            GetCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetCommitErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetCommitErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetCommitErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetCommitErrorKind::InvalidCommitIdException(_inner) => Some(_inner),
            GetCommitErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetCommitErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetCommitErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetCommitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDifferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDifferencesError {
    /// Kind of error that occurred.
    pub kind: GetDifferencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDifferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDifferencesErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified path does not exist.</p>
    PathDoesNotExistException(crate::error::PathDoesNotExistException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDifferencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDifferencesErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            GetDifferencesErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::InvalidCommitIdException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::InvalidContinuationTokenException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::PathDoesNotExistException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetDifferencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDifferencesError {
    fn code(&self) -> Option<&str> {
        GetDifferencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDifferencesError {
    /// Creates a new `GetDifferencesError`.
    pub fn new(kind: GetDifferencesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDifferencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDifferencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDifferencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDifferencesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(&self.kind, GetDifferencesErrorKind::InvalidPathException(_))
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::PathDoesNotExistException`.
    pub fn is_path_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::PathDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDifferencesErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDifferencesErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetDifferencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDifferencesErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            GetDifferencesErrorKind::CommitRequiredException(_inner) => Some(_inner),
            GetDifferencesErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            GetDifferencesErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetDifferencesErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetDifferencesErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetDifferencesErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetDifferencesErrorKind::InvalidCommitException(_inner) => Some(_inner),
            GetDifferencesErrorKind::InvalidCommitIdException(_inner) => Some(_inner),
            GetDifferencesErrorKind::InvalidContinuationTokenException(_inner) => Some(_inner),
            GetDifferencesErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            GetDifferencesErrorKind::InvalidPathException(_inner) => Some(_inner),
            GetDifferencesErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetDifferencesErrorKind::PathDoesNotExistException(_inner) => Some(_inner),
            GetDifferencesErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetDifferencesErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetDifferencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFileError {
    /// Kind of error that occurred.
    pub kind: GetFileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFileErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified file does not exist. Verify that you have used the correct file name,
    /// full path, and extension.</p>
    FileDoesNotExistException(crate::error::FileDoesNotExistException),
    /// <p>The specified file exceeds the file size limit for AWS CodeCommit. For more information about limits in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User Guide</a>.</p>
    FileTooLargeException(crate::error::FileTooLargeException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFileErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            GetFileErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            GetFileErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetFileErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetFileErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetFileErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetFileErrorKind::FileDoesNotExistException(_inner) => _inner.fmt(f),
            GetFileErrorKind::FileTooLargeException(_inner) => _inner.fmt(f),
            GetFileErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            GetFileErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            GetFileErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetFileErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            GetFileErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetFileErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetFileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFileError {
    fn code(&self) -> Option<&str> {
        GetFileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFileError {
    /// Creates a new `GetFileError`.
    pub fn new(kind: GetFileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, GetFileErrorKind::CommitDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::FileDoesNotExistException`.
    pub fn is_file_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, GetFileErrorKind::FileDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::FileTooLargeException`.
    pub fn is_file_too_large_exception(&self) -> bool {
        matches!(&self.kind, GetFileErrorKind::FileTooLargeException(_))
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(&self.kind, GetFileErrorKind::InvalidCommitException(_))
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(&self.kind, GetFileErrorKind::InvalidPathException(_))
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(&self.kind, GetFileErrorKind::PathRequiredException(_))
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFileErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFileErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetFileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFileErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            GetFileErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            GetFileErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetFileErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetFileErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetFileErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetFileErrorKind::FileDoesNotExistException(_inner) => Some(_inner),
            GetFileErrorKind::FileTooLargeException(_inner) => Some(_inner),
            GetFileErrorKind::InvalidCommitException(_inner) => Some(_inner),
            GetFileErrorKind::InvalidPathException(_inner) => Some(_inner),
            GetFileErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetFileErrorKind::PathRequiredException(_inner) => Some(_inner),
            GetFileErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetFileErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetFileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFolderError {
    /// Kind of error that occurred.
    pub kind: GetFolderErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFolder` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFolderErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified folder does not exist. Either the folder name is not correct, or you did
    /// not enter the full path to the folder.</p>
    FolderDoesNotExistException(crate::error::FolderDoesNotExistException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFolderError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFolderErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::FolderDoesNotExistException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetFolderErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFolderError {
    fn code(&self) -> Option<&str> {
        GetFolderError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFolderError {
    /// Creates a new `GetFolderError`.
    pub fn new(kind: GetFolderErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFolderError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFolderErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFolderError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFolderErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::FolderDoesNotExistException`.
    pub fn is_folder_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::FolderDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(&self.kind, GetFolderErrorKind::InvalidCommitException(_))
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(&self.kind, GetFolderErrorKind::InvalidPathException(_))
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(&self.kind, GetFolderErrorKind::PathRequiredException(_))
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFolderErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFolderErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetFolderError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFolderErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            GetFolderErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            GetFolderErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetFolderErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetFolderErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetFolderErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetFolderErrorKind::FolderDoesNotExistException(_inner) => Some(_inner),
            GetFolderErrorKind::InvalidCommitException(_inner) => Some(_inner),
            GetFolderErrorKind::InvalidPathException(_inner) => Some(_inner),
            GetFolderErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetFolderErrorKind::PathRequiredException(_inner) => Some(_inner),
            GetFolderErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetFolderErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetFolderErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMergeCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMergeCommitError {
    /// Kind of error that occurred.
    pub kind: GetMergeCommitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMergeCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMergeCommitErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMergeCommitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMergeCommitErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::InvalidConflictDetailLevelException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeCommitErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetMergeCommitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMergeCommitError {
    fn code(&self) -> Option<&str> {
        GetMergeCommitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMergeCommitError {
    /// Creates a new `GetMergeCommitError`.
    pub fn new(kind: GetMergeCommitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMergeCommitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMergeCommitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMergeCommitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMergeCommitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeCommitErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeCommitErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetMergeCommitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMergeCommitErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::CommitRequiredException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            GetMergeCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::InvalidCommitException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::InvalidConflictDetailLevelException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                Some(_inner)
            }
            GetMergeCommitErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetMergeCommitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMergeConflicts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMergeConflictsError {
    /// Kind of error that occurred.
    pub kind: GetMergeConflictsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMergeConflicts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMergeConflictsErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The destination commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID. </p>
    InvalidDestinationCommitSpecifierException(
        crate::error::InvalidDestinationCommitSpecifierException,
    ),
    /// <p>The specified value for the number of conflict files to return is not valid.</p>
    InvalidMaxConflictFilesException(crate::error::InvalidMaxConflictFilesException),
    /// <p>The specified merge option is not valid for this operation. Not all merge strategies are supported for all operations.</p>
    InvalidMergeOptionException(crate::error::InvalidMergeOptionException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The source commit specifier is not valid. You must provide a valid branch name, tag, or full commit ID.</p>
    InvalidSourceCommitSpecifierException(crate::error::InvalidSourceCommitSpecifierException),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>A merge option or stategy is required, and none was provided.</p>
    MergeOptionRequiredException(crate::error::MergeOptionRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMergeConflictsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMergeConflictsErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::InvalidConflictDetailLevelException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeConflictsErrorKind::InvalidContinuationTokenException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::InvalidDestinationCommitSpecifierException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeConflictsErrorKind::InvalidMaxConflictFilesException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::InvalidMergeOptionException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::InvalidSourceCommitSpecifierException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeConflictsErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeConflictsErrorKind::MergeOptionRequiredException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::TipsDivergenceExceededException(_inner) => _inner.fmt(f),
            GetMergeConflictsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMergeConflictsError {
    fn code(&self) -> Option<&str> {
        GetMergeConflictsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMergeConflictsError {
    /// Creates a new `GetMergeConflictsError`.
    pub fn new(kind: GetMergeConflictsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMergeConflictsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMergeConflictsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMergeConflictsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMergeConflictsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidDestinationCommitSpecifierException`.
    pub fn is_invalid_destination_commit_specifier_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidDestinationCommitSpecifierException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidMaxConflictFilesException`.
    pub fn is_invalid_max_conflict_files_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidMaxConflictFilesException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidMergeOptionException`.
    pub fn is_invalid_merge_option_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidMergeOptionException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::InvalidSourceCommitSpecifierException`.
    pub fn is_invalid_source_commit_specifier_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::InvalidSourceCommitSpecifierException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::MergeOptionRequiredException`.
    pub fn is_merge_option_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::MergeOptionRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeConflictsErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeConflictsErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for GetMergeConflictsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMergeConflictsErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::CommitRequiredException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            GetMergeConflictsErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::InvalidCommitException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::InvalidConflictDetailLevelException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                Some(_inner)
            }
            GetMergeConflictsErrorKind::InvalidContinuationTokenException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::InvalidDestinationCommitSpecifierException(_inner) => {
                Some(_inner)
            }
            GetMergeConflictsErrorKind::InvalidMaxConflictFilesException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::InvalidMergeOptionException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::InvalidSourceCommitSpecifierException(_inner) => {
                Some(_inner)
            }
            GetMergeConflictsErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                Some(_inner)
            }
            GetMergeConflictsErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                Some(_inner)
            }
            GetMergeConflictsErrorKind::MergeOptionRequiredException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::TipsDivergenceExceededException(_inner) => Some(_inner),
            GetMergeConflictsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMergeOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMergeOptionsError {
    /// Kind of error that occurred.
    pub kind: GetMergeOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMergeOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMergeOptionsErrorKind {
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMergeOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMergeOptionsErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeOptionsErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::InvalidConflictDetailLevelException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeOptionsErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeOptionsErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetMergeOptionsErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::TipsDivergenceExceededException(_inner) => _inner.fmt(f),
            GetMergeOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMergeOptionsError {
    fn code(&self) -> Option<&str> {
        GetMergeOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMergeOptionsError {
    /// Creates a new `GetMergeOptionsError`.
    pub fn new(kind: GetMergeOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMergeOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMergeOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMergeOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMergeOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMergeOptionsErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMergeOptionsErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for GetMergeOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMergeOptionsErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::CommitRequiredException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            GetMergeOptionsErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::InvalidCommitException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::InvalidConflictDetailLevelException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                Some(_inner)
            }
            GetMergeOptionsErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                Some(_inner)
            }
            GetMergeOptionsErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                Some(_inner)
            }
            GetMergeOptionsErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::TipsDivergenceExceededException(_inner) => Some(_inner),
            GetMergeOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPullRequestError {
    /// Kind of error that occurred.
    pub kind: GetPullRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPullRequestErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPullRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPullRequestErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetPullRequestErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetPullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetPullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetPullRequestErrorKind::InvalidPullRequestIdException(_inner) => _inner.fmt(f),
            GetPullRequestErrorKind::PullRequestDoesNotExistException(_inner) => _inner.fmt(f),
            GetPullRequestErrorKind::PullRequestIdRequiredException(_inner) => _inner.fmt(f),
            GetPullRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPullRequestError {
    fn code(&self) -> Option<&str> {
        GetPullRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPullRequestError {
    /// Creates a new `GetPullRequestError`.
    pub fn new(kind: GetPullRequestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPullRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPullRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPullRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPullRequestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestErrorKind::PullRequestIdRequiredException(_)
        )
    }
}
impl std::error::Error for GetPullRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPullRequestErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            GetPullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetPullRequestErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetPullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetPullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetPullRequestErrorKind::InvalidPullRequestIdException(_inner) => Some(_inner),
            GetPullRequestErrorKind::PullRequestDoesNotExistException(_inner) => Some(_inner),
            GetPullRequestErrorKind::PullRequestIdRequiredException(_inner) => Some(_inner),
            GetPullRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPullRequestApprovalStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPullRequestApprovalStatesError {
    /// Kind of error that occurred.
    pub kind: GetPullRequestApprovalStatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPullRequestApprovalStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPullRequestApprovalStatesErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The revision ID is not valid. Use GetPullRequest to determine the value.</p>
    InvalidRevisionIdException(crate::error::InvalidRevisionIdException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>A revision ID is required, but was not provided.</p>
    RevisionIdRequiredException(crate::error::RevisionIdRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPullRequestApprovalStatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPullRequestApprovalStatesErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::InvalidRevisionIdException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::RevisionIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestApprovalStatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPullRequestApprovalStatesError {
    fn code(&self) -> Option<&str> {
        GetPullRequestApprovalStatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPullRequestApprovalStatesError {
    /// Creates a new `GetPullRequestApprovalStatesError`.
    pub fn new(kind: GetPullRequestApprovalStatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPullRequestApprovalStatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPullRequestApprovalStatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPullRequestApprovalStatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPullRequestApprovalStatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::InvalidRevisionIdException`.
    pub fn is_invalid_revision_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::InvalidRevisionIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestApprovalStatesErrorKind::RevisionIdRequiredException`.
    pub fn is_revision_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestApprovalStatesErrorKind::RevisionIdRequiredException(_)
        )
    }
}
impl std::error::Error for GetPullRequestApprovalStatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPullRequestApprovalStatesErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::InvalidRevisionIdException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::RevisionIdRequiredException(_inner) => {
                Some(_inner)
            }
            GetPullRequestApprovalStatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPullRequestOverrideState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPullRequestOverrideStateError {
    /// Kind of error that occurred.
    pub kind: GetPullRequestOverrideStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPullRequestOverrideState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPullRequestOverrideStateErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The revision ID is not valid. Use GetPullRequest to determine the value.</p>
    InvalidRevisionIdException(crate::error::InvalidRevisionIdException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>A revision ID is required, but was not provided.</p>
    RevisionIdRequiredException(crate::error::RevisionIdRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPullRequestOverrideStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPullRequestOverrideStateErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            GetPullRequestOverrideStateErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::InvalidRevisionIdException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::RevisionIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetPullRequestOverrideStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPullRequestOverrideStateError {
    fn code(&self) -> Option<&str> {
        GetPullRequestOverrideStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPullRequestOverrideStateError {
    /// Creates a new `GetPullRequestOverrideStateError`.
    pub fn new(kind: GetPullRequestOverrideStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPullRequestOverrideStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPullRequestOverrideStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPullRequestOverrideStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPullRequestOverrideStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::InvalidRevisionIdException`.
    pub fn is_invalid_revision_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::InvalidRevisionIdException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPullRequestOverrideStateErrorKind::RevisionIdRequiredException`.
    pub fn is_revision_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPullRequestOverrideStateErrorKind::RevisionIdRequiredException(_)
        )
    }
}
impl std::error::Error for GetPullRequestOverrideStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPullRequestOverrideStateErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            GetPullRequestOverrideStateErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::InvalidRevisionIdException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::RevisionIdRequiredException(_inner) => {
                Some(_inner)
            }
            GetPullRequestOverrideStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            GetRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryError {
    fn code(&self) -> Option<&str> {
        GetRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRepositoryError {
    /// Creates a new `GetRepositoryError`.
    pub fn new(kind: GetRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            GetRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            GetRepositoryErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            GetRepositoryErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetRepositoryErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetRepositoryErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepositoryTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryTriggersError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryTriggersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepositoryTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryTriggersErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryTriggersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            GetRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            GetRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryTriggersErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            GetRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryTriggersErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryTriggersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryTriggersError {
    fn code(&self) -> Option<&str> {
        GetRepositoryTriggersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRepositoryTriggersError {
    /// Creates a new `GetRepositoryTriggersError`.
    pub fn new(kind: GetRepositoryTriggersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryTriggersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryTriggersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryTriggersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryTriggersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryTriggersErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryTriggersErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for GetRepositoryTriggersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            GetRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            GetRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            GetRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            GetRepositoryTriggersErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            GetRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            GetRepositoryTriggersErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            GetRepositoryTriggersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApprovalRuleTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApprovalRuleTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListApprovalRuleTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApprovalRuleTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApprovalRuleTemplatesErrorKind {
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApprovalRuleTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApprovalRuleTemplatesErrorKind::InvalidContinuationTokenException(_inner) => {
                _inner.fmt(f)
            }
            ListApprovalRuleTemplatesErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            ListApprovalRuleTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApprovalRuleTemplatesError {
    fn code(&self) -> Option<&str> {
        ListApprovalRuleTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApprovalRuleTemplatesError {
    /// Creates a new `ListApprovalRuleTemplatesError`.
    pub fn new(kind: ListApprovalRuleTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApprovalRuleTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApprovalRuleTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApprovalRuleTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApprovalRuleTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApprovalRuleTemplatesErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApprovalRuleTemplatesErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApprovalRuleTemplatesErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApprovalRuleTemplatesErrorKind::InvalidMaxResultsException(_)
        )
    }
}
impl std::error::Error for ListApprovalRuleTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApprovalRuleTemplatesErrorKind::InvalidContinuationTokenException(_inner) => {
                Some(_inner)
            }
            ListApprovalRuleTemplatesErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            ListApprovalRuleTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociatedApprovalRuleTemplatesForRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociatedApprovalRuleTemplatesForRepositoryError {
    /// Kind of error that occurred.
    pub kind: ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociatedApprovalRuleTemplatesForRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociatedApprovalRuleTemplatesForRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidContinuationTokenException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidMaxResultsException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for ListAssociatedApprovalRuleTemplatesForRepositoryError
{
    fn code(&self) -> Option<&str> {
        ListAssociatedApprovalRuleTemplatesForRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociatedApprovalRuleTemplatesForRepositoryError {
    /// Creates a new `ListAssociatedApprovalRuleTemplatesForRepositoryError`.
    pub fn new(
        kind: ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociatedApprovalRuleTemplatesForRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociatedApprovalRuleTemplatesForRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyAccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyDisabledException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyUnavailableException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidContinuationTokenException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidMaxResultsException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidRepositoryNameException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(&self.kind, ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryNameRequiredException(_))
    }
}
impl std::error::Error for ListAssociatedApprovalRuleTemplatesForRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidContinuationTokenException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidMaxResultsException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            ListAssociatedApprovalRuleTemplatesForRepositoryErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListBranches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBranchesError {
    /// Kind of error that occurred.
    pub kind: ListBranchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBranches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBranchesErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBranchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBranchesErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            ListBranchesErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::InvalidContinuationTokenException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            ListBranchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBranchesError {
    fn code(&self) -> Option<&str> {
        ListBranchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBranchesError {
    /// Creates a new `ListBranchesError`.
    pub fn new(kind: ListBranchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBranchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBranchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBranchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBranchesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBranchesErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBranchesErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for ListBranchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBranchesErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            ListBranchesErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            ListBranchesErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            ListBranchesErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            ListBranchesErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            ListBranchesErrorKind::InvalidContinuationTokenException(_inner) => Some(_inner),
            ListBranchesErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            ListBranchesErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            ListBranchesErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            ListBranchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPullRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPullRequestsError {
    /// Kind of error that occurred.
    pub kind: ListPullRequestsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPullRequests` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPullRequestsErrorKind {
    /// <p>The specified Amazon Resource Name (ARN) does not exist in the AWS account.</p>
    AuthorDoesNotExistException(crate::error::AuthorDoesNotExistException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The Amazon Resource Name (ARN) is not valid. Make sure that you have provided the full ARN for the author of the pull request, and then try again.</p>
    InvalidAuthorArnException(crate::error::InvalidAuthorArnException),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// <p>The pull request status is not valid. The only valid values are <code>OPEN</code> and <code>CLOSED</code>.</p>
    InvalidPullRequestStatusException(crate::error::InvalidPullRequestStatusException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPullRequestsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPullRequestsErrorKind::AuthorDoesNotExistException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            ListPullRequestsErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::InvalidAuthorArnException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::InvalidContinuationTokenException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::InvalidMaxResultsException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::InvalidPullRequestStatusException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            ListPullRequestsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPullRequestsError {
    fn code(&self) -> Option<&str> {
        ListPullRequestsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPullRequestsError {
    /// Creates a new `ListPullRequestsError`.
    pub fn new(kind: ListPullRequestsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPullRequestsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPullRequestsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPullRequestsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPullRequestsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::AuthorDoesNotExistException`.
    pub fn is_author_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::AuthorDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::InvalidAuthorArnException`.
    pub fn is_invalid_author_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::InvalidAuthorArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::InvalidMaxResultsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::InvalidPullRequestStatusException`.
    pub fn is_invalid_pull_request_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::InvalidPullRequestStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPullRequestsErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPullRequestsErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for ListPullRequestsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPullRequestsErrorKind::AuthorDoesNotExistException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            ListPullRequestsErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::InvalidAuthorArnException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::InvalidContinuationTokenException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::InvalidMaxResultsException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::InvalidPullRequestStatusException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            ListPullRequestsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRepositoriesError {
    /// Kind of error that occurred.
    pub kind: ListRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRepositoriesErrorKind {
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified sort order is not valid.</p>
    InvalidOrderException(crate::error::InvalidOrderException),
    /// <p>The specified sort by value is not valid.</p>
    InvalidSortByException(crate::error::InvalidSortByException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRepositoriesErrorKind::InvalidContinuationTokenException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::InvalidOrderException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::InvalidSortByException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRepositoriesError {
    fn code(&self) -> Option<&str> {
        ListRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRepositoriesError {
    /// Creates a new `ListRepositoriesError`.
    pub fn new(kind: ListRepositoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRepositoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRepositoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::InvalidOrderException`.
    pub fn is_invalid_order_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::InvalidOrderException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::InvalidSortByException`.
    pub fn is_invalid_sort_by_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::InvalidSortByException(_)
        )
    }
}
impl std::error::Error for ListRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRepositoriesErrorKind::InvalidContinuationTokenException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::InvalidOrderException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::InvalidSortByException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRepositoriesForApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRepositoriesForApprovalRuleTemplateError {
    /// Kind of error that occurred.
    pub kind: ListRepositoriesForApprovalRuleTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRepositoriesForApprovalRuleTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRepositoriesForApprovalRuleTemplateErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>The specified continuation token is not valid.</p>
    InvalidContinuationTokenException(crate::error::InvalidContinuationTokenException),
    /// <p>The specified number of maximum results is not valid.</p>
    InvalidMaxResultsException(crate::error::InvalidMaxResultsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRepositoriesForApprovalRuleTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidContinuationTokenException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidMaxResultsException(_inner) =>
            _inner.fmt(f)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRepositoriesForApprovalRuleTemplateError {
    fn code(&self) -> Option<&str> {
        ListRepositoriesForApprovalRuleTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRepositoriesForApprovalRuleTemplateError {
    /// Creates a new `ListRepositoriesForApprovalRuleTemplateError`.
    pub fn new(
        kind: ListRepositoriesForApprovalRuleTemplateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRepositoriesForApprovalRuleTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRepositoriesForApprovalRuleTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRepositoriesForApprovalRuleTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRepositoriesForApprovalRuleTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(&self.kind, ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_))
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(&self.kind, ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionIntegrityChecksFailedException(_))
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(&self.kind, ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_))
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidContinuationTokenException`.
    pub fn is_invalid_continuation_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidContinuationTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidMaxResultsException`.
    pub fn is_invalid_max_results_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidMaxResultsException(_)
        )
    }
}
impl std::error::Error for ListRepositoriesForApprovalRuleTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidContinuationTokenException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::InvalidMaxResultsException(_inner) =>
            Some(_inner)
            ,
            ListRepositoriesForApprovalRuleTemplateErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a>
    /// in the AWS CodeCommit User Guide.</p>
    InvalidResourceArnException(crate::error::InvalidResourceArnException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid resources in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a>
    /// in the AWS CodeCommit User Guide.</p>
    ResourceArnRequiredException(crate::error::ResourceArnRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidResourceArnException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceArnRequiredException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidResourceArnException`.
    pub fn is_invalid_resource_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidResourceArnException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceArnRequiredException`.
    pub fn is_resource_arn_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceArnRequiredException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidResourceArnException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceArnRequiredException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MergeBranchesByFastForward` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergeBranchesByFastForwardError {
    /// Kind of error that occurred.
    pub kind: MergeBranchesByFastForwardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergeBranchesByFastForward` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergeBranchesByFastForwardErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>The specified branch name is not valid because it is a tag name. Enter the name of a
    /// branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</p>
    BranchNameIsTagNameException(crate::error::BranchNameIsTagNameException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified target branch is not valid.</p>
    InvalidTargetBranchException(crate::error::InvalidTargetBranchException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergeBranchesByFastForwardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergeBranchesByFastForwardErrorKind::BranchDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::BranchNameIsTagNameException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::BranchNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::CommitDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesByFastForwardErrorKind::ConcurrentReferenceUpdateException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            MergeBranchesByFastForwardErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::InvalidBranchNameException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            MergeBranchesByFastForwardErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::InvalidTargetBranchException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::ManualMergeRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::TipsDivergenceExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByFastForwardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergeBranchesByFastForwardError {
    fn code(&self) -> Option<&str> {
        MergeBranchesByFastForwardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergeBranchesByFastForwardError {
    /// Creates a new `MergeBranchesByFastForwardError`.
    pub fn new(kind: MergeBranchesByFastForwardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergeBranchesByFastForwardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergeBranchesByFastForwardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergeBranchesByFastForwardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergeBranchesByFastForwardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::BranchDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::BranchNameIsTagNameException`.
    pub fn is_branch_name_is_tag_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::BranchNameIsTagNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::ConcurrentReferenceUpdateException`.
    pub fn is_concurrent_reference_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::ConcurrentReferenceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::InvalidTargetBranchException`.
    pub fn is_invalid_target_branch_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::InvalidTargetBranchException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::ManualMergeRequiredException`.
    pub fn is_manual_merge_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::ManualMergeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByFastForwardErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByFastForwardErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for MergeBranchesByFastForwardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergeBranchesByFastForwardErrorKind::BranchDoesNotExistException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::BranchNameIsTagNameException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::BranchNameRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::CommitDoesNotExistException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::CommitRequiredException(_inner) => Some(_inner),
            MergeBranchesByFastForwardErrorKind::ConcurrentReferenceUpdateException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            MergeBranchesByFastForwardErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            MergeBranchesByFastForwardErrorKind::InvalidCommitException(_inner) => Some(_inner),
            MergeBranchesByFastForwardErrorKind::InvalidRepositoryNameException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::InvalidTargetBranchException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::ManualMergeRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::TipsDivergenceExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByFastForwardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MergeBranchesBySquash` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergeBranchesBySquashError {
    /// Kind of error that occurred.
    pub kind: MergeBranchesBySquashErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergeBranchesBySquash` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergeBranchesBySquashErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>The specified branch name is not valid because it is a tag name. Enter the name of a
    /// branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</p>
    BranchNameIsTagNameException(crate::error::BranchNameIsTagNameException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and
    /// the combined file content change size is 7 MB. Consider making these changes using a Git
    /// client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>The commit cannot be created because no file mode has been specified. A file mode is
    /// required to update mode permissions for a file.</p>
    FileModeRequiredException(crate::error::FileModeRequiredException),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a
    /// folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes,
    /// or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution list is not valid.</p>
    InvalidConflictResolutionException(crate::error::InvalidConflictResolutionException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>Automerge was specified for resolving the conflict, but the replacement type is not valid or content is missing. </p>
    InvalidReplacementContentException(crate::error::InvalidReplacementContentException),
    /// <p>Automerge was specified for resolving the conflict, but the specified replacement type is not valid.</p>
    InvalidReplacementTypeException(crate::error::InvalidReplacementTypeException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified target branch is not valid.</p>
    InvalidTargetBranchException(crate::error::InvalidTargetBranchException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The number of allowed conflict resolution entries was exceeded.</p>
    MaximumConflictResolutionEntriesExceededException(
        crate::error::MaximumConflictResolutionEntriesExceededException,
    ),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict resolution entry.</p>
    MultipleConflictResolutionEntriesException(
        crate::error::MultipleConflictResolutionEntriesException,
    ),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>USE_NEW_CONTENT was specified, but no replacement content has been provided.</p>
    ReplacementContentRequiredException(crate::error::ReplacementContentRequiredException),
    /// <p>A replacement type is required.</p>
    ReplacementTypeRequiredException(crate::error::ReplacementTypeRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergeBranchesBySquashError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergeBranchesBySquashErrorKind::BranchDoesNotExistException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::BranchNameIsTagNameException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::CommitMessageLengthExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::ConcurrentReferenceUpdateException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::FileContentSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::FileModeRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::FolderContentSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::InvalidConflictDetailLevelException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::InvalidConflictResolutionException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::InvalidEmailException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::InvalidFileModeException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::InvalidReplacementContentException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::InvalidReplacementTypeException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::InvalidTargetBranchException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::ManualMergeRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(
                _inner,
            ) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::MultipleConflictResolutionEntriesException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::NameLengthExceededException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesBySquashErrorKind::ReplacementContentRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::ReplacementTypeRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::TipsDivergenceExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesBySquashErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergeBranchesBySquashError {
    fn code(&self) -> Option<&str> {
        MergeBranchesBySquashError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergeBranchesBySquashError {
    /// Creates a new `MergeBranchesBySquashError`.
    pub fn new(kind: MergeBranchesBySquashErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergeBranchesBySquashError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergeBranchesBySquashErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergeBranchesBySquashError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergeBranchesBySquashErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::BranchDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::BranchNameIsTagNameException`.
    pub fn is_branch_name_is_tag_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::BranchNameIsTagNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::ConcurrentReferenceUpdateException`.
    pub fn is_concurrent_reference_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::ConcurrentReferenceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::FileContentSizeLimitExceededException`.
    pub fn is_file_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::FileContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::FileModeRequiredException`.
    pub fn is_file_mode_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::FileModeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::FolderContentSizeLimitExceededException`.
    pub fn is_folder_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::FolderContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidConflictResolutionException`.
    pub fn is_invalid_conflict_resolution_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidConflictResolutionException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidEmailException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidFileModeException`.
    pub fn is_invalid_file_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidFileModeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidReplacementContentException`.
    pub fn is_invalid_replacement_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidReplacementContentException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidReplacementTypeException`.
    pub fn is_invalid_replacement_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidReplacementTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::InvalidTargetBranchException`.
    pub fn is_invalid_target_branch_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::InvalidTargetBranchException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::ManualMergeRequiredException`.
    pub fn is_manual_merge_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::ManualMergeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::MaximumConflictResolutionEntriesExceededException`.
    pub fn is_maximum_conflict_resolution_entries_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::MultipleConflictResolutionEntriesException`.
    pub fn is_multiple_conflict_resolution_entries_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::MultipleConflictResolutionEntriesException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::NameLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::ReplacementContentRequiredException`.
    pub fn is_replacement_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::ReplacementContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::ReplacementTypeRequiredException`.
    pub fn is_replacement_type_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::ReplacementTypeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesBySquashErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesBySquashErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for MergeBranchesBySquashError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergeBranchesBySquashErrorKind::BranchDoesNotExistException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::BranchNameIsTagNameException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::CommitMessageLengthExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::CommitRequiredException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::ConcurrentReferenceUpdateException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::FileContentSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::FileModeRequiredException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::FolderContentSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::InvalidCommitException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::InvalidConflictDetailLevelException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::InvalidConflictResolutionException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::InvalidConflictResolutionStrategyException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::InvalidEmailException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::InvalidFileModeException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::InvalidPathException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::InvalidReplacementContentException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::InvalidReplacementTypeException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::InvalidTargetBranchException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::ManualMergeRequiredException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(
                _inner,
            ) => Some(_inner),
            MergeBranchesBySquashErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::MultipleConflictResolutionEntriesException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::NameLengthExceededException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::PathRequiredException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::ReplacementContentRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::ReplacementTypeRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesBySquashErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::TipsDivergenceExceededException(_inner) => Some(_inner),
            MergeBranchesBySquashErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MergeBranchesByThreeWay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergeBranchesByThreeWayError {
    /// Kind of error that occurred.
    pub kind: MergeBranchesByThreeWayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergeBranchesByThreeWay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergeBranchesByThreeWayErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>The specified branch name is not valid because it is a tag name. Enter the name of a
    /// branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</p>
    BranchNameIsTagNameException(crate::error::BranchNameIsTagNameException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>A commit was not specified.</p>
    CommitRequiredException(crate::error::CommitRequiredException),
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and
    /// the combined file content change size is 7 MB. Consider making these changes using a Git
    /// client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>The commit cannot be created because no file mode has been specified. A file mode is
    /// required to update mode permissions for a file.</p>
    FileModeRequiredException(crate::error::FileModeRequiredException),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a
    /// folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes,
    /// or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The specified commit is not valid.</p>
    InvalidCommitException(crate::error::InvalidCommitException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution list is not valid.</p>
    InvalidConflictResolutionException(crate::error::InvalidConflictResolutionException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>Automerge was specified for resolving the conflict, but the replacement type is not valid or content is missing. </p>
    InvalidReplacementContentException(crate::error::InvalidReplacementContentException),
    /// <p>Automerge was specified for resolving the conflict, but the specified replacement type is not valid.</p>
    InvalidReplacementTypeException(crate::error::InvalidReplacementTypeException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified target branch is not valid.</p>
    InvalidTargetBranchException(crate::error::InvalidTargetBranchException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The number of allowed conflict resolution entries was exceeded.</p>
    MaximumConflictResolutionEntriesExceededException(
        crate::error::MaximumConflictResolutionEntriesExceededException,
    ),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict resolution entry.</p>
    MultipleConflictResolutionEntriesException(
        crate::error::MultipleConflictResolutionEntriesException,
    ),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>USE_NEW_CONTENT was specified, but no replacement content has been provided.</p>
    ReplacementContentRequiredException(crate::error::ReplacementContentRequiredException),
    /// <p>A replacement type is required.</p>
    ReplacementTypeRequiredException(crate::error::ReplacementTypeRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergeBranchesByThreeWayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergeBranchesByThreeWayErrorKind::BranchDoesNotExistException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::BranchNameIsTagNameException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::CommitDoesNotExistException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::CommitMessageLengthExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::CommitRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::ConcurrentReferenceUpdateException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::FileContentSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::FileModeRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::FolderContentSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::InvalidCommitException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::InvalidConflictDetailLevelException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionStrategyException(
                _inner,
            ) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::InvalidEmailException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::InvalidFileModeException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::InvalidReplacementContentException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::InvalidReplacementTypeException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::InvalidTargetBranchException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::ManualMergeRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(
                _inner,
            ) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::MultipleConflictResolutionEntriesException(
                _inner,
            ) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::NameLengthExceededException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            MergeBranchesByThreeWayErrorKind::ReplacementContentRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::ReplacementTypeRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::TipsDivergenceExceededException(_inner) => {
                _inner.fmt(f)
            }
            MergeBranchesByThreeWayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergeBranchesByThreeWayError {
    fn code(&self) -> Option<&str> {
        MergeBranchesByThreeWayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergeBranchesByThreeWayError {
    /// Creates a new `MergeBranchesByThreeWayError`.
    pub fn new(kind: MergeBranchesByThreeWayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergeBranchesByThreeWayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergeBranchesByThreeWayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergeBranchesByThreeWayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergeBranchesByThreeWayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::BranchDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::BranchNameIsTagNameException`.
    pub fn is_branch_name_is_tag_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::BranchNameIsTagNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::CommitRequiredException`.
    pub fn is_commit_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::CommitRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::ConcurrentReferenceUpdateException`.
    pub fn is_concurrent_reference_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::ConcurrentReferenceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::FileContentSizeLimitExceededException`.
    pub fn is_file_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::FileContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::FileModeRequiredException`.
    pub fn is_file_mode_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::FileModeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::FolderContentSizeLimitExceededException`.
    pub fn is_folder_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::FolderContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidCommitException`.
    pub fn is_invalid_commit_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidCommitException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionException`.
    pub fn is_invalid_conflict_resolution_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidEmailException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidFileModeException`.
    pub fn is_invalid_file_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidFileModeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidReplacementContentException`.
    pub fn is_invalid_replacement_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidReplacementContentException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidReplacementTypeException`.
    pub fn is_invalid_replacement_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidReplacementTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::InvalidTargetBranchException`.
    pub fn is_invalid_target_branch_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::InvalidTargetBranchException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::ManualMergeRequiredException`.
    pub fn is_manual_merge_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::ManualMergeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException`.
    pub fn is_maximum_conflict_resolution_entries_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::MultipleConflictResolutionEntriesException`.
    pub fn is_multiple_conflict_resolution_entries_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::MultipleConflictResolutionEntriesException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::NameLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::ReplacementContentRequiredException`.
    pub fn is_replacement_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::ReplacementContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::ReplacementTypeRequiredException`.
    pub fn is_replacement_type_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::ReplacementTypeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergeBranchesByThreeWayErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeBranchesByThreeWayErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for MergeBranchesByThreeWayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergeBranchesByThreeWayErrorKind::BranchDoesNotExistException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::BranchNameIsTagNameException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::CommitMessageLengthExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::CommitRequiredException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::ConcurrentReferenceUpdateException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::FileContentSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::FileModeRequiredException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::FolderContentSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::InvalidCommitException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::InvalidConflictDetailLevelException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::InvalidConflictResolutionStrategyException(
                _inner,
            ) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::InvalidEmailException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::InvalidFileModeException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::InvalidPathException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::InvalidReplacementContentException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::InvalidReplacementTypeException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::InvalidRepositoryNameException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::InvalidTargetBranchException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::ManualMergeRequiredException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(
                _inner,
            ) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::MaximumFileContentToLoadExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::MaximumItemsToCompareExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::MultipleConflictResolutionEntriesException(
                _inner,
            ) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::NameLengthExceededException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::PathRequiredException(_inner) => Some(_inner),
            MergeBranchesByThreeWayErrorKind::ReplacementContentRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::ReplacementTypeRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::TipsDivergenceExceededException(_inner) => {
                Some(_inner)
            }
            MergeBranchesByThreeWayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MergePullRequestByFastForward` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergePullRequestByFastForwardError {
    /// Kind of error that occurred.
    pub kind: MergePullRequestByFastForwardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergePullRequestByFastForward` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergePullRequestByFastForwardErrorKind {
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request cannot be merged because one or more approval rules applied to the pull request have conditions that have not been met.</p>
    PullRequestApprovalRulesNotSatisfiedException(
        crate::error::PullRequestApprovalRulesNotSatisfiedException,
    ),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>The specified reference does not exist. You must provide a full commit ID.</p>
    ReferenceDoesNotExistException(crate::error::ReferenceDoesNotExistException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request ID.</p>
    RepositoryNotAssociatedWithPullRequestException(
        crate::error::RepositoryNotAssociatedWithPullRequestException,
    ),
    /// <p>The tip of the source branch in the destination repository does not match the tip of the source branch specified in your request.
    /// The pull request might have been updated. Make sure that you have the latest changes.</p>
    TipOfSourceReferenceIsDifferentException(
        crate::error::TipOfSourceReferenceIsDifferentException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergePullRequestByFastForwardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergePullRequestByFastForwardErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::InvalidCommitIdException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::InvalidPullRequestIdException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::ManualMergeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestAlreadyClosedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestApprovalRulesNotSatisfiedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::ReferenceDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::RepositoryNotAssociatedWithPullRequestException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::TipOfSourceReferenceIsDifferentException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByFastForwardErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergePullRequestByFastForwardError {
    fn code(&self) -> Option<&str> {
        MergePullRequestByFastForwardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergePullRequestByFastForwardError {
    /// Creates a new `MergePullRequestByFastForwardError`.
    pub fn new(
        kind: MergePullRequestByFastForwardErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergePullRequestByFastForwardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergePullRequestByFastForwardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergePullRequestByFastForwardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergePullRequestByFastForwardErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::ConcurrentReferenceUpdateException`.
    pub fn is_concurrent_reference_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::ConcurrentReferenceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::ManualMergeRequiredException`.
    pub fn is_manual_merge_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::ManualMergeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::PullRequestApprovalRulesNotSatisfiedException`.
    pub fn is_pull_request_approval_rules_not_satisfied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::PullRequestApprovalRulesNotSatisfiedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::ReferenceDoesNotExistException`.
    pub fn is_reference_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::ReferenceDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::RepositoryNotAssociatedWithPullRequestException`.
    pub fn is_repository_not_associated_with_pull_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::RepositoryNotAssociatedWithPullRequestException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByFastForwardErrorKind::TipOfSourceReferenceIsDifferentException`.
    pub fn is_tip_of_source_reference_is_different_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByFastForwardErrorKind::TipOfSourceReferenceIsDifferentException(_)
        )
    }
}
impl std::error::Error for MergePullRequestByFastForwardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergePullRequestByFastForwardErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::InvalidCommitIdException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::InvalidPullRequestIdException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::ManualMergeRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestAlreadyClosedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestApprovalRulesNotSatisfiedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::PullRequestIdRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::ReferenceDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::RepositoryNotAssociatedWithPullRequestException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::TipOfSourceReferenceIsDifferentException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByFastForwardErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `MergePullRequestBySquash` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergePullRequestBySquashError {
    /// Kind of error that occurred.
    pub kind: MergePullRequestBySquashErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergePullRequestBySquash` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergePullRequestBySquashErrorKind {
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and
    /// the combined file content change size is 7 MB. Consider making these changes using a Git
    /// client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a
    /// folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes,
    /// or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution list is not valid.</p>
    InvalidConflictResolutionException(crate::error::InvalidConflictResolutionException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>Automerge was specified for resolving the conflict, but the replacement type is not valid or content is missing. </p>
    InvalidReplacementContentException(crate::error::InvalidReplacementContentException),
    /// <p>Automerge was specified for resolving the conflict, but the specified replacement type is not valid.</p>
    InvalidReplacementTypeException(crate::error::InvalidReplacementTypeException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The number of allowed conflict resolution entries was exceeded.</p>
    MaximumConflictResolutionEntriesExceededException(
        crate::error::MaximumConflictResolutionEntriesExceededException,
    ),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict resolution entry.</p>
    MultipleConflictResolutionEntriesException(
        crate::error::MultipleConflictResolutionEntriesException,
    ),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request cannot be merged because one or more approval rules applied to the pull request have conditions that have not been met.</p>
    PullRequestApprovalRulesNotSatisfiedException(
        crate::error::PullRequestApprovalRulesNotSatisfiedException,
    ),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>USE_NEW_CONTENT was specified, but no replacement content has been provided.</p>
    ReplacementContentRequiredException(crate::error::ReplacementContentRequiredException),
    /// <p>A replacement type is required.</p>
    ReplacementTypeRequiredException(crate::error::ReplacementTypeRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request ID.</p>
    RepositoryNotAssociatedWithPullRequestException(
        crate::error::RepositoryNotAssociatedWithPullRequestException,
    ),
    /// <p>The tip of the source branch in the destination repository does not match the tip of the source branch specified in your request.
    /// The pull request might have been updated. Make sure that you have the latest changes.</p>
    TipOfSourceReferenceIsDifferentException(
        crate::error::TipOfSourceReferenceIsDifferentException,
    ),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergePullRequestBySquashError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergePullRequestBySquashErrorKind::CommitMessageLengthExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::FileContentSizeLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::FolderContentSizeLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidCommitIdException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidConflictDetailLevelException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidConflictResolutionException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidConflictResolutionStrategyException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidEmailException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidFileModeException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidPathException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidPullRequestIdException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidReplacementContentException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidReplacementTypeException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::ManualMergeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::MaximumFileContentToLoadExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::MaximumItemsToCompareExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::MultipleConflictResolutionEntriesException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::NameLengthExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::PathRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::PullRequestAlreadyClosedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::PullRequestApprovalRulesNotSatisfiedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::PullRequestDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::PullRequestIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::ReplacementContentRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::ReplacementTypeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::RepositoryNotAssociatedWithPullRequestException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::TipOfSourceReferenceIsDifferentException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::TipsDivergenceExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestBySquashErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergePullRequestBySquashError {
    fn code(&self) -> Option<&str> {
        MergePullRequestBySquashError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergePullRequestBySquashError {
    /// Creates a new `MergePullRequestBySquashError`.
    pub fn new(kind: MergePullRequestBySquashErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergePullRequestBySquashError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergePullRequestBySquashErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergePullRequestBySquashError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergePullRequestBySquashErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::ConcurrentReferenceUpdateException`.
    pub fn is_concurrent_reference_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::ConcurrentReferenceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::FileContentSizeLimitExceededException`.
    pub fn is_file_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::FileContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::FolderContentSizeLimitExceededException`.
    pub fn is_folder_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::FolderContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidConflictResolutionException`.
    pub fn is_invalid_conflict_resolution_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidConflictResolutionException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidEmailException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidFileModeException`.
    pub fn is_invalid_file_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidFileModeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidReplacementContentException`.
    pub fn is_invalid_replacement_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidReplacementContentException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidReplacementTypeException`.
    pub fn is_invalid_replacement_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidReplacementTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::ManualMergeRequiredException`.
    pub fn is_manual_merge_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::ManualMergeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::MaximumConflictResolutionEntriesExceededException`.
    pub fn is_maximum_conflict_resolution_entries_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::MultipleConflictResolutionEntriesException`.
    pub fn is_multiple_conflict_resolution_entries_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::MultipleConflictResolutionEntriesException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::NameLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::PullRequestApprovalRulesNotSatisfiedException`.
    pub fn is_pull_request_approval_rules_not_satisfied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::PullRequestApprovalRulesNotSatisfiedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::ReplacementContentRequiredException`.
    pub fn is_replacement_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::ReplacementContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::ReplacementTypeRequiredException`.
    pub fn is_replacement_type_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::ReplacementTypeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::RepositoryNotAssociatedWithPullRequestException`.
    pub fn is_repository_not_associated_with_pull_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::RepositoryNotAssociatedWithPullRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::TipOfSourceReferenceIsDifferentException`.
    pub fn is_tip_of_source_reference_is_different_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::TipOfSourceReferenceIsDifferentException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestBySquashErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestBySquashErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for MergePullRequestBySquashError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergePullRequestBySquashErrorKind::CommitMessageLengthExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::FileContentSizeLimitExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::FolderContentSizeLimitExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidCommitIdException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidConflictDetailLevelException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidConflictResolutionException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidConflictResolutionStrategyException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidEmailException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidFileModeException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidPathException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidPullRequestIdException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidReplacementContentException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidReplacementTypeException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::ManualMergeRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::MaximumConflictResolutionEntriesExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::MaximumFileContentToLoadExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::MaximumItemsToCompareExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::MultipleConflictResolutionEntriesException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::NameLengthExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::PathRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::PullRequestAlreadyClosedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::PullRequestApprovalRulesNotSatisfiedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::PullRequestDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::PullRequestIdRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::ReplacementContentRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::ReplacementTypeRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::RepositoryNotAssociatedWithPullRequestException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::TipOfSourceReferenceIsDifferentException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::TipsDivergenceExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestBySquashErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `MergePullRequestByThreeWay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergePullRequestByThreeWayError {
    /// Kind of error that occurred.
    pub kind: MergePullRequestByThreeWayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergePullRequestByThreeWay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergePullRequestByThreeWayErrorKind {
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>The merge cannot be completed because the target branch has been modified. Another user might have modified the target branch while the merge was in progress. Wait a few minutes, and then try again.</p>
    ConcurrentReferenceUpdateException(crate::error::ConcurrentReferenceUpdateException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and
    /// the combined file content change size is 7 MB. Consider making these changes using a Git
    /// client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a
    /// folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes,
    /// or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The specified conflict detail level is not valid.</p>
    InvalidConflictDetailLevelException(crate::error::InvalidConflictDetailLevelException),
    /// <p>The specified conflict resolution list is not valid.</p>
    InvalidConflictResolutionException(crate::error::InvalidConflictResolutionException),
    /// <p>The specified conflict resolution strategy is not valid.</p>
    InvalidConflictResolutionStrategyException(
        crate::error::InvalidConflictResolutionStrategyException,
    ),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>Automerge was specified for resolving the conflict, but the replacement type is not valid or content is missing. </p>
    InvalidReplacementContentException(crate::error::InvalidReplacementContentException),
    /// <p>Automerge was specified for resolving the conflict, but the specified replacement type is not valid.</p>
    InvalidReplacementTypeException(crate::error::InvalidReplacementTypeException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The pull request cannot be merged automatically into the destination branch. You must manually merge the branches and resolve any conflicts.</p>
    ManualMergeRequiredException(crate::error::ManualMergeRequiredException),
    /// <p>The number of allowed conflict resolution entries was exceeded.</p>
    MaximumConflictResolutionEntriesExceededException(
        crate::error::MaximumConflictResolutionEntriesExceededException,
    ),
    /// <p>The number of files to load exceeds the allowed limit.</p>
    MaximumFileContentToLoadExceededException(
        crate::error::MaximumFileContentToLoadExceededException,
    ),
    /// <p>The number of items to compare between the source or destination branches and the merge base has exceeded the maximum allowed.</p>
    MaximumItemsToCompareExceededException(crate::error::MaximumItemsToCompareExceededException),
    /// <p>More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict resolution entry.</p>
    MultipleConflictResolutionEntriesException(
        crate::error::MultipleConflictResolutionEntriesException,
    ),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request cannot be merged because one or more approval rules applied to the pull request have conditions that have not been met.</p>
    PullRequestApprovalRulesNotSatisfiedException(
        crate::error::PullRequestApprovalRulesNotSatisfiedException,
    ),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>USE_NEW_CONTENT was specified, but no replacement content has been provided.</p>
    ReplacementContentRequiredException(crate::error::ReplacementContentRequiredException),
    /// <p>A replacement type is required.</p>
    ReplacementTypeRequiredException(crate::error::ReplacementTypeRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request ID.</p>
    RepositoryNotAssociatedWithPullRequestException(
        crate::error::RepositoryNotAssociatedWithPullRequestException,
    ),
    /// <p>The tip of the source branch in the destination repository does not match the tip of the source branch specified in your request.
    /// The pull request might have been updated. Make sure that you have the latest changes.</p>
    TipOfSourceReferenceIsDifferentException(
        crate::error::TipOfSourceReferenceIsDifferentException,
    ),
    /// <p>The divergence between the tips of the provided commit specifiers is too great to determine whether there might be
    /// any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.</p>
    TipsDivergenceExceededException(crate::error::TipsDivergenceExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergePullRequestByThreeWayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergePullRequestByThreeWayErrorKind::CommitMessageLengthExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::FileContentSizeLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::FolderContentSizeLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidCommitIdException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidConflictDetailLevelException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionStrategyException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidEmailException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidFileModeException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidPathException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidPullRequestIdException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidReplacementContentException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidReplacementTypeException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::ManualMergeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::MaximumFileContentToLoadExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::MaximumItemsToCompareExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::MultipleConflictResolutionEntriesException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::NameLengthExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::PathRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestAlreadyClosedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestApprovalRulesNotSatisfiedException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::ReplacementContentRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::ReplacementTypeRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::RepositoryNotAssociatedWithPullRequestException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::TipOfSourceReferenceIsDifferentException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::TipsDivergenceExceededException(_inner) =>
            _inner.fmt(f)
            ,
            MergePullRequestByThreeWayErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergePullRequestByThreeWayError {
    fn code(&self) -> Option<&str> {
        MergePullRequestByThreeWayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergePullRequestByThreeWayError {
    /// Creates a new `MergePullRequestByThreeWayError`.
    pub fn new(kind: MergePullRequestByThreeWayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergePullRequestByThreeWayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergePullRequestByThreeWayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergePullRequestByThreeWayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergePullRequestByThreeWayErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::ConcurrentReferenceUpdateException`.
    pub fn is_concurrent_reference_update_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::ConcurrentReferenceUpdateException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::FileContentSizeLimitExceededException`.
    pub fn is_file_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::FileContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::FolderContentSizeLimitExceededException`.
    pub fn is_folder_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::FolderContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidConflictDetailLevelException`.
    pub fn is_invalid_conflict_detail_level_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidConflictDetailLevelException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionException`.
    pub fn is_invalid_conflict_resolution_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionStrategyException`.
    pub fn is_invalid_conflict_resolution_strategy_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionStrategyException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidEmailException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidFileModeException`.
    pub fn is_invalid_file_mode_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidFileModeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidReplacementContentException`.
    pub fn is_invalid_replacement_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidReplacementContentException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidReplacementTypeException`.
    pub fn is_invalid_replacement_type_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidReplacementTypeException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::ManualMergeRequiredException`.
    pub fn is_manual_merge_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::ManualMergeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException`.
    pub fn is_maximum_conflict_resolution_entries_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::MaximumFileContentToLoadExceededException`.
    pub fn is_maximum_file_content_to_load_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::MaximumFileContentToLoadExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::MaximumItemsToCompareExceededException`.
    pub fn is_maximum_items_to_compare_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::MaximumItemsToCompareExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::MultipleConflictResolutionEntriesException`.
    pub fn is_multiple_conflict_resolution_entries_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::MultipleConflictResolutionEntriesException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::NameLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::PullRequestApprovalRulesNotSatisfiedException`.
    pub fn is_pull_request_approval_rules_not_satisfied_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::PullRequestApprovalRulesNotSatisfiedException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::ReplacementContentRequiredException`.
    pub fn is_replacement_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::ReplacementContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::ReplacementTypeRequiredException`.
    pub fn is_replacement_type_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::ReplacementTypeRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::RepositoryNotAssociatedWithPullRequestException`.
    pub fn is_repository_not_associated_with_pull_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::RepositoryNotAssociatedWithPullRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::TipOfSourceReferenceIsDifferentException`.
    pub fn is_tip_of_source_reference_is_different_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::TipOfSourceReferenceIsDifferentException(_)
        )
    }
    /// Returns `true` if the error kind is `MergePullRequestByThreeWayErrorKind::TipsDivergenceExceededException`.
    pub fn is_tips_divergence_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergePullRequestByThreeWayErrorKind::TipsDivergenceExceededException(_)
        )
    }
}
impl std::error::Error for MergePullRequestByThreeWayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergePullRequestByThreeWayErrorKind::CommitMessageLengthExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::ConcurrentReferenceUpdateException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::FileContentSizeLimitExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::FolderContentSizeLimitExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidCommitIdException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidConflictDetailLevelException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidConflictResolutionStrategyException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidEmailException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidFileModeException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidPathException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidPullRequestIdException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidReplacementContentException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidReplacementTypeException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::ManualMergeRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::MaximumConflictResolutionEntriesExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::MaximumFileContentToLoadExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::MaximumItemsToCompareExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::MultipleConflictResolutionEntriesException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::NameLengthExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::PathRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestAlreadyClosedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestApprovalRulesNotSatisfiedException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::PullRequestIdRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::ReplacementContentRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::ReplacementTypeRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::RepositoryNotAssociatedWithPullRequestException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::TipOfSourceReferenceIsDifferentException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::TipsDivergenceExceededException(_inner) =>
            Some(_inner)
            ,
            MergePullRequestByThreeWayErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `OverridePullRequestApprovalRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct OverridePullRequestApprovalRulesError {
    /// Kind of error that occurred.
    pub kind: OverridePullRequestApprovalRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `OverridePullRequestApprovalRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum OverridePullRequestApprovalRulesErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The override status is not valid. Valid statuses are OVERRIDE and REVOKE.</p>
    InvalidOverrideStatusException(crate::error::InvalidOverrideStatusException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The revision ID is not valid. Use GetPullRequest to determine the value.</p>
    InvalidRevisionIdException(crate::error::InvalidRevisionIdException),
    /// <p>The pull request has already had its approval rules set to override.</p>
    OverrideAlreadySetException(crate::error::OverrideAlreadySetException),
    /// <p>An override status is required, but no value was provided. Valid values include OVERRIDE and REVOKE.</p>
    OverrideStatusRequiredException(crate::error::OverrideStatusRequiredException),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>A revision ID is required, but was not provided.</p>
    RevisionIdRequiredException(crate::error::RevisionIdRequiredException),
    /// <p>The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to retrieve the current revision ID.</p>
    RevisionNotCurrentException(crate::error::RevisionNotCurrentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for OverridePullRequestApprovalRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            OverridePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(
                _inner,
            ) => _inner.fmt(f),
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(
                _inner,
            ) => _inner.fmt(f),
            OverridePullRequestApprovalRulesErrorKind::InvalidOverrideStatusException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::OverrideAlreadySetException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::OverrideStatusRequiredException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::PullRequestAlreadyClosedException(
                _inner,
            ) => _inner.fmt(f),
            OverridePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(_inner) => {
                _inner.fmt(f)
            }
            OverridePullRequestApprovalRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for OverridePullRequestApprovalRulesError {
    fn code(&self) -> Option<&str> {
        OverridePullRequestApprovalRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl OverridePullRequestApprovalRulesError {
    /// Creates a new `OverridePullRequestApprovalRulesError`.
    pub fn new(
        kind: OverridePullRequestApprovalRulesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `OverridePullRequestApprovalRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: OverridePullRequestApprovalRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `OverridePullRequestApprovalRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: OverridePullRequestApprovalRulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::InvalidOverrideStatusException`.
    pub fn is_invalid_override_status_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::InvalidOverrideStatusException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::InvalidRevisionIdException`.
    pub fn is_invalid_revision_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::OverrideAlreadySetException`.
    pub fn is_override_already_set_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::OverrideAlreadySetException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::OverrideStatusRequiredException`.
    pub fn is_override_status_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::OverrideStatusRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::RevisionIdRequiredException`.
    pub fn is_revision_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `OverridePullRequestApprovalRulesErrorKind::RevisionNotCurrentException`.
    pub fn is_revision_not_current_exception(&self) -> bool {
        matches!(
            &self.kind,
            OverridePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(_)
        )
    }
}
impl std::error::Error for OverridePullRequestApprovalRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            OverridePullRequestApprovalRulesErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyAccessDeniedException(
                _inner,
            ) => Some(_inner),
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::EncryptionKeyUnavailableException(
                _inner,
            ) => Some(_inner),
            OverridePullRequestApprovalRulesErrorKind::InvalidOverrideStatusException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::InvalidRevisionIdException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::OverrideAlreadySetException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::OverrideStatusRequiredException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::PullRequestAlreadyClosedException(
                _inner,
            ) => Some(_inner),
            OverridePullRequestApprovalRulesErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::RevisionIdRequiredException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::RevisionNotCurrentException(_inner) => {
                Some(_inner)
            }
            OverridePullRequestApprovalRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PostCommentForComparedCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PostCommentForComparedCommitError {
    /// Kind of error that occurred.
    pub kind: PostCommentForComparedCommitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PostCommentForComparedCommit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PostCommentForComparedCommitErrorKind {
    /// <p>The before commit ID and the after commit ID are the same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</p>
    BeforeCommitIdAndAfterCommitIdAreSameException(
        crate::error::BeforeCommitIdAndAfterCommitIdAreSameException,
    ),
    /// <p>A client request token is required. A client request token is an unique,
    /// client-generated idempotency token that, when provided in a request, ensures the request
    /// cannot be repeated with a changed parameter. If a request is received with the same
    /// parameters and a token is included, the request returns information about the initial
    /// request that used that token.</p>
    ClientRequestTokenRequiredException(crate::error::ClientRequestTokenRequiredException),
    /// <p>The comment is empty. You must provide some content for a comment. The content cannot be null.</p>
    CommentContentRequiredException(crate::error::CommentContentRequiredException),
    /// <p>The comment is too large. Comments are limited to 1,000 characters.</p>
    CommentContentSizeLimitExceededException(
        crate::error::CommentContentSizeLimitExceededException,
    ),
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit ID was not specified.</p>
    CommitIdRequiredException(crate::error::CommitIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The client request token is not valid. Either the token is not in a valid format, or
    /// the token has been used in a previous request and cannot be reused.</p>
    IdempotencyParameterMismatchException(crate::error::IdempotencyParameterMismatchException),
    /// <p>The client request token is not valid.</p>
    InvalidClientRequestTokenException(crate::error::InvalidClientRequestTokenException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The location of the file is not valid. Make sure that you include the file name and
    /// extension.</p>
    InvalidFileLocationException(crate::error::InvalidFileLocationException),
    /// <p>The position is not valid. Make sure that the line number exists in the version of the file you want to comment on.</p>
    InvalidFilePositionException(crate::error::InvalidFilePositionException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>Either the enum is not in a valid format, or the specified file version enum is not valid in respect to the current file version.</p>
    InvalidRelativeFileVersionEnumException(crate::error::InvalidRelativeFileVersionEnumException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified path does not exist.</p>
    PathDoesNotExistException(crate::error::PathDoesNotExistException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PostCommentForComparedCommitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PostCommentForComparedCommitErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::ClientRequestTokenRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::CommentContentRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::CommentContentSizeLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::CommitDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::CommitIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::IdempotencyParameterMismatchException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::InvalidClientRequestTokenException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::InvalidCommitIdException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::InvalidFileLocationException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::InvalidFilePositionException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::InvalidPathException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::InvalidRelativeFileVersionEnumException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::InvalidRepositoryNameException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::PathDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::PathRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::RepositoryDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::RepositoryNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            PostCommentForComparedCommitErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PostCommentForComparedCommitError {
    fn code(&self) -> Option<&str> {
        PostCommentForComparedCommitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PostCommentForComparedCommitError {
    /// Creates a new `PostCommentForComparedCommitError`.
    pub fn new(kind: PostCommentForComparedCommitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PostCommentForComparedCommitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PostCommentForComparedCommitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PostCommentForComparedCommitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PostCommentForComparedCommitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException`.
    pub fn is_before_commit_id_and_after_commit_id_are_same_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::ClientRequestTokenRequiredException`.
    pub fn is_client_request_token_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::ClientRequestTokenRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::CommentContentRequiredException`.
    pub fn is_comment_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::CommentContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::CommentContentSizeLimitExceededException`.
    pub fn is_comment_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::CommentContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::CommitIdRequiredException`.
    pub fn is_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::CommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::IdempotencyParameterMismatchException`.
    pub fn is_idempotency_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::IdempotencyParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::InvalidClientRequestTokenException`.
    pub fn is_invalid_client_request_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::InvalidClientRequestTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::InvalidFileLocationException`.
    pub fn is_invalid_file_location_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::InvalidFileLocationException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::InvalidFilePositionException`.
    pub fn is_invalid_file_position_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::InvalidFilePositionException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::InvalidRelativeFileVersionEnumException`.
    pub fn is_invalid_relative_file_version_enum_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::InvalidRelativeFileVersionEnumException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::PathDoesNotExistException`.
    pub fn is_path_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::PathDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForComparedCommitErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForComparedCommitErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for PostCommentForComparedCommitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PostCommentForComparedCommitErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::ClientRequestTokenRequiredException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::CommentContentRequiredException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::CommentContentSizeLimitExceededException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::CommitDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::CommitIdRequiredException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::IdempotencyParameterMismatchException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::InvalidClientRequestTokenException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::InvalidCommitIdException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::InvalidFileLocationException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::InvalidFilePositionException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::InvalidPathException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::InvalidRelativeFileVersionEnumException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::InvalidRepositoryNameException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::PathDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::PathRequiredException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::RepositoryDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::RepositoryNameRequiredException(_inner) =>
            Some(_inner)
            ,
            PostCommentForComparedCommitErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PostCommentForPullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PostCommentForPullRequestError {
    /// Kind of error that occurred.
    pub kind: PostCommentForPullRequestErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PostCommentForPullRequest` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PostCommentForPullRequestErrorKind {
    /// <p>The before commit ID and the after commit ID are the same, which is not valid. The before commit ID and the after commit ID must be different commit IDs.</p>
    BeforeCommitIdAndAfterCommitIdAreSameException(
        crate::error::BeforeCommitIdAndAfterCommitIdAreSameException,
    ),
    /// <p>A client request token is required. A client request token is an unique,
    /// client-generated idempotency token that, when provided in a request, ensures the request
    /// cannot be repeated with a changed parameter. If a request is received with the same
    /// parameters and a token is included, the request returns information about the initial
    /// request that used that token.</p>
    ClientRequestTokenRequiredException(crate::error::ClientRequestTokenRequiredException),
    /// <p>The comment is empty. You must provide some content for a comment. The content cannot be null.</p>
    CommentContentRequiredException(crate::error::CommentContentRequiredException),
    /// <p>The comment is too large. Comments are limited to 1,000 characters.</p>
    CommentContentSizeLimitExceededException(
        crate::error::CommentContentSizeLimitExceededException,
    ),
    /// <p>The specified commit does not exist or no commit was specified, and the specified repository has no default branch.</p>
    CommitDoesNotExistException(crate::error::CommitDoesNotExistException),
    /// <p>A commit ID was not specified.</p>
    CommitIdRequiredException(crate::error::CommitIdRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The client request token is not valid. Either the token is not in a valid format, or
    /// the token has been used in a previous request and cannot be reused.</p>
    IdempotencyParameterMismatchException(crate::error::IdempotencyParameterMismatchException),
    /// <p>The client request token is not valid.</p>
    InvalidClientRequestTokenException(crate::error::InvalidClientRequestTokenException),
    /// <p>The specified commit ID is not valid.</p>
    InvalidCommitIdException(crate::error::InvalidCommitIdException),
    /// <p>The location of the file is not valid. Make sure that you include the file name and
    /// extension.</p>
    InvalidFileLocationException(crate::error::InvalidFileLocationException),
    /// <p>The position is not valid. Make sure that the line number exists in the version of the file you want to comment on.</p>
    InvalidFilePositionException(crate::error::InvalidFilePositionException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>Either the enum is not in a valid format, or the specified file version enum is not valid in respect to the current file version.</p>
    InvalidRelativeFileVersionEnumException(crate::error::InvalidRelativeFileVersionEnumException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified path does not exist.</p>
    PathDoesNotExistException(crate::error::PathDoesNotExistException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The repository does not contain any pull requests with that pull request ID. Use GetPullRequest to verify the correct repository name for the pull request ID.</p>
    RepositoryNotAssociatedWithPullRequestException(
        crate::error::RepositoryNotAssociatedWithPullRequestException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PostCommentForPullRequestError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PostCommentForPullRequestErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(
                _inner,
            ) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::ClientRequestTokenRequiredException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::CommentContentRequiredException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::CommentContentSizeLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::CommitDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::CommitIdRequiredException(_inner) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::IdempotencyParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::InvalidClientRequestTokenException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::InvalidCommitIdException(_inner) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::InvalidFileLocationException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::InvalidFilePositionException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::InvalidPullRequestIdException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::InvalidRelativeFileVersionEnumException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::PathDoesNotExistException(_inner) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::PullRequestDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::PullRequestIdRequiredException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(
                _inner,
            ) => _inner.fmt(f),
            PostCommentForPullRequestErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PostCommentForPullRequestError {
    fn code(&self) -> Option<&str> {
        PostCommentForPullRequestError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PostCommentForPullRequestError {
    /// Creates a new `PostCommentForPullRequestError`.
    pub fn new(kind: PostCommentForPullRequestErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PostCommentForPullRequestError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PostCommentForPullRequestErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PostCommentForPullRequestError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PostCommentForPullRequestErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException`.
    pub fn is_before_commit_id_and_after_commit_id_are_same_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::ClientRequestTokenRequiredException`.
    pub fn is_client_request_token_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::ClientRequestTokenRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::CommentContentRequiredException`.
    pub fn is_comment_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::CommentContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::CommentContentSizeLimitExceededException`.
    pub fn is_comment_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::CommentContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::CommitDoesNotExistException`.
    pub fn is_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::CommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::CommitIdRequiredException`.
    pub fn is_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::CommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::IdempotencyParameterMismatchException`.
    pub fn is_idempotency_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::IdempotencyParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidClientRequestTokenException`.
    pub fn is_invalid_client_request_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidClientRequestTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidCommitIdException`.
    pub fn is_invalid_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidFileLocationException`.
    pub fn is_invalid_file_location_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidFileLocationException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidFilePositionException`.
    pub fn is_invalid_file_position_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidFilePositionException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidPathException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidRelativeFileVersionEnumException`.
    pub fn is_invalid_relative_file_version_enum_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidRelativeFileVersionEnumException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::PathDoesNotExistException`.
    pub fn is_path_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::PathDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::PathRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::PullRequestIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException`.
    pub fn is_repository_not_associated_with_pull_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(_)
        )
    }
}
impl std::error::Error for PostCommentForPullRequestError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PostCommentForPullRequestErrorKind::BeforeCommitIdAndAfterCommitIdAreSameException(
                _inner,
            ) => Some(_inner),
            PostCommentForPullRequestErrorKind::ClientRequestTokenRequiredException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::CommentContentRequiredException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::CommentContentSizeLimitExceededException(
                _inner,
            ) => Some(_inner),
            PostCommentForPullRequestErrorKind::CommitDoesNotExistException(_inner) => Some(_inner),
            PostCommentForPullRequestErrorKind::CommitIdRequiredException(_inner) => Some(_inner),
            PostCommentForPullRequestErrorKind::EncryptionIntegrityChecksFailedException(
                _inner,
            ) => Some(_inner),
            PostCommentForPullRequestErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::EncryptionKeyDisabledException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::EncryptionKeyNotFoundException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::IdempotencyParameterMismatchException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::InvalidClientRequestTokenException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::InvalidCommitIdException(_inner) => Some(_inner),
            PostCommentForPullRequestErrorKind::InvalidFileLocationException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::InvalidFilePositionException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::InvalidPathException(_inner) => Some(_inner),
            PostCommentForPullRequestErrorKind::InvalidPullRequestIdException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::InvalidRelativeFileVersionEnumException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::InvalidRepositoryNameException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::PathDoesNotExistException(_inner) => Some(_inner),
            PostCommentForPullRequestErrorKind::PathRequiredException(_inner) => Some(_inner),
            PostCommentForPullRequestErrorKind::PullRequestDoesNotExistException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::PullRequestIdRequiredException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            PostCommentForPullRequestErrorKind::RepositoryNotAssociatedWithPullRequestException(
                _inner,
            ) => Some(_inner),
            PostCommentForPullRequestErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PostCommentReply` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PostCommentReplyError {
    /// Kind of error that occurred.
    pub kind: PostCommentReplyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PostCommentReply` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PostCommentReplyErrorKind {
    /// <p>A client request token is required. A client request token is an unique,
    /// client-generated idempotency token that, when provided in a request, ensures the request
    /// cannot be repeated with a changed parameter. If a request is received with the same
    /// parameters and a token is included, the request returns information about the initial
    /// request that used that token.</p>
    ClientRequestTokenRequiredException(crate::error::ClientRequestTokenRequiredException),
    /// <p>The comment is empty. You must provide some content for a comment. The content cannot be null.</p>
    CommentContentRequiredException(crate::error::CommentContentRequiredException),
    /// <p>The comment is too large. Comments are limited to 1,000 characters.</p>
    CommentContentSizeLimitExceededException(
        crate::error::CommentContentSizeLimitExceededException,
    ),
    /// <p>No comment exists with the provided ID. Verify that you have used the correct ID, and
    /// then try again.</p>
    CommentDoesNotExistException(crate::error::CommentDoesNotExistException),
    /// <p>The comment ID is missing or null. A comment ID is required.</p>
    CommentIdRequiredException(crate::error::CommentIdRequiredException),
    /// <p>The client request token is not valid. Either the token is not in a valid format, or
    /// the token has been used in a previous request and cannot be reused.</p>
    IdempotencyParameterMismatchException(crate::error::IdempotencyParameterMismatchException),
    /// <p>The client request token is not valid.</p>
    InvalidClientRequestTokenException(crate::error::InvalidClientRequestTokenException),
    /// <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
    InvalidCommentIdException(crate::error::InvalidCommentIdException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PostCommentReplyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PostCommentReplyErrorKind::ClientRequestTokenRequiredException(_inner) => _inner.fmt(f),
            PostCommentReplyErrorKind::CommentContentRequiredException(_inner) => _inner.fmt(f),
            PostCommentReplyErrorKind::CommentContentSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentReplyErrorKind::CommentDoesNotExistException(_inner) => _inner.fmt(f),
            PostCommentReplyErrorKind::CommentIdRequiredException(_inner) => _inner.fmt(f),
            PostCommentReplyErrorKind::IdempotencyParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            PostCommentReplyErrorKind::InvalidClientRequestTokenException(_inner) => _inner.fmt(f),
            PostCommentReplyErrorKind::InvalidCommentIdException(_inner) => _inner.fmt(f),
            PostCommentReplyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PostCommentReplyError {
    fn code(&self) -> Option<&str> {
        PostCommentReplyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PostCommentReplyError {
    /// Creates a new `PostCommentReplyError`.
    pub fn new(kind: PostCommentReplyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PostCommentReplyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PostCommentReplyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PostCommentReplyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PostCommentReplyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::ClientRequestTokenRequiredException`.
    pub fn is_client_request_token_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::ClientRequestTokenRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::CommentContentRequiredException`.
    pub fn is_comment_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::CommentContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::CommentContentSizeLimitExceededException`.
    pub fn is_comment_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::CommentContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::CommentDoesNotExistException`.
    pub fn is_comment_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::CommentDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::CommentIdRequiredException`.
    pub fn is_comment_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::CommentIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::IdempotencyParameterMismatchException`.
    pub fn is_idempotency_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::IdempotencyParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::InvalidClientRequestTokenException`.
    pub fn is_invalid_client_request_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::InvalidClientRequestTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PostCommentReplyErrorKind::InvalidCommentIdException`.
    pub fn is_invalid_comment_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            PostCommentReplyErrorKind::InvalidCommentIdException(_)
        )
    }
}
impl std::error::Error for PostCommentReplyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PostCommentReplyErrorKind::ClientRequestTokenRequiredException(_inner) => Some(_inner),
            PostCommentReplyErrorKind::CommentContentRequiredException(_inner) => Some(_inner),
            PostCommentReplyErrorKind::CommentContentSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            PostCommentReplyErrorKind::CommentDoesNotExistException(_inner) => Some(_inner),
            PostCommentReplyErrorKind::CommentIdRequiredException(_inner) => Some(_inner),
            PostCommentReplyErrorKind::IdempotencyParameterMismatchException(_inner) => {
                Some(_inner)
            }
            PostCommentReplyErrorKind::InvalidClientRequestTokenException(_inner) => Some(_inner),
            PostCommentReplyErrorKind::InvalidCommentIdException(_inner) => Some(_inner),
            PostCommentReplyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutCommentReaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutCommentReactionError {
    /// Kind of error that occurred.
    pub kind: PutCommentReactionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutCommentReaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutCommentReactionErrorKind {
    /// <p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>
    CommentDeletedException(crate::error::CommentDeletedException),
    /// <p>No comment exists with the provided ID. Verify that you have used the correct ID, and
    /// then try again.</p>
    CommentDoesNotExistException(crate::error::CommentDoesNotExistException),
    /// <p>The comment ID is missing or null. A comment ID is required.</p>
    CommentIdRequiredException(crate::error::CommentIdRequiredException),
    /// <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
    InvalidCommentIdException(crate::error::InvalidCommentIdException),
    /// <p>The value of the reaction is not valid. For more information, see the <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit User Guide</a>.</p>
    InvalidReactionValueException(crate::error::InvalidReactionValueException),
    /// <p>The number of reactions has been exceeded. Reactions are limited to one reaction per user for each individual comment ID.</p>
    ReactionLimitExceededException(crate::error::ReactionLimitExceededException),
    /// <p>A reaction value is required. </p>
    ReactionValueRequiredException(crate::error::ReactionValueRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutCommentReactionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutCommentReactionErrorKind::CommentDeletedException(_inner) => _inner.fmt(f),
            PutCommentReactionErrorKind::CommentDoesNotExistException(_inner) => _inner.fmt(f),
            PutCommentReactionErrorKind::CommentIdRequiredException(_inner) => _inner.fmt(f),
            PutCommentReactionErrorKind::InvalidCommentIdException(_inner) => _inner.fmt(f),
            PutCommentReactionErrorKind::InvalidReactionValueException(_inner) => _inner.fmt(f),
            PutCommentReactionErrorKind::ReactionLimitExceededException(_inner) => _inner.fmt(f),
            PutCommentReactionErrorKind::ReactionValueRequiredException(_inner) => _inner.fmt(f),
            PutCommentReactionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutCommentReactionError {
    fn code(&self) -> Option<&str> {
        PutCommentReactionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutCommentReactionError {
    /// Creates a new `PutCommentReactionError`.
    pub fn new(kind: PutCommentReactionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutCommentReactionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutCommentReactionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutCommentReactionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutCommentReactionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutCommentReactionErrorKind::CommentDeletedException`.
    pub fn is_comment_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCommentReactionErrorKind::CommentDeletedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCommentReactionErrorKind::CommentDoesNotExistException`.
    pub fn is_comment_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCommentReactionErrorKind::CommentDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCommentReactionErrorKind::CommentIdRequiredException`.
    pub fn is_comment_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCommentReactionErrorKind::CommentIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCommentReactionErrorKind::InvalidCommentIdException`.
    pub fn is_invalid_comment_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCommentReactionErrorKind::InvalidCommentIdException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCommentReactionErrorKind::InvalidReactionValueException`.
    pub fn is_invalid_reaction_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCommentReactionErrorKind::InvalidReactionValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCommentReactionErrorKind::ReactionLimitExceededException`.
    pub fn is_reaction_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCommentReactionErrorKind::ReactionLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutCommentReactionErrorKind::ReactionValueRequiredException`.
    pub fn is_reaction_value_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutCommentReactionErrorKind::ReactionValueRequiredException(_)
        )
    }
}
impl std::error::Error for PutCommentReactionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutCommentReactionErrorKind::CommentDeletedException(_inner) => Some(_inner),
            PutCommentReactionErrorKind::CommentDoesNotExistException(_inner) => Some(_inner),
            PutCommentReactionErrorKind::CommentIdRequiredException(_inner) => Some(_inner),
            PutCommentReactionErrorKind::InvalidCommentIdException(_inner) => Some(_inner),
            PutCommentReactionErrorKind::InvalidReactionValueException(_inner) => Some(_inner),
            PutCommentReactionErrorKind::ReactionLimitExceededException(_inner) => Some(_inner),
            PutCommentReactionErrorKind::ReactionValueRequiredException(_inner) => Some(_inner),
            PutCommentReactionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutFile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFileError {
    /// Kind of error that occurred.
    pub kind: PutFileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFileErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>The specified branch name is not valid because it is a tag name. Enter the name of a
    /// branch in the repository. For a list of valid branch names, use <a>ListBranches</a>.</p>
    BranchNameIsTagNameException(crate::error::BranchNameIsTagNameException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>The commit message is too long. Provide a shorter string. </p>
    CommitMessageLengthExceededException(crate::error::CommitMessageLengthExceededException),
    /// <p>A file cannot be added to the repository because the specified path name has the same name as a file that already exists in this repository.
    /// Either provide a different name for the file, or specify a different path for the file.</p>
    DirectoryNameConflictsWithFileNameException(
        crate::error::DirectoryNameConflictsWithFileNameException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The file cannot be added because it is empty. Empty files cannot be added to the repository with this API.</p>
    FileContentRequiredException(crate::error::FileContentRequiredException),
    /// <p>The file cannot be added because it is too large. The maximum file size is 6 MB, and
    /// the combined file content change size is 7 MB. Consider making these changes using a Git
    /// client.</p>
    FileContentSizeLimitExceededException(crate::error::FileContentSizeLimitExceededException),
    /// <p>A file cannot be added to the repository because the specified file name has the same name as a directory in this repository. Either provide
    /// another name for the file, or add the file in a directory that does not match the file name.</p>
    FileNameConflictsWithDirectoryNameException(
        crate::error::FileNameConflictsWithDirectoryNameException,
    ),
    /// <p>The commit cannot be created because a specified file path points to a submodule. Verify that the destination files
    /// have valid file paths that do not point to a submodule.</p>
    FilePathConflictsWithSubmodulePathException(
        crate::error::FilePathConflictsWithSubmodulePathException,
    ),
    /// <p>The commit cannot be created because at least one of the overall changes in the commit results in a
    /// folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes,
    /// or split the changes across multiple folders.</p>
    FolderContentSizeLimitExceededException(crate::error::FolderContentSizeLimitExceededException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>The specified deletion parameter is not valid.</p>
    InvalidDeletionParameterException(crate::error::InvalidDeletionParameterException),
    /// <p>The specified email address either contains one or more characters that are not allowed, or it exceeds the maximum number of characters
    /// allowed for an email address.</p>
    InvalidEmailException(crate::error::InvalidEmailException),
    /// <p>The specified file mode permission is not valid. For a list of valid file mode permissions, see <a>PutFile</a>. </p>
    InvalidFileModeException(crate::error::InvalidFileModeException),
    /// <p>The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for the branch of the repository where you
    /// want to add or update a file.</p>
    InvalidParentCommitIdException(crate::error::InvalidParentCommitIdException),
    /// <p>The specified path is not valid.</p>
    InvalidPathException(crate::error::InvalidPathException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The user name is not valid because it has exceeded the character limit for author names. </p>
    NameLengthExceededException(crate::error::NameLengthExceededException),
    /// <p>The parent commit ID is not valid because it does not exist. The specified parent commit ID does not exist in the specified branch of the repository.</p>
    ParentCommitDoesNotExistException(crate::error::ParentCommitDoesNotExistException),
    /// <p>The file could not be added because the provided parent commit ID is not the current tip of the specified branch. To view the full commit ID of the current head
    /// of the branch, use <a>GetBranch</a>.</p>
    ParentCommitIdOutdatedException(crate::error::ParentCommitIdOutdatedException),
    /// <p>A parent commit ID is required. To view the full commit ID of a branch in a repository, use <a>GetBranch</a> or a Git command
    /// (for example, git pull or git log).</p>
    ParentCommitIdRequiredException(crate::error::ParentCommitIdRequiredException),
    /// <p>The folderPath for a location cannot be null.</p>
    PathRequiredException(crate::error::PathRequiredException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>The file was not added or updated because the content of the file is exactly the same as the content of that file in the repository and branch
    /// that you specified.</p>
    SameFileContentException(crate::error::SameFileContentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFileErrorKind::BranchDoesNotExistException(_inner) => _inner.fmt(f),
            PutFileErrorKind::BranchNameIsTagNameException(_inner) => _inner.fmt(f),
            PutFileErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            PutFileErrorKind::CommitMessageLengthExceededException(_inner) => _inner.fmt(f),
            PutFileErrorKind::DirectoryNameConflictsWithFileNameException(_inner) => _inner.fmt(f),
            PutFileErrorKind::EncryptionIntegrityChecksFailedException(_inner) => _inner.fmt(f),
            PutFileErrorKind::EncryptionKeyAccessDeniedException(_inner) => _inner.fmt(f),
            PutFileErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            PutFileErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            PutFileErrorKind::EncryptionKeyUnavailableException(_inner) => _inner.fmt(f),
            PutFileErrorKind::FileContentRequiredException(_inner) => _inner.fmt(f),
            PutFileErrorKind::FileContentSizeLimitExceededException(_inner) => _inner.fmt(f),
            PutFileErrorKind::FileNameConflictsWithDirectoryNameException(_inner) => _inner.fmt(f),
            PutFileErrorKind::FilePathConflictsWithSubmodulePathException(_inner) => _inner.fmt(f),
            PutFileErrorKind::FolderContentSizeLimitExceededException(_inner) => _inner.fmt(f),
            PutFileErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            PutFileErrorKind::InvalidDeletionParameterException(_inner) => _inner.fmt(f),
            PutFileErrorKind::InvalidEmailException(_inner) => _inner.fmt(f),
            PutFileErrorKind::InvalidFileModeException(_inner) => _inner.fmt(f),
            PutFileErrorKind::InvalidParentCommitIdException(_inner) => _inner.fmt(f),
            PutFileErrorKind::InvalidPathException(_inner) => _inner.fmt(f),
            PutFileErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            PutFileErrorKind::NameLengthExceededException(_inner) => _inner.fmt(f),
            PutFileErrorKind::ParentCommitDoesNotExistException(_inner) => _inner.fmt(f),
            PutFileErrorKind::ParentCommitIdOutdatedException(_inner) => _inner.fmt(f),
            PutFileErrorKind::ParentCommitIdRequiredException(_inner) => _inner.fmt(f),
            PutFileErrorKind::PathRequiredException(_inner) => _inner.fmt(f),
            PutFileErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            PutFileErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            PutFileErrorKind::SameFileContentException(_inner) => _inner.fmt(f),
            PutFileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFileError {
    fn code(&self) -> Option<&str> {
        PutFileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFileError {
    /// Creates a new `PutFileError`.
    pub fn new(kind: PutFileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::BranchDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::BranchNameIsTagNameException`.
    pub fn is_branch_name_is_tag_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::BranchNameIsTagNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::BranchNameRequiredException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::CommitMessageLengthExceededException`.
    pub fn is_commit_message_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::CommitMessageLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::DirectoryNameConflictsWithFileNameException`.
    pub fn is_directory_name_conflicts_with_file_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::DirectoryNameConflictsWithFileNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::FileContentRequiredException`.
    pub fn is_file_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::FileContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::FileContentSizeLimitExceededException`.
    pub fn is_file_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::FileContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::FileNameConflictsWithDirectoryNameException`.
    pub fn is_file_name_conflicts_with_directory_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::FileNameConflictsWithDirectoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::FilePathConflictsWithSubmodulePathException`.
    pub fn is_file_path_conflicts_with_submodule_path_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::FilePathConflictsWithSubmodulePathException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::FolderContentSizeLimitExceededException`.
    pub fn is_folder_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::FolderContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::InvalidBranchNameException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::InvalidDeletionParameterException`.
    pub fn is_invalid_deletion_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::InvalidDeletionParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::InvalidEmailException`.
    pub fn is_invalid_email_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::InvalidEmailException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::InvalidFileModeException`.
    pub fn is_invalid_file_mode_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::InvalidFileModeException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::InvalidParentCommitIdException`.
    pub fn is_invalid_parent_commit_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::InvalidParentCommitIdException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::InvalidPathException`.
    pub fn is_invalid_path_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::InvalidPathException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::NameLengthExceededException`.
    pub fn is_name_length_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::NameLengthExceededException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::ParentCommitDoesNotExistException`.
    pub fn is_parent_commit_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::ParentCommitDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::ParentCommitIdOutdatedException`.
    pub fn is_parent_commit_id_outdated_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::ParentCommitIdOutdatedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::ParentCommitIdRequiredException`.
    pub fn is_parent_commit_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::ParentCommitIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::PathRequiredException`.
    pub fn is_path_required_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::PathRequiredException(_))
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFileErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFileErrorKind::SameFileContentException`.
    pub fn is_same_file_content_exception(&self) -> bool {
        matches!(&self.kind, PutFileErrorKind::SameFileContentException(_))
    }
}
impl std::error::Error for PutFileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFileErrorKind::BranchDoesNotExistException(_inner) => Some(_inner),
            PutFileErrorKind::BranchNameIsTagNameException(_inner) => Some(_inner),
            PutFileErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            PutFileErrorKind::CommitMessageLengthExceededException(_inner) => Some(_inner),
            PutFileErrorKind::DirectoryNameConflictsWithFileNameException(_inner) => Some(_inner),
            PutFileErrorKind::EncryptionIntegrityChecksFailedException(_inner) => Some(_inner),
            PutFileErrorKind::EncryptionKeyAccessDeniedException(_inner) => Some(_inner),
            PutFileErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            PutFileErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            PutFileErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            PutFileErrorKind::FileContentRequiredException(_inner) => Some(_inner),
            PutFileErrorKind::FileContentSizeLimitExceededException(_inner) => Some(_inner),
            PutFileErrorKind::FileNameConflictsWithDirectoryNameException(_inner) => Some(_inner),
            PutFileErrorKind::FilePathConflictsWithSubmodulePathException(_inner) => Some(_inner),
            PutFileErrorKind::FolderContentSizeLimitExceededException(_inner) => Some(_inner),
            PutFileErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            PutFileErrorKind::InvalidDeletionParameterException(_inner) => Some(_inner),
            PutFileErrorKind::InvalidEmailException(_inner) => Some(_inner),
            PutFileErrorKind::InvalidFileModeException(_inner) => Some(_inner),
            PutFileErrorKind::InvalidParentCommitIdException(_inner) => Some(_inner),
            PutFileErrorKind::InvalidPathException(_inner) => Some(_inner),
            PutFileErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            PutFileErrorKind::NameLengthExceededException(_inner) => Some(_inner),
            PutFileErrorKind::ParentCommitDoesNotExistException(_inner) => Some(_inner),
            PutFileErrorKind::ParentCommitIdOutdatedException(_inner) => Some(_inner),
            PutFileErrorKind::ParentCommitIdRequiredException(_inner) => Some(_inner),
            PutFileErrorKind::PathRequiredException(_inner) => Some(_inner),
            PutFileErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            PutFileErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            PutFileErrorKind::SameFileContentException(_inner) => Some(_inner),
            PutFileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRepositoryTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRepositoryTriggersError {
    /// Kind of error that occurred.
    pub kind: PutRepositoryTriggersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRepositoryTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRepositoryTriggersErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>One or more branch names specified for the trigger is not valid.</p>
    InvalidRepositoryTriggerBranchNameException(
        crate::error::InvalidRepositoryTriggerBranchNameException,
    ),
    /// <p>The custom data provided for the trigger is not valid.</p>
    InvalidRepositoryTriggerCustomDataException(
        crate::error::InvalidRepositoryTriggerCustomDataException,
    ),
    /// <p>The Amazon Resource Name (ARN) for the trigger is not valid for the specified destination. The most common reason for this error is that the ARN does not meet the requirements for the service type.</p>
    InvalidRepositoryTriggerDestinationArnException(
        crate::error::InvalidRepositoryTriggerDestinationArnException,
    ),
    /// <p>One or more events specified for the trigger is not valid. Check to make sure that all events specified match the requirements for allowed events.</p>
    InvalidRepositoryTriggerEventsException(crate::error::InvalidRepositoryTriggerEventsException),
    /// <p>The name of the trigger is not valid.</p>
    InvalidRepositoryTriggerNameException(crate::error::InvalidRepositoryTriggerNameException),
    /// <p>The AWS Region for the trigger target does not match the AWS Region for the
    /// repository. Triggers must be created in the same Region as the target for the
    /// trigger.</p>
    InvalidRepositoryTriggerRegionException(crate::error::InvalidRepositoryTriggerRegionException),
    /// <p>The number of branches for the trigger was exceeded.</p>
    MaximumBranchesExceededException(crate::error::MaximumBranchesExceededException),
    /// <p>The number of triggers allowed for the repository was exceeded.</p>
    MaximumRepositoryTriggersExceededException(
        crate::error::MaximumRepositoryTriggersExceededException,
    ),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>At least one branch name is required, but was not specified in the trigger
    /// configuration.</p>
    RepositoryTriggerBranchNameListRequiredException(
        crate::error::RepositoryTriggerBranchNameListRequiredException,
    ),
    /// <p>A destination ARN for the target service for the trigger is required, but was not
    /// specified.</p>
    RepositoryTriggerDestinationArnRequiredException(
        crate::error::RepositoryTriggerDestinationArnRequiredException,
    ),
    /// <p>At least one event for the trigger is required, but was not specified.</p>
    RepositoryTriggerEventsListRequiredException(
        crate::error::RepositoryTriggerEventsListRequiredException,
    ),
    /// <p>A name for the trigger is required, but was not specified.</p>
    RepositoryTriggerNameRequiredException(crate::error::RepositoryTriggerNameRequiredException),
    /// <p>The list of triggers for the repository is required, but was not specified.</p>
    RepositoryTriggersListRequiredException(crate::error::RepositoryTriggersListRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRepositoryTriggersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            PutRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            PutRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(
                _inner,
            ) => _inner.fmt(f),
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::MaximumBranchesExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(
                _inner,
            ) => _inner.fmt(f),
            PutRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(
                _inner,
            ) => _inner.fmt(f),
            PutRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(
                _inner,
            ) => _inner.fmt(f),
            PutRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryTriggersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRepositoryTriggersError {
    fn code(&self) -> Option<&str> {
        PutRepositoryTriggersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRepositoryTriggersError {
    /// Creates a new `PutRepositoryTriggersError`.
    pub fn new(kind: PutRepositoryTriggersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRepositoryTriggersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRepositoryTriggersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRepositoryTriggersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRepositoryTriggersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException`.
    pub fn is_invalid_repository_trigger_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException`.
    pub fn is_invalid_repository_trigger_custom_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException`.
    pub fn is_invalid_repository_trigger_destination_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException`.
    pub fn is_invalid_repository_trigger_events_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException`.
    pub fn is_invalid_repository_trigger_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException`.
    pub fn is_invalid_repository_trigger_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::MaximumBranchesExceededException`.
    pub fn is_maximum_branches_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::MaximumBranchesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException`.
    pub fn is_maximum_repository_triggers_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException`.
    pub fn is_repository_trigger_branch_name_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException`.
    pub fn is_repository_trigger_destination_arn_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException`.
    pub fn is_repository_trigger_events_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException`.
    pub fn is_repository_trigger_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException`.
    pub fn is_repository_triggers_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(_)
        )
    }
}
impl std::error::Error for PutRepositoryTriggersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            PutRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            PutRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(
                _inner,
            ) => Some(_inner),
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::MaximumBranchesExceededException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            PutRepositoryTriggersErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            PutRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(
                _inner,
            ) => Some(_inner),
            PutRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(
                _inner,
            ) => Some(_inner),
            PutRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(
                _inner,
            ) => Some(_inner),
            PutRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(_inner) => {
                Some(_inner)
            }
            PutRepositoryTriggersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a>
    /// in the AWS CodeCommit User Guide.</p>
    InvalidResourceArnException(crate::error::InvalidResourceArnException),
    /// <p>The specified tag is not valid. Key names cannot be prefixed with aws:.</p>
    InvalidSystemTagUsageException(crate::error::InvalidSystemTagUsageException),
    /// <p>The map of tags is not valid.</p>
    InvalidTagsMapException(crate::error::InvalidTagsMapException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid resources in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a>
    /// in the AWS CodeCommit User Guide.</p>
    ResourceArnRequiredException(crate::error::ResourceArnRequiredException),
    /// <p>The tag policy is not valid.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>A map of tags is required.</p>
    TagsMapRequiredException(crate::error::TagsMapRequiredException),
    /// <p>The maximum number of tags for an AWS CodeCommit resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidResourceArnException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidSystemTagUsageException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidTagsMapException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceArnRequiredException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TagsMapRequiredException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidResourceArnException`.
    pub fn is_invalid_resource_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidResourceArnException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidSystemTagUsageException`.
    pub fn is_invalid_system_tag_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidSystemTagUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidTagsMapException`.
    pub fn is_invalid_tags_map_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidTagsMapException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceArnRequiredException`.
    pub fn is_resource_arn_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceArnRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TagPolicyException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TagsMapRequiredException`.
    pub fn is_tags_map_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TagsMapRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidResourceArnException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidSystemTagUsageException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidTagsMapException(_inner) => Some(_inner),
            TagResourceErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceArnRequiredException(_inner) => Some(_inner),
            TagResourceErrorKind::TagPolicyException(_inner) => Some(_inner),
            TagResourceErrorKind::TagsMapRequiredException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestRepositoryTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestRepositoryTriggersError {
    /// Kind of error that occurred.
    pub kind: TestRepositoryTriggersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestRepositoryTriggers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestRepositoryTriggersErrorKind {
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>One or more branch names specified for the trigger is not valid.</p>
    InvalidRepositoryTriggerBranchNameException(
        crate::error::InvalidRepositoryTriggerBranchNameException,
    ),
    /// <p>The custom data provided for the trigger is not valid.</p>
    InvalidRepositoryTriggerCustomDataException(
        crate::error::InvalidRepositoryTriggerCustomDataException,
    ),
    /// <p>The Amazon Resource Name (ARN) for the trigger is not valid for the specified destination. The most common reason for this error is that the ARN does not meet the requirements for the service type.</p>
    InvalidRepositoryTriggerDestinationArnException(
        crate::error::InvalidRepositoryTriggerDestinationArnException,
    ),
    /// <p>One or more events specified for the trigger is not valid. Check to make sure that all events specified match the requirements for allowed events.</p>
    InvalidRepositoryTriggerEventsException(crate::error::InvalidRepositoryTriggerEventsException),
    /// <p>The name of the trigger is not valid.</p>
    InvalidRepositoryTriggerNameException(crate::error::InvalidRepositoryTriggerNameException),
    /// <p>The AWS Region for the trigger target does not match the AWS Region for the
    /// repository. Triggers must be created in the same Region as the target for the
    /// trigger.</p>
    InvalidRepositoryTriggerRegionException(crate::error::InvalidRepositoryTriggerRegionException),
    /// <p>The number of branches for the trigger was exceeded.</p>
    MaximumBranchesExceededException(crate::error::MaximumBranchesExceededException),
    /// <p>The number of triggers allowed for the repository was exceeded.</p>
    MaximumRepositoryTriggersExceededException(
        crate::error::MaximumRepositoryTriggersExceededException,
    ),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// <p>At least one branch name is required, but was not specified in the trigger
    /// configuration.</p>
    RepositoryTriggerBranchNameListRequiredException(
        crate::error::RepositoryTriggerBranchNameListRequiredException,
    ),
    /// <p>A destination ARN for the target service for the trigger is required, but was not
    /// specified.</p>
    RepositoryTriggerDestinationArnRequiredException(
        crate::error::RepositoryTriggerDestinationArnRequiredException,
    ),
    /// <p>At least one event for the trigger is required, but was not specified.</p>
    RepositoryTriggerEventsListRequiredException(
        crate::error::RepositoryTriggerEventsListRequiredException,
    ),
    /// <p>A name for the trigger is required, but was not specified.</p>
    RepositoryTriggerNameRequiredException(crate::error::RepositoryTriggerNameRequiredException),
    /// <p>The list of triggers for the repository is required, but was not specified.</p>
    RepositoryTriggersListRequiredException(crate::error::RepositoryTriggersListRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestRepositoryTriggersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::InvalidRepositoryNameException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(
                _inner,
            ) => _inner.fmt(f),
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(
                _inner,
            ) => _inner.fmt(f),
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(
                _inner,
            ) => _inner.fmt(f),
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::MaximumBranchesExceededException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::RepositoryNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(
                _inner,
            ) => _inner.fmt(f),
            TestRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(
                _inner,
            ) => _inner.fmt(f),
            TestRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(
                _inner,
            ) => _inner.fmt(f),
            TestRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(_inner) => {
                _inner.fmt(f)
            }
            TestRepositoryTriggersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestRepositoryTriggersError {
    fn code(&self) -> Option<&str> {
        TestRepositoryTriggersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestRepositoryTriggersError {
    /// Creates a new `TestRepositoryTriggersError`.
    pub fn new(kind: TestRepositoryTriggersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestRepositoryTriggersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestRepositoryTriggersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestRepositoryTriggersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestRepositoryTriggersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException`.
    pub fn is_invalid_repository_trigger_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException`.
    pub fn is_invalid_repository_trigger_custom_data_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException`.
    pub fn is_invalid_repository_trigger_destination_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException`.
    pub fn is_invalid_repository_trigger_events_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException`.
    pub fn is_invalid_repository_trigger_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException`.
    pub fn is_invalid_repository_trigger_region_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::MaximumBranchesExceededException`.
    pub fn is_maximum_branches_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::MaximumBranchesExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException`.
    pub fn is_maximum_repository_triggers_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::RepositoryNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException`.
    pub fn is_repository_trigger_branch_name_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException`.
    pub fn is_repository_trigger_destination_arn_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException`.
    pub fn is_repository_trigger_events_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException`.
    pub fn is_repository_trigger_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `TestRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException`.
    pub fn is_repository_triggers_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(_)
        )
    }
}
impl std::error::Error for TestRepositoryTriggersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestRepositoryTriggersErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            TestRepositoryTriggersErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            TestRepositoryTriggersErrorKind::EncryptionKeyUnavailableException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerBranchNameException(
                _inner,
            ) => Some(_inner),
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerCustomDataException(
                _inner,
            ) => Some(_inner),
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerDestinationArnException(
                _inner,
            ) => Some(_inner),
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerEventsException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerNameException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::InvalidRepositoryTriggerRegionException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::MaximumBranchesExceededException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::MaximumRepositoryTriggersExceededException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::RepositoryDoesNotExistException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::RepositoryNameRequiredException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::RepositoryTriggerBranchNameListRequiredException(
                _inner,
            ) => Some(_inner),
            TestRepositoryTriggersErrorKind::RepositoryTriggerDestinationArnRequiredException(
                _inner,
            ) => Some(_inner),
            TestRepositoryTriggersErrorKind::RepositoryTriggerEventsListRequiredException(
                _inner,
            ) => Some(_inner),
            TestRepositoryTriggersErrorKind::RepositoryTriggerNameRequiredException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::RepositoryTriggersListRequiredException(_inner) => {
                Some(_inner)
            }
            TestRepositoryTriggersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The value for the resource ARN is not valid. For more information about resources in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a>
    /// in the AWS CodeCommit User Guide.</p>
    InvalidResourceArnException(crate::error::InvalidResourceArnException),
    /// <p>The specified tag is not valid. Key names cannot be prefixed with aws:.</p>
    InvalidSystemTagUsageException(crate::error::InvalidSystemTagUsageException),
    /// <p>The list of tags is not valid.</p>
    InvalidTagKeysListException(crate::error::InvalidTagKeysListException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A valid Amazon Resource Name (ARN) for an AWS CodeCommit resource is required. For a list of valid resources in AWS CodeCommit, see
    /// <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/auth-and-access-control-iam-access-control-identity-based.html#arn-formats">CodeCommit Resources and Operations</a>
    /// in the AWS CodeCommit User Guide.</p>
    ResourceArnRequiredException(crate::error::ResourceArnRequiredException),
    /// <p>A list of tag keys is required. The list cannot be empty or null.</p>
    TagKeysListRequiredException(crate::error::TagKeysListRequiredException),
    /// <p>The tag policy is not valid.</p>
    TagPolicyException(crate::error::TagPolicyException),
    /// <p>The maximum number of tags for an AWS CodeCommit resource has been exceeded.</p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidResourceArnException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidSystemTagUsageException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidTagKeysListException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceArnRequiredException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagKeysListRequiredException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TagPolicyException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidResourceArnException`.
    pub fn is_invalid_resource_arn_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidResourceArnException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidSystemTagUsageException`.
    pub fn is_invalid_system_tag_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidSystemTagUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidTagKeysListException`.
    pub fn is_invalid_tag_keys_list_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidTagKeysListException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceArnRequiredException`.
    pub fn is_resource_arn_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceArnRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TagKeysListRequiredException`.
    pub fn is_tag_keys_list_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TagKeysListRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TagPolicyException`.
    pub fn is_tag_policy_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TagPolicyException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidResourceArnException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidSystemTagUsageException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidTagKeysListException(_inner) => Some(_inner),
            UntagResourceErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceArnRequiredException(_inner) => Some(_inner),
            UntagResourceErrorKind::TagKeysListRequiredException(_inner) => Some(_inner),
            UntagResourceErrorKind::TagPolicyException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApprovalRuleTemplateContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApprovalRuleTemplateContentError {
    /// Kind of error that occurred.
    pub kind: UpdateApprovalRuleTemplateContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApprovalRuleTemplateContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApprovalRuleTemplateContentErrorKind {
    /// <p>The content for the approval rule template is empty. You must provide some content for an approval rule template. The content cannot be null.</p>
    ApprovalRuleTemplateContentRequiredException(
        crate::error::ApprovalRuleTemplateContentRequiredException,
    ),
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>The content of the approval rule template is not valid.</p>
    InvalidApprovalRuleTemplateContentException(
        crate::error::InvalidApprovalRuleTemplateContentException,
    ),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// <p>The SHA-256 hash signature for the rule content is not valid.</p>
    InvalidRuleContentSha256Exception(crate::error::InvalidRuleContentSha256Exception),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApprovalRuleTemplateContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateContentRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateContentException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidRuleContentSha256Exception(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApprovalRuleTemplateContentError {
    fn code(&self) -> Option<&str> {
        UpdateApprovalRuleTemplateContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApprovalRuleTemplateContentError {
    /// Creates a new `UpdateApprovalRuleTemplateContentError`.
    pub fn new(
        kind: UpdateApprovalRuleTemplateContentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApprovalRuleTemplateContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApprovalRuleTemplateContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApprovalRuleTemplateContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApprovalRuleTemplateContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateContentRequiredException`.
    pub fn is_approval_rule_template_content_required_exception(&self) -> bool {
        matches!(&self.kind, UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateContentRequiredException(_))
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateDoesNotExistException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateNameRequiredException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateContentException`.
    pub fn is_invalid_approval_rule_template_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateContentException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateContentErrorKind::InvalidRuleContentSha256Exception`.
    pub fn is_invalid_rule_content_sha256_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidRuleContentSha256Exception(_)
        )
    }
}
impl std::error::Error for UpdateApprovalRuleTemplateContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateContentRequiredException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateContentException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::InvalidRuleContentSha256Exception(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateContentErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateApprovalRuleTemplateDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApprovalRuleTemplateDescriptionError {
    /// Kind of error that occurred.
    pub kind: UpdateApprovalRuleTemplateDescriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApprovalRuleTemplateDescription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApprovalRuleTemplateDescriptionErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>The description for the approval rule template is not valid because it exceeds the
    /// maximum characters allowed for a description. For more information about limits in AWS
    /// CodeCommit, see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS CodeCommit User
    /// Guide</a>.</p>
    InvalidApprovalRuleTemplateDescriptionException(
        crate::error::InvalidApprovalRuleTemplateDescriptionException,
    ),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApprovalRuleTemplateDescriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateDescriptionException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApprovalRuleTemplateDescriptionError {
    fn code(&self) -> Option<&str> {
        UpdateApprovalRuleTemplateDescriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApprovalRuleTemplateDescriptionError {
    /// Creates a new `UpdateApprovalRuleTemplateDescriptionError`.
    pub fn new(
        kind: UpdateApprovalRuleTemplateDescriptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApprovalRuleTemplateDescriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApprovalRuleTemplateDescriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApprovalRuleTemplateDescriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApprovalRuleTemplateDescriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(&self.kind, UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateDoesNotExistException(_))
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(&self.kind, UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateNameRequiredException(_))
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateDescriptionException`.
    pub fn is_invalid_approval_rule_template_description_exception(&self) -> bool {
        matches!(&self.kind, UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateDescriptionException(_))
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(&self.kind, UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateNameException(_))
    }
}
impl std::error::Error for UpdateApprovalRuleTemplateDescriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateDescriptionException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateDescriptionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateApprovalRuleTemplateName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApprovalRuleTemplateNameError {
    /// Kind of error that occurred.
    pub kind: UpdateApprovalRuleTemplateNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApprovalRuleTemplateName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApprovalRuleTemplateNameErrorKind {
    /// <p>The specified approval rule template does not exist. Verify that the name is correct and that you are signed in to the AWS Region where the template
    /// was created, and then try again.</p>
    ApprovalRuleTemplateDoesNotExistException(
        crate::error::ApprovalRuleTemplateDoesNotExistException,
    ),
    /// <p>You cannot create an approval rule template with that name because a template with
    /// that name already exists in this AWS Region for your AWS account. Approval rule template
    /// names must be unique.</p>
    ApprovalRuleTemplateNameAlreadyExistsException(
        crate::error::ApprovalRuleTemplateNameAlreadyExistsException,
    ),
    /// <p>An approval rule template name is required, but was not specified.</p>
    ApprovalRuleTemplateNameRequiredException(
        crate::error::ApprovalRuleTemplateNameRequiredException,
    ),
    /// <p>The name of the approval rule template is not valid. Template names must be between 1
    /// and 100 valid characters in length. For more information about limits in AWS CodeCommit,
    /// see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">AWS
    /// CodeCommit User Guide</a>.</p>
    InvalidApprovalRuleTemplateNameException(
        crate::error::InvalidApprovalRuleTemplateNameException,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApprovalRuleTemplateNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            _inner.fmt(f)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApprovalRuleTemplateNameError {
    fn code(&self) -> Option<&str> {
        UpdateApprovalRuleTemplateNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApprovalRuleTemplateNameError {
    /// Creates a new `UpdateApprovalRuleTemplateNameError`.
    pub fn new(
        kind: UpdateApprovalRuleTemplateNameErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApprovalRuleTemplateNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApprovalRuleTemplateNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApprovalRuleTemplateNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApprovalRuleTemplateNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateDoesNotExistException`.
    pub fn is_approval_rule_template_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameAlreadyExistsException`.
    pub fn is_approval_rule_template_name_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameRequiredException`.
    pub fn is_approval_rule_template_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApprovalRuleTemplateNameErrorKind::InvalidApprovalRuleTemplateNameException`.
    pub fn is_invalid_approval_rule_template_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApprovalRuleTemplateNameErrorKind::InvalidApprovalRuleTemplateNameException(_)
        )
    }
}
impl std::error::Error for UpdateApprovalRuleTemplateNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameAlreadyExistsException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::ApprovalRuleTemplateNameRequiredException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::InvalidApprovalRuleTemplateNameException(_inner) =>
            Some(_inner)
            ,
            UpdateApprovalRuleTemplateNameErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCommentError {
    /// Kind of error that occurred.
    pub kind: UpdateCommentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateComment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCommentErrorKind {
    /// <p>The comment is empty. You must provide some content for a comment. The content cannot be null.</p>
    CommentContentRequiredException(crate::error::CommentContentRequiredException),
    /// <p>The comment is too large. Comments are limited to 1,000 characters.</p>
    CommentContentSizeLimitExceededException(
        crate::error::CommentContentSizeLimitExceededException,
    ),
    /// <p>This comment has already been deleted. You cannot edit or delete a deleted comment.</p>
    CommentDeletedException(crate::error::CommentDeletedException),
    /// <p>No comment exists with the provided ID. Verify that you have used the correct ID, and
    /// then try again.</p>
    CommentDoesNotExistException(crate::error::CommentDoesNotExistException),
    /// <p>The comment ID is missing or null. A comment ID is required.</p>
    CommentIdRequiredException(crate::error::CommentIdRequiredException),
    /// <p>You cannot modify or delete this comment. Only comment authors can modify or delete their comments.</p>
    CommentNotCreatedByCallerException(crate::error::CommentNotCreatedByCallerException),
    /// <p>The comment ID is not in a valid format. Make sure that you have provided the full comment ID.</p>
    InvalidCommentIdException(crate::error::InvalidCommentIdException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCommentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCommentErrorKind::CommentContentRequiredException(_inner) => _inner.fmt(f),
            UpdateCommentErrorKind::CommentContentSizeLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCommentErrorKind::CommentDeletedException(_inner) => _inner.fmt(f),
            UpdateCommentErrorKind::CommentDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateCommentErrorKind::CommentIdRequiredException(_inner) => _inner.fmt(f),
            UpdateCommentErrorKind::CommentNotCreatedByCallerException(_inner) => _inner.fmt(f),
            UpdateCommentErrorKind::InvalidCommentIdException(_inner) => _inner.fmt(f),
            UpdateCommentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCommentError {
    fn code(&self) -> Option<&str> {
        UpdateCommentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCommentError {
    /// Creates a new `UpdateCommentError`.
    pub fn new(kind: UpdateCommentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCommentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCommentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCommentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCommentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCommentErrorKind::CommentContentRequiredException`.
    pub fn is_comment_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCommentErrorKind::CommentContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCommentErrorKind::CommentContentSizeLimitExceededException`.
    pub fn is_comment_content_size_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCommentErrorKind::CommentContentSizeLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCommentErrorKind::CommentDeletedException`.
    pub fn is_comment_deleted_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCommentErrorKind::CommentDeletedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCommentErrorKind::CommentDoesNotExistException`.
    pub fn is_comment_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCommentErrorKind::CommentDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCommentErrorKind::CommentIdRequiredException`.
    pub fn is_comment_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCommentErrorKind::CommentIdRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCommentErrorKind::CommentNotCreatedByCallerException`.
    pub fn is_comment_not_created_by_caller_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCommentErrorKind::CommentNotCreatedByCallerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCommentErrorKind::InvalidCommentIdException`.
    pub fn is_invalid_comment_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCommentErrorKind::InvalidCommentIdException(_)
        )
    }
}
impl std::error::Error for UpdateCommentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCommentErrorKind::CommentContentRequiredException(_inner) => Some(_inner),
            UpdateCommentErrorKind::CommentContentSizeLimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateCommentErrorKind::CommentDeletedException(_inner) => Some(_inner),
            UpdateCommentErrorKind::CommentDoesNotExistException(_inner) => Some(_inner),
            UpdateCommentErrorKind::CommentIdRequiredException(_inner) => Some(_inner),
            UpdateCommentErrorKind::CommentNotCreatedByCallerException(_inner) => Some(_inner),
            UpdateCommentErrorKind::InvalidCommentIdException(_inner) => Some(_inner),
            UpdateCommentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDefaultBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDefaultBranchError {
    /// Kind of error that occurred.
    pub kind: UpdateDefaultBranchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDefaultBranch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDefaultBranchErrorKind {
    /// <p>The specified branch does not exist.</p>
    BranchDoesNotExistException(crate::error::BranchDoesNotExistException),
    /// <p>A branch name is required, but was not specified.</p>
    BranchNameRequiredException(crate::error::BranchNameRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The specified reference name is not valid.</p>
    InvalidBranchNameException(crate::error::InvalidBranchNameException),
    /// <p>A specified repository name is not valid.</p>
    ///
    /// <note>
    /// <p>This exception occurs only when a specified repository name is not valid. Other
    /// exceptions occur when a required repository parameter is missing, or when a
    /// specified repository does not exist.</p>
    /// </note>
    InvalidRepositoryNameException(crate::error::InvalidRepositoryNameException),
    /// <p>The specified repository does not exist.</p>
    RepositoryDoesNotExistException(crate::error::RepositoryDoesNotExistException),
    /// <p>A repository name is required, but was not specified.</p>
    RepositoryNameRequiredException(crate::error::RepositoryNameRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDefaultBranchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDefaultBranchErrorKind::BranchDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::BranchNameRequiredException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDefaultBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDefaultBranchErrorKind::EncryptionKeyDisabledException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::EncryptionKeyNotFoundException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::EncryptionKeyUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            UpdateDefaultBranchErrorKind::InvalidBranchNameException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::InvalidRepositoryNameException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::RepositoryDoesNotExistException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::RepositoryNameRequiredException(_inner) => _inner.fmt(f),
            UpdateDefaultBranchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDefaultBranchError {
    fn code(&self) -> Option<&str> {
        UpdateDefaultBranchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDefaultBranchError {
    /// Creates a new `UpdateDefaultBranchError`.
    pub fn new(kind: UpdateDefaultBranchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDefaultBranchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDefaultBranchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDefaultBranchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDefaultBranchErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::BranchDoesNotExistException`.
    pub fn is_branch_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::BranchDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::BranchNameRequiredException`.
    pub fn is_branch_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::BranchNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::InvalidBranchNameException`.
    pub fn is_invalid_branch_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::InvalidBranchNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::InvalidRepositoryNameException`.
    pub fn is_invalid_repository_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::InvalidRepositoryNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::RepositoryDoesNotExistException`.
    pub fn is_repository_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::RepositoryDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDefaultBranchErrorKind::RepositoryNameRequiredException`.
    pub fn is_repository_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDefaultBranchErrorKind::RepositoryNameRequiredException(_)
        )
    }
}
impl std::error::Error for UpdateDefaultBranchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDefaultBranchErrorKind::BranchDoesNotExistException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::BranchNameRequiredException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::EncryptionIntegrityChecksFailedException(_inner) => {
                Some(_inner)
            }
            UpdateDefaultBranchErrorKind::EncryptionKeyAccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateDefaultBranchErrorKind::EncryptionKeyDisabledException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::EncryptionKeyNotFoundException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::EncryptionKeyUnavailableException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::InvalidBranchNameException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::InvalidRepositoryNameException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::RepositoryDoesNotExistException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::RepositoryNameRequiredException(_inner) => Some(_inner),
            UpdateDefaultBranchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePullRequestApprovalRuleContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePullRequestApprovalRuleContentError {
    /// Kind of error that occurred.
    pub kind: UpdatePullRequestApprovalRuleContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePullRequestApprovalRuleContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePullRequestApprovalRuleContentErrorKind {
    /// <p>The content for the approval rule is empty. You must provide some content for an approval rule. The content cannot be null.</p>
    ApprovalRuleContentRequiredException(crate::error::ApprovalRuleContentRequiredException),
    /// <p>The specified approval rule does not exist.</p>
    ApprovalRuleDoesNotExistException(crate::error::ApprovalRuleDoesNotExistException),
    /// <p>An approval rule name is required, but was not specified.</p>
    ApprovalRuleNameRequiredException(crate::error::ApprovalRuleNameRequiredException),
    /// <p>The approval rule cannot be modified for the pull request because it was created by an
    /// approval rule template and applied to the pull request automatically.</p>
    CannotModifyApprovalRuleFromTemplateException(
        crate::error::CannotModifyApprovalRuleFromTemplateException,
    ),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The content for the approval rule is not valid.</p>
    InvalidApprovalRuleContentException(crate::error::InvalidApprovalRuleContentException),
    /// <p>The name for the approval rule is not valid.</p>
    InvalidApprovalRuleNameException(crate::error::InvalidApprovalRuleNameException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The SHA-256 hash signature for the rule content is not valid.</p>
    InvalidRuleContentSha256Exception(crate::error::InvalidRuleContentSha256Exception),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePullRequestApprovalRuleContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleContentRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleNameRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::CannotModifyApprovalRuleFromTemplateException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleContentException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleNameException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidPullRequestIdException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidRuleContentSha256Exception(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestAlreadyClosedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePullRequestApprovalRuleContentError {
    fn code(&self) -> Option<&str> {
        UpdatePullRequestApprovalRuleContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePullRequestApprovalRuleContentError {
    /// Creates a new `UpdatePullRequestApprovalRuleContentError`.
    pub fn new(
        kind: UpdatePullRequestApprovalRuleContentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePullRequestApprovalRuleContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePullRequestApprovalRuleContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePullRequestApprovalRuleContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePullRequestApprovalRuleContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleContentRequiredException`.
    pub fn is_approval_rule_content_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleContentRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleDoesNotExistException`.
    pub fn is_approval_rule_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleNameRequiredException`.
    pub fn is_approval_rule_name_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleNameRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::CannotModifyApprovalRuleFromTemplateException`.
    pub fn is_cannot_modify_approval_rule_from_template_exception(&self) -> bool {
        matches!(&self.kind, UpdatePullRequestApprovalRuleContentErrorKind::CannotModifyApprovalRuleFromTemplateException(_))
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionIntegrityChecksFailedException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleContentException`.
    pub fn is_invalid_approval_rule_content_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleContentException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleNameException`.
    pub fn is_invalid_approval_rule_name_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleNameException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::InvalidRuleContentSha256Exception`.
    pub fn is_invalid_rule_content_sha256_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidRuleContentSha256Exception(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestDoesNotExistException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalRuleContentErrorKind::PullRequestIdRequiredException`.
    pub fn is_pull_request_id_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestIdRequiredException(_)
        )
    }
}
impl std::error::Error for UpdatePullRequestApprovalRuleContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleContentRequiredException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::ApprovalRuleNameRequiredException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::CannotModifyApprovalRuleFromTemplateException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyDisabledException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyNotFoundException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::EncryptionKeyUnavailableException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleContentException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidApprovalRuleNameException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidPullRequestIdException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::InvalidRuleContentSha256Exception(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestAlreadyClosedException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestDoesNotExistException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::PullRequestIdRequiredException(_inner) =>
            Some(_inner)
            ,
            UpdatePullRequestApprovalRuleContentErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdatePullRequestApprovalState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePullRequestApprovalStateError {
    /// Kind of error that occurred.
    pub kind: UpdatePullRequestApprovalStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePullRequestApprovalState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePullRequestApprovalStateErrorKind {
    /// <p>An approval state is required, but was not specified.</p>
    ApprovalStateRequiredException(crate::error::ApprovalStateRequiredException),
    /// <p>An encryption integrity check failed.</p>
    EncryptionIntegrityChecksFailedException(
        crate::error::EncryptionIntegrityChecksFailedException,
    ),
    /// <p>An encryption key could not be accessed.</p>
    EncryptionKeyAccessDeniedException(crate::error::EncryptionKeyAccessDeniedException),
    /// <p>The encryption key is disabled.</p>
    EncryptionKeyDisabledException(crate::error::EncryptionKeyDisabledException),
    /// <p>No encryption key was found.</p>
    EncryptionKeyNotFoundException(crate::error::EncryptionKeyNotFoundException),
    /// <p>The encryption key is not available.</p>
    EncryptionKeyUnavailableException(crate::error::EncryptionKeyUnavailableException),
    /// <p>The state for the approval is not valid. Valid values include APPROVE and REVOKE. </p>
    InvalidApprovalStateException(crate::error::InvalidApprovalStateException),
    /// <p>The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request is in the specified repository, and then try again.</p>
    InvalidPullRequestIdException(crate::error::InvalidPullRequestIdException),
    /// <p>The revision ID is not valid. Use GetPullRequest to determine the value.</p>
    InvalidRevisionIdException(crate::error::InvalidRevisionIdException),
    /// <p>The number of approvals required for the approval rule exceeds the maximum number allowed.</p>
    MaximumNumberOfApprovalsExceededException(
        crate::error::MaximumNumberOfApprovalsExceededException,
    ),
    /// <p>The pull request status cannot be updated because it is already closed.</p>
    PullRequestAlreadyClosedException(crate::error::PullRequestAlreadyClosedException),
    /// <p>The approval cannot be applied because the user approving the pull request matches the user who created the pull request. You cannot approve a pull
    /// request that you created.</p>
    PullRequestCannotBeApprovedByAuthorException(
        crate::error::PullRequestCannotBeApprovedByAuthorException,
    ),
    /// <p>The pull request ID could not be found. Make sure that you have specified the correct repository name and pull request ID, and then try again.</p>
    PullRequestDoesNotExistException(crate::error::PullRequestDoesNotExistException),
    /// <p>A pull request ID is required, but none was provided.</p>
    PullRequestIdRequiredException(crate::error::PullRequestIdRequiredException),
    /// <p>A revision ID is required, but was not provided.</p>
    RevisionIdRequiredException(crate::error::RevisionIdRequiredException),
    /// <p>The revision ID provided in the request does not match the current revision ID. Use GetPullRequest to retrieve the current revision ID.</p>
    RevisionNotCurrentException(crate::error::RevisionNotCurrentException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePullRequestApprovalStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePullRequestApprovalStateErrorKind::ApprovalStateRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::EncryptionIntegrityChecksFailedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyAccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyDisabledException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyNotFoundException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyUnavailableException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::InvalidApprovalStateException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::InvalidPullRequestIdException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::InvalidRevisionIdException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::MaximumNumberOfApprovalsExceededException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::PullRequestAlreadyClosedException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::PullRequestCannotBeApprovedByAuthorException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::PullRequestDoesNotExistException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::PullRequestIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::RevisionIdRequiredException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::RevisionNotCurrentException(_inner) =>
            _inner.fmt(f)
            ,
            UpdatePullRequestApprovalStateErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePullRequestApprovalStateError {
    fn code(&self) -> Option<&str> {
        UpdatePullRequestApprovalStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePullRequestApprovalStateError {
    /// Creates a new `UpdatePullRequestApprovalStateError`.
    pub fn new(
        kind: UpdatePullRequestApprovalStateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePullRequestApprovalStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePullRequestApprovalStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePullRequestApprovalStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePullRequestApprovalStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::ApprovalStateRequiredException`.
    pub fn is_approval_state_required_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::ApprovalStateRequiredException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::EncryptionIntegrityChecksFailedException`.
    pub fn is_encryption_integrity_checks_failed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::EncryptionIntegrityChecksFailedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::EncryptionKeyAccessDeniedException`.
    pub fn is_encryption_key_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyAccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::EncryptionKeyDisabledException`.
    pub fn is_encryption_key_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::EncryptionKeyNotFoundException`.
    pub fn is_encryption_key_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::EncryptionKeyUnavailableException`.
    pub fn is_encryption_key_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::EncryptionKeyUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::InvalidApprovalStateException`.
    pub fn is_invalid_approval_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::InvalidApprovalStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::InvalidPullRequestIdException`.
    pub fn is_invalid_pull_request_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::InvalidPullRequestIdException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::InvalidRevisionIdException`.
    pub fn is_invalid_revision_id_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::InvalidRevisionIdException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::MaximumNumberOfApprovalsExceededException`.
    pub fn is_maximum_number_of_approvals_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::MaximumNumberOfApprovalsExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::PullRequestAlreadyClosedException`.
    pub fn is_pull_request_already_closed_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::PullRequestAlreadyClosedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::PullRequestCannotBeApprovedByAuthorException`.
    pub fn is_pull_request_cannot_be_approved_by_author_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePullRequestApprovalStateErrorKind::PullRequestCannotBeApprovedByAuthorException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `UpdatePullRequestApprovalStateErrorKind::PullRequestDoesNotExistException`.
    pub fn is_pull_request_does_not_exist_exception(&s