// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `BatchDeleteBuilds`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_builds`](crate::client::Client::batch_delete_builds).
///
/// See [`crate::client::fluent_builders::BatchDeleteBuilds`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteBuilds {
    _private: (),
}
impl BatchDeleteBuilds {
    /// Creates a new builder-style object to manufacture [`BatchDeleteBuildsInput`](crate::input::BatchDeleteBuildsInput)
    pub fn builder() -> crate::input::batch_delete_builds_input::Builder {
        crate::input::batch_delete_builds_input::Builder::default()
    }
    /// Creates a new `BatchDeleteBuilds` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteBuilds {
    type Output = std::result::Result<
        crate::output::BatchDeleteBuildsOutput,
        crate::error::BatchDeleteBuildsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_builds_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_builds_response(response)
        }
    }
}

/// Operation shape for `BatchGetBuildBatches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_build_batches`](crate::client::Client::batch_get_build_batches).
///
/// See [`crate::client::fluent_builders::BatchGetBuildBatches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetBuildBatches {
    _private: (),
}
impl BatchGetBuildBatches {
    /// Creates a new builder-style object to manufacture [`BatchGetBuildBatchesInput`](crate::input::BatchGetBuildBatchesInput)
    pub fn builder() -> crate::input::batch_get_build_batches_input::Builder {
        crate::input::batch_get_build_batches_input::Builder::default()
    }
    /// Creates a new `BatchGetBuildBatches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetBuildBatches {
    type Output = std::result::Result<
        crate::output::BatchGetBuildBatchesOutput,
        crate::error::BatchGetBuildBatchesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_build_batches_error(response)
        } else {
            crate::operation_deser::parse_batch_get_build_batches_response(response)
        }
    }
}

/// Operation shape for `BatchGetBuilds`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_builds`](crate::client::Client::batch_get_builds).
///
/// See [`crate::client::fluent_builders::BatchGetBuilds`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetBuilds {
    _private: (),
}
impl BatchGetBuilds {
    /// Creates a new builder-style object to manufacture [`BatchGetBuildsInput`](crate::input::BatchGetBuildsInput)
    pub fn builder() -> crate::input::batch_get_builds_input::Builder {
        crate::input::batch_get_builds_input::Builder::default()
    }
    /// Creates a new `BatchGetBuilds` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetBuilds {
    type Output =
        std::result::Result<crate::output::BatchGetBuildsOutput, crate::error::BatchGetBuildsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_builds_error(response)
        } else {
            crate::operation_deser::parse_batch_get_builds_response(response)
        }
    }
}

/// Operation shape for `BatchGetProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_projects`](crate::client::Client::batch_get_projects).
///
/// See [`crate::client::fluent_builders::BatchGetProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetProjects {
    _private: (),
}
impl BatchGetProjects {
    /// Creates a new builder-style object to manufacture [`BatchGetProjectsInput`](crate::input::BatchGetProjectsInput)
    pub fn builder() -> crate::input::batch_get_projects_input::Builder {
        crate::input::batch_get_projects_input::Builder::default()
    }
    /// Creates a new `BatchGetProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetProjects {
    type Output = std::result::Result<
        crate::output::BatchGetProjectsOutput,
        crate::error::BatchGetProjectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_projects_error(response)
        } else {
            crate::operation_deser::parse_batch_get_projects_response(response)
        }
    }
}

/// Operation shape for `BatchGetReportGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_report_groups`](crate::client::Client::batch_get_report_groups).
///
/// See [`crate::client::fluent_builders::BatchGetReportGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetReportGroups {
    _private: (),
}
impl BatchGetReportGroups {
    /// Creates a new builder-style object to manufacture [`BatchGetReportGroupsInput`](crate::input::BatchGetReportGroupsInput)
    pub fn builder() -> crate::input::batch_get_report_groups_input::Builder {
        crate::input::batch_get_report_groups_input::Builder::default()
    }
    /// Creates a new `BatchGetReportGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetReportGroups {
    type Output = std::result::Result<
        crate::output::BatchGetReportGroupsOutput,
        crate::error::BatchGetReportGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_report_groups_error(response)
        } else {
            crate::operation_deser::parse_batch_get_report_groups_response(response)
        }
    }
}

/// Operation shape for `BatchGetReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_reports`](crate::client::Client::batch_get_reports).
///
/// See [`crate::client::fluent_builders::BatchGetReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetReports {
    _private: (),
}
impl BatchGetReports {
    /// Creates a new builder-style object to manufacture [`BatchGetReportsInput`](crate::input::BatchGetReportsInput)
    pub fn builder() -> crate::input::batch_get_reports_input::Builder {
        crate::input::batch_get_reports_input::Builder::default()
    }
    /// Creates a new `BatchGetReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetReports {
    type Output = std::result::Result<
        crate::output::BatchGetReportsOutput,
        crate::error::BatchGetReportsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_reports_error(response)
        } else {
            crate::operation_deser::parse_batch_get_reports_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `CreateReportGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_report_group`](crate::client::Client::create_report_group).
///
/// See [`crate::client::fluent_builders::CreateReportGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateReportGroup {
    _private: (),
}
impl CreateReportGroup {
    /// Creates a new builder-style object to manufacture [`CreateReportGroupInput`](crate::input::CreateReportGroupInput)
    pub fn builder() -> crate::input::create_report_group_input::Builder {
        crate::input::create_report_group_input::Builder::default()
    }
    /// Creates a new `CreateReportGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateReportGroup {
    type Output = std::result::Result<
        crate::output::CreateReportGroupOutput,
        crate::error::CreateReportGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_report_group_error(response)
        } else {
            crate::operation_deser::parse_create_report_group_response(response)
        }
    }
}

/// Operation shape for `CreateWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_webhook`](crate::client::Client::create_webhook).
///
/// See [`crate::client::fluent_builders::CreateWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateWebhook {
    _private: (),
}
impl CreateWebhook {
    /// Creates a new builder-style object to manufacture [`CreateWebhookInput`](crate::input::CreateWebhookInput)
    pub fn builder() -> crate::input::create_webhook_input::Builder {
        crate::input::create_webhook_input::Builder::default()
    }
    /// Creates a new `CreateWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateWebhook {
    type Output =
        std::result::Result<crate::output::CreateWebhookOutput, crate::error::CreateWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_webhook_error(response)
        } else {
            crate::operation_deser::parse_create_webhook_response(response)
        }
    }
}

/// Operation shape for `DeleteBuildBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_build_batch`](crate::client::Client::delete_build_batch).
///
/// See [`crate::client::fluent_builders::DeleteBuildBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBuildBatch {
    _private: (),
}
impl DeleteBuildBatch {
    /// Creates a new builder-style object to manufacture [`DeleteBuildBatchInput`](crate::input::DeleteBuildBatchInput)
    pub fn builder() -> crate::input::delete_build_batch_input::Builder {
        crate::input::delete_build_batch_input::Builder::default()
    }
    /// Creates a new `DeleteBuildBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBuildBatch {
    type Output = std::result::Result<
        crate::output::DeleteBuildBatchOutput,
        crate::error::DeleteBuildBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_build_batch_error(response)
        } else {
            crate::operation_deser::parse_delete_build_batch_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `DeleteReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_report`](crate::client::Client::delete_report).
///
/// See [`crate::client::fluent_builders::DeleteReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReport {
    _private: (),
}
impl DeleteReport {
    /// Creates a new builder-style object to manufacture [`DeleteReportInput`](crate::input::DeleteReportInput)
    pub fn builder() -> crate::input::delete_report_input::Builder {
        crate::input::delete_report_input::Builder::default()
    }
    /// Creates a new `DeleteReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReport {
    type Output =
        std::result::Result<crate::output::DeleteReportOutput, crate::error::DeleteReportError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_report_error(response)
        } else {
            crate::operation_deser::parse_delete_report_response(response)
        }
    }
}

/// Operation shape for `DeleteReportGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_report_group`](crate::client::Client::delete_report_group).
///
/// See [`crate::client::fluent_builders::DeleteReportGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReportGroup {
    _private: (),
}
impl DeleteReportGroup {
    /// Creates a new builder-style object to manufacture [`DeleteReportGroupInput`](crate::input::DeleteReportGroupInput)
    pub fn builder() -> crate::input::delete_report_group_input::Builder {
        crate::input::delete_report_group_input::Builder::default()
    }
    /// Creates a new `DeleteReportGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReportGroup {
    type Output = std::result::Result<
        crate::output::DeleteReportGroupOutput,
        crate::error::DeleteReportGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_report_group_error(response)
        } else {
            crate::operation_deser::parse_delete_report_group_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteSourceCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_source_credentials`](crate::client::Client::delete_source_credentials).
///
/// See [`crate::client::fluent_builders::DeleteSourceCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSourceCredentials {
    _private: (),
}
impl DeleteSourceCredentials {
    /// Creates a new builder-style object to manufacture [`DeleteSourceCredentialsInput`](crate::input::DeleteSourceCredentialsInput)
    pub fn builder() -> crate::input::delete_source_credentials_input::Builder {
        crate::input::delete_source_credentials_input::Builder::default()
    }
    /// Creates a new `DeleteSourceCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSourceCredentials {
    type Output = std::result::Result<
        crate::output::DeleteSourceCredentialsOutput,
        crate::error::DeleteSourceCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_source_credentials_error(response)
        } else {
            crate::operation_deser::parse_delete_source_credentials_response(response)
        }
    }
}

/// Operation shape for `DeleteWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_webhook`](crate::client::Client::delete_webhook).
///
/// See [`crate::client::fluent_builders::DeleteWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteWebhook {
    _private: (),
}
impl DeleteWebhook {
    /// Creates a new builder-style object to manufacture [`DeleteWebhookInput`](crate::input::DeleteWebhookInput)
    pub fn builder() -> crate::input::delete_webhook_input::Builder {
        crate::input::delete_webhook_input::Builder::default()
    }
    /// Creates a new `DeleteWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteWebhook {
    type Output =
        std::result::Result<crate::output::DeleteWebhookOutput, crate::error::DeleteWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_webhook_error(response)
        } else {
            crate::operation_deser::parse_delete_webhook_response(response)
        }
    }
}

/// Operation shape for `DescribeCodeCoverages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_code_coverages`](crate::client::Client::describe_code_coverages).
///
/// See [`crate::client::fluent_builders::DescribeCodeCoverages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCodeCoverages {
    _private: (),
}
impl DescribeCodeCoverages {
    /// Creates a new builder-style object to manufacture [`DescribeCodeCoveragesInput`](crate::input::DescribeCodeCoveragesInput)
    pub fn builder() -> crate::input::describe_code_coverages_input::Builder {
        crate::input::describe_code_coverages_input::Builder::default()
    }
    /// Creates a new `DescribeCodeCoverages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCodeCoverages {
    type Output = std::result::Result<
        crate::output::DescribeCodeCoveragesOutput,
        crate::error::DescribeCodeCoveragesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_code_coverages_error(response)
        } else {
            crate::operation_deser::parse_describe_code_coverages_response(response)
        }
    }
}

/// Operation shape for `DescribeTestCases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_test_cases`](crate::client::Client::describe_test_cases).
///
/// See [`crate::client::fluent_builders::DescribeTestCases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTestCases {
    _private: (),
}
impl DescribeTestCases {
    /// Creates a new builder-style object to manufacture [`DescribeTestCasesInput`](crate::input::DescribeTestCasesInput)
    pub fn builder() -> crate::input::describe_test_cases_input::Builder {
        crate::input::describe_test_cases_input::Builder::default()
    }
    /// Creates a new `DescribeTestCases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTestCases {
    type Output = std::result::Result<
        crate::output::DescribeTestCasesOutput,
        crate::error::DescribeTestCasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_test_cases_error(response)
        } else {
            crate::operation_deser::parse_describe_test_cases_response(response)
        }
    }
}

/// Operation shape for `GetReportGroupTrend`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_report_group_trend`](crate::client::Client::get_report_group_trend).
///
/// See [`crate::client::fluent_builders::GetReportGroupTrend`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReportGroupTrend {
    _private: (),
}
impl GetReportGroupTrend {
    /// Creates a new builder-style object to manufacture [`GetReportGroupTrendInput`](crate::input::GetReportGroupTrendInput)
    pub fn builder() -> crate::input::get_report_group_trend_input::Builder {
        crate::input::get_report_group_trend_input::Builder::default()
    }
    /// Creates a new `GetReportGroupTrend` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReportGroupTrend {
    type Output = std::result::Result<
        crate::output::GetReportGroupTrendOutput,
        crate::error::GetReportGroupTrendError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_report_group_trend_error(response)
        } else {
            crate::operation_deser::parse_get_report_group_trend_response(response)
        }
    }
}

/// Operation shape for `GetResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_resource_policy`](crate::client::Client::get_resource_policy).
///
/// See [`crate::client::fluent_builders::GetResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetResourcePolicy {
    _private: (),
}
impl GetResourcePolicy {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyInput`](crate::input::GetResourcePolicyInput)
    pub fn builder() -> crate::input::get_resource_policy_input::Builder {
        crate::input::get_resource_policy_input::Builder::default()
    }
    /// Creates a new `GetResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetResourcePolicy {
    type Output = std::result::Result<
        crate::output::GetResourcePolicyOutput,
        crate::error::GetResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_get_resource_policy_response(response)
        }
    }
}

/// Operation shape for `ImportSourceCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_source_credentials`](crate::client::Client::import_source_credentials).
///
/// See [`crate::client::fluent_builders::ImportSourceCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportSourceCredentials {
    _private: (),
}
impl ImportSourceCredentials {
    /// Creates a new builder-style object to manufacture [`ImportSourceCredentialsInput`](crate::input::ImportSourceCredentialsInput)
    pub fn builder() -> crate::input::import_source_credentials_input::Builder {
        crate::input::import_source_credentials_input::Builder::default()
    }
    /// Creates a new `ImportSourceCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportSourceCredentials {
    type Output = std::result::Result<
        crate::output::ImportSourceCredentialsOutput,
        crate::error::ImportSourceCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_source_credentials_error(response)
        } else {
            crate::operation_deser::parse_import_source_credentials_response(response)
        }
    }
}

/// Operation shape for `InvalidateProjectCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`invalidate_project_cache`](crate::client::Client::invalidate_project_cache).
///
/// See [`crate::client::fluent_builders::InvalidateProjectCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct InvalidateProjectCache {
    _private: (),
}
impl InvalidateProjectCache {
    /// Creates a new builder-style object to manufacture [`InvalidateProjectCacheInput`](crate::input::InvalidateProjectCacheInput)
    pub fn builder() -> crate::input::invalidate_project_cache_input::Builder {
        crate::input::invalidate_project_cache_input::Builder::default()
    }
    /// Creates a new `InvalidateProjectCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for InvalidateProjectCache {
    type Output = std::result::Result<
        crate::output::InvalidateProjectCacheOutput,
        crate::error::InvalidateProjectCacheError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_invalidate_project_cache_error(response)
        } else {
            crate::operation_deser::parse_invalidate_project_cache_response(response)
        }
    }
}

/// Operation shape for `ListBuildBatches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_build_batches`](crate::client::Client::list_build_batches).
///
/// See [`crate::client::fluent_builders::ListBuildBatches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuildBatches {
    _private: (),
}
impl ListBuildBatches {
    /// Creates a new builder-style object to manufacture [`ListBuildBatchesInput`](crate::input::ListBuildBatchesInput)
    pub fn builder() -> crate::input::list_build_batches_input::Builder {
        crate::input::list_build_batches_input::Builder::default()
    }
    /// Creates a new `ListBuildBatches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuildBatches {
    type Output = std::result::Result<
        crate::output::ListBuildBatchesOutput,
        crate::error::ListBuildBatchesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_build_batches_error(response)
        } else {
            crate::operation_deser::parse_list_build_batches_response(response)
        }
    }
}

/// Operation shape for `ListBuildBatchesForProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_build_batches_for_project`](crate::client::Client::list_build_batches_for_project).
///
/// See [`crate::client::fluent_builders::ListBuildBatchesForProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuildBatchesForProject {
    _private: (),
}
impl ListBuildBatchesForProject {
    /// Creates a new builder-style object to manufacture [`ListBuildBatchesForProjectInput`](crate::input::ListBuildBatchesForProjectInput)
    pub fn builder() -> crate::input::list_build_batches_for_project_input::Builder {
        crate::input::list_build_batches_for_project_input::Builder::default()
    }
    /// Creates a new `ListBuildBatchesForProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuildBatchesForProject {
    type Output = std::result::Result<
        crate::output::ListBuildBatchesForProjectOutput,
        crate::error::ListBuildBatchesForProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_build_batches_for_project_error(response)
        } else {
            crate::operation_deser::parse_list_build_batches_for_project_response(response)
        }
    }
}

/// Operation shape for `ListBuilds`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_builds`](crate::client::Client::list_builds).
///
/// See [`crate::client::fluent_builders::ListBuilds`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuilds {
    _private: (),
}
impl ListBuilds {
    /// Creates a new builder-style object to manufacture [`ListBuildsInput`](crate::input::ListBuildsInput)
    pub fn builder() -> crate::input::list_builds_input::Builder {
        crate::input::list_builds_input::Builder::default()
    }
    /// Creates a new `ListBuilds` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuilds {
    type Output =
        std::result::Result<crate::output::ListBuildsOutput, crate::error::ListBuildsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_builds_error(response)
        } else {
            crate::operation_deser::parse_list_builds_response(response)
        }
    }
}

/// Operation shape for `ListBuildsForProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_builds_for_project`](crate::client::Client::list_builds_for_project).
///
/// See [`crate::client::fluent_builders::ListBuildsForProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListBuildsForProject {
    _private: (),
}
impl ListBuildsForProject {
    /// Creates a new builder-style object to manufacture [`ListBuildsForProjectInput`](crate::input::ListBuildsForProjectInput)
    pub fn builder() -> crate::input::list_builds_for_project_input::Builder {
        crate::input::list_builds_for_project_input::Builder::default()
    }
    /// Creates a new `ListBuildsForProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListBuildsForProject {
    type Output = std::result::Result<
        crate::output::ListBuildsForProjectOutput,
        crate::error::ListBuildsForProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_builds_for_project_error(response)
        } else {
            crate::operation_deser::parse_list_builds_for_project_response(response)
        }
    }
}

/// Operation shape for `ListCuratedEnvironmentImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_curated_environment_images`](crate::client::Client::list_curated_environment_images).
///
/// See [`crate::client::fluent_builders::ListCuratedEnvironmentImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCuratedEnvironmentImages {
    _private: (),
}
impl ListCuratedEnvironmentImages {
    /// Creates a new builder-style object to manufacture [`ListCuratedEnvironmentImagesInput`](crate::input::ListCuratedEnvironmentImagesInput)
    pub fn builder() -> crate::input::list_curated_environment_images_input::Builder {
        crate::input::list_curated_environment_images_input::Builder::default()
    }
    /// Creates a new `ListCuratedEnvironmentImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCuratedEnvironmentImages {
    type Output = std::result::Result<
        crate::output::ListCuratedEnvironmentImagesOutput,
        crate::error::ListCuratedEnvironmentImagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_curated_environment_images_error(response)
        } else {
            crate::operation_deser::parse_list_curated_environment_images_response(response)
        }
    }
}

/// Operation shape for `ListProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_projects`](crate::client::Client::list_projects).
///
/// See [`crate::client::fluent_builders::ListProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjects {
    _private: (),
}
impl ListProjects {
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
    /// Creates a new `ListProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjects {
    type Output =
        std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_projects_error(response)
        } else {
            crate::operation_deser::parse_list_projects_response(response)
        }
    }
}

/// Operation shape for `ListReportGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_report_groups`](crate::client::Client::list_report_groups).
///
/// See [`crate::client::fluent_builders::ListReportGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReportGroups {
    _private: (),
}
impl ListReportGroups {
    /// Creates a new builder-style object to manufacture [`ListReportGroupsInput`](crate::input::ListReportGroupsInput)
    pub fn builder() -> crate::input::list_report_groups_input::Builder {
        crate::input::list_report_groups_input::Builder::default()
    }
    /// Creates a new `ListReportGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReportGroups {
    type Output = std::result::Result<
        crate::output::ListReportGroupsOutput,
        crate::error::ListReportGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_report_groups_error(response)
        } else {
            crate::operation_deser::parse_list_report_groups_response(response)
        }
    }
}

/// Operation shape for `ListReports`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_reports`](crate::client::Client::list_reports).
///
/// See [`crate::client::fluent_builders::ListReports`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReports {
    _private: (),
}
impl ListReports {
    /// Creates a new builder-style object to manufacture [`ListReportsInput`](crate::input::ListReportsInput)
    pub fn builder() -> crate::input::list_reports_input::Builder {
        crate::input::list_reports_input::Builder::default()
    }
    /// Creates a new `ListReports` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReports {
    type Output =
        std::result::Result<crate::output::ListReportsOutput, crate::error::ListReportsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_reports_error(response)
        } else {
            crate::operation_deser::parse_list_reports_response(response)
        }
    }
}

/// Operation shape for `ListReportsForReportGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_reports_for_report_group`](crate::client::Client::list_reports_for_report_group).
///
/// See [`crate::client::fluent_builders::ListReportsForReportGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReportsForReportGroup {
    _private: (),
}
impl ListReportsForReportGroup {
    /// Creates a new builder-style object to manufacture [`ListReportsForReportGroupInput`](crate::input::ListReportsForReportGroupInput)
    pub fn builder() -> crate::input::list_reports_for_report_group_input::Builder {
        crate::input::list_reports_for_report_group_input::Builder::default()
    }
    /// Creates a new `ListReportsForReportGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReportsForReportGroup {
    type Output = std::result::Result<
        crate::output::ListReportsForReportGroupOutput,
        crate::error::ListReportsForReportGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_reports_for_report_group_error(response)
        } else {
            crate::operation_deser::parse_list_reports_for_report_group_response(response)
        }
    }
}

/// Operation shape for `ListSharedProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_shared_projects`](crate::client::Client::list_shared_projects).
///
/// See [`crate::client::fluent_builders::ListSharedProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSharedProjects {
    _private: (),
}
impl ListSharedProjects {
    /// Creates a new builder-style object to manufacture [`ListSharedProjectsInput`](crate::input::ListSharedProjectsInput)
    pub fn builder() -> crate::input::list_shared_projects_input::Builder {
        crate::input::list_shared_projects_input::Builder::default()
    }
    /// Creates a new `ListSharedProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSharedProjects {
    type Output = std::result::Result<
        crate::output::ListSharedProjectsOutput,
        crate::error::ListSharedProjectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_shared_projects_error(response)
        } else {
            crate::operation_deser::parse_list_shared_projects_response(response)
        }
    }
}

/// Operation shape for `ListSharedReportGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_shared_report_groups`](crate::client::Client::list_shared_report_groups).
///
/// See [`crate::client::fluent_builders::ListSharedReportGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSharedReportGroups {
    _private: (),
}
impl ListSharedReportGroups {
    /// Creates a new builder-style object to manufacture [`ListSharedReportGroupsInput`](crate::input::ListSharedReportGroupsInput)
    pub fn builder() -> crate::input::list_shared_report_groups_input::Builder {
        crate::input::list_shared_report_groups_input::Builder::default()
    }
    /// Creates a new `ListSharedReportGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSharedReportGroups {
    type Output = std::result::Result<
        crate::output::ListSharedReportGroupsOutput,
        crate::error::ListSharedReportGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_shared_report_groups_error(response)
        } else {
            crate::operation_deser::parse_list_shared_report_groups_response(response)
        }
    }
}

/// Operation shape for `ListSourceCredentials`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_source_credentials`](crate::client::Client::list_source_credentials).
///
/// See [`crate::client::fluent_builders::ListSourceCredentials`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListSourceCredentials {
    _private: (),
}
impl ListSourceCredentials {
    /// Creates a new builder-style object to manufacture [`ListSourceCredentialsInput`](crate::input::ListSourceCredentialsInput)
    pub fn builder() -> crate::input::list_source_credentials_input::Builder {
        crate::input::list_source_credentials_input::Builder::default()
    }
    /// Creates a new `ListSourceCredentials` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListSourceCredentials {
    type Output = std::result::Result<
        crate::output::ListSourceCredentialsOutput,
        crate::error::ListSourceCredentialsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_source_credentials_error(response)
        } else {
            crate::operation_deser::parse_list_source_credentials_response(response)
        }
    }
}

/// Operation shape for `PutResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_policy`](crate::client::Client::put_resource_policy).
///
/// See [`crate::client::fluent_builders::PutResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourcePolicy {
    _private: (),
}
impl PutResourcePolicy {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
    /// Creates a new `PutResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourcePolicy {
    type Output = std::result::Result<
        crate::output::PutResourcePolicyOutput,
        crate::error::PutResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resource_policy_response(response)
        }
    }
}

/// Operation shape for `RetryBuild`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retry_build`](crate::client::Client::retry_build).
///
/// See [`crate::client::fluent_builders::RetryBuild`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetryBuild {
    _private: (),
}
impl RetryBuild {
    /// Creates a new builder-style object to manufacture [`RetryBuildInput`](crate::input::RetryBuildInput)
    pub fn builder() -> crate::input::retry_build_input::Builder {
        crate::input::retry_build_input::Builder::default()
    }
    /// Creates a new `RetryBuild` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetryBuild {
    type Output =
        std::result::Result<crate::output::RetryBuildOutput, crate::error::RetryBuildError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retry_build_error(response)
        } else {
            crate::operation_deser::parse_retry_build_response(response)
        }
    }
}

/// Operation shape for `RetryBuildBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`retry_build_batch`](crate::client::Client::retry_build_batch).
///
/// See [`crate::client::fluent_builders::RetryBuildBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RetryBuildBatch {
    _private: (),
}
impl RetryBuildBatch {
    /// Creates a new builder-style object to manufacture [`RetryBuildBatchInput`](crate::input::RetryBuildBatchInput)
    pub fn builder() -> crate::input::retry_build_batch_input::Builder {
        crate::input::retry_build_batch_input::Builder::default()
    }
    /// Creates a new `RetryBuildBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RetryBuildBatch {
    type Output = std::result::Result<
        crate::output::RetryBuildBatchOutput,
        crate::error::RetryBuildBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_retry_build_batch_error(response)
        } else {
            crate::operation_deser::parse_retry_build_batch_response(response)
        }
    }
}

/// Operation shape for `StartBuild`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_build`](crate::client::Client::start_build).
///
/// See [`crate::client::fluent_builders::StartBuild`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBuild {
    _private: (),
}
impl StartBuild {
    /// Creates a new builder-style object to manufacture [`StartBuildInput`](crate::input::StartBuildInput)
    pub fn builder() -> crate::input::start_build_input::Builder {
        crate::input::start_build_input::Builder::default()
    }
    /// Creates a new `StartBuild` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartBuild {
    type Output =
        std::result::Result<crate::output::StartBuildOutput, crate::error::StartBuildError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_build_error(response)
        } else {
            crate::operation_deser::parse_start_build_response(response)
        }
    }
}

/// Operation shape for `StartBuildBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_build_batch`](crate::client::Client::start_build_batch).
///
/// See [`crate::client::fluent_builders::StartBuildBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartBuildBatch {
    _private: (),
}
impl StartBuildBatch {
    /// Creates a new builder-style object to manufacture [`StartBuildBatchInput`](crate::input::StartBuildBatchInput)
    pub fn builder() -> crate::input::start_build_batch_input::Builder {
        crate::input::start_build_batch_input::Builder::default()
    }
    /// Creates a new `StartBuildBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartBuildBatch {
    type Output = std::result::Result<
        crate::output::StartBuildBatchOutput,
        crate::error::StartBuildBatchError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_build_batch_error(response)
        } else {
            crate::operation_deser::parse_start_build_batch_response(response)
        }
    }
}

/// Operation shape for `StopBuild`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_build`](crate::client::Client::stop_build).
///
/// See [`crate::client::fluent_builders::StopBuild`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopBuild {
    _private: (),
}
impl StopBuild {
    /// Creates a new builder-style object to manufacture [`StopBuildInput`](crate::input::StopBuildInput)
    pub fn builder() -> crate::input::stop_build_input::Builder {
        crate::input::stop_build_input::Builder::default()
    }
    /// Creates a new `StopBuild` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopBuild {
    type Output = std::result::Result<crate::output::StopBuildOutput, crate::error::StopBuildError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_build_error(response)
        } else {
            crate::operation_deser::parse_stop_build_response(response)
        }
    }
}

/// Operation shape for `StopBuildBatch`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_build_batch`](crate::client::Client::stop_build_batch).
///
/// See [`crate::client::fluent_builders::StopBuildBatch`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopBuildBatch {
    _private: (),
}
impl StopBuildBatch {
    /// Creates a new builder-style object to manufacture [`StopBuildBatchInput`](crate::input::StopBuildBatchInput)
    pub fn builder() -> crate::input::stop_build_batch_input::Builder {
        crate::input::stop_build_batch_input::Builder::default()
    }
    /// Creates a new `StopBuildBatch` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopBuildBatch {
    type Output =
        std::result::Result<crate::output::StopBuildBatchOutput, crate::error::StopBuildBatchError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_build_batch_error(response)
        } else {
            crate::operation_deser::parse_stop_build_batch_response(response)
        }
    }
}

/// Operation shape for `UpdateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_project`](crate::client::Client::update_project).
///
/// See [`crate::client::fluent_builders::UpdateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProject {
    _private: (),
}
impl UpdateProject {
    /// Creates a new builder-style object to manufacture [`UpdateProjectInput`](crate::input::UpdateProjectInput)
    pub fn builder() -> crate::input::update_project_input::Builder {
        crate::input::update_project_input::Builder::default()
    }
    /// Creates a new `UpdateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProject {
    type Output =
        std::result::Result<crate::output::UpdateProjectOutput, crate::error::UpdateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_project_error(response)
        } else {
            crate::operation_deser::parse_update_project_response(response)
        }
    }
}

/// Operation shape for `UpdateProjectVisibility`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_project_visibility`](crate::client::Client::update_project_visibility).
///
/// See [`crate::client::fluent_builders::UpdateProjectVisibility`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProjectVisibility {
    _private: (),
}
impl UpdateProjectVisibility {
    /// Creates a new builder-style object to manufacture [`UpdateProjectVisibilityInput`](crate::input::UpdateProjectVisibilityInput)
    pub fn builder() -> crate::input::update_project_visibility_input::Builder {
        crate::input::update_project_visibility_input::Builder::default()
    }
    /// Creates a new `UpdateProjectVisibility` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProjectVisibility {
    type Output = std::result::Result<
        crate::output::UpdateProjectVisibilityOutput,
        crate::error::UpdateProjectVisibilityError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_project_visibility_error(response)
        } else {
            crate::operation_deser::parse_update_project_visibility_response(response)
        }
    }
}

/// Operation shape for `UpdateReportGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_report_group`](crate::client::Client::update_report_group).
///
/// See [`crate::client::fluent_builders::UpdateReportGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReportGroup {
    _private: (),
}
impl UpdateReportGroup {
    /// Creates a new builder-style object to manufacture [`UpdateReportGroupInput`](crate::input::UpdateReportGroupInput)
    pub fn builder() -> crate::input::update_report_group_input::Builder {
        crate::input::update_report_group_input::Builder::default()
    }
    /// Creates a new `UpdateReportGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReportGroup {
    type Output = std::result::Result<
        crate::output::UpdateReportGroupOutput,
        crate::error::UpdateReportGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_report_group_error(response)
        } else {
            crate::operation_deser::parse_update_report_group_response(response)
        }
    }
}

/// Operation shape for `UpdateWebhook`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_webhook`](crate::client::Client::update_webhook).
///
/// See [`crate::client::fluent_builders::UpdateWebhook`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateWebhook {
    _private: (),
}
impl UpdateWebhook {
    /// Creates a new builder-style object to manufacture [`UpdateWebhookInput`](crate::input::UpdateWebhookInput)
    pub fn builder() -> crate::input::update_webhook_input::Builder {
        crate::input::update_webhook_input::Builder::default()
    }
    /// Creates a new `UpdateWebhook` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateWebhook {
    type Output =
        std::result::Result<crate::output::UpdateWebhookOutput, crate::error::UpdateWebhookError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_webhook_error(response)
        } else {
            crate::operation_deser::parse_update_webhook_response(response)
        }
    }
}
