// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchDeleteBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteBuildsError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteBuildsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteBuildsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteBuildsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteBuildsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchDeleteBuildsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteBuildsError {
    fn code(&self) -> Option<&str> {
        BatchDeleteBuildsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteBuildsError {
    /// Creates a new `BatchDeleteBuildsError`.
    pub fn new(kind: BatchDeleteBuildsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteBuildsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteBuildsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteBuildsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteBuildsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteBuildsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteBuildsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for BatchDeleteBuildsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteBuildsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchDeleteBuildsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetBuildBatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetBuildBatchesError {
    /// Kind of error that occurred.
    pub kind: BatchGetBuildBatchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetBuildBatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetBuildBatchesErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetBuildBatchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetBuildBatchesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetBuildBatchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetBuildBatchesError {
    fn code(&self) -> Option<&str> {
        BatchGetBuildBatchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetBuildBatchesError {
    /// Creates a new `BatchGetBuildBatchesError`.
    pub fn new(kind: BatchGetBuildBatchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetBuildBatchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetBuildBatchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetBuildBatchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetBuildBatchesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetBuildBatchesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetBuildBatchesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for BatchGetBuildBatchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetBuildBatchesErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetBuildBatchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetBuildsError {
    /// Kind of error that occurred.
    pub kind: BatchGetBuildsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetBuildsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetBuildsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetBuildsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetBuildsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetBuildsError {
    fn code(&self) -> Option<&str> {
        BatchGetBuildsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetBuildsError {
    /// Creates a new `BatchGetBuildsError`.
    pub fn new(kind: BatchGetBuildsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetBuildsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetBuildsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetBuildsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetBuildsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetBuildsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetBuildsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for BatchGetBuildsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetBuildsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetBuildsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetProjectsError {
    /// Kind of error that occurred.
    pub kind: BatchGetProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetProjectsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetProjectsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetProjectsError {
    fn code(&self) -> Option<&str> {
        BatchGetProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetProjectsError {
    /// Creates a new `BatchGetProjectsError`.
    pub fn new(kind: BatchGetProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetProjectsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetProjectsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetProjectsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for BatchGetProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetProjectsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetReportGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetReportGroupsError {
    /// Kind of error that occurred.
    pub kind: BatchGetReportGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetReportGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetReportGroupsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetReportGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetReportGroupsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetReportGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetReportGroupsError {
    fn code(&self) -> Option<&str> {
        BatchGetReportGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetReportGroupsError {
    /// Creates a new `BatchGetReportGroupsError`.
    pub fn new(kind: BatchGetReportGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetReportGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetReportGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetReportGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetReportGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetReportGroupsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetReportGroupsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for BatchGetReportGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetReportGroupsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetReportGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetReportsError {
    /// Kind of error that occurred.
    pub kind: BatchGetReportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetReportsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetReportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetReportsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            BatchGetReportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetReportsError {
    fn code(&self) -> Option<&str> {
        BatchGetReportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetReportsError {
    /// Creates a new `BatchGetReportsError`.
    pub fn new(kind: BatchGetReportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetReportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetReportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetReportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetReportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetReportsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetReportsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for BatchGetReportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetReportsErrorKind::InvalidInputException(_inner) => Some(_inner),
            BatchGetReportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProjectError {
    /// Kind of error that occurred.
    pub kind: CreateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProjectErrorKind {
    /// <p>An Amazon Web Services service limit was exceeded for the calling Amazon Web Services account.</p>
    AccountLimitExceededException(crate::error::AccountLimitExceededException),
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be created, because an Amazon Web Services resource with the same settings already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProjectErrorKind::AccountLimitExceededException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProjectError {
    fn code(&self) -> Option<&str> {
        CreateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProjectError {
    /// Creates a new `CreateProjectError`.
    pub fn new(kind: CreateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::AccountLimitExceededException`.
    pub fn is_account_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::AccountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateProjectErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProjectErrorKind::AccountLimitExceededException(_inner) => Some(_inner),
            CreateProjectErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateProjectErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReportGroupError {
    /// Kind of error that occurred.
    pub kind: CreateReportGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReportGroupErrorKind {
    /// <p>An Amazon Web Services service limit was exceeded for the calling Amazon Web Services account.</p>
    AccountLimitExceededException(crate::error::AccountLimitExceededException),
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be created, because an Amazon Web Services resource with the same settings already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReportGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReportGroupErrorKind::AccountLimitExceededException(_inner) => _inner.fmt(f),
            CreateReportGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateReportGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateReportGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReportGroupError {
    fn code(&self) -> Option<&str> {
        CreateReportGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReportGroupError {
    /// Creates a new `CreateReportGroupError`.
    pub fn new(kind: CreateReportGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReportGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReportGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReportGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReportGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReportGroupErrorKind::AccountLimitExceededException`.
    pub fn is_account_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportGroupErrorKind::AccountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReportGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReportGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateReportGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateReportGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReportGroupErrorKind::AccountLimitExceededException(_inner) => Some(_inner),
            CreateReportGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateReportGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateReportGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateWebhookError {
    /// Kind of error that occurred.
    pub kind: CreateWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateWebhookErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>There was a problem with the underlying OAuth provider.</p>
    OAuthProviderException(crate::error::OAuthProviderException),
    /// <p>The specified Amazon Web Services resource cannot be created, because an Amazon Web Services resource with the same settings already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateWebhookErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::OAuthProviderException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateWebhookError {
    fn code(&self) -> Option<&str> {
        CreateWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateWebhookError {
    /// Creates a new `CreateWebhookError`.
    pub fn new(kind: CreateWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateWebhookErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateWebhookErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::OAuthProviderException`.
    pub fn is_o_auth_provider_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebhookErrorKind::OAuthProviderException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebhookErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateWebhookErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateWebhookErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateWebhookErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateWebhookErrorKind::OAuthProviderException(_inner) => Some(_inner),
            CreateWebhookErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateWebhookErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBuildBatchError {
    /// Kind of error that occurred.
    pub kind: DeleteBuildBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBuildBatchErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBuildBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBuildBatchErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteBuildBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBuildBatchError {
    fn code(&self) -> Option<&str> {
        DeleteBuildBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBuildBatchError {
    /// Creates a new `DeleteBuildBatchError`.
    pub fn new(kind: DeleteBuildBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBuildBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBuildBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBuildBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBuildBatchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBuildBatchErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBuildBatchErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DeleteBuildBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBuildBatchErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteBuildBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProjectErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProjectErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProjectError {
    fn code(&self) -> Option<&str> {
        DeleteProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProjectError {
    /// Creates a new `DeleteProjectError`.
    pub fn new(kind: DeleteProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteProjectErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for DeleteProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProjectErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReportError {
    /// Kind of error that occurred.
    pub kind: DeleteReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReportErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReportErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReportError {
    fn code(&self) -> Option<&str> {
        DeleteReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReportError {
    /// Creates a new `DeleteReportError`.
    pub fn new(kind: DeleteReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReportErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteReportErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for DeleteReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReportErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReportGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteReportGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReportGroupErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReportGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReportGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteReportGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReportGroupError {
    fn code(&self) -> Option<&str> {
        DeleteReportGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReportGroupError {
    /// Creates a new `DeleteReportGroupError`.
    pub fn new(kind: DeleteReportGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReportGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReportGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReportGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReportGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReportGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReportGroupErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DeleteReportGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReportGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteReportGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSourceCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSourceCredentialsError {
    /// Kind of error that occurred.
    pub kind: DeleteSourceCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSourceCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSourceCredentialsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSourceCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSourceCredentialsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteSourceCredentialsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSourceCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSourceCredentialsError {
    fn code(&self) -> Option<&str> {
        DeleteSourceCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSourceCredentialsError {
    /// Creates a new `DeleteSourceCredentialsError`.
    pub fn new(kind: DeleteSourceCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSourceCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSourceCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSourceCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSourceCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSourceCredentialsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceCredentialsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSourceCredentialsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSourceCredentialsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteSourceCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSourceCredentialsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteSourceCredentialsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSourceCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteWebhookError {
    /// Kind of error that occurred.
    pub kind: DeleteWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteWebhookErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>There was a problem with the underlying OAuth provider.</p>
    OAuthProviderException(crate::error::OAuthProviderException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteWebhookErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::OAuthProviderException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteWebhookError {
    fn code(&self) -> Option<&str> {
        DeleteWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteWebhookError {
    /// Creates a new `DeleteWebhookError`.
    pub fn new(kind: DeleteWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteWebhookErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteWebhookErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::OAuthProviderException`.
    pub fn is_o_auth_provider_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebhookErrorKind::OAuthProviderException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteWebhookErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteWebhookErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteWebhookErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::OAuthProviderException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCodeCoverages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCodeCoveragesError {
    /// Kind of error that occurred.
    pub kind: DescribeCodeCoveragesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCodeCoverages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCodeCoveragesErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCodeCoveragesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCodeCoveragesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeCodeCoveragesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCodeCoveragesError {
    fn code(&self) -> Option<&str> {
        DescribeCodeCoveragesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCodeCoveragesError {
    /// Creates a new `DescribeCodeCoveragesError`.
    pub fn new(kind: DescribeCodeCoveragesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCodeCoveragesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCodeCoveragesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCodeCoveragesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCodeCoveragesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCodeCoveragesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCodeCoveragesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeCodeCoveragesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCodeCoveragesErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeCodeCoveragesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTestCases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTestCasesError {
    /// Kind of error that occurred.
    pub kind: DescribeTestCasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTestCases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTestCasesErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTestCasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTestCasesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeTestCasesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTestCasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTestCasesError {
    fn code(&self) -> Option<&str> {
        DescribeTestCasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTestCasesError {
    /// Creates a new `DescribeTestCasesError`.
    pub fn new(kind: DescribeTestCasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTestCasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTestCasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTestCasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTestCasesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTestCasesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTestCasesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTestCasesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTestCasesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTestCasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTestCasesErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeTestCasesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTestCasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReportGroupTrend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReportGroupTrendError {
    /// Kind of error that occurred.
    pub kind: GetReportGroupTrendErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReportGroupTrend` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReportGroupTrendErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReportGroupTrendError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReportGroupTrendErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetReportGroupTrendErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetReportGroupTrendErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReportGroupTrendError {
    fn code(&self) -> Option<&str> {
        GetReportGroupTrendError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReportGroupTrendError {
    /// Creates a new `GetReportGroupTrendError`.
    pub fn new(kind: GetReportGroupTrendErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReportGroupTrendError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReportGroupTrendErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReportGroupTrendError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReportGroupTrendErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReportGroupTrendErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReportGroupTrendErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReportGroupTrendErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReportGroupTrendErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetReportGroupTrendError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReportGroupTrendErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetReportGroupTrendErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetReportGroupTrendErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: GetResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetResourcePolicyErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetResourcePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetResourcePolicyError {
    fn code(&self) -> Option<&str> {
        GetResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetResourcePolicyError {
    /// Creates a new `GetResourcePolicyError`.
    pub fn new(kind: GetResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetResourcePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportSourceCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportSourceCredentialsError {
    /// Kind of error that occurred.
    pub kind: ImportSourceCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportSourceCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportSourceCredentialsErrorKind {
    /// <p>An Amazon Web Services service limit was exceeded for the calling Amazon Web Services account.</p>
    AccountLimitExceededException(crate::error::AccountLimitExceededException),
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be created, because an Amazon Web Services resource with the same settings already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportSourceCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportSourceCredentialsErrorKind::AccountLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ImportSourceCredentialsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ImportSourceCredentialsErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            ImportSourceCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportSourceCredentialsError {
    fn code(&self) -> Option<&str> {
        ImportSourceCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportSourceCredentialsError {
    /// Creates a new `ImportSourceCredentialsError`.
    pub fn new(kind: ImportSourceCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportSourceCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportSourceCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportSourceCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportSourceCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportSourceCredentialsErrorKind::AccountLimitExceededException`.
    pub fn is_account_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSourceCredentialsErrorKind::AccountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportSourceCredentialsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSourceCredentialsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportSourceCredentialsErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportSourceCredentialsErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for ImportSourceCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportSourceCredentialsErrorKind::AccountLimitExceededException(_inner) => Some(_inner),
            ImportSourceCredentialsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ImportSourceCredentialsErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            ImportSourceCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `InvalidateProjectCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct InvalidateProjectCacheError {
    /// Kind of error that occurred.
    pub kind: InvalidateProjectCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `InvalidateProjectCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum InvalidateProjectCacheErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for InvalidateProjectCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            InvalidateProjectCacheErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            InvalidateProjectCacheErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            InvalidateProjectCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for InvalidateProjectCacheError {
    fn code(&self) -> Option<&str> {
        InvalidateProjectCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl InvalidateProjectCacheError {
    /// Creates a new `InvalidateProjectCacheError`.
    pub fn new(kind: InvalidateProjectCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `InvalidateProjectCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: InvalidateProjectCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `InvalidateProjectCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: InvalidateProjectCacheErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `InvalidateProjectCacheErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvalidateProjectCacheErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `InvalidateProjectCacheErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            InvalidateProjectCacheErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for InvalidateProjectCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            InvalidateProjectCacheErrorKind::InvalidInputException(_inner) => Some(_inner),
            InvalidateProjectCacheErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            InvalidateProjectCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBuildBatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBuildBatchesError {
    /// Kind of error that occurred.
    pub kind: ListBuildBatchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBuildBatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBuildBatchesErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBuildBatchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBuildBatchesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListBuildBatchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBuildBatchesError {
    fn code(&self) -> Option<&str> {
        ListBuildBatchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBuildBatchesError {
    /// Creates a new `ListBuildBatchesError`.
    pub fn new(kind: ListBuildBatchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBuildBatchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBuildBatchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBuildBatchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBuildBatchesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBuildBatchesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuildBatchesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListBuildBatchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBuildBatchesErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListBuildBatchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBuildBatchesForProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBuildBatchesForProjectError {
    /// Kind of error that occurred.
    pub kind: ListBuildBatchesForProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBuildBatchesForProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBuildBatchesForProjectErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBuildBatchesForProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBuildBatchesForProjectErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListBuildBatchesForProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBuildBatchesForProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBuildBatchesForProjectError {
    fn code(&self) -> Option<&str> {
        ListBuildBatchesForProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBuildBatchesForProjectError {
    /// Creates a new `ListBuildBatchesForProjectError`.
    pub fn new(kind: ListBuildBatchesForProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBuildBatchesForProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBuildBatchesForProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBuildBatchesForProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBuildBatchesForProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBuildBatchesForProjectErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuildBatchesForProjectErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuildBatchesForProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuildBatchesForProjectErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListBuildBatchesForProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBuildBatchesForProjectErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListBuildBatchesForProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBuildBatchesForProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBuildsError {
    /// Kind of error that occurred.
    pub kind: ListBuildsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBuilds` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBuildsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBuildsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBuildsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListBuildsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBuildsError {
    fn code(&self) -> Option<&str> {
        ListBuildsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBuildsError {
    /// Creates a new `ListBuildsError`.
    pub fn new(kind: ListBuildsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBuildsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBuildsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBuildsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBuildsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBuildsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListBuildsErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for ListBuildsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBuildsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListBuildsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBuildsForProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBuildsForProjectError {
    /// Kind of error that occurred.
    pub kind: ListBuildsForProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBuildsForProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBuildsForProjectErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBuildsForProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBuildsForProjectErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListBuildsForProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBuildsForProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBuildsForProjectError {
    fn code(&self) -> Option<&str> {
        ListBuildsForProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBuildsForProjectError {
    /// Creates a new `ListBuildsForProjectError`.
    pub fn new(kind: ListBuildsForProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBuildsForProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBuildsForProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBuildsForProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBuildsForProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBuildsForProjectErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuildsForProjectErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListBuildsForProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListBuildsForProjectErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListBuildsForProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBuildsForProjectErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListBuildsForProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBuildsForProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCuratedEnvironmentImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCuratedEnvironmentImagesError {
    /// Kind of error that occurred.
    pub kind: ListCuratedEnvironmentImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCuratedEnvironmentImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCuratedEnvironmentImagesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCuratedEnvironmentImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCuratedEnvironmentImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCuratedEnvironmentImagesError {
    fn code(&self) -> Option<&str> {
        ListCuratedEnvironmentImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCuratedEnvironmentImagesError {
    /// Creates a new `ListCuratedEnvironmentImagesError`.
    pub fn new(kind: ListCuratedEnvironmentImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCuratedEnvironmentImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCuratedEnvironmentImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCuratedEnvironmentImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCuratedEnvironmentImagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListCuratedEnvironmentImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCuratedEnvironmentImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectsError {
    /// Kind of error that occurred.
    pub kind: ListProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectsError {
    fn code(&self) -> Option<&str> {
        ListProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectsError {
    /// Creates a new `ListProjectsError`.
    pub fn new(kind: ListProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProjectsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for ListProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReportGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReportGroupsError {
    /// Kind of error that occurred.
    pub kind: ListReportGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReportGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReportGroupsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReportGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReportGroupsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListReportGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReportGroupsError {
    fn code(&self) -> Option<&str> {
        ListReportGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReportGroupsError {
    /// Creates a new `ListReportGroupsError`.
    pub fn new(kind: ListReportGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReportGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReportGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReportGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReportGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReportGroupsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReportGroupsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListReportGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReportGroupsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListReportGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReportsError {
    /// Kind of error that occurred.
    pub kind: ListReportsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReports` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReportsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReportsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReportsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListReportsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReportsError {
    fn code(&self) -> Option<&str> {
        ListReportsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReportsError {
    /// Creates a new `ListReportsError`.
    pub fn new(kind: ListReportsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReportsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReportsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReportsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReportsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReportsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ListReportsErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for ListReportsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReportsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListReportsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReportsForReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReportsForReportGroupError {
    /// Kind of error that occurred.
    pub kind: ListReportsForReportGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReportsForReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReportsForReportGroupErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReportsForReportGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReportsForReportGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListReportsForReportGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListReportsForReportGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReportsForReportGroupError {
    fn code(&self) -> Option<&str> {
        ListReportsForReportGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReportsForReportGroupError {
    /// Creates a new `ListReportsForReportGroupError`.
    pub fn new(kind: ListReportsForReportGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReportsForReportGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReportsForReportGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReportsForReportGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReportsForReportGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReportsForReportGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReportsForReportGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReportsForReportGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReportsForReportGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListReportsForReportGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReportsForReportGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListReportsForReportGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListReportsForReportGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSharedProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSharedProjectsError {
    /// Kind of error that occurred.
    pub kind: ListSharedProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSharedProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSharedProjectsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSharedProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSharedProjectsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSharedProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSharedProjectsError {
    fn code(&self) -> Option<&str> {
        ListSharedProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSharedProjectsError {
    /// Creates a new `ListSharedProjectsError`.
    pub fn new(kind: ListSharedProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSharedProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSharedProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSharedProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSharedProjectsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSharedProjectsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSharedProjectsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListSharedProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSharedProjectsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSharedProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSharedReportGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSharedReportGroupsError {
    /// Kind of error that occurred.
    pub kind: ListSharedReportGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSharedReportGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSharedReportGroupsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSharedReportGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSharedReportGroupsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSharedReportGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSharedReportGroupsError {
    fn code(&self) -> Option<&str> {
        ListSharedReportGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSharedReportGroupsError {
    /// Creates a new `ListSharedReportGroupsError`.
    pub fn new(kind: ListSharedReportGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSharedReportGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSharedReportGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSharedReportGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSharedReportGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSharedReportGroupsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSharedReportGroupsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListSharedReportGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSharedReportGroupsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSharedReportGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSourceCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSourceCredentialsError {
    /// Kind of error that occurred.
    pub kind: ListSourceCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSourceCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSourceCredentialsErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSourceCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSourceCredentialsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ListSourceCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSourceCredentialsError {
    fn code(&self) -> Option<&str> {
        ListSourceCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSourceCredentialsError {
    /// Creates a new `ListSourceCredentialsError`.
    pub fn new(kind: ListSourceCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSourceCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSourceCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSourceCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSourceCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSourceCredentialsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSourceCredentialsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for ListSourceCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSourceCredentialsErrorKind::InvalidInputException(_inner) => Some(_inner),
            ListSourceCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetryBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetryBuildError {
    /// Kind of error that occurred.
    pub kind: RetryBuildErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetryBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetryBuildErrorKind {
    /// <p>An Amazon Web Services service limit was exceeded for the calling Amazon Web Services account.</p>
    AccountLimitExceededException(crate::error::AccountLimitExceededException),
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetryBuildError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetryBuildErrorKind::AccountLimitExceededException(_inner) => _inner.fmt(f),
            RetryBuildErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RetryBuildErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RetryBuildErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetryBuildError {
    fn code(&self) -> Option<&str> {
        RetryBuildError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetryBuildError {
    /// Creates a new `RetryBuildError`.
    pub fn new(kind: RetryBuildErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetryBuildError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetryBuildErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetryBuildError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetryBuildErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RetryBuildErrorKind::AccountLimitExceededException`.
    pub fn is_account_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryBuildErrorKind::AccountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryBuildErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, RetryBuildErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `RetryBuildErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryBuildErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RetryBuildError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetryBuildErrorKind::AccountLimitExceededException(_inner) => Some(_inner),
            RetryBuildErrorKind::InvalidInputException(_inner) => Some(_inner),
            RetryBuildErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RetryBuildErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RetryBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RetryBuildBatchError {
    /// Kind of error that occurred.
    pub kind: RetryBuildBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RetryBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RetryBuildBatchErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RetryBuildBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RetryBuildBatchErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RetryBuildBatchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RetryBuildBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RetryBuildBatchError {
    fn code(&self) -> Option<&str> {
        RetryBuildBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RetryBuildBatchError {
    /// Creates a new `RetryBuildBatchError`.
    pub fn new(kind: RetryBuildBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RetryBuildBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RetryBuildBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RetryBuildBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RetryBuildBatchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RetryBuildBatchErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryBuildBatchErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RetryBuildBatchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RetryBuildBatchErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RetryBuildBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RetryBuildBatchErrorKind::InvalidInputException(_inner) => Some(_inner),
            RetryBuildBatchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RetryBuildBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartBuildError {
    /// Kind of error that occurred.
    pub kind: StartBuildErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartBuildErrorKind {
    /// <p>An Amazon Web Services service limit was exceeded for the calling Amazon Web Services account.</p>
    AccountLimitExceededException(crate::error::AccountLimitExceededException),
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartBuildError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartBuildErrorKind::AccountLimitExceededException(_inner) => _inner.fmt(f),
            StartBuildErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartBuildErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartBuildErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartBuildError {
    fn code(&self) -> Option<&str> {
        StartBuildError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartBuildError {
    /// Creates a new `StartBuildError`.
    pub fn new(kind: StartBuildErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartBuildError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartBuildErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartBuildError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartBuildErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartBuildErrorKind::AccountLimitExceededException`.
    pub fn is_account_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBuildErrorKind::AccountLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBuildErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, StartBuildErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `StartBuildErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBuildErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartBuildError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartBuildErrorKind::AccountLimitExceededException(_inner) => Some(_inner),
            StartBuildErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartBuildErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartBuildErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartBuildBatchError {
    /// Kind of error that occurred.
    pub kind: StartBuildBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartBuildBatchErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartBuildBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartBuildBatchErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StartBuildBatchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartBuildBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartBuildBatchError {
    fn code(&self) -> Option<&str> {
        StartBuildBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartBuildBatchError {
    /// Creates a new `StartBuildBatchError`.
    pub fn new(kind: StartBuildBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartBuildBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartBuildBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartBuildBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartBuildBatchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartBuildBatchErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBuildBatchErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StartBuildBatchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartBuildBatchErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartBuildBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartBuildBatchErrorKind::InvalidInputException(_inner) => Some(_inner),
            StartBuildBatchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartBuildBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopBuildError {
    /// Kind of error that occurred.
    pub kind: StopBuildErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopBuild` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopBuildErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopBuildError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopBuildErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopBuildErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopBuildErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopBuildError {
    fn code(&self) -> Option<&str> {
        StopBuildError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopBuildError {
    /// Creates a new `StopBuildError`.
    pub fn new(kind: StopBuildErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopBuildError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopBuildErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopBuildError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopBuildErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopBuildErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, StopBuildErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `StopBuildErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopBuildErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for StopBuildError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopBuildErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopBuildErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopBuildErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopBuildBatchError {
    /// Kind of error that occurred.
    pub kind: StopBuildBatchErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopBuildBatch` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopBuildBatchErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopBuildBatchError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopBuildBatchErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            StopBuildBatchErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopBuildBatchErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopBuildBatchError {
    fn code(&self) -> Option<&str> {
        StopBuildBatchError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopBuildBatchError {
    /// Creates a new `StopBuildBatchError`.
    pub fn new(kind: StopBuildBatchErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopBuildBatchError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopBuildBatchErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopBuildBatchError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopBuildBatchErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopBuildBatchErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBuildBatchErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `StopBuildBatchErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopBuildBatchErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopBuildBatchError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopBuildBatchErrorKind::InvalidInputException(_inner) => Some(_inner),
            StopBuildBatchErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopBuildBatchErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectError {
    fn code(&self) -> Option<&str> {
        UpdateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectError {
    /// Creates a new `UpdateProjectError`.
    pub fn new(kind: UpdateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateProjectErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdateProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProjectVisibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProjectVisibilityError {
    /// Kind of error that occurred.
    pub kind: UpdateProjectVisibilityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProjectVisibility` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProjectVisibilityErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProjectVisibilityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProjectVisibilityErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateProjectVisibilityErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProjectVisibilityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProjectVisibilityError {
    fn code(&self) -> Option<&str> {
        UpdateProjectVisibilityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProjectVisibilityError {
    /// Creates a new `UpdateProjectVisibilityError`.
    pub fn new(kind: UpdateProjectVisibilityErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProjectVisibilityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProjectVisibilityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProjectVisibilityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProjectVisibilityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateProjectVisibilityErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectVisibilityErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateProjectVisibilityErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProjectVisibilityErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateProjectVisibilityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProjectVisibilityErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateProjectVisibilityErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProjectVisibilityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateReportGroupError {
    /// Kind of error that occurred.
    pub kind: UpdateReportGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateReportGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateReportGroupErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateReportGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateReportGroupErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateReportGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateReportGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateReportGroupError {
    fn code(&self) -> Option<&str> {
        UpdateReportGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateReportGroupError {
    /// Creates a new `UpdateReportGroupError`.
    pub fn new(kind: UpdateReportGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateReportGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateReportGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateReportGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateReportGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateReportGroupErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReportGroupErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateReportGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateReportGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateReportGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateReportGroupErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateReportGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateReportGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateWebhookError {
    /// Kind of error that occurred.
    pub kind: UpdateWebhookErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateWebhook` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateWebhookErrorKind {
    /// <p>The input value that was provided is not valid.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>There was a problem with the underlying OAuth provider.</p>
    OAuthProviderException(crate::error::OAuthProviderException),
    /// <p>The specified Amazon Web Services resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateWebhookError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateWebhookErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::OAuthProviderException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateWebhookErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateWebhookError {
    fn code(&self) -> Option<&str> {
        UpdateWebhookError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateWebhookError {
    /// Creates a new `UpdateWebhookError`.
    pub fn new(kind: UpdateWebhookErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateWebhookError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateWebhookErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateWebhookError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateWebhookErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateWebhookErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::OAuthProviderException`.
    pub fn is_o_auth_provider_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebhookErrorKind::OAuthProviderException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateWebhookErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateWebhookErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateWebhookError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateWebhookErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::OAuthProviderException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateWebhookErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified Amazon Web Services resource cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>There was a problem with the underlying OAuth provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OAuthProviderException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OAuthProviderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OAuthProviderException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OAuthProviderException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OAuthProviderException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OAuthProviderException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for OAuthProviderException {}
/// See [`OAuthProviderException`](crate::error::OAuthProviderException)
pub mod o_auth_provider_exception {
    /// A builder for [`OAuthProviderException`](crate::error::OAuthProviderException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OAuthProviderException`](crate::error::OAuthProviderException)
        pub fn build(self) -> crate::error::OAuthProviderException {
            crate::error::OAuthProviderException {
                message: self.message,
            }
        }
    }
}
impl OAuthProviderException {
    /// Creates a new builder-style object to manufacture [`OAuthProviderException`](crate::error::OAuthProviderException)
    pub fn builder() -> crate::error::o_auth_provider_exception::Builder {
        crate::error::o_auth_provider_exception::Builder::default()
    }
}

/// <p>The input value that was provided is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>An Amazon Web Services service limit was exceeded for the calling Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccountLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccountLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccountLimitExceededException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccountLimitExceededException {}
/// See [`AccountLimitExceededException`](crate::error::AccountLimitExceededException)
pub mod account_limit_exceeded_exception {
    /// A builder for [`AccountLimitExceededException`](crate::error::AccountLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountLimitExceededException`](crate::error::AccountLimitExceededException)
        pub fn build(self) -> crate::error::AccountLimitExceededException {
            crate::error::AccountLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl AccountLimitExceededException {
    /// Creates a new builder-style object to manufacture [`AccountLimitExceededException`](crate::error::AccountLimitExceededException)
    pub fn builder() -> crate::error::account_limit_exceeded_exception::Builder {
        crate::error::account_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The specified Amazon Web Services resource cannot be created, because an Amazon Web Services resource with the same settings already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
