// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS CodeBuild
///
/// Client for invoking operations on AWS CodeBuild. Each operation on AWS CodeBuild is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codebuild::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codebuild::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codebuild::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchDeleteBuilds`](crate::client::fluent_builders::BatchDeleteBuilds) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ids(Vec<String>)`](crate::client::fluent_builders::BatchDeleteBuilds::ids) / [`set_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDeleteBuilds::set_ids): <p>The IDs of the builds to delete.</p>
    /// - On success, responds with [`BatchDeleteBuildsOutput`](crate::output::BatchDeleteBuildsOutput) with field(s):
    ///   - [`builds_deleted(Option<Vec<String>>)`](crate::output::BatchDeleteBuildsOutput::builds_deleted): <p>The IDs of the builds that were successfully deleted.</p>
    ///   - [`builds_not_deleted(Option<Vec<BuildNotDeleted>>)`](crate::output::BatchDeleteBuildsOutput::builds_not_deleted): <p>Information about any builds that could not be successfully deleted.</p>
    /// - On failure, responds with [`SdkError<BatchDeleteBuildsError>`](crate::error::BatchDeleteBuildsError)
    pub fn batch_delete_builds(&self) -> fluent_builders::BatchDeleteBuilds {
        fluent_builders::BatchDeleteBuilds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetBuildBatches`](crate::client::fluent_builders::BatchGetBuildBatches) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ids(Vec<String>)`](crate::client::fluent_builders::BatchGetBuildBatches::ids) / [`set_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetBuildBatches::set_ids): <p>An array that contains the batch build identifiers to retrieve.</p>
    /// - On success, responds with [`BatchGetBuildBatchesOutput`](crate::output::BatchGetBuildBatchesOutput) with field(s):
    ///   - [`build_batches(Option<Vec<BuildBatch>>)`](crate::output::BatchGetBuildBatchesOutput::build_batches): <p>An array of <code>BuildBatch</code> objects that represent the retrieved batch builds.</p>
    ///   - [`build_batches_not_found(Option<Vec<String>>)`](crate::output::BatchGetBuildBatchesOutput::build_batches_not_found): <p>An array that contains the identifiers of any batch builds that are not found.</p>
    /// - On failure, responds with [`SdkError<BatchGetBuildBatchesError>`](crate::error::BatchGetBuildBatchesError)
    pub fn batch_get_build_batches(&self) -> fluent_builders::BatchGetBuildBatches {
        fluent_builders::BatchGetBuildBatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetBuilds`](crate::client::fluent_builders::BatchGetBuilds) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ids(Vec<String>)`](crate::client::fluent_builders::BatchGetBuilds::ids) / [`set_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetBuilds::set_ids): <p>The IDs of the builds.</p>
    /// - On success, responds with [`BatchGetBuildsOutput`](crate::output::BatchGetBuildsOutput) with field(s):
    ///   - [`builds(Option<Vec<Build>>)`](crate::output::BatchGetBuildsOutput::builds): <p>Information about the requested builds.</p>
    ///   - [`builds_not_found(Option<Vec<String>>)`](crate::output::BatchGetBuildsOutput::builds_not_found): <p>The IDs of builds for which information could not be found.</p>
    /// - On failure, responds with [`SdkError<BatchGetBuildsError>`](crate::error::BatchGetBuildsError)
    pub fn batch_get_builds(&self) -> fluent_builders::BatchGetBuilds {
        fluent_builders::BatchGetBuilds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetProjects`](crate::client::fluent_builders::BatchGetProjects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`names(Vec<String>)`](crate::client::fluent_builders::BatchGetProjects::names) / [`set_names(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetProjects::set_names): <p>The names or ARNs of the build projects. To get information about a project shared with your Amazon Web Services account, its ARN must be specified. You cannot specify a shared project using its name.</p>
    /// - On success, responds with [`BatchGetProjectsOutput`](crate::output::BatchGetProjectsOutput) with field(s):
    ///   - [`projects(Option<Vec<Project>>)`](crate::output::BatchGetProjectsOutput::projects): <p>Information about the requested build projects.</p>
    ///   - [`projects_not_found(Option<Vec<String>>)`](crate::output::BatchGetProjectsOutput::projects_not_found): <p>The names of build projects for which information could not be found.</p>
    /// - On failure, responds with [`SdkError<BatchGetProjectsError>`](crate::error::BatchGetProjectsError)
    pub fn batch_get_projects(&self) -> fluent_builders::BatchGetProjects {
        fluent_builders::BatchGetProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetReportGroups`](crate::client::fluent_builders::BatchGetReportGroups) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_group_arns(Vec<String>)`](crate::client::fluent_builders::BatchGetReportGroups::report_group_arns) / [`set_report_group_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetReportGroups::set_report_group_arns): <p> An array of report group ARNs that identify the report groups to return. </p>
    /// - On success, responds with [`BatchGetReportGroupsOutput`](crate::output::BatchGetReportGroupsOutput) with field(s):
    ///   - [`report_groups(Option<Vec<ReportGroup>>)`](crate::output::BatchGetReportGroupsOutput::report_groups): <p> The array of report groups returned by <code>BatchGetReportGroups</code>. </p>
    ///   - [`report_groups_not_found(Option<Vec<String>>)`](crate::output::BatchGetReportGroupsOutput::report_groups_not_found): <p> An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>ReportGroup</code>. </p>
    /// - On failure, responds with [`SdkError<BatchGetReportGroupsError>`](crate::error::BatchGetReportGroupsError)
    pub fn batch_get_report_groups(&self) -> fluent_builders::BatchGetReportGroups {
        fluent_builders::BatchGetReportGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetReports`](crate::client::fluent_builders::BatchGetReports) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_arns(Vec<String>)`](crate::client::fluent_builders::BatchGetReports::report_arns) / [`set_report_arns(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetReports::set_report_arns): <p> An array of ARNs that identify the <code>Report</code> objects to return. </p>
    /// - On success, responds with [`BatchGetReportsOutput`](crate::output::BatchGetReportsOutput) with field(s):
    ///   - [`reports(Option<Vec<Report>>)`](crate::output::BatchGetReportsOutput::reports): <p> The array of <code>Report</code> objects returned by <code>BatchGetReports</code>. </p>
    ///   - [`reports_not_found(Option<Vec<String>>)`](crate::output::BatchGetReportsOutput::reports_not_found): <p> An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>Report</code>. </p>
    /// - On failure, responds with [`SdkError<BatchGetReportsError>`](crate::error::BatchGetReportsError)
    pub fn batch_get_reports(&self) -> fluent_builders::BatchGetReports {
        fluent_builders::BatchGetReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProject`](crate::client::fluent_builders::CreateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_name): <p>The name of the build project.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateProject::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateProject::set_description): <p>A description that makes the build project easy to identify.</p>
    ///   - [`source(ProjectSource)`](crate::client::fluent_builders::CreateProject::source) / [`set_source(Option<ProjectSource>)`](crate::client::fluent_builders::CreateProject::set_source): <p>Information about the build input source code for the build project.</p>
    ///   - [`secondary_sources(Vec<ProjectSource>)`](crate::client::fluent_builders::CreateProject::secondary_sources) / [`set_secondary_sources(Option<Vec<ProjectSource>>)`](crate::client::fluent_builders::CreateProject::set_secondary_sources): <p>An array of <code>ProjectSource</code> objects. </p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::CreateProject::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::CreateProject::set_source_version): <p>A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of: </p>  <ul>   <li> <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p> </li>   <li> <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>   <li> <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>   <li> <p>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</p> </li>  </ul>  <p>If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level). </p>  <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    ///   - [`secondary_source_versions(Vec<ProjectSourceVersion>)`](crate::client::fluent_builders::CreateProject::secondary_source_versions) / [`set_secondary_source_versions(Option<Vec<ProjectSourceVersion>>)`](crate::client::fluent_builders::CreateProject::set_secondary_source_versions): <p>An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at the build level, then they take precedence over these <code>secondarySourceVersions</code> (at the project level). </p>
    ///   - [`artifacts(ProjectArtifacts)`](crate::client::fluent_builders::CreateProject::artifacts) / [`set_artifacts(Option<ProjectArtifacts>)`](crate::client::fluent_builders::CreateProject::set_artifacts): <p>Information about the build output artifacts for the build project.</p>
    ///   - [`secondary_artifacts(Vec<ProjectArtifacts>)`](crate::client::fluent_builders::CreateProject::secondary_artifacts) / [`set_secondary_artifacts(Option<Vec<ProjectArtifacts>>)`](crate::client::fluent_builders::CreateProject::set_secondary_artifacts): <p>An array of <code>ProjectArtifacts</code> objects. </p>
    ///   - [`cache(ProjectCache)`](crate::client::fluent_builders::CreateProject::cache) / [`set_cache(Option<ProjectCache>)`](crate::client::fluent_builders::CreateProject::set_cache): <p>Stores recently used information so that it can be quickly accessed at a later time.</p>
    ///   - [`environment(ProjectEnvironment)`](crate::client::fluent_builders::CreateProject::environment) / [`set_environment(Option<ProjectEnvironment>)`](crate::client::fluent_builders::CreateProject::set_environment): <p>Information about the build environment for the build project.</p>
    ///   - [`service_role(impl Into<String>)`](crate::client::fluent_builders::CreateProject::service_role) / [`set_service_role(Option<String>)`](crate::client::fluent_builders::CreateProject::set_service_role): <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.</p>
    ///   - [`timeout_in_minutes(i32)`](crate::client::fluent_builders::CreateProject::timeout_in_minutes) / [`set_timeout_in_minutes(Option<i32>)`](crate::client::fluent_builders::CreateProject::set_timeout_in_minutes): <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before it times out any build that has not been marked as completed. The default is 60 minutes.</p>
    ///   - [`queued_timeout_in_minutes(i32)`](crate::client::fluent_builders::CreateProject::queued_timeout_in_minutes) / [`set_queued_timeout_in_minutes(Option<i32>)`](crate::client::fluent_builders::CreateProject::set_queued_timeout_in_minutes): <p>The number of minutes a build is allowed to be queued before it times out. </p>
    ///   - [`encryption_key(impl Into<String>)`](crate::client::fluent_builders::CreateProject::encryption_key) / [`set_encryption_key(Option<String>)`](crate::client::fluent_builders::CreateProject::set_encryption_key): <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.</p> <note>   <p>You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>  </note>  <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/   <alias-name></alias-name></code>). </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateProject::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateProject::set_tags): <p>A list of tag key and value pairs associated with this build project.</p>  <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.</p>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::CreateProject::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::CreateProject::set_vpc_config): <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
    ///   - [`badge_enabled(bool)`](crate::client::fluent_builders::CreateProject::badge_enabled) / [`set_badge_enabled(Option<bool>)`](crate::client::fluent_builders::CreateProject::set_badge_enabled): <p>Set this to true to generate a publicly accessible URL for your project's build badge.</p>
    ///   - [`logs_config(LogsConfig)`](crate::client::fluent_builders::CreateProject::logs_config) / [`set_logs_config(Option<LogsConfig>)`](crate::client::fluent_builders::CreateProject::set_logs_config): <p>Information about logs for the build project. These can be logs in CloudWatch Logs, logs uploaded to a specified S3 bucket, or both. </p>
    ///   - [`file_system_locations(Vec<ProjectFileSystemLocation>)`](crate::client::fluent_builders::CreateProject::file_system_locations) / [`set_file_system_locations(Option<Vec<ProjectFileSystemLocation>>)`](crate::client::fluent_builders::CreateProject::set_file_system_locations): <p> An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System. </p>
    ///   - [`build_batch_config(ProjectBuildBatchConfig)`](crate::client::fluent_builders::CreateProject::build_batch_config) / [`set_build_batch_config(Option<ProjectBuildBatchConfig>)`](crate::client::fluent_builders::CreateProject::set_build_batch_config): <p>A <code>ProjectBuildBatchConfig</code> object that defines the batch build options for the project.</p>
    ///   - [`concurrent_build_limit(i32)`](crate::client::fluent_builders::CreateProject::concurrent_build_limit) / [`set_concurrent_build_limit(Option<i32>)`](crate::client::fluent_builders::CreateProject::set_concurrent_build_limit): <p>The maximum number of concurrent builds that are allowed for this project.</p>  <p>New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.</p>
    /// - On success, responds with [`CreateProjectOutput`](crate::output::CreateProjectOutput) with field(s):
    ///   - [`project(Option<Project>)`](crate::output::CreateProjectOutput::project): <p>Information about the build project that was created.</p>
    /// - On failure, responds with [`SdkError<CreateProjectError>`](crate::error::CreateProjectError)
    pub fn create_project(&self) -> fluent_builders::CreateProject {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateReportGroup`](crate::client::fluent_builders::CreateReportGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateReportGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateReportGroup::set_name): <p> The name of the report group. </p>
    ///   - [`r#type(ReportType)`](crate::client::fluent_builders::CreateReportGroup::type) / [`set_type(Option<ReportType>)`](crate::client::fluent_builders::CreateReportGroup::set_type): <p> The type of report group. </p>
    ///   - [`export_config(ReportExportConfig)`](crate::client::fluent_builders::CreateReportGroup::export_config) / [`set_export_config(Option<ReportExportConfig>)`](crate::client::fluent_builders::CreateReportGroup::set_export_config): <p> A <code>ReportExportConfig</code> object that contains information about where the report group test results are exported. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateReportGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateReportGroup::set_tags): <p> A list of tag key and value pairs associated with this report group. </p>  <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.</p>
    /// - On success, responds with [`CreateReportGroupOutput`](crate::output::CreateReportGroupOutput) with field(s):
    ///   - [`report_group(Option<ReportGroup>)`](crate::output::CreateReportGroupOutput::report_group): <p> Information about the report group that was created. </p>
    /// - On failure, responds with [`SdkError<CreateReportGroupError>`](crate::error::CreateReportGroupError)
    pub fn create_report_group(&self) -> fluent_builders::CreateReportGroup {
        fluent_builders::CreateReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateWebhook`](crate::client::fluent_builders::CreateWebhook) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::CreateWebhook::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::CreateWebhook::set_project_name): <p>The name of the CodeBuild project.</p>
    ///   - [`branch_filter(impl Into<String>)`](crate::client::fluent_builders::CreateWebhook::branch_filter) / [`set_branch_filter(Option<String>)`](crate::client::fluent_builders::CreateWebhook::set_branch_filter): <p>A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty, then all branches are built.</p> <note>   <p>It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>. </p>  </note>
    ///   - [`filter_groups(Vec<Vec<WebhookFilter>>)`](crate::client::fluent_builders::CreateWebhook::filter_groups) / [`set_filter_groups(Option<Vec<Vec<WebhookFilter>>>)`](crate::client::fluent_builders::CreateWebhook::set_filter_groups): <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are triggered. At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its <code>type</code>. </p>  <p>For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must pass. For a filter group to pass, each of its filters must pass. </p>
    ///   - [`build_type(WebhookBuildType)`](crate::client::fluent_builders::CreateWebhook::build_type) / [`set_build_type(Option<WebhookBuildType>)`](crate::client::fluent_builders::CreateWebhook::set_build_type): <p>Specifies the type of build this webhook will trigger.</p>
    /// - On success, responds with [`CreateWebhookOutput`](crate::output::CreateWebhookOutput) with field(s):
    ///   - [`webhook(Option<Webhook>)`](crate::output::CreateWebhookOutput::webhook): <p>Information about a webhook that connects repository events to a build project in CodeBuild.</p>
    /// - On failure, responds with [`SdkError<CreateWebhookError>`](crate::error::CreateWebhookError)
    pub fn create_webhook(&self) -> fluent_builders::CreateWebhook {
        fluent_builders::CreateWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBuildBatch`](crate::client::fluent_builders::DeleteBuildBatch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteBuildBatch::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteBuildBatch::set_id): <p>The identifier of the batch build to delete.</p>
    /// - On success, responds with [`DeleteBuildBatchOutput`](crate::output::DeleteBuildBatchOutput) with field(s):
    ///   - [`status_code(Option<String>)`](crate::output::DeleteBuildBatchOutput::status_code): <p>The status code.</p>
    ///   - [`builds_deleted(Option<Vec<String>>)`](crate::output::DeleteBuildBatchOutput::builds_deleted): <p>An array of strings that contain the identifiers of the builds that were deleted.</p>
    ///   - [`builds_not_deleted(Option<Vec<BuildNotDeleted>>)`](crate::output::DeleteBuildBatchOutput::builds_not_deleted): <p>An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteBuildBatchError>`](crate::error::DeleteBuildBatchError)
    pub fn delete_build_batch(&self) -> fluent_builders::DeleteBuildBatch {
        fluent_builders::DeleteBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProject`](crate::client::fluent_builders::DeleteProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_name): <p>The name of the build project.</p>
    /// - On success, responds with [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)

    /// - On failure, responds with [`SdkError<DeleteProjectError>`](crate::error::DeleteProjectError)
    pub fn delete_project(&self) -> fluent_builders::DeleteProject {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReport`](crate::client::fluent_builders::DeleteReport) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteReport::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteReport::set_arn): <p> The ARN of the report to delete. </p>
    /// - On success, responds with [`DeleteReportOutput`](crate::output::DeleteReportOutput)

    /// - On failure, responds with [`SdkError<DeleteReportError>`](crate::error::DeleteReportError)
    pub fn delete_report(&self) -> fluent_builders::DeleteReport {
        fluent_builders::DeleteReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteReportGroup`](crate::client::fluent_builders::DeleteReportGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteReportGroup::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteReportGroup::set_arn): <p>The ARN of the report group to delete. </p>
    ///   - [`delete_reports(bool)`](crate::client::fluent_builders::DeleteReportGroup::delete_reports) / [`set_delete_reports(bool)`](crate::client::fluent_builders::DeleteReportGroup::set_delete_reports): <p>If <code>true</code>, deletes any reports that belong to a report group before deleting the report group. </p>  <p>If <code>false</code>, you must delete any reports in the report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ListReportsForReportGroup.html">ListReportsForReportGroup</a> to get the reports in a report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_DeleteReport.html">DeleteReport</a> to delete the reports. If you call <code>DeleteReportGroup</code> for a report group that contains one or more reports, an exception is thrown. </p>
    /// - On success, responds with [`DeleteReportGroupOutput`](crate::output::DeleteReportGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteReportGroupError>`](crate::error::DeleteReportGroupError)
    pub fn delete_report_group(&self) -> fluent_builders::DeleteReportGroup {
        fluent_builders::DeleteReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_resource_arn): <p> The ARN of the resource that is associated with the resource policy. </p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSourceCredentials`](crate::client::fluent_builders::DeleteSourceCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::DeleteSourceCredentials::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::DeleteSourceCredentials::set_arn): <p> The Amazon Resource Name (ARN) of the token.</p>
    /// - On success, responds with [`DeleteSourceCredentialsOutput`](crate::output::DeleteSourceCredentialsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::DeleteSourceCredentialsOutput::arn): <p> The Amazon Resource Name (ARN) of the token. </p>
    /// - On failure, responds with [`SdkError<DeleteSourceCredentialsError>`](crate::error::DeleteSourceCredentialsError)
    pub fn delete_source_credentials(&self) -> fluent_builders::DeleteSourceCredentials {
        fluent_builders::DeleteSourceCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWebhook`](crate::client::fluent_builders::DeleteWebhook) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DeleteWebhook::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DeleteWebhook::set_project_name): <p>The name of the CodeBuild project.</p>
    /// - On success, responds with [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)

    /// - On failure, responds with [`SdkError<DeleteWebhookError>`](crate::error::DeleteWebhookError)
    pub fn delete_webhook(&self) -> fluent_builders::DeleteWebhook {
        fluent_builders::DeleteWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCodeCoverages`](crate::client::fluent_builders::DescribeCodeCoverages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCodeCoverages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCodeCoverages::report_arn) / [`set_report_arn(Option<String>)`](crate::client::fluent_builders::DescribeCodeCoverages::set_report_arn): <p> The ARN of the report for which test cases are returned. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeCodeCoverages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeCodeCoverages::set_next_token): <p>The <code>nextToken</code> value returned from a previous call to <code>DescribeCodeCoverages</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeCodeCoverages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeCodeCoverages::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::DescribeCodeCoverages::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::DescribeCodeCoverages::set_sort_order): <p>Specifies if the results are sorted in ascending or descending order.</p>
    ///   - [`sort_by(ReportCodeCoverageSortByType)`](crate::client::fluent_builders::DescribeCodeCoverages::sort_by) / [`set_sort_by(Option<ReportCodeCoverageSortByType>)`](crate::client::fluent_builders::DescribeCodeCoverages::set_sort_by): <p>Specifies how the results are sorted. Possible values are:</p>  <dl>   <dt>   FILE_PATH  </dt>   <dd>    <p>The results are sorted by file path.</p>   </dd>   <dt>   LINE_COVERAGE_PERCENTAGE  </dt>   <dd>    <p>The results are sorted by the percentage of lines that are covered.</p>   </dd>  </dl>
    ///   - [`min_line_coverage_percentage(f64)`](crate::client::fluent_builders::DescribeCodeCoverages::min_line_coverage_percentage) / [`set_min_line_coverage_percentage(Option<f64>)`](crate::client::fluent_builders::DescribeCodeCoverages::set_min_line_coverage_percentage): <p>The minimum line coverage percentage to report.</p>
    ///   - [`max_line_coverage_percentage(f64)`](crate::client::fluent_builders::DescribeCodeCoverages::max_line_coverage_percentage) / [`set_max_line_coverage_percentage(Option<f64>)`](crate::client::fluent_builders::DescribeCodeCoverages::set_max_line_coverage_percentage): <p>The maximum line coverage percentage to report.</p>
    /// - On success, responds with [`DescribeCodeCoveragesOutput`](crate::output::DescribeCodeCoveragesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeCodeCoveragesOutput::next_token): <p>If there are more items to return, this contains a token that is passed to a subsequent call to <code>DescribeCodeCoverages</code> to retrieve the next set of items.</p>
    ///   - [`code_coverages(Option<Vec<CodeCoverage>>)`](crate::output::DescribeCodeCoveragesOutput::code_coverages): <p>An array of <code>CodeCoverage</code> objects that contain the results.</p>
    /// - On failure, responds with [`SdkError<DescribeCodeCoveragesError>`](crate::error::DescribeCodeCoveragesError)
    pub fn describe_code_coverages(&self) -> fluent_builders::DescribeCodeCoverages {
        fluent_builders::DescribeCodeCoverages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTestCases`](crate::client::fluent_builders::DescribeTestCases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTestCases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeTestCases::report_arn) / [`set_report_arn(Option<String>)`](crate::client::fluent_builders::DescribeTestCases::set_report_arn): <p> The ARN of the report for which test cases are returned. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeTestCases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeTestCases::set_next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeTestCases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeTestCases::set_max_results): <p> The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>TestCase</code> objects. The default value is 100. </p>
    ///   - [`filter(TestCaseFilter)`](crate::client::fluent_builders::DescribeTestCases::filter) / [`set_filter(Option<TestCaseFilter>)`](crate::client::fluent_builders::DescribeTestCases::set_filter): <p> A <code>TestCaseFilter</code> object used to filter the returned reports. </p>
    /// - On success, responds with [`DescribeTestCasesOutput`](crate::output::DescribeTestCasesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::DescribeTestCasesOutput::next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`test_cases(Option<Vec<TestCase>>)`](crate::output::DescribeTestCasesOutput::test_cases): <p> The returned list of test cases. </p>
    /// - On failure, responds with [`SdkError<DescribeTestCasesError>`](crate::error::DescribeTestCasesError)
    pub fn describe_test_cases(&self) -> fluent_builders::DescribeTestCases {
        fluent_builders::DescribeTestCases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReportGroupTrend`](crate::client::fluent_builders::GetReportGroupTrend) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_group_arn(impl Into<String>)`](crate::client::fluent_builders::GetReportGroupTrend::report_group_arn) / [`set_report_group_arn(Option<String>)`](crate::client::fluent_builders::GetReportGroupTrend::set_report_group_arn): <p>The ARN of the report group that contains the reports to analyze.</p>
    ///   - [`num_of_reports(i32)`](crate::client::fluent_builders::GetReportGroupTrend::num_of_reports) / [`set_num_of_reports(Option<i32>)`](crate::client::fluent_builders::GetReportGroupTrend::set_num_of_reports): <p>The number of reports to analyze. This operation always retrieves the most recent reports.</p>  <p>If this parameter is omitted, the most recent 100 reports are analyzed.</p>
    ///   - [`trend_field(ReportGroupTrendFieldType)`](crate::client::fluent_builders::GetReportGroupTrend::trend_field) / [`set_trend_field(Option<ReportGroupTrendFieldType>)`](crate::client::fluent_builders::GetReportGroupTrend::set_trend_field): <p>The test report value to accumulate. This must be one of the following values:</p>  <dl>   <dt>   Test reports:  </dt>   <dd>    <dl>     <dt>     DURATION    </dt>     <dd>      <p>Accumulate the test run times for the specified reports.</p>     </dd>     <dt>     PASS_RATE    </dt>     <dd>      <p>Accumulate the percentage of tests that passed for the specified test reports.</p>     </dd>     <dt>     TOTAL    </dt>     <dd>      <p>Accumulate the total number of tests for the specified test reports.</p>     </dd>    </dl>   </dd>  </dl>  <dl>   <dt>   Code coverage reports:  </dt>   <dd>    <dl>     <dt>     BRANCH_COVERAGE    </dt>     <dd>      <p>Accumulate the branch coverage percentages for the specified test reports.</p>     </dd>     <dt>     BRANCHES_COVERED    </dt>     <dd>      <p>Accumulate the branches covered values for the specified test reports.</p>     </dd>     <dt>     BRANCHES_MISSED    </dt>     <dd>      <p>Accumulate the branches missed values for the specified test reports.</p>     </dd>     <dt>     LINE_COVERAGE    </dt>     <dd>      <p>Accumulate the line coverage percentages for the specified test reports.</p>     </dd>     <dt>     LINES_COVERED    </dt>     <dd>      <p>Accumulate the lines covered values for the specified test reports.</p>     </dd>     <dt>     LINES_MISSED    </dt>     <dd>      <p>Accumulate the lines not covered values for the specified test reports.</p>     </dd>    </dl>   </dd>  </dl>
    /// - On success, responds with [`GetReportGroupTrendOutput`](crate::output::GetReportGroupTrendOutput) with field(s):
    ///   - [`stats(Option<ReportGroupTrendStats>)`](crate::output::GetReportGroupTrendOutput::stats): <p>Contains the accumulated trend data.</p>
    ///   - [`raw_data(Option<Vec<ReportWithRawData>>)`](crate::output::GetReportGroupTrendOutput::raw_data): <p>An array that contains the raw data for each report.</p>
    /// - On failure, responds with [`SdkError<GetReportGroupTrendError>`](crate::error::GetReportGroupTrendError)
    pub fn get_report_group_trend(&self) -> fluent_builders::GetReportGroupTrend {
        fluent_builders::GetReportGroupTrend::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::GetResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::GetResourcePolicy::set_resource_arn): <p> The ARN of the resource that is associated with the resource policy. </p>
    /// - On success, responds with [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput) with field(s):
    ///   - [`policy(Option<String>)`](crate::output::GetResourcePolicyOutput::policy): <p> The resource policy for the resource identified by the input ARN parameter. </p>
    /// - On failure, responds with [`SdkError<GetResourcePolicyError>`](crate::error::GetResourcePolicyError)
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ImportSourceCredentials`](crate::client::fluent_builders::ImportSourceCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::ImportSourceCredentials::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::ImportSourceCredentials::set_username): <p> The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter is not valid for other types of source providers or connections. </p>
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::ImportSourceCredentials::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::ImportSourceCredentials::set_token): <p> For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app password. </p>
    ///   - [`server_type(ServerType)`](crate::client::fluent_builders::ImportSourceCredentials::server_type) / [`set_server_type(Option<ServerType>)`](crate::client::fluent_builders::ImportSourceCredentials::set_server_type): <p> The source provider used for this project. </p>
    ///   - [`auth_type(AuthType)`](crate::client::fluent_builders::ImportSourceCredentials::auth_type) / [`set_auth_type(Option<AuthType>)`](crate::client::fluent_builders::ImportSourceCredentials::set_auth_type): <p> The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API and must be created using the CodeBuild console. </p>
    ///   - [`should_overwrite(bool)`](crate::client::fluent_builders::ImportSourceCredentials::should_overwrite) / [`set_should_overwrite(Option<bool>)`](crate::client::fluent_builders::ImportSourceCredentials::set_should_overwrite): <p> Set to <code>false</code> to prevent overwriting the repository source credentials. Set to <code>true</code> to overwrite the repository source credentials. The default value is <code>true</code>. </p>
    /// - On success, responds with [`ImportSourceCredentialsOutput`](crate::output::ImportSourceCredentialsOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::ImportSourceCredentialsOutput::arn): <p> The Amazon Resource Name (ARN) of the token. </p>
    /// - On failure, responds with [`SdkError<ImportSourceCredentialsError>`](crate::error::ImportSourceCredentialsError)
    pub fn import_source_credentials(&self) -> fluent_builders::ImportSourceCredentials {
        fluent_builders::ImportSourceCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`InvalidateProjectCache`](crate::client::fluent_builders::InvalidateProjectCache) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::InvalidateProjectCache::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::InvalidateProjectCache::set_project_name): <p>The name of the CodeBuild build project that the cache is reset for.</p>
    /// - On success, responds with [`InvalidateProjectCacheOutput`](crate::output::InvalidateProjectCacheOutput)

    /// - On failure, responds with [`SdkError<InvalidateProjectCacheError>`](crate::error::InvalidateProjectCacheError)
    pub fn invalidate_project_cache(&self) -> fluent_builders::InvalidateProjectCache {
        fluent_builders::InvalidateProjectCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBuildBatches`](crate::client::fluent_builders::ListBuildBatches) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBuildBatches::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(BuildBatchFilter)`](crate::client::fluent_builders::ListBuildBatches::filter) / [`set_filter(Option<BuildBatchFilter>)`](crate::client::fluent_builders::ListBuildBatches::set_filter): <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBuildBatches::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBuildBatches::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListBuildBatches::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListBuildBatches::set_sort_order): <p>Specifies the sort order of the returned items. Valid values include:</p>  <ul>   <li> <p> <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p> </li>   <li> <p> <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBuildBatches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBuildBatches::set_next_token): <p>The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatches</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
    /// - On success, responds with [`ListBuildBatchesOutput`](crate::output::ListBuildBatchesOutput) with field(s):
    ///   - [`ids(Option<Vec<String>>)`](crate::output::ListBuildBatchesOutput::ids): <p>An array of strings that contains the batch build identifiers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBuildBatchesOutput::next_token): <p>If there are more items to return, this contains a token that is passed to a subsequent call to <code>ListBuildBatches</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<ListBuildBatchesError>`](crate::error::ListBuildBatchesError)
    pub fn list_build_batches(&self) -> fluent_builders::ListBuildBatches {
        fluent_builders::ListBuildBatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBuildBatchesForProject`](crate::client::fluent_builders::ListBuildBatchesForProject) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBuildBatchesForProject::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::ListBuildBatchesForProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::ListBuildBatchesForProject::set_project_name): <p>The name of the project.</p>
    ///   - [`filter(BuildBatchFilter)`](crate::client::fluent_builders::ListBuildBatchesForProject::filter) / [`set_filter(Option<BuildBatchFilter>)`](crate::client::fluent_builders::ListBuildBatchesForProject::set_filter): <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBuildBatchesForProject::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBuildBatchesForProject::set_max_results): <p>The maximum number of results to return.</p>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListBuildBatchesForProject::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListBuildBatchesForProject::set_sort_order): <p>Specifies the sort order of the returned items. Valid values include:</p>  <ul>   <li> <p> <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p> </li>   <li> <p> <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBuildBatchesForProject::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBuildBatchesForProject::set_next_token): <p>The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatchesForProject</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
    /// - On success, responds with [`ListBuildBatchesForProjectOutput`](crate::output::ListBuildBatchesForProjectOutput) with field(s):
    ///   - [`ids(Option<Vec<String>>)`](crate::output::ListBuildBatchesForProjectOutput::ids): <p>An array of strings that contains the batch build identifiers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBuildBatchesForProjectOutput::next_token): <p>If there are more items to return, this contains a token that is passed to a subsequent call to <code>ListBuildBatchesForProject</code> to retrieve the next set of items.</p>
    /// - On failure, responds with [`SdkError<ListBuildBatchesForProjectError>`](crate::error::ListBuildBatchesForProjectError)
    pub fn list_build_batches_for_project(&self) -> fluent_builders::ListBuildBatchesForProject {
        fluent_builders::ListBuildBatchesForProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBuilds`](crate::client::fluent_builders::ListBuilds) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBuilds::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListBuilds::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListBuilds::set_sort_order): <p>The order to list build IDs. Valid values include:</p>  <ul>   <li> <p> <code>ASCENDING</code>: List the build IDs in ascending order by build ID.</p> </li>   <li> <p> <code>DESCENDING</code>: List the build IDs in descending order by build ID.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBuilds::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBuilds::set_next_token): <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
    /// - On success, responds with [`ListBuildsOutput`](crate::output::ListBuildsOutput) with field(s):
    ///   - [`ids(Option<Vec<String>>)`](crate::output::ListBuildsOutput::ids): <p>A list of build IDs, with each build ID representing a single build.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBuildsOutput::next_token): <p>If there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call.</p>
    /// - On failure, responds with [`SdkError<ListBuildsError>`](crate::error::ListBuildsError)
    pub fn list_builds(&self) -> fluent_builders::ListBuilds {
        fluent_builders::ListBuilds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBuildsForProject`](crate::client::fluent_builders::ListBuildsForProject) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBuildsForProject::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::ListBuildsForProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::ListBuildsForProject::set_project_name): <p>The name of the CodeBuild project.</p>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListBuildsForProject::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListBuildsForProject::set_sort_order): <p>The order to sort the results in. The results are sorted by build number, not the build identifier. If this is not specified, the results are sorted in descending order.</p>  <p>Valid values include:</p>  <ul>   <li> <p> <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.</p> </li>   <li> <p> <code>DESCENDING</code>: List the build identifiers in descending order, by build number.</p> </li>  </ul>  <p>If the project has more than 100 builds, setting the sort order will result in an error. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBuildsForProject::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBuildsForProject::set_next_token): <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
    /// - On success, responds with [`ListBuildsForProjectOutput`](crate::output::ListBuildsForProjectOutput) with field(s):
    ///   - [`ids(Option<Vec<String>>)`](crate::output::ListBuildsForProjectOutput::ids): <p>A list of build identifiers for the specified build project, with each build ID representing a single build.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBuildsForProjectOutput::next_token): <p>If there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call.</p>
    /// - On failure, responds with [`SdkError<ListBuildsForProjectError>`](crate::error::ListBuildsForProjectError)
    pub fn list_builds_for_project(&self) -> fluent_builders::ListBuildsForProject {
        fluent_builders::ListBuildsForProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCuratedEnvironmentImages`](crate::client::fluent_builders::ListCuratedEnvironmentImages) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListCuratedEnvironmentImages::send) it.

    /// - On success, responds with [`ListCuratedEnvironmentImagesOutput`](crate::output::ListCuratedEnvironmentImagesOutput) with field(s):
    ///   - [`platforms(Option<Vec<EnvironmentPlatform>>)`](crate::output::ListCuratedEnvironmentImagesOutput::platforms): <p>Information about supported platforms for Docker images that are managed by CodeBuild.</p>
    /// - On failure, responds with [`SdkError<ListCuratedEnvironmentImagesError>`](crate::error::ListCuratedEnvironmentImagesError)
    pub fn list_curated_environment_images(&self) -> fluent_builders::ListCuratedEnvironmentImages {
        fluent_builders::ListCuratedEnvironmentImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProjects`](crate::client::fluent_builders::ListProjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_by(ProjectSortByType)`](crate::client::fluent_builders::ListProjects::sort_by) / [`set_sort_by(Option<ProjectSortByType>)`](crate::client::fluent_builders::ListProjects::set_sort_by): <p>The criterion to be used to list build project names. Valid values include:</p>  <ul>   <li> <p> <code>CREATED_TIME</code>: List based on when each build project was created.</p> </li>   <li> <p> <code>LAST_MODIFIED_TIME</code>: List based on when information about each build project was last changed.</p> </li>   <li> <p> <code>NAME</code>: List based on each build project's name.</p> </li>  </ul>  <p>Use <code>sortOrder</code> to specify in what order to list the build project names based on the preceding criteria.</p>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListProjects::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListProjects::set_sort_order): <p>The order in which to list build projects. Valid values include:</p>  <ul>   <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>   <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>  </ul>  <p>Use <code>sortBy</code> to specify the criterion to be used to list build project names.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProjects::set_next_token): <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
    /// - On success, responds with [`ListProjectsOutput`](crate::output::ListProjectsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListProjectsOutput::next_token): <p>If there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call.</p>
    ///   - [`projects(Option<Vec<String>>)`](crate::output::ListProjectsOutput::projects): <p>The list of build project names, with each build project name representing a single build project.</p>
    /// - On failure, responds with [`SdkError<ListProjectsError>`](crate::error::ListProjectsError)
    pub fn list_projects(&self) -> fluent_builders::ListProjects {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReportGroups`](crate::client::fluent_builders::ListReportGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReportGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListReportGroups::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListReportGroups::set_sort_order): <p> Used to specify the order to sort the list of returned report groups. Valid values are <code>ASCENDING</code> and <code>DESCENDING</code>. </p>
    ///   - [`sort_by(ReportGroupSortByType)`](crate::client::fluent_builders::ListReportGroups::sort_by) / [`set_sort_by(Option<ReportGroupSortByType>)`](crate::client::fluent_builders::ListReportGroups::set_sort_by): <p> The criterion to be used to list build report groups. Valid values include: </p>  <ul>   <li> <p> <code>CREATED_TIME</code>: List based on when each report group was created.</p> </li>   <li> <p> <code>LAST_MODIFIED_TIME</code>: List based on when each report group was last changed.</p> </li>   <li> <p> <code>NAME</code>: List based on each report group's name.</p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReportGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReportGroups::set_next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReportGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReportGroups::set_max_results): <p> The maximum number of paginated report groups returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>ReportGroup</code> objects. The default value is 100. </p>
    /// - On success, responds with [`ListReportGroupsOutput`](crate::output::ListReportGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListReportGroupsOutput::next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`report_groups(Option<Vec<String>>)`](crate::output::ListReportGroupsOutput::report_groups): <p> The list of ARNs for the report groups in the current Amazon Web Services account. </p>
    /// - On failure, responds with [`SdkError<ListReportGroupsError>`](crate::error::ListReportGroupsError)
    pub fn list_report_groups(&self) -> fluent_builders::ListReportGroups {
        fluent_builders::ListReportGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReports`](crate::client::fluent_builders::ListReports) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReports::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListReports::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListReports::set_sort_order): <p> Specifies the sort order for the list of returned reports. Valid values are: </p>  <ul>   <li> <p> <code>ASCENDING</code>: return reports in chronological order based on their creation date. </p> </li>   <li> <p> <code>DESCENDING</code>: return reports in the reverse chronological order based on their creation date. </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReports::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReports::set_next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReports::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReports::set_max_results): <p> The maximum number of paginated reports returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default value is 100. </p>
    ///   - [`filter(ReportFilter)`](crate::client::fluent_builders::ListReports::filter) / [`set_filter(Option<ReportFilter>)`](crate::client::fluent_builders::ListReports::set_filter): <p> A <code>ReportFilter</code> object used to filter the returned reports. </p>
    /// - On success, responds with [`ListReportsOutput`](crate::output::ListReportsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListReportsOutput::next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`reports(Option<Vec<String>>)`](crate::output::ListReportsOutput::reports): <p> The list of returned ARNs for the reports in the current Amazon Web Services account. </p>
    /// - On failure, responds with [`SdkError<ListReportsError>`](crate::error::ListReportsError)
    pub fn list_reports(&self) -> fluent_builders::ListReports {
        fluent_builders::ListReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReportsForReportGroup`](crate::client::fluent_builders::ListReportsForReportGroup) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReportsForReportGroup::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_group_arn(impl Into<String>)`](crate::client::fluent_builders::ListReportsForReportGroup::report_group_arn) / [`set_report_group_arn(Option<String>)`](crate::client::fluent_builders::ListReportsForReportGroup::set_report_group_arn): <p> The ARN of the report group for which you want to return report ARNs. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReportsForReportGroup::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReportsForReportGroup::set_next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListReportsForReportGroup::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListReportsForReportGroup::set_sort_order): <p> Use to specify whether the results are returned in ascending or descending order. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReportsForReportGroup::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReportsForReportGroup::set_max_results): <p> The maximum number of paginated reports in this report group returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default value is 100. </p>
    ///   - [`filter(ReportFilter)`](crate::client::fluent_builders::ListReportsForReportGroup::filter) / [`set_filter(Option<ReportFilter>)`](crate::client::fluent_builders::ListReportsForReportGroup::set_filter): <p> A <code>ReportFilter</code> object used to filter the returned reports. </p>
    /// - On success, responds with [`ListReportsForReportGroupOutput`](crate::output::ListReportsForReportGroupOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListReportsForReportGroupOutput::next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`reports(Option<Vec<String>>)`](crate::output::ListReportsForReportGroupOutput::reports): <p> The list of report ARNs. </p>
    /// - On failure, responds with [`SdkError<ListReportsForReportGroupError>`](crate::error::ListReportsForReportGroupError)
    pub fn list_reports_for_report_group(&self) -> fluent_builders::ListReportsForReportGroup {
        fluent_builders::ListReportsForReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSharedProjects`](crate::client::fluent_builders::ListSharedProjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSharedProjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_by(SharedResourceSortByType)`](crate::client::fluent_builders::ListSharedProjects::sort_by) / [`set_sort_by(Option<SharedResourceSortByType>)`](crate::client::fluent_builders::ListSharedProjects::set_sort_by): <p> The criterion to be used to list build projects shared with the current Amazon Web Services account or user. Valid values include: </p>  <ul>   <li> <p> <code>ARN</code>: List based on the ARN. </p> </li>   <li> <p> <code>MODIFIED_TIME</code>: List based on when information about the shared project was last changed. </p> </li>  </ul>
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListSharedProjects::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListSharedProjects::set_sort_order): <p>The order in which to list shared build projects. Valid values include:</p>  <ul>   <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>   <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSharedProjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSharedProjects::set_max_results): <p> The maximum number of paginated shared build projects returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Project</code> objects. The default value is 100. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSharedProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSharedProjects::set_next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    /// - On success, responds with [`ListSharedProjectsOutput`](crate::output::ListSharedProjectsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListSharedProjectsOutput::next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`projects(Option<Vec<String>>)`](crate::output::ListSharedProjectsOutput::projects): <p> The list of ARNs for the build projects shared with the current Amazon Web Services account or user. </p>
    /// - On failure, responds with [`SdkError<ListSharedProjectsError>`](crate::error::ListSharedProjectsError)
    pub fn list_shared_projects(&self) -> fluent_builders::ListSharedProjects {
        fluent_builders::ListSharedProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSharedReportGroups`](crate::client::fluent_builders::ListSharedReportGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSharedReportGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`sort_order(SortOrderType)`](crate::client::fluent_builders::ListSharedReportGroups::sort_order) / [`set_sort_order(Option<SortOrderType>)`](crate::client::fluent_builders::ListSharedReportGroups::set_sort_order): <p>The order in which to list shared report groups. Valid values include:</p>  <ul>   <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>   <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>  </ul>
    ///   - [`sort_by(SharedResourceSortByType)`](crate::client::fluent_builders::ListSharedReportGroups::sort_by) / [`set_sort_by(Option<SharedResourceSortByType>)`](crate::client::fluent_builders::ListSharedReportGroups::set_sort_by): <p> The criterion to be used to list report groups shared with the current Amazon Web Services account or user. Valid values include: </p>  <ul>   <li> <p> <code>ARN</code>: List based on the ARN. </p> </li>   <li> <p> <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last changed. </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSharedReportGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSharedReportGroups::set_next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSharedReportGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSharedReportGroups::set_max_results): <p> The maximum number of paginated shared report groups per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>ReportGroup</code> objects. The default value is 100. </p>
    /// - On success, responds with [`ListSharedReportGroupsOutput`](crate::output::ListSharedReportGroupsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListSharedReportGroupsOutput::next_token): <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
    ///   - [`report_groups(Option<Vec<String>>)`](crate::output::ListSharedReportGroupsOutput::report_groups): <p> The list of ARNs for the report groups shared with the current Amazon Web Services account or user. </p>
    /// - On failure, responds with [`SdkError<ListSharedReportGroupsError>`](crate::error::ListSharedReportGroupsError)
    pub fn list_shared_report_groups(&self) -> fluent_builders::ListSharedReportGroups {
        fluent_builders::ListSharedReportGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSourceCredentials`](crate::client::fluent_builders::ListSourceCredentials) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::ListSourceCredentials::send) it.

    /// - On success, responds with [`ListSourceCredentialsOutput`](crate::output::ListSourceCredentialsOutput) with field(s):
    ///   - [`source_credentials_infos(Option<Vec<SourceCredentialsInfo>>)`](crate::output::ListSourceCredentialsOutput::source_credentials_infos): <p> A list of <code>SourceCredentialsInfo</code> objects. Each <code>SourceCredentialsInfo</code> object includes the authentication type, token ARN, and type of source provider for one set of credentials. </p>
    /// - On failure, responds with [`SdkError<ListSourceCredentialsError>`](crate::error::ListSourceCredentialsError)
    pub fn list_source_credentials(&self) -> fluent_builders::ListSourceCredentials {
        fluent_builders::ListSourceCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::policy) / [`set_policy(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_policy): <p> A JSON-formatted resource policy. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share">Sharing a Project</a> and <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share">Sharing a Report Group</a> in the <i>CodeBuild User Guide</i>. </p>
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_resource_arn): <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource you want to associate with a resource policy. </p>
    /// - On success, responds with [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput) with field(s):
    ///   - [`resource_arn(Option<String>)`](crate::output::PutResourcePolicyOutput::resource_arn): <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource that is associated with a resource policy. </p>
    /// - On failure, responds with [`SdkError<PutResourcePolicyError>`](crate::error::PutResourcePolicyError)
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetryBuild`](crate::client::fluent_builders::RetryBuild) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::RetryBuild::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::RetryBuild::set_id): <p>Specifies the identifier of the build to restart.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::RetryBuild::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::RetryBuild::set_idempotency_token): <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuild</code> request. The token is included in the <code>RetryBuild</code> request and is valid for five minutes. If you repeat the <code>RetryBuild</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
    /// - On success, responds with [`RetryBuildOutput`](crate::output::RetryBuildOutput) with field(s):
    ///   - [`build_value(Option<Build>)`](crate::output::RetryBuildOutput::build_value): <p>Information about a build.</p>
    /// - On failure, responds with [`SdkError<RetryBuildError>`](crate::error::RetryBuildError)
    pub fn retry_build(&self) -> fluent_builders::RetryBuild {
        fluent_builders::RetryBuild::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RetryBuildBatch`](crate::client::fluent_builders::RetryBuildBatch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::RetryBuildBatch::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::RetryBuildBatch::set_id): <p>Specifies the identifier of the batch build to restart.</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::RetryBuildBatch::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::RetryBuildBatch::set_idempotency_token): <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuildBatch</code> request. The token is included in the <code>RetryBuildBatch</code> request and is valid for five minutes. If you repeat the <code>RetryBuildBatch</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
    ///   - [`retry_type(RetryBuildBatchType)`](crate::client::fluent_builders::RetryBuildBatch::retry_type) / [`set_retry_type(Option<RetryBuildBatchType>)`](crate::client::fluent_builders::RetryBuildBatch::set_retry_type): <p>Specifies the type of retry to perform.</p>
    /// - On success, responds with [`RetryBuildBatchOutput`](crate::output::RetryBuildBatchOutput) with field(s):
    ///   - [`build_batch(Option<BuildBatch>)`](crate::output::RetryBuildBatchOutput::build_batch): <p>Contains information about a batch build.</p>
    /// - On failure, responds with [`SdkError<RetryBuildBatchError>`](crate::error::RetryBuildBatchError)
    pub fn retry_build_batch(&self) -> fluent_builders::RetryBuildBatch {
        fluent_builders::RetryBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartBuild`](crate::client::fluent_builders::StartBuild) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::StartBuild::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::StartBuild::set_project_name): <p>The name of the CodeBuild build project to start running a build.</p>
    ///   - [`secondary_sources_override(Vec<ProjectSource>)`](crate::client::fluent_builders::StartBuild::secondary_sources_override) / [`set_secondary_sources_override(Option<Vec<ProjectSource>>)`](crate::client::fluent_builders::StartBuild::set_secondary_sources_override): <p> An array of <code>ProjectSource</code> objects. </p>
    ///   - [`secondary_sources_version_override(Vec<ProjectSourceVersion>)`](crate::client::fluent_builders::StartBuild::secondary_sources_version_override) / [`set_secondary_sources_version_override(Option<Vec<ProjectSourceVersion>>)`](crate::client::fluent_builders::StartBuild::set_secondary_sources_version_override): <p> An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's secondary sources to be used for this build only. </p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::StartBuild::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::StartBuild::set_source_version): <p>The version of the build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:</p>  <dl>   <dt>   CodeCommit  </dt>   <dd>    <p>The commit ID, branch, or Git tag to use.</p>   </dd>   <dt>   GitHub  </dt>   <dd>    <p>The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>   </dd>   <dt>   Bitbucket  </dt>   <dd>    <p>The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>   </dd>   <dt>   Amazon S3  </dt>   <dd>    <p>The version ID of the object that represents the build input ZIP file to use.</p>   </dd>  </dl>  <p>If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the build level) takes precedence. </p>  <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    ///   - [`artifacts_override(ProjectArtifacts)`](crate::client::fluent_builders::StartBuild::artifacts_override) / [`set_artifacts_override(Option<ProjectArtifacts>)`](crate::client::fluent_builders::StartBuild::set_artifacts_override): <p>Build output artifact settings that override, for this build only, the latest ones already defined in the build project.</p>
    ///   - [`secondary_artifacts_override(Vec<ProjectArtifacts>)`](crate::client::fluent_builders::StartBuild::secondary_artifacts_override) / [`set_secondary_artifacts_override(Option<Vec<ProjectArtifacts>>)`](crate::client::fluent_builders::StartBuild::set_secondary_artifacts_override): <p> An array of <code>ProjectArtifacts</code> objects. </p>
    ///   - [`environment_variables_override(Vec<EnvironmentVariable>)`](crate::client::fluent_builders::StartBuild::environment_variables_override) / [`set_environment_variables_override(Option<Vec<EnvironmentVariable>>)`](crate::client::fluent_builders::StartBuild::set_environment_variables_override): <p>A set of environment variables that overrides, for this build only, the latest ones already defined in the build project.</p>
    ///   - [`source_type_override(SourceType)`](crate::client::fluent_builders::StartBuild::source_type_override) / [`set_source_type_override(Option<SourceType>)`](crate::client::fluent_builders::StartBuild::set_source_type_override): <p>A source input type, for this build, that overrides the source input defined in the build project.</p>
    ///   - [`source_location_override(impl Into<String>)`](crate::client::fluent_builders::StartBuild::source_location_override) / [`set_source_location_override(Option<String>)`](crate::client::fluent_builders::StartBuild::set_source_location_override): <p>A location that overrides, for this build, the source location for the one defined in the build project.</p>
    ///   - [`source_auth_override(SourceAuth)`](crate::client::fluent_builders::StartBuild::source_auth_override) / [`set_source_auth_override(Option<SourceAuth>)`](crate::client::fluent_builders::StartBuild::set_source_auth_override): <p>An authorization type for this build that overrides the one defined in the build project. This override applies only if the build project's source is BitBucket or GitHub.</p>
    ///   - [`git_clone_depth_override(i32)`](crate::client::fluent_builders::StartBuild::git_clone_depth_override) / [`set_git_clone_depth_override(Option<i32>)`](crate::client::fluent_builders::StartBuild::set_git_clone_depth_override): <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any previous depth of history defined in the build project.</p>
    ///   - [`git_submodules_config_override(GitSubmodulesConfig)`](crate::client::fluent_builders::StartBuild::git_submodules_config_override) / [`set_git_submodules_config_override(Option<GitSubmodulesConfig>)`](crate::client::fluent_builders::StartBuild::set_git_submodules_config_override): <p> Information about the Git submodules configuration for this build of an CodeBuild build project. </p>
    ///   - [`buildspec_override(impl Into<String>)`](crate::client::fluent_builders::StartBuild::buildspec_override) / [`set_buildspec_override(Option<String>)`](crate::client::fluent_builders::StartBuild::set_buildspec_override): <p>A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.</p>  <p> If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
    ///   - [`insecure_ssl_override(bool)`](crate::client::fluent_builders::StartBuild::insecure_ssl_override) / [`set_insecure_ssl_override(Option<bool>)`](crate::client::fluent_builders::StartBuild::set_insecure_ssl_override): <p>Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.</p>
    ///   - [`report_build_status_override(bool)`](crate::client::fluent_builders::StartBuild::report_build_status_override) / [`set_report_build_status_override(Option<bool>)`](crate::client::fluent_builders::StartBuild::set_report_build_status_override): <p> Set to true to report to your source provider the status of a build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p>  <p>To be able to report the build status to the source provider, the user associated with the source provider must have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p> <note>   <p> The status of a build triggered by a webhook is always reported to your source provider. </p>  </note>
    ///   - [`build_status_config_override(BuildStatusConfig)`](crate::client::fluent_builders::StartBuild::build_status_config_override) / [`set_build_status_config_override(Option<BuildStatusConfig>)`](crate::client::fluent_builders::StartBuild::set_build_status_config_override): <p>Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or <code>BITBUCKET</code>.</p>
    ///   - [`environment_type_override(EnvironmentType)`](crate::client::fluent_builders::StartBuild::environment_type_override) / [`set_environment_type_override(Option<EnvironmentType>)`](crate::client::fluent_builders::StartBuild::set_environment_type_override): <p>A container type for this build that overrides the one specified in the build project.</p>
    ///   - [`image_override(impl Into<String>)`](crate::client::fluent_builders::StartBuild::image_override) / [`set_image_override(Option<String>)`](crate::client::fluent_builders::StartBuild::set_image_override): <p>The name of an image for this build that overrides the one specified in the build project.</p>
    ///   - [`compute_type_override(ComputeType)`](crate::client::fluent_builders::StartBuild::compute_type_override) / [`set_compute_type_override(Option<ComputeType>)`](crate::client::fluent_builders::StartBuild::set_compute_type_override): <p>The name of a compute type for this build that overrides the one specified in the build project.</p>
    ///   - [`certificate_override(impl Into<String>)`](crate::client::fluent_builders::StartBuild::certificate_override) / [`set_certificate_override(Option<String>)`](crate::client::fluent_builders::StartBuild::set_certificate_override): <p>The name of a certificate for this build that overrides the one specified in the build project.</p>
    ///   - [`cache_override(ProjectCache)`](crate::client::fluent_builders::StartBuild::cache_override) / [`set_cache_override(Option<ProjectCache>)`](crate::client::fluent_builders::StartBuild::set_cache_override): <p>A ProjectCache object specified for this build that overrides the one defined in the build project.</p>
    ///   - [`service_role_override(impl Into<String>)`](crate::client::fluent_builders::StartBuild::service_role_override) / [`set_service_role_override(Option<String>)`](crate::client::fluent_builders::StartBuild::set_service_role_override): <p>The name of a service role for this build that overrides the one specified in the build project.</p>
    ///   - [`privileged_mode_override(bool)`](crate::client::fluent_builders::StartBuild::privileged_mode_override) / [`set_privileged_mode_override(Option<bool>)`](crate::client::fluent_builders::StartBuild::set_privileged_mode_override): <p>Enable this flag to override privileged mode in the build project.</p>
    ///   - [`timeout_in_minutes_override(i32)`](crate::client::fluent_builders::StartBuild::timeout_in_minutes_override) / [`set_timeout_in_minutes_override(Option<i32>)`](crate::client::fluent_builders::StartBuild::set_timeout_in_minutes_override): <p>The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest setting already defined in the build project.</p>
    ///   - [`queued_timeout_in_minutes_override(i32)`](crate::client::fluent_builders::StartBuild::queued_timeout_in_minutes_override) / [`set_queued_timeout_in_minutes_override(Option<i32>)`](crate::client::fluent_builders::StartBuild::set_queued_timeout_in_minutes_override): <p> The number of minutes a build is allowed to be queued before it times out. </p>
    ///   - [`encryption_key_override(impl Into<String>)`](crate::client::fluent_builders::StartBuild::encryption_key_override) / [`set_encryption_key_override(Option<String>)`](crate::client::fluent_builders::StartBuild::set_encryption_key_override): <p>The Key Management Service customer master key (CMK) that overrides the one specified in the build project. The CMK key encrypts the build output artifacts.</p> <note>   <p> You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>  </note>  <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/   <alias-name></alias-name></code>).</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::StartBuild::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::StartBuild::set_idempotency_token): <p>A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The token is included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error. </p>
    ///   - [`logs_config_override(LogsConfig)`](crate::client::fluent_builders::StartBuild::logs_config_override) / [`set_logs_config_override(Option<LogsConfig>)`](crate::client::fluent_builders::StartBuild::set_logs_config_override): <p> Log settings for this build that override the log settings defined in the build project. </p>
    ///   - [`registry_credential_override(RegistryCredential)`](crate::client::fluent_builders::StartBuild::registry_credential_override) / [`set_registry_credential_override(Option<RegistryCredential>)`](crate::client::fluent_builders::StartBuild::set_registry_credential_override): <p> The credentials for access to a private registry. </p>
    ///   - [`image_pull_credentials_type_override(ImagePullCredentialsType)`](crate::client::fluent_builders::StartBuild::image_pull_credentials_type_override) / [`set_image_pull_credentials_type_override(Option<ImagePullCredentialsType>)`](crate::client::fluent_builders::StartBuild::set_image_pull_credentials_type_override): <p>The type of credentials CodeBuild uses to pull images in your build. There are two valid values: </p>  <dl>   <dt>   CODEBUILD  </dt>   <dd>    <p>Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.</p>   </dd>   <dt>   SERVICE_ROLE  </dt>   <dd>    <p>Specifies that CodeBuild uses your build project's service role. </p>   </dd>  </dl>  <p>When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials. </p>
    ///   - [`debug_session_enabled(bool)`](crate::client::fluent_builders::StartBuild::debug_session_enabled) / [`set_debug_session_enabled(Option<bool>)`](crate::client::fluent_builders::StartBuild::set_debug_session_enabled): <p>Specifies if session debugging is enabled for this build. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>.</p>
    /// - On success, responds with [`StartBuildOutput`](crate::output::StartBuildOutput) with field(s):
    ///   - [`build_value(Option<Build>)`](crate::output::StartBuildOutput::build_value): <p>Information about the build to be run.</p>
    /// - On failure, responds with [`SdkError<StartBuildError>`](crate::error::StartBuildError)
    pub fn start_build(&self) -> fluent_builders::StartBuild {
        fluent_builders::StartBuild::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartBuildBatch`](crate::client::fluent_builders::StartBuildBatch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_project_name): <p>The name of the project.</p>
    ///   - [`secondary_sources_override(Vec<ProjectSource>)`](crate::client::fluent_builders::StartBuildBatch::secondary_sources_override) / [`set_secondary_sources_override(Option<Vec<ProjectSource>>)`](crate::client::fluent_builders::StartBuildBatch::set_secondary_sources_override): <p>An array of <code>ProjectSource</code> objects that override the secondary sources defined in the batch build project.</p>
    ///   - [`secondary_sources_version_override(Vec<ProjectSourceVersion>)`](crate::client::fluent_builders::StartBuildBatch::secondary_sources_version_override) / [`set_secondary_sources_version_override(Option<Vec<ProjectSourceVersion>>)`](crate::client::fluent_builders::StartBuildBatch::set_secondary_sources_version_override): <p>An array of <code>ProjectSourceVersion</code> objects that override the secondary source versions in the batch build project.</p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_source_version): <p>The version of the batch build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:</p>  <dl>   <dt>   CodeCommit  </dt>   <dd>    <p>The commit ID, branch, or Git tag to use.</p>   </dd>   <dt>   GitHub  </dt>   <dd>    <p>The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>   </dd>   <dt>   Bitbucket  </dt>   <dd>    <p>The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>   </dd>   <dt>   Amazon S3  </dt>   <dd>    <p>The version ID of the object that represents the build input ZIP file to use.</p>   </dd>  </dl>  <p>If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the build level) takes precedence. </p>  <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    ///   - [`artifacts_override(ProjectArtifacts)`](crate::client::fluent_builders::StartBuildBatch::artifacts_override) / [`set_artifacts_override(Option<ProjectArtifacts>)`](crate::client::fluent_builders::StartBuildBatch::set_artifacts_override): <p>An array of <code>ProjectArtifacts</code> objects that contains information about the build output artifact overrides for the build project.</p>
    ///   - [`secondary_artifacts_override(Vec<ProjectArtifacts>)`](crate::client::fluent_builders::StartBuildBatch::secondary_artifacts_override) / [`set_secondary_artifacts_override(Option<Vec<ProjectArtifacts>>)`](crate::client::fluent_builders::StartBuildBatch::set_secondary_artifacts_override): <p>An array of <code>ProjectArtifacts</code> objects that override the secondary artifacts defined in the batch build project.</p>
    ///   - [`environment_variables_override(Vec<EnvironmentVariable>)`](crate::client::fluent_builders::StartBuildBatch::environment_variables_override) / [`set_environment_variables_override(Option<Vec<EnvironmentVariable>>)`](crate::client::fluent_builders::StartBuildBatch::set_environment_variables_override): <p>An array of <code>EnvironmentVariable</code> objects that override, or add to, the environment variables defined in the batch build project.</p>
    ///   - [`source_type_override(SourceType)`](crate::client::fluent_builders::StartBuildBatch::source_type_override) / [`set_source_type_override(Option<SourceType>)`](crate::client::fluent_builders::StartBuildBatch::set_source_type_override): <p>The source input type that overrides the source input defined in the batch build project.</p>
    ///   - [`source_location_override(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::source_location_override) / [`set_source_location_override(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_source_location_override): <p>A location that overrides, for this batch build, the source location defined in the batch build project.</p>
    ///   - [`source_auth_override(SourceAuth)`](crate::client::fluent_builders::StartBuildBatch::source_auth_override) / [`set_source_auth_override(Option<SourceAuth>)`](crate::client::fluent_builders::StartBuildBatch::set_source_auth_override): <p>A <code>SourceAuth</code> object that overrides the one defined in the batch build project. This override applies only if the build project's source is BitBucket or GitHub.</p>
    ///   - [`git_clone_depth_override(i32)`](crate::client::fluent_builders::StartBuildBatch::git_clone_depth_override) / [`set_git_clone_depth_override(Option<i32>)`](crate::client::fluent_builders::StartBuildBatch::set_git_clone_depth_override): <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this batch build only, any previous depth of history defined in the batch build project.</p>
    ///   - [`git_submodules_config_override(GitSubmodulesConfig)`](crate::client::fluent_builders::StartBuildBatch::git_submodules_config_override) / [`set_git_submodules_config_override(Option<GitSubmodulesConfig>)`](crate::client::fluent_builders::StartBuildBatch::set_git_submodules_config_override): <p>A <code>GitSubmodulesConfig</code> object that overrides the Git submodules configuration for this batch build.</p>
    ///   - [`buildspec_override(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::buildspec_override) / [`set_buildspec_override(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_buildspec_override): <p>A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.</p>  <p>If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
    ///   - [`insecure_ssl_override(bool)`](crate::client::fluent_builders::StartBuildBatch::insecure_ssl_override) / [`set_insecure_ssl_override(Option<bool>)`](crate::client::fluent_builders::StartBuildBatch::set_insecure_ssl_override): <p>Enable this flag to override the insecure SSL setting that is specified in the batch build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.</p>
    ///   - [`report_build_batch_status_override(bool)`](crate::client::fluent_builders::StartBuildBatch::report_build_batch_status_override) / [`set_report_build_batch_status_override(Option<bool>)`](crate::client::fluent_builders::StartBuildBatch::set_report_build_batch_status_override): <p>Set to <code>true</code> to report to your source provider the status of a batch build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p> <note>   <p>The status of a build triggered by a webhook is always reported to your source provider. </p>  </note>
    ///   - [`environment_type_override(EnvironmentType)`](crate::client::fluent_builders::StartBuildBatch::environment_type_override) / [`set_environment_type_override(Option<EnvironmentType>)`](crate::client::fluent_builders::StartBuildBatch::set_environment_type_override): <p>A container type for this batch build that overrides the one specified in the batch build project.</p>
    ///   - [`image_override(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::image_override) / [`set_image_override(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_image_override): <p>The name of an image for this batch build that overrides the one specified in the batch build project.</p>
    ///   - [`compute_type_override(ComputeType)`](crate::client::fluent_builders::StartBuildBatch::compute_type_override) / [`set_compute_type_override(Option<ComputeType>)`](crate::client::fluent_builders::StartBuildBatch::set_compute_type_override): <p>The name of a compute type for this batch build that overrides the one specified in the batch build project.</p>
    ///   - [`certificate_override(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::certificate_override) / [`set_certificate_override(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_certificate_override): <p>The name of a certificate for this batch build that overrides the one specified in the batch build project.</p>
    ///   - [`cache_override(ProjectCache)`](crate::client::fluent_builders::StartBuildBatch::cache_override) / [`set_cache_override(Option<ProjectCache>)`](crate::client::fluent_builders::StartBuildBatch::set_cache_override): <p>A <code>ProjectCache</code> object that specifies cache overrides.</p>
    ///   - [`service_role_override(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::service_role_override) / [`set_service_role_override(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_service_role_override): <p>The name of a service role for this batch build that overrides the one specified in the batch build project.</p>
    ///   - [`privileged_mode_override(bool)`](crate::client::fluent_builders::StartBuildBatch::privileged_mode_override) / [`set_privileged_mode_override(Option<bool>)`](crate::client::fluent_builders::StartBuildBatch::set_privileged_mode_override): <p>Enable this flag to override privileged mode in the batch build project.</p>
    ///   - [`build_timeout_in_minutes_override(i32)`](crate::client::fluent_builders::StartBuildBatch::build_timeout_in_minutes_override) / [`set_build_timeout_in_minutes_override(Option<i32>)`](crate::client::fluent_builders::StartBuildBatch::set_build_timeout_in_minutes_override): <p>Overrides the build timeout specified in the batch build project.</p>
    ///   - [`queued_timeout_in_minutes_override(i32)`](crate::client::fluent_builders::StartBuildBatch::queued_timeout_in_minutes_override) / [`set_queued_timeout_in_minutes_override(Option<i32>)`](crate::client::fluent_builders::StartBuildBatch::set_queued_timeout_in_minutes_override): <p>The number of minutes a batch build is allowed to be queued before it times out.</p>
    ///   - [`encryption_key_override(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::encryption_key_override) / [`set_encryption_key_override(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_encryption_key_override): <p>The Key Management Service customer master key (CMK) that overrides the one specified in the batch build project. The CMK key encrypts the build output artifacts.</p> <note>   <p>You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>  </note>  <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/   <alias-name></alias-name></code>).</p>
    ///   - [`idempotency_token(impl Into<String>)`](crate::client::fluent_builders::StartBuildBatch::idempotency_token) / [`set_idempotency_token(Option<String>)`](crate::client::fluent_builders::StartBuildBatch::set_idempotency_token): <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>StartBuildBatch</code> request. The token is included in the <code>StartBuildBatch</code> request and is valid for five minutes. If you repeat the <code>StartBuildBatch</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
    ///   - [`logs_config_override(LogsConfig)`](crate::client::fluent_builders::StartBuildBatch::logs_config_override) / [`set_logs_config_override(Option<LogsConfig>)`](crate::client::fluent_builders::StartBuildBatch::set_logs_config_override): <p>A <code>LogsConfig</code> object that override the log settings defined in the batch build project.</p>
    ///   - [`registry_credential_override(RegistryCredential)`](crate::client::fluent_builders::StartBuildBatch::registry_credential_override) / [`set_registry_credential_override(Option<RegistryCredential>)`](crate::client::fluent_builders::StartBuildBatch::set_registry_credential_override): <p>A <code>RegistryCredential</code> object that overrides credentials for access to a private registry.</p>
    ///   - [`image_pull_credentials_type_override(ImagePullCredentialsType)`](crate::client::fluent_builders::StartBuildBatch::image_pull_credentials_type_override) / [`set_image_pull_credentials_type_override(Option<ImagePullCredentialsType>)`](crate::client::fluent_builders::StartBuildBatch::set_image_pull_credentials_type_override): <p>The type of credentials CodeBuild uses to pull images in your batch build. There are two valid values: </p>  <dl>   <dt>   CODEBUILD  </dt>   <dd>    <p>Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.</p>   </dd>   <dt>   SERVICE_ROLE  </dt>   <dd>    <p>Specifies that CodeBuild uses your build project's service role. </p>   </dd>  </dl>  <p>When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials. </p>
    ///   - [`build_batch_config_override(ProjectBuildBatchConfig)`](crate::client::fluent_builders::StartBuildBatch::build_batch_config_override) / [`set_build_batch_config_override(Option<ProjectBuildBatchConfig>)`](crate::client::fluent_builders::StartBuildBatch::set_build_batch_config_override): <p>A <code>BuildBatchConfigOverride</code> object that contains batch build configuration overrides.</p>
    ///   - [`debug_session_enabled(bool)`](crate::client::fluent_builders::StartBuildBatch::debug_session_enabled) / [`set_debug_session_enabled(Option<bool>)`](crate::client::fluent_builders::StartBuildBatch::set_debug_session_enabled): <p>Specifies if session debugging is enabled for this batch build. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
    /// - On success, responds with [`StartBuildBatchOutput`](crate::output::StartBuildBatchOutput) with field(s):
    ///   - [`build_batch(Option<BuildBatch>)`](crate::output::StartBuildBatchOutput::build_batch): <p>A <code>BuildBatch</code> object that contains information about the batch build.</p>
    /// - On failure, responds with [`SdkError<StartBuildBatchError>`](crate::error::StartBuildBatchError)
    pub fn start_build_batch(&self) -> fluent_builders::StartBuildBatch {
        fluent_builders::StartBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopBuild`](crate::client::fluent_builders::StopBuild) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::StopBuild::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::StopBuild::set_id): <p>The ID of the build.</p>
    /// - On success, responds with [`StopBuildOutput`](crate::output::StopBuildOutput) with field(s):
    ///   - [`build_value(Option<Build>)`](crate::output::StopBuildOutput::build_value): <p>Information about the build.</p>
    /// - On failure, responds with [`SdkError<StopBuildError>`](crate::error::StopBuildError)
    pub fn stop_build(&self) -> fluent_builders::StopBuild {
        fluent_builders::StopBuild::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopBuildBatch`](crate::client::fluent_builders::StopBuildBatch) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::StopBuildBatch::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::StopBuildBatch::set_id): <p>The identifier of the batch build to stop.</p>
    /// - On success, responds with [`StopBuildBatchOutput`](crate::output::StopBuildBatchOutput) with field(s):
    ///   - [`build_batch(Option<BuildBatch>)`](crate::output::StopBuildBatchOutput::build_batch): <p>Contains information about a batch build.</p>
    /// - On failure, responds with [`SdkError<StopBuildBatchError>`](crate::error::StopBuildBatchError)
    pub fn stop_build_batch(&self) -> fluent_builders::StopBuildBatch {
        fluent_builders::StopBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProject`](crate::client::fluent_builders::UpdateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_name): <p>The name of the build project.</p> <note>   <p>You cannot change a build project's name.</p>  </note>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_description): <p>A new or replacement description of the build project.</p>
    ///   - [`source(ProjectSource)`](crate::client::fluent_builders::UpdateProject::source) / [`set_source(Option<ProjectSource>)`](crate::client::fluent_builders::UpdateProject::set_source): <p>Information to be changed about the build input source code for the build project.</p>
    ///   - [`secondary_sources(Vec<ProjectSource>)`](crate::client::fluent_builders::UpdateProject::secondary_sources) / [`set_secondary_sources(Option<Vec<ProjectSource>>)`](crate::client::fluent_builders::UpdateProject::set_secondary_sources): <p> An array of <code>ProjectSource</code> objects. </p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_source_version): <p> A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of: </p>  <ul>   <li> <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p> </li>   <li> <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>   <li> <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>   <li> <p>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</p> </li>  </ul>  <p> If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level). </p>  <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    ///   - [`secondary_source_versions(Vec<ProjectSourceVersion>)`](crate::client::fluent_builders::UpdateProject::secondary_source_versions) / [`set_secondary_source_versions(Option<Vec<ProjectSourceVersion>>)`](crate::client::fluent_builders::UpdateProject::set_secondary_source_versions): <p> An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level). </p>
    ///   - [`artifacts(ProjectArtifacts)`](crate::client::fluent_builders::UpdateProject::artifacts) / [`set_artifacts(Option<ProjectArtifacts>)`](crate::client::fluent_builders::UpdateProject::set_artifacts): <p>Information to be changed about the build output artifacts for the build project.</p>
    ///   - [`secondary_artifacts(Vec<ProjectArtifacts>)`](crate::client::fluent_builders::UpdateProject::secondary_artifacts) / [`set_secondary_artifacts(Option<Vec<ProjectArtifacts>>)`](crate::client::fluent_builders::UpdateProject::set_secondary_artifacts): <p> An array of <code>ProjectArtifact</code> objects. </p>
    ///   - [`cache(ProjectCache)`](crate::client::fluent_builders::UpdateProject::cache) / [`set_cache(Option<ProjectCache>)`](crate::client::fluent_builders::UpdateProject::set_cache): <p>Stores recently used information so that it can be quickly accessed at a later time.</p>
    ///   - [`environment(ProjectEnvironment)`](crate::client::fluent_builders::UpdateProject::environment) / [`set_environment(Option<ProjectEnvironment>)`](crate::client::fluent_builders::UpdateProject::set_environment): <p>Information to be changed about the build environment for the build project.</p>
    ///   - [`service_role(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::service_role) / [`set_service_role(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_service_role): <p>The replacement ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.</p>
    ///   - [`timeout_in_minutes(i32)`](crate::client::fluent_builders::UpdateProject::timeout_in_minutes) / [`set_timeout_in_minutes(Option<i32>)`](crate::client::fluent_builders::UpdateProject::set_timeout_in_minutes): <p>The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build that did not get marked as completed.</p>
    ///   - [`queued_timeout_in_minutes(i32)`](crate::client::fluent_builders::UpdateProject::queued_timeout_in_minutes) / [`set_queued_timeout_in_minutes(Option<i32>)`](crate::client::fluent_builders::UpdateProject::set_queued_timeout_in_minutes): <p> The number of minutes a build is allowed to be queued before it times out. </p>
    ///   - [`encryption_key(impl Into<String>)`](crate::client::fluent_builders::UpdateProject::encryption_key) / [`set_encryption_key(Option<String>)`](crate::client::fluent_builders::UpdateProject::set_encryption_key): <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.</p> <note>   <p> You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>  </note>  <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/   <alias-name></alias-name></code>). </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UpdateProject::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateProject::set_tags): <p>An updated list of tag key and value pairs associated with this build project.</p>  <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.</p>
    ///   - [`vpc_config(VpcConfig)`](crate::client::fluent_builders::UpdateProject::vpc_config) / [`set_vpc_config(Option<VpcConfig>)`](crate::client::fluent_builders::UpdateProject::set_vpc_config): <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
    ///   - [`badge_enabled(bool)`](crate::client::fluent_builders::UpdateProject::badge_enabled) / [`set_badge_enabled(Option<bool>)`](crate::client::fluent_builders::UpdateProject::set_badge_enabled): <p>Set this to true to generate a publicly accessible URL for your project's build badge.</p>
    ///   - [`logs_config(LogsConfig)`](crate::client::fluent_builders::UpdateProject::logs_config) / [`set_logs_config(Option<LogsConfig>)`](crate::client::fluent_builders::UpdateProject::set_logs_config): <p> Information about logs for the build project. A project can create logs in CloudWatch Logs, logs in an S3 bucket, or both. </p>
    ///   - [`file_system_locations(Vec<ProjectFileSystemLocation>)`](crate::client::fluent_builders::UpdateProject::file_system_locations) / [`set_file_system_locations(Option<Vec<ProjectFileSystemLocation>>)`](crate::client::fluent_builders::UpdateProject::set_file_system_locations): <p> An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System. </p>
    ///   - [`build_batch_config(ProjectBuildBatchConfig)`](crate::client::fluent_builders::UpdateProject::build_batch_config) / [`set_build_batch_config(Option<ProjectBuildBatchConfig>)`](crate::client::fluent_builders::UpdateProject::set_build_batch_config): <p>Contains configuration information about a batch build project.</p>
    ///   - [`concurrent_build_limit(i32)`](crate::client::fluent_builders::UpdateProject::concurrent_build_limit) / [`set_concurrent_build_limit(Option<i32>)`](crate::client::fluent_builders::UpdateProject::set_concurrent_build_limit): <p>The maximum number of concurrent builds that are allowed for this project.</p>  <p>New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.</p>  <p>To remove this limit, set this value to -1.</p>
    /// - On success, responds with [`UpdateProjectOutput`](crate::output::UpdateProjectOutput) with field(s):
    ///   - [`project(Option<Project>)`](crate::output::UpdateProjectOutput::project): <p>Information about the build project that was changed.</p>
    /// - On failure, responds with [`SdkError<UpdateProjectError>`](crate::error::UpdateProjectError)
    pub fn update_project(&self) -> fluent_builders::UpdateProject {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProjectVisibility`](crate::client::fluent_builders::UpdateProjectVisibility) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateProjectVisibility::project_arn) / [`set_project_arn(Option<String>)`](crate::client::fluent_builders::UpdateProjectVisibility::set_project_arn): <p>The Amazon Resource Name (ARN) of the build project.</p>
    ///   - [`project_visibility(ProjectVisibilityType)`](crate::client::fluent_builders::UpdateProjectVisibility::project_visibility) / [`set_project_visibility(Option<ProjectVisibilityType>)`](crate::client::fluent_builders::UpdateProjectVisibility::set_project_visibility): <p>Specifies the visibility of the project's builds. Possible values are:</p>  <dl>   <dt>   PUBLIC_READ  </dt>   <dd>    <p>The project builds are visible to the public.</p>   </dd>   <dt>   PRIVATE  </dt>   <dd>    <p>The project builds are not visible to the public.</p>   </dd>  </dl>
    ///   - [`resource_access_role(impl Into<String>)`](crate::client::fluent_builders::UpdateProjectVisibility::resource_access_role) / [`set_resource_access_role(Option<String>)`](crate::client::fluent_builders::UpdateProjectVisibility::set_resource_access_role): <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.</p>
    /// - On success, responds with [`UpdateProjectVisibilityOutput`](crate::output::UpdateProjectVisibilityOutput) with field(s):
    ///   - [`project_arn(Option<String>)`](crate::output::UpdateProjectVisibilityOutput::project_arn): <p>The Amazon Resource Name (ARN) of the build project.</p>
    ///   - [`public_project_alias(Option<String>)`](crate::output::UpdateProjectVisibilityOutput::public_project_alias): <p>Contains the project identifier used with the public build APIs. </p>
    ///   - [`project_visibility(Option<ProjectVisibilityType>)`](crate::output::UpdateProjectVisibilityOutput::project_visibility): <p>Specifies the visibility of the project's builds. Possible values are:</p>  <dl>   <dt>   PUBLIC_READ  </dt>   <dd>    <p>The project builds are visible to the public.</p>   </dd>   <dt>   PRIVATE  </dt>   <dd>    <p>The project builds are not visible to the public.</p>   </dd>  </dl>
    /// - On failure, responds with [`SdkError<UpdateProjectVisibilityError>`](crate::error::UpdateProjectVisibilityError)
    pub fn update_project_visibility(&self) -> fluent_builders::UpdateProjectVisibility {
        fluent_builders::UpdateProjectVisibility::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateReportGroup`](crate::client::fluent_builders::UpdateReportGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`arn(impl Into<String>)`](crate::client::fluent_builders::UpdateReportGroup::arn) / [`set_arn(Option<String>)`](crate::client::fluent_builders::UpdateReportGroup::set_arn): <p> The ARN of the report group to update. </p>
    ///   - [`export_config(ReportExportConfig)`](crate::client::fluent_builders::UpdateReportGroup::export_config) / [`set_export_config(Option<ReportExportConfig>)`](crate::client::fluent_builders::UpdateReportGroup::set_export_config): <p> Used to specify an updated export type. Valid values are: </p>  <ul>   <li> <p> <code>S3</code>: The report results are exported to an S3 bucket. </p> </li>   <li> <p> <code>NO_EXPORT</code>: The report results are not exported. </p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::UpdateReportGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::UpdateReportGroup::set_tags): <p> An updated list of tag key and value pairs associated with this report group. </p>  <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.</p>
    /// - On success, responds with [`UpdateReportGroupOutput`](crate::output::UpdateReportGroupOutput) with field(s):
    ///   - [`report_group(Option<ReportGroup>)`](crate::output::UpdateReportGroupOutput::report_group): <p> Information about the updated report group. </p>
    /// - On failure, responds with [`SdkError<UpdateReportGroupError>`](crate::error::UpdateReportGroupError)
    pub fn update_report_group(&self) -> fluent_builders::UpdateReportGroup {
        fluent_builders::UpdateReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateWebhook`](crate::client::fluent_builders::UpdateWebhook) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::UpdateWebhook::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::UpdateWebhook::set_project_name): <p>The name of the CodeBuild project.</p>
    ///   - [`branch_filter(impl Into<String>)`](crate::client::fluent_builders::UpdateWebhook::branch_filter) / [`set_branch_filter(Option<String>)`](crate::client::fluent_builders::UpdateWebhook::set_branch_filter): <p>A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty, then all branches are built.</p> <note>   <p> It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>. </p>  </note>
    ///   - [`rotate_secret(bool)`](crate::client::fluent_builders::UpdateWebhook::rotate_secret) / [`set_rotate_secret(bool)`](crate::client::fluent_builders::UpdateWebhook::set_rotate_secret): <p> A boolean value that specifies whether the associated GitHub repository's secret token should be updated. If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored. </p>
    ///   - [`filter_groups(Vec<Vec<WebhookFilter>>)`](crate::client::fluent_builders::UpdateWebhook::filter_groups) / [`set_filter_groups(Option<Vec<Vec<WebhookFilter>>>)`](crate::client::fluent_builders::UpdateWebhook::set_filter_groups): <p> An array of arrays of <code>WebhookFilter</code> objects used to determine if a webhook event can trigger a build. A filter group must contain at least one <code>EVENT</code> <code>WebhookFilter</code>. </p>
    ///   - [`build_type(WebhookBuildType)`](crate::client::fluent_builders::UpdateWebhook::build_type) / [`set_build_type(Option<WebhookBuildType>)`](crate::client::fluent_builders::UpdateWebhook::set_build_type): <p>Specifies the type of build this webhook will trigger.</p>
    /// - On success, responds with [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput) with field(s):
    ///   - [`webhook(Option<Webhook>)`](crate::output::UpdateWebhookOutput::webhook): <p> Information about a repository's webhook that is associated with a project in CodeBuild. </p>
    /// - On failure, responds with [`SdkError<UpdateWebhookError>`](crate::error::UpdateWebhookError)
    pub fn update_webhook(&self) -> fluent_builders::UpdateWebhook {
        fluent_builders::UpdateWebhook::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDeleteBuilds`.
    ///
    /// <p>Deletes one or more builds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteBuilds {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_builds_input::Builder,
    }
    impl BatchDeleteBuilds {
        /// Creates a new `BatchDeleteBuilds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteBuildsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteBuildsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the builds to delete.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>The IDs of the builds to delete.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetBuildBatches`.
    ///
    /// <p>Retrieves information about one or more batch builds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetBuildBatches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_build_batches_input::Builder,
    }
    impl BatchGetBuildBatches {
        /// Creates a new `BatchGetBuildBatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetBuildBatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetBuildBatchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array that contains the batch build identifiers to retrieve.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>An array that contains the batch build identifiers to retrieve.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetBuilds`.
    ///
    /// <p>Gets information about one or more builds.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetBuilds {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_builds_input::Builder,
    }
    impl BatchGetBuilds {
        /// Creates a new `BatchGetBuilds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetBuildsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetBuildsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the builds.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>The IDs of the builds.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetProjects`.
    ///
    /// <p>Gets information about one or more build projects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_projects_input::Builder,
    }
    impl BatchGetProjects {
        /// Creates a new `BatchGetProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names or ARNs of the build projects. To get information about a project shared with your Amazon Web Services account, its ARN must be specified. You cannot specify a shared project using its name.</p>
        pub fn names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(input.into());
            self
        }
        /// <p>The names or ARNs of the build projects. To get information about a project shared with your Amazon Web Services account, its ARN must be specified. You cannot specify a shared project using its name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetReportGroups`.
    ///
    /// <p> Returns an array of report groups. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetReportGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_report_groups_input::Builder,
    }
    impl BatchGetReportGroups {
        /// Creates a new `BatchGetReportGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetReportGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetReportGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `reportGroupArns`.
        ///
        /// To override the contents of this collection use [`set_report_group_arns`](Self::set_report_group_arns).
        ///
        /// <p> An array of report group ARNs that identify the report groups to return. </p>
        pub fn report_group_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_group_arns(input.into());
            self
        }
        /// <p> An array of report group ARNs that identify the report groups to return. </p>
        pub fn set_report_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_report_group_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetReports`.
    ///
    /// <p> Returns an array of reports. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_reports_input::Builder,
    }
    impl BatchGetReports {
        /// Creates a new `BatchGetReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `reportArns`.
        ///
        /// To override the contents of this collection use [`set_report_arns`](Self::set_report_arns).
        ///
        /// <p> An array of ARNs that identify the <code>Report</code> objects to return. </p>
        pub fn report_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_arns(input.into());
            self
        }
        /// <p> An array of ARNs that identify the <code>Report</code> objects to return. </p>
        pub fn set_report_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_report_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a build project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_project_input::Builder,
    }
    impl CreateProject {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the build project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the build project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description that makes the build project easy to identify.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description that makes the build project easy to identify.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Information about the build input source code for the build project.</p>
        pub fn source(mut self, input: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>Information about the build input source code for the build project.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ProjectSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `secondarySources`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources`](Self::set_secondary_sources).
        ///
        /// <p>An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources(mut self, input: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.secondary_sources(input);
            self
        }
        /// <p>An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources(input);
            self
        }
        /// <p>A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li> <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p> </li>
        /// <li> <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</p> </li>
        /// </ul>
        /// <p>If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p>A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li> <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p> </li>
        /// <li> <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</p> </li>
        /// </ul>
        /// <p>If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// Appends an item to `secondarySourceVersions`.
        ///
        /// To override the contents of this collection use [`set_secondary_source_versions`](Self::set_secondary_source_versions).
        ///
        /// <p>An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at the build level, then they take precedence over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn secondary_source_versions(
            mut self,
            input: crate::model::ProjectSourceVersion,
        ) -> Self {
            self.inner = self.inner.secondary_source_versions(input);
            self
        }
        /// <p>An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at the build level, then they take precedence over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn set_secondary_source_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_source_versions(input);
            self
        }
        /// <p>Information about the build output artifacts for the build project.</p>
        pub fn artifacts(mut self, input: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts(input);
            self
        }
        /// <p>Information about the build output artifacts for the build project.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts(input);
            self
        }
        /// Appends an item to `secondaryArtifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn secondary_artifacts(mut self, input: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.secondary_artifacts(input);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts(input);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later time.</p>
        pub fn cache(mut self, input: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache(input);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later time.</p>
        pub fn set_cache(mut self, input: std::option::Option<crate::model::ProjectCache>) -> Self {
            self.inner = self.inner.set_cache(input);
            self
        }
        /// <p>Information about the build environment for the build project.</p>
        pub fn environment(mut self, input: crate::model::ProjectEnvironment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>Information about the build environment for the build project.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::ProjectEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role(input.into());
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_role(input);
            self
        }
        /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before it times out any build that has not been marked as completed. The default is 60 minutes.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_minutes(input);
            self
        }
        /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before it times out any build that has not been marked as completed. The default is 60 minutes.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_minutes(input);
            self
        }
        /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes(input);
            self
        }
        /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.</p> <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>). </p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(input.into());
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.</p> <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>). </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build badge.</p>
        pub fn badge_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.badge_enabled(input);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build badge.</p>
        pub fn set_badge_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_badge_enabled(input);
            self
        }
        /// <p>Information about logs for the build project. These can be logs in CloudWatch Logs, logs uploaded to a specified S3 bucket, or both. </p>
        pub fn logs_config(mut self, input: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config(input);
            self
        }
        /// <p>Information about logs for the build project. These can be logs in CloudWatch Logs, logs uploaded to a specified S3 bucket, or both. </p>
        pub fn set_logs_config(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config(input);
            self
        }
        /// Appends an item to `fileSystemLocations`.
        ///
        /// To override the contents of this collection use [`set_file_system_locations`](Self::set_file_system_locations).
        ///
        /// <p> An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System. </p>
        pub fn file_system_locations(
            mut self,
            input: crate::model::ProjectFileSystemLocation,
        ) -> Self {
            self.inner = self.inner.file_system_locations(input);
            self
        }
        /// <p> An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System. </p>
        pub fn set_file_system_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_locations(input);
            self
        }
        /// <p>A <code>ProjectBuildBatchConfig</code> object that defines the batch build options for the project.</p>
        pub fn build_batch_config(mut self, input: crate::model::ProjectBuildBatchConfig) -> Self {
            self.inner = self.inner.build_batch_config(input);
            self
        }
        /// <p>A <code>ProjectBuildBatchConfig</code> object that defines the batch build options for the project.</p>
        pub fn set_build_batch_config(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_batch_config(input);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.</p>
        pub fn concurrent_build_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.concurrent_build_limit(input);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.</p>
        pub fn set_concurrent_build_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_concurrent_build_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReportGroup`.
    ///
    /// <p> Creates a report group. A report group contains a collection of reports. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateReportGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_report_group_input::Builder,
    }
    impl CreateReportGroup {
        /// Creates a new `CreateReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReportGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the report group. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p> The name of the report group. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p> The type of report group. </p>
        pub fn r#type(mut self, input: crate::model::ReportType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p> The type of report group. </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ReportType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p> A <code>ReportExportConfig</code> object that contains information about where the report group test results are exported. </p>
        pub fn export_config(mut self, input: crate::model::ReportExportConfig) -> Self {
            self.inner = self.inner.export_config(input);
            self
        }
        /// <p> A <code>ReportExportConfig</code> object that contains information about where the report group test results are exported. </p>
        pub fn set_export_config(
            mut self,
            input: std::option::Option<crate::model::ReportExportConfig>,
        ) -> Self {
            self.inner = self.inner.set_export_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> A list of tag key and value pairs associated with this report group. </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> A list of tag key and value pairs associated with this report group. </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebhook`.
    ///
    /// <p>For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, enables CodeBuild to start rebuilding the source code every time a code change is pushed to the repository.</p> <important>
    /// <p>If you enable webhooks for an CodeBuild project, and the project is used as a build step in CodePipeline, then two identical builds are created for each commit. One build is triggered through webhooks, and one through CodePipeline. Because billing is on a per-build basis, you are billed for both builds. Therefore, if you are using CodePipeline, we recommend that you disable webhooks in CodeBuild. In the CodeBuild console, clear the Webhook box. For more information, see step 5 in <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console">Change a Build Project's Settings</a>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateWebhook {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_webhook_input::Builder,
    }
    impl CreateWebhook {
        /// Creates a new `CreateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebhookError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty, then all branches are built.</p> <note>
        /// <p>It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>. </p>
        /// </note>
        pub fn branch_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_filter(input.into());
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty, then all branches are built.</p> <note>
        /// <p>It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>. </p>
        /// </note>
        pub fn set_branch_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_branch_filter(input);
            self
        }
        /// Appends an item to `filterGroups`.
        ///
        /// To override the contents of this collection use [`set_filter_groups`](Self::set_filter_groups).
        ///
        /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are triggered. At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its <code>type</code>. </p>
        /// <p>For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must pass. For a filter group to pass, each of its filters must pass. </p>
        pub fn filter_groups(mut self, input: std::vec::Vec<crate::model::WebhookFilter>) -> Self {
            self.inner = self.inner.filter_groups(input);
            self
        }
        /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are triggered. At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its <code>type</code>. </p>
        /// <p>For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must pass. For a filter group to pass, each of its filters must pass. </p>
        pub fn set_filter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::WebhookFilter>>>,
        ) -> Self {
            self.inner = self.inner.set_filter_groups(input);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn build_type(mut self, input: crate::model::WebhookBuildType) -> Self {
            self.inner = self.inner.build_type(input);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn set_build_type(
            mut self,
            input: std::option::Option<crate::model::WebhookBuildType>,
        ) -> Self {
            self.inner = self.inner.set_build_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBuildBatch`.
    ///
    /// <p>Deletes a batch build.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBuildBatch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_build_batch_input::Builder,
    }
    impl DeleteBuildBatch {
        /// Creates a new `DeleteBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBuildBatchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the batch build to delete.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the batch build to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p> Deletes a build project. When you delete a project, its builds are not deleted. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl DeleteProject {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the build project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the build project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReport`.
    ///
    /// <p> Deletes a report. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReport {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_report_input::Builder,
    }
    impl DeleteReport {
        /// Creates a new `DeleteReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReportError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the report to delete. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The ARN of the report to delete. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReportGroup`.
    ///
    /// <p>Deletes a report group. Before you delete a report group, you must delete its reports. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteReportGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_report_group_input::Builder,
    }
    impl DeleteReportGroup {
        /// Creates a new `DeleteReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReportGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the report group to delete. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p>The ARN of the report group to delete. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>If <code>true</code>, deletes any reports that belong to a report group before deleting the report group. </p>
        /// <p>If <code>false</code>, you must delete any reports in the report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ListReportsForReportGroup.html">ListReportsForReportGroup</a> to get the reports in a report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_DeleteReport.html">DeleteReport</a> to delete the reports. If you call <code>DeleteReportGroup</code> for a report group that contains one or more reports, an exception is thrown. </p>
        pub fn delete_reports(mut self, input: bool) -> Self {
            self.inner = self.inner.delete_reports(input);
            self
        }
        /// <p>If <code>true</code>, deletes any reports that belong to a report group before deleting the report group. </p>
        /// <p>If <code>false</code>, you must delete any reports in the report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ListReportsForReportGroup.html">ListReportsForReportGroup</a> to get the reports in a report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_DeleteReport.html">DeleteReport</a> to delete the reports. If you call <code>DeleteReportGroup</code> for a report group that contains one or more reports, an exception is thrown. </p>
        pub fn set_delete_reports(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_reports(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p> Deletes a resource policy that is identified by its resource ARN. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl DeleteResourcePolicy {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSourceCredentials`.
    ///
    /// <p> Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSourceCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_source_credentials_input::Builder,
    }
    impl DeleteSourceCredentials {
        /// Creates a new `DeleteSourceCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSourceCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSourceCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the token.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the token.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebhook`.
    ///
    /// <p>For an existing CodeBuild build project that has its source code stored in a GitHub or Bitbucket repository, stops CodeBuild from rebuilding the source code every time a code change is pushed to the repository.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWebhook {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_webhook_input::Builder,
    }
    impl DeleteWebhook {
        /// Creates a new `DeleteWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebhookError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCodeCoverages`.
    ///
    /// <p>Retrieves one or more code coverage reports.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCodeCoverages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_code_coverages_input::Builder,
    }
    impl DescribeCodeCoverages {
        /// Creates a new `DescribeCodeCoverages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCodeCoveragesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCodeCoveragesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeCodeCoveragesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeCodeCoveragesPaginator {
            crate::paginator::DescribeCodeCoveragesPaginator::new(self.handle, self.inner)
        }
        /// <p> The ARN of the report for which test cases are returned. </p>
        pub fn report_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_arn(input.into());
            self
        }
        /// <p> The ARN of the report for which test cases are returned. </p>
        pub fn set_report_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_arn(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to <code>DescribeCodeCoverages</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to <code>DescribeCodeCoverages</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies if the results are sorted in ascending or descending order.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>Specifies if the results are sorted in ascending or descending order.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>Specifies how the results are sorted. Possible values are:</p>
        /// <dl>
        /// <dt>
        /// FILE_PATH
        /// </dt>
        /// <dd>
        /// <p>The results are sorted by file path.</p>
        /// </dd>
        /// <dt>
        /// LINE_COVERAGE_PERCENTAGE
        /// </dt>
        /// <dd>
        /// <p>The results are sorted by the percentage of lines that are covered.</p>
        /// </dd>
        /// </dl>
        pub fn sort_by(mut self, input: crate::model::ReportCodeCoverageSortByType) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>Specifies how the results are sorted. Possible values are:</p>
        /// <dl>
        /// <dt>
        /// FILE_PATH
        /// </dt>
        /// <dd>
        /// <p>The results are sorted by file path.</p>
        /// </dd>
        /// <dt>
        /// LINE_COVERAGE_PERCENTAGE
        /// </dt>
        /// <dd>
        /// <p>The results are sorted by the percentage of lines that are covered.</p>
        /// </dd>
        /// </dl>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ReportCodeCoverageSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The minimum line coverage percentage to report.</p>
        pub fn min_line_coverage_percentage(mut self, input: f64) -> Self {
            self.inner = self.inner.min_line_coverage_percentage(input);
            self
        }
        /// <p>The minimum line coverage percentage to report.</p>
        pub fn set_min_line_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_min_line_coverage_percentage(input);
            self
        }
        /// <p>The maximum line coverage percentage to report.</p>
        pub fn max_line_coverage_percentage(mut self, input: f64) -> Self {
            self.inner = self.inner.max_line_coverage_percentage(input);
            self
        }
        /// <p>The maximum line coverage percentage to report.</p>
        pub fn set_max_line_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_max_line_coverage_percentage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTestCases`.
    ///
    /// <p> Returns a list of details about test cases for a report. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTestCases {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_test_cases_input::Builder,
    }
    impl DescribeTestCases {
        /// Creates a new `DescribeTestCases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTestCasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTestCasesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTestCasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTestCasesPaginator {
            crate::paginator::DescribeTestCasesPaginator::new(self.handle, self.inner)
        }
        /// <p> The ARN of the report for which test cases are returned. </p>
        pub fn report_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_arn(input.into());
            self
        }
        /// <p> The ARN of the report for which test cases are returned. </p>
        pub fn set_report_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_arn(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>TestCase</code> objects. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>TestCase</code> objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A <code>TestCaseFilter</code> object used to filter the returned reports. </p>
        pub fn filter(mut self, input: crate::model::TestCaseFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p> A <code>TestCaseFilter</code> object used to filter the returned reports. </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TestCaseFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReportGroupTrend`.
    ///
    /// <p>Analyzes and accumulates test report values for the specified test reports.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReportGroupTrend {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_report_group_trend_input::Builder,
    }
    impl GetReportGroupTrend {
        /// Creates a new `GetReportGroupTrend`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReportGroupTrendOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReportGroupTrendError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the report group that contains the reports to analyze.</p>
        pub fn report_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_group_arn(input.into());
            self
        }
        /// <p>The ARN of the report group that contains the reports to analyze.</p>
        pub fn set_report_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_group_arn(input);
            self
        }
        /// <p>The number of reports to analyze. This operation always retrieves the most recent reports.</p>
        /// <p>If this parameter is omitted, the most recent 100 reports are analyzed.</p>
        pub fn num_of_reports(mut self, input: i32) -> Self {
            self.inner = self.inner.num_of_reports(input);
            self
        }
        /// <p>The number of reports to analyze. This operation always retrieves the most recent reports.</p>
        /// <p>If this parameter is omitted, the most recent 100 reports are analyzed.</p>
        pub fn set_num_of_reports(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_of_reports(input);
            self
        }
        /// <p>The test report value to accumulate. This must be one of the following values:</p>
        /// <dl>
        /// <dt>
        /// Test reports:
        /// </dt>
        /// <dd>
        /// <dl>
        /// <dt>
        /// DURATION
        /// </dt>
        /// <dd>
        /// <p>Accumulate the test run times for the specified reports.</p>
        /// </dd>
        /// <dt>
        /// PASS_RATE
        /// </dt>
        /// <dd>
        /// <p>Accumulate the percentage of tests that passed for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// TOTAL
        /// </dt>
        /// <dd>
        /// <p>Accumulate the total number of tests for the specified test reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        /// <dl>
        /// <dt>
        /// Code coverage reports:
        /// </dt>
        /// <dd>
        /// <dl>
        /// <dt>
        /// BRANCH_COVERAGE
        /// </dt>
        /// <dd>
        /// <p>Accumulate the branch coverage percentages for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// BRANCHES_COVERED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the branches covered values for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// BRANCHES_MISSED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the branches missed values for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// LINE_COVERAGE
        /// </dt>
        /// <dd>
        /// <p>Accumulate the line coverage percentages for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// LINES_COVERED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the lines covered values for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// LINES_MISSED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the lines not covered values for the specified test reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        pub fn trend_field(mut self, input: crate::model::ReportGroupTrendFieldType) -> Self {
            self.inner = self.inner.trend_field(input);
            self
        }
        /// <p>The test report value to accumulate. This must be one of the following values:</p>
        /// <dl>
        /// <dt>
        /// Test reports:
        /// </dt>
        /// <dd>
        /// <dl>
        /// <dt>
        /// DURATION
        /// </dt>
        /// <dd>
        /// <p>Accumulate the test run times for the specified reports.</p>
        /// </dd>
        /// <dt>
        /// PASS_RATE
        /// </dt>
        /// <dd>
        /// <p>Accumulate the percentage of tests that passed for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// TOTAL
        /// </dt>
        /// <dd>
        /// <p>Accumulate the total number of tests for the specified test reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        /// <dl>
        /// <dt>
        /// Code coverage reports:
        /// </dt>
        /// <dd>
        /// <dl>
        /// <dt>
        /// BRANCH_COVERAGE
        /// </dt>
        /// <dd>
        /// <p>Accumulate the branch coverage percentages for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// BRANCHES_COVERED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the branches covered values for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// BRANCHES_MISSED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the branches missed values for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// LINE_COVERAGE
        /// </dt>
        /// <dd>
        /// <p>Accumulate the line coverage percentages for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// LINES_COVERED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the lines covered values for the specified test reports.</p>
        /// </dd>
        /// <dt>
        /// LINES_MISSED
        /// </dt>
        /// <dd>
        /// <p>Accumulate the lines not covered values for the specified test reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        pub fn set_trend_field(
            mut self,
            input: std::option::Option<crate::model::ReportGroupTrendFieldType>,
        ) -> Self {
            self.inner = self.inner.set_trend_field(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p> Gets a resource policy that is identified by its resource ARN. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl GetResourcePolicy {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportSourceCredentials`.
    ///
    /// <p> Imports the source repository credentials for an CodeBuild project that has its source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ImportSourceCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::import_source_credentials_input::Builder,
    }
    impl ImportSourceCredentials {
        /// Creates a new `ImportSourceCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportSourceCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportSourceCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter is not valid for other types of source providers or connections. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p> The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter is not valid for other types of source providers or connections. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p> For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app password. </p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p> For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket, this is the app password. </p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
        /// <p> The source provider used for this project. </p>
        pub fn server_type(mut self, input: crate::model::ServerType) -> Self {
            self.inner = self.inner.server_type(input);
            self
        }
        /// <p> The source provider used for this project. </p>
        pub fn set_server_type(
            mut self,
            input: std::option::Option<crate::model::ServerType>,
        ) -> Self {
            self.inner = self.inner.set_server_type(input);
            self
        }
        /// <p> The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API and must be created using the CodeBuild console. </p>
        pub fn auth_type(mut self, input: crate::model::AuthType) -> Self {
            self.inner = self.inner.auth_type(input);
            self
        }
        /// <p> The type of authentication used to connect to a GitHub, GitHub Enterprise, or Bitbucket repository. An OAUTH connection is not supported by the API and must be created using the CodeBuild console. </p>
        pub fn set_auth_type(mut self, input: std::option::Option<crate::model::AuthType>) -> Self {
            self.inner = self.inner.set_auth_type(input);
            self
        }
        /// <p> Set to <code>false</code> to prevent overwriting the repository source credentials. Set to <code>true</code> to overwrite the repository source credentials. The default value is <code>true</code>. </p>
        pub fn should_overwrite(mut self, input: bool) -> Self {
            self.inner = self.inner.should_overwrite(input);
            self
        }
        /// <p> Set to <code>false</code> to prevent overwriting the repository source credentials. Set to <code>true</code> to overwrite the repository source credentials. The default value is <code>true</code>. </p>
        pub fn set_should_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_should_overwrite(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InvalidateProjectCache`.
    ///
    /// <p>Resets the cache for a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct InvalidateProjectCache {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::invalidate_project_cache_input::Builder,
    }
    impl InvalidateProjectCache {
        /// Creates a new `InvalidateProjectCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InvalidateProjectCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::InvalidateProjectCacheError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild build project that the cache is reset for.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the CodeBuild build project that the cache is reset for.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuildBatches`.
    ///
    /// <p>Retrieves the identifiers of your build batches in the current region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBuildBatches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_build_batches_input::Builder,
    }
    impl ListBuildBatches {
        /// Creates a new `ListBuildBatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildBatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildBatchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBuildBatchesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBuildBatchesPaginator {
            crate::paginator::ListBuildBatchesPaginator::new(self.handle, self.inner)
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn filter(mut self, input: crate::model::BuildBatchFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::BuildBatchFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p> </li>
        /// </ul>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p> </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatches</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatches</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuildBatchesForProject`.
    ///
    /// <p>Retrieves the identifiers of the build batches for a specific project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBuildBatchesForProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_build_batches_for_project_input::Builder,
    }
    impl ListBuildBatchesForProject {
        /// Creates a new `ListBuildBatchesForProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildBatchesForProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildBatchesForProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBuildBatchesForProjectPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBuildBatchesForProjectPaginator {
            crate::paginator::ListBuildBatchesForProjectPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn filter(mut self, input: crate::model::BuildBatchFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::BuildBatchFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p> </li>
        /// </ul>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p> </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatchesForProject</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to <code>ListBuildBatchesForProject</code>. This specifies the next item to return. To return the beginning of the list, exclude this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuilds`.
    ///
    /// <p>Gets a list of build IDs, with each build ID representing a single build.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBuilds {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_builds_input::Builder,
    }
    impl ListBuilds {
        /// Creates a new `ListBuilds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBuildsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBuildsPaginator {
            crate::paginator::ListBuildsPaginator::new(self.handle, self.inner)
        }
        /// <p>The order to list build IDs. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the build IDs in ascending order by build ID.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the build IDs in descending order by build ID.</p> </li>
        /// </ul>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The order to list build IDs. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the build IDs in ascending order by build ID.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the build IDs in descending order by build ID.</p> </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuildsForProject`.
    ///
    /// <p>Gets a list of build identifiers for the specified build project, with each build identifier representing a single build.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBuildsForProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_builds_for_project_input::Builder,
    }
    impl ListBuildsForProject {
        /// Creates a new `ListBuildsForProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildsForProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildsForProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBuildsForProjectPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBuildsForProjectPaginator {
            crate::paginator::ListBuildsForProjectPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The order to sort the results in. The results are sorted by build number, not the build identifier. If this is not specified, the results are sorted in descending order.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the build identifiers in descending order, by build number.</p> </li>
        /// </ul>
        /// <p>If the project has more than 100 builds, setting the sort order will result in an error. </p>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The order to sort the results in. The results are sorted by build number, not the build identifier. If this is not specified, the results are sorted in descending order.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List the build identifiers in descending order, by build number.</p> </li>
        /// </ul>
        /// <p>If the project has more than 100 builds, setting the sort order will result in an error. </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCuratedEnvironmentImages`.
    ///
    /// <p>Gets information about Docker images that are managed by CodeBuild.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCuratedEnvironmentImages {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_curated_environment_images_input::Builder,
    }
    impl ListCuratedEnvironmentImages {
        /// Creates a new `ListCuratedEnvironmentImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCuratedEnvironmentImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCuratedEnvironmentImagesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Gets a list of build project names, with each build project name representing a single build project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl ListProjects {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProjectsPaginator {
            crate::paginator::ListProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The criterion to be used to list build project names. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>CREATED_TIME</code>: List based on when each build project was created.</p> </li>
        /// <li> <p> <code>LAST_MODIFIED_TIME</code>: List based on when information about each build project was last changed.</p> </li>
        /// <li> <p> <code>NAME</code>: List based on each build project's name.</p> </li>
        /// </ul>
        /// <p>Use <code>sortOrder</code> to specify in what order to list the build project names based on the preceding criteria.</p>
        pub fn sort_by(mut self, input: crate::model::ProjectSortByType) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The criterion to be used to list build project names. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>CREATED_TIME</code>: List based on when each build project was created.</p> </li>
        /// <li> <p> <code>LAST_MODIFIED_TIME</code>: List based on when information about each build project was last changed.</p> </li>
        /// <li> <p> <code>NAME</code>: List based on each build project's name.</p> </li>
        /// </ul>
        /// <p>Use <code>sortOrder</code> to specify in what order to list the build project names based on the preceding criteria.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProjectSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The order in which to list build projects. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>
        /// </ul>
        /// <p>Use <code>sortBy</code> to specify the criterion to be used to list build project names.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The order in which to list build projects. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>
        /// </ul>
        /// <p>Use <code>sortBy</code> to specify the criterion to be used to list build project names.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReportGroups`.
    ///
    /// <p> Gets a list ARNs for the report groups in the current Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReportGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_report_groups_input::Builder,
    }
    impl ListReportGroups {
        /// Creates a new `ListReportGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReportGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReportGroupsPaginator {
            crate::paginator::ListReportGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p> Used to specify the order to sort the list of returned report groups. Valid values are <code>ASCENDING</code> and <code>DESCENDING</code>. </p>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p> Used to specify the order to sort the list of returned report groups. Valid values are <code>ASCENDING</code> and <code>DESCENDING</code>. </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> The criterion to be used to list build report groups. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>CREATED_TIME</code>: List based on when each report group was created.</p> </li>
        /// <li> <p> <code>LAST_MODIFIED_TIME</code>: List based on when each report group was last changed.</p> </li>
        /// <li> <p> <code>NAME</code>: List based on each report group's name.</p> </li>
        /// </ul>
        pub fn sort_by(mut self, input: crate::model::ReportGroupSortByType) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p> The criterion to be used to list build report groups. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>CREATED_TIME</code>: List based on when each report group was created.</p> </li>
        /// <li> <p> <code>LAST_MODIFIED_TIME</code>: List based on when each report group was last changed.</p> </li>
        /// <li> <p> <code>NAME</code>: List based on each report group's name.</p> </li>
        /// </ul>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ReportGroupSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of paginated report groups returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>ReportGroup</code> objects. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of paginated report groups returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>ReportGroup</code> objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReports`.
    ///
    /// <p> Returns a list of ARNs for the reports in the current Amazon Web Services account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReports {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_reports_input::Builder,
    }
    impl ListReports {
        /// Creates a new `ListReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReportsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReportsPaginator {
            crate::paginator::ListReportsPaginator::new(self.handle, self.inner)
        }
        /// <p> Specifies the sort order for the list of returned reports. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: return reports in chronological order based on their creation date. </p> </li>
        /// <li> <p> <code>DESCENDING</code>: return reports in the reverse chronological order based on their creation date. </p> </li>
        /// </ul>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p> Specifies the sort order for the list of returned reports. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: return reports in chronological order based on their creation date. </p> </li>
        /// <li> <p> <code>DESCENDING</code>: return reports in the reverse chronological order based on their creation date. </p> </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of paginated reports returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of paginated reports returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A <code>ReportFilter</code> object used to filter the returned reports. </p>
        pub fn filter(mut self, input: crate::model::ReportFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p> A <code>ReportFilter</code> object used to filter the returned reports. </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReportFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReportsForReportGroup`.
    ///
    /// <p> Returns a list of ARNs for the reports that belong to a <code>ReportGroup</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReportsForReportGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_reports_for_report_group_input::Builder,
    }
    impl ListReportsForReportGroup {
        /// Creates a new `ListReportsForReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportsForReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportsForReportGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReportsForReportGroupPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReportsForReportGroupPaginator {
            crate::paginator::ListReportsForReportGroupPaginator::new(self.handle, self.inner)
        }
        /// <p> The ARN of the report group for which you want to return report ARNs. </p>
        pub fn report_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_group_arn(input.into());
            self
        }
        /// <p> The ARN of the report group for which you want to return report ARNs. </p>
        pub fn set_report_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_group_arn(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> Use to specify whether the results are returned in ascending or descending order. </p>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p> Use to specify whether the results are returned in ascending or descending order. </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> The maximum number of paginated reports in this report group returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of paginated reports in this report group returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Report</code> objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> A <code>ReportFilter</code> object used to filter the returned reports. </p>
        pub fn filter(mut self, input: crate::model::ReportFilter) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p> A <code>ReportFilter</code> object used to filter the returned reports. </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReportFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSharedProjects`.
    ///
    /// <p> Gets a list of projects that are shared with other Amazon Web Services accounts or users. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSharedProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_shared_projects_input::Builder,
    }
    impl ListSharedProjects {
        /// Creates a new `ListSharedProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSharedProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSharedProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSharedProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSharedProjectsPaginator {
            crate::paginator::ListSharedProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p> The criterion to be used to list build projects shared with the current Amazon Web Services account or user. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>ARN</code>: List based on the ARN. </p> </li>
        /// <li> <p> <code>MODIFIED_TIME</code>: List based on when information about the shared project was last changed. </p> </li>
        /// </ul>
        pub fn sort_by(mut self, input: crate::model::SharedResourceSortByType) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p> The criterion to be used to list build projects shared with the current Amazon Web Services account or user. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>ARN</code>: List based on the ARN. </p> </li>
        /// <li> <p> <code>MODIFIED_TIME</code>: List based on when information about the shared project was last changed. </p> </li>
        /// </ul>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SharedResourceSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The order in which to list shared build projects. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>
        /// </ul>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The order in which to list shared build projects. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> The maximum number of paginated shared build projects returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Project</code> objects. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of paginated shared build projects returned per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>Project</code> objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSharedReportGroups`.
    ///
    /// <p> Gets a list of report groups that are shared with other Amazon Web Services accounts or users. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSharedReportGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_shared_report_groups_input::Builder,
    }
    impl ListSharedReportGroups {
        /// Creates a new `ListSharedReportGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSharedReportGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSharedReportGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSharedReportGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSharedReportGroupsPaginator {
            crate::paginator::ListSharedReportGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The order in which to list shared report groups. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>
        /// </ul>
        pub fn sort_order(mut self, input: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>The order in which to list shared report groups. Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>ASCENDING</code>: List in ascending order.</p> </li>
        /// <li> <p> <code>DESCENDING</code>: List in descending order.</p> </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> The criterion to be used to list report groups shared with the current Amazon Web Services account or user. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>ARN</code>: List based on the ARN. </p> </li>
        /// <li> <p> <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last changed. </p> </li>
        /// </ul>
        pub fn sort_by(mut self, input: crate::model::SharedResourceSortByType) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p> The criterion to be used to list report groups shared with the current Amazon Web Services account or user. Valid values include: </p>
        /// <ul>
        /// <li> <p> <code>ARN</code>: List based on the ARN. </p> </li>
        /// <li> <p> <code>MODIFIED_TIME</code>: List based on when information about the shared report group was last changed. </p> </li>
        /// </ul>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SharedResourceSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value specified in <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of paginated shared report groups per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>ReportGroup</code> objects. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of paginated shared report groups per response. Use <code>nextToken</code> to iterate pages in the list of returned <code>ReportGroup</code> objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSourceCredentials`.
    ///
    /// <p> Returns a list of <code>SourceCredentialsInfo</code> objects. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSourceCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_source_credentials_input::Builder,
    }
    impl ListSourceCredentials {
        /// Creates a new `ListSourceCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSourceCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSourceCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p> Stores a resource policy for the ARN of a <code>Project</code> or <code>ReportGroup</code> object. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl PutResourcePolicy {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A JSON-formatted resource policy. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share">Sharing a Project</a> and <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share">Sharing a Report Group</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p> A JSON-formatted resource policy. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share">Sharing a Project</a> and <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share">Sharing a Report Group</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource you want to associate with a resource policy. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource you want to associate with a resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryBuild`.
    ///
    /// <p>Restarts a build.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetryBuild {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retry_build_input::Builder,
    }
    impl RetryBuild {
        /// Creates a new `RetryBuild`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryBuildOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryBuildError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the identifier of the build to restart.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Specifies the identifier of the build to restart.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuild</code> request. The token is included in the <code>RetryBuild</code> request and is valid for five minutes. If you repeat the <code>RetryBuild</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuild</code> request. The token is included in the <code>RetryBuild</code> request and is valid for five minutes. If you repeat the <code>RetryBuild</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryBuildBatch`.
    ///
    /// <p>Restarts a failed batch build. Only batch builds that have failed can be retried.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RetryBuildBatch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::retry_build_batch_input::Builder,
    }
    impl RetryBuildBatch {
        /// Creates a new `RetryBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryBuildBatchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the identifier of the batch build to restart.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>Specifies the identifier of the batch build to restart.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuildBatch</code> request. The token is included in the <code>RetryBuildBatch</code> request and is valid for five minutes. If you repeat the <code>RetryBuildBatch</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>RetryBuildBatch</code> request. The token is included in the <code>RetryBuildBatch</code> request and is valid for five minutes. If you repeat the <code>RetryBuildBatch</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>Specifies the type of retry to perform.</p>
        pub fn retry_type(mut self, input: crate::model::RetryBuildBatchType) -> Self {
            self.inner = self.inner.retry_type(input);
            self
        }
        /// <p>Specifies the type of retry to perform.</p>
        pub fn set_retry_type(
            mut self,
            input: std::option::Option<crate::model::RetryBuildBatchType>,
        ) -> Self {
            self.inner = self.inner.set_retry_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBuild`.
    ///
    /// <p>Starts running a build.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartBuild {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_build_input::Builder,
    }
    impl StartBuild {
        /// Creates a new `StartBuild`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBuildOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBuildError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild build project to start running a build.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the CodeBuild build project to start running a build.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// Appends an item to `secondarySourcesOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_override`](Self::set_secondary_sources_override).
        ///
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources_override(mut self, input: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.secondary_sources_override(input);
            self
        }
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_override(input);
            self
        }
        /// Appends an item to `secondarySourcesVersionOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_version_override`](Self::set_secondary_sources_version_override).
        ///
        /// <p> An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's secondary sources to be used for this build only. </p>
        pub fn secondary_sources_version_override(
            mut self,
            input: crate::model::ProjectSourceVersion,
        ) -> Self {
            self.inner = self.inner.secondary_sources_version_override(input);
            self
        }
        /// <p> An array of <code>ProjectSourceVersion</code> objects that specify one or more versions of the project's secondary sources to be used for this build only. </p>
        pub fn set_secondary_sources_version_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_version_override(input);
            self
        }
        /// <p>The version of the build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:</p>
        /// <dl>
        /// <dt>
        /// CodeCommit
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>
        /// GitHub
        /// </dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Bitbucket
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Amazon S3
        /// </dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p>The version of the build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:</p>
        /// <dl>
        /// <dt>
        /// CodeCommit
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>
        /// GitHub
        /// </dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Bitbucket
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Amazon S3
        /// </dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// <p>Build output artifact settings that override, for this build only, the latest ones already defined in the build project.</p>
        pub fn artifacts_override(mut self, input: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts_override(input);
            self
        }
        /// <p>Build output artifact settings that override, for this build only, the latest ones already defined in the build project.</p>
        pub fn set_artifacts_override(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts_override(input);
            self
        }
        /// Appends an item to `secondaryArtifactsOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts_override`](Self::set_secondary_artifacts_override).
        ///
        /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn secondary_artifacts_override(
            mut self,
            input: crate::model::ProjectArtifacts,
        ) -> Self {
            self.inner = self.inner.secondary_artifacts_override(input);
            self
        }
        /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn set_secondary_artifacts_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts_override(input);
            self
        }
        /// Appends an item to `environmentVariablesOverride`.
        ///
        /// To override the contents of this collection use [`set_environment_variables_override`](Self::set_environment_variables_override).
        ///
        /// <p>A set of environment variables that overrides, for this build only, the latest ones already defined in the build project.</p>
        pub fn environment_variables_override(
            mut self,
            input: crate::model::EnvironmentVariable,
        ) -> Self {
            self.inner = self.inner.environment_variables_override(input);
            self
        }
        /// <p>A set of environment variables that overrides, for this build only, the latest ones already defined in the build project.</p>
        pub fn set_environment_variables_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.inner = self.inner.set_environment_variables_override(input);
            self
        }
        /// <p>A source input type, for this build, that overrides the source input defined in the build project.</p>
        pub fn source_type_override(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type_override(input);
            self
        }
        /// <p>A source input type, for this build, that overrides the source input defined in the build project.</p>
        pub fn set_source_type_override(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type_override(input);
            self
        }
        /// <p>A location that overrides, for this build, the source location for the one defined in the build project.</p>
        pub fn source_location_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_location_override(input.into());
            self
        }
        /// <p>A location that overrides, for this build, the source location for the one defined in the build project.</p>
        pub fn set_source_location_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_location_override(input);
            self
        }
        /// <p>An authorization type for this build that overrides the one defined in the build project. This override applies only if the build project's source is BitBucket or GitHub.</p>
        pub fn source_auth_override(mut self, input: crate::model::SourceAuth) -> Self {
            self.inner = self.inner.source_auth_override(input);
            self
        }
        /// <p>An authorization type for this build that overrides the one defined in the build project. This override applies only if the build project's source is BitBucket or GitHub.</p>
        pub fn set_source_auth_override(
            mut self,
            input: std::option::Option<crate::model::SourceAuth>,
        ) -> Self {
            self.inner = self.inner.set_source_auth_override(input);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any previous depth of history defined in the build project.</p>
        pub fn git_clone_depth_override(mut self, input: i32) -> Self {
            self.inner = self.inner.git_clone_depth_override(input);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any previous depth of history defined in the build project.</p>
        pub fn set_git_clone_depth_override(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_git_clone_depth_override(input);
            self
        }
        /// <p> Information about the Git submodules configuration for this build of an CodeBuild build project. </p>
        pub fn git_submodules_config_override(
            mut self,
            input: crate::model::GitSubmodulesConfig,
        ) -> Self {
            self.inner = self.inner.git_submodules_config_override(input);
            self
        }
        /// <p> Information about the Git submodules configuration for this build of an CodeBuild build project. </p>
        pub fn set_git_submodules_config_override(
            mut self,
            input: std::option::Option<crate::model::GitSubmodulesConfig>,
        ) -> Self {
            self.inner = self.inner.set_git_submodules_config_override(input);
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.</p>
        /// <p> If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn buildspec_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.buildspec_override(input.into());
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.</p>
        /// <p> If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn set_buildspec_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_buildspec_override(input);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.</p>
        pub fn insecure_ssl_override(mut self, input: bool) -> Self {
            self.inner = self.inner.insecure_ssl_override(input);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.</p>
        pub fn set_insecure_ssl_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_insecure_ssl_override(input);
            self
        }
        /// <p> Set to true to report to your source provider the status of a build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p>
        /// <p>To be able to report the build status to the source provider, the user associated with the source provider must have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p> <note>
        /// <p> The status of a build triggered by a webhook is always reported to your source provider. </p>
        /// </note>
        pub fn report_build_status_override(mut self, input: bool) -> Self {
            self.inner = self.inner.report_build_status_override(input);
            self
        }
        /// <p> Set to true to report to your source provider the status of a build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p>
        /// <p>To be able to report the build status to the source provider, the user associated with the source provider must have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p> <note>
        /// <p> The status of a build triggered by a webhook is always reported to your source provider. </p>
        /// </note>
        pub fn set_report_build_status_override(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_report_build_status_override(input);
            self
        }
        /// <p>Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or <code>BITBUCKET</code>.</p>
        pub fn build_status_config_override(
            mut self,
            input: crate::model::BuildStatusConfig,
        ) -> Self {
            self.inner = self.inner.build_status_config_override(input);
            self
        }
        /// <p>Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or <code>BITBUCKET</code>.</p>
        pub fn set_build_status_config_override(
            mut self,
            input: std::option::Option<crate::model::BuildStatusConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_status_config_override(input);
            self
        }
        /// <p>A container type for this build that overrides the one specified in the build project.</p>
        pub fn environment_type_override(mut self, input: crate::model::EnvironmentType) -> Self {
            self.inner = self.inner.environment_type_override(input);
            self
        }
        /// <p>A container type for this build that overrides the one specified in the build project.</p>
        pub fn set_environment_type_override(
            mut self,
            input: std::option::Option<crate::model::EnvironmentType>,
        ) -> Self {
            self.inner = self.inner.set_environment_type_override(input);
            self
        }
        /// <p>The name of an image for this build that overrides the one specified in the build project.</p>
        pub fn image_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_override(input.into());
            self
        }
        /// <p>The name of an image for this build that overrides the one specified in the build project.</p>
        pub fn set_image_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_override(input);
            self
        }
        /// <p>The name of a compute type for this build that overrides the one specified in the build project.</p>
        pub fn compute_type_override(mut self, input: crate::model::ComputeType) -> Self {
            self.inner = self.inner.compute_type_override(input);
            self
        }
        /// <p>The name of a compute type for this build that overrides the one specified in the build project.</p>
        pub fn set_compute_type_override(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.inner = self.inner.set_compute_type_override(input);
            self
        }
        /// <p>The name of a certificate for this build that overrides the one specified in the build project.</p>
        pub fn certificate_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_override(input.into());
            self
        }
        /// <p>The name of a certificate for this build that overrides the one specified in the build project.</p>
        pub fn set_certificate_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_override(input);
            self
        }
        /// <p>A ProjectCache object specified for this build that overrides the one defined in the build project.</p>
        pub fn cache_override(mut self, input: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache_override(input);
            self
        }
        /// <p>A ProjectCache object specified for this build that overrides the one defined in the build project.</p>
        pub fn set_cache_override(
            mut self,
            input: std::option::Option<crate::model::ProjectCache>,
        ) -> Self {
            self.inner = self.inner.set_cache_override(input);
            self
        }
        /// <p>The name of a service role for this build that overrides the one specified in the build project.</p>
        pub fn service_role_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_override(input.into());
            self
        }
        /// <p>The name of a service role for this build that overrides the one specified in the build project.</p>
        pub fn set_service_role_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_override(input);
            self
        }
        /// <p>Enable this flag to override privileged mode in the build project.</p>
        pub fn privileged_mode_override(mut self, input: bool) -> Self {
            self.inner = self.inner.privileged_mode_override(input);
            self
        }
        /// <p>Enable this flag to override privileged mode in the build project.</p>
        pub fn set_privileged_mode_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_privileged_mode_override(input);
            self
        }
        /// <p>The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest setting already defined in the build project.</p>
        pub fn timeout_in_minutes_override(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_minutes_override(input);
            self
        }
        /// <p>The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest setting already defined in the build project.</p>
        pub fn set_timeout_in_minutes_override(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_minutes_override(input);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes_override(mut self, input: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes_override(input);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes_override(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes_override(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the build project. The CMK key encrypts the build output artifacts.</p> <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>).</p>
        pub fn encryption_key_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_override(input.into());
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the build project. The CMK key encrypts the build output artifacts.</p> <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>).</p>
        pub fn set_encryption_key_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_override(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The token is included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error. </p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The token is included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error. </p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p> Log settings for this build that override the log settings defined in the build project. </p>
        pub fn logs_config_override(mut self, input: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config_override(input);
            self
        }
        /// <p> Log settings for this build that override the log settings defined in the build project. </p>
        pub fn set_logs_config_override(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config_override(input);
            self
        }
        /// <p> The credentials for access to a private registry. </p>
        pub fn registry_credential_override(
            mut self,
            input: crate::model::RegistryCredential,
        ) -> Self {
            self.inner = self.inner.registry_credential_override(input);
            self
        }
        /// <p> The credentials for access to a private registry. </p>
        pub fn set_registry_credential_override(
            mut self,
            input: std::option::Option<crate::model::RegistryCredential>,
        ) -> Self {
            self.inner = self.inner.set_registry_credential_override(input);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your build. There are two valid values: </p>
        /// <dl>
        /// <dt>
        /// CODEBUILD
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>
        /// SERVICE_ROLE
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials. </p>
        pub fn image_pull_credentials_type_override(
            mut self,
            input: crate::model::ImagePullCredentialsType,
        ) -> Self {
            self.inner = self.inner.image_pull_credentials_type_override(input);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your build. There are two valid values: </p>
        /// <dl>
        /// <dt>
        /// CODEBUILD
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>
        /// SERVICE_ROLE
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials. </p>
        pub fn set_image_pull_credentials_type_override(
            mut self,
            input: std::option::Option<crate::model::ImagePullCredentialsType>,
        ) -> Self {
            self.inner = self.inner.set_image_pull_credentials_type_override(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this build. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>.</p>
        pub fn debug_session_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.debug_session_enabled(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this build. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>.</p>
        pub fn set_debug_session_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_debug_session_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBuildBatch`.
    ///
    /// <p>Starts a batch build for a project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartBuildBatch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_build_batch_input::Builder,
    }
    impl StartBuildBatch {
        /// Creates a new `StartBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBuildBatchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// Appends an item to `secondarySourcesOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_override`](Self::set_secondary_sources_override).
        ///
        /// <p>An array of <code>ProjectSource</code> objects that override the secondary sources defined in the batch build project.</p>
        pub fn secondary_sources_override(mut self, input: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.secondary_sources_override(input);
            self
        }
        /// <p>An array of <code>ProjectSource</code> objects that override the secondary sources defined in the batch build project.</p>
        pub fn set_secondary_sources_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_override(input);
            self
        }
        /// Appends an item to `secondarySourcesVersionOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_version_override`](Self::set_secondary_sources_version_override).
        ///
        /// <p>An array of <code>ProjectSourceVersion</code> objects that override the secondary source versions in the batch build project.</p>
        pub fn secondary_sources_version_override(
            mut self,
            input: crate::model::ProjectSourceVersion,
        ) -> Self {
            self.inner = self.inner.secondary_sources_version_override(input);
            self
        }
        /// <p>An array of <code>ProjectSourceVersion</code> objects that override the secondary source versions in the batch build project.</p>
        pub fn set_secondary_sources_version_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_version_override(input);
            self
        }
        /// <p>The version of the batch build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:</p>
        /// <dl>
        /// <dt>
        /// CodeCommit
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>
        /// GitHub
        /// </dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Bitbucket
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Amazon S3
        /// </dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p>The version of the batch build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:</p>
        /// <dl>
        /// <dt>
        /// CodeCommit
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>
        /// GitHub
        /// </dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Bitbucket
        /// </dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p>
        /// </dd>
        /// <dt>
        /// Amazon S3
        /// </dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects that contains information about the build output artifact overrides for the build project.</p>
        pub fn artifacts_override(mut self, input: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts_override(input);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects that contains information about the build output artifact overrides for the build project.</p>
        pub fn set_artifacts_override(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts_override(input);
            self
        }
        /// Appends an item to `secondaryArtifactsOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts_override`](Self::set_secondary_artifacts_override).
        ///
        /// <p>An array of <code>ProjectArtifacts</code> objects that override the secondary artifacts defined in the batch build project.</p>
        pub fn secondary_artifacts_override(
            mut self,
            input: crate::model::ProjectArtifacts,
        ) -> Self {
            self.inner = self.inner.secondary_artifacts_override(input);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects that override the secondary artifacts defined in the batch build project.</p>
        pub fn set_secondary_artifacts_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts_override(input);
            self
        }
        /// Appends an item to `environmentVariablesOverride`.
        ///
        /// To override the contents of this collection use [`set_environment_variables_override`](Self::set_environment_variables_override).
        ///
        /// <p>An array of <code>EnvironmentVariable</code> objects that override, or add to, the environment variables defined in the batch build project.</p>
        pub fn environment_variables_override(
            mut self,
            input: crate::model::EnvironmentVariable,
        ) -> Self {
            self.inner = self.inner.environment_variables_override(input);
            self
        }
        /// <p>An array of <code>EnvironmentVariable</code> objects that override, or add to, the environment variables defined in the batch build project.</p>
        pub fn set_environment_variables_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.inner = self.inner.set_environment_variables_override(input);
            self
        }
        /// <p>The source input type that overrides the source input defined in the batch build project.</p>
        pub fn source_type_override(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type_override(input);
            self
        }
        /// <p>The source input type that overrides the source input defined in the batch build project.</p>
        pub fn set_source_type_override(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type_override(input);
            self
        }
        /// <p>A location that overrides, for this batch build, the source location defined in the batch build project.</p>
        pub fn source_location_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_location_override(input.into());
            self
        }
        /// <p>A location that overrides, for this batch build, the source location defined in the batch build project.</p>
        pub fn set_source_location_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_location_override(input);
            self
        }
        /// <p>A <code>SourceAuth</code> object that overrides the one defined in the batch build project. This override applies only if the build project's source is BitBucket or GitHub.</p>
        pub fn source_auth_override(mut self, input: crate::model::SourceAuth) -> Self {
            self.inner = self.inner.source_auth_override(input);
            self
        }
        /// <p>A <code>SourceAuth</code> object that overrides the one defined in the batch build project. This override applies only if the build project's source is BitBucket or GitHub.</p>
        pub fn set_source_auth_override(
            mut self,
            input: std::option::Option<crate::model::SourceAuth>,
        ) -> Self {
            self.inner = self.inner.set_source_auth_override(input);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this batch build only, any previous depth of history defined in the batch build project.</p>
        pub fn git_clone_depth_override(mut self, input: i32) -> Self {
            self.inner = self.inner.git_clone_depth_override(input);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this batch build only, any previous depth of history defined in the batch build project.</p>
        pub fn set_git_clone_depth_override(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_git_clone_depth_override(input);
            self
        }
        /// <p>A <code>GitSubmodulesConfig</code> object that overrides the Git submodules configuration for this batch build.</p>
        pub fn git_submodules_config_override(
            mut self,
            input: crate::model::GitSubmodulesConfig,
        ) -> Self {
            self.inner = self.inner.git_submodules_config_override(input);
            self
        }
        /// <p>A <code>GitSubmodulesConfig</code> object that overrides the Git submodules configuration for this batch build.</p>
        pub fn set_git_submodules_config_override(
            mut self,
            input: std::option::Option<crate::model::GitSubmodulesConfig>,
        ) -> Self {
            self.inner = self.inner.set_git_submodules_config_override(input);
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.</p>
        /// <p>If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn buildspec_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.buildspec_override(input.into());
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.</p>
        /// <p>If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn set_buildspec_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_buildspec_override(input);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the batch build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.</p>
        pub fn insecure_ssl_override(mut self, input: bool) -> Self {
            self.inner = self.inner.insecure_ssl_override(input);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the batch build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.</p>
        pub fn set_insecure_ssl_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_insecure_ssl_override(input);
            self
        }
        /// <p>Set to <code>true</code> to report to your source provider the status of a batch build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p> <note>
        /// <p>The status of a build triggered by a webhook is always reported to your source provider. </p>
        /// </note>
        pub fn report_build_batch_status_override(mut self, input: bool) -> Self {
            self.inner = self.inner.report_build_batch_status_override(input);
            self
        }
        /// <p>Set to <code>true</code> to report to your source provider the status of a batch build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p> <note>
        /// <p>The status of a build triggered by a webhook is always reported to your source provider. </p>
        /// </note>
        pub fn set_report_build_batch_status_override(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_report_build_batch_status_override(input);
            self
        }
        /// <p>A container type for this batch build that overrides the one specified in the batch build project.</p>
        pub fn environment_type_override(mut self, input: crate::model::EnvironmentType) -> Self {
            self.inner = self.inner.environment_type_override(input);
            self
        }
        /// <p>A container type for this batch build that overrides the one specified in the batch build project.</p>
        pub fn set_environment_type_override(
            mut self,
            input: std::option::Option<crate::model::EnvironmentType>,
        ) -> Self {
            self.inner = self.inner.set_environment_type_override(input);
            self
        }
        /// <p>The name of an image for this batch build that overrides the one specified in the batch build project.</p>
        pub fn image_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_override(input.into());
            self
        }
        /// <p>The name of an image for this batch build that overrides the one specified in the batch build project.</p>
        pub fn set_image_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_override(input);
            self
        }
        /// <p>The name of a compute type for this batch build that overrides the one specified in the batch build project.</p>
        pub fn compute_type_override(mut self, input: crate::model::ComputeType) -> Self {
            self.inner = self.inner.compute_type_override(input);
            self
        }
        /// <p>The name of a compute type for this batch build that overrides the one specified in the batch build project.</p>
        pub fn set_compute_type_override(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.inner = self.inner.set_compute_type_override(input);
            self
        }
        /// <p>The name of a certificate for this batch build that overrides the one specified in the batch build project.</p>
        pub fn certificate_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_override(input.into());
            self
        }
        /// <p>The name of a certificate for this batch build that overrides the one specified in the batch build project.</p>
        pub fn set_certificate_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_override(input);
            self
        }
        /// <p>A <code>ProjectCache</code> object that specifies cache overrides.</p>
        pub fn cache_override(mut self, input: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache_override(input);
            self
        }
        /// <p>A <code>ProjectCache</code> object that specifies cache overrides.</p>
        pub fn set_cache_override(
            mut self,
            input: std::option::Option<crate::model::ProjectCache>,
        ) -> Self {
            self.inner = self.inner.set_cache_override(input);
            self
        }
        /// <p>The name of a service role for this batch build that overrides the one specified in the batch build project.</p>
        pub fn service_role_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_override(input.into());
            self
        }
        /// <p>The name of a service role for this batch build that overrides the one specified in the batch build project.</p>
        pub fn set_service_role_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_override(input);
            self
        }
        /// <p>Enable this flag to override privileged mode in the batch build project.</p>
        pub fn privileged_mode_override(mut self, input: bool) -> Self {
            self.inner = self.inner.privileged_mode_override(input);
            self
        }
        /// <p>Enable this flag to override privileged mode in the batch build project.</p>
        pub fn set_privileged_mode_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_privileged_mode_override(input);
            self
        }
        /// <p>Overrides the build timeout specified in the batch build project.</p>
        pub fn build_timeout_in_minutes_override(mut self, input: i32) -> Self {
            self.inner = self.inner.build_timeout_in_minutes_override(input);
            self
        }
        /// <p>Overrides the build timeout specified in the batch build project.</p>
        pub fn set_build_timeout_in_minutes_override(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_build_timeout_in_minutes_override(input);
            self
        }
        /// <p>The number of minutes a batch build is allowed to be queued before it times out.</p>
        pub fn queued_timeout_in_minutes_override(mut self, input: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes_override(input);
            self
        }
        /// <p>The number of minutes a batch build is allowed to be queued before it times out.</p>
        pub fn set_queued_timeout_in_minutes_override(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes_override(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the batch build project. The CMK key encrypts the build output artifacts.</p> <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>).</p>
        pub fn encryption_key_override(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_override(input.into());
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the batch build project. The CMK key encrypts the build output artifacts.</p> <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>).</p>
        pub fn set_encryption_key_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_override(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>StartBuildBatch</code> request. The token is included in the <code>StartBuildBatch</code> request and is valid for five minutes. If you repeat the <code>StartBuildBatch</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
        pub fn idempotency_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(input.into());
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the <code>StartBuildBatch</code> request. The token is included in the <code>StartBuildBatch</code> request and is valid for five minutes. If you repeat the <code>StartBuildBatch</code> request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>A <code>LogsConfig</code> object that override the log settings defined in the batch build project.</p>
        pub fn logs_config_override(mut self, input: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config_override(input);
            self
        }
        /// <p>A <code>LogsConfig</code> object that override the log settings defined in the batch build project.</p>
        pub fn set_logs_config_override(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config_override(input);
            self
        }
        /// <p>A <code>RegistryCredential</code> object that overrides credentials for access to a private registry.</p>
        pub fn registry_credential_override(
            mut self,
            input: crate::model::RegistryCredential,
        ) -> Self {
            self.inner = self.inner.registry_credential_override(input);
            self
        }
        /// <p>A <code>RegistryCredential</code> object that overrides credentials for access to a private registry.</p>
        pub fn set_registry_credential_override(
            mut self,
            input: std::option::Option<crate::model::RegistryCredential>,
        ) -> Self {
            self.inner = self.inner.set_registry_credential_override(input);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your batch build. There are two valid values: </p>
        /// <dl>
        /// <dt>
        /// CODEBUILD
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>
        /// SERVICE_ROLE
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials. </p>
        pub fn image_pull_credentials_type_override(
            mut self,
            input: crate::model::ImagePullCredentialsType,
        ) -> Self {
            self.inner = self.inner.image_pull_credentials_type_override(input);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your batch build. There are two valid values: </p>
        /// <dl>
        /// <dt>
        /// CODEBUILD
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>
        /// SERVICE_ROLE
        /// </dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials. </p>
        pub fn set_image_pull_credentials_type_override(
            mut self,
            input: std::option::Option<crate::model::ImagePullCredentialsType>,
        ) -> Self {
            self.inner = self.inner.set_image_pull_credentials_type_override(input);
            self
        }
        /// <p>A <code>BuildBatchConfigOverride</code> object that contains batch build configuration overrides.</p>
        pub fn build_batch_config_override(
            mut self,
            input: crate::model::ProjectBuildBatchConfig,
        ) -> Self {
            self.inner = self.inner.build_batch_config_override(input);
            self
        }
        /// <p>A <code>BuildBatchConfigOverride</code> object that contains batch build configuration overrides.</p>
        pub fn set_build_batch_config_override(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_batch_config_override(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this batch build. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
        pub fn debug_session_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.debug_session_enabled(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this batch build. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
        pub fn set_debug_session_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_debug_session_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBuild`.
    ///
    /// <p>Attempts to stop running a build.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopBuild {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_build_input::Builder,
    }
    impl StopBuild {
        /// Creates a new `StopBuild`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBuildOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBuildError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the build.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The ID of the build.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBuildBatch`.
    ///
    /// <p>Stops a running batch build.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopBuildBatch {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_build_batch_input::Builder,
    }
    impl StopBuildBatch {
        /// Creates a new `StopBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBuildBatchError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the batch build to stop.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The identifier of the batch build to stop.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Changes the settings of a build project.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_project_input::Builder,
    }
    impl UpdateProject {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the build project.</p> <note>
        /// <p>You cannot change a build project's name.</p>
        /// </note>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the build project.</p> <note>
        /// <p>You cannot change a build project's name.</p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A new or replacement description of the build project.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A new or replacement description of the build project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Information to be changed about the build input source code for the build project.</p>
        pub fn source(mut self, input: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// <p>Information to be changed about the build input source code for the build project.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ProjectSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `secondarySources`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources`](Self::set_secondary_sources).
        ///
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources(mut self, input: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.secondary_sources(input);
            self
        }
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources(input);
            self
        }
        /// <p> A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li> <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p> </li>
        /// <li> <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</p> </li>
        /// </ul>
        /// <p> If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p> A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li> <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p> </li>
        /// <li> <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format <code>pr/pull-request-ID</code> (for example <code>pr/25</code>). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.</p> </li>
        /// <li> <p>For Amazon S3: the version ID of the object that represents the build input ZIP file to use.</p> </li>
        /// </ul>
        /// <p> If <code>sourceVersion</code> is specified at the build level, then that version takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// Appends an item to `secondarySourceVersions`.
        ///
        /// To override the contents of this collection use [`set_secondary_source_versions`](Self::set_secondary_source_versions).
        ///
        /// <p> An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn secondary_source_versions(
            mut self,
            input: crate::model::ProjectSourceVersion,
        ) -> Self {
            self.inner = self.inner.secondary_source_versions(input);
            self
        }
        /// <p> An array of <code>ProjectSourceVersion</code> objects. If <code>secondarySourceVersions</code> is specified at the build level, then they take over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn set_secondary_source_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_source_versions(input);
            self
        }
        /// <p>Information to be changed about the build output artifacts for the build project.</p>
        pub fn artifacts(mut self, input: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts(input);
            self
        }
        /// <p>Information to be changed about the build output artifacts for the build project.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts(input);
            self
        }
        /// Appends an item to `secondaryArtifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p> An array of <code>ProjectArtifact</code> objects. </p>
        pub fn secondary_artifacts(mut self, input: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.secondary_artifacts(input);
            self
        }
        /// <p> An array of <code>ProjectArtifact</code> objects. </p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts(input);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later time.</p>
        pub fn cache(mut self, input: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache(input);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later time.</p>
        pub fn set_cache(mut self, input: std::option::Option<crate::model::ProjectCache>) -> Self {
            self.inner = self.inner.set_cache(input);
            self
        }
        /// <p>Information to be changed about the build environment for the build project.</p>
        pub fn environment(mut self, input: crate::model::ProjectEnvironment) -> Self {
            self.inner = self.inner.environment(input);
            self
        }
        /// <p>Information to be changed about the build environment for the build project.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::ProjectEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The replacement ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role(input.into());
            self
        }
        /// <p>The replacement ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_role(input);
            self
        }
        /// <p>The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build that did not get marked as completed.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.timeout_in_minutes(input);
            self
        }
        /// <p>The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build that did not get marked as completed.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_minutes(input);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes(mut self, input: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes(input);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.</p> <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>). </p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(input.into());
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.</p> <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format <code>alias/
        /// <alias-name></alias-name></code>). </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An updated list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An updated list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(input);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build badge.</p>
        pub fn badge_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.badge_enabled(input);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build badge.</p>
        pub fn set_badge_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_badge_enabled(input);
            self
        }
        /// <p> Information about logs for the build project. A project can create logs in CloudWatch Logs, logs in an S3 bucket, or both. </p>
        pub fn logs_config(mut self, input: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config(input);
            self
        }
        /// <p> Information about logs for the build project. A project can create logs in CloudWatch Logs, logs in an S3 bucket, or both. </p>
        pub fn set_logs_config(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config(input);
            self
        }
        /// Appends an item to `fileSystemLocations`.
        ///
        /// To override the contents of this collection use [`set_file_system_locations`](Self::set_file_system_locations).
        ///
        /// <p> An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System. </p>
        pub fn file_system_locations(
            mut self,
            input: crate::model::ProjectFileSystemLocation,
        ) -> Self {
            self.inner = self.inner.file_system_locations(input);
            self
        }
        /// <p> An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System. </p>
        pub fn set_file_system_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_locations(input);
            self
        }
        /// <p>Contains configuration information about a batch build project.</p>
        pub fn build_batch_config(mut self, input: crate::model::ProjectBuildBatchConfig) -> Self {
            self.inner = self.inner.build_batch_config(input);
            self
        }
        /// <p>Contains configuration information about a batch build project.</p>
        pub fn set_build_batch_config(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_batch_config(input);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.</p>
        /// <p>To remove this limit, set this value to -1.</p>
        pub fn concurrent_build_limit(mut self, input: i32) -> Self {
            self.inner = self.inner.concurrent_build_limit(input);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.</p>
        /// <p>To remove this limit, set this value to -1.</p>
        pub fn set_concurrent_build_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_concurrent_build_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProjectVisibility`.
    ///
    /// <p>Changes the public visibility for a project. The project's build results, logs, and artifacts are available to the general public. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html">Public build projects</a> in the <i>CodeBuild User Guide</i>.</p> <important>
    /// <p>The following should be kept in mind when making your projects public:</p>
    /// <ul>
    /// <li> <p>All of a project's build results, logs, and artifacts, including builds that were run when the project was private, are available to the general public.</p> </li>
    /// <li> <p>All build logs and artifacts are available to the public. Environment variables, source code, and other sensitive information may have been output to the build logs and artifacts. You must be careful about what information is output to the build logs. Some best practice are:</p>
    /// <ul>
    /// <li> <p>Do not store sensitive values, especially Amazon Web Services access key IDs and secret access keys, in environment variables. We recommend that you use an Amazon EC2 Systems Manager Parameter Store or Secrets Manager to store sensitive values.</p> </li>
    /// <li> <p>Follow <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/webhooks.html#webhook-best-practices">Best practices for using webhooks</a> in the <i>CodeBuild User Guide</i> to limit which entities can trigger a build, and do not store the buildspec in the project itself, to ensure that your webhooks are as secure as possible.</p> </li>
    /// </ul> </li>
    /// <li> <p>A malicious user can use public builds to distribute malicious artifacts. We recommend that you review all pull requests to verify that the pull request is a legitimate change. We also recommend that you validate any artifacts with their checksums to make sure that the correct artifacts are being downloaded.</p> </li>
    /// </ul>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProjectVisibility {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_project_visibility_input::Builder,
    }
    impl UpdateProjectVisibility {
        /// Creates a new `UpdateProjectVisibility`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectVisibilityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectVisibilityError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        /// <dl>
        /// <dt>
        /// PUBLIC_READ
        /// </dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>
        /// PRIVATE
        /// </dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn project_visibility(mut self, input: crate::model::ProjectVisibilityType) -> Self {
            self.inner = self.inner.project_visibility(input);
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        /// <dl>
        /// <dt>
        /// PUBLIC_READ
        /// </dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>
        /// PRIVATE
        /// </dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn set_project_visibility(
            mut self,
            input: std::option::Option<crate::model::ProjectVisibilityType>,
        ) -> Self {
            self.inner = self.inner.set_project_visibility(input);
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.</p>
        pub fn resource_access_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_access_role(input.into());
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.</p>
        pub fn set_resource_access_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_access_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReportGroup`.
    ///
    /// <p> Updates a report group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateReportGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_report_group_input::Builder,
    }
    impl UpdateReportGroup {
        /// Creates a new `UpdateReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReportGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the report group to update. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(input.into());
            self
        }
        /// <p> The ARN of the report group to update. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p> Used to specify an updated export type. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>S3</code>: The report results are exported to an S3 bucket. </p> </li>
        /// <li> <p> <code>NO_EXPORT</code>: The report results are not exported. </p> </li>
        /// </ul>
        pub fn export_config(mut self, input: crate::model::ReportExportConfig) -> Self {
            self.inner = self.inner.export_config(input);
            self
        }
        /// <p> Used to specify an updated export type. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>S3</code>: The report results are exported to an S3 bucket. </p> </li>
        /// <li> <p> <code>NO_EXPORT</code>: The report results are not exported. </p> </li>
        /// </ul>
        pub fn set_export_config(
            mut self,
            input: std::option::Option<crate::model::ReportExportConfig>,
        ) -> Self {
            self.inner = self.inner.set_export_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p> An updated list of tag key and value pairs associated with this report group. </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p> An updated list of tag key and value pairs associated with this report group. </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebhook`.
    ///
    /// <p> Updates the webhook associated with an CodeBuild build project. </p> <note>
    /// <p> If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateWebhook {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_webhook_input::Builder,
    }
    impl UpdateWebhook {
        /// Creates a new `UpdateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebhookError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty, then all branches are built.</p> <note>
        /// <p> It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>. </p>
        /// </note>
        pub fn branch_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_filter(input.into());
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a webhook is triggered. If the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty, then all branches are built.</p> <note>
        /// <p> It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>. </p>
        /// </note>
        pub fn set_branch_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_branch_filter(input);
            self
        }
        /// <p> A boolean value that specifies whether the associated GitHub repository's secret token should be updated. If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored. </p>
        pub fn rotate_secret(mut self, input: bool) -> Self {
            self.inner = self.inner.rotate_secret(input);
            self
        }
        /// <p> A boolean value that specifies whether the associated GitHub repository's secret token should be updated. If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored. </p>
        pub fn set_rotate_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_rotate_secret(input);
            self
        }
        /// Appends an item to `filterGroups`.
        ///
        /// To override the contents of this collection use [`set_filter_groups`](Self::set_filter_groups).
        ///
        /// <p> An array of arrays of <code>WebhookFilter</code> objects used to determine if a webhook event can trigger a build. A filter group must contain at least one <code>EVENT</code> <code>WebhookFilter</code>. </p>
        pub fn filter_groups(mut self, input: std::vec::Vec<crate::model::WebhookFilter>) -> Self {
            self.inner = self.inner.filter_groups(input);
            self
        }
        /// <p> An array of arrays of <code>WebhookFilter</code> objects used to determine if a webhook event can trigger a build. A filter group must contain at least one <code>EVENT</code> <code>WebhookFilter</code>. </p>
        pub fn set_filter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::WebhookFilter>>>,
        ) -> Self {
            self.inner = self.inner.set_filter_groups(input);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn build_type(mut self, input: crate::model::WebhookBuildType) -> Self {
            self.inner = self.inner.build_type(input);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn set_build_type(
            mut self,
            input: std::option::Option<crate::model::WebhookBuildType>,
        ) -> Self {
            self.inner = self.inner.set_build_type(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
