// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Information about a webhook that connects repository events to a build project in
/// CodeBuild.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Webhook {
    /// <p>The URL to the webhook.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The CodeBuild endpoint where webhook events are sent.</p>
    pub payload_url: std::option::Option<std::string::String>,
    /// <p>The secret token of the associated repository. </p>
    /// <note>
    /// <p>A Bitbucket webhook does not support <code>secret</code>. </p>
    /// </note>
    pub secret: std::option::Option<std::string::String>,
    /// <p>A regular expression used to determine which repository branches are built when a
    /// webhook is triggered. If the name of a branch matches the regular expression, then it is
    /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
    /// <note>
    /// <p>It is recommended that you use <code>filterGroups</code> instead of
    /// <code>branchFilter</code>. </p>
    /// </note>
    pub branch_filter: std::option::Option<std::string::String>,
    /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which
    /// webhooks are triggered. At least one <code>WebhookFilter</code> in the array must
    /// specify <code>EVENT</code> as its <code>type</code>. </p>
    /// <p>For a build to be triggered, at least one filter group in the
    /// <code>filterGroups</code> array must pass. For a filter group to pass, each of its
    /// filters must pass. </p>
    pub filter_groups:
        std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::WebhookFilter>>>,
    /// <p>Specifies the type of build this webhook will trigger.</p>
    pub build_type: std::option::Option<crate::model::WebhookBuildType>,
    /// <p>A timestamp that indicates the last time a repository's secret token was modified.
    /// </p>
    pub last_modified_secret: std::option::Option<aws_smithy_types::DateTime>,
}
impl Webhook {
    /// <p>The URL to the webhook.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The CodeBuild endpoint where webhook events are sent.</p>
    pub fn payload_url(&self) -> std::option::Option<&str> {
        self.payload_url.as_deref()
    }
    /// <p>The secret token of the associated repository. </p>
    /// <note>
    /// <p>A Bitbucket webhook does not support <code>secret</code>. </p>
    /// </note>
    pub fn secret(&self) -> std::option::Option<&str> {
        self.secret.as_deref()
    }
    /// <p>A regular expression used to determine which repository branches are built when a
    /// webhook is triggered. If the name of a branch matches the regular expression, then it is
    /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
    /// <note>
    /// <p>It is recommended that you use <code>filterGroups</code> instead of
    /// <code>branchFilter</code>. </p>
    /// </note>
    pub fn branch_filter(&self) -> std::option::Option<&str> {
        self.branch_filter.as_deref()
    }
    /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which
    /// webhooks are triggered. At least one <code>WebhookFilter</code> in the array must
    /// specify <code>EVENT</code> as its <code>type</code>. </p>
    /// <p>For a build to be triggered, at least one filter group in the
    /// <code>filterGroups</code> array must pass. For a filter group to pass, each of its
    /// filters must pass. </p>
    pub fn filter_groups(
        &self,
    ) -> std::option::Option<&[std::vec::Vec<crate::model::WebhookFilter>]> {
        self.filter_groups.as_deref()
    }
    /// <p>Specifies the type of build this webhook will trigger.</p>
    pub fn build_type(&self) -> std::option::Option<&crate::model::WebhookBuildType> {
        self.build_type.as_ref()
    }
    /// <p>A timestamp that indicates the last time a repository's secret token was modified.
    /// </p>
    pub fn last_modified_secret(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified_secret.as_ref()
    }
}
impl std::fmt::Debug for Webhook {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Webhook");
        formatter.field("url", &self.url);
        formatter.field("payload_url", &self.payload_url);
        formatter.field("secret", &self.secret);
        formatter.field("branch_filter", &self.branch_filter);
        formatter.field("filter_groups", &self.filter_groups);
        formatter.field("build_type", &self.build_type);
        formatter.field("last_modified_secret", &self.last_modified_secret);
        formatter.finish()
    }
}
/// See [`Webhook`](crate::model::Webhook)
pub mod webhook {
    /// A builder for [`Webhook`](crate::model::Webhook)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) payload_url: std::option::Option<std::string::String>,
        pub(crate) secret: std::option::Option<std::string::String>,
        pub(crate) branch_filter: std::option::Option<std::string::String>,
        pub(crate) filter_groups:
            std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::WebhookFilter>>>,
        pub(crate) build_type: std::option::Option<crate::model::WebhookBuildType>,
        pub(crate) last_modified_secret: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The URL to the webhook.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL to the webhook.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The CodeBuild endpoint where webhook events are sent.</p>
        pub fn payload_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.payload_url = Some(input.into());
            self
        }
        /// <p>The CodeBuild endpoint where webhook events are sent.</p>
        pub fn set_payload_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.payload_url = input;
            self
        }
        /// <p>The secret token of the associated repository. </p>
        /// <note>
        /// <p>A Bitbucket webhook does not support <code>secret</code>. </p>
        /// </note>
        pub fn secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret = Some(input.into());
            self
        }
        /// <p>The secret token of the associated repository. </p>
        /// <note>
        /// <p>A Bitbucket webhook does not support <code>secret</code>. </p>
        /// </note>
        pub fn set_secret(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret = input;
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a
        /// webhook is triggered. If the name of a branch matches the regular expression, then it is
        /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
        /// <note>
        /// <p>It is recommended that you use <code>filterGroups</code> instead of
        /// <code>branchFilter</code>. </p>
        /// </note>
        pub fn branch_filter(mut self, input: impl Into<std::string::String>) -> Self {
            self.branch_filter = Some(input.into());
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a
        /// webhook is triggered. If the name of a branch matches the regular expression, then it is
        /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
        /// <note>
        /// <p>It is recommended that you use <code>filterGroups</code> instead of
        /// <code>branchFilter</code>. </p>
        /// </note>
        pub fn set_branch_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.branch_filter = input;
            self
        }
        /// Appends an item to `filter_groups`.
        ///
        /// To override the contents of this collection use [`set_filter_groups`](Self::set_filter_groups).
        ///
        /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which
        /// webhooks are triggered. At least one <code>WebhookFilter</code> in the array must
        /// specify <code>EVENT</code> as its <code>type</code>. </p>
        /// <p>For a build to be triggered, at least one filter group in the
        /// <code>filterGroups</code> array must pass. For a filter group to pass, each of its
        /// filters must pass. </p>
        pub fn filter_groups(
            mut self,
            input: impl Into<std::vec::Vec<crate::model::WebhookFilter>>,
        ) -> Self {
            let mut v = self.filter_groups.unwrap_or_default();
            v.push(input.into());
            self.filter_groups = Some(v);
            self
        }
        /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which
        /// webhooks are triggered. At least one <code>WebhookFilter</code> in the array must
        /// specify <code>EVENT</code> as its <code>type</code>. </p>
        /// <p>For a build to be triggered, at least one filter group in the
        /// <code>filterGroups</code> array must pass. For a filter group to pass, each of its
        /// filters must pass. </p>
        pub fn set_filter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::WebhookFilter>>>,
        ) -> Self {
            self.filter_groups = input;
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn build_type(mut self, input: crate::model::WebhookBuildType) -> Self {
            self.build_type = Some(input);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn set_build_type(
            mut self,
            input: std::option::Option<crate::model::WebhookBuildType>,
        ) -> Self {
            self.build_type = input;
            self
        }
        /// <p>A timestamp that indicates the last time a repository's secret token was modified.
        /// </p>
        pub fn last_modified_secret(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified_secret = Some(input);
            self
        }
        /// <p>A timestamp that indicates the last time a repository's secret token was modified.
        /// </p>
        pub fn set_last_modified_secret(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`Webhook`](crate::model::Webhook)
        pub fn build(self) -> crate::model::Webhook {
            crate::model::Webhook {
                url: self.url,
                payload_url: self.payload_url,
                secret: self.secret,
                branch_filter: self.branch_filter,
                filter_groups: self.filter_groups,
                build_type: self.build_type,
                last_modified_secret: self.last_modified_secret,
            }
        }
    }
}
impl Webhook {
    /// Creates a new builder-style object to manufacture [`Webhook`](crate::model::Webhook)
    pub fn builder() -> crate::model::webhook::Builder {
        crate::model::webhook::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WebhookBuildType {
    #[allow(missing_docs)] // documentation missing in model
    Build,
    #[allow(missing_docs)] // documentation missing in model
    BuildBatch,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WebhookBuildType {
    fn from(s: &str) -> Self {
        match s {
            "BUILD" => WebhookBuildType::Build,
            "BUILD_BATCH" => WebhookBuildType::BuildBatch,
            other => WebhookBuildType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WebhookBuildType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WebhookBuildType::from(s))
    }
}
impl WebhookBuildType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WebhookBuildType::Build => "BUILD",
            WebhookBuildType::BuildBatch => "BUILD_BATCH",
            WebhookBuildType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUILD", "BUILD_BATCH"]
    }
}
impl AsRef<str> for WebhookBuildType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A filter used to determine which webhooks trigger a build. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WebhookFilter {
    /// <p> The type of webhook filter. There are six webhook filter types: <code>EVENT</code>,
    /// <code>ACTOR_ACCOUNT_ID</code>, <code>HEAD_REF</code>, <code>BASE_REF</code>,
    /// <code>FILE_PATH</code>, and <code>COMMIT_MESSAGE</code>. </p>
    /// <dl>
    /// <dt>
    /// EVENT
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when the provided <code>pattern</code>
    /// matches one of five event types: <code>PUSH</code>,
    /// <code>PULL_REQUEST_CREATED</code>, <code>PULL_REQUEST_UPDATED</code>,
    /// <code>PULL_REQUEST_REOPENED</code>, and
    /// <code>PULL_REQUEST_MERGED</code>. The <code>EVENT</code> patterns are
    /// specified as a comma-separated string. For example, <code>PUSH,
    /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> filters all push, pull
    /// request created, and pull request updated events. </p>
    /// <note>
    /// <p> The <code>PULL_REQUEST_REOPENED</code> works with GitHub and GitHub
    /// Enterprise only. </p>
    /// </note>
    /// </dd>
    /// <dt>
    /// ACTOR_ACCOUNT_ID
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when a GitHub, GitHub Enterprise, or
    /// Bitbucket account ID matches the regular expression <code>pattern</code>.
    /// </p>
    /// </dd>
    /// <dt>
    /// HEAD_REF
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when the head reference matches the
    /// regular expression <code>pattern</code>. For example,
    /// <code>refs/heads/branch-name</code> and <code>refs/tags/tag-name</code>. </p>
    /// <p> Works with GitHub and GitHub Enterprise push, GitHub and GitHub
    /// Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
    /// </p>
    /// </dd>
    /// <dt>
    /// BASE_REF
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when the base reference matches the
    /// regular expression <code>pattern</code>. For example,
    /// <code>refs/heads/branch-name</code>. </p>
    /// <note>
    /// <p> Works with pull request events only. </p>
    /// </note>
    /// </dd>
    /// <dt>
    /// FILE_PATH
    /// </dt>
    /// <dd>
    /// <p> A webhook triggers a build when the path of a changed file matches the
    /// regular expression <code>pattern</code>. </p>
    /// <note>
    /// <p> Works with GitHub and Bitbucket events push and pull requests events.
    /// Also works with GitHub Enterprise push events, but does not work with
    /// GitHub Enterprise pull request events. </p>
    /// </note>
    /// </dd>
    /// <dt>COMMIT_MESSAGE</dt>
    /// <dd>
    /// <p>A webhook triggers a build when the head commit message matches the
    /// regular expression <code>pattern</code>.</p>
    /// <note>
    /// <p> Works with GitHub and Bitbucket events push and pull requests events.
    /// Also works with GitHub Enterprise push events, but does not work with
    /// GitHub Enterprise pull request events. </p>
    /// </note>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::WebhookFilterType>,
    /// <p> For a <code>WebHookFilter</code> that uses <code>EVENT</code> type, a comma-separated
    /// string that specifies one or more events. For example, the webhook filter <code>PUSH,
    /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> allows all push, pull request
    /// created, and pull request updated events to trigger a build. </p>
    /// <p> For a <code>WebHookFilter</code> that uses any of the other filter types, a regular
    /// expression pattern. For example, a <code>WebHookFilter</code> that uses
    /// <code>HEAD_REF</code> for its <code>type</code> and the pattern
    /// <code>^refs/heads/</code> triggers a build when the head reference is a branch with
    /// a reference name <code>refs/heads/branch-name</code>. </p>
    pub pattern: std::option::Option<std::string::String>,
    /// <p> Used to indicate that the <code>pattern</code> determines which webhook events do not
    /// trigger a build. If true, then a webhook event that does not match the
    /// <code>pattern</code> triggers a build. If false, then a webhook event that matches
    /// the <code>pattern</code> triggers a build. </p>
    pub exclude_matched_pattern: std::option::Option<bool>,
}
impl WebhookFilter {
    /// <p> The type of webhook filter. There are six webhook filter types: <code>EVENT</code>,
    /// <code>ACTOR_ACCOUNT_ID</code>, <code>HEAD_REF</code>, <code>BASE_REF</code>,
    /// <code>FILE_PATH</code>, and <code>COMMIT_MESSAGE</code>. </p>
    /// <dl>
    /// <dt>
    /// EVENT
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when the provided <code>pattern</code>
    /// matches one of five event types: <code>PUSH</code>,
    /// <code>PULL_REQUEST_CREATED</code>, <code>PULL_REQUEST_UPDATED</code>,
    /// <code>PULL_REQUEST_REOPENED</code>, and
    /// <code>PULL_REQUEST_MERGED</code>. The <code>EVENT</code> patterns are
    /// specified as a comma-separated string. For example, <code>PUSH,
    /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> filters all push, pull
    /// request created, and pull request updated events. </p>
    /// <note>
    /// <p> The <code>PULL_REQUEST_REOPENED</code> works with GitHub and GitHub
    /// Enterprise only. </p>
    /// </note>
    /// </dd>
    /// <dt>
    /// ACTOR_ACCOUNT_ID
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when a GitHub, GitHub Enterprise, or
    /// Bitbucket account ID matches the regular expression <code>pattern</code>.
    /// </p>
    /// </dd>
    /// <dt>
    /// HEAD_REF
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when the head reference matches the
    /// regular expression <code>pattern</code>. For example,
    /// <code>refs/heads/branch-name</code> and <code>refs/tags/tag-name</code>. </p>
    /// <p> Works with GitHub and GitHub Enterprise push, GitHub and GitHub
    /// Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
    /// </p>
    /// </dd>
    /// <dt>
    /// BASE_REF
    /// </dt>
    /// <dd>
    /// <p> A webhook event triggers a build when the base reference matches the
    /// regular expression <code>pattern</code>. For example,
    /// <code>refs/heads/branch-name</code>. </p>
    /// <note>
    /// <p> Works with pull request events only. </p>
    /// </note>
    /// </dd>
    /// <dt>
    /// FILE_PATH
    /// </dt>
    /// <dd>
    /// <p> A webhook triggers a build when the path of a changed file matches the
    /// regular expression <code>pattern</code>. </p>
    /// <note>
    /// <p> Works with GitHub and Bitbucket events push and pull requests events.
    /// Also works with GitHub Enterprise push events, but does not work with
    /// GitHub Enterprise pull request events. </p>
    /// </note>
    /// </dd>
    /// <dt>COMMIT_MESSAGE</dt>
    /// <dd>
    /// <p>A webhook triggers a build when the head commit message matches the
    /// regular expression <code>pattern</code>.</p>
    /// <note>
    /// <p> Works with GitHub and Bitbucket events push and pull requests events.
    /// Also works with GitHub Enterprise push events, but does not work with
    /// GitHub Enterprise pull request events. </p>
    /// </note>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::WebhookFilterType> {
        self.r#type.as_ref()
    }
    /// <p> For a <code>WebHookFilter</code> that uses <code>EVENT</code> type, a comma-separated
    /// string that specifies one or more events. For example, the webhook filter <code>PUSH,
    /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> allows all push, pull request
    /// created, and pull request updated events to trigger a build. </p>
    /// <p> For a <code>WebHookFilter</code> that uses any of the other filter types, a regular
    /// expression pattern. For example, a <code>WebHookFilter</code> that uses
    /// <code>HEAD_REF</code> for its <code>type</code> and the pattern
    /// <code>^refs/heads/</code> triggers a build when the head reference is a branch with
    /// a reference name <code>refs/heads/branch-name</code>. </p>
    pub fn pattern(&self) -> std::option::Option<&str> {
        self.pattern.as_deref()
    }
    /// <p> Used to indicate that the <code>pattern</code> determines which webhook events do not
    /// trigger a build. If true, then a webhook event that does not match the
    /// <code>pattern</code> triggers a build. If false, then a webhook event that matches
    /// the <code>pattern</code> triggers a build. </p>
    pub fn exclude_matched_pattern(&self) -> std::option::Option<bool> {
        self.exclude_matched_pattern
    }
}
impl std::fmt::Debug for WebhookFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WebhookFilter");
        formatter.field("r#type", &self.r#type);
        formatter.field("pattern", &self.pattern);
        formatter.field("exclude_matched_pattern", &self.exclude_matched_pattern);
        formatter.finish()
    }
}
/// See [`WebhookFilter`](crate::model::WebhookFilter)
pub mod webhook_filter {
    /// A builder for [`WebhookFilter`](crate::model::WebhookFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::WebhookFilterType>,
        pub(crate) pattern: std::option::Option<std::string::String>,
        pub(crate) exclude_matched_pattern: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The type of webhook filter. There are six webhook filter types: <code>EVENT</code>,
        /// <code>ACTOR_ACCOUNT_ID</code>, <code>HEAD_REF</code>, <code>BASE_REF</code>,
        /// <code>FILE_PATH</code>, and <code>COMMIT_MESSAGE</code>. </p>
        /// <dl>
        /// <dt>
        /// EVENT
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when the provided <code>pattern</code>
        /// matches one of five event types: <code>PUSH</code>,
        /// <code>PULL_REQUEST_CREATED</code>, <code>PULL_REQUEST_UPDATED</code>,
        /// <code>PULL_REQUEST_REOPENED</code>, and
        /// <code>PULL_REQUEST_MERGED</code>. The <code>EVENT</code> patterns are
        /// specified as a comma-separated string. For example, <code>PUSH,
        /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> filters all push, pull
        /// request created, and pull request updated events. </p>
        /// <note>
        /// <p> The <code>PULL_REQUEST_REOPENED</code> works with GitHub and GitHub
        /// Enterprise only. </p>
        /// </note>
        /// </dd>
        /// <dt>
        /// ACTOR_ACCOUNT_ID
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when a GitHub, GitHub Enterprise, or
        /// Bitbucket account ID matches the regular expression <code>pattern</code>.
        /// </p>
        /// </dd>
        /// <dt>
        /// HEAD_REF
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when the head reference matches the
        /// regular expression <code>pattern</code>. For example,
        /// <code>refs/heads/branch-name</code> and <code>refs/tags/tag-name</code>. </p>
        /// <p> Works with GitHub and GitHub Enterprise push, GitHub and GitHub
        /// Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
        /// </p>
        /// </dd>
        /// <dt>
        /// BASE_REF
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when the base reference matches the
        /// regular expression <code>pattern</code>. For example,
        /// <code>refs/heads/branch-name</code>. </p>
        /// <note>
        /// <p> Works with pull request events only. </p>
        /// </note>
        /// </dd>
        /// <dt>
        /// FILE_PATH
        /// </dt>
        /// <dd>
        /// <p> A webhook triggers a build when the path of a changed file matches the
        /// regular expression <code>pattern</code>. </p>
        /// <note>
        /// <p> Works with GitHub and Bitbucket events push and pull requests events.
        /// Also works with GitHub Enterprise push events, but does not work with
        /// GitHub Enterprise pull request events. </p>
        /// </note>
        /// </dd>
        /// <dt>COMMIT_MESSAGE</dt>
        /// <dd>
        /// <p>A webhook triggers a build when the head commit message matches the
        /// regular expression <code>pattern</code>.</p>
        /// <note>
        /// <p> Works with GitHub and Bitbucket events push and pull requests events.
        /// Also works with GitHub Enterprise push events, but does not work with
        /// GitHub Enterprise pull request events. </p>
        /// </note>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::WebhookFilterType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of webhook filter. There are six webhook filter types: <code>EVENT</code>,
        /// <code>ACTOR_ACCOUNT_ID</code>, <code>HEAD_REF</code>, <code>BASE_REF</code>,
        /// <code>FILE_PATH</code>, and <code>COMMIT_MESSAGE</code>. </p>
        /// <dl>
        /// <dt>
        /// EVENT
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when the provided <code>pattern</code>
        /// matches one of five event types: <code>PUSH</code>,
        /// <code>PULL_REQUEST_CREATED</code>, <code>PULL_REQUEST_UPDATED</code>,
        /// <code>PULL_REQUEST_REOPENED</code>, and
        /// <code>PULL_REQUEST_MERGED</code>. The <code>EVENT</code> patterns are
        /// specified as a comma-separated string. For example, <code>PUSH,
        /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> filters all push, pull
        /// request created, and pull request updated events. </p>
        /// <note>
        /// <p> The <code>PULL_REQUEST_REOPENED</code> works with GitHub and GitHub
        /// Enterprise only. </p>
        /// </note>
        /// </dd>
        /// <dt>
        /// ACTOR_ACCOUNT_ID
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when a GitHub, GitHub Enterprise, or
        /// Bitbucket account ID matches the regular expression <code>pattern</code>.
        /// </p>
        /// </dd>
        /// <dt>
        /// HEAD_REF
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when the head reference matches the
        /// regular expression <code>pattern</code>. For example,
        /// <code>refs/heads/branch-name</code> and <code>refs/tags/tag-name</code>. </p>
        /// <p> Works with GitHub and GitHub Enterprise push, GitHub and GitHub
        /// Enterprise pull request, Bitbucket push, and Bitbucket pull request events.
        /// </p>
        /// </dd>
        /// <dt>
        /// BASE_REF
        /// </dt>
        /// <dd>
        /// <p> A webhook event triggers a build when the base reference matches the
        /// regular expression <code>pattern</code>. For example,
        /// <code>refs/heads/branch-name</code>. </p>
        /// <note>
        /// <p> Works with pull request events only. </p>
        /// </note>
        /// </dd>
        /// <dt>
        /// FILE_PATH
        /// </dt>
        /// <dd>
        /// <p> A webhook triggers a build when the path of a changed file matches the
        /// regular expression <code>pattern</code>. </p>
        /// <note>
        /// <p> Works with GitHub and Bitbucket events push and pull requests events.
        /// Also works with GitHub Enterprise push events, but does not work with
        /// GitHub Enterprise pull request events. </p>
        /// </note>
        /// </dd>
        /// <dt>COMMIT_MESSAGE</dt>
        /// <dd>
        /// <p>A webhook triggers a build when the head commit message matches the
        /// regular expression <code>pattern</code>.</p>
        /// <note>
        /// <p> Works with GitHub and Bitbucket events push and pull requests events.
        /// Also works with GitHub Enterprise push events, but does not work with
        /// GitHub Enterprise pull request events. </p>
        /// </note>
        /// </dd>
        /// </dl>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::WebhookFilterType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p> For a <code>WebHookFilter</code> that uses <code>EVENT</code> type, a comma-separated
        /// string that specifies one or more events. For example, the webhook filter <code>PUSH,
        /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> allows all push, pull request
        /// created, and pull request updated events to trigger a build. </p>
        /// <p> For a <code>WebHookFilter</code> that uses any of the other filter types, a regular
        /// expression pattern. For example, a <code>WebHookFilter</code> that uses
        /// <code>HEAD_REF</code> for its <code>type</code> and the pattern
        /// <code>^refs/heads/</code> triggers a build when the head reference is a branch with
        /// a reference name <code>refs/heads/branch-name</code>. </p>
        pub fn pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.pattern = Some(input.into());
            self
        }
        /// <p> For a <code>WebHookFilter</code> that uses <code>EVENT</code> type, a comma-separated
        /// string that specifies one or more events. For example, the webhook filter <code>PUSH,
        /// PULL_REQUEST_CREATED, PULL_REQUEST_UPDATED</code> allows all push, pull request
        /// created, and pull request updated events to trigger a build. </p>
        /// <p> For a <code>WebHookFilter</code> that uses any of the other filter types, a regular
        /// expression pattern. For example, a <code>WebHookFilter</code> that uses
        /// <code>HEAD_REF</code> for its <code>type</code> and the pattern
        /// <code>^refs/heads/</code> triggers a build when the head reference is a branch with
        /// a reference name <code>refs/heads/branch-name</code>. </p>
        pub fn set_pattern(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pattern = input;
            self
        }
        /// <p> Used to indicate that the <code>pattern</code> determines which webhook events do not
        /// trigger a build. If true, then a webhook event that does not match the
        /// <code>pattern</code> triggers a build. If false, then a webhook event that matches
        /// the <code>pattern</code> triggers a build. </p>
        pub fn exclude_matched_pattern(mut self, input: bool) -> Self {
            self.exclude_matched_pattern = Some(input);
            self
        }
        /// <p> Used to indicate that the <code>pattern</code> determines which webhook events do not
        /// trigger a build. If true, then a webhook event that does not match the
        /// <code>pattern</code> triggers a build. If false, then a webhook event that matches
        /// the <code>pattern</code> triggers a build. </p>
        pub fn set_exclude_matched_pattern(mut self, input: std::option::Option<bool>) -> Self {
            self.exclude_matched_pattern = input;
            self
        }
        /// Consumes the builder and constructs a [`WebhookFilter`](crate::model::WebhookFilter)
        pub fn build(self) -> crate::model::WebhookFilter {
            crate::model::WebhookFilter {
                r#type: self.r#type,
                pattern: self.pattern,
                exclude_matched_pattern: self.exclude_matched_pattern,
            }
        }
    }
}
impl WebhookFilter {
    /// Creates a new builder-style object to manufacture [`WebhookFilter`](crate::model::WebhookFilter)
    pub fn builder() -> crate::model::webhook_filter::Builder {
        crate::model::webhook_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WebhookFilterType {
    #[allow(missing_docs)] // documentation missing in model
    ActorAccountId,
    #[allow(missing_docs)] // documentation missing in model
    BaseRef,
    #[allow(missing_docs)] // documentation missing in model
    CommitMessage,
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    FilePath,
    #[allow(missing_docs)] // documentation missing in model
    HeadRef,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WebhookFilterType {
    fn from(s: &str) -> Self {
        match s {
            "ACTOR_ACCOUNT_ID" => WebhookFilterType::ActorAccountId,
            "BASE_REF" => WebhookFilterType::BaseRef,
            "COMMIT_MESSAGE" => WebhookFilterType::CommitMessage,
            "EVENT" => WebhookFilterType::Event,
            "FILE_PATH" => WebhookFilterType::FilePath,
            "HEAD_REF" => WebhookFilterType::HeadRef,
            other => WebhookFilterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WebhookFilterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WebhookFilterType::from(s))
    }
}
impl WebhookFilterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WebhookFilterType::ActorAccountId => "ACTOR_ACCOUNT_ID",
            WebhookFilterType::BaseRef => "BASE_REF",
            WebhookFilterType::CommitMessage => "COMMIT_MESSAGE",
            WebhookFilterType::Event => "EVENT",
            WebhookFilterType::FilePath => "FILE_PATH",
            WebhookFilterType::HeadRef => "HEAD_REF",
            WebhookFilterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTOR_ACCOUNT_ID",
            "BASE_REF",
            "COMMIT_MESSAGE",
            "EVENT",
            "FILE_PATH",
            "HEAD_REF",
        ]
    }
}
impl AsRef<str> for WebhookFilterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A series of reports. Each report contains information about the results from running a
/// series of test cases. You specify the test cases for a report group in the buildspec for
/// a build project using one or more paths to the test case files. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportGroup {
    /// <p>The ARN of the <code>ReportGroup</code>.
    /// </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the <code>ReportGroup</code>.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the <code>ReportGroup</code>. This can be one of the following
    /// values:</p>
    /// <dl>
    /// <dt>CODE_COVERAGE</dt>
    /// <dd>
    /// <p>The report group contains code coverage reports.</p>
    /// </dd>
    /// <dt>TEST</dt>
    /// <dd>
    /// <p>The report group contains test reports.</p>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::ReportType>,
    /// <p>Information about the destination where the raw data of this <code>ReportGroup</code>
    /// is exported. </p>
    pub export_config: std::option::Option<crate::model::ReportExportConfig>,
    /// <p>The date and time this <code>ReportGroup</code> was created. </p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time this <code>ReportGroup</code> was last modified. </p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of tag key and value pairs associated with this report group. </p>
    /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
    /// tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The status of the report group. This property is read-only.</p>
    /// <p>This can be one of the following values:</p>
    /// <dl>
    /// <dt>ACTIVE</dt>
    /// <dd>
    /// <p>The report group is active.</p>
    /// </dd>
    /// <dt>DELETING</dt>
    /// <dd>
    /// <p>The report group is in the process of being deleted.</p>
    /// </dd>
    /// </dl>
    pub status: std::option::Option<crate::model::ReportGroupStatusType>,
}
impl ReportGroup {
    /// <p>The ARN of the <code>ReportGroup</code>.
    /// </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The name of the <code>ReportGroup</code>.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the <code>ReportGroup</code>. This can be one of the following
    /// values:</p>
    /// <dl>
    /// <dt>CODE_COVERAGE</dt>
    /// <dd>
    /// <p>The report group contains code coverage reports.</p>
    /// </dd>
    /// <dt>TEST</dt>
    /// <dd>
    /// <p>The report group contains test reports.</p>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ReportType> {
        self.r#type.as_ref()
    }
    /// <p>Information about the destination where the raw data of this <code>ReportGroup</code>
    /// is exported. </p>
    pub fn export_config(&self) -> std::option::Option<&crate::model::ReportExportConfig> {
        self.export_config.as_ref()
    }
    /// <p>The date and time this <code>ReportGroup</code> was created. </p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>The date and time this <code>ReportGroup</code> was last modified. </p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>A list of tag key and value pairs associated with this report group. </p>
    /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
    /// tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The status of the report group. This property is read-only.</p>
    /// <p>This can be one of the following values:</p>
    /// <dl>
    /// <dt>ACTIVE</dt>
    /// <dd>
    /// <p>The report group is active.</p>
    /// </dd>
    /// <dt>DELETING</dt>
    /// <dd>
    /// <p>The report group is in the process of being deleted.</p>
    /// </dd>
    /// </dl>
    pub fn status(&self) -> std::option::Option<&crate::model::ReportGroupStatusType> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ReportGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportGroup");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("export_config", &self.export_config);
        formatter.field("created", &self.created);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("tags", &self.tags);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ReportGroup`](crate::model::ReportGroup)
pub mod report_group {
    /// A builder for [`ReportGroup`](crate::model::ReportGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ReportType>,
        pub(crate) export_config: std::option::Option<crate::model::ReportExportConfig>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) status: std::option::Option<crate::model::ReportGroupStatusType>,
    }
    impl Builder {
        /// <p>The ARN of the <code>ReportGroup</code>.
        /// </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the <code>ReportGroup</code>.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the <code>ReportGroup</code>.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the <code>ReportGroup</code>.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the <code>ReportGroup</code>. This can be one of the following
        /// values:</p>
        /// <dl>
        /// <dt>CODE_COVERAGE</dt>
        /// <dd>
        /// <p>The report group contains code coverage reports.</p>
        /// </dd>
        /// <dt>TEST</dt>
        /// <dd>
        /// <p>The report group contains test reports.</p>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::ReportType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the <code>ReportGroup</code>. This can be one of the following
        /// values:</p>
        /// <dl>
        /// <dt>CODE_COVERAGE</dt>
        /// <dd>
        /// <p>The report group contains code coverage reports.</p>
        /// </dd>
        /// <dt>TEST</dt>
        /// <dd>
        /// <p>The report group contains test reports.</p>
        /// </dd>
        /// </dl>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ReportType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Information about the destination where the raw data of this <code>ReportGroup</code>
        /// is exported. </p>
        pub fn export_config(mut self, input: crate::model::ReportExportConfig) -> Self {
            self.export_config = Some(input);
            self
        }
        /// <p>Information about the destination where the raw data of this <code>ReportGroup</code>
        /// is exported. </p>
        pub fn set_export_config(
            mut self,
            input: std::option::Option<crate::model::ReportExportConfig>,
        ) -> Self {
            self.export_config = input;
            self
        }
        /// <p>The date and time this <code>ReportGroup</code> was created. </p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>The date and time this <code>ReportGroup</code> was created. </p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>The date and time this <code>ReportGroup</code> was last modified. </p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time this <code>ReportGroup</code> was last modified. </p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key and value pairs associated with this report group. </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
        /// tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag key and value pairs associated with this report group. </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The status of the report group. This property is read-only.</p>
        /// <p>This can be one of the following values:</p>
        /// <dl>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>The report group is active.</p>
        /// </dd>
        /// <dt>DELETING</dt>
        /// <dd>
        /// <p>The report group is in the process of being deleted.</p>
        /// </dd>
        /// </dl>
        pub fn status(mut self, input: crate::model::ReportGroupStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the report group. This property is read-only.</p>
        /// <p>This can be one of the following values:</p>
        /// <dl>
        /// <dt>ACTIVE</dt>
        /// <dd>
        /// <p>The report group is active.</p>
        /// </dd>
        /// <dt>DELETING</dt>
        /// <dd>
        /// <p>The report group is in the process of being deleted.</p>
        /// </dd>
        /// </dl>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReportGroupStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportGroup`](crate::model::ReportGroup)
        pub fn build(self) -> crate::model::ReportGroup {
            crate::model::ReportGroup {
                arn: self.arn,
                name: self.name,
                r#type: self.r#type,
                export_config: self.export_config,
                created: self.created,
                last_modified: self.last_modified,
                tags: self.tags,
                status: self.status,
            }
        }
    }
}
impl ReportGroup {
    /// Creates a new builder-style object to manufacture [`ReportGroup`](crate::model::ReportGroup)
    pub fn builder() -> crate::model::report_group::Builder {
        crate::model::report_group::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportGroupStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportGroupStatusType {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReportGroupStatusType::Active,
            "DELETING" => ReportGroupStatusType::Deleting,
            other => ReportGroupStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportGroupStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportGroupStatusType::from(s))
    }
}
impl ReportGroupStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportGroupStatusType::Active => "ACTIVE",
            ReportGroupStatusType::Deleting => "DELETING",
            ReportGroupStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETING"]
    }
}
impl AsRef<str> for ReportGroupStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A tag, consisting of a key and a value.</p>
/// <p>This tag is available for use by Amazon Web Services services that support tags in CodeBuild.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag's key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag's value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag's key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag's value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag's key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag's key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag's value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag's value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p> Information about the location where the run of a report is exported. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportExportConfig {
    /// <p> The export configuration type. Valid values are: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>S3</code>: The report results are exported to an S3 bucket. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NO_EXPORT</code>: The report results are not exported. </p>
    /// </li>
    /// </ul>
    pub export_config_type: std::option::Option<crate::model::ReportExportConfigType>,
    /// <p> A <code>S3ReportExportConfig</code> object that contains information about the S3
    /// bucket where the run of a report is exported. </p>
    pub s3_destination: std::option::Option<crate::model::S3ReportExportConfig>,
}
impl ReportExportConfig {
    /// <p> The export configuration type. Valid values are: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>S3</code>: The report results are exported to an S3 bucket. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NO_EXPORT</code>: The report results are not exported. </p>
    /// </li>
    /// </ul>
    pub fn export_config_type(&self) -> std::option::Option<&crate::model::ReportExportConfigType> {
        self.export_config_type.as_ref()
    }
    /// <p> A <code>S3ReportExportConfig</code> object that contains information about the S3
    /// bucket where the run of a report is exported. </p>
    pub fn s3_destination(&self) -> std::option::Option<&crate::model::S3ReportExportConfig> {
        self.s3_destination.as_ref()
    }
}
impl std::fmt::Debug for ReportExportConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportExportConfig");
        formatter.field("export_config_type", &self.export_config_type);
        formatter.field("s3_destination", &self.s3_destination);
        formatter.finish()
    }
}
/// See [`ReportExportConfig`](crate::model::ReportExportConfig)
pub mod report_export_config {
    /// A builder for [`ReportExportConfig`](crate::model::ReportExportConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_config_type: std::option::Option<crate::model::ReportExportConfigType>,
        pub(crate) s3_destination: std::option::Option<crate::model::S3ReportExportConfig>,
    }
    impl Builder {
        /// <p> The export configuration type. Valid values are: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code>: The report results are exported to an S3 bucket. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_EXPORT</code>: The report results are not exported. </p>
        /// </li>
        /// </ul>
        pub fn export_config_type(mut self, input: crate::model::ReportExportConfigType) -> Self {
            self.export_config_type = Some(input);
            self
        }
        /// <p> The export configuration type. Valid values are: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code>: The report results are exported to an S3 bucket. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_EXPORT</code>: The report results are not exported. </p>
        /// </li>
        /// </ul>
        pub fn set_export_config_type(
            mut self,
            input: std::option::Option<crate::model::ReportExportConfigType>,
        ) -> Self {
            self.export_config_type = input;
            self
        }
        /// <p> A <code>S3ReportExportConfig</code> object that contains information about the S3
        /// bucket where the run of a report is exported. </p>
        pub fn s3_destination(mut self, input: crate::model::S3ReportExportConfig) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p> A <code>S3ReportExportConfig</code> object that contains information about the S3
        /// bucket where the run of a report is exported. </p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3ReportExportConfig>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportExportConfig`](crate::model::ReportExportConfig)
        pub fn build(self) -> crate::model::ReportExportConfig {
            crate::model::ReportExportConfig {
                export_config_type: self.export_config_type,
                s3_destination: self.s3_destination,
            }
        }
    }
}
impl ReportExportConfig {
    /// Creates a new builder-style object to manufacture [`ReportExportConfig`](crate::model::ReportExportConfig)
    pub fn builder() -> crate::model::report_export_config::Builder {
        crate::model::report_export_config::Builder::default()
    }
}

/// <p> Information about the S3 bucket where the raw data of a report are exported. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ReportExportConfig {
    /// <p> The name of the S3 bucket where the raw data of a report are exported. </p>
    pub bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account identifier of the owner of the Amazon S3 bucket. This allows report data to be exported to an Amazon S3 bucket
    /// that is owned by an account other than the account running the build.</p>
    pub bucket_owner: std::option::Option<std::string::String>,
    /// <p> The path to the exported report's raw data results. </p>
    pub path: std::option::Option<std::string::String>,
    /// <p> The type of build output artifact to create. Valid values include: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: CodeBuild creates the raw data in the output bucket. This
    /// is the default if packaging is not specified. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ZIP</code>: CodeBuild creates a ZIP file with the raw data in the
    /// output bucket. </p>
    /// </li>
    /// </ul>
    pub packaging: std::option::Option<crate::model::ReportPackagingType>,
    /// <p> The encryption key for the report's encrypted raw data. </p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p> A boolean value that specifies if the results of a report are encrypted. </p>
    pub encryption_disabled: std::option::Option<bool>,
}
impl S3ReportExportConfig {
    /// <p> The name of the S3 bucket where the raw data of a report are exported. </p>
    pub fn bucket(&self) -> std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The Amazon Web Services account identifier of the owner of the Amazon S3 bucket. This allows report data to be exported to an Amazon S3 bucket
    /// that is owned by an account other than the account running the build.</p>
    pub fn bucket_owner(&self) -> std::option::Option<&str> {
        self.bucket_owner.as_deref()
    }
    /// <p> The path to the exported report's raw data results. </p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p> The type of build output artifact to create. Valid values include: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: CodeBuild creates the raw data in the output bucket. This
    /// is the default if packaging is not specified. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ZIP</code>: CodeBuild creates a ZIP file with the raw data in the
    /// output bucket. </p>
    /// </li>
    /// </ul>
    pub fn packaging(&self) -> std::option::Option<&crate::model::ReportPackagingType> {
        self.packaging.as_ref()
    }
    /// <p> The encryption key for the report's encrypted raw data. </p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p> A boolean value that specifies if the results of a report are encrypted. </p>
    pub fn encryption_disabled(&self) -> std::option::Option<bool> {
        self.encryption_disabled
    }
}
impl std::fmt::Debug for S3ReportExportConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ReportExportConfig");
        formatter.field("bucket", &self.bucket);
        formatter.field("bucket_owner", &self.bucket_owner);
        formatter.field("path", &self.path);
        formatter.field("packaging", &self.packaging);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("encryption_disabled", &self.encryption_disabled);
        formatter.finish()
    }
}
/// See [`S3ReportExportConfig`](crate::model::S3ReportExportConfig)
pub mod s3_report_export_config {
    /// A builder for [`S3ReportExportConfig`](crate::model::S3ReportExportConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket: std::option::Option<std::string::String>,
        pub(crate) bucket_owner: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) packaging: std::option::Option<crate::model::ReportPackagingType>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) encryption_disabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> The name of the S3 bucket where the raw data of a report are exported. </p>
        pub fn bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket = Some(input.into());
            self
        }
        /// <p> The name of the S3 bucket where the raw data of a report are exported. </p>
        pub fn set_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket = input;
            self
        }
        /// <p>The Amazon Web Services account identifier of the owner of the Amazon S3 bucket. This allows report data to be exported to an Amazon S3 bucket
        /// that is owned by an account other than the account running the build.</p>
        pub fn bucket_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account identifier of the owner of the Amazon S3 bucket. This allows report data to be exported to an Amazon S3 bucket
        /// that is owned by an account other than the account running the build.</p>
        pub fn set_bucket_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_owner = input;
            self
        }
        /// <p> The path to the exported report's raw data results. </p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p> The path to the exported report's raw data results. </p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p> The type of build output artifact to create. Valid values include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: CodeBuild creates the raw data in the output bucket. This
        /// is the default if packaging is not specified. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ZIP</code>: CodeBuild creates a ZIP file with the raw data in the
        /// output bucket. </p>
        /// </li>
        /// </ul>
        pub fn packaging(mut self, input: crate::model::ReportPackagingType) -> Self {
            self.packaging = Some(input);
            self
        }
        /// <p> The type of build output artifact to create. Valid values include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: CodeBuild creates the raw data in the output bucket. This
        /// is the default if packaging is not specified. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ZIP</code>: CodeBuild creates a ZIP file with the raw data in the
        /// output bucket. </p>
        /// </li>
        /// </ul>
        pub fn set_packaging(
            mut self,
            input: std::option::Option<crate::model::ReportPackagingType>,
        ) -> Self {
            self.packaging = input;
            self
        }
        /// <p> The encryption key for the report's encrypted raw data. </p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p> The encryption key for the report's encrypted raw data. </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p> A boolean value that specifies if the results of a report are encrypted. </p>
        pub fn encryption_disabled(mut self, input: bool) -> Self {
            self.encryption_disabled = Some(input);
            self
        }
        /// <p> A boolean value that specifies if the results of a report are encrypted. </p>
        pub fn set_encryption_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.encryption_disabled = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ReportExportConfig`](crate::model::S3ReportExportConfig)
        pub fn build(self) -> crate::model::S3ReportExportConfig {
            crate::model::S3ReportExportConfig {
                bucket: self.bucket,
                bucket_owner: self.bucket_owner,
                path: self.path,
                packaging: self.packaging,
                encryption_key: self.encryption_key,
                encryption_disabled: self.encryption_disabled,
            }
        }
    }
}
impl S3ReportExportConfig {
    /// Creates a new builder-style object to manufacture [`S3ReportExportConfig`](crate::model::S3ReportExportConfig)
    pub fn builder() -> crate::model::s3_report_export_config::Builder {
        crate::model::s3_report_export_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportPackagingType {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Zip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportPackagingType {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ReportPackagingType::None,
            "ZIP" => ReportPackagingType::Zip,
            other => ReportPackagingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportPackagingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportPackagingType::from(s))
    }
}
impl ReportPackagingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportPackagingType::None => "NONE",
            ReportPackagingType::Zip => "ZIP",
            ReportPackagingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "ZIP"]
    }
}
impl AsRef<str> for ReportPackagingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportExportConfigType {
    #[allow(missing_docs)] // documentation missing in model
    NoExport,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportExportConfigType {
    fn from(s: &str) -> Self {
        match s {
            "NO_EXPORT" => ReportExportConfigType::NoExport,
            "S3" => ReportExportConfigType::S3,
            other => ReportExportConfigType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportExportConfigType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportExportConfigType::from(s))
    }
}
impl ReportExportConfigType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportExportConfigType::NoExport => "NO_EXPORT",
            ReportExportConfigType::S3 => "S3",
            ReportExportConfigType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_EXPORT", "S3"]
    }
}
impl AsRef<str> for ReportExportConfigType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportType {
    #[allow(missing_docs)] // documentation missing in model
    CodeCoverage,
    #[allow(missing_docs)] // documentation missing in model
    Test,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportType {
    fn from(s: &str) -> Self {
        match s {
            "CODE_COVERAGE" => ReportType::CodeCoverage,
            "TEST" => ReportType::Test,
            other => ReportType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportType::from(s))
    }
}
impl ReportType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportType::CodeCoverage => "CODE_COVERAGE",
            ReportType::Test => "TEST",
            ReportType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CODE_COVERAGE", "TEST"]
    }
}
impl AsRef<str> for ReportType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the visibility of the project's builds. Possible values are:</p>
///
/// <dl>
/// <dt>PUBLIC_READ</dt>
/// <dd>
/// <p>The project builds are visible to the public.</p>
/// </dd>
/// <dt>PRIVATE</dt>
/// <dd>
/// <p>The project builds are not visible to the public.</p>
/// </dd>
/// </dl>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProjectVisibilityType {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProjectVisibilityType {
    fn from(s: &str) -> Self {
        match s {
            "PRIVATE" => ProjectVisibilityType::Private,
            "PUBLIC_READ" => ProjectVisibilityType::PublicRead,
            other => ProjectVisibilityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProjectVisibilityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProjectVisibilityType::from(s))
    }
}
impl ProjectVisibilityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProjectVisibilityType::Private => "PRIVATE",
            ProjectVisibilityType::PublicRead => "PUBLIC_READ",
            ProjectVisibilityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRIVATE", "PUBLIC_READ"]
    }
}
impl AsRef<str> for ProjectVisibilityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a build project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Project {
    /// <p>The name of the build project.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the build project.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A description that makes the build project easy to identify.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Information about the build input source code for this build project.</p>
    pub source: std::option::Option<crate::model::ProjectSource>,
    /// <p>An array of <code>ProjectSource</code> objects. </p>
    pub secondary_sources: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
    /// <p>A version of the build input to be built for this project. If not specified, the
    /// latest version is used. If specified, it must be one of:</p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>sourceVersion</code> is specified at the build level, then that version
    /// takes precedence over this <code>sourceVersion</code> (at the project level). </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
    /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
    /// </p>
    pub source_version: std::option::Option<std::string::String>,
    /// <p>An array of <code>ProjectSourceVersion</code> objects. If
    /// <code>secondarySourceVersions</code> is specified at the build level, then they take
    /// over these <code>secondarySourceVersions</code> (at the project level). </p>
    pub secondary_source_versions:
        std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
    /// <p>Information about the build output artifacts for the build project.</p>
    pub artifacts: std::option::Option<crate::model::ProjectArtifacts>,
    /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
    pub secondary_artifacts: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
    /// <p>Information about the cache for the build project.</p>
    pub cache: std::option::Option<crate::model::ProjectCache>,
    /// <p>Information about the build environment for this build project.</p>
    pub environment: std::option::Option<crate::model::ProjectEnvironment>,
    /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
    /// on behalf of the Amazon Web Services account.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any
    /// related build that did not get marked as completed. The default is 60 minutes.</p>
    pub timeout_in_minutes: std::option::Option<i32>,
    /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
    pub queued_timeout_in_minutes: std::option::Option<i32>,
    /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
    /// artifacts.</p>
    /// <note>
    /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
    /// service role has permission to that key. </p>
    /// </note>
    /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
    /// the format <code>alias/<alias-name></code>). If you don't specify a
    /// value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
    /// </p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>A list of tag key and value pairs associated with this build project.</p>
    /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
    /// tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>When the build project was created, expressed in Unix time format.</p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the build project's settings were last modified, expressed in Unix time
    /// format.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Information about a webhook that connects repository events to a build project in
    /// CodeBuild.</p>
    pub webhook: std::option::Option<crate::model::Webhook>,
    /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Information about the build badge for the build project.</p>
    pub badge: std::option::Option<crate::model::ProjectBadge>,
    /// <p>Information about logs for the build project. A project can create logs in CloudWatch Logs, an
    /// S3 bucket, or both. </p>
    pub logs_config: std::option::Option<crate::model::LogsConfig>,
    /// <p>
    /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
    /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
    /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
    /// </p>
    pub file_system_locations:
        std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
    /// <p>A <a>ProjectBuildBatchConfig</a>
    /// object that defines the batch build
    /// options for the project.</p>
    pub build_batch_config: std::option::Option<crate::model::ProjectBuildBatchConfig>,
    /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
    /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
    /// If the current build count meets this limit, new builds are throttled and are not run.</p>
    pub concurrent_build_limit: std::option::Option<i32>,
    /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
    ///
    /// <dl>
    /// <dt>PUBLIC_READ</dt>
    /// <dd>
    /// <p>The project builds are visible to the public.</p>
    /// </dd>
    /// <dt>PRIVATE</dt>
    /// <dd>
    /// <p>The project builds are not visible to the public.</p>
    /// </dd>
    /// </dl>
    pub project_visibility: std::option::Option<crate::model::ProjectVisibilityType>,
    /// <p>Contains the project identifier used with the public build APIs. </p>
    pub public_project_alias: std::option::Option<std::string::String>,
    /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
    /// the project's builds.</p>
    pub resource_access_role: std::option::Option<std::string::String>,
}
impl Project {
    /// <p>The name of the build project.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the build project.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>A description that makes the build project easy to identify.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Information about the build input source code for this build project.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::ProjectSource> {
        self.source.as_ref()
    }
    /// <p>An array of <code>ProjectSource</code> objects. </p>
    pub fn secondary_sources(&self) -> std::option::Option<&[crate::model::ProjectSource]> {
        self.secondary_sources.as_deref()
    }
    /// <p>A version of the build input to be built for this project. If not specified, the
    /// latest version is used. If specified, it must be one of:</p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    /// <p>If <code>sourceVersion</code> is specified at the build level, then that version
    /// takes precedence over this <code>sourceVersion</code> (at the project level). </p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
    /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
    /// </p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
    /// <p>An array of <code>ProjectSourceVersion</code> objects. If
    /// <code>secondarySourceVersions</code> is specified at the build level, then they take
    /// over these <code>secondarySourceVersions</code> (at the project level). </p>
    pub fn secondary_source_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ProjectSourceVersion]> {
        self.secondary_source_versions.as_deref()
    }
    /// <p>Information about the build output artifacts for the build project.</p>
    pub fn artifacts(&self) -> std::option::Option<&crate::model::ProjectArtifacts> {
        self.artifacts.as_ref()
    }
    /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
    pub fn secondary_artifacts(&self) -> std::option::Option<&[crate::model::ProjectArtifacts]> {
        self.secondary_artifacts.as_deref()
    }
    /// <p>Information about the cache for the build project.</p>
    pub fn cache(&self) -> std::option::Option<&crate::model::ProjectCache> {
        self.cache.as_ref()
    }
    /// <p>Information about the build environment for this build project.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::ProjectEnvironment> {
        self.environment.as_ref()
    }
    /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
    /// on behalf of the Amazon Web Services account.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any
    /// related build that did not get marked as completed. The default is 60 minutes.</p>
    pub fn timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.timeout_in_minutes
    }
    /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
    pub fn queued_timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.queued_timeout_in_minutes
    }
    /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
    /// artifacts.</p>
    /// <note>
    /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
    /// service role has permission to that key. </p>
    /// </note>
    /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
    /// the format <code>alias/<alias-name></code>). If you don't specify a
    /// value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
    /// </p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>A list of tag key and value pairs associated with this build project.</p>
    /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
    /// tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>When the build project was created, expressed in Unix time format.</p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p>When the build project's settings were last modified, expressed in Unix time
    /// format.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>Information about a webhook that connects repository events to a build project in
    /// CodeBuild.</p>
    pub fn webhook(&self) -> std::option::Option<&crate::model::Webhook> {
        self.webhook.as_ref()
    }
    /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>Information about the build badge for the build project.</p>
    pub fn badge(&self) -> std::option::Option<&crate::model::ProjectBadge> {
        self.badge.as_ref()
    }
    /// <p>Information about logs for the build project. A project can create logs in CloudWatch Logs, an
    /// S3 bucket, or both. </p>
    pub fn logs_config(&self) -> std::option::Option<&crate::model::LogsConfig> {
        self.logs_config.as_ref()
    }
    /// <p>
    /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
    /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
    /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
    /// </p>
    pub fn file_system_locations(
        &self,
    ) -> std::option::Option<&[crate::model::ProjectFileSystemLocation]> {
        self.file_system_locations.as_deref()
    }
    /// <p>A <a>ProjectBuildBatchConfig</a>
    /// object that defines the batch build
    /// options for the project.</p>
    pub fn build_batch_config(
        &self,
    ) -> std::option::Option<&crate::model::ProjectBuildBatchConfig> {
        self.build_batch_config.as_ref()
    }
    /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
    /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
    /// If the current build count meets this limit, new builds are throttled and are not run.</p>
    pub fn concurrent_build_limit(&self) -> std::option::Option<i32> {
        self.concurrent_build_limit
    }
    /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
    ///
    /// <dl>
    /// <dt>PUBLIC_READ</dt>
    /// <dd>
    /// <p>The project builds are visible to the public.</p>
    /// </dd>
    /// <dt>PRIVATE</dt>
    /// <dd>
    /// <p>The project builds are not visible to the public.</p>
    /// </dd>
    /// </dl>
    pub fn project_visibility(&self) -> std::option::Option<&crate::model::ProjectVisibilityType> {
        self.project_visibility.as_ref()
    }
    /// <p>Contains the project identifier used with the public build APIs. </p>
    pub fn public_project_alias(&self) -> std::option::Option<&str> {
        self.public_project_alias.as_deref()
    }
    /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
    /// the project's builds.</p>
    pub fn resource_access_role(&self) -> std::option::Option<&str> {
        self.resource_access_role.as_deref()
    }
}
impl std::fmt::Debug for Project {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Project");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("secondary_sources", &self.secondary_sources);
        formatter.field("source_version", &self.source_version);
        formatter.field("secondary_source_versions", &self.secondary_source_versions);
        formatter.field("artifacts", &self.artifacts);
        formatter.field("secondary_artifacts", &self.secondary_artifacts);
        formatter.field("cache", &self.cache);
        formatter.field("environment", &self.environment);
        formatter.field("service_role", &self.service_role);
        formatter.field("timeout_in_minutes", &self.timeout_in_minutes);
        formatter.field("queued_timeout_in_minutes", &self.queued_timeout_in_minutes);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("tags", &self.tags);
        formatter.field("created", &self.created);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("webhook", &self.webhook);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("badge", &self.badge);
        formatter.field("logs_config", &self.logs_config);
        formatter.field("file_system_locations", &self.file_system_locations);
        formatter.field("build_batch_config", &self.build_batch_config);
        formatter.field("concurrent_build_limit", &self.concurrent_build_limit);
        formatter.field("project_visibility", &self.project_visibility);
        formatter.field("public_project_alias", &self.public_project_alias);
        formatter.field("resource_access_role", &self.resource_access_role);
        formatter.finish()
    }
}
/// See [`Project`](crate::model::Project)
pub mod project {
    /// A builder for [`Project`](crate::model::Project)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::ProjectSource>,
        pub(crate) secondary_sources:
            std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        pub(crate) source_version: std::option::Option<std::string::String>,
        pub(crate) secondary_source_versions:
            std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        pub(crate) artifacts: std::option::Option<crate::model::ProjectArtifacts>,
        pub(crate) secondary_artifacts:
            std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        pub(crate) cache: std::option::Option<crate::model::ProjectCache>,
        pub(crate) environment: std::option::Option<crate::model::ProjectEnvironment>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) timeout_in_minutes: std::option::Option<i32>,
        pub(crate) queued_timeout_in_minutes: std::option::Option<i32>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) webhook: std::option::Option<crate::model::Webhook>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) badge: std::option::Option<crate::model::ProjectBadge>,
        pub(crate) logs_config: std::option::Option<crate::model::LogsConfig>,
        pub(crate) file_system_locations:
            std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        pub(crate) build_batch_config: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        pub(crate) concurrent_build_limit: std::option::Option<i32>,
        pub(crate) project_visibility: std::option::Option<crate::model::ProjectVisibilityType>,
        pub(crate) public_project_alias: std::option::Option<std::string::String>,
        pub(crate) resource_access_role: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the build project.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the build project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>A description that makes the build project easy to identify.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description that makes the build project easy to identify.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Information about the build input source code for this build project.</p>
        pub fn source(mut self, input: crate::model::ProjectSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>Information about the build input source code for this build project.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ProjectSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `secondary_sources`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources`](Self::set_secondary_sources).
        ///
        /// <p>An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources(mut self, input: impl Into<crate::model::ProjectSource>) -> Self {
            let mut v = self.secondary_sources.unwrap_or_default();
            v.push(input.into());
            self.secondary_sources = Some(v);
            self
        }
        /// <p>An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.secondary_sources = input;
            self
        }
        /// <p>A version of the build input to be built for this project. If not specified, the
        /// latest version is used. If specified, it must be one of:</p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>sourceVersion</code> is specified at the build level, then that version
        /// takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>A version of the build input to be built for this project. If not specified, the
        /// latest version is used. If specified, it must be one of:</p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>sourceVersion</code> is specified at the build level, then that version
        /// takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// Appends an item to `secondary_source_versions`.
        ///
        /// To override the contents of this collection use [`set_secondary_source_versions`](Self::set_secondary_source_versions).
        ///
        /// <p>An array of <code>ProjectSourceVersion</code> objects. If
        /// <code>secondarySourceVersions</code> is specified at the build level, then they take
        /// over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn secondary_source_versions(
            mut self,
            input: impl Into<crate::model::ProjectSourceVersion>,
        ) -> Self {
            let mut v = self.secondary_source_versions.unwrap_or_default();
            v.push(input.into());
            self.secondary_source_versions = Some(v);
            self
        }
        /// <p>An array of <code>ProjectSourceVersion</code> objects. If
        /// <code>secondarySourceVersions</code> is specified at the build level, then they take
        /// over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn set_secondary_source_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.secondary_source_versions = input;
            self
        }
        /// <p>Information about the build output artifacts for the build project.</p>
        pub fn artifacts(mut self, input: crate::model::ProjectArtifacts) -> Self {
            self.artifacts = Some(input);
            self
        }
        /// <p>Information about the build output artifacts for the build project.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.artifacts = input;
            self
        }
        /// Appends an item to `secondary_artifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn secondary_artifacts(
            mut self,
            input: impl Into<crate::model::ProjectArtifacts>,
        ) -> Self {
            let mut v = self.secondary_artifacts.unwrap_or_default();
            v.push(input.into());
            self.secondary_artifacts = Some(v);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.secondary_artifacts = input;
            self
        }
        /// <p>Information about the cache for the build project.</p>
        pub fn cache(mut self, input: crate::model::ProjectCache) -> Self {
            self.cache = Some(input);
            self
        }
        /// <p>Information about the cache for the build project.</p>
        pub fn set_cache(mut self, input: std::option::Option<crate::model::ProjectCache>) -> Self {
            self.cache = input;
            self
        }
        /// <p>Information about the build environment for this build project.</p>
        pub fn environment(mut self, input: crate::model::ProjectEnvironment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>Information about the build environment for this build project.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::ProjectEnvironment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
        /// on behalf of the Amazon Web Services account.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
        /// on behalf of the Amazon Web Services account.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any
        /// related build that did not get marked as completed. The default is 60 minutes.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.timeout_in_minutes = Some(input);
            self
        }
        /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any
        /// related build that did not get marked as completed. The default is 60 minutes.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_minutes = input;
            self
        }
        /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes(mut self, input: i32) -> Self {
            self.queued_timeout_in_minutes = Some(input);
            self
        }
        /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.queued_timeout_in_minutes = input;
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>). If you don't specify a
        /// value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
        /// </p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>). If you don't specify a
        /// value, CodeBuild uses the managed CMK for Amazon Simple Storage Service (Amazon S3).
        /// </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
        /// tags.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>When the build project was created, expressed in Unix time format.</p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p>When the build project was created, expressed in Unix time format.</p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p>When the build project's settings were last modified, expressed in Unix time
        /// format.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>When the build project's settings were last modified, expressed in Unix time
        /// format.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>Information about a webhook that connects repository events to a build project in
        /// CodeBuild.</p>
        pub fn webhook(mut self, input: crate::model::Webhook) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p>Information about a webhook that connects repository events to a build project in
        /// CodeBuild.</p>
        pub fn set_webhook(mut self, input: std::option::Option<crate::model::Webhook>) -> Self {
            self.webhook = input;
            self
        }
        /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Information about the build badge for the build project.</p>
        pub fn badge(mut self, input: crate::model::ProjectBadge) -> Self {
            self.badge = Some(input);
            self
        }
        /// <p>Information about the build badge for the build project.</p>
        pub fn set_badge(mut self, input: std::option::Option<crate::model::ProjectBadge>) -> Self {
            self.badge = input;
            self
        }
        /// <p>Information about logs for the build project. A project can create logs in CloudWatch Logs, an
        /// S3 bucket, or both. </p>
        pub fn logs_config(mut self, input: crate::model::LogsConfig) -> Self {
            self.logs_config = Some(input);
            self
        }
        /// <p>Information about logs for the build project. A project can create logs in CloudWatch Logs, an
        /// S3 bucket, or both. </p>
        pub fn set_logs_config(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.logs_config = input;
            self
        }
        /// Appends an item to `file_system_locations`.
        ///
        /// To override the contents of this collection use [`set_file_system_locations`](Self::set_file_system_locations).
        ///
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn file_system_locations(
            mut self,
            input: impl Into<crate::model::ProjectFileSystemLocation>,
        ) -> Self {
            let mut v = self.file_system_locations.unwrap_or_default();
            v.push(input.into());
            self.file_system_locations = Some(v);
            self
        }
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn set_file_system_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        ) -> Self {
            self.file_system_locations = input;
            self
        }
        /// <p>A <a>ProjectBuildBatchConfig</a>
        /// object that defines the batch build
        /// options for the project.</p>
        pub fn build_batch_config(mut self, input: crate::model::ProjectBuildBatchConfig) -> Self {
            self.build_batch_config = Some(input);
            self
        }
        /// <p>A <a>ProjectBuildBatchConfig</a>
        /// object that defines the batch build
        /// options for the project.</p>
        pub fn set_build_batch_config(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.build_batch_config = input;
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
        /// If the current build count meets this limit, new builds are throttled and are not run.</p>
        pub fn concurrent_build_limit(mut self, input: i32) -> Self {
            self.concurrent_build_limit = Some(input);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
        /// If the current build count meets this limit, new builds are throttled and are not run.</p>
        pub fn set_concurrent_build_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.concurrent_build_limit = input;
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        ///
        /// <dl>
        /// <dt>PUBLIC_READ</dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>PRIVATE</dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn project_visibility(mut self, input: crate::model::ProjectVisibilityType) -> Self {
            self.project_visibility = Some(input);
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        ///
        /// <dl>
        /// <dt>PUBLIC_READ</dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>PRIVATE</dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn set_project_visibility(
            mut self,
            input: std::option::Option<crate::model::ProjectVisibilityType>,
        ) -> Self {
            self.project_visibility = input;
            self
        }
        /// <p>Contains the project identifier used with the public build APIs. </p>
        pub fn public_project_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_project_alias = Some(input.into());
            self
        }
        /// <p>Contains the project identifier used with the public build APIs. </p>
        pub fn set_public_project_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_project_alias = input;
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
        /// the project's builds.</p>
        pub fn resource_access_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_access_role = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
        /// the project's builds.</p>
        pub fn set_resource_access_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_access_role = input;
            self
        }
        /// Consumes the builder and constructs a [`Project`](crate::model::Project)
        pub fn build(self) -> crate::model::Project {
            crate::model::Project {
                name: self.name,
                arn: self.arn,
                description: self.description,
                source: self.source,
                secondary_sources: self.secondary_sources,
                source_version: self.source_version,
                secondary_source_versions: self.secondary_source_versions,
                artifacts: self.artifacts,
                secondary_artifacts: self.secondary_artifacts,
                cache: self.cache,
                environment: self.environment,
                service_role: self.service_role,
                timeout_in_minutes: self.timeout_in_minutes,
                queued_timeout_in_minutes: self.queued_timeout_in_minutes,
                encryption_key: self.encryption_key,
                tags: self.tags,
                created: self.created,
                last_modified: self.last_modified,
                webhook: self.webhook,
                vpc_config: self.vpc_config,
                badge: self.badge,
                logs_config: self.logs_config,
                file_system_locations: self.file_system_locations,
                build_batch_config: self.build_batch_config,
                concurrent_build_limit: self.concurrent_build_limit,
                project_visibility: self.project_visibility,
                public_project_alias: self.public_project_alias,
                resource_access_role: self.resource_access_role,
            }
        }
    }
}
impl Project {
    /// Creates a new builder-style object to manufacture [`Project`](crate::model::Project)
    pub fn builder() -> crate::model::project::Builder {
        crate::model::project::Builder::default()
    }
}

/// <p>Contains configuration information about a batch build project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectBuildBatchConfig {
    /// <p>Specifies the service role ARN for the batch build project.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>Specifies if the build artifacts for the batch build should be combined into a single
    /// artifact location.</p>
    pub combine_artifacts: std::option::Option<bool>,
    /// <p>A <code>BatchRestrictions</code> object that specifies the restrictions for the batch
    /// build.</p>
    pub restrictions: std::option::Option<crate::model::BatchRestrictions>,
    /// <p>Specifies the maximum amount of time, in minutes, that the batch build must be completed in.</p>
    pub timeout_in_mins: std::option::Option<i32>,
    /// <p>Specifies how build status reports are sent to the source provider for the batch build. This property is only used
    /// when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise,
    /// and your project is configured to report build statuses to the source provider.</p>
    /// <dl>
    /// <dt>REPORT_AGGREGATED_BATCH</dt>
    /// <dd>
    /// <p>(Default) Aggregate all of the build statuses into a single status report.</p>
    /// </dd>
    /// <dt>REPORT_INDIVIDUAL_BUILDS</dt>
    /// <dd>
    /// <p>Send a separate status report for each individual build.</p>
    /// </dd>
    /// </dl>
    pub batch_report_mode: std::option::Option<crate::model::BatchReportModeType>,
}
impl ProjectBuildBatchConfig {
    /// <p>Specifies the service role ARN for the batch build project.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p>Specifies if the build artifacts for the batch build should be combined into a single
    /// artifact location.</p>
    pub fn combine_artifacts(&self) -> std::option::Option<bool> {
        self.combine_artifacts
    }
    /// <p>A <code>BatchRestrictions</code> object that specifies the restrictions for the batch
    /// build.</p>
    pub fn restrictions(&self) -> std::option::Option<&crate::model::BatchRestrictions> {
        self.restrictions.as_ref()
    }
    /// <p>Specifies the maximum amount of time, in minutes, that the batch build must be completed in.</p>
    pub fn timeout_in_mins(&self) -> std::option::Option<i32> {
        self.timeout_in_mins
    }
    /// <p>Specifies how build status reports are sent to the source provider for the batch build. This property is only used
    /// when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise,
    /// and your project is configured to report build statuses to the source provider.</p>
    /// <dl>
    /// <dt>REPORT_AGGREGATED_BATCH</dt>
    /// <dd>
    /// <p>(Default) Aggregate all of the build statuses into a single status report.</p>
    /// </dd>
    /// <dt>REPORT_INDIVIDUAL_BUILDS</dt>
    /// <dd>
    /// <p>Send a separate status report for each individual build.</p>
    /// </dd>
    /// </dl>
    pub fn batch_report_mode(&self) -> std::option::Option<&crate::model::BatchReportModeType> {
        self.batch_report_mode.as_ref()
    }
}
impl std::fmt::Debug for ProjectBuildBatchConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectBuildBatchConfig");
        formatter.field("service_role", &self.service_role);
        formatter.field("combine_artifacts", &self.combine_artifacts);
        formatter.field("restrictions", &self.restrictions);
        formatter.field("timeout_in_mins", &self.timeout_in_mins);
        formatter.field("batch_report_mode", &self.batch_report_mode);
        formatter.finish()
    }
}
/// See [`ProjectBuildBatchConfig`](crate::model::ProjectBuildBatchConfig)
pub mod project_build_batch_config {
    /// A builder for [`ProjectBuildBatchConfig`](crate::model::ProjectBuildBatchConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) combine_artifacts: std::option::Option<bool>,
        pub(crate) restrictions: std::option::Option<crate::model::BatchRestrictions>,
        pub(crate) timeout_in_mins: std::option::Option<i32>,
        pub(crate) batch_report_mode: std::option::Option<crate::model::BatchReportModeType>,
    }
    impl Builder {
        /// <p>Specifies the service role ARN for the batch build project.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>Specifies the service role ARN for the batch build project.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>Specifies if the build artifacts for the batch build should be combined into a single
        /// artifact location.</p>
        pub fn combine_artifacts(mut self, input: bool) -> Self {
            self.combine_artifacts = Some(input);
            self
        }
        /// <p>Specifies if the build artifacts for the batch build should be combined into a single
        /// artifact location.</p>
        pub fn set_combine_artifacts(mut self, input: std::option::Option<bool>) -> Self {
            self.combine_artifacts = input;
            self
        }
        /// <p>A <code>BatchRestrictions</code> object that specifies the restrictions for the batch
        /// build.</p>
        pub fn restrictions(mut self, input: crate::model::BatchRestrictions) -> Self {
            self.restrictions = Some(input);
            self
        }
        /// <p>A <code>BatchRestrictions</code> object that specifies the restrictions for the batch
        /// build.</p>
        pub fn set_restrictions(
            mut self,
            input: std::option::Option<crate::model::BatchRestrictions>,
        ) -> Self {
            self.restrictions = input;
            self
        }
        /// <p>Specifies the maximum amount of time, in minutes, that the batch build must be completed in.</p>
        pub fn timeout_in_mins(mut self, input: i32) -> Self {
            self.timeout_in_mins = Some(input);
            self
        }
        /// <p>Specifies the maximum amount of time, in minutes, that the batch build must be completed in.</p>
        pub fn set_timeout_in_mins(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_mins = input;
            self
        }
        /// <p>Specifies how build status reports are sent to the source provider for the batch build. This property is only used
        /// when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise,
        /// and your project is configured to report build statuses to the source provider.</p>
        /// <dl>
        /// <dt>REPORT_AGGREGATED_BATCH</dt>
        /// <dd>
        /// <p>(Default) Aggregate all of the build statuses into a single status report.</p>
        /// </dd>
        /// <dt>REPORT_INDIVIDUAL_BUILDS</dt>
        /// <dd>
        /// <p>Send a separate status report for each individual build.</p>
        /// </dd>
        /// </dl>
        pub fn batch_report_mode(mut self, input: crate::model::BatchReportModeType) -> Self {
            self.batch_report_mode = Some(input);
            self
        }
        /// <p>Specifies how build status reports are sent to the source provider for the batch build. This property is only used
        /// when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise,
        /// and your project is configured to report build statuses to the source provider.</p>
        /// <dl>
        /// <dt>REPORT_AGGREGATED_BATCH</dt>
        /// <dd>
        /// <p>(Default) Aggregate all of the build statuses into a single status report.</p>
        /// </dd>
        /// <dt>REPORT_INDIVIDUAL_BUILDS</dt>
        /// <dd>
        /// <p>Send a separate status report for each individual build.</p>
        /// </dd>
        /// </dl>
        pub fn set_batch_report_mode(
            mut self,
            input: std::option::Option<crate::model::BatchReportModeType>,
        ) -> Self {
            self.batch_report_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectBuildBatchConfig`](crate::model::ProjectBuildBatchConfig)
        pub fn build(self) -> crate::model::ProjectBuildBatchConfig {
            crate::model::ProjectBuildBatchConfig {
                service_role: self.service_role,
                combine_artifacts: self.combine_artifacts,
                restrictions: self.restrictions,
                timeout_in_mins: self.timeout_in_mins,
                batch_report_mode: self.batch_report_mode,
            }
        }
    }
}
impl ProjectBuildBatchConfig {
    /// Creates a new builder-style object to manufacture [`ProjectBuildBatchConfig`](crate::model::ProjectBuildBatchConfig)
    pub fn builder() -> crate::model::project_build_batch_config::Builder {
        crate::model::project_build_batch_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BatchReportModeType {
    #[allow(missing_docs)] // documentation missing in model
    ReportAggregatedBatch,
    #[allow(missing_docs)] // documentation missing in model
    ReportIndividualBuilds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BatchReportModeType {
    fn from(s: &str) -> Self {
        match s {
            "REPORT_AGGREGATED_BATCH" => BatchReportModeType::ReportAggregatedBatch,
            "REPORT_INDIVIDUAL_BUILDS" => BatchReportModeType::ReportIndividualBuilds,
            other => BatchReportModeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BatchReportModeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BatchReportModeType::from(s))
    }
}
impl BatchReportModeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BatchReportModeType::ReportAggregatedBatch => "REPORT_AGGREGATED_BATCH",
            BatchReportModeType::ReportIndividualBuilds => "REPORT_INDIVIDUAL_BUILDS",
            BatchReportModeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["REPORT_AGGREGATED_BATCH", "REPORT_INDIVIDUAL_BUILDS"]
    }
}
impl AsRef<str> for BatchReportModeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies restrictions for the batch build.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchRestrictions {
    /// <p>Specifies the maximum number of builds allowed.</p>
    pub maximum_builds_allowed: std::option::Option<i32>,
    /// <p>An array of strings that specify the compute types that are allowed for the batch
    /// build. See <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
    /// compute types</a> in the <i>CodeBuild User Guide</i> for these values.
    /// </p>
    pub compute_types_allowed: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchRestrictions {
    /// <p>Specifies the maximum number of builds allowed.</p>
    pub fn maximum_builds_allowed(&self) -> std::option::Option<i32> {
        self.maximum_builds_allowed
    }
    /// <p>An array of strings that specify the compute types that are allowed for the batch
    /// build. See <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
    /// compute types</a> in the <i>CodeBuild User Guide</i> for these values.
    /// </p>
    pub fn compute_types_allowed(&self) -> std::option::Option<&[std::string::String]> {
        self.compute_types_allowed.as_deref()
    }
}
impl std::fmt::Debug for BatchRestrictions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchRestrictions");
        formatter.field("maximum_builds_allowed", &self.maximum_builds_allowed);
        formatter.field("compute_types_allowed", &self.compute_types_allowed);
        formatter.finish()
    }
}
/// See [`BatchRestrictions`](crate::model::BatchRestrictions)
pub mod batch_restrictions {
    /// A builder for [`BatchRestrictions`](crate::model::BatchRestrictions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_builds_allowed: std::option::Option<i32>,
        pub(crate) compute_types_allowed: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies the maximum number of builds allowed.</p>
        pub fn maximum_builds_allowed(mut self, input: i32) -> Self {
            self.maximum_builds_allowed = Some(input);
            self
        }
        /// <p>Specifies the maximum number of builds allowed.</p>
        pub fn set_maximum_builds_allowed(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_builds_allowed = input;
            self
        }
        /// Appends an item to `compute_types_allowed`.
        ///
        /// To override the contents of this collection use [`set_compute_types_allowed`](Self::set_compute_types_allowed).
        ///
        /// <p>An array of strings that specify the compute types that are allowed for the batch
        /// build. See <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
        /// compute types</a> in the <i>CodeBuild User Guide</i> for these values.
        /// </p>
        pub fn compute_types_allowed(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.compute_types_allowed.unwrap_or_default();
            v.push(input.into());
            self.compute_types_allowed = Some(v);
            self
        }
        /// <p>An array of strings that specify the compute types that are allowed for the batch
        /// build. See <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment
        /// compute types</a> in the <i>CodeBuild User Guide</i> for these values.
        /// </p>
        pub fn set_compute_types_allowed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.compute_types_allowed = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchRestrictions`](crate::model::BatchRestrictions)
        pub fn build(self) -> crate::model::BatchRestrictions {
            crate::model::BatchRestrictions {
                maximum_builds_allowed: self.maximum_builds_allowed,
                compute_types_allowed: self.compute_types_allowed,
            }
        }
    }
}
impl BatchRestrictions {
    /// Creates a new builder-style object to manufacture [`BatchRestrictions`](crate::model::BatchRestrictions)
    pub fn builder() -> crate::model::batch_restrictions::Builder {
        crate::model::batch_restrictions::Builder::default()
    }
}

/// <p> Information about a file system created by Amazon Elastic File System (EFS). For more
/// information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/whatisefs.html">What Is
/// Amazon Elastic File System?</a>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectFileSystemLocation {
    /// <p> The type of the file system. The one supported type is <code>EFS</code>. </p>
    pub r#type: std::option::Option<crate::model::FileSystemType>,
    /// <p>A string that specifies the location of the file system created by Amazon EFS. Its
    /// format is <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file
    /// system when you view it in the Amazon EFS console. The directory path is a path to a
    /// directory in the file system that CodeBuild mounts. For example, if the DNS name of a
    /// file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its mount
    /// directory is <code>my-efs-mount-directory</code>, then the <code>location</code> is
    /// <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>. </p>
    /// <p>The directory path in the format <code>efs-dns-name:/directory-path</code> is
    /// optional. If you do not specify a directory path, the location is only the DNS name and
    /// CodeBuild mounts the entire file system. </p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The location in the container where you mount the file system. </p>
    pub mount_point: std::option::Option<std::string::String>,
    /// <p>The name used to access a file system created by Amazon EFS. CodeBuild creates an
    /// environment variable by appending the <code>identifier</code> in all capital letters to
    /// <code>CODEBUILD_</code>. For example, if you specify <code>my_efs</code> for
    /// <code>identifier</code>, a new environment variable is create named
    /// <code>CODEBUILD_MY_EFS</code>. </p>
    /// <p> The <code>identifier</code> is used to mount your file system. </p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p> The mount options for a file system created by Amazon EFS. The default mount options
    /// used by CodeBuild are
    /// <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For
    /// more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount
    /// Options</a>. </p>
    pub mount_options: std::option::Option<std::string::String>,
}
impl ProjectFileSystemLocation {
    /// <p> The type of the file system. The one supported type is <code>EFS</code>. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FileSystemType> {
        self.r#type.as_ref()
    }
    /// <p>A string that specifies the location of the file system created by Amazon EFS. Its
    /// format is <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file
    /// system when you view it in the Amazon EFS console. The directory path is a path to a
    /// directory in the file system that CodeBuild mounts. For example, if the DNS name of a
    /// file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its mount
    /// directory is <code>my-efs-mount-directory</code>, then the <code>location</code> is
    /// <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>. </p>
    /// <p>The directory path in the format <code>efs-dns-name:/directory-path</code> is
    /// optional. If you do not specify a directory path, the location is only the DNS name and
    /// CodeBuild mounts the entire file system. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The location in the container where you mount the file system. </p>
    pub fn mount_point(&self) -> std::option::Option<&str> {
        self.mount_point.as_deref()
    }
    /// <p>The name used to access a file system created by Amazon EFS. CodeBuild creates an
    /// environment variable by appending the <code>identifier</code> in all capital letters to
    /// <code>CODEBUILD_</code>. For example, if you specify <code>my_efs</code> for
    /// <code>identifier</code>, a new environment variable is create named
    /// <code>CODEBUILD_MY_EFS</code>. </p>
    /// <p> The <code>identifier</code> is used to mount your file system. </p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p> The mount options for a file system created by Amazon EFS. The default mount options
    /// used by CodeBuild are
    /// <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For
    /// more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount
    /// Options</a>. </p>
    pub fn mount_options(&self) -> std::option::Option<&str> {
        self.mount_options.as_deref()
    }
}
impl std::fmt::Debug for ProjectFileSystemLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectFileSystemLocation");
        formatter.field("r#type", &self.r#type);
        formatter.field("location", &self.location);
        formatter.field("mount_point", &self.mount_point);
        formatter.field("identifier", &self.identifier);
        formatter.field("mount_options", &self.mount_options);
        formatter.finish()
    }
}
/// See [`ProjectFileSystemLocation`](crate::model::ProjectFileSystemLocation)
pub mod project_file_system_location {
    /// A builder for [`ProjectFileSystemLocation`](crate::model::ProjectFileSystemLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::FileSystemType>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) mount_point: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) mount_options: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The type of the file system. The one supported type is <code>EFS</code>. </p>
        pub fn r#type(mut self, input: crate::model::FileSystemType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p> The type of the file system. The one supported type is <code>EFS</code>. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::FileSystemType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A string that specifies the location of the file system created by Amazon EFS. Its
        /// format is <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file
        /// system when you view it in the Amazon EFS console. The directory path is a path to a
        /// directory in the file system that CodeBuild mounts. For example, if the DNS name of a
        /// file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its mount
        /// directory is <code>my-efs-mount-directory</code>, then the <code>location</code> is
        /// <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>. </p>
        /// <p>The directory path in the format <code>efs-dns-name:/directory-path</code> is
        /// optional. If you do not specify a directory path, the location is only the DNS name and
        /// CodeBuild mounts the entire file system. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>A string that specifies the location of the file system created by Amazon EFS. Its
        /// format is <code>efs-dns-name:/directory-path</code>. You can find the DNS name of file
        /// system when you view it in the Amazon EFS console. The directory path is a path to a
        /// directory in the file system that CodeBuild mounts. For example, if the DNS name of a
        /// file system is <code>fs-abcd1234.efs.us-west-2.amazonaws.com</code>, and its mount
        /// directory is <code>my-efs-mount-directory</code>, then the <code>location</code> is
        /// <code>fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory</code>. </p>
        /// <p>The directory path in the format <code>efs-dns-name:/directory-path</code> is
        /// optional. If you do not specify a directory path, the location is only the DNS name and
        /// CodeBuild mounts the entire file system. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The location in the container where you mount the file system. </p>
        pub fn mount_point(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_point = Some(input.into());
            self
        }
        /// <p>The location in the container where you mount the file system. </p>
        pub fn set_mount_point(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mount_point = input;
            self
        }
        /// <p>The name used to access a file system created by Amazon EFS. CodeBuild creates an
        /// environment variable by appending the <code>identifier</code> in all capital letters to
        /// <code>CODEBUILD_</code>. For example, if you specify <code>my_efs</code> for
        /// <code>identifier</code>, a new environment variable is create named
        /// <code>CODEBUILD_MY_EFS</code>. </p>
        /// <p> The <code>identifier</code> is used to mount your file system. </p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The name used to access a file system created by Amazon EFS. CodeBuild creates an
        /// environment variable by appending the <code>identifier</code> in all capital letters to
        /// <code>CODEBUILD_</code>. For example, if you specify <code>my_efs</code> for
        /// <code>identifier</code>, a new environment variable is create named
        /// <code>CODEBUILD_MY_EFS</code>. </p>
        /// <p> The <code>identifier</code> is used to mount your file system. </p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// <p> The mount options for a file system created by Amazon EFS. The default mount options
        /// used by CodeBuild are
        /// <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For
        /// more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount
        /// Options</a>. </p>
        pub fn mount_options(mut self, input: impl Into<std::string::String>) -> Self {
            self.mount_options = Some(input.into());
            self
        }
        /// <p> The mount options for a file system created by Amazon EFS. The default mount options
        /// used by CodeBuild are
        /// <code>nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2</code>. For
        /// more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html">Recommended NFS Mount
        /// Options</a>. </p>
        pub fn set_mount_options(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mount_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectFileSystemLocation`](crate::model::ProjectFileSystemLocation)
        pub fn build(self) -> crate::model::ProjectFileSystemLocation {
            crate::model::ProjectFileSystemLocation {
                r#type: self.r#type,
                location: self.location,
                mount_point: self.mount_point,
                identifier: self.identifier,
                mount_options: self.mount_options,
            }
        }
    }
}
impl ProjectFileSystemLocation {
    /// Creates a new builder-style object to manufacture [`ProjectFileSystemLocation`](crate::model::ProjectFileSystemLocation)
    pub fn builder() -> crate::model::project_file_system_location::Builder {
        crate::model::project_file_system_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FileSystemType {
    #[allow(missing_docs)] // documentation missing in model
    Efs,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FileSystemType {
    fn from(s: &str) -> Self {
        match s {
            "EFS" => FileSystemType::Efs,
            other => FileSystemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FileSystemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FileSystemType::from(s))
    }
}
impl FileSystemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FileSystemType::Efs => "EFS",
            FileSystemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EFS"]
    }
}
impl AsRef<str> for FileSystemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about logs for a build project. These can be logs in CloudWatch Logs, built in a
/// specified S3 bucket, or both. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogsConfig {
    /// <p> Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default. </p>
    pub cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsConfig>,
    /// <p> Information about logs built to an S3 bucket for a build project. S3 logs are not
    /// enabled by default. </p>
    pub s3_logs: std::option::Option<crate::model::S3LogsConfig>,
}
impl LogsConfig {
    /// <p> Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default. </p>
    pub fn cloud_watch_logs(&self) -> std::option::Option<&crate::model::CloudWatchLogsConfig> {
        self.cloud_watch_logs.as_ref()
    }
    /// <p> Information about logs built to an S3 bucket for a build project. S3 logs are not
    /// enabled by default. </p>
    pub fn s3_logs(&self) -> std::option::Option<&crate::model::S3LogsConfig> {
        self.s3_logs.as_ref()
    }
}
impl std::fmt::Debug for LogsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogsConfig");
        formatter.field("cloud_watch_logs", &self.cloud_watch_logs);
        formatter.field("s3_logs", &self.s3_logs);
        formatter.finish()
    }
}
/// See [`LogsConfig`](crate::model::LogsConfig)
pub mod logs_config {
    /// A builder for [`LogsConfig`](crate::model::LogsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsConfig>,
        pub(crate) s3_logs: std::option::Option<crate::model::S3LogsConfig>,
    }
    impl Builder {
        /// <p> Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default. </p>
        pub fn cloud_watch_logs(mut self, input: crate::model::CloudWatchLogsConfig) -> Self {
            self.cloud_watch_logs = Some(input);
            self
        }
        /// <p> Information about CloudWatch Logs for a build project. CloudWatch Logs are enabled by default. </p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsConfig>,
        ) -> Self {
            self.cloud_watch_logs = input;
            self
        }
        /// <p> Information about logs built to an S3 bucket for a build project. S3 logs are not
        /// enabled by default. </p>
        pub fn s3_logs(mut self, input: crate::model::S3LogsConfig) -> Self {
            self.s3_logs = Some(input);
            self
        }
        /// <p> Information about logs built to an S3 bucket for a build project. S3 logs are not
        /// enabled by default. </p>
        pub fn set_s3_logs(
            mut self,
            input: std::option::Option<crate::model::S3LogsConfig>,
        ) -> Self {
            self.s3_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`LogsConfig`](crate::model::LogsConfig)
        pub fn build(self) -> crate::model::LogsConfig {
            crate::model::LogsConfig {
                cloud_watch_logs: self.cloud_watch_logs,
                s3_logs: self.s3_logs,
            }
        }
    }
}
impl LogsConfig {
    /// Creates a new builder-style object to manufacture [`LogsConfig`](crate::model::LogsConfig)
    pub fn builder() -> crate::model::logs_config::Builder {
        crate::model::logs_config::Builder::default()
    }
}

/// <p> Information about S3 logs for a build project. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3LogsConfig {
    /// <p>The current status of the S3 build logs. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code>: S3 build logs are enabled for this build project.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code>: S3 build logs are not enabled for this build
    /// project.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::LogsConfigStatusType>,
    /// <p> The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket
    /// name is <code>my-bucket</code>, and your path prefix is <code>build-log</code>, then
    /// acceptable formats are <code>my-bucket/build-log</code> or
    /// <code>arn:aws:s3:::my-bucket/build-log</code>. </p>
    pub location: std::option::Option<std::string::String>,
    /// <p> Set to true if you do not want your S3 build log output encrypted. By default S3
    /// build logs are encrypted. </p>
    pub encryption_disabled: std::option::Option<bool>,
    /// <p>Specifies the bucket owner's access for objects that another account uploads to their
    /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
    /// access to these objects. This property allows you to give the bucket owner access to
    /// these objects.</p>
    /// <note>
    /// <p>To use this property, your CodeBuild service role must have the
    /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
    /// the access control list for the bucket.</p>
    /// </note>
    /// <p>This property can be one of the following values:</p>
    /// <dl>
    /// <dt>NONE</dt>
    /// <dd>
    /// <p>The bucket owner does not have access to the objects. This is the
    /// default.</p>
    /// </dd>
    /// <dt>READ_ONLY</dt>
    /// <dd>
    /// <p>The bucket owner has read-only access to the objects. The uploading account
    /// retains ownership of the objects.</p>
    /// </dd>
    /// <dt>FULL</dt>
    /// <dd>
    /// <p>The bucket owner has full access to the objects. Object ownership is determined
    /// by the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>If the bucket is configured with the <b>Bucket
    /// owner preferred</b> setting, the bucket owner owns the
    /// objects. The uploading account will have object access as specified
    /// by the bucket's policy.</p>
    /// </li>
    /// <li>
    /// <p>Otherwise, the uploading account retains ownership of the
    /// objects.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
    /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
    /// Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub bucket_owner_access: std::option::Option<crate::model::BucketOwnerAccess>,
}
impl S3LogsConfig {
    /// <p>The current status of the S3 build logs. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code>: S3 build logs are enabled for this build project.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code>: S3 build logs are not enabled for this build
    /// project.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::LogsConfigStatusType> {
        self.status.as_ref()
    }
    /// <p> The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket
    /// name is <code>my-bucket</code>, and your path prefix is <code>build-log</code>, then
    /// acceptable formats are <code>my-bucket/build-log</code> or
    /// <code>arn:aws:s3:::my-bucket/build-log</code>. </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p> Set to true if you do not want your S3 build log output encrypted. By default S3
    /// build logs are encrypted. </p>
    pub fn encryption_disabled(&self) -> std::option::Option<bool> {
        self.encryption_disabled
    }
    /// <p>Specifies the bucket owner's access for objects that another account uploads to their
    /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
    /// access to these objects. This property allows you to give the bucket owner access to
    /// these objects.</p>
    /// <note>
    /// <p>To use this property, your CodeBuild service role must have the
    /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
    /// the access control list for the bucket.</p>
    /// </note>
    /// <p>This property can be one of the following values:</p>
    /// <dl>
    /// <dt>NONE</dt>
    /// <dd>
    /// <p>The bucket owner does not have access to the objects. This is the
    /// default.</p>
    /// </dd>
    /// <dt>READ_ONLY</dt>
    /// <dd>
    /// <p>The bucket owner has read-only access to the objects. The uploading account
    /// retains ownership of the objects.</p>
    /// </dd>
    /// <dt>FULL</dt>
    /// <dd>
    /// <p>The bucket owner has full access to the objects. Object ownership is determined
    /// by the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>If the bucket is configured with the <b>Bucket
    /// owner preferred</b> setting, the bucket owner owns the
    /// objects. The uploading account will have object access as specified
    /// by the bucket's policy.</p>
    /// </li>
    /// <li>
    /// <p>Otherwise, the uploading account retains ownership of the
    /// objects.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
    /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
    /// Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub fn bucket_owner_access(&self) -> std::option::Option<&crate::model::BucketOwnerAccess> {
        self.bucket_owner_access.as_ref()
    }
}
impl std::fmt::Debug for S3LogsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3LogsConfig");
        formatter.field("status", &self.status);
        formatter.field("location", &self.location);
        formatter.field("encryption_disabled", &self.encryption_disabled);
        formatter.field("bucket_owner_access", &self.bucket_owner_access);
        formatter.finish()
    }
}
/// See [`S3LogsConfig`](crate::model::S3LogsConfig)
pub mod s3_logs_config {
    /// A builder for [`S3LogsConfig`](crate::model::S3LogsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::LogsConfigStatusType>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) encryption_disabled: std::option::Option<bool>,
        pub(crate) bucket_owner_access: std::option::Option<crate::model::BucketOwnerAccess>,
    }
    impl Builder {
        /// <p>The current status of the S3 build logs. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code>: S3 build logs are enabled for this build project.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code>: S3 build logs are not enabled for this build
        /// project.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::LogsConfigStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the S3 build logs. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code>: S3 build logs are enabled for this build project.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code>: S3 build logs are not enabled for this build
        /// project.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LogsConfigStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket
        /// name is <code>my-bucket</code>, and your path prefix is <code>build-log</code>, then
        /// acceptable formats are <code>my-bucket/build-log</code> or
        /// <code>arn:aws:s3:::my-bucket/build-log</code>. </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p> The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket
        /// name is <code>my-bucket</code>, and your path prefix is <code>build-log</code>, then
        /// acceptable formats are <code>my-bucket/build-log</code> or
        /// <code>arn:aws:s3:::my-bucket/build-log</code>. </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p> Set to true if you do not want your S3 build log output encrypted. By default S3
        /// build logs are encrypted. </p>
        pub fn encryption_disabled(mut self, input: bool) -> Self {
            self.encryption_disabled = Some(input);
            self
        }
        /// <p> Set to true if you do not want your S3 build log output encrypted. By default S3
        /// build logs are encrypted. </p>
        pub fn set_encryption_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.encryption_disabled = input;
            self
        }
        /// <p>Specifies the bucket owner's access for objects that another account uploads to their
        /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
        /// access to these objects. This property allows you to give the bucket owner access to
        /// these objects.</p>
        /// <note>
        /// <p>To use this property, your CodeBuild service role must have the
        /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
        /// the access control list for the bucket.</p>
        /// </note>
        /// <p>This property can be one of the following values:</p>
        /// <dl>
        /// <dt>NONE</dt>
        /// <dd>
        /// <p>The bucket owner does not have access to the objects. This is the
        /// default.</p>
        /// </dd>
        /// <dt>READ_ONLY</dt>
        /// <dd>
        /// <p>The bucket owner has read-only access to the objects. The uploading account
        /// retains ownership of the objects.</p>
        /// </dd>
        /// <dt>FULL</dt>
        /// <dd>
        /// <p>The bucket owner has full access to the objects. Object ownership is determined
        /// by the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>If the bucket is configured with the <b>Bucket
        /// owner preferred</b> setting, the bucket owner owns the
        /// objects. The uploading account will have object access as specified
        /// by the bucket's policy.</p>
        /// </li>
        /// <li>
        /// <p>Otherwise, the uploading account retains ownership of the
        /// objects.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
        /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
        /// Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn bucket_owner_access(mut self, input: crate::model::BucketOwnerAccess) -> Self {
            self.bucket_owner_access = Some(input);
            self
        }
        /// <p>Specifies the bucket owner's access for objects that another account uploads to their
        /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
        /// access to these objects. This property allows you to give the bucket owner access to
        /// these objects.</p>
        /// <note>
        /// <p>To use this property, your CodeBuild service role must have the
        /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
        /// the access control list for the bucket.</p>
        /// </note>
        /// <p>This property can be one of the following values:</p>
        /// <dl>
        /// <dt>NONE</dt>
        /// <dd>
        /// <p>The bucket owner does not have access to the objects. This is the
        /// default.</p>
        /// </dd>
        /// <dt>READ_ONLY</dt>
        /// <dd>
        /// <p>The bucket owner has read-only access to the objects. The uploading account
        /// retains ownership of the objects.</p>
        /// </dd>
        /// <dt>FULL</dt>
        /// <dd>
        /// <p>The bucket owner has full access to the objects. Object ownership is determined
        /// by the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>If the bucket is configured with the <b>Bucket
        /// owner preferred</b> setting, the bucket owner owns the
        /// objects. The uploading account will have object access as specified
        /// by the bucket's policy.</p>
        /// </li>
        /// <li>
        /// <p>Otherwise, the uploading account retains ownership of the
        /// objects.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
        /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
        /// Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn set_bucket_owner_access(
            mut self,
            input: std::option::Option<crate::model::BucketOwnerAccess>,
        ) -> Self {
            self.bucket_owner_access = input;
            self
        }
        /// Consumes the builder and constructs a [`S3LogsConfig`](crate::model::S3LogsConfig)
        pub fn build(self) -> crate::model::S3LogsConfig {
            crate::model::S3LogsConfig {
                status: self.status,
                location: self.location,
                encryption_disabled: self.encryption_disabled,
                bucket_owner_access: self.bucket_owner_access,
            }
        }
    }
}
impl S3LogsConfig {
    /// Creates a new builder-style object to manufacture [`S3LogsConfig`](crate::model::S3LogsConfig)
    pub fn builder() -> crate::model::s3_logs_config::Builder {
        crate::model::s3_logs_config::Builder::default()
    }
}

/// <p>Specifies the bucket owner's access for objects that another account uploads to their
/// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
/// access to these objects. This property allows you to give the bucket owner access to
/// these objects.</p>
/// <note>
/// <p>To use this property, your CodeBuild service role must have the
/// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
/// the access control list for the bucket.</p>
/// </note>
/// <p>This property can be one of the following values:</p>
/// <dl>
/// <dt>NONE</dt>
/// <dd>
/// <p>The bucket owner does not have access to the objects. This is the
/// default.</p>
/// </dd>
/// <dt>READ_ONLY</dt>
/// <dd>
/// <p>The bucket owner has read-only access to the objects. The uploading account
/// retains ownership of the objects.</p>
/// </dd>
/// <dt>FULL</dt>
/// <dd>
/// <p>The bucket owner has full access to the objects. Object ownership is determined
/// by the following criteria:</p>
/// <ul>
/// <li>
/// <p>If the bucket is configured with the <b>Bucket
/// owner preferred</b> setting, the bucket owner owns the
/// objects. The uploading account will have object access as specified
/// by the bucket's policy.</p>
/// </li>
/// <li>
/// <p>Otherwise, the uploading account retains ownership of the
/// objects.</p>
/// </li>
/// </ul>
/// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
/// Object Ownership</a> in the <i>Amazon Simple Storage Service User
/// Guide</i>.</p>
/// </dd>
/// </dl>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketOwnerAccess {
    #[allow(missing_docs)] // documentation missing in model
    Full,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    ReadOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketOwnerAccess {
    fn from(s: &str) -> Self {
        match s {
            "FULL" => BucketOwnerAccess::Full,
            "NONE" => BucketOwnerAccess::None,
            "READ_ONLY" => BucketOwnerAccess::ReadOnly,
            other => BucketOwnerAccess::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketOwnerAccess {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketOwnerAccess::from(s))
    }
}
impl BucketOwnerAccess {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketOwnerAccess::Full => "FULL",
            BucketOwnerAccess::None => "NONE",
            BucketOwnerAccess::ReadOnly => "READ_ONLY",
            BucketOwnerAccess::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL", "NONE", "READ_ONLY"]
    }
}
impl AsRef<str> for BucketOwnerAccess {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogsConfigStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogsConfigStatusType {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => LogsConfigStatusType::Disabled,
            "ENABLED" => LogsConfigStatusType::Enabled,
            other => LogsConfigStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogsConfigStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogsConfigStatusType::from(s))
    }
}
impl LogsConfigStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogsConfigStatusType::Disabled => "DISABLED",
            LogsConfigStatusType::Enabled => "ENABLED",
            LogsConfigStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for LogsConfigStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about CloudWatch Logs for a build project. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchLogsConfig {
    /// <p>The current status of the logs in CloudWatch Logs for a build project. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code>: CloudWatch Logs are enabled for this build project.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code>: CloudWatch Logs are not enabled for this build project.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::LogsConfigStatusType>,
    /// <p> The group name of the logs in CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
    /// with Log Groups and Log Streams</a>. </p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p> The prefix of the stream name of the CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
    /// with Log Groups and Log Streams</a>. </p>
    pub stream_name: std::option::Option<std::string::String>,
}
impl CloudWatchLogsConfig {
    /// <p>The current status of the logs in CloudWatch Logs for a build project. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENABLED</code>: CloudWatch Logs are enabled for this build project.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code>: CloudWatch Logs are not enabled for this build project.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::LogsConfigStatusType> {
        self.status.as_ref()
    }
    /// <p> The group name of the logs in CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
    /// with Log Groups and Log Streams</a>. </p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p> The prefix of the stream name of the CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
    /// with Log Groups and Log Streams</a>. </p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchLogsConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchLogsConfig");
        formatter.field("status", &self.status);
        formatter.field("group_name", &self.group_name);
        formatter.field("stream_name", &self.stream_name);
        formatter.finish()
    }
}
/// See [`CloudWatchLogsConfig`](crate::model::CloudWatchLogsConfig)
pub mod cloud_watch_logs_config {
    /// A builder for [`CloudWatchLogsConfig`](crate::model::CloudWatchLogsConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::LogsConfigStatusType>,
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current status of the logs in CloudWatch Logs for a build project. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code>: CloudWatch Logs are enabled for this build project.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code>: CloudWatch Logs are not enabled for this build project.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::LogsConfigStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the logs in CloudWatch Logs for a build project. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ENABLED</code>: CloudWatch Logs are enabled for this build project.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code>: CloudWatch Logs are not enabled for this build project.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LogsConfigStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The group name of the logs in CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
        /// with Log Groups and Log Streams</a>. </p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p> The group name of the logs in CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
        /// with Log Groups and Log Streams</a>. </p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p> The prefix of the stream name of the CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
        /// with Log Groups and Log Streams</a>. </p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p> The prefix of the stream name of the CloudWatch Logs. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
        /// with Log Groups and Log Streams</a>. </p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchLogsConfig`](crate::model::CloudWatchLogsConfig)
        pub fn build(self) -> crate::model::CloudWatchLogsConfig {
            crate::model::CloudWatchLogsConfig {
                status: self.status,
                group_name: self.group_name,
                stream_name: self.stream_name,
            }
        }
    }
}
impl CloudWatchLogsConfig {
    /// Creates a new builder-style object to manufacture [`CloudWatchLogsConfig`](crate::model::CloudWatchLogsConfig)
    pub fn builder() -> crate::model::cloud_watch_logs_config::Builder {
        crate::model::cloud_watch_logs_config::Builder::default()
    }
}

/// <p>Information about the build badge for the build project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectBadge {
    /// <p>Set this to true to generate a publicly accessible URL for your project's build
    /// badge.</p>
    pub badge_enabled: bool,
    /// <p>The publicly-accessible URL through which you can access the build badge for your
    /// project. </p>
    pub badge_request_url: std::option::Option<std::string::String>,
}
impl ProjectBadge {
    /// <p>Set this to true to generate a publicly accessible URL for your project's build
    /// badge.</p>
    pub fn badge_enabled(&self) -> bool {
        self.badge_enabled
    }
    /// <p>The publicly-accessible URL through which you can access the build badge for your
    /// project. </p>
    pub fn badge_request_url(&self) -> std::option::Option<&str> {
        self.badge_request_url.as_deref()
    }
}
impl std::fmt::Debug for ProjectBadge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectBadge");
        formatter.field("badge_enabled", &self.badge_enabled);
        formatter.field("badge_request_url", &self.badge_request_url);
        formatter.finish()
    }
}
/// See [`ProjectBadge`](crate::model::ProjectBadge)
pub mod project_badge {
    /// A builder for [`ProjectBadge`](crate::model::ProjectBadge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) badge_enabled: std::option::Option<bool>,
        pub(crate) badge_request_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Set this to true to generate a publicly accessible URL for your project's build
        /// badge.</p>
        pub fn badge_enabled(mut self, input: bool) -> Self {
            self.badge_enabled = Some(input);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build
        /// badge.</p>
        pub fn set_badge_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.badge_enabled = input;
            self
        }
        /// <p>The publicly-accessible URL through which you can access the build badge for your
        /// project. </p>
        pub fn badge_request_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.badge_request_url = Some(input.into());
            self
        }
        /// <p>The publicly-accessible URL through which you can access the build badge for your
        /// project. </p>
        pub fn set_badge_request_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.badge_request_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectBadge`](crate::model::ProjectBadge)
        pub fn build(self) -> crate::model::ProjectBadge {
            crate::model::ProjectBadge {
                badge_enabled: self.badge_enabled.unwrap_or_default(),
                badge_request_url: self.badge_request_url,
            }
        }
    }
}
impl ProjectBadge {
    /// Creates a new builder-style object to manufacture [`ProjectBadge`](crate::model::ProjectBadge)
    pub fn builder() -> crate::model::project_badge::Builder {
        crate::model::project_badge::Builder::default()
    }
}

/// <p>Information about the VPC configuration that CodeBuild accesses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfig {
    /// <p>The ID of the Amazon VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>A list of one or more subnet IDs in your Amazon VPC.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of one or more security groups IDs in your Amazon VPC.</p>
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfig {
    /// <p>The ID of the Amazon VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>A list of one or more subnet IDs in your Amazon VPC.</p>
    pub fn subnets(&self) -> std::option::Option<&[std::string::String]> {
        self.subnets.as_deref()
    }
    /// <p>A list of one or more security groups IDs in your Amazon VPC.</p>
    pub fn security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_ids.as_deref()
    }
}
impl std::fmt::Debug for VpcConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfig");
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnets", &self.subnets);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.finish()
    }
}
/// See [`VpcConfig`](crate::model::VpcConfig)
pub mod vpc_config {
    /// A builder for [`VpcConfig`](crate::model::VpcConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ID of the Amazon VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the Amazon VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of one or more subnet IDs in your Amazon VPC.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>A list of one or more subnet IDs in your Amazon VPC.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// <p>A list of one or more security groups IDs in your Amazon VPC.</p>
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// <p>A list of one or more security groups IDs in your Amazon VPC.</p>
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfig`](crate::model::VpcConfig)
        pub fn build(self) -> crate::model::VpcConfig {
            crate::model::VpcConfig {
                vpc_id: self.vpc_id,
                subnets: self.subnets,
                security_group_ids: self.security_group_ids,
            }
        }
    }
}
impl VpcConfig {
    /// Creates a new builder-style object to manufacture [`VpcConfig`](crate::model::VpcConfig)
    pub fn builder() -> crate::model::vpc_config::Builder {
        crate::model::vpc_config::Builder::default()
    }
}

/// <p>Information about the build environment of the build project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectEnvironment {
    /// <p>The type of build environment to use for related builds.</p>
    /// <ul>
    /// <li>
    /// <p>The environment type <code>ARM_CONTAINER</code> is available only in regions
    /// US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland),
    /// Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and
    /// EU (Frankfurt).</p>
    /// </li>
    /// <li>
    /// <p>The environment type <code>LINUX_CONTAINER</code> with compute type
    /// <code>build.general1.2xlarge</code> is available only in regions
    /// US East (N. Virginia), US East (Ohio), US West (Oregon),
    /// Canada (Central), EU (Ireland), EU (London),
    /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
    /// Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and
    /// China (Ningxia).</p>
    /// </li>
    /// <li>
    /// <p>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in
    /// regions US East (N. Virginia), US East (Ohio), US West (Oregon),
    /// Canada (Central), EU (Ireland), EU (London),
    /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
    /// Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and
    /// China (Ningxia).</p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>The environment types <code>WINDOWS_CONTAINER</code> and
    /// <code>WINDOWS_SERVER_2019_CONTAINER</code> are available only in regions
    /// US East (N. Virginia), US East (Ohio), US West (Oregon), and
    /// EU (Ireland).</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <i>CodeBuild
    /// user guide</i>.</p>
    pub r#type: std::option::Option<crate::model::EnvironmentType>,
    /// <p>The image tag or image digest that identifies the Docker image to use for this build
    /// project. Use the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>For an image tag: <code><registry>/<repository>:<tag></code>. For
    /// example, in the Docker repository that CodeBuild uses to manage its Docker
    /// images, this would be <code>aws/codebuild/standard:4.0</code>. </p>
    /// </li>
    /// <li>
    /// <p>For an image digest: <code><registry>/<repository>@<digest></code>.
    /// For example, to specify an image with the digest
    /// "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use
    /// <code><registry>/<repository>@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">Docker images provided by CodeBuild</a> in the <i>CodeBuild user
    /// guide</i>.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>Information about the compute resources the build project uses. Available values
    /// include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for
    /// builds.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for
    /// builds.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for
    /// builds, depending on your environment type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and
    /// 824 GB of SSD storage for builds. This compute type supports Docker images up to
    /// 100 GB uncompressed.</p>
    /// </li>
    /// </ul>
    /// <p> If you use <code>BUILD_GENERAL1_LARGE</code>: </p>
    /// <ul>
    /// <li>
    /// <p> For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB
    /// memory and 8 vCPUs for builds. </p>
    /// </li>
    /// <li>
    /// <p> For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255
    /// GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</p>
    /// </li>
    /// <li>
    /// <p> For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB
    /// memory and 8 vCPUs on ARM-based processors for builds.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build Environment
    /// Compute Types</a> in the <i>CodeBuild User Guide.</i>
    /// </p>
    pub compute_type: std::option::Option<crate::model::ComputeType>,
    /// <p>A set of environment variables to make available to builds for this build
    /// project.</p>
    pub environment_variables:
        std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
    /// <p>Enables running the Docker daemon inside a Docker container. Set to true only if the
    /// build project is used to build Docker images. Otherwise, a build that attempts to
    /// interact with the Docker daemon fails. The default setting is <code>false</code>.</p>
    /// <p>You can initialize the Docker daemon during the install phase of your build by adding
    /// one of the following sets of commands to the install phase of your buildspec
    /// file:</p>
    /// <p>If the operating system's base image is Ubuntu Linux:</p>
    /// <p>
    /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
    /// </p>
    /// <p>
    /// <code>- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
    /// </p>
    /// <p>If the operating system's base image is Alpine Linux and the previous command does not
    /// work, add the <code>-t</code> argument to <code>timeout</code>:</p>
    /// <p>
    /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
    /// </p>
    /// <p>
    /// <code>- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
    /// </p>
    pub privileged_mode: std::option::Option<bool>,
    /// <p>The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded
    /// certificate for the build project. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate">certificate</a> in the
    /// <i>CodeBuild User Guide</i>.</p>
    pub certificate: std::option::Option<std::string::String>,
    /// <p> The credentials for access to a private registry.</p>
    pub registry_credential: std::option::Option<crate::model::RegistryCredential>,
    /// <p> The type of credentials CodeBuild uses to pull images in your build. There are two valid
    /// values: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials.
    /// This requires that you modify your ECR repository policy to trust CodeBuild service principal. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service
    /// role. </p>
    /// </li>
    /// </ul>
    /// <p> When you use a cross-account or private registry image, you must use SERVICE_ROLE
    /// credentials. When you use an CodeBuild curated image, you must use CODEBUILD credentials.
    /// </p>
    pub image_pull_credentials_type: std::option::Option<crate::model::ImagePullCredentialsType>,
}
impl ProjectEnvironment {
    /// <p>The type of build environment to use for related builds.</p>
    /// <ul>
    /// <li>
    /// <p>The environment type <code>ARM_CONTAINER</code> is available only in regions
    /// US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland),
    /// Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and
    /// EU (Frankfurt).</p>
    /// </li>
    /// <li>
    /// <p>The environment type <code>LINUX_CONTAINER</code> with compute type
    /// <code>build.general1.2xlarge</code> is available only in regions
    /// US East (N. Virginia), US East (Ohio), US West (Oregon),
    /// Canada (Central), EU (Ireland), EU (London),
    /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
    /// Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and
    /// China (Ningxia).</p>
    /// </li>
    /// <li>
    /// <p>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in
    /// regions US East (N. Virginia), US East (Ohio), US West (Oregon),
    /// Canada (Central), EU (Ireland), EU (London),
    /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
    /// Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and
    /// China (Ningxia).</p>
    /// </li>
    /// </ul>
    /// <ul>
    /// <li>
    /// <p>The environment types <code>WINDOWS_CONTAINER</code> and
    /// <code>WINDOWS_SERVER_2019_CONTAINER</code> are available only in regions
    /// US East (N. Virginia), US East (Ohio), US West (Oregon), and
    /// EU (Ireland).</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <i>CodeBuild
    /// user guide</i>.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EnvironmentType> {
        self.r#type.as_ref()
    }
    /// <p>The image tag or image digest that identifies the Docker image to use for this build
    /// project. Use the following formats:</p>
    /// <ul>
    /// <li>
    /// <p>For an image tag: <code><registry>/<repository>:<tag></code>. For
    /// example, in the Docker repository that CodeBuild uses to manage its Docker
    /// images, this would be <code>aws/codebuild/standard:4.0</code>. </p>
    /// </li>
    /// <li>
    /// <p>For an image digest: <code><registry>/<repository>@<digest></code>.
    /// For example, to specify an image with the digest
    /// "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use
    /// <code><registry>/<repository>@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">Docker images provided by CodeBuild</a> in the <i>CodeBuild user
    /// guide</i>.</p>
    pub fn image(&self) -> std::option::Option<&str> {
        self.image.as_deref()
    }
    /// <p>Information about the compute resources the build project uses. Available values
    /// include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for
    /// builds.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for
    /// builds.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for
    /// builds, depending on your environment type.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and
    /// 824 GB of SSD storage for builds. This compute type supports Docker images up to
    /// 100 GB uncompressed.</p>
    /// </li>
    /// </ul>
    /// <p> If you use <code>BUILD_GENERAL1_LARGE</code>: </p>
    /// <ul>
    /// <li>
    /// <p> For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB
    /// memory and 8 vCPUs for builds. </p>
    /// </li>
    /// <li>
    /// <p> For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255
    /// GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</p>
    /// </li>
    /// <li>
    /// <p> For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB
    /// memory and 8 vCPUs on ARM-based processors for builds.</p>
    /// </li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build Environment
    /// Compute Types</a> in the <i>CodeBuild User Guide.</i>
    /// </p>
    pub fn compute_type(&self) -> std::option::Option<&crate::model::ComputeType> {
        self.compute_type.as_ref()
    }
    /// <p>A set of environment variables to make available to builds for this build
    /// project.</p>
    pub fn environment_variables(
        &self,
    ) -> std::option::Option<&[crate::model::EnvironmentVariable]> {
        self.environment_variables.as_deref()
    }
    /// <p>Enables running the Docker daemon inside a Docker container. Set to true only if the
    /// build project is used to build Docker images. Otherwise, a build that attempts to
    /// interact with the Docker daemon fails. The default setting is <code>false</code>.</p>
    /// <p>You can initialize the Docker daemon during the install phase of your build by adding
    /// one of the following sets of commands to the install phase of your buildspec
    /// file:</p>
    /// <p>If the operating system's base image is Ubuntu Linux:</p>
    /// <p>
    /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
    /// </p>
    /// <p>
    /// <code>- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
    /// </p>
    /// <p>If the operating system's base image is Alpine Linux and the previous command does not
    /// work, add the <code>-t</code> argument to <code>timeout</code>:</p>
    /// <p>
    /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
    /// </p>
    /// <p>
    /// <code>- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
    /// </p>
    pub fn privileged_mode(&self) -> std::option::Option<bool> {
        self.privileged_mode
    }
    /// <p>The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded
    /// certificate for the build project. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate">certificate</a> in the
    /// <i>CodeBuild User Guide</i>.</p>
    pub fn certificate(&self) -> std::option::Option<&str> {
        self.certificate.as_deref()
    }
    /// <p> The credentials for access to a private registry.</p>
    pub fn registry_credential(&self) -> std::option::Option<&crate::model::RegistryCredential> {
        self.registry_credential.as_ref()
    }
    /// <p> The type of credentials CodeBuild uses to pull images in your build. There are two valid
    /// values: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials.
    /// This requires that you modify your ECR repository policy to trust CodeBuild service principal. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service
    /// role. </p>
    /// </li>
    /// </ul>
    /// <p> When you use a cross-account or private registry image, you must use SERVICE_ROLE
    /// credentials. When you use an CodeBuild curated image, you must use CODEBUILD credentials.
    /// </p>
    pub fn image_pull_credentials_type(
        &self,
    ) -> std::option::Option<&crate::model::ImagePullCredentialsType> {
        self.image_pull_credentials_type.as_ref()
    }
}
impl std::fmt::Debug for ProjectEnvironment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectEnvironment");
        formatter.field("r#type", &self.r#type);
        formatter.field("image", &self.image);
        formatter.field("compute_type", &self.compute_type);
        formatter.field("environment_variables", &self.environment_variables);
        formatter.field("privileged_mode", &self.privileged_mode);
        formatter.field("certificate", &self.certificate);
        formatter.field("registry_credential", &self.registry_credential);
        formatter.field(
            "image_pull_credentials_type",
            &self.image_pull_credentials_type,
        );
        formatter.finish()
    }
}
/// See [`ProjectEnvironment`](crate::model::ProjectEnvironment)
pub mod project_environment {
    /// A builder for [`ProjectEnvironment`](crate::model::ProjectEnvironment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::EnvironmentType>,
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) compute_type: std::option::Option<crate::model::ComputeType>,
        pub(crate) environment_variables:
            std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        pub(crate) privileged_mode: std::option::Option<bool>,
        pub(crate) certificate: std::option::Option<std::string::String>,
        pub(crate) registry_credential: std::option::Option<crate::model::RegistryCredential>,
        pub(crate) image_pull_credentials_type:
            std::option::Option<crate::model::ImagePullCredentialsType>,
    }
    impl Builder {
        /// <p>The type of build environment to use for related builds.</p>
        /// <ul>
        /// <li>
        /// <p>The environment type <code>ARM_CONTAINER</code> is available only in regions
        /// US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland),
        /// Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and
        /// EU (Frankfurt).</p>
        /// </li>
        /// <li>
        /// <p>The environment type <code>LINUX_CONTAINER</code> with compute type
        /// <code>build.general1.2xlarge</code> is available only in regions
        /// US East (N. Virginia), US East (Ohio), US West (Oregon),
        /// Canada (Central), EU (Ireland), EU (London),
        /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
        /// Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and
        /// China (Ningxia).</p>
        /// </li>
        /// <li>
        /// <p>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in
        /// regions US East (N. Virginia), US East (Ohio), US West (Oregon),
        /// Canada (Central), EU (Ireland), EU (London),
        /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
        /// Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and
        /// China (Ningxia).</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>The environment types <code>WINDOWS_CONTAINER</code> and
        /// <code>WINDOWS_SERVER_2019_CONTAINER</code> are available only in regions
        /// US East (N. Virginia), US East (Ohio), US West (Oregon), and
        /// EU (Ireland).</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <i>CodeBuild
        /// user guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::EnvironmentType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of build environment to use for related builds.</p>
        /// <ul>
        /// <li>
        /// <p>The environment type <code>ARM_CONTAINER</code> is available only in regions
        /// US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland),
        /// Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney), and
        /// EU (Frankfurt).</p>
        /// </li>
        /// <li>
        /// <p>The environment type <code>LINUX_CONTAINER</code> with compute type
        /// <code>build.general1.2xlarge</code> is available only in regions
        /// US East (N. Virginia), US East (Ohio), US West (Oregon),
        /// Canada (Central), EU (Ireland), EU (London),
        /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
        /// Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and
        /// China (Ningxia).</p>
        /// </li>
        /// <li>
        /// <p>The environment type <code>LINUX_GPU_CONTAINER</code> is available only in
        /// regions US East (N. Virginia), US East (Ohio), US West (Oregon),
        /// Canada (Central), EU (Ireland), EU (London),
        /// EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul),
        /// Asia Pacific (Singapore), Asia Pacific (Sydney) , China (Beijing), and
        /// China (Ningxia).</p>
        /// </li>
        /// </ul>
        /// <ul>
        /// <li>
        /// <p>The environment types <code>WINDOWS_CONTAINER</code> and
        /// <code>WINDOWS_SERVER_2019_CONTAINER</code> are available only in regions
        /// US East (N. Virginia), US East (Ohio), US West (Oregon), and
        /// EU (Ireland).</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build environment compute types</a> in the <i>CodeBuild
        /// user guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The image tag or image digest that identifies the Docker image to use for this build
        /// project. Use the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>For an image tag: <code><registry>/<repository>:<tag></code>. For
        /// example, in the Docker repository that CodeBuild uses to manage its Docker
        /// images, this would be <code>aws/codebuild/standard:4.0</code>. </p>
        /// </li>
        /// <li>
        /// <p>For an image digest: <code><registry>/<repository>@<digest></code>.
        /// For example, to specify an image with the digest
        /// "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use
        /// <code><registry>/<repository>@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">Docker images provided by CodeBuild</a> in the <i>CodeBuild user
        /// guide</i>.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The image tag or image digest that identifies the Docker image to use for this build
        /// project. Use the following formats:</p>
        /// <ul>
        /// <li>
        /// <p>For an image tag: <code><registry>/<repository>:<tag></code>. For
        /// example, in the Docker repository that CodeBuild uses to manage its Docker
        /// images, this would be <code>aws/codebuild/standard:4.0</code>. </p>
        /// </li>
        /// <li>
        /// <p>For an image digest: <code><registry>/<repository>@<digest></code>.
        /// For example, to specify an image with the digest
        /// "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf," use
        /// <code><registry>/<repository>@sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html">Docker images provided by CodeBuild</a> in the <i>CodeBuild user
        /// guide</i>.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>Information about the compute resources the build project uses. Available values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for
        /// builds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for
        /// builds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for
        /// builds, depending on your environment type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and
        /// 824 GB of SSD storage for builds. This compute type supports Docker images up to
        /// 100 GB uncompressed.</p>
        /// </li>
        /// </ul>
        /// <p> If you use <code>BUILD_GENERAL1_LARGE</code>: </p>
        /// <ul>
        /// <li>
        /// <p> For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB
        /// memory and 8 vCPUs for builds. </p>
        /// </li>
        /// <li>
        /// <p> For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255
        /// GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</p>
        /// </li>
        /// <li>
        /// <p> For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB
        /// memory and 8 vCPUs on ARM-based processors for builds.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build Environment
        /// Compute Types</a> in the <i>CodeBuild User Guide.</i>
        /// </p>
        pub fn compute_type(mut self, input: crate::model::ComputeType) -> Self {
            self.compute_type = Some(input);
            self
        }
        /// <p>Information about the compute resources the build project uses. Available values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_SMALL</code>: Use up to 3 GB memory and 2 vCPUs for
        /// builds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_MEDIUM</code>: Use up to 7 GB memory and 4 vCPUs for
        /// builds.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_LARGE</code>: Use up to 16 GB memory and 8 vCPUs for
        /// builds, depending on your environment type.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BUILD_GENERAL1_2XLARGE</code>: Use up to 145 GB memory, 72 vCPUs, and
        /// 824 GB of SSD storage for builds. This compute type supports Docker images up to
        /// 100 GB uncompressed.</p>
        /// </li>
        /// </ul>
        /// <p> If you use <code>BUILD_GENERAL1_LARGE</code>: </p>
        /// <ul>
        /// <li>
        /// <p> For environment type <code>LINUX_CONTAINER</code>, you can use up to 15 GB
        /// memory and 8 vCPUs for builds. </p>
        /// </li>
        /// <li>
        /// <p> For environment type <code>LINUX_GPU_CONTAINER</code>, you can use up to 255
        /// GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.</p>
        /// </li>
        /// <li>
        /// <p> For environment type <code>ARM_CONTAINER</code>, you can use up to 16 GB
        /// memory and 8 vCPUs on ARM-based processors for builds.</p>
        /// </li>
        /// </ul>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html">Build Environment
        /// Compute Types</a> in the <i>CodeBuild User Guide.</i>
        /// </p>
        pub fn set_compute_type(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.compute_type = input;
            self
        }
        /// Appends an item to `environment_variables`.
        ///
        /// To override the contents of this collection use [`set_environment_variables`](Self::set_environment_variables).
        ///
        /// <p>A set of environment variables to make available to builds for this build
        /// project.</p>
        pub fn environment_variables(
            mut self,
            input: impl Into<crate::model::EnvironmentVariable>,
        ) -> Self {
            let mut v = self.environment_variables.unwrap_or_default();
            v.push(input.into());
            self.environment_variables = Some(v);
            self
        }
        /// <p>A set of environment variables to make available to builds for this build
        /// project.</p>
        pub fn set_environment_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.environment_variables = input;
            self
        }
        /// <p>Enables running the Docker daemon inside a Docker container. Set to true only if the
        /// build project is used to build Docker images. Otherwise, a build that attempts to
        /// interact with the Docker daemon fails. The default setting is <code>false</code>.</p>
        /// <p>You can initialize the Docker daemon during the install phase of your build by adding
        /// one of the following sets of commands to the install phase of your buildspec
        /// file:</p>
        /// <p>If the operating system's base image is Ubuntu Linux:</p>
        /// <p>
        /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
        /// </p>
        /// <p>
        /// <code>- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
        /// </p>
        /// <p>If the operating system's base image is Alpine Linux and the previous command does not
        /// work, add the <code>-t</code> argument to <code>timeout</code>:</p>
        /// <p>
        /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
        /// </p>
        /// <p>
        /// <code>- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
        /// </p>
        pub fn privileged_mode(mut self, input: bool) -> Self {
            self.privileged_mode = Some(input);
            self
        }
        /// <p>Enables running the Docker daemon inside a Docker container. Set to true only if the
        /// build project is used to build Docker images. Otherwise, a build that attempts to
        /// interact with the Docker daemon fails. The default setting is <code>false</code>.</p>
        /// <p>You can initialize the Docker daemon during the install phase of your build by adding
        /// one of the following sets of commands to the install phase of your buildspec
        /// file:</p>
        /// <p>If the operating system's base image is Ubuntu Linux:</p>
        /// <p>
        /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
        /// </p>
        /// <p>
        /// <code>- timeout 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
        /// </p>
        /// <p>If the operating system's base image is Alpine Linux and the previous command does not
        /// work, add the <code>-t</code> argument to <code>timeout</code>:</p>
        /// <p>
        /// <code>- nohup /usr/local/bin/dockerd --host=unix:///var/run/docker.sock --host=tcp://0.0.0.0:2375 --storage-driver=overlay&</code>
        /// </p>
        /// <p>
        /// <code>- timeout -t 15 sh -c "until docker info; do echo .; sleep 1; done"</code>
        /// </p>
        pub fn set_privileged_mode(mut self, input: std::option::Option<bool>) -> Self {
            self.privileged_mode = input;
            self
        }
        /// <p>The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded
        /// certificate for the build project. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate">certificate</a> in the
        /// <i>CodeBuild User Guide</i>.</p>
        pub fn certificate(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate = Some(input.into());
            self
        }
        /// <p>The ARN of the Amazon S3 bucket, path prefix, and object key that contains the PEM-encoded
        /// certificate for the build project. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/create-project-cli.html#cli.environment.certificate">certificate</a> in the
        /// <i>CodeBuild User Guide</i>.</p>
        pub fn set_certificate(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.certificate = input;
            self
        }
        /// <p> The credentials for access to a private registry.</p>
        pub fn registry_credential(mut self, input: crate::model::RegistryCredential) -> Self {
            self.registry_credential = Some(input);
            self
        }
        /// <p> The credentials for access to a private registry.</p>
        pub fn set_registry_credential(
            mut self,
            input: std::option::Option<crate::model::RegistryCredential>,
        ) -> Self {
            self.registry_credential = input;
            self
        }
        /// <p> The type of credentials CodeBuild uses to pull images in your build. There are two valid
        /// values: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials.
        /// This requires that you modify your ECR repository policy to trust CodeBuild service principal. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service
        /// role. </p>
        /// </li>
        /// </ul>
        /// <p> When you use a cross-account or private registry image, you must use SERVICE_ROLE
        /// credentials. When you use an CodeBuild curated image, you must use CODEBUILD credentials.
        /// </p>
        pub fn image_pull_credentials_type(
            mut self,
            input: crate::model::ImagePullCredentialsType,
        ) -> Self {
            self.image_pull_credentials_type = Some(input);
            self
        }
        /// <p> The type of credentials CodeBuild uses to pull images in your build. There are two valid
        /// values: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials.
        /// This requires that you modify your ECR repository policy to trust CodeBuild service principal. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service
        /// role. </p>
        /// </li>
        /// </ul>
        /// <p> When you use a cross-account or private registry image, you must use SERVICE_ROLE
        /// credentials. When you use an CodeBuild curated image, you must use CODEBUILD credentials.
        /// </p>
        pub fn set_image_pull_credentials_type(
            mut self,
            input: std::option::Option<crate::model::ImagePullCredentialsType>,
        ) -> Self {
            self.image_pull_credentials_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectEnvironment`](crate::model::ProjectEnvironment)
        pub fn build(self) -> crate::model::ProjectEnvironment {
            crate::model::ProjectEnvironment {
                r#type: self.r#type,
                image: self.image,
                compute_type: self.compute_type,
                environment_variables: self.environment_variables,
                privileged_mode: self.privileged_mode,
                certificate: self.certificate,
                registry_credential: self.registry_credential,
                image_pull_credentials_type: self.image_pull_credentials_type,
            }
        }
    }
}
impl ProjectEnvironment {
    /// Creates a new builder-style object to manufacture [`ProjectEnvironment`](crate::model::ProjectEnvironment)
    pub fn builder() -> crate::model::project_environment::Builder {
        crate::model::project_environment::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ImagePullCredentialsType {
    #[allow(missing_docs)] // documentation missing in model
    Codebuild,
    #[allow(missing_docs)] // documentation missing in model
    ServiceRole,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ImagePullCredentialsType {
    fn from(s: &str) -> Self {
        match s {
            "CODEBUILD" => ImagePullCredentialsType::Codebuild,
            "SERVICE_ROLE" => ImagePullCredentialsType::ServiceRole,
            other => ImagePullCredentialsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ImagePullCredentialsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ImagePullCredentialsType::from(s))
    }
}
impl ImagePullCredentialsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ImagePullCredentialsType::Codebuild => "CODEBUILD",
            ImagePullCredentialsType::ServiceRole => "SERVICE_ROLE",
            ImagePullCredentialsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CODEBUILD", "SERVICE_ROLE"]
    }
}
impl AsRef<str> for ImagePullCredentialsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about credentials that provide access to a private Docker registry. When
/// this is set: </p>
/// <ul>
/// <li>
/// <p>
/// <code>imagePullCredentialsType</code> must be set to <code>SERVICE_ROLE</code>.
/// </p>
/// </li>
/// <li>
/// <p> images cannot be curated or an Amazon ECR image.</p>
/// </li>
/// </ul>
/// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-private-registry.html">Private Registry with
/// Secrets Manager Sample for CodeBuild</a>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegistryCredential {
    /// <p> The Amazon Resource Name (ARN) or name of credentials created using Secrets Manager. </p>
    /// <note>
    /// <p> The <code>credential</code> can use the name of the credentials only if they
    /// exist in your current Amazon Web Services Region. </p>
    /// </note>
    pub credential: std::option::Option<std::string::String>,
    /// <p> The service that created the credentials to access a private Docker registry. The
    /// valid value, SECRETS_MANAGER, is for Secrets Manager. </p>
    pub credential_provider: std::option::Option<crate::model::CredentialProviderType>,
}
impl RegistryCredential {
    /// <p> The Amazon Resource Name (ARN) or name of credentials created using Secrets Manager. </p>
    /// <note>
    /// <p> The <code>credential</code> can use the name of the credentials only if they
    /// exist in your current Amazon Web Services Region. </p>
    /// </note>
    pub fn credential(&self) -> std::option::Option<&str> {
        self.credential.as_deref()
    }
    /// <p> The service that created the credentials to access a private Docker registry. The
    /// valid value, SECRETS_MANAGER, is for Secrets Manager. </p>
    pub fn credential_provider(
        &self,
    ) -> std::option::Option<&crate::model::CredentialProviderType> {
        self.credential_provider.as_ref()
    }
}
impl std::fmt::Debug for RegistryCredential {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegistryCredential");
        formatter.field("credential", &self.credential);
        formatter.field("credential_provider", &self.credential_provider);
        formatter.finish()
    }
}
/// See [`RegistryCredential`](crate::model::RegistryCredential)
pub mod registry_credential {
    /// A builder for [`RegistryCredential`](crate::model::RegistryCredential)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) credential: std::option::Option<std::string::String>,
        pub(crate) credential_provider: std::option::Option<crate::model::CredentialProviderType>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) or name of credentials created using Secrets Manager. </p>
        /// <note>
        /// <p> The <code>credential</code> can use the name of the credentials only if they
        /// exist in your current Amazon Web Services Region. </p>
        /// </note>
        pub fn credential(mut self, input: impl Into<std::string::String>) -> Self {
            self.credential = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) or name of credentials created using Secrets Manager. </p>
        /// <note>
        /// <p> The <code>credential</code> can use the name of the credentials only if they
        /// exist in your current Amazon Web Services Region. </p>
        /// </note>
        pub fn set_credential(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.credential = input;
            self
        }
        /// <p> The service that created the credentials to access a private Docker registry. The
        /// valid value, SECRETS_MANAGER, is for Secrets Manager. </p>
        pub fn credential_provider(mut self, input: crate::model::CredentialProviderType) -> Self {
            self.credential_provider = Some(input);
            self
        }
        /// <p> The service that created the credentials to access a private Docker registry. The
        /// valid value, SECRETS_MANAGER, is for Secrets Manager. </p>
        pub fn set_credential_provider(
            mut self,
            input: std::option::Option<crate::model::CredentialProviderType>,
        ) -> Self {
            self.credential_provider = input;
            self
        }
        /// Consumes the builder and constructs a [`RegistryCredential`](crate::model::RegistryCredential)
        pub fn build(self) -> crate::model::RegistryCredential {
            crate::model::RegistryCredential {
                credential: self.credential,
                credential_provider: self.credential_provider,
            }
        }
    }
}
impl RegistryCredential {
    /// Creates a new builder-style object to manufacture [`RegistryCredential`](crate::model::RegistryCredential)
    pub fn builder() -> crate::model::registry_credential::Builder {
        crate::model::registry_credential::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CredentialProviderType {
    #[allow(missing_docs)] // documentation missing in model
    SecretsManager,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CredentialProviderType {
    fn from(s: &str) -> Self {
        match s {
            "SECRETS_MANAGER" => CredentialProviderType::SecretsManager,
            other => CredentialProviderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CredentialProviderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CredentialProviderType::from(s))
    }
}
impl CredentialProviderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CredentialProviderType::SecretsManager => "SECRETS_MANAGER",
            CredentialProviderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SECRETS_MANAGER"]
    }
}
impl AsRef<str> for CredentialProviderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about an environment variable for a build project or a build.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentVariable {
    /// <p>The name or key of the environment variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the environment variable.</p>
    /// <important>
    /// <p>We strongly discourage the use of <code>PLAINTEXT</code> environment variables to
    /// store sensitive values, especially Amazon Web Services secret key IDs and secret access keys.
    /// <code>PLAINTEXT</code> environment variables can be displayed in plain text
    /// using the CodeBuild console and the CLI. For sensitive values, we recommend you use an
    /// environment variable of type <code>PARAMETER_STORE</code> or
    /// <code>SECRETS_MANAGER</code>. </p>
    /// </important>
    pub value: std::option::Option<std::string::String>,
    /// <p>The type of environment variable. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PARAMETER_STORE</code>: An environment variable stored in Systems Manager
    /// Parameter Store. To learn how to specify a parameter store environment variable,
    /// see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.parameter-store">env/parameter-store</a> in the
    /// <i>CodeBuild User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAINTEXT</code>: An environment variable in plain text format. This is
    /// the default value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SECRETS_MANAGER</code>: An environment variable stored in Secrets Manager. To learn how to specify a secrets manager environment variable, see
    /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.secrets-manager">env/secrets-manager</a> in the
    /// <i>CodeBuild User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::EnvironmentVariableType>,
}
impl EnvironmentVariable {
    /// <p>The name or key of the environment variable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the environment variable.</p>
    /// <important>
    /// <p>We strongly discourage the use of <code>PLAINTEXT</code> environment variables to
    /// store sensitive values, especially Amazon Web Services secret key IDs and secret access keys.
    /// <code>PLAINTEXT</code> environment variables can be displayed in plain text
    /// using the CodeBuild console and the CLI. For sensitive values, we recommend you use an
    /// environment variable of type <code>PARAMETER_STORE</code> or
    /// <code>SECRETS_MANAGER</code>. </p>
    /// </important>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The type of environment variable. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PARAMETER_STORE</code>: An environment variable stored in Systems Manager
    /// Parameter Store. To learn how to specify a parameter store environment variable,
    /// see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.parameter-store">env/parameter-store</a> in the
    /// <i>CodeBuild User Guide</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAINTEXT</code>: An environment variable in plain text format. This is
    /// the default value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SECRETS_MANAGER</code>: An environment variable stored in Secrets Manager. To learn how to specify a secrets manager environment variable, see
    /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.secrets-manager">env/secrets-manager</a> in the
    /// <i>CodeBuild User Guide</i>.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::EnvironmentVariableType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for EnvironmentVariable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentVariable");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`EnvironmentVariable`](crate::model::EnvironmentVariable)
pub mod environment_variable {
    /// A builder for [`EnvironmentVariable`](crate::model::EnvironmentVariable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::EnvironmentVariableType>,
    }
    impl Builder {
        /// <p>The name or key of the environment variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name or key of the environment variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the environment variable.</p>
        /// <important>
        /// <p>We strongly discourage the use of <code>PLAINTEXT</code> environment variables to
        /// store sensitive values, especially Amazon Web Services secret key IDs and secret access keys.
        /// <code>PLAINTEXT</code> environment variables can be displayed in plain text
        /// using the CodeBuild console and the CLI. For sensitive values, we recommend you use an
        /// environment variable of type <code>PARAMETER_STORE</code> or
        /// <code>SECRETS_MANAGER</code>. </p>
        /// </important>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the environment variable.</p>
        /// <important>
        /// <p>We strongly discourage the use of <code>PLAINTEXT</code> environment variables to
        /// store sensitive values, especially Amazon Web Services secret key IDs and secret access keys.
        /// <code>PLAINTEXT</code> environment variables can be displayed in plain text
        /// using the CodeBuild console and the CLI. For sensitive values, we recommend you use an
        /// environment variable of type <code>PARAMETER_STORE</code> or
        /// <code>SECRETS_MANAGER</code>. </p>
        /// </important>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The type of environment variable. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PARAMETER_STORE</code>: An environment variable stored in Systems Manager
        /// Parameter Store. To learn how to specify a parameter store environment variable,
        /// see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.parameter-store">env/parameter-store</a> in the
        /// <i>CodeBuild User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAINTEXT</code>: An environment variable in plain text format. This is
        /// the default value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SECRETS_MANAGER</code>: An environment variable stored in Secrets Manager. To learn how to specify a secrets manager environment variable, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.secrets-manager">env/secrets-manager</a> in the
        /// <i>CodeBuild User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::EnvironmentVariableType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of environment variable. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PARAMETER_STORE</code>: An environment variable stored in Systems Manager
        /// Parameter Store. To learn how to specify a parameter store environment variable,
        /// see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.parameter-store">env/parameter-store</a> in the
        /// <i>CodeBuild User Guide</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAINTEXT</code>: An environment variable in plain text format. This is
        /// the default value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SECRETS_MANAGER</code>: An environment variable stored in Secrets Manager. To learn how to specify a secrets manager environment variable, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec.env.secrets-manager">env/secrets-manager</a> in the
        /// <i>CodeBuild User Guide</i>.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::EnvironmentVariableType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentVariable`](crate::model::EnvironmentVariable)
        pub fn build(self) -> crate::model::EnvironmentVariable {
            crate::model::EnvironmentVariable {
                name: self.name,
                value: self.value,
                r#type: self.r#type,
            }
        }
    }
}
impl EnvironmentVariable {
    /// Creates a new builder-style object to manufacture [`EnvironmentVariable`](crate::model::EnvironmentVariable)
    pub fn builder() -> crate::model::environment_variable::Builder {
        crate::model::environment_variable::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentVariableType {
    #[allow(missing_docs)] // documentation missing in model
    ParameterStore,
    #[allow(missing_docs)] // documentation missing in model
    Plaintext,
    #[allow(missing_docs)] // documentation missing in model
    SecretsManager,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentVariableType {
    fn from(s: &str) -> Self {
        match s {
            "PARAMETER_STORE" => EnvironmentVariableType::ParameterStore,
            "PLAINTEXT" => EnvironmentVariableType::Plaintext,
            "SECRETS_MANAGER" => EnvironmentVariableType::SecretsManager,
            other => EnvironmentVariableType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentVariableType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentVariableType::from(s))
    }
}
impl EnvironmentVariableType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentVariableType::ParameterStore => "PARAMETER_STORE",
            EnvironmentVariableType::Plaintext => "PLAINTEXT",
            EnvironmentVariableType::SecretsManager => "SECRETS_MANAGER",
            EnvironmentVariableType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PARAMETER_STORE", "PLAINTEXT", "SECRETS_MANAGER"]
    }
}
impl AsRef<str> for EnvironmentVariableType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComputeType {
    #[allow(missing_docs)] // documentation missing in model
    BuildGeneral12Xlarge,
    #[allow(missing_docs)] // documentation missing in model
    BuildGeneral1Large,
    #[allow(missing_docs)] // documentation missing in model
    BuildGeneral1Medium,
    #[allow(missing_docs)] // documentation missing in model
    BuildGeneral1Small,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComputeType {
    fn from(s: &str) -> Self {
        match s {
            "BUILD_GENERAL1_2XLARGE" => ComputeType::BuildGeneral12Xlarge,
            "BUILD_GENERAL1_LARGE" => ComputeType::BuildGeneral1Large,
            "BUILD_GENERAL1_MEDIUM" => ComputeType::BuildGeneral1Medium,
            "BUILD_GENERAL1_SMALL" => ComputeType::BuildGeneral1Small,
            other => ComputeType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComputeType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComputeType::from(s))
    }
}
impl ComputeType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComputeType::BuildGeneral12Xlarge => "BUILD_GENERAL1_2XLARGE",
            ComputeType::BuildGeneral1Large => "BUILD_GENERAL1_LARGE",
            ComputeType::BuildGeneral1Medium => "BUILD_GENERAL1_MEDIUM",
            ComputeType::BuildGeneral1Small => "BUILD_GENERAL1_SMALL",
            ComputeType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BUILD_GENERAL1_2XLARGE",
            "BUILD_GENERAL1_LARGE",
            "BUILD_GENERAL1_MEDIUM",
            "BUILD_GENERAL1_SMALL",
        ]
    }
}
impl AsRef<str> for ComputeType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EnvironmentType {
    #[allow(missing_docs)] // documentation missing in model
    ArmContainer,
    #[allow(missing_docs)] // documentation missing in model
    LinuxContainer,
    #[allow(missing_docs)] // documentation missing in model
    LinuxGpuContainer,
    #[allow(missing_docs)] // documentation missing in model
    WindowsContainer,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer2019Container,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EnvironmentType {
    fn from(s: &str) -> Self {
        match s {
            "ARM_CONTAINER" => EnvironmentType::ArmContainer,
            "LINUX_CONTAINER" => EnvironmentType::LinuxContainer,
            "LINUX_GPU_CONTAINER" => EnvironmentType::LinuxGpuContainer,
            "WINDOWS_CONTAINER" => EnvironmentType::WindowsContainer,
            "WINDOWS_SERVER_2019_CONTAINER" => EnvironmentType::WindowsServer2019Container,
            other => EnvironmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EnvironmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EnvironmentType::from(s))
    }
}
impl EnvironmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EnvironmentType::ArmContainer => "ARM_CONTAINER",
            EnvironmentType::LinuxContainer => "LINUX_CONTAINER",
            EnvironmentType::LinuxGpuContainer => "LINUX_GPU_CONTAINER",
            EnvironmentType::WindowsContainer => "WINDOWS_CONTAINER",
            EnvironmentType::WindowsServer2019Container => "WINDOWS_SERVER_2019_CONTAINER",
            EnvironmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ARM_CONTAINER",
            "LINUX_CONTAINER",
            "LINUX_GPU_CONTAINER",
            "WINDOWS_CONTAINER",
            "WINDOWS_SERVER_2019_CONTAINER",
        ]
    }
}
impl AsRef<str> for EnvironmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the cache for the build project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectCache {
    /// <p>The type of cache used by the build project. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NO_CACHE</code>: The build project does not use any cache.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: The build project reads and writes from and to S3.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCAL</code>: The build project stores a cache locally on a build host
    /// that is only available to that build host.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::CacheType>,
    /// <p>Information about the cache location: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NO_CACHE</code> or <code>LOCAL</code>: This value is ignored.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: This is the S3 bucket name/prefix.</p>
    /// </li>
    /// </ul>
    pub location: std::option::Option<std::string::String>,
    /// <p>An array of strings that specify the local cache modes. You can use one or more local
    /// cache modes at the same time. This is only used for <code>LOCAL</code> cache
    /// types.</p>
    /// <p>Possible values are:</p>
    /// <dl>
    /// <dt>LOCAL_SOURCE_CACHE</dt>
    /// <dd>
    /// <p>Caches Git metadata for primary and secondary sources. After the cache is
    /// created, subsequent builds pull only the change between commits. This mode
    /// is a good choice for projects with a clean working directory and a source
    /// that is a large Git repository. If you choose this option and your project
    /// does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the
    /// option is ignored. </p>
    /// </dd>
    /// <dt>LOCAL_DOCKER_LAYER_CACHE</dt>
    /// <dd>
    /// <p>Caches existing Docker layers. This mode is a good choice for projects
    /// that build or pull large Docker images. It can prevent the performance
    /// issues caused by pulling large Docker images down from the network. </p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You can use a Docker layer cache in the Linux environment
    /// only. </p>
    /// </li>
    /// <li>
    /// <p>The <code>privileged</code> flag must be set so that your
    /// project has the required Docker permissions. </p>
    /// </li>
    /// <li>
    /// <p>You should consider the security implications before you use a
    /// Docker layer cache. </p>
    /// </li>
    /// </ul>
    /// </note>
    /// </dd>
    /// <dt>LOCAL_CUSTOM_CACHE</dt>
    /// <dd>
    /// <p>Caches directories you specify in the buildspec file. This mode is a good
    /// choice if your build scenario is not suited to one of the other three local
    /// cache modes. If you use a custom cache: </p>
    /// <ul>
    /// <li>
    /// <p>Only directories can be specified for caching. You cannot specify
    /// individual files. </p>
    /// </li>
    /// <li>
    /// <p>Symlinks are used to reference cached directories. </p>
    /// </li>
    /// <li>
    /// <p>Cached directories are linked to your build before it downloads
    /// its project sources. Cached items are overridden if a source item
    /// has the same name. Directories are specified using cache paths in
    /// the buildspec file. </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    pub modes: std::option::Option<std::vec::Vec<crate::model::CacheMode>>,
}
impl ProjectCache {
    /// <p>The type of cache used by the build project. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NO_CACHE</code>: The build project does not use any cache.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: The build project reads and writes from and to S3.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>LOCAL</code>: The build project stores a cache locally on a build host
    /// that is only available to that build host.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CacheType> {
        self.r#type.as_ref()
    }
    /// <p>Information about the cache location: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NO_CACHE</code> or <code>LOCAL</code>: This value is ignored.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: This is the S3 bucket name/prefix.</p>
    /// </li>
    /// </ul>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>An array of strings that specify the local cache modes. You can use one or more local
    /// cache modes at the same time. This is only used for <code>LOCAL</code> cache
    /// types.</p>
    /// <p>Possible values are:</p>
    /// <dl>
    /// <dt>LOCAL_SOURCE_CACHE</dt>
    /// <dd>
    /// <p>Caches Git metadata for primary and secondary sources. After the cache is
    /// created, subsequent builds pull only the change between commits. This mode
    /// is a good choice for projects with a clean working directory and a source
    /// that is a large Git repository. If you choose this option and your project
    /// does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the
    /// option is ignored. </p>
    /// </dd>
    /// <dt>LOCAL_DOCKER_LAYER_CACHE</dt>
    /// <dd>
    /// <p>Caches existing Docker layers. This mode is a good choice for projects
    /// that build or pull large Docker images. It can prevent the performance
    /// issues caused by pulling large Docker images down from the network. </p>
    /// <note>
    /// <ul>
    /// <li>
    /// <p>You can use a Docker layer cache in the Linux environment
    /// only. </p>
    /// </li>
    /// <li>
    /// <p>The <code>privileged</code> flag must be set so that your
    /// project has the required Docker permissions. </p>
    /// </li>
    /// <li>
    /// <p>You should consider the security implications before you use a
    /// Docker layer cache. </p>
    /// </li>
    /// </ul>
    /// </note>
    /// </dd>
    /// <dt>LOCAL_CUSTOM_CACHE</dt>
    /// <dd>
    /// <p>Caches directories you specify in the buildspec file. This mode is a good
    /// choice if your build scenario is not suited to one of the other three local
    /// cache modes. If you use a custom cache: </p>
    /// <ul>
    /// <li>
    /// <p>Only directories can be specified for caching. You cannot specify
    /// individual files. </p>
    /// </li>
    /// <li>
    /// <p>Symlinks are used to reference cached directories. </p>
    /// </li>
    /// <li>
    /// <p>Cached directories are linked to your build before it downloads
    /// its project sources. Cached items are overridden if a source item
    /// has the same name. Directories are specified using cache paths in
    /// the buildspec file. </p>
    /// </li>
    /// </ul>
    /// </dd>
    /// </dl>
    pub fn modes(&self) -> std::option::Option<&[crate::model::CacheMode]> {
        self.modes.as_deref()
    }
}
impl std::fmt::Debug for ProjectCache {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectCache");
        formatter.field("r#type", &self.r#type);
        formatter.field("location", &self.location);
        formatter.field("modes", &self.modes);
        formatter.finish()
    }
}
/// See [`ProjectCache`](crate::model::ProjectCache)
pub mod project_cache {
    /// A builder for [`ProjectCache`](crate::model::ProjectCache)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::CacheType>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) modes: std::option::Option<std::vec::Vec<crate::model::CacheMode>>,
    }
    impl Builder {
        /// <p>The type of cache used by the build project. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NO_CACHE</code>: The build project does not use any cache.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: The build project reads and writes from and to S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCAL</code>: The build project stores a cache locally on a build host
        /// that is only available to that build host.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::CacheType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of cache used by the build project. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NO_CACHE</code>: The build project does not use any cache.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: The build project reads and writes from and to S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LOCAL</code>: The build project stores a cache locally on a build host
        /// that is only available to that build host.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::CacheType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Information about the cache location: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NO_CACHE</code> or <code>LOCAL</code>: This value is ignored.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: This is the S3 bucket name/prefix.</p>
        /// </li>
        /// </ul>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>Information about the cache location: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NO_CACHE</code> or <code>LOCAL</code>: This value is ignored.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: This is the S3 bucket name/prefix.</p>
        /// </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// Appends an item to `modes`.
        ///
        /// To override the contents of this collection use [`set_modes`](Self::set_modes).
        ///
        /// <p>An array of strings that specify the local cache modes. You can use one or more local
        /// cache modes at the same time. This is only used for <code>LOCAL</code> cache
        /// types.</p>
        /// <p>Possible values are:</p>
        /// <dl>
        /// <dt>LOCAL_SOURCE_CACHE</dt>
        /// <dd>
        /// <p>Caches Git metadata for primary and secondary sources. After the cache is
        /// created, subsequent builds pull only the change between commits. This mode
        /// is a good choice for projects with a clean working directory and a source
        /// that is a large Git repository. If you choose this option and your project
        /// does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the
        /// option is ignored. </p>
        /// </dd>
        /// <dt>LOCAL_DOCKER_LAYER_CACHE</dt>
        /// <dd>
        /// <p>Caches existing Docker layers. This mode is a good choice for projects
        /// that build or pull large Docker images. It can prevent the performance
        /// issues caused by pulling large Docker images down from the network. </p>
        /// <note>
        /// <ul>
        /// <li>
        /// <p>You can use a Docker layer cache in the Linux environment
        /// only. </p>
        /// </li>
        /// <li>
        /// <p>The <code>privileged</code> flag must be set so that your
        /// project has the required Docker permissions. </p>
        /// </li>
        /// <li>
        /// <p>You should consider the security implications before you use a
        /// Docker layer cache. </p>
        /// </li>
        /// </ul>
        /// </note>
        /// </dd>
        /// <dt>LOCAL_CUSTOM_CACHE</dt>
        /// <dd>
        /// <p>Caches directories you specify in the buildspec file. This mode is a good
        /// choice if your build scenario is not suited to one of the other three local
        /// cache modes. If you use a custom cache: </p>
        /// <ul>
        /// <li>
        /// <p>Only directories can be specified for caching. You cannot specify
        /// individual files. </p>
        /// </li>
        /// <li>
        /// <p>Symlinks are used to reference cached directories. </p>
        /// </li>
        /// <li>
        /// <p>Cached directories are linked to your build before it downloads
        /// its project sources. Cached items are overridden if a source item
        /// has the same name. Directories are specified using cache paths in
        /// the buildspec file. </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        pub fn modes(mut self, input: impl Into<crate::model::CacheMode>) -> Self {
            let mut v = self.modes.unwrap_or_default();
            v.push(input.into());
            self.modes = Some(v);
            self
        }
        /// <p>An array of strings that specify the local cache modes. You can use one or more local
        /// cache modes at the same time. This is only used for <code>LOCAL</code> cache
        /// types.</p>
        /// <p>Possible values are:</p>
        /// <dl>
        /// <dt>LOCAL_SOURCE_CACHE</dt>
        /// <dd>
        /// <p>Caches Git metadata for primary and secondary sources. After the cache is
        /// created, subsequent builds pull only the change between commits. This mode
        /// is a good choice for projects with a clean working directory and a source
        /// that is a large Git repository. If you choose this option and your project
        /// does not use a Git repository (GitHub, GitHub Enterprise, or Bitbucket), the
        /// option is ignored. </p>
        /// </dd>
        /// <dt>LOCAL_DOCKER_LAYER_CACHE</dt>
        /// <dd>
        /// <p>Caches existing Docker layers. This mode is a good choice for projects
        /// that build or pull large Docker images. It can prevent the performance
        /// issues caused by pulling large Docker images down from the network. </p>
        /// <note>
        /// <ul>
        /// <li>
        /// <p>You can use a Docker layer cache in the Linux environment
        /// only. </p>
        /// </li>
        /// <li>
        /// <p>The <code>privileged</code> flag must be set so that your
        /// project has the required Docker permissions. </p>
        /// </li>
        /// <li>
        /// <p>You should consider the security implications before you use a
        /// Docker layer cache. </p>
        /// </li>
        /// </ul>
        /// </note>
        /// </dd>
        /// <dt>LOCAL_CUSTOM_CACHE</dt>
        /// <dd>
        /// <p>Caches directories you specify in the buildspec file. This mode is a good
        /// choice if your build scenario is not suited to one of the other three local
        /// cache modes. If you use a custom cache: </p>
        /// <ul>
        /// <li>
        /// <p>Only directories can be specified for caching. You cannot specify
        /// individual files. </p>
        /// </li>
        /// <li>
        /// <p>Symlinks are used to reference cached directories. </p>
        /// </li>
        /// <li>
        /// <p>Cached directories are linked to your build before it downloads
        /// its project sources. Cached items are overridden if a source item
        /// has the same name. Directories are specified using cache paths in
        /// the buildspec file. </p>
        /// </li>
        /// </ul>
        /// </dd>
        /// </dl>
        pub fn set_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheMode>>,
        ) -> Self {
            self.modes = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectCache`](crate::model::ProjectCache)
        pub fn build(self) -> crate::model::ProjectCache {
            crate::model::ProjectCache {
                r#type: self.r#type,
                location: self.location,
                modes: self.modes,
            }
        }
    }
}
impl ProjectCache {
    /// Creates a new builder-style object to manufacture [`ProjectCache`](crate::model::ProjectCache)
    pub fn builder() -> crate::model::project_cache::Builder {
        crate::model::project_cache::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CacheMode {
    #[allow(missing_docs)] // documentation missing in model
    LocalCustomCache,
    #[allow(missing_docs)] // documentation missing in model
    LocalDockerLayerCache,
    #[allow(missing_docs)] // documentation missing in model
    LocalSourceCache,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CacheMode {
    fn from(s: &str) -> Self {
        match s {
            "LOCAL_CUSTOM_CACHE" => CacheMode::LocalCustomCache,
            "LOCAL_DOCKER_LAYER_CACHE" => CacheMode::LocalDockerLayerCache,
            "LOCAL_SOURCE_CACHE" => CacheMode::LocalSourceCache,
            other => CacheMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CacheMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CacheMode::from(s))
    }
}
impl CacheMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CacheMode::LocalCustomCache => "LOCAL_CUSTOM_CACHE",
            CacheMode::LocalDockerLayerCache => "LOCAL_DOCKER_LAYER_CACHE",
            CacheMode::LocalSourceCache => "LOCAL_SOURCE_CACHE",
            CacheMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "LOCAL_CUSTOM_CACHE",
            "LOCAL_DOCKER_LAYER_CACHE",
            "LOCAL_SOURCE_CACHE",
        ]
    }
}
impl AsRef<str> for CacheMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CacheType {
    #[allow(missing_docs)] // documentation missing in model
    Local,
    #[allow(missing_docs)] // documentation missing in model
    NoCache,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CacheType {
    fn from(s: &str) -> Self {
        match s {
            "LOCAL" => CacheType::Local,
            "NO_CACHE" => CacheType::NoCache,
            "S3" => CacheType::S3,
            other => CacheType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CacheType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CacheType::from(s))
    }
}
impl CacheType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CacheType::Local => "LOCAL",
            CacheType::NoCache => "NO_CACHE",
            CacheType::S3 => "S3",
            CacheType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOCAL", "NO_CACHE", "S3"]
    }
}
impl AsRef<str> for CacheType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about the build output artifacts for the build project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectArtifacts {
    /// <p>The type of build output artifact. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CODEPIPELINE</code>: The build project has build output generated
    /// through CodePipeline. </p>
    /// <note>
    /// <p>The <code>CODEPIPELINE</code> type is not supported for
    /// <code>secondaryArtifacts</code>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NO_ARTIFACTS</code>: The build project does not produce any build
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: The build project stores build output in Amazon S3.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::ArtifactsType>,
    /// <p>Information about the build output artifact location:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output locations
    /// instead of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
    /// bucket.</p>
    /// </li>
    /// </ul>
    pub location: std::option::Option<std::string::String>,
    /// <p>Along with <code>namespaceType</code> and <code>name</code>, the pattern that CodeBuild
    /// uses to name and store the output artifact:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output names instead
    /// of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, this is the path to the output
    /// artifact. If <code>path</code> is not specified, <code>path</code> is not
    /// used.</p>
    /// </li>
    /// </ul>
    /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>NONE</code>, and <code>name</code> is set
    /// to <code>MyArtifact.zip</code>, the output artifact is stored in the output bucket at
    /// <code>MyArtifacts/MyArtifact.zip</code>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Along with <code>path</code> and <code>name</code>, the pattern that CodeBuild uses to
    /// determine the name and location to store the output artifact:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output names instead
    /// of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BUILD_ID</code>: Include the build ID in the location of the
    /// build output artifact.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not include the build ID. This is the default if
    /// <code>namespaceType</code> is not specified.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and <code>name</code> is
    /// set to <code>MyArtifact.zip</code>, the output artifact is stored in
    /// <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>.</p>
    pub namespace_type: std::option::Option<crate::model::ArtifactNamespace>,
    /// <p>Along with <code>path</code> and <code>namespaceType</code>, the pattern that CodeBuild
    /// uses to name and store the output artifact:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output names instead
    /// of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
    /// artifact object. If you set the name to be a forward slash ("/"), the artifact
    /// is stored in the root of the output bucket.</p>
    /// </li>
    /// </ul>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
    /// <code>name</code> is set to <code>MyArtifact.zip</code>, then the output
    /// artifact is stored in <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>. </p>
    /// </li>
    /// <li>
    /// <p> If <code>path</code> is empty, <code>namespaceType</code> is set to
    /// <code>NONE</code>, and <code>name</code> is set to "<code>/</code>", the
    /// output artifact is stored in the root of the output bucket. </p>
    /// </li>
    /// <li>
    /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
    /// <code>name</code> is set to "<code>/</code>", the output artifact is stored
    /// in <code>MyArtifacts/<build-ID></code>. </p>
    /// </li>
    /// </ul>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of build output artifact to create:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output artifacts
    /// instead of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: CodeBuild creates in the output bucket a folder that
    /// contains the build output. This is the default if <code>packaging</code>
    /// is not specified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ZIP</code>: CodeBuild creates in the output bucket a ZIP file that
    /// contains the build output.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub packaging: std::option::Option<crate::model::ArtifactPackaging>,
    /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
    /// name. The name specified in a buildspec file is calculated at build time and uses the
    /// Shell Command Language. For example, you can append a date and time to your artifact
    /// name so that it is always unique. </p>
    pub override_artifact_name: std::option::Option<bool>,
    /// <p> Set to true if you do not want your output artifacts encrypted. This option is valid
    /// only if your artifacts type is Amazon S3. If this is set with another artifacts type, an
    /// invalidInputException is thrown. </p>
    pub encryption_disabled: std::option::Option<bool>,
    /// <p> An identifier for this artifact definition. </p>
    pub artifact_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket owner's access for objects that another account uploads to their
    /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
    /// access to these objects. This property allows you to give the bucket owner access to
    /// these objects.</p>
    /// <note>
    /// <p>To use this property, your CodeBuild service role must have the
    /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
    /// the access control list for the bucket.</p>
    /// </note>
    /// <p>This property can be one of the following values:</p>
    /// <dl>
    /// <dt>NONE</dt>
    /// <dd>
    /// <p>The bucket owner does not have access to the objects. This is the
    /// default.</p>
    /// </dd>
    /// <dt>READ_ONLY</dt>
    /// <dd>
    /// <p>The bucket owner has read-only access to the objects. The uploading account
    /// retains ownership of the objects.</p>
    /// </dd>
    /// <dt>FULL</dt>
    /// <dd>
    /// <p>The bucket owner has full access to the objects. Object ownership is determined
    /// by the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>If the bucket is configured with the <b>Bucket
    /// owner preferred</b> setting, the bucket owner owns the
    /// objects. The uploading account will have object access as specified
    /// by the bucket's policy.</p>
    /// </li>
    /// <li>
    /// <p>Otherwise, the uploading account retains ownership of the
    /// objects.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
    /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
    /// Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub bucket_owner_access: std::option::Option<crate::model::BucketOwnerAccess>,
}
impl ProjectArtifacts {
    /// <p>The type of build output artifact. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CODEPIPELINE</code>: The build project has build output generated
    /// through CodePipeline. </p>
    /// <note>
    /// <p>The <code>CODEPIPELINE</code> type is not supported for
    /// <code>secondaryArtifacts</code>.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NO_ARTIFACTS</code>: The build project does not produce any build
    /// output.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: The build project stores build output in Amazon S3.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ArtifactsType> {
        self.r#type.as_ref()
    }
    /// <p>Information about the build output artifact location:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output locations
    /// instead of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
    /// bucket.</p>
    /// </li>
    /// </ul>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>Along with <code>namespaceType</code> and <code>name</code>, the pattern that CodeBuild
    /// uses to name and store the output artifact:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output names instead
    /// of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, this is the path to the output
    /// artifact. If <code>path</code> is not specified, <code>path</code> is not
    /// used.</p>
    /// </li>
    /// </ul>
    /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>NONE</code>, and <code>name</code> is set
    /// to <code>MyArtifact.zip</code>, the output artifact is stored in the output bucket at
    /// <code>MyArtifacts/MyArtifact.zip</code>.</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Along with <code>path</code> and <code>name</code>, the pattern that CodeBuild uses to
    /// determine the name and location to store the output artifact:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output names instead
    /// of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BUILD_ID</code>: Include the build ID in the location of the
    /// build output artifact.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NONE</code>: Do not include the build ID. This is the default if
    /// <code>namespaceType</code> is not specified.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and <code>name</code> is
    /// set to <code>MyArtifact.zip</code>, the output artifact is stored in
    /// <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>.</p>
    pub fn namespace_type(&self) -> std::option::Option<&crate::model::ArtifactNamespace> {
        self.namespace_type.as_ref()
    }
    /// <p>Along with <code>path</code> and <code>namespaceType</code>, the pattern that CodeBuild
    /// uses to name and store the output artifact:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output names instead
    /// of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
    /// artifact object. If you set the name to be a forward slash ("/"), the artifact
    /// is stored in the root of the output bucket.</p>
    /// </li>
    /// </ul>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
    /// <code>name</code> is set to <code>MyArtifact.zip</code>, then the output
    /// artifact is stored in <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>. </p>
    /// </li>
    /// <li>
    /// <p> If <code>path</code> is empty, <code>namespaceType</code> is set to
    /// <code>NONE</code>, and <code>name</code> is set to "<code>/</code>", the
    /// output artifact is stored in the root of the output bucket. </p>
    /// </li>
    /// <li>
    /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
    /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
    /// <code>name</code> is set to "<code>/</code>", the output artifact is stored
    /// in <code>MyArtifacts/<build-ID></code>. </p>
    /// </li>
    /// </ul>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of build output artifact to create:</p>
    /// <ul>
    /// <li>
    /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
    /// value if specified. This is because CodePipeline manages its build output artifacts
    /// instead of CodeBuild.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
    /// ignored if specified, because no build output is produced.</p>
    /// </li>
    /// <li>
    /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>NONE</code>: CodeBuild creates in the output bucket a folder that
    /// contains the build output. This is the default if <code>packaging</code>
    /// is not specified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ZIP</code>: CodeBuild creates in the output bucket a ZIP file that
    /// contains the build output.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub fn packaging(&self) -> std::option::Option<&crate::model::ArtifactPackaging> {
        self.packaging.as_ref()
    }
    /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
    /// name. The name specified in a buildspec file is calculated at build time and uses the
    /// Shell Command Language. For example, you can append a date and time to your artifact
    /// name so that it is always unique. </p>
    pub fn override_artifact_name(&self) -> std::option::Option<bool> {
        self.override_artifact_name
    }
    /// <p> Set to true if you do not want your output artifacts encrypted. This option is valid
    /// only if your artifacts type is Amazon S3. If this is set with another artifacts type, an
    /// invalidInputException is thrown. </p>
    pub fn encryption_disabled(&self) -> std::option::Option<bool> {
        self.encryption_disabled
    }
    /// <p> An identifier for this artifact definition. </p>
    pub fn artifact_identifier(&self) -> std::option::Option<&str> {
        self.artifact_identifier.as_deref()
    }
    /// <p>Specifies the bucket owner's access for objects that another account uploads to their
    /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
    /// access to these objects. This property allows you to give the bucket owner access to
    /// these objects.</p>
    /// <note>
    /// <p>To use this property, your CodeBuild service role must have the
    /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
    /// the access control list for the bucket.</p>
    /// </note>
    /// <p>This property can be one of the following values:</p>
    /// <dl>
    /// <dt>NONE</dt>
    /// <dd>
    /// <p>The bucket owner does not have access to the objects. This is the
    /// default.</p>
    /// </dd>
    /// <dt>READ_ONLY</dt>
    /// <dd>
    /// <p>The bucket owner has read-only access to the objects. The uploading account
    /// retains ownership of the objects.</p>
    /// </dd>
    /// <dt>FULL</dt>
    /// <dd>
    /// <p>The bucket owner has full access to the objects. Object ownership is determined
    /// by the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>If the bucket is configured with the <b>Bucket
    /// owner preferred</b> setting, the bucket owner owns the
    /// objects. The uploading account will have object access as specified
    /// by the bucket's policy.</p>
    /// </li>
    /// <li>
    /// <p>Otherwise, the uploading account retains ownership of the
    /// objects.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
    /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
    /// Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub fn bucket_owner_access(&self) -> std::option::Option<&crate::model::BucketOwnerAccess> {
        self.bucket_owner_access.as_ref()
    }
}
impl std::fmt::Debug for ProjectArtifacts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectArtifacts");
        formatter.field("r#type", &self.r#type);
        formatter.field("location", &self.location);
        formatter.field("path", &self.path);
        formatter.field("namespace_type", &self.namespace_type);
        formatter.field("name", &self.name);
        formatter.field("packaging", &self.packaging);
        formatter.field("override_artifact_name", &self.override_artifact_name);
        formatter.field("encryption_disabled", &self.encryption_disabled);
        formatter.field("artifact_identifier", &self.artifact_identifier);
        formatter.field("bucket_owner_access", &self.bucket_owner_access);
        formatter.finish()
    }
}
/// See [`ProjectArtifacts`](crate::model::ProjectArtifacts)
pub mod project_artifacts {
    /// A builder for [`ProjectArtifacts`](crate::model::ProjectArtifacts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ArtifactsType>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) namespace_type: std::option::Option<crate::model::ArtifactNamespace>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) packaging: std::option::Option<crate::model::ArtifactPackaging>,
        pub(crate) override_artifact_name: std::option::Option<bool>,
        pub(crate) encryption_disabled: std::option::Option<bool>,
        pub(crate) artifact_identifier: std::option::Option<std::string::String>,
        pub(crate) bucket_owner_access: std::option::Option<crate::model::BucketOwnerAccess>,
    }
    impl Builder {
        /// <p>The type of build output artifact. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CODEPIPELINE</code>: The build project has build output generated
        /// through CodePipeline. </p>
        /// <note>
        /// <p>The <code>CODEPIPELINE</code> type is not supported for
        /// <code>secondaryArtifacts</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_ARTIFACTS</code>: The build project does not produce any build
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: The build project stores build output in Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ArtifactsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of build output artifact. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CODEPIPELINE</code>: The build project has build output generated
        /// through CodePipeline. </p>
        /// <note>
        /// <p>The <code>CODEPIPELINE</code> type is not supported for
        /// <code>secondaryArtifacts</code>.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_ARTIFACTS</code>: The build project does not produce any build
        /// output.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: The build project stores build output in Amazon S3.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ArtifactsType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Information about the build output artifact location:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output locations
        /// instead of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
        /// bucket.</p>
        /// </li>
        /// </ul>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>Information about the build output artifact location:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output locations
        /// instead of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
        /// bucket.</p>
        /// </li>
        /// </ul>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>Along with <code>namespaceType</code> and <code>name</code>, the pattern that CodeBuild
        /// uses to name and store the output artifact:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output names instead
        /// of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, this is the path to the output
        /// artifact. If <code>path</code> is not specified, <code>path</code> is not
        /// used.</p>
        /// </li>
        /// </ul>
        /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>NONE</code>, and <code>name</code> is set
        /// to <code>MyArtifact.zip</code>, the output artifact is stored in the output bucket at
        /// <code>MyArtifacts/MyArtifact.zip</code>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>Along with <code>namespaceType</code> and <code>name</code>, the pattern that CodeBuild
        /// uses to name and store the output artifact:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output names instead
        /// of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, this is the path to the output
        /// artifact. If <code>path</code> is not specified, <code>path</code> is not
        /// used.</p>
        /// </li>
        /// </ul>
        /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>NONE</code>, and <code>name</code> is set
        /// to <code>MyArtifact.zip</code>, the output artifact is stored in the output bucket at
        /// <code>MyArtifacts/MyArtifact.zip</code>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Along with <code>path</code> and <code>name</code>, the pattern that CodeBuild uses to
        /// determine the name and location to store the output artifact:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output names instead
        /// of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BUILD_ID</code>: Include the build ID in the location of the
        /// build output artifact.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not include the build ID. This is the default if
        /// <code>namespaceType</code> is not specified.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and <code>name</code> is
        /// set to <code>MyArtifact.zip</code>, the output artifact is stored in
        /// <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>.</p>
        pub fn namespace_type(mut self, input: crate::model::ArtifactNamespace) -> Self {
            self.namespace_type = Some(input);
            self
        }
        /// <p>Along with <code>path</code> and <code>name</code>, the pattern that CodeBuild uses to
        /// determine the name and location to store the output artifact:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output names instead
        /// of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BUILD_ID</code>: Include the build ID in the location of the
        /// build output artifact.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NONE</code>: Do not include the build ID. This is the default if
        /// <code>namespaceType</code> is not specified.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        /// <p>For example, if <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and <code>name</code> is
        /// set to <code>MyArtifact.zip</code>, the output artifact is stored in
        /// <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>.</p>
        pub fn set_namespace_type(
            mut self,
            input: std::option::Option<crate::model::ArtifactNamespace>,
        ) -> Self {
            self.namespace_type = input;
            self
        }
        /// <p>Along with <code>path</code> and <code>namespaceType</code>, the pattern that CodeBuild
        /// uses to name and store the output artifact:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output names instead
        /// of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
        /// artifact object. If you set the name to be a forward slash ("/"), the artifact
        /// is stored in the root of the output bucket.</p>
        /// </li>
        /// </ul>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
        /// <code>name</code> is set to <code>MyArtifact.zip</code>, then the output
        /// artifact is stored in <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>. </p>
        /// </li>
        /// <li>
        /// <p> If <code>path</code> is empty, <code>namespaceType</code> is set to
        /// <code>NONE</code>, and <code>name</code> is set to "<code>/</code>", the
        /// output artifact is stored in the root of the output bucket. </p>
        /// </li>
        /// <li>
        /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
        /// <code>name</code> is set to "<code>/</code>", the output artifact is stored
        /// in <code>MyArtifacts/<build-ID></code>. </p>
        /// </li>
        /// </ul>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Along with <code>path</code> and <code>namespaceType</code>, the pattern that CodeBuild
        /// uses to name and store the output artifact:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output names instead
        /// of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, this is the name of the output
        /// artifact object. If you set the name to be a forward slash ("/"), the artifact
        /// is stored in the root of the output bucket.</p>
        /// </li>
        /// </ul>
        /// <p>For example:</p>
        /// <ul>
        /// <li>
        /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
        /// <code>name</code> is set to <code>MyArtifact.zip</code>, then the output
        /// artifact is stored in <code>MyArtifacts/<build-ID>/MyArtifact.zip</code>. </p>
        /// </li>
        /// <li>
        /// <p> If <code>path</code> is empty, <code>namespaceType</code> is set to
        /// <code>NONE</code>, and <code>name</code> is set to "<code>/</code>", the
        /// output artifact is stored in the root of the output bucket. </p>
        /// </li>
        /// <li>
        /// <p> If <code>path</code> is set to <code>MyArtifacts</code>,
        /// <code>namespaceType</code> is set to <code>BUILD_ID</code>, and
        /// <code>name</code> is set to "<code>/</code>", the output artifact is stored
        /// in <code>MyArtifacts/<build-ID></code>. </p>
        /// </li>
        /// </ul>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of build output artifact to create:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output artifacts
        /// instead of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: CodeBuild creates in the output bucket a folder that
        /// contains the build output. This is the default if <code>packaging</code>
        /// is not specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ZIP</code>: CodeBuild creates in the output bucket a ZIP file that
        /// contains the build output.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn packaging(mut self, input: crate::model::ArtifactPackaging) -> Self {
            self.packaging = Some(input);
            self
        }
        /// <p>The type of build output artifact to create:</p>
        /// <ul>
        /// <li>
        /// <p>If <code>type</code> is set to <code>CODEPIPELINE</code>, CodePipeline ignores this
        /// value if specified. This is because CodePipeline manages its build output artifacts
        /// instead of CodeBuild.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>NO_ARTIFACTS</code>, this value is
        /// ignored if specified, because no build output is produced.</p>
        /// </li>
        /// <li>
        /// <p>If <code>type</code> is set to <code>S3</code>, valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>NONE</code>: CodeBuild creates in the output bucket a folder that
        /// contains the build output. This is the default if <code>packaging</code>
        /// is not specified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ZIP</code>: CodeBuild creates in the output bucket a ZIP file that
        /// contains the build output.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_packaging(
            mut self,
            input: std::option::Option<crate::model::ArtifactPackaging>,
        ) -> Self {
            self.packaging = input;
            self
        }
        /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
        /// name. The name specified in a buildspec file is calculated at build time and uses the
        /// Shell Command Language. For example, you can append a date and time to your artifact
        /// name so that it is always unique. </p>
        pub fn override_artifact_name(mut self, input: bool) -> Self {
            self.override_artifact_name = Some(input);
            self
        }
        /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
        /// name. The name specified in a buildspec file is calculated at build time and uses the
        /// Shell Command Language. For example, you can append a date and time to your artifact
        /// name so that it is always unique. </p>
        pub fn set_override_artifact_name(mut self, input: std::option::Option<bool>) -> Self {
            self.override_artifact_name = input;
            self
        }
        /// <p> Set to true if you do not want your output artifacts encrypted. This option is valid
        /// only if your artifacts type is Amazon S3. If this is set with another artifacts type, an
        /// invalidInputException is thrown. </p>
        pub fn encryption_disabled(mut self, input: bool) -> Self {
            self.encryption_disabled = Some(input);
            self
        }
        /// <p> Set to true if you do not want your output artifacts encrypted. This option is valid
        /// only if your artifacts type is Amazon S3. If this is set with another artifacts type, an
        /// invalidInputException is thrown. </p>
        pub fn set_encryption_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.encryption_disabled = input;
            self
        }
        /// <p> An identifier for this artifact definition. </p>
        pub fn artifact_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_identifier = Some(input.into());
            self
        }
        /// <p> An identifier for this artifact definition. </p>
        pub fn set_artifact_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_identifier = input;
            self
        }
        /// <p>Specifies the bucket owner's access for objects that another account uploads to their
        /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
        /// access to these objects. This property allows you to give the bucket owner access to
        /// these objects.</p>
        /// <note>
        /// <p>To use this property, your CodeBuild service role must have the
        /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
        /// the access control list for the bucket.</p>
        /// </note>
        /// <p>This property can be one of the following values:</p>
        /// <dl>
        /// <dt>NONE</dt>
        /// <dd>
        /// <p>The bucket owner does not have access to the objects. This is the
        /// default.</p>
        /// </dd>
        /// <dt>READ_ONLY</dt>
        /// <dd>
        /// <p>The bucket owner has read-only access to the objects. The uploading account
        /// retains ownership of the objects.</p>
        /// </dd>
        /// <dt>FULL</dt>
        /// <dd>
        /// <p>The bucket owner has full access to the objects. Object ownership is determined
        /// by the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>If the bucket is configured with the <b>Bucket
        /// owner preferred</b> setting, the bucket owner owns the
        /// objects. The uploading account will have object access as specified
        /// by the bucket's policy.</p>
        /// </li>
        /// <li>
        /// <p>Otherwise, the uploading account retains ownership of the
        /// objects.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
        /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
        /// Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn bucket_owner_access(mut self, input: crate::model::BucketOwnerAccess) -> Self {
            self.bucket_owner_access = Some(input);
            self
        }
        /// <p>Specifies the bucket owner's access for objects that another account uploads to their
        /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
        /// access to these objects. This property allows you to give the bucket owner access to
        /// these objects.</p>
        /// <note>
        /// <p>To use this property, your CodeBuild service role must have the
        /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
        /// the access control list for the bucket.</p>
        /// </note>
        /// <p>This property can be one of the following values:</p>
        /// <dl>
        /// <dt>NONE</dt>
        /// <dd>
        /// <p>The bucket owner does not have access to the objects. This is the
        /// default.</p>
        /// </dd>
        /// <dt>READ_ONLY</dt>
        /// <dd>
        /// <p>The bucket owner has read-only access to the objects. The uploading account
        /// retains ownership of the objects.</p>
        /// </dd>
        /// <dt>FULL</dt>
        /// <dd>
        /// <p>The bucket owner has full access to the objects. Object ownership is determined
        /// by the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>If the bucket is configured with the <b>Bucket
        /// owner preferred</b> setting, the bucket owner owns the
        /// objects. The uploading account will have object access as specified
        /// by the bucket's policy.</p>
        /// </li>
        /// <li>
        /// <p>Otherwise, the uploading account retains ownership of the
        /// objects.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
        /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
        /// Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn set_bucket_owner_access(
            mut self,
            input: std::option::Option<crate::model::BucketOwnerAccess>,
        ) -> Self {
            self.bucket_owner_access = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectArtifacts`](crate::model::ProjectArtifacts)
        pub fn build(self) -> crate::model::ProjectArtifacts {
            crate::model::ProjectArtifacts {
                r#type: self.r#type,
                location: self.location,
                path: self.path,
                namespace_type: self.namespace_type,
                name: self.name,
                packaging: self.packaging,
                override_artifact_name: self.override_artifact_name,
                encryption_disabled: self.encryption_disabled,
                artifact_identifier: self.artifact_identifier,
                bucket_owner_access: self.bucket_owner_access,
            }
        }
    }
}
impl ProjectArtifacts {
    /// Creates a new builder-style object to manufacture [`ProjectArtifacts`](crate::model::ProjectArtifacts)
    pub fn builder() -> crate::model::project_artifacts::Builder {
        crate::model::project_artifacts::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactPackaging {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Zip,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactPackaging {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => ArtifactPackaging::None,
            "ZIP" => ArtifactPackaging::Zip,
            other => ArtifactPackaging::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactPackaging {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactPackaging::from(s))
    }
}
impl ArtifactPackaging {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactPackaging::None => "NONE",
            ArtifactPackaging::Zip => "ZIP",
            ArtifactPackaging::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "ZIP"]
    }
}
impl AsRef<str> for ArtifactPackaging {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactNamespace {
    #[allow(missing_docs)] // documentation missing in model
    BuildId,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactNamespace {
    fn from(s: &str) -> Self {
        match s {
            "BUILD_ID" => ArtifactNamespace::BuildId,
            "NONE" => ArtifactNamespace::None,
            other => ArtifactNamespace::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactNamespace {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactNamespace::from(s))
    }
}
impl ArtifactNamespace {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactNamespace::BuildId => "BUILD_ID",
            ArtifactNamespace::None => "NONE",
            ArtifactNamespace::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUILD_ID", "NONE"]
    }
}
impl AsRef<str> for ArtifactNamespace {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArtifactsType {
    #[allow(missing_docs)] // documentation missing in model
    Codepipeline,
    #[allow(missing_docs)] // documentation missing in model
    NoArtifacts,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArtifactsType {
    fn from(s: &str) -> Self {
        match s {
            "CODEPIPELINE" => ArtifactsType::Codepipeline,
            "NO_ARTIFACTS" => ArtifactsType::NoArtifacts,
            "S3" => ArtifactsType::S3,
            other => ArtifactsType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArtifactsType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArtifactsType::from(s))
    }
}
impl ArtifactsType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArtifactsType::Codepipeline => "CODEPIPELINE",
            ArtifactsType::NoArtifacts => "NO_ARTIFACTS",
            ArtifactsType::S3 => "S3",
            ArtifactsType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CODEPIPELINE", "NO_ARTIFACTS", "S3"]
    }
}
impl AsRef<str> for ArtifactsType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A source identifier and its corresponding version. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectSourceVersion {
    /// <p>An identifier for a source in the build project. The identifier can only contain
    /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>The source version for the corresponding source identifier. If specified, must be one
    /// of:</p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
    /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    pub source_version: std::option::Option<std::string::String>,
}
impl ProjectSourceVersion {
    /// <p>An identifier for a source in the build project. The identifier can only contain
    /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>The source version for the corresponding source identifier. If specified, must be one
    /// of:</p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
    /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
}
impl std::fmt::Debug for ProjectSourceVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectSourceVersion");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_version", &self.source_version);
        formatter.finish()
    }
}
/// See [`ProjectSourceVersion`](crate::model::ProjectSourceVersion)
pub mod project_source_version {
    /// A builder for [`ProjectSourceVersion`](crate::model::ProjectSourceVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for a source in the build project. The identifier can only contain
        /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>An identifier for a source in the build project. The identifier can only contain
        /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The source version for the corresponding source identifier. If specified, must be one
        /// of:</p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>The source version for the corresponding source identifier. If specified, must be one
        /// of:</p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectSourceVersion`](crate::model::ProjectSourceVersion)
        pub fn build(self) -> crate::model::ProjectSourceVersion {
            crate::model::ProjectSourceVersion {
                source_identifier: self.source_identifier,
                source_version: self.source_version,
            }
        }
    }
}
impl ProjectSourceVersion {
    /// Creates a new builder-style object to manufacture [`ProjectSourceVersion`](crate::model::ProjectSourceVersion)
    pub fn builder() -> crate::model::project_source_version::Builder {
        crate::model::project_source_version::Builder::default()
    }
}

/// <p>Information about the build input source code for the build project.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProjectSource {
    /// <p>The type of repository that contains the source code to be built. Valid values
    /// include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BITBUCKET</code>: The source code is in a Bitbucket repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CODECOMMIT</code>: The source code is in an CodeCommit repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CODEPIPELINE</code>: The source code settings are specified in the
    /// source action of a pipeline in CodePipeline.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GITHUB</code>: The source code is in a GitHub or GitHub Enterprise Cloud
    /// repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GITHUB_ENTERPRISE</code>: The source code is in a GitHub Enterprise
    /// Server repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NO_SOURCE</code>: The project does not have input source code.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: The source code is in an Amazon S3 bucket.</p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::SourceType>,
    /// <p>Information about the location of the source code to be built. Valid values
    /// include:</p>
    /// <ul>
    /// <li>
    /// <p>For source code settings that are specified in the source action of a pipeline
    /// in CodePipeline, <code>location</code> should not be specified. If it is specified,
    /// CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source
    /// action instead of this value.</p>
    /// </li>
    /// <li>
    /// <p>For source code in an CodeCommit repository, the HTTPS clone URL to the repository
    /// that contains the source code and the buildspec file (for example,
    /// <code>https://git-codecommit.<region-ID>.amazonaws.com/v1/repos/<repo-name></code>).</p>
    /// </li>
    /// <li>
    /// <p>For source code in an Amazon S3 input bucket, one of the following. </p>
    /// <ul>
    /// <li>
    /// <p>The path to the ZIP file that contains the source code (for example,
    /// <code><bucket-name>/<path>/<object-name>.zip</code>). </p>
    /// </li>
    /// <li>
    /// <p>The path to the folder that contains the source code (for example,
    /// <code><bucket-name>/<path-to-source-code>/<folder>/</code>). </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For source code in a GitHub repository, the HTTPS clone URL to the repository
    /// that contains the source and the buildspec file. You must connect your Amazon Web Services account
    /// to your GitHub account. Use the CodeBuild console to start creating a build
    /// project. When you use the console to connect (or reconnect) with GitHub, on the
    /// GitHub <b>Authorize application</b> page, for
    /// <b>Organization access</b>, choose <b>Request access</b> next to each repository you want to
    /// allow CodeBuild to have access to, and then choose <b>Authorize
    /// application</b>. (After you have connected to your GitHub account,
    /// you do not need to finish creating the build project. You can leave the CodeBuild
    /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
    /// object, set the <code>auth</code> object's <code>type</code> value to
    /// <code>OAUTH</code>.</p>
    /// </li>
    /// <li>
    /// <p>For source code in a Bitbucket repository, the HTTPS clone URL to the
    /// repository that contains the source and the buildspec file. You must connect
    /// your Amazon Web Services account to your Bitbucket account. Use the CodeBuild console to start
    /// creating a build project. When you use the console to connect (or reconnect)
    /// with Bitbucket, on the Bitbucket <b>Confirm access to your
    /// account</b> page, choose <b>Grant
    /// access</b>. (After you have connected to your Bitbucket account, you
    /// do not need to finish creating the build project. You can leave the CodeBuild
    /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
    /// object, set the <code>auth</code> object's <code>type</code> value to
    /// <code>OAUTH</code>.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// If you specify <code>CODEPIPELINE</code> for the <code>Type</code> property, don't specify this
    /// property. For all of the other types, you must specify <code>Location</code>.
    /// </p>
    pub location: std::option::Option<std::string::String>,
    /// <p>Information about the Git clone depth for the build project.</p>
    pub git_clone_depth: std::option::Option<i32>,
    /// <p> Information about the Git submodules configuration for the build project. </p>
    pub git_submodules_config: std::option::Option<crate::model::GitSubmodulesConfig>,
    /// <p>The buildspec file declaration to use for the builds in this build project.</p>
    /// <p> If this value is set, it can be either an inline buildspec definition, the path to an
    /// alternate buildspec file relative to the value of the built-in
    /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
    /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
    /// file using its ARN (for example,
    /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
    /// provided or is set to an empty string, the source code must contain a buildspec file in
    /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
    pub buildspec: std::option::Option<std::string::String>,
    /// <p>Information about the authorization settings for CodeBuild to access the source code to be
    /// built.</p>
    /// <p>This information is for the CodeBuild console's use only. Your code should not get or set
    /// this information directly.</p>
    pub auth: std::option::Option<crate::model::SourceAuth>,
    /// <p> Set to true to report the status of a build's start and finish to your source
    /// provider. This option is valid only when your source provider is GitHub, GitHub
    /// Enterprise, or Bitbucket. If this is set and you use a different source provider, an
    /// <code>invalidInputException</code> is thrown. </p>
    /// <p>To be able to report the build status to the source provider, the user associated with the source provider must
    /// have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p>
    /// <p>The status of a build triggered by a webhook is always reported to your source
    /// provider. </p>
    /// <p>If your project's builds are triggered by a webhook, you must push a
    /// new commit to the repo for a change to this property to take
    /// effect.</p>
    pub report_build_status: std::option::Option<bool>,
    /// <p>Contains information that defines how the build project reports the build status to
    /// the source provider. This option is only used when the source provider is
    /// <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
    /// <code>BITBUCKET</code>.</p>
    pub build_status_config: std::option::Option<crate::model::BuildStatusConfig>,
    /// <p>Enable this flag to ignore SSL warnings while connecting to the project source
    /// code.</p>
    pub insecure_ssl: std::option::Option<bool>,
    /// <p>An identifier for this project source. The identifier can only contain
    /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
    pub source_identifier: std::option::Option<std::string::String>,
}
impl ProjectSource {
    /// <p>The type of repository that contains the source code to be built. Valid values
    /// include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>BITBUCKET</code>: The source code is in a Bitbucket repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CODECOMMIT</code>: The source code is in an CodeCommit repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CODEPIPELINE</code>: The source code settings are specified in the
    /// source action of a pipeline in CodePipeline.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GITHUB</code>: The source code is in a GitHub or GitHub Enterprise Cloud
    /// repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GITHUB_ENTERPRISE</code>: The source code is in a GitHub Enterprise
    /// Server repository.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NO_SOURCE</code>: The project does not have input source code.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>S3</code>: The source code is in an Amazon S3 bucket.</p>
    /// </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.r#type.as_ref()
    }
    /// <p>Information about the location of the source code to be built. Valid values
    /// include:</p>
    /// <ul>
    /// <li>
    /// <p>For source code settings that are specified in the source action of a pipeline
    /// in CodePipeline, <code>location</code> should not be specified. If it is specified,
    /// CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source
    /// action instead of this value.</p>
    /// </li>
    /// <li>
    /// <p>For source code in an CodeCommit repository, the HTTPS clone URL to the repository
    /// that contains the source code and the buildspec file (for example,
    /// <code>https://git-codecommit.<region-ID>.amazonaws.com/v1/repos/<repo-name></code>).</p>
    /// </li>
    /// <li>
    /// <p>For source code in an Amazon S3 input bucket, one of the following. </p>
    /// <ul>
    /// <li>
    /// <p>The path to the ZIP file that contains the source code (for example,
    /// <code><bucket-name>/<path>/<object-name>.zip</code>). </p>
    /// </li>
    /// <li>
    /// <p>The path to the folder that contains the source code (for example,
    /// <code><bucket-name>/<path-to-source-code>/<folder>/</code>). </p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>For source code in a GitHub repository, the HTTPS clone URL to the repository
    /// that contains the source and the buildspec file. You must connect your Amazon Web Services account
    /// to your GitHub account. Use the CodeBuild console to start creating a build
    /// project. When you use the console to connect (or reconnect) with GitHub, on the
    /// GitHub <b>Authorize application</b> page, for
    /// <b>Organization access</b>, choose <b>Request access</b> next to each repository you want to
    /// allow CodeBuild to have access to, and then choose <b>Authorize
    /// application</b>. (After you have connected to your GitHub account,
    /// you do not need to finish creating the build project. You can leave the CodeBuild
    /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
    /// object, set the <code>auth</code> object's <code>type</code> value to
    /// <code>OAUTH</code>.</p>
    /// </li>
    /// <li>
    /// <p>For source code in a Bitbucket repository, the HTTPS clone URL to the
    /// repository that contains the source and the buildspec file. You must connect
    /// your Amazon Web Services account to your Bitbucket account. Use the CodeBuild console to start
    /// creating a build project. When you use the console to connect (or reconnect)
    /// with Bitbucket, on the Bitbucket <b>Confirm access to your
    /// account</b> page, choose <b>Grant
    /// access</b>. (After you have connected to your Bitbucket account, you
    /// do not need to finish creating the build project. You can leave the CodeBuild
    /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
    /// object, set the <code>auth</code> object's <code>type</code> value to
    /// <code>OAUTH</code>.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// If you specify <code>CODEPIPELINE</code> for the <code>Type</code> property, don't specify this
    /// property. For all of the other types, you must specify <code>Location</code>.
    /// </p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>Information about the Git clone depth for the build project.</p>
    pub fn git_clone_depth(&self) -> std::option::Option<i32> {
        self.git_clone_depth
    }
    /// <p> Information about the Git submodules configuration for the build project. </p>
    pub fn git_submodules_config(&self) -> std::option::Option<&crate::model::GitSubmodulesConfig> {
        self.git_submodules_config.as_ref()
    }
    /// <p>The buildspec file declaration to use for the builds in this build project.</p>
    /// <p> If this value is set, it can be either an inline buildspec definition, the path to an
    /// alternate buildspec file relative to the value of the built-in
    /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
    /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
    /// file using its ARN (for example,
    /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
    /// provided or is set to an empty string, the source code must contain a buildspec file in
    /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
    pub fn buildspec(&self) -> std::option::Option<&str> {
        self.buildspec.as_deref()
    }
    /// <p>Information about the authorization settings for CodeBuild to access the source code to be
    /// built.</p>
    /// <p>This information is for the CodeBuild console's use only. Your code should not get or set
    /// this information directly.</p>
    pub fn auth(&self) -> std::option::Option<&crate::model::SourceAuth> {
        self.auth.as_ref()
    }
    /// <p> Set to true to report the status of a build's start and finish to your source
    /// provider. This option is valid only when your source provider is GitHub, GitHub
    /// Enterprise, or Bitbucket. If this is set and you use a different source provider, an
    /// <code>invalidInputException</code> is thrown. </p>
    /// <p>To be able to report the build status to the source provider, the user associated with the source provider must
    /// have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p>
    /// <p>The status of a build triggered by a webhook is always reported to your source
    /// provider. </p>
    /// <p>If your project's builds are triggered by a webhook, you must push a
    /// new commit to the repo for a change to this property to take
    /// effect.</p>
    pub fn report_build_status(&self) -> std::option::Option<bool> {
        self.report_build_status
    }
    /// <p>Contains information that defines how the build project reports the build status to
    /// the source provider. This option is only used when the source provider is
    /// <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
    /// <code>BITBUCKET</code>.</p>
    pub fn build_status_config(&self) -> std::option::Option<&crate::model::BuildStatusConfig> {
        self.build_status_config.as_ref()
    }
    /// <p>Enable this flag to ignore SSL warnings while connecting to the project source
    /// code.</p>
    pub fn insecure_ssl(&self) -> std::option::Option<bool> {
        self.insecure_ssl
    }
    /// <p>An identifier for this project source. The identifier can only contain
    /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
}
impl std::fmt::Debug for ProjectSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProjectSource");
        formatter.field("r#type", &self.r#type);
        formatter.field("location", &self.location);
        formatter.field("git_clone_depth", &self.git_clone_depth);
        formatter.field("git_submodules_config", &self.git_submodules_config);
        formatter.field("buildspec", &self.buildspec);
        formatter.field("auth", &self.auth);
        formatter.field("report_build_status", &self.report_build_status);
        formatter.field("build_status_config", &self.build_status_config);
        formatter.field("insecure_ssl", &self.insecure_ssl);
        formatter.field("source_identifier", &self.source_identifier);
        formatter.finish()
    }
}
/// See [`ProjectSource`](crate::model::ProjectSource)
pub mod project_source {
    /// A builder for [`ProjectSource`](crate::model::ProjectSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SourceType>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) git_clone_depth: std::option::Option<i32>,
        pub(crate) git_submodules_config: std::option::Option<crate::model::GitSubmodulesConfig>,
        pub(crate) buildspec: std::option::Option<std::string::String>,
        pub(crate) auth: std::option::Option<crate::model::SourceAuth>,
        pub(crate) report_build_status: std::option::Option<bool>,
        pub(crate) build_status_config: std::option::Option<crate::model::BuildStatusConfig>,
        pub(crate) insecure_ssl: std::option::Option<bool>,
        pub(crate) source_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of repository that contains the source code to be built. Valid values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BITBUCKET</code>: The source code is in a Bitbucket repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CODECOMMIT</code>: The source code is in an CodeCommit repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CODEPIPELINE</code>: The source code settings are specified in the
        /// source action of a pipeline in CodePipeline.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GITHUB</code>: The source code is in a GitHub or GitHub Enterprise Cloud
        /// repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GITHUB_ENTERPRISE</code>: The source code is in a GitHub Enterprise
        /// Server repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_SOURCE</code>: The project does not have input source code.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: The source code is in an Amazon S3 bucket.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::SourceType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of repository that contains the source code to be built. Valid values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>BITBUCKET</code>: The source code is in a Bitbucket repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CODECOMMIT</code>: The source code is in an CodeCommit repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CODEPIPELINE</code>: The source code settings are specified in the
        /// source action of a pipeline in CodePipeline.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GITHUB</code>: The source code is in a GitHub or GitHub Enterprise Cloud
        /// repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GITHUB_ENTERPRISE</code>: The source code is in a GitHub Enterprise
        /// Server repository.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_SOURCE</code>: The project does not have input source code.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>S3</code>: The source code is in an Amazon S3 bucket.</p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::SourceType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Information about the location of the source code to be built. Valid values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>For source code settings that are specified in the source action of a pipeline
        /// in CodePipeline, <code>location</code> should not be specified. If it is specified,
        /// CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source
        /// action instead of this value.</p>
        /// </li>
        /// <li>
        /// <p>For source code in an CodeCommit repository, the HTTPS clone URL to the repository
        /// that contains the source code and the buildspec file (for example,
        /// <code>https://git-codecommit.<region-ID>.amazonaws.com/v1/repos/<repo-name></code>).</p>
        /// </li>
        /// <li>
        /// <p>For source code in an Amazon S3 input bucket, one of the following. </p>
        /// <ul>
        /// <li>
        /// <p>The path to the ZIP file that contains the source code (for example,
        /// <code><bucket-name>/<path>/<object-name>.zip</code>). </p>
        /// </li>
        /// <li>
        /// <p>The path to the folder that contains the source code (for example,
        /// <code><bucket-name>/<path-to-source-code>/<folder>/</code>). </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For source code in a GitHub repository, the HTTPS clone URL to the repository
        /// that contains the source and the buildspec file. You must connect your Amazon Web Services account
        /// to your GitHub account. Use the CodeBuild console to start creating a build
        /// project. When you use the console to connect (or reconnect) with GitHub, on the
        /// GitHub <b>Authorize application</b> page, for
        /// <b>Organization access</b>, choose <b>Request access</b> next to each repository you want to
        /// allow CodeBuild to have access to, and then choose <b>Authorize
        /// application</b>. (After you have connected to your GitHub account,
        /// you do not need to finish creating the build project. You can leave the CodeBuild
        /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
        /// object, set the <code>auth</code> object's <code>type</code> value to
        /// <code>OAUTH</code>.</p>
        /// </li>
        /// <li>
        /// <p>For source code in a Bitbucket repository, the HTTPS clone URL to the
        /// repository that contains the source and the buildspec file. You must connect
        /// your Amazon Web Services account to your Bitbucket account. Use the CodeBuild console to start
        /// creating a build project. When you use the console to connect (or reconnect)
        /// with Bitbucket, on the Bitbucket <b>Confirm access to your
        /// account</b> page, choose <b>Grant
        /// access</b>. (After you have connected to your Bitbucket account, you
        /// do not need to finish creating the build project. You can leave the CodeBuild
        /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
        /// object, set the <code>auth</code> object's <code>type</code> value to
        /// <code>OAUTH</code>.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// If you specify <code>CODEPIPELINE</code> for the <code>Type</code> property, don't specify this
        /// property. For all of the other types, you must specify <code>Location</code>.
        /// </p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>Information about the location of the source code to be built. Valid values
        /// include:</p>
        /// <ul>
        /// <li>
        /// <p>For source code settings that are specified in the source action of a pipeline
        /// in CodePipeline, <code>location</code> should not be specified. If it is specified,
        /// CodePipeline ignores it. This is because CodePipeline uses the settings in a pipeline's source
        /// action instead of this value.</p>
        /// </li>
        /// <li>
        /// <p>For source code in an CodeCommit repository, the HTTPS clone URL to the repository
        /// that contains the source code and the buildspec file (for example,
        /// <code>https://git-codecommit.<region-ID>.amazonaws.com/v1/repos/<repo-name></code>).</p>
        /// </li>
        /// <li>
        /// <p>For source code in an Amazon S3 input bucket, one of the following. </p>
        /// <ul>
        /// <li>
        /// <p>The path to the ZIP file that contains the source code (for example,
        /// <code><bucket-name>/<path>/<object-name>.zip</code>). </p>
        /// </li>
        /// <li>
        /// <p>The path to the folder that contains the source code (for example,
        /// <code><bucket-name>/<path-to-source-code>/<folder>/</code>). </p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>For source code in a GitHub repository, the HTTPS clone URL to the repository
        /// that contains the source and the buildspec file. You must connect your Amazon Web Services account
        /// to your GitHub account. Use the CodeBuild console to start creating a build
        /// project. When you use the console to connect (or reconnect) with GitHub, on the
        /// GitHub <b>Authorize application</b> page, for
        /// <b>Organization access</b>, choose <b>Request access</b> next to each repository you want to
        /// allow CodeBuild to have access to, and then choose <b>Authorize
        /// application</b>. (After you have connected to your GitHub account,
        /// you do not need to finish creating the build project. You can leave the CodeBuild
        /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
        /// object, set the <code>auth</code> object's <code>type</code> value to
        /// <code>OAUTH</code>.</p>
        /// </li>
        /// <li>
        /// <p>For source code in a Bitbucket repository, the HTTPS clone URL to the
        /// repository that contains the source and the buildspec file. You must connect
        /// your Amazon Web Services account to your Bitbucket account. Use the CodeBuild console to start
        /// creating a build project. When you use the console to connect (or reconnect)
        /// with Bitbucket, on the Bitbucket <b>Confirm access to your
        /// account</b> page, choose <b>Grant
        /// access</b>. (After you have connected to your Bitbucket account, you
        /// do not need to finish creating the build project. You can leave the CodeBuild
        /// console.) To instruct CodeBuild to use this connection, in the <code>source</code>
        /// object, set the <code>auth</code> object's <code>type</code> value to
        /// <code>OAUTH</code>.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// If you specify <code>CODEPIPELINE</code> for the <code>Type</code> property, don't specify this
        /// property. For all of the other types, you must specify <code>Location</code>.
        /// </p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>Information about the Git clone depth for the build project.</p>
        pub fn git_clone_depth(mut self, input: i32) -> Self {
            self.git_clone_depth = Some(input);
            self
        }
        /// <p>Information about the Git clone depth for the build project.</p>
        pub fn set_git_clone_depth(mut self, input: std::option::Option<i32>) -> Self {
            self.git_clone_depth = input;
            self
        }
        /// <p> Information about the Git submodules configuration for the build project. </p>
        pub fn git_submodules_config(mut self, input: crate::model::GitSubmodulesConfig) -> Self {
            self.git_submodules_config = Some(input);
            self
        }
        /// <p> Information about the Git submodules configuration for the build project. </p>
        pub fn set_git_submodules_config(
            mut self,
            input: std::option::Option<crate::model::GitSubmodulesConfig>,
        ) -> Self {
            self.git_submodules_config = input;
            self
        }
        /// <p>The buildspec file declaration to use for the builds in this build project.</p>
        /// <p> If this value is set, it can be either an inline buildspec definition, the path to an
        /// alternate buildspec file relative to the value of the built-in
        /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
        /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
        /// file using its ARN (for example,
        /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
        /// provided or is set to an empty string, the source code must contain a buildspec file in
        /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn buildspec(mut self, input: impl Into<std::string::String>) -> Self {
            self.buildspec = Some(input.into());
            self
        }
        /// <p>The buildspec file declaration to use for the builds in this build project.</p>
        /// <p> If this value is set, it can be either an inline buildspec definition, the path to an
        /// alternate buildspec file relative to the value of the built-in
        /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
        /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
        /// file using its ARN (for example,
        /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
        /// provided or is set to an empty string, the source code must contain a buildspec file in
        /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn set_buildspec(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.buildspec = input;
            self
        }
        /// <p>Information about the authorization settings for CodeBuild to access the source code to be
        /// built.</p>
        /// <p>This information is for the CodeBuild console's use only. Your code should not get or set
        /// this information directly.</p>
        pub fn auth(mut self, input: crate::model::SourceAuth) -> Self {
            self.auth = Some(input);
            self
        }
        /// <p>Information about the authorization settings for CodeBuild to access the source code to be
        /// built.</p>
        /// <p>This information is for the CodeBuild console's use only. Your code should not get or set
        /// this information directly.</p>
        pub fn set_auth(mut self, input: std::option::Option<crate::model::SourceAuth>) -> Self {
            self.auth = input;
            self
        }
        /// <p> Set to true to report the status of a build's start and finish to your source
        /// provider. This option is valid only when your source provider is GitHub, GitHub
        /// Enterprise, or Bitbucket. If this is set and you use a different source provider, an
        /// <code>invalidInputException</code> is thrown. </p>
        /// <p>To be able to report the build status to the source provider, the user associated with the source provider must
        /// have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p>
        /// <p>The status of a build triggered by a webhook is always reported to your source
        /// provider. </p>
        /// <p>If your project's builds are triggered by a webhook, you must push a
        /// new commit to the repo for a change to this property to take
        /// effect.</p>
        pub fn report_build_status(mut self, input: bool) -> Self {
            self.report_build_status = Some(input);
            self
        }
        /// <p> Set to true to report the status of a build's start and finish to your source
        /// provider. This option is valid only when your source provider is GitHub, GitHub
        /// Enterprise, or Bitbucket. If this is set and you use a different source provider, an
        /// <code>invalidInputException</code> is thrown. </p>
        /// <p>To be able to report the build status to the source provider, the user associated with the source provider must
        /// have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p>
        /// <p>The status of a build triggered by a webhook is always reported to your source
        /// provider. </p>
        /// <p>If your project's builds are triggered by a webhook, you must push a
        /// new commit to the repo for a change to this property to take
        /// effect.</p>
        pub fn set_report_build_status(mut self, input: std::option::Option<bool>) -> Self {
            self.report_build_status = input;
            self
        }
        /// <p>Contains information that defines how the build project reports the build status to
        /// the source provider. This option is only used when the source provider is
        /// <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
        /// <code>BITBUCKET</code>.</p>
        pub fn build_status_config(mut self, input: crate::model::BuildStatusConfig) -> Self {
            self.build_status_config = Some(input);
            self
        }
        /// <p>Contains information that defines how the build project reports the build status to
        /// the source provider. This option is only used when the source provider is
        /// <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
        /// <code>BITBUCKET</code>.</p>
        pub fn set_build_status_config(
            mut self,
            input: std::option::Option<crate::model::BuildStatusConfig>,
        ) -> Self {
            self.build_status_config = input;
            self
        }
        /// <p>Enable this flag to ignore SSL warnings while connecting to the project source
        /// code.</p>
        pub fn insecure_ssl(mut self, input: bool) -> Self {
            self.insecure_ssl = Some(input);
            self
        }
        /// <p>Enable this flag to ignore SSL warnings while connecting to the project source
        /// code.</p>
        pub fn set_insecure_ssl(mut self, input: std::option::Option<bool>) -> Self {
            self.insecure_ssl = input;
            self
        }
        /// <p>An identifier for this project source. The identifier can only contain
        /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>An identifier for this project source. The identifier can only contain
        /// alphanumeric characters and underscores, and must be less than 128 characters in length. </p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ProjectSource`](crate::model::ProjectSource)
        pub fn build(self) -> crate::model::ProjectSource {
            crate::model::ProjectSource {
                r#type: self.r#type,
                location: self.location,
                git_clone_depth: self.git_clone_depth,
                git_submodules_config: self.git_submodules_config,
                buildspec: self.buildspec,
                auth: self.auth,
                report_build_status: self.report_build_status,
                build_status_config: self.build_status_config,
                insecure_ssl: self.insecure_ssl,
                source_identifier: self.source_identifier,
            }
        }
    }
}
impl ProjectSource {
    /// Creates a new builder-style object to manufacture [`ProjectSource`](crate::model::ProjectSource)
    pub fn builder() -> crate::model::project_source::Builder {
        crate::model::project_source::Builder::default()
    }
}

/// <p>Contains information that defines how the CodeBuild build project reports the build status
/// to the source provider. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildStatusConfig {
    /// <p>Specifies the context of the build status CodeBuild sends to the source provider. The
    /// usage of this parameter depends on the source provider.</p>
    /// <dl>
    /// <dt>Bitbucket</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>name</code> parameter in the
    /// Bitbucket commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
    /// </dd>
    /// <dt>GitHub/GitHub Enterprise Server</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>context</code> parameter in the
    /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
    /// </dd>
    /// </dl>
    pub context: std::option::Option<std::string::String>,
    /// <p>Specifies the target url of the build status CodeBuild sends to the source provider. The
    /// usage of this parameter depends on the source provider.</p>
    /// <dl>
    /// <dt>Bitbucket</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>url</code> parameter in the Bitbucket
    /// commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
    /// </dd>
    /// <dt>GitHub/GitHub Enterprise Server</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>target_url</code> parameter in the
    /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
    /// </dd>
    /// </dl>
    pub target_url: std::option::Option<std::string::String>,
}
impl BuildStatusConfig {
    /// <p>Specifies the context of the build status CodeBuild sends to the source provider. The
    /// usage of this parameter depends on the source provider.</p>
    /// <dl>
    /// <dt>Bitbucket</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>name</code> parameter in the
    /// Bitbucket commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
    /// </dd>
    /// <dt>GitHub/GitHub Enterprise Server</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>context</code> parameter in the
    /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
    /// </dd>
    /// </dl>
    pub fn context(&self) -> std::option::Option<&str> {
        self.context.as_deref()
    }
    /// <p>Specifies the target url of the build status CodeBuild sends to the source provider. The
    /// usage of this parameter depends on the source provider.</p>
    /// <dl>
    /// <dt>Bitbucket</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>url</code> parameter in the Bitbucket
    /// commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
    /// </dd>
    /// <dt>GitHub/GitHub Enterprise Server</dt>
    /// <dd>
    /// <p>This parameter is used for the <code>target_url</code> parameter in the
    /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
    /// </dd>
    /// </dl>
    pub fn target_url(&self) -> std::option::Option<&str> {
        self.target_url.as_deref()
    }
}
impl std::fmt::Debug for BuildStatusConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildStatusConfig");
        formatter.field("context", &self.context);
        formatter.field("target_url", &self.target_url);
        formatter.finish()
    }
}
/// See [`BuildStatusConfig`](crate::model::BuildStatusConfig)
pub mod build_status_config {
    /// A builder for [`BuildStatusConfig`](crate::model::BuildStatusConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) context: std::option::Option<std::string::String>,
        pub(crate) target_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the context of the build status CodeBuild sends to the source provider. The
        /// usage of this parameter depends on the source provider.</p>
        /// <dl>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>name</code> parameter in the
        /// Bitbucket commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
        /// </dd>
        /// <dt>GitHub/GitHub Enterprise Server</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>context</code> parameter in the
        /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
        /// </dd>
        /// </dl>
        pub fn context(mut self, input: impl Into<std::string::String>) -> Self {
            self.context = Some(input.into());
            self
        }
        /// <p>Specifies the context of the build status CodeBuild sends to the source provider. The
        /// usage of this parameter depends on the source provider.</p>
        /// <dl>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>name</code> parameter in the
        /// Bitbucket commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
        /// </dd>
        /// <dt>GitHub/GitHub Enterprise Server</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>context</code> parameter in the
        /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
        /// </dd>
        /// </dl>
        pub fn set_context(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.context = input;
            self
        }
        /// <p>Specifies the target url of the build status CodeBuild sends to the source provider. The
        /// usage of this parameter depends on the source provider.</p>
        /// <dl>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>url</code> parameter in the Bitbucket
        /// commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
        /// </dd>
        /// <dt>GitHub/GitHub Enterprise Server</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>target_url</code> parameter in the
        /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
        /// </dd>
        /// </dl>
        pub fn target_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_url = Some(input.into());
            self
        }
        /// <p>Specifies the target url of the build status CodeBuild sends to the source provider. The
        /// usage of this parameter depends on the source provider.</p>
        /// <dl>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>url</code> parameter in the Bitbucket
        /// commit status. For more information, see <a href="https://developer.atlassian.com/bitbucket/api/2/reference/resource/repositories/%7Bworkspace%7D/%7Brepo_slug%7D/commit/%7Bnode%7D/statuses/build">build</a> in the Bitbucket API documentation.</p>
        /// </dd>
        /// <dt>GitHub/GitHub Enterprise Server</dt>
        /// <dd>
        /// <p>This parameter is used for the <code>target_url</code> parameter in the
        /// GitHub commit status. For more information, see <a href="https://developer.github.com/v3/repos/statuses/#create-a-commit-status">Create a commit status</a> in the GitHub developer guide.</p>
        /// </dd>
        /// </dl>
        pub fn set_target_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_url = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildStatusConfig`](crate::model::BuildStatusConfig)
        pub fn build(self) -> crate::model::BuildStatusConfig {
            crate::model::BuildStatusConfig {
                context: self.context,
                target_url: self.target_url,
            }
        }
    }
}
impl BuildStatusConfig {
    /// Creates a new builder-style object to manufacture [`BuildStatusConfig`](crate::model::BuildStatusConfig)
    pub fn builder() -> crate::model::build_status_config::Builder {
        crate::model::build_status_config::Builder::default()
    }
}

/// <p>Information about the authorization settings for CodeBuild to access the source code to be
/// built.</p>
/// <p>This information is for the CodeBuild console's use only. Your code should not get or set
/// this information directly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceAuth {
    /// <note>
    /// <p> This data type is deprecated and is no longer accurate or used. </p>
    /// </note>
    /// <p>The authorization type to use. The only valid value is <code>OAUTH</code>, which
    /// represents the OAuth authorization type.</p>
    pub r#type: std::option::Option<crate::model::SourceAuthType>,
    /// <p>The resource value that applies to the specified authorization type.</p>
    pub resource: std::option::Option<std::string::String>,
}
impl SourceAuth {
    /// <note>
    /// <p> This data type is deprecated and is no longer accurate or used. </p>
    /// </note>
    /// <p>The authorization type to use. The only valid value is <code>OAUTH</code>, which
    /// represents the OAuth authorization type.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SourceAuthType> {
        self.r#type.as_ref()
    }
    /// <p>The resource value that applies to the specified authorization type.</p>
    pub fn resource(&self) -> std::option::Option<&str> {
        self.resource.as_deref()
    }
}
impl std::fmt::Debug for SourceAuth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceAuth");
        formatter.field("r#type", &self.r#type);
        formatter.field("resource", &self.resource);
        formatter.finish()
    }
}
/// See [`SourceAuth`](crate::model::SourceAuth)
pub mod source_auth {
    /// A builder for [`SourceAuth`](crate::model::SourceAuth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::SourceAuthType>,
        pub(crate) resource: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <note>
        /// <p> This data type is deprecated and is no longer accurate or used. </p>
        /// </note>
        /// <p>The authorization type to use. The only valid value is <code>OAUTH</code>, which
        /// represents the OAuth authorization type.</p>
        pub fn r#type(mut self, input: crate::model::SourceAuthType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <note>
        /// <p> This data type is deprecated and is no longer accurate or used. </p>
        /// </note>
        /// <p>The authorization type to use. The only valid value is <code>OAUTH</code>, which
        /// represents the OAuth authorization type.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::SourceAuthType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The resource value that applies to the specified authorization type.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The resource value that applies to the specified authorization type.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceAuth`](crate::model::SourceAuth)
        pub fn build(self) -> crate::model::SourceAuth {
            crate::model::SourceAuth {
                r#type: self.r#type,
                resource: self.resource,
            }
        }
    }
}
impl SourceAuth {
    /// Creates a new builder-style object to manufacture [`SourceAuth`](crate::model::SourceAuth)
    pub fn builder() -> crate::model::source_auth::Builder {
        crate::model::source_auth::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceAuthType {
    #[allow(missing_docs)] // documentation missing in model
    Oauth,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceAuthType {
    fn from(s: &str) -> Self {
        match s {
            "OAUTH" => SourceAuthType::Oauth,
            other => SourceAuthType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceAuthType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceAuthType::from(s))
    }
}
impl SourceAuthType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceAuthType::Oauth => "OAUTH",
            SourceAuthType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["OAUTH"]
    }
}
impl AsRef<str> for SourceAuthType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about the Git submodules configuration for an CodeBuild build project.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GitSubmodulesConfig {
    /// <p> Set to true to fetch Git submodules for your CodeBuild build project. </p>
    pub fetch_submodules: std::option::Option<bool>,
}
impl GitSubmodulesConfig {
    /// <p> Set to true to fetch Git submodules for your CodeBuild build project. </p>
    pub fn fetch_submodules(&self) -> std::option::Option<bool> {
        self.fetch_submodules
    }
}
impl std::fmt::Debug for GitSubmodulesConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GitSubmodulesConfig");
        formatter.field("fetch_submodules", &self.fetch_submodules);
        formatter.finish()
    }
}
/// See [`GitSubmodulesConfig`](crate::model::GitSubmodulesConfig)
pub mod git_submodules_config {
    /// A builder for [`GitSubmodulesConfig`](crate::model::GitSubmodulesConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fetch_submodules: std::option::Option<bool>,
    }
    impl Builder {
        /// <p> Set to true to fetch Git submodules for your CodeBuild build project. </p>
        pub fn fetch_submodules(mut self, input: bool) -> Self {
            self.fetch_submodules = Some(input);
            self
        }
        /// <p> Set to true to fetch Git submodules for your CodeBuild build project. </p>
        pub fn set_fetch_submodules(mut self, input: std::option::Option<bool>) -> Self {
            self.fetch_submodules = input;
            self
        }
        /// Consumes the builder and constructs a [`GitSubmodulesConfig`](crate::model::GitSubmodulesConfig)
        pub fn build(self) -> crate::model::GitSubmodulesConfig {
            crate::model::GitSubmodulesConfig {
                fetch_submodules: self.fetch_submodules,
            }
        }
    }
}
impl GitSubmodulesConfig {
    /// Creates a new builder-style object to manufacture [`GitSubmodulesConfig`](crate::model::GitSubmodulesConfig)
    pub fn builder() -> crate::model::git_submodules_config::Builder {
        crate::model::git_submodules_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Bitbucket,
    #[allow(missing_docs)] // documentation missing in model
    Codecommit,
    #[allow(missing_docs)] // documentation missing in model
    Codepipeline,
    #[allow(missing_docs)] // documentation missing in model
    Github,
    #[allow(missing_docs)] // documentation missing in model
    GithubEnterprise,
    #[allow(missing_docs)] // documentation missing in model
    NoSource,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "BITBUCKET" => SourceType::Bitbucket,
            "CODECOMMIT" => SourceType::Codecommit,
            "CODEPIPELINE" => SourceType::Codepipeline,
            "GITHUB" => SourceType::Github,
            "GITHUB_ENTERPRISE" => SourceType::GithubEnterprise,
            "NO_SOURCE" => SourceType::NoSource,
            "S3" => SourceType::S3,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Bitbucket => "BITBUCKET",
            SourceType::Codecommit => "CODECOMMIT",
            SourceType::Codepipeline => "CODEPIPELINE",
            SourceType::Github => "GITHUB",
            SourceType::GithubEnterprise => "GITHUB_ENTERPRISE",
            SourceType::NoSource => "NO_SOURCE",
            SourceType::S3 => "S3",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BITBUCKET",
            "CODECOMMIT",
            "CODEPIPELINE",
            "GITHUB",
            "GITHUB_ENTERPRISE",
            "NO_SOURCE",
            "S3",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a batch build.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildBatch {
    /// <p>The identifier of the batch build.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the batch build.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time that the batch build started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time that the batch build ended.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current phase of the batch build.</p>
    pub current_phase: std::option::Option<std::string::String>,
    /// <p>The status of the batch build.</p>
    pub build_batch_status: std::option::Option<crate::model::StatusType>,
    /// <p>The identifier of the version of the source code to be built.</p>
    pub source_version: std::option::Option<std::string::String>,
    /// <p>The identifier of the resolved version of this batch build's source code.</p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.</p>
    /// </li>
    /// <li>
    /// <p>For CodePipeline, the source revision provided by CodePipeline.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3, this does not apply.</p>
    /// </li>
    /// </ul>
    pub resolved_source_version: std::option::Option<std::string::String>,
    /// <p>The name of the batch build project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>An array of <code>BuildBatchPhase</code> objects the specify the phases of the
    /// batch build.</p>
    pub phases: std::option::Option<std::vec::Vec<crate::model::BuildBatchPhase>>,
    /// <p>Information about the build input source code for the build project.</p>
    pub source: std::option::Option<crate::model::ProjectSource>,
    /// <p>An array of <code>ProjectSource</code> objects that define the sources for the batch
    /// build.</p>
    pub secondary_sources: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
    /// <p>An array of <code>ProjectSourceVersion</code> objects. Each
    /// <code>ProjectSourceVersion</code> must be one of: </p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    pub secondary_source_versions:
        std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
    /// <p>A <code>BuildArtifacts</code> object the defines the build artifacts for this batch build.</p>
    pub artifacts: std::option::Option<crate::model::BuildArtifacts>,
    /// <p>An array of <code>BuildArtifacts</code> objects the define the build artifacts
    /// for this batch build.</p>
    pub secondary_artifacts: std::option::Option<std::vec::Vec<crate::model::BuildArtifacts>>,
    /// <p>Information about the cache for the build project.</p>
    pub cache: std::option::Option<crate::model::ProjectCache>,
    /// <p>Information about the build environment of the build project.</p>
    pub environment: std::option::Option<crate::model::ProjectEnvironment>,
    /// <p>The name of a service role used for builds in the batch.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p> Information about logs for a build project. These can be logs in CloudWatch Logs, built in a
    /// specified S3 bucket, or both. </p>
    pub log_config: std::option::Option<crate::model::LogsConfig>,
    /// <p>Specifies the maximum amount of time, in minutes, that the build in a batch must be
    /// completed in.</p>
    pub build_timeout_in_minutes: std::option::Option<i32>,
    /// <p>Specifies the amount of time, in minutes, that the batch build is allowed to be queued
    /// before it times out.</p>
    pub queued_timeout_in_minutes: std::option::Option<i32>,
    /// <p>Indicates if the batch build is complete.</p>
    pub complete: bool,
    /// <p>The entity that started the batch build. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>If CodePipeline started the build, the pipeline's name (for example,
    /// <code>codepipeline/my-demo-pipeline</code>).</p>
    /// </li>
    /// <li>
    /// <p>If an IAM user started the build, the user's name.</p>
    /// </li>
    /// <li>
    /// <p>If the Jenkins plugin for CodeBuild started the build, the string
    /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
    /// </li>
    /// </ul>
    pub initiator: std::option::Option<std::string::String>,
    /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the batch build output
    /// artifacts.</p>
    /// <note>
    /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
    /// service role has permission to that key. </p>
    /// </note>
    /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
    /// the format <code>alias/<alias-name></code>).</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>The number of the batch build. For each project, the <code>buildBatchNumber</code> of its
    /// first batch build is <code>1</code>. The <code>buildBatchNumber</code> of each subsequent
    /// batch build is incremented by <code>1</code>. If a batch build is deleted, the
    /// <code>buildBatchNumber</code> of other batch builds does not change.</p>
    pub build_batch_number: std::option::Option<i64>,
    /// <p>An array of <code>ProjectFileSystemLocation</code> objects for the batch build
    /// project. A <code>ProjectFileSystemLocation</code> object specifies the
    /// <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
    /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon
    /// Elastic File System. </p>
    pub file_system_locations:
        std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
    /// <p>Contains configuration information about a batch build project.</p>
    pub build_batch_config: std::option::Option<crate::model::ProjectBuildBatchConfig>,
    /// <p>An array of <code>BuildGroup</code> objects that define the build groups for the
    /// batch build.</p>
    pub build_groups: std::option::Option<std::vec::Vec<crate::model::BuildGroup>>,
    /// <p>Specifies if session debugging is enabled for this batch build. For more information, see
    /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
    pub debug_session_enabled: std::option::Option<bool>,
}
impl BuildBatch {
    /// <p>The identifier of the batch build.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the batch build.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time that the batch build started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The date and time that the batch build ended.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The current phase of the batch build.</p>
    pub fn current_phase(&self) -> std::option::Option<&str> {
        self.current_phase.as_deref()
    }
    /// <p>The status of the batch build.</p>
    pub fn build_batch_status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.build_batch_status.as_ref()
    }
    /// <p>The identifier of the version of the source code to be built.</p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
    /// <p>The identifier of the resolved version of this batch build's source code.</p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.</p>
    /// </li>
    /// <li>
    /// <p>For CodePipeline, the source revision provided by CodePipeline.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3, this does not apply.</p>
    /// </li>
    /// </ul>
    pub fn resolved_source_version(&self) -> std::option::Option<&str> {
        self.resolved_source_version.as_deref()
    }
    /// <p>The name of the batch build project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>An array of <code>BuildBatchPhase</code> objects the specify the phases of the
    /// batch build.</p>
    pub fn phases(&self) -> std::option::Option<&[crate::model::BuildBatchPhase]> {
        self.phases.as_deref()
    }
    /// <p>Information about the build input source code for the build project.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::ProjectSource> {
        self.source.as_ref()
    }
    /// <p>An array of <code>ProjectSource</code> objects that define the sources for the batch
    /// build.</p>
    pub fn secondary_sources(&self) -> std::option::Option<&[crate::model::ProjectSource]> {
        self.secondary_sources.as_deref()
    }
    /// <p>An array of <code>ProjectSourceVersion</code> objects. Each
    /// <code>ProjectSourceVersion</code> must be one of: </p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    pub fn secondary_source_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ProjectSourceVersion]> {
        self.secondary_source_versions.as_deref()
    }
    /// <p>A <code>BuildArtifacts</code> object the defines the build artifacts for this batch build.</p>
    pub fn artifacts(&self) -> std::option::Option<&crate::model::BuildArtifacts> {
        self.artifacts.as_ref()
    }
    /// <p>An array of <code>BuildArtifacts</code> objects the define the build artifacts
    /// for this batch build.</p>
    pub fn secondary_artifacts(&self) -> std::option::Option<&[crate::model::BuildArtifacts]> {
        self.secondary_artifacts.as_deref()
    }
    /// <p>Information about the cache for the build project.</p>
    pub fn cache(&self) -> std::option::Option<&crate::model::ProjectCache> {
        self.cache.as_ref()
    }
    /// <p>Information about the build environment of the build project.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::ProjectEnvironment> {
        self.environment.as_ref()
    }
    /// <p>The name of a service role used for builds in the batch.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p> Information about logs for a build project. These can be logs in CloudWatch Logs, built in a
    /// specified S3 bucket, or both. </p>
    pub fn log_config(&self) -> std::option::Option<&crate::model::LogsConfig> {
        self.log_config.as_ref()
    }
    /// <p>Specifies the maximum amount of time, in minutes, that the build in a batch must be
    /// completed in.</p>
    pub fn build_timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.build_timeout_in_minutes
    }
    /// <p>Specifies the amount of time, in minutes, that the batch build is allowed to be queued
    /// before it times out.</p>
    pub fn queued_timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.queued_timeout_in_minutes
    }
    /// <p>Indicates if the batch build is complete.</p>
    pub fn complete(&self) -> bool {
        self.complete
    }
    /// <p>The entity that started the batch build. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>If CodePipeline started the build, the pipeline's name (for example,
    /// <code>codepipeline/my-demo-pipeline</code>).</p>
    /// </li>
    /// <li>
    /// <p>If an IAM user started the build, the user's name.</p>
    /// </li>
    /// <li>
    /// <p>If the Jenkins plugin for CodeBuild started the build, the string
    /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
    /// </li>
    /// </ul>
    pub fn initiator(&self) -> std::option::Option<&str> {
        self.initiator.as_deref()
    }
    /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the batch build output
    /// artifacts.</p>
    /// <note>
    /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
    /// service role has permission to that key. </p>
    /// </note>
    /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
    /// the format <code>alias/<alias-name></code>).</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>The number of the batch build. For each project, the <code>buildBatchNumber</code> of its
    /// first batch build is <code>1</code>. The <code>buildBatchNumber</code> of each subsequent
    /// batch build is incremented by <code>1</code>. If a batch build is deleted, the
    /// <code>buildBatchNumber</code> of other batch builds does not change.</p>
    pub fn build_batch_number(&self) -> std::option::Option<i64> {
        self.build_batch_number
    }
    /// <p>An array of <code>ProjectFileSystemLocation</code> objects for the batch build
    /// project. A <code>ProjectFileSystemLocation</code> object specifies the
    /// <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
    /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon
    /// Elastic File System. </p>
    pub fn file_system_locations(
        &self,
    ) -> std::option::Option<&[crate::model::ProjectFileSystemLocation]> {
        self.file_system_locations.as_deref()
    }
    /// <p>Contains configuration information about a batch build project.</p>
    pub fn build_batch_config(
        &self,
    ) -> std::option::Option<&crate::model::ProjectBuildBatchConfig> {
        self.build_batch_config.as_ref()
    }
    /// <p>An array of <code>BuildGroup</code> objects that define the build groups for the
    /// batch build.</p>
    pub fn build_groups(&self) -> std::option::Option<&[crate::model::BuildGroup]> {
        self.build_groups.as_deref()
    }
    /// <p>Specifies if session debugging is enabled for this batch build. For more information, see
    /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
    pub fn debug_session_enabled(&self) -> std::option::Option<bool> {
        self.debug_session_enabled
    }
}
impl std::fmt::Debug for BuildBatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildBatch");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("current_phase", &self.current_phase);
        formatter.field("build_batch_status", &self.build_batch_status);
        formatter.field("source_version", &self.source_version);
        formatter.field("resolved_source_version", &self.resolved_source_version);
        formatter.field("project_name", &self.project_name);
        formatter.field("phases", &self.phases);
        formatter.field("source", &self.source);
        formatter.field("secondary_sources", &self.secondary_sources);
        formatter.field("secondary_source_versions", &self.secondary_source_versions);
        formatter.field("artifacts", &self.artifacts);
        formatter.field("secondary_artifacts", &self.secondary_artifacts);
        formatter.field("cache", &self.cache);
        formatter.field("environment", &self.environment);
        formatter.field("service_role", &self.service_role);
        formatter.field("log_config", &self.log_config);
        formatter.field("build_timeout_in_minutes", &self.build_timeout_in_minutes);
        formatter.field("queued_timeout_in_minutes", &self.queued_timeout_in_minutes);
        formatter.field("complete", &self.complete);
        formatter.field("initiator", &self.initiator);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("build_batch_number", &self.build_batch_number);
        formatter.field("file_system_locations", &self.file_system_locations);
        formatter.field("build_batch_config", &self.build_batch_config);
        formatter.field("build_groups", &self.build_groups);
        formatter.field("debug_session_enabled", &self.debug_session_enabled);
        formatter.finish()
    }
}
/// See [`BuildBatch`](crate::model::BuildBatch)
pub mod build_batch {
    /// A builder for [`BuildBatch`](crate::model::BuildBatch)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) current_phase: std::option::Option<std::string::String>,
        pub(crate) build_batch_status: std::option::Option<crate::model::StatusType>,
        pub(crate) source_version: std::option::Option<std::string::String>,
        pub(crate) resolved_source_version: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) phases: std::option::Option<std::vec::Vec<crate::model::BuildBatchPhase>>,
        pub(crate) source: std::option::Option<crate::model::ProjectSource>,
        pub(crate) secondary_sources:
            std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        pub(crate) secondary_source_versions:
            std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        pub(crate) artifacts: std::option::Option<crate::model::BuildArtifacts>,
        pub(crate) secondary_artifacts:
            std::option::Option<std::vec::Vec<crate::model::BuildArtifacts>>,
        pub(crate) cache: std::option::Option<crate::model::ProjectCache>,
        pub(crate) environment: std::option::Option<crate::model::ProjectEnvironment>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) log_config: std::option::Option<crate::model::LogsConfig>,
        pub(crate) build_timeout_in_minutes: std::option::Option<i32>,
        pub(crate) queued_timeout_in_minutes: std::option::Option<i32>,
        pub(crate) complete: std::option::Option<bool>,
        pub(crate) initiator: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) build_batch_number: std::option::Option<i64>,
        pub(crate) file_system_locations:
            std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        pub(crate) build_batch_config: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        pub(crate) build_groups: std::option::Option<std::vec::Vec<crate::model::BuildGroup>>,
        pub(crate) debug_session_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the batch build.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the batch build.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the batch build.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the batch build.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time that the batch build started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The date and time that the batch build started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The date and time that the batch build ended.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The date and time that the batch build ended.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The current phase of the batch build.</p>
        pub fn current_phase(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_phase = Some(input.into());
            self
        }
        /// <p>The current phase of the batch build.</p>
        pub fn set_current_phase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_phase = input;
            self
        }
        /// <p>The status of the batch build.</p>
        pub fn build_batch_status(mut self, input: crate::model::StatusType) -> Self {
            self.build_batch_status = Some(input);
            self
        }
        /// <p>The status of the batch build.</p>
        pub fn set_build_batch_status(
            mut self,
            input: std::option::Option<crate::model::StatusType>,
        ) -> Self {
            self.build_batch_status = input;
            self
        }
        /// <p>The identifier of the version of the source code to be built.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>The identifier of the version of the source code to be built.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// <p>The identifier of the resolved version of this batch build's source code.</p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.</p>
        /// </li>
        /// <li>
        /// <p>For CodePipeline, the source revision provided by CodePipeline.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3, this does not apply.</p>
        /// </li>
        /// </ul>
        pub fn resolved_source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolved_source_version = Some(input.into());
            self
        }
        /// <p>The identifier of the resolved version of this batch build's source code.</p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.</p>
        /// </li>
        /// <li>
        /// <p>For CodePipeline, the source revision provided by CodePipeline.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3, this does not apply.</p>
        /// </li>
        /// </ul>
        pub fn set_resolved_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolved_source_version = input;
            self
        }
        /// <p>The name of the batch build project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the batch build project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Appends an item to `phases`.
        ///
        /// To override the contents of this collection use [`set_phases`](Self::set_phases).
        ///
        /// <p>An array of <code>BuildBatchPhase</code> objects the specify the phases of the
        /// batch build.</p>
        pub fn phases(mut self, input: impl Into<crate::model::BuildBatchPhase>) -> Self {
            let mut v = self.phases.unwrap_or_default();
            v.push(input.into());
            self.phases = Some(v);
            self
        }
        /// <p>An array of <code>BuildBatchPhase</code> objects the specify the phases of the
        /// batch build.</p>
        pub fn set_phases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildBatchPhase>>,
        ) -> Self {
            self.phases = input;
            self
        }
        /// <p>Information about the build input source code for the build project.</p>
        pub fn source(mut self, input: crate::model::ProjectSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>Information about the build input source code for the build project.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ProjectSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `secondary_sources`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources`](Self::set_secondary_sources).
        ///
        /// <p>An array of <code>ProjectSource</code> objects that define the sources for the batch
        /// build.</p>
        pub fn secondary_sources(mut self, input: impl Into<crate::model::ProjectSource>) -> Self {
            let mut v = self.secondary_sources.unwrap_or_default();
            v.push(input.into());
            self.secondary_sources = Some(v);
            self
        }
        /// <p>An array of <code>ProjectSource</code> objects that define the sources for the batch
        /// build.</p>
        pub fn set_secondary_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.secondary_sources = input;
            self
        }
        /// Appends an item to `secondary_source_versions`.
        ///
        /// To override the contents of this collection use [`set_secondary_source_versions`](Self::set_secondary_source_versions).
        ///
        /// <p>An array of <code>ProjectSourceVersion</code> objects. Each
        /// <code>ProjectSourceVersion</code> must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        pub fn secondary_source_versions(
            mut self,
            input: impl Into<crate::model::ProjectSourceVersion>,
        ) -> Self {
            let mut v = self.secondary_source_versions.unwrap_or_default();
            v.push(input.into());
            self.secondary_source_versions = Some(v);
            self
        }
        /// <p>An array of <code>ProjectSourceVersion</code> objects. Each
        /// <code>ProjectSourceVersion</code> must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        pub fn set_secondary_source_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.secondary_source_versions = input;
            self
        }
        /// <p>A <code>BuildArtifacts</code> object the defines the build artifacts for this batch build.</p>
        pub fn artifacts(mut self, input: crate::model::BuildArtifacts) -> Self {
            self.artifacts = Some(input);
            self
        }
        /// <p>A <code>BuildArtifacts</code> object the defines the build artifacts for this batch build.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<crate::model::BuildArtifacts>,
        ) -> Self {
            self.artifacts = input;
            self
        }
        /// Appends an item to `secondary_artifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p>An array of <code>BuildArtifacts</code> objects the define the build artifacts
        /// for this batch build.</p>
        pub fn secondary_artifacts(
            mut self,
            input: impl Into<crate::model::BuildArtifacts>,
        ) -> Self {
            let mut v = self.secondary_artifacts.unwrap_or_default();
            v.push(input.into());
            self.secondary_artifacts = Some(v);
            self
        }
        /// <p>An array of <code>BuildArtifacts</code> objects the define the build artifacts
        /// for this batch build.</p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildArtifacts>>,
        ) -> Self {
            self.secondary_artifacts = input;
            self
        }
        /// <p>Information about the cache for the build project.</p>
        pub fn cache(mut self, input: crate::model::ProjectCache) -> Self {
            self.cache = Some(input);
            self
        }
        /// <p>Information about the cache for the build project.</p>
        pub fn set_cache(mut self, input: std::option::Option<crate::model::ProjectCache>) -> Self {
            self.cache = input;
            self
        }
        /// <p>Information about the build environment of the build project.</p>
        pub fn environment(mut self, input: crate::model::ProjectEnvironment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>Information about the build environment of the build project.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::ProjectEnvironment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The name of a service role used for builds in the batch.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The name of a service role used for builds in the batch.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p> Information about logs for a build project. These can be logs in CloudWatch Logs, built in a
        /// specified S3 bucket, or both. </p>
        pub fn log_config(mut self, input: crate::model::LogsConfig) -> Self {
            self.log_config = Some(input);
            self
        }
        /// <p> Information about logs for a build project. These can be logs in CloudWatch Logs, built in a
        /// specified S3 bucket, or both. </p>
        pub fn set_log_config(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.log_config = input;
            self
        }
        /// <p>Specifies the maximum amount of time, in minutes, that the build in a batch must be
        /// completed in.</p>
        pub fn build_timeout_in_minutes(mut self, input: i32) -> Self {
            self.build_timeout_in_minutes = Some(input);
            self
        }
        /// <p>Specifies the maximum amount of time, in minutes, that the build in a batch must be
        /// completed in.</p>
        pub fn set_build_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.build_timeout_in_minutes = input;
            self
        }
        /// <p>Specifies the amount of time, in minutes, that the batch build is allowed to be queued
        /// before it times out.</p>
        pub fn queued_timeout_in_minutes(mut self, input: i32) -> Self {
            self.queued_timeout_in_minutes = Some(input);
            self
        }
        /// <p>Specifies the amount of time, in minutes, that the batch build is allowed to be queued
        /// before it times out.</p>
        pub fn set_queued_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.queued_timeout_in_minutes = input;
            self
        }
        /// <p>Indicates if the batch build is complete.</p>
        pub fn complete(mut self, input: bool) -> Self {
            self.complete = Some(input);
            self
        }
        /// <p>Indicates if the batch build is complete.</p>
        pub fn set_complete(mut self, input: std::option::Option<bool>) -> Self {
            self.complete = input;
            self
        }
        /// <p>The entity that started the batch build. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>If CodePipeline started the build, the pipeline's name (for example,
        /// <code>codepipeline/my-demo-pipeline</code>).</p>
        /// </li>
        /// <li>
        /// <p>If an IAM user started the build, the user's name.</p>
        /// </li>
        /// <li>
        /// <p>If the Jenkins plugin for CodeBuild started the build, the string
        /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
        /// </li>
        /// </ul>
        pub fn initiator(mut self, input: impl Into<std::string::String>) -> Self {
            self.initiator = Some(input.into());
            self
        }
        /// <p>The entity that started the batch build. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>If CodePipeline started the build, the pipeline's name (for example,
        /// <code>codepipeline/my-demo-pipeline</code>).</p>
        /// </li>
        /// <li>
        /// <p>If an IAM user started the build, the user's name.</p>
        /// </li>
        /// <li>
        /// <p>If the Jenkins plugin for CodeBuild started the build, the string
        /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_initiator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.initiator = input;
            self
        }
        /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>Information about the VPC configuration that CodeBuild accesses.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the batch build output
        /// artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the batch build output
        /// artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>The number of the batch build. For each project, the <code>buildBatchNumber</code> of its
        /// first batch build is <code>1</code>. The <code>buildBatchNumber</code> of each subsequent
        /// batch build is incremented by <code>1</code>. If a batch build is deleted, the
        /// <code>buildBatchNumber</code> of other batch builds does not change.</p>
        pub fn build_batch_number(mut self, input: i64) -> Self {
            self.build_batch_number = Some(input);
            self
        }
        /// <p>The number of the batch build. For each project, the <code>buildBatchNumber</code> of its
        /// first batch build is <code>1</code>. The <code>buildBatchNumber</code> of each subsequent
        /// batch build is incremented by <code>1</code>. If a batch build is deleted, the
        /// <code>buildBatchNumber</code> of other batch builds does not change.</p>
        pub fn set_build_batch_number(mut self, input: std::option::Option<i64>) -> Self {
            self.build_batch_number = input;
            self
        }
        /// Appends an item to `file_system_locations`.
        ///
        /// To override the contents of this collection use [`set_file_system_locations`](Self::set_file_system_locations).
        ///
        /// <p>An array of <code>ProjectFileSystemLocation</code> objects for the batch build
        /// project. A <code>ProjectFileSystemLocation</code> object specifies the
        /// <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon
        /// Elastic File System. </p>
        pub fn file_system_locations(
            mut self,
            input: impl Into<crate::model::ProjectFileSystemLocation>,
        ) -> Self {
            let mut v = self.file_system_locations.unwrap_or_default();
            v.push(input.into());
            self.file_system_locations = Some(v);
            self
        }
        /// <p>An array of <code>ProjectFileSystemLocation</code> objects for the batch build
        /// project. A <code>ProjectFileSystemLocation</code> object specifies the
        /// <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon
        /// Elastic File System. </p>
        pub fn set_file_system_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        ) -> Self {
            self.file_system_locations = input;
            self
        }
        /// <p>Contains configuration information about a batch build project.</p>
        pub fn build_batch_config(mut self, input: crate::model::ProjectBuildBatchConfig) -> Self {
            self.build_batch_config = Some(input);
            self
        }
        /// <p>Contains configuration information about a batch build project.</p>
        pub fn set_build_batch_config(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.build_batch_config = input;
            self
        }
        /// Appends an item to `build_groups`.
        ///
        /// To override the contents of this collection use [`set_build_groups`](Self::set_build_groups).
        ///
        /// <p>An array of <code>BuildGroup</code> objects that define the build groups for the
        /// batch build.</p>
        pub fn build_groups(mut self, input: impl Into<crate::model::BuildGroup>) -> Self {
            let mut v = self.build_groups.unwrap_or_default();
            v.push(input.into());
            self.build_groups = Some(v);
            self
        }
        /// <p>An array of <code>BuildGroup</code> objects that define the build groups for the
        /// batch build.</p>
        pub fn set_build_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildGroup>>,
        ) -> Self {
            self.build_groups = input;
            self
        }
        /// <p>Specifies if session debugging is enabled for this batch build. For more information, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
        pub fn debug_session_enabled(mut self, input: bool) -> Self {
            self.debug_session_enabled = Some(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this batch build. For more information, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
        pub fn set_debug_session_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.debug_session_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildBatch`](crate::model::BuildBatch)
        pub fn build(self) -> crate::model::BuildBatch {
            crate::model::BuildBatch {
                id: self.id,
                arn: self.arn,
                start_time: self.start_time,
                end_time: self.end_time,
                current_phase: self.current_phase,
                build_batch_status: self.build_batch_status,
                source_version: self.source_version,
                resolved_source_version: self.resolved_source_version,
                project_name: self.project_name,
                phases: self.phases,
                source: self.source,
                secondary_sources: self.secondary_sources,
                secondary_source_versions: self.secondary_source_versions,
                artifacts: self.artifacts,
                secondary_artifacts: self.secondary_artifacts,
                cache: self.cache,
                environment: self.environment,
                service_role: self.service_role,
                log_config: self.log_config,
                build_timeout_in_minutes: self.build_timeout_in_minutes,
                queued_timeout_in_minutes: self.queued_timeout_in_minutes,
                complete: self.complete.unwrap_or_default(),
                initiator: self.initiator,
                vpc_config: self.vpc_config,
                encryption_key: self.encryption_key,
                build_batch_number: self.build_batch_number,
                file_system_locations: self.file_system_locations,
                build_batch_config: self.build_batch_config,
                build_groups: self.build_groups,
                debug_session_enabled: self.debug_session_enabled,
            }
        }
    }
}
impl BuildBatch {
    /// Creates a new builder-style object to manufacture [`BuildBatch`](crate::model::BuildBatch)
    pub fn builder() -> crate::model::build_batch::Builder {
        crate::model::build_batch::Builder::default()
    }
}

/// <p>Contains information about a batch build build group. Build groups are used to combine
/// builds that can run in parallel, while still being able to set dependencies on other
/// build groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildGroup {
    /// <p>Contains the identifier of the build group.</p>
    pub identifier: std::option::Option<std::string::String>,
    /// <p>An array of strings that contain the identifiers of the build groups that this build
    /// group depends on.</p>
    pub depends_on: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies if failures in this build group can be ignored.</p>
    pub ignore_failure: bool,
    /// <p>A <code>BuildSummary</code> object that contains a summary of the current build
    /// group.</p>
    pub current_build_summary: std::option::Option<crate::model::BuildSummary>,
    /// <p>An array of <code>BuildSummary</code> objects that contain summaries of previous
    /// build groups.</p>
    pub prior_build_summary_list: std::option::Option<std::vec::Vec<crate::model::BuildSummary>>,
}
impl BuildGroup {
    /// <p>Contains the identifier of the build group.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>An array of strings that contain the identifiers of the build groups that this build
    /// group depends on.</p>
    pub fn depends_on(&self) -> std::option::Option<&[std::string::String]> {
        self.depends_on.as_deref()
    }
    /// <p>Specifies if failures in this build group can be ignored.</p>
    pub fn ignore_failure(&self) -> bool {
        self.ignore_failure
    }
    /// <p>A <code>BuildSummary</code> object that contains a summary of the current build
    /// group.</p>
    pub fn current_build_summary(&self) -> std::option::Option<&crate::model::BuildSummary> {
        self.current_build_summary.as_ref()
    }
    /// <p>An array of <code>BuildSummary</code> objects that contain summaries of previous
    /// build groups.</p>
    pub fn prior_build_summary_list(&self) -> std::option::Option<&[crate::model::BuildSummary]> {
        self.prior_build_summary_list.as_deref()
    }
}
impl std::fmt::Debug for BuildGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildGroup");
        formatter.field("identifier", &self.identifier);
        formatter.field("depends_on", &self.depends_on);
        formatter.field("ignore_failure", &self.ignore_failure);
        formatter.field("current_build_summary", &self.current_build_summary);
        formatter.field("prior_build_summary_list", &self.prior_build_summary_list);
        formatter.finish()
    }
}
/// See [`BuildGroup`](crate::model::BuildGroup)
pub mod build_group {
    /// A builder for [`BuildGroup`](crate::model::BuildGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) identifier: std::option::Option<std::string::String>,
        pub(crate) depends_on: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ignore_failure: std::option::Option<bool>,
        pub(crate) current_build_summary: std::option::Option<crate::model::BuildSummary>,
        pub(crate) prior_build_summary_list:
            std::option::Option<std::vec::Vec<crate::model::BuildSummary>>,
    }
    impl Builder {
        /// <p>Contains the identifier of the build group.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>Contains the identifier of the build group.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Appends an item to `depends_on`.
        ///
        /// To override the contents of this collection use [`set_depends_on`](Self::set_depends_on).
        ///
        /// <p>An array of strings that contain the identifiers of the build groups that this build
        /// group depends on.</p>
        pub fn depends_on(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.depends_on.unwrap_or_default();
            v.push(input.into());
            self.depends_on = Some(v);
            self
        }
        /// <p>An array of strings that contain the identifiers of the build groups that this build
        /// group depends on.</p>
        pub fn set_depends_on(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.depends_on = input;
            self
        }
        /// <p>Specifies if failures in this build group can be ignored.</p>
        pub fn ignore_failure(mut self, input: bool) -> Self {
            self.ignore_failure = Some(input);
            self
        }
        /// <p>Specifies if failures in this build group can be ignored.</p>
        pub fn set_ignore_failure(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_failure = input;
            self
        }
        /// <p>A <code>BuildSummary</code> object that contains a summary of the current build
        /// group.</p>
        pub fn current_build_summary(mut self, input: crate::model::BuildSummary) -> Self {
            self.current_build_summary = Some(input);
            self
        }
        /// <p>A <code>BuildSummary</code> object that contains a summary of the current build
        /// group.</p>
        pub fn set_current_build_summary(
            mut self,
            input: std::option::Option<crate::model::BuildSummary>,
        ) -> Self {
            self.current_build_summary = input;
            self
        }
        /// Appends an item to `prior_build_summary_list`.
        ///
        /// To override the contents of this collection use [`set_prior_build_summary_list`](Self::set_prior_build_summary_list).
        ///
        /// <p>An array of <code>BuildSummary</code> objects that contain summaries of previous
        /// build groups.</p>
        pub fn prior_build_summary_list(
            mut self,
            input: impl Into<crate::model::BuildSummary>,
        ) -> Self {
            let mut v = self.prior_build_summary_list.unwrap_or_default();
            v.push(input.into());
            self.prior_build_summary_list = Some(v);
            self
        }
        /// <p>An array of <code>BuildSummary</code> objects that contain summaries of previous
        /// build groups.</p>
        pub fn set_prior_build_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildSummary>>,
        ) -> Self {
            self.prior_build_summary_list = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildGroup`](crate::model::BuildGroup)
        pub fn build(self) -> crate::model::BuildGroup {
            crate::model::BuildGroup {
                identifier: self.identifier,
                depends_on: self.depends_on,
                ignore_failure: self.ignore_failure.unwrap_or_default(),
                current_build_summary: self.current_build_summary,
                prior_build_summary_list: self.prior_build_summary_list,
            }
        }
    }
}
impl BuildGroup {
    /// Creates a new builder-style object to manufacture [`BuildGroup`](crate::model::BuildGroup)
    pub fn builder() -> crate::model::build_group::Builder {
        crate::model::build_group::Builder::default()
    }
}

/// <p>Contains summary information about a batch build group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildSummary {
    /// <p>The batch build ARN.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>When the build was started, expressed in Unix time format.</p>
    pub requested_on: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the build group.</p>
    /// <dl>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>The build group failed.</p>
    /// </dd>
    /// <dt>FAULT</dt>
    /// <dd>
    /// <p>The build group faulted.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The build group is still in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The build group stopped.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The build group succeeded.</p>
    /// </dd>
    /// <dt>TIMED_OUT</dt>
    /// <dd>
    /// <p>The build group timed out.</p>
    /// </dd>
    /// </dl>
    pub build_status: std::option::Option<crate::model::StatusType>,
    /// <p>A <code>ResolvedArtifact</code> object that represents the primary build artifacts for the
    /// build group.</p>
    pub primary_artifact: std::option::Option<crate::model::ResolvedArtifact>,
    /// <p>An array of <code>ResolvedArtifact</code> objects that represents the secondary build
    /// artifacts for the build group.</p>
    pub secondary_artifacts: std::option::Option<std::vec::Vec<crate::model::ResolvedArtifact>>,
}
impl BuildSummary {
    /// <p>The batch build ARN.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>When the build was started, expressed in Unix time format.</p>
    pub fn requested_on(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.requested_on.as_ref()
    }
    /// <p>The status of the build group.</p>
    /// <dl>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>The build group failed.</p>
    /// </dd>
    /// <dt>FAULT</dt>
    /// <dd>
    /// <p>The build group faulted.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The build group is still in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The build group stopped.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The build group succeeded.</p>
    /// </dd>
    /// <dt>TIMED_OUT</dt>
    /// <dd>
    /// <p>The build group timed out.</p>
    /// </dd>
    /// </dl>
    pub fn build_status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.build_status.as_ref()
    }
    /// <p>A <code>ResolvedArtifact</code> object that represents the primary build artifacts for the
    /// build group.</p>
    pub fn primary_artifact(&self) -> std::option::Option<&crate::model::ResolvedArtifact> {
        self.primary_artifact.as_ref()
    }
    /// <p>An array of <code>ResolvedArtifact</code> objects that represents the secondary build
    /// artifacts for the build group.</p>
    pub fn secondary_artifacts(&self) -> std::option::Option<&[crate::model::ResolvedArtifact]> {
        self.secondary_artifacts.as_deref()
    }
}
impl std::fmt::Debug for BuildSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildSummary");
        formatter.field("arn", &self.arn);
        formatter.field("requested_on", &self.requested_on);
        formatter.field("build_status", &self.build_status);
        formatter.field("primary_artifact", &self.primary_artifact);
        formatter.field("secondary_artifacts", &self.secondary_artifacts);
        formatter.finish()
    }
}
/// See [`BuildSummary`](crate::model::BuildSummary)
pub mod build_summary {
    /// A builder for [`BuildSummary`](crate::model::BuildSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) requested_on: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) build_status: std::option::Option<crate::model::StatusType>,
        pub(crate) primary_artifact: std::option::Option<crate::model::ResolvedArtifact>,
        pub(crate) secondary_artifacts:
            std::option::Option<std::vec::Vec<crate::model::ResolvedArtifact>>,
    }
    impl Builder {
        /// <p>The batch build ARN.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The batch build ARN.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>When the build was started, expressed in Unix time format.</p>
        pub fn requested_on(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.requested_on = Some(input);
            self
        }
        /// <p>When the build was started, expressed in Unix time format.</p>
        pub fn set_requested_on(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.requested_on = input;
            self
        }
        /// <p>The status of the build group.</p>
        /// <dl>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The build group failed.</p>
        /// </dd>
        /// <dt>FAULT</dt>
        /// <dd>
        /// <p>The build group faulted.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The build group is still in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The build group stopped.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The build group succeeded.</p>
        /// </dd>
        /// <dt>TIMED_OUT</dt>
        /// <dd>
        /// <p>The build group timed out.</p>
        /// </dd>
        /// </dl>
        pub fn build_status(mut self, input: crate::model::StatusType) -> Self {
            self.build_status = Some(input);
            self
        }
        /// <p>The status of the build group.</p>
        /// <dl>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The build group failed.</p>
        /// </dd>
        /// <dt>FAULT</dt>
        /// <dd>
        /// <p>The build group faulted.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The build group is still in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The build group stopped.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The build group succeeded.</p>
        /// </dd>
        /// <dt>TIMED_OUT</dt>
        /// <dd>
        /// <p>The build group timed out.</p>
        /// </dd>
        /// </dl>
        pub fn set_build_status(
            mut self,
            input: std::option::Option<crate::model::StatusType>,
        ) -> Self {
            self.build_status = input;
            self
        }
        /// <p>A <code>ResolvedArtifact</code> object that represents the primary build artifacts for the
        /// build group.</p>
        pub fn primary_artifact(mut self, input: crate::model::ResolvedArtifact) -> Self {
            self.primary_artifact = Some(input);
            self
        }
        /// <p>A <code>ResolvedArtifact</code> object that represents the primary build artifacts for the
        /// build group.</p>
        pub fn set_primary_artifact(
            mut self,
            input: std::option::Option<crate::model::ResolvedArtifact>,
        ) -> Self {
            self.primary_artifact = input;
            self
        }
        /// Appends an item to `secondary_artifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p>An array of <code>ResolvedArtifact</code> objects that represents the secondary build
        /// artifacts for the build group.</p>
        pub fn secondary_artifacts(
            mut self,
            input: impl Into<crate::model::ResolvedArtifact>,
        ) -> Self {
            let mut v = self.secondary_artifacts.unwrap_or_default();
            v.push(input.into());
            self.secondary_artifacts = Some(v);
            self
        }
        /// <p>An array of <code>ResolvedArtifact</code> objects that represents the secondary build
        /// artifacts for the build group.</p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResolvedArtifact>>,
        ) -> Self {
            self.secondary_artifacts = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildSummary`](crate::model::BuildSummary)
        pub fn build(self) -> crate::model::BuildSummary {
            crate::model::BuildSummary {
                arn: self.arn,
                requested_on: self.requested_on,
                build_status: self.build_status,
                primary_artifact: self.primary_artifact,
                secondary_artifacts: self.secondary_artifacts,
            }
        }
    }
}
impl BuildSummary {
    /// Creates a new builder-style object to manufacture [`BuildSummary`](crate::model::BuildSummary)
    pub fn builder() -> crate::model::build_summary::Builder {
        crate::model::build_summary::Builder::default()
    }
}

/// <p>Represents a resolved build artifact. A resolved artifact is an artifact that is built and
/// deployed to the destination, such as Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolvedArtifact {
    /// <p>Specifies the type of artifact.</p>
    pub r#type: std::option::Option<crate::model::ArtifactsType>,
    /// <p>The location of the artifact.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The identifier of the artifact.</p>
    pub identifier: std::option::Option<std::string::String>,
}
impl ResolvedArtifact {
    /// <p>Specifies the type of artifact.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ArtifactsType> {
        self.r#type.as_ref()
    }
    /// <p>The location of the artifact.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The identifier of the artifact.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
}
impl std::fmt::Debug for ResolvedArtifact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolvedArtifact");
        formatter.field("r#type", &self.r#type);
        formatter.field("location", &self.location);
        formatter.field("identifier", &self.identifier);
        formatter.finish()
    }
}
/// See [`ResolvedArtifact`](crate::model::ResolvedArtifact)
pub mod resolved_artifact {
    /// A builder for [`ResolvedArtifact`](crate::model::ResolvedArtifact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::ArtifactsType>,
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the type of artifact.</p>
        pub fn r#type(mut self, input: crate::model::ArtifactsType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the type of artifact.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ArtifactsType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The location of the artifact.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>The location of the artifact.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The identifier of the artifact.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the artifact.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolvedArtifact`](crate::model::ResolvedArtifact)
        pub fn build(self) -> crate::model::ResolvedArtifact {
            crate::model::ResolvedArtifact {
                r#type: self.r#type,
                location: self.location,
                identifier: self.identifier,
            }
        }
    }
}
impl ResolvedArtifact {
    /// Creates a new builder-style object to manufacture [`ResolvedArtifact`](crate::model::ResolvedArtifact)
    pub fn builder() -> crate::model::resolved_artifact::Builder {
        crate::model::resolved_artifact::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Fault,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    #[allow(missing_docs)] // documentation missing in model
    TimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusType {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => StatusType::Failed,
            "FAULT" => StatusType::Fault,
            "IN_PROGRESS" => StatusType::InProgress,
            "STOPPED" => StatusType::Stopped,
            "SUCCEEDED" => StatusType::Succeeded,
            "TIMED_OUT" => StatusType::TimedOut,
            other => StatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusType::from(s))
    }
}
impl StatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusType::Failed => "FAILED",
            StatusType::Fault => "FAULT",
            StatusType::InProgress => "IN_PROGRESS",
            StatusType::Stopped => "STOPPED",
            StatusType::Succeeded => "SUCCEEDED",
            StatusType::TimedOut => "TIMED_OUT",
            StatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "FAULT",
            "IN_PROGRESS",
            "STOPPED",
            "SUCCEEDED",
            "TIMED_OUT",
        ]
    }
}
impl AsRef<str> for StatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about build output artifacts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildArtifacts {
    /// <p>Information about the location of the build artifacts.</p>
    pub location: std::option::Option<std::string::String>,
    /// <p>The SHA-256 hash of the build artifact.</p>
    /// <p>You can use this hash along with a checksum tool to confirm file integrity and
    /// authenticity.</p>
    /// <note>
    /// <p>This value is available only if the build project's <code>packaging</code> value
    /// is set to <code>ZIP</code>.</p>
    /// </note>
    pub sha256sum: std::option::Option<std::string::String>,
    /// <p>The MD5 hash of the build artifact.</p>
    /// <p>You can use this hash along with a checksum tool to confirm file integrity and
    /// authenticity.</p>
    /// <note>
    /// <p>This value is available only if the build project's <code>packaging</code> value
    /// is set to <code>ZIP</code>.</p>
    /// </note>
    pub md5sum: std::option::Option<std::string::String>,
    /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
    /// name. The name specified in a buildspec file is calculated at build time and uses the
    /// Shell Command Language. For example, you can append a date and time to your artifact
    /// name so that it is always unique. </p>
    pub override_artifact_name: std::option::Option<bool>,
    /// <p> Information that tells you if encryption for build artifacts is disabled. </p>
    pub encryption_disabled: std::option::Option<bool>,
    /// <p> An identifier for this artifact definition. </p>
    pub artifact_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the bucket owner's access for objects that another account uploads to their
    /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
    /// access to these objects. This property allows you to give the bucket owner access to
    /// these objects.</p>
    /// <note>
    /// <p>To use this property, your CodeBuild service role must have the
    /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
    /// the access control list for the bucket.</p>
    /// </note>
    /// <p>This property can be one of the following values:</p>
    /// <dl>
    /// <dt>NONE</dt>
    /// <dd>
    /// <p>The bucket owner does not have access to the objects. This is the
    /// default.</p>
    /// </dd>
    /// <dt>READ_ONLY</dt>
    /// <dd>
    /// <p>The bucket owner has read-only access to the objects. The uploading account
    /// retains ownership of the objects.</p>
    /// </dd>
    /// <dt>FULL</dt>
    /// <dd>
    /// <p>The bucket owner has full access to the objects. Object ownership is determined
    /// by the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>If the bucket is configured with the <b>Bucket
    /// owner preferred</b> setting, the bucket owner owns the
    /// objects. The uploading account will have object access as specified
    /// by the bucket's policy.</p>
    /// </li>
    /// <li>
    /// <p>Otherwise, the uploading account retains ownership of the
    /// objects.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
    /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
    /// Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub bucket_owner_access: std::option::Option<crate::model::BucketOwnerAccess>,
}
impl BuildArtifacts {
    /// <p>Information about the location of the build artifacts.</p>
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
    /// <p>The SHA-256 hash of the build artifact.</p>
    /// <p>You can use this hash along with a checksum tool to confirm file integrity and
    /// authenticity.</p>
    /// <note>
    /// <p>This value is available only if the build project's <code>packaging</code> value
    /// is set to <code>ZIP</code>.</p>
    /// </note>
    pub fn sha256sum(&self) -> std::option::Option<&str> {
        self.sha256sum.as_deref()
    }
    /// <p>The MD5 hash of the build artifact.</p>
    /// <p>You can use this hash along with a checksum tool to confirm file integrity and
    /// authenticity.</p>
    /// <note>
    /// <p>This value is available only if the build project's <code>packaging</code> value
    /// is set to <code>ZIP</code>.</p>
    /// </note>
    pub fn md5sum(&self) -> std::option::Option<&str> {
        self.md5sum.as_deref()
    }
    /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
    /// name. The name specified in a buildspec file is calculated at build time and uses the
    /// Shell Command Language. For example, you can append a date and time to your artifact
    /// name so that it is always unique. </p>
    pub fn override_artifact_name(&self) -> std::option::Option<bool> {
        self.override_artifact_name
    }
    /// <p> Information that tells you if encryption for build artifacts is disabled. </p>
    pub fn encryption_disabled(&self) -> std::option::Option<bool> {
        self.encryption_disabled
    }
    /// <p> An identifier for this artifact definition. </p>
    pub fn artifact_identifier(&self) -> std::option::Option<&str> {
        self.artifact_identifier.as_deref()
    }
    /// <p>Specifies the bucket owner's access for objects that another account uploads to their
    /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
    /// access to these objects. This property allows you to give the bucket owner access to
    /// these objects.</p>
    /// <note>
    /// <p>To use this property, your CodeBuild service role must have the
    /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
    /// the access control list for the bucket.</p>
    /// </note>
    /// <p>This property can be one of the following values:</p>
    /// <dl>
    /// <dt>NONE</dt>
    /// <dd>
    /// <p>The bucket owner does not have access to the objects. This is the
    /// default.</p>
    /// </dd>
    /// <dt>READ_ONLY</dt>
    /// <dd>
    /// <p>The bucket owner has read-only access to the objects. The uploading account
    /// retains ownership of the objects.</p>
    /// </dd>
    /// <dt>FULL</dt>
    /// <dd>
    /// <p>The bucket owner has full access to the objects. Object ownership is determined
    /// by the following criteria:</p>
    /// <ul>
    /// <li>
    /// <p>If the bucket is configured with the <b>Bucket
    /// owner preferred</b> setting, the bucket owner owns the
    /// objects. The uploading account will have object access as specified
    /// by the bucket's policy.</p>
    /// </li>
    /// <li>
    /// <p>Otherwise, the uploading account retains ownership of the
    /// objects.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
    /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
    /// Guide</i>.</p>
    /// </dd>
    /// </dl>
    pub fn bucket_owner_access(&self) -> std::option::Option<&crate::model::BucketOwnerAccess> {
        self.bucket_owner_access.as_ref()
    }
}
impl std::fmt::Debug for BuildArtifacts {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildArtifacts");
        formatter.field("location", &self.location);
        formatter.field("sha256sum", &self.sha256sum);
        formatter.field("md5sum", &self.md5sum);
        formatter.field("override_artifact_name", &self.override_artifact_name);
        formatter.field("encryption_disabled", &self.encryption_disabled);
        formatter.field("artifact_identifier", &self.artifact_identifier);
        formatter.field("bucket_owner_access", &self.bucket_owner_access);
        formatter.finish()
    }
}
/// See [`BuildArtifacts`](crate::model::BuildArtifacts)
pub mod build_artifacts {
    /// A builder for [`BuildArtifacts`](crate::model::BuildArtifacts)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) sha256sum: std::option::Option<std::string::String>,
        pub(crate) md5sum: std::option::Option<std::string::String>,
        pub(crate) override_artifact_name: std::option::Option<bool>,
        pub(crate) encryption_disabled: std::option::Option<bool>,
        pub(crate) artifact_identifier: std::option::Option<std::string::String>,
        pub(crate) bucket_owner_access: std::option::Option<crate::model::BucketOwnerAccess>,
    }
    impl Builder {
        /// <p>Information about the location of the build artifacts.</p>
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        /// <p>Information about the location of the build artifacts.</p>
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        /// <p>The SHA-256 hash of the build artifact.</p>
        /// <p>You can use this hash along with a checksum tool to confirm file integrity and
        /// authenticity.</p>
        /// <note>
        /// <p>This value is available only if the build project's <code>packaging</code> value
        /// is set to <code>ZIP</code>.</p>
        /// </note>
        pub fn sha256sum(mut self, input: impl Into<std::string::String>) -> Self {
            self.sha256sum = Some(input.into());
            self
        }
        /// <p>The SHA-256 hash of the build artifact.</p>
        /// <p>You can use this hash along with a checksum tool to confirm file integrity and
        /// authenticity.</p>
        /// <note>
        /// <p>This value is available only if the build project's <code>packaging</code> value
        /// is set to <code>ZIP</code>.</p>
        /// </note>
        pub fn set_sha256sum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sha256sum = input;
            self
        }
        /// <p>The MD5 hash of the build artifact.</p>
        /// <p>You can use this hash along with a checksum tool to confirm file integrity and
        /// authenticity.</p>
        /// <note>
        /// <p>This value is available only if the build project's <code>packaging</code> value
        /// is set to <code>ZIP</code>.</p>
        /// </note>
        pub fn md5sum(mut self, input: impl Into<std::string::String>) -> Self {
            self.md5sum = Some(input.into());
            self
        }
        /// <p>The MD5 hash of the build artifact.</p>
        /// <p>You can use this hash along with a checksum tool to confirm file integrity and
        /// authenticity.</p>
        /// <note>
        /// <p>This value is available only if the build project's <code>packaging</code> value
        /// is set to <code>ZIP</code>.</p>
        /// </note>
        pub fn set_md5sum(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.md5sum = input;
            self
        }
        /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
        /// name. The name specified in a buildspec file is calculated at build time and uses the
        /// Shell Command Language. For example, you can append a date and time to your artifact
        /// name so that it is always unique. </p>
        pub fn override_artifact_name(mut self, input: bool) -> Self {
            self.override_artifact_name = Some(input);
            self
        }
        /// <p> If this flag is set, a name specified in the buildspec file overrides the artifact
        /// name. The name specified in a buildspec file is calculated at build time and uses the
        /// Shell Command Language. For example, you can append a date and time to your artifact
        /// name so that it is always unique. </p>
        pub fn set_override_artifact_name(mut self, input: std::option::Option<bool>) -> Self {
            self.override_artifact_name = input;
            self
        }
        /// <p> Information that tells you if encryption for build artifacts is disabled. </p>
        pub fn encryption_disabled(mut self, input: bool) -> Self {
            self.encryption_disabled = Some(input);
            self
        }
        /// <p> Information that tells you if encryption for build artifacts is disabled. </p>
        pub fn set_encryption_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.encryption_disabled = input;
            self
        }
        /// <p> An identifier for this artifact definition. </p>
        pub fn artifact_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.artifact_identifier = Some(input.into());
            self
        }
        /// <p> An identifier for this artifact definition. </p>
        pub fn set_artifact_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.artifact_identifier = input;
            self
        }
        /// <p>Specifies the bucket owner's access for objects that another account uploads to their
        /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
        /// access to these objects. This property allows you to give the bucket owner access to
        /// these objects.</p>
        /// <note>
        /// <p>To use this property, your CodeBuild service role must have the
        /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
        /// the access control list for the bucket.</p>
        /// </note>
        /// <p>This property can be one of the following values:</p>
        /// <dl>
        /// <dt>NONE</dt>
        /// <dd>
        /// <p>The bucket owner does not have access to the objects. This is the
        /// default.</p>
        /// </dd>
        /// <dt>READ_ONLY</dt>
        /// <dd>
        /// <p>The bucket owner has read-only access to the objects. The uploading account
        /// retains ownership of the objects.</p>
        /// </dd>
        /// <dt>FULL</dt>
        /// <dd>
        /// <p>The bucket owner has full access to the objects. Object ownership is determined
        /// by the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>If the bucket is configured with the <b>Bucket
        /// owner preferred</b> setting, the bucket owner owns the
        /// objects. The uploading account will have object access as specified
        /// by the bucket's policy.</p>
        /// </li>
        /// <li>
        /// <p>Otherwise, the uploading account retains ownership of the
        /// objects.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
        /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
        /// Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn bucket_owner_access(mut self, input: crate::model::BucketOwnerAccess) -> Self {
            self.bucket_owner_access = Some(input);
            self
        }
        /// <p>Specifies the bucket owner's access for objects that another account uploads to their
        /// Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has
        /// access to these objects. This property allows you to give the bucket owner access to
        /// these objects.</p>
        /// <note>
        /// <p>To use this property, your CodeBuild service role must have the
        /// <code>s3:PutBucketAcl</code> permission. This permission allows CodeBuild to modify
        /// the access control list for the bucket.</p>
        /// </note>
        /// <p>This property can be one of the following values:</p>
        /// <dl>
        /// <dt>NONE</dt>
        /// <dd>
        /// <p>The bucket owner does not have access to the objects. This is the
        /// default.</p>
        /// </dd>
        /// <dt>READ_ONLY</dt>
        /// <dd>
        /// <p>The bucket owner has read-only access to the objects. The uploading account
        /// retains ownership of the objects.</p>
        /// </dd>
        /// <dt>FULL</dt>
        /// <dd>
        /// <p>The bucket owner has full access to the objects. Object ownership is determined
        /// by the following criteria:</p>
        /// <ul>
        /// <li>
        /// <p>If the bucket is configured with the <b>Bucket
        /// owner preferred</b> setting, the bucket owner owns the
        /// objects. The uploading account will have object access as specified
        /// by the bucket's policy.</p>
        /// </li>
        /// <li>
        /// <p>Otherwise, the uploading account retains ownership of the
        /// objects.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon S3 object ownership, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html">Controlling ownership of uploaded objects using S3
        /// Object Ownership</a> in the <i>Amazon Simple Storage Service User
        /// Guide</i>.</p>
        /// </dd>
        /// </dl>
        pub fn set_bucket_owner_access(
            mut self,
            input: std::option::Option<crate::model::BucketOwnerAccess>,
        ) -> Self {
            self.bucket_owner_access = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildArtifacts`](crate::model::BuildArtifacts)
        pub fn build(self) -> crate::model::BuildArtifacts {
            crate::model::BuildArtifacts {
                location: self.location,
                sha256sum: self.sha256sum,
                md5sum: self.md5sum,
                override_artifact_name: self.override_artifact_name,
                encryption_disabled: self.encryption_disabled,
                artifact_identifier: self.artifact_identifier,
                bucket_owner_access: self.bucket_owner_access,
            }
        }
    }
}
impl BuildArtifacts {
    /// Creates a new builder-style object to manufacture [`BuildArtifacts`](crate::model::BuildArtifacts)
    pub fn builder() -> crate::model::build_artifacts::Builder {
        crate::model::build_artifacts::Builder::default()
    }
}

/// <p>Contains information about a stage for a batch build.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildBatchPhase {
    /// <p>The name of the batch build phase. Valid values include:</p>
    /// <dl>
    /// <dt>COMBINE_ARTIFACTS</dt>
    /// <dd>
    /// <p>Build output artifacts are being combined and uploaded to the output
    /// location.</p>
    /// </dd>
    /// <dt>DOWNLOAD_BATCHSPEC</dt>
    /// <dd>
    /// <p>The batch build specification is being downloaded.</p>
    /// </dd>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>One or more of the builds failed.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The batch build is in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The batch build was stopped.</p>
    /// </dd>
    /// <dt>SUBMITTED</dt>
    /// <dd>
    /// <p>The btach build has been submitted.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The batch build succeeded.</p>
    /// </dd>
    /// </dl>
    pub phase_type: std::option::Option<crate::model::BuildBatchPhaseType>,
    /// <p>The current status of the batch build phase. Valid values include:</p>
    /// <dl>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>The build phase failed.</p>
    /// </dd>
    /// <dt>FAULT</dt>
    /// <dd>
    /// <p>The build phase faulted.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The build phase is still in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The build phase stopped.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The build phase succeeded.</p>
    /// </dd>
    /// <dt>TIMED_OUT</dt>
    /// <dd>
    /// <p>The build phase timed out.</p>
    /// </dd>
    /// </dl>
    pub phase_status: std::option::Option<crate::model::StatusType>,
    /// <p>When the batch build phase started, expressed in Unix time format.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the batch build phase ended, expressed in Unix time format.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>How long, in seconds, between the starting and ending times of the batch build's
    /// phase.</p>
    pub duration_in_seconds: std::option::Option<i64>,
    /// <p>Additional information about the batch build phase. Especially to help troubleshoot a
    /// failed batch build.</p>
    pub contexts: std::option::Option<std::vec::Vec<crate::model::PhaseContext>>,
}
impl BuildBatchPhase {
    /// <p>The name of the batch build phase. Valid values include:</p>
    /// <dl>
    /// <dt>COMBINE_ARTIFACTS</dt>
    /// <dd>
    /// <p>Build output artifacts are being combined and uploaded to the output
    /// location.</p>
    /// </dd>
    /// <dt>DOWNLOAD_BATCHSPEC</dt>
    /// <dd>
    /// <p>The batch build specification is being downloaded.</p>
    /// </dd>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>One or more of the builds failed.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The batch build is in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The batch build was stopped.</p>
    /// </dd>
    /// <dt>SUBMITTED</dt>
    /// <dd>
    /// <p>The btach build has been submitted.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The batch build succeeded.</p>
    /// </dd>
    /// </dl>
    pub fn phase_type(&self) -> std::option::Option<&crate::model::BuildBatchPhaseType> {
        self.phase_type.as_ref()
    }
    /// <p>The current status of the batch build phase. Valid values include:</p>
    /// <dl>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>The build phase failed.</p>
    /// </dd>
    /// <dt>FAULT</dt>
    /// <dd>
    /// <p>The build phase faulted.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The build phase is still in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The build phase stopped.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The build phase succeeded.</p>
    /// </dd>
    /// <dt>TIMED_OUT</dt>
    /// <dd>
    /// <p>The build phase timed out.</p>
    /// </dd>
    /// </dl>
    pub fn phase_status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.phase_status.as_ref()
    }
    /// <p>When the batch build phase started, expressed in Unix time format.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>When the batch build phase ended, expressed in Unix time format.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>How long, in seconds, between the starting and ending times of the batch build's
    /// phase.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i64> {
        self.duration_in_seconds
    }
    /// <p>Additional information about the batch build phase. Especially to help troubleshoot a
    /// failed batch build.</p>
    pub fn contexts(&self) -> std::option::Option<&[crate::model::PhaseContext]> {
        self.contexts.as_deref()
    }
}
impl std::fmt::Debug for BuildBatchPhase {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildBatchPhase");
        formatter.field("phase_type", &self.phase_type);
        formatter.field("phase_status", &self.phase_status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.field("contexts", &self.contexts);
        formatter.finish()
    }
}
/// See [`BuildBatchPhase`](crate::model::BuildBatchPhase)
pub mod build_batch_phase {
    /// A builder for [`BuildBatchPhase`](crate::model::BuildBatchPhase)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phase_type: std::option::Option<crate::model::BuildBatchPhaseType>,
        pub(crate) phase_status: std::option::Option<crate::model::StatusType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration_in_seconds: std::option::Option<i64>,
        pub(crate) contexts: std::option::Option<std::vec::Vec<crate::model::PhaseContext>>,
    }
    impl Builder {
        /// <p>The name of the batch build phase. Valid values include:</p>
        /// <dl>
        /// <dt>COMBINE_ARTIFACTS</dt>
        /// <dd>
        /// <p>Build output artifacts are being combined and uploaded to the output
        /// location.</p>
        /// </dd>
        /// <dt>DOWNLOAD_BATCHSPEC</dt>
        /// <dd>
        /// <p>The batch build specification is being downloaded.</p>
        /// </dd>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>One or more of the builds failed.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The batch build is in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The batch build was stopped.</p>
        /// </dd>
        /// <dt>SUBMITTED</dt>
        /// <dd>
        /// <p>The btach build has been submitted.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The batch build succeeded.</p>
        /// </dd>
        /// </dl>
        pub fn phase_type(mut self, input: crate::model::BuildBatchPhaseType) -> Self {
            self.phase_type = Some(input);
            self
        }
        /// <p>The name of the batch build phase. Valid values include:</p>
        /// <dl>
        /// <dt>COMBINE_ARTIFACTS</dt>
        /// <dd>
        /// <p>Build output artifacts are being combined and uploaded to the output
        /// location.</p>
        /// </dd>
        /// <dt>DOWNLOAD_BATCHSPEC</dt>
        /// <dd>
        /// <p>The batch build specification is being downloaded.</p>
        /// </dd>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>One or more of the builds failed.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The batch build is in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The batch build was stopped.</p>
        /// </dd>
        /// <dt>SUBMITTED</dt>
        /// <dd>
        /// <p>The btach build has been submitted.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The batch build succeeded.</p>
        /// </dd>
        /// </dl>
        pub fn set_phase_type(
            mut self,
            input: std::option::Option<crate::model::BuildBatchPhaseType>,
        ) -> Self {
            self.phase_type = input;
            self
        }
        /// <p>The current status of the batch build phase. Valid values include:</p>
        /// <dl>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The build phase failed.</p>
        /// </dd>
        /// <dt>FAULT</dt>
        /// <dd>
        /// <p>The build phase faulted.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The build phase is still in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The build phase stopped.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The build phase succeeded.</p>
        /// </dd>
        /// <dt>TIMED_OUT</dt>
        /// <dd>
        /// <p>The build phase timed out.</p>
        /// </dd>
        /// </dl>
        pub fn phase_status(mut self, input: crate::model::StatusType) -> Self {
            self.phase_status = Some(input);
            self
        }
        /// <p>The current status of the batch build phase. Valid values include:</p>
        /// <dl>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The build phase failed.</p>
        /// </dd>
        /// <dt>FAULT</dt>
        /// <dd>
        /// <p>The build phase faulted.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The build phase is still in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The build phase stopped.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The build phase succeeded.</p>
        /// </dd>
        /// <dt>TIMED_OUT</dt>
        /// <dd>
        /// <p>The build phase timed out.</p>
        /// </dd>
        /// </dl>
        pub fn set_phase_status(
            mut self,
            input: std::option::Option<crate::model::StatusType>,
        ) -> Self {
            self.phase_status = input;
            self
        }
        /// <p>When the batch build phase started, expressed in Unix time format.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>When the batch build phase started, expressed in Unix time format.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>When the batch build phase ended, expressed in Unix time format.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>When the batch build phase ended, expressed in Unix time format.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>How long, in seconds, between the starting and ending times of the batch build's
        /// phase.</p>
        pub fn duration_in_seconds(mut self, input: i64) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>How long, in seconds, between the starting and ending times of the batch build's
        /// phase.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Appends an item to `contexts`.
        ///
        /// To override the contents of this collection use [`set_contexts`](Self::set_contexts).
        ///
        /// <p>Additional information about the batch build phase. Especially to help troubleshoot a
        /// failed batch build.</p>
        pub fn contexts(mut self, input: impl Into<crate::model::PhaseContext>) -> Self {
            let mut v = self.contexts.unwrap_or_default();
            v.push(input.into());
            self.contexts = Some(v);
            self
        }
        /// <p>Additional information about the batch build phase. Especially to help troubleshoot a
        /// failed batch build.</p>
        pub fn set_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhaseContext>>,
        ) -> Self {
            self.contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildBatchPhase`](crate::model::BuildBatchPhase)
        pub fn build(self) -> crate::model::BuildBatchPhase {
            crate::model::BuildBatchPhase {
                phase_type: self.phase_type,
                phase_status: self.phase_status,
                start_time: self.start_time,
                end_time: self.end_time,
                duration_in_seconds: self.duration_in_seconds,
                contexts: self.contexts,
            }
        }
    }
}
impl BuildBatchPhase {
    /// Creates a new builder-style object to manufacture [`BuildBatchPhase`](crate::model::BuildBatchPhase)
    pub fn builder() -> crate::model::build_batch_phase::Builder {
        crate::model::build_batch_phase::Builder::default()
    }
}

/// <p>Additional information about a build phase that has an error. You can use this
/// information for troubleshooting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PhaseContext {
    /// <p>The status code for the context of the build phase.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>An explanation of the build phase's context. This might include a command ID and an
    /// exit code.</p>
    pub message: std::option::Option<std::string::String>,
}
impl PhaseContext {
    /// <p>The status code for the context of the build phase.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
    /// <p>An explanation of the build phase's context. This might include a command ID and an
    /// exit code.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for PhaseContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PhaseContext");
        formatter.field("status_code", &self.status_code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`PhaseContext`](crate::model::PhaseContext)
pub mod phase_context {
    /// A builder for [`PhaseContext`](crate::model::PhaseContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status code for the context of the build phase.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The status code for the context of the build phase.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// <p>An explanation of the build phase's context. This might include a command ID and an
        /// exit code.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An explanation of the build phase's context. This might include a command ID and an
        /// exit code.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PhaseContext`](crate::model::PhaseContext)
        pub fn build(self) -> crate::model::PhaseContext {
            crate::model::PhaseContext {
                status_code: self.status_code,
                message: self.message,
            }
        }
    }
}
impl PhaseContext {
    /// Creates a new builder-style object to manufacture [`PhaseContext`](crate::model::PhaseContext)
    pub fn builder() -> crate::model::phase_context::Builder {
        crate::model::phase_context::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BuildBatchPhaseType {
    #[allow(missing_docs)] // documentation missing in model
    CombineArtifacts,
    #[allow(missing_docs)] // documentation missing in model
    DownloadBatchspec,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BuildBatchPhaseType {
    fn from(s: &str) -> Self {
        match s {
            "COMBINE_ARTIFACTS" => BuildBatchPhaseType::CombineArtifacts,
            "DOWNLOAD_BATCHSPEC" => BuildBatchPhaseType::DownloadBatchspec,
            "FAILED" => BuildBatchPhaseType::Failed,
            "IN_PROGRESS" => BuildBatchPhaseType::InProgress,
            "STOPPED" => BuildBatchPhaseType::Stopped,
            "SUBMITTED" => BuildBatchPhaseType::Submitted,
            "SUCCEEDED" => BuildBatchPhaseType::Succeeded,
            other => BuildBatchPhaseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BuildBatchPhaseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BuildBatchPhaseType::from(s))
    }
}
impl BuildBatchPhaseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BuildBatchPhaseType::CombineArtifacts => "COMBINE_ARTIFACTS",
            BuildBatchPhaseType::DownloadBatchspec => "DOWNLOAD_BATCHSPEC",
            BuildBatchPhaseType::Failed => "FAILED",
            BuildBatchPhaseType::InProgress => "IN_PROGRESS",
            BuildBatchPhaseType::Stopped => "STOPPED",
            BuildBatchPhaseType::Submitted => "SUBMITTED",
            BuildBatchPhaseType::Succeeded => "SUCCEEDED",
            BuildBatchPhaseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMBINE_ARTIFACTS",
            "DOWNLOAD_BATCHSPEC",
            "FAILED",
            "IN_PROGRESS",
            "STOPPED",
            "SUBMITTED",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for BuildBatchPhaseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a build.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Build {
    /// <p>The unique ID for the build.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the build.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The number of the build. For each project, the <code>buildNumber</code> of its first
    /// build is <code>1</code>. The <code>buildNumber</code> of each subsequent build is
    /// incremented by <code>1</code>. If a build is deleted, the <code>buildNumber</code> of
    /// other builds does not change.</p>
    pub build_number: std::option::Option<i64>,
    /// <p>When the build process started, expressed in Unix time format.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the build process ended, expressed in Unix time format.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The current build phase.</p>
    pub current_phase: std::option::Option<std::string::String>,
    /// <p>The current status of the build. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The build failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAULT</code>: The build faulted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The build is still in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code>: The build stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCEEDED</code>: The build succeeded.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIMED_OUT</code>: The build timed out.</p>
    /// </li>
    /// </ul>
    pub build_status: std::option::Option<crate::model::StatusType>,
    /// <p>Any version identifier for the version of the source code to be built. If
    /// <code>sourceVersion</code> is specified at the project level, then this
    /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
    /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    pub source_version: std::option::Option<std::string::String>,
    /// <p> An identifier for the version of this build's source code. </p>
    /// <ul>
    /// <li>
    /// <p> For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID. </p>
    /// </li>
    /// <li>
    /// <p> For CodePipeline, the source revision provided by CodePipeline. </p>
    /// </li>
    /// <li>
    /// <p> For Amazon S3, this does not apply. </p>
    /// </li>
    /// </ul>
    pub resolved_source_version: std::option::Option<std::string::String>,
    /// <p>The name of the CodeBuild project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>Information about all previous build phases that are complete and information about
    /// any current build phase that is not yet complete.</p>
    pub phases: std::option::Option<std::vec::Vec<crate::model::BuildPhase>>,
    /// <p>Information about the source code to be built.</p>
    pub source: std::option::Option<crate::model::ProjectSource>,
    /// <p> An array of <code>ProjectSource</code> objects. </p>
    pub secondary_sources: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
    /// <p> An array of <code>ProjectSourceVersion</code> objects. Each
    /// <code>ProjectSourceVersion</code> must be one of: </p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    pub secondary_source_versions:
        std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
    /// <p>Information about the output artifacts for the build.</p>
    pub artifacts: std::option::Option<crate::model::BuildArtifacts>,
    /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
    pub secondary_artifacts: std::option::Option<std::vec::Vec<crate::model::BuildArtifacts>>,
    /// <p>Information about the cache for the build.</p>
    pub cache: std::option::Option<crate::model::ProjectCache>,
    /// <p>Information about the build environment for this build.</p>
    pub environment: std::option::Option<crate::model::ProjectEnvironment>,
    /// <p>The name of a service role used for this build.</p>
    pub service_role: std::option::Option<std::string::String>,
    /// <p>Information about the build's logs in CloudWatch Logs.</p>
    pub logs: std::option::Option<crate::model::LogsLocation>,
    /// <p>How long, in minutes, for CodeBuild to wait before timing out this build if it does not
    /// get marked as completed.</p>
    pub timeout_in_minutes: std::option::Option<i32>,
    /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
    pub queued_timeout_in_minutes: std::option::Option<i32>,
    /// <p>Whether the build is complete. True if complete; otherwise, false.</p>
    pub build_complete: bool,
    /// <p>The entity that started the build. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>If CodePipeline started the build, the pipeline's name (for example,
    /// <code>codepipeline/my-demo-pipeline</code>).</p>
    /// </li>
    /// <li>
    /// <p>If an IAM user started the build, the user's name (for example,
    /// <code>MyUserName</code>).</p>
    /// </li>
    /// <li>
    /// <p>If the Jenkins plugin for CodeBuild started the build, the string
    /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
    /// </li>
    /// </ul>
    pub initiator: std::option::Option<std::string::String>,
    /// <p>If your CodeBuild project accesses resources in an Amazon VPC, you provide this parameter
    /// that identifies the VPC ID and the list of security group IDs and subnet IDs. The
    /// security groups and subnets must belong to the same VPC. You must provide at least one
    /// security group and one subnet ID.</p>
    pub vpc_config: std::option::Option<crate::model::VpcConfig>,
    /// <p>Describes a network interface.</p>
    pub network_interface: std::option::Option<crate::model::NetworkInterface>,
    /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
    /// artifacts.</p>
    /// <note>
    /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
    /// service role has permission to that key. </p>
    /// </note>
    /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
    /// the format <code>alias/<alias-name></code>).</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>A list of exported environment variables for this build.</p>
    /// <p>Exported environment variables are used in conjunction with CodePipeline to export
    /// environment variables from the current build stage to subsequent stages in the pipeline.
    /// For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html">Working with variables</a> in the <i>CodePipeline User Guide</i>.</p>
    pub exported_environment_variables:
        std::option::Option<std::vec::Vec<crate::model::ExportedEnvironmentVariable>>,
    /// <p> An array of the ARNs associated with this build's reports. </p>
    pub report_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
    /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
    /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
    /// </p>
    pub file_system_locations:
        std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
    /// <p>Contains information about the debug session for this build.</p>
    pub debug_session: std::option::Option<crate::model::DebugSession>,
    /// <p>The ARN of the batch build that this build is a member of, if applicable.</p>
    pub build_batch_arn: std::option::Option<std::string::String>,
}
impl Build {
    /// <p>The unique ID for the build.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the build.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The number of the build. For each project, the <code>buildNumber</code> of its first
    /// build is <code>1</code>. The <code>buildNumber</code> of each subsequent build is
    /// incremented by <code>1</code>. If a build is deleted, the <code>buildNumber</code> of
    /// other builds does not change.</p>
    pub fn build_number(&self) -> std::option::Option<i64> {
        self.build_number
    }
    /// <p>When the build process started, expressed in Unix time format.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>When the build process ended, expressed in Unix time format.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>The current build phase.</p>
    pub fn current_phase(&self) -> std::option::Option<&str> {
        self.current_phase.as_deref()
    }
    /// <p>The current status of the build. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>FAILED</code>: The build failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAULT</code>: The build faulted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code>: The build is still in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>STOPPED</code>: The build stopped.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SUCCEEDED</code>: The build succeeded.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIMED_OUT</code>: The build timed out.</p>
    /// </li>
    /// </ul>
    pub fn build_status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.build_status.as_ref()
    }
    /// <p>Any version identifier for the version of the source code to be built. If
    /// <code>sourceVersion</code> is specified at the project level, then this
    /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
    /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
    /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
    /// <p> An identifier for the version of this build's source code. </p>
    /// <ul>
    /// <li>
    /// <p> For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID. </p>
    /// </li>
    /// <li>
    /// <p> For CodePipeline, the source revision provided by CodePipeline. </p>
    /// </li>
    /// <li>
    /// <p> For Amazon S3, this does not apply. </p>
    /// </li>
    /// </ul>
    pub fn resolved_source_version(&self) -> std::option::Option<&str> {
        self.resolved_source_version.as_deref()
    }
    /// <p>The name of the CodeBuild project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>Information about all previous build phases that are complete and information about
    /// any current build phase that is not yet complete.</p>
    pub fn phases(&self) -> std::option::Option<&[crate::model::BuildPhase]> {
        self.phases.as_deref()
    }
    /// <p>Information about the source code to be built.</p>
    pub fn source(&self) -> std::option::Option<&crate::model::ProjectSource> {
        self.source.as_ref()
    }
    /// <p> An array of <code>ProjectSource</code> objects. </p>
    pub fn secondary_sources(&self) -> std::option::Option<&[crate::model::ProjectSource]> {
        self.secondary_sources.as_deref()
    }
    /// <p> An array of <code>ProjectSourceVersion</code> objects. Each
    /// <code>ProjectSourceVersion</code> must be one of: </p>
    /// <ul>
    /// <li>
    /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
    /// </li>
    /// <li>
    /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
    /// corresponds to the version of the source code you want to build. If a pull
    /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
    /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
    /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
    /// used.</p>
    /// </li>
    /// <li>
    /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
    /// version of the source code you want to build. If a branch name is specified, the
    /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
    /// commit ID is used.</p>
    /// </li>
    /// <li>
    /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
    /// file to use.</p>
    /// </li>
    /// </ul>
    pub fn secondary_source_versions(
        &self,
    ) -> std::option::Option<&[crate::model::ProjectSourceVersion]> {
        self.secondary_source_versions.as_deref()
    }
    /// <p>Information about the output artifacts for the build.</p>
    pub fn artifacts(&self) -> std::option::Option<&crate::model::BuildArtifacts> {
        self.artifacts.as_ref()
    }
    /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
    pub fn secondary_artifacts(&self) -> std::option::Option<&[crate::model::BuildArtifacts]> {
        self.secondary_artifacts.as_deref()
    }
    /// <p>Information about the cache for the build.</p>
    pub fn cache(&self) -> std::option::Option<&crate::model::ProjectCache> {
        self.cache.as_ref()
    }
    /// <p>Information about the build environment for this build.</p>
    pub fn environment(&self) -> std::option::Option<&crate::model::ProjectEnvironment> {
        self.environment.as_ref()
    }
    /// <p>The name of a service role used for this build.</p>
    pub fn service_role(&self) -> std::option::Option<&str> {
        self.service_role.as_deref()
    }
    /// <p>Information about the build's logs in CloudWatch Logs.</p>
    pub fn logs(&self) -> std::option::Option<&crate::model::LogsLocation> {
        self.logs.as_ref()
    }
    /// <p>How long, in minutes, for CodeBuild to wait before timing out this build if it does not
    /// get marked as completed.</p>
    pub fn timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.timeout_in_minutes
    }
    /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
    pub fn queued_timeout_in_minutes(&self) -> std::option::Option<i32> {
        self.queued_timeout_in_minutes
    }
    /// <p>Whether the build is complete. True if complete; otherwise, false.</p>
    pub fn build_complete(&self) -> bool {
        self.build_complete
    }
    /// <p>The entity that started the build. Valid values include:</p>
    /// <ul>
    /// <li>
    /// <p>If CodePipeline started the build, the pipeline's name (for example,
    /// <code>codepipeline/my-demo-pipeline</code>).</p>
    /// </li>
    /// <li>
    /// <p>If an IAM user started the build, the user's name (for example,
    /// <code>MyUserName</code>).</p>
    /// </li>
    /// <li>
    /// <p>If the Jenkins plugin for CodeBuild started the build, the string
    /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
    /// </li>
    /// </ul>
    pub fn initiator(&self) -> std::option::Option<&str> {
        self.initiator.as_deref()
    }
    /// <p>If your CodeBuild project accesses resources in an Amazon VPC, you provide this parameter
    /// that identifies the VPC ID and the list of security group IDs and subnet IDs. The
    /// security groups and subnets must belong to the same VPC. You must provide at least one
    /// security group and one subnet ID.</p>
    pub fn vpc_config(&self) -> std::option::Option<&crate::model::VpcConfig> {
        self.vpc_config.as_ref()
    }
    /// <p>Describes a network interface.</p>
    pub fn network_interface(&self) -> std::option::Option<&crate::model::NetworkInterface> {
        self.network_interface.as_ref()
    }
    /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
    /// artifacts.</p>
    /// <note>
    /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
    /// service role has permission to that key. </p>
    /// </note>
    /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
    /// the format <code>alias/<alias-name></code>).</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>A list of exported environment variables for this build.</p>
    /// <p>Exported environment variables are used in conjunction with CodePipeline to export
    /// environment variables from the current build stage to subsequent stages in the pipeline.
    /// For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html">Working with variables</a> in the <i>CodePipeline User Guide</i>.</p>
    pub fn exported_environment_variables(
        &self,
    ) -> std::option::Option<&[crate::model::ExportedEnvironmentVariable]> {
        self.exported_environment_variables.as_deref()
    }
    /// <p> An array of the ARNs associated with this build's reports. </p>
    pub fn report_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.report_arns.as_deref()
    }
    /// <p>
    /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
    /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
    /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
    /// </p>
    pub fn file_system_locations(
        &self,
    ) -> std::option::Option<&[crate::model::ProjectFileSystemLocation]> {
        self.file_system_locations.as_deref()
    }
    /// <p>Contains information about the debug session for this build.</p>
    pub fn debug_session(&self) -> std::option::Option<&crate::model::DebugSession> {
        self.debug_session.as_ref()
    }
    /// <p>The ARN of the batch build that this build is a member of, if applicable.</p>
    pub fn build_batch_arn(&self) -> std::option::Option<&str> {
        self.build_batch_arn.as_deref()
    }
}
impl std::fmt::Debug for Build {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Build");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("build_number", &self.build_number);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("current_phase", &self.current_phase);
        formatter.field("build_status", &self.build_status);
        formatter.field("source_version", &self.source_version);
        formatter.field("resolved_source_version", &self.resolved_source_version);
        formatter.field("project_name", &self.project_name);
        formatter.field("phases", &self.phases);
        formatter.field("source", &self.source);
        formatter.field("secondary_sources", &self.secondary_sources);
        formatter.field("secondary_source_versions", &self.secondary_source_versions);
        formatter.field("artifacts", &self.artifacts);
        formatter.field("secondary_artifacts", &self.secondary_artifacts);
        formatter.field("cache", &self.cache);
        formatter.field("environment", &self.environment);
        formatter.field("service_role", &self.service_role);
        formatter.field("logs", &self.logs);
        formatter.field("timeout_in_minutes", &self.timeout_in_minutes);
        formatter.field("queued_timeout_in_minutes", &self.queued_timeout_in_minutes);
        formatter.field("build_complete", &self.build_complete);
        formatter.field("initiator", &self.initiator);
        formatter.field("vpc_config", &self.vpc_config);
        formatter.field("network_interface", &self.network_interface);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field(
            "exported_environment_variables",
            &self.exported_environment_variables,
        );
        formatter.field("report_arns", &self.report_arns);
        formatter.field("file_system_locations", &self.file_system_locations);
        formatter.field("debug_session", &self.debug_session);
        formatter.field("build_batch_arn", &self.build_batch_arn);
        formatter.finish()
    }
}
/// See [`Build`](crate::model::Build)
pub mod build {
    /// A builder for [`Build`](crate::model::Build)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) build_number: std::option::Option<i64>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) current_phase: std::option::Option<std::string::String>,
        pub(crate) build_status: std::option::Option<crate::model::StatusType>,
        pub(crate) source_version: std::option::Option<std::string::String>,
        pub(crate) resolved_source_version: std::option::Option<std::string::String>,
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) phases: std::option::Option<std::vec::Vec<crate::model::BuildPhase>>,
        pub(crate) source: std::option::Option<crate::model::ProjectSource>,
        pub(crate) secondary_sources:
            std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        pub(crate) secondary_source_versions:
            std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        pub(crate) artifacts: std::option::Option<crate::model::BuildArtifacts>,
        pub(crate) secondary_artifacts:
            std::option::Option<std::vec::Vec<crate::model::BuildArtifacts>>,
        pub(crate) cache: std::option::Option<crate::model::ProjectCache>,
        pub(crate) environment: std::option::Option<crate::model::ProjectEnvironment>,
        pub(crate) service_role: std::option::Option<std::string::String>,
        pub(crate) logs: std::option::Option<crate::model::LogsLocation>,
        pub(crate) timeout_in_minutes: std::option::Option<i32>,
        pub(crate) queued_timeout_in_minutes: std::option::Option<i32>,
        pub(crate) build_complete: std::option::Option<bool>,
        pub(crate) initiator: std::option::Option<std::string::String>,
        pub(crate) vpc_config: std::option::Option<crate::model::VpcConfig>,
        pub(crate) network_interface: std::option::Option<crate::model::NetworkInterface>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) exported_environment_variables:
            std::option::Option<std::vec::Vec<crate::model::ExportedEnvironmentVariable>>,
        pub(crate) report_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) file_system_locations:
            std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        pub(crate) debug_session: std::option::Option<crate::model::DebugSession>,
        pub(crate) build_batch_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID for the build.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique ID for the build.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the build.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the build.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The number of the build. For each project, the <code>buildNumber</code> of its first
        /// build is <code>1</code>. The <code>buildNumber</code> of each subsequent build is
        /// incremented by <code>1</code>. If a build is deleted, the <code>buildNumber</code> of
        /// other builds does not change.</p>
        pub fn build_number(mut self, input: i64) -> Self {
            self.build_number = Some(input);
            self
        }
        /// <p>The number of the build. For each project, the <code>buildNumber</code> of its first
        /// build is <code>1</code>. The <code>buildNumber</code> of each subsequent build is
        /// incremented by <code>1</code>. If a build is deleted, the <code>buildNumber</code> of
        /// other builds does not change.</p>
        pub fn set_build_number(mut self, input: std::option::Option<i64>) -> Self {
            self.build_number = input;
            self
        }
        /// <p>When the build process started, expressed in Unix time format.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>When the build process started, expressed in Unix time format.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>When the build process ended, expressed in Unix time format.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>When the build process ended, expressed in Unix time format.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The current build phase.</p>
        pub fn current_phase(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_phase = Some(input.into());
            self
        }
        /// <p>The current build phase.</p>
        pub fn set_current_phase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_phase = input;
            self
        }
        /// <p>The current status of the build. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The build failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAULT</code>: The build faulted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The build is still in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code>: The build stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code>: The build succeeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIMED_OUT</code>: The build timed out.</p>
        /// </li>
        /// </ul>
        pub fn build_status(mut self, input: crate::model::StatusType) -> Self {
            self.build_status = Some(input);
            self
        }
        /// <p>The current status of the build. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>FAILED</code>: The build failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAULT</code>: The build faulted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code>: The build is still in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>STOPPED</code>: The build stopped.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code>: The build succeeded.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIMED_OUT</code>: The build timed out.</p>
        /// </li>
        /// </ul>
        pub fn set_build_status(
            mut self,
            input: std::option::Option<crate::model::StatusType>,
        ) -> Self {
            self.build_status = input;
            self
        }
        /// <p>Any version identifier for the version of the source code to be built. If
        /// <code>sourceVersion</code> is specified at the project level, then this
        /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>Any version identifier for the version of the source code to be built. If
        /// <code>sourceVersion</code> is specified at the project level, then this
        /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// <p> An identifier for the version of this build's source code. </p>
        /// <ul>
        /// <li>
        /// <p> For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID. </p>
        /// </li>
        /// <li>
        /// <p> For CodePipeline, the source revision provided by CodePipeline. </p>
        /// </li>
        /// <li>
        /// <p> For Amazon S3, this does not apply. </p>
        /// </li>
        /// </ul>
        pub fn resolved_source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.resolved_source_version = Some(input.into());
            self
        }
        /// <p> An identifier for the version of this build's source code. </p>
        /// <ul>
        /// <li>
        /// <p> For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID. </p>
        /// </li>
        /// <li>
        /// <p> For CodePipeline, the source revision provided by CodePipeline. </p>
        /// </li>
        /// <li>
        /// <p> For Amazon S3, this does not apply. </p>
        /// </li>
        /// </ul>
        pub fn set_resolved_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resolved_source_version = input;
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Appends an item to `phases`.
        ///
        /// To override the contents of this collection use [`set_phases`](Self::set_phases).
        ///
        /// <p>Information about all previous build phases that are complete and information about
        /// any current build phase that is not yet complete.</p>
        pub fn phases(mut self, input: impl Into<crate::model::BuildPhase>) -> Self {
            let mut v = self.phases.unwrap_or_default();
            v.push(input.into());
            self.phases = Some(v);
            self
        }
        /// <p>Information about all previous build phases that are complete and information about
        /// any current build phase that is not yet complete.</p>
        pub fn set_phases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildPhase>>,
        ) -> Self {
            self.phases = input;
            self
        }
        /// <p>Information about the source code to be built.</p>
        pub fn source(mut self, input: crate::model::ProjectSource) -> Self {
            self.source = Some(input);
            self
        }
        /// <p>Information about the source code to be built.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ProjectSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `secondary_sources`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources`](Self::set_secondary_sources).
        ///
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources(mut self, input: impl Into<crate::model::ProjectSource>) -> Self {
            let mut v = self.secondary_sources.unwrap_or_default();
            v.push(input.into());
            self.secondary_sources = Some(v);
            self
        }
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.secondary_sources = input;
            self
        }
        /// Appends an item to `secondary_source_versions`.
        ///
        /// To override the contents of this collection use [`set_secondary_source_versions`](Self::set_secondary_source_versions).
        ///
        /// <p> An array of <code>ProjectSourceVersion</code> objects. Each
        /// <code>ProjectSourceVersion</code> must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        pub fn secondary_source_versions(
            mut self,
            input: impl Into<crate::model::ProjectSourceVersion>,
        ) -> Self {
            let mut v = self.secondary_source_versions.unwrap_or_default();
            v.push(input.into());
            self.secondary_source_versions = Some(v);
            self
        }
        /// <p> An array of <code>ProjectSourceVersion</code> objects. Each
        /// <code>ProjectSourceVersion</code> must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example, <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        pub fn set_secondary_source_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.secondary_source_versions = input;
            self
        }
        /// <p>Information about the output artifacts for the build.</p>
        pub fn artifacts(mut self, input: crate::model::BuildArtifacts) -> Self {
            self.artifacts = Some(input);
            self
        }
        /// <p>Information about the output artifacts for the build.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<crate::model::BuildArtifacts>,
        ) -> Self {
            self.artifacts = input;
            self
        }
        /// Appends an item to `secondary_artifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn secondary_artifacts(
            mut self,
            input: impl Into<crate::model::BuildArtifacts>,
        ) -> Self {
            let mut v = self.secondary_artifacts.unwrap_or_default();
            v.push(input.into());
            self.secondary_artifacts = Some(v);
            self
        }
        /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildArtifacts>>,
        ) -> Self {
            self.secondary_artifacts = input;
            self
        }
        /// <p>Information about the cache for the build.</p>
        pub fn cache(mut self, input: crate::model::ProjectCache) -> Self {
            self.cache = Some(input);
            self
        }
        /// <p>Information about the cache for the build.</p>
        pub fn set_cache(mut self, input: std::option::Option<crate::model::ProjectCache>) -> Self {
            self.cache = input;
            self
        }
        /// <p>Information about the build environment for this build.</p>
        pub fn environment(mut self, input: crate::model::ProjectEnvironment) -> Self {
            self.environment = Some(input);
            self
        }
        /// <p>Information about the build environment for this build.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::ProjectEnvironment>,
        ) -> Self {
            self.environment = input;
            self
        }
        /// <p>The name of a service role used for this build.</p>
        pub fn service_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_role = Some(input.into());
            self
        }
        /// <p>The name of a service role used for this build.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_role = input;
            self
        }
        /// <p>Information about the build's logs in CloudWatch Logs.</p>
        pub fn logs(mut self, input: crate::model::LogsLocation) -> Self {
            self.logs = Some(input);
            self
        }
        /// <p>Information about the build's logs in CloudWatch Logs.</p>
        pub fn set_logs(mut self, input: std::option::Option<crate::model::LogsLocation>) -> Self {
            self.logs = input;
            self
        }
        /// <p>How long, in minutes, for CodeBuild to wait before timing out this build if it does not
        /// get marked as completed.</p>
        pub fn timeout_in_minutes(mut self, input: i32) -> Self {
            self.timeout_in_minutes = Some(input);
            self
        }
        /// <p>How long, in minutes, for CodeBuild to wait before timing out this build if it does not
        /// get marked as completed.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_in_minutes = input;
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes(mut self, input: i32) -> Self {
            self.queued_timeout_in_minutes = Some(input);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.queued_timeout_in_minutes = input;
            self
        }
        /// <p>Whether the build is complete. True if complete; otherwise, false.</p>
        pub fn build_complete(mut self, input: bool) -> Self {
            self.build_complete = Some(input);
            self
        }
        /// <p>Whether the build is complete. True if complete; otherwise, false.</p>
        pub fn set_build_complete(mut self, input: std::option::Option<bool>) -> Self {
            self.build_complete = input;
            self
        }
        /// <p>The entity that started the build. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>If CodePipeline started the build, the pipeline's name (for example,
        /// <code>codepipeline/my-demo-pipeline</code>).</p>
        /// </li>
        /// <li>
        /// <p>If an IAM user started the build, the user's name (for example,
        /// <code>MyUserName</code>).</p>
        /// </li>
        /// <li>
        /// <p>If the Jenkins plugin for CodeBuild started the build, the string
        /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
        /// </li>
        /// </ul>
        pub fn initiator(mut self, input: impl Into<std::string::String>) -> Self {
            self.initiator = Some(input.into());
            self
        }
        /// <p>The entity that started the build. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>If CodePipeline started the build, the pipeline's name (for example,
        /// <code>codepipeline/my-demo-pipeline</code>).</p>
        /// </li>
        /// <li>
        /// <p>If an IAM user started the build, the user's name (for example,
        /// <code>MyUserName</code>).</p>
        /// </li>
        /// <li>
        /// <p>If the Jenkins plugin for CodeBuild started the build, the string
        /// <code>CodeBuild-Jenkins-Plugin</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_initiator(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.initiator = input;
            self
        }
        /// <p>If your CodeBuild project accesses resources in an Amazon VPC, you provide this parameter
        /// that identifies the VPC ID and the list of security group IDs and subnet IDs. The
        /// security groups and subnets must belong to the same VPC. You must provide at least one
        /// security group and one subnet ID.</p>
        pub fn vpc_config(mut self, input: crate::model::VpcConfig) -> Self {
            self.vpc_config = Some(input);
            self
        }
        /// <p>If your CodeBuild project accesses resources in an Amazon VPC, you provide this parameter
        /// that identifies the VPC ID and the list of security group IDs and subnet IDs. The
        /// security groups and subnets must belong to the same VPC. You must provide at least one
        /// security group and one subnet ID.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.vpc_config = input;
            self
        }
        /// <p>Describes a network interface.</p>
        pub fn network_interface(mut self, input: crate::model::NetworkInterface) -> Self {
            self.network_interface = Some(input);
            self
        }
        /// <p>Describes a network interface.</p>
        pub fn set_network_interface(
            mut self,
            input: std::option::Option<crate::model::NetworkInterface>,
        ) -> Self {
            self.network_interface = input;
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Appends an item to `exported_environment_variables`.
        ///
        /// To override the contents of this collection use [`set_exported_environment_variables`](Self::set_exported_environment_variables).
        ///
        /// <p>A list of exported environment variables for this build.</p>
        /// <p>Exported environment variables are used in conjunction with CodePipeline to export
        /// environment variables from the current build stage to subsequent stages in the pipeline.
        /// For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html">Working with variables</a> in the <i>CodePipeline User Guide</i>.</p>
        pub fn exported_environment_variables(
            mut self,
            input: impl Into<crate::model::ExportedEnvironmentVariable>,
        ) -> Self {
            let mut v = self.exported_environment_variables.unwrap_or_default();
            v.push(input.into());
            self.exported_environment_variables = Some(v);
            self
        }
        /// <p>A list of exported environment variables for this build.</p>
        /// <p>Exported environment variables are used in conjunction with CodePipeline to export
        /// environment variables from the current build stage to subsequent stages in the pipeline.
        /// For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html">Working with variables</a> in the <i>CodePipeline User Guide</i>.</p>
        pub fn set_exported_environment_variables(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportedEnvironmentVariable>>,
        ) -> Self {
            self.exported_environment_variables = input;
            self
        }
        /// Appends an item to `report_arns`.
        ///
        /// To override the contents of this collection use [`set_report_arns`](Self::set_report_arns).
        ///
        /// <p> An array of the ARNs associated with this build's reports. </p>
        pub fn report_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.report_arns.unwrap_or_default();
            v.push(input.into());
            self.report_arns = Some(v);
            self
        }
        /// <p> An array of the ARNs associated with this build's reports. </p>
        pub fn set_report_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.report_arns = input;
            self
        }
        /// Appends an item to `file_system_locations`.
        ///
        /// To override the contents of this collection use [`set_file_system_locations`](Self::set_file_system_locations).
        ///
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn file_system_locations(
            mut self,
            input: impl Into<crate::model::ProjectFileSystemLocation>,
        ) -> Self {
            let mut v = self.file_system_locations.unwrap_or_default();
            v.push(input.into());
            self.file_system_locations = Some(v);
            self
        }
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn set_file_system_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        ) -> Self {
            self.file_system_locations = input;
            self
        }
        /// <p>Contains information about the debug session for this build.</p>
        pub fn debug_session(mut self, input: crate::model::DebugSession) -> Self {
            self.debug_session = Some(input);
            self
        }
        /// <p>Contains information about the debug session for this build.</p>
        pub fn set_debug_session(
            mut self,
            input: std::option::Option<crate::model::DebugSession>,
        ) -> Self {
            self.debug_session = input;
            self
        }
        /// <p>The ARN of the batch build that this build is a member of, if applicable.</p>
        pub fn build_batch_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.build_batch_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the batch build that this build is a member of, if applicable.</p>
        pub fn set_build_batch_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.build_batch_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Build`](crate::model::Build)
        pub fn build(self) -> crate::model::Build {
            crate::model::Build {
                id: self.id,
                arn: self.arn,
                build_number: self.build_number,
                start_time: self.start_time,
                end_time: self.end_time,
                current_phase: self.current_phase,
                build_status: self.build_status,
                source_version: self.source_version,
                resolved_source_version: self.resolved_source_version,
                project_name: self.project_name,
                phases: self.phases,
                source: self.source,
                secondary_sources: self.secondary_sources,
                secondary_source_versions: self.secondary_source_versions,
                artifacts: self.artifacts,
                secondary_artifacts: self.secondary_artifacts,
                cache: self.cache,
                environment: self.environment,
                service_role: self.service_role,
                logs: self.logs,
                timeout_in_minutes: self.timeout_in_minutes,
                queued_timeout_in_minutes: self.queued_timeout_in_minutes,
                build_complete: self.build_complete.unwrap_or_default(),
                initiator: self.initiator,
                vpc_config: self.vpc_config,
                network_interface: self.network_interface,
                encryption_key: self.encryption_key,
                exported_environment_variables: self.exported_environment_variables,
                report_arns: self.report_arns,
                file_system_locations: self.file_system_locations,
                debug_session: self.debug_session,
                build_batch_arn: self.build_batch_arn,
            }
        }
    }
}
impl Build {
    /// Creates a new builder-style object to manufacture [`Build`](crate::model::Build)
    pub fn builder() -> crate::model::build::Builder {
        crate::model::build::Builder::default()
    }
}

/// <p>Contains information about the debug session for a build. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a
/// running build in Session Manager</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DebugSession {
    /// <p>Specifies if session debugging is enabled for this build.</p>
    pub session_enabled: std::option::Option<bool>,
    /// <p>Contains the identifier of the Session Manager session used for the build. To work with
    /// the paused build, you open this session to examine, control, and resume the
    /// build.</p>
    pub session_target: std::option::Option<std::string::String>,
}
impl DebugSession {
    /// <p>Specifies if session debugging is enabled for this build.</p>
    pub fn session_enabled(&self) -> std::option::Option<bool> {
        self.session_enabled
    }
    /// <p>Contains the identifier of the Session Manager session used for the build. To work with
    /// the paused build, you open this session to examine, control, and resume the
    /// build.</p>
    pub fn session_target(&self) -> std::option::Option<&str> {
        self.session_target.as_deref()
    }
}
impl std::fmt::Debug for DebugSession {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DebugSession");
        formatter.field("session_enabled", &self.session_enabled);
        formatter.field("session_target", &self.session_target);
        formatter.finish()
    }
}
/// See [`DebugSession`](crate::model::DebugSession)
pub mod debug_session {
    /// A builder for [`DebugSession`](crate::model::DebugSession)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) session_enabled: std::option::Option<bool>,
        pub(crate) session_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies if session debugging is enabled for this build.</p>
        pub fn session_enabled(mut self, input: bool) -> Self {
            self.session_enabled = Some(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this build.</p>
        pub fn set_session_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.session_enabled = input;
            self
        }
        /// <p>Contains the identifier of the Session Manager session used for the build. To work with
        /// the paused build, you open this session to examine, control, and resume the
        /// build.</p>
        pub fn session_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.session_target = Some(input.into());
            self
        }
        /// <p>Contains the identifier of the Session Manager session used for the build. To work with
        /// the paused build, you open this session to examine, control, and resume the
        /// build.</p>
        pub fn set_session_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.session_target = input;
            self
        }
        /// Consumes the builder and constructs a [`DebugSession`](crate::model::DebugSession)
        pub fn build(self) -> crate::model::DebugSession {
            crate::model::DebugSession {
                session_enabled: self.session_enabled,
                session_target: self.session_target,
            }
        }
    }
}
impl DebugSession {
    /// Creates a new builder-style object to manufacture [`DebugSession`](crate::model::DebugSession)
    pub fn builder() -> crate::model::debug_session::Builder {
        crate::model::debug_session::Builder::default()
    }
}

/// <p>Contains information about an exported environment variable. </p>
/// <p>Exported environment variables are used in conjunction with CodePipeline to export
/// environment variables from the current build stage to subsequent stages in the pipeline.
/// For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-variables.html">Working with variables</a> in the <i>CodePipeline User Guide</i>.</p>
/// <note>
/// <p> During a build, the value of a variable is available starting with the
/// <code>install</code> phase. It can be updated between the start of the
/// <code>install</code> phase and the end of the <code>post_build</code> phase.
/// After the <code>post_build</code> phase ends, the value of exported variables cannot
/// change.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportedEnvironmentVariable {
    /// <p>The name of the exported environment variable.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value assigned to the exported environment variable.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ExportedEnvironmentVariable {
    /// <p>The name of the exported environment variable.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value assigned to the exported environment variable.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ExportedEnvironmentVariable {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportedEnvironmentVariable");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ExportedEnvironmentVariable`](crate::model::ExportedEnvironmentVariable)
pub mod exported_environment_variable {
    /// A builder for [`ExportedEnvironmentVariable`](crate::model::ExportedEnvironmentVariable)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the exported environment variable.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the exported environment variable.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value assigned to the exported environment variable.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value assigned to the exported environment variable.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportedEnvironmentVariable`](crate::model::ExportedEnvironmentVariable)
        pub fn build(self) -> crate::model::ExportedEnvironmentVariable {
            crate::model::ExportedEnvironmentVariable {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ExportedEnvironmentVariable {
    /// Creates a new builder-style object to manufacture [`ExportedEnvironmentVariable`](crate::model::ExportedEnvironmentVariable)
    pub fn builder() -> crate::model::exported_environment_variable::Builder {
        crate::model::exported_environment_variable::Builder::default()
    }
}

/// <p>Describes a network interface.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>The ID of the subnet.</p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The ID of the network interface.</p>
    pub network_interface_id: std::option::Option<std::string::String>,
}
impl NetworkInterface {
    /// <p>The ID of the subnet.</p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The ID of the network interface.</p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the subnet.</p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The ID of the subnet.</p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The ID of the network interface.</p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                subnet_id: self.subnet_id,
                network_interface_id: self.network_interface_id,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>Information about build logs in CloudWatch Logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogsLocation {
    /// <p>The name of the CloudWatch Logs group for the build logs.</p>
    pub group_name: std::option::Option<std::string::String>,
    /// <p>The name of the CloudWatch Logs stream for the build logs.</p>
    pub stream_name: std::option::Option<std::string::String>,
    /// <p>The URL to an individual build log in CloudWatch Logs.</p>
    pub deep_link: std::option::Option<std::string::String>,
    /// <p> The URL to a build log in an S3 bucket. </p>
    pub s3_deep_link: std::option::Option<std::string::String>,
    /// <p> The ARN of CloudWatch Logs for a build project. Its format is
    /// <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>.
    /// For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies">Resources Defined by CloudWatch Logs</a>. </p>
    pub cloud_watch_logs_arn: std::option::Option<std::string::String>,
    /// <p> The ARN of S3 logs for a build project. Its format is
    /// <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies">Resources Defined by Amazon S3</a>. </p>
    pub s3_logs_arn: std::option::Option<std::string::String>,
    /// <p> Information about CloudWatch Logs for a build project. </p>
    pub cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsConfig>,
    /// <p> Information about S3 logs for a build project. </p>
    pub s3_logs: std::option::Option<crate::model::S3LogsConfig>,
}
impl LogsLocation {
    /// <p>The name of the CloudWatch Logs group for the build logs.</p>
    pub fn group_name(&self) -> std::option::Option<&str> {
        self.group_name.as_deref()
    }
    /// <p>The name of the CloudWatch Logs stream for the build logs.</p>
    pub fn stream_name(&self) -> std::option::Option<&str> {
        self.stream_name.as_deref()
    }
    /// <p>The URL to an individual build log in CloudWatch Logs.</p>
    pub fn deep_link(&self) -> std::option::Option<&str> {
        self.deep_link.as_deref()
    }
    /// <p> The URL to a build log in an S3 bucket. </p>
    pub fn s3_deep_link(&self) -> std::option::Option<&str> {
        self.s3_deep_link.as_deref()
    }
    /// <p> The ARN of CloudWatch Logs for a build project. Its format is
    /// <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>.
    /// For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies">Resources Defined by CloudWatch Logs</a>. </p>
    pub fn cloud_watch_logs_arn(&self) -> std::option::Option<&str> {
        self.cloud_watch_logs_arn.as_deref()
    }
    /// <p> The ARN of S3 logs for a build project. Its format is
    /// <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more
    /// information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies">Resources Defined by Amazon S3</a>. </p>
    pub fn s3_logs_arn(&self) -> std::option::Option<&str> {
        self.s3_logs_arn.as_deref()
    }
    /// <p> Information about CloudWatch Logs for a build project. </p>
    pub fn cloud_watch_logs(&self) -> std::option::Option<&crate::model::CloudWatchLogsConfig> {
        self.cloud_watch_logs.as_ref()
    }
    /// <p> Information about S3 logs for a build project. </p>
    pub fn s3_logs(&self) -> std::option::Option<&crate::model::S3LogsConfig> {
        self.s3_logs.as_ref()
    }
}
impl std::fmt::Debug for LogsLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogsLocation");
        formatter.field("group_name", &self.group_name);
        formatter.field("stream_name", &self.stream_name);
        formatter.field("deep_link", &self.deep_link);
        formatter.field("s3_deep_link", &self.s3_deep_link);
        formatter.field("cloud_watch_logs_arn", &self.cloud_watch_logs_arn);
        formatter.field("s3_logs_arn", &self.s3_logs_arn);
        formatter.field("cloud_watch_logs", &self.cloud_watch_logs);
        formatter.field("s3_logs", &self.s3_logs);
        formatter.finish()
    }
}
/// See [`LogsLocation`](crate::model::LogsLocation)
pub mod logs_location {
    /// A builder for [`LogsLocation`](crate::model::LogsLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_name: std::option::Option<std::string::String>,
        pub(crate) stream_name: std::option::Option<std::string::String>,
        pub(crate) deep_link: std::option::Option<std::string::String>,
        pub(crate) s3_deep_link: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs_arn: std::option::Option<std::string::String>,
        pub(crate) s3_logs_arn: std::option::Option<std::string::String>,
        pub(crate) cloud_watch_logs: std::option::Option<crate::model::CloudWatchLogsConfig>,
        pub(crate) s3_logs: std::option::Option<crate::model::S3LogsConfig>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch Logs group for the build logs.</p>
        pub fn group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch Logs group for the build logs.</p>
        pub fn set_group_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_name = input;
            self
        }
        /// <p>The name of the CloudWatch Logs stream for the build logs.</p>
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch Logs stream for the build logs.</p>
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// <p>The URL to an individual build log in CloudWatch Logs.</p>
        pub fn deep_link(mut self, input: impl Into<std::string::String>) -> Self {
            self.deep_link = Some(input.into());
            self
        }
        /// <p>The URL to an individual build log in CloudWatch Logs.</p>
        pub fn set_deep_link(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.deep_link = input;
            self
        }
        /// <p> The URL to a build log in an S3 bucket. </p>
        pub fn s3_deep_link(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_deep_link = Some(input.into());
            self
        }
        /// <p> The URL to a build log in an S3 bucket. </p>
        pub fn set_s3_deep_link(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_deep_link = input;
            self
        }
        /// <p> The ARN of CloudWatch Logs for a build project. Its format is
        /// <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>.
        /// For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies">Resources Defined by CloudWatch Logs</a>. </p>
        pub fn cloud_watch_logs_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cloud_watch_logs_arn = Some(input.into());
            self
        }
        /// <p> The ARN of CloudWatch Logs for a build project. Its format is
        /// <code>arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}</code>.
        /// For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies">Resources Defined by CloudWatch Logs</a>. </p>
        pub fn set_cloud_watch_logs_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cloud_watch_logs_arn = input;
            self
        }
        /// <p> The ARN of S3 logs for a build project. Its format is
        /// <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more
        /// information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies">Resources Defined by Amazon S3</a>. </p>
        pub fn s3_logs_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_logs_arn = Some(input.into());
            self
        }
        /// <p> The ARN of S3 logs for a build project. Its format is
        /// <code>arn:${Partition}:s3:::${BucketName}/${ObjectName}</code>. For more
        /// information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies">Resources Defined by Amazon S3</a>. </p>
        pub fn set_s3_logs_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_logs_arn = input;
            self
        }
        /// <p> Information about CloudWatch Logs for a build project. </p>
        pub fn cloud_watch_logs(mut self, input: crate::model::CloudWatchLogsConfig) -> Self {
            self.cloud_watch_logs = Some(input);
            self
        }
        /// <p> Information about CloudWatch Logs for a build project. </p>
        pub fn set_cloud_watch_logs(
            mut self,
            input: std::option::Option<crate::model::CloudWatchLogsConfig>,
        ) -> Self {
            self.cloud_watch_logs = input;
            self
        }
        /// <p> Information about S3 logs for a build project. </p>
        pub fn s3_logs(mut self, input: crate::model::S3LogsConfig) -> Self {
            self.s3_logs = Some(input);
            self
        }
        /// <p> Information about S3 logs for a build project. </p>
        pub fn set_s3_logs(
            mut self,
            input: std::option::Option<crate::model::S3LogsConfig>,
        ) -> Self {
            self.s3_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`LogsLocation`](crate::model::LogsLocation)
        pub fn build(self) -> crate::model::LogsLocation {
            crate::model::LogsLocation {
                group_name: self.group_name,
                stream_name: self.stream_name,
                deep_link: self.deep_link,
                s3_deep_link: self.s3_deep_link,
                cloud_watch_logs_arn: self.cloud_watch_logs_arn,
                s3_logs_arn: self.s3_logs_arn,
                cloud_watch_logs: self.cloud_watch_logs,
                s3_logs: self.s3_logs,
            }
        }
    }
}
impl LogsLocation {
    /// Creates a new builder-style object to manufacture [`LogsLocation`](crate::model::LogsLocation)
    pub fn builder() -> crate::model::logs_location::Builder {
        crate::model::logs_location::Builder::default()
    }
}

/// <p>Information about a stage for a build.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildPhase {
    /// <p>The name of the build phase. Valid values include:</p>
    /// <dl>
    /// <dt>BUILD</dt>
    /// <dd>
    /// <p>Core build activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>COMPLETED</dt>
    /// <dd>
    /// <p>The build has been completed.</p>
    /// </dd>
    /// <dt>DOWNLOAD_SOURCE</dt>
    /// <dd>
    /// <p>Source code is being downloaded in this build phase.</p>
    /// </dd>
    /// <dt>FINALIZING</dt>
    /// <dd>
    /// <p>The build process is completing in this build phase.</p>
    /// </dd>
    /// <dt>INSTALL</dt>
    /// <dd>
    /// <p>Installation activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>POST_BUILD</dt>
    /// <dd>
    /// <p>Post-build activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>PRE_BUILD</dt>
    /// <dd>
    /// <p>Pre-build activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>PROVISIONING</dt>
    /// <dd>
    /// <p>The build environment is being set up.</p>
    /// </dd>
    /// <dt>QUEUED</dt>
    /// <dd>
    /// <p>The build has been submitted and is queued behind other submitted
    /// builds.</p>
    /// </dd>
    /// <dt>SUBMITTED</dt>
    /// <dd>
    /// <p>The build has been submitted.</p>
    /// </dd>
    /// <dt>UPLOAD_ARTIFACTS</dt>
    /// <dd>
    /// <p>Build output artifacts are being uploaded to the output location.</p>
    /// </dd>
    /// </dl>
    pub phase_type: std::option::Option<crate::model::BuildPhaseType>,
    /// <p>The current status of the build phase. Valid values include:</p>
    /// <dl>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>The build phase failed.</p>
    /// </dd>
    /// <dt>FAULT</dt>
    /// <dd>
    /// <p>The build phase faulted.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The build phase is still in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The build phase stopped.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The build phase succeeded.</p>
    /// </dd>
    /// <dt>TIMED_OUT</dt>
    /// <dd>
    /// <p>The build phase timed out.</p>
    /// </dd>
    /// </dl>
    pub phase_status: std::option::Option<crate::model::StatusType>,
    /// <p>When the build phase started, expressed in Unix time format.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>When the build phase ended, expressed in Unix time format.</p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>How long, in seconds, between the starting and ending times of the build's
    /// phase.</p>
    pub duration_in_seconds: std::option::Option<i64>,
    /// <p>Additional information about a build phase, especially to help troubleshoot a failed
    /// build.</p>
    pub contexts: std::option::Option<std::vec::Vec<crate::model::PhaseContext>>,
}
impl BuildPhase {
    /// <p>The name of the build phase. Valid values include:</p>
    /// <dl>
    /// <dt>BUILD</dt>
    /// <dd>
    /// <p>Core build activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>COMPLETED</dt>
    /// <dd>
    /// <p>The build has been completed.</p>
    /// </dd>
    /// <dt>DOWNLOAD_SOURCE</dt>
    /// <dd>
    /// <p>Source code is being downloaded in this build phase.</p>
    /// </dd>
    /// <dt>FINALIZING</dt>
    /// <dd>
    /// <p>The build process is completing in this build phase.</p>
    /// </dd>
    /// <dt>INSTALL</dt>
    /// <dd>
    /// <p>Installation activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>POST_BUILD</dt>
    /// <dd>
    /// <p>Post-build activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>PRE_BUILD</dt>
    /// <dd>
    /// <p>Pre-build activities typically occur in this build phase.</p>
    /// </dd>
    /// <dt>PROVISIONING</dt>
    /// <dd>
    /// <p>The build environment is being set up.</p>
    /// </dd>
    /// <dt>QUEUED</dt>
    /// <dd>
    /// <p>The build has been submitted and is queued behind other submitted
    /// builds.</p>
    /// </dd>
    /// <dt>SUBMITTED</dt>
    /// <dd>
    /// <p>The build has been submitted.</p>
    /// </dd>
    /// <dt>UPLOAD_ARTIFACTS</dt>
    /// <dd>
    /// <p>Build output artifacts are being uploaded to the output location.</p>
    /// </dd>
    /// </dl>
    pub fn phase_type(&self) -> std::option::Option<&crate::model::BuildPhaseType> {
        self.phase_type.as_ref()
    }
    /// <p>The current status of the build phase. Valid values include:</p>
    /// <dl>
    /// <dt>FAILED</dt>
    /// <dd>
    /// <p>The build phase failed.</p>
    /// </dd>
    /// <dt>FAULT</dt>
    /// <dd>
    /// <p>The build phase faulted.</p>
    /// </dd>
    /// <dt>IN_PROGRESS</dt>
    /// <dd>
    /// <p>The build phase is still in progress.</p>
    /// </dd>
    /// <dt>STOPPED</dt>
    /// <dd>
    /// <p>The build phase stopped.</p>
    /// </dd>
    /// <dt>SUCCEEDED</dt>
    /// <dd>
    /// <p>The build phase succeeded.</p>
    /// </dd>
    /// <dt>TIMED_OUT</dt>
    /// <dd>
    /// <p>The build phase timed out.</p>
    /// </dd>
    /// </dl>
    pub fn phase_status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.phase_status.as_ref()
    }
    /// <p>When the build phase started, expressed in Unix time format.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>When the build phase ended, expressed in Unix time format.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
    /// <p>How long, in seconds, between the starting and ending times of the build's
    /// phase.</p>
    pub fn duration_in_seconds(&self) -> std::option::Option<i64> {
        self.duration_in_seconds
    }
    /// <p>Additional information about a build phase, especially to help troubleshoot a failed
    /// build.</p>
    pub fn contexts(&self) -> std::option::Option<&[crate::model::PhaseContext]> {
        self.contexts.as_deref()
    }
}
impl std::fmt::Debug for BuildPhase {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildPhase");
        formatter.field("phase_type", &self.phase_type);
        formatter.field("phase_status", &self.phase_status);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration_in_seconds", &self.duration_in_seconds);
        formatter.field("contexts", &self.contexts);
        formatter.finish()
    }
}
/// See [`BuildPhase`](crate::model::BuildPhase)
pub mod build_phase {
    /// A builder for [`BuildPhase`](crate::model::BuildPhase)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) phase_type: std::option::Option<crate::model::BuildPhaseType>,
        pub(crate) phase_status: std::option::Option<crate::model::StatusType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration_in_seconds: std::option::Option<i64>,
        pub(crate) contexts: std::option::Option<std::vec::Vec<crate::model::PhaseContext>>,
    }
    impl Builder {
        /// <p>The name of the build phase. Valid values include:</p>
        /// <dl>
        /// <dt>BUILD</dt>
        /// <dd>
        /// <p>Core build activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>COMPLETED</dt>
        /// <dd>
        /// <p>The build has been completed.</p>
        /// </dd>
        /// <dt>DOWNLOAD_SOURCE</dt>
        /// <dd>
        /// <p>Source code is being downloaded in this build phase.</p>
        /// </dd>
        /// <dt>FINALIZING</dt>
        /// <dd>
        /// <p>The build process is completing in this build phase.</p>
        /// </dd>
        /// <dt>INSTALL</dt>
        /// <dd>
        /// <p>Installation activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>POST_BUILD</dt>
        /// <dd>
        /// <p>Post-build activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>PRE_BUILD</dt>
        /// <dd>
        /// <p>Pre-build activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>PROVISIONING</dt>
        /// <dd>
        /// <p>The build environment is being set up.</p>
        /// </dd>
        /// <dt>QUEUED</dt>
        /// <dd>
        /// <p>The build has been submitted and is queued behind other submitted
        /// builds.</p>
        /// </dd>
        /// <dt>SUBMITTED</dt>
        /// <dd>
        /// <p>The build has been submitted.</p>
        /// </dd>
        /// <dt>UPLOAD_ARTIFACTS</dt>
        /// <dd>
        /// <p>Build output artifacts are being uploaded to the output location.</p>
        /// </dd>
        /// </dl>
        pub fn phase_type(mut self, input: crate::model::BuildPhaseType) -> Self {
            self.phase_type = Some(input);
            self
        }
        /// <p>The name of the build phase. Valid values include:</p>
        /// <dl>
        /// <dt>BUILD</dt>
        /// <dd>
        /// <p>Core build activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>COMPLETED</dt>
        /// <dd>
        /// <p>The build has been completed.</p>
        /// </dd>
        /// <dt>DOWNLOAD_SOURCE</dt>
        /// <dd>
        /// <p>Source code is being downloaded in this build phase.</p>
        /// </dd>
        /// <dt>FINALIZING</dt>
        /// <dd>
        /// <p>The build process is completing in this build phase.</p>
        /// </dd>
        /// <dt>INSTALL</dt>
        /// <dd>
        /// <p>Installation activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>POST_BUILD</dt>
        /// <dd>
        /// <p>Post-build activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>PRE_BUILD</dt>
        /// <dd>
        /// <p>Pre-build activities typically occur in this build phase.</p>
        /// </dd>
        /// <dt>PROVISIONING</dt>
        /// <dd>
        /// <p>The build environment is being set up.</p>
        /// </dd>
        /// <dt>QUEUED</dt>
        /// <dd>
        /// <p>The build has been submitted and is queued behind other submitted
        /// builds.</p>
        /// </dd>
        /// <dt>SUBMITTED</dt>
        /// <dd>
        /// <p>The build has been submitted.</p>
        /// </dd>
        /// <dt>UPLOAD_ARTIFACTS</dt>
        /// <dd>
        /// <p>Build output artifacts are being uploaded to the output location.</p>
        /// </dd>
        /// </dl>
        pub fn set_phase_type(
            mut self,
            input: std::option::Option<crate::model::BuildPhaseType>,
        ) -> Self {
            self.phase_type = input;
            self
        }
        /// <p>The current status of the build phase. Valid values include:</p>
        /// <dl>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The build phase failed.</p>
        /// </dd>
        /// <dt>FAULT</dt>
        /// <dd>
        /// <p>The build phase faulted.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The build phase is still in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The build phase stopped.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The build phase succeeded.</p>
        /// </dd>
        /// <dt>TIMED_OUT</dt>
        /// <dd>
        /// <p>The build phase timed out.</p>
        /// </dd>
        /// </dl>
        pub fn phase_status(mut self, input: crate::model::StatusType) -> Self {
            self.phase_status = Some(input);
            self
        }
        /// <p>The current status of the build phase. Valid values include:</p>
        /// <dl>
        /// <dt>FAILED</dt>
        /// <dd>
        /// <p>The build phase failed.</p>
        /// </dd>
        /// <dt>FAULT</dt>
        /// <dd>
        /// <p>The build phase faulted.</p>
        /// </dd>
        /// <dt>IN_PROGRESS</dt>
        /// <dd>
        /// <p>The build phase is still in progress.</p>
        /// </dd>
        /// <dt>STOPPED</dt>
        /// <dd>
        /// <p>The build phase stopped.</p>
        /// </dd>
        /// <dt>SUCCEEDED</dt>
        /// <dd>
        /// <p>The build phase succeeded.</p>
        /// </dd>
        /// <dt>TIMED_OUT</dt>
        /// <dd>
        /// <p>The build phase timed out.</p>
        /// </dd>
        /// </dl>
        pub fn set_phase_status(
            mut self,
            input: std::option::Option<crate::model::StatusType>,
        ) -> Self {
            self.phase_status = input;
            self
        }
        /// <p>When the build phase started, expressed in Unix time format.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>When the build phase started, expressed in Unix time format.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>When the build phase ended, expressed in Unix time format.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>When the build phase ended, expressed in Unix time format.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>How long, in seconds, between the starting and ending times of the build's
        /// phase.</p>
        pub fn duration_in_seconds(mut self, input: i64) -> Self {
            self.duration_in_seconds = Some(input);
            self
        }
        /// <p>How long, in seconds, between the starting and ending times of the build's
        /// phase.</p>
        pub fn set_duration_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_seconds = input;
            self
        }
        /// Appends an item to `contexts`.
        ///
        /// To override the contents of this collection use [`set_contexts`](Self::set_contexts).
        ///
        /// <p>Additional information about a build phase, especially to help troubleshoot a failed
        /// build.</p>
        pub fn contexts(mut self, input: impl Into<crate::model::PhaseContext>) -> Self {
            let mut v = self.contexts.unwrap_or_default();
            v.push(input.into());
            self.contexts = Some(v);
            self
        }
        /// <p>Additional information about a build phase, especially to help troubleshoot a failed
        /// build.</p>
        pub fn set_contexts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhaseContext>>,
        ) -> Self {
            self.contexts = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildPhase`](crate::model::BuildPhase)
        pub fn build(self) -> crate::model::BuildPhase {
            crate::model::BuildPhase {
                phase_type: self.phase_type,
                phase_status: self.phase_status,
                start_time: self.start_time,
                end_time: self.end_time,
                duration_in_seconds: self.duration_in_seconds,
                contexts: self.contexts,
            }
        }
    }
}
impl BuildPhase {
    /// Creates a new builder-style object to manufacture [`BuildPhase`](crate::model::BuildPhase)
    pub fn builder() -> crate::model::build_phase::Builder {
        crate::model::build_phase::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BuildPhaseType {
    #[allow(missing_docs)] // documentation missing in model
    Build,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    DownloadSource,
    #[allow(missing_docs)] // documentation missing in model
    Finalizing,
    #[allow(missing_docs)] // documentation missing in model
    Install,
    #[allow(missing_docs)] // documentation missing in model
    PostBuild,
    #[allow(missing_docs)] // documentation missing in model
    PreBuild,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    #[allow(missing_docs)] // documentation missing in model
    Queued,
    #[allow(missing_docs)] // documentation missing in model
    Submitted,
    #[allow(missing_docs)] // documentation missing in model
    UploadArtifacts,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BuildPhaseType {
    fn from(s: &str) -> Self {
        match s {
            "BUILD" => BuildPhaseType::Build,
            "COMPLETED" => BuildPhaseType::Completed,
            "DOWNLOAD_SOURCE" => BuildPhaseType::DownloadSource,
            "FINALIZING" => BuildPhaseType::Finalizing,
            "INSTALL" => BuildPhaseType::Install,
            "POST_BUILD" => BuildPhaseType::PostBuild,
            "PRE_BUILD" => BuildPhaseType::PreBuild,
            "PROVISIONING" => BuildPhaseType::Provisioning,
            "QUEUED" => BuildPhaseType::Queued,
            "SUBMITTED" => BuildPhaseType::Submitted,
            "UPLOAD_ARTIFACTS" => BuildPhaseType::UploadArtifacts,
            other => BuildPhaseType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BuildPhaseType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BuildPhaseType::from(s))
    }
}
impl BuildPhaseType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BuildPhaseType::Build => "BUILD",
            BuildPhaseType::Completed => "COMPLETED",
            BuildPhaseType::DownloadSource => "DOWNLOAD_SOURCE",
            BuildPhaseType::Finalizing => "FINALIZING",
            BuildPhaseType::Install => "INSTALL",
            BuildPhaseType::PostBuild => "POST_BUILD",
            BuildPhaseType::PreBuild => "PRE_BUILD",
            BuildPhaseType::Provisioning => "PROVISIONING",
            BuildPhaseType::Queued => "QUEUED",
            BuildPhaseType::Submitted => "SUBMITTED",
            BuildPhaseType::UploadArtifacts => "UPLOAD_ARTIFACTS",
            BuildPhaseType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BUILD",
            "COMPLETED",
            "DOWNLOAD_SOURCE",
            "FINALIZING",
            "INSTALL",
            "POST_BUILD",
            "PRE_BUILD",
            "PROVISIONING",
            "QUEUED",
            "SUBMITTED",
            "UPLOAD_ARTIFACTS",
        ]
    }
}
impl AsRef<str> for BuildPhaseType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RetryBuildBatchType {
    #[allow(missing_docs)] // documentation missing in model
    RetryAllBuilds,
    #[allow(missing_docs)] // documentation missing in model
    RetryFailedBuilds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RetryBuildBatchType {
    fn from(s: &str) -> Self {
        match s {
            "RETRY_ALL_BUILDS" => RetryBuildBatchType::RetryAllBuilds,
            "RETRY_FAILED_BUILDS" => RetryBuildBatchType::RetryFailedBuilds,
            other => RetryBuildBatchType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RetryBuildBatchType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RetryBuildBatchType::from(s))
    }
}
impl RetryBuildBatchType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RetryBuildBatchType::RetryAllBuilds => "RETRY_ALL_BUILDS",
            RetryBuildBatchType::RetryFailedBuilds => "RETRY_FAILED_BUILDS",
            RetryBuildBatchType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RETRY_ALL_BUILDS", "RETRY_FAILED_BUILDS"]
    }
}
impl AsRef<str> for RetryBuildBatchType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about the credentials for a GitHub, GitHub Enterprise, or Bitbucket
/// repository. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceCredentialsInfo {
    /// <p> The Amazon Resource Name (ARN) of the token. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or
    /// BITBUCKET. </p>
    pub server_type: std::option::Option<crate::model::ServerType>,
    /// <p> The type of authentication used by the credentials. Valid options are OAUTH,
    /// BASIC_AUTH, or PERSONAL_ACCESS_TOKEN. </p>
    pub auth_type: std::option::Option<crate::model::AuthType>,
}
impl SourceCredentialsInfo {
    /// <p> The Amazon Resource Name (ARN) of the token. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or
    /// BITBUCKET. </p>
    pub fn server_type(&self) -> std::option::Option<&crate::model::ServerType> {
        self.server_type.as_ref()
    }
    /// <p> The type of authentication used by the credentials. Valid options are OAUTH,
    /// BASIC_AUTH, or PERSONAL_ACCESS_TOKEN. </p>
    pub fn auth_type(&self) -> std::option::Option<&crate::model::AuthType> {
        self.auth_type.as_ref()
    }
}
impl std::fmt::Debug for SourceCredentialsInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceCredentialsInfo");
        formatter.field("arn", &self.arn);
        formatter.field("server_type", &self.server_type);
        formatter.field("auth_type", &self.auth_type);
        formatter.finish()
    }
}
/// See [`SourceCredentialsInfo`](crate::model::SourceCredentialsInfo)
pub mod source_credentials_info {
    /// A builder for [`SourceCredentialsInfo`](crate::model::SourceCredentialsInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) server_type: std::option::Option<crate::model::ServerType>,
        pub(crate) auth_type: std::option::Option<crate::model::AuthType>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the token. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the token. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or
        /// BITBUCKET. </p>
        pub fn server_type(mut self, input: crate::model::ServerType) -> Self {
            self.server_type = Some(input);
            self
        }
        /// <p> The type of source provider. The valid options are GITHUB, GITHUB_ENTERPRISE, or
        /// BITBUCKET. </p>
        pub fn set_server_type(
            mut self,
            input: std::option::Option<crate::model::ServerType>,
        ) -> Self {
            self.server_type = input;
            self
        }
        /// <p> The type of authentication used by the credentials. Valid options are OAUTH,
        /// BASIC_AUTH, or PERSONAL_ACCESS_TOKEN. </p>
        pub fn auth_type(mut self, input: crate::model::AuthType) -> Self {
            self.auth_type = Some(input);
            self
        }
        /// <p> The type of authentication used by the credentials. Valid options are OAUTH,
        /// BASIC_AUTH, or PERSONAL_ACCESS_TOKEN. </p>
        pub fn set_auth_type(mut self, input: std::option::Option<crate::model::AuthType>) -> Self {
            self.auth_type = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceCredentialsInfo`](crate::model::SourceCredentialsInfo)
        pub fn build(self) -> crate::model::SourceCredentialsInfo {
            crate::model::SourceCredentialsInfo {
                arn: self.arn,
                server_type: self.server_type,
                auth_type: self.auth_type,
            }
        }
    }
}
impl SourceCredentialsInfo {
    /// Creates a new builder-style object to manufacture [`SourceCredentialsInfo`](crate::model::SourceCredentialsInfo)
    pub fn builder() -> crate::model::source_credentials_info::Builder {
        crate::model::source_credentials_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthType {
    #[allow(missing_docs)] // documentation missing in model
    BasicAuth,
    #[allow(missing_docs)] // documentation missing in model
    Oauth,
    #[allow(missing_docs)] // documentation missing in model
    PersonalAccessToken,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthType {
    fn from(s: &str) -> Self {
        match s {
            "BASIC_AUTH" => AuthType::BasicAuth,
            "OAUTH" => AuthType::Oauth,
            "PERSONAL_ACCESS_TOKEN" => AuthType::PersonalAccessToken,
            other => AuthType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthType::from(s))
    }
}
impl AuthType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthType::BasicAuth => "BASIC_AUTH",
            AuthType::Oauth => "OAUTH",
            AuthType::PersonalAccessToken => "PERSONAL_ACCESS_TOKEN",
            AuthType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BASIC_AUTH", "OAUTH", "PERSONAL_ACCESS_TOKEN"]
    }
}
impl AsRef<str> for AuthType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServerType {
    #[allow(missing_docs)] // documentation missing in model
    Bitbucket,
    #[allow(missing_docs)] // documentation missing in model
    Github,
    #[allow(missing_docs)] // documentation missing in model
    GithubEnterprise,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServerType {
    fn from(s: &str) -> Self {
        match s {
            "BITBUCKET" => ServerType::Bitbucket,
            "GITHUB" => ServerType::Github,
            "GITHUB_ENTERPRISE" => ServerType::GithubEnterprise,
            other => ServerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServerType::from(s))
    }
}
impl ServerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServerType::Bitbucket => "BITBUCKET",
            ServerType::Github => "GITHUB",
            ServerType::GithubEnterprise => "GITHUB_ENTERPRISE",
            ServerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BITBUCKET", "GITHUB", "GITHUB_ENTERPRISE"]
    }
}
impl AsRef<str> for ServerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SharedResourceSortByType {
    #[allow(missing_docs)] // documentation missing in model
    Arn,
    #[allow(missing_docs)] // documentation missing in model
    ModifiedTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SharedResourceSortByType {
    fn from(s: &str) -> Self {
        match s {
            "ARN" => SharedResourceSortByType::Arn,
            "MODIFIED_TIME" => SharedResourceSortByType::ModifiedTime,
            other => SharedResourceSortByType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SharedResourceSortByType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SharedResourceSortByType::from(s))
    }
}
impl SharedResourceSortByType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SharedResourceSortByType::Arn => "ARN",
            SharedResourceSortByType::ModifiedTime => "MODIFIED_TIME",
            SharedResourceSortByType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARN", "MODIFIED_TIME"]
    }
}
impl AsRef<str> for SharedResourceSortByType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrderType {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrderType {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrderType::Ascending,
            "DESCENDING" => SortOrderType::Descending,
            other => SortOrderType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrderType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrderType::from(s))
    }
}
impl SortOrderType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrderType::Ascending => "ASCENDING",
            SortOrderType::Descending => "DESCENDING",
            SortOrderType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrderType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A filter used to return reports with the status specified by the input
/// <code>status</code> parameter. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportFilter {
    /// <p> The status used to filter reports. You can filter using one status only. </p>
    pub status: std::option::Option<crate::model::ReportStatusType>,
}
impl ReportFilter {
    /// <p> The status used to filter reports. You can filter using one status only. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReportStatusType> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ReportFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportFilter");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ReportFilter`](crate::model::ReportFilter)
pub mod report_filter {
    /// A builder for [`ReportFilter`](crate::model::ReportFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ReportStatusType>,
    }
    impl Builder {
        /// <p> The status used to filter reports. You can filter using one status only. </p>
        pub fn status(mut self, input: crate::model::ReportStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status used to filter reports. You can filter using one status only. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReportStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportFilter`](crate::model::ReportFilter)
        pub fn build(self) -> crate::model::ReportFilter {
            crate::model::ReportFilter {
                status: self.status,
            }
        }
    }
}
impl ReportFilter {
    /// Creates a new builder-style object to manufacture [`ReportFilter`](crate::model::ReportFilter)
    pub fn builder() -> crate::model::report_filter::Builder {
        crate::model::report_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Generating,
    #[allow(missing_docs)] // documentation missing in model
    Incomplete,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportStatusType {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => ReportStatusType::Deleting,
            "FAILED" => ReportStatusType::Failed,
            "GENERATING" => ReportStatusType::Generating,
            "INCOMPLETE" => ReportStatusType::Incomplete,
            "SUCCEEDED" => ReportStatusType::Succeeded,
            other => ReportStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportStatusType::from(s))
    }
}
impl ReportStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportStatusType::Deleting => "DELETING",
            ReportStatusType::Failed => "FAILED",
            ReportStatusType::Generating => "GENERATING",
            ReportStatusType::Incomplete => "INCOMPLETE",
            ReportStatusType::Succeeded => "SUCCEEDED",
            ReportStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETING",
            "FAILED",
            "GENERATING",
            "INCOMPLETE",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for ReportStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportGroupSortByType {
    #[allow(missing_docs)] // documentation missing in model
    CreatedTime,
    #[allow(missing_docs)] // documentation missing in model
    LastModifiedTime,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportGroupSortByType {
    fn from(s: &str) -> Self {
        match s {
            "CREATED_TIME" => ReportGroupSortByType::CreatedTime,
            "LAST_MODIFIED_TIME" => ReportGroupSortByType::LastModifiedTime,
            "NAME" => ReportGroupSortByType::Name,
            other => ReportGroupSortByType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportGroupSortByType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportGroupSortByType::from(s))
    }
}
impl ReportGroupSortByType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportGroupSortByType::CreatedTime => "CREATED_TIME",
            ReportGroupSortByType::LastModifiedTime => "LAST_MODIFIED_TIME",
            ReportGroupSortByType::Name => "NAME",
            ReportGroupSortByType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED_TIME", "LAST_MODIFIED_TIME", "NAME"]
    }
}
impl AsRef<str> for ReportGroupSortByType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProjectSortByType {
    #[allow(missing_docs)] // documentation missing in model
    CreatedTime,
    #[allow(missing_docs)] // documentation missing in model
    LastModifiedTime,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProjectSortByType {
    fn from(s: &str) -> Self {
        match s {
            "CREATED_TIME" => ProjectSortByType::CreatedTime,
            "LAST_MODIFIED_TIME" => ProjectSortByType::LastModifiedTime,
            "NAME" => ProjectSortByType::Name,
            other => ProjectSortByType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProjectSortByType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProjectSortByType::from(s))
    }
}
impl ProjectSortByType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProjectSortByType::CreatedTime => "CREATED_TIME",
            ProjectSortByType::LastModifiedTime => "LAST_MODIFIED_TIME",
            ProjectSortByType::Name => "NAME",
            ProjectSortByType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATED_TIME", "LAST_MODIFIED_TIME", "NAME"]
    }
}
impl AsRef<str> for ProjectSortByType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of Docker images that are related by platform and are managed by CodeBuild.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentPlatform {
    /// <p>The platform's name.</p>
    pub platform: std::option::Option<crate::model::PlatformType>,
    /// <p>The list of programming languages that are available for the specified
    /// platform.</p>
    pub languages: std::option::Option<std::vec::Vec<crate::model::EnvironmentLanguage>>,
}
impl EnvironmentPlatform {
    /// <p>The platform's name.</p>
    pub fn platform(&self) -> std::option::Option<&crate::model::PlatformType> {
        self.platform.as_ref()
    }
    /// <p>The list of programming languages that are available for the specified
    /// platform.</p>
    pub fn languages(&self) -> std::option::Option<&[crate::model::EnvironmentLanguage]> {
        self.languages.as_deref()
    }
}
impl std::fmt::Debug for EnvironmentPlatform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentPlatform");
        formatter.field("platform", &self.platform);
        formatter.field("languages", &self.languages);
        formatter.finish()
    }
}
/// See [`EnvironmentPlatform`](crate::model::EnvironmentPlatform)
pub mod environment_platform {
    /// A builder for [`EnvironmentPlatform`](crate::model::EnvironmentPlatform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platform: std::option::Option<crate::model::PlatformType>,
        pub(crate) languages: std::option::Option<std::vec::Vec<crate::model::EnvironmentLanguage>>,
    }
    impl Builder {
        /// <p>The platform's name.</p>
        pub fn platform(mut self, input: crate::model::PlatformType) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The platform's name.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::PlatformType>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// Appends an item to `languages`.
        ///
        /// To override the contents of this collection use [`set_languages`](Self::set_languages).
        ///
        /// <p>The list of programming languages that are available for the specified
        /// platform.</p>
        pub fn languages(mut self, input: impl Into<crate::model::EnvironmentLanguage>) -> Self {
            let mut v = self.languages.unwrap_or_default();
            v.push(input.into());
            self.languages = Some(v);
            self
        }
        /// <p>The list of programming languages that are available for the specified
        /// platform.</p>
        pub fn set_languages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentLanguage>>,
        ) -> Self {
            self.languages = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentPlatform`](crate::model::EnvironmentPlatform)
        pub fn build(self) -> crate::model::EnvironmentPlatform {
            crate::model::EnvironmentPlatform {
                platform: self.platform,
                languages: self.languages,
            }
        }
    }
}
impl EnvironmentPlatform {
    /// Creates a new builder-style object to manufacture [`EnvironmentPlatform`](crate::model::EnvironmentPlatform)
    pub fn builder() -> crate::model::environment_platform::Builder {
        crate::model::environment_platform::Builder::default()
    }
}

/// <p>A set of Docker images that are related by programming language and are managed by
/// CodeBuild.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentLanguage {
    /// <p>The programming language for the Docker images.</p>
    pub language: std::option::Option<crate::model::LanguageType>,
    /// <p>The list of Docker images that are related by the specified programming
    /// language.</p>
    pub images: std::option::Option<std::vec::Vec<crate::model::EnvironmentImage>>,
}
impl EnvironmentLanguage {
    /// <p>The programming language for the Docker images.</p>
    pub fn language(&self) -> std::option::Option<&crate::model::LanguageType> {
        self.language.as_ref()
    }
    /// <p>The list of Docker images that are related by the specified programming
    /// language.</p>
    pub fn images(&self) -> std::option::Option<&[crate::model::EnvironmentImage]> {
        self.images.as_deref()
    }
}
impl std::fmt::Debug for EnvironmentLanguage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentLanguage");
        formatter.field("language", &self.language);
        formatter.field("images", &self.images);
        formatter.finish()
    }
}
/// See [`EnvironmentLanguage`](crate::model::EnvironmentLanguage)
pub mod environment_language {
    /// A builder for [`EnvironmentLanguage`](crate::model::EnvironmentLanguage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language: std::option::Option<crate::model::LanguageType>,
        pub(crate) images: std::option::Option<std::vec::Vec<crate::model::EnvironmentImage>>,
    }
    impl Builder {
        /// <p>The programming language for the Docker images.</p>
        pub fn language(mut self, input: crate::model::LanguageType) -> Self {
            self.language = Some(input);
            self
        }
        /// <p>The programming language for the Docker images.</p>
        pub fn set_language(
            mut self,
            input: std::option::Option<crate::model::LanguageType>,
        ) -> Self {
            self.language = input;
            self
        }
        /// Appends an item to `images`.
        ///
        /// To override the contents of this collection use [`set_images`](Self::set_images).
        ///
        /// <p>The list of Docker images that are related by the specified programming
        /// language.</p>
        pub fn images(mut self, input: impl Into<crate::model::EnvironmentImage>) -> Self {
            let mut v = self.images.unwrap_or_default();
            v.push(input.into());
            self.images = Some(v);
            self
        }
        /// <p>The list of Docker images that are related by the specified programming
        /// language.</p>
        pub fn set_images(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentImage>>,
        ) -> Self {
            self.images = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentLanguage`](crate::model::EnvironmentLanguage)
        pub fn build(self) -> crate::model::EnvironmentLanguage {
            crate::model::EnvironmentLanguage {
                language: self.language,
                images: self.images,
            }
        }
    }
}
impl EnvironmentLanguage {
    /// Creates a new builder-style object to manufacture [`EnvironmentLanguage`](crate::model::EnvironmentLanguage)
    pub fn builder() -> crate::model::environment_language::Builder {
        crate::model::environment_language::Builder::default()
    }
}

/// <p>Information about a Docker image that is managed by CodeBuild.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnvironmentImage {
    /// <p>The name of the Docker image.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the Docker image.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of environment image versions.</p>
    pub versions: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EnvironmentImage {
    /// <p>The name of the Docker image.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the Docker image.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of environment image versions.</p>
    pub fn versions(&self) -> std::option::Option<&[std::string::String]> {
        self.versions.as_deref()
    }
}
impl std::fmt::Debug for EnvironmentImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnvironmentImage");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("versions", &self.versions);
        formatter.finish()
    }
}
/// See [`EnvironmentImage`](crate::model::EnvironmentImage)
pub mod environment_image {
    /// A builder for [`EnvironmentImage`](crate::model::EnvironmentImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) versions: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Docker image.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Docker image.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the Docker image.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the Docker image.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>A list of environment image versions.</p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>A list of environment image versions.</p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Consumes the builder and constructs a [`EnvironmentImage`](crate::model::EnvironmentImage)
        pub fn build(self) -> crate::model::EnvironmentImage {
            crate::model::EnvironmentImage {
                name: self.name,
                description: self.description,
                versions: self.versions,
            }
        }
    }
}
impl EnvironmentImage {
    /// Creates a new builder-style object to manufacture [`EnvironmentImage`](crate::model::EnvironmentImage)
    pub fn builder() -> crate::model::environment_image::Builder {
        crate::model::environment_image::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LanguageType {
    #[allow(missing_docs)] // documentation missing in model
    Android,
    #[allow(missing_docs)] // documentation missing in model
    Base,
    #[allow(missing_docs)] // documentation missing in model
    Docker,
    #[allow(missing_docs)] // documentation missing in model
    Dotnet,
    #[allow(missing_docs)] // documentation missing in model
    Golang,
    #[allow(missing_docs)] // documentation missing in model
    Java,
    #[allow(missing_docs)] // documentation missing in model
    NodeJs,
    #[allow(missing_docs)] // documentation missing in model
    Php,
    #[allow(missing_docs)] // documentation missing in model
    Python,
    #[allow(missing_docs)] // documentation missing in model
    Ruby,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LanguageType {
    fn from(s: &str) -> Self {
        match s {
            "ANDROID" => LanguageType::Android,
            "BASE" => LanguageType::Base,
            "DOCKER" => LanguageType::Docker,
            "DOTNET" => LanguageType::Dotnet,
            "GOLANG" => LanguageType::Golang,
            "JAVA" => LanguageType::Java,
            "NODE_JS" => LanguageType::NodeJs,
            "PHP" => LanguageType::Php,
            "PYTHON" => LanguageType::Python,
            "RUBY" => LanguageType::Ruby,
            other => LanguageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LanguageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LanguageType::from(s))
    }
}
impl LanguageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LanguageType::Android => "ANDROID",
            LanguageType::Base => "BASE",
            LanguageType::Docker => "DOCKER",
            LanguageType::Dotnet => "DOTNET",
            LanguageType::Golang => "GOLANG",
            LanguageType::Java => "JAVA",
            LanguageType::NodeJs => "NODE_JS",
            LanguageType::Php => "PHP",
            LanguageType::Python => "PYTHON",
            LanguageType::Ruby => "RUBY",
            LanguageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ANDROID", "BASE", "DOCKER", "DOTNET", "GOLANG", "JAVA", "NODE_JS", "PHP", "PYTHON",
            "RUBY",
        ]
    }
}
impl AsRef<str> for LanguageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlatformType {
    #[allow(missing_docs)] // documentation missing in model
    AmazonLinux,
    #[allow(missing_docs)] // documentation missing in model
    Debian,
    #[allow(missing_docs)] // documentation missing in model
    Ubuntu,
    #[allow(missing_docs)] // documentation missing in model
    WindowsServer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlatformType {
    fn from(s: &str) -> Self {
        match s {
            "AMAZON_LINUX" => PlatformType::AmazonLinux,
            "DEBIAN" => PlatformType::Debian,
            "UBUNTU" => PlatformType::Ubuntu,
            "WINDOWS_SERVER" => PlatformType::WindowsServer,
            other => PlatformType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlatformType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlatformType::from(s))
    }
}
impl PlatformType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlatformType::AmazonLinux => "AMAZON_LINUX",
            PlatformType::Debian => "DEBIAN",
            PlatformType::Ubuntu => "UBUNTU",
            PlatformType::WindowsServer => "WINDOWS_SERVER",
            PlatformType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AMAZON_LINUX", "DEBIAN", "UBUNTU", "WINDOWS_SERVER"]
    }
}
impl AsRef<str> for PlatformType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies filters when retrieving batch builds.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildBatchFilter {
    /// <p>The status of the batch builds to retrieve. Only batch builds that have this status will
    /// be retrieved.</p>
    pub status: std::option::Option<crate::model::StatusType>,
}
impl BuildBatchFilter {
    /// <p>The status of the batch builds to retrieve. Only batch builds that have this status will
    /// be retrieved.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::StatusType> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for BuildBatchFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildBatchFilter");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`BuildBatchFilter`](crate::model::BuildBatchFilter)
pub mod build_batch_filter {
    /// A builder for [`BuildBatchFilter`](crate::model::BuildBatchFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::StatusType>,
    }
    impl Builder {
        /// <p>The status of the batch builds to retrieve. Only batch builds that have this status will
        /// be retrieved.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the batch builds to retrieve. Only batch builds that have this status will
        /// be retrieved.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildBatchFilter`](crate::model::BuildBatchFilter)
        pub fn build(self) -> crate::model::BuildBatchFilter {
            crate::model::BuildBatchFilter {
                status: self.status,
            }
        }
    }
}
impl BuildBatchFilter {
    /// Creates a new builder-style object to manufacture [`BuildBatchFilter`](crate::model::BuildBatchFilter)
    pub fn builder() -> crate::model::build_batch_filter::Builder {
        crate::model::build_batch_filter::Builder::default()
    }
}

/// <p>Contains the unmodified data for the report. For more information, see .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportWithRawData {
    /// <p>The ARN of the report.</p>
    pub report_arn: std::option::Option<std::string::String>,
    /// <p>The value of the requested data field from the report.</p>
    pub data: std::option::Option<std::string::String>,
}
impl ReportWithRawData {
    /// <p>The ARN of the report.</p>
    pub fn report_arn(&self) -> std::option::Option<&str> {
        self.report_arn.as_deref()
    }
    /// <p>The value of the requested data field from the report.</p>
    pub fn data(&self) -> std::option::Option<&str> {
        self.data.as_deref()
    }
}
impl std::fmt::Debug for ReportWithRawData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportWithRawData");
        formatter.field("report_arn", &self.report_arn);
        formatter.field("data", &self.data);
        formatter.finish()
    }
}
/// See [`ReportWithRawData`](crate::model::ReportWithRawData)
pub mod report_with_raw_data {
    /// A builder for [`ReportWithRawData`](crate::model::ReportWithRawData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_arn: std::option::Option<std::string::String>,
        pub(crate) data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the report.</p>
        pub fn report_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the report.</p>
        pub fn set_report_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_arn = input;
            self
        }
        /// <p>The value of the requested data field from the report.</p>
        pub fn data(mut self, input: impl Into<std::string::String>) -> Self {
            self.data = Some(input.into());
            self
        }
        /// <p>The value of the requested data field from the report.</p>
        pub fn set_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportWithRawData`](crate::model::ReportWithRawData)
        pub fn build(self) -> crate::model::ReportWithRawData {
            crate::model::ReportWithRawData {
                report_arn: self.report_arn,
                data: self.data,
            }
        }
    }
}
impl ReportWithRawData {
    /// Creates a new builder-style object to manufacture [`ReportWithRawData`](crate::model::ReportWithRawData)
    pub fn builder() -> crate::model::report_with_raw_data::Builder {
        crate::model::report_with_raw_data::Builder::default()
    }
}

/// <p>Contains trend statistics for a set of reports. The actual values depend on the type of
/// trend being collected. For more information, see .</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReportGroupTrendStats {
    /// <p>Contains the average of all values analyzed.</p>
    pub average: std::option::Option<std::string::String>,
    /// <p>Contains the maximum value analyzed.</p>
    pub max: std::option::Option<std::string::String>,
    /// <p>Contains the minimum value analyzed.</p>
    pub min: std::option::Option<std::string::String>,
}
impl ReportGroupTrendStats {
    /// <p>Contains the average of all values analyzed.</p>
    pub fn average(&self) -> std::option::Option<&str> {
        self.average.as_deref()
    }
    /// <p>Contains the maximum value analyzed.</p>
    pub fn max(&self) -> std::option::Option<&str> {
        self.max.as_deref()
    }
    /// <p>Contains the minimum value analyzed.</p>
    pub fn min(&self) -> std::option::Option<&str> {
        self.min.as_deref()
    }
}
impl std::fmt::Debug for ReportGroupTrendStats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReportGroupTrendStats");
        formatter.field("average", &self.average);
        formatter.field("max", &self.max);
        formatter.field("min", &self.min);
        formatter.finish()
    }
}
/// See [`ReportGroupTrendStats`](crate::model::ReportGroupTrendStats)
pub mod report_group_trend_stats {
    /// A builder for [`ReportGroupTrendStats`](crate::model::ReportGroupTrendStats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) average: std::option::Option<std::string::String>,
        pub(crate) max: std::option::Option<std::string::String>,
        pub(crate) min: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains the average of all values analyzed.</p>
        pub fn average(mut self, input: impl Into<std::string::String>) -> Self {
            self.average = Some(input.into());
            self
        }
        /// <p>Contains the average of all values analyzed.</p>
        pub fn set_average(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.average = input;
            self
        }
        /// <p>Contains the maximum value analyzed.</p>
        pub fn max(mut self, input: impl Into<std::string::String>) -> Self {
            self.max = Some(input.into());
            self
        }
        /// <p>Contains the maximum value analyzed.</p>
        pub fn set_max(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.max = input;
            self
        }
        /// <p>Contains the minimum value analyzed.</p>
        pub fn min(mut self, input: impl Into<std::string::String>) -> Self {
            self.min = Some(input.into());
            self
        }
        /// <p>Contains the minimum value analyzed.</p>
        pub fn set_min(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.min = input;
            self
        }
        /// Consumes the builder and constructs a [`ReportGroupTrendStats`](crate::model::ReportGroupTrendStats)
        pub fn build(self) -> crate::model::ReportGroupTrendStats {
            crate::model::ReportGroupTrendStats {
                average: self.average,
                max: self.max,
                min: self.min,
            }
        }
    }
}
impl ReportGroupTrendStats {
    /// Creates a new builder-style object to manufacture [`ReportGroupTrendStats`](crate::model::ReportGroupTrendStats)
    pub fn builder() -> crate::model::report_group_trend_stats::Builder {
        crate::model::report_group_trend_stats::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportGroupTrendFieldType {
    #[allow(missing_docs)] // documentation missing in model
    BranchesCovered,
    #[allow(missing_docs)] // documentation missing in model
    BranchesMissed,
    #[allow(missing_docs)] // documentation missing in model
    BranchCoverage,
    #[allow(missing_docs)] // documentation missing in model
    Duration,
    #[allow(missing_docs)] // documentation missing in model
    LinesCovered,
    #[allow(missing_docs)] // documentation missing in model
    LinesMissed,
    #[allow(missing_docs)] // documentation missing in model
    LineCoverage,
    #[allow(missing_docs)] // documentation missing in model
    PassRate,
    #[allow(missing_docs)] // documentation missing in model
    Total,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportGroupTrendFieldType {
    fn from(s: &str) -> Self {
        match s {
            "BRANCHES_COVERED" => ReportGroupTrendFieldType::BranchesCovered,
            "BRANCHES_MISSED" => ReportGroupTrendFieldType::BranchesMissed,
            "BRANCH_COVERAGE" => ReportGroupTrendFieldType::BranchCoverage,
            "DURATION" => ReportGroupTrendFieldType::Duration,
            "LINES_COVERED" => ReportGroupTrendFieldType::LinesCovered,
            "LINES_MISSED" => ReportGroupTrendFieldType::LinesMissed,
            "LINE_COVERAGE" => ReportGroupTrendFieldType::LineCoverage,
            "PASS_RATE" => ReportGroupTrendFieldType::PassRate,
            "TOTAL" => ReportGroupTrendFieldType::Total,
            other => ReportGroupTrendFieldType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportGroupTrendFieldType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportGroupTrendFieldType::from(s))
    }
}
impl ReportGroupTrendFieldType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportGroupTrendFieldType::BranchesCovered => "BRANCHES_COVERED",
            ReportGroupTrendFieldType::BranchesMissed => "BRANCHES_MISSED",
            ReportGroupTrendFieldType::BranchCoverage => "BRANCH_COVERAGE",
            ReportGroupTrendFieldType::Duration => "DURATION",
            ReportGroupTrendFieldType::LinesCovered => "LINES_COVERED",
            ReportGroupTrendFieldType::LinesMissed => "LINES_MISSED",
            ReportGroupTrendFieldType::LineCoverage => "LINE_COVERAGE",
            ReportGroupTrendFieldType::PassRate => "PASS_RATE",
            ReportGroupTrendFieldType::Total => "TOTAL",
            ReportGroupTrendFieldType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BRANCHES_COVERED",
            "BRANCHES_MISSED",
            "BRANCH_COVERAGE",
            "DURATION",
            "LINES_COVERED",
            "LINES_MISSED",
            "LINE_COVERAGE",
            "PASS_RATE",
            "TOTAL",
        ]
    }
}
impl AsRef<str> for ReportGroupTrendFieldType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> Information about a test case created using a framework such as NUnit or Cucumber. A
/// test case might be a unit test or a configuration test. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestCase {
    /// <p> The ARN of the report to which the test case belongs. </p>
    pub report_arn: std::option::Option<std::string::String>,
    /// <p> The path to the raw data file that contains the test result. </p>
    pub test_raw_data_path: std::option::Option<std::string::String>,
    /// <p> A string that is applied to a series of related test cases. CodeBuild generates the
    /// prefix. The prefix depends on the framework used to generate the tests. </p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p> The name of the test case. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The status returned by the test case after it was run. Valid statuses are
    /// <code>SUCCEEDED</code>, <code>FAILED</code>, <code>ERROR</code>,
    /// <code>SKIPPED</code>, and <code>UNKNOWN</code>. </p>
    pub status: std::option::Option<std::string::String>,
    /// <p> The number of nanoseconds it took to run this test case. </p>
    pub duration_in_nano_seconds: std::option::Option<i64>,
    /// <p> A message associated with a test case. For example, an error message or stack trace.
    /// </p>
    pub message: std::option::Option<std::string::String>,
    /// <p> The date and time a test case expires. A test case expires 30 days after it is
    /// created. An expired test case is not available to view in CodeBuild. </p>
    pub expired: std::option::Option<aws_smithy_types::DateTime>,
}
impl TestCase {
    /// <p> The ARN of the report to which the test case belongs. </p>
    pub fn report_arn(&self) -> std::option::Option<&str> {
        self.report_arn.as_deref()
    }
    /// <p> The path to the raw data file that contains the test result. </p>
    pub fn test_raw_data_path(&self) -> std::option::Option<&str> {
        self.test_raw_data_path.as_deref()
    }
    /// <p> A string that is applied to a series of related test cases. CodeBuild generates the
    /// prefix. The prefix depends on the framework used to generate the tests. </p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p> The name of the test case. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The status returned by the test case after it was run. Valid statuses are
    /// <code>SUCCEEDED</code>, <code>FAILED</code>, <code>ERROR</code>,
    /// <code>SKIPPED</code>, and <code>UNKNOWN</code>. </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p> The number of nanoseconds it took to run this test case. </p>
    pub fn duration_in_nano_seconds(&self) -> std::option::Option<i64> {
        self.duration_in_nano_seconds
    }
    /// <p> A message associated with a test case. For example, an error message or stack trace.
    /// </p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p> The date and time a test case expires. A test case expires 30 days after it is
    /// created. An expired test case is not available to view in CodeBuild. </p>
    pub fn expired(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expired.as_ref()
    }
}
impl std::fmt::Debug for TestCase {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestCase");
        formatter.field("report_arn", &self.report_arn);
        formatter.field("test_raw_data_path", &self.test_raw_data_path);
        formatter.field("prefix", &self.prefix);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("duration_in_nano_seconds", &self.duration_in_nano_seconds);
        formatter.field("message", &self.message);
        formatter.field("expired", &self.expired);
        formatter.finish()
    }
}
/// See [`TestCase`](crate::model::TestCase)
pub mod test_case {
    /// A builder for [`TestCase`](crate::model::TestCase)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_arn: std::option::Option<std::string::String>,
        pub(crate) test_raw_data_path: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) duration_in_nano_seconds: std::option::Option<i64>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) expired: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p> The ARN of the report to which the test case belongs. </p>
        pub fn report_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_arn = Some(input.into());
            self
        }
        /// <p> The ARN of the report to which the test case belongs. </p>
        pub fn set_report_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_arn = input;
            self
        }
        /// <p> The path to the raw data file that contains the test result. </p>
        pub fn test_raw_data_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.test_raw_data_path = Some(input.into());
            self
        }
        /// <p> The path to the raw data file that contains the test result. </p>
        pub fn set_test_raw_data_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.test_raw_data_path = input;
            self
        }
        /// <p> A string that is applied to a series of related test cases. CodeBuild generates the
        /// prefix. The prefix depends on the framework used to generate the tests. </p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p> A string that is applied to a series of related test cases. CodeBuild generates the
        /// prefix. The prefix depends on the framework used to generate the tests. </p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p> The name of the test case. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the test case. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The status returned by the test case after it was run. Valid statuses are
        /// <code>SUCCEEDED</code>, <code>FAILED</code>, <code>ERROR</code>,
        /// <code>SKIPPED</code>, and <code>UNKNOWN</code>. </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p> The status returned by the test case after it was run. Valid statuses are
        /// <code>SUCCEEDED</code>, <code>FAILED</code>, <code>ERROR</code>,
        /// <code>SKIPPED</code>, and <code>UNKNOWN</code>. </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p> The number of nanoseconds it took to run this test case. </p>
        pub fn duration_in_nano_seconds(mut self, input: i64) -> Self {
            self.duration_in_nano_seconds = Some(input);
            self
        }
        /// <p> The number of nanoseconds it took to run this test case. </p>
        pub fn set_duration_in_nano_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_nano_seconds = input;
            self
        }
        /// <p> A message associated with a test case. For example, an error message or stack trace.
        /// </p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p> A message associated with a test case. For example, an error message or stack trace.
        /// </p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The date and time a test case expires. A test case expires 30 days after it is
        /// created. An expired test case is not available to view in CodeBuild. </p>
        pub fn expired(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expired = Some(input);
            self
        }
        /// <p> The date and time a test case expires. A test case expires 30 days after it is
        /// created. An expired test case is not available to view in CodeBuild. </p>
        pub fn set_expired(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expired = input;
            self
        }
        /// Consumes the builder and constructs a [`TestCase`](crate::model::TestCase)
        pub fn build(self) -> crate::model::TestCase {
            crate::model::TestCase {
                report_arn: self.report_arn,
                test_raw_data_path: self.test_raw_data_path,
                prefix: self.prefix,
                name: self.name,
                status: self.status,
                duration_in_nano_seconds: self.duration_in_nano_seconds,
                message: self.message,
                expired: self.expired,
            }
        }
    }
}
impl TestCase {
    /// Creates a new builder-style object to manufacture [`TestCase`](crate::model::TestCase)
    pub fn builder() -> crate::model::test_case::Builder {
        crate::model::test_case::Builder::default()
    }
}

/// <p>A filter used to return specific types of test cases. In order to pass the filter, the
/// report must meet all of the filter properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestCaseFilter {
    /// <p>The status used to filter test cases. A <code>TestCaseFilter</code> can have one
    /// status. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCEEDED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNKNOWN</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>A keyword that is used to filter on the <code>name</code> or the <code>prefix</code>
    /// of the test cases. Only test cases where the keyword is a substring of the
    /// <code>name</code> or the <code>prefix</code> will be returned.</p>
    pub keyword: std::option::Option<std::string::String>,
}
impl TestCaseFilter {
    /// <p>The status used to filter test cases. A <code>TestCaseFilter</code> can have one
    /// status. Valid values are:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>SUCCEEDED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ERROR</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNKNOWN</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A keyword that is used to filter on the <code>name</code> or the <code>prefix</code>
    /// of the test cases. Only test cases where the keyword is a substring of the
    /// <code>name</code> or the <code>prefix</code> will be returned.</p>
    pub fn keyword(&self) -> std::option::Option<&str> {
        self.keyword.as_deref()
    }
}
impl std::fmt::Debug for TestCaseFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestCaseFilter");
        formatter.field("status", &self.status);
        formatter.field("keyword", &self.keyword);
        formatter.finish()
    }
}
/// See [`TestCaseFilter`](crate::model::TestCaseFilter)
pub mod test_case_filter {
    /// A builder for [`TestCaseFilter`](crate::model::TestCaseFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) keyword: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status used to filter test cases. A <code>TestCaseFilter</code> can have one
        /// status. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNKNOWN</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status used to filter test cases. A <code>TestCaseFilter</code> can have one
        /// status. Valid values are:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>SUCCEEDED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ERROR</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNKNOWN</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A keyword that is used to filter on the <code>name</code> or the <code>prefix</code>
        /// of the test cases. Only test cases where the keyword is a substring of the
        /// <code>name</code> or the <code>prefix</code> will be returned.</p>
        pub fn keyword(mut self, input: impl Into<std::string::String>) -> Self {
            self.keyword = Some(input.into());
            self
        }
        /// <p>A keyword that is used to filter on the <code>name</code> or the <code>prefix</code>
        /// of the test cases. Only test cases where the keyword is a substring of the
        /// <code>name</code> or the <code>prefix</code> will be returned.</p>
        pub fn set_keyword(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.keyword = input;
            self
        }
        /// Consumes the builder and constructs a [`TestCaseFilter`](crate::model::TestCaseFilter)
        pub fn build(self) -> crate::model::TestCaseFilter {
            crate::model::TestCaseFilter {
                status: self.status,
                keyword: self.keyword,
            }
        }
    }
}
impl TestCaseFilter {
    /// Creates a new builder-style object to manufacture [`TestCaseFilter`](crate::model::TestCaseFilter)
    pub fn builder() -> crate::model::test_case_filter::Builder {
        crate::model::test_case_filter::Builder::default()
    }
}

/// <p>Contains code coverage report information.</p>
/// <p>Line coverage measures how many statements your tests cover. A statement is a single
/// instruction, not including comments, conditionals, etc.</p>
/// <p>Branch coverage determines if your tests cover every possible branch of a control
/// structure, such as an <code>if</code> or <code>case</code> statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeCoverage {
    /// <p>The identifier of the code coverage report.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The ARN of the report.</p>
    pub report_arn: std::option::Option<std::string::String>,
    /// <p>The path of the test report file.</p>
    pub file_path: std::option::Option<std::string::String>,
    /// <p>The percentage of lines that are covered by your tests.</p>
    pub line_coverage_percentage: std::option::Option<f64>,
    /// <p>The number of lines that are covered by your tests.</p>
    pub lines_covered: std::option::Option<i32>,
    /// <p>The number of lines that are not covered by your tests.</p>
    pub lines_missed: std::option::Option<i32>,
    /// <p>The percentage of branches that are covered by your tests.</p>
    pub branch_coverage_percentage: std::option::Option<f64>,
    /// <p>The number of conditional branches that are covered by your tests.</p>
    pub branches_covered: std::option::Option<i32>,
    /// <p>The number of conditional branches that are not covered by your tests.</p>
    pub branches_missed: std::option::Option<i32>,
    /// <p>The date and time that the tests were run.</p>
    pub expired: std::option::Option<aws_smithy_types::DateTime>,
}
impl CodeCoverage {
    /// <p>The identifier of the code coverage report.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The ARN of the report.</p>
    pub fn report_arn(&self) -> std::option::Option<&str> {
        self.report_arn.as_deref()
    }
    /// <p>The path of the test report file.</p>
    pub fn file_path(&self) -> std::option::Option<&str> {
        self.file_path.as_deref()
    }
    /// <p>The percentage of lines that are covered by your tests.</p>
    pub fn line_coverage_percentage(&self) -> std::option::Option<f64> {
        self.line_coverage_percentage
    }
    /// <p>The number of lines that are covered by your tests.</p>
    pub fn lines_covered(&self) -> std::option::Option<i32> {
        self.lines_covered
    }
    /// <p>The number of lines that are not covered by your tests.</p>
    pub fn lines_missed(&self) -> std::option::Option<i32> {
        self.lines_missed
    }
    /// <p>The percentage of branches that are covered by your tests.</p>
    pub fn branch_coverage_percentage(&self) -> std::option::Option<f64> {
        self.branch_coverage_percentage
    }
    /// <p>The number of conditional branches that are covered by your tests.</p>
    pub fn branches_covered(&self) -> std::option::Option<i32> {
        self.branches_covered
    }
    /// <p>The number of conditional branches that are not covered by your tests.</p>
    pub fn branches_missed(&self) -> std::option::Option<i32> {
        self.branches_missed
    }
    /// <p>The date and time that the tests were run.</p>
    pub fn expired(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expired.as_ref()
    }
}
impl std::fmt::Debug for CodeCoverage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeCoverage");
        formatter.field("id", &self.id);
        formatter.field("report_arn", &self.report_arn);
        formatter.field("file_path", &self.file_path);
        formatter.field("line_coverage_percentage", &self.line_coverage_percentage);
        formatter.field("lines_covered", &self.lines_covered);
        formatter.field("lines_missed", &self.lines_missed);
        formatter.field(
            "branch_coverage_percentage",
            &self.branch_coverage_percentage,
        );
        formatter.field("branches_covered", &self.branches_covered);
        formatter.field("branches_missed", &self.branches_missed);
        formatter.field("expired", &self.expired);
        formatter.finish()
    }
}
/// See [`CodeCoverage`](crate::model::CodeCoverage)
pub mod code_coverage {
    /// A builder for [`CodeCoverage`](crate::model::CodeCoverage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) report_arn: std::option::Option<std::string::String>,
        pub(crate) file_path: std::option::Option<std::string::String>,
        pub(crate) line_coverage_percentage: std::option::Option<f64>,
        pub(crate) lines_covered: std::option::Option<i32>,
        pub(crate) lines_missed: std::option::Option<i32>,
        pub(crate) branch_coverage_percentage: std::option::Option<f64>,
        pub(crate) branches_covered: std::option::Option<i32>,
        pub(crate) branches_missed: std::option::Option<i32>,
        pub(crate) expired: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the code coverage report.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The identifier of the code coverage report.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The ARN of the report.</p>
        pub fn report_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the report.</p>
        pub fn set_report_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.report_arn = input;
            self
        }
        /// <p>The path of the test report file.</p>
        pub fn file_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_path = Some(input.into());
            self
        }
        /// <p>The path of the test report file.</p>
        pub fn set_file_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_path = input;
            self
        }
        /// <p>The percentage of lines that are covered by your tests.</p>
        pub fn line_coverage_percentage(mut self, input: f64) -> Self {
            self.line_coverage_percentage = Some(input);
            self
        }
        /// <p>The percentage of lines that are covered by your tests.</p>
        pub fn set_line_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.line_coverage_percentage = input;
            self
        }
        /// <p>The number of lines that are covered by your tests.</p>
        pub fn lines_covered(mut self, input: i32) -> Self {
            self.lines_covered = Some(input);
            self
        }
        /// <p>The number of lines that are covered by your tests.</p>
        pub fn set_lines_covered(mut self, input: std::option::Option<i32>) -> Self {
            self.lines_covered = input;
            self
        }
        /// <p>The number of lines that are not covered by your tests.</p>
        pub fn lines_missed(mut self, input: i32) -> Self {
            self.lines_missed = Some(input);
            self
        }
        /// <p>The number of lines that are not covered by your tests.</p>
        pub fn set_lines_missed(mut self, input: std::option::Option<i32>) -> Self {
            self.lines_missed = input;
            self
        }
        /// <p>The percentage of branches that are covered by your tests.</p>
        pub fn branch_coverage_percentage(mut self, input: f64) -> Self {
            self.branch_coverage_percentage = Some(input);
            self
        }
        /// <p>The percentage of branches that are covered by your tests.</p>
        pub fn set_branch_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.branch_coverage_percentage = input;
            self
        }
        /// <p>The number of conditional branches that are covered by your tests.</p>
        pub fn branches_covered(mut self, input: i32) -> Self {
            self.branches_covered = Some(input);
            self
        }
        /// <p>The number of conditional branches that are covered by your tests.</p>
        pub fn set_branches_covered(mut self, input: std::option::Option<i32>) -> Self {
            self.branches_covered = input;
            self
        }
        /// <p>The number of conditional branches that are not covered by your tests.</p>
        pub fn branches_missed(mut self, input: i32) -> Self {
            self.branches_missed = Some(input);
            self
        }
        /// <p>The number of conditional branches that are not covered by your tests.</p>
        pub fn set_branches_missed(mut self, input: std::option::Option<i32>) -> Self {
            self.branches_missed = input;
            self
        }
        /// <p>The date and time that the tests were run.</p>
        pub fn expired(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expired = Some(input);
            self
        }
        /// <p>The date and time that the tests were run.</p>
        pub fn set_expired(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expired = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeCoverage`](crate::model::CodeCoverage)
        pub fn build(self) -> crate::model::CodeCoverage {
            crate::model::CodeCoverage {
                id: self.id,
                report_arn: self.report_arn,
                file_path: self.file_path,
                line_coverage_percentage: self.line_coverage_percentage,
                lines_covered: self.lines_covered,
                lines_missed: self.lines_missed,
                branch_coverage_percentage: self.branch_coverage_percentage,
                branches_covered: self.branches_covered,
                branches_missed: self.branches_missed,
                expired: self.expired,
            }
        }
    }
}
impl CodeCoverage {
    /// Creates a new builder-style object to manufacture [`CodeCoverage`](crate::model::CodeCoverage)
    pub fn builder() -> crate::model::code_coverage::Builder {
        crate::model::code_coverage::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReportCodeCoverageSortByType {
    #[allow(missing_docs)] // documentation missing in model
    FilePath,
    #[allow(missing_docs)] // documentation missing in model
    LineCoveragePercentage,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReportCodeCoverageSortByType {
    fn from(s: &str) -> Self {
        match s {
            "FILE_PATH" => ReportCodeCoverageSortByType::FilePath,
            "LINE_COVERAGE_PERCENTAGE" => ReportCodeCoverageSortByType::LineCoveragePercentage,
            other => ReportCodeCoverageSortByType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReportCodeCoverageSortByType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReportCodeCoverageSortByType::from(s))
    }
}
impl ReportCodeCoverageSortByType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReportCodeCoverageSortByType::FilePath => "FILE_PATH",
            ReportCodeCoverageSortByType::LineCoveragePercentage => "LINE_COVERAGE_PERCENTAGE",
            ReportCodeCoverageSortByType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FILE_PATH", "LINE_COVERAGE_PERCENTAGE"]
    }
}
impl AsRef<str> for ReportCodeCoverageSortByType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about a build that could not be successfully deleted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BuildNotDeleted {
    /// <p>The ID of the build that could not be successfully deleted.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Additional information about the build that could not be successfully deleted.</p>
    pub status_code: std::option::Option<std::string::String>,
}
impl BuildNotDeleted {
    /// <p>The ID of the build that could not be successfully deleted.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Additional information about the build that could not be successfully deleted.</p>
    pub fn status_code(&self) -> std::option::Option<&str> {
        self.status_code.as_deref()
    }
}
impl std::fmt::Debug for BuildNotDeleted {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BuildNotDeleted");
        formatter.field("id", &self.id);
        formatter.field("status_code", &self.status_code);
        formatter.finish()
    }
}
/// See [`BuildNotDeleted`](crate::model::BuildNotDeleted)
pub mod build_not_deleted {
    /// A builder for [`BuildNotDeleted`](crate::model::BuildNotDeleted)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the build that could not be successfully deleted.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the build that could not be successfully deleted.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Additional information about the build that could not be successfully deleted.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>Additional information about the build that could not be successfully deleted.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Consumes the builder and constructs a [`BuildNotDeleted`](crate::model::BuildNotDeleted)
        pub fn build(self) -> crate::model::BuildNotDeleted {
            crate::model::BuildNotDeleted {
                id: self.id,
                status_code: self.status_code,
            }
        }
    }
}
impl BuildNotDeleted {
    /// Creates a new builder-style object to manufacture [`BuildNotDeleted`](crate::model::BuildNotDeleted)
    pub fn builder() -> crate::model::build_not_deleted::Builder {
        crate::model::build_not_deleted::Builder::default()
    }
}

/// <p>Information about the results from running a series of test cases during the run of a
/// build project. The test cases are specified in the buildspec for the build project using
/// one or more paths to the test case files. You can specify any type of tests you want,
/// such as unit tests, integration tests, and functional tests. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Report {
    /// <p> The ARN of the report run. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The type of the report that was run.</p>
    /// <dl>
    /// <dt>CODE_COVERAGE</dt>
    /// <dd>
    /// <p>A code coverage report.</p>
    /// </dd>
    /// <dt>TEST</dt>
    /// <dd>
    /// <p>A test report.</p>
    /// </dd>
    /// </dl>
    pub r#type: std::option::Option<crate::model::ReportType>,
    /// <p> The name of the report that was run. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The ARN of the report group associated with this report. </p>
    pub report_group_arn: std::option::Option<std::string::String>,
    /// <p> The ARN of the build run that generated this report. </p>
    pub execution_id: std::option::Option<std::string::String>,
    /// <p> The status of this report. </p>
    pub status: std::option::Option<crate::model::ReportStatusType>,
    /// <p> The date and time this report run occurred. </p>
    pub created: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The date and time a report expires. A report expires 30 days after it is created. An
    /// expired report is not available to view in CodeBuild. </p>
    pub expired: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Information about where the raw data used to generate this report was exported.
    /// </p>
    pub export_config: std::option::Option<crate::model::ReportExportConfig>,
    /// <p> A boolean that specifies if this report run is truncated. The list of test cases is
    /// truncated after the maximum number of test cases is reached. </p>
    pub truncated: std::option::Option<bool>,
    /// <p> A <code>TestReportSummary</code> object that contains information about this test
    /// report. </p>
    pub test_summary: std::option::Option<crate::model::TestReportSummary>,
    /// <p>A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for
    /// this report.</p>
    pub code_coverage_summary: std::option::Option<crate::model::CodeCoverageReportSummary>,
}
impl Report {
    /// <p> The ARN of the report run. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The type of the report that was run.</p>
    /// <dl>
    /// <dt>CODE_COVERAGE</dt>
    /// <dd>
    /// <p>A code coverage report.</p>
    /// </dd>
    /// <dt>TEST</dt>
    /// <dd>
    /// <p>A test report.</p>
    /// </dd>
    /// </dl>
    pub fn r#type(&self) -> std::option::Option<&crate::model::ReportType> {
        self.r#type.as_ref()
    }
    /// <p> The name of the report that was run. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The ARN of the report group associated with this report. </p>
    pub fn report_group_arn(&self) -> std::option::Option<&str> {
        self.report_group_arn.as_deref()
    }
    /// <p> The ARN of the build run that generated this report. </p>
    pub fn execution_id(&self) -> std::option::Option<&str> {
        self.execution_id.as_deref()
    }
    /// <p> The status of this report. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReportStatusType> {
        self.status.as_ref()
    }
    /// <p> The date and time this report run occurred. </p>
    pub fn created(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created.as_ref()
    }
    /// <p> The date and time a report expires. A report expires 30 days after it is created. An
    /// expired report is not available to view in CodeBuild. </p>
    pub fn expired(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expired.as_ref()
    }
    /// <p> Information about where the raw data used to generate this report was exported.
    /// </p>
    pub fn export_config(&self) -> std::option::Option<&crate::model::ReportExportConfig> {
        self.export_config.as_ref()
    }
    /// <p> A boolean that specifies if this report run is truncated. The list of test cases is
    /// truncated after the maximum number of test cases is reached. </p>
    pub fn truncated(&self) -> std::option::Option<bool> {
        self.truncated
    }
    /// <p> A <code>TestReportSummary</code> object that contains information about this test
    /// report. </p>
    pub fn test_summary(&self) -> std::option::Option<&crate::model::TestReportSummary> {
        self.test_summary.as_ref()
    }
    /// <p>A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for
    /// this report.</p>
    pub fn code_coverage_summary(
        &self,
    ) -> std::option::Option<&crate::model::CodeCoverageReportSummary> {
        self.code_coverage_summary.as_ref()
    }
}
impl std::fmt::Debug for Report {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Report");
        formatter.field("arn", &self.arn);
        formatter.field("r#type", &self.r#type);
        formatter.field("name", &self.name);
        formatter.field("report_group_arn", &self.report_group_arn);
        formatter.field("execution_id", &self.execution_id);
        formatter.field("status", &self.status);
        formatter.field("created", &self.created);
        formatter.field("expired", &self.expired);
        formatter.field("export_config", &self.export_config);
        formatter.field("truncated", &self.truncated);
        formatter.field("test_summary", &self.test_summary);
        formatter.field("code_coverage_summary", &self.code_coverage_summary);
        formatter.finish()
    }
}
/// See [`Report`](crate::model::Report)
pub mod report {
    /// A builder for [`Report`](crate::model::Report)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ReportType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) report_group_arn: std::option::Option<std::string::String>,
        pub(crate) execution_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ReportStatusType>,
        pub(crate) created: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expired: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) export_config: std::option::Option<crate::model::ReportExportConfig>,
        pub(crate) truncated: std::option::Option<bool>,
        pub(crate) test_summary: std::option::Option<crate::model::TestReportSummary>,
        pub(crate) code_coverage_summary:
            std::option::Option<crate::model::CodeCoverageReportSummary>,
    }
    impl Builder {
        /// <p> The ARN of the report run. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the report run. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The type of the report that was run.</p>
        /// <dl>
        /// <dt>CODE_COVERAGE</dt>
        /// <dd>
        /// <p>A code coverage report.</p>
        /// </dd>
        /// <dt>TEST</dt>
        /// <dd>
        /// <p>A test report.</p>
        /// </dd>
        /// </dl>
        pub fn r#type(mut self, input: crate::model::ReportType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the report that was run.</p>
        /// <dl>
        /// <dt>CODE_COVERAGE</dt>
        /// <dd>
        /// <p>A code coverage report.</p>
        /// </dd>
        /// <dt>TEST</dt>
        /// <dd>
        /// <p>A test report.</p>
        /// </dd>
        /// </dl>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ReportType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p> The name of the report that was run. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p> The name of the report that was run. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The ARN of the report group associated with this report. </p>
        pub fn report_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_group_arn = Some(input.into());
            self
        }
        /// <p> The ARN of the report group associated with this report. </p>
        pub fn set_report_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_group_arn = input;
            self
        }
        /// <p> The ARN of the build run that generated this report. </p>
        pub fn execution_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.execution_id = Some(input.into());
            self
        }
        /// <p> The ARN of the build run that generated this report. </p>
        pub fn set_execution_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.execution_id = input;
            self
        }
        /// <p> The status of this report. </p>
        pub fn status(mut self, input: crate::model::ReportStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The status of this report. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReportStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p> The date and time this report run occurred. </p>
        pub fn created(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created = Some(input);
            self
        }
        /// <p> The date and time this report run occurred. </p>
        pub fn set_created(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created = input;
            self
        }
        /// <p> The date and time a report expires. A report expires 30 days after it is created. An
        /// expired report is not available to view in CodeBuild. </p>
        pub fn expired(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expired = Some(input);
            self
        }
        /// <p> The date and time a report expires. A report expires 30 days after it is created. An
        /// expired report is not available to view in CodeBuild. </p>
        pub fn set_expired(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expired = input;
            self
        }
        /// <p> Information about where the raw data used to generate this report was exported.
        /// </p>
        pub fn export_config(mut self, input: crate::model::ReportExportConfig) -> Self {
            self.export_config = Some(input);
            self
        }
        /// <p> Information about where the raw data used to generate this report was exported.
        /// </p>
        pub fn set_export_config(
            mut self,
            input: std::option::Option<crate::model::ReportExportConfig>,
        ) -> Self {
            self.export_config = input;
            self
        }
        /// <p> A boolean that specifies if this report run is truncated. The list of test cases is
        /// truncated after the maximum number of test cases is reached. </p>
        pub fn truncated(mut self, input: bool) -> Self {
            self.truncated = Some(input);
            self
        }
        /// <p> A boolean that specifies if this report run is truncated. The list of test cases is
        /// truncated after the maximum number of test cases is reached. </p>
        pub fn set_truncated(mut self, input: std::option::Option<bool>) -> Self {
            self.truncated = input;
            self
        }
        /// <p> A <code>TestReportSummary</code> object that contains information about this test
        /// report. </p>
        pub fn test_summary(mut self, input: crate::model::TestReportSummary) -> Self {
            self.test_summary = Some(input);
            self
        }
        /// <p> A <code>TestReportSummary</code> object that contains information about this test
        /// report. </p>
        pub fn set_test_summary(
            mut self,
            input: std::option::Option<crate::model::TestReportSummary>,
        ) -> Self {
            self.test_summary = input;
            self
        }
        /// <p>A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for
        /// this report.</p>
        pub fn code_coverage_summary(
            mut self,
            input: crate::model::CodeCoverageReportSummary,
        ) -> Self {
            self.code_coverage_summary = Some(input);
            self
        }
        /// <p>A <code>CodeCoverageReportSummary</code> object that contains a code coverage summary for
        /// this report.</p>
        pub fn set_code_coverage_summary(
            mut self,
            input: std::option::Option<crate::model::CodeCoverageReportSummary>,
        ) -> Self {
            self.code_coverage_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`Report`](crate::model::Report)
        pub fn build(self) -> crate::model::Report {
            crate::model::Report {
                arn: self.arn,
                r#type: self.r#type,
                name: self.name,
                report_group_arn: self.report_group_arn,
                execution_id: self.execution_id,
                status: self.status,
                created: self.created,
                expired: self.expired,
                export_config: self.export_config,
                truncated: self.truncated,
                test_summary: self.test_summary,
                code_coverage_summary: self.code_coverage_summary,
            }
        }
    }
}
impl Report {
    /// Creates a new builder-style object to manufacture [`Report`](crate::model::Report)
    pub fn builder() -> crate::model::report::Builder {
        crate::model::report::Builder::default()
    }
}

/// <p>Contains a summary of a code coverage report.</p>
/// <p>Line coverage measures how many statements your tests cover. A statement is a single
/// instruction, not including comments, conditionals, etc.</p>
/// <p>Branch coverage determines if your tests cover every possible branch of a control
/// structure, such as an <code>if</code> or <code>case</code> statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CodeCoverageReportSummary {
    /// <p>The percentage of lines that are covered by your tests.</p>
    pub line_coverage_percentage: std::option::Option<f64>,
    /// <p>The number of lines that are covered by your tests.</p>
    pub lines_covered: std::option::Option<i32>,
    /// <p>The number of lines that are not covered by your tests.</p>
    pub lines_missed: std::option::Option<i32>,
    /// <p>The percentage of branches that are covered by your tests.</p>
    pub branch_coverage_percentage: std::option::Option<f64>,
    /// <p>The number of conditional branches that are covered by your tests.</p>
    pub branches_covered: std::option::Option<i32>,
    /// <p>The number of conditional branches that are not covered by your tests.</p>
    pub branches_missed: std::option::Option<i32>,
}
impl CodeCoverageReportSummary {
    /// <p>The percentage of lines that are covered by your tests.</p>
    pub fn line_coverage_percentage(&self) -> std::option::Option<f64> {
        self.line_coverage_percentage
    }
    /// <p>The number of lines that are covered by your tests.</p>
    pub fn lines_covered(&self) -> std::option::Option<i32> {
        self.lines_covered
    }
    /// <p>The number of lines that are not covered by your tests.</p>
    pub fn lines_missed(&self) -> std::option::Option<i32> {
        self.lines_missed
    }
    /// <p>The percentage of branches that are covered by your tests.</p>
    pub fn branch_coverage_percentage(&self) -> std::option::Option<f64> {
        self.branch_coverage_percentage
    }
    /// <p>The number of conditional branches that are covered by your tests.</p>
    pub fn branches_covered(&self) -> std::option::Option<i32> {
        self.branches_covered
    }
    /// <p>The number of conditional branches that are not covered by your tests.</p>
    pub fn branches_missed(&self) -> std::option::Option<i32> {
        self.branches_missed
    }
}
impl std::fmt::Debug for CodeCoverageReportSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CodeCoverageReportSummary");
        formatter.field("line_coverage_percentage", &self.line_coverage_percentage);
        formatter.field("lines_covered", &self.lines_covered);
        formatter.field("lines_missed", &self.lines_missed);
        formatter.field(
            "branch_coverage_percentage",
            &self.branch_coverage_percentage,
        );
        formatter.field("branches_covered", &self.branches_covered);
        formatter.field("branches_missed", &self.branches_missed);
        formatter.finish()
    }
}
/// See [`CodeCoverageReportSummary`](crate::model::CodeCoverageReportSummary)
pub mod code_coverage_report_summary {
    /// A builder for [`CodeCoverageReportSummary`](crate::model::CodeCoverageReportSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) line_coverage_percentage: std::option::Option<f64>,
        pub(crate) lines_covered: std::option::Option<i32>,
        pub(crate) lines_missed: std::option::Option<i32>,
        pub(crate) branch_coverage_percentage: std::option::Option<f64>,
        pub(crate) branches_covered: std::option::Option<i32>,
        pub(crate) branches_missed: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The percentage of lines that are covered by your tests.</p>
        pub fn line_coverage_percentage(mut self, input: f64) -> Self {
            self.line_coverage_percentage = Some(input);
            self
        }
        /// <p>The percentage of lines that are covered by your tests.</p>
        pub fn set_line_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.line_coverage_percentage = input;
            self
        }
        /// <p>The number of lines that are covered by your tests.</p>
        pub fn lines_covered(mut self, input: i32) -> Self {
            self.lines_covered = Some(input);
            self
        }
        /// <p>The number of lines that are covered by your tests.</p>
        pub fn set_lines_covered(mut self, input: std::option::Option<i32>) -> Self {
            self.lines_covered = input;
            self
        }
        /// <p>The number of lines that are not covered by your tests.</p>
        pub fn lines_missed(mut self, input: i32) -> Self {
            self.lines_missed = Some(input);
            self
        }
        /// <p>The number of lines that are not covered by your tests.</p>
        pub fn set_lines_missed(mut self, input: std::option::Option<i32>) -> Self {
            self.lines_missed = input;
            self
        }
        /// <p>The percentage of branches that are covered by your tests.</p>
        pub fn branch_coverage_percentage(mut self, input: f64) -> Self {
            self.branch_coverage_percentage = Some(input);
            self
        }
        /// <p>The percentage of branches that are covered by your tests.</p>
        pub fn set_branch_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.branch_coverage_percentage = input;
            self
        }
        /// <p>The number of conditional branches that are covered by your tests.</p>
        pub fn branches_covered(mut self, input: i32) -> Self {
            self.branches_covered = Some(input);
            self
        }
        /// <p>The number of conditional branches that are covered by your tests.</p>
        pub fn set_branches_covered(mut self, input: std::option::Option<i32>) -> Self {
            self.branches_covered = input;
            self
        }
        /// <p>The number of conditional branches that are not covered by your tests.</p>
        pub fn branches_missed(mut self, input: i32) -> Self {
            self.branches_missed = Some(input);
            self
        }
        /// <p>The number of conditional branches that are not covered by your tests.</p>
        pub fn set_branches_missed(mut self, input: std::option::Option<i32>) -> Self {
            self.branches_missed = input;
            self
        }
        /// Consumes the builder and constructs a [`CodeCoverageReportSummary`](crate::model::CodeCoverageReportSummary)
        pub fn build(self) -> crate::model::CodeCoverageReportSummary {
            crate::model::CodeCoverageReportSummary {
                line_coverage_percentage: self.line_coverage_percentage,
                lines_covered: self.lines_covered,
                lines_missed: self.lines_missed,
                branch_coverage_percentage: self.branch_coverage_percentage,
                branches_covered: self.branches_covered,
                branches_missed: self.branches_missed,
            }
        }
    }
}
impl CodeCoverageReportSummary {
    /// Creates a new builder-style object to manufacture [`CodeCoverageReportSummary`](crate::model::CodeCoverageReportSummary)
    pub fn builder() -> crate::model::code_coverage_report_summary::Builder {
        crate::model::code_coverage_report_summary::Builder::default()
    }
}

/// <p> Information about a test report. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestReportSummary {
    /// <p> The number of test cases in this <code>TestReportSummary</code>. The total includes
    /// truncated test cases. </p>
    pub total: std::option::Option<i32>,
    /// <p> A map that contains the number of each type of status returned by the test results in
    /// this <code>TestReportSummary</code>. </p>
    pub status_counts: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
    /// <p> The number of nanoseconds it took to run all of the test cases in this report.
    /// </p>
    pub duration_in_nano_seconds: std::option::Option<i64>,
}
impl TestReportSummary {
    /// <p> The number of test cases in this <code>TestReportSummary</code>. The total includes
    /// truncated test cases. </p>
    pub fn total(&self) -> std::option::Option<i32> {
        self.total
    }
    /// <p> A map that contains the number of each type of status returned by the test results in
    /// this <code>TestReportSummary</code>. </p>
    pub fn status_counts(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, i32>> {
        self.status_counts.as_ref()
    }
    /// <p> The number of nanoseconds it took to run all of the test cases in this report.
    /// </p>
    pub fn duration_in_nano_seconds(&self) -> std::option::Option<i64> {
        self.duration_in_nano_seconds
    }
}
impl std::fmt::Debug for TestReportSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestReportSummary");
        formatter.field("total", &self.total);
        formatter.field("status_counts", &self.status_counts);
        formatter.field("duration_in_nano_seconds", &self.duration_in_nano_seconds);
        formatter.finish()
    }
}
/// See [`TestReportSummary`](crate::model::TestReportSummary)
pub mod test_report_summary {
    /// A builder for [`TestReportSummary`](crate::model::TestReportSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total: std::option::Option<i32>,
        pub(crate) status_counts:
            std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        pub(crate) duration_in_nano_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p> The number of test cases in this <code>TestReportSummary</code>. The total includes
        /// truncated test cases. </p>
        pub fn total(mut self, input: i32) -> Self {
            self.total = Some(input);
            self
        }
        /// <p> The number of test cases in this <code>TestReportSummary</code>. The total includes
        /// truncated test cases. </p>
        pub fn set_total(mut self, input: std::option::Option<i32>) -> Self {
            self.total = input;
            self
        }
        /// Adds a key-value pair to `status_counts`.
        ///
        /// To override the contents of this collection use [`set_status_counts`](Self::set_status_counts).
        ///
        /// <p> A map that contains the number of each type of status returned by the test results in
        /// this <code>TestReportSummary</code>. </p>
        pub fn status_counts(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<i32>,
        ) -> Self {
            let mut hash_map = self.status_counts.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.status_counts = Some(hash_map);
            self
        }
        /// <p> A map that contains the number of each type of status returned by the test results in
        /// this <code>TestReportSummary</code>. </p>
        pub fn set_status_counts(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, i32>>,
        ) -> Self {
            self.status_counts = input;
            self
        }
        /// <p> The number of nanoseconds it took to run all of the test cases in this report.
        /// </p>
        pub fn duration_in_nano_seconds(mut self, input: i64) -> Self {
            self.duration_in_nano_seconds = Some(input);
            self
        }
        /// <p> The number of nanoseconds it took to run all of the test cases in this report.
        /// </p>
        pub fn set_duration_in_nano_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_in_nano_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`TestReportSummary`](crate::model::TestReportSummary)
        pub fn build(self) -> crate::model::TestReportSummary {
            crate::model::TestReportSummary {
                total: self.total,
                status_counts: self.status_counts,
                duration_in_nano_seconds: self.duration_in_nano_seconds,
            }
        }
    }
}
impl TestReportSummary {
    /// Creates a new builder-style object to manufacture [`TestReportSummary`](crate::model::TestReportSummary)
    pub fn builder() -> crate::model::test_report_summary::Builder {
        crate::model::test_report_summary::Builder::default()
    }
}
