// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateWebhookOutput {
    /// <p> Information about a repository's webhook that is associated with a project in CodeBuild.
    /// </p>
    pub webhook: std::option::Option<crate::model::Webhook>,
}
impl std::fmt::Debug for UpdateWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateWebhookOutput");
        formatter.field("webhook", &self.webhook);
        formatter.finish()
    }
}
/// See [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
pub mod update_webhook_output {
    /// A builder for [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::Webhook>,
    }
    impl Builder {
        /// <p> Information about a repository's webhook that is associated with a project in CodeBuild.
        /// </p>
        pub fn webhook(mut self, input: crate::model::Webhook) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p> Information about a repository's webhook that is associated with a project in CodeBuild.
        /// </p>
        pub fn set_webhook(mut self, input: std::option::Option<crate::model::Webhook>) -> Self {
            self.webhook = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
        pub fn build(self) -> crate::output::UpdateWebhookOutput {
            crate::output::UpdateWebhookOutput {
                webhook: self.webhook,
            }
        }
    }
}
impl UpdateWebhookOutput {
    /// Creates a new builder-style object to manufacture [`UpdateWebhookOutput`](crate::output::UpdateWebhookOutput)
    pub fn builder() -> crate::output::update_webhook_output::Builder {
        crate::output::update_webhook_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateReportGroupOutput {
    /// <p>
    /// Information about the updated report group.
    /// </p>
    pub report_group: std::option::Option<crate::model::ReportGroup>,
}
impl std::fmt::Debug for UpdateReportGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateReportGroupOutput");
        formatter.field("report_group", &self.report_group);
        formatter.finish()
    }
}
/// See [`UpdateReportGroupOutput`](crate::output::UpdateReportGroupOutput)
pub mod update_report_group_output {
    /// A builder for [`UpdateReportGroupOutput`](crate::output::UpdateReportGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_group: std::option::Option<crate::model::ReportGroup>,
    }
    impl Builder {
        /// <p>
        /// Information about the updated report group.
        /// </p>
        pub fn report_group(mut self, input: crate::model::ReportGroup) -> Self {
            self.report_group = Some(input);
            self
        }
        /// <p>
        /// Information about the updated report group.
        /// </p>
        pub fn set_report_group(
            mut self,
            input: std::option::Option<crate::model::ReportGroup>,
        ) -> Self {
            self.report_group = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateReportGroupOutput`](crate::output::UpdateReportGroupOutput)
        pub fn build(self) -> crate::output::UpdateReportGroupOutput {
            crate::output::UpdateReportGroupOutput {
                report_group: self.report_group,
            }
        }
    }
}
impl UpdateReportGroupOutput {
    /// Creates a new builder-style object to manufacture [`UpdateReportGroupOutput`](crate::output::UpdateReportGroupOutput)
    pub fn builder() -> crate::output::update_report_group_output::Builder {
        crate::output::update_report_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectVisibilityOutput {
    /// <p>The Amazon Resource Name (ARN) of the build project.</p>
    pub project_arn: std::option::Option<std::string::String>,
    /// <p>Contains the project identifier used with the public build APIs. </p>
    pub public_project_alias: std::option::Option<std::string::String>,
    /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
    ///
    /// <dl>
    /// <dt>PUBLIC_READ</dt>
    /// <dd>
    /// <p>The project builds are visible to the public.</p>
    /// </dd>
    /// <dt>PRIVATE</dt>
    /// <dd>
    /// <p>The project builds are not visible to the public.</p>
    /// </dd>
    /// </dl>
    pub project_visibility: std::option::Option<crate::model::ProjectVisibilityType>,
}
impl std::fmt::Debug for UpdateProjectVisibilityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectVisibilityOutput");
        formatter.field("project_arn", &self.project_arn);
        formatter.field("public_project_alias", &self.public_project_alias);
        formatter.field("project_visibility", &self.project_visibility);
        formatter.finish()
    }
}
/// See [`UpdateProjectVisibilityOutput`](crate::output::UpdateProjectVisibilityOutput)
pub mod update_project_visibility_output {
    /// A builder for [`UpdateProjectVisibilityOutput`](crate::output::UpdateProjectVisibilityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
        pub(crate) public_project_alias: std::option::Option<std::string::String>,
        pub(crate) project_visibility: std::option::Option<crate::model::ProjectVisibilityType>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// <p>Contains the project identifier used with the public build APIs. </p>
        pub fn public_project_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_project_alias = Some(input.into());
            self
        }
        /// <p>Contains the project identifier used with the public build APIs. </p>
        pub fn set_public_project_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_project_alias = input;
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        ///
        /// <dl>
        /// <dt>PUBLIC_READ</dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>PRIVATE</dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn project_visibility(mut self, input: crate::model::ProjectVisibilityType) -> Self {
            self.project_visibility = Some(input);
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        ///
        /// <dl>
        /// <dt>PUBLIC_READ</dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>PRIVATE</dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn set_project_visibility(
            mut self,
            input: std::option::Option<crate::model::ProjectVisibilityType>,
        ) -> Self {
            self.project_visibility = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectVisibilityOutput`](crate::output::UpdateProjectVisibilityOutput)
        pub fn build(self) -> crate::output::UpdateProjectVisibilityOutput {
            crate::output::UpdateProjectVisibilityOutput {
                project_arn: self.project_arn,
                public_project_alias: self.public_project_alias,
                project_visibility: self.project_visibility,
            }
        }
    }
}
impl UpdateProjectVisibilityOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectVisibilityOutput`](crate::output::UpdateProjectVisibilityOutput)
    pub fn builder() -> crate::output::update_project_visibility_output::Builder {
        crate::output::update_project_visibility_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProjectOutput {
    /// <p>Information about the build project that was changed.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl std::fmt::Debug for UpdateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
pub mod update_project_output {
    /// A builder for [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>Information about the build project that was changed.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>Information about the build project that was changed.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
        pub fn build(self) -> crate::output::UpdateProjectOutput {
            crate::output::UpdateProjectOutput {
                project: self.project,
            }
        }
    }
}
impl UpdateProjectOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProjectOutput`](crate::output::UpdateProjectOutput)
    pub fn builder() -> crate::output::update_project_output::Builder {
        crate::output::update_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopBuildBatchOutput {
    /// <p>Contains information about a batch build.</p>
    pub build_batch: std::option::Option<crate::model::BuildBatch>,
}
impl std::fmt::Debug for StopBuildBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopBuildBatchOutput");
        formatter.field("build_batch", &self.build_batch);
        formatter.finish()
    }
}
/// See [`StopBuildBatchOutput`](crate::output::StopBuildBatchOutput)
pub mod stop_build_batch_output {
    /// A builder for [`StopBuildBatchOutput`](crate::output::StopBuildBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_batch: std::option::Option<crate::model::BuildBatch>,
    }
    impl Builder {
        /// <p>Contains information about a batch build.</p>
        pub fn build_batch(mut self, input: crate::model::BuildBatch) -> Self {
            self.build_batch = Some(input);
            self
        }
        /// <p>Contains information about a batch build.</p>
        pub fn set_build_batch(
            mut self,
            input: std::option::Option<crate::model::BuildBatch>,
        ) -> Self {
            self.build_batch = input;
            self
        }
        /// Consumes the builder and constructs a [`StopBuildBatchOutput`](crate::output::StopBuildBatchOutput)
        pub fn build(self) -> crate::output::StopBuildBatchOutput {
            crate::output::StopBuildBatchOutput {
                build_batch: self.build_batch,
            }
        }
    }
}
impl StopBuildBatchOutput {
    /// Creates a new builder-style object to manufacture [`StopBuildBatchOutput`](crate::output::StopBuildBatchOutput)
    pub fn builder() -> crate::output::stop_build_batch_output::Builder {
        crate::output::stop_build_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopBuildOutput {
    /// <p>Information about the build.</p>
    pub build_value: std::option::Option<crate::model::Build>,
}
impl std::fmt::Debug for StopBuildOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopBuildOutput");
        formatter.field("build_value", &self.build_value);
        formatter.finish()
    }
}
/// See [`StopBuildOutput`](crate::output::StopBuildOutput)
pub mod stop_build_output {
    /// A builder for [`StopBuildOutput`](crate::output::StopBuildOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_value: std::option::Option<crate::model::Build>,
    }
    impl Builder {
        /// <p>Information about the build.</p>
        pub fn build_value(mut self, input: crate::model::Build) -> Self {
            self.build_value = Some(input);
            self
        }
        /// <p>Information about the build.</p>
        pub fn set_build(mut self, input: std::option::Option<crate::model::Build>) -> Self {
            self.build_value = input;
            self
        }
        /// Consumes the builder and constructs a [`StopBuildOutput`](crate::output::StopBuildOutput)
        pub fn build(self) -> crate::output::StopBuildOutput {
            crate::output::StopBuildOutput {
                build_value: self.build_value,
            }
        }
    }
}
impl StopBuildOutput {
    /// Creates a new builder-style object to manufacture [`StopBuildOutput`](crate::output::StopBuildOutput)
    pub fn builder() -> crate::output::stop_build_output::Builder {
        crate::output::stop_build_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBuildBatchOutput {
    /// <p>A <code>BuildBatch</code> object that contains information about the batch build.</p>
    pub build_batch: std::option::Option<crate::model::BuildBatch>,
}
impl std::fmt::Debug for StartBuildBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBuildBatchOutput");
        formatter.field("build_batch", &self.build_batch);
        formatter.finish()
    }
}
/// See [`StartBuildBatchOutput`](crate::output::StartBuildBatchOutput)
pub mod start_build_batch_output {
    /// A builder for [`StartBuildBatchOutput`](crate::output::StartBuildBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_batch: std::option::Option<crate::model::BuildBatch>,
    }
    impl Builder {
        /// <p>A <code>BuildBatch</code> object that contains information about the batch build.</p>
        pub fn build_batch(mut self, input: crate::model::BuildBatch) -> Self {
            self.build_batch = Some(input);
            self
        }
        /// <p>A <code>BuildBatch</code> object that contains information about the batch build.</p>
        pub fn set_build_batch(
            mut self,
            input: std::option::Option<crate::model::BuildBatch>,
        ) -> Self {
            self.build_batch = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBuildBatchOutput`](crate::output::StartBuildBatchOutput)
        pub fn build(self) -> crate::output::StartBuildBatchOutput {
            crate::output::StartBuildBatchOutput {
                build_batch: self.build_batch,
            }
        }
    }
}
impl StartBuildBatchOutput {
    /// Creates a new builder-style object to manufacture [`StartBuildBatchOutput`](crate::output::StartBuildBatchOutput)
    pub fn builder() -> crate::output::start_build_batch_output::Builder {
        crate::output::start_build_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartBuildOutput {
    /// <p>Information about the build to be run.</p>
    pub build_value: std::option::Option<crate::model::Build>,
}
impl std::fmt::Debug for StartBuildOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartBuildOutput");
        formatter.field("build_value", &self.build_value);
        formatter.finish()
    }
}
/// See [`StartBuildOutput`](crate::output::StartBuildOutput)
pub mod start_build_output {
    /// A builder for [`StartBuildOutput`](crate::output::StartBuildOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_value: std::option::Option<crate::model::Build>,
    }
    impl Builder {
        /// <p>Information about the build to be run.</p>
        pub fn build_value(mut self, input: crate::model::Build) -> Self {
            self.build_value = Some(input);
            self
        }
        /// <p>Information about the build to be run.</p>
        pub fn set_build(mut self, input: std::option::Option<crate::model::Build>) -> Self {
            self.build_value = input;
            self
        }
        /// Consumes the builder and constructs a [`StartBuildOutput`](crate::output::StartBuildOutput)
        pub fn build(self) -> crate::output::StartBuildOutput {
            crate::output::StartBuildOutput {
                build_value: self.build_value,
            }
        }
    }
}
impl StartBuildOutput {
    /// Creates a new builder-style object to manufacture [`StartBuildOutput`](crate::output::StartBuildOutput)
    pub fn builder() -> crate::output::start_build_output::Builder {
        crate::output::start_build_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryBuildBatchOutput {
    /// <p>Contains information about a batch build.</p>
    pub build_batch: std::option::Option<crate::model::BuildBatch>,
}
impl std::fmt::Debug for RetryBuildBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryBuildBatchOutput");
        formatter.field("build_batch", &self.build_batch);
        formatter.finish()
    }
}
/// See [`RetryBuildBatchOutput`](crate::output::RetryBuildBatchOutput)
pub mod retry_build_batch_output {
    /// A builder for [`RetryBuildBatchOutput`](crate::output::RetryBuildBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_batch: std::option::Option<crate::model::BuildBatch>,
    }
    impl Builder {
        /// <p>Contains information about a batch build.</p>
        pub fn build_batch(mut self, input: crate::model::BuildBatch) -> Self {
            self.build_batch = Some(input);
            self
        }
        /// <p>Contains information about a batch build.</p>
        pub fn set_build_batch(
            mut self,
            input: std::option::Option<crate::model::BuildBatch>,
        ) -> Self {
            self.build_batch = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryBuildBatchOutput`](crate::output::RetryBuildBatchOutput)
        pub fn build(self) -> crate::output::RetryBuildBatchOutput {
            crate::output::RetryBuildBatchOutput {
                build_batch: self.build_batch,
            }
        }
    }
}
impl RetryBuildBatchOutput {
    /// Creates a new builder-style object to manufacture [`RetryBuildBatchOutput`](crate::output::RetryBuildBatchOutput)
    pub fn builder() -> crate::output::retry_build_batch_output::Builder {
        crate::output::retry_build_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryBuildOutput {
    /// <p>Information about a build.</p>
    pub build_value: std::option::Option<crate::model::Build>,
}
impl std::fmt::Debug for RetryBuildOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryBuildOutput");
        formatter.field("build_value", &self.build_value);
        formatter.finish()
    }
}
/// See [`RetryBuildOutput`](crate::output::RetryBuildOutput)
pub mod retry_build_output {
    /// A builder for [`RetryBuildOutput`](crate::output::RetryBuildOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_value: std::option::Option<crate::model::Build>,
    }
    impl Builder {
        /// <p>Information about a build.</p>
        pub fn build_value(mut self, input: crate::model::Build) -> Self {
            self.build_value = Some(input);
            self
        }
        /// <p>Information about a build.</p>
        pub fn set_build(mut self, input: std::option::Option<crate::model::Build>) -> Self {
            self.build_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryBuildOutput`](crate::output::RetryBuildOutput)
        pub fn build(self) -> crate::output::RetryBuildOutput {
            crate::output::RetryBuildOutput {
                build_value: self.build_value,
            }
        }
    }
}
impl RetryBuildOutput {
    /// Creates a new builder-style object to manufacture [`RetryBuildOutput`](crate::output::RetryBuildOutput)
    pub fn builder() -> crate::output::retry_build_output::Builder {
        crate::output::retry_build_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutResourcePolicyOutput {
    /// <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource that is
    /// associated with a resource policy. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutResourcePolicyOutput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
pub mod put_resource_policy_output {
    /// A builder for [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource that is
        /// associated with a resource policy. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource that is
        /// associated with a resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
        pub fn build(self) -> crate::output::PutResourcePolicyOutput {
            crate::output::PutResourcePolicyOutput {
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl PutResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput)
    pub fn builder() -> crate::output::put_resource_policy_output::Builder {
        crate::output::put_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSourceCredentialsOutput {
    /// <p> A list of <code>SourceCredentialsInfo</code> objects. Each
    /// <code>SourceCredentialsInfo</code> object includes the authentication type, token
    /// ARN, and type of source provider for one set of credentials. </p>
    pub source_credentials_infos:
        std::option::Option<std::vec::Vec<crate::model::SourceCredentialsInfo>>,
}
impl std::fmt::Debug for ListSourceCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSourceCredentialsOutput");
        formatter.field("source_credentials_infos", &self.source_credentials_infos);
        formatter.finish()
    }
}
/// See [`ListSourceCredentialsOutput`](crate::output::ListSourceCredentialsOutput)
pub mod list_source_credentials_output {
    /// A builder for [`ListSourceCredentialsOutput`](crate::output::ListSourceCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_credentials_infos:
            std::option::Option<std::vec::Vec<crate::model::SourceCredentialsInfo>>,
    }
    impl Builder {
        /// Appends an item to `source_credentials_infos`.
        ///
        /// To override the contents of this collection use [`set_source_credentials_infos`](Self::set_source_credentials_infos).
        ///
        /// <p> A list of <code>SourceCredentialsInfo</code> objects. Each
        /// <code>SourceCredentialsInfo</code> object includes the authentication type, token
        /// ARN, and type of source provider for one set of credentials. </p>
        pub fn source_credentials_infos(
            mut self,
            input: impl Into<crate::model::SourceCredentialsInfo>,
        ) -> Self {
            let mut v = self.source_credentials_infos.unwrap_or_default();
            v.push(input.into());
            self.source_credentials_infos = Some(v);
            self
        }
        /// <p> A list of <code>SourceCredentialsInfo</code> objects. Each
        /// <code>SourceCredentialsInfo</code> object includes the authentication type, token
        /// ARN, and type of source provider for one set of credentials. </p>
        pub fn set_source_credentials_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceCredentialsInfo>>,
        ) -> Self {
            self.source_credentials_infos = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSourceCredentialsOutput`](crate::output::ListSourceCredentialsOutput)
        pub fn build(self) -> crate::output::ListSourceCredentialsOutput {
            crate::output::ListSourceCredentialsOutput {
                source_credentials_infos: self.source_credentials_infos,
            }
        }
    }
}
impl ListSourceCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`ListSourceCredentialsOutput`](crate::output::ListSourceCredentialsOutput)
    pub fn builder() -> crate::output::list_source_credentials_output::Builder {
        crate::output::list_source_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSharedReportGroupsOutput {
    /// <p> During a previous call, the maximum number of items that can be returned is the value
    /// specified in <code>maxResults</code>. If there more items in the list, then a unique
    /// string called a <i>nextToken</i> is returned. To get the next batch of
    /// items in the list, call this operation again, adding the next token to the call. To get
    /// all of the items in the list, keep calling this operation with each subsequent next
    /// token that is returned, until no more next tokens are returned. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The list of ARNs for the report groups shared with the current Amazon Web Services account or user.
    /// </p>
    pub report_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListSharedReportGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSharedReportGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("report_groups", &self.report_groups);
        formatter.finish()
    }
}
/// See [`ListSharedReportGroupsOutput`](crate::output::ListSharedReportGroupsOutput)
pub mod list_shared_report_groups_output {
    /// A builder for [`ListSharedReportGroupsOutput`](crate::output::ListSharedReportGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) report_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `report_groups`.
        ///
        /// To override the contents of this collection use [`set_report_groups`](Self::set_report_groups).
        ///
        /// <p> The list of ARNs for the report groups shared with the current Amazon Web Services account or user.
        /// </p>
        pub fn report_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.report_groups.unwrap_or_default();
            v.push(input.into());
            self.report_groups = Some(v);
            self
        }
        /// <p> The list of ARNs for the report groups shared with the current Amazon Web Services account or user.
        /// </p>
        pub fn set_report_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.report_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSharedReportGroupsOutput`](crate::output::ListSharedReportGroupsOutput)
        pub fn build(self) -> crate::output::ListSharedReportGroupsOutput {
            crate::output::ListSharedReportGroupsOutput {
                next_token: self.next_token,
                report_groups: self.report_groups,
            }
        }
    }
}
impl ListSharedReportGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListSharedReportGroupsOutput`](crate::output::ListSharedReportGroupsOutput)
    pub fn builder() -> crate::output::list_shared_report_groups_output::Builder {
        crate::output::list_shared_report_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListSharedProjectsOutput {
    /// <p> During a previous call, the maximum number of items that can be returned is the value
    /// specified in <code>maxResults</code>. If there more items in the list, then a unique
    /// string called a <i>nextToken</i> is returned. To get the next batch of
    /// items in the list, call this operation again, adding the next token to the call. To get
    /// all of the items in the list, keep calling this operation with each subsequent next
    /// token that is returned, until no more next tokens are returned. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The list of ARNs for the build projects shared with the current Amazon Web Services account or user.
    /// </p>
    pub projects: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListSharedProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListSharedProjectsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("projects", &self.projects);
        formatter.finish()
    }
}
/// See [`ListSharedProjectsOutput`](crate::output::ListSharedProjectsOutput)
pub mod list_shared_projects_output {
    /// A builder for [`ListSharedProjectsOutput`](crate::output::ListSharedProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) projects: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p> The list of ARNs for the build projects shared with the current Amazon Web Services account or user.
        /// </p>
        pub fn projects(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input.into());
            self.projects = Some(v);
            self
        }
        /// <p> The list of ARNs for the build projects shared with the current Amazon Web Services account or user.
        /// </p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSharedProjectsOutput`](crate::output::ListSharedProjectsOutput)
        pub fn build(self) -> crate::output::ListSharedProjectsOutput {
            crate::output::ListSharedProjectsOutput {
                next_token: self.next_token,
                projects: self.projects,
            }
        }
    }
}
impl ListSharedProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListSharedProjectsOutput`](crate::output::ListSharedProjectsOutput)
    pub fn builder() -> crate::output::list_shared_projects_output::Builder {
        crate::output::list_shared_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportsForReportGroupOutput {
    /// <p>
    /// During a previous call, the maximum number of items that can be returned is the value specified in
    /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
    /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
    /// to the call. To get all of the items in the list, keep calling this operation with each
    /// subsequent next token that is returned, until no more next tokens are returned.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// The list of report ARNs.
    /// </p>
    pub reports: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListReportsForReportGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportsForReportGroupOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("reports", &self.reports);
        formatter.finish()
    }
}
/// See [`ListReportsForReportGroupOutput`](crate::output::ListReportsForReportGroupOutput)
pub mod list_reports_for_report_group_output {
    /// A builder for [`ListReportsForReportGroupOutput`](crate::output::ListReportsForReportGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reports: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reports`.
        ///
        /// To override the contents of this collection use [`set_reports`](Self::set_reports).
        ///
        /// <p>
        /// The list of report ARNs.
        /// </p>
        pub fn reports(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reports.unwrap_or_default();
            v.push(input.into());
            self.reports = Some(v);
            self
        }
        /// <p>
        /// The list of report ARNs.
        /// </p>
        pub fn set_reports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reports = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportsForReportGroupOutput`](crate::output::ListReportsForReportGroupOutput)
        pub fn build(self) -> crate::output::ListReportsForReportGroupOutput {
            crate::output::ListReportsForReportGroupOutput {
                next_token: self.next_token,
                reports: self.reports,
            }
        }
    }
}
impl ListReportsForReportGroupOutput {
    /// Creates a new builder-style object to manufacture [`ListReportsForReportGroupOutput`](crate::output::ListReportsForReportGroupOutput)
    pub fn builder() -> crate::output::list_reports_for_report_group_output::Builder {
        crate::output::list_reports_for_report_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportsOutput {
    /// <p>
    /// During a previous call, the maximum number of items that can be returned is the value specified in
    /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
    /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
    /// to the call. To get all of the items in the list, keep calling this operation with each
    /// subsequent next token that is returned, until no more next tokens are returned.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// The list of returned ARNs for the reports in the current Amazon Web Services account.
    /// </p>
    pub reports: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListReportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("reports", &self.reports);
        formatter.finish()
    }
}
/// See [`ListReportsOutput`](crate::output::ListReportsOutput)
pub mod list_reports_output {
    /// A builder for [`ListReportsOutput`](crate::output::ListReportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reports: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reports`.
        ///
        /// To override the contents of this collection use [`set_reports`](Self::set_reports).
        ///
        /// <p>
        /// The list of returned ARNs for the reports in the current Amazon Web Services account.
        /// </p>
        pub fn reports(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reports.unwrap_or_default();
            v.push(input.into());
            self.reports = Some(v);
            self
        }
        /// <p>
        /// The list of returned ARNs for the reports in the current Amazon Web Services account.
        /// </p>
        pub fn set_reports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reports = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportsOutput`](crate::output::ListReportsOutput)
        pub fn build(self) -> crate::output::ListReportsOutput {
            crate::output::ListReportsOutput {
                next_token: self.next_token,
                reports: self.reports,
            }
        }
    }
}
impl ListReportsOutput {
    /// Creates a new builder-style object to manufacture [`ListReportsOutput`](crate::output::ListReportsOutput)
    pub fn builder() -> crate::output::list_reports_output::Builder {
        crate::output::list_reports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReportGroupsOutput {
    /// <p>
    /// During a previous call, the maximum number of items that can be returned is the value specified in
    /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
    /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
    /// to the call. To get all of the items in the list, keep calling this operation with each
    /// subsequent next token that is returned, until no more next tokens are returned.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// The list of ARNs for the report groups in the current Amazon Web Services account.
    /// </p>
    pub report_groups: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListReportGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReportGroupsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("report_groups", &self.report_groups);
        formatter.finish()
    }
}
/// See [`ListReportGroupsOutput`](crate::output::ListReportGroupsOutput)
pub mod list_report_groups_output {
    /// A builder for [`ListReportGroupsOutput`](crate::output::ListReportGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) report_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `report_groups`.
        ///
        /// To override the contents of this collection use [`set_report_groups`](Self::set_report_groups).
        ///
        /// <p>
        /// The list of ARNs for the report groups in the current Amazon Web Services account.
        /// </p>
        pub fn report_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.report_groups.unwrap_or_default();
            v.push(input.into());
            self.report_groups = Some(v);
            self
        }
        /// <p>
        /// The list of ARNs for the report groups in the current Amazon Web Services account.
        /// </p>
        pub fn set_report_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.report_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReportGroupsOutput`](crate::output::ListReportGroupsOutput)
        pub fn build(self) -> crate::output::ListReportGroupsOutput {
            crate::output::ListReportGroupsOutput {
                next_token: self.next_token,
                report_groups: self.report_groups,
            }
        }
    }
}
impl ListReportGroupsOutput {
    /// Creates a new builder-style object to manufacture [`ListReportGroupsOutput`](crate::output::ListReportGroupsOutput)
    pub fn builder() -> crate::output::list_report_groups_output::Builder {
        crate::output::list_report_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
    /// along with a unique string called a <i>nextToken</i>. To get the next
    /// batch of items in the list, call this operation again, adding the next token to the
    /// call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The list of build project names, with each build project name representing a single
    /// build project.</p>
    pub projects: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("projects", &self.projects);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) projects: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
        /// along with a unique string called a <i>nextToken</i>. To get the next
        /// batch of items in the list, call this operation again, adding the next token to the
        /// call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
        /// along with a unique string called a <i>nextToken</i>. To get the next
        /// batch of items in the list, call this operation again, adding the next token to the
        /// call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p>The list of build project names, with each build project name representing a single
        /// build project.</p>
        pub fn projects(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input.into());
            self.projects = Some(v);
            self
        }
        /// <p>The list of build project names, with each build project name representing a single
        /// build project.</p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                next_token: self.next_token,
                projects: self.projects,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCuratedEnvironmentImagesOutput {
    /// <p>Information about supported platforms for Docker images that are managed by
    /// CodeBuild.</p>
    pub platforms: std::option::Option<std::vec::Vec<crate::model::EnvironmentPlatform>>,
}
impl std::fmt::Debug for ListCuratedEnvironmentImagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCuratedEnvironmentImagesOutput");
        formatter.field("platforms", &self.platforms);
        formatter.finish()
    }
}
/// See [`ListCuratedEnvironmentImagesOutput`](crate::output::ListCuratedEnvironmentImagesOutput)
pub mod list_curated_environment_images_output {
    /// A builder for [`ListCuratedEnvironmentImagesOutput`](crate::output::ListCuratedEnvironmentImagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) platforms: std::option::Option<std::vec::Vec<crate::model::EnvironmentPlatform>>,
    }
    impl Builder {
        /// Appends an item to `platforms`.
        ///
        /// To override the contents of this collection use [`set_platforms`](Self::set_platforms).
        ///
        /// <p>Information about supported platforms for Docker images that are managed by
        /// CodeBuild.</p>
        pub fn platforms(mut self, input: impl Into<crate::model::EnvironmentPlatform>) -> Self {
            let mut v = self.platforms.unwrap_or_default();
            v.push(input.into());
            self.platforms = Some(v);
            self
        }
        /// <p>Information about supported platforms for Docker images that are managed by
        /// CodeBuild.</p>
        pub fn set_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentPlatform>>,
        ) -> Self {
            self.platforms = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCuratedEnvironmentImagesOutput`](crate::output::ListCuratedEnvironmentImagesOutput)
        pub fn build(self) -> crate::output::ListCuratedEnvironmentImagesOutput {
            crate::output::ListCuratedEnvironmentImagesOutput {
                platforms: self.platforms,
            }
        }
    }
}
impl ListCuratedEnvironmentImagesOutput {
    /// Creates a new builder-style object to manufacture [`ListCuratedEnvironmentImagesOutput`](crate::output::ListCuratedEnvironmentImagesOutput)
    pub fn builder() -> crate::output::list_curated_environment_images_output::Builder {
        crate::output::list_curated_environment_images_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuildsForProjectOutput {
    /// <p>A list of build identifiers for the specified build project, with each build ID representing a
    /// single build.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
    /// along with a unique string called a <i>nextToken</i>. To get the next
    /// batch of items in the list, call this operation again, adding the next token to the
    /// call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBuildsForProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuildsForProjectOutput");
        formatter.field("ids", &self.ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBuildsForProjectOutput`](crate::output::ListBuildsForProjectOutput)
pub mod list_builds_for_project_output {
    /// A builder for [`ListBuildsForProjectOutput`](crate::output::ListBuildsForProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>A list of build identifiers for the specified build project, with each build ID representing a
        /// single build.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>A list of build identifiers for the specified build project, with each build ID representing a
        /// single build.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
        /// along with a unique string called a <i>nextToken</i>. To get the next
        /// batch of items in the list, call this operation again, adding the next token to the
        /// call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
        /// along with a unique string called a <i>nextToken</i>. To get the next
        /// batch of items in the list, call this operation again, adding the next token to the
        /// call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuildsForProjectOutput`](crate::output::ListBuildsForProjectOutput)
        pub fn build(self) -> crate::output::ListBuildsForProjectOutput {
            crate::output::ListBuildsForProjectOutput {
                ids: self.ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBuildsForProjectOutput {
    /// Creates a new builder-style object to manufacture [`ListBuildsForProjectOutput`](crate::output::ListBuildsForProjectOutput)
    pub fn builder() -> crate::output::list_builds_for_project_output::Builder {
        crate::output::list_builds_for_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuildsOutput {
    /// <p>A list of build IDs, with each build ID representing a single build.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
    /// along with a unique string called a <i>nextToken</i>. To get the next
    /// batch of items in the list, call this operation again, adding the next token to the
    /// call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBuildsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuildsOutput");
        formatter.field("ids", &self.ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBuildsOutput`](crate::output::ListBuildsOutput)
pub mod list_builds_output {
    /// A builder for [`ListBuildsOutput`](crate::output::ListBuildsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>A list of build IDs, with each build ID representing a single build.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>A list of build IDs, with each build ID representing a single build.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
        /// along with a unique string called a <i>nextToken</i>. To get the next
        /// batch of items in the list, call this operation again, adding the next token to the
        /// call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more than 100 items in the list, only the first 100 items are returned,
        /// along with a unique string called a <i>nextToken</i>. To get the next
        /// batch of items in the list, call this operation again, adding the next token to the
        /// call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuildsOutput`](crate::output::ListBuildsOutput)
        pub fn build(self) -> crate::output::ListBuildsOutput {
            crate::output::ListBuildsOutput {
                ids: self.ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBuildsOutput {
    /// Creates a new builder-style object to manufacture [`ListBuildsOutput`](crate::output::ListBuildsOutput)
    pub fn builder() -> crate::output::list_builds_output::Builder {
        crate::output::list_builds_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuildBatchesForProjectOutput {
    /// <p>An array of strings that contains the batch build identifiers.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If there are more items to return, this contains a token that is passed to a
    /// subsequent call to <code>ListBuildBatchesForProject</code> to retrieve the next set of
    /// items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBuildBatchesForProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuildBatchesForProjectOutput");
        formatter.field("ids", &self.ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBuildBatchesForProjectOutput`](crate::output::ListBuildBatchesForProjectOutput)
pub mod list_build_batches_for_project_output {
    /// A builder for [`ListBuildBatchesForProjectOutput`](crate::output::ListBuildBatchesForProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of strings that contains the batch build identifiers.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>An array of strings that contains the batch build identifiers.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>If there are more items to return, this contains a token that is passed to a
        /// subsequent call to <code>ListBuildBatchesForProject</code> to retrieve the next set of
        /// items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more items to return, this contains a token that is passed to a
        /// subsequent call to <code>ListBuildBatchesForProject</code> to retrieve the next set of
        /// items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuildBatchesForProjectOutput`](crate::output::ListBuildBatchesForProjectOutput)
        pub fn build(self) -> crate::output::ListBuildBatchesForProjectOutput {
            crate::output::ListBuildBatchesForProjectOutput {
                ids: self.ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBuildBatchesForProjectOutput {
    /// Creates a new builder-style object to manufacture [`ListBuildBatchesForProjectOutput`](crate::output::ListBuildBatchesForProjectOutput)
    pub fn builder() -> crate::output::list_build_batches_for_project_output::Builder {
        crate::output::list_build_batches_for_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListBuildBatchesOutput {
    /// <p>An array of strings that contains the batch build identifiers.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If there are more items to return, this contains a token that is passed to a subsequent
    /// call to <code>ListBuildBatches</code> to retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListBuildBatchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListBuildBatchesOutput");
        formatter.field("ids", &self.ids);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListBuildBatchesOutput`](crate::output::ListBuildBatchesOutput)
pub mod list_build_batches_output {
    /// A builder for [`ListBuildBatchesOutput`](crate::output::ListBuildBatchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of strings that contains the batch build identifiers.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>An array of strings that contains the batch build identifiers.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// <p>If there are more items to return, this contains a token that is passed to a subsequent
        /// call to <code>ListBuildBatches</code> to retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more items to return, this contains a token that is passed to a subsequent
        /// call to <code>ListBuildBatches</code> to retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBuildBatchesOutput`](crate::output::ListBuildBatchesOutput)
        pub fn build(self) -> crate::output::ListBuildBatchesOutput {
            crate::output::ListBuildBatchesOutput {
                ids: self.ids,
                next_token: self.next_token,
            }
        }
    }
}
impl ListBuildBatchesOutput {
    /// Creates a new builder-style object to manufacture [`ListBuildBatchesOutput`](crate::output::ListBuildBatchesOutput)
    pub fn builder() -> crate::output::list_build_batches_output::Builder {
        crate::output::list_build_batches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidateProjectCacheOutput {}
impl std::fmt::Debug for InvalidateProjectCacheOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidateProjectCacheOutput");
        formatter.finish()
    }
}
/// See [`InvalidateProjectCacheOutput`](crate::output::InvalidateProjectCacheOutput)
pub mod invalidate_project_cache_output {
    /// A builder for [`InvalidateProjectCacheOutput`](crate::output::InvalidateProjectCacheOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`InvalidateProjectCacheOutput`](crate::output::InvalidateProjectCacheOutput)
        pub fn build(self) -> crate::output::InvalidateProjectCacheOutput {
            crate::output::InvalidateProjectCacheOutput {}
        }
    }
}
impl InvalidateProjectCacheOutput {
    /// Creates a new builder-style object to manufacture [`InvalidateProjectCacheOutput`](crate::output::InvalidateProjectCacheOutput)
    pub fn builder() -> crate::output::invalidate_project_cache_output::Builder {
        crate::output::invalidate_project_cache_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportSourceCredentialsOutput {
    /// <p> The Amazon Resource Name (ARN) of the token. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ImportSourceCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportSourceCredentialsOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ImportSourceCredentialsOutput`](crate::output::ImportSourceCredentialsOutput)
pub mod import_source_credentials_output {
    /// A builder for [`ImportSourceCredentialsOutput`](crate::output::ImportSourceCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the token. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the token. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportSourceCredentialsOutput`](crate::output::ImportSourceCredentialsOutput)
        pub fn build(self) -> crate::output::ImportSourceCredentialsOutput {
            crate::output::ImportSourceCredentialsOutput { arn: self.arn }
        }
    }
}
impl ImportSourceCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`ImportSourceCredentialsOutput`](crate::output::ImportSourceCredentialsOutput)
    pub fn builder() -> crate::output::import_source_credentials_output::Builder {
        crate::output::import_source_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetResourcePolicyOutput {
    /// <p> The resource policy for the resource identified by the input ARN parameter. </p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetResourcePolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
pub mod get_resource_policy_output {
    /// A builder for [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The resource policy for the resource identified by the input ARN parameter. </p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p> The resource policy for the resource identified by the input ARN parameter. </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
        pub fn build(self) -> crate::output::GetResourcePolicyOutput {
            crate::output::GetResourcePolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetResourcePolicyOutput`](crate::output::GetResourcePolicyOutput)
    pub fn builder() -> crate::output::get_resource_policy_output::Builder {
        crate::output::get_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReportGroupTrendOutput {
    /// <p>Contains the accumulated trend data.</p>
    pub stats: std::option::Option<crate::model::ReportGroupTrendStats>,
    /// <p>An array that contains the raw data for each report.</p>
    pub raw_data: std::option::Option<std::vec::Vec<crate::model::ReportWithRawData>>,
}
impl std::fmt::Debug for GetReportGroupTrendOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReportGroupTrendOutput");
        formatter.field("stats", &self.stats);
        formatter.field("raw_data", &self.raw_data);
        formatter.finish()
    }
}
/// See [`GetReportGroupTrendOutput`](crate::output::GetReportGroupTrendOutput)
pub mod get_report_group_trend_output {
    /// A builder for [`GetReportGroupTrendOutput`](crate::output::GetReportGroupTrendOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stats: std::option::Option<crate::model::ReportGroupTrendStats>,
        pub(crate) raw_data: std::option::Option<std::vec::Vec<crate::model::ReportWithRawData>>,
    }
    impl Builder {
        /// <p>Contains the accumulated trend data.</p>
        pub fn stats(mut self, input: crate::model::ReportGroupTrendStats) -> Self {
            self.stats = Some(input);
            self
        }
        /// <p>Contains the accumulated trend data.</p>
        pub fn set_stats(
            mut self,
            input: std::option::Option<crate::model::ReportGroupTrendStats>,
        ) -> Self {
            self.stats = input;
            self
        }
        /// Appends an item to `raw_data`.
        ///
        /// To override the contents of this collection use [`set_raw_data`](Self::set_raw_data).
        ///
        /// <p>An array that contains the raw data for each report.</p>
        pub fn raw_data(mut self, input: impl Into<crate::model::ReportWithRawData>) -> Self {
            let mut v = self.raw_data.unwrap_or_default();
            v.push(input.into());
            self.raw_data = Some(v);
            self
        }
        /// <p>An array that contains the raw data for each report.</p>
        pub fn set_raw_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportWithRawData>>,
        ) -> Self {
            self.raw_data = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReportGroupTrendOutput`](crate::output::GetReportGroupTrendOutput)
        pub fn build(self) -> crate::output::GetReportGroupTrendOutput {
            crate::output::GetReportGroupTrendOutput {
                stats: self.stats,
                raw_data: self.raw_data,
            }
        }
    }
}
impl GetReportGroupTrendOutput {
    /// Creates a new builder-style object to manufacture [`GetReportGroupTrendOutput`](crate::output::GetReportGroupTrendOutput)
    pub fn builder() -> crate::output::get_report_group_trend_output::Builder {
        crate::output::get_report_group_trend_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTestCasesOutput {
    /// <p>
    /// During a previous call, the maximum number of items that can be returned is the value specified in
    /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
    /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
    /// to the call. To get all of the items in the list, keep calling this operation with each
    /// subsequent next token that is returned, until no more next tokens are returned.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// The returned list of test cases.
    /// </p>
    pub test_cases: std::option::Option<std::vec::Vec<crate::model::TestCase>>,
}
impl std::fmt::Debug for DescribeTestCasesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTestCasesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("test_cases", &self.test_cases);
        formatter.finish()
    }
}
/// See [`DescribeTestCasesOutput`](crate::output::DescribeTestCasesOutput)
pub mod describe_test_cases_output {
    /// A builder for [`DescribeTestCasesOutput`](crate::output::DescribeTestCasesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) test_cases: std::option::Option<std::vec::Vec<crate::model::TestCase>>,
    }
    impl Builder {
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `test_cases`.
        ///
        /// To override the contents of this collection use [`set_test_cases`](Self::set_test_cases).
        ///
        /// <p>
        /// The returned list of test cases.
        /// </p>
        pub fn test_cases(mut self, input: impl Into<crate::model::TestCase>) -> Self {
            let mut v = self.test_cases.unwrap_or_default();
            v.push(input.into());
            self.test_cases = Some(v);
            self
        }
        /// <p>
        /// The returned list of test cases.
        /// </p>
        pub fn set_test_cases(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TestCase>>,
        ) -> Self {
            self.test_cases = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTestCasesOutput`](crate::output::DescribeTestCasesOutput)
        pub fn build(self) -> crate::output::DescribeTestCasesOutput {
            crate::output::DescribeTestCasesOutput {
                next_token: self.next_token,
                test_cases: self.test_cases,
            }
        }
    }
}
impl DescribeTestCasesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTestCasesOutput`](crate::output::DescribeTestCasesOutput)
    pub fn builder() -> crate::output::describe_test_cases_output::Builder {
        crate::output::describe_test_cases_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCodeCoveragesOutput {
    /// <p>If there are more items to return, this contains a token that is passed to a subsequent
    /// call to <code>DescribeCodeCoverages</code> to retrieve the next set of items.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>An array of <code>CodeCoverage</code> objects that contain the results.</p>
    pub code_coverages: std::option::Option<std::vec::Vec<crate::model::CodeCoverage>>,
}
impl std::fmt::Debug for DescribeCodeCoveragesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCodeCoveragesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("code_coverages", &self.code_coverages);
        formatter.finish()
    }
}
/// See [`DescribeCodeCoveragesOutput`](crate::output::DescribeCodeCoveragesOutput)
pub mod describe_code_coverages_output {
    /// A builder for [`DescribeCodeCoveragesOutput`](crate::output::DescribeCodeCoveragesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) code_coverages: std::option::Option<std::vec::Vec<crate::model::CodeCoverage>>,
    }
    impl Builder {
        /// <p>If there are more items to return, this contains a token that is passed to a subsequent
        /// call to <code>DescribeCodeCoverages</code> to retrieve the next set of items.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are more items to return, this contains a token that is passed to a subsequent
        /// call to <code>DescribeCodeCoverages</code> to retrieve the next set of items.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `code_coverages`.
        ///
        /// To override the contents of this collection use [`set_code_coverages`](Self::set_code_coverages).
        ///
        /// <p>An array of <code>CodeCoverage</code> objects that contain the results.</p>
        pub fn code_coverages(mut self, input: impl Into<crate::model::CodeCoverage>) -> Self {
            let mut v = self.code_coverages.unwrap_or_default();
            v.push(input.into());
            self.code_coverages = Some(v);
            self
        }
        /// <p>An array of <code>CodeCoverage</code> objects that contain the results.</p>
        pub fn set_code_coverages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CodeCoverage>>,
        ) -> Self {
            self.code_coverages = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCodeCoveragesOutput`](crate::output::DescribeCodeCoveragesOutput)
        pub fn build(self) -> crate::output::DescribeCodeCoveragesOutput {
            crate::output::DescribeCodeCoveragesOutput {
                next_token: self.next_token,
                code_coverages: self.code_coverages,
            }
        }
    }
}
impl DescribeCodeCoveragesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCodeCoveragesOutput`](crate::output::DescribeCodeCoveragesOutput)
    pub fn builder() -> crate::output::describe_code_coverages_output::Builder {
        crate::output::describe_code_coverages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWebhookOutput {}
impl std::fmt::Debug for DeleteWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWebhookOutput");
        formatter.finish()
    }
}
/// See [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
pub mod delete_webhook_output {
    /// A builder for [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
        pub fn build(self) -> crate::output::DeleteWebhookOutput {
            crate::output::DeleteWebhookOutput {}
        }
    }
}
impl DeleteWebhookOutput {
    /// Creates a new builder-style object to manufacture [`DeleteWebhookOutput`](crate::output::DeleteWebhookOutput)
    pub fn builder() -> crate::output::delete_webhook_output::Builder {
        crate::output::delete_webhook_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSourceCredentialsOutput {
    /// <p> The Amazon Resource Name (ARN) of the token. </p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteSourceCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSourceCredentialsOutput");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeleteSourceCredentialsOutput`](crate::output::DeleteSourceCredentialsOutput)
pub mod delete_source_credentials_output {
    /// A builder for [`DeleteSourceCredentialsOutput`](crate::output::DeleteSourceCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the token. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the token. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSourceCredentialsOutput`](crate::output::DeleteSourceCredentialsOutput)
        pub fn build(self) -> crate::output::DeleteSourceCredentialsOutput {
            crate::output::DeleteSourceCredentialsOutput { arn: self.arn }
        }
    }
}
impl DeleteSourceCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSourceCredentialsOutput`](crate::output::DeleteSourceCredentialsOutput)
    pub fn builder() -> crate::output::delete_source_credentials_output::Builder {
        crate::output::delete_source_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteResourcePolicyOutput {}
impl std::fmt::Debug for DeleteResourcePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteResourcePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
pub mod delete_resource_policy_output {
    /// A builder for [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
        pub fn build(self) -> crate::output::DeleteResourcePolicyOutput {
            crate::output::DeleteResourcePolicyOutput {}
        }
    }
}
impl DeleteResourcePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)
    pub fn builder() -> crate::output::delete_resource_policy_output::Builder {
        crate::output::delete_resource_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReportGroupOutput {}
impl std::fmt::Debug for DeleteReportGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReportGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteReportGroupOutput`](crate::output::DeleteReportGroupOutput)
pub mod delete_report_group_output {
    /// A builder for [`DeleteReportGroupOutput`](crate::output::DeleteReportGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReportGroupOutput`](crate::output::DeleteReportGroupOutput)
        pub fn build(self) -> crate::output::DeleteReportGroupOutput {
            crate::output::DeleteReportGroupOutput {}
        }
    }
}
impl DeleteReportGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReportGroupOutput`](crate::output::DeleteReportGroupOutput)
    pub fn builder() -> crate::output::delete_report_group_output::Builder {
        crate::output::delete_report_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReportOutput {}
impl std::fmt::Debug for DeleteReportOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReportOutput");
        formatter.finish()
    }
}
/// See [`DeleteReportOutput`](crate::output::DeleteReportOutput)
pub mod delete_report_output {
    /// A builder for [`DeleteReportOutput`](crate::output::DeleteReportOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteReportOutput`](crate::output::DeleteReportOutput)
        pub fn build(self) -> crate::output::DeleteReportOutput {
            crate::output::DeleteReportOutput {}
        }
    }
}
impl DeleteReportOutput {
    /// Creates a new builder-style object to manufacture [`DeleteReportOutput`](crate::output::DeleteReportOutput)
    pub fn builder() -> crate::output::delete_report_output::Builder {
        crate::output::delete_report_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectOutput {}
impl std::fmt::Debug for DeleteProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectOutput");
        formatter.finish()
    }
}
/// See [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
pub mod delete_project_output {
    /// A builder for [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
        pub fn build(self) -> crate::output::DeleteProjectOutput {
            crate::output::DeleteProjectOutput {}
        }
    }
}
impl DeleteProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    pub fn builder() -> crate::output::delete_project_output::Builder {
        crate::output::delete_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBuildBatchOutput {
    /// <p>The status code.</p>
    pub status_code: std::option::Option<std::string::String>,
    /// <p>An array of strings that contain the identifiers of the builds that were deleted.</p>
    pub builds_deleted: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be
    /// deleted.</p>
    pub builds_not_deleted: std::option::Option<std::vec::Vec<crate::model::BuildNotDeleted>>,
}
impl std::fmt::Debug for DeleteBuildBatchOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBuildBatchOutput");
        formatter.field("status_code", &self.status_code);
        formatter.field("builds_deleted", &self.builds_deleted);
        formatter.field("builds_not_deleted", &self.builds_not_deleted);
        formatter.finish()
    }
}
/// See [`DeleteBuildBatchOutput`](crate::output::DeleteBuildBatchOutput)
pub mod delete_build_batch_output {
    /// A builder for [`DeleteBuildBatchOutput`](crate::output::DeleteBuildBatchOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_code: std::option::Option<std::string::String>,
        pub(crate) builds_deleted: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) builds_not_deleted:
            std::option::Option<std::vec::Vec<crate::model::BuildNotDeleted>>,
    }
    impl Builder {
        /// <p>The status code.</p>
        pub fn status_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_code = Some(input.into());
            self
        }
        /// <p>The status code.</p>
        pub fn set_status_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_code = input;
            self
        }
        /// Appends an item to `builds_deleted`.
        ///
        /// To override the contents of this collection use [`set_builds_deleted`](Self::set_builds_deleted).
        ///
        /// <p>An array of strings that contain the identifiers of the builds that were deleted.</p>
        pub fn builds_deleted(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.builds_deleted.unwrap_or_default();
            v.push(input.into());
            self.builds_deleted = Some(v);
            self
        }
        /// <p>An array of strings that contain the identifiers of the builds that were deleted.</p>
        pub fn set_builds_deleted(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.builds_deleted = input;
            self
        }
        /// Appends an item to `builds_not_deleted`.
        ///
        /// To override the contents of this collection use [`set_builds_not_deleted`](Self::set_builds_not_deleted).
        ///
        /// <p>An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be
        /// deleted.</p>
        pub fn builds_not_deleted(
            mut self,
            input: impl Into<crate::model::BuildNotDeleted>,
        ) -> Self {
            let mut v = self.builds_not_deleted.unwrap_or_default();
            v.push(input.into());
            self.builds_not_deleted = Some(v);
            self
        }
        /// <p>An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be
        /// deleted.</p>
        pub fn set_builds_not_deleted(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildNotDeleted>>,
        ) -> Self {
            self.builds_not_deleted = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBuildBatchOutput`](crate::output::DeleteBuildBatchOutput)
        pub fn build(self) -> crate::output::DeleteBuildBatchOutput {
            crate::output::DeleteBuildBatchOutput {
                status_code: self.status_code,
                builds_deleted: self.builds_deleted,
                builds_not_deleted: self.builds_not_deleted,
            }
        }
    }
}
impl DeleteBuildBatchOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBuildBatchOutput`](crate::output::DeleteBuildBatchOutput)
    pub fn builder() -> crate::output::delete_build_batch_output::Builder {
        crate::output::delete_build_batch_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateWebhookOutput {
    /// <p>Information about a webhook that connects repository events to a build project in
    /// CodeBuild.</p>
    pub webhook: std::option::Option<crate::model::Webhook>,
}
impl std::fmt::Debug for CreateWebhookOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateWebhookOutput");
        formatter.field("webhook", &self.webhook);
        formatter.finish()
    }
}
/// See [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
pub mod create_webhook_output {
    /// A builder for [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) webhook: std::option::Option<crate::model::Webhook>,
    }
    impl Builder {
        /// <p>Information about a webhook that connects repository events to a build project in
        /// CodeBuild.</p>
        pub fn webhook(mut self, input: crate::model::Webhook) -> Self {
            self.webhook = Some(input);
            self
        }
        /// <p>Information about a webhook that connects repository events to a build project in
        /// CodeBuild.</p>
        pub fn set_webhook(mut self, input: std::option::Option<crate::model::Webhook>) -> Self {
            self.webhook = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
        pub fn build(self) -> crate::output::CreateWebhookOutput {
            crate::output::CreateWebhookOutput {
                webhook: self.webhook,
            }
        }
    }
}
impl CreateWebhookOutput {
    /// Creates a new builder-style object to manufacture [`CreateWebhookOutput`](crate::output::CreateWebhookOutput)
    pub fn builder() -> crate::output::create_webhook_output::Builder {
        crate::output::create_webhook_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReportGroupOutput {
    /// <p>
    /// Information about the report group that was created.
    /// </p>
    pub report_group: std::option::Option<crate::model::ReportGroup>,
}
impl std::fmt::Debug for CreateReportGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReportGroupOutput");
        formatter.field("report_group", &self.report_group);
        formatter.finish()
    }
}
/// See [`CreateReportGroupOutput`](crate::output::CreateReportGroupOutput)
pub mod create_report_group_output {
    /// A builder for [`CreateReportGroupOutput`](crate::output::CreateReportGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_group: std::option::Option<crate::model::ReportGroup>,
    }
    impl Builder {
        /// <p>
        /// Information about the report group that was created.
        /// </p>
        pub fn report_group(mut self, input: crate::model::ReportGroup) -> Self {
            self.report_group = Some(input);
            self
        }
        /// <p>
        /// Information about the report group that was created.
        /// </p>
        pub fn set_report_group(
            mut self,
            input: std::option::Option<crate::model::ReportGroup>,
        ) -> Self {
            self.report_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReportGroupOutput`](crate::output::CreateReportGroupOutput)
        pub fn build(self) -> crate::output::CreateReportGroupOutput {
            crate::output::CreateReportGroupOutput {
                report_group: self.report_group,
            }
        }
    }
}
impl CreateReportGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateReportGroupOutput`](crate::output::CreateReportGroupOutput)
    pub fn builder() -> crate::output::create_report_group_output::Builder {
        crate::output::create_report_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectOutput {
    /// <p>Information about the build project that was created.</p>
    pub project: std::option::Option<crate::model::Project>,
}
impl std::fmt::Debug for CreateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectOutput");
        formatter.field("project", &self.project);
        formatter.finish()
    }
}
/// See [`CreateProjectOutput`](crate::output::CreateProjectOutput)
pub mod create_project_output {
    /// A builder for [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project: std::option::Option<crate::model::Project>,
    }
    impl Builder {
        /// <p>Information about the build project that was created.</p>
        pub fn project(mut self, input: crate::model::Project) -> Self {
            self.project = Some(input);
            self
        }
        /// <p>Information about the build project that was created.</p>
        pub fn set_project(mut self, input: std::option::Option<crate::model::Project>) -> Self {
            self.project = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectOutput`](crate::output::CreateProjectOutput)
        pub fn build(self) -> crate::output::CreateProjectOutput {
            crate::output::CreateProjectOutput {
                project: self.project,
            }
        }
    }
}
impl CreateProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    pub fn builder() -> crate::output::create_project_output::Builder {
        crate::output::create_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetReportsOutput {
    /// <p>
    /// The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
    /// </p>
    pub reports: std::option::Option<std::vec::Vec<crate::model::Report>>,
    /// <p>
    /// An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>Report</code>.
    /// </p>
    pub reports_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetReportsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetReportsOutput");
        formatter.field("reports", &self.reports);
        formatter.field("reports_not_found", &self.reports_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetReportsOutput`](crate::output::BatchGetReportsOutput)
pub mod batch_get_reports_output {
    /// A builder for [`BatchGetReportsOutput`](crate::output::BatchGetReportsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reports: std::option::Option<std::vec::Vec<crate::model::Report>>,
        pub(crate) reports_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `reports`.
        ///
        /// To override the contents of this collection use [`set_reports`](Self::set_reports).
        ///
        /// <p>
        /// The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
        /// </p>
        pub fn reports(mut self, input: impl Into<crate::model::Report>) -> Self {
            let mut v = self.reports.unwrap_or_default();
            v.push(input.into());
            self.reports = Some(v);
            self
        }
        /// <p>
        /// The array of <code>Report</code> objects returned by <code>BatchGetReports</code>.
        /// </p>
        pub fn set_reports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Report>>,
        ) -> Self {
            self.reports = input;
            self
        }
        /// Appends an item to `reports_not_found`.
        ///
        /// To override the contents of this collection use [`set_reports_not_found`](Self::set_reports_not_found).
        ///
        /// <p>
        /// An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>Report</code>.
        /// </p>
        pub fn reports_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.reports_not_found.unwrap_or_default();
            v.push(input.into());
            self.reports_not_found = Some(v);
            self
        }
        /// <p>
        /// An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>Report</code>.
        /// </p>
        pub fn set_reports_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.reports_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetReportsOutput`](crate::output::BatchGetReportsOutput)
        pub fn build(self) -> crate::output::BatchGetReportsOutput {
            crate::output::BatchGetReportsOutput {
                reports: self.reports,
                reports_not_found: self.reports_not_found,
            }
        }
    }
}
impl BatchGetReportsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetReportsOutput`](crate::output::BatchGetReportsOutput)
    pub fn builder() -> crate::output::batch_get_reports_output::Builder {
        crate::output::batch_get_reports_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetReportGroupsOutput {
    /// <p>
    /// The array of report groups returned by <code>BatchGetReportGroups</code>.
    /// </p>
    pub report_groups: std::option::Option<std::vec::Vec<crate::model::ReportGroup>>,
    /// <p>
    /// An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>ReportGroup</code>.
    /// </p>
    pub report_groups_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetReportGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetReportGroupsOutput");
        formatter.field("report_groups", &self.report_groups);
        formatter.field("report_groups_not_found", &self.report_groups_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetReportGroupsOutput`](crate::output::BatchGetReportGroupsOutput)
pub mod batch_get_report_groups_output {
    /// A builder for [`BatchGetReportGroupsOutput`](crate::output::BatchGetReportGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_groups: std::option::Option<std::vec::Vec<crate::model::ReportGroup>>,
        pub(crate) report_groups_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `report_groups`.
        ///
        /// To override the contents of this collection use [`set_report_groups`](Self::set_report_groups).
        ///
        /// <p>
        /// The array of report groups returned by <code>BatchGetReportGroups</code>.
        /// </p>
        pub fn report_groups(mut self, input: impl Into<crate::model::ReportGroup>) -> Self {
            let mut v = self.report_groups.unwrap_or_default();
            v.push(input.into());
            self.report_groups = Some(v);
            self
        }
        /// <p>
        /// The array of report groups returned by <code>BatchGetReportGroups</code>.
        /// </p>
        pub fn set_report_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportGroup>>,
        ) -> Self {
            self.report_groups = input;
            self
        }
        /// Appends an item to `report_groups_not_found`.
        ///
        /// To override the contents of this collection use [`set_report_groups_not_found`](Self::set_report_groups_not_found).
        ///
        /// <p>
        /// An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>ReportGroup</code>.
        /// </p>
        pub fn report_groups_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.report_groups_not_found.unwrap_or_default();
            v.push(input.into());
            self.report_groups_not_found = Some(v);
            self
        }
        /// <p>
        /// An array of ARNs passed to <code>BatchGetReportGroups</code> that are not associated with a <code>ReportGroup</code>.
        /// </p>
        pub fn set_report_groups_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.report_groups_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetReportGroupsOutput`](crate::output::BatchGetReportGroupsOutput)
        pub fn build(self) -> crate::output::BatchGetReportGroupsOutput {
            crate::output::BatchGetReportGroupsOutput {
                report_groups: self.report_groups,
                report_groups_not_found: self.report_groups_not_found,
            }
        }
    }
}
impl BatchGetReportGroupsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetReportGroupsOutput`](crate::output::BatchGetReportGroupsOutput)
    pub fn builder() -> crate::output::batch_get_report_groups_output::Builder {
        crate::output::batch_get_report_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetProjectsOutput {
    /// <p>Information about the requested build projects.</p>
    pub projects: std::option::Option<std::vec::Vec<crate::model::Project>>,
    /// <p>The names of build projects for which information could not be found.</p>
    pub projects_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetProjectsOutput");
        formatter.field("projects", &self.projects);
        formatter.field("projects_not_found", &self.projects_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetProjectsOutput`](crate::output::BatchGetProjectsOutput)
pub mod batch_get_projects_output {
    /// A builder for [`BatchGetProjectsOutput`](crate::output::BatchGetProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projects: std::option::Option<std::vec::Vec<crate::model::Project>>,
        pub(crate) projects_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p>Information about the requested build projects.</p>
        pub fn projects(mut self, input: impl Into<crate::model::Project>) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input.into());
            self.projects = Some(v);
            self
        }
        /// <p>Information about the requested build projects.</p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Project>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// Appends an item to `projects_not_found`.
        ///
        /// To override the contents of this collection use [`set_projects_not_found`](Self::set_projects_not_found).
        ///
        /// <p>The names of build projects for which information could not be found.</p>
        pub fn projects_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.projects_not_found.unwrap_or_default();
            v.push(input.into());
            self.projects_not_found = Some(v);
            self
        }
        /// <p>The names of build projects for which information could not be found.</p>
        pub fn set_projects_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.projects_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetProjectsOutput`](crate::output::BatchGetProjectsOutput)
        pub fn build(self) -> crate::output::BatchGetProjectsOutput {
            crate::output::BatchGetProjectsOutput {
                projects: self.projects,
                projects_not_found: self.projects_not_found,
            }
        }
    }
}
impl BatchGetProjectsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetProjectsOutput`](crate::output::BatchGetProjectsOutput)
    pub fn builder() -> crate::output::batch_get_projects_output::Builder {
        crate::output::batch_get_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetBuildsOutput {
    /// <p>Information about the requested builds.</p>
    pub builds: std::option::Option<std::vec::Vec<crate::model::Build>>,
    /// <p>The IDs of builds for which information could not be found.</p>
    pub builds_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetBuildsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetBuildsOutput");
        formatter.field("builds", &self.builds);
        formatter.field("builds_not_found", &self.builds_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetBuildsOutput`](crate::output::BatchGetBuildsOutput)
pub mod batch_get_builds_output {
    /// A builder for [`BatchGetBuildsOutput`](crate::output::BatchGetBuildsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) builds: std::option::Option<std::vec::Vec<crate::model::Build>>,
        pub(crate) builds_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `builds`.
        ///
        /// To override the contents of this collection use [`set_builds`](Self::set_builds).
        ///
        /// <p>Information about the requested builds.</p>
        pub fn builds(mut self, input: impl Into<crate::model::Build>) -> Self {
            let mut v = self.builds.unwrap_or_default();
            v.push(input.into());
            self.builds = Some(v);
            self
        }
        /// <p>Information about the requested builds.</p>
        pub fn set_builds(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Build>>,
        ) -> Self {
            self.builds = input;
            self
        }
        /// Appends an item to `builds_not_found`.
        ///
        /// To override the contents of this collection use [`set_builds_not_found`](Self::set_builds_not_found).
        ///
        /// <p>The IDs of builds for which information could not be found.</p>
        pub fn builds_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.builds_not_found.unwrap_or_default();
            v.push(input.into());
            self.builds_not_found = Some(v);
            self
        }
        /// <p>The IDs of builds for which information could not be found.</p>
        pub fn set_builds_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.builds_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetBuildsOutput`](crate::output::BatchGetBuildsOutput)
        pub fn build(self) -> crate::output::BatchGetBuildsOutput {
            crate::output::BatchGetBuildsOutput {
                builds: self.builds,
                builds_not_found: self.builds_not_found,
            }
        }
    }
}
impl BatchGetBuildsOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetBuildsOutput`](crate::output::BatchGetBuildsOutput)
    pub fn builder() -> crate::output::batch_get_builds_output::Builder {
        crate::output::batch_get_builds_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetBuildBatchesOutput {
    /// <p>An array of <code>BuildBatch</code> objects that represent the retrieved batch
    /// builds.</p>
    pub build_batches: std::option::Option<std::vec::Vec<crate::model::BuildBatch>>,
    /// <p>An array that contains the identifiers of any batch builds that are not found.</p>
    pub build_batches_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for BatchGetBuildBatchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetBuildBatchesOutput");
        formatter.field("build_batches", &self.build_batches);
        formatter.field("build_batches_not_found", &self.build_batches_not_found);
        formatter.finish()
    }
}
/// See [`BatchGetBuildBatchesOutput`](crate::output::BatchGetBuildBatchesOutput)
pub mod batch_get_build_batches_output {
    /// A builder for [`BatchGetBuildBatchesOutput`](crate::output::BatchGetBuildBatchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) build_batches: std::option::Option<std::vec::Vec<crate::model::BuildBatch>>,
        pub(crate) build_batches_not_found: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `build_batches`.
        ///
        /// To override the contents of this collection use [`set_build_batches`](Self::set_build_batches).
        ///
        /// <p>An array of <code>BuildBatch</code> objects that represent the retrieved batch
        /// builds.</p>
        pub fn build_batches(mut self, input: impl Into<crate::model::BuildBatch>) -> Self {
            let mut v = self.build_batches.unwrap_or_default();
            v.push(input.into());
            self.build_batches = Some(v);
            self
        }
        /// <p>An array of <code>BuildBatch</code> objects that represent the retrieved batch
        /// builds.</p>
        pub fn set_build_batches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildBatch>>,
        ) -> Self {
            self.build_batches = input;
            self
        }
        /// Appends an item to `build_batches_not_found`.
        ///
        /// To override the contents of this collection use [`set_build_batches_not_found`](Self::set_build_batches_not_found).
        ///
        /// <p>An array that contains the identifiers of any batch builds that are not found.</p>
        pub fn build_batches_not_found(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.build_batches_not_found.unwrap_or_default();
            v.push(input.into());
            self.build_batches_not_found = Some(v);
            self
        }
        /// <p>An array that contains the identifiers of any batch builds that are not found.</p>
        pub fn set_build_batches_not_found(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.build_batches_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetBuildBatchesOutput`](crate::output::BatchGetBuildBatchesOutput)
        pub fn build(self) -> crate::output::BatchGetBuildBatchesOutput {
            crate::output::BatchGetBuildBatchesOutput {
                build_batches: self.build_batches,
                build_batches_not_found: self.build_batches_not_found,
            }
        }
    }
}
impl BatchGetBuildBatchesOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetBuildBatchesOutput`](crate::output::BatchGetBuildBatchesOutput)
    pub fn builder() -> crate::output::batch_get_build_batches_output::Builder {
        crate::output::batch_get_build_batches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteBuildsOutput {
    /// <p>The IDs of the builds that were successfully deleted.</p>
    pub builds_deleted: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Information about any builds that could not be successfully deleted.</p>
    pub builds_not_deleted: std::option::Option<std::vec::Vec<crate::model::BuildNotDeleted>>,
}
impl std::fmt::Debug for BatchDeleteBuildsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteBuildsOutput");
        formatter.field("builds_deleted", &self.builds_deleted);
        formatter.field("builds_not_deleted", &self.builds_not_deleted);
        formatter.finish()
    }
}
/// See [`BatchDeleteBuildsOutput`](crate::output::BatchDeleteBuildsOutput)
pub mod batch_delete_builds_output {
    /// A builder for [`BatchDeleteBuildsOutput`](crate::output::BatchDeleteBuildsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) builds_deleted: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) builds_not_deleted:
            std::option::Option<std::vec::Vec<crate::model::BuildNotDeleted>>,
    }
    impl Builder {
        /// Appends an item to `builds_deleted`.
        ///
        /// To override the contents of this collection use [`set_builds_deleted`](Self::set_builds_deleted).
        ///
        /// <p>The IDs of the builds that were successfully deleted.</p>
        pub fn builds_deleted(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.builds_deleted.unwrap_or_default();
            v.push(input.into());
            self.builds_deleted = Some(v);
            self
        }
        /// <p>The IDs of the builds that were successfully deleted.</p>
        pub fn set_builds_deleted(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.builds_deleted = input;
            self
        }
        /// Appends an item to `builds_not_deleted`.
        ///
        /// To override the contents of this collection use [`set_builds_not_deleted`](Self::set_builds_not_deleted).
        ///
        /// <p>Information about any builds that could not be successfully deleted.</p>
        pub fn builds_not_deleted(
            mut self,
            input: impl Into<crate::model::BuildNotDeleted>,
        ) -> Self {
            let mut v = self.builds_not_deleted.unwrap_or_default();
            v.push(input.into());
            self.builds_not_deleted = Some(v);
            self
        }
        /// <p>Information about any builds that could not be successfully deleted.</p>
        pub fn set_builds_not_deleted(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BuildNotDeleted>>,
        ) -> Self {
            self.builds_not_deleted = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteBuildsOutput`](crate::output::BatchDeleteBuildsOutput)
        pub fn build(self) -> crate::output::BatchDeleteBuildsOutput {
            crate::output::BatchDeleteBuildsOutput {
                builds_deleted: self.builds_deleted,
                builds_not_deleted: self.builds_not_deleted,
            }
        }
    }
}
impl BatchDeleteBuildsOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteBuildsOutput`](crate::output::BatchDeleteBuildsOutput)
    pub fn builder() -> crate::output::batch_delete_builds_output::Builder {
        crate::output::batch_delete_builds_output::Builder::default()
    }
}
