// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CodeBuild_20161006`.
///
/// This client allows ergonomic access to a `CodeBuild_20161006`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchDeleteBuilds` operation.
    ///
    /// See [`BatchDeleteBuilds`](crate::client::fluent_builders::BatchDeleteBuilds) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_builds(&self) -> fluent_builders::BatchDeleteBuilds<C, M, R> {
        fluent_builders::BatchDeleteBuilds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetBuildBatches` operation.
    ///
    /// See [`BatchGetBuildBatches`](crate::client::fluent_builders::BatchGetBuildBatches) for more information about the
    /// operation and its arguments.
    pub fn batch_get_build_batches(&self) -> fluent_builders::BatchGetBuildBatches<C, M, R> {
        fluent_builders::BatchGetBuildBatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetBuilds` operation.
    ///
    /// See [`BatchGetBuilds`](crate::client::fluent_builders::BatchGetBuilds) for more information about the
    /// operation and its arguments.
    pub fn batch_get_builds(&self) -> fluent_builders::BatchGetBuilds<C, M, R> {
        fluent_builders::BatchGetBuilds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetProjects` operation.
    ///
    /// See [`BatchGetProjects`](crate::client::fluent_builders::BatchGetProjects) for more information about the
    /// operation and its arguments.
    pub fn batch_get_projects(&self) -> fluent_builders::BatchGetProjects<C, M, R> {
        fluent_builders::BatchGetProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetReportGroups` operation.
    ///
    /// See [`BatchGetReportGroups`](crate::client::fluent_builders::BatchGetReportGroups) for more information about the
    /// operation and its arguments.
    pub fn batch_get_report_groups(&self) -> fluent_builders::BatchGetReportGroups<C, M, R> {
        fluent_builders::BatchGetReportGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetReports` operation.
    ///
    /// See [`BatchGetReports`](crate::client::fluent_builders::BatchGetReports) for more information about the
    /// operation and its arguments.
    pub fn batch_get_reports(&self) -> fluent_builders::BatchGetReports<C, M, R> {
        fluent_builders::BatchGetReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReportGroup` operation.
    ///
    /// See [`CreateReportGroup`](crate::client::fluent_builders::CreateReportGroup) for more information about the
    /// operation and its arguments.
    pub fn create_report_group(&self) -> fluent_builders::CreateReportGroup<C, M, R> {
        fluent_builders::CreateReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateWebhook` operation.
    ///
    /// See [`CreateWebhook`](crate::client::fluent_builders::CreateWebhook) for more information about the
    /// operation and its arguments.
    pub fn create_webhook(&self) -> fluent_builders::CreateWebhook<C, M, R> {
        fluent_builders::CreateWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBuildBatch` operation.
    ///
    /// See [`DeleteBuildBatch`](crate::client::fluent_builders::DeleteBuildBatch) for more information about the
    /// operation and its arguments.
    pub fn delete_build_batch(&self) -> fluent_builders::DeleteBuildBatch<C, M, R> {
        fluent_builders::DeleteBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReport` operation.
    ///
    /// See [`DeleteReport`](crate::client::fluent_builders::DeleteReport) for more information about the
    /// operation and its arguments.
    pub fn delete_report(&self) -> fluent_builders::DeleteReport<C, M, R> {
        fluent_builders::DeleteReport::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReportGroup` operation.
    ///
    /// See [`DeleteReportGroup`](crate::client::fluent_builders::DeleteReportGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_report_group(&self) -> fluent_builders::DeleteReportGroup<C, M, R> {
        fluent_builders::DeleteReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteResourcePolicy` operation.
    ///
    /// See [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy<C, M, R> {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSourceCredentials` operation.
    ///
    /// See [`DeleteSourceCredentials`](crate::client::fluent_builders::DeleteSourceCredentials) for more information about the
    /// operation and its arguments.
    pub fn delete_source_credentials(&self) -> fluent_builders::DeleteSourceCredentials<C, M, R> {
        fluent_builders::DeleteSourceCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteWebhook` operation.
    ///
    /// See [`DeleteWebhook`](crate::client::fluent_builders::DeleteWebhook) for more information about the
    /// operation and its arguments.
    pub fn delete_webhook(&self) -> fluent_builders::DeleteWebhook<C, M, R> {
        fluent_builders::DeleteWebhook::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCodeCoverages` operation.
    ///
    /// See [`DescribeCodeCoverages`](crate::client::fluent_builders::DescribeCodeCoverages) for more information about the
    /// operation and its arguments.
    pub fn describe_code_coverages(&self) -> fluent_builders::DescribeCodeCoverages<C, M, R> {
        fluent_builders::DescribeCodeCoverages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTestCases` operation.
    ///
    /// See [`DescribeTestCases`](crate::client::fluent_builders::DescribeTestCases) for more information about the
    /// operation and its arguments.
    pub fn describe_test_cases(&self) -> fluent_builders::DescribeTestCases<C, M, R> {
        fluent_builders::DescribeTestCases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReportGroupTrend` operation.
    ///
    /// See [`GetReportGroupTrend`](crate::client::fluent_builders::GetReportGroupTrend) for more information about the
    /// operation and its arguments.
    pub fn get_report_group_trend(&self) -> fluent_builders::GetReportGroupTrend<C, M, R> {
        fluent_builders::GetReportGroupTrend::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetResourcePolicy` operation.
    ///
    /// See [`GetResourcePolicy`](crate::client::fluent_builders::GetResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn get_resource_policy(&self) -> fluent_builders::GetResourcePolicy<C, M, R> {
        fluent_builders::GetResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportSourceCredentials` operation.
    ///
    /// See [`ImportSourceCredentials`](crate::client::fluent_builders::ImportSourceCredentials) for more information about the
    /// operation and its arguments.
    pub fn import_source_credentials(&self) -> fluent_builders::ImportSourceCredentials<C, M, R> {
        fluent_builders::ImportSourceCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `InvalidateProjectCache` operation.
    ///
    /// See [`InvalidateProjectCache`](crate::client::fluent_builders::InvalidateProjectCache) for more information about the
    /// operation and its arguments.
    pub fn invalidate_project_cache(&self) -> fluent_builders::InvalidateProjectCache<C, M, R> {
        fluent_builders::InvalidateProjectCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBuildBatches` operation.
    ///
    /// See [`ListBuildBatches`](crate::client::fluent_builders::ListBuildBatches) for more information about the
    /// operation and its arguments.
    pub fn list_build_batches(&self) -> fluent_builders::ListBuildBatches<C, M, R> {
        fluent_builders::ListBuildBatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBuildBatchesForProject` operation.
    ///
    /// See [`ListBuildBatchesForProject`](crate::client::fluent_builders::ListBuildBatchesForProject) for more information about the
    /// operation and its arguments.
    pub fn list_build_batches_for_project(
        &self,
    ) -> fluent_builders::ListBuildBatchesForProject<C, M, R> {
        fluent_builders::ListBuildBatchesForProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBuilds` operation.
    ///
    /// See [`ListBuilds`](crate::client::fluent_builders::ListBuilds) for more information about the
    /// operation and its arguments.
    pub fn list_builds(&self) -> fluent_builders::ListBuilds<C, M, R> {
        fluent_builders::ListBuilds::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBuildsForProject` operation.
    ///
    /// See [`ListBuildsForProject`](crate::client::fluent_builders::ListBuildsForProject) for more information about the
    /// operation and its arguments.
    pub fn list_builds_for_project(&self) -> fluent_builders::ListBuildsForProject<C, M, R> {
        fluent_builders::ListBuildsForProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCuratedEnvironmentImages` operation.
    ///
    /// See [`ListCuratedEnvironmentImages`](crate::client::fluent_builders::ListCuratedEnvironmentImages) for more information about the
    /// operation and its arguments.
    pub fn list_curated_environment_images(
        &self,
    ) -> fluent_builders::ListCuratedEnvironmentImages<C, M, R> {
        fluent_builders::ListCuratedEnvironmentImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReportGroups` operation.
    ///
    /// See [`ListReportGroups`](crate::client::fluent_builders::ListReportGroups) for more information about the
    /// operation and its arguments.
    pub fn list_report_groups(&self) -> fluent_builders::ListReportGroups<C, M, R> {
        fluent_builders::ListReportGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReports` operation.
    ///
    /// See [`ListReports`](crate::client::fluent_builders::ListReports) for more information about the
    /// operation and its arguments.
    pub fn list_reports(&self) -> fluent_builders::ListReports<C, M, R> {
        fluent_builders::ListReports::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReportsForReportGroup` operation.
    ///
    /// See [`ListReportsForReportGroup`](crate::client::fluent_builders::ListReportsForReportGroup) for more information about the
    /// operation and its arguments.
    pub fn list_reports_for_report_group(
        &self,
    ) -> fluent_builders::ListReportsForReportGroup<C, M, R> {
        fluent_builders::ListReportsForReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSharedProjects` operation.
    ///
    /// See [`ListSharedProjects`](crate::client::fluent_builders::ListSharedProjects) for more information about the
    /// operation and its arguments.
    pub fn list_shared_projects(&self) -> fluent_builders::ListSharedProjects<C, M, R> {
        fluent_builders::ListSharedProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSharedReportGroups` operation.
    ///
    /// See [`ListSharedReportGroups`](crate::client::fluent_builders::ListSharedReportGroups) for more information about the
    /// operation and its arguments.
    pub fn list_shared_report_groups(&self) -> fluent_builders::ListSharedReportGroups<C, M, R> {
        fluent_builders::ListSharedReportGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSourceCredentials` operation.
    ///
    /// See [`ListSourceCredentials`](crate::client::fluent_builders::ListSourceCredentials) for more information about the
    /// operation and its arguments.
    pub fn list_source_credentials(&self) -> fluent_builders::ListSourceCredentials<C, M, R> {
        fluent_builders::ListSourceCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutResourcePolicy` operation.
    ///
    /// See [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) for more information about the
    /// operation and its arguments.
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy<C, M, R> {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetryBuild` operation.
    ///
    /// See [`RetryBuild`](crate::client::fluent_builders::RetryBuild) for more information about the
    /// operation and its arguments.
    pub fn retry_build(&self) -> fluent_builders::RetryBuild<C, M, R> {
        fluent_builders::RetryBuild::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RetryBuildBatch` operation.
    ///
    /// See [`RetryBuildBatch`](crate::client::fluent_builders::RetryBuildBatch) for more information about the
    /// operation and its arguments.
    pub fn retry_build_batch(&self) -> fluent_builders::RetryBuildBatch<C, M, R> {
        fluent_builders::RetryBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartBuild` operation.
    ///
    /// See [`StartBuild`](crate::client::fluent_builders::StartBuild) for more information about the
    /// operation and its arguments.
    pub fn start_build(&self) -> fluent_builders::StartBuild<C, M, R> {
        fluent_builders::StartBuild::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartBuildBatch` operation.
    ///
    /// See [`StartBuildBatch`](crate::client::fluent_builders::StartBuildBatch) for more information about the
    /// operation and its arguments.
    pub fn start_build_batch(&self) -> fluent_builders::StartBuildBatch<C, M, R> {
        fluent_builders::StartBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopBuild` operation.
    ///
    /// See [`StopBuild`](crate::client::fluent_builders::StopBuild) for more information about the
    /// operation and its arguments.
    pub fn stop_build(&self) -> fluent_builders::StopBuild<C, M, R> {
        fluent_builders::StopBuild::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopBuildBatch` operation.
    ///
    /// See [`StopBuildBatch`](crate::client::fluent_builders::StopBuildBatch) for more information about the
    /// operation and its arguments.
    pub fn stop_build_batch(&self) -> fluent_builders::StopBuildBatch<C, M, R> {
        fluent_builders::StopBuildBatch::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProject` operation.
    ///
    /// See [`UpdateProject`](crate::client::fluent_builders::UpdateProject) for more information about the
    /// operation and its arguments.
    pub fn update_project(&self) -> fluent_builders::UpdateProject<C, M, R> {
        fluent_builders::UpdateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProjectVisibility` operation.
    ///
    /// See [`UpdateProjectVisibility`](crate::client::fluent_builders::UpdateProjectVisibility) for more information about the
    /// operation and its arguments.
    pub fn update_project_visibility(&self) -> fluent_builders::UpdateProjectVisibility<C, M, R> {
        fluent_builders::UpdateProjectVisibility::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateReportGroup` operation.
    ///
    /// See [`UpdateReportGroup`](crate::client::fluent_builders::UpdateReportGroup) for more information about the
    /// operation and its arguments.
    pub fn update_report_group(&self) -> fluent_builders::UpdateReportGroup<C, M, R> {
        fluent_builders::UpdateReportGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateWebhook` operation.
    ///
    /// See [`UpdateWebhook`](crate::client::fluent_builders::UpdateWebhook) for more information about the
    /// operation and its arguments.
    pub fn update_webhook(&self) -> fluent_builders::UpdateWebhook<C, M, R> {
        fluent_builders::UpdateWebhook::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchDeleteBuilds`.
    ///
    /// <p>Deletes one or more builds.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteBuilds<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_builds_input::Builder,
    }
    impl<C, M, R> BatchDeleteBuilds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteBuilds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteBuildsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteBuildsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteBuildsInputOperationOutputAlias,
                crate::output::BatchDeleteBuildsOutput,
                crate::error::BatchDeleteBuildsError,
                crate::input::BatchDeleteBuildsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the builds to delete.</p>
        pub fn ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(inp);
            self
        }
        /// <p>The IDs of the builds to delete.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetBuildBatches`.
    ///
    /// <p>Retrieves information about one or more batch builds.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetBuildBatches<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_build_batches_input::Builder,
    }
    impl<C, M, R> BatchGetBuildBatches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetBuildBatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetBuildBatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetBuildBatchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetBuildBatchesInputOperationOutputAlias,
                crate::output::BatchGetBuildBatchesOutput,
                crate::error::BatchGetBuildBatchesError,
                crate::input::BatchGetBuildBatchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array that contains the batch build identifiers to retrieve.</p>
        pub fn ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(inp);
            self
        }
        /// <p>An array that contains the batch build identifiers to retrieve.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetBuilds`.
    ///
    /// <p>Gets information about one or more builds.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetBuilds<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_builds_input::Builder,
    }
    impl<C, M, R> BatchGetBuilds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetBuilds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetBuildsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetBuildsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetBuildsInputOperationOutputAlias,
                crate::output::BatchGetBuildsOutput,
                crate::error::BatchGetBuildsError,
                crate::input::BatchGetBuildsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the builds.</p>
        pub fn ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(inp);
            self
        }
        /// <p>The IDs of the builds.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetProjects`.
    ///
    /// <p>Gets information about one or more build projects.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_projects_input::Builder,
    }
    impl<C, M, R> BatchGetProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetProjectsInputOperationOutputAlias,
                crate::output::BatchGetProjectsOutput,
                crate::error::BatchGetProjectsError,
                crate::input::BatchGetProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `names`.
        ///
        /// To override the contents of this collection use [`set_names`](Self::set_names).
        ///
        /// <p>The names or ARNs of the build projects. To get information about a project shared
        /// with your Amazon Web Services account, its ARN must be specified. You cannot specify a shared project
        /// using its name.</p>
        pub fn names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.names(inp);
            self
        }
        /// <p>The names or ARNs of the build projects. To get information about a project shared
        /// with your Amazon Web Services account, its ARN must be specified. You cannot specify a shared project
        /// using its name.</p>
        pub fn set_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetReportGroups`.
    ///
    /// <p>
    /// Returns an array of report groups.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetReportGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_report_groups_input::Builder,
    }
    impl<C, M, R> BatchGetReportGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetReportGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetReportGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetReportGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetReportGroupsInputOperationOutputAlias,
                crate::output::BatchGetReportGroupsOutput,
                crate::error::BatchGetReportGroupsError,
                crate::input::BatchGetReportGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `reportGroupArns`.
        ///
        /// To override the contents of this collection use [`set_report_group_arns`](Self::set_report_group_arns).
        ///
        /// <p>
        /// An array of report group ARNs that identify the report groups to return.
        /// </p>
        pub fn report_group_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_group_arns(inp);
            self
        }
        /// <p>
        /// An array of report group ARNs that identify the report groups to return.
        /// </p>
        pub fn set_report_group_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_report_group_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetReports`.
    ///
    /// <p>
    /// Returns an array of reports.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetReports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_reports_input::Builder,
    }
    impl<C, M, R> BatchGetReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetReportsInputOperationOutputAlias,
                crate::output::BatchGetReportsOutput,
                crate::error::BatchGetReportsError,
                crate::input::BatchGetReportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `reportArns`.
        ///
        /// To override the contents of this collection use [`set_report_arns`](Self::set_report_arns).
        ///
        /// <p>
        /// An array of ARNs that identify the <code>Report</code> objects to return.
        /// </p>
        pub fn report_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_arns(inp);
            self
        }
        /// <p>
        /// An array of ARNs that identify the <code>Report</code> objects to return.
        /// </p>
        pub fn set_report_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_report_arns(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates a build project.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the build project.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the build project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description that makes the build project easy to identify.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description that makes the build project easy to identify.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Information about the build input source code for the build project.</p>
        pub fn source(mut self, inp: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>Information about the build input source code for the build project.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ProjectSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `secondarySources`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources`](Self::set_secondary_sources).
        ///
        /// <p>An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources(mut self, inp: impl Into<crate::model::ProjectSource>) -> Self {
            self.inner = self.inner.secondary_sources(inp);
            self
        }
        /// <p>An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources(input);
            self
        }
        /// <p>A version of the build input to be built for this project. If not specified, the latest
        /// version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>sourceVersion</code> is specified at the build level, then that version takes
        /// precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn source_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(inp);
            self
        }
        /// <p>A version of the build input to be built for this project. If not specified, the latest
        /// version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>sourceVersion</code> is specified at the build level, then that version takes
        /// precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// Appends an item to `secondarySourceVersions`.
        ///
        /// To override the contents of this collection use [`set_secondary_source_versions`](Self::set_secondary_source_versions).
        ///
        /// <p>An array of <code>ProjectSourceVersion</code> objects. If
        /// <code>secondarySourceVersions</code> is specified at the build level, then they take
        /// precedence over these <code>secondarySourceVersions</code> (at the project level).
        /// </p>
        pub fn secondary_source_versions(
            mut self,
            inp: impl Into<crate::model::ProjectSourceVersion>,
        ) -> Self {
            self.inner = self.inner.secondary_source_versions(inp);
            self
        }
        /// <p>An array of <code>ProjectSourceVersion</code> objects. If
        /// <code>secondarySourceVersions</code> is specified at the build level, then they take
        /// precedence over these <code>secondarySourceVersions</code> (at the project level).
        /// </p>
        pub fn set_secondary_source_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_source_versions(input);
            self
        }
        /// <p>Information about the build output artifacts for the build project.</p>
        pub fn artifacts(mut self, inp: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts(inp);
            self
        }
        /// <p>Information about the build output artifacts for the build project.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts(input);
            self
        }
        /// Appends an item to `secondaryArtifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn secondary_artifacts(
            mut self,
            inp: impl Into<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.secondary_artifacts(inp);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts(input);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later
        /// time.</p>
        pub fn cache(mut self, inp: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache(inp);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later
        /// time.</p>
        pub fn set_cache(mut self, input: std::option::Option<crate::model::ProjectCache>) -> Self {
            self.inner = self.inner.set_cache(input);
            self
        }
        /// <p>Information about the build environment for the build project.</p>
        pub fn environment(mut self, inp: crate::model::ProjectEnvironment) -> Self {
            self.inner = self.inner.environment(inp);
            self
        }
        /// <p>Information about the build environment for the build project.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::ProjectEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
        /// on behalf of the Amazon Web Services account.</p>
        pub fn service_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role(inp);
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
        /// on behalf of the Amazon Web Services account.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_role(input);
            self
        }
        /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before it times out
        /// any build that has not been marked as completed. The default is 60 minutes.</p>
        pub fn timeout_in_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout_in_minutes(inp);
            self
        }
        /// <p>How long, in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before it times out
        /// any build that has not been marked as completed. The default is 60 minutes.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_minutes(input);
            self
        }
        /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes(inp);
            self
        }
        /// <p>The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).
        /// </p>
        pub fn encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).
        /// </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
        /// tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build
        /// badge.</p>
        pub fn badge_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.badge_enabled(inp);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build
        /// badge.</p>
        pub fn set_badge_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_badge_enabled(input);
            self
        }
        /// <p>Information about logs for the build project. These can be logs in CloudWatch Logs, logs
        /// uploaded to a specified S3 bucket, or both. </p>
        pub fn logs_config(mut self, inp: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config(inp);
            self
        }
        /// <p>Information about logs for the build project. These can be logs in CloudWatch Logs, logs
        /// uploaded to a specified S3 bucket, or both. </p>
        pub fn set_logs_config(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config(input);
            self
        }
        /// Appends an item to `fileSystemLocations`.
        ///
        /// To override the contents of this collection use [`set_file_system_locations`](Self::set_file_system_locations).
        ///
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn file_system_locations(
            mut self,
            inp: impl Into<crate::model::ProjectFileSystemLocation>,
        ) -> Self {
            self.inner = self.inner.file_system_locations(inp);
            self
        }
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn set_file_system_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_locations(input);
            self
        }
        /// <p>A <a>ProjectBuildBatchConfig</a>
        /// object that defines the batch build options
        /// for the project.</p>
        pub fn build_batch_config(mut self, inp: crate::model::ProjectBuildBatchConfig) -> Self {
            self.inner = self.inner.build_batch_config(inp);
            self
        }
        /// <p>A <a>ProjectBuildBatchConfig</a>
        /// object that defines the batch build options
        /// for the project.</p>
        pub fn set_build_batch_config(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_batch_config(input);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
        /// If the current build count meets this limit, new builds are throttled and are not run.</p>
        pub fn concurrent_build_limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.concurrent_build_limit(inp);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
        /// If the current build count meets this limit, new builds are throttled and are not run.</p>
        pub fn set_concurrent_build_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_concurrent_build_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReportGroup`.
    ///
    /// <p>
    /// Creates a report group. A report group contains a collection of reports.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReportGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_report_group_input::Builder,
    }
    impl<C, M, R> CreateReportGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReportGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReportGroupInputOperationOutputAlias,
                crate::output::CreateReportGroupOutput,
                crate::error::CreateReportGroupError,
                crate::input::CreateReportGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the report group.
        /// </p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>
        /// The name of the report group.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>
        /// The type of report group.
        /// </p>
        pub fn r#type(mut self, inp: crate::model::ReportType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>
        /// The type of report group.
        /// </p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::ReportType>) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>
        /// A <code>ReportExportConfig</code> object that contains information about where the report group test results are exported.
        /// </p>
        pub fn export_config(mut self, inp: crate::model::ReportExportConfig) -> Self {
            self.inner = self.inner.export_config(inp);
            self
        }
        /// <p>
        /// A <code>ReportExportConfig</code> object that contains information about where the report group test results are exported.
        /// </p>
        pub fn set_export_config(
            mut self,
            input: std::option::Option<crate::model::ReportExportConfig>,
        ) -> Self {
            self.inner = self.inner.set_export_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// A list of tag key and value pairs associated with this report group.
        /// </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
        /// tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>
        /// A list of tag key and value pairs associated with this report group.
        /// </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateWebhook`.
    ///
    /// <p>For an existing CodeBuild build project that has its source code stored in a GitHub or
    /// Bitbucket repository, enables CodeBuild to start rebuilding the source code every time a
    /// code change is pushed to the repository.</p>
    /// <important>
    /// <p>If you enable webhooks for an CodeBuild project, and the project is used as a build
    /// step in CodePipeline, then two identical builds are created for each commit. One build is
    /// triggered through webhooks, and one through CodePipeline. Because billing is on a per-build
    /// basis, you are billed for both builds. Therefore, if you are using CodePipeline, we
    /// recommend that you disable webhooks in CodeBuild. In the CodeBuild console, clear the
    /// Webhook box. For more information, see step 5 in <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/change-project.html#change-project-console">Change a Build Project's Settings</a>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_webhook_input::Builder,
    }
    impl<C, M, R> CreateWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateWebhookInputOperationOutputAlias,
                crate::output::CreateWebhookOutput,
                crate::error::CreateWebhookError,
                crate::input::CreateWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a
        /// webhook is triggered. If the name of a branch matches the regular expression, then it is
        /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
        /// <note>
        /// <p>It is recommended that you use <code>filterGroups</code> instead of
        /// <code>branchFilter</code>. </p>
        /// </note>
        pub fn branch_filter(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_filter(inp);
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a
        /// webhook is triggered. If the name of a branch matches the regular expression, then it is
        /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
        /// <note>
        /// <p>It is recommended that you use <code>filterGroups</code> instead of
        /// <code>branchFilter</code>. </p>
        /// </note>
        pub fn set_branch_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_branch_filter(input);
            self
        }
        /// Appends an item to `filterGroups`.
        ///
        /// To override the contents of this collection use [`set_filter_groups`](Self::set_filter_groups).
        ///
        /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which
        /// webhooks are triggered. At least one <code>WebhookFilter</code> in the array must
        /// specify <code>EVENT</code> as its <code>type</code>. </p>
        /// <p>For a build to be triggered, at least one filter group in the
        /// <code>filterGroups</code> array must pass. For a filter group to pass, each of its
        /// filters must pass. </p>
        pub fn filter_groups(
            mut self,
            inp: impl Into<std::vec::Vec<crate::model::WebhookFilter>>,
        ) -> Self {
            self.inner = self.inner.filter_groups(inp);
            self
        }
        /// <p>An array of arrays of <code>WebhookFilter</code> objects used to determine which
        /// webhooks are triggered. At least one <code>WebhookFilter</code> in the array must
        /// specify <code>EVENT</code> as its <code>type</code>. </p>
        /// <p>For a build to be triggered, at least one filter group in the
        /// <code>filterGroups</code> array must pass. For a filter group to pass, each of its
        /// filters must pass. </p>
        pub fn set_filter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::WebhookFilter>>>,
        ) -> Self {
            self.inner = self.inner.set_filter_groups(input);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn build_type(mut self, inp: crate::model::WebhookBuildType) -> Self {
            self.inner = self.inner.build_type(inp);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn set_build_type(
            mut self,
            input: std::option::Option<crate::model::WebhookBuildType>,
        ) -> Self {
            self.inner = self.inner.set_build_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBuildBatch`.
    ///
    /// <p>Deletes a batch build.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBuildBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_build_batch_input::Builder,
    }
    impl<C, M, R> DeleteBuildBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBuildBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBuildBatchInputOperationOutputAlias,
                crate::output::DeleteBuildBatchOutput,
                crate::error::DeleteBuildBatchError,
                crate::input::DeleteBuildBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the batch build to delete.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the batch build to delete.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p> Deletes a build project. When you delete a project, its builds are not deleted.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the build project.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the build project.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReport`.
    ///
    /// <p>
    /// Deletes a report.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReport<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_report_input::Builder,
    }
    impl<C, M, R> DeleteReport<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReport`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReportOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReportError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReportInputOperationOutputAlias,
                crate::output::DeleteReportOutput,
                crate::error::DeleteReportError,
                crate::input::DeleteReportInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ARN of the report to delete.
        /// </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>
        /// The ARN of the report to delete.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReportGroup`.
    ///
    /// <p>Deletes a report group. Before you delete a report group, you must delete its reports. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReportGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_report_group_input::Builder,
    }
    impl<C, M, R> DeleteReportGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReportGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReportGroupInputOperationOutputAlias,
                crate::output::DeleteReportGroupOutput,
                crate::error::DeleteReportGroupError,
                crate::input::DeleteReportGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the report group to delete. </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>The ARN of the report group to delete. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>If <code>true</code>, deletes any reports that belong to a report group before deleting
        /// the report group. </p>
        /// <p>If <code>false</code>, you must delete any reports in the report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ListReportsForReportGroup.html">ListReportsForReportGroup</a> to get the reports in a report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_DeleteReport.html">DeleteReport</a> to delete the reports. If you call
        /// <code>DeleteReportGroup</code> for a report group that contains one or more reports,
        /// an exception is thrown. </p>
        pub fn delete_reports(mut self, inp: bool) -> Self {
            self.inner = self.inner.delete_reports(inp);
            self
        }
        /// <p>If <code>true</code>, deletes any reports that belong to a report group before deleting
        /// the report group. </p>
        /// <p>If <code>false</code>, you must delete any reports in the report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ListReportsForReportGroup.html">ListReportsForReportGroup</a> to get the reports in a report group. Use <a href="https://docs.aws.amazon.com/codebuild/latest/APIReference/API_DeleteReport.html">DeleteReport</a> to delete the reports. If you call
        /// <code>DeleteReportGroup</code> for a report group that contains one or more reports,
        /// an exception is thrown. </p>
        pub fn set_delete_reports(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_delete_reports(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p> Deletes a resource policy that is identified by its resource ARN. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl<C, M, R> DeleteResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteResourcePolicyInputOperationOutputAlias,
                crate::output::DeleteResourcePolicyOutput,
                crate::error::DeleteResourcePolicyError,
                crate::input::DeleteResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSourceCredentials`.
    ///
    /// <p> Deletes a set of GitHub, GitHub Enterprise, or Bitbucket source credentials. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSourceCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_source_credentials_input::Builder,
    }
    impl<C, M, R> DeleteSourceCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSourceCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSourceCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSourceCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSourceCredentialsInputOperationOutputAlias,
                crate::output::DeleteSourceCredentialsOutput,
                crate::error::DeleteSourceCredentialsError,
                crate::input::DeleteSourceCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the token.</p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the token.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWebhook`.
    ///
    /// <p>For an existing CodeBuild build project that has its source code stored in a GitHub or
    /// Bitbucket repository, stops CodeBuild from rebuilding the source code every time a code
    /// change is pushed to the repository.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_webhook_input::Builder,
    }
    impl<C, M, R> DeleteWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteWebhookInputOperationOutputAlias,
                crate::output::DeleteWebhookOutput,
                crate::error::DeleteWebhookError,
                crate::input::DeleteWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCodeCoverages`.
    ///
    /// <p>Retrieves one or more code coverage reports.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCodeCoverages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_code_coverages_input::Builder,
    }
    impl<C, M, R> DescribeCodeCoverages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCodeCoverages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCodeCoveragesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCodeCoveragesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCodeCoveragesInputOperationOutputAlias,
                crate::output::DescribeCodeCoveragesOutput,
                crate::error::DescribeCodeCoveragesError,
                crate::input::DescribeCodeCoveragesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ARN of the report for which test cases are returned.
        /// </p>
        pub fn report_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_arn(inp);
            self
        }
        /// <p>
        /// The ARN of the report for which test cases are returned.
        /// </p>
        pub fn set_report_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_arn(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to
        /// <code>DescribeCodeCoverages</code>. This specifies the next item to return. To
        /// return the beginning of the list, exclude this parameter.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to
        /// <code>DescribeCodeCoverages</code>. This specifies the next item to return. To
        /// return the beginning of the list, exclude this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies if the results are sorted in ascending or descending order.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>Specifies if the results are sorted in ascending or descending order.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>Specifies how the results are sorted. Possible values are:</p>
        /// <dl>
        /// <dt>FILE_PATH</dt>
        /// <dd>
        /// <p>The results are sorted by file path.</p>
        /// </dd>
        /// <dt>LINE_COVERAGE_PERCENTAGE</dt>
        /// <dd>
        /// <p>The results are sorted by the percentage of lines that are covered.</p>
        /// </dd>
        /// </dl>
        pub fn sort_by(mut self, inp: crate::model::ReportCodeCoverageSortByType) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>Specifies how the results are sorted. Possible values are:</p>
        /// <dl>
        /// <dt>FILE_PATH</dt>
        /// <dd>
        /// <p>The results are sorted by file path.</p>
        /// </dd>
        /// <dt>LINE_COVERAGE_PERCENTAGE</dt>
        /// <dd>
        /// <p>The results are sorted by the percentage of lines that are covered.</p>
        /// </dd>
        /// </dl>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ReportCodeCoverageSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The minimum line coverage percentage to report.</p>
        pub fn min_line_coverage_percentage(mut self, inp: f64) -> Self {
            self.inner = self.inner.min_line_coverage_percentage(inp);
            self
        }
        /// <p>The minimum line coverage percentage to report.</p>
        pub fn set_min_line_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_min_line_coverage_percentage(input);
            self
        }
        /// <p>The maximum line coverage percentage to report.</p>
        pub fn max_line_coverage_percentage(mut self, inp: f64) -> Self {
            self.inner = self.inner.max_line_coverage_percentage(inp);
            self
        }
        /// <p>The maximum line coverage percentage to report.</p>
        pub fn set_max_line_coverage_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_max_line_coverage_percentage(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTestCases`.
    ///
    /// <p>
    /// Returns a list of details about test cases for a report.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTestCases<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_test_cases_input::Builder,
    }
    impl<C, M, R> DescribeTestCases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTestCases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTestCasesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTestCasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTestCasesInputOperationOutputAlias,
                crate::output::DescribeTestCasesOutput,
                crate::error::DescribeTestCasesError,
                crate::input::DescribeTestCasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ARN of the report for which test cases are returned.
        /// </p>
        pub fn report_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_arn(inp);
            self
        }
        /// <p>
        /// The ARN of the report for which test cases are returned.
        /// </p>
        pub fn set_report_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_report_arn(input);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>TestCase</code> objects. The default value is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of paginated test cases returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>TestCase</code> objects. The default value is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// A <code>TestCaseFilter</code> object used to filter the returned reports.
        /// </p>
        pub fn filter(mut self, inp: crate::model::TestCaseFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>
        /// A <code>TestCaseFilter</code> object used to filter the returned reports.
        /// </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::TestCaseFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReportGroupTrend`.
    ///
    /// <p>Analyzes and accumulates test report values for the specified test reports.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetReportGroupTrend<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_report_group_trend_input::Builder,
    }
    impl<C, M, R> GetReportGroupTrend<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReportGroupTrend`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReportGroupTrendOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReportGroupTrendError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReportGroupTrendInputOperationOutputAlias,
                crate::output::GetReportGroupTrendOutput,
                crate::error::GetReportGroupTrendError,
                crate::input::GetReportGroupTrendInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the report group that contains the reports to analyze.</p>
        pub fn report_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_group_arn(inp);
            self
        }
        /// <p>The ARN of the report group that contains the reports to analyze.</p>
        pub fn set_report_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_group_arn(input);
            self
        }
        /// <p>The number of reports to analyze. This operation always retrieves the most recent
        /// reports.</p>
        /// <p>If this parameter is omitted, the most recent 100 reports are analyzed.</p>
        pub fn num_of_reports(mut self, inp: i32) -> Self {
            self.inner = self.inner.num_of_reports(inp);
            self
        }
        /// <p>The number of reports to analyze. This operation always retrieves the most recent
        /// reports.</p>
        /// <p>If this parameter is omitted, the most recent 100 reports are analyzed.</p>
        pub fn set_num_of_reports(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_num_of_reports(input);
            self
        }
        /// <p>The test report value to accumulate. This must be one of the following values:</p>
        /// <dl>
        /// <dt>Test reports:</dt>
        /// <dd>
        /// <dl>
        /// <dt>DURATION</dt>
        /// <dd>
        /// <p>Accumulate the test run times for the specified
        /// reports.</p>
        /// </dd>
        /// <dt>PASS_RATE</dt>
        /// <dd>
        /// <p>Accumulate the percentage of tests that passed for the
        /// specified test reports.</p>
        /// </dd>
        /// <dt>TOTAL</dt>
        /// <dd>
        /// <p>Accumulate the total number of tests for the specified test
        /// reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        /// <dl>
        /// <dt>Code coverage reports:</dt>
        /// <dd>
        /// <dl>
        /// <dt>BRANCH_COVERAGE</dt>
        /// <dd>
        /// <p>Accumulate the branch coverage percentages for the specified
        /// test reports.</p>
        /// </dd>
        /// <dt>BRANCHES_COVERED</dt>
        /// <dd>
        /// <p>Accumulate the branches covered values for the specified test
        /// reports.</p>
        /// </dd>
        /// <dt>BRANCHES_MISSED</dt>
        /// <dd>
        /// <p>Accumulate the branches missed values for the specified test
        /// reports.</p>
        /// </dd>
        /// <dt>LINE_COVERAGE</dt>
        /// <dd>
        /// <p>Accumulate the line coverage percentages for the specified
        /// test reports.</p>
        /// </dd>
        /// <dt>LINES_COVERED</dt>
        /// <dd>
        /// <p>Accumulate the lines covered values for the specified test
        /// reports.</p>
        /// </dd>
        /// <dt>LINES_MISSED</dt>
        /// <dd>
        /// <p>Accumulate the lines not covered values for the specified test
        /// reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        pub fn trend_field(mut self, inp: crate::model::ReportGroupTrendFieldType) -> Self {
            self.inner = self.inner.trend_field(inp);
            self
        }
        /// <p>The test report value to accumulate. This must be one of the following values:</p>
        /// <dl>
        /// <dt>Test reports:</dt>
        /// <dd>
        /// <dl>
        /// <dt>DURATION</dt>
        /// <dd>
        /// <p>Accumulate the test run times for the specified
        /// reports.</p>
        /// </dd>
        /// <dt>PASS_RATE</dt>
        /// <dd>
        /// <p>Accumulate the percentage of tests that passed for the
        /// specified test reports.</p>
        /// </dd>
        /// <dt>TOTAL</dt>
        /// <dd>
        /// <p>Accumulate the total number of tests for the specified test
        /// reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        /// <dl>
        /// <dt>Code coverage reports:</dt>
        /// <dd>
        /// <dl>
        /// <dt>BRANCH_COVERAGE</dt>
        /// <dd>
        /// <p>Accumulate the branch coverage percentages for the specified
        /// test reports.</p>
        /// </dd>
        /// <dt>BRANCHES_COVERED</dt>
        /// <dd>
        /// <p>Accumulate the branches covered values for the specified test
        /// reports.</p>
        /// </dd>
        /// <dt>BRANCHES_MISSED</dt>
        /// <dd>
        /// <p>Accumulate the branches missed values for the specified test
        /// reports.</p>
        /// </dd>
        /// <dt>LINE_COVERAGE</dt>
        /// <dd>
        /// <p>Accumulate the line coverage percentages for the specified
        /// test reports.</p>
        /// </dd>
        /// <dt>LINES_COVERED</dt>
        /// <dd>
        /// <p>Accumulate the lines covered values for the specified test
        /// reports.</p>
        /// </dd>
        /// <dt>LINES_MISSED</dt>
        /// <dd>
        /// <p>Accumulate the lines not covered values for the specified test
        /// reports.</p>
        /// </dd>
        /// </dl>
        /// </dd>
        /// </dl>
        pub fn set_trend_field(
            mut self,
            input: std::option::Option<crate::model::ReportGroupTrendFieldType>,
        ) -> Self {
            self.inner = self.inner.set_trend_field(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetResourcePolicy`.
    ///
    /// <p> Gets a resource policy that is identified by its resource ARN. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_resource_policy_input::Builder,
    }
    impl<C, M, R> GetResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetResourcePolicyInputOperationOutputAlias,
                crate::output::GetResourcePolicyOutput,
                crate::error::GetResourcePolicyError,
                crate::input::GetResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The ARN of the resource that is associated with the resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportSourceCredentials`.
    ///
    /// <p> Imports the source repository credentials for an CodeBuild project that has its
    /// source code stored in a GitHub, GitHub Enterprise, or Bitbucket repository. </p>
    #[derive(std::fmt::Debug)]
    pub struct ImportSourceCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_source_credentials_input::Builder,
    }
    impl<C, M, R> ImportSourceCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportSourceCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportSourceCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportSourceCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportSourceCredentialsInputOperationOutputAlias,
                crate::output::ImportSourceCredentialsOutput,
                crate::error::ImportSourceCredentialsError,
                crate::input::ImportSourceCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter
        /// is not valid for other types of source providers or connections. </p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p> The Bitbucket username when the <code>authType</code> is BASIC_AUTH. This parameter
        /// is not valid for other types of source providers or connections. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p> For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket,
        /// this is the app password. </p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p> For GitHub or GitHub Enterprise, this is the personal access token. For Bitbucket,
        /// this is the app password. </p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
        /// <p> The source provider used for this project. </p>
        pub fn server_type(mut self, inp: crate::model::ServerType) -> Self {
            self.inner = self.inner.server_type(inp);
            self
        }
        /// <p> The source provider used for this project. </p>
        pub fn set_server_type(
            mut self,
            input: std::option::Option<crate::model::ServerType>,
        ) -> Self {
            self.inner = self.inner.set_server_type(input);
            self
        }
        /// <p> The type of authentication used to connect to a GitHub, GitHub Enterprise, or
        /// Bitbucket repository. An OAUTH connection is not supported by the API and must be
        /// created using the CodeBuild console. </p>
        pub fn auth_type(mut self, inp: crate::model::AuthType) -> Self {
            self.inner = self.inner.auth_type(inp);
            self
        }
        /// <p> The type of authentication used to connect to a GitHub, GitHub Enterprise, or
        /// Bitbucket repository. An OAUTH connection is not supported by the API and must be
        /// created using the CodeBuild console. </p>
        pub fn set_auth_type(mut self, input: std::option::Option<crate::model::AuthType>) -> Self {
            self.inner = self.inner.set_auth_type(input);
            self
        }
        /// <p> Set to <code>false</code> to prevent overwriting the repository source credentials.
        /// Set to <code>true</code> to overwrite the repository source credentials. The default
        /// value is <code>true</code>. </p>
        pub fn should_overwrite(mut self, inp: bool) -> Self {
            self.inner = self.inner.should_overwrite(inp);
            self
        }
        /// <p> Set to <code>false</code> to prevent overwriting the repository source credentials.
        /// Set to <code>true</code> to overwrite the repository source credentials. The default
        /// value is <code>true</code>. </p>
        pub fn set_should_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_should_overwrite(input);
            self
        }
    }
    /// Fluent builder constructing a request to `InvalidateProjectCache`.
    ///
    /// <p>Resets the cache for a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct InvalidateProjectCache<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::invalidate_project_cache_input::Builder,
    }
    impl<C, M, R> InvalidateProjectCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `InvalidateProjectCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::InvalidateProjectCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::InvalidateProjectCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::InvalidateProjectCacheInputOperationOutputAlias,
                crate::output::InvalidateProjectCacheOutput,
                crate::error::InvalidateProjectCacheError,
                crate::input::InvalidateProjectCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild build project that the cache is reset for.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the CodeBuild build project that the cache is reset for.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuildBatches`.
    ///
    /// <p>Retrieves the identifiers of your build batches in the current region.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBuildBatches<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_build_batches_input::Builder,
    }
    impl<C, M, R> ListBuildBatches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBuildBatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildBatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildBatchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBuildBatchesInputOperationOutputAlias,
                crate::output::ListBuildBatchesOutput,
                crate::error::ListBuildBatchesError,
                crate::input::ListBuildBatchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn filter(mut self, inp: crate::model::BuildBatchFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::BuildBatchFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p>
        /// </li>
        /// </ul>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the batch build identifiers in ascending order by identifier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the batch build identifiers in descending order by identifier.</p>
        /// </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to
        /// <code>ListBuildBatches</code>. This specifies the next item to return. To return the
        /// beginning of the list, exclude this parameter.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to
        /// <code>ListBuildBatches</code>. This specifies the next item to return. To return the
        /// beginning of the list, exclude this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuildBatchesForProject`.
    ///
    /// <p>Retrieves the identifiers of the build batches for a specific project.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBuildBatchesForProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_build_batches_for_project_input::Builder,
    }
    impl<C, M, R> ListBuildBatchesForProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBuildBatchesForProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildBatchesForProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildBatchesForProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBuildBatchesForProjectInputOperationOutputAlias,
                crate::output::ListBuildBatchesForProjectOutput,
                crate::error::ListBuildBatchesForProjectError,
                crate::input::ListBuildBatchesForProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn filter(mut self, inp: crate::model::BuildBatchFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>A <code>BuildBatchFilter</code> object that specifies the filters for the search.</p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::BuildBatchFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the batch build identifiers in ascending order by
        /// identifier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the batch build identifiers in descending order
        /// by identifier.</p>
        /// </li>
        /// </ul>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>Specifies the sort order of the returned items. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the batch build identifiers in ascending order by
        /// identifier.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the batch build identifiers in descending order
        /// by identifier.</p>
        /// </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to
        /// <code>ListBuildBatchesForProject</code>. This specifies the next item to return. To return the
        /// beginning of the list, exclude this parameter.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The <code>nextToken</code> value returned from a previous call to
        /// <code>ListBuildBatchesForProject</code>. This specifies the next item to return. To return the
        /// beginning of the list, exclude this parameter.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuilds`.
    ///
    /// <p>Gets a list of build IDs, with each build ID representing a single build.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBuilds<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_builds_input::Builder,
    }
    impl<C, M, R> ListBuilds<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBuilds`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBuildsInputOperationOutputAlias,
                crate::output::ListBuildsOutput,
                crate::error::ListBuildsError,
                crate::input::ListBuildsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The order to list build IDs. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the build IDs in ascending order by build
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the build IDs in descending order by build
        /// ID.</p>
        /// </li>
        /// </ul>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The order to list build IDs. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the build IDs in ascending order by build
        /// ID.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the build IDs in descending order by build
        /// ID.</p>
        /// </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first
        /// 100 items are returned, along with a unique string called a
        /// <i>nextToken</i>. To get the next batch of items in the list, call
        /// this operation again, adding the next token to the call. To get all of the items in the
        /// list, keep calling this operation with each subsequent next token that is returned,
        /// until no more next tokens are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first
        /// 100 items are returned, along with a unique string called a
        /// <i>nextToken</i>. To get the next batch of items in the list, call
        /// this operation again, adding the next token to the call. To get all of the items in the
        /// list, keep calling this operation with each subsequent next token that is returned,
        /// until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBuildsForProject`.
    ///
    /// <p>Gets a list of build identifiers for the specified build project, with each build
    /// identifier representing a single build.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListBuildsForProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_builds_for_project_input::Builder,
    }
    impl<C, M, R> ListBuildsForProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBuildsForProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBuildsForProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBuildsForProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBuildsForProjectInputOperationOutputAlias,
                crate::output::ListBuildsForProjectOutput,
                crate::error::ListBuildsForProjectError,
                crate::input::ListBuildsForProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The order to sort the results in. The results are sorted by build number, not the build
        /// identifier. If this is not specified, the results are sorted in descending order.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the build identifiers in descending order, by build number.</p>
        /// </li>
        /// </ul>
        /// <p>If the project has more than 100 builds, setting the sort order will result in an
        /// error. </p>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The order to sort the results in. The results are sorted by build number, not the build
        /// identifier. If this is not specified, the results are sorted in descending order.</p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List the build identifiers in descending order, by build number.</p>
        /// </li>
        /// </ul>
        /// <p>If the project has more than 100 builds, setting the sort order will result in an
        /// error. </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first
        /// 100 items are returned, along with a unique string called a
        /// <i>nextToken</i>. To get the next batch of items in the list, call
        /// this operation again, adding the next token to the call. To get all of the items in the
        /// list, keep calling this operation with each subsequent next token that is returned,
        /// until no more next tokens are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first
        /// 100 items are returned, along with a unique string called a
        /// <i>nextToken</i>. To get the next batch of items in the list, call
        /// this operation again, adding the next token to the call. To get all of the items in the
        /// list, keep calling this operation with each subsequent next token that is returned,
        /// until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCuratedEnvironmentImages`.
    ///
    /// <p>Gets information about Docker images that are managed by CodeBuild.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCuratedEnvironmentImages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_curated_environment_images_input::Builder,
    }
    impl<C, M, R> ListCuratedEnvironmentImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCuratedEnvironmentImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCuratedEnvironmentImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCuratedEnvironmentImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCuratedEnvironmentImagesInputOperationOutputAlias,
                crate::output::ListCuratedEnvironmentImagesOutput,
                crate::error::ListCuratedEnvironmentImagesError,
                crate::input::ListCuratedEnvironmentImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Gets a list of build project names, with each build project name representing a single
    /// build project.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The criterion to be used to list build project names. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED_TIME</code>: List based on when each build project was
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAST_MODIFIED_TIME</code>: List based on when information about each
        /// build project was last changed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NAME</code>: List based on each build project's name.</p>
        /// </li>
        /// </ul>
        /// <p>Use <code>sortOrder</code> to specify in what order to list the build project names
        /// based on the preceding criteria.</p>
        pub fn sort_by(mut self, inp: crate::model::ProjectSortByType) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The criterion to be used to list build project names. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED_TIME</code>: List based on when each build project was
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAST_MODIFIED_TIME</code>: List based on when information about each
        /// build project was last changed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NAME</code>: List based on each build project's name.</p>
        /// </li>
        /// </ul>
        /// <p>Use <code>sortOrder</code> to specify in what order to list the build project names
        /// based on the preceding criteria.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ProjectSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The order in which to list build projects. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List in ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List in descending order.</p>
        /// </li>
        /// </ul>
        /// <p>Use <code>sortBy</code> to specify the criterion to be used to list build project
        /// names.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The order in which to list build projects. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List in ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List in descending order.</p>
        /// </li>
        /// </ul>
        /// <p>Use <code>sortBy</code> to specify the criterion to be used to list build project
        /// names.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first
        /// 100 items are returned, along with a unique string called a
        /// <i>nextToken</i>. To get the next batch of items in the list, call
        /// this operation again, adding the next token to the call. To get all of the items in the
        /// list, keep calling this operation with each subsequent next token that is returned,
        /// until no more next tokens are returned.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>During a previous call, if there are more than 100 items in the list, only the first
        /// 100 items are returned, along with a unique string called a
        /// <i>nextToken</i>. To get the next batch of items in the list, call
        /// this operation again, adding the next token to the call. To get all of the items in the
        /// list, keep calling this operation with each subsequent next token that is returned,
        /// until no more next tokens are returned.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReportGroups`.
    ///
    /// <p>
    /// Gets a list ARNs for the report groups in the current Amazon Web Services account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListReportGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_report_groups_input::Builder,
    }
    impl<C, M, R> ListReportGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReportGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReportGroupsInputOperationOutputAlias,
                crate::output::ListReportGroupsOutput,
                crate::error::ListReportGroupsError,
                crate::input::ListReportGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Used to specify the order to sort the list of returned report groups. Valid values are
        /// <code>ASCENDING</code> and <code>DESCENDING</code>.
        /// </p>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>
        /// Used to specify the order to sort the list of returned report groups. Valid values are
        /// <code>ASCENDING</code> and <code>DESCENDING</code>.
        /// </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>
        /// The criterion to be used to list build report groups. Valid values include:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED_TIME</code>: List based on when each report group was
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAST_MODIFIED_TIME</code>: List based on when each report group  was last changed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NAME</code>: List based on each report group's name.</p>
        /// </li>
        /// </ul>
        pub fn sort_by(mut self, inp: crate::model::ReportGroupSortByType) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>
        /// The criterion to be used to list build report groups. Valid values include:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATED_TIME</code>: List based on when each report group was
        /// created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LAST_MODIFIED_TIME</code>: List based on when each report group  was last changed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NAME</code>: List based on each report group's name.</p>
        /// </li>
        /// </ul>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::ReportGroupSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// The maximum number of paginated report groups returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>ReportGroup</code> objects. The default value is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of paginated report groups returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>ReportGroup</code> objects. The default value is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReports`.
    ///
    /// <p>
    /// Returns a list of ARNs for the reports in the current Amazon Web Services account.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListReports<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_reports_input::Builder,
    }
    impl<C, M, R> ListReports<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReports`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReportsInputOperationOutputAlias,
                crate::output::ListReportsOutput,
                crate::error::ListReportsError,
                crate::input::ListReportsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// Specifies the sort order for the list of returned reports. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: return reports in chronological order based on their creation date.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: return reports in the reverse chronological order based on their creation date.
        /// </p>
        /// </li>
        /// </ul>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>
        /// Specifies the sort order for the list of returned reports. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: return reports in chronological order based on their creation date.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: return reports in the reverse chronological order based on their creation date.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// The maximum number of paginated reports returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>Report</code> objects. The default value is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of paginated reports returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>Report</code> objects. The default value is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// A <code>ReportFilter</code> object used to filter the returned reports.
        /// </p>
        pub fn filter(mut self, inp: crate::model::ReportFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>
        /// A <code>ReportFilter</code> object used to filter the returned reports.
        /// </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReportFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReportsForReportGroup`.
    ///
    /// <p>
    /// Returns a list of ARNs for the reports that belong to a <code>ReportGroup</code>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListReportsForReportGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_reports_for_report_group_input::Builder,
    }
    impl<C, M, R> ListReportsForReportGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReportsForReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReportsForReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReportsForReportGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReportsForReportGroupInputOperationOutputAlias,
                crate::output::ListReportsForReportGroupOutput,
                crate::error::ListReportsForReportGroupError,
                crate::input::ListReportsForReportGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ARN of the report group for which you want to return report ARNs.
        /// </p>
        pub fn report_group_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_group_arn(inp);
            self
        }
        /// <p>
        /// The ARN of the report group for which you want to return report ARNs.
        /// </p>
        pub fn set_report_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_group_arn(input);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// During a previous call, the maximum number of items that can be returned is the value specified in
        /// <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
        /// is returned. To get the next batch of items in the list, call this operation again, adding the next token
        /// to the call. To get all of the items in the list, keep calling this operation with each
        /// subsequent next token that is returned, until no more next tokens are returned.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>
        /// Use to specify whether the results are returned in ascending or descending order.
        /// </p>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>
        /// Use to specify whether the results are returned in ascending or descending order.
        /// </p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>
        /// The maximum number of paginated reports in this report group returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>Report</code> objects. The default value is 100.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of paginated reports in this report group returned per response. Use <code>nextToken</code> to iterate pages in
        /// the list of returned <code>Report</code> objects. The default value is 100.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// A <code>ReportFilter</code> object used to filter the returned reports.
        /// </p>
        pub fn filter(mut self, inp: crate::model::ReportFilter) -> Self {
            self.inner = self.inner.filter(inp);
            self
        }
        /// <p>
        /// A <code>ReportFilter</code> object used to filter the returned reports.
        /// </p>
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::ReportFilter>,
        ) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSharedProjects`.
    ///
    /// <p> Gets a list of projects that are shared with other Amazon Web Services accounts or users. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListSharedProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_shared_projects_input::Builder,
    }
    impl<C, M, R> ListSharedProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSharedProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSharedProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSharedProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSharedProjectsInputOperationOutputAlias,
                crate::output::ListSharedProjectsOutput,
                crate::error::ListSharedProjectsError,
                crate::input::ListSharedProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The criterion to be used to list build projects shared with the current Amazon Web Services account
        /// or user. Valid values include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ARN</code>: List based on the ARN. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED_TIME</code>: List based on when information about the shared
        /// project was last changed. </p>
        /// </li>
        /// </ul>
        pub fn sort_by(mut self, inp: crate::model::SharedResourceSortByType) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p> The criterion to be used to list build projects shared with the current Amazon Web Services account
        /// or user. Valid values include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ARN</code>: List based on the ARN. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED_TIME</code>: List based on when information about the shared
        /// project was last changed. </p>
        /// </li>
        /// </ul>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SharedResourceSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The order in which to list shared build projects. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List in ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List in descending order.</p>
        /// </li>
        /// </ul>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The order in which to list shared build projects. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List in ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List in descending order.</p>
        /// </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> The maximum number of paginated shared build projects returned per response. Use
        /// <code>nextToken</code> to iterate pages in the list of returned <code>Project</code>
        /// objects. The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of paginated shared build projects returned per response. Use
        /// <code>nextToken</code> to iterate pages in the list of returned <code>Project</code>
        /// objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSharedReportGroups`.
    ///
    /// <p> Gets a list of report groups that are shared with other Amazon Web Services accounts or users.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListSharedReportGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_shared_report_groups_input::Builder,
    }
    impl<C, M, R> ListSharedReportGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSharedReportGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSharedReportGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSharedReportGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSharedReportGroupsInputOperationOutputAlias,
                crate::output::ListSharedReportGroupsOutput,
                crate::error::ListSharedReportGroupsError,
                crate::input::ListSharedReportGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The order in which to list shared report groups. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List in ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List in descending order.</p>
        /// </li>
        /// </ul>
        pub fn sort_order(mut self, inp: crate::model::SortOrderType) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The order in which to list shared report groups. Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ASCENDING</code>: List in ascending order.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DESCENDING</code>: List in descending order.</p>
        /// </li>
        /// </ul>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrderType>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p> The criterion to be used to list report groups shared with the current Amazon Web Services account or
        /// user. Valid values include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ARN</code>: List based on the ARN. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED_TIME</code>: List based on when information about the shared
        /// report group was last changed. </p>
        /// </li>
        /// </ul>
        pub fn sort_by(mut self, inp: crate::model::SharedResourceSortByType) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p> The criterion to be used to list report groups shared with the current Amazon Web Services account or
        /// user. Valid values include: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ARN</code>: List based on the ARN. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MODIFIED_TIME</code>: List based on when information about the shared
        /// report group was last changed. </p>
        /// </li>
        /// </ul>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SharedResourceSortByType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p> During a previous call, the maximum number of items that can be returned is the value
        /// specified in <code>maxResults</code>. If there more items in the list, then a unique
        /// string called a <i>nextToken</i> is returned. To get the next batch of
        /// items in the list, call this operation again, adding the next token to the call. To get
        /// all of the items in the list, keep calling this operation with each subsequent next
        /// token that is returned, until no more next tokens are returned. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of paginated shared report groups per response. Use
        /// <code>nextToken</code> to iterate pages in the list of returned
        /// <code>ReportGroup</code> objects. The default value is 100. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p> The maximum number of paginated shared report groups per response. Use
        /// <code>nextToken</code> to iterate pages in the list of returned
        /// <code>ReportGroup</code> objects. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSourceCredentials`.
    ///
    /// <p> Returns a list of <code>SourceCredentialsInfo</code> objects. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListSourceCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_source_credentials_input::Builder,
    }
    impl<C, M, R> ListSourceCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSourceCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSourceCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSourceCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSourceCredentialsInputOperationOutputAlias,
                crate::output::ListSourceCredentialsOutput,
                crate::error::ListSourceCredentialsError,
                crate::input::ListSourceCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p> Stores a resource policy for the ARN of a <code>Project</code> or
    /// <code>ReportGroup</code> object. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutResourcePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl<C, M, R> PutResourcePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutResourcePolicyInputOperationOutputAlias,
                crate::output::PutResourcePolicyOutput,
                crate::error::PutResourcePolicyError,
                crate::input::PutResourcePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A JSON-formatted resource policy. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share">Sharing
        /// a Project</a> and <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share">Sharing a Report Group</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn policy(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// <p> A JSON-formatted resource policy. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/project-sharing.html#project-sharing-share">Sharing
        /// a Project</a> and <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/report-groups-sharing.html#report-groups-sharing-share">Sharing a Report Group</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
        /// <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource you want to
        /// associate with a resource policy. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p> The ARN of the <code>Project</code> or <code>ReportGroup</code> resource you want to
        /// associate with a resource policy. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryBuild`.
    ///
    /// <p>Restarts a build.</p>
    #[derive(std::fmt::Debug)]
    pub struct RetryBuild<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retry_build_input::Builder,
    }
    impl<C, M, R> RetryBuild<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetryBuild`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryBuildOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryBuildError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetryBuildInputOperationOutputAlias,
                crate::output::RetryBuildOutput,
                crate::error::RetryBuildError,
                crate::input::RetryBuildInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the identifier of the build to restart.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>Specifies the identifier of the build to restart.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// <code>RetryBuild</code> request. The token is included in the
        /// <code>RetryBuild</code> request and is valid for five minutes. If you repeat
        /// the <code>RetryBuild</code> request with the same token, but change a parameter,
        /// CodeBuild returns a parameter mismatch error.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// <code>RetryBuild</code> request. The token is included in the
        /// <code>RetryBuild</code> request and is valid for five minutes. If you repeat
        /// the <code>RetryBuild</code> request with the same token, but change a parameter,
        /// CodeBuild returns a parameter mismatch error.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RetryBuildBatch`.
    ///
    /// <p>Restarts a failed batch build. Only batch builds that have failed can be retried.</p>
    #[derive(std::fmt::Debug)]
    pub struct RetryBuildBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::retry_build_batch_input::Builder,
    }
    impl<C, M, R> RetryBuildBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RetryBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RetryBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::RetryBuildBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RetryBuildBatchInputOperationOutputAlias,
                crate::output::RetryBuildBatchOutput,
                crate::error::RetryBuildBatchError,
                crate::input::RetryBuildBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies the identifier of the batch build to restart.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>Specifies the identifier of the batch build to restart.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// <code>RetryBuildBatch</code> request. The token is included in the
        /// <code>RetryBuildBatch</code> request and is valid for five minutes. If you repeat
        /// the <code>RetryBuildBatch</code> request with the same token, but change a parameter,
        /// CodeBuild returns a parameter mismatch error.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// <code>RetryBuildBatch</code> request. The token is included in the
        /// <code>RetryBuildBatch</code> request and is valid for five minutes. If you repeat
        /// the <code>RetryBuildBatch</code> request with the same token, but change a parameter,
        /// CodeBuild returns a parameter mismatch error.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>Specifies the type of retry to perform.</p>
        pub fn retry_type(mut self, inp: crate::model::RetryBuildBatchType) -> Self {
            self.inner = self.inner.retry_type(inp);
            self
        }
        /// <p>Specifies the type of retry to perform.</p>
        pub fn set_retry_type(
            mut self,
            input: std::option::Option<crate::model::RetryBuildBatchType>,
        ) -> Self {
            self.inner = self.inner.set_retry_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBuild`.
    ///
    /// <p>Starts running a build.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartBuild<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_build_input::Builder,
    }
    impl<C, M, R> StartBuild<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBuild`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBuildOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBuildError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartBuildInputOperationOutputAlias,
                crate::output::StartBuildOutput,
                crate::error::StartBuildError,
                crate::input::StartBuildInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild build project to start running a build.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the CodeBuild build project to start running a build.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// Appends an item to `secondarySourcesOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_override`](Self::set_secondary_sources_override).
        ///
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources_override(
            mut self,
            inp: impl Into<crate::model::ProjectSource>,
        ) -> Self {
            self.inner = self.inner.secondary_sources_override(inp);
            self
        }
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_override(input);
            self
        }
        /// Appends an item to `secondarySourcesVersionOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_version_override`](Self::set_secondary_sources_version_override).
        ///
        /// <p> An array of <code>ProjectSourceVersion</code> objects that specify one or more
        /// versions of the project's secondary sources to be used for this build only. </p>
        pub fn secondary_sources_version_override(
            mut self,
            inp: impl Into<crate::model::ProjectSourceVersion>,
        ) -> Self {
            self.inner = self.inner.secondary_sources_version_override(inp);
            self
        }
        /// <p> An array of <code>ProjectSourceVersion</code> objects that specify one or more
        /// versions of the project's secondary sources to be used for this build only. </p>
        pub fn set_secondary_sources_version_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_version_override(input);
            self
        }
        /// <p>The version of the build input to be built, for this build only. If not specified,
        /// the latest version is used. If specified, the contents depends on the source
        /// provider:</p>
        /// <dl>
        /// <dt>CodeCommit</dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>GitHub</dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds
        /// to the version of the source code you want to build. If a pull request ID is
        /// specified, it must use the format <code>pr/pull-request-ID</code> (for
        /// example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit
        /// ID is used.</p>
        /// </dd>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of
        /// the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </dd>
        /// <dt>Amazon S3</dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to
        /// use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this
        /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(inp);
            self
        }
        /// <p>The version of the build input to be built, for this build only. If not specified,
        /// the latest version is used. If specified, the contents depends on the source
        /// provider:</p>
        /// <dl>
        /// <dt>CodeCommit</dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>GitHub</dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds
        /// to the version of the source code you want to build. If a pull request ID is
        /// specified, it must use the format <code>pr/pull-request-ID</code> (for
        /// example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit
        /// ID is used.</p>
        /// </dd>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of
        /// the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </dd>
        /// <dt>Amazon S3</dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to
        /// use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this
        /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// <p>Build output artifact settings that override, for this build only, the latest ones
        /// already defined in the build project.</p>
        pub fn artifacts_override(mut self, inp: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts_override(inp);
            self
        }
        /// <p>Build output artifact settings that override, for this build only, the latest ones
        /// already defined in the build project.</p>
        pub fn set_artifacts_override(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts_override(input);
            self
        }
        /// Appends an item to `secondaryArtifactsOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts_override`](Self::set_secondary_artifacts_override).
        ///
        /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn secondary_artifacts_override(
            mut self,
            inp: impl Into<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.secondary_artifacts_override(inp);
            self
        }
        /// <p> An array of <code>ProjectArtifacts</code> objects. </p>
        pub fn set_secondary_artifacts_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts_override(input);
            self
        }
        /// Appends an item to `environmentVariablesOverride`.
        ///
        /// To override the contents of this collection use [`set_environment_variables_override`](Self::set_environment_variables_override).
        ///
        /// <p>A set of environment variables that overrides, for this build only, the latest ones
        /// already defined in the build project.</p>
        pub fn environment_variables_override(
            mut self,
            inp: impl Into<crate::model::EnvironmentVariable>,
        ) -> Self {
            self.inner = self.inner.environment_variables_override(inp);
            self
        }
        /// <p>A set of environment variables that overrides, for this build only, the latest ones
        /// already defined in the build project.</p>
        pub fn set_environment_variables_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.inner = self.inner.set_environment_variables_override(input);
            self
        }
        /// <p>A source input type, for this build, that overrides the source input defined in the
        /// build project.</p>
        pub fn source_type_override(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type_override(inp);
            self
        }
        /// <p>A source input type, for this build, that overrides the source input defined in the
        /// build project.</p>
        pub fn set_source_type_override(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type_override(input);
            self
        }
        /// <p>A location that overrides, for this build, the source location for the one defined in
        /// the build project.</p>
        pub fn source_location_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_location_override(inp);
            self
        }
        /// <p>A location that overrides, for this build, the source location for the one defined in
        /// the build project.</p>
        pub fn set_source_location_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_location_override(input);
            self
        }
        /// <p>An authorization type for this build that overrides the one defined in the build
        /// project. This override applies only if the build project's source is BitBucket or
        /// GitHub.</p>
        pub fn source_auth_override(mut self, inp: crate::model::SourceAuth) -> Self {
            self.inner = self.inner.source_auth_override(inp);
            self
        }
        /// <p>An authorization type for this build that overrides the one defined in the build
        /// project. This override applies only if the build project's source is BitBucket or
        /// GitHub.</p>
        pub fn set_source_auth_override(
            mut self,
            input: std::option::Option<crate::model::SourceAuth>,
        ) -> Self {
            self.inner = self.inner.set_source_auth_override(input);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this
        /// build only, any previous depth of history defined in the build project.</p>
        pub fn git_clone_depth_override(mut self, inp: i32) -> Self {
            self.inner = self.inner.git_clone_depth_override(inp);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this
        /// build only, any previous depth of history defined in the build project.</p>
        pub fn set_git_clone_depth_override(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_git_clone_depth_override(input);
            self
        }
        /// <p> Information about the Git submodules configuration for this build of an CodeBuild build
        /// project. </p>
        pub fn git_submodules_config_override(
            mut self,
            inp: crate::model::GitSubmodulesConfig,
        ) -> Self {
            self.inner = self.inner.git_submodules_config_override(inp);
            self
        }
        /// <p> Information about the Git submodules configuration for this build of an CodeBuild build
        /// project. </p>
        pub fn set_git_submodules_config_override(
            mut self,
            input: std::option::Option<crate::model::GitSubmodulesConfig>,
        ) -> Self {
            self.inner = self.inner.set_git_submodules_config_override(input);
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one
        /// already defined in the build project.</p>
        /// <p> If this value is set, it can be either an inline buildspec definition, the path to an
        /// alternate buildspec file relative to the value of the built-in
        /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
        /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
        /// file using its ARN (for example,
        /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
        /// provided or is set to an empty string, the source code must contain a buildspec file in
        /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn buildspec_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.buildspec_override(inp);
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one
        /// already defined in the build project.</p>
        /// <p> If this value is set, it can be either an inline buildspec definition, the path to an
        /// alternate buildspec file relative to the value of the built-in
        /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
        /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
        /// file using its ARN (for example,
        /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
        /// provided or is set to an empty string, the source code must contain a buildspec file in
        /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn set_buildspec_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_buildspec_override(input);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the build
        /// project. The insecure SSL setting determines whether to ignore SSL warnings while
        /// connecting to the project source code. This override applies only if the build's source
        /// is GitHub Enterprise.</p>
        pub fn insecure_ssl_override(mut self, inp: bool) -> Self {
            self.inner = self.inner.insecure_ssl_override(inp);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the build
        /// project. The insecure SSL setting determines whether to ignore SSL warnings while
        /// connecting to the project source code. This override applies only if the build's source
        /// is GitHub Enterprise.</p>
        pub fn set_insecure_ssl_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_insecure_ssl_override(input);
            self
        }
        /// <p> Set to true to report to your source provider the status of a build's start and
        /// completion. If you use this option with a source provider other than GitHub, GitHub
        /// Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p>
        /// <p>To be able to report the build status to the source provider, the user associated with the source provider must
        /// have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p>
        /// <note>
        /// <p> The status of a build triggered by a webhook is always reported to your source
        /// provider. </p>
        /// </note>
        pub fn report_build_status_override(mut self, inp: bool) -> Self {
            self.inner = self.inner.report_build_status_override(inp);
            self
        }
        /// <p> Set to true to report to your source provider the status of a build's start and
        /// completion. If you use this option with a source provider other than GitHub, GitHub
        /// Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p>
        /// <p>To be able to report the build status to the source provider, the user associated with the source provider must
        /// have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html">Source provider access</a> in the <i>CodeBuild User Guide</i>.</p>
        /// <note>
        /// <p> The status of a build triggered by a webhook is always reported to your source
        /// provider. </p>
        /// </note>
        pub fn set_report_build_status_override(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_report_build_status_override(input);
            self
        }
        /// <p>Contains information that defines how the build project reports the build status to
        /// the source provider. This option is only used when the source provider is
        /// <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
        /// <code>BITBUCKET</code>.</p>
        pub fn build_status_config_override(
            mut self,
            inp: crate::model::BuildStatusConfig,
        ) -> Self {
            self.inner = self.inner.build_status_config_override(inp);
            self
        }
        /// <p>Contains information that defines how the build project reports the build status to
        /// the source provider. This option is only used when the source provider is
        /// <code>GITHUB</code>, <code>GITHUB_ENTERPRISE</code>, or
        /// <code>BITBUCKET</code>.</p>
        pub fn set_build_status_config_override(
            mut self,
            input: std::option::Option<crate::model::BuildStatusConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_status_config_override(input);
            self
        }
        /// <p>A container type for this build that overrides the one specified in the build
        /// project.</p>
        pub fn environment_type_override(mut self, inp: crate::model::EnvironmentType) -> Self {
            self.inner = self.inner.environment_type_override(inp);
            self
        }
        /// <p>A container type for this build that overrides the one specified in the build
        /// project.</p>
        pub fn set_environment_type_override(
            mut self,
            input: std::option::Option<crate::model::EnvironmentType>,
        ) -> Self {
            self.inner = self.inner.set_environment_type_override(input);
            self
        }
        /// <p>The name of an image for this build that overrides the one specified in the build
        /// project.</p>
        pub fn image_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_override(inp);
            self
        }
        /// <p>The name of an image for this build that overrides the one specified in the build
        /// project.</p>
        pub fn set_image_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_override(input);
            self
        }
        /// <p>The name of a compute type for this build that overrides the one specified in the
        /// build project.</p>
        pub fn compute_type_override(mut self, inp: crate::model::ComputeType) -> Self {
            self.inner = self.inner.compute_type_override(inp);
            self
        }
        /// <p>The name of a compute type for this build that overrides the one specified in the
        /// build project.</p>
        pub fn set_compute_type_override(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.inner = self.inner.set_compute_type_override(input);
            self
        }
        /// <p>The name of a certificate for this build that overrides the one specified in the build
        /// project.</p>
        pub fn certificate_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_override(inp);
            self
        }
        /// <p>The name of a certificate for this build that overrides the one specified in the build
        /// project.</p>
        pub fn set_certificate_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_override(input);
            self
        }
        /// <p>A ProjectCache object specified for this build that overrides the one defined in the
        /// build project.</p>
        pub fn cache_override(mut self, inp: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache_override(inp);
            self
        }
        /// <p>A ProjectCache object specified for this build that overrides the one defined in the
        /// build project.</p>
        pub fn set_cache_override(
            mut self,
            input: std::option::Option<crate::model::ProjectCache>,
        ) -> Self {
            self.inner = self.inner.set_cache_override(input);
            self
        }
        /// <p>The name of a service role for this build that overrides the one specified in the
        /// build project.</p>
        pub fn service_role_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_override(inp);
            self
        }
        /// <p>The name of a service role for this build that overrides the one specified in the
        /// build project.</p>
        pub fn set_service_role_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_override(input);
            self
        }
        /// <p>Enable this flag to override privileged mode in the build project.</p>
        pub fn privileged_mode_override(mut self, inp: bool) -> Self {
            self.inner = self.inner.privileged_mode_override(inp);
            self
        }
        /// <p>Enable this flag to override privileged mode in the build project.</p>
        pub fn set_privileged_mode_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_privileged_mode_override(input);
            self
        }
        /// <p>The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this
        /// build only, the latest setting already defined in the build project.</p>
        pub fn timeout_in_minutes_override(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout_in_minutes_override(inp);
            self
        }
        /// <p>The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this
        /// build only, the latest setting already defined in the build project.</p>
        pub fn set_timeout_in_minutes_override(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_minutes_override(input);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes_override(mut self, inp: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes_override(inp);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes_override(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes_override(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the build
        /// project. The CMK key encrypts the build output artifacts.</p>
        /// <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn encryption_key_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_override(inp);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the build
        /// project. The CMK key encrypts the build output artifacts.</p>
        /// <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn set_encryption_key_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_override(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// StartBuild request. The token is included in the StartBuild request and is valid for 5
        /// minutes. If you repeat the StartBuild request with the same token, but change a
        /// parameter, CodeBuild returns a parameter mismatch error. </p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// StartBuild request. The token is included in the StartBuild request and is valid for 5
        /// minutes. If you repeat the StartBuild request with the same token, but change a
        /// parameter, CodeBuild returns a parameter mismatch error. </p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p> Log settings for this build that override the log settings defined in the build
        /// project. </p>
        pub fn logs_config_override(mut self, inp: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config_override(inp);
            self
        }
        /// <p> Log settings for this build that override the log settings defined in the build
        /// project. </p>
        pub fn set_logs_config_override(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config_override(input);
            self
        }
        /// <p> The credentials for access to a private registry. </p>
        pub fn registry_credential_override(
            mut self,
            inp: crate::model::RegistryCredential,
        ) -> Self {
            self.inner = self.inner.registry_credential_override(inp);
            self
        }
        /// <p> The credentials for access to a private registry. </p>
        pub fn set_registry_credential_override(
            mut self,
            input: std::option::Option<crate::model::RegistryCredential>,
        ) -> Self {
            self.inner = self.inner.set_registry_credential_override(input);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your build. There are two valid
        /// values: </p>
        /// <dl>
        /// <dt>CODEBUILD</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you
        /// modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>SERVICE_ROLE</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use
        /// <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image,
        /// you must use <code>CODEBUILD</code> credentials. </p>
        pub fn image_pull_credentials_type_override(
            mut self,
            inp: crate::model::ImagePullCredentialsType,
        ) -> Self {
            self.inner = self.inner.image_pull_credentials_type_override(inp);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your build. There are two valid
        /// values: </p>
        /// <dl>
        /// <dt>CODEBUILD</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you
        /// modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>SERVICE_ROLE</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use
        /// <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image,
        /// you must use <code>CODEBUILD</code> credentials. </p>
        pub fn set_image_pull_credentials_type_override(
            mut self,
            input: std::option::Option<crate::model::ImagePullCredentialsType>,
        ) -> Self {
            self.inner = self.inner.set_image_pull_credentials_type_override(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this build. For more information, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>.</p>
        pub fn debug_session_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.debug_session_enabled(inp);
            self
        }
        /// <p>Specifies if session debugging is enabled for this build. For more information, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>.</p>
        pub fn set_debug_session_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_debug_session_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartBuildBatch`.
    ///
    /// <p>Starts a batch build for a project.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartBuildBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_build_batch_input::Builder,
    }
    impl<C, M, R> StartBuildBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::StartBuildBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartBuildBatchInputOperationOutputAlias,
                crate::output::StartBuildBatchOutput,
                crate::error::StartBuildBatchError,
                crate::input::StartBuildBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// Appends an item to `secondarySourcesOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_override`](Self::set_secondary_sources_override).
        ///
        /// <p>An array of <code>ProjectSource</code> objects that override the secondary sources
        /// defined in the batch build project.</p>
        pub fn secondary_sources_override(
            mut self,
            inp: impl Into<crate::model::ProjectSource>,
        ) -> Self {
            self.inner = self.inner.secondary_sources_override(inp);
            self
        }
        /// <p>An array of <code>ProjectSource</code> objects that override the secondary sources
        /// defined in the batch build project.</p>
        pub fn set_secondary_sources_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_override(input);
            self
        }
        /// Appends an item to `secondarySourcesVersionOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources_version_override`](Self::set_secondary_sources_version_override).
        ///
        /// <p>An array of <code>ProjectSourceVersion</code> objects that override the secondary source
        /// versions in the batch build project.</p>
        pub fn secondary_sources_version_override(
            mut self,
            inp: impl Into<crate::model::ProjectSourceVersion>,
        ) -> Self {
            self.inner = self.inner.secondary_sources_version_override(inp);
            self
        }
        /// <p>An array of <code>ProjectSourceVersion</code> objects that override the secondary source
        /// versions in the batch build project.</p>
        pub fn set_secondary_sources_version_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources_version_override(input);
            self
        }
        /// <p>The version of the batch build input to be built, for this build only. If not specified,
        /// the latest version is used. If specified, the contents depends on the source
        /// provider:</p>
        /// <dl>
        /// <dt>CodeCommit</dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>GitHub</dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds
        /// to the version of the source code you want to build. If a pull request ID is
        /// specified, it must use the format <code>pr/pull-request-ID</code> (for
        /// example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit
        /// ID is used.</p>
        /// </dd>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of
        /// the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </dd>
        /// <dt>Amazon S3</dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to
        /// use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this
        /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn source_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(inp);
            self
        }
        /// <p>The version of the batch build input to be built, for this build only. If not specified,
        /// the latest version is used. If specified, the contents depends on the source
        /// provider:</p>
        /// <dl>
        /// <dt>CodeCommit</dt>
        /// <dd>
        /// <p>The commit ID, branch, or Git tag to use.</p>
        /// </dd>
        /// <dt>GitHub</dt>
        /// <dd>
        /// <p>The commit ID, pull request ID, branch name, or tag name that corresponds
        /// to the version of the source code you want to build. If a pull request ID is
        /// specified, it must use the format <code>pr/pull-request-ID</code> (for
        /// example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit
        /// ID is used.</p>
        /// </dd>
        /// <dt>Bitbucket</dt>
        /// <dd>
        /// <p>The commit ID, branch name, or tag name that corresponds to the version of
        /// the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </dd>
        /// <dt>Amazon S3</dt>
        /// <dd>
        /// <p>The version ID of the object that represents the build input ZIP file to
        /// use.</p>
        /// </dd>
        /// </dl>
        /// <p>If <code>sourceVersion</code> is specified at the project level, then this
        /// <code>sourceVersion</code> (at the build level) takes precedence. </p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>. </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects that contains information about the
        /// build output artifact overrides for the build project.</p>
        pub fn artifacts_override(mut self, inp: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts_override(inp);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects that contains information about the
        /// build output artifact overrides for the build project.</p>
        pub fn set_artifacts_override(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts_override(input);
            self
        }
        /// Appends an item to `secondaryArtifactsOverride`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts_override`](Self::set_secondary_artifacts_override).
        ///
        /// <p>An array of <code>ProjectArtifacts</code> objects that override the secondary artifacts
        /// defined in the batch build project.</p>
        pub fn secondary_artifacts_override(
            mut self,
            inp: impl Into<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.secondary_artifacts_override(inp);
            self
        }
        /// <p>An array of <code>ProjectArtifacts</code> objects that override the secondary artifacts
        /// defined in the batch build project.</p>
        pub fn set_secondary_artifacts_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts_override(input);
            self
        }
        /// Appends an item to `environmentVariablesOverride`.
        ///
        /// To override the contents of this collection use [`set_environment_variables_override`](Self::set_environment_variables_override).
        ///
        /// <p>An array of <code>EnvironmentVariable</code> objects that override, or add to, the
        /// environment variables defined in the batch build project.</p>
        pub fn environment_variables_override(
            mut self,
            inp: impl Into<crate::model::EnvironmentVariable>,
        ) -> Self {
            self.inner = self.inner.environment_variables_override(inp);
            self
        }
        /// <p>An array of <code>EnvironmentVariable</code> objects that override, or add to, the
        /// environment variables defined in the batch build project.</p>
        pub fn set_environment_variables_override(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EnvironmentVariable>>,
        ) -> Self {
            self.inner = self.inner.set_environment_variables_override(input);
            self
        }
        /// <p>The source input type that overrides the source input defined in the batch
        /// build project.</p>
        pub fn source_type_override(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type_override(inp);
            self
        }
        /// <p>The source input type that overrides the source input defined in the batch
        /// build project.</p>
        pub fn set_source_type_override(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type_override(input);
            self
        }
        /// <p>A location that overrides, for this batch build, the source location defined in
        /// the batch build project.</p>
        pub fn source_location_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_location_override(inp);
            self
        }
        /// <p>A location that overrides, for this batch build, the source location defined in
        /// the batch build project.</p>
        pub fn set_source_location_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_location_override(input);
            self
        }
        /// <p>A <code>SourceAuth</code> object that overrides the one defined in the batch build
        /// project. This override applies only if the build project's source is BitBucket or
        /// GitHub.</p>
        pub fn source_auth_override(mut self, inp: crate::model::SourceAuth) -> Self {
            self.inner = self.inner.source_auth_override(inp);
            self
        }
        /// <p>A <code>SourceAuth</code> object that overrides the one defined in the batch build
        /// project. This override applies only if the build project's source is BitBucket or
        /// GitHub.</p>
        pub fn set_source_auth_override(
            mut self,
            input: std::option::Option<crate::model::SourceAuth>,
        ) -> Self {
            self.inner = self.inner.set_source_auth_override(input);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this
        /// batch build only, any previous depth of history defined in the batch build project.</p>
        pub fn git_clone_depth_override(mut self, inp: i32) -> Self {
            self.inner = self.inner.git_clone_depth_override(inp);
            self
        }
        /// <p>The user-defined depth of history, with a minimum value of 0, that overrides, for this
        /// batch build only, any previous depth of history defined in the batch build project.</p>
        pub fn set_git_clone_depth_override(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_git_clone_depth_override(input);
            self
        }
        /// <p>A <code>GitSubmodulesConfig</code> object that overrides the Git submodules configuration
        /// for this batch build.</p>
        pub fn git_submodules_config_override(
            mut self,
            inp: crate::model::GitSubmodulesConfig,
        ) -> Self {
            self.inner = self.inner.git_submodules_config_override(inp);
            self
        }
        /// <p>A <code>GitSubmodulesConfig</code> object that overrides the Git submodules configuration
        /// for this batch build.</p>
        pub fn set_git_submodules_config_override(
            mut self,
            input: std::option::Option<crate::model::GitSubmodulesConfig>,
        ) -> Self {
            self.inner = self.inner.set_git_submodules_config_override(input);
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one
        /// already defined in the build project.</p>
        /// <p>If this value is set, it can be either an inline buildspec definition, the path to an
        /// alternate buildspec file relative to the value of the built-in
        /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
        /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
        /// file using its ARN (for example,
        /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
        /// provided or is set to an empty string, the source code must contain a buildspec file in
        /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn buildspec_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.buildspec_override(inp);
            self
        }
        /// <p>A buildspec file declaration that overrides, for this build only, the latest one
        /// already defined in the build project.</p>
        /// <p>If this value is set, it can be either an inline buildspec definition, the path to an
        /// alternate buildspec file relative to the value of the built-in
        /// <code>CODEBUILD_SRC_DIR</code> environment variable, or the path to an S3 bucket.
        /// The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec
        /// file using its ARN (for example,
        /// <code>arn:aws:s3:::my-codebuild-sample2/buildspec.yml</code>). If this value is not
        /// provided or is set to an empty string, the source code must contain a buildspec file in
        /// its root directory. For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage">Buildspec File Name and Storage Location</a>. </p>
        pub fn set_buildspec_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_buildspec_override(input);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the batch build
        /// project. The insecure SSL setting determines whether to ignore SSL warnings while
        /// connecting to the project source code. This override applies only if the build's source
        /// is GitHub Enterprise.</p>
        pub fn insecure_ssl_override(mut self, inp: bool) -> Self {
            self.inner = self.inner.insecure_ssl_override(inp);
            self
        }
        /// <p>Enable this flag to override the insecure SSL setting that is specified in the batch build
        /// project. The insecure SSL setting determines whether to ignore SSL warnings while
        /// connecting to the project source code. This override applies only if the build's source
        /// is GitHub Enterprise.</p>
        pub fn set_insecure_ssl_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_insecure_ssl_override(input);
            self
        }
        /// <p>Set to <code>true</code> to report to your source provider the status of a batch build's
        /// start and completion. If you use this option with a source provider other than GitHub,
        /// GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p>
        /// <note>
        /// <p>The status of a build triggered by a webhook is always reported to your source
        /// provider. </p>
        /// </note>
        pub fn report_build_batch_status_override(mut self, inp: bool) -> Self {
            self.inner = self.inner.report_build_batch_status_override(inp);
            self
        }
        /// <p>Set to <code>true</code> to report to your source provider the status of a batch build's
        /// start and completion. If you use this option with a source provider other than GitHub,
        /// GitHub Enterprise, or Bitbucket, an <code>invalidInputException</code> is thrown. </p>
        /// <note>
        /// <p>The status of a build triggered by a webhook is always reported to your source
        /// provider. </p>
        /// </note>
        pub fn set_report_build_batch_status_override(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_report_build_batch_status_override(input);
            self
        }
        /// <p>A container type for this batch build that overrides the one specified in the batch build
        /// project.</p>
        pub fn environment_type_override(mut self, inp: crate::model::EnvironmentType) -> Self {
            self.inner = self.inner.environment_type_override(inp);
            self
        }
        /// <p>A container type for this batch build that overrides the one specified in the batch build
        /// project.</p>
        pub fn set_environment_type_override(
            mut self,
            input: std::option::Option<crate::model::EnvironmentType>,
        ) -> Self {
            self.inner = self.inner.set_environment_type_override(input);
            self
        }
        /// <p>The name of an image for this batch build that overrides the one specified in the batch
        /// build project.</p>
        pub fn image_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image_override(inp);
            self
        }
        /// <p>The name of an image for this batch build that overrides the one specified in the batch
        /// build project.</p>
        pub fn set_image_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_image_override(input);
            self
        }
        /// <p>The name of a compute type for this batch build that overrides the one specified in the
        /// batch build project.</p>
        pub fn compute_type_override(mut self, inp: crate::model::ComputeType) -> Self {
            self.inner = self.inner.compute_type_override(inp);
            self
        }
        /// <p>The name of a compute type for this batch build that overrides the one specified in the
        /// batch build project.</p>
        pub fn set_compute_type_override(
            mut self,
            input: std::option::Option<crate::model::ComputeType>,
        ) -> Self {
            self.inner = self.inner.set_compute_type_override(input);
            self
        }
        /// <p>The name of a certificate for this batch build that overrides the one specified in the batch build
        /// project.</p>
        pub fn certificate_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_override(inp);
            self
        }
        /// <p>The name of a certificate for this batch build that overrides the one specified in the batch build
        /// project.</p>
        pub fn set_certificate_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_override(input);
            self
        }
        /// <p>A <code>ProjectCache</code> object that specifies cache overrides.</p>
        pub fn cache_override(mut self, inp: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache_override(inp);
            self
        }
        /// <p>A <code>ProjectCache</code> object that specifies cache overrides.</p>
        pub fn set_cache_override(
            mut self,
            input: std::option::Option<crate::model::ProjectCache>,
        ) -> Self {
            self.inner = self.inner.set_cache_override(input);
            self
        }
        /// <p>The name of a service role for this batch build that overrides the one specified in the
        /// batch build project.</p>
        pub fn service_role_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role_override(inp);
            self
        }
        /// <p>The name of a service role for this batch build that overrides the one specified in the
        /// batch build project.</p>
        pub fn set_service_role_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_role_override(input);
            self
        }
        /// <p>Enable this flag to override privileged mode in the batch build project.</p>
        pub fn privileged_mode_override(mut self, inp: bool) -> Self {
            self.inner = self.inner.privileged_mode_override(inp);
            self
        }
        /// <p>Enable this flag to override privileged mode in the batch build project.</p>
        pub fn set_privileged_mode_override(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_privileged_mode_override(input);
            self
        }
        /// <p>Overrides the build timeout specified in the batch build project.</p>
        pub fn build_timeout_in_minutes_override(mut self, inp: i32) -> Self {
            self.inner = self.inner.build_timeout_in_minutes_override(inp);
            self
        }
        /// <p>Overrides the build timeout specified in the batch build project.</p>
        pub fn set_build_timeout_in_minutes_override(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_build_timeout_in_minutes_override(input);
            self
        }
        /// <p>The number of minutes a batch build is allowed to be queued before it times out.</p>
        pub fn queued_timeout_in_minutes_override(mut self, inp: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes_override(inp);
            self
        }
        /// <p>The number of minutes a batch build is allowed to be queued before it times out.</p>
        pub fn set_queued_timeout_in_minutes_override(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes_override(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the batch build
        /// project. The CMK key encrypts the build output artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn encryption_key_override(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key_override(inp);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) that overrides the one specified in the batch build
        /// project. The CMK key encrypts the build output artifacts.</p>
        /// <note>
        /// <p>You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).</p>
        pub fn set_encryption_key_override(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key_override(input);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// <code>StartBuildBatch</code> request. The token is included in the
        /// <code>StartBuildBatch</code> request and is valid for five minutes. If you repeat
        /// the <code>StartBuildBatch</code> request with the same token, but change a parameter,
        /// CodeBuild returns a parameter mismatch error.</p>
        pub fn idempotency_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.idempotency_token(inp);
            self
        }
        /// <p>A unique, case sensitive identifier you provide to ensure the idempotency of the
        /// <code>StartBuildBatch</code> request. The token is included in the
        /// <code>StartBuildBatch</code> request and is valid for five minutes. If you repeat
        /// the <code>StartBuildBatch</code> request with the same token, but change a parameter,
        /// CodeBuild returns a parameter mismatch error.</p>
        pub fn set_idempotency_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_idempotency_token(input);
            self
        }
        /// <p>A <code>LogsConfig</code> object that override the log settings defined in the batch build
        /// project.</p>
        pub fn logs_config_override(mut self, inp: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config_override(inp);
            self
        }
        /// <p>A <code>LogsConfig</code> object that override the log settings defined in the batch build
        /// project.</p>
        pub fn set_logs_config_override(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config_override(input);
            self
        }
        /// <p>A <code>RegistryCredential</code> object that overrides credentials for access to a
        /// private registry.</p>
        pub fn registry_credential_override(
            mut self,
            inp: crate::model::RegistryCredential,
        ) -> Self {
            self.inner = self.inner.registry_credential_override(inp);
            self
        }
        /// <p>A <code>RegistryCredential</code> object that overrides credentials for access to a
        /// private registry.</p>
        pub fn set_registry_credential_override(
            mut self,
            input: std::option::Option<crate::model::RegistryCredential>,
        ) -> Self {
            self.inner = self.inner.set_registry_credential_override(input);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your batch build. There are two valid
        /// values: </p>
        /// <dl>
        /// <dt>CODEBUILD</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you
        /// modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>SERVICE_ROLE</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use
        /// <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image,
        /// you must use <code>CODEBUILD</code> credentials. </p>
        pub fn image_pull_credentials_type_override(
            mut self,
            inp: crate::model::ImagePullCredentialsType,
        ) -> Self {
            self.inner = self.inner.image_pull_credentials_type_override(inp);
            self
        }
        /// <p>The type of credentials CodeBuild uses to pull images in your batch build. There are two valid
        /// values: </p>
        /// <dl>
        /// <dt>CODEBUILD</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses its own credentials. This requires that you
        /// modify your ECR repository policy to trust CodeBuild's service principal.</p>
        /// </dd>
        /// <dt>SERVICE_ROLE</dt>
        /// <dd>
        /// <p>Specifies that CodeBuild uses your build project's service role. </p>
        /// </dd>
        /// </dl>
        /// <p>When using a cross-account or private registry image, you must use
        /// <code>SERVICE_ROLE</code> credentials. When using an CodeBuild curated image,
        /// you must use <code>CODEBUILD</code> credentials. </p>
        pub fn set_image_pull_credentials_type_override(
            mut self,
            input: std::option::Option<crate::model::ImagePullCredentialsType>,
        ) -> Self {
            self.inner = self.inner.set_image_pull_credentials_type_override(input);
            self
        }
        /// <p>A <code>BuildBatchConfigOverride</code> object that contains batch build configuration
        /// overrides.</p>
        pub fn build_batch_config_override(
            mut self,
            inp: crate::model::ProjectBuildBatchConfig,
        ) -> Self {
            self.inner = self.inner.build_batch_config_override(inp);
            self
        }
        /// <p>A <code>BuildBatchConfigOverride</code> object that contains batch build configuration
        /// overrides.</p>
        pub fn set_build_batch_config_override(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_batch_config_override(input);
            self
        }
        /// <p>Specifies if session debugging is enabled for this batch build. For more information, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
        pub fn debug_session_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.debug_session_enabled(inp);
            self
        }
        /// <p>Specifies if session debugging is enabled for this batch build. For more information, see
        /// <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html">Viewing a running build in Session Manager</a>. Batch session debugging is not supported for matrix batch builds.</p>
        pub fn set_debug_session_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_debug_session_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBuild`.
    ///
    /// <p>Attempts to stop running a build.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopBuild<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_build_input::Builder,
    }
    impl<C, M, R> StopBuild<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopBuild`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBuildOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBuildError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopBuildInputOperationOutputAlias,
                crate::output::StopBuildOutput,
                crate::error::StopBuildError,
                crate::input::StopBuildInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the build.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The ID of the build.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopBuildBatch`.
    ///
    /// <p>Stops a running batch build.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopBuildBatch<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_build_batch_input::Builder,
    }
    impl<C, M, R> StopBuildBatch<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopBuildBatch`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopBuildBatchOutput,
            aws_smithy_http::result::SdkError<crate::error::StopBuildBatchError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopBuildBatchInputOperationOutputAlias,
                crate::output::StopBuildBatchOutput,
                crate::error::StopBuildBatchError,
                crate::input::StopBuildBatchInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the batch build to stop.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The identifier of the batch build to stop.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProject`.
    ///
    /// <p>Changes the settings of a build project.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_input::Builder,
    }
    impl<C, M, R> UpdateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectInputOperationOutputAlias,
                crate::output::UpdateProjectOutput,
                crate::error::UpdateProjectError,
                crate::input::UpdateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the build project.</p>
        /// <note>
        /// <p>You cannot change a build project's name.</p>
        /// </note>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the build project.</p>
        /// <note>
        /// <p>You cannot change a build project's name.</p>
        /// </note>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A new or replacement description of the build project.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A new or replacement description of the build project.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Information to be changed about the build input source code for the build
        /// project.</p>
        pub fn source(mut self, inp: crate::model::ProjectSource) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>Information to be changed about the build input source code for the build
        /// project.</p>
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::ProjectSource>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// Appends an item to `secondarySources`.
        ///
        /// To override the contents of this collection use [`set_secondary_sources`](Self::set_secondary_sources).
        ///
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn secondary_sources(mut self, inp: impl Into<crate::model::ProjectSource>) -> Self {
            self.inner = self.inner.secondary_sources(inp);
            self
        }
        /// <p> An array of <code>ProjectSource</code> objects. </p>
        pub fn set_secondary_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSource>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_sources(input);
            self
        }
        /// <p> A version of the build input to be built for this project. If not specified, the
        /// latest version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p> If <code>sourceVersion</code> is specified at the build level, then that version
        /// takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn source_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(inp);
            self
        }
        /// <p> A version of the build input to be built for this project. If not specified, the
        /// latest version is used. If specified, it must be one of: </p>
        /// <ul>
        /// <li>
        /// <p>For CodeCommit: the commit ID, branch, or Git tag to use.</p>
        /// </li>
        /// <li>
        /// <p>For GitHub: the commit ID, pull request ID, branch name, or tag name that
        /// corresponds to the version of the source code you want to build. If a pull
        /// request ID is specified, it must use the format <code>pr/pull-request-ID</code>
        /// (for example <code>pr/25</code>). If a branch name is specified, the branch's
        /// HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is
        /// used.</p>
        /// </li>
        /// <li>
        /// <p>For Bitbucket: the commit ID, branch name, or tag name that corresponds to the
        /// version of the source code you want to build. If a branch name is specified, the
        /// branch's HEAD commit ID is used. If not specified, the default branch's HEAD
        /// commit ID is used.</p>
        /// </li>
        /// <li>
        /// <p>For Amazon S3: the version ID of the object that represents the build input ZIP
        /// file to use.</p>
        /// </li>
        /// </ul>
        /// <p> If <code>sourceVersion</code> is specified at the build level, then that version
        /// takes precedence over this <code>sourceVersion</code> (at the project level). </p>
        /// <p> For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html">Source Version Sample
        /// with CodeBuild</a> in the <i>CodeBuild User Guide</i>.
        /// </p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
        /// Appends an item to `secondarySourceVersions`.
        ///
        /// To override the contents of this collection use [`set_secondary_source_versions`](Self::set_secondary_source_versions).
        ///
        /// <p> An array of <code>ProjectSourceVersion</code> objects. If
        /// <code>secondarySourceVersions</code> is specified at the build level, then they take
        /// over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn secondary_source_versions(
            mut self,
            inp: impl Into<crate::model::ProjectSourceVersion>,
        ) -> Self {
            self.inner = self.inner.secondary_source_versions(inp);
            self
        }
        /// <p> An array of <code>ProjectSourceVersion</code> objects. If
        /// <code>secondarySourceVersions</code> is specified at the build level, then they take
        /// over these <code>secondarySourceVersions</code> (at the project level). </p>
        pub fn set_secondary_source_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectSourceVersion>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_source_versions(input);
            self
        }
        /// <p>Information to be changed about the build output artifacts for the build
        /// project.</p>
        pub fn artifacts(mut self, inp: crate::model::ProjectArtifacts) -> Self {
            self.inner = self.inner.artifacts(inp);
            self
        }
        /// <p>Information to be changed about the build output artifacts for the build
        /// project.</p>
        pub fn set_artifacts(
            mut self,
            input: std::option::Option<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.set_artifacts(input);
            self
        }
        /// Appends an item to `secondaryArtifacts`.
        ///
        /// To override the contents of this collection use [`set_secondary_artifacts`](Self::set_secondary_artifacts).
        ///
        /// <p> An array of <code>ProjectArtifact</code> objects. </p>
        pub fn secondary_artifacts(
            mut self,
            inp: impl Into<crate::model::ProjectArtifacts>,
        ) -> Self {
            self.inner = self.inner.secondary_artifacts(inp);
            self
        }
        /// <p> An array of <code>ProjectArtifact</code> objects. </p>
        pub fn set_secondary_artifacts(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectArtifacts>>,
        ) -> Self {
            self.inner = self.inner.set_secondary_artifacts(input);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later
        /// time.</p>
        pub fn cache(mut self, inp: crate::model::ProjectCache) -> Self {
            self.inner = self.inner.cache(inp);
            self
        }
        /// <p>Stores recently used information so that it can be quickly accessed at a later
        /// time.</p>
        pub fn set_cache(mut self, input: std::option::Option<crate::model::ProjectCache>) -> Self {
            self.inner = self.inner.set_cache(input);
            self
        }
        /// <p>Information to be changed about the build environment for the build project.</p>
        pub fn environment(mut self, inp: crate::model::ProjectEnvironment) -> Self {
            self.inner = self.inner.environment(inp);
            self
        }
        /// <p>Information to be changed about the build environment for the build project.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<crate::model::ProjectEnvironment>,
        ) -> Self {
            self.inner = self.inner.set_environment(input);
            self
        }
        /// <p>The replacement ARN of the IAM role that enables CodeBuild to interact with dependent
        /// Amazon Web Services services on behalf of the Amazon Web Services account.</p>
        pub fn service_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_role(inp);
            self
        }
        /// <p>The replacement ARN of the IAM role that enables CodeBuild to interact with dependent
        /// Amazon Web Services services on behalf of the Amazon Web Services account.</p>
        pub fn set_service_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_role(input);
            self
        }
        /// <p>The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before
        /// timing out any related build that did not get marked as completed.</p>
        pub fn timeout_in_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.timeout_in_minutes(inp);
            self
        }
        /// <p>The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before
        /// timing out any related build that did not get marked as completed.</p>
        pub fn set_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_timeout_in_minutes(input);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn queued_timeout_in_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.queued_timeout_in_minutes(inp);
            self
        }
        /// <p> The number of minutes a build is allowed to be queued before it times out. </p>
        pub fn set_queued_timeout_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_queued_timeout_in_minutes(input);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).
        /// </p>
        pub fn encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>The Key Management Service customer master key (CMK) to be used for encrypting the build output
        /// artifacts.</p>
        /// <note>
        /// <p> You can use a cross-account KMS key to encrypt the build output artifacts if your
        /// service role has permission to that key. </p>
        /// </note>
        /// <p>You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using
        /// the format <code>alias/<alias-name></code>).
        /// </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An updated list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
        /// tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An updated list of tag key and value pairs associated with this build project.</p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild build project
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn vpc_config(mut self, inp: crate::model::VpcConfig) -> Self {
            self.inner = self.inner.vpc_config(inp);
            self
        }
        /// <p>VpcConfig enables CodeBuild to access resources in an Amazon VPC.</p>
        pub fn set_vpc_config(
            mut self,
            input: std::option::Option<crate::model::VpcConfig>,
        ) -> Self {
            self.inner = self.inner.set_vpc_config(input);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build
        /// badge.</p>
        pub fn badge_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.badge_enabled(inp);
            self
        }
        /// <p>Set this to true to generate a publicly accessible URL for your project's build
        /// badge.</p>
        pub fn set_badge_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_badge_enabled(input);
            self
        }
        /// <p> Information about logs for the build project. A project can create logs in CloudWatch Logs,
        /// logs in an S3 bucket, or both. </p>
        pub fn logs_config(mut self, inp: crate::model::LogsConfig) -> Self {
            self.inner = self.inner.logs_config(inp);
            self
        }
        /// <p> Information about logs for the build project. A project can create logs in CloudWatch Logs,
        /// logs in an S3 bucket, or both. </p>
        pub fn set_logs_config(
            mut self,
            input: std::option::Option<crate::model::LogsConfig>,
        ) -> Self {
            self.inner = self.inner.set_logs_config(input);
            self
        }
        /// Appends an item to `fileSystemLocations`.
        ///
        /// To override the contents of this collection use [`set_file_system_locations`](Self::set_file_system_locations).
        ///
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn file_system_locations(
            mut self,
            inp: impl Into<crate::model::ProjectFileSystemLocation>,
        ) -> Self {
            self.inner = self.inner.file_system_locations(inp);
            self
        }
        /// <p>
        /// An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A <code>ProjectFileSystemLocation</code> object
        /// specifies the <code>identifier</code>, <code>location</code>, <code>mountOptions</code>,
        /// <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon Elastic File System.
        /// </p>
        pub fn set_file_system_locations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectFileSystemLocation>>,
        ) -> Self {
            self.inner = self.inner.set_file_system_locations(input);
            self
        }
        /// <p>Contains configuration information about a batch build project.</p>
        pub fn build_batch_config(mut self, inp: crate::model::ProjectBuildBatchConfig) -> Self {
            self.inner = self.inner.build_batch_config(inp);
            self
        }
        /// <p>Contains configuration information about a batch build project.</p>
        pub fn set_build_batch_config(
            mut self,
            input: std::option::Option<crate::model::ProjectBuildBatchConfig>,
        ) -> Self {
            self.inner = self.inner.set_build_batch_config(input);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
        /// If the current build count meets this limit, new builds are throttled and are not run.</p>
        /// <p>To remove this limit, set this value to -1.</p>
        pub fn concurrent_build_limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.concurrent_build_limit(inp);
            self
        }
        /// <p>The maximum number of concurrent builds that are allowed for this project.</p>
        /// <p>New builds are only started if the current number of builds is less than or equal to this limit.
        /// If the current build count meets this limit, new builds are throttled and are not run.</p>
        /// <p>To remove this limit, set this value to -1.</p>
        pub fn set_concurrent_build_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_concurrent_build_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProjectVisibility`.
    ///
    /// <p>Changes the public visibility for a project. The project's build results, logs, and
    /// artifacts are available to the general public.  For more information, see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/public-builds.html">Public build
    /// projects</a> in the <i>CodeBuild User Guide</i>.</p>
    /// <important>
    /// <p>The following should be kept in mind when making your projects public:</p>
    /// <ul>
    /// <li>
    /// <p>All of a project's build results, logs, and artifacts, including builds that were run
    /// when the project was private, are available to the general public.</p>
    /// </li>
    /// <li>
    /// <p>All build logs and artifacts are available to the public. Environment variables, source
    /// code, and other sensitive information may have been output to the build logs and artifacts.
    /// You must be careful about what information is output to the build logs. Some best practice
    /// are:</p>
    /// <ul>
    /// <li>
    /// <p>Do not store sensitive values, especially Amazon Web Services access key IDs and secret access
    /// keys, in environment variables. We recommend that you use an Amazon EC2 Systems Manager Parameter Store
    /// or Secrets Manager to store sensitive values.</p>
    /// </li>
    /// <li>
    /// <p>Follow <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/webhooks.html#webhook-best-practices">Best
    /// practices for using webhooks</a> in the <i>CodeBuild User
    /// Guide</i> to limit which entities can trigger a build, and do
    /// not store the buildspec in the project itself, to ensure that your webhooks are as
    /// secure as possible.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>A malicious user can use public builds to distribute malicious artifacts. We recommend
    /// that you review all pull requests to verify that the pull request is a legitimate change. We
    /// also recommend that you validate any artifacts with their checksums to make sure that the
    /// correct artifacts are being downloaded.</p>
    /// </li>
    /// </ul>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProjectVisibility<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_project_visibility_input::Builder,
    }
    impl<C, M, R> UpdateProjectVisibility<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProjectVisibility`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProjectVisibilityOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProjectVisibilityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProjectVisibilityInputOperationOutputAlias,
                crate::output::UpdateProjectVisibilityOutput,
                crate::error::UpdateProjectVisibilityError,
                crate::input::UpdateProjectVisibilityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn project_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the build project.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_arn(input);
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        ///
        /// <dl>
        /// <dt>PUBLIC_READ</dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>PRIVATE</dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn project_visibility(mut self, inp: crate::model::ProjectVisibilityType) -> Self {
            self.inner = self.inner.project_visibility(inp);
            self
        }
        /// <p>Specifies the visibility of the project's builds. Possible values are:</p>
        ///
        /// <dl>
        /// <dt>PUBLIC_READ</dt>
        /// <dd>
        /// <p>The project builds are visible to the public.</p>
        /// </dd>
        /// <dt>PRIVATE</dt>
        /// <dd>
        /// <p>The project builds are not visible to the public.</p>
        /// </dd>
        /// </dl>
        pub fn set_project_visibility(
            mut self,
            input: std::option::Option<crate::model::ProjectVisibilityType>,
        ) -> Self {
            self.inner = self.inner.set_project_visibility(input);
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
        /// the project's builds.</p>
        pub fn resource_access_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_access_role(inp);
            self
        }
        /// <p>The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for
        /// the project's builds.</p>
        pub fn set_resource_access_role(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_access_role(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateReportGroup`.
    ///
    /// <p>
    /// Updates a report group.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateReportGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_report_group_input::Builder,
    }
    impl<C, M, R> UpdateReportGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateReportGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateReportGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateReportGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateReportGroupInputOperationOutputAlias,
                crate::output::UpdateReportGroupOutput,
                crate::error::UpdateReportGroupError,
                crate::input::UpdateReportGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The ARN of the report group to update.
        /// </p>
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// <p>
        /// The ARN of the report group to update.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// <p>
        /// Used to specify an updated export type. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code>: The report results are exported to an S3 bucket.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_EXPORT</code>: The report results are not exported.
        /// </p>
        /// </li>
        /// </ul>
        pub fn export_config(mut self, inp: crate::model::ReportExportConfig) -> Self {
            self.inner = self.inner.export_config(inp);
            self
        }
        /// <p>
        /// Used to specify an updated export type. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>S3</code>: The report results are exported to an S3 bucket.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NO_EXPORT</code>: The report results are not exported.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_export_config(
            mut self,
            input: std::option::Option<crate::model::ReportExportConfig>,
        ) -> Self {
            self.inner = self.inner.set_export_config(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>
        /// An updated list of tag key and value pairs associated with this report group.
        /// </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
        /// tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>
        /// An updated list of tag key and value pairs associated with this report group.
        /// </p>
        /// <p>These tags are available for use by Amazon Web Services services that support CodeBuild report group
        /// tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateWebhook`.
    ///
    /// <p> Updates the webhook associated with an CodeBuild build project. </p>
    /// <note>
    /// <p> If you use Bitbucket for your repository, <code>rotateSecret</code> is ignored.
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct UpdateWebhook<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_webhook_input::Builder,
    }
    impl<C, M, R> UpdateWebhook<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateWebhook`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateWebhookOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateWebhookError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateWebhookInputOperationOutputAlias,
                crate::output::UpdateWebhookOutput,
                crate::error::UpdateWebhookError,
                crate::input::UpdateWebhookInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the CodeBuild project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a
        /// webhook is triggered. If the name of a branch matches the regular expression, then it is
        /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
        /// <note>
        /// <p> It is recommended that you use <code>filterGroups</code> instead of
        /// <code>branchFilter</code>. </p>
        /// </note>
        pub fn branch_filter(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.branch_filter(inp);
            self
        }
        /// <p>A regular expression used to determine which repository branches are built when a
        /// webhook is triggered. If the name of a branch matches the regular expression, then it is
        /// built. If <code>branchFilter</code> is empty, then all branches are built.</p>
        /// <note>
        /// <p> It is recommended that you use <code>filterGroups</code> instead of
        /// <code>branchFilter</code>. </p>
        /// </note>
        pub fn set_branch_filter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_branch_filter(input);
            self
        }
        /// <p> A boolean value that specifies whether the associated GitHub repository's secret
        /// token should be updated. If you use Bitbucket for your repository,
        /// <code>rotateSecret</code> is ignored. </p>
        pub fn rotate_secret(mut self, inp: bool) -> Self {
            self.inner = self.inner.rotate_secret(inp);
            self
        }
        /// <p> A boolean value that specifies whether the associated GitHub repository's secret
        /// token should be updated. If you use Bitbucket for your repository,
        /// <code>rotateSecret</code> is ignored. </p>
        pub fn set_rotate_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_rotate_secret(input);
            self
        }
        /// Appends an item to `filterGroups`.
        ///
        /// To override the contents of this collection use [`set_filter_groups`](Self::set_filter_groups).
        ///
        /// <p> An array of arrays of <code>WebhookFilter</code> objects used to determine if a
        /// webhook event can trigger a build. A filter group must contain at least one
        /// <code>EVENT</code>
        /// <code>WebhookFilter</code>. </p>
        pub fn filter_groups(
            mut self,
            inp: impl Into<std::vec::Vec<crate::model::WebhookFilter>>,
        ) -> Self {
            self.inner = self.inner.filter_groups(inp);
            self
        }
        /// <p> An array of arrays of <code>WebhookFilter</code> objects used to determine if a
        /// webhook event can trigger a build. A filter group must contain at least one
        /// <code>EVENT</code>
        /// <code>WebhookFilter</code>. </p>
        pub fn set_filter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::WebhookFilter>>>,
        ) -> Self {
            self.inner = self.inner.set_filter_groups(input);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn build_type(mut self, inp: crate::model::WebhookBuildType) -> Self {
            self.inner = self.inner.build_type(inp);
            self
        }
        /// <p>Specifies the type of build this webhook will trigger.</p>
        pub fn set_build_type(
            mut self,
            input: std::option::Option<crate::model::WebhookBuildType>,
        ) -> Self {
            self.inner = self.inner.set_build_type(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
