// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateExternalConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_external_connection`](crate::client::Client::associate_external_connection).
///
/// See [`crate::client::fluent_builders::AssociateExternalConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateExternalConnection {
    _private: (),
}
impl AssociateExternalConnection {
    /// Creates a new builder-style object to manufacture [`AssociateExternalConnectionInput`](crate::input::AssociateExternalConnectionInput)
    pub fn builder() -> crate::input::associate_external_connection_input::Builder {
        crate::input::associate_external_connection_input::Builder::default()
    }
    /// Creates a new `AssociateExternalConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateExternalConnection {
    type Output = std::result::Result<
        crate::output::AssociateExternalConnectionOutput,
        crate::error::AssociateExternalConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_external_connection_error(response)
        } else {
            crate::operation_deser::parse_associate_external_connection_response(response)
        }
    }
}

/// Operation shape for `CopyPackageVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_package_versions`](crate::client::Client::copy_package_versions).
///
/// See [`crate::client::fluent_builders::CopyPackageVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopyPackageVersions {
    _private: (),
}
impl CopyPackageVersions {
    /// Creates a new builder-style object to manufacture [`CopyPackageVersionsInput`](crate::input::CopyPackageVersionsInput)
    pub fn builder() -> crate::input::copy_package_versions_input::Builder {
        crate::input::copy_package_versions_input::Builder::default()
    }
    /// Creates a new `CopyPackageVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopyPackageVersions {
    type Output = std::result::Result<
        crate::output::CopyPackageVersionsOutput,
        crate::error::CopyPackageVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_package_versions_error(response)
        } else {
            crate::operation_deser::parse_copy_package_versions_response(response)
        }
    }
}

/// Operation shape for `CreateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain`](crate::client::Client::create_domain).
///
/// See [`crate::client::fluent_builders::CreateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomain {
    _private: (),
}
impl CreateDomain {
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
    /// Creates a new `CreateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomain {
    type Output =
        std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_error(response)
        } else {
            crate::operation_deser::parse_create_domain_response(response)
        }
    }
}

/// Operation shape for `CreateRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_repository`](crate::client::Client::create_repository).
///
/// See [`crate::client::fluent_builders::CreateRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRepository {
    _private: (),
}
impl CreateRepository {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
    /// Creates a new `CreateRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRepository {
    type Output = std::result::Result<
        crate::output::CreateRepositoryOutput,
        crate::error::CreateRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_repository_error(response)
        } else {
            crate::operation_deser::parse_create_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain`](crate::client::Client::delete_domain).
///
/// See [`crate::client::fluent_builders::DeleteDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomain {
    _private: (),
}
impl DeleteDomain {
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
    /// Creates a new `DeleteDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomain {
    type Output =
        std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteDomainPermissionsPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain_permissions_policy`](crate::client::Client::delete_domain_permissions_policy).
///
/// See [`crate::client::fluent_builders::DeleteDomainPermissionsPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomainPermissionsPolicy {
    _private: (),
}
impl DeleteDomainPermissionsPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteDomainPermissionsPolicyInput`](crate::input::DeleteDomainPermissionsPolicyInput)
    pub fn builder() -> crate::input::delete_domain_permissions_policy_input::Builder {
        crate::input::delete_domain_permissions_policy_input::Builder::default()
    }
    /// Creates a new `DeleteDomainPermissionsPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomainPermissionsPolicy {
    type Output = std::result::Result<
        crate::output::DeleteDomainPermissionsPolicyOutput,
        crate::error::DeleteDomainPermissionsPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_permissions_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_permissions_policy_response(response)
        }
    }
}

/// Operation shape for `DeletePackageVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_package_versions`](crate::client::Client::delete_package_versions).
///
/// See [`crate::client::fluent_builders::DeletePackageVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePackageVersions {
    _private: (),
}
impl DeletePackageVersions {
    /// Creates a new builder-style object to manufacture [`DeletePackageVersionsInput`](crate::input::DeletePackageVersionsInput)
    pub fn builder() -> crate::input::delete_package_versions_input::Builder {
        crate::input::delete_package_versions_input::Builder::default()
    }
    /// Creates a new `DeletePackageVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePackageVersions {
    type Output = std::result::Result<
        crate::output::DeletePackageVersionsOutput,
        crate::error::DeletePackageVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_package_versions_error(response)
        } else {
            crate::operation_deser::parse_delete_package_versions_response(response)
        }
    }
}

/// Operation shape for `DeleteRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository`](crate::client::Client::delete_repository).
///
/// See [`crate::client::fluent_builders::DeleteRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepository {
    _private: (),
}
impl DeleteRepository {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
    /// Creates a new `DeleteRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepository {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryOutput,
        crate::error::DeleteRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_response(response)
        }
    }
}

/// Operation shape for `DeleteRepositoryPermissionsPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_repository_permissions_policy`](crate::client::Client::delete_repository_permissions_policy).
///
/// See [`crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRepositoryPermissionsPolicy {
    _private: (),
}
impl DeleteRepositoryPermissionsPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPermissionsPolicyInput`](crate::input::DeleteRepositoryPermissionsPolicyInput)
    pub fn builder() -> crate::input::delete_repository_permissions_policy_input::Builder {
        crate::input::delete_repository_permissions_policy_input::Builder::default()
    }
    /// Creates a new `DeleteRepositoryPermissionsPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRepositoryPermissionsPolicy {
    type Output = std::result::Result<
        crate::output::DeleteRepositoryPermissionsPolicyOutput,
        crate::error::DeleteRepositoryPermissionsPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_repository_permissions_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_repository_permissions_policy_response(response)
        }
    }
}

/// Operation shape for `DescribeDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_domain`](crate::client::Client::describe_domain).
///
/// See [`crate::client::fluent_builders::DescribeDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDomain {
    _private: (),
}
impl DescribeDomain {
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
    /// Creates a new `DescribeDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDomain {
    type Output =
        std::result::Result<crate::output::DescribeDomainOutput, crate::error::DescribeDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_domain_error(response)
        } else {
            crate::operation_deser::parse_describe_domain_response(response)
        }
    }
}

/// Operation shape for `DescribePackageVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_package_version`](crate::client::Client::describe_package_version).
///
/// See [`crate::client::fluent_builders::DescribePackageVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePackageVersion {
    _private: (),
}
impl DescribePackageVersion {
    /// Creates a new builder-style object to manufacture [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
    pub fn builder() -> crate::input::describe_package_version_input::Builder {
        crate::input::describe_package_version_input::Builder::default()
    }
    /// Creates a new `DescribePackageVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePackageVersion {
    type Output = std::result::Result<
        crate::output::DescribePackageVersionOutput,
        crate::error::DescribePackageVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_package_version_error(response)
        } else {
            crate::operation_deser::parse_describe_package_version_response(response)
        }
    }
}

/// Operation shape for `DescribeRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_repository`](crate::client::Client::describe_repository).
///
/// See [`crate::client::fluent_builders::DescribeRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRepository {
    _private: (),
}
impl DescribeRepository {
    /// Creates a new builder-style object to manufacture [`DescribeRepositoryInput`](crate::input::DescribeRepositoryInput)
    pub fn builder() -> crate::input::describe_repository_input::Builder {
        crate::input::describe_repository_input::Builder::default()
    }
    /// Creates a new `DescribeRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRepository {
    type Output = std::result::Result<
        crate::output::DescribeRepositoryOutput,
        crate::error::DescribeRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_repository_error(response)
        } else {
            crate::operation_deser::parse_describe_repository_response(response)
        }
    }
}

/// Operation shape for `DisassociateExternalConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_external_connection`](crate::client::Client::disassociate_external_connection).
///
/// See [`crate::client::fluent_builders::DisassociateExternalConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateExternalConnection {
    _private: (),
}
impl DisassociateExternalConnection {
    /// Creates a new builder-style object to manufacture [`DisassociateExternalConnectionInput`](crate::input::DisassociateExternalConnectionInput)
    pub fn builder() -> crate::input::disassociate_external_connection_input::Builder {
        crate::input::disassociate_external_connection_input::Builder::default()
    }
    /// Creates a new `DisassociateExternalConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateExternalConnection {
    type Output = std::result::Result<
        crate::output::DisassociateExternalConnectionOutput,
        crate::error::DisassociateExternalConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_external_connection_error(response)
        } else {
            crate::operation_deser::parse_disassociate_external_connection_response(response)
        }
    }
}

/// Operation shape for `DisposePackageVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`dispose_package_versions`](crate::client::Client::dispose_package_versions).
///
/// See [`crate::client::fluent_builders::DisposePackageVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisposePackageVersions {
    _private: (),
}
impl DisposePackageVersions {
    /// Creates a new builder-style object to manufacture [`DisposePackageVersionsInput`](crate::input::DisposePackageVersionsInput)
    pub fn builder() -> crate::input::dispose_package_versions_input::Builder {
        crate::input::dispose_package_versions_input::Builder::default()
    }
    /// Creates a new `DisposePackageVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisposePackageVersions {
    type Output = std::result::Result<
        crate::output::DisposePackageVersionsOutput,
        crate::error::DisposePackageVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_dispose_package_versions_error(response)
        } else {
            crate::operation_deser::parse_dispose_package_versions_response(response)
        }
    }
}

/// Operation shape for `GetAuthorizationToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_authorization_token`](crate::client::Client::get_authorization_token).
///
/// See [`crate::client::fluent_builders::GetAuthorizationToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAuthorizationToken {
    _private: (),
}
impl GetAuthorizationToken {
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    pub fn builder() -> crate::input::get_authorization_token_input::Builder {
        crate::input::get_authorization_token_input::Builder::default()
    }
    /// Creates a new `GetAuthorizationToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAuthorizationToken {
    type Output = std::result::Result<
        crate::output::GetAuthorizationTokenOutput,
        crate::error::GetAuthorizationTokenError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_authorization_token_error(response)
        } else {
            crate::operation_deser::parse_get_authorization_token_response(response)
        }
    }
}

/// Operation shape for `GetDomainPermissionsPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain_permissions_policy`](crate::client::Client::get_domain_permissions_policy).
///
/// See [`crate::client::fluent_builders::GetDomainPermissionsPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomainPermissionsPolicy {
    _private: (),
}
impl GetDomainPermissionsPolicy {
    /// Creates a new builder-style object to manufacture [`GetDomainPermissionsPolicyInput`](crate::input::GetDomainPermissionsPolicyInput)
    pub fn builder() -> crate::input::get_domain_permissions_policy_input::Builder {
        crate::input::get_domain_permissions_policy_input::Builder::default()
    }
    /// Creates a new `GetDomainPermissionsPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomainPermissionsPolicy {
    type Output = std::result::Result<
        crate::output::GetDomainPermissionsPolicyOutput,
        crate::error::GetDomainPermissionsPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_permissions_policy_error(response)
        } else {
            crate::operation_deser::parse_get_domain_permissions_policy_response(response)
        }
    }
}

/// Operation shape for `GetPackageVersionAsset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_package_version_asset`](crate::client::Client::get_package_version_asset).
///
/// See [`crate::client::fluent_builders::GetPackageVersionAsset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPackageVersionAsset {
    _private: (),
}
impl GetPackageVersionAsset {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionAssetInput`](crate::input::GetPackageVersionAssetInput)
    pub fn builder() -> crate::input::get_package_version_asset_input::Builder {
        crate::input::get_package_version_asset_input::Builder::default()
    }
    /// Creates a new `GetPackageVersionAsset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for GetPackageVersionAsset {
    type Output = std::result::Result<
        crate::output::GetPackageVersionAssetOutput,
        crate::error::GetPackageVersionAssetError,
    >;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_get_package_version_asset(
            response,
        ))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_get_package_version_asset_error(response)
    }
}

/// Operation shape for `GetPackageVersionReadme`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_package_version_readme`](crate::client::Client::get_package_version_readme).
///
/// See [`crate::client::fluent_builders::GetPackageVersionReadme`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPackageVersionReadme {
    _private: (),
}
impl GetPackageVersionReadme {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionReadmeInput`](crate::input::GetPackageVersionReadmeInput)
    pub fn builder() -> crate::input::get_package_version_readme_input::Builder {
        crate::input::get_package_version_readme_input::Builder::default()
    }
    /// Creates a new `GetPackageVersionReadme` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPackageVersionReadme {
    type Output = std::result::Result<
        crate::output::GetPackageVersionReadmeOutput,
        crate::error::GetPackageVersionReadmeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_package_version_readme_error(response)
        } else {
            crate::operation_deser::parse_get_package_version_readme_response(response)
        }
    }
}

/// Operation shape for `GetRepositoryEndpoint`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository_endpoint`](crate::client::Client::get_repository_endpoint).
///
/// See [`crate::client::fluent_builders::GetRepositoryEndpoint`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepositoryEndpoint {
    _private: (),
}
impl GetRepositoryEndpoint {
    /// Creates a new builder-style object to manufacture [`GetRepositoryEndpointInput`](crate::input::GetRepositoryEndpointInput)
    pub fn builder() -> crate::input::get_repository_endpoint_input::Builder {
        crate::input::get_repository_endpoint_input::Builder::default()
    }
    /// Creates a new `GetRepositoryEndpoint` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepositoryEndpoint {
    type Output = std::result::Result<
        crate::output::GetRepositoryEndpointOutput,
        crate::error::GetRepositoryEndpointError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_endpoint_error(response)
        } else {
            crate::operation_deser::parse_get_repository_endpoint_response(response)
        }
    }
}

/// Operation shape for `GetRepositoryPermissionsPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_repository_permissions_policy`](crate::client::Client::get_repository_permissions_policy).
///
/// See [`crate::client::fluent_builders::GetRepositoryPermissionsPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRepositoryPermissionsPolicy {
    _private: (),
}
impl GetRepositoryPermissionsPolicy {
    /// Creates a new builder-style object to manufacture [`GetRepositoryPermissionsPolicyInput`](crate::input::GetRepositoryPermissionsPolicyInput)
    pub fn builder() -> crate::input::get_repository_permissions_policy_input::Builder {
        crate::input::get_repository_permissions_policy_input::Builder::default()
    }
    /// Creates a new `GetRepositoryPermissionsPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRepositoryPermissionsPolicy {
    type Output = std::result::Result<
        crate::output::GetRepositoryPermissionsPolicyOutput,
        crate::error::GetRepositoryPermissionsPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_repository_permissions_policy_error(response)
        } else {
            crate::operation_deser::parse_get_repository_permissions_policy_response(response)
        }
    }
}

/// Operation shape for `ListDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domains`](crate::client::Client::list_domains).
///
/// See [`crate::client::fluent_builders::ListDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomains {
    _private: (),
}
impl ListDomains {
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
    /// Creates a new `ListDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomains {
    type Output =
        std::result::Result<crate::output::ListDomainsOutput, crate::error::ListDomainsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domains_error(response)
        } else {
            crate::operation_deser::parse_list_domains_response(response)
        }
    }
}

/// Operation shape for `ListPackages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_packages`](crate::client::Client::list_packages).
///
/// See [`crate::client::fluent_builders::ListPackages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackages {
    _private: (),
}
impl ListPackages {
    /// Creates a new builder-style object to manufacture [`ListPackagesInput`](crate::input::ListPackagesInput)
    pub fn builder() -> crate::input::list_packages_input::Builder {
        crate::input::list_packages_input::Builder::default()
    }
    /// Creates a new `ListPackages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackages {
    type Output =
        std::result::Result<crate::output::ListPackagesOutput, crate::error::ListPackagesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_packages_error(response)
        } else {
            crate::operation_deser::parse_list_packages_response(response)
        }
    }
}

/// Operation shape for `ListPackageVersionAssets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_package_version_assets`](crate::client::Client::list_package_version_assets).
///
/// See [`crate::client::fluent_builders::ListPackageVersionAssets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackageVersionAssets {
    _private: (),
}
impl ListPackageVersionAssets {
    /// Creates a new builder-style object to manufacture [`ListPackageVersionAssetsInput`](crate::input::ListPackageVersionAssetsInput)
    pub fn builder() -> crate::input::list_package_version_assets_input::Builder {
        crate::input::list_package_version_assets_input::Builder::default()
    }
    /// Creates a new `ListPackageVersionAssets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackageVersionAssets {
    type Output = std::result::Result<
        crate::output::ListPackageVersionAssetsOutput,
        crate::error::ListPackageVersionAssetsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_package_version_assets_error(response)
        } else {
            crate::operation_deser::parse_list_package_version_assets_response(response)
        }
    }
}

/// Operation shape for `ListPackageVersionDependencies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_package_version_dependencies`](crate::client::Client::list_package_version_dependencies).
///
/// See [`crate::client::fluent_builders::ListPackageVersionDependencies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackageVersionDependencies {
    _private: (),
}
impl ListPackageVersionDependencies {
    /// Creates a new builder-style object to manufacture [`ListPackageVersionDependenciesInput`](crate::input::ListPackageVersionDependenciesInput)
    pub fn builder() -> crate::input::list_package_version_dependencies_input::Builder {
        crate::input::list_package_version_dependencies_input::Builder::default()
    }
    /// Creates a new `ListPackageVersionDependencies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackageVersionDependencies {
    type Output = std::result::Result<
        crate::output::ListPackageVersionDependenciesOutput,
        crate::error::ListPackageVersionDependenciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_package_version_dependencies_error(response)
        } else {
            crate::operation_deser::parse_list_package_version_dependencies_response(response)
        }
    }
}

/// Operation shape for `ListPackageVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_package_versions`](crate::client::Client::list_package_versions).
///
/// See [`crate::client::fluent_builders::ListPackageVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPackageVersions {
    _private: (),
}
impl ListPackageVersions {
    /// Creates a new builder-style object to manufacture [`ListPackageVersionsInput`](crate::input::ListPackageVersionsInput)
    pub fn builder() -> crate::input::list_package_versions_input::Builder {
        crate::input::list_package_versions_input::Builder::default()
    }
    /// Creates a new `ListPackageVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPackageVersions {
    type Output = std::result::Result<
        crate::output::ListPackageVersionsOutput,
        crate::error::ListPackageVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_package_versions_error(response)
        } else {
            crate::operation_deser::parse_list_package_versions_response(response)
        }
    }
}

/// Operation shape for `ListRepositories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_repositories`](crate::client::Client::list_repositories).
///
/// See [`crate::client::fluent_builders::ListRepositories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRepositories {
    _private: (),
}
impl ListRepositories {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
    pub fn builder() -> crate::input::list_repositories_input::Builder {
        crate::input::list_repositories_input::Builder::default()
    }
    /// Creates a new `ListRepositories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRepositories {
    type Output = std::result::Result<
        crate::output::ListRepositoriesOutput,
        crate::error::ListRepositoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_repositories_error(response)
        } else {
            crate::operation_deser::parse_list_repositories_response(response)
        }
    }
}

/// Operation shape for `ListRepositoriesInDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_repositories_in_domain`](crate::client::Client::list_repositories_in_domain).
///
/// See [`crate::client::fluent_builders::ListRepositoriesInDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRepositoriesInDomain {
    _private: (),
}
impl ListRepositoriesInDomain {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInDomainInput`](crate::input::ListRepositoriesInDomainInput)
    pub fn builder() -> crate::input::list_repositories_in_domain_input::Builder {
        crate::input::list_repositories_in_domain_input::Builder::default()
    }
    /// Creates a new `ListRepositoriesInDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRepositoriesInDomain {
    type Output = std::result::Result<
        crate::output::ListRepositoriesInDomainOutput,
        crate::error::ListRepositoriesInDomainError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_repositories_in_domain_error(response)
        } else {
            crate::operation_deser::parse_list_repositories_in_domain_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutDomainPermissionsPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_domain_permissions_policy`](crate::client::Client::put_domain_permissions_policy).
///
/// See [`crate::client::fluent_builders::PutDomainPermissionsPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDomainPermissionsPolicy {
    _private: (),
}
impl PutDomainPermissionsPolicy {
    /// Creates a new builder-style object to manufacture [`PutDomainPermissionsPolicyInput`](crate::input::PutDomainPermissionsPolicyInput)
    pub fn builder() -> crate::input::put_domain_permissions_policy_input::Builder {
        crate::input::put_domain_permissions_policy_input::Builder::default()
    }
    /// Creates a new `PutDomainPermissionsPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDomainPermissionsPolicy {
    type Output = std::result::Result<
        crate::output::PutDomainPermissionsPolicyOutput,
        crate::error::PutDomainPermissionsPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_domain_permissions_policy_error(response)
        } else {
            crate::operation_deser::parse_put_domain_permissions_policy_response(response)
        }
    }
}

/// Operation shape for `PutRepositoryPermissionsPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_repository_permissions_policy`](crate::client::Client::put_repository_permissions_policy).
///
/// See [`crate::client::fluent_builders::PutRepositoryPermissionsPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRepositoryPermissionsPolicy {
    _private: (),
}
impl PutRepositoryPermissionsPolicy {
    /// Creates a new builder-style object to manufacture [`PutRepositoryPermissionsPolicyInput`](crate::input::PutRepositoryPermissionsPolicyInput)
    pub fn builder() -> crate::input::put_repository_permissions_policy_input::Builder {
        crate::input::put_repository_permissions_policy_input::Builder::default()
    }
    /// Creates a new `PutRepositoryPermissionsPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRepositoryPermissionsPolicy {
    type Output = std::result::Result<
        crate::output::PutRepositoryPermissionsPolicyOutput,
        crate::error::PutRepositoryPermissionsPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_repository_permissions_policy_error(response)
        } else {
            crate::operation_deser::parse_put_repository_permissions_policy_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdatePackageVersionsStatus`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_package_versions_status`](crate::client::Client::update_package_versions_status).
///
/// See [`crate::client::fluent_builders::UpdatePackageVersionsStatus`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePackageVersionsStatus {
    _private: (),
}
impl UpdatePackageVersionsStatus {
    /// Creates a new builder-style object to manufacture [`UpdatePackageVersionsStatusInput`](crate::input::UpdatePackageVersionsStatusInput)
    pub fn builder() -> crate::input::update_package_versions_status_input::Builder {
        crate::input::update_package_versions_status_input::Builder::default()
    }
    /// Creates a new `UpdatePackageVersionsStatus` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePackageVersionsStatus {
    type Output = std::result::Result<
        crate::output::UpdatePackageVersionsStatusOutput,
        crate::error::UpdatePackageVersionsStatusError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_package_versions_status_error(response)
        } else {
            crate::operation_deser::parse_update_package_versions_status_response(response)
        }
    }
}

/// Operation shape for `UpdateRepository`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_repository`](crate::client::Client::update_repository).
///
/// See [`crate::client::fluent_builders::UpdateRepository`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRepository {
    _private: (),
}
impl UpdateRepository {
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryInput`](crate::input::UpdateRepositoryInput)
    pub fn builder() -> crate::input::update_repository_input::Builder {
        crate::input::update_repository_input::Builder::default()
    }
    /// Creates a new `UpdateRepository` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRepository {
    type Output = std::result::Result<
        crate::output::UpdateRepositoryOutput,
        crate::error::UpdateRepositoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_repository_error(response)
        } else {
            crate::operation_deser::parse_update_repository_response(response)
        }
    }
}
