// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for CodeArtifact
///
/// Client for invoking operations on CodeArtifact. Each operation on CodeArtifact is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_codeartifact::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_codeartifact::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_codeartifact::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateExternalConnection`](crate::client::fluent_builders::AssociateExternalConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::AssociateExternalConnection::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::AssociateExternalConnection::set_domain): <p>The name of the domain that contains the repository.</p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::AssociateExternalConnection::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::AssociateExternalConnection::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::AssociateExternalConnection::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::AssociateExternalConnection::set_repository): <p> The name of the repository to which the external connection is added. </p>
    ///   - [`external_connection(impl Into<String>)`](crate::client::fluent_builders::AssociateExternalConnection::external_connection) / [`set_external_connection(Option<String>)`](crate::client::fluent_builders::AssociateExternalConnection::set_external_connection): <p> The name of the external connection to add to the repository. The following values are supported: </p>  <ul>   <li> <p> <code>public:npmjs</code> - for the npm public repository. </p> </li>   <li> <p> <code>public:pypi</code> - for the Python Package Index. </p> </li>   <li> <p> <code>public:maven-central</code> - for Maven Central. </p> </li>   <li> <p> <code>public:maven-googleandroid</code> - for the Google Android repository. </p> </li>   <li> <p> <code>public:maven-gradleplugins</code> - for the Gradle plugins repository. </p> </li>   <li> <p> <code>public:maven-commonsware</code> - for the CommonsWare Android repository. </p> </li>  </ul>
    /// - On success, responds with [`AssociateExternalConnectionOutput`](crate::output::AssociateExternalConnectionOutput) with field(s):
    ///   - [`repository(Option<RepositoryDescription>)`](crate::output::AssociateExternalConnectionOutput::repository): <p> Information about the connected repository after processing the request. </p>
    /// - On failure, responds with [`SdkError<AssociateExternalConnectionError>`](crate::error::AssociateExternalConnectionError)
    pub fn associate_external_connection(
        &self,
    ) -> fluent_builders::AssociateExternalConnection<C, M, R> {
        fluent_builders::AssociateExternalConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyPackageVersions`](crate::client::fluent_builders::CopyPackageVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CopyPackageVersions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CopyPackageVersions::set_domain): <p> The name of the domain that contains the source and destination repositories. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::CopyPackageVersions::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::CopyPackageVersions::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`source_repository(impl Into<String>)`](crate::client::fluent_builders::CopyPackageVersions::source_repository) / [`set_source_repository(Option<String>)`](crate::client::fluent_builders::CopyPackageVersions::set_source_repository): <p> The name of the repository that contains the package versions to copy. </p>
    ///   - [`destination_repository(impl Into<String>)`](crate::client::fluent_builders::CopyPackageVersions::destination_repository) / [`set_destination_repository(Option<String>)`](crate::client::fluent_builders::CopyPackageVersions::set_destination_repository): <p> The name of the repository into which package versions are copied. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::CopyPackageVersions::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::CopyPackageVersions::set_format): <p> The format of the package that is copied. The valid package types are: </p>  <ul>   <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>   <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>   <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::CopyPackageVersions::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::CopyPackageVersions::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::CopyPackageVersions::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::CopyPackageVersions::set_package): <p> The name of the package that is copied. </p>
    ///   - [`versions(Vec<String>)`](crate::client::fluent_builders::CopyPackageVersions::versions) / [`set_versions(Option<Vec<String>>)`](crate::client::fluent_builders::CopyPackageVersions::set_versions): <p> The versions of the package to copy. </p> <note>   <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p>  </note>
    ///   - [`version_revisions(HashMap<String, String>)`](crate::client::fluent_builders::CopyPackageVersions::version_revisions) / [`set_version_revisions(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CopyPackageVersions::set_version_revisions): <p> A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source repository match the specified package version revision. </p> <note>   <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p>  </note>
    ///   - [`allow_overwrite(bool)`](crate::client::fluent_builders::CopyPackageVersions::allow_overwrite) / [`set_allow_overwrite(Option<bool>)`](crate::client::fluent_builders::CopyPackageVersions::set_allow_overwrite): <p> Set to true to overwrite a package version that already exists in the destination repository. If set to false and the package version already exists in the destination repository, the package version is returned in the <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code> error code. </p>
    ///   - [`include_from_upstream(bool)`](crate::client::fluent_builders::CopyPackageVersions::include_from_upstream) / [`set_include_from_upstream(Option<bool>)`](crate::client::fluent_builders::CopyPackageVersions::set_include_from_upstream): <p> Set to true to copy packages from repositories that are upstream from the source repository to the destination repository. The default setting is false. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    /// - On success, responds with [`CopyPackageVersionsOutput`](crate::output::CopyPackageVersionsOutput) with field(s):
    ///   - [`successful_versions(Option<HashMap<String, SuccessfulPackageVersionInfo>>)`](crate::output::CopyPackageVersionsOutput::successful_versions): <p> A list of the package versions that were successfully copied to your repository. </p>
    ///   - [`failed_versions(Option<HashMap<String, PackageVersionError>>)`](crate::output::CopyPackageVersionsOutput::failed_versions): <p> A map of package versions that failed to copy and their error codes. The possible error codes are in the <code>PackageVersionError</code> data type. They are: </p>  <ul>   <li> <p> <code>ALREADY_EXISTS</code> </p> </li>   <li> <p> <code>MISMATCHED_REVISION</code> </p> </li>   <li> <p> <code>MISMATCHED_STATUS</code> </p> </li>   <li> <p> <code>NOT_ALLOWED</code> </p> </li>   <li> <p> <code>NOT_FOUND</code> </p> </li>   <li> <p> <code>SKIPPED</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<CopyPackageVersionsError>`](crate::error::CopyPackageVersionsError)
    pub fn copy_package_versions(&self) -> fluent_builders::CopyPackageVersions<C, M, R> {
        fluent_builders::CopyPackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomain`](crate::client::fluent_builders::CreateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_domain): <p> The name of the domain to create. All domain names in an AWS Region that are in the same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a domain name because it is publicly discoverable. </p>
    ///   - [`encryption_key(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::encryption_key) / [`set_encryption_key(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_encryption_key): <p> The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p> <important>   <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>  </important>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDomain::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDomain::set_tags): <p>One or more tag key-value pairs for the domain.</p>
    /// - On success, responds with [`CreateDomainOutput`](crate::output::CreateDomainOutput) with field(s):
    ///   - [`domain(Option<DomainDescription>)`](crate::output::CreateDomainOutput::domain): <p> Contains information about the created domain after processing the request. </p>
    /// - On failure, responds with [`SdkError<CreateDomainError>`](crate::error::CreateDomainError)
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRepository`](crate::client::fluent_builders::CreateRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_domain): <p> The name of the domain that contains the created repository. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_repository): <p> The name of the repository to create. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRepository::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRepository::set_description): <p> A description of the created repository. </p>
    ///   - [`upstreams(Vec<UpstreamRepository>)`](crate::client::fluent_builders::CreateRepository::upstreams) / [`set_upstreams(Option<Vec<UpstreamRepository>>)`](crate::client::fluent_builders::CreateRepository::set_upstreams): <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateRepository::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateRepository::set_tags): <p>One or more tag key-value pairs for the repository.</p>
    /// - On success, responds with [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput) with field(s):
    ///   - [`repository(Option<RepositoryDescription>)`](crate::output::CreateRepositoryOutput::repository): <p> Information about the created repository after processing the request. </p>
    /// - On failure, responds with [`SdkError<CreateRepositoryError>`](crate::error::CreateRepositoryError)
    pub fn create_repository(&self) -> fluent_builders::CreateRepository<C, M, R> {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeleteDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeleteDomain::set_domain): <p> The name of the domain to delete. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteDomain::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DeleteDomain::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    /// - On success, responds with [`DeleteDomainOutput`](crate::output::DeleteDomainOutput) with field(s):
    ///   - [`domain(Option<DomainDescription>)`](crate::output::DeleteDomainOutput::domain): <p> Contains information about the deleted domain after processing the request. </p>
    /// - On failure, responds with [`SdkError<DeleteDomainError>`](crate::error::DeleteDomainError)
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomainPermissionsPolicy`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy::set_domain): <p> The name of the domain associated with the resource policy to be deleted. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`policy_revision(impl Into<String>)`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy::policy_revision) / [`set_policy_revision(Option<String>)`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy::set_policy_revision): <p> The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. </p>
    /// - On success, responds with [`DeleteDomainPermissionsPolicyOutput`](crate::output::DeleteDomainPermissionsPolicyOutput) with field(s):
    ///   - [`policy(Option<ResourcePolicy>)`](crate::output::DeleteDomainPermissionsPolicyOutput::policy): <p> Information about the deleted resource policy after processing the request. </p>
    /// - On failure, responds with [`SdkError<DeleteDomainPermissionsPolicyError>`](crate::error::DeleteDomainPermissionsPolicyError)
    pub fn delete_domain_permissions_policy(
        &self,
    ) -> fluent_builders::DeleteDomainPermissionsPolicy<C, M, R> {
        fluent_builders::DeleteDomainPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePackageVersions`](crate::client::fluent_builders::DeletePackageVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeletePackageVersions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeletePackageVersions::set_domain): <p> The name of the domain that contains the package to delete. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DeletePackageVersions::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DeletePackageVersions::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::DeletePackageVersions::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::DeletePackageVersions::set_repository): <p> The name of the repository that contains the package versions to delete. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::DeletePackageVersions::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::DeletePackageVersions::set_format): <p> The format of the package versions to delete. The valid values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DeletePackageVersions::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DeletePackageVersions::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::DeletePackageVersions::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::DeletePackageVersions::set_package): <p> The name of the package with the versions to delete. </p>
    ///   - [`versions(Vec<String>)`](crate::client::fluent_builders::DeletePackageVersions::versions) / [`set_versions(Option<Vec<String>>)`](crate::client::fluent_builders::DeletePackageVersions::set_versions): <p> An array of strings that specify the versions of the package to delete. </p>
    ///   - [`expected_status(PackageVersionStatus)`](crate::client::fluent_builders::DeletePackageVersions::expected_status) / [`set_expected_status(Option<PackageVersionStatus>)`](crate::client::fluent_builders::DeletePackageVersions::set_expected_status): <p> The expected status of the package version to delete. Valid values are: </p>  <ul>   <li> <p> <code>Published</code> </p> </li>   <li> <p> <code>Unfinished</code> </p> </li>   <li> <p> <code>Unlisted</code> </p> </li>   <li> <p> <code>Archived</code> </p> </li>   <li> <p> <code>Disposed</code> </p> </li>  </ul>
    /// - On success, responds with [`DeletePackageVersionsOutput`](crate::output::DeletePackageVersionsOutput) with field(s):
    ///   - [`successful_versions(Option<HashMap<String, SuccessfulPackageVersionInfo>>)`](crate::output::DeletePackageVersionsOutput::successful_versions): <p> A list of the package versions that were successfully deleted. </p>
    ///   - [`failed_versions(Option<HashMap<String, PackageVersionError>>)`](crate::output::DeletePackageVersionsOutput::failed_versions): <p> A <code>PackageVersionError</code> object that contains a map of errors codes for the deleted package that failed. The possible error codes are: </p>  <ul>   <li> <p> <code>ALREADY_EXISTS</code> </p> </li>   <li> <p> <code>MISMATCHED_REVISION</code> </p> </li>   <li> <p> <code>MISMATCHED_STATUS</code> </p> </li>   <li> <p> <code>NOT_ALLOWED</code> </p> </li>   <li> <p> <code>NOT_FOUND</code> </p> </li>   <li> <p> <code>SKIPPED</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DeletePackageVersionsError>`](crate::error::DeletePackageVersionsError)
    pub fn delete_package_versions(&self) -> fluent_builders::DeletePackageVersions<C, M, R> {
        fluent_builders::DeletePackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeleteRepository::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeleteRepository::set_domain): <p> The name of the domain that contains the repository to delete. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteRepository::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DeleteRepository::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::DeleteRepository::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::DeleteRepository::set_repository): <p> The name of the repository to delete. </p>
    /// - On success, responds with [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput) with field(s):
    ///   - [`repository(Option<RepositoryDescription>)`](crate::output::DeleteRepositoryOutput::repository): <p> Information about the deleted repository after processing the request. </p>
    /// - On failure, responds with [`SdkError<DeleteRepositoryError>`](crate::error::DeleteRepositoryError)
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository<C, M, R> {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRepositoryPermissionsPolicy`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::set_domain): <p> The name of the domain that contains the repository associated with the resource policy to be deleted. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::set_repository): <p> The name of the repository that is associated with the resource policy to be deleted </p>
    ///   - [`policy_revision(impl Into<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::policy_revision) / [`set_policy_revision(Option<String>)`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy::set_policy_revision): <p> The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which prevents others from accidentally overwriting your changes to the repository's resource policy. </p>
    /// - On success, responds with [`DeleteRepositoryPermissionsPolicyOutput`](crate::output::DeleteRepositoryPermissionsPolicyOutput) with field(s):
    ///   - [`policy(Option<ResourcePolicy>)`](crate::output::DeleteRepositoryPermissionsPolicyOutput::policy): <p> Information about the deleted policy after processing the request. </p>
    /// - On failure, responds with [`SdkError<DeleteRepositoryPermissionsPolicyError>`](crate::error::DeleteRepositoryPermissionsPolicyError)
    pub fn delete_repository_permissions_policy(
        &self,
    ) -> fluent_builders::DeleteRepositoryPermissionsPolicy<C, M, R> {
        fluent_builders::DeleteRepositoryPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DescribeDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DescribeDomain::set_domain): <p> A string that specifies the name of the requested domain. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeDomain::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DescribeDomain::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    /// - On success, responds with [`DescribeDomainOutput`](crate::output::DescribeDomainOutput) with field(s):
    ///   - [`domain(Option<DomainDescription>)`](crate::output::DescribeDomainOutput::domain): <p> Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you add one or more repositories. </p>
    /// - On failure, responds with [`SdkError<DescribeDomainError>`](crate::error::DescribeDomainError)
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePackageVersion`](crate::client::fluent_builders::DescribePackageVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DescribePackageVersion::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DescribePackageVersion::set_domain): <p> The name of the domain that contains the repository that contains the package version. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DescribePackageVersion::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DescribePackageVersion::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::DescribePackageVersion::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::DescribePackageVersion::set_repository): <p> The name of the repository that contains the package version. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::DescribePackageVersion::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::DescribePackageVersion::set_format): <p> A format that specifies the type of the requested package version. The valid values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DescribePackageVersion::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DescribePackageVersion::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::DescribePackageVersion::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::DescribePackageVersion::set_package): <p> The name of the requested package version. </p>
    ///   - [`package_version(impl Into<String>)`](crate::client::fluent_builders::DescribePackageVersion::package_version) / [`set_package_version(Option<String>)`](crate::client::fluent_builders::DescribePackageVersion::set_package_version): <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
    /// - On success, responds with [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput) with field(s):
    ///   - [`package_version(Option<PackageVersionDescription>)`](crate::output::DescribePackageVersionOutput::package_version): <p> A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a> object that contains information about the requested package version. </p>
    /// - On failure, responds with [`SdkError<DescribePackageVersionError>`](crate::error::DescribePackageVersionError)
    pub fn describe_package_version(&self) -> fluent_builders::DescribePackageVersion<C, M, R> {
        fluent_builders::DescribePackageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRepository`](crate::client::fluent_builders::DescribeRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DescribeRepository::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DescribeRepository::set_domain): <p> The name of the domain that contains the repository to describe. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeRepository::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DescribeRepository::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::DescribeRepository::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::DescribeRepository::set_repository): <p> A string that specifies the name of the requested repository. </p>
    /// - On success, responds with [`DescribeRepositoryOutput`](crate::output::DescribeRepositoryOutput) with field(s):
    ///   - [`repository(Option<RepositoryDescription>)`](crate::output::DescribeRepositoryOutput::repository): <p> A <code>RepositoryDescription</code> object that contains the requested repository information. </p>
    /// - On failure, responds with [`SdkError<DescribeRepositoryError>`](crate::error::DescribeRepositoryError)
    pub fn describe_repository(&self) -> fluent_builders::DescribeRepository<C, M, R> {
        fluent_builders::DescribeRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateExternalConnection`](crate::client::fluent_builders::DisassociateExternalConnection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::set_domain): <p>The name of the domain that contains the repository from which to remove the external repository. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::set_repository): <p>The name of the repository from which the external connection will be removed. </p>
    ///   - [`external_connection(impl Into<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::external_connection) / [`set_external_connection(Option<String>)`](crate::client::fluent_builders::DisassociateExternalConnection::set_external_connection): <p>The name of the external connection to be removed from the repository. </p>
    /// - On success, responds with [`DisassociateExternalConnectionOutput`](crate::output::DisassociateExternalConnectionOutput) with field(s):
    ///   - [`repository(Option<RepositoryDescription>)`](crate::output::DisassociateExternalConnectionOutput::repository): <p> The repository associated with the removed external connection. </p>
    /// - On failure, responds with [`SdkError<DisassociateExternalConnectionError>`](crate::error::DisassociateExternalConnectionError)
    pub fn disassociate_external_connection(
        &self,
    ) -> fluent_builders::DisassociateExternalConnection<C, M, R> {
        fluent_builders::DisassociateExternalConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisposePackageVersions`](crate::client::fluent_builders::DisposePackageVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::DisposePackageVersions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::DisposePackageVersions::set_domain): <p> The name of the domain that contains the repository you want to dispose. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::DisposePackageVersions::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::DisposePackageVersions::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::DisposePackageVersions::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::DisposePackageVersions::set_repository): <p> The name of the repository that contains the package versions you want to dispose. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::DisposePackageVersions::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::DisposePackageVersions::set_format): <p> A format that specifies the type of package versions you want to dispose. The valid values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::DisposePackageVersions::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::DisposePackageVersions::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::DisposePackageVersions::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::DisposePackageVersions::set_package): <p> The name of the package with the versions you want to dispose. </p>
    ///   - [`versions(Vec<String>)`](crate::client::fluent_builders::DisposePackageVersions::versions) / [`set_versions(Option<Vec<String>>)`](crate::client::fluent_builders::DisposePackageVersions::set_versions): <p> The versions of the package you want to dispose. </p>
    ///   - [`version_revisions(HashMap<String, String>)`](crate::client::fluent_builders::DisposePackageVersions::version_revisions) / [`set_version_revisions(Option<HashMap<String, String>>)`](crate::client::fluent_builders::DisposePackageVersions::set_version_revisions): <p> The revisions of the package versions you want to dispose. </p>
    ///   - [`expected_status(PackageVersionStatus)`](crate::client::fluent_builders::DisposePackageVersions::expected_status) / [`set_expected_status(Option<PackageVersionStatus>)`](crate::client::fluent_builders::DisposePackageVersions::set_expected_status): <p> The expected status of the package version to dispose. Valid values are: </p>  <ul>   <li> <p> <code>Published</code> </p> </li>   <li> <p> <code>Unfinished</code> </p> </li>   <li> <p> <code>Unlisted</code> </p> </li>   <li> <p> <code>Archived</code> </p> </li>   <li> <p> <code>Disposed</code> </p> </li>  </ul>
    /// - On success, responds with [`DisposePackageVersionsOutput`](crate::output::DisposePackageVersionsOutput) with field(s):
    ///   - [`successful_versions(Option<HashMap<String, SuccessfulPackageVersionInfo>>)`](crate::output::DisposePackageVersionsOutput::successful_versions): <p> A list of the package versions that were successfully disposed. </p>
    ///   - [`failed_versions(Option<HashMap<String, PackageVersionError>>)`](crate::output::DisposePackageVersionsOutput::failed_versions): <p> A <code>PackageVersionError</code> object that contains a map of errors codes for the disposed package versions that failed. The possible error codes are: </p>  <ul>   <li> <p> <code>ALREADY_EXISTS</code> </p> </li>   <li> <p> <code>MISMATCHED_REVISION</code> </p> </li>   <li> <p> <code>MISMATCHED_STATUS</code> </p> </li>   <li> <p> <code>NOT_ALLOWED</code> </p> </li>   <li> <p> <code>NOT_FOUND</code> </p> </li>   <li> <p> <code>SKIPPED</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<DisposePackageVersionsError>`](crate::error::DisposePackageVersionsError)
    pub fn dispose_package_versions(&self) -> fluent_builders::DisposePackageVersions<C, M, R> {
        fluent_builders::DisposePackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAuthorizationToken`](crate::client::fluent_builders::GetAuthorizationToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizationToken::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetAuthorizationToken::set_domain): <p> The name of the domain that is in scope for the generated authorization token. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::GetAuthorizationToken::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::GetAuthorizationToken::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`duration_seconds(i64)`](crate::client::fluent_builders::GetAuthorizationToken::duration_seconds) / [`set_duration_seconds(Option<i64>)`](crate::client::fluent_builders::GetAuthorizationToken::set_duration_seconds): <p>The time, in seconds, that the generated authorization token is valid. Valid values are <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours). A value of <code>0</code> will set the expiration of the authorization token to the same expiration of the user's role's temporary credentials.</p>
    /// - On success, responds with [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput) with field(s):
    ///   - [`authorization_token(Option<String>)`](crate::output::GetAuthorizationTokenOutput::authorization_token): <p> The returned authentication token. </p>
    ///   - [`expiration(Option<DateTime>)`](crate::output::GetAuthorizationTokenOutput::expiration): <p> A timestamp that specifies the date and time the authorization token expires. </p>
    /// - On failure, responds with [`SdkError<GetAuthorizationTokenError>`](crate::error::GetAuthorizationTokenError)
    pub fn get_authorization_token(&self) -> fluent_builders::GetAuthorizationToken<C, M, R> {
        fluent_builders::GetAuthorizationToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomainPermissionsPolicy`](crate::client::fluent_builders::GetDomainPermissionsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetDomainPermissionsPolicy::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetDomainPermissionsPolicy::set_domain): <p> The name of the domain to which the resource policy is attached. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::GetDomainPermissionsPolicy::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::GetDomainPermissionsPolicy::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    /// - On success, responds with [`GetDomainPermissionsPolicyOutput`](crate::output::GetDomainPermissionsPolicyOutput) with field(s):
    ///   - [`policy(Option<ResourcePolicy>)`](crate::output::GetDomainPermissionsPolicyOutput::policy): <p> The returned resource policy. </p>
    /// - On failure, responds with [`SdkError<GetDomainPermissionsPolicyError>`](crate::error::GetDomainPermissionsPolicyError)
    pub fn get_domain_permissions_policy(
        &self,
    ) -> fluent_builders::GetDomainPermissionsPolicy<C, M, R> {
        fluent_builders::GetDomainPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPackageVersionAsset`](crate::client::fluent_builders::GetPackageVersionAsset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_domain): <p> The name of the domain that contains the repository that contains the package version with the requested asset. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_repository): <p> The repository that contains the package version with the requested asset. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::GetPackageVersionAsset::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_format): <p> A format that specifies the type of the package version with the requested asset file. The valid values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_package): <p> The name of the package that contains the requested asset. </p>
    ///   - [`package_version(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::package_version) / [`set_package_version(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_package_version): <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
    ///   - [`asset(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::asset) / [`set_asset(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_asset): <p> The name of the requested asset. </p>
    ///   - [`package_version_revision(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::package_version_revision) / [`set_package_version_revision(Option<String>)`](crate::client::fluent_builders::GetPackageVersionAsset::set_package_version_revision): <p> The name of the package version revision that contains the requested asset. </p>
    /// - On success, responds with [`GetPackageVersionAssetOutput`](crate::output::GetPackageVersionAssetOutput) with field(s):
    ///   - [`asset(byte_stream::ByteStream)`](crate::output::GetPackageVersionAssetOutput::asset): <p> The binary file, or asset, that is downloaded.</p>
    ///   - [`asset_name(Option<String>)`](crate::output::GetPackageVersionAssetOutput::asset_name): <p> The name of the asset that is downloaded. </p>
    ///   - [`package_version(Option<String>)`](crate::output::GetPackageVersionAssetOutput::package_version): <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
    ///   - [`package_version_revision(Option<String>)`](crate::output::GetPackageVersionAssetOutput::package_version_revision): <p> The name of the package version revision that contains the downloaded asset. </p>
    /// - On failure, responds with [`SdkError<GetPackageVersionAssetError>`](crate::error::GetPackageVersionAssetError)
    pub fn get_package_version_asset(&self) -> fluent_builders::GetPackageVersionAsset<C, M, R> {
        fluent_builders::GetPackageVersionAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetPackageVersionReadme`](crate::client::fluent_builders::GetPackageVersionReadme) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::set_domain): <p> The name of the domain that contains the repository that contains the package version with the requested readme file. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::set_repository): <p> The repository that contains the package with the requested readme file. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::GetPackageVersionReadme::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::GetPackageVersionReadme::set_format): <p> A format that specifies the type of the package version with the requested readme file. The valid values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::set_package): <p> The name of the package version that contains the requested readme file. </p>
    ///   - [`package_version(impl Into<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::package_version) / [`set_package_version(Option<String>)`](crate::client::fluent_builders::GetPackageVersionReadme::set_package_version): <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
    /// - On success, responds with [`GetPackageVersionReadmeOutput`](crate::output::GetPackageVersionReadmeOutput) with field(s):
    ///   - [`format(Option<PackageFormat>)`](crate::output::GetPackageVersionReadmeOutput::format): <p> The format of the package with the requested readme file. Valid format types are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(Option<String>)`](crate::output::GetPackageVersionReadmeOutput::namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(Option<String>)`](crate::output::GetPackageVersionReadmeOutput::package): <p> The name of the package that contains the returned readme file. </p>
    ///   - [`version(Option<String>)`](crate::output::GetPackageVersionReadmeOutput::version): <p> The version of the package with the requested readme file. </p>
    ///   - [`version_revision(Option<String>)`](crate::output::GetPackageVersionReadmeOutput::version_revision): <p> The current revision associated with the package version. </p>
    ///   - [`readme(Option<String>)`](crate::output::GetPackageVersionReadmeOutput::readme): <p> The text of the returned readme file. </p>
    /// - On failure, responds with [`SdkError<GetPackageVersionReadmeError>`](crate::error::GetPackageVersionReadmeError)
    pub fn get_package_version_readme(&self) -> fluent_builders::GetPackageVersionReadme<C, M, R> {
        fluent_builders::GetPackageVersionReadme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRepositoryEndpoint`](crate::client::fluent_builders::GetRepositoryEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryEndpoint::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetRepositoryEndpoint::set_domain): <p> The name of the domain that contains the repository. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryEndpoint::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::GetRepositoryEndpoint::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryEndpoint::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::GetRepositoryEndpoint::set_repository): <p> The name of the repository. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::GetRepositoryEndpoint::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::GetRepositoryEndpoint::set_format): <p> Returns which endpoint of a repository to return. A repository has one endpoint for each package format: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    /// - On success, responds with [`GetRepositoryEndpointOutput`](crate::output::GetRepositoryEndpointOutput) with field(s):
    ///   - [`repository_endpoint(Option<String>)`](crate::output::GetRepositoryEndpointOutput::repository_endpoint): <p> A string that specifies the URL of the returned endpoint. </p>
    /// - On failure, responds with [`SdkError<GetRepositoryEndpointError>`](crate::error::GetRepositoryEndpointError)
    pub fn get_repository_endpoint(&self) -> fluent_builders::GetRepositoryEndpoint<C, M, R> {
        fluent_builders::GetRepositoryEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRepositoryPermissionsPolicy`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy::set_domain): <p> The name of the domain containing the repository whose associated resource policy is to be retrieved. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy::set_repository): <p> The name of the repository whose associated resource policy is to be retrieved. </p>
    /// - On success, responds with [`GetRepositoryPermissionsPolicyOutput`](crate::output::GetRepositoryPermissionsPolicyOutput) with field(s):
    ///   - [`policy(Option<ResourcePolicy>)`](crate::output::GetRepositoryPermissionsPolicyOutput::policy): <p> The returned resource policy. </p>
    /// - On failure, responds with [`SdkError<GetRepositoryPermissionsPolicyError>`](crate::error::GetRepositoryPermissionsPolicyError)
    pub fn get_repository_permissions_policy(
        &self,
    ) -> fluent_builders::GetRepositoryPermissionsPolicy<C, M, R> {
        fluent_builders::GetRepositoryPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomains`](crate::client::fluent_builders::ListDomains) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDomains::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomains::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDomains::set_max_results): <p> The maximum number of results to return per page. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomains::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomains::set_next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On success, responds with [`ListDomainsOutput`](crate::output::ListDomainsOutput) with field(s):
    ///   - [`domains(Option<Vec<DomainSummary>>)`](crate::output::ListDomainsOutput::domains): <p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainSummary.html">DomainSummary</a> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainsOutput::next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListDomainsError>`](crate::error::ListDomainsError)
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackages`](crate::client::fluent_builders::ListPackages) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPackages::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListPackages::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListPackages::set_domain): <p> The name of the domain that contains the repository that contains the requested list of packages. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::ListPackages::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::ListPackages::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::ListPackages::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::ListPackages::set_repository): <p> The name of the repository from which packages are to be listed. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::ListPackages::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::ListPackages::set_format): <p> The format of the packages. The valid package types are: </p>  <ul>   <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>   <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>   <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListPackages::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListPackages::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package_prefix(impl Into<String>)`](crate::client::fluent_builders::ListPackages::package_prefix) / [`set_package_prefix(Option<String>)`](crate::client::fluent_builders::ListPackages::set_package_prefix): <p> A prefix used to filter returned packages. Only packages with names that start with <code>packagePrefix</code> are returned. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPackages::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPackages::set_max_results): <p> The maximum number of results to return per page. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackages::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackages::set_next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On success, responds with [`ListPackagesOutput`](crate::output::ListPackagesOutput) with field(s):
    ///   - [`packages(Option<Vec<PackageSummary>>)`](crate::output::ListPackagesOutput::packages): <p> The list of returned <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPackagesOutput::next_token): <p> If there are additional results, this is the token for the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListPackagesError>`](crate::error::ListPackagesError)
    pub fn list_packages(&self) -> fluent_builders::ListPackages<C, M, R> {
        fluent_builders::ListPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackageVersionAssets`](crate::client::fluent_builders::ListPackageVersionAssets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPackageVersionAssets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_domain): <p> The name of the domain that contains the repository associated with the package version assets. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_repository): <p> The name of the repository that contains the package that contains the returned package version assets. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::ListPackageVersionAssets::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_format): <p> The format of the package that contains the returned package version assets. The valid package types are: </p>  <ul>   <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>   <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>   <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_package): <p> The name of the package that contains the returned package version assets. </p>
    ///   - [`package_version(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::package_version) / [`set_package_version(Option<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_package_version): <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPackageVersionAssets::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_max_results): <p> The maximum number of results to return per page. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackageVersionAssets::set_next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On success, responds with [`ListPackageVersionAssetsOutput`](crate::output::ListPackageVersionAssetsOutput) with field(s):
    ///   - [`format(Option<PackageFormat>)`](crate::output::ListPackageVersionAssetsOutput::format): <p> The format of the package that contains the returned package version assets. </p>
    ///   - [`namespace(Option<String>)`](crate::output::ListPackageVersionAssetsOutput::namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(Option<String>)`](crate::output::ListPackageVersionAssetsOutput::package): <p> The name of the package that contains the returned package version assets. </p>
    ///   - [`version(Option<String>)`](crate::output::ListPackageVersionAssetsOutput::version): <p> The version of the package associated with the returned assets. </p>
    ///   - [`version_revision(Option<String>)`](crate::output::ListPackageVersionAssetsOutput::version_revision): <p> The current revision associated with the package version. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPackageVersionAssetsOutput::next_token): <p> If there are additional results, this is the token for the next set of results. </p>
    ///   - [`assets(Option<Vec<AssetSummary>>)`](crate::output::ListPackageVersionAssetsOutput::assets): <p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects. </p>
    /// - On failure, responds with [`SdkError<ListPackageVersionAssetsError>`](crate::error::ListPackageVersionAssetsError)
    pub fn list_package_version_assets(
        &self,
    ) -> fluent_builders::ListPackageVersionAssets<C, M, R> {
        fluent_builders::ListPackageVersionAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackageVersionDependencies`](crate::client::fluent_builders::ListPackageVersionDependencies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_domain): <p> The name of the domain that contains the repository that contains the requested package version dependencies. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_repository): <p> The name of the repository that contains the requested package version. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::ListPackageVersionDependencies::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_format): <p> The format of the package with the requested dependencies. The valid package types are: </p>  <ul>   <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>   <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>   <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_package): <p> The name of the package versions' package. </p>
    ///   - [`package_version(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::package_version) / [`set_package_version(Option<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_package_version): <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackageVersionDependencies::set_next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On success, responds with [`ListPackageVersionDependenciesOutput`](crate::output::ListPackageVersionDependenciesOutput) with field(s):
    ///   - [`format(Option<PackageFormat>)`](crate::output::ListPackageVersionDependenciesOutput::format): <p> A format that specifies the type of the package that contains the returned dependencies. The valid values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(Option<String>)`](crate::output::ListPackageVersionDependenciesOutput::namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(Option<String>)`](crate::output::ListPackageVersionDependenciesOutput::package): <p> The name of the package that contains the returned package versions dependencies. </p>
    ///   - [`version(Option<String>)`](crate::output::ListPackageVersionDependenciesOutput::version): <p> The version of the package that is specified in the request. </p>
    ///   - [`version_revision(Option<String>)`](crate::output::ListPackageVersionDependenciesOutput::version_revision): <p> The current revision associated with the package version. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPackageVersionDependenciesOutput::next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    ///   - [`dependencies(Option<Vec<PackageDependency>>)`](crate::output::ListPackageVersionDependenciesOutput::dependencies): <p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects. </p>
    /// - On failure, responds with [`SdkError<ListPackageVersionDependenciesError>`](crate::error::ListPackageVersionDependenciesError)
    pub fn list_package_version_dependencies(
        &self,
    ) -> fluent_builders::ListPackageVersionDependencies<C, M, R> {
        fluent_builders::ListPackageVersionDependencies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPackageVersions`](crate::client::fluent_builders::ListPackageVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPackageVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersions::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListPackageVersions::set_domain): <p> The name of the domain that contains the repository that contains the returned package versions. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersions::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::ListPackageVersions::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersions::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::ListPackageVersions::set_repository): <p> The name of the repository that contains the package. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::ListPackageVersions::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::ListPackageVersions::set_format): <p> The format of the returned packages. The valid package types are: </p>  <ul>   <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>   <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>   <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersions::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::ListPackageVersions::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersions::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::ListPackageVersions::set_package): <p> The name of the package for which you want to return a list of package versions. </p>
    ///   - [`status(PackageVersionStatus)`](crate::client::fluent_builders::ListPackageVersions::status) / [`set_status(Option<PackageVersionStatus>)`](crate::client::fluent_builders::ListPackageVersions::set_status): <p> A string that specifies the status of the package versions to include in the returned list. It can be one of the following: </p>  <ul>   <li> <p> <code>Published</code> </p> </li>   <li> <p> <code>Unfinished</code> </p> </li>   <li> <p> <code>Unlisted</code> </p> </li>   <li> <p> <code>Archived</code> </p> </li>   <li> <p> <code>Disposed</code> </p> </li>  </ul>
    ///   - [`sort_by(PackageVersionSortType)`](crate::client::fluent_builders::ListPackageVersions::sort_by) / [`set_sort_by(Option<PackageVersionSortType>)`](crate::client::fluent_builders::ListPackageVersions::set_sort_by): <p> How to sort the returned list of package versions. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPackageVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPackageVersions::set_max_results): <p> The maximum number of results to return per page. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPackageVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPackageVersions::set_next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On success, responds with [`ListPackageVersionsOutput`](crate::output::ListPackageVersionsOutput) with field(s):
    ///   - [`default_display_version(Option<String>)`](crate::output::ListPackageVersionsOutput::default_display_version): <p> The default package version to display. This depends on the package format: </p>  <ul>   <li> <p> For Maven and PyPI packages, it's the most recently published package version. </p> </li>   <li> <p> For npm packages, it's the version referenced by the <code>latest</code> tag. If the <code>latest</code> tag is not set, it's the most recently published package version. </p> </li>  </ul>
    ///   - [`format(Option<PackageFormat>)`](crate::output::ListPackageVersionsOutput::format): <p> A format of the package. Valid package format values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(Option<String>)`](crate::output::ListPackageVersionsOutput::namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(Option<String>)`](crate::output::ListPackageVersionsOutput::package): <p> The name of the package. </p>
    ///   - [`versions(Option<Vec<PackageVersionSummary>>)`](crate::output::ListPackageVersionsOutput::versions): <p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPackageVersionsOutput::next_token): <p> If there are additional results, this is the token for the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListPackageVersionsError>`](crate::error::ListPackageVersionsError)
    pub fn list_package_versions(&self) -> fluent_builders::ListPackageVersions<C, M, R> {
        fluent_builders::ListPackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRepositories`](crate::client::fluent_builders::ListRepositories) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRepositories::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`repository_prefix(impl Into<String>)`](crate::client::fluent_builders::ListRepositories::repository_prefix) / [`set_repository_prefix(Option<String>)`](crate::client::fluent_builders::ListRepositories::set_repository_prefix): <p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRepositories::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRepositories::set_max_results): <p> The maximum number of results to return per page. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRepositories::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRepositories::set_next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On success, responds with [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput) with field(s):
    ///   - [`repositories(Option<Vec<RepositorySummary>>)`](crate::output::ListRepositoriesOutput::repositories): <p> The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a> objects. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRepositoriesOutput::next_token): <p> If there are additional results, this is the token for the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListRepositoriesError>`](crate::error::ListRepositoriesError)
    pub fn list_repositories(&self) -> fluent_builders::ListRepositories<C, M, R> {
        fluent_builders::ListRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRepositoriesInDomain`](crate::client::fluent_builders::ListRepositoriesInDomain) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRepositoriesInDomain::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::set_domain): <p> The name of the domain that contains the returned list of repositories. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`administrator_account(impl Into<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::administrator_account) / [`set_administrator_account(Option<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::set_administrator_account): <p> Filter the list of repositories to only include those that are managed by the AWS account ID. </p>
    ///   - [`repository_prefix(impl Into<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::repository_prefix) / [`set_repository_prefix(Option<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::set_repository_prefix): <p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRepositoriesInDomain::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRepositoriesInDomain::set_max_results): <p> The maximum number of results to return per page. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRepositoriesInDomain::set_next_token): <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
    /// - On success, responds with [`ListRepositoriesInDomainOutput`](crate::output::ListRepositoriesInDomainOutput) with field(s):
    ///   - [`repositories(Option<Vec<RepositorySummary>>)`](crate::output::ListRepositoriesInDomainOutput::repositories): <p> The returned list of repositories. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRepositoriesInDomainOutput::next_token): <p> If there are additional results, this is the token for the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListRepositoriesInDomainError>`](crate::error::ListRepositoriesInDomainError)
    pub fn list_repositories_in_domain(
        &self,
    ) -> fluent_builders::ListRepositoriesInDomain<C, M, R> {
        fluent_builders::ListRepositoriesInDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A list of tag key and value pairs associated with the specified resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDomainPermissionsPolicy`](crate::client::fluent_builders::PutDomainPermissionsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::set_domain): <p> The name of the domain on which to set the resource policy. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`policy_revision(impl Into<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::policy_revision) / [`set_policy_revision(Option<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::set_policy_revision): <p> The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. </p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::PutDomainPermissionsPolicy::set_policy_document): <p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided domain. </p>
    /// - On success, responds with [`PutDomainPermissionsPolicyOutput`](crate::output::PutDomainPermissionsPolicyOutput) with field(s):
    ///   - [`policy(Option<ResourcePolicy>)`](crate::output::PutDomainPermissionsPolicyOutput::policy): <p> The resource policy that was set after processing the request. </p>
    /// - On failure, responds with [`SdkError<PutDomainPermissionsPolicyError>`](crate::error::PutDomainPermissionsPolicyError)
    pub fn put_domain_permissions_policy(
        &self,
    ) -> fluent_builders::PutDomainPermissionsPolicy<C, M, R> {
        fluent_builders::PutDomainPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRepositoryPermissionsPolicy`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::set_domain): <p> The name of the domain containing the repository to set the resource policy on. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::set_repository): <p> The name of the repository to set the resource policy on. </p>
    ///   - [`policy_revision(impl Into<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::policy_revision) / [`set_policy_revision(Option<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::set_policy_revision): <p> Sets the revision of the resource policy that specifies permissions to access the repository. This revision is used for optimistic locking, which prevents others from overwriting your changes to the repository's resource policy. </p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy::set_policy_document): <p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided repository. </p>
    /// - On success, responds with [`PutRepositoryPermissionsPolicyOutput`](crate::output::PutRepositoryPermissionsPolicyOutput) with field(s):
    ///   - [`policy(Option<ResourcePolicy>)`](crate::output::PutRepositoryPermissionsPolicyOutput::policy): <p> The resource policy that was set after processing the request. </p>
    /// - On failure, responds with [`SdkError<PutRepositoryPermissionsPolicyError>`](crate::error::PutRepositoryPermissionsPolicyError)
    pub fn put_repository_permissions_policy(
        &self,
    ) -> fluent_builders::PutRepositoryPermissionsPolicy<C, M, R> {
        fluent_builders::PutRepositoryPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags you want to modify or add to the resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag key for each tag that you want to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePackageVersionsStatus`](crate::client::fluent_builders::UpdatePackageVersionsStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_domain): <p> The name of the domain that contains the repository that contains the package versions with a status to be updated. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_repository): <p> The repository that contains the package versions with the status you want to update. </p>
    ///   - [`format(PackageFormat)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::format) / [`set_format(Option<PackageFormat>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_format): <p> A format that specifies the type of the package with the statuses to update. The valid values are: </p>  <ul>   <li> <p> <code>npm</code> </p> </li>   <li> <p> <code>pypi</code> </p> </li>   <li> <p> <code>maven</code> </p> </li>  </ul>
    ///   - [`namespace(impl Into<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::namespace) / [`set_namespace(Option<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_namespace): <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>  <ul>   <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>   <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>   <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>  </ul>
    ///   - [`package(impl Into<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::package) / [`set_package(Option<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_package): <p> The name of the package with the version statuses to update. </p>
    ///   - [`versions(Vec<String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::versions) / [`set_versions(Option<Vec<String>>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_versions): <p> An array of strings that specify the versions of the package with the statuses to update. </p>
    ///   - [`version_revisions(HashMap<String, String>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::version_revisions) / [`set_version_revisions(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_version_revisions): <p> A map of package versions and package version revisions. The map <code>key</code> is the package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the package version revision. </p>
    ///   - [`expected_status(PackageVersionStatus)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::expected_status) / [`set_expected_status(Option<PackageVersionStatus>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_expected_status): <p> The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the package version's status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>. </p>
    ///   - [`target_status(PackageVersionStatus)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::target_status) / [`set_target_status(Option<PackageVersionStatus>)`](crate::client::fluent_builders::UpdatePackageVersionsStatus::set_target_status): <p> The status you want to change the package version status to. </p>
    /// - On success, responds with [`UpdatePackageVersionsStatusOutput`](crate::output::UpdatePackageVersionsStatusOutput) with field(s):
    ///   - [`successful_versions(Option<HashMap<String, SuccessfulPackageVersionInfo>>)`](crate::output::UpdatePackageVersionsStatusOutput::successful_versions): <p> A list of <code>PackageVersionError</code> objects, one for each package version with a status that failed to update. </p>
    ///   - [`failed_versions(Option<HashMap<String, PackageVersionError>>)`](crate::output::UpdatePackageVersionsStatusOutput::failed_versions): <p> A list of <code>SuccessfulPackageVersionInfo</code> objects, one for each package version with a status that successfully updated. </p>
    /// - On failure, responds with [`SdkError<UpdatePackageVersionsStatusError>`](crate::error::UpdatePackageVersionsStatusError)
    pub fn update_package_versions_status(
        &self,
    ) -> fluent_builders::UpdatePackageVersionsStatus<C, M, R> {
        fluent_builders::UpdatePackageVersionsStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRepository`](crate::client::fluent_builders::UpdateRepository) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::UpdateRepository::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::UpdateRepository::set_domain): <p> The name of the domain associated with the repository to update. </p>
    ///   - [`domain_owner(impl Into<String>)`](crate::client::fluent_builders::UpdateRepository::domain_owner) / [`set_domain_owner(Option<String>)`](crate::client::fluent_builders::UpdateRepository::set_domain_owner): <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
    ///   - [`repository(impl Into<String>)`](crate::client::fluent_builders::UpdateRepository::repository) / [`set_repository(Option<String>)`](crate::client::fluent_builders::UpdateRepository::set_repository): <p> The name of the repository to update. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRepository::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRepository::set_description): <p> An updated repository description. </p>
    ///   - [`upstreams(Vec<UpstreamRepository>)`](crate::client::fluent_builders::UpdateRepository::upstreams) / [`set_upstreams(Option<Vec<UpstreamRepository>>)`](crate::client::fluent_builders::UpdateRepository::set_upstreams): <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    /// - On success, responds with [`UpdateRepositoryOutput`](crate::output::UpdateRepositoryOutput) with field(s):
    ///   - [`repository(Option<RepositoryDescription>)`](crate::output::UpdateRepositoryOutput::repository): <p> The updated repository. </p>
    /// - On failure, responds with [`SdkError<UpdateRepositoryError>`](crate::error::UpdateRepositoryError)
    pub fn update_repository(&self) -> fluent_builders::UpdateRepository<C, M, R> {
        fluent_builders::UpdateRepository::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateExternalConnection`.
    ///
    /// <p>Adds an existing external connection to a repository. One external connection is allowed per repository.</p> <note>
    /// <p>A repository can have one or more upstream repositories, or an external connection.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateExternalConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_external_connection_input::Builder,
    }
    impl<C, M, R> AssociateExternalConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateExternalConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateExternalConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateExternalConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateExternalConnectionInputOperationOutputAlias,
                crate::output::AssociateExternalConnectionOutput,
                crate::error::AssociateExternalConnectionError,
                crate::input::AssociateExternalConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the repository.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain that contains the repository.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to which the external connection is added. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository to which the external connection is added. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The name of the external connection to add to the repository. The following values are supported: </p>
        /// <ul>
        /// <li> <p> <code>public:npmjs</code> - for the npm public repository. </p> </li>
        /// <li> <p> <code>public:pypi</code> - for the Python Package Index. </p> </li>
        /// <li> <p> <code>public:maven-central</code> - for Maven Central. </p> </li>
        /// <li> <p> <code>public:maven-googleandroid</code> - for the Google Android repository. </p> </li>
        /// <li> <p> <code>public:maven-gradleplugins</code> - for the Gradle plugins repository. </p> </li>
        /// <li> <p> <code>public:maven-commonsware</code> - for the CommonsWare Android repository. </p> </li>
        /// </ul>
        pub fn external_connection(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_connection(input.into());
            self
        }
        /// <p> The name of the external connection to add to the repository. The following values are supported: </p>
        /// <ul>
        /// <li> <p> <code>public:npmjs</code> - for the npm public repository. </p> </li>
        /// <li> <p> <code>public:pypi</code> - for the Python Package Index. </p> </li>
        /// <li> <p> <code>public:maven-central</code> - for Maven Central. </p> </li>
        /// <li> <p> <code>public:maven-googleandroid</code> - for the Google Android repository. </p> </li>
        /// <li> <p> <code>public:maven-gradleplugins</code> - for the Gradle plugins repository. </p> </li>
        /// <li> <p> <code>public:maven-commonsware</code> - for the CommonsWare Android repository. </p> </li>
        /// </ul>
        pub fn set_external_connection(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_connection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyPackageVersions`.
    ///
    /// <p> Copies package versions from one repository to another repository in the same domain. </p> <note>
    /// <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyPackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_package_versions_input::Builder,
    }
    impl<C, M, R> CopyPackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyPackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyPackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyPackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyPackageVersionsInputOperationOutputAlias,
                crate::output::CopyPackageVersionsOutput,
                crate::error::CopyPackageVersionsError,
                crate::input::CopyPackageVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the source and destination repositories. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the source and destination repositories. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the package versions to copy. </p>
        pub fn source_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_repository(input.into());
            self
        }
        /// <p> The name of the repository that contains the package versions to copy. </p>
        pub fn set_source_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_repository(input);
            self
        }
        /// <p> The name of the repository into which package versions are copied. </p>
        pub fn destination_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_repository(input.into());
            self
        }
        /// <p> The name of the repository into which package versions are copied. </p>
        pub fn set_destination_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_repository(input);
            self
        }
        /// <p> The format of the package that is copied. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> The format of the package that is copied. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package that is copied. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package that is copied. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p> The versions of the package to copy. </p> <note>
        /// <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p>
        /// </note>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(input.into());
            self
        }
        /// <p> The versions of the package to copy. </p> <note>
        /// <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p>
        /// </note>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// Adds a key-value pair to `versionRevisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p> A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source repository match the specified package version revision. </p> <note>
        /// <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p>
        /// </note>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.version_revisions(k.into(), v.into());
            self
        }
        /// <p> A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation succeeds if the specified versions in the source repository match the specified package version revision. </p> <note>
        /// <p> You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both. </p>
        /// </note>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_version_revisions(input);
            self
        }
        /// <p> Set to true to overwrite a package version that already exists in the destination repository. If set to false and the package version already exists in the destination repository, the package version is returned in the <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code> error code. </p>
        pub fn allow_overwrite(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_overwrite(input);
            self
        }
        /// <p> Set to true to overwrite a package version that already exists in the destination repository. If set to false and the package version already exists in the destination repository, the package version is returned in the <code>failedVersions</code> field of the response with an <code>ALREADY_EXISTS</code> error code. </p>
        pub fn set_allow_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_overwrite(input);
            self
        }
        /// <p> Set to true to copy packages from repositories that are upstream from the source repository to the destination repository. The default setting is false. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn include_from_upstream(mut self, input: bool) -> Self {
            self.inner = self.inner.include_from_upstream(input);
            self
        }
        /// <p> Set to true to copy packages from repositories that are upstream from the source repository to the destination repository. The default setting is false. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_include_from_upstream(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_from_upstream(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p> Creates a domain. CodeArtifact <i>domains</i> make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different AWS accounts. An asset is stored only once in a domain, even if it's in multiple repositories. </p>
    /// <p>Although you can have multiple domains, we recommend a single production domain that contains all published artifacts so that your development teams can find and share packages. You can use a second pre-production domain to test changes to the production domain configuration. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain to create. All domain names in an AWS Region that are in the same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a domain name because it is publicly discoverable. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain to create. All domain names in an AWS Region that are in the same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do not use sensitive information in a domain name because it is publicly discoverable. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p> <important>
        /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// </important>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(input.into());
            self
        }
        /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain. An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p> <important>
        /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// </important>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the domain.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tag key-value pairs for the domain.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p> Creates a repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl<C, M, R> CreateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRepositoryInputOperationOutputAlias,
                crate::output::CreateRepositoryOutput,
                crate::error::CreateRepositoryError,
                crate::input::CreateRepositoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the created repository. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the created repository. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to create. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository to create. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> A description of the created repository. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> A description of the created repository. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `upstreams`.
        ///
        /// To override the contents of this collection use [`set_upstreams`](Self::set_upstreams).
        ///
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn upstreams(mut self, input: crate::model::UpstreamRepository) -> Self {
            self.inner = self.inner.upstreams(input);
            self
        }
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_upstreams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
        ) -> Self {
            self.inner = self.inner.set_upstreams(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the repository.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tag key-value pairs for the repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p> Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain to delete. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain to delete. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainPermissionsPolicy`.
    ///
    /// <p> Deletes the resource policy set on a domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomainPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_permissions_policy_input::Builder,
    }
    impl<C, M, R> DeleteDomainPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainPermissionsPolicyInputOperationOutputAlias,
                crate::output::DeleteDomainPermissionsPolicyOutput,
                crate::error::DeleteDomainPermissionsPolicyError,
                crate::input::DeleteDomainPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain associated with the resource policy to be deleted. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain associated with the resource policy to be deleted. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(input.into());
            self
        }
        /// <p> The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackageVersions`.
    ///
    /// <p> Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to <code>Archived</code>. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListackageVersions</a>), but you can restore them using <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html">UpdatePackageVersionsStatus</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_package_versions_input::Builder,
    }
    impl<C, M, R> DeletePackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePackageVersionsInputOperationOutputAlias,
                crate::output::DeletePackageVersionsOutput,
                crate::error::DeletePackageVersionsError,
                crate::input::DeletePackageVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the package to delete. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the package to delete. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the package versions to delete. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository that contains the package versions to delete. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The format of the package versions to delete. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> The format of the package versions to delete. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package with the versions to delete. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package with the versions to delete. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p> An array of strings that specify the versions of the package to delete. </p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(input.into());
            self
        }
        /// <p> An array of strings that specify the versions of the package to delete. </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// <p> The expected status of the package version to delete. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>Published</code> </p> </li>
        /// <li> <p> <code>Unfinished</code> </p> </li>
        /// <li> <p> <code>Unlisted</code> </p> </li>
        /// <li> <p> <code>Archived</code> </p> </li>
        /// <li> <p> <code>Disposed</code> </p> </li>
        /// </ul>
        pub fn expected_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.expected_status(input);
            self
        }
        /// <p> The expected status of the package version to delete. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>Published</code> </p> </li>
        /// <li> <p> <code>Unfinished</code> </p> </li>
        /// <li> <p> <code>Unlisted</code> </p> </li>
        /// <li> <p> <code>Archived</code> </p> </li>
        /// <li> <p> <code>Disposed</code> </p> </li>
        /// </ul>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_expected_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p> Deletes a repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl<C, M, R> DeleteRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryInputOperationOutputAlias,
                crate::output::DeleteRepositoryOutput,
                crate::error::DeleteRepositoryError,
                crate::input::DeleteRepositoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository to delete. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository to delete. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to delete. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository to delete. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepositoryPermissionsPolicy`.
    ///
    /// <p> Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate. </p> <important>
    /// <p> Use <code>DeleteRepositoryPermissionsPolicy</code> with caution. After a policy is deleted, AWS users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRepositoryPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_permissions_policy_input::Builder,
    }
    impl<C, M, R> DeleteRepositoryPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepositoryPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryPermissionsPolicyInputOperationOutputAlias,
                crate::output::DeleteRepositoryPermissionsPolicyOutput,
                crate::error::DeleteRepositoryPermissionsPolicyError,
                crate::input::DeleteRepositoryPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository associated with the resource policy to be deleted. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository associated with the resource policy to be deleted. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that is associated with the resource policy to be deleted </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository that is associated with the resource policy to be deleted </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which prevents others from accidentally overwriting your changes to the repository's resource policy. </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(input.into());
            self
        }
        /// <p> The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which prevents others from accidentally overwriting your changes to the repository's resource policy. </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p> Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html">DomainDescription</a> object that contains information about the requested domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A string that specifies the name of the requested domain. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> A string that specifies the name of the requested domain. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackageVersion`.
    ///
    /// <p> Returns a <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a> object that contains information about the requested package version. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePackageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_package_version_input::Builder,
    }
    impl<C, M, R> DescribePackageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePackageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePackageVersionInputOperationOutputAlias,
                crate::output::DescribePackageVersionOutput,
                crate::error::DescribePackageVersionError,
                crate::input::DescribePackageVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository that contains the package version. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository that contains the package version. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the package version. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository that contains the package version. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> A format that specifies the type of the requested package version. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> A format that specifies the type of the requested package version. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the requested package version. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the requested package version. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRepository`.
    ///
    /// <p> Returns a <code>RepositoryDescription</code> object that contains detailed information about the requested repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_repository_input::Builder,
    }
    impl<C, M, R> DescribeRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRepositoryInputOperationOutputAlias,
                crate::output::DescribeRepositoryOutput,
                crate::error::DescribeRepositoryError,
                crate::input::DescribeRepositoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository to describe. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository to describe. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> A string that specifies the name of the requested repository. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> A string that specifies the name of the requested repository. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateExternalConnection`.
    ///
    /// <p> Removes an existing external connection from a repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateExternalConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_external_connection_input::Builder,
    }
    impl<C, M, R> DisassociateExternalConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateExternalConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateExternalConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateExternalConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateExternalConnectionInputOperationOutputAlias,
                crate::output::DisassociateExternalConnectionOutput,
                crate::error::DisassociateExternalConnectionError,
                crate::input::DisassociateExternalConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the repository from which to remove the external repository. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The name of the domain that contains the repository from which to remove the external repository. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>The name of the repository from which the external connection will be removed. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p>The name of the repository from which the external connection will be removed. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>The name of the external connection to be removed from the repository. </p>
        pub fn external_connection(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_connection(input.into());
            self
        }
        /// <p>The name of the external connection to be removed from the repository. </p>
        pub fn set_external_connection(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_connection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisposePackageVersions`.
    ///
    /// <p> Deletes the assets in package versions and sets the package versions' status to <code>Disposed</code>. A disposed package version cannot be restored in your repository because its assets are deleted. </p>
    /// <p> To view all disposed package versions in a repository, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListPackageVersions</a> and set the <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax">status</a> parameter to <code>Disposed</code>. </p>
    /// <p> To view information about a disposed package version, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html">DescribePackageVersion</a>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisposePackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::dispose_package_versions_input::Builder,
    }
    impl<C, M, R> DisposePackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisposePackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisposePackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisposePackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisposePackageVersionsInputOperationOutputAlias,
                crate::output::DisposePackageVersionsOutput,
                crate::error::DisposePackageVersionsError,
                crate::input::DisposePackageVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository you want to dispose. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository you want to dispose. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the package versions you want to dispose. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository that contains the package versions you want to dispose. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> A format that specifies the type of package versions you want to dispose. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> A format that specifies the type of package versions you want to dispose. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package with the versions you want to dispose. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package with the versions you want to dispose. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p> The versions of the package you want to dispose. </p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(input.into());
            self
        }
        /// <p> The versions of the package you want to dispose. </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// Adds a key-value pair to `versionRevisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p> The revisions of the package versions you want to dispose. </p>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.version_revisions(k.into(), v.into());
            self
        }
        /// <p> The revisions of the package versions you want to dispose. </p>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_version_revisions(input);
            self
        }
        /// <p> The expected status of the package version to dispose. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>Published</code> </p> </li>
        /// <li> <p> <code>Unfinished</code> </p> </li>
        /// <li> <p> <code>Unlisted</code> </p> </li>
        /// <li> <p> <code>Archived</code> </p> </li>
        /// <li> <p> <code>Disposed</code> </p> </li>
        /// </ul>
        pub fn expected_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.expected_status(input);
            self
        }
        /// <p> The expected status of the package version to dispose. Valid values are: </p>
        /// <ul>
        /// <li> <p> <code>Published</code> </p> </li>
        /// <li> <p> <code>Unfinished</code> </p> </li>
        /// <li> <p> <code>Unlisted</code> </p> </li>
        /// <li> <p> <code>Archived</code> </p> </li>
        /// <li> <p> <code>Disposed</code> </p> </li>
        /// </ul>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_expected_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizationToken`.
    ///
    /// <p> Generates a temporary authorization token for accessing repositories in the domain. This API requires the <code>codeartifact:GetAuthorizationToken</code> and <code>sts:GetServiceBearerToken</code> permissions. For more information about authorization tokens, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html">AWS CodeArtifact authentication and tokens</a>. </p> <note>
    /// <p>CodeArtifact authorization tokens are valid for a period of 12 hours when created with the <code>login</code> command. You can call <code>login</code> periodically to refresh the token. When you create an authorization token with the <code>GetAuthorizationToken</code> API, you can set a custom authorization period, up to a maximum of 12 hours, with the <code>durationSeconds</code> parameter.</p>
    /// <p>The authorization period begins after <code>login</code> or <code>GetAuthorizationToken</code> is called. If <code>login</code> or <code>GetAuthorizationToken</code> is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call <code>sts assume-role</code> and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration.</p>
    /// <p>See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM Roles</a> for more information on controlling session duration. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAuthorizationToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorization_token_input::Builder,
    }
    impl<C, M, R> GetAuthorizationToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizationToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizationTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizationTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizationTokenInputOperationOutputAlias,
                crate::output::GetAuthorizationTokenOutput,
                crate::error::GetAuthorizationTokenError,
                crate::input::GetAuthorizationTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that is in scope for the generated authorization token. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that is in scope for the generated authorization token. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours). A value of <code>0</code> will set the expiration of the authorization token to the same expiration of the user's role's temporary credentials.</p>
        pub fn duration_seconds(mut self, input: i64) -> Self {
            self.inner = self.inner.duration_seconds(input);
            self
        }
        /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours). A value of <code>0</code> will set the expiration of the authorization token to the same expiration of the user's role's temporary credentials.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_duration_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainPermissionsPolicy`.
    ///
    /// <p> Returns the resource policy attached to the specified domain. </p> <note>
    /// <p> The policy is a resource-based policy, not an identity-based policy. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies and resource-based policies </a> in the <i>AWS Identity and Access Management User Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomainPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_permissions_policy_input::Builder,
    }
    impl<C, M, R> GetDomainPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainPermissionsPolicyInputOperationOutputAlias,
                crate::output::GetDomainPermissionsPolicyOutput,
                crate::error::GetDomainPermissionsPolicyError,
                crate::input::GetDomainPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain to which the resource policy is attached. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain to which the resource policy is attached. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionAsset`.
    ///
    /// <p> Returns an asset (or file) that is in a package. For example, for a Maven package version, use <code>GetPackageVersionAsset</code> to download a <code>JAR</code> file, a <code>POM</code> file, or any other assets in the package version. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPackageVersionAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_package_version_asset_input::Builder,
    }
    impl<C, M, R> GetPackageVersionAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPackageVersionAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPackageVersionAssetInputOperationOutputAlias,
                crate::output::GetPackageVersionAssetOutput,
                crate::error::GetPackageVersionAssetError,
                crate::input::GetPackageVersionAssetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository that contains the package version with the requested asset. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository that contains the package version with the requested asset. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The repository that contains the package version with the requested asset. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The repository that contains the package version with the requested asset. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> A format that specifies the type of the package version with the requested asset file. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> A format that specifies the type of the package version with the requested asset file. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package that contains the requested asset. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package that contains the requested asset. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p> The name of the requested asset. </p>
        pub fn asset(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset(input.into());
            self
        }
        /// <p> The name of the requested asset. </p>
        pub fn set_asset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset(input);
            self
        }
        /// <p> The name of the package version revision that contains the requested asset. </p>
        pub fn package_version_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version_revision(input.into());
            self
        }
        /// <p> The name of the package version revision that contains the requested asset. </p>
        pub fn set_package_version_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionReadme`.
    ///
    /// <p> Gets the readme file or descriptive text for a package version. For packages that do not contain a readme file, CodeArtifact extracts a description from a metadata file. For example, from the <code>
    /// <description></description></code> element in the <code>pom.xml</code> file of a Maven package. </p>
    /// <p> The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetPackageVersionReadme<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_package_version_readme_input::Builder,
    }
    impl<C, M, R> GetPackageVersionReadme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPackageVersionReadme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionReadmeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionReadmeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPackageVersionReadmeInputOperationOutputAlias,
                crate::output::GetPackageVersionReadmeOutput,
                crate::error::GetPackageVersionReadmeError,
                crate::input::GetPackageVersionReadmeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository that contains the package version with the requested readme file. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository that contains the package version with the requested readme file. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The repository that contains the package with the requested readme file. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The repository that contains the package with the requested readme file. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> A format that specifies the type of the package version with the requested readme file. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> A format that specifies the type of the package version with the requested readme file. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package version that contains the requested readme file. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package version that contains the requested readme file. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryEndpoint`.
    ///
    /// <p> Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format: </p>
    /// <ul>
    /// <li> <p> <code>npm</code> </p> </li>
    /// <li> <p> <code>pypi</code> </p> </li>
    /// <li> <p> <code>maven</code> </p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRepositoryEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_endpoint_input::Builder,
    }
    impl<C, M, R> GetRepositoryEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryEndpointInputOperationOutputAlias,
                crate::output::GetRepositoryEndpointOutput,
                crate::error::GetRepositoryEndpointError,
                crate::input::GetRepositoryEndpointInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> Returns which endpoint of a repository to return. A repository has one endpoint for each package format: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> Returns which endpoint of a repository to return. A repository has one endpoint for each package format: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryPermissionsPolicy`.
    ///
    /// <p> Returns the resource policy that is set on a repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRepositoryPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_permissions_policy_input::Builder,
    }
    impl<C, M, R> GetRepositoryPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryPermissionsPolicyInputOperationOutputAlias,
                crate::output::GetRepositoryPermissionsPolicyOutput,
                crate::error::GetRepositoryPermissionsPolicyError,
                crate::input::GetRepositoryPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain containing the repository whose associated resource policy is to be retrieved. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain containing the repository whose associated resource policy is to be retrieved. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository whose associated resource policy is to be retrieved. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository whose associated resource policy is to be retrieved. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">DomainSummary</a> objects for all domains owned by the AWS account that makes this call. Each returned <code>DomainSummary</code> object contains information about a domain. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDomainsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDomainsPaginator<C, M, R> {
            crate::paginator::ListDomainsPaginator::new(self.handle, self.inner)
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackages`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a> objects for packages in a repository that match the request parameters. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_packages_input::Builder,
    }
    impl<C, M, R> ListPackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackagesInputOperationOutputAlias,
                crate::output::ListPackagesOutput,
                crate::error::ListPackagesError,
                crate::input::ListPackagesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackagesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackagesPaginator<C, M, R> {
            crate::paginator::ListPackagesPaginator::new(self.handle, self.inner)
        }
        /// <p> The name of the domain that contains the repository that contains the requested list of packages. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository that contains the requested list of packages. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository from which packages are to be listed. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository from which packages are to be listed. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The format of the packages. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> The format of the packages. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> A prefix used to filter returned packages. Only packages with names that start with <code>packagePrefix</code> are returned. </p>
        pub fn package_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_prefix(input.into());
            self
        }
        /// <p> A prefix used to filter returned packages. Only packages with names that start with <code>packagePrefix</code> are returned. </p>
        pub fn set_package_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_prefix(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackageVersionAssets`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects for assets in a package version. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackageVersionAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_package_version_assets_input::Builder,
    }
    impl<C, M, R> ListPackageVersionAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackageVersionAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackageVersionAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackageVersionAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackageVersionAssetsInputOperationOutputAlias,
                crate::output::ListPackageVersionAssetsOutput,
                crate::error::ListPackageVersionAssetsError,
                crate::input::ListPackageVersionAssetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackageVersionAssetsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListPackageVersionAssetsPaginator<C, M, R> {
            crate::paginator::ListPackageVersionAssetsPaginator::new(self.handle, self.inner)
        }
        /// <p> The name of the domain that contains the repository associated with the package version assets. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository associated with the package version assets. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the package that contains the returned package version assets. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository that contains the package that contains the returned package version assets. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The format of the package that contains the returned package version assets. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> The format of the package that contains the returned package version assets. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package that contains the returned package version assets. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package that contains the returned package version assets. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackageVersionDependencies`.
    ///
    /// <p> Returns the direct dependencies for a package version. The dependencies are returned as <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the <code>package.json</code> file for npm packages and the <code>pom.xml</code> file for Maven). Any package version dependencies that are not listed in the configuration file are not returned. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackageVersionDependencies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_package_version_dependencies_input::Builder,
    }
    impl<C, M, R> ListPackageVersionDependencies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackageVersionDependencies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackageVersionDependenciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackageVersionDependenciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackageVersionDependenciesInputOperationOutputAlias,
                crate::output::ListPackageVersionDependenciesOutput,
                crate::error::ListPackageVersionDependenciesError,
                crate::input::ListPackageVersionDependenciesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository that contains the requested package version dependencies. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository that contains the requested package version dependencies. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the requested package version. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository that contains the requested package version. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The format of the package with the requested dependencies. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> The format of the package with the requested dependencies. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package versions' package. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package versions' package. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(input.into());
            self
        }
        /// <p> A string that contains the package version (for example, <code>3.5.2</code>). </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackageVersions`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a> objects for package versions in a repository that match the request parameters. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_package_versions_input::Builder,
    }
    impl<C, M, R> ListPackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackageVersionsInputOperationOutputAlias,
                crate::output::ListPackageVersionsOutput,
                crate::error::ListPackageVersionsError,
                crate::input::ListPackageVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPackageVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPackageVersionsPaginator<C, M, R> {
            crate::paginator::ListPackageVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p> The name of the domain that contains the repository that contains the returned package versions. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository that contains the returned package versions. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the package. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository that contains the package. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> The format of the returned packages. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> The format of the returned packages. The valid package types are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code>: A Node Package Manager (npm) package. </p> </li>
        /// <li> <p> <code>pypi</code>: A Python Package Index (PyPI) package. </p> </li>
        /// <li> <p> <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file. </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package for which you want to return a list of package versions. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package for which you want to return a list of package versions. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p> A string that specifies the status of the package versions to include in the returned list. It can be one of the following: </p>
        /// <ul>
        /// <li> <p> <code>Published</code> </p> </li>
        /// <li> <p> <code>Unfinished</code> </p> </li>
        /// <li> <p> <code>Unlisted</code> </p> </li>
        /// <li> <p> <code>Archived</code> </p> </li>
        /// <li> <p> <code>Disposed</code> </p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p> A string that specifies the status of the package versions to include in the returned list. It can be one of the following: </p>
        /// <ul>
        /// <li> <p> <code>Published</code> </p> </li>
        /// <li> <p> <code>Unfinished</code> </p> </li>
        /// <li> <p> <code>Unlisted</code> </p> </li>
        /// <li> <p> <code>Archived</code> </p> </li>
        /// <li> <p> <code>Disposed</code> </p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p> How to sort the returned list of package versions. </p>
        pub fn sort_by(mut self, input: crate::model::PackageVersionSortType) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p> How to sort the returned list of package versions. </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::PackageVersionSortType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositories`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in the specified AWS account and that matches the input parameters. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repositories_input::Builder,
    }
    impl<C, M, R> ListRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoriesInputOperationOutputAlias,
                crate::output::ListRepositoriesOutput,
                crate::error::ListRepositoriesError,
                crate::input::ListRepositoriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRepositoriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRepositoriesPaginator<C, M, R> {
            crate::paginator::ListRepositoriesPaginator::new(self.handle, self.inner)
        }
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned.</p>
        pub fn repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_prefix(input.into());
            self
        }
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned.</p>
        pub fn set_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_prefix(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositoriesInDomain`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a> objects. Each <code>RepositorySummary</code> contains information about a repository in the specified domain and that matches the input parameters. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRepositoriesInDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repositories_in_domain_input::Builder,
    }
    impl<C, M, R> ListRepositoriesInDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositoriesInDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesInDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoriesInDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoriesInDomainInputOperationOutputAlias,
                crate::output::ListRepositoriesInDomainOutput,
                crate::error::ListRepositoriesInDomainError,
                crate::input::ListRepositoriesInDomainInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRepositoriesInDomainPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRepositoriesInDomainPaginator<C, M, R> {
            crate::paginator::ListRepositoriesInDomainPaginator::new(self.handle, self.inner)
        }
        /// <p> The name of the domain that contains the returned list of repositories. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the returned list of repositories. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> Filter the list of repositories to only include those that are managed by the AWS account ID. </p>
        pub fn administrator_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.administrator_account(input.into());
            self
        }
        /// <p> Filter the list of repositories to only include those that are managed by the AWS account ID. </p>
        pub fn set_administrator_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_administrator_account(input);
            self
        }
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned. </p>
        pub fn repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_prefix(input.into());
            self
        }
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start with <code>repositoryPrefix</code> are returned. </p>
        pub fn set_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_prefix(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of results to return per page. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeArtifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDomainPermissionsPolicy`.
    ///
    /// <p> Sets a resource policy on a domain that specifies permissions to access it. </p>
    /// <p> When you call <code>PutDomainPermissionsPolicy</code>, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDomainPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_domain_permissions_policy_input::Builder,
    }
    impl<C, M, R> PutDomainPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDomainPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDomainPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDomainPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDomainPermissionsPolicyInputOperationOutputAlias,
                crate::output::PutDomainPermissionsPolicyOutput,
                crate::error::PutDomainPermissionsPolicyError,
                crate::input::PutDomainPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain on which to set the resource policy. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain on which to set the resource policy. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(input.into());
            self
        }
        /// <p> The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided domain. </p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided domain. </p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRepositoryPermissionsPolicy`.
    ///
    /// <p> Sets the resource policy on a repository that specifies permissions to access it. </p>
    /// <p> When you call <code>PutRepositoryPermissionsPolicy</code>, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRepositoryPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_repository_permissions_policy_input::Builder,
    }
    impl<C, M, R> PutRepositoryPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRepositoryPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRepositoryPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRepositoryPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRepositoryPermissionsPolicyInputOperationOutputAlias,
                crate::output::PutRepositoryPermissionsPolicyOutput,
                crate::error::PutRepositoryPermissionsPolicyError,
                crate::input::PutRepositoryPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain containing the repository to set the resource policy on. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain containing the repository to set the resource policy on. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to set the resource policy on. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository to set the resource policy on. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> Sets the revision of the resource policy that specifies permissions to access the repository. This revision is used for optimistic locking, which prevents others from overwriting your changes to the repository's resource policy. </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(input.into());
            self
        }
        /// <p> Sets the revision of the resource policy that specifies permissions to access the repository. This revision is used for optimistic locking, which prevents others from overwriting your changes to the repository's resource policy. </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided repository. </p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided repository. </p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for a resource in AWS CodeArtifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource in AWS CodeArtifact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePackageVersionsStatus`.
    ///
    /// <p> Updates the status of one or more versions of a package. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePackageVersionsStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_package_versions_status_input::Builder,
    }
    impl<C, M, R> UpdatePackageVersionsStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePackageVersionsStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePackageVersionsStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePackageVersionsStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePackageVersionsStatusInputOperationOutputAlias,
                crate::output::UpdatePackageVersionsStatusOutput,
                crate::error::UpdatePackageVersionsStatusError,
                crate::input::UpdatePackageVersionsStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain that contains the repository that contains the package versions with a status to be updated. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain that contains the repository that contains the package versions with a status to be updated. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The repository that contains the package versions with the status you want to update. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The repository that contains the package versions with the status you want to update. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> A format that specifies the type of the package with the statuses to update. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(input);
            self
        }
        /// <p> A format that specifies the type of the package with the statuses to update. The valid values are: </p>
        /// <ul>
        /// <li> <p> <code>npm</code> </p> </li>
        /// <li> <p> <code>pypi</code> </p> </li>
        /// <li> <p> <code>maven</code> </p> </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(input.into());
            self
        }
        /// <p> The namespace of the package. The package component that specifies its namespace depends on its type. For example: </p>
        /// <ul>
        /// <li> <p> The namespace of a Maven package is its <code>groupId</code>. </p> </li>
        /// <li> <p> The namespace of an npm package is its <code>scope</code>. </p> </li>
        /// <li> <p> A Python package does not contain a corresponding component, so Python packages do not have a namespace. </p> </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the package with the version statuses to update. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(input.into());
            self
        }
        /// <p> The name of the package with the version statuses to update. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p> An array of strings that specify the versions of the package with the statuses to update. </p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(input.into());
            self
        }
        /// <p> An array of strings that specify the versions of the package with the statuses to update. </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// Adds a key-value pair to `versionRevisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p> A map of package versions and package version revisions. The map <code>key</code> is the package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the package version revision. </p>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.version_revisions(k.into(), v.into());
            self
        }
        /// <p> A map of package versions and package version revisions. The map <code>key</code> is the package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the package version revision. </p>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_version_revisions(input);
            self
        }
        /// <p> The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the package version's status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>. </p>
        pub fn expected_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.expected_status(input);
            self
        }
        /// <p> The package version’s expected status before it is updated. If <code>expectedStatus</code> is provided, the package version's status is updated only if its status at the time <code>UpdatePackageVersionsStatus</code> is called matches <code>expectedStatus</code>. </p>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_expected_status(input);
            self
        }
        /// <p> The status you want to change the package version status to. </p>
        pub fn target_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.target_status(input);
            self
        }
        /// <p> The status you want to change the package version status to. </p>
        pub fn set_target_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_target_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRepository`.
    ///
    /// <p> Update the properties of a repository. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_repository_input::Builder,
    }
    impl<C, M, R> UpdateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRepositoryInputOperationOutputAlias,
                crate::output::UpdateRepositoryOutput,
                crate::error::UpdateRepositoryError,
                crate::input::UpdateRepositoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain associated with the repository to update. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p> The name of the domain associated with the repository to update. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to update. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(input.into());
            self
        }
        /// <p> The name of the repository to update. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p> An updated repository description. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p> An updated repository description. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `upstreams`.
        ///
        /// To override the contents of this collection use [`set_upstreams`](Self::set_upstreams).
        ///
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn upstreams(mut self, input: crate::model::UpstreamRepository) -> Self {
            self.inner = self.inner.upstreams(input);
            self
        }
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_upstreams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
        ) -> Self {
            self.inner = self.inner.set_upstreams(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
