// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateExternalConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateExternalConnectionError {
    /// Kind of error that occurred.
    pub kind: AssociateExternalConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateExternalConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateExternalConnectionErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateExternalConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateExternalConnectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AssociateExternalConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateExternalConnectionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AssociateExternalConnectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateExternalConnectionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateExternalConnectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateExternalConnectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AssociateExternalConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateExternalConnectionError {
    fn code(&self) -> Option<&str> {
        AssociateExternalConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateExternalConnectionError {
    /// Creates a new `AssociateExternalConnectionError`.
    pub fn new(kind: AssociateExternalConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateExternalConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateExternalConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateExternalConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateExternalConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateExternalConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateExternalConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateExternalConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateExternalConnectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateExternalConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateExternalConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateExternalConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateExternalConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateExternalConnectionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateExternalConnectionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateExternalConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateExternalConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateExternalConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateExternalConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AssociateExternalConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateExternalConnectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AssociateExternalConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateExternalConnectionErrorKind::InternalServerException(_inner) => Some(_inner),
            AssociateExternalConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateExternalConnectionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            AssociateExternalConnectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateExternalConnectionErrorKind::ValidationException(_inner) => Some(_inner),
            AssociateExternalConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyPackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyPackageVersionsError {
    /// Kind of error that occurred.
    pub kind: CopyPackageVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyPackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyPackageVersionsErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyPackageVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyPackageVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CopyPackageVersionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CopyPackageVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CopyPackageVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CopyPackageVersionsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CopyPackageVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CopyPackageVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CopyPackageVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyPackageVersionsError {
    fn code(&self) -> Option<&str> {
        CopyPackageVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyPackageVersionsError {
    /// Creates a new `CopyPackageVersionsError`.
    pub fn new(kind: CopyPackageVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyPackageVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyPackageVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyPackageVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyPackageVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyPackageVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyPackageVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyPackageVersionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyPackageVersionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyPackageVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyPackageVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyPackageVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyPackageVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyPackageVersionsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyPackageVersionsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyPackageVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyPackageVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CopyPackageVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopyPackageVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CopyPackageVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyPackageVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CopyPackageVersionsErrorKind::ConflictException(_inner) => Some(_inner),
            CopyPackageVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            CopyPackageVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CopyPackageVersionsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CopyPackageVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            CopyPackageVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            CopyPackageVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainError {
    /// Kind of error that occurred.
    pub kind: CreateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainError {
    fn code(&self) -> Option<&str> {
        CreateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainError {
    /// Creates a new `CreateDomainError`.
    pub fn new(kind: CreateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDomainErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDomainErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDomainErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRepositoryError {
    /// Kind of error that occurred.
    pub kind: CreateRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRepositoryErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRepositoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRepositoryError {
    fn code(&self) -> Option<&str> {
        CreateRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRepositoryError {
    /// Creates a new `CreateRepositoryError`.
    pub fn new(kind: CreateRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateRepositoryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRepositoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRepositoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRepositoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ConflictException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::ValidationException(_inner) => Some(_inner),
            CreateRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainError {
    fn code(&self) -> Option<&str> {
        DeleteDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainError {
    /// Creates a new `DeleteDomainError`.
    pub fn new(kind: DeleteDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomainPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainPermissionsPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainPermissionsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomainPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainPermissionsPolicyErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainPermissionsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainPermissionsPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDomainPermissionsPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDomainPermissionsPolicyErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteDomainPermissionsPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDomainPermissionsPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDomainPermissionsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainPermissionsPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteDomainPermissionsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainPermissionsPolicyError {
    /// Creates a new `DeleteDomainPermissionsPolicyError`.
    pub fn new(
        kind: DeleteDomainPermissionsPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainPermissionsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainPermissionsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainPermissionsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainPermissionsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainPermissionsPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainPermissionsPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainPermissionsPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainPermissionsPolicyErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainPermissionsPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainPermissionsPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainPermissionsPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainPermissionsPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainPermissionsPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainPermissionsPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainPermissionsPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteDomainPermissionsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainPermissionsPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDomainPermissionsPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDomainPermissionsPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteDomainPermissionsPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDomainPermissionsPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDomainPermissionsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePackageVersionsError {
    /// Kind of error that occurred.
    pub kind: DeletePackageVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePackageVersionsErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePackageVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePackageVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeletePackageVersionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePackageVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeletePackageVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeletePackageVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeletePackageVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeletePackageVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePackageVersionsError {
    fn code(&self) -> Option<&str> {
        DeletePackageVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePackageVersionsError {
    /// Creates a new `DeletePackageVersionsError`.
    pub fn new(kind: DeletePackageVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePackageVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePackageVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePackageVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePackageVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePackageVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageVersionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageVersionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePackageVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePackageVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeletePackageVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePackageVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeletePackageVersionsErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePackageVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            DeletePackageVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeletePackageVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeletePackageVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            DeletePackageVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRepositoryError {
    /// Creates a new `DeleteRepositoryError`.
    pub fn new(kind: DeleteRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteRepositoryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRepositoryPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRepositoryPermissionsPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteRepositoryPermissionsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRepositoryPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRepositoryPermissionsPolicyErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRepositoryPermissionsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteRepositoryPermissionsPolicyErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRepositoryPermissionsPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteRepositoryPermissionsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRepositoryPermissionsPolicyError {
    /// Creates a new `DeleteRepositoryPermissionsPolicyError`.
    pub fn new(
        kind: DeleteRepositoryPermissionsPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRepositoryPermissionsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRepositoryPermissionsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRepositoryPermissionsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRepositoryPermissionsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPermissionsPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPermissionsPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPermissionsPolicyErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPermissionsPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPermissionsPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPermissionsPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPermissionsPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRepositoryPermissionsPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRepositoryPermissionsPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteRepositoryPermissionsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteRepositoryPermissionsPolicyErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteRepositoryPermissionsPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteRepositoryPermissionsPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteRepositoryPermissionsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDomainError {
    /// Kind of error that occurred.
    pub kind: DescribeDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDomainErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDomainError {
    fn code(&self) -> Option<&str> {
        DescribeDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDomainError {
    /// Creates a new `DescribeDomainError`.
    pub fn new(kind: DescribeDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeDomainErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDomainErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePackageVersionError {
    /// Kind of error that occurred.
    pub kind: DescribePackageVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePackageVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePackageVersionErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePackageVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePackageVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribePackageVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePackageVersionError {
    fn code(&self) -> Option<&str> {
        DescribePackageVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePackageVersionError {
    /// Creates a new `DescribePackageVersionError`.
    pub fn new(kind: DescribePackageVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePackageVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePackageVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePackageVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePackageVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePackageVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePackageVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribePackageVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePackageVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::ConflictException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::ValidationException(_inner) => Some(_inner),
            DescribePackageVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRepositoryError {
    /// Kind of error that occurred.
    pub kind: DescribeRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRepositoryErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRepositoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeRepositoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeRepositoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRepositoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRepositoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRepositoryError {
    fn code(&self) -> Option<&str> {
        DescribeRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRepositoryError {
    /// Creates a new `DescribeRepositoryError`.
    pub fn new(kind: DescribeRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRepositoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRepositoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRepositoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRepositoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeRepositoryErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeRepositoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRepositoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRepositoryErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateExternalConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateExternalConnectionError {
    /// Kind of error that occurred.
    pub kind: DisassociateExternalConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateExternalConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateExternalConnectionErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateExternalConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateExternalConnectionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateExternalConnectionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateExternalConnectionErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateExternalConnectionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateExternalConnectionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateExternalConnectionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateExternalConnectionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateExternalConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateExternalConnectionError {
    fn code(&self) -> Option<&str> {
        DisassociateExternalConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateExternalConnectionError {
    /// Creates a new `DisassociateExternalConnectionError`.
    pub fn new(
        kind: DisassociateExternalConnectionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateExternalConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateExternalConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateExternalConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateExternalConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateExternalConnectionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateExternalConnectionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateExternalConnectionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateExternalConnectionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateExternalConnectionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateExternalConnectionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateExternalConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateExternalConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateExternalConnectionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateExternalConnectionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateExternalConnectionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateExternalConnectionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateExternalConnectionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateExternalConnectionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateExternalConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateExternalConnectionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateExternalConnectionErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateExternalConnectionErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateExternalConnectionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateExternalConnectionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            DisassociateExternalConnectionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateExternalConnectionErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateExternalConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisposePackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisposePackageVersionsError {
    /// Kind of error that occurred.
    pub kind: DisposePackageVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisposePackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisposePackageVersionsErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisposePackageVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisposePackageVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisposePackageVersionsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisposePackageVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisposePackageVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisposePackageVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisposePackageVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisposePackageVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisposePackageVersionsError {
    fn code(&self) -> Option<&str> {
        DisposePackageVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisposePackageVersionsError {
    /// Creates a new `DisposePackageVersionsError`.
    pub fn new(kind: DisposePackageVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisposePackageVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisposePackageVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisposePackageVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisposePackageVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisposePackageVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisposePackageVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisposePackageVersionsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisposePackageVersionsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisposePackageVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisposePackageVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisposePackageVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisposePackageVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisposePackageVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisposePackageVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisposePackageVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisposePackageVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisposePackageVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisposePackageVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisposePackageVersionsErrorKind::ConflictException(_inner) => Some(_inner),
            DisposePackageVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            DisposePackageVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisposePackageVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisposePackageVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            DisposePackageVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAuthorizationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAuthorizationTokenError {
    /// Kind of error that occurred.
    pub kind: GetAuthorizationTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAuthorizationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAuthorizationTokenErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAuthorizationTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAuthorizationTokenErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAuthorizationTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAuthorizationTokenError {
    fn code(&self) -> Option<&str> {
        GetAuthorizationTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAuthorizationTokenError {
    /// Creates a new `GetAuthorizationTokenError`.
    pub fn new(kind: GetAuthorizationTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAuthorizationTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAuthorizationTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAuthorizationTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAuthorizationTokenErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAuthorizationTokenErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAuthorizationTokenErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAuthorizationTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAuthorizationTokenErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::ValidationException(_inner) => Some(_inner),
            GetAuthorizationTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomainPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainPermissionsPolicyError {
    /// Kind of error that occurred.
    pub kind: GetDomainPermissionsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomainPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainPermissionsPolicyErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainPermissionsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainPermissionsPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDomainPermissionsPolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDomainPermissionsPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDomainPermissionsPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetDomainPermissionsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainPermissionsPolicyError {
    fn code(&self) -> Option<&str> {
        GetDomainPermissionsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainPermissionsPolicyError {
    /// Creates a new `GetDomainPermissionsPolicyError`.
    pub fn new(kind: GetDomainPermissionsPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainPermissionsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainPermissionsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainPermissionsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainPermissionsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainPermissionsPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainPermissionsPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainPermissionsPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainPermissionsPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainPermissionsPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainPermissionsPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainPermissionsPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainPermissionsPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainPermissionsPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetDomainPermissionsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainPermissionsPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDomainPermissionsPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDomainPermissionsPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDomainPermissionsPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            GetDomainPermissionsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPackageVersionAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPackageVersionAssetError {
    /// Kind of error that occurred.
    pub kind: GetPackageVersionAssetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPackageVersionAsset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPackageVersionAssetErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPackageVersionAssetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPackageVersionAssetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPackageVersionAssetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetPackageVersionAssetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPackageVersionAssetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPackageVersionAssetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPackageVersionAssetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPackageVersionAssetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPackageVersionAssetError {
    fn code(&self) -> Option<&str> {
        GetPackageVersionAssetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPackageVersionAssetError {
    /// Creates a new `GetPackageVersionAssetError`.
    pub fn new(kind: GetPackageVersionAssetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPackageVersionAssetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPackageVersionAssetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPackageVersionAssetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPackageVersionAssetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPackageVersionAssetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionAssetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionAssetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionAssetErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionAssetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionAssetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionAssetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionAssetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionAssetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionAssetErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionAssetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionAssetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPackageVersionAssetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPackageVersionAssetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPackageVersionAssetErrorKind::ConflictException(_inner) => Some(_inner),
            GetPackageVersionAssetErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPackageVersionAssetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPackageVersionAssetErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPackageVersionAssetErrorKind::ValidationException(_inner) => Some(_inner),
            GetPackageVersionAssetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPackageVersionReadme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPackageVersionReadmeError {
    /// Kind of error that occurred.
    pub kind: GetPackageVersionReadmeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPackageVersionReadme` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPackageVersionReadmeErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPackageVersionReadmeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPackageVersionReadmeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetPackageVersionReadmeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetPackageVersionReadmeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetPackageVersionReadmeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetPackageVersionReadmeErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetPackageVersionReadmeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPackageVersionReadmeError {
    fn code(&self) -> Option<&str> {
        GetPackageVersionReadmeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPackageVersionReadmeError {
    /// Creates a new `GetPackageVersionReadmeError`.
    pub fn new(kind: GetPackageVersionReadmeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPackageVersionReadmeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPackageVersionReadmeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPackageVersionReadmeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPackageVersionReadmeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPackageVersionReadmeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionReadmeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionReadmeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionReadmeErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionReadmeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionReadmeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionReadmeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionReadmeErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPackageVersionReadmeErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPackageVersionReadmeErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetPackageVersionReadmeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPackageVersionReadmeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetPackageVersionReadmeErrorKind::InternalServerException(_inner) => Some(_inner),
            GetPackageVersionReadmeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetPackageVersionReadmeErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetPackageVersionReadmeErrorKind::ValidationException(_inner) => Some(_inner),
            GetPackageVersionReadmeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepositoryEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryEndpointError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepositoryEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryEndpointErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryEndpointErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRepositoryEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetRepositoryEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetRepositoryEndpointErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRepositoryEndpointErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRepositoryEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryEndpointError {
    fn code(&self) -> Option<&str> {
        GetRepositoryEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRepositoryEndpointError {
    /// Creates a new `GetRepositoryEndpointError`.
    pub fn new(kind: GetRepositoryEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryEndpointErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryEndpointErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryEndpointErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryEndpointErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryEndpointErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryEndpointErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRepositoryEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryEndpointErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRepositoryEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            GetRepositoryEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetRepositoryEndpointErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRepositoryEndpointErrorKind::ValidationException(_inner) => Some(_inner),
            GetRepositoryEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRepositoryPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRepositoryPermissionsPolicyError {
    /// Kind of error that occurred.
    pub kind: GetRepositoryPermissionsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRepositoryPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRepositoryPermissionsPolicyErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRepositoryPermissionsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRepositoryPermissionsPolicyErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetRepositoryPermissionsPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetRepositoryPermissionsPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetRepositoryPermissionsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRepositoryPermissionsPolicyError {
    fn code(&self) -> Option<&str> {
        GetRepositoryPermissionsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRepositoryPermissionsPolicyError {
    /// Creates a new `GetRepositoryPermissionsPolicyError`.
    pub fn new(
        kind: GetRepositoryPermissionsPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRepositoryPermissionsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRepositoryPermissionsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRepositoryPermissionsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRepositoryPermissionsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRepositoryPermissionsPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPermissionsPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPermissionsPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPermissionsPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPermissionsPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRepositoryPermissionsPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRepositoryPermissionsPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetRepositoryPermissionsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRepositoryPermissionsPolicyErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetRepositoryPermissionsPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetRepositoryPermissionsPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            GetRepositoryPermissionsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsError {
    /// Kind of error that occurred.
    pub kind: ListDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsError {
    fn code(&self) -> Option<&str> {
        ListDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsError {
    /// Creates a new `ListDomainsError`.
    pub fn new(kind: ListDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListDomainsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDomainsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDomainsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDomainsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackagesError {
    /// Kind of error that occurred.
    pub kind: ListPackagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackagesErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackagesError {
    fn code(&self) -> Option<&str> {
        ListPackagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackagesError {
    /// Creates a new `ListPackagesError`.
    pub fn new(kind: ListPackagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackagesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackagesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListPackagesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListPackagesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListPackagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackagesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPackagesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPackagesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPackagesErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackageVersionAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackageVersionAssetsError {
    /// Kind of error that occurred.
    pub kind: ListPackageVersionAssetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackageVersionAssets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackageVersionAssetsErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackageVersionAssetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackageVersionAssetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackageVersionAssetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPackageVersionAssetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPackageVersionAssetsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPackageVersionAssetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackageVersionAssetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackageVersionAssetsError {
    fn code(&self) -> Option<&str> {
        ListPackageVersionAssetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackageVersionAssetsError {
    /// Creates a new `ListPackageVersionAssetsError`.
    pub fn new(kind: ListPackageVersionAssetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackageVersionAssetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackageVersionAssetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackageVersionAssetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackageVersionAssetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackageVersionAssetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionAssetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionAssetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionAssetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionAssetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionAssetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionAssetsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionAssetsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionAssetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionAssetsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPackageVersionAssetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackageVersionAssetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackageVersionAssetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPackageVersionAssetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPackageVersionAssetsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPackageVersionAssetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackageVersionAssetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackageVersionDependencies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackageVersionDependenciesError {
    /// Kind of error that occurred.
    pub kind: ListPackageVersionDependenciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackageVersionDependencies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackageVersionDependenciesErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackageVersionDependenciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackageVersionDependenciesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackageVersionDependenciesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListPackageVersionDependenciesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListPackageVersionDependenciesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPackageVersionDependenciesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackageVersionDependenciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackageVersionDependenciesError {
    fn code(&self) -> Option<&str> {
        ListPackageVersionDependenciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackageVersionDependenciesError {
    /// Creates a new `ListPackageVersionDependenciesError`.
    pub fn new(
        kind: ListPackageVersionDependenciesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackageVersionDependenciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackageVersionDependenciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackageVersionDependenciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackageVersionDependenciesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackageVersionDependenciesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionDependenciesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionDependenciesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionDependenciesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionDependenciesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionDependenciesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionDependenciesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionDependenciesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionDependenciesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionDependenciesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPackageVersionDependenciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackageVersionDependenciesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackageVersionDependenciesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListPackageVersionDependenciesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListPackageVersionDependenciesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPackageVersionDependenciesErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackageVersionDependenciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPackageVersionsError {
    /// Kind of error that occurred.
    pub kind: ListPackageVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPackageVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPackageVersionsErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPackageVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPackageVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListPackageVersionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListPackageVersionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPackageVersionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPackageVersionsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListPackageVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPackageVersionsError {
    fn code(&self) -> Option<&str> {
        ListPackageVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPackageVersionsError {
    /// Creates a new `ListPackageVersionsError`.
    pub fn new(kind: ListPackageVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPackageVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPackageVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPackageVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPackageVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPackageVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPackageVersionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPackageVersionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListPackageVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPackageVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListPackageVersionsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListPackageVersionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPackageVersionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPackageVersionsErrorKind::ValidationException(_inner) => Some(_inner),
            ListPackageVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRepositoriesError {
    /// Kind of error that occurred.
    pub kind: ListRepositoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRepositories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRepositoriesErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRepositoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRepositoriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRepositoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRepositoriesError {
    fn code(&self) -> Option<&str> {
        ListRepositoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRepositoriesError {
    /// Creates a new `ListRepositoriesError`.
    pub fn new(kind: ListRepositoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRepositoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRepositoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRepositoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRepositoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRepositoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRepositoriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::ValidationException(_inner) => Some(_inner),
            ListRepositoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRepositoriesInDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRepositoriesInDomainError {
    /// Kind of error that occurred.
    pub kind: ListRepositoriesInDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRepositoriesInDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRepositoriesInDomainErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRepositoriesInDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRepositoriesInDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListRepositoriesInDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListRepositoriesInDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRepositoriesInDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRepositoriesInDomainErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListRepositoriesInDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRepositoriesInDomainError {
    fn code(&self) -> Option<&str> {
        ListRepositoriesInDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRepositoriesInDomainError {
    /// Creates a new `ListRepositoriesInDomainError`.
    pub fn new(kind: ListRepositoriesInDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRepositoriesInDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRepositoriesInDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRepositoriesInDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRepositoriesInDomainErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRepositoriesInDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesInDomainErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesInDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesInDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesInDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesInDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesInDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesInDomainErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRepositoriesInDomainErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRepositoriesInDomainErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListRepositoriesInDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRepositoriesInDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListRepositoriesInDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            ListRepositoriesInDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRepositoriesInDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRepositoriesInDomainErrorKind::ValidationException(_inner) => Some(_inner),
            ListRepositoriesInDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDomainPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDomainPermissionsPolicyError {
    /// Kind of error that occurred.
    pub kind: PutDomainPermissionsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDomainPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDomainPermissionsPolicyErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDomainPermissionsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDomainPermissionsPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutDomainPermissionsPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutDomainPermissionsPolicyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutDomainPermissionsPolicyErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutDomainPermissionsPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutDomainPermissionsPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutDomainPermissionsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDomainPermissionsPolicyError {
    fn code(&self) -> Option<&str> {
        PutDomainPermissionsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDomainPermissionsPolicyError {
    /// Creates a new `PutDomainPermissionsPolicyError`.
    pub fn new(kind: PutDomainPermissionsPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDomainPermissionsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDomainPermissionsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDomainPermissionsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDomainPermissionsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDomainPermissionsPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDomainPermissionsPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDomainPermissionsPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDomainPermissionsPolicyErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDomainPermissionsPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDomainPermissionsPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDomainPermissionsPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDomainPermissionsPolicyErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDomainPermissionsPolicyErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDomainPermissionsPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDomainPermissionsPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDomainPermissionsPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDomainPermissionsPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutDomainPermissionsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDomainPermissionsPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutDomainPermissionsPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            PutDomainPermissionsPolicyErrorKind::InternalServerException(_inner) => Some(_inner),
            PutDomainPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutDomainPermissionsPolicyErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            PutDomainPermissionsPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutDomainPermissionsPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutDomainPermissionsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRepositoryPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRepositoryPermissionsPolicyError {
    /// Kind of error that occurred.
    pub kind: PutRepositoryPermissionsPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRepositoryPermissionsPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRepositoryPermissionsPolicyErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRepositoryPermissionsPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutRepositoryPermissionsPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutRepositoryPermissionsPolicyErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryPermissionsPolicyErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutRepositoryPermissionsPolicyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutRepositoryPermissionsPolicyErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutRepositoryPermissionsPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRepositoryPermissionsPolicyError {
    fn code(&self) -> Option<&str> {
        PutRepositoryPermissionsPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRepositoryPermissionsPolicyError {
    /// Creates a new `PutRepositoryPermissionsPolicyError`.
    pub fn new(
        kind: PutRepositoryPermissionsPolicyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRepositoryPermissionsPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRepositoryPermissionsPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRepositoryPermissionsPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRepositoryPermissionsPolicyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRepositoryPermissionsPolicyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryPermissionsPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryPermissionsPolicyErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryPermissionsPolicyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryPermissionsPolicyErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryPermissionsPolicyErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryPermissionsPolicyErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryPermissionsPolicyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryPermissionsPolicyErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRepositoryPermissionsPolicyErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRepositoryPermissionsPolicyErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutRepositoryPermissionsPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRepositoryPermissionsPolicyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutRepositoryPermissionsPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            PutRepositoryPermissionsPolicyErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            PutRepositoryPermissionsPolicyErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutRepositoryPermissionsPolicyErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            PutRepositoryPermissionsPolicyErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutRepositoryPermissionsPolicyErrorKind::ValidationException(_inner) => Some(_inner),
            PutRepositoryPermissionsPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePackageVersionsStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePackageVersionsStatusError {
    /// Kind of error that occurred.
    pub kind: UpdatePackageVersionsStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePackageVersionsStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePackageVersionsStatusErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePackageVersionsStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePackageVersionsStatusErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdatePackageVersionsStatusErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePackageVersionsStatusErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdatePackageVersionsStatusErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdatePackageVersionsStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdatePackageVersionsStatusErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdatePackageVersionsStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePackageVersionsStatusError {
    fn code(&self) -> Option<&str> {
        UpdatePackageVersionsStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePackageVersionsStatusError {
    /// Creates a new `UpdatePackageVersionsStatusError`.
    pub fn new(kind: UpdatePackageVersionsStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePackageVersionsStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePackageVersionsStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePackageVersionsStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePackageVersionsStatusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePackageVersionsStatusErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageVersionsStatusErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackageVersionsStatusErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageVersionsStatusErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackageVersionsStatusErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageVersionsStatusErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackageVersionsStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageVersionsStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackageVersionsStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageVersionsStatusErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePackageVersionsStatusErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePackageVersionsStatusErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdatePackageVersionsStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePackageVersionsStatusErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdatePackageVersionsStatusErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePackageVersionsStatusErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdatePackageVersionsStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdatePackageVersionsStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdatePackageVersionsStatusErrorKind::ValidationException(_inner) => Some(_inner),
            UpdatePackageVersionsStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRepositoryError {
    /// Kind of error that occurred.
    pub kind: UpdateRepositoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRepository` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRepositoryErrorKind {
    /// <p> The operation did not succeed because of an unauthorized access attempt. </p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p> The operation did not succeed because prerequisites are not met. </p>
    ConflictException(crate::error::ConflictException),
    /// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
    InternalServerException(crate::error::InternalServerException),
    /// <p> The operation did not succeed because the resource requested is not found in the service. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p> The operation did not succeed because too many requests are sent to the service. </p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRepositoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRepositoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateRepositoryErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateRepositoryErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateRepositoryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRepositoryErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateRepositoryErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRepositoryErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateRepositoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRepositoryError {
    fn code(&self) -> Option<&str> {
        UpdateRepositoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRepositoryError {
    /// Creates a new `UpdateRepositoryError`.
    pub fn new(kind: UpdateRepositoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRepositoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRepositoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRepositoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRepositoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRepositoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRepositoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRepositoryErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateRepositoryErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateRepositoryErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRepositoryErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRepositoryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRepositoryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRepositoryErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRepositoryErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRepositoryErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRepositoryErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRepositoryErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRepositoryErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateRepositoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRepositoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateRepositoryErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateRepositoryErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateRepositoryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRepositoryErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateRepositoryErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRepositoryErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateRepositoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p> The operation did not succeed because a parameter in the request was sent with an invalid value. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p> </p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
}
impl ValidationException {
    /// <p> </p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> </p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p> </p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p> The operation did not succeed because too many requests are sent to the service. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p> The time period, in seconds, to wait before retrying the request. </p>
    pub retry_after_seconds: std::option::Option<i32>,
}
impl ThrottlingException {
    /// <p> The time period, in seconds, to wait before retrying the request. </p>
    pub fn retry_after_seconds(&self) -> std::option::Option<i32> {
        self.retry_after_seconds
    }
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The time period, in seconds, to wait before retrying the request. </p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p> The time period, in seconds, to wait before retrying the request. </p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p> The operation did not succeed because it would have exceeded a service limit for your account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p> The ID of the resource. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p> The type of AWS resource. </p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl ServiceQuotaExceededException {
    /// <p> The ID of the resource. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p> The type of AWS resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The ID of the resource. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p> The ID of the resource. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p> The type of AWS resource. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p> The type of AWS resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p> The operation did not succeed because the resource requested is not found in the service. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p> The ID of the resource. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p> The type of AWS resource. </p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl ResourceNotFoundException {
    /// <p> The ID of the resource. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p> The type of AWS resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The ID of the resource. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p> The ID of the resource. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p> The type of AWS resource. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p> The type of AWS resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p> The operation did not succeed because of an error that occurred inside AWS CodeArtifact. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p> The operation did not succeed because prerequisites are not met. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p> The ID of the resource. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p> The type of AWS resource. </p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl ConflictException {
    /// <p> The ID of the resource. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p> The type of AWS resource. </p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p> The ID of the resource. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p> The ID of the resource. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p> The type of AWS resource. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p> The type of AWS resource. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p> The operation did not succeed because of an unauthorized access attempt. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
