// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRepositoryOutput {
    /// <p>
    /// The updated repository.
    /// </p>
    pub repository: std::option::Option<crate::model::RepositoryDescription>,
}
impl UpdateRepositoryOutput {
    /// <p>
    /// The updated repository.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&crate::model::RepositoryDescription> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for UpdateRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`UpdateRepositoryOutput`](crate::output::UpdateRepositoryOutput)
pub mod update_repository_output {
    /// A builder for [`UpdateRepositoryOutput`](crate::output::UpdateRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::RepositoryDescription>,
    }
    impl Builder {
        /// <p>
        /// The updated repository.
        /// </p>
        pub fn repository(mut self, input: crate::model::RepositoryDescription) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>
        /// The updated repository.
        /// </p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryDescription>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRepositoryOutput`](crate::output::UpdateRepositoryOutput)
        pub fn build(self) -> crate::output::UpdateRepositoryOutput {
            crate::output::UpdateRepositoryOutput {
                repository: self.repository,
            }
        }
    }
}
impl UpdateRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryOutput`](crate::output::UpdateRepositoryOutput)
    pub fn builder() -> crate::output::update_repository_output::Builder {
        crate::output::update_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackageVersionsStatusOutput {
    /// <p>
    /// A list of <code>PackageVersionError</code> objects, one for each package version with
    /// a status that failed to update.
    /// </p>
    pub successful_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    >,
    /// <p> A list of <code>SuccessfulPackageVersionInfo</code> objects, one for each package version
    /// with a status that successfully updated. </p>
    pub failed_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    >,
}
impl UpdatePackageVersionsStatusOutput {
    /// <p>
    /// A list of <code>PackageVersionError</code> objects, one for each package version with
    /// a status that failed to update.
    /// </p>
    pub fn successful_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    > {
        self.successful_versions.as_ref()
    }
    /// <p> A list of <code>SuccessfulPackageVersionInfo</code> objects, one for each package version
    /// with a status that successfully updated. </p>
    pub fn failed_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    > {
        self.failed_versions.as_ref()
    }
}
impl std::fmt::Debug for UpdatePackageVersionsStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackageVersionsStatusOutput");
        formatter.field("successful_versions", &self.successful_versions);
        formatter.field("failed_versions", &self.failed_versions);
        formatter.finish()
    }
}
/// See [`UpdatePackageVersionsStatusOutput`](crate::output::UpdatePackageVersionsStatusOutput)
pub mod update_package_versions_status_output {
    /// A builder for [`UpdatePackageVersionsStatusOutput`](crate::output::UpdatePackageVersionsStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_versions: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::SuccessfulPackageVersionInfo,
            >,
        >,
        pub(crate) failed_versions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `successful_versions`.
        ///
        /// To override the contents of this collection use [`set_successful_versions`](Self::set_successful_versions).
        ///
        /// <p>
        /// A list of <code>PackageVersionError</code> objects, one for each package version with
        /// a status that failed to update.
        /// </p>
        pub fn successful_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::SuccessfulPackageVersionInfo>,
        ) -> Self {
            let mut hash_map = self.successful_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.successful_versions = Some(hash_map);
            self
        }
        /// <p>
        /// A list of <code>PackageVersionError</code> objects, one for each package version with
        /// a status that failed to update.
        /// </p>
        pub fn set_successful_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::SuccessfulPackageVersionInfo,
                >,
            >,
        ) -> Self {
            self.successful_versions = input;
            self
        }
        /// Adds a key-value pair to `failed_versions`.
        ///
        /// To override the contents of this collection use [`set_failed_versions`](Self::set_failed_versions).
        ///
        /// <p> A list of <code>SuccessfulPackageVersionInfo</code> objects, one for each package version
        /// with a status that successfully updated. </p>
        pub fn failed_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PackageVersionError>,
        ) -> Self {
            let mut hash_map = self.failed_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.failed_versions = Some(hash_map);
            self
        }
        /// <p> A list of <code>SuccessfulPackageVersionInfo</code> objects, one for each package version
        /// with a status that successfully updated. </p>
        pub fn set_failed_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
            >,
        ) -> Self {
            self.failed_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackageVersionsStatusOutput`](crate::output::UpdatePackageVersionsStatusOutput)
        pub fn build(self) -> crate::output::UpdatePackageVersionsStatusOutput {
            crate::output::UpdatePackageVersionsStatusOutput {
                successful_versions: self.successful_versions,
                failed_versions: self.failed_versions,
            }
        }
    }
}
impl UpdatePackageVersionsStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePackageVersionsStatusOutput`](crate::output::UpdatePackageVersionsStatusOutput)
    pub fn builder() -> crate::output::update_package_versions_status_output::Builder {
        crate::output::update_package_versions_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRepositoryPermissionsPolicyOutput {
    /// <p> The resource policy that was set after processing the request. </p>
    pub policy: std::option::Option<crate::model::ResourcePolicy>,
}
impl PutRepositoryPermissionsPolicyOutput {
    /// <p> The resource policy that was set after processing the request. </p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResourcePolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for PutRepositoryPermissionsPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRepositoryPermissionsPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`PutRepositoryPermissionsPolicyOutput`](crate::output::PutRepositoryPermissionsPolicyOutput)
pub mod put_repository_permissions_policy_output {
    /// A builder for [`PutRepositoryPermissionsPolicyOutput`](crate::output::PutRepositoryPermissionsPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResourcePolicy>,
    }
    impl Builder {
        /// <p> The resource policy that was set after processing the request. </p>
        pub fn policy(mut self, input: crate::model::ResourcePolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p> The resource policy that was set after processing the request. </p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResourcePolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRepositoryPermissionsPolicyOutput`](crate::output::PutRepositoryPermissionsPolicyOutput)
        pub fn build(self) -> crate::output::PutRepositoryPermissionsPolicyOutput {
            crate::output::PutRepositoryPermissionsPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl PutRepositoryPermissionsPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutRepositoryPermissionsPolicyOutput`](crate::output::PutRepositoryPermissionsPolicyOutput)
    pub fn builder() -> crate::output::put_repository_permissions_policy_output::Builder {
        crate::output::put_repository_permissions_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDomainPermissionsPolicyOutput {
    /// <p> The resource policy that was set after processing the request. </p>
    pub policy: std::option::Option<crate::model::ResourcePolicy>,
}
impl PutDomainPermissionsPolicyOutput {
    /// <p> The resource policy that was set after processing the request. </p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResourcePolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for PutDomainPermissionsPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDomainPermissionsPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`PutDomainPermissionsPolicyOutput`](crate::output::PutDomainPermissionsPolicyOutput)
pub mod put_domain_permissions_policy_output {
    /// A builder for [`PutDomainPermissionsPolicyOutput`](crate::output::PutDomainPermissionsPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResourcePolicy>,
    }
    impl Builder {
        /// <p> The resource policy that was set after processing the request. </p>
        pub fn policy(mut self, input: crate::model::ResourcePolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p> The resource policy that was set after processing the request. </p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResourcePolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDomainPermissionsPolicyOutput`](crate::output::PutDomainPermissionsPolicyOutput)
        pub fn build(self) -> crate::output::PutDomainPermissionsPolicyOutput {
            crate::output::PutDomainPermissionsPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl PutDomainPermissionsPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutDomainPermissionsPolicyOutput`](crate::output::PutDomainPermissionsPolicyOutput)
    pub fn builder() -> crate::output::put_domain_permissions_policy_output::Builder {
        crate::output::put_domain_permissions_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A list of tag key and value pairs associated with the specified resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>A list of tag key and value pairs associated with the specified resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag key and value pairs associated with the specified resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag key and value pairs associated with the specified resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesInDomainOutput {
    /// <p>
    /// The returned list of repositories.
    /// </p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::RepositorySummary>>,
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRepositoriesInDomainOutput {
    /// <p>
    /// The returned list of repositories.
    /// </p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::RepositorySummary]> {
        self.repositories.as_deref()
    }
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRepositoriesInDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesInDomainOutput");
        formatter.field("repositories", &self.repositories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRepositoriesInDomainOutput`](crate::output::ListRepositoriesInDomainOutput)
pub mod list_repositories_in_domain_output {
    /// A builder for [`ListRepositoriesInDomainOutput`](crate::output::ListRepositoriesInDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories:
            std::option::Option<std::vec::Vec<crate::model::RepositorySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>
        /// The returned list of repositories.
        /// </p>
        pub fn repositories(mut self, input: impl Into<crate::model::RepositorySummary>) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input.into());
            self.repositories = Some(v);
            self
        }
        /// <p>
        /// The returned list of repositories.
        /// </p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositorySummary>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesInDomainOutput`](crate::output::ListRepositoriesInDomainOutput)
        pub fn build(self) -> crate::output::ListRepositoriesInDomainOutput {
            crate::output::ListRepositoriesInDomainOutput {
                repositories: self.repositories,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRepositoriesInDomainOutput {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInDomainOutput`](crate::output::ListRepositoriesInDomainOutput)
    pub fn builder() -> crate::output::list_repositories_in_domain_output::Builder {
        crate::output::list_repositories_in_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesOutput {
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a>
    /// objects.
    /// </p>
    pub repositories: std::option::Option<std::vec::Vec<crate::model::RepositorySummary>>,
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRepositoriesOutput {
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a>
    /// objects.
    /// </p>
    pub fn repositories(&self) -> std::option::Option<&[crate::model::RepositorySummary]> {
        self.repositories.as_deref()
    }
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRepositoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesOutput");
        formatter.field("repositories", &self.repositories);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
pub mod list_repositories_output {
    /// A builder for [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repositories:
            std::option::Option<std::vec::Vec<crate::model::RepositorySummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `repositories`.
        ///
        /// To override the contents of this collection use [`set_repositories`](Self::set_repositories).
        ///
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a>
        /// objects.
        /// </p>
        pub fn repositories(mut self, input: impl Into<crate::model::RepositorySummary>) -> Self {
            let mut v = self.repositories.unwrap_or_default();
            v.push(input.into());
            self.repositories = Some(v);
            self
        }
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a>
        /// objects.
        /// </p>
        pub fn set_repositories(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RepositorySummary>>,
        ) -> Self {
            self.repositories = input;
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
        pub fn build(self) -> crate::output::ListRepositoriesOutput {
            crate::output::ListRepositoriesOutput {
                repositories: self.repositories,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRepositoriesOutput {
    /// Creates a new builder-style object to manufacture [`ListRepositoriesOutput`](crate::output::ListRepositoriesOutput)
    pub fn builder() -> crate::output::list_repositories_output::Builder {
        crate::output::list_repositories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageVersionsOutput {
    /// <p>
    /// The default package version to display. This depends on the package format:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// For Maven and PyPI packages, it's the most recently published package version.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// For npm packages, it's the version referenced by the
    /// <code>latest</code> tag. If the  <code>latest</code> tag is not set, it's the most recently published package version.
    /// </p>
    /// </li>
    /// </ul>
    pub default_display_version: std::option::Option<std::string::String>,
    /// <p>
    /// A format of the package. Valid package format values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// The returned list of
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a>
    /// objects.
    /// </p>
    pub versions: std::option::Option<std::vec::Vec<crate::model::PackageVersionSummary>>,
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackageVersionsOutput {
    /// <p>
    /// The default package version to display. This depends on the package format:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// For Maven and PyPI packages, it's the most recently published package version.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// For npm packages, it's the version referenced by the
    /// <code>latest</code> tag. If the  <code>latest</code> tag is not set, it's the most recently published package version.
    /// </p>
    /// </li>
    /// </ul>
    pub fn default_display_version(&self) -> std::option::Option<&str> {
        self.default_display_version.as_deref()
    }
    /// <p>
    /// A format of the package. Valid package format values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// The returned list of
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a>
    /// objects.
    /// </p>
    pub fn versions(&self) -> std::option::Option<&[crate::model::PackageVersionSummary]> {
        self.versions.as_deref()
    }
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackageVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageVersionsOutput");
        formatter.field("default_display_version", &self.default_display_version);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("versions", &self.versions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPackageVersionsOutput`](crate::output::ListPackageVersionsOutput)
pub mod list_package_versions_output {
    /// A builder for [`ListPackageVersionsOutput`](crate::output::ListPackageVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_display_version: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) versions:
            std::option::Option<std::vec::Vec<crate::model::PackageVersionSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The default package version to display. This depends on the package format:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// For Maven and PyPI packages, it's the most recently published package version.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// For npm packages, it's the version referenced by the
        /// <code>latest</code> tag. If the  <code>latest</code> tag is not set, it's the most recently published package version.
        /// </p>
        /// </li>
        /// </ul>
        pub fn default_display_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_display_version = Some(input.into());
            self
        }
        /// <p>
        /// The default package version to display. This depends on the package format:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// For Maven and PyPI packages, it's the most recently published package version.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// For npm packages, it's the version referenced by the
        /// <code>latest</code> tag. If the  <code>latest</code> tag is not set, it's the most recently published package version.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_default_display_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_display_version = input;
            self
        }
        /// <p>
        /// A format of the package. Valid package format values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// A format of the package. Valid package format values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// The returned list of
        /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a>
        /// objects.
        /// </p>
        pub fn versions(mut self, input: impl Into<crate::model::PackageVersionSummary>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>
        /// The returned list of
        /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a>
        /// objects.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageVersionSummary>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageVersionsOutput`](crate::output::ListPackageVersionsOutput)
        pub fn build(self) -> crate::output::ListPackageVersionsOutput {
            crate::output::ListPackageVersionsOutput {
                default_display_version: self.default_display_version,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                versions: self.versions,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPackageVersionsOutput {
    /// Creates a new builder-style object to manufacture [`ListPackageVersionsOutput`](crate::output::ListPackageVersionsOutput)
    pub fn builder() -> crate::output::list_package_versions_output::Builder {
        crate::output::list_package_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageVersionDependenciesOutput {
    /// <p>
    /// A format that specifies the type of the package that contains the returned dependencies. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that contains the returned package versions dependencies.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// The version of the package that is specified in the request.
    /// </p>
    pub version: std::option::Option<std::string::String>,
    /// <p>
    /// The current revision associated with the package version.
    /// </p>
    pub version_revision: std::option::Option<std::string::String>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects.
    /// </p>
    pub dependencies: std::option::Option<std::vec::Vec<crate::model::PackageDependency>>,
}
impl ListPackageVersionDependenciesOutput {
    /// <p>
    /// A format that specifies the type of the package that contains the returned dependencies. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package that contains the returned package versions dependencies.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// The version of the package that is specified in the request.
    /// </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>
    /// The current revision associated with the package version.
    /// </p>
    pub fn version_revision(&self) -> std::option::Option<&str> {
        self.version_revision.as_deref()
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects.
    /// </p>
    pub fn dependencies(&self) -> std::option::Option<&[crate::model::PackageDependency]> {
        self.dependencies.as_deref()
    }
}
impl std::fmt::Debug for ListPackageVersionDependenciesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageVersionDependenciesOutput");
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("version", &self.version);
        formatter.field("version_revision", &self.version_revision);
        formatter.field("next_token", &self.next_token);
        formatter.field("dependencies", &self.dependencies);
        formatter.finish()
    }
}
/// See [`ListPackageVersionDependenciesOutput`](crate::output::ListPackageVersionDependenciesOutput)
pub mod list_package_version_dependencies_output {
    /// A builder for [`ListPackageVersionDependenciesOutput`](crate::output::ListPackageVersionDependenciesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) version_revision: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) dependencies:
            std::option::Option<std::vec::Vec<crate::model::PackageDependency>>,
    }
    impl Builder {
        /// <p>
        /// A format that specifies the type of the package that contains the returned dependencies. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the package that contains the returned dependencies. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package that contains the returned package versions dependencies.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that contains the returned package versions dependencies.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// The version of the package that is specified in the request.
        /// </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>
        /// The version of the package that is specified in the request.
        /// </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>
        /// The current revision associated with the package version.
        /// </p>
        pub fn version_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_revision = Some(input.into());
            self
        }
        /// <p>
        /// The current revision associated with the package version.
        /// </p>
        pub fn set_version_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_revision = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `dependencies`.
        ///
        /// To override the contents of this collection use [`set_dependencies`](Self::set_dependencies).
        ///
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects.
        /// </p>
        pub fn dependencies(mut self, input: impl Into<crate::model::PackageDependency>) -> Self {
            let mut v = self.dependencies.unwrap_or_default();
            v.push(input.into());
            self.dependencies = Some(v);
            self
        }
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a> objects.
        /// </p>
        pub fn set_dependencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageDependency>>,
        ) -> Self {
            self.dependencies = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageVersionDependenciesOutput`](crate::output::ListPackageVersionDependenciesOutput)
        pub fn build(self) -> crate::output::ListPackageVersionDependenciesOutput {
            crate::output::ListPackageVersionDependenciesOutput {
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                version: self.version,
                version_revision: self.version_revision,
                next_token: self.next_token,
                dependencies: self.dependencies,
            }
        }
    }
}
impl ListPackageVersionDependenciesOutput {
    /// Creates a new builder-style object to manufacture [`ListPackageVersionDependenciesOutput`](crate::output::ListPackageVersionDependenciesOutput)
    pub fn builder() -> crate::output::list_package_version_dependencies_output::Builder {
        crate::output::list_package_version_dependencies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageVersionAssetsOutput {
    /// <p>
    /// The format of the package that contains the returned package version assets.
    /// </p>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that contains the returned package version assets.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// The version of the package associated with the returned assets.
    /// </p>
    pub version: std::option::Option<std::string::String>,
    /// <p>
    /// The current revision associated with the package version.
    /// </p>
    pub version_revision: std::option::Option<std::string::String>,
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects.
    /// </p>
    pub assets: std::option::Option<std::vec::Vec<crate::model::AssetSummary>>,
}
impl ListPackageVersionAssetsOutput {
    /// <p>
    /// The format of the package that contains the returned package version assets.
    /// </p>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package that contains the returned package version assets.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// The version of the package associated with the returned assets.
    /// </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>
    /// The current revision associated with the package version.
    /// </p>
    pub fn version_revision(&self) -> std::option::Option<&str> {
        self.version_revision.as_deref()
    }
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects.
    /// </p>
    pub fn assets(&self) -> std::option::Option<&[crate::model::AssetSummary]> {
        self.assets.as_deref()
    }
}
impl std::fmt::Debug for ListPackageVersionAssetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageVersionAssetsOutput");
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("version", &self.version);
        formatter.field("version_revision", &self.version_revision);
        formatter.field("next_token", &self.next_token);
        formatter.field("assets", &self.assets);
        formatter.finish()
    }
}
/// See [`ListPackageVersionAssetsOutput`](crate::output::ListPackageVersionAssetsOutput)
pub mod list_package_version_assets_output {
    /// A builder for [`ListPackageVersionAssetsOutput`](crate::output::ListPackageVersionAssetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) version_revision: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) assets: std::option::Option<std::vec::Vec<crate::model::AssetSummary>>,
    }
    impl Builder {
        /// <p>
        /// The format of the package that contains the returned package version assets.
        /// </p>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package that contains the returned package version assets.
        /// </p>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package that contains the returned package version assets.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that contains the returned package version assets.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// The version of the package associated with the returned assets.
        /// </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>
        /// The version of the package associated with the returned assets.
        /// </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>
        /// The current revision associated with the package version.
        /// </p>
        pub fn version_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_revision = Some(input.into());
            self
        }
        /// <p>
        /// The current revision associated with the package version.
        /// </p>
        pub fn set_version_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_revision = input;
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `assets`.
        ///
        /// To override the contents of this collection use [`set_assets`](Self::set_assets).
        ///
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects.
        /// </p>
        pub fn assets(mut self, input: impl Into<crate::model::AssetSummary>) -> Self {
            let mut v = self.assets.unwrap_or_default();
            v.push(input.into());
            self.assets = Some(v);
            self
        }
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a> objects.
        /// </p>
        pub fn set_assets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AssetSummary>>,
        ) -> Self {
            self.assets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageVersionAssetsOutput`](crate::output::ListPackageVersionAssetsOutput)
        pub fn build(self) -> crate::output::ListPackageVersionAssetsOutput {
            crate::output::ListPackageVersionAssetsOutput {
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                version: self.version,
                version_revision: self.version_revision,
                next_token: self.next_token,
                assets: self.assets,
            }
        }
    }
}
impl ListPackageVersionAssetsOutput {
    /// Creates a new builder-style object to manufacture [`ListPackageVersionAssetsOutput`](crate::output::ListPackageVersionAssetsOutput)
    pub fn builder() -> crate::output::list_package_version_assets_output::Builder {
        crate::output::list_package_version_assets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesOutput {
    /// <p>
    /// The list of returned <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
    /// objects.
    /// </p>
    pub packages: std::option::Option<std::vec::Vec<crate::model::PackageSummary>>,
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackagesOutput {
    /// <p>
    /// The list of returned <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
    /// objects.
    /// </p>
    pub fn packages(&self) -> std::option::Option<&[crate::model::PackageSummary]> {
        self.packages.as_deref()
    }
    /// <p>
    /// If there are additional results, this is the token for the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackagesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesOutput");
        formatter.field("packages", &self.packages);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPackagesOutput`](crate::output::ListPackagesOutput)
pub mod list_packages_output {
    /// A builder for [`ListPackagesOutput`](crate::output::ListPackagesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) packages: std::option::Option<std::vec::Vec<crate::model::PackageSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `packages`.
        ///
        /// To override the contents of this collection use [`set_packages`](Self::set_packages).
        ///
        /// <p>
        /// The list of returned <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
        /// objects.
        /// </p>
        pub fn packages(mut self, input: impl Into<crate::model::PackageSummary>) -> Self {
            let mut v = self.packages.unwrap_or_default();
            v.push(input.into());
            self.packages = Some(v);
            self
        }
        /// <p>
        /// The list of returned <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
        /// objects.
        /// </p>
        pub fn set_packages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PackageSummary>>,
        ) -> Self {
            self.packages = input;
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// If there are additional results, this is the token for the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesOutput`](crate::output::ListPackagesOutput)
        pub fn build(self) -> crate::output::ListPackagesOutput {
            crate::output::ListPackagesOutput {
                packages: self.packages,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPackagesOutput {
    /// Creates a new builder-style object to manufacture [`ListPackagesOutput`](crate::output::ListPackagesOutput)
    pub fn builder() -> crate::output::list_packages_output::Builder {
        crate::output::list_packages_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsOutput {
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainSummary.html">DomainSummary</a> objects.
    /// </p>
    pub domains: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDomainsOutput {
    /// <p>
    /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainSummary.html">DomainSummary</a> objects.
    /// </p>
    pub fn domains(&self) -> std::option::Option<&[crate::model::DomainSummary]> {
        self.domains.as_deref()
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsOutput");
        formatter.field("domains", &self.domains);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDomainsOutput`](crate::output::ListDomainsOutput)
pub mod list_domains_output {
    /// A builder for [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domains: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `domains`.
        ///
        /// To override the contents of this collection use [`set_domains`](Self::set_domains).
        ///
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainSummary.html">DomainSummary</a> objects.
        /// </p>
        pub fn domains(mut self, input: impl Into<crate::model::DomainSummary>) -> Self {
            let mut v = self.domains.unwrap_or_default();
            v.push(input.into());
            self.domains = Some(v);
            self
        }
        /// <p>
        /// The returned list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainSummary.html">DomainSummary</a> objects.
        /// </p>
        pub fn set_domains(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainSummary>>,
        ) -> Self {
            self.domains = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsOutput`](crate::output::ListDomainsOutput)
        pub fn build(self) -> crate::output::ListDomainsOutput {
            crate::output::ListDomainsOutput {
                domains: self.domains,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDomainsOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    pub fn builder() -> crate::output::list_domains_output::Builder {
        crate::output::list_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryPermissionsPolicyOutput {
    /// <p>
    /// The returned resource policy.
    /// </p>
    pub policy: std::option::Option<crate::model::ResourcePolicy>,
}
impl GetRepositoryPermissionsPolicyOutput {
    /// <p>
    /// The returned resource policy.
    /// </p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResourcePolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for GetRepositoryPermissionsPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryPermissionsPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetRepositoryPermissionsPolicyOutput`](crate::output::GetRepositoryPermissionsPolicyOutput)
pub mod get_repository_permissions_policy_output {
    /// A builder for [`GetRepositoryPermissionsPolicyOutput`](crate::output::GetRepositoryPermissionsPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResourcePolicy>,
    }
    impl Builder {
        /// <p>
        /// The returned resource policy.
        /// </p>
        pub fn policy(mut self, input: crate::model::ResourcePolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>
        /// The returned resource policy.
        /// </p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResourcePolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryPermissionsPolicyOutput`](crate::output::GetRepositoryPermissionsPolicyOutput)
        pub fn build(self) -> crate::output::GetRepositoryPermissionsPolicyOutput {
            crate::output::GetRepositoryPermissionsPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetRepositoryPermissionsPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetRepositoryPermissionsPolicyOutput`](crate::output::GetRepositoryPermissionsPolicyOutput)
    pub fn builder() -> crate::output::get_repository_permissions_policy_output::Builder {
        crate::output::get_repository_permissions_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryEndpointOutput {
    /// <p>
    /// A string that specifies the URL of the returned endpoint.
    /// </p>
    pub repository_endpoint: std::option::Option<std::string::String>,
}
impl GetRepositoryEndpointOutput {
    /// <p>
    /// A string that specifies the URL of the returned endpoint.
    /// </p>
    pub fn repository_endpoint(&self) -> std::option::Option<&str> {
        self.repository_endpoint.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryEndpointOutput");
        formatter.field("repository_endpoint", &self.repository_endpoint);
        formatter.finish()
    }
}
/// See [`GetRepositoryEndpointOutput`](crate::output::GetRepositoryEndpointOutput)
pub mod get_repository_endpoint_output {
    /// A builder for [`GetRepositoryEndpointOutput`](crate::output::GetRepositoryEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// A string that specifies the URL of the returned endpoint.
        /// </p>
        pub fn repository_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_endpoint = Some(input.into());
            self
        }
        /// <p>
        /// A string that specifies the URL of the returned endpoint.
        /// </p>
        pub fn set_repository_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryEndpointOutput`](crate::output::GetRepositoryEndpointOutput)
        pub fn build(self) -> crate::output::GetRepositoryEndpointOutput {
            crate::output::GetRepositoryEndpointOutput {
                repository_endpoint: self.repository_endpoint,
            }
        }
    }
}
impl GetRepositoryEndpointOutput {
    /// Creates a new builder-style object to manufacture [`GetRepositoryEndpointOutput`](crate::output::GetRepositoryEndpointOutput)
    pub fn builder() -> crate::output::get_repository_endpoint_output::Builder {
        crate::output::get_repository_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPackageVersionReadmeOutput {
    /// <p>
    /// The format of the package with the requested readme file. Valid format types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that contains the returned readme file.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// The version of the package with the requested readme file.
    /// </p>
    pub version: std::option::Option<std::string::String>,
    /// <p>
    /// The current revision associated with the package version.
    /// </p>
    pub version_revision: std::option::Option<std::string::String>,
    /// <p>
    /// The text of the returned readme file.
    /// </p>
    pub readme: std::option::Option<std::string::String>,
}
impl GetPackageVersionReadmeOutput {
    /// <p>
    /// The format of the package with the requested readme file. Valid format types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package that contains the returned readme file.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// The version of the package with the requested readme file.
    /// </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>
    /// The current revision associated with the package version.
    /// </p>
    pub fn version_revision(&self) -> std::option::Option<&str> {
        self.version_revision.as_deref()
    }
    /// <p>
    /// The text of the returned readme file.
    /// </p>
    pub fn readme(&self) -> std::option::Option<&str> {
        self.readme.as_deref()
    }
}
impl std::fmt::Debug for GetPackageVersionReadmeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionReadmeOutput");
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("version", &self.version);
        formatter.field("version_revision", &self.version_revision);
        formatter.field("readme", &self.readme);
        formatter.finish()
    }
}
/// See [`GetPackageVersionReadmeOutput`](crate::output::GetPackageVersionReadmeOutput)
pub mod get_package_version_readme_output {
    /// A builder for [`GetPackageVersionReadmeOutput`](crate::output::GetPackageVersionReadmeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) version_revision: std::option::Option<std::string::String>,
        pub(crate) readme: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The format of the package with the requested readme file. Valid format types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package with the requested readme file. Valid format types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package that contains the returned readme file.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that contains the returned readme file.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// The version of the package with the requested readme file.
        /// </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>
        /// The version of the package with the requested readme file.
        /// </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>
        /// The current revision associated with the package version.
        /// </p>
        pub fn version_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_revision = Some(input.into());
            self
        }
        /// <p>
        /// The current revision associated with the package version.
        /// </p>
        pub fn set_version_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_revision = input;
            self
        }
        /// <p>
        /// The text of the returned readme file.
        /// </p>
        pub fn readme(mut self, input: impl Into<std::string::String>) -> Self {
            self.readme = Some(input.into());
            self
        }
        /// <p>
        /// The text of the returned readme file.
        /// </p>
        pub fn set_readme(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.readme = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionReadmeOutput`](crate::output::GetPackageVersionReadmeOutput)
        pub fn build(self) -> crate::output::GetPackageVersionReadmeOutput {
            crate::output::GetPackageVersionReadmeOutput {
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                version: self.version,
                version_revision: self.version_revision,
                readme: self.readme,
            }
        }
    }
}
impl GetPackageVersionReadmeOutput {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionReadmeOutput`](crate::output::GetPackageVersionReadmeOutput)
    pub fn builder() -> crate::output::get_package_version_readme_output::Builder {
        crate::output::get_package_version_readme_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct GetPackageVersionAssetOutput {
    /// <p> The binary file, or asset, that is downloaded.</p>
    pub asset: aws_smithy_http::byte_stream::ByteStream,
    /// <p>
    /// The name of the asset that is downloaded.
    /// </p>
    pub asset_name: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package version revision that contains the downloaded asset.
    /// </p>
    pub package_version_revision: std::option::Option<std::string::String>,
}
impl GetPackageVersionAssetOutput {
    /// <p> The binary file, or asset, that is downloaded.</p>
    pub fn asset(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.asset
    }
    /// <p>
    /// The name of the asset that is downloaded.
    /// </p>
    pub fn asset_name(&self) -> std::option::Option<&str> {
        self.asset_name.as_deref()
    }
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>
    /// The name of the package version revision that contains the downloaded asset.
    /// </p>
    pub fn package_version_revision(&self) -> std::option::Option<&str> {
        self.package_version_revision.as_deref()
    }
}
impl std::fmt::Debug for GetPackageVersionAssetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionAssetOutput");
        formatter.field("asset", &self.asset);
        formatter.field("asset_name", &self.asset_name);
        formatter.field("package_version", &self.package_version);
        formatter.field("package_version_revision", &self.package_version_revision);
        formatter.finish()
    }
}
/// See [`GetPackageVersionAssetOutput`](crate::output::GetPackageVersionAssetOutput)
pub mod get_package_version_asset_output {
    /// A builder for [`GetPackageVersionAssetOutput`](crate::output::GetPackageVersionAssetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asset: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) asset_name: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) package_version_revision: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The binary file, or asset, that is downloaded.</p>
        pub fn asset(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.asset = Some(input);
            self
        }
        /// <p> The binary file, or asset, that is downloaded.</p>
        pub fn set_asset(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.asset = input;
            self
        }
        /// <p>
        /// The name of the asset that is downloaded.
        /// </p>
        pub fn asset_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the asset that is downloaded.
        /// </p>
        pub fn set_asset_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset_name = input;
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>
        /// The name of the package version revision that contains the downloaded asset.
        /// </p>
        pub fn package_version_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version_revision = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package version revision that contains the downloaded asset.
        /// </p>
        pub fn set_package_version_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version_revision = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionAssetOutput`](crate::output::GetPackageVersionAssetOutput)
        pub fn build(self) -> crate::output::GetPackageVersionAssetOutput {
            crate::output::GetPackageVersionAssetOutput {
                asset: self.asset.unwrap_or_default(),
                asset_name: self.asset_name,
                package_version: self.package_version,
                package_version_revision: self.package_version_revision,
            }
        }
    }
}
impl GetPackageVersionAssetOutput {
    /// Creates a new builder-style object to manufacture [`GetPackageVersionAssetOutput`](crate::output::GetPackageVersionAssetOutput)
    pub fn builder() -> crate::output::get_package_version_asset_output::Builder {
        crate::output::get_package_version_asset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainPermissionsPolicyOutput {
    /// <p>
    /// The returned resource policy.
    /// </p>
    pub policy: std::option::Option<crate::model::ResourcePolicy>,
}
impl GetDomainPermissionsPolicyOutput {
    /// <p>
    /// The returned resource policy.
    /// </p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResourcePolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for GetDomainPermissionsPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainPermissionsPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetDomainPermissionsPolicyOutput`](crate::output::GetDomainPermissionsPolicyOutput)
pub mod get_domain_permissions_policy_output {
    /// A builder for [`GetDomainPermissionsPolicyOutput`](crate::output::GetDomainPermissionsPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResourcePolicy>,
    }
    impl Builder {
        /// <p>
        /// The returned resource policy.
        /// </p>
        pub fn policy(mut self, input: crate::model::ResourcePolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>
        /// The returned resource policy.
        /// </p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResourcePolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainPermissionsPolicyOutput`](crate::output::GetDomainPermissionsPolicyOutput)
        pub fn build(self) -> crate::output::GetDomainPermissionsPolicyOutput {
            crate::output::GetDomainPermissionsPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetDomainPermissionsPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainPermissionsPolicyOutput`](crate::output::GetDomainPermissionsPolicyOutput)
    pub fn builder() -> crate::output::get_domain_permissions_policy_output::Builder {
        crate::output::get_domain_permissions_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizationTokenOutput {
    /// <p>
    /// The returned authentication token.
    /// </p>
    pub authorization_token: std::option::Option<std::string::String>,
    /// <p>
    /// A timestamp that specifies the date and time the authorization token expires.
    /// </p>
    pub expiration: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetAuthorizationTokenOutput {
    /// <p>
    /// The returned authentication token.
    /// </p>
    pub fn authorization_token(&self) -> std::option::Option<&str> {
        self.authorization_token.as_deref()
    }
    /// <p>
    /// A timestamp that specifies the date and time the authorization token expires.
    /// </p>
    pub fn expiration(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration.as_ref()
    }
}
impl std::fmt::Debug for GetAuthorizationTokenOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizationTokenOutput");
        formatter.field("authorization_token", &self.authorization_token);
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
/// See [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
pub mod get_authorization_token_output {
    /// A builder for [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authorization_token: std::option::Option<std::string::String>,
        pub(crate) expiration: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>
        /// The returned authentication token.
        /// </p>
        pub fn authorization_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_token = Some(input.into());
            self
        }
        /// <p>
        /// The returned authentication token.
        /// </p>
        pub fn set_authorization_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_token = input;
            self
        }
        /// <p>
        /// A timestamp that specifies the date and time the authorization token expires.
        /// </p>
        pub fn expiration(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>
        /// A timestamp that specifies the date and time the authorization token expires.
        /// </p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
        pub fn build(self) -> crate::output::GetAuthorizationTokenOutput {
            crate::output::GetAuthorizationTokenOutput {
                authorization_token: self.authorization_token,
                expiration: self.expiration,
            }
        }
    }
}
impl GetAuthorizationTokenOutput {
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenOutput`](crate::output::GetAuthorizationTokenOutput)
    pub fn builder() -> crate::output::get_authorization_token_output::Builder {
        crate::output::get_authorization_token_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisposePackageVersionsOutput {
    /// <p>
    /// A list of the package versions that were successfully disposed.
    /// </p>
    pub successful_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    >,
    /// <p>
    /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
    /// disposed package versions that failed. The possible error codes are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub failed_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    >,
}
impl DisposePackageVersionsOutput {
    /// <p>
    /// A list of the package versions that were successfully disposed.
    /// </p>
    pub fn successful_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    > {
        self.successful_versions.as_ref()
    }
    /// <p>
    /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
    /// disposed package versions that failed. The possible error codes are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn failed_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    > {
        self.failed_versions.as_ref()
    }
}
impl std::fmt::Debug for DisposePackageVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisposePackageVersionsOutput");
        formatter.field("successful_versions", &self.successful_versions);
        formatter.field("failed_versions", &self.failed_versions);
        formatter.finish()
    }
}
/// See [`DisposePackageVersionsOutput`](crate::output::DisposePackageVersionsOutput)
pub mod dispose_package_versions_output {
    /// A builder for [`DisposePackageVersionsOutput`](crate::output::DisposePackageVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_versions: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::SuccessfulPackageVersionInfo,
            >,
        >,
        pub(crate) failed_versions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `successful_versions`.
        ///
        /// To override the contents of this collection use [`set_successful_versions`](Self::set_successful_versions).
        ///
        /// <p>
        /// A list of the package versions that were successfully disposed.
        /// </p>
        pub fn successful_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::SuccessfulPackageVersionInfo>,
        ) -> Self {
            let mut hash_map = self.successful_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.successful_versions = Some(hash_map);
            self
        }
        /// <p>
        /// A list of the package versions that were successfully disposed.
        /// </p>
        pub fn set_successful_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::SuccessfulPackageVersionInfo,
                >,
            >,
        ) -> Self {
            self.successful_versions = input;
            self
        }
        /// Adds a key-value pair to `failed_versions`.
        ///
        /// To override the contents of this collection use [`set_failed_versions`](Self::set_failed_versions).
        ///
        /// <p>
        /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
        /// disposed package versions that failed. The possible error codes are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn failed_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PackageVersionError>,
        ) -> Self {
            let mut hash_map = self.failed_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.failed_versions = Some(hash_map);
            self
        }
        /// <p>
        /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
        /// disposed package versions that failed. The possible error codes are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_failed_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
            >,
        ) -> Self {
            self.failed_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`DisposePackageVersionsOutput`](crate::output::DisposePackageVersionsOutput)
        pub fn build(self) -> crate::output::DisposePackageVersionsOutput {
            crate::output::DisposePackageVersionsOutput {
                successful_versions: self.successful_versions,
                failed_versions: self.failed_versions,
            }
        }
    }
}
impl DisposePackageVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DisposePackageVersionsOutput`](crate::output::DisposePackageVersionsOutput)
    pub fn builder() -> crate::output::dispose_package_versions_output::Builder {
        crate::output::dispose_package_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateExternalConnectionOutput {
    /// <p>
    /// The repository associated with the removed external connection.
    /// </p>
    pub repository: std::option::Option<crate::model::RepositoryDescription>,
}
impl DisassociateExternalConnectionOutput {
    /// <p>
    /// The repository associated with the removed external connection.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&crate::model::RepositoryDescription> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for DisassociateExternalConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateExternalConnectionOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`DisassociateExternalConnectionOutput`](crate::output::DisassociateExternalConnectionOutput)
pub mod disassociate_external_connection_output {
    /// A builder for [`DisassociateExternalConnectionOutput`](crate::output::DisassociateExternalConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::RepositoryDescription>,
    }
    impl Builder {
        /// <p>
        /// The repository associated with the removed external connection.
        /// </p>
        pub fn repository(mut self, input: crate::model::RepositoryDescription) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>
        /// The repository associated with the removed external connection.
        /// </p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryDescription>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateExternalConnectionOutput`](crate::output::DisassociateExternalConnectionOutput)
        pub fn build(self) -> crate::output::DisassociateExternalConnectionOutput {
            crate::output::DisassociateExternalConnectionOutput {
                repository: self.repository,
            }
        }
    }
}
impl DisassociateExternalConnectionOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateExternalConnectionOutput`](crate::output::DisassociateExternalConnectionOutput)
    pub fn builder() -> crate::output::disassociate_external_connection_output::Builder {
        crate::output::disassociate_external_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRepositoryOutput {
    /// <p>
    /// A <code>RepositoryDescription</code> object that contains the requested repository information.
    /// </p>
    pub repository: std::option::Option<crate::model::RepositoryDescription>,
}
impl DescribeRepositoryOutput {
    /// <p>
    /// A <code>RepositoryDescription</code> object that contains the requested repository information.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&crate::model::RepositoryDescription> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for DescribeRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`DescribeRepositoryOutput`](crate::output::DescribeRepositoryOutput)
pub mod describe_repository_output {
    /// A builder for [`DescribeRepositoryOutput`](crate::output::DescribeRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::RepositoryDescription>,
    }
    impl Builder {
        /// <p>
        /// A <code>RepositoryDescription</code> object that contains the requested repository information.
        /// </p>
        pub fn repository(mut self, input: crate::model::RepositoryDescription) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>
        /// A <code>RepositoryDescription</code> object that contains the requested repository information.
        /// </p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryDescription>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRepositoryOutput`](crate::output::DescribeRepositoryOutput)
        pub fn build(self) -> crate::output::DescribeRepositoryOutput {
            crate::output::DescribeRepositoryOutput {
                repository: self.repository,
            }
        }
    }
}
impl DescribeRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRepositoryOutput`](crate::output::DescribeRepositoryOutput)
    pub fn builder() -> crate::output::describe_repository_output::Builder {
        crate::output::describe_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageVersionOutput {
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a>
    /// object that contains information about the requested package version.
    /// </p>
    pub package_version: std::option::Option<crate::model::PackageVersionDescription>,
}
impl DescribePackageVersionOutput {
    /// <p>
    /// A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a>
    /// object that contains information about the requested package version.
    /// </p>
    pub fn package_version(&self) -> std::option::Option<&crate::model::PackageVersionDescription> {
        self.package_version.as_ref()
    }
}
impl std::fmt::Debug for DescribePackageVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageVersionOutput");
        formatter.field("package_version", &self.package_version);
        formatter.finish()
    }
}
/// See [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
pub mod describe_package_version_output {
    /// A builder for [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) package_version: std::option::Option<crate::model::PackageVersionDescription>,
    }
    impl Builder {
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a>
        /// object that contains information about the requested package version.
        /// </p>
        pub fn package_version(mut self, input: crate::model::PackageVersionDescription) -> Self {
            self.package_version = Some(input);
            self
        }
        /// <p>
        /// A <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a>
        /// object that contains information about the requested package version.
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<crate::model::PackageVersionDescription>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
        pub fn build(self) -> crate::output::DescribePackageVersionOutput {
            crate::output::DescribePackageVersionOutput {
                package_version: self.package_version,
            }
        }
    }
}
impl DescribePackageVersionOutput {
    /// Creates a new builder-style object to manufacture [`DescribePackageVersionOutput`](crate::output::DescribePackageVersionOutput)
    pub fn builder() -> crate::output::describe_package_version_output::Builder {
        crate::output::describe_package_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainOutput {
    /// <p>
    /// Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you
    /// add one or more repositories.
    /// </p>
    pub domain: std::option::Option<crate::model::DomainDescription>,
}
impl DescribeDomainOutput {
    /// <p>
    /// Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you
    /// add one or more repositories.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&crate::model::DomainDescription> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for DescribeDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainOutput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
pub mod describe_domain_output {
    /// A builder for [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<crate::model::DomainDescription>,
    }
    impl Builder {
        /// <p>
        /// Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you
        /// add one or more repositories.
        /// </p>
        pub fn domain(mut self, input: crate::model::DomainDescription) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>
        /// Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you
        /// add one or more repositories.
        /// </p>
        pub fn set_domain(
            mut self,
            input: std::option::Option<crate::model::DomainDescription>,
        ) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
        pub fn build(self) -> crate::output::DescribeDomainOutput {
            crate::output::DescribeDomainOutput {
                domain: self.domain,
            }
        }
    }
}
impl DescribeDomainOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDomainOutput`](crate::output::DescribeDomainOutput)
    pub fn builder() -> crate::output::describe_domain_output::Builder {
        crate::output::describe_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryPermissionsPolicyOutput {
    /// <p>
    /// Information about the deleted policy after processing the request.
    /// </p>
    pub policy: std::option::Option<crate::model::ResourcePolicy>,
}
impl DeleteRepositoryPermissionsPolicyOutput {
    /// <p>
    /// Information about the deleted policy after processing the request.
    /// </p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResourcePolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for DeleteRepositoryPermissionsPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryPermissionsPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`DeleteRepositoryPermissionsPolicyOutput`](crate::output::DeleteRepositoryPermissionsPolicyOutput)
pub mod delete_repository_permissions_policy_output {
    /// A builder for [`DeleteRepositoryPermissionsPolicyOutput`](crate::output::DeleteRepositoryPermissionsPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResourcePolicy>,
    }
    impl Builder {
        /// <p>
        /// Information about the deleted policy after processing the request.
        /// </p>
        pub fn policy(mut self, input: crate::model::ResourcePolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>
        /// Information about the deleted policy after processing the request.
        /// </p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResourcePolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryPermissionsPolicyOutput`](crate::output::DeleteRepositoryPermissionsPolicyOutput)
        pub fn build(self) -> crate::output::DeleteRepositoryPermissionsPolicyOutput {
            crate::output::DeleteRepositoryPermissionsPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl DeleteRepositoryPermissionsPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPermissionsPolicyOutput`](crate::output::DeleteRepositoryPermissionsPolicyOutput)
    pub fn builder() -> crate::output::delete_repository_permissions_policy_output::Builder {
        crate::output::delete_repository_permissions_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryOutput {
    /// <p>
    /// Information about the deleted repository after processing the request.
    /// </p>
    pub repository: std::option::Option<crate::model::RepositoryDescription>,
}
impl DeleteRepositoryOutput {
    /// <p>
    /// Information about the deleted repository after processing the request.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&crate::model::RepositoryDescription> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for DeleteRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
pub mod delete_repository_output {
    /// A builder for [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::RepositoryDescription>,
    }
    impl Builder {
        /// <p>
        /// Information about the deleted repository after processing the request.
        /// </p>
        pub fn repository(mut self, input: crate::model::RepositoryDescription) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>
        /// Information about the deleted repository after processing the request.
        /// </p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryDescription>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
        pub fn build(self) -> crate::output::DeleteRepositoryOutput {
            crate::output::DeleteRepositoryOutput {
                repository: self.repository,
            }
        }
    }
}
impl DeleteRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryOutput`](crate::output::DeleteRepositoryOutput)
    pub fn builder() -> crate::output::delete_repository_output::Builder {
        crate::output::delete_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageVersionsOutput {
    /// <p>
    /// A list of the package versions that were successfully deleted.
    /// </p>
    pub successful_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    >,
    /// <p>
    /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
    /// deleted package that failed. The possible error codes are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub failed_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    >,
}
impl DeletePackageVersionsOutput {
    /// <p>
    /// A list of the package versions that were successfully deleted.
    /// </p>
    pub fn successful_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    > {
        self.successful_versions.as_ref()
    }
    /// <p>
    /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
    /// deleted package that failed. The possible error codes are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn failed_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    > {
        self.failed_versions.as_ref()
    }
}
impl std::fmt::Debug for DeletePackageVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageVersionsOutput");
        formatter.field("successful_versions", &self.successful_versions);
        formatter.field("failed_versions", &self.failed_versions);
        formatter.finish()
    }
}
/// See [`DeletePackageVersionsOutput`](crate::output::DeletePackageVersionsOutput)
pub mod delete_package_versions_output {
    /// A builder for [`DeletePackageVersionsOutput`](crate::output::DeletePackageVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_versions: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::SuccessfulPackageVersionInfo,
            >,
        >,
        pub(crate) failed_versions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `successful_versions`.
        ///
        /// To override the contents of this collection use [`set_successful_versions`](Self::set_successful_versions).
        ///
        /// <p>
        /// A list of the package versions that were successfully deleted.
        /// </p>
        pub fn successful_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::SuccessfulPackageVersionInfo>,
        ) -> Self {
            let mut hash_map = self.successful_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.successful_versions = Some(hash_map);
            self
        }
        /// <p>
        /// A list of the package versions that were successfully deleted.
        /// </p>
        pub fn set_successful_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::SuccessfulPackageVersionInfo,
                >,
            >,
        ) -> Self {
            self.successful_versions = input;
            self
        }
        /// Adds a key-value pair to `failed_versions`.
        ///
        /// To override the contents of this collection use [`set_failed_versions`](Self::set_failed_versions).
        ///
        /// <p>
        /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
        /// deleted package that failed. The possible error codes are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn failed_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PackageVersionError>,
        ) -> Self {
            let mut hash_map = self.failed_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.failed_versions = Some(hash_map);
            self
        }
        /// <p>
        /// A <code>PackageVersionError</code> object that contains a map of errors codes for the
        /// deleted package that failed. The possible error codes are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_failed_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
            >,
        ) -> Self {
            self.failed_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackageVersionsOutput`](crate::output::DeletePackageVersionsOutput)
        pub fn build(self) -> crate::output::DeletePackageVersionsOutput {
            crate::output::DeletePackageVersionsOutput {
                successful_versions: self.successful_versions,
                failed_versions: self.failed_versions,
            }
        }
    }
}
impl DeletePackageVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DeletePackageVersionsOutput`](crate::output::DeletePackageVersionsOutput)
    pub fn builder() -> crate::output::delete_package_versions_output::Builder {
        crate::output::delete_package_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainPermissionsPolicyOutput {
    /// <p>
    /// Information about the deleted resource policy after processing the request.
    /// </p>
    pub policy: std::option::Option<crate::model::ResourcePolicy>,
}
impl DeleteDomainPermissionsPolicyOutput {
    /// <p>
    /// Information about the deleted resource policy after processing the request.
    /// </p>
    pub fn policy(&self) -> std::option::Option<&crate::model::ResourcePolicy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for DeleteDomainPermissionsPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainPermissionsPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`DeleteDomainPermissionsPolicyOutput`](crate::output::DeleteDomainPermissionsPolicyOutput)
pub mod delete_domain_permissions_policy_output {
    /// A builder for [`DeleteDomainPermissionsPolicyOutput`](crate::output::DeleteDomainPermissionsPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::ResourcePolicy>,
    }
    impl Builder {
        /// <p>
        /// Information about the deleted resource policy after processing the request.
        /// </p>
        pub fn policy(mut self, input: crate::model::ResourcePolicy) -> Self {
            self.policy = Some(input);
            self
        }
        /// <p>
        /// Information about the deleted resource policy after processing the request.
        /// </p>
        pub fn set_policy(
            mut self,
            input: std::option::Option<crate::model::ResourcePolicy>,
        ) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainPermissionsPolicyOutput`](crate::output::DeleteDomainPermissionsPolicyOutput)
        pub fn build(self) -> crate::output::DeleteDomainPermissionsPolicyOutput {
            crate::output::DeleteDomainPermissionsPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl DeleteDomainPermissionsPolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainPermissionsPolicyOutput`](crate::output::DeleteDomainPermissionsPolicyOutput)
    pub fn builder() -> crate::output::delete_domain_permissions_policy_output::Builder {
        crate::output::delete_domain_permissions_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainOutput {
    /// <p>
    /// Contains information about the deleted domain after processing the request.
    /// </p>
    pub domain: std::option::Option<crate::model::DomainDescription>,
}
impl DeleteDomainOutput {
    /// <p>
    /// Contains information about the deleted domain after processing the request.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&crate::model::DomainDescription> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for DeleteDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainOutput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
pub mod delete_domain_output {
    /// A builder for [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<crate::model::DomainDescription>,
    }
    impl Builder {
        /// <p>
        /// Contains information about the deleted domain after processing the request.
        /// </p>
        pub fn domain(mut self, input: crate::model::DomainDescription) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>
        /// Contains information about the deleted domain after processing the request.
        /// </p>
        pub fn set_domain(
            mut self,
            input: std::option::Option<crate::model::DomainDescription>,
        ) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
        pub fn build(self) -> crate::output::DeleteDomainOutput {
            crate::output::DeleteDomainOutput {
                domain: self.domain,
            }
        }
    }
}
impl DeleteDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    pub fn builder() -> crate::output::delete_domain_output::Builder {
        crate::output::delete_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryOutput {
    /// <p>
    /// Information about the created repository after processing the request.
    /// </p>
    pub repository: std::option::Option<crate::model::RepositoryDescription>,
}
impl CreateRepositoryOutput {
    /// <p>
    /// Information about the created repository after processing the request.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&crate::model::RepositoryDescription> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for CreateRepositoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
pub mod create_repository_output {
    /// A builder for [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::RepositoryDescription>,
    }
    impl Builder {
        /// <p>
        /// Information about the created repository after processing the request.
        /// </p>
        pub fn repository(mut self, input: crate::model::RepositoryDescription) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>
        /// Information about the created repository after processing the request.
        /// </p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryDescription>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
        pub fn build(self) -> crate::output::CreateRepositoryOutput {
            crate::output::CreateRepositoryOutput {
                repository: self.repository,
            }
        }
    }
}
impl CreateRepositoryOutput {
    /// Creates a new builder-style object to manufacture [`CreateRepositoryOutput`](crate::output::CreateRepositoryOutput)
    pub fn builder() -> crate::output::create_repository_output::Builder {
        crate::output::create_repository_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainOutput {
    /// <p>
    /// Contains information about the created domain after processing the request.
    /// </p>
    pub domain: std::option::Option<crate::model::DomainDescription>,
}
impl CreateDomainOutput {
    /// <p>
    /// Contains information about the created domain after processing the request.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&crate::model::DomainDescription> {
        self.domain.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainOutput");
        formatter.field("domain", &self.domain);
        formatter.finish()
    }
}
/// See [`CreateDomainOutput`](crate::output::CreateDomainOutput)
pub mod create_domain_output {
    /// A builder for [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<crate::model::DomainDescription>,
    }
    impl Builder {
        /// <p>
        /// Contains information about the created domain after processing the request.
        /// </p>
        pub fn domain(mut self, input: crate::model::DomainDescription) -> Self {
            self.domain = Some(input);
            self
        }
        /// <p>
        /// Contains information about the created domain after processing the request.
        /// </p>
        pub fn set_domain(
            mut self,
            input: std::option::Option<crate::model::DomainDescription>,
        ) -> Self {
            self.domain = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainOutput`](crate::output::CreateDomainOutput)
        pub fn build(self) -> crate::output::CreateDomainOutput {
            crate::output::CreateDomainOutput {
                domain: self.domain,
            }
        }
    }
}
impl CreateDomainOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    pub fn builder() -> crate::output::create_domain_output::Builder {
        crate::output::create_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyPackageVersionsOutput {
    /// <p>
    /// A list of the package versions that were successfully copied to your repository.
    /// </p>
    pub successful_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    >,
    /// <p>
    /// A map of package versions that failed to copy and their error codes. The possible error codes are in
    /// the <code>PackageVersionError</code> data type. They are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub failed_versions: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    >,
}
impl CopyPackageVersionsOutput {
    /// <p>
    /// A list of the package versions that were successfully copied to your repository.
    /// </p>
    pub fn successful_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::SuccessfulPackageVersionInfo>,
    > {
        self.successful_versions.as_ref()
    }
    /// <p>
    /// A map of package versions that failed to copy and their error codes. The possible error codes are in
    /// the <code>PackageVersionError</code> data type. They are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn failed_versions(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
    > {
        self.failed_versions.as_ref()
    }
}
impl std::fmt::Debug for CopyPackageVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyPackageVersionsOutput");
        formatter.field("successful_versions", &self.successful_versions);
        formatter.field("failed_versions", &self.failed_versions);
        formatter.finish()
    }
}
/// See [`CopyPackageVersionsOutput`](crate::output::CopyPackageVersionsOutput)
pub mod copy_package_versions_output {
    /// A builder for [`CopyPackageVersionsOutput`](crate::output::CopyPackageVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successful_versions: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::SuccessfulPackageVersionInfo,
            >,
        >,
        pub(crate) failed_versions: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `successful_versions`.
        ///
        /// To override the contents of this collection use [`set_successful_versions`](Self::set_successful_versions).
        ///
        /// <p>
        /// A list of the package versions that were successfully copied to your repository.
        /// </p>
        pub fn successful_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::SuccessfulPackageVersionInfo>,
        ) -> Self {
            let mut hash_map = self.successful_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.successful_versions = Some(hash_map);
            self
        }
        /// <p>
        /// A list of the package versions that were successfully copied to your repository.
        /// </p>
        pub fn set_successful_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::SuccessfulPackageVersionInfo,
                >,
            >,
        ) -> Self {
            self.successful_versions = input;
            self
        }
        /// Adds a key-value pair to `failed_versions`.
        ///
        /// To override the contents of this collection use [`set_failed_versions`](Self::set_failed_versions).
        ///
        /// <p>
        /// A map of package versions that failed to copy and their error codes. The possible error codes are in
        /// the <code>PackageVersionError</code> data type. They are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn failed_versions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::PackageVersionError>,
        ) -> Self {
            let mut hash_map = self.failed_versions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.failed_versions = Some(hash_map);
            self
        }
        /// <p>
        /// A map of package versions that failed to copy and their error codes. The possible error codes are in
        /// the <code>PackageVersionError</code> data type. They are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_failed_versions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::PackageVersionError>,
            >,
        ) -> Self {
            self.failed_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyPackageVersionsOutput`](crate::output::CopyPackageVersionsOutput)
        pub fn build(self) -> crate::output::CopyPackageVersionsOutput {
            crate::output::CopyPackageVersionsOutput {
                successful_versions: self.successful_versions,
                failed_versions: self.failed_versions,
            }
        }
    }
}
impl CopyPackageVersionsOutput {
    /// Creates a new builder-style object to manufacture [`CopyPackageVersionsOutput`](crate::output::CopyPackageVersionsOutput)
    pub fn builder() -> crate::output::copy_package_versions_output::Builder {
        crate::output::copy_package_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateExternalConnectionOutput {
    /// <p>
    /// Information about the connected repository after processing the request.
    /// </p>
    pub repository: std::option::Option<crate::model::RepositoryDescription>,
}
impl AssociateExternalConnectionOutput {
    /// <p>
    /// Information about the connected repository after processing the request.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&crate::model::RepositoryDescription> {
        self.repository.as_ref()
    }
}
impl std::fmt::Debug for AssociateExternalConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateExternalConnectionOutput");
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}
/// See [`AssociateExternalConnectionOutput`](crate::output::AssociateExternalConnectionOutput)
pub mod associate_external_connection_output {
    /// A builder for [`AssociateExternalConnectionOutput`](crate::output::AssociateExternalConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository: std::option::Option<crate::model::RepositoryDescription>,
    }
    impl Builder {
        /// <p>
        /// Information about the connected repository after processing the request.
        /// </p>
        pub fn repository(mut self, input: crate::model::RepositoryDescription) -> Self {
            self.repository = Some(input);
            self
        }
        /// <p>
        /// Information about the connected repository after processing the request.
        /// </p>
        pub fn set_repository(
            mut self,
            input: std::option::Option<crate::model::RepositoryDescription>,
        ) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateExternalConnectionOutput`](crate::output::AssociateExternalConnectionOutput)
        pub fn build(self) -> crate::output::AssociateExternalConnectionOutput {
            crate::output::AssociateExternalConnectionOutput {
                repository: self.repository,
            }
        }
    }
}
impl AssociateExternalConnectionOutput {
    /// Creates a new builder-style object to manufacture [`AssociateExternalConnectionOutput`](crate::output::AssociateExternalConnectionOutput)
    pub fn builder() -> crate::output::associate_external_connection_output::Builder {
        crate::output::associate_external_connection_output::Builder::default()
    }
}
