// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `CodeArtifactControlPlaneService`.
///
/// This client allows ergonomic access to a `CodeArtifactControlPlaneService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateExternalConnection` operation.
    ///
    /// See [`AssociateExternalConnection`](crate::client::fluent_builders::AssociateExternalConnection) for more information about the
    /// operation and its arguments.
    pub fn associate_external_connection(
        &self,
    ) -> fluent_builders::AssociateExternalConnection<C, M, R> {
        fluent_builders::AssociateExternalConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyPackageVersions` operation.
    ///
    /// See [`CopyPackageVersions`](crate::client::fluent_builders::CopyPackageVersions) for more information about the
    /// operation and its arguments.
    pub fn copy_package_versions(&self) -> fluent_builders::CopyPackageVersions<C, M, R> {
        fluent_builders::CopyPackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomain` operation.
    ///
    /// See [`CreateDomain`](crate::client::fluent_builders::CreateDomain) for more information about the
    /// operation and its arguments.
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRepository` operation.
    ///
    /// See [`CreateRepository`](crate::client::fluent_builders::CreateRepository) for more information about the
    /// operation and its arguments.
    pub fn create_repository(&self) -> fluent_builders::CreateRepository<C, M, R> {
        fluent_builders::CreateRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomain` operation.
    ///
    /// See [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomainPermissionsPolicy` operation.
    ///
    /// See [`DeleteDomainPermissionsPolicy`](crate::client::fluent_builders::DeleteDomainPermissionsPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_domain_permissions_policy(
        &self,
    ) -> fluent_builders::DeleteDomainPermissionsPolicy<C, M, R> {
        fluent_builders::DeleteDomainPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePackageVersions` operation.
    ///
    /// See [`DeletePackageVersions`](crate::client::fluent_builders::DeletePackageVersions) for more information about the
    /// operation and its arguments.
    pub fn delete_package_versions(&self) -> fluent_builders::DeletePackageVersions<C, M, R> {
        fluent_builders::DeletePackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepository` operation.
    ///
    /// See [`DeleteRepository`](crate::client::fluent_builders::DeleteRepository) for more information about the
    /// operation and its arguments.
    pub fn delete_repository(&self) -> fluent_builders::DeleteRepository<C, M, R> {
        fluent_builders::DeleteRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRepositoryPermissionsPolicy` operation.
    ///
    /// See [`DeleteRepositoryPermissionsPolicy`](crate::client::fluent_builders::DeleteRepositoryPermissionsPolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_repository_permissions_policy(
        &self,
    ) -> fluent_builders::DeleteRepositoryPermissionsPolicy<C, M, R> {
        fluent_builders::DeleteRepositoryPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDomain` operation.
    ///
    /// See [`DescribeDomain`](crate::client::fluent_builders::DescribeDomain) for more information about the
    /// operation and its arguments.
    pub fn describe_domain(&self) -> fluent_builders::DescribeDomain<C, M, R> {
        fluent_builders::DescribeDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePackageVersion` operation.
    ///
    /// See [`DescribePackageVersion`](crate::client::fluent_builders::DescribePackageVersion) for more information about the
    /// operation and its arguments.
    pub fn describe_package_version(&self) -> fluent_builders::DescribePackageVersion<C, M, R> {
        fluent_builders::DescribePackageVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRepository` operation.
    ///
    /// See [`DescribeRepository`](crate::client::fluent_builders::DescribeRepository) for more information about the
    /// operation and its arguments.
    pub fn describe_repository(&self) -> fluent_builders::DescribeRepository<C, M, R> {
        fluent_builders::DescribeRepository::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateExternalConnection` operation.
    ///
    /// See [`DisassociateExternalConnection`](crate::client::fluent_builders::DisassociateExternalConnection) for more information about the
    /// operation and its arguments.
    pub fn disassociate_external_connection(
        &self,
    ) -> fluent_builders::DisassociateExternalConnection<C, M, R> {
        fluent_builders::DisassociateExternalConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisposePackageVersions` operation.
    ///
    /// See [`DisposePackageVersions`](crate::client::fluent_builders::DisposePackageVersions) for more information about the
    /// operation and its arguments.
    pub fn dispose_package_versions(&self) -> fluent_builders::DisposePackageVersions<C, M, R> {
        fluent_builders::DisposePackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAuthorizationToken` operation.
    ///
    /// See [`GetAuthorizationToken`](crate::client::fluent_builders::GetAuthorizationToken) for more information about the
    /// operation and its arguments.
    pub fn get_authorization_token(&self) -> fluent_builders::GetAuthorizationToken<C, M, R> {
        fluent_builders::GetAuthorizationToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomainPermissionsPolicy` operation.
    ///
    /// See [`GetDomainPermissionsPolicy`](crate::client::fluent_builders::GetDomainPermissionsPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_domain_permissions_policy(
        &self,
    ) -> fluent_builders::GetDomainPermissionsPolicy<C, M, R> {
        fluent_builders::GetDomainPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPackageVersionAsset` operation.
    ///
    /// See [`GetPackageVersionAsset`](crate::client::fluent_builders::GetPackageVersionAsset) for more information about the
    /// operation and its arguments.
    pub fn get_package_version_asset(&self) -> fluent_builders::GetPackageVersionAsset<C, M, R> {
        fluent_builders::GetPackageVersionAsset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPackageVersionReadme` operation.
    ///
    /// See [`GetPackageVersionReadme`](crate::client::fluent_builders::GetPackageVersionReadme) for more information about the
    /// operation and its arguments.
    pub fn get_package_version_readme(&self) -> fluent_builders::GetPackageVersionReadme<C, M, R> {
        fluent_builders::GetPackageVersionReadme::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepositoryEndpoint` operation.
    ///
    /// See [`GetRepositoryEndpoint`](crate::client::fluent_builders::GetRepositoryEndpoint) for more information about the
    /// operation and its arguments.
    pub fn get_repository_endpoint(&self) -> fluent_builders::GetRepositoryEndpoint<C, M, R> {
        fluent_builders::GetRepositoryEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRepositoryPermissionsPolicy` operation.
    ///
    /// See [`GetRepositoryPermissionsPolicy`](crate::client::fluent_builders::GetRepositoryPermissionsPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_repository_permissions_policy(
        &self,
    ) -> fluent_builders::GetRepositoryPermissionsPolicy<C, M, R> {
        fluent_builders::GetRepositoryPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomains` operation.
    ///
    /// See [`ListDomains`](crate::client::fluent_builders::ListDomains) for more information about the
    /// operation and its arguments.
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackages` operation.
    ///
    /// See [`ListPackages`](crate::client::fluent_builders::ListPackages) for more information about the
    /// operation and its arguments.
    pub fn list_packages(&self) -> fluent_builders::ListPackages<C, M, R> {
        fluent_builders::ListPackages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackageVersionAssets` operation.
    ///
    /// See [`ListPackageVersionAssets`](crate::client::fluent_builders::ListPackageVersionAssets) for more information about the
    /// operation and its arguments.
    pub fn list_package_version_assets(
        &self,
    ) -> fluent_builders::ListPackageVersionAssets<C, M, R> {
        fluent_builders::ListPackageVersionAssets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackageVersionDependencies` operation.
    ///
    /// See [`ListPackageVersionDependencies`](crate::client::fluent_builders::ListPackageVersionDependencies) for more information about the
    /// operation and its arguments.
    pub fn list_package_version_dependencies(
        &self,
    ) -> fluent_builders::ListPackageVersionDependencies<C, M, R> {
        fluent_builders::ListPackageVersionDependencies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPackageVersions` operation.
    ///
    /// See [`ListPackageVersions`](crate::client::fluent_builders::ListPackageVersions) for more information about the
    /// operation and its arguments.
    pub fn list_package_versions(&self) -> fluent_builders::ListPackageVersions<C, M, R> {
        fluent_builders::ListPackageVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRepositories` operation.
    ///
    /// See [`ListRepositories`](crate::client::fluent_builders::ListRepositories) for more information about the
    /// operation and its arguments.
    pub fn list_repositories(&self) -> fluent_builders::ListRepositories<C, M, R> {
        fluent_builders::ListRepositories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRepositoriesInDomain` operation.
    ///
    /// See [`ListRepositoriesInDomain`](crate::client::fluent_builders::ListRepositoriesInDomain) for more information about the
    /// operation and its arguments.
    pub fn list_repositories_in_domain(
        &self,
    ) -> fluent_builders::ListRepositoriesInDomain<C, M, R> {
        fluent_builders::ListRepositoriesInDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutDomainPermissionsPolicy` operation.
    ///
    /// See [`PutDomainPermissionsPolicy`](crate::client::fluent_builders::PutDomainPermissionsPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_domain_permissions_policy(
        &self,
    ) -> fluent_builders::PutDomainPermissionsPolicy<C, M, R> {
        fluent_builders::PutDomainPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRepositoryPermissionsPolicy` operation.
    ///
    /// See [`PutRepositoryPermissionsPolicy`](crate::client::fluent_builders::PutRepositoryPermissionsPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_repository_permissions_policy(
        &self,
    ) -> fluent_builders::PutRepositoryPermissionsPolicy<C, M, R> {
        fluent_builders::PutRepositoryPermissionsPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePackageVersionsStatus` operation.
    ///
    /// See [`UpdatePackageVersionsStatus`](crate::client::fluent_builders::UpdatePackageVersionsStatus) for more information about the
    /// operation and its arguments.
    pub fn update_package_versions_status(
        &self,
    ) -> fluent_builders::UpdatePackageVersionsStatus<C, M, R> {
        fluent_builders::UpdatePackageVersionsStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRepository` operation.
    ///
    /// See [`UpdateRepository`](crate::client::fluent_builders::UpdateRepository) for more information about the
    /// operation and its arguments.
    pub fn update_repository(&self) -> fluent_builders::UpdateRepository<C, M, R> {
        fluent_builders::UpdateRepository::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateExternalConnection`.
    ///
    /// <p>Adds an existing external connection to a repository. One external connection is allowed
    /// per repository.</p>
    /// <note>
    /// <p>A repository can have one or more upstream repositories, or an external connection.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AssociateExternalConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_external_connection_input::Builder,
    }
    impl<C, M, R> AssociateExternalConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateExternalConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateExternalConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateExternalConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateExternalConnectionInputOperationOutputAlias,
                crate::output::AssociateExternalConnectionOutput,
                crate::error::AssociateExternalConnectionError,
                crate::input::AssociateExternalConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the repository.</p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain that contains the repository.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository to which the external connection is added.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository to which the external connection is added.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// The name of the external connection to add to the repository. The following values are supported:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>public:npmjs</code> - for the npm public repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:pypi</code> - for the Python Package Index.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-central</code> - for Maven Central.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-googleandroid</code> - for the Google Android repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
        /// </p>
        /// </li>
        /// </ul>
        pub fn external_connection(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_connection(inp);
            self
        }
        /// <p>
        /// The name of the external connection to add to the repository. The following values are supported:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>public:npmjs</code> - for the npm public repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:pypi</code> - for the Python Package Index.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-central</code> - for Maven Central.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-googleandroid</code> - for the Google Android repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_external_connection(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_connection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyPackageVersions`.
    ///
    /// <p>
    /// Copies package versions from one repository to another repository in the same domain.
    /// </p>
    /// <note>
    /// <p>
    /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CopyPackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_package_versions_input::Builder,
    }
    impl<C, M, R> CopyPackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyPackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyPackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyPackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyPackageVersionsInputOperationOutputAlias,
                crate::output::CopyPackageVersionsOutput,
                crate::error::CopyPackageVersionsError,
                crate::input::CopyPackageVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the source and destination repositories.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the source and destination repositories.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to copy.
        /// </p>
        pub fn source_repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_repository(inp);
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to copy.
        /// </p>
        pub fn set_source_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_repository(input);
            self
        }
        /// <p>
        /// The name of the repository into which package versions are copied.
        /// </p>
        pub fn destination_repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_repository(inp);
            self
        }
        /// <p>
        /// The name of the repository into which package versions are copied.
        /// </p>
        pub fn set_destination_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_repository(input);
            self
        }
        /// <p>
        /// The format of the package that is copied. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// The format of the package that is copied. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package that is copied.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package that is copied.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// The versions of the package to copy.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn versions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(inp);
            self
        }
        /// <p>
        /// The versions of the package to copy.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// Adds a key-value pair to `versionRevisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p>
        /// A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation
        /// succeeds if the specified versions in the source repository match the specified package version revision.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.version_revisions(k, v);
            self
        }
        /// <p>
        /// A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation
        /// succeeds if the specified versions in the source repository match the specified package version revision.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_version_revisions(input);
            self
        }
        /// <p>
        /// Set to true to overwrite a package version that already exists in the destination repository.
        /// If set to false and the package version already exists in the destination repository,
        /// the package version is returned in the <code>failedVersions</code> field of the response with
        /// an <code>ALREADY_EXISTS</code> error code.
        /// </p>
        pub fn allow_overwrite(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_overwrite(inp);
            self
        }
        /// <p>
        /// Set to true to overwrite a package version that already exists in the destination repository.
        /// If set to false and the package version already exists in the destination repository,
        /// the package version is returned in the <code>failedVersions</code> field of the response with
        /// an <code>ALREADY_EXISTS</code> error code.
        /// </p>
        pub fn set_allow_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_overwrite(input);
            self
        }
        /// <p> Set to true to copy packages from repositories that are upstream from the source
        /// repository to the destination repository. The default setting is false. For more information,
        /// see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
        /// upstream repositories</a>. </p>
        pub fn include_from_upstream(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_from_upstream(inp);
            self
        }
        /// <p> Set to true to copy packages from repositories that are upstream from the source
        /// repository to the destination repository. The default setting is false. For more information,
        /// see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
        /// upstream repositories</a>. </p>
        pub fn set_include_from_upstream(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_from_upstream(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>
    /// Creates a domain. CodeArtifact <i>domains</i> make it easier to manage multiple repositories across an
    /// organization. You can use a domain to apply permissions across many
    /// repositories owned by different AWS accounts. An asset is stored only once
    /// in a domain, even if it's in multiple repositories.
    /// </p>
    ///
    /// <p>Although you can have multiple domains, we recommend a single production domain that contains all
    /// published artifacts so that your development teams can find and share packages. You can use a second
    /// pre-production domain to test changes to the production domain configuration.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the domain to create. All domain names in an AWS Region that are in the
        /// same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do
        /// not use sensitive information in a domain name because it is publicly discoverable. </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p> The name of the domain to create. All domain names in an AWS Region that are in the
        /// same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do
        /// not use sensitive information in a domain name because it is publicly discoverable. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain.
        /// An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key
        /// alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have
        /// <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption
        /// key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i>
        /// and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions
        /// Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// <important>
        /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your
        /// domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric
        /// keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// </important>
        pub fn encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain.
        /// An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key
        /// alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have
        /// <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption
        /// key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i>
        /// and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions
        /// Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// <important>
        /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your
        /// domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric
        /// keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// </important>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the domain.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tag key-value pairs for the domain.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRepository`.
    ///
    /// <p>
    /// Creates a repository.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_repository_input::Builder,
    }
    impl<C, M, R> CreateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRepositoryInputOperationOutputAlias,
                crate::output::CreateRepositoryOutput,
                crate::error::CreateRepositoryError,
                crate::input::CreateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the created repository.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the created repository.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to create. </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p> The name of the repository to create. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// A description of the created repository.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// A description of the created repository.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `upstreams`.
        ///
        /// To override the contents of this collection use [`set_upstreams`](Self::set_upstreams).
        ///
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn upstreams(mut self, inp: impl Into<crate::model::UpstreamRepository>) -> Self {
            self.inner = self.inner.upstreams(inp);
            self
        }
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_upstreams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
        ) -> Self {
            self.inner = self.inner.set_upstreams(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the repository.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tag key-value pairs for the repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>
    /// Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain
    /// with repositories, first delete its repositories.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain to delete.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain to delete.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainPermissionsPolicy`.
    ///
    /// <p>
    /// Deletes the resource policy set on a domain.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomainPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_permissions_policy_input::Builder,
    }
    impl<C, M, R> DeleteDomainPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainPermissionsPolicyInputOperationOutputAlias,
                crate::output::DeleteDomainPermissionsPolicyOutput,
                crate::error::DeleteDomainPermissionsPolicyError,
                crate::input::DeleteDomainPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain associated with the resource policy to be deleted.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain associated with the resource policy to be deleted.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn policy_revision(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(inp);
            self
        }
        /// <p>
        /// The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePackageVersions`.
    ///
    /// <p> Deletes one or more versions of a package. A deleted package version cannot be restored
    /// in your repository. If you want to remove a package version from your repository and be able
    /// to restore it later, set its status to <code>Archived</code>. Archived packages cannot be
    /// downloaded from a repository and don't show up with list package APIs (for example,
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListackageVersions</a>), but you can restore them using <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html">UpdatePackageVersionsStatus</a>. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_package_versions_input::Builder,
    }
    impl<C, M, R> DeletePackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePackageVersionsInputOperationOutputAlias,
                crate::output::DeletePackageVersionsOutput,
                crate::error::DeletePackageVersionsError,
                crate::input::DeletePackageVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the package to delete.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the package to delete.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to delete.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to delete.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// The format of the package versions to delete. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// The format of the package versions to delete. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package with the versions to delete.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package with the versions to delete.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// An array of strings that specify the versions of the package to delete.
        /// </p>
        pub fn versions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(inp);
            self
        }
        /// <p>
        /// An array of strings that specify the versions of the package to delete.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// <p>
        /// The expected status of the package version to delete. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn expected_status(mut self, inp: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.expected_status(inp);
            self
        }
        /// <p>
        /// The expected status of the package version to delete. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_expected_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepository`.
    ///
    /// <p>
    /// Deletes a repository.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_input::Builder,
    }
    impl<C, M, R> DeleteRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryInputOperationOutputAlias,
                crate::output::DeleteRepositoryOutput,
                crate::error::DeleteRepositoryError,
                crate::input::DeleteRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository to delete.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository to delete.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to delete. </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p> The name of the repository to delete. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRepositoryPermissionsPolicy`.
    ///
    /// <p>
    /// Deletes the resource policy that is set on a repository. After a resource policy is deleted, the
    /// permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.
    /// </p>
    /// <important>
    /// <p>
    /// Use <code>DeleteRepositoryPermissionsPolicy</code> with caution. After a policy is deleted, AWS users, roles, and accounts lose permissions to perform
    /// the repository actions granted by the deleted policy.
    /// </p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRepositoryPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_repository_permissions_policy_input::Builder,
    }
    impl<C, M, R> DeleteRepositoryPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRepositoryPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRepositoryPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRepositoryPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRepositoryPermissionsPolicyInputOperationOutputAlias,
                crate::output::DeleteRepositoryPermissionsPolicyOutput,
                crate::error::DeleteRepositoryPermissionsPolicyError,
                crate::input::DeleteRepositoryPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository associated with the resource policy to be deleted.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository associated with the resource policy to be deleted.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository that is associated with the resource policy to be deleted
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository that is associated with the resource policy to be deleted
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from accidentally overwriting your changes to the repository's resource policy.
        /// </p>
        pub fn policy_revision(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(inp);
            self
        }
        /// <p>
        /// The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from accidentally overwriting your changes to the repository's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDomain`.
    ///
    /// <p>
    /// Returns a
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html">DomainDescription</a>
    /// object that contains information about the requested domain.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_domain_input::Builder,
    }
    impl<C, M, R> DescribeDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDomainInputOperationOutputAlias,
                crate::output::DescribeDomainOutput,
                crate::error::DescribeDomainError,
                crate::input::DescribeDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// A string that specifies the name of the requested domain.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// A string that specifies the name of the requested domain.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePackageVersion`.
    ///
    /// <p>
    /// Returns a
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">PackageVersionDescription</a>
    /// object that contains information about the requested package version.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePackageVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_package_version_input::Builder,
    }
    impl<C, M, R> DescribePackageVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePackageVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePackageVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePackageVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePackageVersionInputOperationOutputAlias,
                crate::output::DescribePackageVersionOutput,
                crate::error::DescribePackageVersionError,
                crate::input::DescribePackageVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository that contains the package version. </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p> The name of the repository that contains the package version. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the requested package version. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// A format that specifies the type of the requested package version. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p> The name of the requested package version. </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p> The name of the requested package version. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(inp);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRepository`.
    ///
    /// <p>
    /// Returns a <code>RepositoryDescription</code> object that contains detailed information
    /// about the requested repository.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_repository_input::Builder,
    }
    impl<C, M, R> DescribeRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRepositoryInputOperationOutputAlias,
                crate::output::DescribeRepositoryOutput,
                crate::error::DescribeRepositoryError,
                crate::input::DescribeRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository to describe.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository to describe.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// A string that specifies the name of the requested repository.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// A string that specifies the name of the requested repository.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateExternalConnection`.
    ///
    /// <p>
    /// Removes an existing external connection from a repository.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateExternalConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_external_connection_input::Builder,
    }
    impl<C, M, R> DisassociateExternalConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateExternalConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateExternalConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateExternalConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateExternalConnectionInputOperationOutputAlias,
                crate::output::DisassociateExternalConnectionOutput,
                crate::error::DisassociateExternalConnectionError,
                crate::input::DisassociateExternalConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain that contains the repository from which to remove the external
        /// repository. </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>The name of the domain that contains the repository from which to remove the external
        /// repository. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>The name of the repository from which the external connection will be removed. </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>The name of the repository from which the external connection will be removed. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>The name of the external connection to be removed from the repository. </p>
        pub fn external_connection(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_connection(inp);
            self
        }
        /// <p>The name of the external connection to be removed from the repository. </p>
        pub fn set_external_connection(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_connection(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisposePackageVersions`.
    ///
    /// <p>
    /// Deletes the assets in package versions and sets the package versions' status to <code>Disposed</code>.
    /// A disposed package version cannot be restored in your repository because its assets are deleted.
    /// </p>
    ///
    /// <p>
    /// To view all disposed package versions in a repository, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListPackageVersions</a> and set the
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax">status</a> parameter
    /// to <code>Disposed</code>.
    /// </p>
    ///
    /// <p>
    /// To view information about a disposed package version, use <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html">DescribePackageVersion</a>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DisposePackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::dispose_package_versions_input::Builder,
    }
    impl<C, M, R> DisposePackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisposePackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisposePackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisposePackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisposePackageVersionsInputOperationOutputAlias,
                crate::output::DisposePackageVersionsOutput,
                crate::error::DisposePackageVersionsError,
                crate::input::DisposePackageVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository you want to dispose.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository you want to dispose.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions you want to dispose.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions you want to dispose.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// A format that specifies the type of package versions you want to dispose. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// A format that specifies the type of package versions you want to dispose. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package with the versions you want to dispose.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package with the versions you want to dispose.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// The versions of the package you want to dispose.
        /// </p>
        pub fn versions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(inp);
            self
        }
        /// <p>
        /// The versions of the package you want to dispose.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// Adds a key-value pair to `versionRevisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p>
        /// The revisions of the package versions you want to dispose.
        /// </p>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.version_revisions(k, v);
            self
        }
        /// <p>
        /// The revisions of the package versions you want to dispose.
        /// </p>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_version_revisions(input);
            self
        }
        /// <p>
        /// The expected status of the package version to dispose. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn expected_status(mut self, inp: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.expected_status(inp);
            self
        }
        /// <p>
        /// The expected status of the package version to dispose. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_expected_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAuthorizationToken`.
    ///
    /// <p>
    /// Generates a temporary authorization token for accessing repositories in the domain.
    /// This API requires the <code>codeartifact:GetAuthorizationToken</code> and <code>sts:GetServiceBearerToken</code> permissions.
    /// For more information about authorization tokens, see
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html">AWS CodeArtifact authentication and tokens</a>.
    /// </p>
    /// <note>
    /// <p>CodeArtifact authorization tokens are valid for a period of 12 hours when created with the <code>login</code> command.
    /// You can call <code>login</code> periodically to refresh the token. When
    /// you create an authorization token with the <code>GetAuthorizationToken</code> API, you can set a custom authorization period,
    /// up to a maximum of 12 hours, with the <code>durationSeconds</code> parameter.</p>
    /// <p>The authorization period begins after <code>login</code>
    /// or <code>GetAuthorizationToken</code> is called. If <code>login</code> or <code>GetAuthorizationToken</code> is called while
    /// assuming a role, the token lifetime is independent of the maximum session duration
    /// of the role. For example, if you call <code>sts assume-role</code> and specify a session duration of 15 minutes, then
    /// generate a CodeArtifact authorization token, the token will be valid for the full authorization period
    /// even though this is longer than the 15-minute session duration.</p>
    /// <p>See
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html">Using IAM Roles</a>
    /// for more information on controlling session duration. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetAuthorizationToken<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_authorization_token_input::Builder,
    }
    impl<C, M, R> GetAuthorizationToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAuthorizationToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAuthorizationTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAuthorizationTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAuthorizationTokenInputOperationOutputAlias,
                crate::output::GetAuthorizationTokenOutput,
                crate::error::GetAuthorizationTokenError,
                crate::input::GetAuthorizationTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that is in scope for the generated authorization token.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that is in scope for the generated authorization token.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are
        /// <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours).
        /// A value of <code>0</code> will set the expiration of the authorization token to the same expiration of
        /// the user's role's temporary credentials.</p>
        pub fn duration_seconds(mut self, inp: i64) -> Self {
            self.inner = self.inner.duration_seconds(inp);
            self
        }
        /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are
        /// <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours).
        /// A value of <code>0</code> will set the expiration of the authorization token to the same expiration of
        /// the user's role's temporary credentials.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_duration_seconds(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomainPermissionsPolicy`.
    ///
    /// <p>
    /// Returns the resource policy attached to the specified domain.
    /// </p>
    /// <note>
    /// <p>
    /// The policy is a resource-based policy, not an identity-based policy. For more information, see
    /// <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies
    /// and resource-based policies </a> in the <i>AWS Identity and Access Management User Guide</i>.
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDomainPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_permissions_policy_input::Builder,
    }
    impl<C, M, R> GetDomainPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomainPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainPermissionsPolicyInputOperationOutputAlias,
                crate::output::GetDomainPermissionsPolicyOutput,
                crate::error::GetDomainPermissionsPolicyError,
                crate::input::GetDomainPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain to which the resource policy is attached.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain to which the resource policy is attached.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionAsset`.
    ///
    /// <p>
    /// Returns an asset (or file) that is in a package. For example, for a Maven package version, use
    /// <code>GetPackageVersionAsset</code> to download a <code>JAR</code> file, a <code>POM</code> file,
    /// or any other assets in the package version.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetPackageVersionAsset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_package_version_asset_input::Builder,
    }
    impl<C, M, R> GetPackageVersionAsset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPackageVersionAsset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionAssetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionAssetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPackageVersionAssetInputOperationOutputAlias,
                crate::output::GetPackageVersionAssetOutput,
                crate::error::GetPackageVersionAssetError,
                crate::input::GetPackageVersionAssetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested asset.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested asset.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The repository that contains the package version with the requested asset.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The repository that contains the package version with the requested asset.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested asset file. The valid values are:
        /// </p>    
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested asset file. The valid values are:
        /// </p>    
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package that contains the requested asset.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package that contains the requested asset.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(inp);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p>
        /// The name of the requested asset.
        /// </p>
        pub fn asset(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.asset(inp);
            self
        }
        /// <p>
        /// The name of the requested asset.
        /// </p>
        pub fn set_asset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_asset(input);
            self
        }
        /// <p>
        /// The name of the package version revision that contains the requested asset.
        /// </p>
        pub fn package_version_revision(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version_revision(inp);
            self
        }
        /// <p>
        /// The name of the package version revision that contains the requested asset.
        /// </p>
        pub fn set_package_version_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version_revision(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPackageVersionReadme`.
    ///
    /// <p>
    /// Gets the readme file or descriptive text for a package version. For packages that do not contain a readme file, CodeArtifact
    /// extracts a description from a metadata file. For example, from the <code><description></code> element in the
    /// <code>pom.xml</code> file of a Maven package.
    /// </p>
    /// <p>
    /// The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetPackageVersionReadme<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_package_version_readme_input::Builder,
    }
    impl<C, M, R> GetPackageVersionReadme<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPackageVersionReadme`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPackageVersionReadmeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPackageVersionReadmeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPackageVersionReadmeInputOperationOutputAlias,
                crate::output::GetPackageVersionReadmeOutput,
                crate::error::GetPackageVersionReadmeError,
                crate::input::GetPackageVersionReadmeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested readme file.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested readme file.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The repository that contains the package with the requested readme file.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The repository that contains the package with the requested readme file.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested readme file. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested readme file. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package version that contains the requested readme file.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package version that contains the requested readme file.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(inp);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryEndpoint`.
    ///
    /// <p>
    /// Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each
    /// package format:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct GetRepositoryEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_endpoint_input::Builder,
    }
    impl<C, M, R> GetRepositoryEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryEndpointInputOperationOutputAlias,
                crate::output::GetRepositoryEndpointOutput,
                crate::error::GetRepositoryEndpointError,
                crate::input::GetRepositoryEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// Returns which endpoint of a repository to return. A repository has one endpoint for each
        /// package format:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// Returns which endpoint of a repository to return. A repository has one endpoint for each
        /// package format:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRepositoryPermissionsPolicy`.
    ///
    /// <p>
    /// Returns the resource policy that is set on a repository.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct GetRepositoryPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_repository_permissions_policy_input::Builder,
    }
    impl<C, M, R> GetRepositoryPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRepositoryPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRepositoryPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRepositoryPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRepositoryPermissionsPolicyInputOperationOutputAlias,
                crate::output::GetRepositoryPermissionsPolicyOutput,
                crate::error::GetRepositoryPermissionsPolicyError,
                crate::input::GetRepositoryPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain containing the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain containing the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p> Returns a list of <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html">DomainSummary</a> objects for all domains owned by the AWS account that makes
    /// this call. Each returned <code>DomainSummary</code> object contains information about a
    /// domain. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackages`.
    ///
    /// <p>
    /// Returns a list of
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html">PackageSummary</a>
    /// objects for packages in a repository that match the request parameters.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListPackages<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_packages_input::Builder,
    }
    impl<C, M, R> ListPackages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackagesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackagesInputOperationOutputAlias,
                crate::output::ListPackagesOutput,
                crate::error::ListPackagesError,
                crate::input::ListPackagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the requested list of packages.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the requested list of packages.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository from which packages are to be listed.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository from which packages are to be listed.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// The format of the packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// The format of the packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// A prefix used to filter returned packages. Only packages with names that start with
        /// <code>packagePrefix</code> are returned.
        /// </p>
        pub fn package_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_prefix(inp);
            self
        }
        /// <p>
        /// A prefix used to filter returned packages. Only packages with names that start with
        /// <code>packagePrefix</code> are returned.
        /// </p>
        pub fn set_package_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_prefix(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackageVersionAssets`.
    ///
    /// <p>
    /// Returns a list of
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html">AssetSummary</a>
    /// objects for assets in a package version.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListPackageVersionAssets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_package_version_assets_input::Builder,
    }
    impl<C, M, R> ListPackageVersionAssets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackageVersionAssets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackageVersionAssetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackageVersionAssetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackageVersionAssetsInputOperationOutputAlias,
                crate::output::ListPackageVersionAssetsOutput,
                crate::error::ListPackageVersionAssetsError,
                crate::input::ListPackageVersionAssetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository associated with the package version assets.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository associated with the package version assets.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository that contains the package that contains the returned package version assets.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository that contains the package that contains the returned package version assets.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// The format of the package that contains the returned package version assets. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// The format of the package that contains the returned package version assets. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package that contains the returned package version assets.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package that contains the returned package version assets.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(inp);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackageVersionDependencies`.
    ///
    /// <p>
    /// Returns the direct dependencies for a package version. The dependencies are returned as
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html">PackageDependency</a>
    /// objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package
    /// format (for example, the <code>package.json</code> file for npm packages and the <code>pom.xml</code> file
    /// for Maven). Any package version dependencies that are not listed in the configuration file are not returned.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListPackageVersionDependencies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_package_version_dependencies_input::Builder,
    }
    impl<C, M, R> ListPackageVersionDependencies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackageVersionDependencies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackageVersionDependenciesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackageVersionDependenciesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackageVersionDependenciesInputOperationOutputAlias,
                crate::output::ListPackageVersionDependenciesOutput,
                crate::error::ListPackageVersionDependenciesError,
                crate::input::ListPackageVersionDependenciesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the requested package version dependencies.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the requested package version dependencies.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository that contains the requested package version.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository that contains the requested package version.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// The format of the package with the requested dependencies. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// The format of the package with the requested dependencies. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package versions' package.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package versions' package.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package_version(inp);
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_package_version(input);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPackageVersions`.
    ///
    /// <p>
    /// Returns a list of
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html">PackageVersionSummary</a>
    /// objects for package versions in a repository that match the request parameters.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListPackageVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_package_versions_input::Builder,
    }
    impl<C, M, R> ListPackageVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPackageVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPackageVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPackageVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPackageVersionsInputOperationOutputAlias,
                crate::output::ListPackageVersionsOutput,
                crate::error::ListPackageVersionsError,
                crate::input::ListPackageVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the returned package versions.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the returned package versions.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository that contains the package.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository that contains the package.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// The format of the returned packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// The format of the returned packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package for which you want to return a list of package versions.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package for which you want to return a list of package versions.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// <p>
        /// A string that specifies the status of the package versions to include in the returned list. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, inp: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>
        /// A string that specifies the status of the package versions to include in the returned list. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>
        /// How to sort the returned list of package versions.
        /// </p>
        pub fn sort_by(mut self, inp: crate::model::PackageVersionSortType) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>
        /// How to sort the returned list of package versions.
        /// </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::PackageVersionSortType>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositories`.
    ///
    /// <p>
    /// Returns a list of
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a>
    /// objects. Each <code>RepositorySummary</code> contains information about a repository in the specified AWS account and that matches the input
    /// parameters.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRepositories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repositories_input::Builder,
    }
    impl<C, M, R> ListRepositories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoriesInputOperationOutputAlias,
                crate::output::ListRepositoriesOutput,
                crate::error::ListRepositoriesError,
                crate::input::ListRepositoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start
        /// with <code>repositoryPrefix</code> are returned.</p>
        pub fn repository_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_prefix(inp);
            self
        }
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start
        /// with <code>repositoryPrefix</code> are returned.</p>
        pub fn set_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_prefix(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRepositoriesInDomain`.
    ///
    /// <p>
    /// Returns a list of
    /// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html">RepositorySummary</a>
    /// objects. Each <code>RepositorySummary</code> contains information about a repository in the specified domain and that matches the input
    /// parameters.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ListRepositoriesInDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_repositories_in_domain_input::Builder,
    }
    impl<C, M, R> ListRepositoriesInDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRepositoriesInDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRepositoriesInDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRepositoriesInDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRepositoriesInDomainInputOperationOutputAlias,
                crate::output::ListRepositoriesInDomainOutput,
                crate::error::ListRepositoriesInDomainError,
                crate::input::ListRepositoriesInDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the returned list of repositories.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the returned list of repositories.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// Filter the list of repositories to only include those that are managed by the AWS account ID.
        /// </p>
        pub fn administrator_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.administrator_account(inp);
            self
        }
        /// <p>
        /// Filter the list of repositories to only include those that are managed by the AWS account ID.
        /// </p>
        pub fn set_administrator_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_administrator_account(input);
            self
        }
        /// <p>
        /// A prefix used to filter returned repositories. Only repositories with names that start with
        /// <code>repositoryPrefix</code> are returned.
        /// </p>
        pub fn repository_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository_prefix(inp);
            self
        }
        /// <p>
        /// A prefix used to filter returned repositories. Only repositories with names that start with
        /// <code>repositoryPrefix</code> are returned.
        /// </p>
        pub fn set_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_repository_prefix(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets information about AWS tags for a specified Amazon Resource Name (ARN) in AWS CodeArtifact.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDomainPermissionsPolicy`.
    ///
    /// <p>
    /// Sets a resource policy on a domain that specifies permissions to access it.
    /// </p>
    /// <p>
    /// When you call <code>PutDomainPermissionsPolicy</code>, the resource policy on the domain is ignored when evaluting permissions.
    /// This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being
    /// able to update the resource policy.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct PutDomainPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_domain_permissions_policy_input::Builder,
    }
    impl<C, M, R> PutDomainPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutDomainPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDomainPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDomainPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutDomainPermissionsPolicyInputOperationOutputAlias,
                crate::output::PutDomainPermissionsPolicyOutput,
                crate::error::PutDomainPermissionsPolicyError,
                crate::input::PutDomainPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain on which to set the resource policy.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain on which to set the resource policy.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The current revision of the resource policy to be set. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn policy_revision(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(inp);
            self
        }
        /// <p>
        /// The current revision of the resource policy to be set. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided domain. </p>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided domain. </p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRepositoryPermissionsPolicy`.
    ///
    /// <p>
    /// Sets the resource policy on a repository that specifies permissions to access it.
    /// </p>
    /// <p>
    /// When you call <code>PutRepositoryPermissionsPolicy</code>, the resource policy on the repository is ignored when evaluting permissions.
    /// This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being
    /// able to update the resource policy.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct PutRepositoryPermissionsPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_repository_permissions_policy_input::Builder,
    }
    impl<C, M, R> PutRepositoryPermissionsPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRepositoryPermissionsPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRepositoryPermissionsPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRepositoryPermissionsPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRepositoryPermissionsPolicyInputOperationOutputAlias,
                crate::output::PutRepositoryPermissionsPolicyOutput,
                crate::error::PutRepositoryPermissionsPolicyError,
                crate::input::PutRepositoryPermissionsPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain containing the repository to set the resource policy on.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain containing the repository to set the resource policy on.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p> The name of the repository to set the resource policy on. </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p> The name of the repository to set the resource policy on. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// Sets the revision of the resource policy that specifies permissions to access the repository.
        /// This revision is used for optimistic locking, which prevents others from overwriting your
        /// changes to the repository's resource policy.
        /// </p>
        pub fn policy_revision(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_revision(inp);
            self
        }
        /// <p>
        /// Sets the revision of the resource policy that specifies permissions to access the repository.
        /// This revision is used for optimistic locking, which prevents others from overwriting your
        /// changes to the repository's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_revision(input);
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided repository. </p>
        pub fn policy_document(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(inp);
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided repository. </p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates tags for a resource in AWS CodeArtifact.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes tags from a resource in AWS CodeArtifact.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePackageVersionsStatus`.
    ///
    /// <p>
    /// Updates the status of one or more versions of a package.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePackageVersionsStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_package_versions_status_input::Builder,
    }
    impl<C, M, R> UpdatePackageVersionsStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePackageVersionsStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePackageVersionsStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePackageVersionsStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePackageVersionsStatusInputOperationOutputAlias,
                crate::output::UpdatePackageVersionsStatusOutput,
                crate::error::UpdatePackageVersionsStatusError,
                crate::input::UpdatePackageVersionsStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package versions with a status to be updated.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package versions with a status to be updated.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The repository that contains the package versions with the status you want to update.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The repository that contains the package versions with the status you want to update.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the package with the statuses to update. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, inp: crate::model::PackageFormat) -> Self {
            self.inner = self.inner.format(inp);
            self
        }
        /// <p>
        /// A format that specifies the type of the package with the statuses to update. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.inner = self.inner.set_format(input);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.namespace(inp);
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_namespace(input);
            self
        }
        /// <p>
        /// The name of the package with the version statuses to update.
        /// </p>
        pub fn package(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.package(inp);
            self
        }
        /// <p>
        /// The name of the package with the version statuses to update.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_package(input);
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// An array of strings that specify the versions of the package with the statuses to update.
        /// </p>
        pub fn versions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versions(inp);
            self
        }
        /// <p>
        /// An array of strings that specify the versions of the package with the statuses to update.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_versions(input);
            self
        }
        /// Adds a key-value pair to `versionRevisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p> A map of package versions and package version revisions. The map <code>key</code> is the
        /// package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the
        /// package version revision. </p>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.version_revisions(k, v);
            self
        }
        /// <p> A map of package versions and package version revisions. The map <code>key</code> is the
        /// package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the
        /// package version revision. </p>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_version_revisions(input);
            self
        }
        /// <p> The package version’s expected status before it is updated. If
        /// <code>expectedStatus</code> is provided, the package version's status is updated only if its
        /// status at the time <code>UpdatePackageVersionsStatus</code> is called matches
        /// <code>expectedStatus</code>. </p>
        pub fn expected_status(mut self, inp: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.expected_status(inp);
            self
        }
        /// <p> The package version’s expected status before it is updated. If
        /// <code>expectedStatus</code> is provided, the package version's status is updated only if its
        /// status at the time <code>UpdatePackageVersionsStatus</code> is called matches
        /// <code>expectedStatus</code>. </p>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_expected_status(input);
            self
        }
        /// <p>
        /// The status you want to change the package version status to.
        /// </p>
        pub fn target_status(mut self, inp: crate::model::PackageVersionStatus) -> Self {
            self.inner = self.inner.target_status(inp);
            self
        }
        /// <p>
        /// The status you want to change the package version status to.
        /// </p>
        pub fn set_target_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.inner = self.inner.set_target_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRepository`.
    ///
    /// <p>
    /// Update the properties of a repository.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRepository<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_repository_input::Builder,
    }
    impl<C, M, R> UpdateRepository<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRepository`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRepositoryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRepositoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRepositoryInputOperationOutputAlias,
                crate::output::UpdateRepositoryOutput,
                crate::error::UpdateRepositoryError,
                crate::input::UpdateRepositoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The name of the domain associated with the repository to update.
        /// </p>
        pub fn domain(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(inp);
            self
        }
        /// <p>
        /// The name of the domain associated with the repository to update.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_owner(inp);
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_owner(input);
            self
        }
        /// <p>
        /// The name of the repository to update.
        /// </p>
        pub fn repository(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.repository(inp);
            self
        }
        /// <p>
        /// The name of the repository to update.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_repository(input);
            self
        }
        /// <p>
        /// An updated repository description.
        /// </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>
        /// An updated repository description.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `upstreams`.
        ///
        /// To override the contents of this collection use [`set_upstreams`](Self::set_upstreams).
        ///
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn upstreams(mut self, inp: impl Into<crate::model::UpstreamRepository>) -> Self {
            self.inner = self.inner.upstreams(inp);
            self
        }
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_upstreams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
        ) -> Self {
            self.inner = self.inner.set_upstreams(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
