// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    EncryptionKeyError,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "ENCRYPTION_KEY_ERROR" => ValidationExceptionReason::EncryptionKeyError,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::EncryptionKeyError => "ENCRYPTION_KEY_ERROR",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "ENCRYPTION_KEY_ERROR",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Asset,
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    #[allow(missing_docs)] // documentation missing in model
    Package,
    #[allow(missing_docs)] // documentation missing in model
    PackageVersion,
    #[allow(missing_docs)] // documentation missing in model
    Repository,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "asset" => ResourceType::Asset,
            "domain" => ResourceType::Domain,
            "package" => ResourceType::Package,
            "package-version" => ResourceType::PackageVersion,
            "repository" => ResourceType::Repository,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Asset => "asset",
            ResourceType::Domain => "domain",
            ResourceType::Package => "package",
            ResourceType::PackageVersion => "package-version",
            ResourceType::Repository => "repository",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "asset",
            "domain",
            "package",
            "package-version",
            "repository",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The details of a repository stored in AWS CodeArtifact. A CodeArtifact repository contains a set of
/// package versions, each of which maps to a set of assets. Repositories are polyglot—a single
/// repository can contain packages of any supported type. Each repository exposes endpoints for
/// fetching and publishing packages using tools like the <code>npm</code> CLI, the Maven CLI
/// (<code>mvn</code>), and <code>pip</code>. You can create up to 100 repositories per AWS
/// account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryDescription {
    /// <p>
    /// The name of the repository.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The 12-digit account number of the AWS account that manages the repository. </p>
    pub administrator_account: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the domain that contains the repository.
    /// </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the repository. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>
    /// A text description of the repository.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
    /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
    /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    pub upstreams: std::option::Option<std::vec::Vec<crate::model::UpstreamRepositoryInfo>>,
    /// <p>
    /// An array of external connections associated with the repository.
    /// </p>
    pub external_connections:
        std::option::Option<std::vec::Vec<crate::model::RepositoryExternalConnectionInfo>>,
}
impl RepositoryDescription {
    /// <p>
    /// The name of the repository.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The 12-digit account number of the AWS account that manages the repository. </p>
    pub fn administrator_account(&self) -> std::option::Option<&str> {
        self.administrator_account.as_deref()
    }
    /// <p>
    /// The name of the domain that contains the repository.
    /// </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the repository. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>
    /// A text description of the repository.
    /// </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
    /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
    /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    pub fn upstreams(&self) -> std::option::Option<&[crate::model::UpstreamRepositoryInfo]> {
        self.upstreams.as_deref()
    }
    /// <p>
    /// An array of external connections associated with the repository.
    /// </p>
    pub fn external_connections(
        &self,
    ) -> std::option::Option<&[crate::model::RepositoryExternalConnectionInfo]> {
        self.external_connections.as_deref()
    }
}
impl std::fmt::Debug for RepositoryDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryDescription");
        formatter.field("name", &self.name);
        formatter.field("administrator_account", &self.administrator_account);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.field("upstreams", &self.upstreams);
        formatter.field("external_connections", &self.external_connections);
        formatter.finish()
    }
}
/// See [`RepositoryDescription`](crate::model::RepositoryDescription)
pub mod repository_description {
    /// A builder for [`RepositoryDescription`](crate::model::RepositoryDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) administrator_account: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) upstreams:
            std::option::Option<std::vec::Vec<crate::model::UpstreamRepositoryInfo>>,
        pub(crate) external_connections:
            std::option::Option<std::vec::Vec<crate::model::RepositoryExternalConnectionInfo>>,
    }
    impl Builder {
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The 12-digit account number of the AWS account that manages the repository. </p>
        pub fn administrator_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.administrator_account = Some(input.into());
            self
        }
        /// <p> The 12-digit account number of the AWS account that manages the repository. </p>
        pub fn set_administrator_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administrator_account = input;
            self
        }
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the repository. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the repository. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>
        /// A text description of the repository.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// A text description of the repository.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `upstreams`.
        ///
        /// To override the contents of this collection use [`set_upstreams`](Self::set_upstreams).
        ///
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn upstreams(mut self, input: impl Into<crate::model::UpstreamRepositoryInfo>) -> Self {
            let mut v = self.upstreams.unwrap_or_default();
            v.push(input.into());
            self.upstreams = Some(v);
            self
        }
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_upstreams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpstreamRepositoryInfo>>,
        ) -> Self {
            self.upstreams = input;
            self
        }
        /// Appends an item to `external_connections`.
        ///
        /// To override the contents of this collection use [`set_external_connections`](Self::set_external_connections).
        ///
        /// <p>
        /// An array of external connections associated with the repository.
        /// </p>
        pub fn external_connections(
            mut self,
            input: impl Into<crate::model::RepositoryExternalConnectionInfo>,
        ) -> Self {
            let mut v = self.external_connections.unwrap_or_default();
            v.push(input.into());
            self.external_connections = Some(v);
            self
        }
        /// <p>
        /// An array of external connections associated with the repository.
        /// </p>
        pub fn set_external_connections(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::RepositoryExternalConnectionInfo>,
            >,
        ) -> Self {
            self.external_connections = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryDescription`](crate::model::RepositoryDescription)
        pub fn build(self) -> crate::model::RepositoryDescription {
            crate::model::RepositoryDescription {
                name: self.name,
                administrator_account: self.administrator_account,
                domain_name: self.domain_name,
                domain_owner: self.domain_owner,
                arn: self.arn,
                description: self.description,
                upstreams: self.upstreams,
                external_connections: self.external_connections,
            }
        }
    }
}
impl RepositoryDescription {
    /// Creates a new builder-style object to manufacture [`RepositoryDescription`](crate::model::RepositoryDescription)
    pub fn builder() -> crate::model::repository_description::Builder {
        crate::model::repository_description::Builder::default()
    }
}

/// <p>
/// Contains information about the external connection of a repository.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositoryExternalConnectionInfo {
    /// <p> The name of the external connection associated with a repository. </p>
    pub external_connection_name: std::option::Option<std::string::String>,
    /// <p>
    /// The package format associated with a repository's external connection. The valid package formats are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub package_format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The status of the external connection of a repository. There is one valid value, <code>Available</code>.
    /// </p>
    pub status: std::option::Option<crate::model::ExternalConnectionStatus>,
}
impl RepositoryExternalConnectionInfo {
    /// <p> The name of the external connection associated with a repository. </p>
    pub fn external_connection_name(&self) -> std::option::Option<&str> {
        self.external_connection_name.as_deref()
    }
    /// <p>
    /// The package format associated with a repository's external connection. The valid package formats are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub fn package_format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.package_format.as_ref()
    }
    /// <p>
    /// The status of the external connection of a repository. There is one valid value, <code>Available</code>.
    /// </p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExternalConnectionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for RepositoryExternalConnectionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositoryExternalConnectionInfo");
        formatter.field("external_connection_name", &self.external_connection_name);
        formatter.field("package_format", &self.package_format);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`RepositoryExternalConnectionInfo`](crate::model::RepositoryExternalConnectionInfo)
pub mod repository_external_connection_info {
    /// A builder for [`RepositoryExternalConnectionInfo`](crate::model::RepositoryExternalConnectionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external_connection_name: std::option::Option<std::string::String>,
        pub(crate) package_format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) status: std::option::Option<crate::model::ExternalConnectionStatus>,
    }
    impl Builder {
        /// <p> The name of the external connection associated with a repository. </p>
        pub fn external_connection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_connection_name = Some(input.into());
            self
        }
        /// <p> The name of the external connection associated with a repository. </p>
        pub fn set_external_connection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_connection_name = input;
            self
        }
        /// <p>
        /// The package format associated with a repository's external connection. The valid package formats are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn package_format(mut self, input: crate::model::PackageFormat) -> Self {
            self.package_format = Some(input);
            self
        }
        /// <p>
        /// The package format associated with a repository's external connection. The valid package formats are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_package_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.package_format = input;
            self
        }
        /// <p>
        /// The status of the external connection of a repository. There is one valid value, <code>Available</code>.
        /// </p>
        pub fn status(mut self, input: crate::model::ExternalConnectionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of the external connection of a repository. There is one valid value, <code>Available</code>.
        /// </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExternalConnectionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositoryExternalConnectionInfo`](crate::model::RepositoryExternalConnectionInfo)
        pub fn build(self) -> crate::model::RepositoryExternalConnectionInfo {
            crate::model::RepositoryExternalConnectionInfo {
                external_connection_name: self.external_connection_name,
                package_format: self.package_format,
                status: self.status,
            }
        }
    }
}
impl RepositoryExternalConnectionInfo {
    /// Creates a new builder-style object to manufacture [`RepositoryExternalConnectionInfo`](crate::model::RepositoryExternalConnectionInfo)
    pub fn builder() -> crate::model::repository_external_connection_info::Builder {
        crate::model::repository_external_connection_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExternalConnectionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExternalConnectionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Available" => ExternalConnectionStatus::Available,
            other => ExternalConnectionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExternalConnectionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExternalConnectionStatus::from(s))
    }
}
impl ExternalConnectionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExternalConnectionStatus::Available => "Available",
            ExternalConnectionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Available"]
    }
}
impl AsRef<str> for ExternalConnectionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageFormat {
    #[allow(missing_docs)] // documentation missing in model
    Maven,
    #[allow(missing_docs)] // documentation missing in model
    Npm,
    #[allow(missing_docs)] // documentation missing in model
    Nuget,
    #[allow(missing_docs)] // documentation missing in model
    Pypi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageFormat {
    fn from(s: &str) -> Self {
        match s {
            "maven" => PackageFormat::Maven,
            "npm" => PackageFormat::Npm,
            "nuget" => PackageFormat::Nuget,
            "pypi" => PackageFormat::Pypi,
            other => PackageFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageFormat::from(s))
    }
}
impl PackageFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageFormat::Maven => "maven",
            PackageFormat::Npm => "npm",
            PackageFormat::Nuget => "nuget",
            PackageFormat::Pypi => "pypi",
            PackageFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["maven", "npm", "nuget", "pypi"]
    }
}
impl AsRef<str> for PackageFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Information about an upstream repository.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpstreamRepositoryInfo {
    /// <p> The name of an upstream repository. </p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl UpstreamRepositoryInfo {
    /// <p> The name of an upstream repository. </p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for UpstreamRepositoryInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpstreamRepositoryInfo");
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}
/// See [`UpstreamRepositoryInfo`](crate::model::UpstreamRepositoryInfo)
pub mod upstream_repository_info {
    /// A builder for [`UpstreamRepositoryInfo`](crate::model::UpstreamRepositoryInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of an upstream repository. </p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p> The name of an upstream repository. </p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpstreamRepositoryInfo`](crate::model::UpstreamRepositoryInfo)
        pub fn build(self) -> crate::model::UpstreamRepositoryInfo {
            crate::model::UpstreamRepositoryInfo {
                repository_name: self.repository_name,
            }
        }
    }
}
impl UpstreamRepositoryInfo {
    /// Creates a new builder-style object to manufacture [`UpstreamRepositoryInfo`](crate::model::UpstreamRepositoryInfo)
    pub fn builder() -> crate::model::upstream_repository_info::Builder {
        crate::model::upstream_repository_info::Builder::default()
    }
}

/// <p>
/// Information about an upstream repository. A list of <code>UpstreamRepository</code> objects is an input parameter to
/// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_CreateRepository.html">CreateRepository</a>
/// and <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdateRepository.html">UpdateRepository</a>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpstreamRepository {
    /// <p> The name of an upstream repository. </p>
    pub repository_name: std::option::Option<std::string::String>,
}
impl UpstreamRepository {
    /// <p> The name of an upstream repository. </p>
    pub fn repository_name(&self) -> std::option::Option<&str> {
        self.repository_name.as_deref()
    }
}
impl std::fmt::Debug for UpstreamRepository {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpstreamRepository");
        formatter.field("repository_name", &self.repository_name);
        formatter.finish()
    }
}
/// See [`UpstreamRepository`](crate::model::UpstreamRepository)
pub mod upstream_repository {
    /// A builder for [`UpstreamRepository`](crate::model::UpstreamRepository)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of an upstream repository. </p>
        pub fn repository_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_name = Some(input.into());
            self
        }
        /// <p> The name of an upstream repository. </p>
        pub fn set_repository_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpstreamRepository`](crate::model::UpstreamRepository)
        pub fn build(self) -> crate::model::UpstreamRepository {
            crate::model::UpstreamRepository {
                repository_name: self.repository_name,
            }
        }
    }
}
impl UpstreamRepository {
    /// Creates a new builder-style object to manufacture [`UpstreamRepository`](crate::model::UpstreamRepository)
    pub fn builder() -> crate::model::upstream_repository::Builder {
        crate::model::upstream_repository::Builder::default()
    }
}

/// <p>
/// An error associated with package.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageVersionError {
    /// <p> The error code associated with the error. Valid error codes are: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub error_code: std::option::Option<crate::model::PackageVersionErrorCode>,
    /// <p>
    /// The error message associated with the error.
    /// </p>
    pub error_message: std::option::Option<std::string::String>,
}
impl PackageVersionError {
    /// <p> The error code associated with the error. Valid error codes are: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALREADY_EXISTS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_REVISION</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MISMATCHED_STATUS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_ALLOWED</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NOT_FOUND</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SKIPPED</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn error_code(&self) -> std::option::Option<&crate::model::PackageVersionErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>
    /// The error message associated with the error.
    /// </p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for PackageVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageVersionError");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PackageVersionError`](crate::model::PackageVersionError)
pub mod package_version_error {
    /// A builder for [`PackageVersionError`](crate::model::PackageVersionError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<crate::model::PackageVersionErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The error code associated with the error. Valid error codes are: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn error_code(mut self, input: crate::model::PackageVersionErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p> The error code associated with the error. Valid error codes are: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALREADY_EXISTS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_REVISION</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MISMATCHED_STATUS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_ALLOWED</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NOT_FOUND</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SKIPPED</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::PackageVersionErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>
        /// The error message associated with the error.
        /// </p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>
        /// The error message associated with the error.
        /// </p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageVersionError`](crate::model::PackageVersionError)
        pub fn build(self) -> crate::model::PackageVersionError {
            crate::model::PackageVersionError {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PackageVersionError {
    /// Creates a new builder-style object to manufacture [`PackageVersionError`](crate::model::PackageVersionError)
    pub fn builder() -> crate::model::package_version_error::Builder {
        crate::model::package_version_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageVersionErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AlreadyExists,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedRevision,
    #[allow(missing_docs)] // documentation missing in model
    MismatchedStatus,
    #[allow(missing_docs)] // documentation missing in model
    NotAllowed,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    Skipped,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageVersionErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ALREADY_EXISTS" => PackageVersionErrorCode::AlreadyExists,
            "MISMATCHED_REVISION" => PackageVersionErrorCode::MismatchedRevision,
            "MISMATCHED_STATUS" => PackageVersionErrorCode::MismatchedStatus,
            "NOT_ALLOWED" => PackageVersionErrorCode::NotAllowed,
            "NOT_FOUND" => PackageVersionErrorCode::NotFound,
            "SKIPPED" => PackageVersionErrorCode::Skipped,
            other => PackageVersionErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageVersionErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageVersionErrorCode::from(s))
    }
}
impl PackageVersionErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageVersionErrorCode::AlreadyExists => "ALREADY_EXISTS",
            PackageVersionErrorCode::MismatchedRevision => "MISMATCHED_REVISION",
            PackageVersionErrorCode::MismatchedStatus => "MISMATCHED_STATUS",
            PackageVersionErrorCode::NotAllowed => "NOT_ALLOWED",
            PackageVersionErrorCode::NotFound => "NOT_FOUND",
            PackageVersionErrorCode::Skipped => "SKIPPED",
            PackageVersionErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALREADY_EXISTS",
            "MISMATCHED_REVISION",
            "MISMATCHED_STATUS",
            "NOT_ALLOWED",
            "NOT_FOUND",
            "SKIPPED",
        ]
    }
}
impl AsRef<str> for PackageVersionErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Contains the revision and status of a package version.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SuccessfulPackageVersionInfo {
    /// <p>
    /// The revision of a package version.
    /// </p>
    pub revision: std::option::Option<std::string::String>,
    /// <p>
    /// The status of a package version. Valid statuses are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PackageVersionStatus>,
}
impl SuccessfulPackageVersionInfo {
    /// <p>
    /// The revision of a package version.
    /// </p>
    pub fn revision(&self) -> std::option::Option<&str> {
        self.revision.as_deref()
    }
    /// <p>
    /// The status of a package version. Valid statuses are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for SuccessfulPackageVersionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SuccessfulPackageVersionInfo");
        formatter.field("revision", &self.revision);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`SuccessfulPackageVersionInfo`](crate::model::SuccessfulPackageVersionInfo)
pub mod successful_package_version_info {
    /// A builder for [`SuccessfulPackageVersionInfo`](crate::model::SuccessfulPackageVersionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) revision: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PackageVersionStatus>,
    }
    impl Builder {
        /// <p>
        /// The revision of a package version.
        /// </p>
        pub fn revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision = Some(input.into());
            self
        }
        /// <p>
        /// The revision of a package version.
        /// </p>
        pub fn set_revision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision = input;
            self
        }
        /// <p>
        /// The status of a package version. Valid statuses are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// The status of a package version. Valid statuses are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`SuccessfulPackageVersionInfo`](crate::model::SuccessfulPackageVersionInfo)
        pub fn build(self) -> crate::model::SuccessfulPackageVersionInfo {
            crate::model::SuccessfulPackageVersionInfo {
                revision: self.revision,
                status: self.status,
            }
        }
    }
}
impl SuccessfulPackageVersionInfo {
    /// Creates a new builder-style object to manufacture [`SuccessfulPackageVersionInfo`](crate::model::SuccessfulPackageVersionInfo)
    pub fn builder() -> crate::model::successful_package_version_info::Builder {
        crate::model::successful_package_version_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Archived,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Disposed,
    #[allow(missing_docs)] // documentation missing in model
    Published,
    #[allow(missing_docs)] // documentation missing in model
    Unfinished,
    #[allow(missing_docs)] // documentation missing in model
    Unlisted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "Archived" => PackageVersionStatus::Archived,
            "Deleted" => PackageVersionStatus::Deleted,
            "Disposed" => PackageVersionStatus::Disposed,
            "Published" => PackageVersionStatus::Published,
            "Unfinished" => PackageVersionStatus::Unfinished,
            "Unlisted" => PackageVersionStatus::Unlisted,
            other => PackageVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageVersionStatus::from(s))
    }
}
impl PackageVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageVersionStatus::Archived => "Archived",
            PackageVersionStatus::Deleted => "Deleted",
            PackageVersionStatus::Disposed => "Disposed",
            PackageVersionStatus::Published => "Published",
            PackageVersionStatus::Unfinished => "Unfinished",
            PackageVersionStatus::Unlisted => "Unlisted",
            PackageVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Archived",
            "Deleted",
            "Disposed",
            "Published",
            "Unfinished",
            "Unlisted",
        ]
    }
}
impl AsRef<str> for PackageVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A tag is a key-value pair that can be used to manage, search for, or filter resources in AWS CodeArtifact.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The tag key.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The tag key.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag key.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The tag key.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>
/// An AWS CodeArtifact resource policy that contains a resource ARN, document details, and a revision.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePolicy {
    /// <p>
    /// The ARN of the resource associated with the resource policy
    /// </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The current revision of the resource policy.
    /// </p>
    pub revision: std::option::Option<std::string::String>,
    /// <p>
    /// The resource policy formatted in JSON.
    /// </p>
    pub document: std::option::Option<std::string::String>,
}
impl ResourcePolicy {
    /// <p>
    /// The ARN of the resource associated with the resource policy
    /// </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>
    /// The current revision of the resource policy.
    /// </p>
    pub fn revision(&self) -> std::option::Option<&str> {
        self.revision.as_deref()
    }
    /// <p>
    /// The resource policy formatted in JSON.
    /// </p>
    pub fn document(&self) -> std::option::Option<&str> {
        self.document.as_deref()
    }
}
impl std::fmt::Debug for ResourcePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePolicy");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("revision", &self.revision);
        formatter.field("document", &self.document);
        formatter.finish()
    }
}
/// See [`ResourcePolicy`](crate::model::ResourcePolicy)
pub mod resource_policy {
    /// A builder for [`ResourcePolicy`](crate::model::ResourcePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<std::string::String>,
        pub(crate) document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The ARN of the resource associated with the resource policy
        /// </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>
        /// The ARN of the resource associated with the resource policy
        /// </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>
        /// The current revision of the resource policy.
        /// </p>
        pub fn revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision = Some(input.into());
            self
        }
        /// <p>
        /// The current revision of the resource policy.
        /// </p>
        pub fn set_revision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision = input;
            self
        }
        /// <p>
        /// The resource policy formatted in JSON.
        /// </p>
        pub fn document(mut self, input: impl Into<std::string::String>) -> Self {
            self.document = Some(input.into());
            self
        }
        /// <p>
        /// The resource policy formatted in JSON.
        /// </p>
        pub fn set_document(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.document = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePolicy`](crate::model::ResourcePolicy)
        pub fn build(self) -> crate::model::ResourcePolicy {
            crate::model::ResourcePolicy {
                resource_arn: self.resource_arn,
                revision: self.revision,
                document: self.document,
            }
        }
    }
}
impl ResourcePolicy {
    /// Creates a new builder-style object to manufacture [`ResourcePolicy`](crate::model::ResourcePolicy)
    pub fn builder() -> crate::model::resource_policy::Builder {
        crate::model::resource_policy::Builder::default()
    }
}

/// <p> Details about a repository, including its Amazon Resource Name (ARN), description, and
/// domain information. The <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListRepositories.html">ListRepositories</a> operation returns a list of
/// <code>RepositorySummary</code> objects. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RepositorySummary {
    /// <p>
    /// The name of the repository.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The AWS account ID that manages the repository.
    /// </p>
    pub administrator_account: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the domain that contains the repository.
    /// </p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p> The ARN of the repository. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>
    /// The description of the repository.
    /// </p>
    pub description: std::option::Option<std::string::String>,
}
impl RepositorySummary {
    /// <p>
    /// The name of the repository.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// The AWS account ID that manages the repository.
    /// </p>
    pub fn administrator_account(&self) -> std::option::Option<&str> {
        self.administrator_account.as_deref()
    }
    /// <p>
    /// The name of the domain that contains the repository.
    /// </p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p> The ARN of the repository. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>
    /// The description of the repository.
    /// </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for RepositorySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RepositorySummary");
        formatter.field("name", &self.name);
        formatter.field("administrator_account", &self.administrator_account);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("arn", &self.arn);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`RepositorySummary`](crate::model::RepositorySummary)
pub mod repository_summary {
    /// A builder for [`RepositorySummary`](crate::model::RepositorySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) administrator_account: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The AWS account ID that manages the repository.
        /// </p>
        pub fn administrator_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.administrator_account = Some(input.into());
            self
        }
        /// <p>
        /// The AWS account ID that manages the repository.
        /// </p>
        pub fn set_administrator_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administrator_account = input;
            self
        }
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p> The ARN of the repository. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The ARN of the repository. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>
        /// The description of the repository.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// The description of the repository.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`RepositorySummary`](crate::model::RepositorySummary)
        pub fn build(self) -> crate::model::RepositorySummary {
            crate::model::RepositorySummary {
                name: self.name,
                administrator_account: self.administrator_account,
                domain_name: self.domain_name,
                domain_owner: self.domain_owner,
                arn: self.arn,
                description: self.description,
            }
        }
    }
}
impl RepositorySummary {
    /// Creates a new builder-style object to manufacture [`RepositorySummary`](crate::model::RepositorySummary)
    pub fn builder() -> crate::model::repository_summary::Builder {
        crate::model::repository_summary::Builder::default()
    }
}

/// <p>
/// Details about a package version, including its status, version, and revision. The
/// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html">ListPackageVersions</a>
/// operation returns a list of <code>PackageVersionSummary</code> objects.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageVersionSummary {
    /// <p>
    /// Information about a package version.
    /// </p>
    pub version: std::option::Option<std::string::String>,
    /// <p>
    /// The revision associated with a package version.
    /// </p>
    pub revision: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the status of the package version. It can be one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PackageVersionStatus>,
}
impl PackageVersionSummary {
    /// <p>
    /// Information about a package version.
    /// </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>
    /// The revision associated with a package version.
    /// </p>
    pub fn revision(&self) -> std::option::Option<&str> {
        self.revision.as_deref()
    }
    /// <p>
    /// A string that contains the status of the package version. It can be one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PackageVersionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageVersionSummary");
        formatter.field("version", &self.version);
        formatter.field("revision", &self.revision);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PackageVersionSummary`](crate::model::PackageVersionSummary)
pub mod package_version_summary {
    /// A builder for [`PackageVersionSummary`](crate::model::PackageVersionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) revision: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PackageVersionStatus>,
    }
    impl Builder {
        /// <p>
        /// Information about a package version.
        /// </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>
        /// Information about a package version.
        /// </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>
        /// The revision associated with a package version.
        /// </p>
        pub fn revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision = Some(input.into());
            self
        }
        /// <p>
        /// The revision associated with a package version.
        /// </p>
        pub fn set_revision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision = input;
            self
        }
        /// <p>
        /// A string that contains the status of the package version. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// A string that contains the status of the package version. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageVersionSummary`](crate::model::PackageVersionSummary)
        pub fn build(self) -> crate::model::PackageVersionSummary {
            crate::model::PackageVersionSummary {
                version: self.version,
                revision: self.revision,
                status: self.status,
            }
        }
    }
}
impl PackageVersionSummary {
    /// Creates a new builder-style object to manufacture [`PackageVersionSummary`](crate::model::PackageVersionSummary)
    pub fn builder() -> crate::model::package_version_summary::Builder {
        crate::model::package_version_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PackageVersionSortType {
    #[allow(missing_docs)] // documentation missing in model
    PublishedTime,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PackageVersionSortType {
    fn from(s: &str) -> Self {
        match s {
            "PUBLISHED_TIME" => PackageVersionSortType::PublishedTime,
            other => PackageVersionSortType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PackageVersionSortType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PackageVersionSortType::from(s))
    }
}
impl PackageVersionSortType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PackageVersionSortType::PublishedTime => "PUBLISHED_TIME",
            PackageVersionSortType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PUBLISHED_TIME"]
    }
}
impl AsRef<str> for PackageVersionSortType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Details about a package dependency.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageDependency {
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that this package depends on.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p> The type of a package dependency. The possible values depend on the package type.
    /// Example types are <code>compile</code>, <code>runtime</code>, and <code>test</code> for Maven
    /// packages, and <code>dev</code>, <code>prod</code>, and <code>optional</code> for npm packages. </p>
    pub dependency_type: std::option::Option<std::string::String>,
    /// <p>
    /// The required version, or version range, of the package that this package depends on. The version format
    /// is specific to the package type. For example, the following are possible valid required versions: <code>1.2.3</code>,
    /// <code>^2.3.4</code>, or <code>4.x</code>.
    /// </p>
    pub version_requirement: std::option::Option<std::string::String>,
}
impl PackageDependency {
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package that this package depends on.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p> The type of a package dependency. The possible values depend on the package type.
    /// Example types are <code>compile</code>, <code>runtime</code>, and <code>test</code> for Maven
    /// packages, and <code>dev</code>, <code>prod</code>, and <code>optional</code> for npm packages. </p>
    pub fn dependency_type(&self) -> std::option::Option<&str> {
        self.dependency_type.as_deref()
    }
    /// <p>
    /// The required version, or version range, of the package that this package depends on. The version format
    /// is specific to the package type. For example, the following are possible valid required versions: <code>1.2.3</code>,
    /// <code>^2.3.4</code>, or <code>4.x</code>.
    /// </p>
    pub fn version_requirement(&self) -> std::option::Option<&str> {
        self.version_requirement.as_deref()
    }
}
impl std::fmt::Debug for PackageDependency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageDependency");
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("dependency_type", &self.dependency_type);
        formatter.field("version_requirement", &self.version_requirement);
        formatter.finish()
    }
}
/// See [`PackageDependency`](crate::model::PackageDependency)
pub mod package_dependency {
    /// A builder for [`PackageDependency`](crate::model::PackageDependency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) dependency_type: std::option::Option<std::string::String>,
        pub(crate) version_requirement: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package that this package depends on.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that this package depends on.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p> The type of a package dependency. The possible values depend on the package type.
        /// Example types are <code>compile</code>, <code>runtime</code>, and <code>test</code> for Maven
        /// packages, and <code>dev</code>, <code>prod</code>, and <code>optional</code> for npm packages. </p>
        pub fn dependency_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dependency_type = Some(input.into());
            self
        }
        /// <p> The type of a package dependency. The possible values depend on the package type.
        /// Example types are <code>compile</code>, <code>runtime</code>, and <code>test</code> for Maven
        /// packages, and <code>dev</code>, <code>prod</code>, and <code>optional</code> for npm packages. </p>
        pub fn set_dependency_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dependency_type = input;
            self
        }
        /// <p>
        /// The required version, or version range, of the package that this package depends on. The version format
        /// is specific to the package type. For example, the following are possible valid required versions: <code>1.2.3</code>,
        /// <code>^2.3.4</code>, or <code>4.x</code>.
        /// </p>
        pub fn version_requirement(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_requirement = Some(input.into());
            self
        }
        /// <p>
        /// The required version, or version range, of the package that this package depends on. The version format
        /// is specific to the package type. For example, the following are possible valid required versions: <code>1.2.3</code>,
        /// <code>^2.3.4</code>, or <code>4.x</code>.
        /// </p>
        pub fn set_version_requirement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.version_requirement = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageDependency`](crate::model::PackageDependency)
        pub fn build(self) -> crate::model::PackageDependency {
            crate::model::PackageDependency {
                namespace: self.namespace,
                package: self.package,
                dependency_type: self.dependency_type,
                version_requirement: self.version_requirement,
            }
        }
    }
}
impl PackageDependency {
    /// Creates a new builder-style object to manufacture [`PackageDependency`](crate::model::PackageDependency)
    pub fn builder() -> crate::model::package_dependency::Builder {
        crate::model::package_dependency::Builder::default()
    }
}

/// <p>
/// Contains details about a package version asset.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssetSummary {
    /// <p>
    /// The name of the asset.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The size of the asset.
    /// </p>
    pub size: std::option::Option<i64>,
    /// <p>
    /// The hashes of the asset.
    /// </p>
    pub hashes: std::option::Option<
        std::collections::HashMap<crate::model::HashAlgorithm, std::string::String>,
    >,
}
impl AssetSummary {
    /// <p>
    /// The name of the asset.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// The size of the asset.
    /// </p>
    pub fn size(&self) -> std::option::Option<i64> {
        self.size
    }
    /// <p>
    /// The hashes of the asset.
    /// </p>
    pub fn hashes(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<crate::model::HashAlgorithm, std::string::String>,
    > {
        self.hashes.as_ref()
    }
}
impl std::fmt::Debug for AssetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssetSummary");
        formatter.field("name", &self.name);
        formatter.field("size", &self.size);
        formatter.field("hashes", &self.hashes);
        formatter.finish()
    }
}
/// See [`AssetSummary`](crate::model::AssetSummary)
pub mod asset_summary {
    /// A builder for [`AssetSummary`](crate::model::AssetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) hashes: std::option::Option<
            std::collections::HashMap<crate::model::HashAlgorithm, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>
        /// The name of the asset.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the asset.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The size of the asset.
        /// </p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>
        /// The size of the asset.
        /// </p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// Adds a key-value pair to `hashes`.
        ///
        /// To override the contents of this collection use [`set_hashes`](Self::set_hashes).
        ///
        /// <p>
        /// The hashes of the asset.
        /// </p>
        pub fn hashes(
            mut self,
            k: impl Into<crate::model::HashAlgorithm>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.hashes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.hashes = Some(hash_map);
            self
        }
        /// <p>
        /// The hashes of the asset.
        /// </p>
        pub fn set_hashes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<crate::model::HashAlgorithm, std::string::String>,
            >,
        ) -> Self {
            self.hashes = input;
            self
        }
        /// Consumes the builder and constructs a [`AssetSummary`](crate::model::AssetSummary)
        pub fn build(self) -> crate::model::AssetSummary {
            crate::model::AssetSummary {
                name: self.name,
                size: self.size,
                hashes: self.hashes,
            }
        }
    }
}
impl AssetSummary {
    /// Creates a new builder-style object to manufacture [`AssetSummary`](crate::model::AssetSummary)
    pub fn builder() -> crate::model::asset_summary::Builder {
        crate::model::asset_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HashAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Md5,
    #[allow(missing_docs)] // documentation missing in model
    Sha1,
    #[allow(missing_docs)] // documentation missing in model
    Sha256,
    #[allow(missing_docs)] // documentation missing in model
    Sha512,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HashAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "MD5" => HashAlgorithm::Md5,
            "SHA-1" => HashAlgorithm::Sha1,
            "SHA-256" => HashAlgorithm::Sha256,
            "SHA-512" => HashAlgorithm::Sha512,
            other => HashAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HashAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HashAlgorithm::from(s))
    }
}
impl HashAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HashAlgorithm::Md5 => "MD5",
            HashAlgorithm::Sha1 => "SHA-1",
            HashAlgorithm::Sha256 => "SHA-256",
            HashAlgorithm::Sha512 => "SHA-512",
            HashAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MD5", "SHA-1", "SHA-256", "SHA-512"]
    }
}
impl AsRef<str> for HashAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Details about a package, including its format, namespace, and name. The
/// <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackages.html">ListPackages</a>
/// operation returns a list of <code>PackageSummary</code> objects.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageSummary {
    /// <p>
    /// The format of the package. Valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package.
    /// </p>
    pub package: std::option::Option<std::string::String>,
}
impl PackageSummary {
    /// <p>
    /// The format of the package. Valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
}
impl std::fmt::Debug for PackageSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageSummary");
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.finish()
    }
}
/// See [`PackageSummary`](crate::model::PackageSummary)
pub mod package_summary {
    /// A builder for [`PackageSummary`](crate::model::PackageSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The format of the package. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageSummary`](crate::model::PackageSummary)
        pub fn build(self) -> crate::model::PackageSummary {
            crate::model::PackageSummary {
                format: self.format,
                namespace: self.namespace,
                package: self.package,
            }
        }
    }
}
impl PackageSummary {
    /// Creates a new builder-style object to manufacture [`PackageSummary`](crate::model::PackageSummary)
    pub fn builder() -> crate::model::package_summary::Builder {
        crate::model::package_summary::Builder::default()
    }
}

/// <p> Information about a domain, including its name, Amazon Resource Name (ARN), and status.
/// The <a href="https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListDomains.html">ListDomains</a> operation returns a list of <code>DomainSummary</code>
/// objects. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainSummary {
    /// <p>
    /// The name of the domain.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub owner: std::option::Option<std::string::String>,
    /// <p>
    /// The ARN of the domain.
    /// </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the status of the domain. The valid values are:      
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Active</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleted</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DomainStatus>,
    /// <p>
    /// A timestamp that contains the date and time the domain was created.
    /// </p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The key used to encrypt the domain.
    /// </p>
    pub encryption_key: std::option::Option<std::string::String>,
}
impl DomainSummary {
    /// <p>
    /// The name of the domain.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p>
    /// The ARN of the domain.
    /// </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>
    /// A string that contains the status of the domain. The valid values are:      
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Active</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleted</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::DomainStatus> {
        self.status.as_ref()
    }
    /// <p>
    /// A timestamp that contains the date and time the domain was created.
    /// </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p>
    /// The key used to encrypt the domain.
    /// </p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
}
impl std::fmt::Debug for DomainSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainSummary");
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.finish()
    }
}
/// See [`DomainSummary`](crate::model::DomainSummary)
pub mod domain_summary {
    /// A builder for [`DomainSummary`](crate::model::DomainSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DomainStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p>
        /// The ARN of the domain.
        /// </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>
        /// The ARN of the domain.
        /// </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>
        /// A string that contains the status of the domain. The valid values are:      
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Active</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleted</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DomainStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// A string that contains the status of the domain. The valid values are:      
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Active</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleted</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// A timestamp that contains the date and time the domain was created.
        /// </p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>
        /// A timestamp that contains the date and time the domain was created.
        /// </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p>
        /// The key used to encrypt the domain.
        /// </p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>
        /// The key used to encrypt the domain.
        /// </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainSummary`](crate::model::DomainSummary)
        pub fn build(self) -> crate::model::DomainSummary {
            crate::model::DomainSummary {
                name: self.name,
                owner: self.owner,
                arn: self.arn,
                status: self.status,
                created_time: self.created_time,
                encryption_key: self.encryption_key,
            }
        }
    }
}
impl DomainSummary {
    /// Creates a new builder-style object to manufacture [`DomainSummary`](crate::model::DomainSummary)
    pub fn builder() -> crate::model::domain_summary::Builder {
        crate::model::domain_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DomainStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DomainStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => DomainStatus::Active,
            "Deleted" => DomainStatus::Deleted,
            other => DomainStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DomainStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DomainStatus::from(s))
    }
}
impl DomainStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DomainStatus::Active => "Active",
            DomainStatus::Deleted => "Deleted",
            DomainStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Deleted"]
    }
}
impl AsRef<str> for DomainStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>
/// Details about a package version.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PackageVersionDescription {
    /// <p>
    /// The format of the package version. The valid package formats are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the requested package.
    /// </p>
    pub package_name: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that is displayed. The <code>displayName</code> varies depending
    /// on the package version's format. For example, if an npm package is named <code>ui</code>,
    /// is in the namespace <code>vue</code>, and has the format <code>npm</code>, then
    /// the <code>displayName</code> is <code>@vue/ui</code>.
    /// </p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>
    /// The version of the package.
    /// </p>
    pub version: std::option::Option<std::string::String>,
    /// <p>
    /// A summary of the package version. The summary is extracted from the package. The information in and
    /// detail level of the summary depends on the package version's format.
    /// </p>
    pub summary: std::option::Option<std::string::String>,
    /// <p>
    /// The homepage associated with the package.
    /// </p>
    pub home_page: std::option::Option<std::string::String>,
    /// <p>
    /// The repository for the source code in the package version, or the source code used to build it.
    /// </p>
    pub source_code_repository: std::option::Option<std::string::String>,
    /// <p>
    /// A timestamp that contains the date and time the package version was published.
    /// </p>
    pub published_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// Information about licenses associated with the package version.
    /// </p>
    pub licenses: std::option::Option<std::vec::Vec<crate::model::LicenseInfo>>,
    /// <p>
    /// The revision of the package version.
    /// </p>
    pub revision: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the status of the package version. It can be one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PackageVersionStatus>,
}
impl PackageVersionDescription {
    /// <p>
    /// The format of the package version. The valid package formats are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the requested package.
    /// </p>
    pub fn package_name(&self) -> std::option::Option<&str> {
        self.package_name.as_deref()
    }
    /// <p>
    /// The name of the package that is displayed. The <code>displayName</code> varies depending
    /// on the package version's format. For example, if an npm package is named <code>ui</code>,
    /// is in the namespace <code>vue</code>, and has the format <code>npm</code>, then
    /// the <code>displayName</code> is <code>@vue/ui</code>.
    /// </p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>
    /// The version of the package.
    /// </p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>
    /// A summary of the package version. The summary is extracted from the package. The information in and
    /// detail level of the summary depends on the package version's format.
    /// </p>
    pub fn summary(&self) -> std::option::Option<&str> {
        self.summary.as_deref()
    }
    /// <p>
    /// The homepage associated with the package.
    /// </p>
    pub fn home_page(&self) -> std::option::Option<&str> {
        self.home_page.as_deref()
    }
    /// <p>
    /// The repository for the source code in the package version, or the source code used to build it.
    /// </p>
    pub fn source_code_repository(&self) -> std::option::Option<&str> {
        self.source_code_repository.as_deref()
    }
    /// <p>
    /// A timestamp that contains the date and time the package version was published.
    /// </p>
    pub fn published_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.published_time.as_ref()
    }
    /// <p>
    /// Information about licenses associated with the package version.
    /// </p>
    pub fn licenses(&self) -> std::option::Option<&[crate::model::LicenseInfo]> {
        self.licenses.as_deref()
    }
    /// <p>
    /// The revision of the package version.
    /// </p>
    pub fn revision(&self) -> std::option::Option<&str> {
        self.revision.as_deref()
    }
    /// <p>
    /// A string that contains the status of the package version. It can be one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for PackageVersionDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PackageVersionDescription");
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package_name", &self.package_name);
        formatter.field("display_name", &self.display_name);
        formatter.field("version", &self.version);
        formatter.field("summary", &self.summary);
        formatter.field("home_page", &self.home_page);
        formatter.field("source_code_repository", &self.source_code_repository);
        formatter.field("published_time", &self.published_time);
        formatter.field("licenses", &self.licenses);
        formatter.field("revision", &self.revision);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`PackageVersionDescription`](crate::model::PackageVersionDescription)
pub mod package_version_description {
    /// A builder for [`PackageVersionDescription`](crate::model::PackageVersionDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package_name: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) summary: std::option::Option<std::string::String>,
        pub(crate) home_page: std::option::Option<std::string::String>,
        pub(crate) source_code_repository: std::option::Option<std::string::String>,
        pub(crate) published_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) licenses: std::option::Option<std::vec::Vec<crate::model::LicenseInfo>>,
        pub(crate) revision: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PackageVersionStatus>,
    }
    impl Builder {
        /// <p>
        /// The format of the package version. The valid package formats are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package version. The valid package formats are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the requested package.
        /// </p>
        pub fn package_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the requested package.
        /// </p>
        pub fn set_package_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package_name = input;
            self
        }
        /// <p>
        /// The name of the package that is displayed. The <code>displayName</code> varies depending
        /// on the package version's format. For example, if an npm package is named <code>ui</code>,
        /// is in the namespace <code>vue</code>, and has the format <code>npm</code>, then
        /// the <code>displayName</code> is <code>@vue/ui</code>.
        /// </p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that is displayed. The <code>displayName</code> varies depending
        /// on the package version's format. For example, if an npm package is named <code>ui</code>,
        /// is in the namespace <code>vue</code>, and has the format <code>npm</code>, then
        /// the <code>displayName</code> is <code>@vue/ui</code>.
        /// </p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>
        /// The version of the package.
        /// </p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>
        /// The version of the package.
        /// </p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>
        /// A summary of the package version. The summary is extracted from the package. The information in and
        /// detail level of the summary depends on the package version's format.
        /// </p>
        pub fn summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.summary = Some(input.into());
            self
        }
        /// <p>
        /// A summary of the package version. The summary is extracted from the package. The information in and
        /// detail level of the summary depends on the package version's format.
        /// </p>
        pub fn set_summary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.summary = input;
            self
        }
        /// <p>
        /// The homepage associated with the package.
        /// </p>
        pub fn home_page(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_page = Some(input.into());
            self
        }
        /// <p>
        /// The homepage associated with the package.
        /// </p>
        pub fn set_home_page(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_page = input;
            self
        }
        /// <p>
        /// The repository for the source code in the package version, or the source code used to build it.
        /// </p>
        pub fn source_code_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_code_repository = Some(input.into());
            self
        }
        /// <p>
        /// The repository for the source code in the package version, or the source code used to build it.
        /// </p>
        pub fn set_source_code_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_code_repository = input;
            self
        }
        /// <p>
        /// A timestamp that contains the date and time the package version was published.
        /// </p>
        pub fn published_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.published_time = Some(input);
            self
        }
        /// <p>
        /// A timestamp that contains the date and time the package version was published.
        /// </p>
        pub fn set_published_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.published_time = input;
            self
        }
        /// Appends an item to `licenses`.
        ///
        /// To override the contents of this collection use [`set_licenses`](Self::set_licenses).
        ///
        /// <p>
        /// Information about licenses associated with the package version.
        /// </p>
        pub fn licenses(mut self, input: impl Into<crate::model::LicenseInfo>) -> Self {
            let mut v = self.licenses.unwrap_or_default();
            v.push(input.into());
            self.licenses = Some(v);
            self
        }
        /// <p>
        /// Information about licenses associated with the package version.
        /// </p>
        pub fn set_licenses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseInfo>>,
        ) -> Self {
            self.licenses = input;
            self
        }
        /// <p>
        /// The revision of the package version.
        /// </p>
        pub fn revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.revision = Some(input.into());
            self
        }
        /// <p>
        /// The revision of the package version.
        /// </p>
        pub fn set_revision(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.revision = input;
            self
        }
        /// <p>
        /// A string that contains the status of the package version. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// A string that contains the status of the package version. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`PackageVersionDescription`](crate::model::PackageVersionDescription)
        pub fn build(self) -> crate::model::PackageVersionDescription {
            crate::model::PackageVersionDescription {
                format: self.format,
                namespace: self.namespace,
                package_name: self.package_name,
                display_name: self.display_name,
                version: self.version,
                summary: self.summary,
                home_page: self.home_page,
                source_code_repository: self.source_code_repository,
                published_time: self.published_time,
                licenses: self.licenses,
                revision: self.revision,
                status: self.status,
            }
        }
    }
}
impl PackageVersionDescription {
    /// Creates a new builder-style object to manufacture [`PackageVersionDescription`](crate::model::PackageVersionDescription)
    pub fn builder() -> crate::model::package_version_description::Builder {
        crate::model::package_version_description::Builder::default()
    }
}

/// <p>
/// Details of the license data.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseInfo {
    /// <p>
    /// Name of the license.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// The URL for license data.
    /// </p>
    pub url: std::option::Option<std::string::String>,
}
impl LicenseInfo {
    /// <p>
    /// Name of the license.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// The URL for license data.
    /// </p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
}
impl std::fmt::Debug for LicenseInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseInfo");
        formatter.field("name", &self.name);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`LicenseInfo`](crate::model::LicenseInfo)
pub mod license_info {
    /// A builder for [`LicenseInfo`](crate::model::LicenseInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// Name of the license.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// Name of the license.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>
        /// The URL for license data.
        /// </p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>
        /// The URL for license data.
        /// </p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseInfo`](crate::model::LicenseInfo)
        pub fn build(self) -> crate::model::LicenseInfo {
            crate::model::LicenseInfo {
                name: self.name,
                url: self.url,
            }
        }
    }
}
impl LicenseInfo {
    /// Creates a new builder-style object to manufacture [`LicenseInfo`](crate::model::LicenseInfo)
    pub fn builder() -> crate::model::license_info::Builder {
        crate::model::license_info::Builder::default()
    }
}

/// <p>
/// Information about a domain. A domain is a container for repositories. When you create a domain, it is empty until you
/// add one or more repositories.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainDescription {
    /// <p>
    /// The name of the domain.
    /// </p>
    pub name: std::option::Option<std::string::String>,
    /// <p> The AWS account ID that owns the domain. </p>
    pub owner: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the domain. </p>
    pub arn: std::option::Option<std::string::String>,
    /// <p> The current status of a domain. The valid values are </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Active</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleted</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::DomainStatus>,
    /// <p>
    /// A timestamp that represents the date and time the domain was created.
    /// </p>
    pub created_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p> The ARN of an AWS Key Management Service (AWS KMS) key associated with a domain. </p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>
    /// The number of repositories in the domain.
    /// </p>
    pub repository_count: i32,
    /// <p>
    /// The total size of all assets in the domain.
    /// </p>
    pub asset_size_bytes: i64,
    /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.</p>
    pub s3_bucket_arn: std::option::Option<std::string::String>,
}
impl DomainDescription {
    /// <p>
    /// The name of the domain.
    /// </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p> The AWS account ID that owns the domain. </p>
    pub fn owner(&self) -> std::option::Option<&str> {
        self.owner.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) of the domain. </p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p> The current status of a domain. The valid values are </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Active</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Deleted</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::DomainStatus> {
        self.status.as_ref()
    }
    /// <p>
    /// A timestamp that represents the date and time the domain was created.
    /// </p>
    pub fn created_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_time.as_ref()
    }
    /// <p> The ARN of an AWS Key Management Service (AWS KMS) key associated with a domain. </p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>
    /// The number of repositories in the domain.
    /// </p>
    pub fn repository_count(&self) -> i32 {
        self.repository_count
    }
    /// <p>
    /// The total size of all assets in the domain.
    /// </p>
    pub fn asset_size_bytes(&self) -> i64 {
        self.asset_size_bytes
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.</p>
    pub fn s3_bucket_arn(&self) -> std::option::Option<&str> {
        self.s3_bucket_arn.as_deref()
    }
}
impl std::fmt::Debug for DomainDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainDescription");
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("arn", &self.arn);
        formatter.field("status", &self.status);
        formatter.field("created_time", &self.created_time);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("repository_count", &self.repository_count);
        formatter.field("asset_size_bytes", &self.asset_size_bytes);
        formatter.field("s3_bucket_arn", &self.s3_bucket_arn);
        formatter.finish()
    }
}
/// See [`DomainDescription`](crate::model::DomainDescription)
pub mod domain_description {
    /// A builder for [`DomainDescription`](crate::model::DomainDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DomainStatus>,
        pub(crate) created_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) repository_count: std::option::Option<i32>,
        pub(crate) asset_size_bytes: std::option::Option<i64>,
        pub(crate) s3_bucket_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain.
        /// </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain.
        /// </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p> The AWS account ID that owns the domain. </p>
        pub fn owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner = Some(input.into());
            self
        }
        /// <p> The AWS account ID that owns the domain. </p>
        pub fn set_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the domain. </p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the domain. </p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p> The current status of a domain. The valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Active</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleted</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::DomainStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p> The current status of a domain. The valid values are </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Active</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Deleted</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DomainStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// A timestamp that represents the date and time the domain was created.
        /// </p>
        pub fn created_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_time = Some(input);
            self
        }
        /// <p>
        /// A timestamp that represents the date and time the domain was created.
        /// </p>
        pub fn set_created_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_time = input;
            self
        }
        /// <p> The ARN of an AWS Key Management Service (AWS KMS) key associated with a domain. </p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p> The ARN of an AWS Key Management Service (AWS KMS) key associated with a domain. </p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>
        /// The number of repositories in the domain.
        /// </p>
        pub fn repository_count(mut self, input: i32) -> Self {
            self.repository_count = Some(input);
            self
        }
        /// <p>
        /// The number of repositories in the domain.
        /// </p>
        pub fn set_repository_count(mut self, input: std::option::Option<i32>) -> Self {
            self.repository_count = input;
            self
        }
        /// <p>
        /// The total size of all assets in the domain.
        /// </p>
        pub fn asset_size_bytes(mut self, input: i64) -> Self {
            self.asset_size_bytes = Some(input);
            self
        }
        /// <p>
        /// The total size of all assets in the domain.
        /// </p>
        pub fn set_asset_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.asset_size_bytes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.</p>
        pub fn s3_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon S3 bucket that is used to store package assets in the domain.</p>
        pub fn set_s3_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainDescription`](crate::model::DomainDescription)
        pub fn build(self) -> crate::model::DomainDescription {
            crate::model::DomainDescription {
                name: self.name,
                owner: self.owner,
                arn: self.arn,
                status: self.status,
                created_time: self.created_time,
                encryption_key: self.encryption_key,
                repository_count: self.repository_count.unwrap_or_default(),
                asset_size_bytes: self.asset_size_bytes.unwrap_or_default(),
                s3_bucket_arn: self.s3_bucket_arn,
            }
        }
    }
}
impl DomainDescription {
    /// Creates a new builder-style object to manufacture [`DomainDescription`](crate::model::DomainDescription)
    pub fn builder() -> crate::model::domain_description::Builder {
        crate::model::domain_description::Builder::default()
    }
}
