// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateExternalConnectionInput`](crate::input::AssociateExternalConnectionInput)
pub mod associate_external_connection_input {
    /// A builder for [`AssociateExternalConnectionInput`](crate::input::AssociateExternalConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) external_connection: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that contains the repository.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain that contains the repository.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository to which the external connection is added.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository to which the external connection is added.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The name of the external connection to add to the repository. The following values are supported:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>public:npmjs</code> - for the npm public repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:pypi</code> - for the Python Package Index.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-central</code> - for Maven Central.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-googleandroid</code> - for the Google Android repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
        /// </p>
        /// </li>
        /// </ul>
        pub fn external_connection(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_connection = Some(input.into());
            self
        }
        /// <p>
        /// The name of the external connection to add to the repository. The following values are supported:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>public:npmjs</code> - for the npm public repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:pypi</code> - for the Python Package Index.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-central</code> - for Maven Central.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-googleandroid</code> - for the Google Android repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_external_connection(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateExternalConnectionInput`](crate::input::AssociateExternalConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateExternalConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateExternalConnectionInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                external_connection: self.external_connection,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateExternalConnectionInputOperationOutputAlias =
    crate::operation::AssociateExternalConnection;
#[doc(hidden)]
pub type AssociateExternalConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AssociateExternalConnectionInput {
    /// Consumes the builder and constructs an Operation<[`AssociateExternalConnection`](crate::operation::AssociateExternalConnection)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateExternalConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateExternalConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository/external-connection")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::AssociateExternalConnectionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_1) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_1));
            }
            if let Some(inner_2) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_2),
                );
            }
            if let Some(inner_3) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_3));
            }
            if let Some(inner_4) = &_input.external_connection {
                query.push_kv(
                    "external-connection",
                    &aws_smithy_http::query::fmt_string(&inner_4),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateExternalConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateExternalConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateExternalConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateExternalConnection",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateExternalConnectionInput`](crate::input::AssociateExternalConnectionInput)
    pub fn builder() -> crate::input::associate_external_connection_input::Builder {
        crate::input::associate_external_connection_input::Builder::default()
    }
}

/// See [`CopyPackageVersionsInput`](crate::input::CopyPackageVersionsInput)
pub mod copy_package_versions_input {
    /// A builder for [`CopyPackageVersionsInput`](crate::input::CopyPackageVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) source_repository: std::option::Option<std::string::String>,
        pub(crate) destination_repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) version_revisions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) allow_overwrite: std::option::Option<bool>,
        pub(crate) include_from_upstream: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the source and destination repositories.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the source and destination repositories.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to copy.
        /// </p>
        pub fn source_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to copy.
        /// </p>
        pub fn set_source_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_repository = input;
            self
        }
        /// <p>
        /// The name of the repository into which package versions are copied.
        /// </p>
        pub fn destination_repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository into which package versions are copied.
        /// </p>
        pub fn set_destination_repository(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_repository = input;
            self
        }
        /// <p>
        /// The format of the package that is copied. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package that is copied. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package that is copied.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that is copied.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// The versions of the package to copy.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>
        /// The versions of the package to copy.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Adds a key-value pair to `version_revisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p>
        /// A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation
        /// succeeds if the specified versions in the source repository match the specified package version revision.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.version_revisions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.version_revisions = Some(hash_map);
            self
        }
        /// <p>
        /// A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation
        /// succeeds if the specified versions in the source repository match the specified package version revision.
        /// </p>
        /// <note>
        /// <p>
        /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
        /// </p>
        /// </note>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.version_revisions = input;
            self
        }
        /// <p>
        /// Set to true to overwrite a package version that already exists in the destination repository.
        /// If set to false and the package version already exists in the destination repository,
        /// the package version is returned in the <code>failedVersions</code> field of the response with
        /// an <code>ALREADY_EXISTS</code> error code.
        /// </p>
        pub fn allow_overwrite(mut self, input: bool) -> Self {
            self.allow_overwrite = Some(input);
            self
        }
        /// <p>
        /// Set to true to overwrite a package version that already exists in the destination repository.
        /// If set to false and the package version already exists in the destination repository,
        /// the package version is returned in the <code>failedVersions</code> field of the response with
        /// an <code>ALREADY_EXISTS</code> error code.
        /// </p>
        pub fn set_allow_overwrite(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_overwrite = input;
            self
        }
        /// <p> Set to true to copy packages from repositories that are upstream from the source
        /// repository to the destination repository. The default setting is false. For more information,
        /// see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
        /// upstream repositories</a>. </p>
        pub fn include_from_upstream(mut self, input: bool) -> Self {
            self.include_from_upstream = Some(input);
            self
        }
        /// <p> Set to true to copy packages from repositories that are upstream from the source
        /// repository to the destination repository. The default setting is false. For more information,
        /// see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
        /// upstream repositories</a>. </p>
        pub fn set_include_from_upstream(mut self, input: std::option::Option<bool>) -> Self {
            self.include_from_upstream = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyPackageVersionsInput`](crate::input::CopyPackageVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyPackageVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyPackageVersionsInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                source_repository: self.source_repository,
                destination_repository: self.destination_repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                versions: self.versions,
                version_revisions: self.version_revisions,
                allow_overwrite: self.allow_overwrite,
                include_from_upstream: self.include_from_upstream,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyPackageVersionsInputOperationOutputAlias = crate::operation::CopyPackageVersions;
#[doc(hidden)]
pub type CopyPackageVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CopyPackageVersionsInput {
    /// Consumes the builder and constructs an Operation<[`CopyPackageVersions`](crate::operation::CopyPackageVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyPackageVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CopyPackageVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/versions/copy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::CopyPackageVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_5));
            }
            if let Some(inner_6) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_6),
                );
            }
            if let Some(inner_7) = &_input.source_repository {
                query.push_kv(
                    "source-repository",
                    &aws_smithy_http::query::fmt_string(&inner_7),
                );
            }
            if let Some(inner_8) = &_input.destination_repository {
                query.push_kv(
                    "destination-repository",
                    &aws_smithy_http::query::fmt_string(&inner_8),
                );
            }
            if let Some(inner_9) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_9));
            }
            if let Some(inner_10) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_10));
            }
            if let Some(inner_11) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_11));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CopyPackageVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CopyPackageVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_copy_package_versions(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyPackageVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyPackageVersions",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CopyPackageVersionsInput`](crate::input::CopyPackageVersionsInput)
    pub fn builder() -> crate::input::copy_package_versions_input::Builder {
        crate::input::copy_package_versions_input::Builder::default()
    }
}

/// See [`CreateDomainInput`](crate::input::CreateDomainInput)
pub mod create_domain_input {
    /// A builder for [`CreateDomainInput`](crate::input::CreateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p> The name of the domain to create. All domain names in an AWS Region that are in the
        /// same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do
        /// not use sensitive information in a domain name because it is publicly discoverable. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p> The name of the domain to create. All domain names in an AWS Region that are in the
        /// same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do
        /// not use sensitive information in a domain name because it is publicly discoverable. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain.
        /// An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key
        /// alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have
        /// <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption
        /// key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i>
        /// and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions
        /// Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// <important>
        /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your
        /// domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric
        /// keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// </important>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain.
        /// An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key
        /// alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have
        /// <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption
        /// key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i>
        /// and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions
        /// Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// <important>
        /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your
        /// domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric
        /// keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
        /// </important>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the domain.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tag key-value pairs for the domain.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainInput`](crate::input::CreateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainInput {
                domain: self.domain,
                encryption_key: self.encryption_key,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainInputOperationOutputAlias = crate::operation::CreateDomain;
#[doc(hidden)]
pub type CreateDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDomainInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomain`](crate::operation::CreateDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domain").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::CreateDomainInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_12) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_12));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_domain(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomain",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
}

/// See [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
pub mod create_repository_input {
    /// A builder for [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) upstreams: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the created repository.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the created repository.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p> The name of the repository to create. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p> The name of the repository to create. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// A description of the created repository.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// A description of the created repository.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `upstreams`.
        ///
        /// To override the contents of this collection use [`set_upstreams`](Self::set_upstreams).
        ///
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn upstreams(mut self, input: impl Into<crate::model::UpstreamRepository>) -> Self {
            let mut v = self.upstreams.unwrap_or_default();
            v.push(input.into());
            self.upstreams = Some(v);
            self
        }
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_upstreams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
        ) -> Self {
            self.upstreams = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tag key-value pairs for the repository.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tag key-value pairs for the repository.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRepositoryInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                description: self.description,
                upstreams: self.upstreams,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRepositoryInputOperationOutputAlias = crate::operation::CreateRepository;
#[doc(hidden)]
pub type CreateRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`CreateRepository`](crate::operation::CreateRepository)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::CreateRepositoryInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_13) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            if let Some(inner_14) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_14),
                );
            }
            if let Some(inner_15) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_15));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_repository(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRepository",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRepositoryInput`](crate::input::CreateRepositoryInput)
    pub fn builder() -> crate::input::create_repository_input::Builder {
        crate::input::create_repository_input::Builder::default()
    }
}

/// See [`DeleteDomainInput`](crate::input::DeleteDomainInput)
pub mod delete_domain_input {
    /// A builder for [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain to delete.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain to delete.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainInput`](crate::input::DeleteDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainInputOperationOutputAlias = crate::operation::DeleteDomain;
#[doc(hidden)]
pub type DeleteDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomain`](crate::operation::DeleteDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domain").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeleteDomainInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_16) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_16));
            }
            if let Some(inner_17) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_17),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomain",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
}

/// See [`DeleteDomainPermissionsPolicyInput`](crate::input::DeleteDomainPermissionsPolicyInput)
pub mod delete_domain_permissions_policy_input {
    /// A builder for [`DeleteDomainPermissionsPolicyInput`](crate::input::DeleteDomainPermissionsPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) policy_revision: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain associated with the resource policy to be deleted.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain associated with the resource policy to be deleted.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_revision = Some(input.into());
            self
        }
        /// <p>
        /// The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_revision = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainPermissionsPolicyInput`](crate::input::DeleteDomainPermissionsPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainPermissionsPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainPermissionsPolicyInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                policy_revision: self.policy_revision,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainPermissionsPolicyInputOperationOutputAlias =
    crate::operation::DeleteDomainPermissionsPolicy;
#[doc(hidden)]
pub type DeleteDomainPermissionsPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDomainPermissionsPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomainPermissionsPolicy`](crate::operation::DeleteDomainPermissionsPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomainPermissionsPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDomainPermissionsPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domain/permissions/policy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteDomainPermissionsPolicyInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_18) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_18));
            }
            if let Some(inner_19) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_19),
                );
            }
            if let Some(inner_20) = &_input.policy_revision {
                query.push_kv(
                    "policy-revision",
                    &aws_smithy_http::query::fmt_string(&inner_20),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDomainPermissionsPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDomainPermissionsPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomainPermissionsPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomainPermissionsPolicy",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainPermissionsPolicyInput`](crate::input::DeleteDomainPermissionsPolicyInput)
    pub fn builder() -> crate::input::delete_domain_permissions_policy_input::Builder {
        crate::input::delete_domain_permissions_policy_input::Builder::default()
    }
}

/// See [`DeletePackageVersionsInput`](crate::input::DeletePackageVersionsInput)
pub mod delete_package_versions_input {
    /// A builder for [`DeletePackageVersionsInput`](crate::input::DeletePackageVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) expected_status: std::option::Option<crate::model::PackageVersionStatus>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the package to delete.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the package to delete.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to delete.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions to delete.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The format of the package versions to delete. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package versions to delete. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package with the versions to delete.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package with the versions to delete.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// An array of strings that specify the versions of the package to delete.
        /// </p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>
        /// An array of strings that specify the versions of the package to delete.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// <p>
        /// The expected status of the package version to delete. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn expected_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.expected_status = Some(input);
            self
        }
        /// <p>
        /// The expected status of the package version to delete. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.expected_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePackageVersionsInput`](crate::input::DeletePackageVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePackageVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePackageVersionsInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                versions: self.versions,
                expected_status: self.expected_status,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePackageVersionsInputOperationOutputAlias = crate::operation::DeletePackageVersions;
#[doc(hidden)]
pub type DeletePackageVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeletePackageVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DeletePackageVersions`](crate::operation::DeletePackageVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePackageVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeletePackageVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/versions/delete").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeletePackageVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_21) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_21));
            }
            if let Some(inner_22) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_22),
                );
            }
            if let Some(inner_23) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_23));
            }
            if let Some(inner_24) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_24));
            }
            if let Some(inner_25) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_25));
            }
            if let Some(inner_26) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_26));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeletePackageVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeletePackageVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_package_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePackageVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePackageVersions",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeletePackageVersionsInput`](crate::input::DeletePackageVersionsInput)
    pub fn builder() -> crate::input::delete_package_versions_input::Builder {
        crate::input::delete_package_versions_input::Builder::default()
    }
}

/// See [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
pub mod delete_repository_input {
    /// A builder for [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository to delete.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository to delete.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p> The name of the repository to delete. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p> The name of the repository to delete. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRepositoryInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRepositoryInputOperationOutputAlias = crate::operation::DeleteRepository;
#[doc(hidden)]
pub type DeleteRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRepository`](crate::operation::DeleteRepository)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DeleteRepositoryInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_27) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_27));
            }
            if let Some(inner_28) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_28),
                );
            }
            if let Some(inner_29) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_29));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRepository",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryInput`](crate::input::DeleteRepositoryInput)
    pub fn builder() -> crate::input::delete_repository_input::Builder {
        crate::input::delete_repository_input::Builder::default()
    }
}

/// See [`DeleteRepositoryPermissionsPolicyInput`](crate::input::DeleteRepositoryPermissionsPolicyInput)
pub mod delete_repository_permissions_policy_input {
    /// A builder for [`DeleteRepositoryPermissionsPolicyInput`](crate::input::DeleteRepositoryPermissionsPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) policy_revision: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository associated with the resource policy to be deleted.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository associated with the resource policy to be deleted.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository that is associated with the resource policy to be deleted
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository that is associated with the resource policy to be deleted
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from accidentally overwriting your changes to the repository's resource policy.
        /// </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_revision = Some(input.into());
            self
        }
        /// <p>
        /// The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which
        /// prevents others from accidentally overwriting your changes to the repository's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_revision = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRepositoryPermissionsPolicyInput`](crate::input::DeleteRepositoryPermissionsPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRepositoryPermissionsPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRepositoryPermissionsPolicyInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                policy_revision: self.policy_revision,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRepositoryPermissionsPolicyInputOperationOutputAlias =
    crate::operation::DeleteRepositoryPermissionsPolicy;
#[doc(hidden)]
pub type DeleteRepositoryPermissionsPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRepositoryPermissionsPolicyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRepositoryPermissionsPolicy`](crate::operation::DeleteRepositoryPermissionsPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRepositoryPermissionsPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRepositoryPermissionsPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository/permissions/policies")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DeleteRepositoryPermissionsPolicyInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_30) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_30));
            }
            if let Some(inner_31) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_31),
                );
            }
            if let Some(inner_32) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_32));
            }
            if let Some(inner_33) = &_input.policy_revision {
                query.push_kv(
                    "policy-revision",
                    &aws_smithy_http::query::fmt_string(&inner_33),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRepositoryPermissionsPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRepositoryPermissionsPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRepositoryPermissionsPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRepositoryPermissionsPolicy",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRepositoryPermissionsPolicyInput`](crate::input::DeleteRepositoryPermissionsPolicyInput)
    pub fn builder() -> crate::input::delete_repository_permissions_policy_input::Builder {
        crate::input::delete_repository_permissions_policy_input::Builder::default()
    }
}

/// See [`DescribeDomainInput`](crate::input::DescribeDomainInput)
pub mod describe_domain_input {
    /// A builder for [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// A string that specifies the name of the requested domain.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// A string that specifies the name of the requested domain.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDomainInput`](crate::input::DescribeDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDomainInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDomainInputOperationOutputAlias = crate::operation::DescribeDomain;
#[doc(hidden)]
pub type DescribeDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDomainInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDomain`](crate::operation::DescribeDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domain").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeDomainInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_34) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_34));
            }
            if let Some(inner_35) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_35),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDomain",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDomainInput`](crate::input::DescribeDomainInput)
    pub fn builder() -> crate::input::describe_domain_input::Builder {
        crate::input::describe_domain_input::Builder::default()
    }
}

/// See [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
pub mod describe_package_version_input {
    /// A builder for [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository that contains the package version.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p> The name of the repository that contains the package version. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p> The name of the repository that contains the package version. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// A format that specifies the type of the requested package version. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the requested package version. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p> The name of the requested package version. </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p> The name of the requested package version. </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePackageVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePackageVersionInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                package_version: self.package_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePackageVersionInputOperationOutputAlias = crate::operation::DescribePackageVersion;
#[doc(hidden)]
pub type DescribePackageVersionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePackageVersionInput {
    /// Consumes the builder and constructs an Operation<[`DescribePackageVersion`](crate::operation::DescribePackageVersion)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePackageVersion,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePackageVersionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/version").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribePackageVersionInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_36) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_36));
            }
            if let Some(inner_37) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_37),
                );
            }
            if let Some(inner_38) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_38));
            }
            if let Some(inner_39) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_39));
            }
            if let Some(inner_40) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_40));
            }
            if let Some(inner_41) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_41));
            }
            if let Some(inner_42) = &_input.package_version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_42));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePackageVersionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePackageVersionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePackageVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePackageVersion",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePackageVersionInput`](crate::input::DescribePackageVersionInput)
    pub fn builder() -> crate::input::describe_package_version_input::Builder {
        crate::input::describe_package_version_input::Builder::default()
    }
}

/// See [`DescribeRepositoryInput`](crate::input::DescribeRepositoryInput)
pub mod describe_repository_input {
    /// A builder for [`DescribeRepositoryInput`](crate::input::DescribeRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository to describe.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository to describe.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// A string that specifies the name of the requested repository.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// A string that specifies the name of the requested repository.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRepositoryInput`](crate::input::DescribeRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRepositoryInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRepositoryInputOperationOutputAlias = crate::operation::DescribeRepository;
#[doc(hidden)]
pub type DescribeRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRepository`](crate::operation::DescribeRepository)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeRepositoryInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_43) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_43));
            }
            if let Some(inner_44) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_44),
                );
            }
            if let Some(inner_45) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_45));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRepository",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRepositoryInput`](crate::input::DescribeRepositoryInput)
    pub fn builder() -> crate::input::describe_repository_input::Builder {
        crate::input::describe_repository_input::Builder::default()
    }
}

/// See [`DisassociateExternalConnectionInput`](crate::input::DisassociateExternalConnectionInput)
pub mod disassociate_external_connection_input {
    /// A builder for [`DisassociateExternalConnectionInput`](crate::input::DisassociateExternalConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) external_connection: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain that contains the repository from which to remove the external
        /// repository. </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The name of the domain that contains the repository from which to remove the external
        /// repository. </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>The name of the repository from which the external connection will be removed. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>The name of the repository from which the external connection will be removed. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>The name of the external connection to be removed from the repository. </p>
        pub fn external_connection(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_connection = Some(input.into());
            self
        }
        /// <p>The name of the external connection to be removed from the repository. </p>
        pub fn set_external_connection(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_connection = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateExternalConnectionInput`](crate::input::DisassociateExternalConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateExternalConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateExternalConnectionInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                external_connection: self.external_connection,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateExternalConnectionInputOperationOutputAlias =
    crate::operation::DisassociateExternalConnection;
#[doc(hidden)]
pub type DisassociateExternalConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateExternalConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateExternalConnection`](crate::operation::DisassociateExternalConnection)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateExternalConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateExternalConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository/external-connection")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateExternalConnectionInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_46) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_46));
            }
            if let Some(inner_47) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_47),
                );
            }
            if let Some(inner_48) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_48));
            }
            if let Some(inner_49) = &_input.external_connection {
                query.push_kv(
                    "external-connection",
                    &aws_smithy_http::query::fmt_string(&inner_49),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateExternalConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateExternalConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateExternalConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateExternalConnection",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateExternalConnectionInput`](crate::input::DisassociateExternalConnectionInput)
    pub fn builder() -> crate::input::disassociate_external_connection_input::Builder {
        crate::input::disassociate_external_connection_input::Builder::default()
    }
}

/// See [`DisposePackageVersionsInput`](crate::input::DisposePackageVersionsInput)
pub mod dispose_package_versions_input {
    /// A builder for [`DisposePackageVersionsInput`](crate::input::DisposePackageVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) version_revisions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expected_status: std::option::Option<crate::model::PackageVersionStatus>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository you want to dispose.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository you want to dispose.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions you want to dispose.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository that contains the package versions you want to dispose.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// A format that specifies the type of package versions you want to dispose. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// A format that specifies the type of package versions you want to dispose. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package with the versions you want to dispose.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package with the versions you want to dispose.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// The versions of the package you want to dispose.
        /// </p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>
        /// The versions of the package you want to dispose.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Adds a key-value pair to `version_revisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p>
        /// The revisions of the package versions you want to dispose.
        /// </p>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.version_revisions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.version_revisions = Some(hash_map);
            self
        }
        /// <p>
        /// The revisions of the package versions you want to dispose.
        /// </p>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.version_revisions = input;
            self
        }
        /// <p>
        /// The expected status of the package version to dispose. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn expected_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.expected_status = Some(input);
            self
        }
        /// <p>
        /// The expected status of the package version to dispose. Valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.expected_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DisposePackageVersionsInput`](crate::input::DisposePackageVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisposePackageVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisposePackageVersionsInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                versions: self.versions,
                version_revisions: self.version_revisions,
                expected_status: self.expected_status,
            })
        }
    }
}
#[doc(hidden)]
pub type DisposePackageVersionsInputOperationOutputAlias = crate::operation::DisposePackageVersions;
#[doc(hidden)]
pub type DisposePackageVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisposePackageVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DisposePackageVersions`](crate::operation::DisposePackageVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisposePackageVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisposePackageVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/versions/dispose").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DisposePackageVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_50) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_50));
            }
            if let Some(inner_51) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_51),
                );
            }
            if let Some(inner_52) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_52));
            }
            if let Some(inner_53) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_53));
            }
            if let Some(inner_54) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_54));
            }
            if let Some(inner_55) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_55));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisposePackageVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisposePackageVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_dispose_package_versions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisposePackageVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisposePackageVersions",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisposePackageVersionsInput`](crate::input::DisposePackageVersionsInput)
    pub fn builder() -> crate::input::dispose_package_versions_input::Builder {
        crate::input::dispose_package_versions_input::Builder::default()
    }
}

/// See [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
pub mod get_authorization_token_input {
    /// A builder for [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) duration_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that is in scope for the generated authorization token.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that is in scope for the generated authorization token.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are
        /// <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours).
        /// A value of <code>0</code> will set the expiration of the authorization token to the same expiration of
        /// the user's role's temporary credentials.</p>
        pub fn duration_seconds(mut self, input: i64) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are
        /// <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours).
        /// A value of <code>0</code> will set the expiration of the authorization token to the same expiration of
        /// the user's role's temporary credentials.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAuthorizationTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAuthorizationTokenInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                duration_seconds: self.duration_seconds,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAuthorizationTokenInputOperationOutputAlias = crate::operation::GetAuthorizationToken;
#[doc(hidden)]
pub type GetAuthorizationTokenInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAuthorizationTokenInput {
    /// Consumes the builder and constructs an Operation<[`GetAuthorizationToken`](crate::operation::GetAuthorizationToken)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAuthorizationToken,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAuthorizationTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/authorization-token").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetAuthorizationTokenInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_56) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_56));
            }
            if let Some(inner_57) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_57),
                );
            }
            if let Some(inner_58) = &_input.duration_seconds {
                query.push_kv(
                    "duration",
                    &aws_smithy_types::primitive::Encoder::from(*inner_58).encode(),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAuthorizationTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAuthorizationTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAuthorizationToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAuthorizationToken",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAuthorizationTokenInput`](crate::input::GetAuthorizationTokenInput)
    pub fn builder() -> crate::input::get_authorization_token_input::Builder {
        crate::input::get_authorization_token_input::Builder::default()
    }
}

/// See [`GetDomainPermissionsPolicyInput`](crate::input::GetDomainPermissionsPolicyInput)
pub mod get_domain_permissions_policy_input {
    /// A builder for [`GetDomainPermissionsPolicyInput`](crate::input::GetDomainPermissionsPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain to which the resource policy is attached.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain to which the resource policy is attached.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainPermissionsPolicyInput`](crate::input::GetDomainPermissionsPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainPermissionsPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainPermissionsPolicyInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainPermissionsPolicyInputOperationOutputAlias =
    crate::operation::GetDomainPermissionsPolicy;
#[doc(hidden)]
pub type GetDomainPermissionsPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDomainPermissionsPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetDomainPermissionsPolicy`](crate::operation::GetDomainPermissionsPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomainPermissionsPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDomainPermissionsPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domain/permissions/policy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetDomainPermissionsPolicyInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_59) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_59));
            }
            if let Some(inner_60) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_60),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDomainPermissionsPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDomainPermissionsPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomainPermissionsPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomainPermissionsPolicy",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDomainPermissionsPolicyInput`](crate::input::GetDomainPermissionsPolicyInput)
    pub fn builder() -> crate::input::get_domain_permissions_policy_input::Builder {
        crate::input::get_domain_permissions_policy_input::Builder::default()
    }
}

/// See [`GetPackageVersionAssetInput`](crate::input::GetPackageVersionAssetInput)
pub mod get_package_version_asset_input {
    /// A builder for [`GetPackageVersionAssetInput`](crate::input::GetPackageVersionAssetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) asset: std::option::Option<std::string::String>,
        pub(crate) package_version_revision: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested asset.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested asset.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The repository that contains the package version with the requested asset.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The repository that contains the package version with the requested asset.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested asset file. The valid values are:
        /// </p>    
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested asset file. The valid values are:
        /// </p>    
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package that contains the requested asset.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that contains the requested asset.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>
        /// The name of the requested asset.
        /// </p>
        pub fn asset(mut self, input: impl Into<std::string::String>) -> Self {
            self.asset = Some(input.into());
            self
        }
        /// <p>
        /// The name of the requested asset.
        /// </p>
        pub fn set_asset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asset = input;
            self
        }
        /// <p>
        /// The name of the package version revision that contains the requested asset.
        /// </p>
        pub fn package_version_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version_revision = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package version revision that contains the requested asset.
        /// </p>
        pub fn set_package_version_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version_revision = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionAssetInput`](crate::input::GetPackageVersionAssetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPackageVersionAssetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPackageVersionAssetInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                package_version: self.package_version,
                asset: self.asset,
                package_version_revision: self.package_version_revision,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPackageVersionAssetInputOperationOutputAlias = crate::operation::GetPackageVersionAsset;
#[doc(hidden)]
pub type GetPackageVersionAssetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPackageVersionAssetInput {
    /// Consumes the builder and constructs an Operation<[`GetPackageVersionAsset`](crate::operation::GetPackageVersionAsset)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPackageVersionAsset,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPackageVersionAssetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/version/asset").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetPackageVersionAssetInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_61) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_61));
            }
            if let Some(inner_62) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_62),
                );
            }
            if let Some(inner_63) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_63));
            }
            if let Some(inner_64) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_64));
            }
            if let Some(inner_65) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_65));
            }
            if let Some(inner_66) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_66));
            }
            if let Some(inner_67) = &_input.package_version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_67));
            }
            if let Some(inner_68) = &_input.asset {
                query.push_kv("asset", &aws_smithy_http::query::fmt_string(&inner_68));
            }
            if let Some(inner_69) = &_input.package_version_revision {
                query.push_kv("revision", &aws_smithy_http::query::fmt_string(&inner_69));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPackageVersionAssetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPackageVersionAssetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPackageVersionAsset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPackageVersionAsset",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPackageVersionAssetInput`](crate::input::GetPackageVersionAssetInput)
    pub fn builder() -> crate::input::get_package_version_asset_input::Builder {
        crate::input::get_package_version_asset_input::Builder::default()
    }
}

/// See [`GetPackageVersionReadmeInput`](crate::input::GetPackageVersionReadmeInput)
pub mod get_package_version_readme_input {
    /// A builder for [`GetPackageVersionReadmeInput`](crate::input::GetPackageVersionReadmeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested readme file.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package version with the requested readme file.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The repository that contains the package with the requested readme file.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The repository that contains the package with the requested readme file.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested readme file. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the package version with the requested readme file. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package version that contains the requested readme file.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package version that contains the requested readme file.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPackageVersionReadmeInput`](crate::input::GetPackageVersionReadmeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetPackageVersionReadmeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetPackageVersionReadmeInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                package_version: self.package_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetPackageVersionReadmeInputOperationOutputAlias =
    crate::operation::GetPackageVersionReadme;
#[doc(hidden)]
pub type GetPackageVersionReadmeInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetPackageVersionReadmeInput {
    /// Consumes the builder and constructs an Operation<[`GetPackageVersionReadme`](crate::operation::GetPackageVersionReadme)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetPackageVersionReadme,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetPackageVersionReadmeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/version/readme").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetPackageVersionReadmeInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_70) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_70));
            }
            if let Some(inner_71) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_71),
                );
            }
            if let Some(inner_72) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_72));
            }
            if let Some(inner_73) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_73));
            }
            if let Some(inner_74) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_74));
            }
            if let Some(inner_75) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_75));
            }
            if let Some(inner_76) = &_input.package_version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_76));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetPackageVersionReadmeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetPackageVersionReadmeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetPackageVersionReadme::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetPackageVersionReadme",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetPackageVersionReadmeInput`](crate::input::GetPackageVersionReadmeInput)
    pub fn builder() -> crate::input::get_package_version_readme_input::Builder {
        crate::input::get_package_version_readme_input::Builder::default()
    }
}

/// See [`GetRepositoryEndpointInput`](crate::input::GetRepositoryEndpointInput)
pub mod get_repository_endpoint_input {
    /// A builder for [`GetRepositoryEndpointInput`](crate::input::GetRepositoryEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// Returns which endpoint of a repository to return. A repository has one endpoint for each
        /// package format:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// Returns which endpoint of a repository to return. A repository has one endpoint for each
        /// package format:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryEndpointInput`](crate::input::GetRepositoryEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRepositoryEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRepositoryEndpointInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRepositoryEndpointInputOperationOutputAlias = crate::operation::GetRepositoryEndpoint;
#[doc(hidden)]
pub type GetRepositoryEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRepositoryEndpointInput {
    /// Consumes the builder and constructs an Operation<[`GetRepositoryEndpoint`](crate::operation::GetRepositoryEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRepositoryEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRepositoryEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository/endpoint").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::GetRepositoryEndpointInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_77) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_77));
            }
            if let Some(inner_78) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_78),
                );
            }
            if let Some(inner_79) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_79));
            }
            if let Some(inner_80) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_80));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRepositoryEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRepositoryEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRepositoryEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRepositoryEndpoint",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRepositoryEndpointInput`](crate::input::GetRepositoryEndpointInput)
    pub fn builder() -> crate::input::get_repository_endpoint_input::Builder {
        crate::input::get_repository_endpoint_input::Builder::default()
    }
}

/// See [`GetRepositoryPermissionsPolicyInput`](crate::input::GetRepositoryPermissionsPolicyInput)
pub mod get_repository_permissions_policy_input {
    /// A builder for [`GetRepositoryPermissionsPolicyInput`](crate::input::GetRepositoryPermissionsPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain containing the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain containing the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository whose associated resource policy is to be retrieved.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRepositoryPermissionsPolicyInput`](crate::input::GetRepositoryPermissionsPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRepositoryPermissionsPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRepositoryPermissionsPolicyInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRepositoryPermissionsPolicyInputOperationOutputAlias =
    crate::operation::GetRepositoryPermissionsPolicy;
#[doc(hidden)]
pub type GetRepositoryPermissionsPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetRepositoryPermissionsPolicyInput {
    /// Consumes the builder and constructs an Operation<[`GetRepositoryPermissionsPolicy`](crate::operation::GetRepositoryPermissionsPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRepositoryPermissionsPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRepositoryPermissionsPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository/permissions/policy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetRepositoryPermissionsPolicyInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_81) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_81));
            }
            if let Some(inner_82) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_82),
                );
            }
            if let Some(inner_83) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_83));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRepositoryPermissionsPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRepositoryPermissionsPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRepositoryPermissionsPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRepositoryPermissionsPolicy",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRepositoryPermissionsPolicyInput`](crate::input::GetRepositoryPermissionsPolicyInput)
    pub fn builder() -> crate::input::get_repository_permissions_policy_input::Builder {
        crate::input::get_repository_permissions_policy_input::Builder::default()
    }
}

/// See [`ListDomainsInput`](crate::input::ListDomainsInput)
pub mod list_domains_input {
    /// A builder for [`ListDomainsInput`](crate::input::ListDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsInput`](crate::input::ListDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainsInputOperationOutputAlias = crate::operation::ListDomains;
#[doc(hidden)]
pub type ListDomainsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListDomainsInput {
    /// Consumes the builder and constructs an Operation<[`ListDomains`](crate::operation::ListDomains)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomains,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDomainsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domains").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDomainsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDomainsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_domains(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomains",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
}

/// See [`ListPackagesInput`](crate::input::ListPackagesInput)
pub mod list_packages_input {
    /// A builder for [`ListPackagesInput`](crate::input::ListPackagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package_prefix: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository that contains the requested list of packages.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the requested list of packages.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository from which packages are to be listed.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository from which packages are to be listed.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The format of the packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// A prefix used to filter returned packages. Only packages with names that start with
        /// <code>packagePrefix</code> are returned.
        /// </p>
        pub fn package_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_prefix = Some(input.into());
            self
        }
        /// <p>
        /// A prefix used to filter returned packages. Only packages with names that start with
        /// <code>packagePrefix</code> are returned.
        /// </p>
        pub fn set_package_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_prefix = input;
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackagesInput`](crate::input::ListPackagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackagesInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package_prefix: self.package_prefix,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackagesInputOperationOutputAlias = crate::operation::ListPackages;
#[doc(hidden)]
pub type ListPackagesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPackagesInput {
    /// Consumes the builder and constructs an Operation<[`ListPackages`](crate::operation::ListPackages)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackages,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPackagesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/packages").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListPackagesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_84) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_84));
            }
            if let Some(inner_85) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_85),
                );
            }
            if let Some(inner_86) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_86));
            }
            if let Some(inner_87) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_87));
            }
            if let Some(inner_88) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_88));
            }
            if let Some(inner_89) = &_input.package_prefix {
                query.push_kv(
                    "package-prefix",
                    &aws_smithy_http::query::fmt_string(&inner_89),
                );
            }
            if let Some(inner_90) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_90).encode(),
                );
            }
            if let Some(inner_91) = &_input.next_token {
                query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_91));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPackagesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPackagesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackages",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPackagesInput`](crate::input::ListPackagesInput)
    pub fn builder() -> crate::input::list_packages_input::Builder {
        crate::input::list_packages_input::Builder::default()
    }
}

/// See [`ListPackageVersionAssetsInput`](crate::input::ListPackageVersionAssetsInput)
pub mod list_package_version_assets_input {
    /// A builder for [`ListPackageVersionAssetsInput`](crate::input::ListPackageVersionAssetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository associated with the package version assets.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository associated with the package version assets.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository that contains the package that contains the returned package version assets.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository that contains the package that contains the returned package version assets.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The format of the package that contains the returned package version assets. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package that contains the returned package version assets. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package that contains the returned package version assets.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package that contains the returned package version assets.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageVersionAssetsInput`](crate::input::ListPackageVersionAssetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackageVersionAssetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackageVersionAssetsInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                package_version: self.package_version,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackageVersionAssetsInputOperationOutputAlias =
    crate::operation::ListPackageVersionAssets;
#[doc(hidden)]
pub type ListPackageVersionAssetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPackageVersionAssetsInput {
    /// Consumes the builder and constructs an Operation<[`ListPackageVersionAssets`](crate::operation::ListPackageVersionAssets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackageVersionAssets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPackageVersionAssetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/version/assets").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPackageVersionAssetsInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_92) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_92));
            }
            if let Some(inner_93) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_93),
                );
            }
            if let Some(inner_94) = &_input.repository {
                query.push_kv("repository", &aws_smithy_http::query::fmt_string(&inner_94));
            }
            if let Some(inner_95) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_95));
            }
            if let Some(inner_96) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_96));
            }
            if let Some(inner_97) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_97));
            }
            if let Some(inner_98) = &_input.package_version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_98));
            }
            if let Some(inner_99) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_99).encode(),
                );
            }
            if let Some(inner_100) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_100),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPackageVersionAssetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPackageVersionAssetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackageVersionAssets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackageVersionAssets",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPackageVersionAssetsInput`](crate::input::ListPackageVersionAssetsInput)
    pub fn builder() -> crate::input::list_package_version_assets_input::Builder {
        crate::input::list_package_version_assets_input::Builder::default()
    }
}

/// See [`ListPackageVersionDependenciesInput`](crate::input::ListPackageVersionDependenciesInput)
pub mod list_package_version_dependencies_input {
    /// A builder for [`ListPackageVersionDependenciesInput`](crate::input::ListPackageVersionDependenciesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) package_version: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository that contains the requested package version dependencies.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the requested package version dependencies.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository that contains the requested package version.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository that contains the requested package version.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The format of the package with the requested dependencies. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the package with the requested dependencies. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package versions' package.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package versions' package.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn package_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.package_version = Some(input.into());
            self
        }
        /// <p>
        /// A string that contains the package version (for example, <code>3.5.2</code>).
        /// </p>
        pub fn set_package_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.package_version = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageVersionDependenciesInput`](crate::input::ListPackageVersionDependenciesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackageVersionDependenciesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackageVersionDependenciesInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                package_version: self.package_version,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackageVersionDependenciesInputOperationOutputAlias =
    crate::operation::ListPackageVersionDependencies;
#[doc(hidden)]
pub type ListPackageVersionDependenciesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPackageVersionDependenciesInput {
    /// Consumes the builder and constructs an Operation<[`ListPackageVersionDependencies`](crate::operation::ListPackageVersionDependencies)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackageVersionDependencies,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPackageVersionDependenciesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/version/dependencies").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPackageVersionDependenciesInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_101) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_101));
            }
            if let Some(inner_102) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_102),
                );
            }
            if let Some(inner_103) = &_input.repository {
                query.push_kv(
                    "repository",
                    &aws_smithy_http::query::fmt_string(&inner_103),
                );
            }
            if let Some(inner_104) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_104));
            }
            if let Some(inner_105) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_105));
            }
            if let Some(inner_106) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_106));
            }
            if let Some(inner_107) = &_input.package_version {
                query.push_kv("version", &aws_smithy_http::query::fmt_string(&inner_107));
            }
            if let Some(inner_108) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_108),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPackageVersionDependenciesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPackageVersionDependenciesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackageVersionDependencies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackageVersionDependencies",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPackageVersionDependenciesInput`](crate::input::ListPackageVersionDependenciesInput)
    pub fn builder() -> crate::input::list_package_version_dependencies_input::Builder {
        crate::input::list_package_version_dependencies_input::Builder::default()
    }
}

/// See [`ListPackageVersionsInput`](crate::input::ListPackageVersionsInput)
pub mod list_package_versions_input {
    /// A builder for [`ListPackageVersionsInput`](crate::input::ListPackageVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PackageVersionStatus>,
        pub(crate) sort_by: std::option::Option<crate::model::PackageVersionSortType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository that contains the returned package versions.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the returned package versions.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository that contains the package.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository that contains the package.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// The format of the returned packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// The format of the returned packages. The valid package types are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>: A Node Package Manager (npm) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>: A Python Package Index (PyPI) package.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package for which you want to return a list of package versions.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package for which you want to return a list of package versions.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// <p>
        /// A string that specifies the status of the package versions to include in the returned list. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>
        /// A string that specifies the status of the package versions to include in the returned list. It can be one of the following:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Published</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unfinished</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unlisted</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Archived</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Disposed</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// How to sort the returned list of package versions.
        /// </p>
        pub fn sort_by(mut self, input: crate::model::PackageVersionSortType) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>
        /// How to sort the returned list of package versions.
        /// </p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::PackageVersionSortType>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPackageVersionsInput`](crate::input::ListPackageVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPackageVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPackageVersionsInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                status: self.status,
                sort_by: self.sort_by,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPackageVersionsInputOperationOutputAlias = crate::operation::ListPackageVersions;
#[doc(hidden)]
pub type ListPackageVersionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListPackageVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListPackageVersions`](crate::operation::ListPackageVersions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPackageVersions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPackageVersionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/versions").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListPackageVersionsInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_109) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_109));
            }
            if let Some(inner_110) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_110),
                );
            }
            if let Some(inner_111) = &_input.repository {
                query.push_kv(
                    "repository",
                    &aws_smithy_http::query::fmt_string(&inner_111),
                );
            }
            if let Some(inner_112) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_112));
            }
            if let Some(inner_113) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_113));
            }
            if let Some(inner_114) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_114));
            }
            if let Some(inner_115) = &_input.status {
                query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_115));
            }
            if let Some(inner_116) = &_input.sort_by {
                query.push_kv("sortBy", &aws_smithy_http::query::fmt_string(&inner_116));
            }
            if let Some(inner_117) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_117).encode(),
                );
            }
            if let Some(inner_118) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_118),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPackageVersionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPackageVersionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPackageVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPackageVersions",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPackageVersionsInput`](crate::input::ListPackageVersionsInput)
    pub fn builder() -> crate::input::list_package_versions_input::Builder {
        crate::input::list_package_versions_input::Builder::default()
    }
}

/// See [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
pub mod list_repositories_input {
    /// A builder for [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) repository_prefix: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start
        /// with <code>repositoryPrefix</code> are returned.</p>
        pub fn repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_prefix = Some(input.into());
            self
        }
        /// <p> A prefix used to filter returned repositories. Only repositories with names that start
        /// with <code>repositoryPrefix</code> are returned.</p>
        pub fn set_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_prefix = input;
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRepositoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRepositoriesInput {
                repository_prefix: self.repository_prefix,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRepositoriesInputOperationOutputAlias = crate::operation::ListRepositories;
#[doc(hidden)]
pub type ListRepositoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRepositoriesInput {
    /// Consumes the builder and constructs an Operation<[`ListRepositories`](crate::operation::ListRepositories)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRepositories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRepositoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repositories").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListRepositoriesInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_119) = &_input.repository_prefix {
                query.push_kv(
                    "repository-prefix",
                    &aws_smithy_http::query::fmt_string(&inner_119),
                );
            }
            if let Some(inner_120) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_120).encode(),
                );
            }
            if let Some(inner_121) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_121),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRepositoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRepositoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRepositories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRepositories",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInput`](crate::input::ListRepositoriesInput)
    pub fn builder() -> crate::input::list_repositories_input::Builder {
        crate::input::list_repositories_input::Builder::default()
    }
}

/// See [`ListRepositoriesInDomainInput`](crate::input::ListRepositoriesInDomainInput)
pub mod list_repositories_in_domain_input {
    /// A builder for [`ListRepositoriesInDomainInput`](crate::input::ListRepositoriesInDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) administrator_account: std::option::Option<std::string::String>,
        pub(crate) repository_prefix: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the returned list of repositories.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the returned list of repositories.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// Filter the list of repositories to only include those that are managed by the AWS account ID.
        /// </p>
        pub fn administrator_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.administrator_account = Some(input.into());
            self
        }
        /// <p>
        /// Filter the list of repositories to only include those that are managed by the AWS account ID.
        /// </p>
        pub fn set_administrator_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administrator_account = input;
            self
        }
        /// <p>
        /// A prefix used to filter returned repositories. Only repositories with names that start with
        /// <code>repositoryPrefix</code> are returned.
        /// </p>
        pub fn repository_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository_prefix = Some(input.into());
            self
        }
        /// <p>
        /// A prefix used to filter returned repositories. Only repositories with names that start with
        /// <code>repositoryPrefix</code> are returned.
        /// </p>
        pub fn set_repository_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.repository_prefix = input;
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>
        /// The maximum number of results to return per page.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRepositoriesInDomainInput`](crate::input::ListRepositoriesInDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRepositoriesInDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRepositoriesInDomainInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                administrator_account: self.administrator_account,
                repository_prefix: self.repository_prefix,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRepositoriesInDomainInputOperationOutputAlias =
    crate::operation::ListRepositoriesInDomain;
#[doc(hidden)]
pub type ListRepositoriesInDomainInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListRepositoriesInDomainInput {
    /// Consumes the builder and constructs an Operation<[`ListRepositoriesInDomain`](crate::operation::ListRepositoriesInDomain)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRepositoriesInDomain,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRepositoriesInDomainInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domain/repositories").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRepositoriesInDomainInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_122) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_122));
            }
            if let Some(inner_123) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_123),
                );
            }
            if let Some(inner_124) = &_input.administrator_account {
                query.push_kv(
                    "administrator-account",
                    &aws_smithy_http::query::fmt_string(&inner_124),
                );
            }
            if let Some(inner_125) = &_input.repository_prefix {
                query.push_kv(
                    "repository-prefix",
                    &aws_smithy_http::query::fmt_string(&inner_125),
                );
            }
            if let Some(inner_126) = &_input.max_results {
                query.push_kv(
                    "max-results",
                    &aws_smithy_types::primitive::Encoder::from(*inner_126).encode(),
                );
            }
            if let Some(inner_127) = &_input.next_token {
                query.push_kv(
                    "next-token",
                    &aws_smithy_http::query::fmt_string(&inner_127),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRepositoriesInDomainInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRepositoriesInDomainInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRepositoriesInDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRepositoriesInDomain",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRepositoriesInDomainInput`](crate::input::ListRepositoriesInDomainInput)
    pub fn builder() -> crate::input::list_repositories_in_domain_input::Builder {
        crate::input::list_repositories_in_domain_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/tags").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::ListTagsForResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_128) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_128),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutDomainPermissionsPolicyInput`](crate::input::PutDomainPermissionsPolicyInput)
pub mod put_domain_permissions_policy_input {
    /// A builder for [`PutDomainPermissionsPolicyInput`](crate::input::PutDomainPermissionsPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) policy_revision: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain on which to set the resource policy.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain on which to set the resource policy.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The current revision of the resource policy to be set. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_revision = Some(input.into());
            self
        }
        /// <p>
        /// The current revision of the resource policy to be set. This revision is used for optimistic locking, which
        /// prevents others from overwriting your changes to the domain's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_revision = input;
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided domain. </p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided domain. </p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`PutDomainPermissionsPolicyInput`](crate::input::PutDomainPermissionsPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutDomainPermissionsPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutDomainPermissionsPolicyInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                policy_revision: self.policy_revision,
                policy_document: self.policy_document,
            })
        }
    }
}
#[doc(hidden)]
pub type PutDomainPermissionsPolicyInputOperationOutputAlias =
    crate::operation::PutDomainPermissionsPolicy;
#[doc(hidden)]
pub type PutDomainPermissionsPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutDomainPermissionsPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutDomainPermissionsPolicy`](crate::operation::PutDomainPermissionsPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutDomainPermissionsPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutDomainPermissionsPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/domain/permissions/policy").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutDomainPermissionsPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutDomainPermissionsPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_domain_permissions_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutDomainPermissionsPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutDomainPermissionsPolicy",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutDomainPermissionsPolicyInput`](crate::input::PutDomainPermissionsPolicyInput)
    pub fn builder() -> crate::input::put_domain_permissions_policy_input::Builder {
        crate::input::put_domain_permissions_policy_input::Builder::default()
    }
}

/// See [`PutRepositoryPermissionsPolicyInput`](crate::input::PutRepositoryPermissionsPolicyInput)
pub mod put_repository_permissions_policy_input {
    /// A builder for [`PutRepositoryPermissionsPolicyInput`](crate::input::PutRepositoryPermissionsPolicyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) policy_revision: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain containing the repository to set the resource policy on.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain containing the repository to set the resource policy on.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p> The name of the repository to set the resource policy on. </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p> The name of the repository to set the resource policy on. </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// Sets the revision of the resource policy that specifies permissions to access the repository.
        /// This revision is used for optimistic locking, which prevents others from overwriting your
        /// changes to the repository's resource policy.
        /// </p>
        pub fn policy_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_revision = Some(input.into());
            self
        }
        /// <p>
        /// Sets the revision of the resource policy that specifies permissions to access the repository.
        /// This revision is used for optimistic locking, which prevents others from overwriting your
        /// changes to the repository's resource policy.
        /// </p>
        pub fn set_policy_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_revision = input;
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided repository. </p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
        /// policy on the provided repository. </p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// Consumes the builder and constructs a [`PutRepositoryPermissionsPolicyInput`](crate::input::PutRepositoryPermissionsPolicyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutRepositoryPermissionsPolicyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutRepositoryPermissionsPolicyInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                policy_revision: self.policy_revision,
                policy_document: self.policy_document,
            })
        }
    }
}
#[doc(hidden)]
pub type PutRepositoryPermissionsPolicyInputOperationOutputAlias =
    crate::operation::PutRepositoryPermissionsPolicy;
#[doc(hidden)]
pub type PutRepositoryPermissionsPolicyInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PutRepositoryPermissionsPolicyInput {
    /// Consumes the builder and constructs an Operation<[`PutRepositoryPermissionsPolicy`](crate::operation::PutRepositoryPermissionsPolicy)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutRepositoryPermissionsPolicy,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutRepositoryPermissionsPolicyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository/permissions/policy").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::PutRepositoryPermissionsPolicyInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_129) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_129));
            }
            if let Some(inner_130) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_130),
                );
            }
            if let Some(inner_131) = &_input.repository {
                query.push_kv(
                    "repository",
                    &aws_smithy_http::query::fmt_string(&inner_131),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutRepositoryPermissionsPolicyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutRepositoryPermissionsPolicyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_repository_permissions_policy(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutRepositoryPermissionsPolicy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutRepositoryPermissionsPolicy",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutRepositoryPermissionsPolicyInput`](crate::input::PutRepositoryPermissionsPolicyInput)
    pub fn builder() -> crate::input::put_repository_permissions_policy_input::Builder {
        crate::input::put_repository_permissions_policy_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags you want to modify or add to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/tag").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::TagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_132) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_132),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key for each tag that you want to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/untag").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UntagResourceInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_133) = &_input.resource_arn {
                query.push_kv(
                    "resourceArn",
                    &aws_smithy_http::query::fmt_string(&inner_133),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdatePackageVersionsStatusInput`](crate::input::UpdatePackageVersionsStatusInput)
pub mod update_package_versions_status_input {
    /// A builder for [`UpdatePackageVersionsStatusInput`](crate::input::UpdatePackageVersionsStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) format: std::option::Option<crate::model::PackageFormat>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) package: std::option::Option<std::string::String>,
        pub(crate) versions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) version_revisions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) expected_status: std::option::Option<crate::model::PackageVersionStatus>,
        pub(crate) target_status: std::option::Option<crate::model::PackageVersionStatus>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain that contains the repository that contains the package versions with a status to be updated.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain that contains the repository that contains the package versions with a status to be updated.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The repository that contains the package versions with the status you want to update.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The repository that contains the package versions with the status you want to update.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// A format that specifies the type of the package with the statuses to update. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn format(mut self, input: crate::model::PackageFormat) -> Self {
            self.format = Some(input);
            self
        }
        /// <p>
        /// A format that specifies the type of the package with the statuses to update. The valid values are:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>npm</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pypi</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>maven</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_format(
            mut self,
            input: std::option::Option<crate::model::PackageFormat>,
        ) -> Self {
            self.format = input;
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>
        /// The namespace of the package. The package component that specifies its
        /// namespace depends on its type. For example:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>
        /// The namespace of a Maven package is its <code>groupId</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// The namespace of an npm package is its <code>scope</code>.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// A Python package does not contain a corresponding component, so
        /// Python packages do not have a namespace.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>
        /// The name of the package with the version statuses to update.
        /// </p>
        pub fn package(mut self, input: impl Into<std::string::String>) -> Self {
            self.package = Some(input.into());
            self
        }
        /// <p>
        /// The name of the package with the version statuses to update.
        /// </p>
        pub fn set_package(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.package = input;
            self
        }
        /// Appends an item to `versions`.
        ///
        /// To override the contents of this collection use [`set_versions`](Self::set_versions).
        ///
        /// <p>
        /// An array of strings that specify the versions of the package with the statuses to update.
        /// </p>
        pub fn versions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.versions.unwrap_or_default();
            v.push(input.into());
            self.versions = Some(v);
            self
        }
        /// <p>
        /// An array of strings that specify the versions of the package with the statuses to update.
        /// </p>
        pub fn set_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.versions = input;
            self
        }
        /// Adds a key-value pair to `version_revisions`.
        ///
        /// To override the contents of this collection use [`set_version_revisions`](Self::set_version_revisions).
        ///
        /// <p> A map of package versions and package version revisions. The map <code>key</code> is the
        /// package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the
        /// package version revision. </p>
        pub fn version_revisions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.version_revisions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.version_revisions = Some(hash_map);
            self
        }
        /// <p> A map of package versions and package version revisions. The map <code>key</code> is the
        /// package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the
        /// package version revision. </p>
        pub fn set_version_revisions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.version_revisions = input;
            self
        }
        /// <p> The package version’s expected status before it is updated. If
        /// <code>expectedStatus</code> is provided, the package version's status is updated only if its
        /// status at the time <code>UpdatePackageVersionsStatus</code> is called matches
        /// <code>expectedStatus</code>. </p>
        pub fn expected_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.expected_status = Some(input);
            self
        }
        /// <p> The package version’s expected status before it is updated. If
        /// <code>expectedStatus</code> is provided, the package version's status is updated only if its
        /// status at the time <code>UpdatePackageVersionsStatus</code> is called matches
        /// <code>expectedStatus</code>. </p>
        pub fn set_expected_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.expected_status = input;
            self
        }
        /// <p>
        /// The status you want to change the package version status to.
        /// </p>
        pub fn target_status(mut self, input: crate::model::PackageVersionStatus) -> Self {
            self.target_status = Some(input);
            self
        }
        /// <p>
        /// The status you want to change the package version status to.
        /// </p>
        pub fn set_target_status(
            mut self,
            input: std::option::Option<crate::model::PackageVersionStatus>,
        ) -> Self {
            self.target_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePackageVersionsStatusInput`](crate::input::UpdatePackageVersionsStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePackageVersionsStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePackageVersionsStatusInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                format: self.format,
                namespace: self.namespace,
                package: self.package,
                versions: self.versions,
                version_revisions: self.version_revisions,
                expected_status: self.expected_status,
                target_status: self.target_status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePackageVersionsStatusInputOperationOutputAlias =
    crate::operation::UpdatePackageVersionsStatus;
#[doc(hidden)]
pub type UpdatePackageVersionsStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdatePackageVersionsStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePackageVersionsStatus`](crate::operation::UpdatePackageVersionsStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePackageVersionsStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdatePackageVersionsStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/package/versions/update_status")
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UpdatePackageVersionsStatusInput,
            mut output: &mut String,
        ) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_134) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_134));
            }
            if let Some(inner_135) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_135),
                );
            }
            if let Some(inner_136) = &_input.repository {
                query.push_kv(
                    "repository",
                    &aws_smithy_http::query::fmt_string(&inner_136),
                );
            }
            if let Some(inner_137) = &_input.format {
                query.push_kv("format", &aws_smithy_http::query::fmt_string(&inner_137));
            }
            if let Some(inner_138) = &_input.namespace {
                query.push_kv("namespace", &aws_smithy_http::query::fmt_string(&inner_138));
            }
            if let Some(inner_139) = &_input.package {
                query.push_kv("package", &aws_smithy_http::query::fmt_string(&inner_139));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdatePackageVersionsStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdatePackageVersionsStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_package_versions_status(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePackageVersionsStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePackageVersionsStatus",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdatePackageVersionsStatusInput`](crate::input::UpdatePackageVersionsStatusInput)
    pub fn builder() -> crate::input::update_package_versions_status_input::Builder {
        crate::input::update_package_versions_status_input::Builder::default()
    }
}

/// See [`UpdateRepositoryInput`](crate::input::UpdateRepositoryInput)
pub mod update_repository_input {
    /// A builder for [`UpdateRepositoryInput`](crate::input::UpdateRepositoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_owner: std::option::Option<std::string::String>,
        pub(crate) repository: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) upstreams: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
    }
    impl Builder {
        /// <p>
        /// The name of the domain associated with the repository to update.
        /// </p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>
        /// The name of the domain associated with the repository to update.
        /// </p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn domain_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_owner = Some(input.into());
            self
        }
        /// <p>
        /// The 12-digit account number of the AWS account that owns the domain. It does not include
        /// dashes or spaces.
        /// </p>
        pub fn set_domain_owner(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_owner = input;
            self
        }
        /// <p>
        /// The name of the repository to update.
        /// </p>
        pub fn repository(mut self, input: impl Into<std::string::String>) -> Self {
            self.repository = Some(input.into());
            self
        }
        /// <p>
        /// The name of the repository to update.
        /// </p>
        pub fn set_repository(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.repository = input;
            self
        }
        /// <p>
        /// An updated repository description.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// An updated repository description.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `upstreams`.
        ///
        /// To override the contents of this collection use [`set_upstreams`](Self::set_upstreams).
        ///
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn upstreams(mut self, input: impl Into<crate::model::UpstreamRepository>) -> Self {
            let mut v = self.upstreams.unwrap_or_default();
            v.push(input.into());
            self.upstreams = Some(v);
            self
        }
        /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
        /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
        /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
        pub fn set_upstreams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
        ) -> Self {
            self.upstreams = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRepositoryInput`](crate::input::UpdateRepositoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRepositoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRepositoryInput {
                domain: self.domain,
                domain_owner: self.domain_owner,
                repository: self.repository,
                description: self.description,
                upstreams: self.upstreams,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRepositoryInputOperationOutputAlias = crate::operation::UpdateRepository;
#[doc(hidden)]
pub type UpdateRepositoryInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateRepositoryInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRepository`](crate::operation::UpdateRepository)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRepository,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateRepositoryInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/repository").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::UpdateRepositoryInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_140) = &_input.domain {
                query.push_kv("domain", &aws_smithy_http::query::fmt_string(&inner_140));
            }
            if let Some(inner_141) = &_input.domain_owner {
                query.push_kv(
                    "domain-owner",
                    &aws_smithy_http::query::fmt_string(&inner_141),
                );
            }
            if let Some(inner_142) = &_input.repository {
                query.push_kv(
                    "repository",
                    &aws_smithy_http::query::fmt_string(&inner_142),
                );
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateRepositoryInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateRepositoryInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_repository(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRepository::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRepository",
            "codeartifact",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateRepositoryInput`](crate::input::UpdateRepositoryInput)
    pub fn builder() -> crate::input::update_repository_input::Builder {
        crate::input::update_repository_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRepositoryInput {
    /// <p>
    /// The name of the domain associated with the repository to update.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository to update.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// An updated repository description.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
    /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
    /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    pub upstreams: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
}
impl UpdateRepositoryInput {
    /// <p>
    /// The name of the domain associated with the repository to update.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository to update.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// An updated repository description.
    /// </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
    /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
    /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    pub fn upstreams(&self) -> std::option::Option<&[crate::model::UpstreamRepository]> {
        self.upstreams.as_deref()
    }
}
impl std::fmt::Debug for UpdateRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRepositoryInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("description", &self.description);
        formatter.field("upstreams", &self.upstreams);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePackageVersionsStatusInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package versions with a status to be updated.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The repository that contains the package versions with the status you want to update.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// A format that specifies the type of the package with the statuses to update. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package with the version statuses to update.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// An array of strings that specify the versions of the package with the statuses to update.
    /// </p>
    pub versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A map of package versions and package version revisions. The map <code>key</code> is the
    /// package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the
    /// package version revision. </p>
    pub version_revisions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p> The package version’s expected status before it is updated. If
    /// <code>expectedStatus</code> is provided, the package version's status is updated only if its
    /// status at the time <code>UpdatePackageVersionsStatus</code> is called matches
    /// <code>expectedStatus</code>. </p>
    pub expected_status: std::option::Option<crate::model::PackageVersionStatus>,
    /// <p>
    /// The status you want to change the package version status to.
    /// </p>
    pub target_status: std::option::Option<crate::model::PackageVersionStatus>,
}
impl UpdatePackageVersionsStatusInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package versions with a status to be updated.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The repository that contains the package versions with the status you want to update.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// A format that specifies the type of the package with the statuses to update. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package with the version statuses to update.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// An array of strings that specify the versions of the package with the statuses to update.
    /// </p>
    pub fn versions(&self) -> std::option::Option<&[std::string::String]> {
        self.versions.as_deref()
    }
    /// <p> A map of package versions and package version revisions. The map <code>key</code> is the
    /// package version (for example, <code>3.5.2</code>), and the map <code>value</code> is the
    /// package version revision. </p>
    pub fn version_revisions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.version_revisions.as_ref()
    }
    /// <p> The package version’s expected status before it is updated. If
    /// <code>expectedStatus</code> is provided, the package version's status is updated only if its
    /// status at the time <code>UpdatePackageVersionsStatus</code> is called matches
    /// <code>expectedStatus</code>. </p>
    pub fn expected_status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.expected_status.as_ref()
    }
    /// <p>
    /// The status you want to change the package version status to.
    /// </p>
    pub fn target_status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.target_status.as_ref()
    }
}
impl std::fmt::Debug for UpdatePackageVersionsStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePackageVersionsStatusInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("versions", &self.versions);
        formatter.field("version_revisions", &self.version_revisions);
        formatter.field("expected_status", &self.expected_status);
        formatter.field("target_status", &self.target_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag key for each tag that you want to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to remove tags from.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag key for each tag that you want to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags you want to modify or add to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource that you want to add or update tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags you want to modify or add to the resource.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutRepositoryPermissionsPolicyInput {
    /// <p>
    /// The name of the domain containing the repository to set the resource policy on.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p> The name of the repository to set the resource policy on. </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// Sets the revision of the resource policy that specifies permissions to access the repository.
    /// This revision is used for optimistic locking, which prevents others from overwriting your
    /// changes to the repository's resource policy.
    /// </p>
    pub policy_revision: std::option::Option<std::string::String>,
    /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
    /// policy on the provided repository. </p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl PutRepositoryPermissionsPolicyInput {
    /// <p>
    /// The name of the domain containing the repository to set the resource policy on.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p> The name of the repository to set the resource policy on. </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// Sets the revision of the resource policy that specifies permissions to access the repository.
    /// This revision is used for optimistic locking, which prevents others from overwriting your
    /// changes to the repository's resource policy.
    /// </p>
    pub fn policy_revision(&self) -> std::option::Option<&str> {
        self.policy_revision.as_deref()
    }
    /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
    /// policy on the provided repository. </p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for PutRepositoryPermissionsPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutRepositoryPermissionsPolicyInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("policy_revision", &self.policy_revision);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutDomainPermissionsPolicyInput {
    /// <p>
    /// The name of the domain on which to set the resource policy.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The current revision of the resource policy to be set. This revision is used for optimistic locking, which
    /// prevents others from overwriting your changes to the domain's resource policy.
    /// </p>
    pub policy_revision: std::option::Option<std::string::String>,
    /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
    /// policy on the provided domain. </p>
    pub policy_document: std::option::Option<std::string::String>,
}
impl PutDomainPermissionsPolicyInput {
    /// <p>
    /// The name of the domain on which to set the resource policy.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The current revision of the resource policy to be set. This revision is used for optimistic locking, which
    /// prevents others from overwriting your changes to the domain's resource policy.
    /// </p>
    pub fn policy_revision(&self) -> std::option::Option<&str> {
        self.policy_revision.as_deref()
    }
    /// <p> A valid displayable JSON Aspen policy string to be set as the access control resource
    /// policy on the provided domain. </p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
}
impl std::fmt::Debug for PutDomainPermissionsPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutDomainPermissionsPolicyInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("policy_revision", &self.policy_revision);
        formatter.field("policy_document", &self.policy_document);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource to get tags for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesInDomainInput {
    /// <p>
    /// The name of the domain that contains the returned list of repositories.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// Filter the list of repositories to only include those that are managed by the AWS account ID.
    /// </p>
    pub administrator_account: std::option::Option<std::string::String>,
    /// <p>
    /// A prefix used to filter returned repositories. Only repositories with names that start with
    /// <code>repositoryPrefix</code> are returned.
    /// </p>
    pub repository_prefix: std::option::Option<std::string::String>,
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRepositoriesInDomainInput {
    /// <p>
    /// The name of the domain that contains the returned list of repositories.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// Filter the list of repositories to only include those that are managed by the AWS account ID.
    /// </p>
    pub fn administrator_account(&self) -> std::option::Option<&str> {
        self.administrator_account.as_deref()
    }
    /// <p>
    /// A prefix used to filter returned repositories. Only repositories with names that start with
    /// <code>repositoryPrefix</code> are returned.
    /// </p>
    pub fn repository_prefix(&self) -> std::option::Option<&str> {
        self.repository_prefix.as_deref()
    }
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRepositoriesInDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesInDomainInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("administrator_account", &self.administrator_account);
        formatter.field("repository_prefix", &self.repository_prefix);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRepositoriesInput {
    /// <p> A prefix used to filter returned repositories. Only repositories with names that start
    /// with <code>repositoryPrefix</code> are returned.</p>
    pub repository_prefix: std::option::Option<std::string::String>,
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRepositoriesInput {
    /// <p> A prefix used to filter returned repositories. Only repositories with names that start
    /// with <code>repositoryPrefix</code> are returned.</p>
    pub fn repository_prefix(&self) -> std::option::Option<&str> {
        self.repository_prefix.as_deref()
    }
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRepositoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRepositoriesInput");
        formatter.field("repository_prefix", &self.repository_prefix);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the returned package versions.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository that contains the package.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The format of the returned packages. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package for which you want to return a list of package versions.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// A string that specifies the status of the package versions to include in the returned list. It can be one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::PackageVersionStatus>,
    /// <p>
    /// How to sort the returned list of package versions.
    /// </p>
    pub sort_by: std::option::Option<crate::model::PackageVersionSortType>,
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the returned package versions.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository that contains the package.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The format of the returned packages. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package for which you want to return a list of package versions.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// A string that specifies the status of the package versions to include in the returned list. It can be one of the following:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.status.as_ref()
    }
    /// <p>
    /// How to sort the returned list of package versions.
    /// </p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::PackageVersionSortType> {
        self.sort_by.as_ref()
    }
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackageVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageVersionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("status", &self.status);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageVersionDependenciesInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the requested package version dependencies.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository that contains the requested package version.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The format of the package with the requested dependencies. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package versions' package.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackageVersionDependenciesInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the requested package version dependencies.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository that contains the requested package version.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The format of the package with the requested dependencies. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package versions' package.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackageVersionDependenciesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageVersionDependenciesInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("package_version", &self.package_version);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackageVersionAssetsInput {
    /// <p>
    /// The name of the domain that contains the repository associated with the package version assets.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository that contains the package that contains the returned package version assets.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The format of the package that contains the returned package version assets. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that contains the returned package version assets.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackageVersionAssetsInput {
    /// <p>
    /// The name of the domain that contains the repository associated with the package version assets.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository that contains the package that contains the returned package version assets.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The format of the package that contains the returned package version assets. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package that contains the returned package version assets.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackageVersionAssetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackageVersionAssetsInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("package_version", &self.package_version);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPackagesInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the requested list of packages.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository from which packages are to be listed.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The format of the packages. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// A prefix used to filter returned packages. Only packages with names that start with
    /// <code>packagePrefix</code> are returned.
    /// </p>
    pub package_prefix: std::option::Option<std::string::String>,
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPackagesInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the requested list of packages.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository from which packages are to be listed.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The format of the packages. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// A prefix used to filter returned packages. Only packages with names that start with
    /// <code>packagePrefix</code> are returned.
    /// </p>
    pub fn package_prefix(&self) -> std::option::Option<&str> {
        self.package_prefix.as_deref()
    }
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPackagesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPackagesInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package_prefix", &self.package_prefix);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsInput {
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub max_results: std::option::Option<i32>,
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDomainsInput {
    /// <p>
    /// The maximum number of results to return per page.
    /// </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>
    /// The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
    /// </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryPermissionsPolicyInput {
    /// <p>
    /// The name of the domain containing the repository whose associated resource policy is to be retrieved.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository whose associated resource policy is to be retrieved.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
}
impl GetRepositoryPermissionsPolicyInput {
    /// <p>
    /// The name of the domain containing the repository whose associated resource policy is to be retrieved.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository whose associated resource policy is to be retrieved.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
}
impl std::fmt::Debug for GetRepositoryPermissionsPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryPermissionsPolicyInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRepositoryEndpointInput {
    /// <p>
    /// The name of the domain that contains the repository.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// Returns which endpoint of a repository to return. A repository has one endpoint for each
    /// package format:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
}
impl GetRepositoryEndpointInput {
    /// <p>
    /// The name of the domain that contains the repository.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// Returns which endpoint of a repository to return. A repository has one endpoint for each
    /// package format:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
}
impl std::fmt::Debug for GetRepositoryEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRepositoryEndpointInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPackageVersionReadmeInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package version with the requested readme file.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The repository that contains the package with the requested readme file.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// A format that specifies the type of the package version with the requested readme file. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package version that contains the requested readme file.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub package_version: std::option::Option<std::string::String>,
}
impl GetPackageVersionReadmeInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package version with the requested readme file.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The repository that contains the package with the requested readme file.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// A format that specifies the type of the package version with the requested readme file. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package version that contains the requested readme file.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
}
impl std::fmt::Debug for GetPackageVersionReadmeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionReadmeInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("package_version", &self.package_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPackageVersionAssetInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package version with the requested asset.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The repository that contains the package version with the requested asset.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// A format that specifies the type of the package version with the requested asset file. The valid values are:
    /// </p>    
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that contains the requested asset.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub package_version: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the requested asset.
    /// </p>
    pub asset: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package version revision that contains the requested asset.
    /// </p>
    pub package_version_revision: std::option::Option<std::string::String>,
}
impl GetPackageVersionAssetInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package version with the requested asset.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The repository that contains the package version with the requested asset.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// A format that specifies the type of the package version with the requested asset file. The valid values are:
    /// </p>    
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package that contains the requested asset.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
    /// <p>
    /// The name of the requested asset.
    /// </p>
    pub fn asset(&self) -> std::option::Option<&str> {
        self.asset.as_deref()
    }
    /// <p>
    /// The name of the package version revision that contains the requested asset.
    /// </p>
    pub fn package_version_revision(&self) -> std::option::Option<&str> {
        self.package_version_revision.as_deref()
    }
}
impl std::fmt::Debug for GetPackageVersionAssetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPackageVersionAssetInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("package_version", &self.package_version);
        formatter.field("asset", &self.asset);
        formatter.field("package_version_revision", &self.package_version_revision);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainPermissionsPolicyInput {
    /// <p>
    /// The name of the domain to which the resource policy is attached.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
}
impl GetDomainPermissionsPolicyInput {
    /// <p>
    /// The name of the domain to which the resource policy is attached.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
}
impl std::fmt::Debug for GetDomainPermissionsPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainPermissionsPolicyInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAuthorizationTokenInput {
    /// <p>
    /// The name of the domain that is in scope for the generated authorization token.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are
    /// <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours).
    /// A value of <code>0</code> will set the expiration of the authorization token to the same expiration of
    /// the user's role's temporary credentials.</p>
    pub duration_seconds: std::option::Option<i64>,
}
impl GetAuthorizationTokenInput {
    /// <p>
    /// The name of the domain that is in scope for the generated authorization token.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>The time, in seconds, that the generated authorization token is valid. Valid values are
    /// <code>0</code> and any number between <code>900</code> (15 minutes) and <code>43200</code> (12 hours).
    /// A value of <code>0</code> will set the expiration of the authorization token to the same expiration of
    /// the user's role's temporary credentials.</p>
    pub fn duration_seconds(&self) -> std::option::Option<i64> {
        self.duration_seconds
    }
}
impl std::fmt::Debug for GetAuthorizationTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAuthorizationTokenInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisposePackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the repository you want to dispose.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository that contains the package versions you want to dispose.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// A format that specifies the type of package versions you want to dispose. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package with the versions you want to dispose.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// The versions of the package you want to dispose.
    /// </p>
    pub versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// The revisions of the package versions you want to dispose.
    /// </p>
    pub version_revisions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>
    /// The expected status of the package version to dispose. Valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub expected_status: std::option::Option<crate::model::PackageVersionStatus>,
}
impl DisposePackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the repository you want to dispose.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository that contains the package versions you want to dispose.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// A format that specifies the type of package versions you want to dispose. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package with the versions you want to dispose.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// The versions of the package you want to dispose.
    /// </p>
    pub fn versions(&self) -> std::option::Option<&[std::string::String]> {
        self.versions.as_deref()
    }
    /// <p>
    /// The revisions of the package versions you want to dispose.
    /// </p>
    pub fn version_revisions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.version_revisions.as_ref()
    }
    /// <p>
    /// The expected status of the package version to dispose. Valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn expected_status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.expected_status.as_ref()
    }
}
impl std::fmt::Debug for DisposePackageVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisposePackageVersionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("versions", &self.versions);
        formatter.field("version_revisions", &self.version_revisions);
        formatter.field("expected_status", &self.expected_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateExternalConnectionInput {
    /// <p>The name of the domain that contains the repository from which to remove the external
    /// repository. </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>The name of the repository from which the external connection will be removed. </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>The name of the external connection to be removed from the repository. </p>
    pub external_connection: std::option::Option<std::string::String>,
}
impl DisassociateExternalConnectionInput {
    /// <p>The name of the domain that contains the repository from which to remove the external
    /// repository. </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>The name of the repository from which the external connection will be removed. </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>The name of the external connection to be removed from the repository. </p>
    pub fn external_connection(&self) -> std::option::Option<&str> {
        self.external_connection.as_deref()
    }
}
impl std::fmt::Debug for DisassociateExternalConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateExternalConnectionInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("external_connection", &self.external_connection);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRepositoryInput {
    /// <p>
    /// The name of the domain that contains the repository to describe.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// A string that specifies the name of the requested repository.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
}
impl DescribeRepositoryInput {
    /// <p>
    /// The name of the domain that contains the repository to describe.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// A string that specifies the name of the requested repository.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
}
impl std::fmt::Debug for DescribeRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRepositoryInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePackageVersionInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package version.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p> The name of the repository that contains the package version. </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// A format that specifies the type of the requested package version. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p> The name of the requested package version. </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub package_version: std::option::Option<std::string::String>,
}
impl DescribePackageVersionInput {
    /// <p>
    /// The name of the domain that contains the repository that contains the package version.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p> The name of the repository that contains the package version. </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// A format that specifies the type of the requested package version. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p> The name of the requested package version. </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// A string that contains the package version (for example, <code>3.5.2</code>).
    /// </p>
    pub fn package_version(&self) -> std::option::Option<&str> {
        self.package_version.as_deref()
    }
}
impl std::fmt::Debug for DescribePackageVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePackageVersionInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("package_version", &self.package_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDomainInput {
    /// <p>
    /// A string that specifies the name of the requested domain.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
}
impl DescribeDomainInput {
    /// <p>
    /// A string that specifies the name of the requested domain.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
}
impl std::fmt::Debug for DescribeDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDomainInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryPermissionsPolicyInput {
    /// <p>
    /// The name of the domain that contains the repository associated with the resource policy to be deleted.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository that is associated with the resource policy to be deleted
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which
    /// prevents others from accidentally overwriting your changes to the repository's resource policy.
    /// </p>
    pub policy_revision: std::option::Option<std::string::String>,
}
impl DeleteRepositoryPermissionsPolicyInput {
    /// <p>
    /// The name of the domain that contains the repository associated with the resource policy to be deleted.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository that is associated with the resource policy to be deleted
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which
    /// prevents others from accidentally overwriting your changes to the repository's resource policy.
    /// </p>
    pub fn policy_revision(&self) -> std::option::Option<&str> {
        self.policy_revision.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryPermissionsPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryPermissionsPolicyInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("policy_revision", &self.policy_revision);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRepositoryInput {
    /// <p>
    /// The name of the domain that contains the repository to delete.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p> The name of the repository to delete. </p>
    pub repository: std::option::Option<std::string::String>,
}
impl DeleteRepositoryInput {
    /// <p>
    /// The name of the domain that contains the repository to delete.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p> The name of the repository to delete. </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
}
impl std::fmt::Debug for DeleteRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRepositoryInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the package to delete.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository that contains the package versions to delete.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The format of the package versions to delete. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package with the versions to delete.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// An array of strings that specify the versions of the package to delete.
    /// </p>
    pub versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// The expected status of the package version to delete. Valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub expected_status: std::option::Option<crate::model::PackageVersionStatus>,
}
impl DeletePackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the package to delete.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository that contains the package versions to delete.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The format of the package versions to delete. The valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package with the versions to delete.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// An array of strings that specify the versions of the package to delete.
    /// </p>
    pub fn versions(&self) -> std::option::Option<&[std::string::String]> {
        self.versions.as_deref()
    }
    /// <p>
    /// The expected status of the package version to delete. Valid values are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Published</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unfinished</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unlisted</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Archived</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Disposed</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn expected_status(&self) -> std::option::Option<&crate::model::PackageVersionStatus> {
        self.expected_status.as_ref()
    }
}
impl std::fmt::Debug for DeletePackageVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePackageVersionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("versions", &self.versions);
        formatter.field("expected_status", &self.expected_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainPermissionsPolicyInput {
    /// <p>
    /// The name of the domain associated with the resource policy to be deleted.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which
    /// prevents others from overwriting your changes to the domain's resource policy.
    /// </p>
    pub policy_revision: std::option::Option<std::string::String>,
}
impl DeleteDomainPermissionsPolicyInput {
    /// <p>
    /// The name of the domain associated with the resource policy to be deleted.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which
    /// prevents others from overwriting your changes to the domain's resource policy.
    /// </p>
    pub fn policy_revision(&self) -> std::option::Option<&str> {
        self.policy_revision.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainPermissionsPolicyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainPermissionsPolicyInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("policy_revision", &self.policy_revision);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainInput {
    /// <p>
    /// The name of the domain to delete.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
}
impl DeleteDomainInput {
    /// <p>
    /// The name of the domain to delete.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRepositoryInput {
    /// <p>
    /// The name of the domain that contains the created repository.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p> The name of the repository to create. </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// A description of the created repository.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
    /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
    /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    pub upstreams: std::option::Option<std::vec::Vec<crate::model::UpstreamRepository>>,
    /// <p>One or more tag key-value pairs for the repository.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateRepositoryInput {
    /// <p>
    /// The name of the domain that contains the created repository.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p> The name of the repository to create. </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// A description of the created repository.
    /// </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p> A list of upstream repositories to associate with the repository. The order of the upstream repositories
    /// in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more
    /// information, see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with upstream repositories</a>. </p>
    pub fn upstreams(&self) -> std::option::Option<&[crate::model::UpstreamRepository]> {
        self.upstreams.as_deref()
    }
    /// <p>One or more tag key-value pairs for the repository.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateRepositoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRepositoryInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("description", &self.description);
        formatter.field("upstreams", &self.upstreams);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainInput {
    /// <p> The name of the domain to create. All domain names in an AWS Region that are in the
    /// same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do
    /// not use sensitive information in a domain name because it is publicly discoverable. </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain.
    /// An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key
    /// alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have
    /// <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption
    /// key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i>
    /// and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions
    /// Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
    /// <important>
    /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your
    /// domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric
    /// keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
    /// </important>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>One or more tag key-value pairs for the domain.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateDomainInput {
    /// <p> The name of the domain to create. All domain names in an AWS Region that are in the
    /// same AWS account must be unique. The domain name is used as the prefix in DNS hostnames. Do
    /// not use sensitive information in a domain name because it is publicly discoverable. </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p> The encryption key for the domain. This is used to encrypt content stored in a domain.
    /// An encryption key can be a key ID, a key Amazon Resource Name (ARN), a key alias, or a key
    /// alias ARN. To specify an <code>encryptionKey</code>, your IAM role must have
    /// <code>kms:DescribeKey</code> and <code>kms:CreateGrant</code> permissions on the encryption
    /// key that is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestSyntax">DescribeKey</a> in the <i>AWS Key Management Service API Reference</i>
    /// and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html">AWS KMS API Permissions
    /// Reference</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
    /// <important>
    /// <p> CodeArtifact supports only symmetric CMKs. Do not associate an asymmetric CMK with your
    /// domain. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric
    /// keys</a> in the <i>AWS Key Management Service Developer Guide</i>. </p>
    /// </important>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>One or more tag key-value pairs for the domain.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainInput");
        formatter.field("domain", &self.domain);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyPackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the source and destination repositories.
    /// </p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository that contains the package versions to copy.
    /// </p>
    pub source_repository: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository into which package versions are copied.
    /// </p>
    pub destination_repository: std::option::Option<std::string::String>,
    /// <p>
    /// The format of the package that is copied. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub format: std::option::Option<crate::model::PackageFormat>,
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the package that is copied.
    /// </p>
    pub package: std::option::Option<std::string::String>,
    /// <p>
    /// The versions of the package to copy.
    /// </p>
    /// <note>
    /// <p>
    /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
    /// </p>
    /// </note>
    pub versions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation
    /// succeeds if the specified versions in the source repository match the specified package version revision.
    /// </p>
    /// <note>
    /// <p>
    /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
    /// </p>
    /// </note>
    pub version_revisions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>
    /// Set to true to overwrite a package version that already exists in the destination repository.
    /// If set to false and the package version already exists in the destination repository,
    /// the package version is returned in the <code>failedVersions</code> field of the response with
    /// an <code>ALREADY_EXISTS</code> error code.
    /// </p>
    pub allow_overwrite: std::option::Option<bool>,
    /// <p> Set to true to copy packages from repositories that are upstream from the source
    /// repository to the destination repository. The default setting is false. For more information,
    /// see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
    /// upstream repositories</a>. </p>
    pub include_from_upstream: std::option::Option<bool>,
}
impl CopyPackageVersionsInput {
    /// <p>
    /// The name of the domain that contains the source and destination repositories.
    /// </p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository that contains the package versions to copy.
    /// </p>
    pub fn source_repository(&self) -> std::option::Option<&str> {
        self.source_repository.as_deref()
    }
    /// <p>
    /// The name of the repository into which package versions are copied.
    /// </p>
    pub fn destination_repository(&self) -> std::option::Option<&str> {
        self.destination_repository.as_deref()
    }
    /// <p>
    /// The format of the package that is copied. The valid package types are:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>npm</code>: A Node Package Manager (npm) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pypi</code>: A Python Package Index (PyPI) package.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>maven</code>: A Maven package that contains compiled code in a distributable format, such as a JAR file.
    /// </p>
    /// </li>
    /// </ul>
    pub fn format(&self) -> std::option::Option<&crate::model::PackageFormat> {
        self.format.as_ref()
    }
    /// <p>
    /// The namespace of the package. The package component that specifies its
    /// namespace depends on its type. For example:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// The namespace of a Maven package is its <code>groupId</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// The namespace of an npm package is its <code>scope</code>.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// A Python package does not contain a corresponding component, so
    /// Python packages do not have a namespace.
    /// </p>
    /// </li>
    /// </ul>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>
    /// The name of the package that is copied.
    /// </p>
    pub fn package(&self) -> std::option::Option<&str> {
        self.package.as_deref()
    }
    /// <p>
    /// The versions of the package to copy.
    /// </p>
    /// <note>
    /// <p>
    /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
    /// </p>
    /// </note>
    pub fn versions(&self) -> std::option::Option<&[std::string::String]> {
        self.versions.as_deref()
    }
    /// <p>
    /// A list of key-value pairs. The keys are package versions and the values are package version revisions. A <code>CopyPackageVersion</code> operation
    /// succeeds if the specified versions in the source repository match the specified package version revision.
    /// </p>
    /// <note>
    /// <p>
    /// You must specify <code>versions</code> or <code>versionRevisions</code>. You cannot specify both.
    /// </p>
    /// </note>
    pub fn version_revisions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.version_revisions.as_ref()
    }
    /// <p>
    /// Set to true to overwrite a package version that already exists in the destination repository.
    /// If set to false and the package version already exists in the destination repository,
    /// the package version is returned in the <code>failedVersions</code> field of the response with
    /// an <code>ALREADY_EXISTS</code> error code.
    /// </p>
    pub fn allow_overwrite(&self) -> std::option::Option<bool> {
        self.allow_overwrite
    }
    /// <p> Set to true to copy packages from repositories that are upstream from the source
    /// repository to the destination repository. The default setting is false. For more information,
    /// see <a href="https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html">Working with
    /// upstream repositories</a>. </p>
    pub fn include_from_upstream(&self) -> std::option::Option<bool> {
        self.include_from_upstream
    }
}
impl std::fmt::Debug for CopyPackageVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyPackageVersionsInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("source_repository", &self.source_repository);
        formatter.field("destination_repository", &self.destination_repository);
        formatter.field("format", &self.format);
        formatter.field("namespace", &self.namespace);
        formatter.field("package", &self.package);
        formatter.field("versions", &self.versions);
        formatter.field("version_revisions", &self.version_revisions);
        formatter.field("allow_overwrite", &self.allow_overwrite);
        formatter.field("include_from_upstream", &self.include_from_upstream);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateExternalConnectionInput {
    /// <p>The name of the domain that contains the repository.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub domain_owner: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the repository to which the external connection is added.
    /// </p>
    pub repository: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the external connection to add to the repository. The following values are supported:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>public:npmjs</code> - for the npm public repository.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:pypi</code> - for the Python Package Index.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-central</code> - for Maven Central.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-googleandroid</code> - for the Google Android repository.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
    /// </p>
    /// </li>
    /// </ul>
    pub external_connection: std::option::Option<std::string::String>,
}
impl AssociateExternalConnectionInput {
    /// <p>The name of the domain that contains the repository.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>
    /// The 12-digit account number of the AWS account that owns the domain. It does not include
    /// dashes or spaces.
    /// </p>
    pub fn domain_owner(&self) -> std::option::Option<&str> {
        self.domain_owner.as_deref()
    }
    /// <p>
    /// The name of the repository to which the external connection is added.
    /// </p>
    pub fn repository(&self) -> std::option::Option<&str> {
        self.repository.as_deref()
    }
    /// <p>
    /// The name of the external connection to add to the repository. The following values are supported:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>public:npmjs</code> - for the npm public repository.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:pypi</code> - for the Python Package Index.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-central</code> - for Maven Central.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-googleandroid</code> - for the Google Android repository.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-gradleplugins</code> - for the Gradle plugins repository.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>public:maven-commonsware</code> - for the CommonsWare Android repository.
    /// </p>
    /// </li>
    /// </ul>
    pub fn external_connection(&self) -> std::option::Option<&str> {
        self.external_connection.as_deref()
    }
}
impl std::fmt::Debug for AssociateExternalConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateExternalConnectionInput");
        formatter.field("domain", &self.domain);
        formatter.field("domain_owner", &self.domain_owner);
        formatter.field("repository", &self.repository);
        formatter.field("external_connection", &self.external_connection);
        formatter.finish()
    }
}
