// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudWatch Logs
///
/// Client for invoking operations on Amazon CloudWatch Logs. Each operation on Amazon CloudWatch Logs is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloudwatchlogs::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloudwatchlogs::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloudwatchlogs::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateKmsKey`](crate::client::fluent_builders::AssociateKmsKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::AssociateKmsKey::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::AssociateKmsKey::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::AssociateKmsKey::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::AssociateKmsKey::set_kms_key_id): <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. This must be a symmetric CMK. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p>
    /// - On success, responds with [`AssociateKmsKeyOutput`](crate::output::AssociateKmsKeyOutput)

    /// - On failure, responds with [`SdkError<AssociateKmsKeyError>`](crate::error::AssociateKmsKeyError)
    pub fn associate_kms_key(&self) -> fluent_builders::AssociateKmsKey {
        fluent_builders::AssociateKmsKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelExportTask`](crate::client::fluent_builders::CancelExportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::CancelExportTask::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::CancelExportTask::set_task_id): <p>The ID of the export task.</p>
    /// - On success, responds with [`CancelExportTaskOutput`](crate::output::CancelExportTaskOutput)

    /// - On failure, responds with [`SdkError<CancelExportTaskError>`](crate::error::CancelExportTaskError)
    pub fn cancel_export_task(&self) -> fluent_builders::CancelExportTask {
        fluent_builders::CancelExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateExportTask`](crate::client::fluent_builders::CreateExportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_name(impl Into<String>)`](crate::client::fluent_builders::CreateExportTask::task_name) / [`set_task_name(Option<String>)`](crate::client::fluent_builders::CreateExportTask::set_task_name): <p>The name of the export task.</p>
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateExportTask::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::CreateExportTask::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`log_stream_name_prefix(impl Into<String>)`](crate::client::fluent_builders::CreateExportTask::log_stream_name_prefix) / [`set_log_stream_name_prefix(Option<String>)`](crate::client::fluent_builders::CreateExportTask::set_log_stream_name_prefix): <p>Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is applied.</p>
    ///   - [`from(i64)`](crate::client::fluent_builders::CreateExportTask::from) / [`set_from(Option<i64>)`](crate::client::fluent_builders::CreateExportTask::set_from): <p>The start time of the range for the request, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp earlier than this time are not exported.</p>
    ///   - [`to(i64)`](crate::client::fluent_builders::CreateExportTask::to) / [`set_to(Option<i64>)`](crate::client::fluent_builders::CreateExportTask::set_to): <p>The end time of the range for the request, expreswatchlogsdocused as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not exported.</p>
    ///   - [`destination(impl Into<String>)`](crate::client::fluent_builders::CreateExportTask::destination) / [`set_destination(Option<String>)`](crate::client::fluent_builders::CreateExportTask::set_destination): <p>The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services region.</p>
    ///   - [`destination_prefix(impl Into<String>)`](crate::client::fluent_builders::CreateExportTask::destination_prefix) / [`set_destination_prefix(Option<String>)`](crate::client::fluent_builders::CreateExportTask::set_destination_prefix): <p>The prefix used as the start of the key for every object exported. If you don't specify a value, the default is <code>exportedlogs</code>.</p>
    /// - On success, responds with [`CreateExportTaskOutput`](crate::output::CreateExportTaskOutput) with field(s):
    ///   - [`task_id(Option<String>)`](crate::output::CreateExportTaskOutput::task_id): <p>The ID of the export task.</p>
    /// - On failure, responds with [`SdkError<CreateExportTaskError>`](crate::error::CreateExportTaskError)
    pub fn create_export_task(&self) -> fluent_builders::CreateExportTask {
        fluent_builders::CreateExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLogGroup`](crate::client::fluent_builders::CreateLogGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateLogGroup::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::CreateLogGroup::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateLogGroup::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateLogGroup::set_kms_key_id): <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateLogGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateLogGroup::set_tags): <p>The key-value pairs to use for the tags.</p>  <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>
    /// - On success, responds with [`CreateLogGroupOutput`](crate::output::CreateLogGroupOutput)

    /// - On failure, responds with [`SdkError<CreateLogGroupError>`](crate::error::CreateLogGroupError)
    pub fn create_log_group(&self) -> fluent_builders::CreateLogGroup {
        fluent_builders::CreateLogGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLogStream`](crate::client::fluent_builders::CreateLogStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateLogStream::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::CreateLogStream::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`log_stream_name(impl Into<String>)`](crate::client::fluent_builders::CreateLogStream::log_stream_name) / [`set_log_stream_name(Option<String>)`](crate::client::fluent_builders::CreateLogStream::set_log_stream_name): <p>The name of the log stream.</p>
    /// - On success, responds with [`CreateLogStreamOutput`](crate::output::CreateLogStreamOutput)

    /// - On failure, responds with [`SdkError<CreateLogStreamError>`](crate::error::CreateLogStreamError)
    pub fn create_log_stream(&self) -> fluent_builders::CreateLogStream {
        fluent_builders::CreateLogStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDestination`](crate::client::fluent_builders::DeleteDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDestination::destination_name) / [`set_destination_name(Option<String>)`](crate::client::fluent_builders::DeleteDestination::set_destination_name): <p>The name of the destination.</p>
    /// - On success, responds with [`DeleteDestinationOutput`](crate::output::DeleteDestinationOutput)

    /// - On failure, responds with [`SdkError<DeleteDestinationError>`](crate::error::DeleteDestinationError)
    pub fn delete_destination(&self) -> fluent_builders::DeleteDestination {
        fluent_builders::DeleteDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLogGroup`](crate::client::fluent_builders::DeleteLogGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLogGroup::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DeleteLogGroup::set_log_group_name): <p>The name of the log group.</p>
    /// - On success, responds with [`DeleteLogGroupOutput`](crate::output::DeleteLogGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteLogGroupError>`](crate::error::DeleteLogGroupError)
    pub fn delete_log_group(&self) -> fluent_builders::DeleteLogGroup {
        fluent_builders::DeleteLogGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLogStream`](crate::client::fluent_builders::DeleteLogStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLogStream::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DeleteLogStream::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`log_stream_name(impl Into<String>)`](crate::client::fluent_builders::DeleteLogStream::log_stream_name) / [`set_log_stream_name(Option<String>)`](crate::client::fluent_builders::DeleteLogStream::set_log_stream_name): <p>The name of the log stream.</p>
    /// - On success, responds with [`DeleteLogStreamOutput`](crate::output::DeleteLogStreamOutput)

    /// - On failure, responds with [`SdkError<DeleteLogStreamError>`](crate::error::DeleteLogStreamError)
    pub fn delete_log_stream(&self) -> fluent_builders::DeleteLogStream {
        fluent_builders::DeleteLogStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMetricFilter`](crate::client::fluent_builders::DeleteMetricFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteMetricFilter::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DeleteMetricFilter::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`filter_name(impl Into<String>)`](crate::client::fluent_builders::DeleteMetricFilter::filter_name) / [`set_filter_name(Option<String>)`](crate::client::fluent_builders::DeleteMetricFilter::set_filter_name): <p>The name of the metric filter.</p>
    /// - On success, responds with [`DeleteMetricFilterOutput`](crate::output::DeleteMetricFilterOutput)

    /// - On failure, responds with [`SdkError<DeleteMetricFilterError>`](crate::error::DeleteMetricFilterError)
    pub fn delete_metric_filter(&self) -> fluent_builders::DeleteMetricFilter {
        fluent_builders::DeleteMetricFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteQueryDefinition`](crate::client::fluent_builders::DeleteQueryDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_definition_id(impl Into<String>)`](crate::client::fluent_builders::DeleteQueryDefinition::query_definition_id) / [`set_query_definition_id(Option<String>)`](crate::client::fluent_builders::DeleteQueryDefinition::set_query_definition_id): <p>The ID of the query definition that you want to delete. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p>
    /// - On success, responds with [`DeleteQueryDefinitionOutput`](crate::output::DeleteQueryDefinitionOutput) with field(s):
    ///   - [`success(bool)`](crate::output::DeleteQueryDefinitionOutput::success): <p>A value of TRUE indicates that the operation succeeded. FALSE indicates that the operation failed.</p>
    /// - On failure, responds with [`SdkError<DeleteQueryDefinitionError>`](crate::error::DeleteQueryDefinitionError)
    pub fn delete_query_definition(&self) -> fluent_builders::DeleteQueryDefinition {
        fluent_builders::DeleteQueryDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteResourcePolicy`](crate::client::fluent_builders::DeleteResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::DeleteResourcePolicy::set_policy_name): <p>The name of the policy to be revoked. This parameter is required.</p>
    /// - On success, responds with [`DeleteResourcePolicyOutput`](crate::output::DeleteResourcePolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteResourcePolicyError>`](crate::error::DeleteResourcePolicyError)
    pub fn delete_resource_policy(&self) -> fluent_builders::DeleteResourcePolicy {
        fluent_builders::DeleteResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRetentionPolicy`](crate::client::fluent_builders::DeleteRetentionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRetentionPolicy::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DeleteRetentionPolicy::set_log_group_name): <p>The name of the log group.</p>
    /// - On success, responds with [`DeleteRetentionPolicyOutput`](crate::output::DeleteRetentionPolicyOutput)

    /// - On failure, responds with [`SdkError<DeleteRetentionPolicyError>`](crate::error::DeleteRetentionPolicyError)
    pub fn delete_retention_policy(&self) -> fluent_builders::DeleteRetentionPolicy {
        fluent_builders::DeleteRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSubscriptionFilter`](crate::client::fluent_builders::DeleteSubscriptionFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSubscriptionFilter::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DeleteSubscriptionFilter::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`filter_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSubscriptionFilter::filter_name) / [`set_filter_name(Option<String>)`](crate::client::fluent_builders::DeleteSubscriptionFilter::set_filter_name): <p>The name of the subscription filter.</p>
    /// - On success, responds with [`DeleteSubscriptionFilterOutput`](crate::output::DeleteSubscriptionFilterOutput)

    /// - On failure, responds with [`SdkError<DeleteSubscriptionFilterError>`](crate::error::DeleteSubscriptionFilterError)
    pub fn delete_subscription_filter(&self) -> fluent_builders::DeleteSubscriptionFilter {
        fluent_builders::DeleteSubscriptionFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDestinations`](crate::client::fluent_builders::DescribeDestinations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDestinations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_name_prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeDestinations::destination_name_prefix) / [`set_destination_name_prefix(Option<String>)`](crate::client::fluent_builders::DescribeDestinations::set_destination_name_prefix): <p>The prefix to match. If you don't specify a value, no prefix filter is applied.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDestinations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDestinations::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeDestinations::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeDestinations::set_limit): <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
    /// - On success, responds with [`DescribeDestinationsOutput`](crate::output::DescribeDestinationsOutput) with field(s):
    ///   - [`destinations(Option<Vec<Destination>>)`](crate::output::DescribeDestinationsOutput::destinations): <p>The destinations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDestinationsOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeDestinationsError>`](crate::error::DescribeDestinationsError)
    pub fn describe_destinations(&self) -> fluent_builders::DescribeDestinations {
        fluent_builders::DescribeDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExportTasks`](crate::client::fluent_builders::DescribeExportTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`task_id(impl Into<String>)`](crate::client::fluent_builders::DescribeExportTasks::task_id) / [`set_task_id(Option<String>)`](crate::client::fluent_builders::DescribeExportTasks::set_task_id): <p>The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.</p>
    ///   - [`status_code(ExportTaskStatusCode)`](crate::client::fluent_builders::DescribeExportTasks::status_code) / [`set_status_code(Option<ExportTaskStatusCode>)`](crate::client::fluent_builders::DescribeExportTasks::set_status_code): <p>The status code of the export task. Specifying a status code filters the results to zero or more export tasks.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeExportTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeExportTasks::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeExportTasks::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeExportTasks::set_limit): <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
    /// - On success, responds with [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput) with field(s):
    ///   - [`export_tasks(Option<Vec<ExportTask>>)`](crate::output::DescribeExportTasksOutput::export_tasks): <p>The export tasks.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeExportTasksOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeExportTasksError>`](crate::error::DescribeExportTasksError)
    pub fn describe_export_tasks(&self) -> fluent_builders::DescribeExportTasks {
        fluent_builders::DescribeExportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLogGroups`](crate::client::fluent_builders::DescribeLogGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLogGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name_prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeLogGroups::log_group_name_prefix) / [`set_log_group_name_prefix(Option<String>)`](crate::client::fluent_builders::DescribeLogGroups::set_log_group_name_prefix): <p>The prefix to match.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLogGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLogGroups::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeLogGroups::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeLogGroups::set_limit): <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
    /// - On success, responds with [`DescribeLogGroupsOutput`](crate::output::DescribeLogGroupsOutput) with field(s):
    ///   - [`log_groups(Option<Vec<LogGroup>>)`](crate::output::DescribeLogGroupsOutput::log_groups): <p>The log groups.</p>  <p>If the <code>retentionInDays</code> value if not included for a log group, then that log group is set to have its events never expire.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLogGroupsOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeLogGroupsError>`](crate::error::DescribeLogGroupsError)
    pub fn describe_log_groups(&self) -> fluent_builders::DescribeLogGroups {
        fluent_builders::DescribeLogGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLogStreams`](crate::client::fluent_builders::DescribeLogStreams) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeLogStreams::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeLogStreams::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DescribeLogStreams::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`log_stream_name_prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeLogStreams::log_stream_name_prefix) / [`set_log_stream_name_prefix(Option<String>)`](crate::client::fluent_builders::DescribeLogStreams::set_log_stream_name_prefix): <p>The prefix to match.</p>  <p>If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.</p>
    ///   - [`order_by(OrderBy)`](crate::client::fluent_builders::DescribeLogStreams::order_by) / [`set_order_by(Option<OrderBy>)`](crate::client::fluent_builders::DescribeLogStreams::set_order_by): <p>If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is <code>LastEventTime</code>, the results are ordered by the event time. The default value is <code>LogStreamName</code>.</p>  <p>If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.</p>  <p> <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. <code>lastEventTimestamp</code> updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.</p>
    ///   - [`descending(bool)`](crate::client::fluent_builders::DescribeLogStreams::descending) / [`set_descending(Option<bool>)`](crate::client::fluent_builders::DescribeLogStreams::set_descending): <p>If the value is true, results are returned in descending order. If the value is to false, results are returned in ascending order. The default value is false.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeLogStreams::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeLogStreams::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeLogStreams::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeLogStreams::set_limit): <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
    /// - On success, responds with [`DescribeLogStreamsOutput`](crate::output::DescribeLogStreamsOutput) with field(s):
    ///   - [`log_streams(Option<Vec<LogStream>>)`](crate::output::DescribeLogStreamsOutput::log_streams): <p>The log streams.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeLogStreamsOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeLogStreamsError>`](crate::error::DescribeLogStreamsError)
    pub fn describe_log_streams(&self) -> fluent_builders::DescribeLogStreams {
        fluent_builders::DescribeLogStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMetricFilters`](crate::client::fluent_builders::DescribeMetricFilters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMetricFilters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeMetricFilters::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DescribeMetricFilters::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`filter_name_prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeMetricFilters::filter_name_prefix) / [`set_filter_name_prefix(Option<String>)`](crate::client::fluent_builders::DescribeMetricFilters::set_filter_name_prefix): <p>The prefix to match. CloudWatch Logs uses the value you set here only if you also include the <code>logGroupName</code> parameter in your request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMetricFilters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMetricFilters::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeMetricFilters::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeMetricFilters::set_limit): <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
    ///   - [`metric_name(impl Into<String>)`](crate::client::fluent_builders::DescribeMetricFilters::metric_name) / [`set_metric_name(Option<String>)`](crate::client::fluent_builders::DescribeMetricFilters::set_metric_name): <p>Filters results to include only those with the specified metric name. If you include this parameter in your request, you must also include the <code>metricNamespace</code> parameter.</p>
    ///   - [`metric_namespace(impl Into<String>)`](crate::client::fluent_builders::DescribeMetricFilters::metric_namespace) / [`set_metric_namespace(Option<String>)`](crate::client::fluent_builders::DescribeMetricFilters::set_metric_namespace): <p>Filters results to include only those in the specified namespace. If you include this parameter in your request, you must also include the <code>metricName</code> parameter.</p>
    /// - On success, responds with [`DescribeMetricFiltersOutput`](crate::output::DescribeMetricFiltersOutput) with field(s):
    ///   - [`metric_filters(Option<Vec<MetricFilter>>)`](crate::output::DescribeMetricFiltersOutput::metric_filters): <p>The metric filters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMetricFiltersOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeMetricFiltersError>`](crate::error::DescribeMetricFiltersError)
    pub fn describe_metric_filters(&self) -> fluent_builders::DescribeMetricFilters {
        fluent_builders::DescribeMetricFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeQueries`](crate::client::fluent_builders::DescribeQueries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeQueries::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DescribeQueries::set_log_group_name): <p>Limits the returned queries to only those for the specified log group.</p>
    ///   - [`status(QueryStatus)`](crate::client::fluent_builders::DescribeQueries::status) / [`set_status(Option<QueryStatus>)`](crate::client::fluent_builders::DescribeQueries::set_status): <p>Limits the returned queries to only those that have the specified status. Valid values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>, <code>Running</code>, and <code>Scheduled</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeQueries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeQueries::set_max_results): <p>Limits the number of returned queries to the specified number.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeQueries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeQueries::set_next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On success, responds with [`DescribeQueriesOutput`](crate::output::DescribeQueriesOutput) with field(s):
    ///   - [`queries(Option<Vec<QueryInfo>>)`](crate::output::DescribeQueriesOutput::queries): <p>The list of queries that match the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeQueriesOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeQueriesError>`](crate::error::DescribeQueriesError)
    pub fn describe_queries(&self) -> fluent_builders::DescribeQueries {
        fluent_builders::DescribeQueries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeQueryDefinitions`](crate::client::fluent_builders::DescribeQueryDefinitions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_definition_name_prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeQueryDefinitions::query_definition_name_prefix) / [`set_query_definition_name_prefix(Option<String>)`](crate::client::fluent_builders::DescribeQueryDefinitions::set_query_definition_name_prefix): <p>Use this parameter to filter your results to only the query definitions that have names that start with the prefix you specify.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeQueryDefinitions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::DescribeQueryDefinitions::set_max_results): <p>Limits the number of returned query definitions to the specified number.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeQueryDefinitions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeQueryDefinitions::set_next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On success, responds with [`DescribeQueryDefinitionsOutput`](crate::output::DescribeQueryDefinitionsOutput) with field(s):
    ///   - [`query_definitions(Option<Vec<QueryDefinition>>)`](crate::output::DescribeQueryDefinitionsOutput::query_definitions): <p>The list of query definitions that match your request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeQueryDefinitionsOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeQueryDefinitionsError>`](crate::error::DescribeQueryDefinitionsError)
    pub fn describe_query_definitions(&self) -> fluent_builders::DescribeQueryDefinitions {
        fluent_builders::DescribeQueryDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResourcePolicies`](crate::client::fluent_builders::DescribeResourcePolicies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeResourcePolicies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeResourcePolicies::set_next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeResourcePolicies::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeResourcePolicies::set_limit): <p>The maximum number of resource policies to be displayed with one call of this API.</p>
    /// - On success, responds with [`DescribeResourcePoliciesOutput`](crate::output::DescribeResourcePoliciesOutput) with field(s):
    ///   - [`resource_policies(Option<Vec<ResourcePolicy>>)`](crate::output::DescribeResourcePoliciesOutput::resource_policies): <p>The resource policies that exist in this account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeResourcePoliciesOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeResourcePoliciesError>`](crate::error::DescribeResourcePoliciesError)
    pub fn describe_resource_policies(&self) -> fluent_builders::DescribeResourcePolicies {
        fluent_builders::DescribeResourcePolicies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSubscriptionFilters`](crate::client::fluent_builders::DescribeSubscriptionFilters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSubscriptionFilters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSubscriptionFilters::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DescribeSubscriptionFilters::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`filter_name_prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeSubscriptionFilters::filter_name_prefix) / [`set_filter_name_prefix(Option<String>)`](crate::client::fluent_builders::DescribeSubscriptionFilters::set_filter_name_prefix): <p>The prefix to match. If you don't specify a value, no prefix filter is applied.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeSubscriptionFilters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeSubscriptionFilters::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeSubscriptionFilters::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeSubscriptionFilters::set_limit): <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
    /// - On success, responds with [`DescribeSubscriptionFiltersOutput`](crate::output::DescribeSubscriptionFiltersOutput) with field(s):
    ///   - [`subscription_filters(Option<Vec<SubscriptionFilter>>)`](crate::output::DescribeSubscriptionFiltersOutput::subscription_filters): <p>The subscription filters.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeSubscriptionFiltersOutput::next_token): <p>The token for the next set of items to return. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<DescribeSubscriptionFiltersError>`](crate::error::DescribeSubscriptionFiltersError)
    pub fn describe_subscription_filters(&self) -> fluent_builders::DescribeSubscriptionFilters {
        fluent_builders::DescribeSubscriptionFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateKmsKey`](crate::client::fluent_builders::DisassociateKmsKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateKmsKey::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::DisassociateKmsKey::set_log_group_name): <p>The name of the log group.</p>
    /// - On success, responds with [`DisassociateKmsKeyOutput`](crate::output::DisassociateKmsKeyOutput)

    /// - On failure, responds with [`SdkError<DisassociateKmsKeyError>`](crate::error::DisassociateKmsKeyError)
    pub fn disassociate_kms_key(&self) -> fluent_builders::DisassociateKmsKey {
        fluent_builders::DisassociateKmsKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FilterLogEvents`](crate::client::fluent_builders::FilterLogEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::FilterLogEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::FilterLogEvents::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::FilterLogEvents::set_log_group_name): <p>The name of the log group to search.</p>
    ///   - [`log_stream_names(Vec<String>)`](crate::client::fluent_builders::FilterLogEvents::log_stream_names) / [`set_log_stream_names(Option<Vec<String>>)`](crate::client::fluent_builders::FilterLogEvents::set_log_stream_names): <p>Filters the results to only logs from the log streams in this list.</p>  <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>
    ///   - [`log_stream_name_prefix(impl Into<String>)`](crate::client::fluent_builders::FilterLogEvents::log_stream_name_prefix) / [`set_log_stream_name_prefix(Option<String>)`](crate::client::fluent_builders::FilterLogEvents::set_log_stream_name_prefix): <p>Filters the results to include only events from log streams that have names starting with this prefix.</p>  <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but the value for <code>logStreamNamePrefix</code> does not match any log stream names specified in <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>
    ///   - [`start_time(i64)`](crate::client::fluent_builders::FilterLogEvents::start_time) / [`set_start_time(Option<i64>)`](crate::client::fluent_builders::FilterLogEvents::set_start_time): <p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time are not returned.</p>
    ///   - [`end_time(i64)`](crate::client::fluent_builders::FilterLogEvents::end_time) / [`set_end_time(Option<i64>)`](crate::client::fluent_builders::FilterLogEvents::set_end_time): <p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not returned.</p>
    ///   - [`filter_pattern(impl Into<String>)`](crate::client::fluent_builders::FilterLogEvents::filter_pattern) / [`set_filter_pattern(Option<String>)`](crate::client::fluent_builders::FilterLogEvents::set_filter_pattern): <p>The filter pattern to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a>.</p>  <p>If not provided, all the events are matched.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::FilterLogEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::FilterLogEvents::set_next_token): <p>The token for the next set of events to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::FilterLogEvents::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::FilterLogEvents::set_limit): <p>The maximum number of events to return. The default is 10,000 events.</p>
    ///   - [`interleaved(bool)`](crate::client::fluent_builders::FilterLogEvents::interleaved) / [`set_interleaved(Option<bool>)`](crate::client::fluent_builders::FilterLogEvents::set_interleaved): <p>If the value is true, the operation makes a best effort to provide responses that contain events from multiple log streams within the log group, interleaved in a single response. If the value is false, all the matched log events in the first log stream are searched first, then those in the next log stream, and so on. The default is false.</p>  <p> <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be true. The response from this operation always interleaves events from multiple log streams within a log group.</p>
    /// - On success, responds with [`FilterLogEventsOutput`](crate::output::FilterLogEventsOutput) with field(s):
    ///   - [`events(Option<Vec<FilteredLogEvent>>)`](crate::output::FilterLogEventsOutput::events): <p>The matched events.</p>
    ///   - [`searched_log_streams(Option<Vec<SearchedLogStream>>)`](crate::output::FilterLogEventsOutput::searched_log_streams): <p> <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be an empty list after the deprecation occurs.</p>  <p>Indicates which log streams have been searched and whether each has been searched completely.</p>
    ///   - [`next_token(Option<String>)`](crate::output::FilterLogEventsOutput::next_token): <p>The token to use when requesting the next set of items. The token expires after 24 hours.</p>
    /// - On failure, responds with [`SdkError<FilterLogEventsError>`](crate::error::FilterLogEventsError)
    pub fn filter_log_events(&self) -> fluent_builders::FilterLogEvents {
        fluent_builders::FilterLogEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLogEvents`](crate::client::fluent_builders::GetLogEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetLogEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::GetLogEvents::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::GetLogEvents::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`log_stream_name(impl Into<String>)`](crate::client::fluent_builders::GetLogEvents::log_stream_name) / [`set_log_stream_name(Option<String>)`](crate::client::fluent_builders::GetLogEvents::set_log_stream_name): <p>The name of the log stream.</p>
    ///   - [`start_time(i64)`](crate::client::fluent_builders::GetLogEvents::start_time) / [`set_start_time(Option<i64>)`](crate::client::fluent_builders::GetLogEvents::set_start_time): <p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this time or later than this time are included. Events with a timestamp earlier than this time are not included.</p>
    ///   - [`end_time(i64)`](crate::client::fluent_builders::GetLogEvents::end_time) / [`set_end_time(Option<i64>)`](crate::client::fluent_builders::GetLogEvents::set_end_time): <p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than this time are not included.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetLogEvents::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetLogEvents::set_next_token): <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::GetLogEvents::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::GetLogEvents::set_limit): <p>The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as can fit in a response size of 1 MB, up to 10,000 log events.</p>
    ///   - [`start_from_head(bool)`](crate::client::fluent_builders::GetLogEvents::start_from_head) / [`set_start_from_head(Option<bool>)`](crate::client::fluent_builders::GetLogEvents::set_start_from_head): <p>If the value is true, the earliest log events are returned first. If the value is false, the latest log events are returned first. The default value is false.</p>  <p>If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this operation, you must specify <code>true</code> for <code>startFromHead</code>.</p>
    /// - On success, responds with [`GetLogEventsOutput`](crate::output::GetLogEventsOutput) with field(s):
    ///   - [`events(Option<Vec<OutputLogEvent>>)`](crate::output::GetLogEventsOutput::events): <p>The events.</p>
    ///   - [`next_forward_token(Option<String>)`](crate::output::GetLogEventsOutput::next_forward_token): <p>The token for the next set of items in the forward direction. The token expires after 24 hours. If you have reached the end of the stream, it returns the same token you passed in.</p>
    ///   - [`next_backward_token(Option<String>)`](crate::output::GetLogEventsOutput::next_backward_token): <p>The token for the next set of items in the backward direction. The token expires after 24 hours. This token is never null. If you have reached the end of the stream, it returns the same token you passed in.</p>
    /// - On failure, responds with [`SdkError<GetLogEventsError>`](crate::error::GetLogEventsError)
    pub fn get_log_events(&self) -> fluent_builders::GetLogEvents {
        fluent_builders::GetLogEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLogGroupFields`](crate::client::fluent_builders::GetLogGroupFields) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::GetLogGroupFields::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::GetLogGroupFields::set_log_group_name): <p>The name of the log group to search.</p>
    ///   - [`time(i64)`](crate::client::fluent_builders::GetLogGroupFields::time) / [`set_time(Option<i64>)`](crate::client::fluent_builders::GetLogGroupFields::set_time): <p>The time to set as the center of the query. If you specify <code>time</code>, the 15 minutes before this time are queries. If you omit <code>time</code> the 8 minutes before and 8 minutes after this time are searched.</p>  <p>The <code>time</code> value is specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
    /// - On success, responds with [`GetLogGroupFieldsOutput`](crate::output::GetLogGroupFieldsOutput) with field(s):
    ///   - [`log_group_fields(Option<Vec<LogGroupField>>)`](crate::output::GetLogGroupFieldsOutput::log_group_fields): <p>The array of fields found in the query. Each object in the array contains the name of the field, along with the percentage of time it appeared in the log events that were queried.</p>
    /// - On failure, responds with [`SdkError<GetLogGroupFieldsError>`](crate::error::GetLogGroupFieldsError)
    pub fn get_log_group_fields(&self) -> fluent_builders::GetLogGroupFields {
        fluent_builders::GetLogGroupFields::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLogRecord`](crate::client::fluent_builders::GetLogRecord) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_record_pointer(impl Into<String>)`](crate::client::fluent_builders::GetLogRecord::log_record_pointer) / [`set_log_record_pointer(Option<String>)`](crate::client::fluent_builders::GetLogRecord::set_log_record_pointer): <p>The pointer corresponding to the log event record you want to retrieve. You get this from the response of a <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code> field for a log event is the value to use as <code>logRecordPointer</code> to retrieve that complete log event record.</p>
    /// - On success, responds with [`GetLogRecordOutput`](crate::output::GetLogRecordOutput) with field(s):
    ///   - [`log_record(Option<HashMap<String, String>>)`](crate::output::GetLogRecordOutput::log_record): <p>The requested log event, as a JSON string.</p>
    /// - On failure, responds with [`SdkError<GetLogRecordError>`](crate::error::GetLogRecordError)
    pub fn get_log_record(&self) -> fluent_builders::GetLogRecord {
        fluent_builders::GetLogRecord::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetQueryResults`](crate::client::fluent_builders::GetQueryResults) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_id(impl Into<String>)`](crate::client::fluent_builders::GetQueryResults::query_id) / [`set_query_id(Option<String>)`](crate::client::fluent_builders::GetQueryResults::set_query_id): <p>The ID number of the query.</p>
    /// - On success, responds with [`GetQueryResultsOutput`](crate::output::GetQueryResultsOutput) with field(s):
    ///   - [`results(Option<Vec<Vec<ResultField>>>)`](crate::output::GetQueryResultsOutput::results): <p>The log events that matched the query criteria during the most recent time it ran.</p>  <p>The <code>results</code> value is an array of arrays. Each log event is one object in the top-level array. Each of these log event objects is an array of <code>field</code>/<code>value</code> pairs.</p>
    ///   - [`statistics(Option<QueryStatistics>)`](crate::output::GetQueryResultsOutput::statistics): <p>Includes the number of log events scanned by the query, the number of log events that matched the query criteria, and the total number of bytes in the log events that were scanned. These values reflect the full raw results of the query.</p>
    ///   - [`status(Option<QueryStatus>)`](crate::output::GetQueryResultsOutput::status): <p>The status of the most recent running of the query. Possible values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, <code>Timeout</code>, and <code>Unknown</code>.</p>  <p>Queries time out after 15 minutes of execution. To avoid having your queries time out, reduce the time range being searched or partition your query into a number of queries.</p>
    /// - On failure, responds with [`SdkError<GetQueryResultsError>`](crate::error::GetQueryResultsError)
    pub fn get_query_results(&self) -> fluent_builders::GetQueryResults {
        fluent_builders::GetQueryResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsLogGroup`](crate::client::fluent_builders::ListTagsLogGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::ListTagsLogGroup::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::ListTagsLogGroup::set_log_group_name): <p>The name of the log group.</p>
    /// - On success, responds with [`ListTagsLogGroupOutput`](crate::output::ListTagsLogGroupOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsLogGroupOutput::tags): <p>The tags for the log group.</p>
    /// - On failure, responds with [`SdkError<ListTagsLogGroupError>`](crate::error::ListTagsLogGroupError)
    pub fn list_tags_log_group(&self) -> fluent_builders::ListTagsLogGroup {
        fluent_builders::ListTagsLogGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDestination`](crate::client::fluent_builders::PutDestination) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_name(impl Into<String>)`](crate::client::fluent_builders::PutDestination::destination_name) / [`set_destination_name(Option<String>)`](crate::client::fluent_builders::PutDestination::set_destination_name): <p>A name for the destination.</p>
    ///   - [`target_arn(impl Into<String>)`](crate::client::fluent_builders::PutDestination::target_arn) / [`set_target_arn(Option<String>)`](crate::client::fluent_builders::PutDestination::set_target_arn): <p>The ARN of an Amazon Kinesis stream to which to deliver matching log events.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::PutDestination::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::PutDestination::set_role_arn): <p>The ARN of an IAM role that grants CloudWatch Logs permissions to call the Amazon Kinesis <code>PutRecord</code> operation on the destination stream.</p>
    /// - On success, responds with [`PutDestinationOutput`](crate::output::PutDestinationOutput) with field(s):
    ///   - [`destination(Option<Destination>)`](crate::output::PutDestinationOutput::destination): <p>The destination.</p>
    /// - On failure, responds with [`SdkError<PutDestinationError>`](crate::error::PutDestinationError)
    pub fn put_destination(&self) -> fluent_builders::PutDestination {
        fluent_builders::PutDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutDestinationPolicy`](crate::client::fluent_builders::PutDestinationPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_name(impl Into<String>)`](crate::client::fluent_builders::PutDestinationPolicy::destination_name) / [`set_destination_name(Option<String>)`](crate::client::fluent_builders::PutDestinationPolicy::set_destination_name): <p>A name for an existing destination.</p>
    ///   - [`access_policy(impl Into<String>)`](crate::client::fluent_builders::PutDestinationPolicy::access_policy) / [`set_access_policy(Option<String>)`](crate::client::fluent_builders::PutDestinationPolicy::set_access_policy): <p>An IAM policy document that authorizes cross-account users to deliver their log events to the associated destination. This can be up to 5120 bytes.</p>
    ///   - [`force_update(bool)`](crate::client::fluent_builders::PutDestinationPolicy::force_update) / [`set_force_update(Option<bool>)`](crate::client::fluent_builders::PutDestinationPolicy::set_force_update): <p>Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts. Before you update a destination policy this way, you must first update the subscription filters in the accounts that send logs to this destination. If you do not, the subscription filters might stop working. By specifying <code>true</code> for <code>forceUpdate</code>, you are affirming that you have already updated the subscription filters. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html"> Updating an existing cross-account subscription</a> </p>  <p>If you omit this parameter, the default of <code>false</code> is used.</p>
    /// - On success, responds with [`PutDestinationPolicyOutput`](crate::output::PutDestinationPolicyOutput)

    /// - On failure, responds with [`SdkError<PutDestinationPolicyError>`](crate::error::PutDestinationPolicyError)
    pub fn put_destination_policy(&self) -> fluent_builders::PutDestinationPolicy {
        fluent_builders::PutDestinationPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutLogEvents`](crate::client::fluent_builders::PutLogEvents) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::PutLogEvents::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::PutLogEvents::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`log_stream_name(impl Into<String>)`](crate::client::fluent_builders::PutLogEvents::log_stream_name) / [`set_log_stream_name(Option<String>)`](crate::client::fluent_builders::PutLogEvents::set_log_stream_name): <p>The name of the log stream.</p>
    ///   - [`log_events(Vec<InputLogEvent>)`](crate::client::fluent_builders::PutLogEvents::log_events) / [`set_log_events(Option<Vec<InputLogEvent>>)`](crate::client::fluent_builders::PutLogEvents::set_log_events): <p>The log events.</p>
    ///   - [`sequence_token(impl Into<String>)`](crate::client::fluent_builders::PutLogEvents::sequence_token) / [`set_sequence_token(Option<String>)`](crate::client::fluent_builders::PutLogEvents::set_sequence_token): <p>The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token using <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html">DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using the same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.</p>
    /// - On success, responds with [`PutLogEventsOutput`](crate::output::PutLogEventsOutput) with field(s):
    ///   - [`next_sequence_token(Option<String>)`](crate::output::PutLogEventsOutput::next_sequence_token): <p>The next sequence token.</p>
    ///   - [`rejected_log_events_info(Option<RejectedLogEventsInfo>)`](crate::output::PutLogEventsOutput::rejected_log_events_info): <p>The rejected events.</p>
    /// - On failure, responds with [`SdkError<PutLogEventsError>`](crate::error::PutLogEventsError)
    pub fn put_log_events(&self) -> fluent_builders::PutLogEvents {
        fluent_builders::PutLogEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutMetricFilter`](crate::client::fluent_builders::PutMetricFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::PutMetricFilter::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::PutMetricFilter::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`filter_name(impl Into<String>)`](crate::client::fluent_builders::PutMetricFilter::filter_name) / [`set_filter_name(Option<String>)`](crate::client::fluent_builders::PutMetricFilter::set_filter_name): <p>A name for the metric filter.</p>
    ///   - [`filter_pattern(impl Into<String>)`](crate::client::fluent_builders::PutMetricFilter::filter_pattern) / [`set_filter_pattern(Option<String>)`](crate::client::fluent_builders::PutMetricFilter::set_filter_pattern): <p>A filter pattern for extracting metric data out of ingested log events.</p>
    ///   - [`metric_transformations(Vec<MetricTransformation>)`](crate::client::fluent_builders::PutMetricFilter::metric_transformations) / [`set_metric_transformations(Option<Vec<MetricTransformation>>)`](crate::client::fluent_builders::PutMetricFilter::set_metric_transformations): <p>A collection of information that defines how metric data gets emitted.</p>
    /// - On success, responds with [`PutMetricFilterOutput`](crate::output::PutMetricFilterOutput)

    /// - On failure, responds with [`SdkError<PutMetricFilterError>`](crate::error::PutMetricFilterError)
    pub fn put_metric_filter(&self) -> fluent_builders::PutMetricFilter {
        fluent_builders::PutMetricFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutQueryDefinition`](crate::client::fluent_builders::PutQueryDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::PutQueryDefinition::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::PutQueryDefinition::set_name): <p>A name for the query definition. If you are saving a lot of query definitions, we recommend that you name them so that you can easily find the ones you want by using the first part of the name as a filter in the <code>queryDefinitionNamePrefix</code> parameter of <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a>.</p>
    ///   - [`query_definition_id(impl Into<String>)`](crate::client::fluent_builders::PutQueryDefinition::query_definition_id) / [`set_query_definition_id(Option<String>)`](crate::client::fluent_builders::PutQueryDefinition::set_query_definition_id): <p>If you are updating a query definition, use this parameter to specify the ID of the query definition that you want to update. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p>  <p>If you are creating a query definition, do not specify this parameter. CloudWatch generates a unique ID for the new query definition and include it in the response to this operation.</p>
    ///   - [`log_group_names(Vec<String>)`](crate::client::fluent_builders::PutQueryDefinition::log_group_names) / [`set_log_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::PutQueryDefinition::set_log_group_names): <p>Use this parameter to include specific log groups as part of your query definition.</p>  <p>If you are updating a query definition and you omit this parameter, then the updated definition will contain no log groups.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::PutQueryDefinition::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::PutQueryDefinition::set_query_string): <p>The query string to use for this definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
    /// - On success, responds with [`PutQueryDefinitionOutput`](crate::output::PutQueryDefinitionOutput) with field(s):
    ///   - [`query_definition_id(Option<String>)`](crate::output::PutQueryDefinitionOutput::query_definition_id): <p>The ID of the query definition.</p>
    /// - On failure, responds with [`SdkError<PutQueryDefinitionError>`](crate::error::PutQueryDefinitionError)
    pub fn put_query_definition(&self) -> fluent_builders::PutQueryDefinition {
        fluent_builders::PutQueryDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutResourcePolicy`](crate::client::fluent_builders::PutResourcePolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`policy_name(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::policy_name) / [`set_policy_name(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_policy_name): <p>Name of the new policy. This parameter is required.</p>
    ///   - [`policy_document(impl Into<String>)`](crate::client::fluent_builders::PutResourcePolicy::policy_document) / [`set_policy_document(Option<String>)`](crate::client::fluent_builders::PutResourcePolicy::set_policy_document): <p>Details of the new policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. This parameter is required.</p>  <p>The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to the specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs resource, such as a log group or log stream.</p>  <p>CloudWatch Logs also supports <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn">aws:SourceArn</a> and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount">aws:SourceAccount</a> condition context keys.</p>  <p>In the example resource policy, you would replace the value of <code>SourceArn</code> with the resource making the call from Route&nbsp;53 to CloudWatch Logs and replace the value of <code>SourceAccount</code> with the Amazon Web Services account ID making that call.</p>  <p></p>  <p> <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code> </p>
    /// - On success, responds with [`PutResourcePolicyOutput`](crate::output::PutResourcePolicyOutput) with field(s):
    ///   - [`resource_policy(Option<ResourcePolicy>)`](crate::output::PutResourcePolicyOutput::resource_policy): <p>The new policy.</p>
    /// - On failure, responds with [`SdkError<PutResourcePolicyError>`](crate::error::PutResourcePolicyError)
    pub fn put_resource_policy(&self) -> fluent_builders::PutResourcePolicy {
        fluent_builders::PutResourcePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutRetentionPolicy`](crate::client::fluent_builders::PutRetentionPolicy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::PutRetentionPolicy::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::PutRetentionPolicy::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`retention_in_days(i32)`](crate::client::fluent_builders::PutRetentionPolicy::retention_in_days) / [`set_retention_in_days(Option<i32>)`](crate::client::fluent_builders::PutRetentionPolicy::set_retention_in_days): <p>The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p>  <p>To set a log group to never have log events expire, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>. </p>
    /// - On success, responds with [`PutRetentionPolicyOutput`](crate::output::PutRetentionPolicyOutput)

    /// - On failure, responds with [`SdkError<PutRetentionPolicyError>`](crate::error::PutRetentionPolicyError)
    pub fn put_retention_policy(&self) -> fluent_builders::PutRetentionPolicy {
        fluent_builders::PutRetentionPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutSubscriptionFilter`](crate::client::fluent_builders::PutSubscriptionFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`filter_name(impl Into<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::filter_name) / [`set_filter_name(Option<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::set_filter_name): <p>A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html">DescribeSubscriptionFilters</a>.</p>
    ///   - [`filter_pattern(impl Into<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::filter_pattern) / [`set_filter_pattern(Option<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::set_filter_pattern): <p>A filter pattern for subscribing to a filtered stream of log events.</p>
    ///   - [`destination_arn(impl Into<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::destination_arn) / [`set_destination_arn(Option<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::set_destination_arn): <p>The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:</p>  <ul>   <li> <p>An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li>   <li> <p>A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.</p> <p>If you are setting up a cross-account subscription, the destination must have an IAM policy associated with it that allows the sender to send logs to the destination. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html">PutDestinationPolicy</a>.</p> </li>   <li> <p>An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li>   <li> <p>A Lambda function belonging to the same account as the subscription filter, for same-account delivery.</p> </li>  </ul>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::PutSubscriptionFilter::set_role_arn): <p>The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.</p>
    ///   - [`distribution(Distribution)`](crate::client::fluent_builders::PutSubscriptionFilter::distribution) / [`set_distribution(Option<Distribution>)`](crate::client::fluent_builders::PutSubscriptionFilter::set_distribution): <p>The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. </p>
    /// - On success, responds with [`PutSubscriptionFilterOutput`](crate::output::PutSubscriptionFilterOutput)

    /// - On failure, responds with [`SdkError<PutSubscriptionFilterError>`](crate::error::PutSubscriptionFilterError)
    pub fn put_subscription_filter(&self) -> fluent_builders::PutSubscriptionFilter {
        fluent_builders::PutSubscriptionFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartQuery`](crate::client::fluent_builders::StartQuery) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::StartQuery::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::StartQuery::set_log_group_name): <p>The log group on which to perform the query.</p>  <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>
    ///   - [`log_group_names(Vec<String>)`](crate::client::fluent_builders::StartQuery::log_group_names) / [`set_log_group_names(Option<Vec<String>>)`](crate::client::fluent_builders::StartQuery::set_log_group_names): <p>The list of log groups to be queried. You can include up to 20 log groups.</p>  <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>
    ///   - [`start_time(i64)`](crate::client::fluent_builders::StartQuery::start_time) / [`set_start_time(Option<i64>)`](crate::client::fluent_builders::StartQuery::set_start_time): <p>The beginning of the time range to query. The range is inclusive, so the specified start time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
    ///   - [`end_time(i64)`](crate::client::fluent_builders::StartQuery::end_time) / [`set_end_time(Option<i64>)`](crate::client::fluent_builders::StartQuery::set_end_time): <p>The end of the time range to query. The range is inclusive, so the specified end time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
    ///   - [`query_string(impl Into<String>)`](crate::client::fluent_builders::StartQuery::query_string) / [`set_query_string(Option<String>)`](crate::client::fluent_builders::StartQuery::set_query_string): <p>The query string to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::StartQuery::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::StartQuery::set_limit): <p>The maximum number of log events to return in the query. If the query string uses the <code>fields</code> command, only the specified fields and their values are returned. The default is 1000.</p>
    /// - On success, responds with [`StartQueryOutput`](crate::output::StartQueryOutput) with field(s):
    ///   - [`query_id(Option<String>)`](crate::output::StartQueryOutput::query_id): <p>The unique ID of the query. </p>
    /// - On failure, responds with [`SdkError<StartQueryError>`](crate::error::StartQueryError)
    pub fn start_query(&self) -> fluent_builders::StartQuery {
        fluent_builders::StartQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopQuery`](crate::client::fluent_builders::StopQuery) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`query_id(impl Into<String>)`](crate::client::fluent_builders::StopQuery::query_id) / [`set_query_id(Option<String>)`](crate::client::fluent_builders::StopQuery::set_query_id): <p>The ID number of the query to stop. To find this ID number, use <code>DescribeQueries</code>.</p>
    /// - On success, responds with [`StopQueryOutput`](crate::output::StopQueryOutput) with field(s):
    ///   - [`success(bool)`](crate::output::StopQueryOutput::success): <p>This is true if the query was stopped by the <code>StopQuery</code> operation.</p>
    /// - On failure, responds with [`SdkError<StopQueryError>`](crate::error::StopQueryError)
    pub fn stop_query(&self) -> fluent_builders::StopQuery {
        fluent_builders::StopQuery::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagLogGroup`](crate::client::fluent_builders::TagLogGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::TagLogGroup::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::TagLogGroup::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagLogGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagLogGroup::set_tags): <p>The key-value pairs to use for the tags.</p>
    /// - On success, responds with [`TagLogGroupOutput`](crate::output::TagLogGroupOutput)

    /// - On failure, responds with [`SdkError<TagLogGroupError>`](crate::error::TagLogGroupError)
    pub fn tag_log_group(&self) -> fluent_builders::TagLogGroup {
        fluent_builders::TagLogGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestMetricFilter`](crate::client::fluent_builders::TestMetricFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_pattern(impl Into<String>)`](crate::client::fluent_builders::TestMetricFilter::filter_pattern) / [`set_filter_pattern(Option<String>)`](crate::client::fluent_builders::TestMetricFilter::set_filter_pattern): <p>A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.</p>
    ///   - [`log_event_messages(Vec<String>)`](crate::client::fluent_builders::TestMetricFilter::log_event_messages) / [`set_log_event_messages(Option<Vec<String>>)`](crate::client::fluent_builders::TestMetricFilter::set_log_event_messages): <p>The log event messages to test.</p>
    /// - On success, responds with [`TestMetricFilterOutput`](crate::output::TestMetricFilterOutput) with field(s):
    ///   - [`matches(Option<Vec<MetricFilterMatchRecord>>)`](crate::output::TestMetricFilterOutput::matches): <p>The matched events.</p>
    /// - On failure, responds with [`SdkError<TestMetricFilterError>`](crate::error::TestMetricFilterError)
    pub fn test_metric_filter(&self) -> fluent_builders::TestMetricFilter {
        fluent_builders::TestMetricFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagLogGroup`](crate::client::fluent_builders::UntagLogGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`log_group_name(impl Into<String>)`](crate::client::fluent_builders::UntagLogGroup::log_group_name) / [`set_log_group_name(Option<String>)`](crate::client::fluent_builders::UntagLogGroup::set_log_group_name): <p>The name of the log group.</p>
    ///   - [`tags(Vec<String>)`](crate::client::fluent_builders::UntagLogGroup::tags) / [`set_tags(Option<Vec<String>>)`](crate::client::fluent_builders::UntagLogGroup::set_tags): <p>The tag keys. The corresponding tags are removed from the log group.</p>
    /// - On success, responds with [`UntagLogGroupOutput`](crate::output::UntagLogGroupOutput)

    /// - On failure, responds with [`SdkError<UntagLogGroupError>`](crate::error::UntagLogGroupError)
    pub fn untag_log_group(&self) -> fluent_builders::UntagLogGroup {
        fluent_builders::UntagLogGroup::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateKmsKey`.
    ///
    /// <p>Associates the specified Key Management Service customer master key (CMK) with the specified log group.</p>
    /// <p>Associating an KMS CMK with a log group overrides any existing associations between the log group and a CMK. After a CMK is associated with a log group, all newly ingested data for the log group is encrypted using the CMK. This association is stored as long as the data encrypted with the CMK is still within CloudWatch Logs. This enables CloudWatch Logs to decrypt this data whenever it is requested.</p> <important>
    /// <p>CloudWatch Logs supports only symmetric CMKs. Do not use an associate an asymmetric CMK with your log group. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p>
    /// </important>
    /// <p>It can take up to 5 minutes for this operation to take effect.</p>
    /// <p>If you attempt to associate a CMK with a log group but the CMK does not exist or the CMK is disabled, you receive an <code>InvalidParameterException</code> error. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateKmsKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_kms_key_input::Builder,
    }
    impl AssociateKmsKey {
        /// Creates a new `AssociateKmsKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateKmsKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateKmsKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. This must be a symmetric CMK. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. This must be a symmetric CMK. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelExportTask`.
    ///
    /// <p>Cancels the specified export task.</p>
    /// <p>The task must be in the <code>PENDING</code> or <code>RUNNING</code> state.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelExportTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_export_task_input::Builder,
    }
    impl CancelExportTask {
        /// Creates a new `CancelExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelExportTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the export task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the export task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateExportTask`.
    ///
    /// <p>Creates an export task, which allows you to efficiently export data from a log group to an Amazon S3 bucket. When you perform a <code>CreateExportTask</code> operation, you must use credentials that have permission to write to the S3 bucket that you specify as the destination.</p>
    /// <p>This is an asynchronous call. If all the required information is provided, this operation initiates an export task and responds with the ID of the task. After the task has started, you can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html">DescribeExportTasks</a> to get the status of the export task. Each account can only have one active (<code>RUNNING</code> or <code>PENDING</code>) export task at a time. To cancel an export task, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html">CancelExportTask</a>.</p>
    /// <p>You can export logs from multiple log groups or multiple time ranges to the same S3 bucket. To separate out log data for each export task, you can specify a prefix to be used as the Amazon S3 key prefix for all exported objects.</p>
    /// <p>Exporting to S3 buckets that are encrypted with AES-256 is supported. Exporting to S3 buckets encrypted with SSE-KMS is not supported. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateExportTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_export_task_input::Builder,
    }
    impl CreateExportTask {
        /// Creates a new `CreateExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateExportTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the export task.</p>
        pub fn task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_name(input.into());
            self
        }
        /// <p>The name of the export task.</p>
        pub fn set_task_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_name(input);
            self
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is applied.</p>
        pub fn log_stream_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name_prefix(input.into());
            self
        }
        /// <p>Export only log streams that match the provided prefix. If you don't specify a value, no prefix filter is applied.</p>
        pub fn set_log_stream_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name_prefix(input);
            self
        }
        /// <p>The start time of the range for the request, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp earlier than this time are not exported.</p>
        pub fn from(mut self, input: i64) -> Self {
            self.inner = self.inner.from(input);
            self
        }
        /// <p>The start time of the range for the request, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp earlier than this time are not exported.</p>
        pub fn set_from(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_from(input);
            self
        }
        /// <p>The end time of the range for the request, expreswatchlogsdocused as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not exported.</p>
        pub fn to(mut self, input: i64) -> Self {
            self.inner = self.inner.to(input);
            self
        }
        /// <p>The end time of the range for the request, expreswatchlogsdocused as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not exported.</p>
        pub fn set_to(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_to(input);
            self
        }
        /// <p>The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services region.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination(input.into());
            self
        }
        /// <p>The name of S3 bucket for the exported log data. The bucket must be in the same Amazon Web Services region.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// <p>The prefix used as the start of the key for every object exported. If you don't specify a value, the default is <code>exportedlogs</code>.</p>
        pub fn destination_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_prefix(input.into());
            self
        }
        /// <p>The prefix used as the start of the key for every object exported. If you don't specify a value, the default is <code>exportedlogs</code>.</p>
        pub fn set_destination_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLogGroup`.
    ///
    /// <p>Creates a log group with the specified name. You can create up to 20,000 log groups per account.</p>
    /// <p>You must use the following guidelines when naming a log group:</p>
    /// <ul>
    /// <li> <p>Log group names must be unique within a region for an Amazon Web Services account.</p> </li>
    /// <li> <p>Log group names can be between 1 and 512 characters long.</p> </li>
    /// <li> <p>Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward slash), '.' (period), and '#' (number sign)</p> </li>
    /// </ul>
    /// <p>When you create a log group, by default the log events in the log group never expire. To set a retention policy so that events expire and are deleted after a specified time, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html">PutRetentionPolicy</a>.</p>
    /// <p>If you associate a Key Management Service customer master key (CMK) with the log group, ingested data is encrypted using the CMK. This association is stored as long as the data encrypted with the CMK is still within CloudWatch Logs. This enables CloudWatch Logs to decrypt this data whenever it is requested.</p>
    /// <p>If you attempt to associate a CMK with the log group but the CMK does not exist or the CMK is disabled, you receive an <code>InvalidParameterException</code> error. </p> <important>
    /// <p>CloudWatch Logs supports only symmetric CMKs. Do not associate an asymmetric CMK with your log group. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and Asymmetric Keys</a>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLogGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_log_group_input::Builder,
    }
    impl CreateLogGroup {
        /// Creates a new `CreateLogGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLogGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLogGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a>.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms">Amazon Resource Names - Key Management Service</a>.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to use for the tags.</p>
        /// <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value pairs to use for the tags.</p>
        /// <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLogStream`.
    ///
    /// <p>Creates a log stream for the specified log group. A log stream is a sequence of log events that originate from a single source, such as an application instance or a resource that is being monitored.</p>
    /// <p>There is no limit on the number of log streams that you can create for a log group. There is a limit of 50 TPS on <code>CreateLogStream</code> operations, after which transactions are throttled.</p>
    /// <p>You must use the following guidelines when naming a log stream:</p>
    /// <ul>
    /// <li> <p>Log stream names must be unique within the log group.</p> </li>
    /// <li> <p>Log stream names can be between 1 and 512 characters long.</p> </li>
    /// <li> <p>The ':' (colon) and '*' (asterisk) characters are not allowed.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLogStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_log_stream_input::Builder,
    }
    impl CreateLogStream {
        /// Creates a new `CreateLogStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLogStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLogStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name(input.into());
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDestination`.
    ///
    /// <p>Deletes the specified destination, and eventually disables all the subscription filters that publish to it. This operation does not delete the physical resource encapsulated by the destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_destination_input::Builder,
    }
    impl DeleteDestination {
        /// Creates a new `DeleteDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the destination.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(input.into());
            self
        }
        /// <p>The name of the destination.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLogGroup`.
    ///
    /// <p>Deletes the specified log group and permanently deletes all the archived log events associated with the log group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLogGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_log_group_input::Builder,
    }
    impl DeleteLogGroup {
        /// Creates a new `DeleteLogGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLogGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLogGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLogStream`.
    ///
    /// <p>Deletes the specified log stream and permanently deletes all the archived log events associated with the log stream.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLogStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_log_stream_input::Builder,
    }
    impl DeleteLogStream {
        /// Creates a new `DeleteLogStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLogStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLogStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name(input.into());
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMetricFilter`.
    ///
    /// <p>Deletes the specified metric filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMetricFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_metric_filter_input::Builder,
    }
    impl DeleteMetricFilter {
        /// Creates a new `DeleteMetricFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMetricFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMetricFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The name of the metric filter.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(input.into());
            self
        }
        /// <p>The name of the metric filter.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueryDefinition`.
    ///
    /// <p>Deletes a saved CloudWatch Logs Insights query definition. A query definition contains details about a saved CloudWatch Logs Insights query.</p>
    /// <p>Each <code>DeleteQueryDefinition</code> operation can delete one query definition.</p>
    /// <p>You must have the <code>logs:DeleteQueryDefinition</code> permission to be able to perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteQueryDefinition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_query_definition_input::Builder,
    }
    impl DeleteQueryDefinition {
        /// Creates a new `DeleteQueryDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueryDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueryDefinitionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the query definition that you want to delete. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p>
        pub fn query_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_definition_id(input.into());
            self
        }
        /// <p>The ID of the query definition that you want to delete. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p>
        pub fn set_query_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_definition_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteResourcePolicy`.
    ///
    /// <p>Deletes a resource policy from this account. This revokes the access of the identities in that policy to put log events to this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_resource_policy_input::Builder,
    }
    impl DeleteResourcePolicy {
        /// Creates a new `DeleteResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the policy to be revoked. This parameter is required.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>The name of the policy to be revoked. This parameter is required.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRetentionPolicy`.
    ///
    /// <p>Deletes the specified retention policy.</p>
    /// <p>Log events do not expire if they belong to log groups without a retention policy.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRetentionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_retention_policy_input::Builder,
    }
    impl DeleteRetentionPolicy {
        /// Creates a new `DeleteRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRetentionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSubscriptionFilter`.
    ///
    /// <p>Deletes the specified subscription filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSubscriptionFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_subscription_filter_input::Builder,
    }
    impl DeleteSubscriptionFilter {
        /// Creates a new `DeleteSubscriptionFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSubscriptionFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSubscriptionFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The name of the subscription filter.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(input.into());
            self
        }
        /// <p>The name of the subscription filter.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDestinations`.
    ///
    /// <p>Lists all your destinations. The results are ASCII-sorted by destination name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDestinations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_destinations_input::Builder,
    }
    impl DescribeDestinations {
        /// Creates a new `DescribeDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDestinationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDestinationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDestinationsPaginator {
            crate::paginator::DescribeDestinationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The prefix to match. If you don't specify a value, no prefix filter is applied.</p>
        pub fn destination_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name_prefix(input.into());
            self
        }
        /// <p>The prefix to match. If you don't specify a value, no prefix filter is applied.</p>
        pub fn set_destination_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name_prefix(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeExportTasks`.
    ///
    /// <p>Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or task status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeExportTasks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_export_tasks_input::Builder,
    }
    impl DescribeExportTasks {
        /// Creates a new `DescribeExportTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeExportTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_id(input.into());
            self
        }
        /// <p>The ID of the export task. Specifying a task ID filters the results to zero or one export tasks.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_id(input);
            self
        }
        /// <p>The status code of the export task. Specifying a status code filters the results to zero or more export tasks.</p>
        pub fn status_code(mut self, input: crate::model::ExportTaskStatusCode) -> Self {
            self.inner = self.inner.status_code(input);
            self
        }
        /// <p>The status code of the export task. Specifying a status code filters the results to zero or more export tasks.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::ExportTaskStatusCode>,
        ) -> Self {
            self.inner = self.inner.set_status_code(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLogGroups`.
    ///
    /// <p>Lists the specified log groups. You can list all your log groups or filter the results by prefix. The results are ASCII-sorted by log group name.</p>
    /// <p>CloudWatch Logs doesn’t support IAM policies that control access to the <code>DescribeLogGroups</code> action by using the <code>aws:ResourceTag/<i>key-name</i> </code> condition key. Other CloudWatch Logs actions do support the use of the <code>aws:ResourceTag/<i>key-name</i> </code> condition key to control access. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLogGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_log_groups_input::Builder,
    }
    impl DescribeLogGroups {
        /// Creates a new `DescribeLogGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLogGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLogGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeLogGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeLogGroupsPaginator {
            crate::paginator::DescribeLogGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The prefix to match.</p>
        pub fn log_group_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name_prefix(input.into());
            self
        }
        /// <p>The prefix to match.</p>
        pub fn set_log_group_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name_prefix(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLogStreams`.
    ///
    /// <p>Lists the log streams for the specified log group. You can list all the log streams or filter the results by prefix. You can also control how the results are ordered.</p>
    /// <p>This operation has a limit of five transactions per second, after which transactions are throttled.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLogStreams {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_log_streams_input::Builder,
    }
    impl DescribeLogStreams {
        /// Creates a new `DescribeLogStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLogStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLogStreamsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeLogStreamsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeLogStreamsPaginator {
            crate::paginator::DescribeLogStreamsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The prefix to match.</p>
        /// <p>If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.</p>
        pub fn log_stream_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name_prefix(input.into());
            self
        }
        /// <p>The prefix to match.</p>
        /// <p>If <code>orderBy</code> is <code>LastEventTime</code>, you cannot specify this parameter.</p>
        pub fn set_log_stream_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name_prefix(input);
            self
        }
        /// <p>If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is <code>LastEventTime</code>, the results are ordered by the event time. The default value is <code>LogStreamName</code>.</p>
        /// <p>If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.</p>
        /// <p> <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. <code>lastEventTimestamp</code> updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.inner = self.inner.order_by(input);
            self
        }
        /// <p>If the value is <code>LogStreamName</code>, the results are ordered by log stream name. If the value is <code>LastEventTime</code>, the results are ordered by the event time. The default value is <code>LogStreamName</code>.</p>
        /// <p>If you order the results by event time, you cannot specify the <code>logStreamNamePrefix</code> parameter.</p>
        /// <p> <code>lastEventTimestamp</code> represents the time of the most recent log event in the log stream in CloudWatch Logs. This number is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. <code>lastEventTimestamp</code> updates on an eventual consistency basis. It typically updates in less than an hour from ingestion, but in rare situations might take longer.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.inner = self.inner.set_order_by(input);
            self
        }
        /// <p>If the value is true, results are returned in descending order. If the value is to false, results are returned in ascending order. The default value is false.</p>
        pub fn descending(mut self, input: bool) -> Self {
            self.inner = self.inner.descending(input);
            self
        }
        /// <p>If the value is true, results are returned in descending order. If the value is to false, results are returned in ascending order. The default value is false.</p>
        pub fn set_descending(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_descending(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMetricFilters`.
    ///
    /// <p>Lists the specified metric filters. You can list all of the metric filters or filter the results by log name, prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMetricFilters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_metric_filters_input::Builder,
    }
    impl DescribeMetricFilters {
        /// Creates a new `DescribeMetricFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMetricFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMetricFiltersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMetricFiltersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeMetricFiltersPaginator {
            crate::paginator::DescribeMetricFiltersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The prefix to match. CloudWatch Logs uses the value you set here only if you also include the <code>logGroupName</code> parameter in your request.</p>
        pub fn filter_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name_prefix(input.into());
            self
        }
        /// <p>The prefix to match. CloudWatch Logs uses the value you set here only if you also include the <code>logGroupName</code> parameter in your request.</p>
        pub fn set_filter_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_name_prefix(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>Filters results to include only those with the specified metric name. If you include this parameter in your request, you must also include the <code>metricNamespace</code> parameter.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(input.into());
            self
        }
        /// <p>Filters results to include only those with the specified metric name. If you include this parameter in your request, you must also include the <code>metricNamespace</code> parameter.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>Filters results to include only those in the specified namespace. If you include this parameter in your request, you must also include the <code>metricName</code> parameter.</p>
        pub fn metric_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_namespace(input.into());
            self
        }
        /// <p>Filters results to include only those in the specified namespace. If you include this parameter in your request, you must also include the <code>metricName</code> parameter.</p>
        pub fn set_metric_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_metric_namespace(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQueries`.
    ///
    /// <p>Returns a list of CloudWatch Logs Insights queries that are scheduled, executing, or have been executed recently in this account. You can request all queries or limit it to queries of a specific log group or queries with a certain status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeQueries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_queries_input::Builder,
    }
    impl DescribeQueries {
        /// Creates a new `DescribeQueries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQueriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQueriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Limits the returned queries to only those for the specified log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>Limits the returned queries to only those for the specified log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>Limits the returned queries to only those that have the specified status. Valid values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>, <code>Running</code>, and <code>Scheduled</code>.</p>
        pub fn status(mut self, input: crate::model::QueryStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Limits the returned queries to only those that have the specified status. Valid values are <code>Cancelled</code>, <code>Complete</code>, <code>Failed</code>, <code>Running</code>, and <code>Scheduled</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueryStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Limits the number of returned queries to the specified number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits the number of returned queries to the specified number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. The token expires after 24 hours.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. The token expires after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQueryDefinitions`.
    ///
    /// <p>This operation returns a paginated list of your saved CloudWatch Logs Insights query definitions.</p>
    /// <p>You can use the <code>queryDefinitionNamePrefix</code> parameter to limit the results to only the query definitions that have names that start with a certain string.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeQueryDefinitions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_query_definitions_input::Builder,
    }
    impl DescribeQueryDefinitions {
        /// Creates a new `DescribeQueryDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQueryDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQueryDefinitionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use this parameter to filter your results to only the query definitions that have names that start with the prefix you specify.</p>
        pub fn query_definition_name_prefix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.query_definition_name_prefix(input.into());
            self
        }
        /// <p>Use this parameter to filter your results to only the query definitions that have names that start with the prefix you specify.</p>
        pub fn set_query_definition_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_definition_name_prefix(input);
            self
        }
        /// <p>Limits the number of returned query definitions to the specified number.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Limits the number of returned query definitions to the specified number.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of items to return. The token expires after 24 hours.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. The token expires after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResourcePolicies`.
    ///
    /// <p>Lists the resource policies in this account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResourcePolicies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resource_policies_input::Builder,
    }
    impl DescribeResourcePolicies {
        /// Creates a new `DescribeResourcePolicies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResourcePoliciesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResourcePoliciesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of items to return. The token expires after 24 hours.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. The token expires after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of resource policies to be displayed with one call of this API.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of resource policies to be displayed with one call of this API.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSubscriptionFilters`.
    ///
    /// <p>Lists the subscription filters for the specified log group. You can list all the subscription filters or filter the results by prefix. The results are ASCII-sorted by filter name.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSubscriptionFilters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_subscription_filters_input::Builder,
    }
    impl DescribeSubscriptionFilters {
        /// Creates a new `DescribeSubscriptionFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSubscriptionFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSubscriptionFiltersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSubscriptionFiltersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSubscriptionFiltersPaginator {
            crate::paginator::DescribeSubscriptionFiltersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The prefix to match. If you don't specify a value, no prefix filter is applied.</p>
        pub fn filter_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name_prefix(input.into());
            self
        }
        /// <p>The prefix to match. If you don't specify a value, no prefix filter is applied.</p>
        pub fn set_filter_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_name_prefix(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of items returned. If you don't specify a value, the default is up to 50 items.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateKmsKey`.
    ///
    /// <p>Disassociates the associated Key Management Service customer master key (CMK) from the specified log group.</p>
    /// <p>After the KMS CMK is disassociated from the log group, CloudWatch Logs stops encrypting newly ingested data for the log group. All previously ingested data remains encrypted, and CloudWatch Logs requires permissions for the CMK whenever the encrypted data is requested.</p>
    /// <p>Note that it can take up to 5 minutes for this operation to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateKmsKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_kms_key_input::Builder,
    }
    impl DisassociateKmsKey {
        /// Creates a new `DisassociateKmsKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateKmsKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateKmsKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `FilterLogEvents`.
    ///
    /// <p>Lists log events from the specified log group. You can list all the log events or filter the results using a filter pattern, a time range, and the name of the log stream.</p>
    /// <p>By default, this operation returns as many log events as can fit in 1 MB (up to 10,000 log events) or all the events found within the time range that you specify. If the results include a token, then there are more log events available, and you can get additional results by specifying the token in a subsequent call. This operation can return empty results while there are more log events available through the token.</p>
    /// <p>The returned log events are sorted by event timestamp, the timestamp when the event was ingested by CloudWatch Logs, and the ID of the <code>PutLogEvents</code> request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct FilterLogEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::filter_log_events_input::Builder,
    }
    impl FilterLogEvents {
        /// Creates a new `FilterLogEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::FilterLogEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::FilterLogEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::FilterLogEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::FilterLogEventsPaginator {
            crate::paginator::FilterLogEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the log group to search.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group to search.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// Appends an item to `logStreamNames`.
        ///
        /// To override the contents of this collection use [`set_log_stream_names`](Self::set_log_stream_names).
        ///
        /// <p>Filters the results to only logs from the log streams in this list.</p>
        /// <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>
        pub fn log_stream_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_names(input.into());
            self
        }
        /// <p>Filters the results to only logs from the log streams in this list.</p>
        /// <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>
        pub fn set_log_stream_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_names(input);
            self
        }
        /// <p>Filters the results to include only events from log streams that have names starting with this prefix.</p>
        /// <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but the value for <code>logStreamNamePrefix</code> does not match any log stream names specified in <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>
        pub fn log_stream_name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name_prefix(input.into());
            self
        }
        /// <p>Filters the results to include only events from log streams that have names starting with this prefix.</p>
        /// <p>If you specify a value for both <code>logStreamNamePrefix</code> and <code>logStreamNames</code>, but the value for <code>logStreamNamePrefix</code> does not match any log stream names specified in <code>logStreamNames</code>, the action returns an <code>InvalidParameterException</code> error.</p>
        pub fn set_log_stream_name_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name_prefix(input);
            self
        }
        /// <p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time are not returned.</p>
        pub fn start_time(mut self, input: i64) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp before this time are not returned.</p>
        pub fn set_start_time(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not returned.</p>
        pub fn end_time(mut self, input: i64) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp later than this time are not returned.</p>
        pub fn set_end_time(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The filter pattern to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a>.</p>
        /// <p>If not provided, all the events are matched.</p>
        pub fn filter_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_pattern(input.into());
            self
        }
        /// <p>The filter pattern to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a>.</p>
        /// <p>If not provided, all the events are matched.</p>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_pattern(input);
            self
        }
        /// <p>The token for the next set of events to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of events to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of events to return. The default is 10,000 events.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of events to return. The default is 10,000 events.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If the value is true, the operation makes a best effort to provide responses that contain events from multiple log streams within the log group, interleaved in a single response. If the value is false, all the matched log events in the first log stream are searched first, then those in the next log stream, and so on. The default is false.</p>
        /// <p> <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be true. The response from this operation always interleaves events from multiple log streams within a log group.</p>
        pub fn interleaved(mut self, input: bool) -> Self {
            self.inner = self.inner.interleaved(input);
            self
        }
        /// <p>If the value is true, the operation makes a best effort to provide responses that contain events from multiple log streams within the log group, interleaved in a single response. If the value is false, all the matched log events in the first log stream are searched first, then those in the next log stream, and so on. The default is false.</p>
        /// <p> <b>Important:</b> Starting on June 17, 2019, this parameter is ignored and the value is assumed to be true. The response from this operation always interleaves events from multiple log streams within a log group.</p>
        pub fn set_interleaved(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_interleaved(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLogEvents`.
    ///
    /// <p>Lists log events from the specified log stream. You can list all of the log events or filter using a time range.</p>
    /// <p>By default, this operation returns as many log events as can fit in a response size of 1MB (up to 10,000 log events). You can get additional log events by specifying one of the tokens in a subsequent call. This operation can return empty results while there are more log events available through the token.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLogEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_log_events_input::Builder,
    }
    impl GetLogEvents {
        /// Creates a new `GetLogEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLogEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLogEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetLogEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetLogEventsPaginator {
            crate::paginator::GetLogEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name(input.into());
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name(input);
            self
        }
        /// <p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this time or later than this time are included. Events with a timestamp earlier than this time are not included.</p>
        pub fn start_time(mut self, input: i64) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to this time or later than this time are included. Events with a timestamp earlier than this time are not included.</p>
        pub fn set_start_time(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than this time are not included.</p>
        pub fn end_time(mut self, input: i64) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time range, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp equal to or later than this time are not included.</p>
        pub fn set_end_time(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of items to return. (You received this token from a previous call.)</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as can fit in a response size of 1 MB, up to 10,000 log events.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of log events returned. If you don't specify a value, the maximum is as many log events as can fit in a response size of 1 MB, up to 10,000 log events.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
        /// <p>If the value is true, the earliest log events are returned first. If the value is false, the latest log events are returned first. The default value is false.</p>
        /// <p>If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this operation, you must specify <code>true</code> for <code>startFromHead</code>.</p>
        pub fn start_from_head(mut self, input: bool) -> Self {
            self.inner = self.inner.start_from_head(input);
            self
        }
        /// <p>If the value is true, the earliest log events are returned first. If the value is false, the latest log events are returned first. The default value is false.</p>
        /// <p>If you are using a previous <code>nextForwardToken</code> value as the <code>nextToken</code> in this operation, you must specify <code>true</code> for <code>startFromHead</code>.</p>
        pub fn set_start_from_head(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_start_from_head(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLogGroupFields`.
    ///
    /// <p>Returns a list of the fields that are included in log events in the specified log group, along with the percentage of log events that contain each field. The search is limited to a time period that you specify.</p>
    /// <p>In the results, fields that start with @ are fields generated by CloudWatch Logs. For example, <code>@timestamp</code> is the timestamp of each log event. For more information about the fields that are generated by CloudWatch logs, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html">Supported Logs and Discovered Fields</a>.</p>
    /// <p>The response results are sorted by the frequency percentage, starting with the highest percentage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLogGroupFields {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_log_group_fields_input::Builder,
    }
    impl GetLogGroupFields {
        /// Creates a new `GetLogGroupFields`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLogGroupFieldsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLogGroupFieldsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group to search.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group to search.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The time to set as the center of the query. If you specify <code>time</code>, the 15 minutes before this time are queries. If you omit <code>time</code> the 8 minutes before and 8 minutes after this time are searched.</p>
        /// <p>The <code>time</code> value is specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
        pub fn time(mut self, input: i64) -> Self {
            self.inner = self.inner.time(input);
            self
        }
        /// <p>The time to set as the center of the query. If you specify <code>time</code>, the 15 minutes before this time are queries. If you omit <code>time</code> the 8 minutes before and 8 minutes after this time are searched.</p>
        /// <p>The <code>time</code> value is specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
        pub fn set_time(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLogRecord`.
    ///
    /// <p>Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original query that produced the <code>logRecordPointer</code> retrieved only a subset of fields. Fields are returned as field name/field value pairs.</p>
    /// <p>The full unparsed log event is returned within <code>@message</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLogRecord {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_log_record_input::Builder,
    }
    impl GetLogRecord {
        /// Creates a new `GetLogRecord`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLogRecordOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLogRecordError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pointer corresponding to the log event record you want to retrieve. You get this from the response of a <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code> field for a log event is the value to use as <code>logRecordPointer</code> to retrieve that complete log event record.</p>
        pub fn log_record_pointer(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_record_pointer(input.into());
            self
        }
        /// <p>The pointer corresponding to the log event record you want to retrieve. You get this from the response of a <code>GetQueryResults</code> operation. In that response, the value of the <code>@ptr</code> field for a log event is the value to use as <code>logRecordPointer</code> to retrieve that complete log event record.</p>
        pub fn set_log_record_pointer(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_record_pointer(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueryResults`.
    ///
    /// <p>Returns the results from the specified query.</p>
    /// <p>Only the fields requested in the query are returned, along with a <code>@ptr</code> field, which is the identifier for the log record. You can use the value of <code>@ptr</code> in a <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogRecord.html">GetLogRecord</a> operation to get the full log record.</p>
    /// <p> <code>GetQueryResults</code> does not start a query execution. To run a query, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>.</p>
    /// <p>If the value of the <code>Status</code> field in the output is <code>Running</code>, this operation returns only partial results. If you see a value of <code>Scheduled</code> or <code>Running</code> for the status, you can retry the operation later to see the final results. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetQueryResults {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_query_results_input::Builder,
    }
    impl GetQueryResults {
        /// Creates a new `GetQueryResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueryResultsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueryResultsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID number of the query.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_id(input.into());
            self
        }
        /// <p>The ID number of the query.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsLogGroup`.
    ///
    /// <p>Lists the tags for the specified log group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsLogGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_log_group_input::Builder,
    }
    impl ListTagsLogGroup {
        /// Creates a new `ListTagsLogGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsLogGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsLogGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDestination`.
    ///
    /// <p>Creates or updates a destination. This operation is used only to create destinations for cross-account subscriptions.</p>
    /// <p>A destination encapsulates a physical resource (such as an Amazon Kinesis stream) and enables you to subscribe to a real-time stream of log events for a different account, ingested using <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html">PutLogEvents</a>.</p>
    /// <p>Through an access policy, a destination controls what is written to it. By default, <code>PutDestination</code> does not set any access policy with the destination, which means a cross-account user cannot call <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutSubscriptionFilter.html">PutSubscriptionFilter</a> against this destination. To enable this, the destination owner must call <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html">PutDestinationPolicy</a> after <code>PutDestination</code>.</p>
    /// <p>To perform a <code>PutDestination</code> operation, you must also have the <code>iam:PassRole</code> permission.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDestination {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_destination_input::Builder,
    }
    impl PutDestination {
        /// Creates a new `PutDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDestinationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the destination.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(input.into());
            self
        }
        /// <p>A name for the destination.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>The ARN of an Amazon Kinesis stream to which to deliver matching log events.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The ARN of an Amazon Kinesis stream to which to deliver matching log events.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The ARN of an IAM role that grants CloudWatch Logs permissions to call the Amazon Kinesis <code>PutRecord</code> operation on the destination stream.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of an IAM role that grants CloudWatch Logs permissions to call the Amazon Kinesis <code>PutRecord</code> operation on the destination stream.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutDestinationPolicy`.
    ///
    /// <p>Creates or updates an access policy associated with an existing destination. An access policy is an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html">IAM policy document</a> that is used to authorize claims to register a subscription filter against a given destination.</p>
    /// <p>If multiple Amazon Web Services accounts are sending logs to this destination, each sender account must be listed separately in the policy. The policy does not support specifying <code>*</code> as the Principal or the use of the <code>aws:PrincipalOrgId</code> global key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutDestinationPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_destination_policy_input::Builder,
    }
    impl PutDestinationPolicy {
        /// Creates a new `PutDestinationPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutDestinationPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutDestinationPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for an existing destination.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_name(input.into());
            self
        }
        /// <p>A name for an existing destination.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_name(input);
            self
        }
        /// <p>An IAM policy document that authorizes cross-account users to deliver their log events to the associated destination. This can be up to 5120 bytes.</p>
        pub fn access_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_policy(input.into());
            self
        }
        /// <p>An IAM policy document that authorizes cross-account users to deliver their log events to the associated destination. This can be up to 5120 bytes.</p>
        pub fn set_access_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_policy(input);
            self
        }
        /// <p>Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts. Before you update a destination policy this way, you must first update the subscription filters in the accounts that send logs to this destination. If you do not, the subscription filters might stop working. By specifying <code>true</code> for <code>forceUpdate</code>, you are affirming that you have already updated the subscription filters. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html"> Updating an existing cross-account subscription</a> </p>
        /// <p>If you omit this parameter, the default of <code>false</code> is used.</p>
        pub fn force_update(mut self, input: bool) -> Self {
            self.inner = self.inner.force_update(input);
            self
        }
        /// <p>Specify true if you are updating an existing destination policy to grant permission to an organization ID instead of granting permission to individual AWS accounts. Before you update a destination policy this way, you must first update the subscription filters in the accounts that send logs to this destination. If you do not, the subscription filters might stop working. By specifying <code>true</code> for <code>forceUpdate</code>, you are affirming that you have already updated the subscription filters. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html"> Updating an existing cross-account subscription</a> </p>
        /// <p>If you omit this parameter, the default of <code>false</code> is used.</p>
        pub fn set_force_update(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_update(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutLogEvents`.
    ///
    /// <p>Uploads a batch of log events to the specified log stream.</p>
    /// <p>You must include the sequence token obtained from the response of the previous call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token in the <code>expectedSequenceToken</code> field from <code>InvalidSequenceTokenException</code>. If you call <code>PutLogEvents</code> twice within a narrow time period using the same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.</p>
    /// <p>The batch of events must satisfy the following constraints:</p>
    /// <ul>
    /// <li> <p>The maximum batch size is 1,048,576 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.</p> </li>
    /// <li> <p>None of the log events in the batch can be more than 2 hours in the future.</p> </li>
    /// <li> <p>None of the log events in the batch can be older than 14 days or older than the retention period of the log group.</p> </li>
    /// <li> <p>The log events in the batch must be in chronological order by their timestamp. The timestamp is the time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. (In Amazon Web Services Tools for PowerShell and the Amazon Web Services SDK for .NET, the timestamp is specified in .NET format: yyyy-mm-ddThh:mm:ss. For example, 2017-09-15T13:45:30.) </p> </li>
    /// <li> <p>A batch of log events in a single request cannot span more than 24 hours. Otherwise, the operation fails.</p> </li>
    /// <li> <p>The maximum number of log events in a batch is 10,000.</p> </li>
    /// <li> <p>There is a quota of 5 requests per second per log stream. Additional requests are throttled. This quota can't be changed.</p> </li>
    /// </ul>
    /// <p>If a call to <code>PutLogEvents</code> returns "UnrecognizedClientException" the most likely cause is an invalid Amazon Web Services access key ID or secret key. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutLogEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_log_events_input::Builder,
    }
    impl PutLogEvents {
        /// Creates a new `PutLogEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutLogEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutLogEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name(input.into());
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name(input);
            self
        }
        /// Appends an item to `logEvents`.
        ///
        /// To override the contents of this collection use [`set_log_events`](Self::set_log_events).
        ///
        /// <p>The log events.</p>
        pub fn log_events(mut self, input: crate::model::InputLogEvent) -> Self {
            self.inner = self.inner.log_events(input);
            self
        }
        /// <p>The log events.</p>
        pub fn set_log_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputLogEvent>>,
        ) -> Self {
            self.inner = self.inner.set_log_events(input);
            self
        }
        /// <p>The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token using <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html">DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using the same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.</p>
        pub fn sequence_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sequence_token(input.into());
            self
        }
        /// <p>The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An upload in a newly created log stream does not require a sequence token. You can also get the sequence token using <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html">DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using the same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.</p>
        pub fn set_sequence_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sequence_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutMetricFilter`.
    ///
    /// <p>Creates or updates a metric filter and associates it with the specified log group. Metric filters allow you to configure rules to extract metric data from log events ingested through <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html">PutLogEvents</a>.</p>
    /// <p>The maximum number of metric filters that can be associated with a log group is 100.</p>
    /// <p>When you create a metric filter, you can also optionally assign a unit and dimensions to the metric that is created.</p> <important>
    /// <p>Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not specify high-cardinality fields such as <code>IPAddress</code> or <code>requestID</code> as dimensions. Each different value found for a dimension is treated as a separate metric and accrues charges as a separate custom metric. </p>
    /// <p>To help prevent accidental high charges, Amazon disables a metric filter if it generates 1000 different name/value pairs for the dimensions that you have specified within a certain amount of time.</p>
    /// <p>You can also set up a billing alarm to alert you if your charges are higher than expected. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html"> Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>. </p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutMetricFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_metric_filter_input::Builder,
    }
    impl PutMetricFilter {
        /// Creates a new `PutMetricFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutMetricFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::PutMetricFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>A name for the metric filter.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(input.into());
            self
        }
        /// <p>A name for the metric filter.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
        /// <p>A filter pattern for extracting metric data out of ingested log events.</p>
        pub fn filter_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_pattern(input.into());
            self
        }
        /// <p>A filter pattern for extracting metric data out of ingested log events.</p>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_pattern(input);
            self
        }
        /// Appends an item to `metricTransformations`.
        ///
        /// To override the contents of this collection use [`set_metric_transformations`](Self::set_metric_transformations).
        ///
        /// <p>A collection of information that defines how metric data gets emitted.</p>
        pub fn metric_transformations(mut self, input: crate::model::MetricTransformation) -> Self {
            self.inner = self.inner.metric_transformations(input);
            self
        }
        /// <p>A collection of information that defines how metric data gets emitted.</p>
        pub fn set_metric_transformations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricTransformation>>,
        ) -> Self {
            self.inner = self.inner.set_metric_transformations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutQueryDefinition`.
    ///
    /// <p>Creates or updates a query definition for CloudWatch Logs Insights. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html">Analyzing Log Data with CloudWatch Logs Insights</a>.</p>
    /// <p>To update a query definition, specify its <code>queryDefinitionId</code> in your request. The values of <code>name</code>, <code>queryString</code>, and <code>logGroupNames</code> are changed to the values that you specify in your update operation. No current values are retained from the current query definition. For example, if you update a current query definition that includes log groups, and you don't specify the <code>logGroupNames</code> parameter in your update operation, the query definition changes to contain no log groups.</p>
    /// <p>You must have the <code>logs:PutQueryDefinition</code> permission to be able to perform this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutQueryDefinition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_query_definition_input::Builder,
    }
    impl PutQueryDefinition {
        /// Creates a new `PutQueryDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutQueryDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutQueryDefinitionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name for the query definition. If you are saving a lot of query definitions, we recommend that you name them so that you can easily find the ones you want by using the first part of the name as a filter in the <code>queryDefinitionNamePrefix</code> parameter of <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A name for the query definition. If you are saving a lot of query definitions, we recommend that you name them so that you can easily find the ones you want by using the first part of the name as a filter in the <code>queryDefinitionNamePrefix</code> parameter of <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If you are updating a query definition, use this parameter to specify the ID of the query definition that you want to update. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p>
        /// <p>If you are creating a query definition, do not specify this parameter. CloudWatch generates a unique ID for the new query definition and include it in the response to this operation.</p>
        pub fn query_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_definition_id(input.into());
            self
        }
        /// <p>If you are updating a query definition, use this parameter to specify the ID of the query definition that you want to update. You can use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeQueryDefinitions.html">DescribeQueryDefinitions</a> to retrieve the IDs of your saved query definitions.</p>
        /// <p>If you are creating a query definition, do not specify this parameter. CloudWatch generates a unique ID for the new query definition and include it in the response to this operation.</p>
        pub fn set_query_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_query_definition_id(input);
            self
        }
        /// Appends an item to `logGroupNames`.
        ///
        /// To override the contents of this collection use [`set_log_group_names`](Self::set_log_group_names).
        ///
        /// <p>Use this parameter to include specific log groups as part of your query definition.</p>
        /// <p>If you are updating a query definition and you omit this parameter, then the updated definition will contain no log groups.</p>
        pub fn log_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_names(input.into());
            self
        }
        /// <p>Use this parameter to include specific log groups as part of your query definition.</p>
        /// <p>If you are updating a query definition and you omit this parameter, then the updated definition will contain no log groups.</p>
        pub fn set_log_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_log_group_names(input);
            self
        }
        /// <p>The query string to use for this definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The query string to use for this definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutResourcePolicy`.
    ///
    /// <p>Creates or updates a resource policy allowing other Amazon Web Services services to put log events to this account, such as Amazon Route 53. An account can have up to 10 resource policies per Amazon Web Services Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutResourcePolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_resource_policy_input::Builder,
    }
    impl PutResourcePolicy {
        /// Creates a new `PutResourcePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutResourcePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutResourcePolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the new policy. This parameter is required.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_name(input.into());
            self
        }
        /// <p>Name of the new policy. This parameter is required.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy_name(input);
            self
        }
        /// <p>Details of the new policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. This parameter is required.</p>
        /// <p>The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to the specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs resource, such as a log group or log stream.</p>
        /// <p>CloudWatch Logs also supports <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn">aws:SourceArn</a> and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount">aws:SourceAccount</a> condition context keys.</p>
        /// <p>In the example resource policy, you would replace the value of <code>SourceArn</code> with the resource making the call from Route&nbsp;53 to CloudWatch Logs and replace the value of <code>SourceAccount</code> with the Amazon Web Services account ID making that call.</p>
        /// <p></p>
        /// <p> <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code> </p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy_document(input.into());
            self
        }
        /// <p>Details of the new policy, including the identity of the principal that is enabled to put logs to this account. This is formatted as a JSON string. This parameter is required.</p>
        /// <p>The following example creates a resource policy enabling the Route 53 service to put DNS query logs in to the specified log group. Replace <code>"logArn"</code> with the ARN of your CloudWatch Logs resource, such as a log group or log stream.</p>
        /// <p>CloudWatch Logs also supports <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourcearn">aws:SourceArn</a> and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-sourceaccount">aws:SourceAccount</a> condition context keys.</p>
        /// <p>In the example resource policy, you would replace the value of <code>SourceArn</code> with the resource making the call from Route&nbsp;53 to CloudWatch Logs and replace the value of <code>SourceAccount</code> with the Amazon Web Services account ID making that call.</p>
        /// <p></p>
        /// <p> <code>{ "Version": "2012-10-17", "Statement": [ { "Sid": "Route53LogsToCloudWatchLogs", "Effect": "Allow", "Principal": { "Service": [ "route53.amazonaws.com" ] }, "Action": "logs:PutLogEvents", "Resource": "logArn", "Condition": { "ArnLike": { "aws:SourceArn": "myRoute53ResourceArn" }, "StringEquals": { "aws:SourceAccount": "myAwsAccountId" } } } ] }</code> </p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_policy_document(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRetentionPolicy`.
    ///
    /// <p>Sets the retention of the specified log group. A retention policy allows you to configure the number of days for which to retain log events in the specified log group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRetentionPolicy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_retention_policy_input::Builder,
    }
    impl PutRetentionPolicy {
        /// Creates a new `PutRetentionPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRetentionPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRetentionPolicyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p>
        /// <p>To set a log group to never have log events expire, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>. </p>
        pub fn retention_in_days(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_in_days(input);
            self
        }
        /// <p>The number of days to retain the log events in the specified log group. Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p>
        /// <p>To set a log group to never have log events expire, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>. </p>
        pub fn set_retention_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_in_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutSubscriptionFilter`.
    ///
    /// <p>Creates or updates a subscription filter and associates it with the specified log group. Subscription filters allow you to subscribe to a real-time stream of log events ingested through <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html">PutLogEvents</a> and have them delivered to a specific destination. When log events are sent to the receiving service, they are Base64 encoded and compressed with the gzip format.</p>
    /// <p>The following destinations are supported for subscription filters:</p>
    /// <ul>
    /// <li> <p>An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li>
    /// <li> <p>A logical destination that belongs to a different account, for cross-account delivery.</p> </li>
    /// <li> <p>An Amazon Kinesis Firehose delivery stream that belongs to the same account as the subscription filter, for same-account delivery.</p> </li>
    /// <li> <p>An Lambda function that belongs to the same account as the subscription filter, for same-account delivery.</p> </li>
    /// </ul>
    /// <p>Each log group can have up to two subscription filters associated with it. If you are updating an existing filter, you must specify the correct name in <code>filterName</code>. </p>
    /// <p>To perform a <code>PutSubscriptionFilter</code> operation, you must also have the <code>iam:PassRole</code> permission.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutSubscriptionFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_subscription_filter_input::Builder,
    }
    impl PutSubscriptionFilter {
        /// Creates a new `PutSubscriptionFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutSubscriptionFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::PutSubscriptionFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// <p>A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html">DescribeSubscriptionFilters</a>.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_name(input.into());
            self
        }
        /// <p>A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in <code>filterName</code>. To find the name of the filter currently associated with a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeSubscriptionFilters.html">DescribeSubscriptionFilters</a>.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_filter_name(input);
            self
        }
        /// <p>A filter pattern for subscribing to a filtered stream of log events.</p>
        pub fn filter_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_pattern(input.into());
            self
        }
        /// <p>A filter pattern for subscribing to a filtered stream of log events.</p>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_pattern(input);
            self
        }
        /// <p>The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:</p>
        /// <ul>
        /// <li> <p>An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li>
        /// <li> <p>A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.</p> <p>If you are setting up a cross-account subscription, the destination must have an IAM policy associated with it that allows the sender to send logs to the destination. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html">PutDestinationPolicy</a>.</p> </li>
        /// <li> <p>An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li>
        /// <li> <p>A Lambda function belonging to the same account as the subscription filter, for same-account delivery.</p> </li>
        /// </ul>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_arn(input.into());
            self
        }
        /// <p>The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:</p>
        /// <ul>
        /// <li> <p>An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li>
        /// <li> <p>A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.</p> <p>If you are setting up a cross-account subscription, the destination must have an IAM policy associated with it that allows the sender to send logs to the destination. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html">PutDestinationPolicy</a>.</p> </li>
        /// <li> <p>An Amazon Kinesis Firehose delivery stream belonging to the same account as the subscription filter, for same-account delivery.</p> </li>
        /// <li> <p>A Lambda function belonging to the same account as the subscription filter, for same-account delivery.</p> </li>
        /// </ul>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_arn(input);
            self
        }
        /// <p>The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination stream. You don't need to provide the ARN when you are working with a logical destination for cross-account delivery.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. </p>
        pub fn distribution(mut self, input: crate::model::Distribution) -> Self {
            self.inner = self.inner.distribution(input);
            self
        }
        /// <p>The method used to distribute log data to the destination. By default, log data is grouped by log stream, but the grouping can be set to random for a more even distribution. This property is only applicable when the destination is an Amazon Kinesis stream. </p>
        pub fn set_distribution(
            mut self,
            input: std::option::Option<crate::model::Distribution>,
        ) -> Self {
            self.inner = self.inner.set_distribution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartQuery`.
    ///
    /// <p>Schedules a query of a log group using CloudWatch Logs Insights. You specify the log group and time range to query and the query string to use.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
    /// <p>Queries time out after 15 minutes of execution. If your queries are timing out, reduce the time range being searched or partition your query into a number of queries.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartQuery {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_query_input::Builder,
    }
    impl StartQuery {
        /// Creates a new `StartQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::StartQueryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The log group on which to perform the query.</p>
        /// <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The log group on which to perform the query.</p>
        /// <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// Appends an item to `logGroupNames`.
        ///
        /// To override the contents of this collection use [`set_log_group_names`](Self::set_log_group_names).
        ///
        /// <p>The list of log groups to be queried. You can include up to 20 log groups.</p>
        /// <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>
        pub fn log_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_names(input.into());
            self
        }
        /// <p>The list of log groups to be queried. You can include up to 20 log groups.</p>
        /// <p>A <code>StartQuery</code> operation must include a <code>logGroupNames</code> or a <code>logGroupName</code> parameter, but not both.</p>
        pub fn set_log_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_log_group_names(input);
            self
        }
        /// <p>The beginning of the time range to query. The range is inclusive, so the specified start time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
        pub fn start_time(mut self, input: i64) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The beginning of the time range to query. The range is inclusive, so the specified start time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
        pub fn set_start_time(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time range to query. The range is inclusive, so the specified end time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
        pub fn end_time(mut self, input: i64) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time range to query. The range is inclusive, so the specified end time is included in the query. Specified as epoch time, the number of seconds since January 1, 1970, 00:00:00 UTC.</p>
        pub fn set_end_time(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The query string to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_string(input.into());
            self
        }
        /// <p>The query string to use. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_string(input);
            self
        }
        /// <p>The maximum number of log events to return in the query. If the query string uses the <code>fields</code> command, only the specified fields and their values are returned. The default is 1000.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of log events to return in the query. If the query string uses the <code>fields</code> command, only the specified fields and their values are returned. The default is 1000.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopQuery`.
    ///
    /// <p>Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended, the operation returns an error indicating that the specified query is not running.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopQuery {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_query_input::Builder,
    }
    impl StopQuery {
        /// Creates a new `StopQuery`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopQueryOutput,
            aws_smithy_http::result::SdkError<crate::error::StopQueryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID number of the query to stop. To find this ID number, use <code>DescribeQueries</code>.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.query_id(input.into());
            self
        }
        /// <p>The ID number of the query to stop. To find this ID number, use <code>DescribeQueries</code>.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_query_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagLogGroup`.
    ///
    /// <p>Adds or updates the specified tags for the specified log group.</p>
    /// <p>To list the tags for a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsLogGroup.html">ListTagsLogGroup</a>. To remove tags, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagLogGroup.html">UntagLogGroup</a>.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html#log-group-tagging">Tag Log Groups in Amazon CloudWatch Logs</a> in the <i>Amazon CloudWatch Logs User Guide</i>.</p>
    /// <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information about using tags to control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagLogGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_log_group_input::Builder,
    }
    impl TagLogGroup {
        /// Creates a new `TagLogGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagLogGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::TagLogGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to use for the tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The key-value pairs to use for the tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestMetricFilter`.
    ///
    /// <p>Tests the filter pattern of a metric filter against a sample of log event messages. You can use this operation to validate the correctness of a metric filter pattern.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestMetricFilter {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::test_metric_filter_input::Builder,
    }
    impl TestMetricFilter {
        /// Creates a new `TestMetricFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestMetricFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::TestMetricFilterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.</p>
        pub fn filter_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_pattern(input.into());
            self
        }
        /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.</p>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_pattern(input);
            self
        }
        /// Appends an item to `logEventMessages`.
        ///
        /// To override the contents of this collection use [`set_log_event_messages`](Self::set_log_event_messages).
        ///
        /// <p>The log event messages to test.</p>
        pub fn log_event_messages(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_event_messages(input.into());
            self
        }
        /// <p>The log event messages to test.</p>
        pub fn set_log_event_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_log_event_messages(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagLogGroup`.
    ///
    /// <p>Removes the specified tags from the specified log group.</p>
    /// <p>To list the tags for a log group, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsLogGroup.html">ListTagsLogGroup</a>. To add tags, use <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagLogGroup.html">TagLogGroup</a>.</p>
    /// <p>CloudWatch Logs doesn’t support IAM policies that prevent users from assigning specified tags to log groups using the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagLogGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_log_group_input::Builder,
    }
    impl UntagLogGroup {
        /// Creates a new `UntagLogGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagLogGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagLogGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_group_name(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_group_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys. The corresponding tags are removed from the log group.</p>
        pub fn tags(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tags(input.into());
            self
        }
        /// <p>The tag keys. The corresponding tags are removed from the log group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
