// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateKmsKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_kms_key`](crate::client::Client::associate_kms_key).
///
/// See [`crate::client::fluent_builders::AssociateKmsKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateKmsKey {
    _private: (),
}
impl AssociateKmsKey {
    /// Creates a new builder-style object to manufacture [`AssociateKmsKeyInput`](crate::input::AssociateKmsKeyInput)
    pub fn builder() -> crate::input::associate_kms_key_input::Builder {
        crate::input::associate_kms_key_input::Builder::default()
    }
    /// Creates a new `AssociateKmsKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateKmsKey {
    type Output = std::result::Result<
        crate::output::AssociateKmsKeyOutput,
        crate::error::AssociateKmsKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_kms_key_error(response)
        } else {
            crate::operation_deser::parse_associate_kms_key_response(response)
        }
    }
}

/// Operation shape for `CancelExportTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_export_task`](crate::client::Client::cancel_export_task).
///
/// See [`crate::client::fluent_builders::CancelExportTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelExportTask {
    _private: (),
}
impl CancelExportTask {
    /// Creates a new builder-style object to manufacture [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
    pub fn builder() -> crate::input::cancel_export_task_input::Builder {
        crate::input::cancel_export_task_input::Builder::default()
    }
    /// Creates a new `CancelExportTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelExportTask {
    type Output = std::result::Result<
        crate::output::CancelExportTaskOutput,
        crate::error::CancelExportTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_export_task_error(response)
        } else {
            crate::operation_deser::parse_cancel_export_task_response(response)
        }
    }
}

/// Operation shape for `CreateExportTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_export_task`](crate::client::Client::create_export_task).
///
/// See [`crate::client::fluent_builders::CreateExportTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateExportTask {
    _private: (),
}
impl CreateExportTask {
    /// Creates a new builder-style object to manufacture [`CreateExportTaskInput`](crate::input::CreateExportTaskInput)
    pub fn builder() -> crate::input::create_export_task_input::Builder {
        crate::input::create_export_task_input::Builder::default()
    }
    /// Creates a new `CreateExportTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateExportTask {
    type Output = std::result::Result<
        crate::output::CreateExportTaskOutput,
        crate::error::CreateExportTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_export_task_error(response)
        } else {
            crate::operation_deser::parse_create_export_task_response(response)
        }
    }
}

/// Operation shape for `CreateLogGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_log_group`](crate::client::Client::create_log_group).
///
/// See [`crate::client::fluent_builders::CreateLogGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLogGroup {
    _private: (),
}
impl CreateLogGroup {
    /// Creates a new builder-style object to manufacture [`CreateLogGroupInput`](crate::input::CreateLogGroupInput)
    pub fn builder() -> crate::input::create_log_group_input::Builder {
        crate::input::create_log_group_input::Builder::default()
    }
    /// Creates a new `CreateLogGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLogGroup {
    type Output =
        std::result::Result<crate::output::CreateLogGroupOutput, crate::error::CreateLogGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_log_group_error(response)
        } else {
            crate::operation_deser::parse_create_log_group_response(response)
        }
    }
}

/// Operation shape for `CreateLogStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_log_stream`](crate::client::Client::create_log_stream).
///
/// See [`crate::client::fluent_builders::CreateLogStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLogStream {
    _private: (),
}
impl CreateLogStream {
    /// Creates a new builder-style object to manufacture [`CreateLogStreamInput`](crate::input::CreateLogStreamInput)
    pub fn builder() -> crate::input::create_log_stream_input::Builder {
        crate::input::create_log_stream_input::Builder::default()
    }
    /// Creates a new `CreateLogStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLogStream {
    type Output = std::result::Result<
        crate::output::CreateLogStreamOutput,
        crate::error::CreateLogStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_log_stream_error(response)
        } else {
            crate::operation_deser::parse_create_log_stream_response(response)
        }
    }
}

/// Operation shape for `DeleteDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_destination`](crate::client::Client::delete_destination).
///
/// See [`crate::client::fluent_builders::DeleteDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDestination {
    _private: (),
}
impl DeleteDestination {
    /// Creates a new builder-style object to manufacture [`DeleteDestinationInput`](crate::input::DeleteDestinationInput)
    pub fn builder() -> crate::input::delete_destination_input::Builder {
        crate::input::delete_destination_input::Builder::default()
    }
    /// Creates a new `DeleteDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDestination {
    type Output = std::result::Result<
        crate::output::DeleteDestinationOutput,
        crate::error::DeleteDestinationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_destination_error(response)
        } else {
            crate::operation_deser::parse_delete_destination_response(response)
        }
    }
}

/// Operation shape for `DeleteLogGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_log_group`](crate::client::Client::delete_log_group).
///
/// See [`crate::client::fluent_builders::DeleteLogGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLogGroup {
    _private: (),
}
impl DeleteLogGroup {
    /// Creates a new builder-style object to manufacture [`DeleteLogGroupInput`](crate::input::DeleteLogGroupInput)
    pub fn builder() -> crate::input::delete_log_group_input::Builder {
        crate::input::delete_log_group_input::Builder::default()
    }
    /// Creates a new `DeleteLogGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLogGroup {
    type Output =
        std::result::Result<crate::output::DeleteLogGroupOutput, crate::error::DeleteLogGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_log_group_error(response)
        } else {
            crate::operation_deser::parse_delete_log_group_response(response)
        }
    }
}

/// Operation shape for `DeleteLogStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_log_stream`](crate::client::Client::delete_log_stream).
///
/// See [`crate::client::fluent_builders::DeleteLogStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLogStream {
    _private: (),
}
impl DeleteLogStream {
    /// Creates a new builder-style object to manufacture [`DeleteLogStreamInput`](crate::input::DeleteLogStreamInput)
    pub fn builder() -> crate::input::delete_log_stream_input::Builder {
        crate::input::delete_log_stream_input::Builder::default()
    }
    /// Creates a new `DeleteLogStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLogStream {
    type Output = std::result::Result<
        crate::output::DeleteLogStreamOutput,
        crate::error::DeleteLogStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_log_stream_error(response)
        } else {
            crate::operation_deser::parse_delete_log_stream_response(response)
        }
    }
}

/// Operation shape for `DeleteMetricFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_metric_filter`](crate::client::Client::delete_metric_filter).
///
/// See [`crate::client::fluent_builders::DeleteMetricFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMetricFilter {
    _private: (),
}
impl DeleteMetricFilter {
    /// Creates a new builder-style object to manufacture [`DeleteMetricFilterInput`](crate::input::DeleteMetricFilterInput)
    pub fn builder() -> crate::input::delete_metric_filter_input::Builder {
        crate::input::delete_metric_filter_input::Builder::default()
    }
    /// Creates a new `DeleteMetricFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMetricFilter {
    type Output = std::result::Result<
        crate::output::DeleteMetricFilterOutput,
        crate::error::DeleteMetricFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_metric_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_metric_filter_response(response)
        }
    }
}

/// Operation shape for `DeleteQueryDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_query_definition`](crate::client::Client::delete_query_definition).
///
/// See [`crate::client::fluent_builders::DeleteQueryDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteQueryDefinition {
    _private: (),
}
impl DeleteQueryDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteQueryDefinitionInput`](crate::input::DeleteQueryDefinitionInput)
    pub fn builder() -> crate::input::delete_query_definition_input::Builder {
        crate::input::delete_query_definition_input::Builder::default()
    }
    /// Creates a new `DeleteQueryDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteQueryDefinition {
    type Output = std::result::Result<
        crate::output::DeleteQueryDefinitionOutput,
        crate::error::DeleteQueryDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_query_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_query_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_resource_policy`](crate::client::Client::delete_resource_policy).
///
/// See [`crate::client::fluent_builders::DeleteResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteResourcePolicy {
    _private: (),
}
impl DeleteResourcePolicy {
    /// Creates a new builder-style object to manufacture [`DeleteResourcePolicyInput`](crate::input::DeleteResourcePolicyInput)
    pub fn builder() -> crate::input::delete_resource_policy_input::Builder {
        crate::input::delete_resource_policy_input::Builder::default()
    }
    /// Creates a new `DeleteResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteResourcePolicy {
    type Output = std::result::Result<
        crate::output::DeleteResourcePolicyOutput,
        crate::error::DeleteResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_resource_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteRetentionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_retention_policy`](crate::client::Client::delete_retention_policy).
///
/// See [`crate::client::fluent_builders::DeleteRetentionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRetentionPolicy {
    _private: (),
}
impl DeleteRetentionPolicy {
    /// Creates a new builder-style object to manufacture [`DeleteRetentionPolicyInput`](crate::input::DeleteRetentionPolicyInput)
    pub fn builder() -> crate::input::delete_retention_policy_input::Builder {
        crate::input::delete_retention_policy_input::Builder::default()
    }
    /// Creates a new `DeleteRetentionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRetentionPolicy {
    type Output = std::result::Result<
        crate::output::DeleteRetentionPolicyOutput,
        crate::error::DeleteRetentionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_retention_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_retention_policy_response(response)
        }
    }
}

/// Operation shape for `DeleteSubscriptionFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_subscription_filter`](crate::client::Client::delete_subscription_filter).
///
/// See [`crate::client::fluent_builders::DeleteSubscriptionFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSubscriptionFilter {
    _private: (),
}
impl DeleteSubscriptionFilter {
    /// Creates a new builder-style object to manufacture [`DeleteSubscriptionFilterInput`](crate::input::DeleteSubscriptionFilterInput)
    pub fn builder() -> crate::input::delete_subscription_filter_input::Builder {
        crate::input::delete_subscription_filter_input::Builder::default()
    }
    /// Creates a new `DeleteSubscriptionFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSubscriptionFilter {
    type Output = std::result::Result<
        crate::output::DeleteSubscriptionFilterOutput,
        crate::error::DeleteSubscriptionFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_subscription_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_subscription_filter_response(response)
        }
    }
}

/// Operation shape for `DescribeDestinations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_destinations`](crate::client::Client::describe_destinations).
///
/// See [`crate::client::fluent_builders::DescribeDestinations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDestinations {
    _private: (),
}
impl DescribeDestinations {
    /// Creates a new builder-style object to manufacture [`DescribeDestinationsInput`](crate::input::DescribeDestinationsInput)
    pub fn builder() -> crate::input::describe_destinations_input::Builder {
        crate::input::describe_destinations_input::Builder::default()
    }
    /// Creates a new `DescribeDestinations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDestinations {
    type Output = std::result::Result<
        crate::output::DescribeDestinationsOutput,
        crate::error::DescribeDestinationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_destinations_error(response)
        } else {
            crate::operation_deser::parse_describe_destinations_response(response)
        }
    }
}

/// Operation shape for `DescribeExportTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_export_tasks`](crate::client::Client::describe_export_tasks).
///
/// See [`crate::client::fluent_builders::DescribeExportTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeExportTasks {
    _private: (),
}
impl DescribeExportTasks {
    /// Creates a new builder-style object to manufacture [`DescribeExportTasksInput`](crate::input::DescribeExportTasksInput)
    pub fn builder() -> crate::input::describe_export_tasks_input::Builder {
        crate::input::describe_export_tasks_input::Builder::default()
    }
    /// Creates a new `DescribeExportTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeExportTasks {
    type Output = std::result::Result<
        crate::output::DescribeExportTasksOutput,
        crate::error::DescribeExportTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_export_tasks_error(response)
        } else {
            crate::operation_deser::parse_describe_export_tasks_response(response)
        }
    }
}

/// Operation shape for `DescribeLogGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_log_groups`](crate::client::Client::describe_log_groups).
///
/// See [`crate::client::fluent_builders::DescribeLogGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLogGroups {
    _private: (),
}
impl DescribeLogGroups {
    /// Creates a new builder-style object to manufacture [`DescribeLogGroupsInput`](crate::input::DescribeLogGroupsInput)
    pub fn builder() -> crate::input::describe_log_groups_input::Builder {
        crate::input::describe_log_groups_input::Builder::default()
    }
    /// Creates a new `DescribeLogGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLogGroups {
    type Output = std::result::Result<
        crate::output::DescribeLogGroupsOutput,
        crate::error::DescribeLogGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_log_groups_error(response)
        } else {
            crate::operation_deser::parse_describe_log_groups_response(response)
        }
    }
}

/// Operation shape for `DescribeLogStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_log_streams`](crate::client::Client::describe_log_streams).
///
/// See [`crate::client::fluent_builders::DescribeLogStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeLogStreams {
    _private: (),
}
impl DescribeLogStreams {
    /// Creates a new builder-style object to manufacture [`DescribeLogStreamsInput`](crate::input::DescribeLogStreamsInput)
    pub fn builder() -> crate::input::describe_log_streams_input::Builder {
        crate::input::describe_log_streams_input::Builder::default()
    }
    /// Creates a new `DescribeLogStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeLogStreams {
    type Output = std::result::Result<
        crate::output::DescribeLogStreamsOutput,
        crate::error::DescribeLogStreamsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_log_streams_error(response)
        } else {
            crate::operation_deser::parse_describe_log_streams_response(response)
        }
    }
}

/// Operation shape for `DescribeMetricFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_metric_filters`](crate::client::Client::describe_metric_filters).
///
/// See [`crate::client::fluent_builders::DescribeMetricFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMetricFilters {
    _private: (),
}
impl DescribeMetricFilters {
    /// Creates a new builder-style object to manufacture [`DescribeMetricFiltersInput`](crate::input::DescribeMetricFiltersInput)
    pub fn builder() -> crate::input::describe_metric_filters_input::Builder {
        crate::input::describe_metric_filters_input::Builder::default()
    }
    /// Creates a new `DescribeMetricFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMetricFilters {
    type Output = std::result::Result<
        crate::output::DescribeMetricFiltersOutput,
        crate::error::DescribeMetricFiltersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_metric_filters_error(response)
        } else {
            crate::operation_deser::parse_describe_metric_filters_response(response)
        }
    }
}

/// Operation shape for `DescribeQueries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_queries`](crate::client::Client::describe_queries).
///
/// See [`crate::client::fluent_builders::DescribeQueries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeQueries {
    _private: (),
}
impl DescribeQueries {
    /// Creates a new builder-style object to manufacture [`DescribeQueriesInput`](crate::input::DescribeQueriesInput)
    pub fn builder() -> crate::input::describe_queries_input::Builder {
        crate::input::describe_queries_input::Builder::default()
    }
    /// Creates a new `DescribeQueries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeQueries {
    type Output = std::result::Result<
        crate::output::DescribeQueriesOutput,
        crate::error::DescribeQueriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_queries_error(response)
        } else {
            crate::operation_deser::parse_describe_queries_response(response)
        }
    }
}

/// Operation shape for `DescribeQueryDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_query_definitions`](crate::client::Client::describe_query_definitions).
///
/// See [`crate::client::fluent_builders::DescribeQueryDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeQueryDefinitions {
    _private: (),
}
impl DescribeQueryDefinitions {
    /// Creates a new builder-style object to manufacture [`DescribeQueryDefinitionsInput`](crate::input::DescribeQueryDefinitionsInput)
    pub fn builder() -> crate::input::describe_query_definitions_input::Builder {
        crate::input::describe_query_definitions_input::Builder::default()
    }
    /// Creates a new `DescribeQueryDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeQueryDefinitions {
    type Output = std::result::Result<
        crate::output::DescribeQueryDefinitionsOutput,
        crate::error::DescribeQueryDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_query_definitions_error(response)
        } else {
            crate::operation_deser::parse_describe_query_definitions_response(response)
        }
    }
}

/// Operation shape for `DescribeResourcePolicies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_resource_policies`](crate::client::Client::describe_resource_policies).
///
/// See [`crate::client::fluent_builders::DescribeResourcePolicies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeResourcePolicies {
    _private: (),
}
impl DescribeResourcePolicies {
    /// Creates a new builder-style object to manufacture [`DescribeResourcePoliciesInput`](crate::input::DescribeResourcePoliciesInput)
    pub fn builder() -> crate::input::describe_resource_policies_input::Builder {
        crate::input::describe_resource_policies_input::Builder::default()
    }
    /// Creates a new `DescribeResourcePolicies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeResourcePolicies {
    type Output = std::result::Result<
        crate::output::DescribeResourcePoliciesOutput,
        crate::error::DescribeResourcePoliciesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_resource_policies_error(response)
        } else {
            crate::operation_deser::parse_describe_resource_policies_response(response)
        }
    }
}

/// Operation shape for `DescribeSubscriptionFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_subscription_filters`](crate::client::Client::describe_subscription_filters).
///
/// See [`crate::client::fluent_builders::DescribeSubscriptionFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSubscriptionFilters {
    _private: (),
}
impl DescribeSubscriptionFilters {
    /// Creates a new builder-style object to manufacture [`DescribeSubscriptionFiltersInput`](crate::input::DescribeSubscriptionFiltersInput)
    pub fn builder() -> crate::input::describe_subscription_filters_input::Builder {
        crate::input::describe_subscription_filters_input::Builder::default()
    }
    /// Creates a new `DescribeSubscriptionFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSubscriptionFilters {
    type Output = std::result::Result<
        crate::output::DescribeSubscriptionFiltersOutput,
        crate::error::DescribeSubscriptionFiltersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_subscription_filters_error(response)
        } else {
            crate::operation_deser::parse_describe_subscription_filters_response(response)
        }
    }
}

/// Operation shape for `DisassociateKmsKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_kms_key`](crate::client::Client::disassociate_kms_key).
///
/// See [`crate::client::fluent_builders::DisassociateKmsKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateKmsKey {
    _private: (),
}
impl DisassociateKmsKey {
    /// Creates a new builder-style object to manufacture [`DisassociateKmsKeyInput`](crate::input::DisassociateKmsKeyInput)
    pub fn builder() -> crate::input::disassociate_kms_key_input::Builder {
        crate::input::disassociate_kms_key_input::Builder::default()
    }
    /// Creates a new `DisassociateKmsKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateKmsKey {
    type Output = std::result::Result<
        crate::output::DisassociateKmsKeyOutput,
        crate::error::DisassociateKmsKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_kms_key_error(response)
        } else {
            crate::operation_deser::parse_disassociate_kms_key_response(response)
        }
    }
}

/// Operation shape for `FilterLogEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`filter_log_events`](crate::client::Client::filter_log_events).
///
/// See [`crate::client::fluent_builders::FilterLogEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct FilterLogEvents {
    _private: (),
}
impl FilterLogEvents {
    /// Creates a new builder-style object to manufacture [`FilterLogEventsInput`](crate::input::FilterLogEventsInput)
    pub fn builder() -> crate::input::filter_log_events_input::Builder {
        crate::input::filter_log_events_input::Builder::default()
    }
    /// Creates a new `FilterLogEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for FilterLogEvents {
    type Output = std::result::Result<
        crate::output::FilterLogEventsOutput,
        crate::error::FilterLogEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_filter_log_events_error(response)
        } else {
            crate::operation_deser::parse_filter_log_events_response(response)
        }
    }
}

/// Operation shape for `GetLogEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_log_events`](crate::client::Client::get_log_events).
///
/// See [`crate::client::fluent_builders::GetLogEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLogEvents {
    _private: (),
}
impl GetLogEvents {
    /// Creates a new builder-style object to manufacture [`GetLogEventsInput`](crate::input::GetLogEventsInput)
    pub fn builder() -> crate::input::get_log_events_input::Builder {
        crate::input::get_log_events_input::Builder::default()
    }
    /// Creates a new `GetLogEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLogEvents {
    type Output =
        std::result::Result<crate::output::GetLogEventsOutput, crate::error::GetLogEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_log_events_error(response)
        } else {
            crate::operation_deser::parse_get_log_events_response(response)
        }
    }
}

/// Operation shape for `GetLogGroupFields`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_log_group_fields`](crate::client::Client::get_log_group_fields).
///
/// See [`crate::client::fluent_builders::GetLogGroupFields`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLogGroupFields {
    _private: (),
}
impl GetLogGroupFields {
    /// Creates a new builder-style object to manufacture [`GetLogGroupFieldsInput`](crate::input::GetLogGroupFieldsInput)
    pub fn builder() -> crate::input::get_log_group_fields_input::Builder {
        crate::input::get_log_group_fields_input::Builder::default()
    }
    /// Creates a new `GetLogGroupFields` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLogGroupFields {
    type Output = std::result::Result<
        crate::output::GetLogGroupFieldsOutput,
        crate::error::GetLogGroupFieldsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_log_group_fields_error(response)
        } else {
            crate::operation_deser::parse_get_log_group_fields_response(response)
        }
    }
}

/// Operation shape for `GetLogRecord`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_log_record`](crate::client::Client::get_log_record).
///
/// See [`crate::client::fluent_builders::GetLogRecord`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLogRecord {
    _private: (),
}
impl GetLogRecord {
    /// Creates a new builder-style object to manufacture [`GetLogRecordInput`](crate::input::GetLogRecordInput)
    pub fn builder() -> crate::input::get_log_record_input::Builder {
        crate::input::get_log_record_input::Builder::default()
    }
    /// Creates a new `GetLogRecord` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLogRecord {
    type Output =
        std::result::Result<crate::output::GetLogRecordOutput, crate::error::GetLogRecordError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_log_record_error(response)
        } else {
            crate::operation_deser::parse_get_log_record_response(response)
        }
    }
}

/// Operation shape for `GetQueryResults`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_query_results`](crate::client::Client::get_query_results).
///
/// See [`crate::client::fluent_builders::GetQueryResults`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQueryResults {
    _private: (),
}
impl GetQueryResults {
    /// Creates a new builder-style object to manufacture [`GetQueryResultsInput`](crate::input::GetQueryResultsInput)
    pub fn builder() -> crate::input::get_query_results_input::Builder {
        crate::input::get_query_results_input::Builder::default()
    }
    /// Creates a new `GetQueryResults` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQueryResults {
    type Output = std::result::Result<
        crate::output::GetQueryResultsOutput,
        crate::error::GetQueryResultsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_query_results_error(response)
        } else {
            crate::operation_deser::parse_get_query_results_response(response)
        }
    }
}

/// Operation shape for `ListTagsLogGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_log_group`](crate::client::Client::list_tags_log_group).
///
/// See [`crate::client::fluent_builders::ListTagsLogGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsLogGroup {
    _private: (),
}
impl ListTagsLogGroup {
    /// Creates a new builder-style object to manufacture [`ListTagsLogGroupInput`](crate::input::ListTagsLogGroupInput)
    pub fn builder() -> crate::input::list_tags_log_group_input::Builder {
        crate::input::list_tags_log_group_input::Builder::default()
    }
    /// Creates a new `ListTagsLogGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsLogGroup {
    type Output = std::result::Result<
        crate::output::ListTagsLogGroupOutput,
        crate::error::ListTagsLogGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_log_group_error(response)
        } else {
            crate::operation_deser::parse_list_tags_log_group_response(response)
        }
    }
}

/// Operation shape for `PutDestination`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_destination`](crate::client::Client::put_destination).
///
/// See [`crate::client::fluent_builders::PutDestination`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDestination {
    _private: (),
}
impl PutDestination {
    /// Creates a new builder-style object to manufacture [`PutDestinationInput`](crate::input::PutDestinationInput)
    pub fn builder() -> crate::input::put_destination_input::Builder {
        crate::input::put_destination_input::Builder::default()
    }
    /// Creates a new `PutDestination` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDestination {
    type Output =
        std::result::Result<crate::output::PutDestinationOutput, crate::error::PutDestinationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_destination_error(response)
        } else {
            crate::operation_deser::parse_put_destination_response(response)
        }
    }
}

/// Operation shape for `PutDestinationPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_destination_policy`](crate::client::Client::put_destination_policy).
///
/// See [`crate::client::fluent_builders::PutDestinationPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDestinationPolicy {
    _private: (),
}
impl PutDestinationPolicy {
    /// Creates a new builder-style object to manufacture [`PutDestinationPolicyInput`](crate::input::PutDestinationPolicyInput)
    pub fn builder() -> crate::input::put_destination_policy_input::Builder {
        crate::input::put_destination_policy_input::Builder::default()
    }
    /// Creates a new `PutDestinationPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDestinationPolicy {
    type Output = std::result::Result<
        crate::output::PutDestinationPolicyOutput,
        crate::error::PutDestinationPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_destination_policy_error(response)
        } else {
            crate::operation_deser::parse_put_destination_policy_response(response)
        }
    }
}

/// Operation shape for `PutLogEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_log_events`](crate::client::Client::put_log_events).
///
/// See [`crate::client::fluent_builders::PutLogEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutLogEvents {
    _private: (),
}
impl PutLogEvents {
    /// Creates a new builder-style object to manufacture [`PutLogEventsInput`](crate::input::PutLogEventsInput)
    pub fn builder() -> crate::input::put_log_events_input::Builder {
        crate::input::put_log_events_input::Builder::default()
    }
    /// Creates a new `PutLogEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutLogEvents {
    type Output =
        std::result::Result<crate::output::PutLogEventsOutput, crate::error::PutLogEventsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_log_events_error(response)
        } else {
            crate::operation_deser::parse_put_log_events_response(response)
        }
    }
}

/// Operation shape for `PutMetricFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_metric_filter`](crate::client::Client::put_metric_filter).
///
/// See [`crate::client::fluent_builders::PutMetricFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMetricFilter {
    _private: (),
}
impl PutMetricFilter {
    /// Creates a new builder-style object to manufacture [`PutMetricFilterInput`](crate::input::PutMetricFilterInput)
    pub fn builder() -> crate::input::put_metric_filter_input::Builder {
        crate::input::put_metric_filter_input::Builder::default()
    }
    /// Creates a new `PutMetricFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMetricFilter {
    type Output = std::result::Result<
        crate::output::PutMetricFilterOutput,
        crate::error::PutMetricFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_metric_filter_error(response)
        } else {
            crate::operation_deser::parse_put_metric_filter_response(response)
        }
    }
}

/// Operation shape for `PutQueryDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_query_definition`](crate::client::Client::put_query_definition).
///
/// See [`crate::client::fluent_builders::PutQueryDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutQueryDefinition {
    _private: (),
}
impl PutQueryDefinition {
    /// Creates a new builder-style object to manufacture [`PutQueryDefinitionInput`](crate::input::PutQueryDefinitionInput)
    pub fn builder() -> crate::input::put_query_definition_input::Builder {
        crate::input::put_query_definition_input::Builder::default()
    }
    /// Creates a new `PutQueryDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutQueryDefinition {
    type Output = std::result::Result<
        crate::output::PutQueryDefinitionOutput,
        crate::error::PutQueryDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_query_definition_error(response)
        } else {
            crate::operation_deser::parse_put_query_definition_response(response)
        }
    }
}

/// Operation shape for `PutResourcePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_resource_policy`](crate::client::Client::put_resource_policy).
///
/// See [`crate::client::fluent_builders::PutResourcePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutResourcePolicy {
    _private: (),
}
impl PutResourcePolicy {
    /// Creates a new builder-style object to manufacture [`PutResourcePolicyInput`](crate::input::PutResourcePolicyInput)
    pub fn builder() -> crate::input::put_resource_policy_input::Builder {
        crate::input::put_resource_policy_input::Builder::default()
    }
    /// Creates a new `PutResourcePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutResourcePolicy {
    type Output = std::result::Result<
        crate::output::PutResourcePolicyOutput,
        crate::error::PutResourcePolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_resource_policy_error(response)
        } else {
            crate::operation_deser::parse_put_resource_policy_response(response)
        }
    }
}

/// Operation shape for `PutRetentionPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_retention_policy`](crate::client::Client::put_retention_policy).
///
/// See [`crate::client::fluent_builders::PutRetentionPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutRetentionPolicy {
    _private: (),
}
impl PutRetentionPolicy {
    /// Creates a new builder-style object to manufacture [`PutRetentionPolicyInput`](crate::input::PutRetentionPolicyInput)
    pub fn builder() -> crate::input::put_retention_policy_input::Builder {
        crate::input::put_retention_policy_input::Builder::default()
    }
    /// Creates a new `PutRetentionPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutRetentionPolicy {
    type Output = std::result::Result<
        crate::output::PutRetentionPolicyOutput,
        crate::error::PutRetentionPolicyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_retention_policy_error(response)
        } else {
            crate::operation_deser::parse_put_retention_policy_response(response)
        }
    }
}

/// Operation shape for `PutSubscriptionFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_subscription_filter`](crate::client::Client::put_subscription_filter).
///
/// See [`crate::client::fluent_builders::PutSubscriptionFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutSubscriptionFilter {
    _private: (),
}
impl PutSubscriptionFilter {
    /// Creates a new builder-style object to manufacture [`PutSubscriptionFilterInput`](crate::input::PutSubscriptionFilterInput)
    pub fn builder() -> crate::input::put_subscription_filter_input::Builder {
        crate::input::put_subscription_filter_input::Builder::default()
    }
    /// Creates a new `PutSubscriptionFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutSubscriptionFilter {
    type Output = std::result::Result<
        crate::output::PutSubscriptionFilterOutput,
        crate::error::PutSubscriptionFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_subscription_filter_error(response)
        } else {
            crate::operation_deser::parse_put_subscription_filter_response(response)
        }
    }
}

/// Operation shape for `StartQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_query`](crate::client::Client::start_query).
///
/// See [`crate::client::fluent_builders::StartQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartQuery {
    _private: (),
}
impl StartQuery {
    /// Creates a new builder-style object to manufacture [`StartQueryInput`](crate::input::StartQueryInput)
    pub fn builder() -> crate::input::start_query_input::Builder {
        crate::input::start_query_input::Builder::default()
    }
    /// Creates a new `StartQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartQuery {
    type Output =
        std::result::Result<crate::output::StartQueryOutput, crate::error::StartQueryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_query_error(response)
        } else {
            crate::operation_deser::parse_start_query_response(response)
        }
    }
}

/// Operation shape for `StopQuery`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_query`](crate::client::Client::stop_query).
///
/// See [`crate::client::fluent_builders::StopQuery`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopQuery {
    _private: (),
}
impl StopQuery {
    /// Creates a new builder-style object to manufacture [`StopQueryInput`](crate::input::StopQueryInput)
    pub fn builder() -> crate::input::stop_query_input::Builder {
        crate::input::stop_query_input::Builder::default()
    }
    /// Creates a new `StopQuery` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopQuery {
    type Output = std::result::Result<crate::output::StopQueryOutput, crate::error::StopQueryError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_query_error(response)
        } else {
            crate::operation_deser::parse_stop_query_response(response)
        }
    }
}

/// Operation shape for `TagLogGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_log_group`](crate::client::Client::tag_log_group).
///
/// See [`crate::client::fluent_builders::TagLogGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagLogGroup {
    _private: (),
}
impl TagLogGroup {
    /// Creates a new builder-style object to manufacture [`TagLogGroupInput`](crate::input::TagLogGroupInput)
    pub fn builder() -> crate::input::tag_log_group_input::Builder {
        crate::input::tag_log_group_input::Builder::default()
    }
    /// Creates a new `TagLogGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagLogGroup {
    type Output =
        std::result::Result<crate::output::TagLogGroupOutput, crate::error::TagLogGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_log_group_error(response)
        } else {
            crate::operation_deser::parse_tag_log_group_response(response)
        }
    }
}

/// Operation shape for `TestMetricFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_metric_filter`](crate::client::Client::test_metric_filter).
///
/// See [`crate::client::fluent_builders::TestMetricFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestMetricFilter {
    _private: (),
}
impl TestMetricFilter {
    /// Creates a new builder-style object to manufacture [`TestMetricFilterInput`](crate::input::TestMetricFilterInput)
    pub fn builder() -> crate::input::test_metric_filter_input::Builder {
        crate::input::test_metric_filter_input::Builder::default()
    }
    /// Creates a new `TestMetricFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestMetricFilter {
    type Output = std::result::Result<
        crate::output::TestMetricFilterOutput,
        crate::error::TestMetricFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_metric_filter_error(response)
        } else {
            crate::operation_deser::parse_test_metric_filter_response(response)
        }
    }
}

/// Operation shape for `UntagLogGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_log_group`](crate::client::Client::untag_log_group).
///
/// See [`crate::client::fluent_builders::UntagLogGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagLogGroup {
    _private: (),
}
impl UntagLogGroup {
    /// Creates a new builder-style object to manufacture [`UntagLogGroupInput`](crate::input::UntagLogGroupInput)
    pub fn builder() -> crate::input::untag_log_group_input::Builder {
        crate::input::untag_log_group_input::Builder::default()
    }
    /// Creates a new `UntagLogGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagLogGroup {
    type Output =
        std::result::Result<crate::output::UntagLogGroupOutput, crate::error::UntagLogGroupError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_log_group_error(response)
        } else {
            crate::operation_deser::parse_untag_log_group_response(response)
        }
    }
}
