// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents a matched event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricFilterMatchRecord {
    /// <p>The event number.</p>
    pub event_number: i64,
    /// <p>The raw event data.</p>
    pub event_message: std::option::Option<std::string::String>,
    /// <p>The values extracted from the event data by the filter.</p>
    pub extracted_values:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl MetricFilterMatchRecord {
    /// <p>The event number.</p>
    pub fn event_number(&self) -> i64 {
        self.event_number
    }
    /// <p>The raw event data.</p>
    pub fn event_message(&self) -> std::option::Option<&str> {
        self.event_message.as_deref()
    }
    /// <p>The values extracted from the event data by the filter.</p>
    pub fn extracted_values(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.extracted_values.as_ref()
    }
}
impl std::fmt::Debug for MetricFilterMatchRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricFilterMatchRecord");
        formatter.field("event_number", &self.event_number);
        formatter.field("event_message", &self.event_message);
        formatter.field("extracted_values", &self.extracted_values);
        formatter.finish()
    }
}
/// See [`MetricFilterMatchRecord`](crate::model::MetricFilterMatchRecord)
pub mod metric_filter_match_record {
    /// A builder for [`MetricFilterMatchRecord`](crate::model::MetricFilterMatchRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_number: std::option::Option<i64>,
        pub(crate) event_message: std::option::Option<std::string::String>,
        pub(crate) extracted_values: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The event number.</p>
        pub fn event_number(mut self, input: i64) -> Self {
            self.event_number = Some(input);
            self
        }
        /// <p>The event number.</p>
        pub fn set_event_number(mut self, input: std::option::Option<i64>) -> Self {
            self.event_number = input;
            self
        }
        /// <p>The raw event data.</p>
        pub fn event_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_message = Some(input.into());
            self
        }
        /// <p>The raw event data.</p>
        pub fn set_event_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_message = input;
            self
        }
        /// Adds a key-value pair to `extracted_values`.
        ///
        /// To override the contents of this collection use [`set_extracted_values`](Self::set_extracted_values).
        ///
        /// <p>The values extracted from the event data by the filter.</p>
        pub fn extracted_values(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.extracted_values.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.extracted_values = Some(hash_map);
            self
        }
        /// <p>The values extracted from the event data by the filter.</p>
        pub fn set_extracted_values(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.extracted_values = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricFilterMatchRecord`](crate::model::MetricFilterMatchRecord)
        pub fn build(self) -> crate::model::MetricFilterMatchRecord {
            crate::model::MetricFilterMatchRecord {
                event_number: self.event_number.unwrap_or_default(),
                event_message: self.event_message,
                extracted_values: self.extracted_values,
            }
        }
    }
}
impl MetricFilterMatchRecord {
    /// Creates a new builder-style object to manufacture [`MetricFilterMatchRecord`](crate::model::MetricFilterMatchRecord)
    pub fn builder() -> crate::model::metric_filter_match_record::Builder {
        crate::model::metric_filter_match_record::Builder::default()
    }
}

/// <p>Reserved.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryCompileError {
    /// <p>Reserved.</p>
    pub location: std::option::Option<crate::model::QueryCompileErrorLocation>,
    /// <p>Reserved.</p>
    pub message: std::option::Option<std::string::String>,
}
impl QueryCompileError {
    /// <p>Reserved.</p>
    pub fn location(&self) -> std::option::Option<&crate::model::QueryCompileErrorLocation> {
        self.location.as_ref()
    }
    /// <p>Reserved.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for QueryCompileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryCompileError");
        formatter.field("location", &self.location);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`QueryCompileError`](crate::model::QueryCompileError)
pub mod query_compile_error {
    /// A builder for [`QueryCompileError`](crate::model::QueryCompileError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<crate::model::QueryCompileErrorLocation>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Reserved.</p>
        pub fn location(mut self, input: crate::model::QueryCompileErrorLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::QueryCompileErrorLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryCompileError`](crate::model::QueryCompileError)
        pub fn build(self) -> crate::model::QueryCompileError {
            crate::model::QueryCompileError {
                location: self.location,
                message: self.message,
            }
        }
    }
}
impl QueryCompileError {
    /// Creates a new builder-style object to manufacture [`QueryCompileError`](crate::model::QueryCompileError)
    pub fn builder() -> crate::model::query_compile_error::Builder {
        crate::model::query_compile_error::Builder::default()
    }
}

/// <p>Reserved.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryCompileErrorLocation {
    /// <p>Reserved.</p>
    pub start_char_offset: std::option::Option<i32>,
    /// <p>Reserved.</p>
    pub end_char_offset: std::option::Option<i32>,
}
impl QueryCompileErrorLocation {
    /// <p>Reserved.</p>
    pub fn start_char_offset(&self) -> std::option::Option<i32> {
        self.start_char_offset
    }
    /// <p>Reserved.</p>
    pub fn end_char_offset(&self) -> std::option::Option<i32> {
        self.end_char_offset
    }
}
impl std::fmt::Debug for QueryCompileErrorLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryCompileErrorLocation");
        formatter.field("start_char_offset", &self.start_char_offset);
        formatter.field("end_char_offset", &self.end_char_offset);
        formatter.finish()
    }
}
/// See [`QueryCompileErrorLocation`](crate::model::QueryCompileErrorLocation)
pub mod query_compile_error_location {
    /// A builder for [`QueryCompileErrorLocation`](crate::model::QueryCompileErrorLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_char_offset: std::option::Option<i32>,
        pub(crate) end_char_offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Reserved.</p>
        pub fn start_char_offset(mut self, input: i32) -> Self {
            self.start_char_offset = Some(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_start_char_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.start_char_offset = input;
            self
        }
        /// <p>Reserved.</p>
        pub fn end_char_offset(mut self, input: i32) -> Self {
            self.end_char_offset = Some(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_end_char_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.end_char_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryCompileErrorLocation`](crate::model::QueryCompileErrorLocation)
        pub fn build(self) -> crate::model::QueryCompileErrorLocation {
            crate::model::QueryCompileErrorLocation {
                start_char_offset: self.start_char_offset,
                end_char_offset: self.end_char_offset,
            }
        }
    }
}
impl QueryCompileErrorLocation {
    /// Creates a new builder-style object to manufacture [`QueryCompileErrorLocation`](crate::model::QueryCompileErrorLocation)
    pub fn builder() -> crate::model::query_compile_error_location::Builder {
        crate::model::query_compile_error_location::Builder::default()
    }
}

/// <p>The method used to distribute log data to the destination, which can be either
/// random or grouped by log stream.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Distribution {
    #[allow(missing_docs)] // documentation missing in model
    ByLogStream,
    #[allow(missing_docs)] // documentation missing in model
    Random,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Distribution {
    fn from(s: &str) -> Self {
        match s {
            "ByLogStream" => Distribution::ByLogStream,
            "Random" => Distribution::Random,
            other => Distribution::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Distribution {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Distribution::from(s))
    }
}
impl Distribution {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Distribution::ByLogStream => "ByLogStream",
            Distribution::Random => "Random",
            Distribution::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ByLogStream", "Random"]
    }
}
impl AsRef<str> for Distribution {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A policy enabling one or more entities to put logs to a log group in this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePolicy {
    /// <p>The name of the resource policy.</p>
    pub policy_name: std::option::Option<std::string::String>,
    /// <p>The details of the policy.</p>
    pub policy_document: std::option::Option<std::string::String>,
    /// <p>Timestamp showing when this policy was last updated, expressed as the number of
    /// milliseconds after Jan 1, 1970 00:00:00 UTC.</p>
    pub last_updated_time: std::option::Option<i64>,
}
impl ResourcePolicy {
    /// <p>The name of the resource policy.</p>
    pub fn policy_name(&self) -> std::option::Option<&str> {
        self.policy_name.as_deref()
    }
    /// <p>The details of the policy.</p>
    pub fn policy_document(&self) -> std::option::Option<&str> {
        self.policy_document.as_deref()
    }
    /// <p>Timestamp showing when this policy was last updated, expressed as the number of
    /// milliseconds after Jan 1, 1970 00:00:00 UTC.</p>
    pub fn last_updated_time(&self) -> std::option::Option<i64> {
        self.last_updated_time
    }
}
impl std::fmt::Debug for ResourcePolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePolicy");
        formatter.field("policy_name", &self.policy_name);
        formatter.field("policy_document", &self.policy_document);
        formatter.field("last_updated_time", &self.last_updated_time);
        formatter.finish()
    }
}
/// See [`ResourcePolicy`](crate::model::ResourcePolicy)
pub mod resource_policy {
    /// A builder for [`ResourcePolicy`](crate::model::ResourcePolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy_name: std::option::Option<std::string::String>,
        pub(crate) policy_document: std::option::Option<std::string::String>,
        pub(crate) last_updated_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the resource policy.</p>
        pub fn policy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_name = Some(input.into());
            self
        }
        /// <p>The name of the resource policy.</p>
        pub fn set_policy_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy_name = input;
            self
        }
        /// <p>The details of the policy.</p>
        pub fn policy_document(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy_document = Some(input.into());
            self
        }
        /// <p>The details of the policy.</p>
        pub fn set_policy_document(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.policy_document = input;
            self
        }
        /// <p>Timestamp showing when this policy was last updated, expressed as the number of
        /// milliseconds after Jan 1, 1970 00:00:00 UTC.</p>
        pub fn last_updated_time(mut self, input: i64) -> Self {
            self.last_updated_time = Some(input);
            self
        }
        /// <p>Timestamp showing when this policy was last updated, expressed as the number of
        /// milliseconds after Jan 1, 1970 00:00:00 UTC.</p>
        pub fn set_last_updated_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_updated_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePolicy`](crate::model::ResourcePolicy)
        pub fn build(self) -> crate::model::ResourcePolicy {
            crate::model::ResourcePolicy {
                policy_name: self.policy_name,
                policy_document: self.policy_document,
                last_updated_time: self.last_updated_time,
            }
        }
    }
}
impl ResourcePolicy {
    /// Creates a new builder-style object to manufacture [`ResourcePolicy`](crate::model::ResourcePolicy)
    pub fn builder() -> crate::model::resource_policy::Builder {
        crate::model::resource_policy::Builder::default()
    }
}

/// <p>Indicates how to transform ingested log events to metric data in a CloudWatch
/// metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricTransformation {
    /// <p>The name of the CloudWatch metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics
    /// that are similar. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a>.</p>
    pub metric_namespace: std::option::Option<std::string::String>,
    /// <p>The value to publish to the CloudWatch metric when a filter pattern matches a log event.</p>
    pub metric_value: std::option::Option<std::string::String>,
    /// <p>(Optional) The value to emit when a filter pattern does not match a log event.
    /// This value can be null.</p>
    pub default_value: std::option::Option<f64>,
    /// <p>The fields to use as dimensions for the metric. One metric filter can include
    /// as many as three dimensions.</p>
    /// <important>
    /// <p>Metrics extracted from log events are charged as custom metrics.
    /// To prevent unexpected high charges, do not specify high-cardinality fields such as
    /// <code>IPAddress</code> or <code>requestID</code> as dimensions. Each different value
    /// found for
    /// a dimension is treated as a separate metric and accrues charges as a separate custom metric.
    /// </p>
    /// <p>To help prevent accidental high charges, Amazon disables a metric filter
    /// if it generates 1000 different name/value pairs for the dimensions that you
    /// have specified within a certain amount of time.</p>
    /// <p>You can also set up a billing alarm to alert you if your charges are higher than
    /// expected. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html">
    /// Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>.
    /// </p>
    /// </important>
    pub dimensions:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The unit to assign to the metric. If you omit this, the unit is set as <code>None</code>.</p>
    pub unit: std::option::Option<crate::model::StandardUnit>,
}
impl MetricTransformation {
    /// <p>The name of the CloudWatch metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics
    /// that are similar. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a>.</p>
    pub fn metric_namespace(&self) -> std::option::Option<&str> {
        self.metric_namespace.as_deref()
    }
    /// <p>The value to publish to the CloudWatch metric when a filter pattern matches a log event.</p>
    pub fn metric_value(&self) -> std::option::Option<&str> {
        self.metric_value.as_deref()
    }
    /// <p>(Optional) The value to emit when a filter pattern does not match a log event.
    /// This value can be null.</p>
    pub fn default_value(&self) -> std::option::Option<f64> {
        self.default_value
    }
    /// <p>The fields to use as dimensions for the metric. One metric filter can include
    /// as many as three dimensions.</p>
    /// <important>
    /// <p>Metrics extracted from log events are charged as custom metrics.
    /// To prevent unexpected high charges, do not specify high-cardinality fields such as
    /// <code>IPAddress</code> or <code>requestID</code> as dimensions. Each different value
    /// found for
    /// a dimension is treated as a separate metric and accrues charges as a separate custom metric.
    /// </p>
    /// <p>To help prevent accidental high charges, Amazon disables a metric filter
    /// if it generates 1000 different name/value pairs for the dimensions that you
    /// have specified within a certain amount of time.</p>
    /// <p>You can also set up a billing alarm to alert you if your charges are higher than
    /// expected. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html">
    /// Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>.
    /// </p>
    /// </important>
    pub fn dimensions(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.dimensions.as_ref()
    }
    /// <p>The unit to assign to the metric. If you omit this, the unit is set as <code>None</code>.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::StandardUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for MetricTransformation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricTransformation");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("metric_namespace", &self.metric_namespace);
        formatter.field("metric_value", &self.metric_value);
        formatter.field("default_value", &self.default_value);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`MetricTransformation`](crate::model::MetricTransformation)
pub mod metric_transformation {
    /// A builder for [`MetricTransformation`](crate::model::MetricTransformation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_namespace: std::option::Option<std::string::String>,
        pub(crate) metric_value: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<f64>,
        pub(crate) dimensions: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) unit: std::option::Option<crate::model::StandardUnit>,
    }
    impl Builder {
        /// <p>The name of the CloudWatch metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the CloudWatch metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics
        /// that are similar. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a>.</p>
        pub fn metric_namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_namespace = Some(input.into());
            self
        }
        /// <p>A custom namespace to contain your metric in CloudWatch. Use namespaces to group together metrics
        /// that are similar. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a>.</p>
        pub fn set_metric_namespace(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_namespace = input;
            self
        }
        /// <p>The value to publish to the CloudWatch metric when a filter pattern matches a log event.</p>
        pub fn metric_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_value = Some(input.into());
            self
        }
        /// <p>The value to publish to the CloudWatch metric when a filter pattern matches a log event.</p>
        pub fn set_metric_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_value = input;
            self
        }
        /// <p>(Optional) The value to emit when a filter pattern does not match a log event.
        /// This value can be null.</p>
        pub fn default_value(mut self, input: f64) -> Self {
            self.default_value = Some(input);
            self
        }
        /// <p>(Optional) The value to emit when a filter pattern does not match a log event.
        /// This value can be null.</p>
        pub fn set_default_value(mut self, input: std::option::Option<f64>) -> Self {
            self.default_value = input;
            self
        }
        /// Adds a key-value pair to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The fields to use as dimensions for the metric. One metric filter can include
        /// as many as three dimensions.</p>
        /// <important>
        /// <p>Metrics extracted from log events are charged as custom metrics.
        /// To prevent unexpected high charges, do not specify high-cardinality fields such as
        /// <code>IPAddress</code> or <code>requestID</code> as dimensions. Each different value
        /// found for
        /// a dimension is treated as a separate metric and accrues charges as a separate custom metric.
        /// </p>
        /// <p>To help prevent accidental high charges, Amazon disables a metric filter
        /// if it generates 1000 different name/value pairs for the dimensions that you
        /// have specified within a certain amount of time.</p>
        /// <p>You can also set up a billing alarm to alert you if your charges are higher than
        /// expected. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html">
        /// Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>.
        /// </p>
        /// </important>
        pub fn dimensions(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.dimensions.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.dimensions = Some(hash_map);
            self
        }
        /// <p>The fields to use as dimensions for the metric. One metric filter can include
        /// as many as three dimensions.</p>
        /// <important>
        /// <p>Metrics extracted from log events are charged as custom metrics.
        /// To prevent unexpected high charges, do not specify high-cardinality fields such as
        /// <code>IPAddress</code> or <code>requestID</code> as dimensions. Each different value
        /// found for
        /// a dimension is treated as a separate metric and accrues charges as a separate custom metric.
        /// </p>
        /// <p>To help prevent accidental high charges, Amazon disables a metric filter
        /// if it generates 1000 different name/value pairs for the dimensions that you
        /// have specified within a certain amount of time.</p>
        /// <p>You can also set up a billing alarm to alert you if your charges are higher than
        /// expected. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html">
        /// Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>.
        /// </p>
        /// </important>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The unit to assign to the metric. If you omit this, the unit is set as <code>None</code>.</p>
        pub fn unit(mut self, input: crate::model::StandardUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit to assign to the metric. If you omit this, the unit is set as <code>None</code>.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::StandardUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricTransformation`](crate::model::MetricTransformation)
        pub fn build(self) -> crate::model::MetricTransformation {
            crate::model::MetricTransformation {
                metric_name: self.metric_name,
                metric_namespace: self.metric_namespace,
                metric_value: self.metric_value,
                default_value: self.default_value,
                dimensions: self.dimensions,
                unit: self.unit,
            }
        }
    }
}
impl MetricTransformation {
    /// Creates a new builder-style object to manufacture [`MetricTransformation`](crate::model::MetricTransformation)
    pub fn builder() -> crate::model::metric_transformation::Builder {
        crate::model::metric_transformation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StandardUnit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabits,
    #[allow(missing_docs)] // documentation missing in model
    GigabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabytes,
    #[allow(missing_docs)] // documentation missing in model
    GigabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobits,
    #[allow(missing_docs)] // documentation missing in model
    KilobitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    #[allow(missing_docs)] // documentation missing in model
    KilobytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabits,
    #[allow(missing_docs)] // documentation missing in model
    MegabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabytes,
    #[allow(missing_docs)] // documentation missing in model
    MegabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Microseconds,
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    Terabits,
    #[allow(missing_docs)] // documentation missing in model
    TerabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    #[allow(missing_docs)] // documentation missing in model
    TerabytesSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StandardUnit {
    fn from(s: &str) -> Self {
        match s {
            "Bits" => StandardUnit::Bits,
            "Bits/Second" => StandardUnit::BitsSecond,
            "Bytes" => StandardUnit::Bytes,
            "Bytes/Second" => StandardUnit::BytesSecond,
            "Count" => StandardUnit::Count,
            "Count/Second" => StandardUnit::CountSecond,
            "Gigabits" => StandardUnit::Gigabits,
            "Gigabits/Second" => StandardUnit::GigabitsSecond,
            "Gigabytes" => StandardUnit::Gigabytes,
            "Gigabytes/Second" => StandardUnit::GigabytesSecond,
            "Kilobits" => StandardUnit::Kilobits,
            "Kilobits/Second" => StandardUnit::KilobitsSecond,
            "Kilobytes" => StandardUnit::Kilobytes,
            "Kilobytes/Second" => StandardUnit::KilobytesSecond,
            "Megabits" => StandardUnit::Megabits,
            "Megabits/Second" => StandardUnit::MegabitsSecond,
            "Megabytes" => StandardUnit::Megabytes,
            "Megabytes/Second" => StandardUnit::MegabytesSecond,
            "Microseconds" => StandardUnit::Microseconds,
            "Milliseconds" => StandardUnit::Milliseconds,
            "None" => StandardUnit::None,
            "Percent" => StandardUnit::Percent,
            "Seconds" => StandardUnit::Seconds,
            "Terabits" => StandardUnit::Terabits,
            "Terabits/Second" => StandardUnit::TerabitsSecond,
            "Terabytes" => StandardUnit::Terabytes,
            "Terabytes/Second" => StandardUnit::TerabytesSecond,
            other => StandardUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StandardUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StandardUnit::from(s))
    }
}
impl StandardUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StandardUnit::Bits => "Bits",
            StandardUnit::BitsSecond => "Bits/Second",
            StandardUnit::Bytes => "Bytes",
            StandardUnit::BytesSecond => "Bytes/Second",
            StandardUnit::Count => "Count",
            StandardUnit::CountSecond => "Count/Second",
            StandardUnit::Gigabits => "Gigabits",
            StandardUnit::GigabitsSecond => "Gigabits/Second",
            StandardUnit::Gigabytes => "Gigabytes",
            StandardUnit::GigabytesSecond => "Gigabytes/Second",
            StandardUnit::Kilobits => "Kilobits",
            StandardUnit::KilobitsSecond => "Kilobits/Second",
            StandardUnit::Kilobytes => "Kilobytes",
            StandardUnit::KilobytesSecond => "Kilobytes/Second",
            StandardUnit::Megabits => "Megabits",
            StandardUnit::MegabitsSecond => "Megabits/Second",
            StandardUnit::Megabytes => "Megabytes",
            StandardUnit::MegabytesSecond => "Megabytes/Second",
            StandardUnit::Microseconds => "Microseconds",
            StandardUnit::Milliseconds => "Milliseconds",
            StandardUnit::None => "None",
            StandardUnit::Percent => "Percent",
            StandardUnit::Seconds => "Seconds",
            StandardUnit::Terabits => "Terabits",
            StandardUnit::TerabitsSecond => "Terabits/Second",
            StandardUnit::Terabytes => "Terabytes",
            StandardUnit::TerabytesSecond => "Terabytes/Second",
            StandardUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bits",
            "Bits/Second",
            "Bytes",
            "Bytes/Second",
            "Count",
            "Count/Second",
            "Gigabits",
            "Gigabits/Second",
            "Gigabytes",
            "Gigabytes/Second",
            "Kilobits",
            "Kilobits/Second",
            "Kilobytes",
            "Kilobytes/Second",
            "Megabits",
            "Megabits/Second",
            "Megabytes",
            "Megabytes/Second",
            "Microseconds",
            "Milliseconds",
            "None",
            "Percent",
            "Seconds",
            "Terabits",
            "Terabits/Second",
            "Terabytes",
            "Terabytes/Second",
        ]
    }
}
impl AsRef<str> for StandardUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the rejected events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectedLogEventsInfo {
    /// <p>The log events that are too new.</p>
    pub too_new_log_event_start_index: std::option::Option<i32>,
    /// <p>The log events that are too old.</p>
    pub too_old_log_event_end_index: std::option::Option<i32>,
    /// <p>The expired log events.</p>
    pub expired_log_event_end_index: std::option::Option<i32>,
}
impl RejectedLogEventsInfo {
    /// <p>The log events that are too new.</p>
    pub fn too_new_log_event_start_index(&self) -> std::option::Option<i32> {
        self.too_new_log_event_start_index
    }
    /// <p>The log events that are too old.</p>
    pub fn too_old_log_event_end_index(&self) -> std::option::Option<i32> {
        self.too_old_log_event_end_index
    }
    /// <p>The expired log events.</p>
    pub fn expired_log_event_end_index(&self) -> std::option::Option<i32> {
        self.expired_log_event_end_index
    }
}
impl std::fmt::Debug for RejectedLogEventsInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectedLogEventsInfo");
        formatter.field(
            "too_new_log_event_start_index",
            &self.too_new_log_event_start_index,
        );
        formatter.field(
            "too_old_log_event_end_index",
            &self.too_old_log_event_end_index,
        );
        formatter.field(
            "expired_log_event_end_index",
            &self.expired_log_event_end_index,
        );
        formatter.finish()
    }
}
/// See [`RejectedLogEventsInfo`](crate::model::RejectedLogEventsInfo)
pub mod rejected_log_events_info {
    /// A builder for [`RejectedLogEventsInfo`](crate::model::RejectedLogEventsInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) too_new_log_event_start_index: std::option::Option<i32>,
        pub(crate) too_old_log_event_end_index: std::option::Option<i32>,
        pub(crate) expired_log_event_end_index: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The log events that are too new.</p>
        pub fn too_new_log_event_start_index(mut self, input: i32) -> Self {
            self.too_new_log_event_start_index = Some(input);
            self
        }
        /// <p>The log events that are too new.</p>
        pub fn set_too_new_log_event_start_index(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.too_new_log_event_start_index = input;
            self
        }
        /// <p>The log events that are too old.</p>
        pub fn too_old_log_event_end_index(mut self, input: i32) -> Self {
            self.too_old_log_event_end_index = Some(input);
            self
        }
        /// <p>The log events that are too old.</p>
        pub fn set_too_old_log_event_end_index(mut self, input: std::option::Option<i32>) -> Self {
            self.too_old_log_event_end_index = input;
            self
        }
        /// <p>The expired log events.</p>
        pub fn expired_log_event_end_index(mut self, input: i32) -> Self {
            self.expired_log_event_end_index = Some(input);
            self
        }
        /// <p>The expired log events.</p>
        pub fn set_expired_log_event_end_index(mut self, input: std::option::Option<i32>) -> Self {
            self.expired_log_event_end_index = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectedLogEventsInfo`](crate::model::RejectedLogEventsInfo)
        pub fn build(self) -> crate::model::RejectedLogEventsInfo {
            crate::model::RejectedLogEventsInfo {
                too_new_log_event_start_index: self.too_new_log_event_start_index,
                too_old_log_event_end_index: self.too_old_log_event_end_index,
                expired_log_event_end_index: self.expired_log_event_end_index,
            }
        }
    }
}
impl RejectedLogEventsInfo {
    /// Creates a new builder-style object to manufacture [`RejectedLogEventsInfo`](crate::model::RejectedLogEventsInfo)
    pub fn builder() -> crate::model::rejected_log_events_info::Builder {
        crate::model::rejected_log_events_info::Builder::default()
    }
}

/// <p>Represents a log event, which is a record of activity that was recorded
/// by the application or resource being monitored.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputLogEvent {
    /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub timestamp: std::option::Option<i64>,
    /// <p>The raw event message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InputLogEvent {
    /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub fn timestamp(&self) -> std::option::Option<i64> {
        self.timestamp
    }
    /// <p>The raw event message.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for InputLogEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputLogEvent");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`InputLogEvent`](crate::model::InputLogEvent)
pub mod input_log_event {
    /// A builder for [`InputLogEvent`](crate::model::InputLogEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The raw event message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The raw event message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InputLogEvent`](crate::model::InputLogEvent)
        pub fn build(self) -> crate::model::InputLogEvent {
            crate::model::InputLogEvent {
                timestamp: self.timestamp,
                message: self.message,
            }
        }
    }
}
impl InputLogEvent {
    /// Creates a new builder-style object to manufacture [`InputLogEvent`](crate::model::InputLogEvent)
    pub fn builder() -> crate::model::input_log_event::Builder {
        crate::model::input_log_event::Builder::default()
    }
}

/// <p>Represents a cross-account destination that receives subscription log events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Destination {
    /// <p>The name of the destination.</p>
    pub destination_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the physical target where the log events are
    /// delivered (for example, a Kinesis stream).</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>A role for impersonation, used when delivering log events to the target.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>An IAM policy document that governs which Amazon Web Services accounts can create subscription filters
    /// against this destination.</p>
    pub access_policy: std::option::Option<std::string::String>,
    /// <p>The ARN of this destination.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The creation time of the destination, expressed as the number of milliseconds after Jan
    /// 1, 1970 00:00:00 UTC.</p>
    pub creation_time: std::option::Option<i64>,
}
impl Destination {
    /// <p>The name of the destination.</p>
    pub fn destination_name(&self) -> std::option::Option<&str> {
        self.destination_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the physical target where the log events are
    /// delivered (for example, a Kinesis stream).</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>A role for impersonation, used when delivering log events to the target.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>An IAM policy document that governs which Amazon Web Services accounts can create subscription filters
    /// against this destination.</p>
    pub fn access_policy(&self) -> std::option::Option<&str> {
        self.access_policy.as_deref()
    }
    /// <p>The ARN of this destination.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The creation time of the destination, expressed as the number of milliseconds after Jan
    /// 1, 1970 00:00:00 UTC.</p>
    pub fn creation_time(&self) -> std::option::Option<i64> {
        self.creation_time
    }
}
impl std::fmt::Debug for Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Destination");
        formatter.field("destination_name", &self.destination_name);
        formatter.field("target_arn", &self.target_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("access_policy", &self.access_policy);
        formatter.field("arn", &self.arn);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`Destination`](crate::model::Destination)
pub mod destination {
    /// A builder for [`Destination`](crate::model::Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_name: std::option::Option<std::string::String>,
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) access_policy: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the destination.</p>
        pub fn destination_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_name = Some(input.into());
            self
        }
        /// <p>The name of the destination.</p>
        pub fn set_destination_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the physical target where the log events are
        /// delivered (for example, a Kinesis stream).</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the physical target where the log events are
        /// delivered (for example, a Kinesis stream).</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>A role for impersonation, used when delivering log events to the target.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>A role for impersonation, used when delivering log events to the target.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>An IAM policy document that governs which Amazon Web Services accounts can create subscription filters
        /// against this destination.</p>
        pub fn access_policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_policy = Some(input.into());
            self
        }
        /// <p>An IAM policy document that governs which Amazon Web Services accounts can create subscription filters
        /// against this destination.</p>
        pub fn set_access_policy(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_policy = input;
            self
        }
        /// <p>The ARN of this destination.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of this destination.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The creation time of the destination, expressed as the number of milliseconds after Jan
        /// 1, 1970 00:00:00 UTC.</p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the destination, expressed as the number of milliseconds after Jan
        /// 1, 1970 00:00:00 UTC.</p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Destination`](crate::model::Destination)
        pub fn build(self) -> crate::model::Destination {
            crate::model::Destination {
                destination_name: self.destination_name,
                target_arn: self.target_arn,
                role_arn: self.role_arn,
                access_policy: self.access_policy,
                arn: self.arn,
                creation_time: self.creation_time,
            }
        }
    }
}
impl Destination {
    /// Creates a new builder-style object to manufacture [`Destination`](crate::model::Destination)
    pub fn builder() -> crate::model::destination::Builder {
        crate::model::destination::Builder::default()
    }
}

/// _Note: `QueryStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    #[allow(missing_docs)] // documentation missing in model
    Timeout,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueryStatus {
    fn from(s: &str) -> Self {
        match s {
            "Cancelled" => QueryStatus::Cancelled,
            "Complete" => QueryStatus::Complete,
            "Failed" => QueryStatus::Failed,
            "Running" => QueryStatus::Running,
            "Scheduled" => QueryStatus::Scheduled,
            "Timeout" => QueryStatus::Timeout,
            "Unknown" => QueryStatus::UnknownValue,
            other => QueryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueryStatus::from(s))
    }
}
impl QueryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueryStatus::Cancelled => "Cancelled",
            QueryStatus::Complete => "Complete",
            QueryStatus::Failed => "Failed",
            QueryStatus::Running => "Running",
            QueryStatus::Scheduled => "Scheduled",
            QueryStatus::Timeout => "Timeout",
            QueryStatus::UnknownValue => "Unknown",
            QueryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Cancelled",
            "Complete",
            "Failed",
            "Running",
            "Scheduled",
            "Timeout",
            "Unknown",
        ]
    }
}
impl AsRef<str> for QueryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the number of log events scanned by the query, the number of log events that matched the
/// query criteria, and the total number of bytes in the log events that were scanned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryStatistics {
    /// <p>The number of log events that matched the query string.</p>
    pub records_matched: f64,
    /// <p>The total number of log events scanned during the query.</p>
    pub records_scanned: f64,
    /// <p>The total number of bytes in the log events scanned during the query.</p>
    pub bytes_scanned: f64,
}
impl QueryStatistics {
    /// <p>The number of log events that matched the query string.</p>
    pub fn records_matched(&self) -> f64 {
        self.records_matched
    }
    /// <p>The total number of log events scanned during the query.</p>
    pub fn records_scanned(&self) -> f64 {
        self.records_scanned
    }
    /// <p>The total number of bytes in the log events scanned during the query.</p>
    pub fn bytes_scanned(&self) -> f64 {
        self.bytes_scanned
    }
}
impl std::fmt::Debug for QueryStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryStatistics");
        formatter.field("records_matched", &self.records_matched);
        formatter.field("records_scanned", &self.records_scanned);
        formatter.field("bytes_scanned", &self.bytes_scanned);
        formatter.finish()
    }
}
/// See [`QueryStatistics`](crate::model::QueryStatistics)
pub mod query_statistics {
    /// A builder for [`QueryStatistics`](crate::model::QueryStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) records_matched: std::option::Option<f64>,
        pub(crate) records_scanned: std::option::Option<f64>,
        pub(crate) bytes_scanned: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The number of log events that matched the query string.</p>
        pub fn records_matched(mut self, input: f64) -> Self {
            self.records_matched = Some(input);
            self
        }
        /// <p>The number of log events that matched the query string.</p>
        pub fn set_records_matched(mut self, input: std::option::Option<f64>) -> Self {
            self.records_matched = input;
            self
        }
        /// <p>The total number of log events scanned during the query.</p>
        pub fn records_scanned(mut self, input: f64) -> Self {
            self.records_scanned = Some(input);
            self
        }
        /// <p>The total number of log events scanned during the query.</p>
        pub fn set_records_scanned(mut self, input: std::option::Option<f64>) -> Self {
            self.records_scanned = input;
            self
        }
        /// <p>The total number of bytes in the log events scanned during the query.</p>
        pub fn bytes_scanned(mut self, input: f64) -> Self {
            self.bytes_scanned = Some(input);
            self
        }
        /// <p>The total number of bytes in the log events scanned during the query.</p>
        pub fn set_bytes_scanned(mut self, input: std::option::Option<f64>) -> Self {
            self.bytes_scanned = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryStatistics`](crate::model::QueryStatistics)
        pub fn build(self) -> crate::model::QueryStatistics {
            crate::model::QueryStatistics {
                records_matched: self.records_matched.unwrap_or_default(),
                records_scanned: self.records_scanned.unwrap_or_default(),
                bytes_scanned: self.bytes_scanned.unwrap_or_default(),
            }
        }
    }
}
impl QueryStatistics {
    /// Creates a new builder-style object to manufacture [`QueryStatistics`](crate::model::QueryStatistics)
    pub fn builder() -> crate::model::query_statistics::Builder {
        crate::model::query_statistics::Builder::default()
    }
}

/// <p>Contains one field from one log event returned by a CloudWatch Logs Insights query, along with the value of that field.</p>
/// <p>For more information about the fields that are
/// generated by CloudWatch logs, see
/// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html">Supported Logs and Discovered Fields</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultField {
    /// <p>The log event field.</p>
    pub field: std::option::Option<std::string::String>,
    /// <p>The value of this field.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ResultField {
    /// <p>The log event field.</p>
    pub fn field(&self) -> std::option::Option<&str> {
        self.field.as_deref()
    }
    /// <p>The value of this field.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ResultField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultField");
        formatter.field("field", &self.field);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ResultField`](crate::model::ResultField)
pub mod result_field {
    /// A builder for [`ResultField`](crate::model::ResultField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) field: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The log event field.</p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The log event field.</p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// <p>The value of this field.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of this field.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultField`](crate::model::ResultField)
        pub fn build(self) -> crate::model::ResultField {
            crate::model::ResultField {
                field: self.field,
                value: self.value,
            }
        }
    }
}
impl ResultField {
    /// Creates a new builder-style object to manufacture [`ResultField`](crate::model::ResultField)
    pub fn builder() -> crate::model::result_field::Builder {
        crate::model::result_field::Builder::default()
    }
}

/// <p>The fields contained in log events found by a <code>GetLogGroupFields</code> operation,
/// along with the percentage of queried log events in which each field appears.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogGroupField {
    /// <p>The name of a log field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The percentage of log events queried that contained the field.</p>
    pub percent: i32,
}
impl LogGroupField {
    /// <p>The name of a log field.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The percentage of log events queried that contained the field.</p>
    pub fn percent(&self) -> i32 {
        self.percent
    }
}
impl std::fmt::Debug for LogGroupField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogGroupField");
        formatter.field("name", &self.name);
        formatter.field("percent", &self.percent);
        formatter.finish()
    }
}
/// See [`LogGroupField`](crate::model::LogGroupField)
pub mod log_group_field {
    /// A builder for [`LogGroupField`](crate::model::LogGroupField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) percent: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of a log field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a log field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The percentage of log events queried that contained the field.</p>
        pub fn percent(mut self, input: i32) -> Self {
            self.percent = Some(input);
            self
        }
        /// <p>The percentage of log events queried that contained the field.</p>
        pub fn set_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.percent = input;
            self
        }
        /// Consumes the builder and constructs a [`LogGroupField`](crate::model::LogGroupField)
        pub fn build(self) -> crate::model::LogGroupField {
            crate::model::LogGroupField {
                name: self.name,
                percent: self.percent.unwrap_or_default(),
            }
        }
    }
}
impl LogGroupField {
    /// Creates a new builder-style object to manufacture [`LogGroupField`](crate::model::LogGroupField)
    pub fn builder() -> crate::model::log_group_field::Builder {
        crate::model::log_group_field::Builder::default()
    }
}

/// <p>Represents a log event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputLogEvent {
    /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub timestamp: std::option::Option<i64>,
    /// <p>The data contained in the log event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
    /// 1970 00:00:00 UTC.</p>
    pub ingestion_time: std::option::Option<i64>,
}
impl OutputLogEvent {
    /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub fn timestamp(&self) -> std::option::Option<i64> {
        self.timestamp
    }
    /// <p>The data contained in the log event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
    /// 1970 00:00:00 UTC.</p>
    pub fn ingestion_time(&self) -> std::option::Option<i64> {
        self.ingestion_time
    }
}
impl std::fmt::Debug for OutputLogEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputLogEvent");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("message", &self.message);
        formatter.field("ingestion_time", &self.ingestion_time);
        formatter.finish()
    }
}
/// See [`OutputLogEvent`](crate::model::OutputLogEvent)
pub mod output_log_event {
    /// A builder for [`OutputLogEvent`](crate::model::OutputLogEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) ingestion_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The data contained in the log event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The data contained in the log event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
        /// 1970 00:00:00 UTC.</p>
        pub fn ingestion_time(mut self, input: i64) -> Self {
            self.ingestion_time = Some(input);
            self
        }
        /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
        /// 1970 00:00:00 UTC.</p>
        pub fn set_ingestion_time(mut self, input: std::option::Option<i64>) -> Self {
            self.ingestion_time = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputLogEvent`](crate::model::OutputLogEvent)
        pub fn build(self) -> crate::model::OutputLogEvent {
            crate::model::OutputLogEvent {
                timestamp: self.timestamp,
                message: self.message,
                ingestion_time: self.ingestion_time,
            }
        }
    }
}
impl OutputLogEvent {
    /// Creates a new builder-style object to manufacture [`OutputLogEvent`](crate::model::OutputLogEvent)
    pub fn builder() -> crate::model::output_log_event::Builder {
        crate::model::output_log_event::Builder::default()
    }
}

/// <p>Represents the search status of a log stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchedLogStream {
    /// <p>The name of the log stream.</p>
    pub log_stream_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether all the events in this log stream were searched.</p>
    pub searched_completely: std::option::Option<bool>,
}
impl SearchedLogStream {
    /// <p>The name of the log stream.</p>
    pub fn log_stream_name(&self) -> std::option::Option<&str> {
        self.log_stream_name.as_deref()
    }
    /// <p>Indicates whether all the events in this log stream were searched.</p>
    pub fn searched_completely(&self) -> std::option::Option<bool> {
        self.searched_completely
    }
}
impl std::fmt::Debug for SearchedLogStream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchedLogStream");
        formatter.field("log_stream_name", &self.log_stream_name);
        formatter.field("searched_completely", &self.searched_completely);
        formatter.finish()
    }
}
/// See [`SearchedLogStream`](crate::model::SearchedLogStream)
pub mod searched_log_stream {
    /// A builder for [`SearchedLogStream`](crate::model::SearchedLogStream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_stream_name: std::option::Option<std::string::String>,
        pub(crate) searched_completely: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the log stream.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_name = input;
            self
        }
        /// <p>Indicates whether all the events in this log stream were searched.</p>
        pub fn searched_completely(mut self, input: bool) -> Self {
            self.searched_completely = Some(input);
            self
        }
        /// <p>Indicates whether all the events in this log stream were searched.</p>
        pub fn set_searched_completely(mut self, input: std::option::Option<bool>) -> Self {
            self.searched_completely = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchedLogStream`](crate::model::SearchedLogStream)
        pub fn build(self) -> crate::model::SearchedLogStream {
            crate::model::SearchedLogStream {
                log_stream_name: self.log_stream_name,
                searched_completely: self.searched_completely,
            }
        }
    }
}
impl SearchedLogStream {
    /// Creates a new builder-style object to manufacture [`SearchedLogStream`](crate::model::SearchedLogStream)
    pub fn builder() -> crate::model::searched_log_stream::Builder {
        crate::model::searched_log_stream::Builder::default()
    }
}

/// <p>Represents a matched event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilteredLogEvent {
    /// <p>The name of the log stream to which this event belongs.</p>
    pub log_stream_name: std::option::Option<std::string::String>,
    /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub timestamp: std::option::Option<i64>,
    /// <p>The data contained in the log event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
    /// 1970 00:00:00 UTC.</p>
    pub ingestion_time: std::option::Option<i64>,
    /// <p>The ID of the event.</p>
    pub event_id: std::option::Option<std::string::String>,
}
impl FilteredLogEvent {
    /// <p>The name of the log stream to which this event belongs.</p>
    pub fn log_stream_name(&self) -> std::option::Option<&str> {
        self.log_stream_name.as_deref()
    }
    /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub fn timestamp(&self) -> std::option::Option<i64> {
        self.timestamp
    }
    /// <p>The data contained in the log event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
    /// 1970 00:00:00 UTC.</p>
    pub fn ingestion_time(&self) -> std::option::Option<i64> {
        self.ingestion_time
    }
    /// <p>The ID of the event.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
}
impl std::fmt::Debug for FilteredLogEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilteredLogEvent");
        formatter.field("log_stream_name", &self.log_stream_name);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("message", &self.message);
        formatter.field("ingestion_time", &self.ingestion_time);
        formatter.field("event_id", &self.event_id);
        formatter.finish()
    }
}
/// See [`FilteredLogEvent`](crate::model::FilteredLogEvent)
pub mod filtered_log_event {
    /// A builder for [`FilteredLogEvent`](crate::model::FilteredLogEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_stream_name: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<i64>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) ingestion_time: std::option::Option<i64>,
        pub(crate) event_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the log stream to which this event belongs.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the log stream to which this event belongs.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_name = input;
            self
        }
        /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn timestamp(mut self, input: i64) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The data contained in the log event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The data contained in the log event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
        /// 1970 00:00:00 UTC.</p>
        pub fn ingestion_time(mut self, input: i64) -> Self {
            self.ingestion_time = Some(input);
            self
        }
        /// <p>The time the event was ingested, expressed as the number of milliseconds after Jan 1,
        /// 1970 00:00:00 UTC.</p>
        pub fn set_ingestion_time(mut self, input: std::option::Option<i64>) -> Self {
            self.ingestion_time = input;
            self
        }
        /// <p>The ID of the event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`FilteredLogEvent`](crate::model::FilteredLogEvent)
        pub fn build(self) -> crate::model::FilteredLogEvent {
            crate::model::FilteredLogEvent {
                log_stream_name: self.log_stream_name,
                timestamp: self.timestamp,
                message: self.message,
                ingestion_time: self.ingestion_time,
                event_id: self.event_id,
            }
        }
    }
}
impl FilteredLogEvent {
    /// Creates a new builder-style object to manufacture [`FilteredLogEvent`](crate::model::FilteredLogEvent)
    pub fn builder() -> crate::model::filtered_log_event::Builder {
        crate::model::filtered_log_event::Builder::default()
    }
}

/// <p>Represents a subscription filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionFilter {
    /// <p>The name of the subscription filter.</p>
    pub filter_name: std::option::Option<std::string::String>,
    /// <p>The name of the log group.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
    /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
    /// use the filter pattern to specify what to look for in the log event message.</p>
    pub filter_pattern: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the destination.</p>
    pub destination_arn: std::option::Option<std::string::String>,
    /// <p></p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The method used to distribute log data to the destination, which can be either
    /// random or grouped by log stream.</p>
    pub distribution: std::option::Option<crate::model::Distribution>,
    /// <p>The creation time of the subscription filter, expressed as the number of milliseconds
    /// after Jan 1, 1970 00:00:00 UTC.</p>
    pub creation_time: std::option::Option<i64>,
}
impl SubscriptionFilter {
    /// <p>The name of the subscription filter.</p>
    pub fn filter_name(&self) -> std::option::Option<&str> {
        self.filter_name.as_deref()
    }
    /// <p>The name of the log group.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
    /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
    /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
    /// use the filter pattern to specify what to look for in the log event message.</p>
    pub fn filter_pattern(&self) -> std::option::Option<&str> {
        self.filter_pattern.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the destination.</p>
    pub fn destination_arn(&self) -> std::option::Option<&str> {
        self.destination_arn.as_deref()
    }
    /// <p></p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The method used to distribute log data to the destination, which can be either
    /// random or grouped by log stream.</p>
    pub fn distribution(&self) -> std::option::Option<&crate::model::Distribution> {
        self.distribution.as_ref()
    }
    /// <p>The creation time of the subscription filter, expressed as the number of milliseconds
    /// after Jan 1, 1970 00:00:00 UTC.</p>
    pub fn creation_time(&self) -> std::option::Option<i64> {
        self.creation_time
    }
}
impl std::fmt::Debug for SubscriptionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionFilter");
        formatter.field("filter_name", &self.filter_name);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("filter_pattern", &self.filter_pattern);
        formatter.field("destination_arn", &self.destination_arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("distribution", &self.distribution);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`SubscriptionFilter`](crate::model::SubscriptionFilter)
pub mod subscription_filter {
    /// A builder for [`SubscriptionFilter`](crate::model::SubscriptionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_name: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) filter_pattern: std::option::Option<std::string::String>,
        pub(crate) destination_arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) distribution: std::option::Option<crate::model::Distribution>,
        pub(crate) creation_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the subscription filter.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_name = Some(input.into());
            self
        }
        /// <p>The name of the subscription filter.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_name = input;
            self
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
        /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
        /// use the filter pattern to specify what to look for in the log event message.</p>
        pub fn filter_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_pattern = Some(input.into());
            self
        }
        /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
        /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
        /// use the filter pattern to specify what to look for in the log event message.</p>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_pattern = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the destination.</p>
        pub fn set_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_arn = input;
            self
        }
        /// <p></p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The method used to distribute log data to the destination, which can be either
        /// random or grouped by log stream.</p>
        pub fn distribution(mut self, input: crate::model::Distribution) -> Self {
            self.distribution = Some(input);
            self
        }
        /// <p>The method used to distribute log data to the destination, which can be either
        /// random or grouped by log stream.</p>
        pub fn set_distribution(
            mut self,
            input: std::option::Option<crate::model::Distribution>,
        ) -> Self {
            self.distribution = input;
            self
        }
        /// <p>The creation time of the subscription filter, expressed as the number of milliseconds
        /// after Jan 1, 1970 00:00:00 UTC.</p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the subscription filter, expressed as the number of milliseconds
        /// after Jan 1, 1970 00:00:00 UTC.</p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionFilter`](crate::model::SubscriptionFilter)
        pub fn build(self) -> crate::model::SubscriptionFilter {
            crate::model::SubscriptionFilter {
                filter_name: self.filter_name,
                log_group_name: self.log_group_name,
                filter_pattern: self.filter_pattern,
                destination_arn: self.destination_arn,
                role_arn: self.role_arn,
                distribution: self.distribution,
                creation_time: self.creation_time,
            }
        }
    }
}
impl SubscriptionFilter {
    /// Creates a new builder-style object to manufacture [`SubscriptionFilter`](crate::model::SubscriptionFilter)
    pub fn builder() -> crate::model::subscription_filter::Builder {
        crate::model::subscription_filter::Builder::default()
    }
}

/// <p>This structure contains details about a saved CloudWatch Logs Insights query definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryDefinition {
    /// <p>The unique ID of the query definition.</p>
    pub query_definition_id: std::option::Option<std::string::String>,
    /// <p>The name of the query definition.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The query string to use for this definition.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The date that the query definition was most recently modified.</p>
    pub last_modified: std::option::Option<i64>,
    /// <p>If this query definition contains a list of log groups that it is limited to, that list appears here.</p>
    pub log_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl QueryDefinition {
    /// <p>The unique ID of the query definition.</p>
    pub fn query_definition_id(&self) -> std::option::Option<&str> {
        self.query_definition_id.as_deref()
    }
    /// <p>The name of the query definition.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The query string to use for this definition.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The date that the query definition was most recently modified.</p>
    pub fn last_modified(&self) -> std::option::Option<i64> {
        self.last_modified
    }
    /// <p>If this query definition contains a list of log groups that it is limited to, that list appears here.</p>
    pub fn log_group_names(&self) -> std::option::Option<&[std::string::String]> {
        self.log_group_names.as_deref()
    }
}
impl std::fmt::Debug for QueryDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryDefinition");
        formatter.field("query_definition_id", &self.query_definition_id);
        formatter.field("name", &self.name);
        formatter.field("query_string", &self.query_string);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("log_group_names", &self.log_group_names);
        formatter.finish()
    }
}
/// See [`QueryDefinition`](crate::model::QueryDefinition)
pub mod query_definition {
    /// A builder for [`QueryDefinition`](crate::model::QueryDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_definition_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<i64>,
        pub(crate) log_group_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique ID of the query definition.</p>
        pub fn query_definition_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_definition_id = Some(input.into());
            self
        }
        /// <p>The unique ID of the query definition.</p>
        pub fn set_query_definition_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.query_definition_id = input;
            self
        }
        /// <p>The name of the query definition.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the query definition.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The query string to use for this definition.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The query string to use for this definition.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The date that the query definition was most recently modified.</p>
        pub fn last_modified(mut self, input: i64) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date that the query definition was most recently modified.</p>
        pub fn set_last_modified(mut self, input: std::option::Option<i64>) -> Self {
            self.last_modified = input;
            self
        }
        /// Appends an item to `log_group_names`.
        ///
        /// To override the contents of this collection use [`set_log_group_names`](Self::set_log_group_names).
        ///
        /// <p>If this query definition contains a list of log groups that it is limited to, that list appears here.</p>
        pub fn log_group_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_group_names.unwrap_or_default();
            v.push(input.into());
            self.log_group_names = Some(v);
            self
        }
        /// <p>If this query definition contains a list of log groups that it is limited to, that list appears here.</p>
        pub fn set_log_group_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_group_names = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryDefinition`](crate::model::QueryDefinition)
        pub fn build(self) -> crate::model::QueryDefinition {
            crate::model::QueryDefinition {
                query_definition_id: self.query_definition_id,
                name: self.name,
                query_string: self.query_string,
                last_modified: self.last_modified,
                log_group_names: self.log_group_names,
            }
        }
    }
}
impl QueryDefinition {
    /// Creates a new builder-style object to manufacture [`QueryDefinition`](crate::model::QueryDefinition)
    pub fn builder() -> crate::model::query_definition::Builder {
        crate::model::query_definition::Builder::default()
    }
}

/// <p>Information about one CloudWatch Logs Insights query that matches the request in a <code>DescribeQueries</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryInfo {
    /// <p>The unique ID number of this query.</p>
    pub query_id: std::option::Option<std::string::String>,
    /// <p>The query string used in this query.</p>
    pub query_string: std::option::Option<std::string::String>,
    /// <p>The status of this query. Possible values are <code>Cancelled</code>,
    /// <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.</p>
    pub status: std::option::Option<crate::model::QueryStatus>,
    /// <p>The date and time that this query was created.</p>
    pub create_time: std::option::Option<i64>,
    /// <p>The name of the log group scanned by this query.</p>
    pub log_group_name: std::option::Option<std::string::String>,
}
impl QueryInfo {
    /// <p>The unique ID number of this query.</p>
    pub fn query_id(&self) -> std::option::Option<&str> {
        self.query_id.as_deref()
    }
    /// <p>The query string used in this query.</p>
    pub fn query_string(&self) -> std::option::Option<&str> {
        self.query_string.as_deref()
    }
    /// <p>The status of this query. Possible values are <code>Cancelled</code>,
    /// <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::QueryStatus> {
        self.status.as_ref()
    }
    /// <p>The date and time that this query was created.</p>
    pub fn create_time(&self) -> std::option::Option<i64> {
        self.create_time
    }
    /// <p>The name of the log group scanned by this query.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
}
impl std::fmt::Debug for QueryInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryInfo");
        formatter.field("query_id", &self.query_id);
        formatter.field("query_string", &self.query_string);
        formatter.field("status", &self.status);
        formatter.field("create_time", &self.create_time);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`QueryInfo`](crate::model::QueryInfo)
pub mod query_info {
    /// A builder for [`QueryInfo`](crate::model::QueryInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_id: std::option::Option<std::string::String>,
        pub(crate) query_string: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::QueryStatus>,
        pub(crate) create_time: std::option::Option<i64>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique ID number of this query.</p>
        pub fn query_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_id = Some(input.into());
            self
        }
        /// <p>The unique ID number of this query.</p>
        pub fn set_query_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_id = input;
            self
        }
        /// <p>The query string used in this query.</p>
        pub fn query_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.query_string = Some(input.into());
            self
        }
        /// <p>The query string used in this query.</p>
        pub fn set_query_string(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.query_string = input;
            self
        }
        /// <p>The status of this query. Possible values are <code>Cancelled</code>,
        /// <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.</p>
        pub fn status(mut self, input: crate::model::QueryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of this query. Possible values are <code>Cancelled</code>,
        /// <code>Complete</code>, <code>Failed</code>, <code>Running</code>, <code>Scheduled</code>, and <code>Unknown</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueryStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that this query was created.</p>
        pub fn create_time(mut self, input: i64) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The date and time that this query was created.</p>
        pub fn set_create_time(mut self, input: std::option::Option<i64>) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The name of the log group scanned by this query.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group scanned by this query.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryInfo`](crate::model::QueryInfo)
        pub fn build(self) -> crate::model::QueryInfo {
            crate::model::QueryInfo {
                query_id: self.query_id,
                query_string: self.query_string,
                status: self.status,
                create_time: self.create_time,
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl QueryInfo {
    /// Creates a new builder-style object to manufacture [`QueryInfo`](crate::model::QueryInfo)
    pub fn builder() -> crate::model::query_info::Builder {
        crate::model::query_info::Builder::default()
    }
}

/// <p>Metric filters express how CloudWatch Logs would extract metric observations
/// from ingested log events and transform them into metric data in a CloudWatch metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricFilter {
    /// <p>The name of the metric filter.</p>
    pub filter_name: std::option::Option<std::string::String>,
    /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
    /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
    /// use the filter pattern to specify what to look for in the log event message.</p>
    pub filter_pattern: std::option::Option<std::string::String>,
    /// <p>The metric transformations.</p>
    pub metric_transformations:
        std::option::Option<std::vec::Vec<crate::model::MetricTransformation>>,
    /// <p>The creation time of the metric filter, expressed as the number of milliseconds after
    /// Jan 1, 1970 00:00:00 UTC.</p>
    pub creation_time: std::option::Option<i64>,
    /// <p>The name of the log group.</p>
    pub log_group_name: std::option::Option<std::string::String>,
}
impl MetricFilter {
    /// <p>The name of the metric filter.</p>
    pub fn filter_name(&self) -> std::option::Option<&str> {
        self.filter_name.as_deref()
    }
    /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
    /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
    /// use the filter pattern to specify what to look for in the log event message.</p>
    pub fn filter_pattern(&self) -> std::option::Option<&str> {
        self.filter_pattern.as_deref()
    }
    /// <p>The metric transformations.</p>
    pub fn metric_transformations(
        &self,
    ) -> std::option::Option<&[crate::model::MetricTransformation]> {
        self.metric_transformations.as_deref()
    }
    /// <p>The creation time of the metric filter, expressed as the number of milliseconds after
    /// Jan 1, 1970 00:00:00 UTC.</p>
    pub fn creation_time(&self) -> std::option::Option<i64> {
        self.creation_time
    }
    /// <p>The name of the log group.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
}
impl std::fmt::Debug for MetricFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricFilter");
        formatter.field("filter_name", &self.filter_name);
        formatter.field("filter_pattern", &self.filter_pattern);
        formatter.field("metric_transformations", &self.metric_transformations);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.finish()
    }
}
/// See [`MetricFilter`](crate::model::MetricFilter)
pub mod metric_filter {
    /// A builder for [`MetricFilter`](crate::model::MetricFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_name: std::option::Option<std::string::String>,
        pub(crate) filter_pattern: std::option::Option<std::string::String>,
        pub(crate) metric_transformations:
            std::option::Option<std::vec::Vec<crate::model::MetricTransformation>>,
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric filter.</p>
        pub fn filter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_name = Some(input.into());
            self
        }
        /// <p>The name of the metric filter.</p>
        pub fn set_filter_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.filter_name = input;
            self
        }
        /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
        /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
        /// use the filter pattern to specify what to look for in the log event message.</p>
        pub fn filter_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_pattern = Some(input.into());
            self
        }
        /// <p>A symbolic description of how CloudWatch Logs should interpret the data in each log
        /// event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You
        /// use the filter pattern to specify what to look for in the log event message.</p>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_pattern = input;
            self
        }
        /// Appends an item to `metric_transformations`.
        ///
        /// To override the contents of this collection use [`set_metric_transformations`](Self::set_metric_transformations).
        ///
        /// <p>The metric transformations.</p>
        pub fn metric_transformations(
            mut self,
            input: impl Into<crate::model::MetricTransformation>,
        ) -> Self {
            let mut v = self.metric_transformations.unwrap_or_default();
            v.push(input.into());
            self.metric_transformations = Some(v);
            self
        }
        /// <p>The metric transformations.</p>
        pub fn set_metric_transformations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricTransformation>>,
        ) -> Self {
            self.metric_transformations = input;
            self
        }
        /// <p>The creation time of the metric filter, expressed as the number of milliseconds after
        /// Jan 1, 1970 00:00:00 UTC.</p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the metric filter, expressed as the number of milliseconds after
        /// Jan 1, 1970 00:00:00 UTC.</p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricFilter`](crate::model::MetricFilter)
        pub fn build(self) -> crate::model::MetricFilter {
            crate::model::MetricFilter {
                filter_name: self.filter_name,
                filter_pattern: self.filter_pattern,
                metric_transformations: self.metric_transformations,
                creation_time: self.creation_time,
                log_group_name: self.log_group_name,
            }
        }
    }
}
impl MetricFilter {
    /// Creates a new builder-style object to manufacture [`MetricFilter`](crate::model::MetricFilter)
    pub fn builder() -> crate::model::metric_filter::Builder {
        crate::model::metric_filter::Builder::default()
    }
}

/// <p>Represents a log stream, which is a sequence of log events from
/// a single emitter of logs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogStream {
    /// <p>The name of the log stream.</p>
    pub log_stream_name: std::option::Option<std::string::String>,
    /// <p>The creation time of the stream, expressed as the number of milliseconds after Jan 1,
    /// 1970 00:00:00 UTC.</p>
    pub creation_time: std::option::Option<i64>,
    /// <p>The time of the first event, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub first_event_timestamp: std::option::Option<i64>,
    /// <p>The time of the most recent log event in the log stream in CloudWatch Logs. This number
    /// is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. The
    /// <code>lastEventTime</code> value updates on an eventual consistency basis. It typically
    /// updates in less than an hour from ingestion, but in rare situations might take
    /// longer.</p>
    pub last_event_timestamp: std::option::Option<i64>,
    /// <p>The ingestion time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
    /// UTC.</p>
    pub last_ingestion_time: std::option::Option<i64>,
    /// <p>The sequence token.</p>
    pub upload_sequence_token: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the log stream.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The number of bytes stored.</p>
    /// <p>
    /// <b>Important:</b> On June 17, 2019, this parameter was
    /// deprecated for log streams, and is always reported as zero. This change applies only to log
    /// streams. The <code>storedBytes</code> parameter for log groups is not affected.</p>
    pub stored_bytes: std::option::Option<i64>,
}
impl LogStream {
    /// <p>The name of the log stream.</p>
    pub fn log_stream_name(&self) -> std::option::Option<&str> {
        self.log_stream_name.as_deref()
    }
    /// <p>The creation time of the stream, expressed as the number of milliseconds after Jan 1,
    /// 1970 00:00:00 UTC.</p>
    pub fn creation_time(&self) -> std::option::Option<i64> {
        self.creation_time
    }
    /// <p>The time of the first event, expressed as the number of milliseconds after Jan 1, 1970
    /// 00:00:00 UTC.</p>
    pub fn first_event_timestamp(&self) -> std::option::Option<i64> {
        self.first_event_timestamp
    }
    /// <p>The time of the most recent log event in the log stream in CloudWatch Logs. This number
    /// is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. The
    /// <code>lastEventTime</code> value updates on an eventual consistency basis. It typically
    /// updates in less than an hour from ingestion, but in rare situations might take
    /// longer.</p>
    pub fn last_event_timestamp(&self) -> std::option::Option<i64> {
        self.last_event_timestamp
    }
    /// <p>The ingestion time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
    /// UTC.</p>
    pub fn last_ingestion_time(&self) -> std::option::Option<i64> {
        self.last_ingestion_time
    }
    /// <p>The sequence token.</p>
    pub fn upload_sequence_token(&self) -> std::option::Option<&str> {
        self.upload_sequence_token.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the log stream.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The number of bytes stored.</p>
    /// <p>
    /// <b>Important:</b> On June 17, 2019, this parameter was
    /// deprecated for log streams, and is always reported as zero. This change applies only to log
    /// streams. The <code>storedBytes</code> parameter for log groups is not affected.</p>
    pub fn stored_bytes(&self) -> std::option::Option<i64> {
        self.stored_bytes
    }
}
impl std::fmt::Debug for LogStream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogStream");
        formatter.field("log_stream_name", &self.log_stream_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("first_event_timestamp", &self.first_event_timestamp);
        formatter.field("last_event_timestamp", &self.last_event_timestamp);
        formatter.field("last_ingestion_time", &self.last_ingestion_time);
        formatter.field("upload_sequence_token", &self.upload_sequence_token);
        formatter.field("arn", &self.arn);
        formatter.field("stored_bytes", &self.stored_bytes);
        formatter.finish()
    }
}
/// See [`LogStream`](crate::model::LogStream)
pub mod log_stream {
    /// A builder for [`LogStream`](crate::model::LogStream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_stream_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) first_event_timestamp: std::option::Option<i64>,
        pub(crate) last_event_timestamp: std::option::Option<i64>,
        pub(crate) last_ingestion_time: std::option::Option<i64>,
        pub(crate) upload_sequence_token: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) stored_bytes: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the log stream.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the log stream.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_name = input;
            self
        }
        /// <p>The creation time of the stream, expressed as the number of milliseconds after Jan 1,
        /// 1970 00:00:00 UTC.</p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the stream, expressed as the number of milliseconds after Jan 1,
        /// 1970 00:00:00 UTC.</p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time of the first event, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn first_event_timestamp(mut self, input: i64) -> Self {
            self.first_event_timestamp = Some(input);
            self
        }
        /// <p>The time of the first event, expressed as the number of milliseconds after Jan 1, 1970
        /// 00:00:00 UTC.</p>
        pub fn set_first_event_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.first_event_timestamp = input;
            self
        }
        /// <p>The time of the most recent log event in the log stream in CloudWatch Logs. This number
        /// is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. The
        /// <code>lastEventTime</code> value updates on an eventual consistency basis. It typically
        /// updates in less than an hour from ingestion, but in rare situations might take
        /// longer.</p>
        pub fn last_event_timestamp(mut self, input: i64) -> Self {
            self.last_event_timestamp = Some(input);
            self
        }
        /// <p>The time of the most recent log event in the log stream in CloudWatch Logs. This number
        /// is expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC. The
        /// <code>lastEventTime</code> value updates on an eventual consistency basis. It typically
        /// updates in less than an hour from ingestion, but in rare situations might take
        /// longer.</p>
        pub fn set_last_event_timestamp(mut self, input: std::option::Option<i64>) -> Self {
            self.last_event_timestamp = input;
            self
        }
        /// <p>The ingestion time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
        /// UTC.</p>
        pub fn last_ingestion_time(mut self, input: i64) -> Self {
            self.last_ingestion_time = Some(input);
            self
        }
        /// <p>The ingestion time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00
        /// UTC.</p>
        pub fn set_last_ingestion_time(mut self, input: std::option::Option<i64>) -> Self {
            self.last_ingestion_time = input;
            self
        }
        /// <p>The sequence token.</p>
        pub fn upload_sequence_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.upload_sequence_token = Some(input.into());
            self
        }
        /// <p>The sequence token.</p>
        pub fn set_upload_sequence_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.upload_sequence_token = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the log stream.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the log stream.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The number of bytes stored.</p>
        /// <p>
        /// <b>Important:</b> On June 17, 2019, this parameter was
        /// deprecated for log streams, and is always reported as zero. This change applies only to log
        /// streams. The <code>storedBytes</code> parameter for log groups is not affected.</p>
        pub fn stored_bytes(mut self, input: i64) -> Self {
            self.stored_bytes = Some(input);
            self
        }
        /// <p>The number of bytes stored.</p>
        /// <p>
        /// <b>Important:</b> On June 17, 2019, this parameter was
        /// deprecated for log streams, and is always reported as zero. This change applies only to log
        /// streams. The <code>storedBytes</code> parameter for log groups is not affected.</p>
        pub fn set_stored_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.stored_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`LogStream`](crate::model::LogStream)
        pub fn build(self) -> crate::model::LogStream {
            crate::model::LogStream {
                log_stream_name: self.log_stream_name,
                creation_time: self.creation_time,
                first_event_timestamp: self.first_event_timestamp,
                last_event_timestamp: self.last_event_timestamp,
                last_ingestion_time: self.last_ingestion_time,
                upload_sequence_token: self.upload_sequence_token,
                arn: self.arn,
                stored_bytes: self.stored_bytes,
            }
        }
    }
}
impl LogStream {
    /// Creates a new builder-style object to manufacture [`LogStream`](crate::model::LogStream)
    pub fn builder() -> crate::model::log_stream::Builder {
        crate::model::log_stream::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderBy {
    #[allow(missing_docs)] // documentation missing in model
    LastEventTime,
    #[allow(missing_docs)] // documentation missing in model
    LogStreamName,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderBy {
    fn from(s: &str) -> Self {
        match s {
            "LastEventTime" => OrderBy::LastEventTime,
            "LogStreamName" => OrderBy::LogStreamName,
            other => OrderBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderBy::from(s))
    }
}
impl OrderBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderBy::LastEventTime => "LastEventTime",
            OrderBy::LogStreamName => "LogStreamName",
            OrderBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LastEventTime", "LogStreamName"]
    }
}
impl AsRef<str> for OrderBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a log group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogGroup {
    /// <p>The name of the log group.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>The creation time of the log group, expressed as the number of milliseconds after Jan
    /// 1, 1970 00:00:00 UTC.</p>
    pub creation_time: std::option::Option<i64>,
    /// <p>The number of days to retain the log events in the specified log group.
    /// Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p>
    /// <p>To set a log group to never have log events expire, use
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>.
    /// </p>
    pub retention_in_days: std::option::Option<i32>,
    /// <p>The number of metric filters.</p>
    pub metric_filter_count: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the log group.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The number of bytes stored.</p>
    pub stored_bytes: std::option::Option<i64>,
    /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl LogGroup {
    /// <p>The name of the log group.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
    /// <p>The creation time of the log group, expressed as the number of milliseconds after Jan
    /// 1, 1970 00:00:00 UTC.</p>
    pub fn creation_time(&self) -> std::option::Option<i64> {
        self.creation_time
    }
    /// <p>The number of days to retain the log events in the specified log group.
    /// Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p>
    /// <p>To set a log group to never have log events expire, use
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>.
    /// </p>
    pub fn retention_in_days(&self) -> std::option::Option<i32> {
        self.retention_in_days
    }
    /// <p>The number of metric filters.</p>
    pub fn metric_filter_count(&self) -> std::option::Option<i32> {
        self.metric_filter_count
    }
    /// <p>The Amazon Resource Name (ARN) of the log group.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The number of bytes stored.</p>
    pub fn stored_bytes(&self) -> std::option::Option<i64> {
        self.stored_bytes
    }
    /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for LogGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogGroup");
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("retention_in_days", &self.retention_in_days);
        formatter.field("metric_filter_count", &self.metric_filter_count);
        formatter.field("arn", &self.arn);
        formatter.field("stored_bytes", &self.stored_bytes);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}
/// See [`LogGroup`](crate::model::LogGroup)
pub mod log_group {
    /// A builder for [`LogGroup`](crate::model::LogGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) retention_in_days: std::option::Option<i32>,
        pub(crate) metric_filter_count: std::option::Option<i32>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) stored_bytes: std::option::Option<i64>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the log group.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>The creation time of the log group, expressed as the number of milliseconds after Jan
        /// 1, 1970 00:00:00 UTC.</p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the log group, expressed as the number of milliseconds after Jan
        /// 1, 1970 00:00:00 UTC.</p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The number of days to retain the log events in the specified log group.
        /// Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p>
        /// <p>To set a log group to never have log events expire, use
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>.
        /// </p>
        pub fn retention_in_days(mut self, input: i32) -> Self {
            self.retention_in_days = Some(input);
            self
        }
        /// <p>The number of days to retain the log events in the specified log group.
        /// Possible values are: 1, 3, 5, 7, 14, 30, 60, 90, 120, 150, 180, 365, 400, 545, 731, 1827, and 3653.</p>
        /// <p>To set a log group to never have log events expire, use
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteRetentionPolicy.html">DeleteRetentionPolicy</a>.
        /// </p>
        pub fn set_retention_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_in_days = input;
            self
        }
        /// <p>The number of metric filters.</p>
        pub fn metric_filter_count(mut self, input: i32) -> Self {
            self.metric_filter_count = Some(input);
            self
        }
        /// <p>The number of metric filters.</p>
        pub fn set_metric_filter_count(mut self, input: std::option::Option<i32>) -> Self {
            self.metric_filter_count = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the log group.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the log group.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The number of bytes stored.</p>
        pub fn stored_bytes(mut self, input: i64) -> Self {
            self.stored_bytes = Some(input);
            self
        }
        /// <p>The number of bytes stored.</p>
        pub fn set_stored_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.stored_bytes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CMK to use when encrypting log data.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`LogGroup`](crate::model::LogGroup)
        pub fn build(self) -> crate::model::LogGroup {
            crate::model::LogGroup {
                log_group_name: self.log_group_name,
                creation_time: self.creation_time,
                retention_in_days: self.retention_in_days,
                metric_filter_count: self.metric_filter_count,
                arn: self.arn,
                stored_bytes: self.stored_bytes,
                kms_key_id: self.kms_key_id,
            }
        }
    }
}
impl LogGroup {
    /// Creates a new builder-style object to manufacture [`LogGroup`](crate::model::LogGroup)
    pub fn builder() -> crate::model::log_group::Builder {
        crate::model::log_group::Builder::default()
    }
}

/// <p>Represents an export task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportTask {
    /// <p>The ID of the export task.</p>
    pub task_id: std::option::Option<std::string::String>,
    /// <p>The name of the export task.</p>
    pub task_name: std::option::Option<std::string::String>,
    /// <p>The name of the log group from which logs data was exported.</p>
    pub log_group_name: std::option::Option<std::string::String>,
    /// <p>The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
    /// Events with a timestamp before this time are not exported.</p>
    pub from: std::option::Option<i64>,
    /// <p>The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
    /// Events with a timestamp later than this time are not exported.</p>
    pub to: std::option::Option<i64>,
    /// <p>The name of the S3 bucket to which the log data was exported.</p>
    pub destination: std::option::Option<std::string::String>,
    /// <p>The prefix that was used as the start of Amazon S3 key for every object exported.</p>
    pub destination_prefix: std::option::Option<std::string::String>,
    /// <p>The status of the export task.</p>
    pub status: std::option::Option<crate::model::ExportTaskStatus>,
    /// <p>Execution information about the export task.</p>
    pub execution_info: std::option::Option<crate::model::ExportTaskExecutionInfo>,
}
impl ExportTask {
    /// <p>The ID of the export task.</p>
    pub fn task_id(&self) -> std::option::Option<&str> {
        self.task_id.as_deref()
    }
    /// <p>The name of the export task.</p>
    pub fn task_name(&self) -> std::option::Option<&str> {
        self.task_name.as_deref()
    }
    /// <p>The name of the log group from which logs data was exported.</p>
    pub fn log_group_name(&self) -> std::option::Option<&str> {
        self.log_group_name.as_deref()
    }
    /// <p>The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
    /// Events with a timestamp before this time are not exported.</p>
    pub fn from(&self) -> std::option::Option<i64> {
        self.from
    }
    /// <p>The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
    /// Events with a timestamp later than this time are not exported.</p>
    pub fn to(&self) -> std::option::Option<i64> {
        self.to
    }
    /// <p>The name of the S3 bucket to which the log data was exported.</p>
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
    /// <p>The prefix that was used as the start of Amazon S3 key for every object exported.</p>
    pub fn destination_prefix(&self) -> std::option::Option<&str> {
        self.destination_prefix.as_deref()
    }
    /// <p>The status of the export task.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ExportTaskStatus> {
        self.status.as_ref()
    }
    /// <p>Execution information about the export task.</p>
    pub fn execution_info(&self) -> std::option::Option<&crate::model::ExportTaskExecutionInfo> {
        self.execution_info.as_ref()
    }
}
impl std::fmt::Debug for ExportTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportTask");
        formatter.field("task_id", &self.task_id);
        formatter.field("task_name", &self.task_name);
        formatter.field("log_group_name", &self.log_group_name);
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.field("destination", &self.destination);
        formatter.field("destination_prefix", &self.destination_prefix);
        formatter.field("status", &self.status);
        formatter.field("execution_info", &self.execution_info);
        formatter.finish()
    }
}
/// See [`ExportTask`](crate::model::ExportTask)
pub mod export_task {
    /// A builder for [`ExportTask`](crate::model::ExportTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_id: std::option::Option<std::string::String>,
        pub(crate) task_name: std::option::Option<std::string::String>,
        pub(crate) log_group_name: std::option::Option<std::string::String>,
        pub(crate) from: std::option::Option<i64>,
        pub(crate) to: std::option::Option<i64>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) destination_prefix: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ExportTaskStatus>,
        pub(crate) execution_info: std::option::Option<crate::model::ExportTaskExecutionInfo>,
    }
    impl Builder {
        /// <p>The ID of the export task.</p>
        pub fn task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_id = Some(input.into());
            self
        }
        /// <p>The ID of the export task.</p>
        pub fn set_task_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_id = input;
            self
        }
        /// <p>The name of the export task.</p>
        pub fn task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_name = Some(input.into());
            self
        }
        /// <p>The name of the export task.</p>
        pub fn set_task_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_name = input;
            self
        }
        /// <p>The name of the log group from which logs data was exported.</p>
        pub fn log_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_group_name = Some(input.into());
            self
        }
        /// <p>The name of the log group from which logs data was exported.</p>
        pub fn set_log_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_group_name = input;
            self
        }
        /// <p>The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
        /// Events with a timestamp before this time are not exported.</p>
        pub fn from(mut self, input: i64) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The start time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
        /// Events with a timestamp before this time are not exported.</p>
        pub fn set_from(mut self, input: std::option::Option<i64>) -> Self {
            self.from = input;
            self
        }
        /// <p>The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
        /// Events with a timestamp later than this time are not exported.</p>
        pub fn to(mut self, input: i64) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The end time, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.
        /// Events with a timestamp later than this time are not exported.</p>
        pub fn set_to(mut self, input: std::option::Option<i64>) -> Self {
            self.to = input;
            self
        }
        /// <p>The name of the S3 bucket to which the log data was exported.</p>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket to which the log data was exported.</p>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The prefix that was used as the start of Amazon S3 key for every object exported.</p>
        pub fn destination_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_prefix = Some(input.into());
            self
        }
        /// <p>The prefix that was used as the start of Amazon S3 key for every object exported.</p>
        pub fn set_destination_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_prefix = input;
            self
        }
        /// <p>The status of the export task.</p>
        pub fn status(mut self, input: crate::model::ExportTaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the export task.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ExportTaskStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Execution information about the export task.</p>
        pub fn execution_info(mut self, input: crate::model::ExportTaskExecutionInfo) -> Self {
            self.execution_info = Some(input);
            self
        }
        /// <p>Execution information about the export task.</p>
        pub fn set_execution_info(
            mut self,
            input: std::option::Option<crate::model::ExportTaskExecutionInfo>,
        ) -> Self {
            self.execution_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportTask`](crate::model::ExportTask)
        pub fn build(self) -> crate::model::ExportTask {
            crate::model::ExportTask {
                task_id: self.task_id,
                task_name: self.task_name,
                log_group_name: self.log_group_name,
                from: self.from,
                to: self.to,
                destination: self.destination,
                destination_prefix: self.destination_prefix,
                status: self.status,
                execution_info: self.execution_info,
            }
        }
    }
}
impl ExportTask {
    /// Creates a new builder-style object to manufacture [`ExportTask`](crate::model::ExportTask)
    pub fn builder() -> crate::model::export_task::Builder {
        crate::model::export_task::Builder::default()
    }
}

/// <p>Represents the status of an export task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportTaskExecutionInfo {
    /// <p>The creation time of the export task, expressed as the number of milliseconds after Jan
    /// 1, 1970 00:00:00 UTC.</p>
    pub creation_time: std::option::Option<i64>,
    /// <p>The completion time of the export task, expressed as the number of milliseconds after
    /// Jan 1, 1970 00:00:00 UTC.</p>
    pub completion_time: std::option::Option<i64>,
}
impl ExportTaskExecutionInfo {
    /// <p>The creation time of the export task, expressed as the number of milliseconds after Jan
    /// 1, 1970 00:00:00 UTC.</p>
    pub fn creation_time(&self) -> std::option::Option<i64> {
        self.creation_time
    }
    /// <p>The completion time of the export task, expressed as the number of milliseconds after
    /// Jan 1, 1970 00:00:00 UTC.</p>
    pub fn completion_time(&self) -> std::option::Option<i64> {
        self.completion_time
    }
}
impl std::fmt::Debug for ExportTaskExecutionInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportTaskExecutionInfo");
        formatter.field("creation_time", &self.creation_time);
        formatter.field("completion_time", &self.completion_time);
        formatter.finish()
    }
}
/// See [`ExportTaskExecutionInfo`](crate::model::ExportTaskExecutionInfo)
pub mod export_task_execution_info {
    /// A builder for [`ExportTaskExecutionInfo`](crate::model::ExportTaskExecutionInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_time: std::option::Option<i64>,
        pub(crate) completion_time: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The creation time of the export task, expressed as the number of milliseconds after Jan
        /// 1, 1970 00:00:00 UTC.</p>
        pub fn creation_time(mut self, input: i64) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The creation time of the export task, expressed as the number of milliseconds after Jan
        /// 1, 1970 00:00:00 UTC.</p>
        pub fn set_creation_time(mut self, input: std::option::Option<i64>) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The completion time of the export task, expressed as the number of milliseconds after
        /// Jan 1, 1970 00:00:00 UTC.</p>
        pub fn completion_time(mut self, input: i64) -> Self {
            self.completion_time = Some(input);
            self
        }
        /// <p>The completion time of the export task, expressed as the number of milliseconds after
        /// Jan 1, 1970 00:00:00 UTC.</p>
        pub fn set_completion_time(mut self, input: std::option::Option<i64>) -> Self {
            self.completion_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportTaskExecutionInfo`](crate::model::ExportTaskExecutionInfo)
        pub fn build(self) -> crate::model::ExportTaskExecutionInfo {
            crate::model::ExportTaskExecutionInfo {
                creation_time: self.creation_time,
                completion_time: self.completion_time,
            }
        }
    }
}
impl ExportTaskExecutionInfo {
    /// Creates a new builder-style object to manufacture [`ExportTaskExecutionInfo`](crate::model::ExportTaskExecutionInfo)
    pub fn builder() -> crate::model::export_task_execution_info::Builder {
        crate::model::export_task_execution_info::Builder::default()
    }
}

/// <p>Represents the status of an export task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportTaskStatus {
    /// <p>The status code of the export task.</p>
    pub code: std::option::Option<crate::model::ExportTaskStatusCode>,
    /// <p>The status message related to the status code.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ExportTaskStatus {
    /// <p>The status code of the export task.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::ExportTaskStatusCode> {
        self.code.as_ref()
    }
    /// <p>The status message related to the status code.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ExportTaskStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportTaskStatus");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ExportTaskStatus`](crate::model::ExportTaskStatus)
pub mod export_task_status {
    /// A builder for [`ExportTaskStatus`](crate::model::ExportTaskStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ExportTaskStatusCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status code of the export task.</p>
        pub fn code(mut self, input: crate::model::ExportTaskStatusCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The status code of the export task.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::ExportTaskStatusCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>The status message related to the status code.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The status message related to the status code.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportTaskStatus`](crate::model::ExportTaskStatus)
        pub fn build(self) -> crate::model::ExportTaskStatus {
            crate::model::ExportTaskStatus {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ExportTaskStatus {
    /// Creates a new builder-style object to manufacture [`ExportTaskStatus`](crate::model::ExportTaskStatus)
    pub fn builder() -> crate::model::export_task_status::Builder {
        crate::model::export_task_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportTaskStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    PendingCancel,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportTaskStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => ExportTaskStatusCode::Cancelled,
            "COMPLETED" => ExportTaskStatusCode::Completed,
            "FAILED" => ExportTaskStatusCode::Failed,
            "PENDING" => ExportTaskStatusCode::Pending,
            "PENDING_CANCEL" => ExportTaskStatusCode::PendingCancel,
            "RUNNING" => ExportTaskStatusCode::Running,
            other => ExportTaskStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportTaskStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportTaskStatusCode::from(s))
    }
}
impl ExportTaskStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportTaskStatusCode::Cancelled => "CANCELLED",
            ExportTaskStatusCode::Completed => "COMPLETED",
            ExportTaskStatusCode::Failed => "FAILED",
            ExportTaskStatusCode::Pending => "PENDING",
            ExportTaskStatusCode::PendingCancel => "PENDING_CANCEL",
            ExportTaskStatusCode::Running => "RUNNING",
            ExportTaskStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "COMPLETED",
            "FAILED",
            "PENDING",
            "PENDING_CANCEL",
            "RUNNING",
        ]
    }
}
impl AsRef<str> for ExportTaskStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
