// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateKmsKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateKmsKeyError {
    /// Kind of error that occurred.
    pub kind: AssociateKmsKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateKmsKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateKmsKeyErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateKmsKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateKmsKeyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateKmsKeyErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            AssociateKmsKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateKmsKeyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AssociateKmsKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateKmsKeyError {
    fn code(&self) -> Option<&str> {
        AssociateKmsKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateKmsKeyError {
    /// Creates a new `AssociateKmsKeyError`.
    pub fn new(kind: AssociateKmsKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateKmsKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateKmsKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateKmsKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateKmsKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateKmsKeyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateKmsKeyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateKmsKeyErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateKmsKeyErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateKmsKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateKmsKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateKmsKeyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateKmsKeyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for AssociateKmsKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateKmsKeyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateKmsKeyErrorKind::OperationAbortedException(_inner) => Some(_inner),
            AssociateKmsKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateKmsKeyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AssociateKmsKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelExportTaskError {
    /// Kind of error that occurred.
    pub kind: CancelExportTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelExportTaskErrorKind {
    /// <p>The operation is not valid on the specified resource.</p>
    InvalidOperationException(crate::error::InvalidOperationException),
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelExportTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelExportTaskErrorKind::InvalidOperationException(_inner) => _inner.fmt(f),
            CancelExportTaskErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CancelExportTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelExportTaskErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CancelExportTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelExportTaskError {
    fn code(&self) -> Option<&str> {
        CancelExportTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelExportTaskError {
    /// Creates a new `CancelExportTaskError`.
    pub fn new(kind: CancelExportTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelExportTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelExportTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelExportTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelExportTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelExportTaskErrorKind::InvalidOperationException`.
    pub fn is_invalid_operation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelExportTaskErrorKind::InvalidOperationException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelExportTaskErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelExportTaskErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelExportTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelExportTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelExportTaskErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelExportTaskErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CancelExportTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelExportTaskErrorKind::InvalidOperationException(_inner) => Some(_inner),
            CancelExportTaskErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CancelExportTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelExportTaskErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CancelExportTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateExportTaskError {
    /// Kind of error that occurred.
    pub kind: CreateExportTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateExportTaskErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateExportTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateExportTaskErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateExportTaskErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateExportTaskErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            CreateExportTaskErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateExportTaskErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateExportTaskErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateExportTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateExportTaskError {
    fn code(&self) -> Option<&str> {
        CreateExportTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateExportTaskError {
    /// Creates a new `CreateExportTaskError`.
    pub fn new(kind: CreateExportTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateExportTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateExportTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateExportTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateExportTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateExportTaskErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportTaskErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportTaskErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportTaskErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportTaskErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportTaskErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportTaskErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportTaskErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportTaskErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportTaskErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateExportTaskErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateExportTaskErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateExportTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateExportTaskErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateExportTaskErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateExportTaskErrorKind::OperationAbortedException(_inner) => Some(_inner),
            CreateExportTaskErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateExportTaskErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateExportTaskErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateExportTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLogGroupError {
    /// Kind of error that occurred.
    pub kind: CreateLogGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLogGroupErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLogGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLogGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateLogGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateLogGroupErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            CreateLogGroupErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateLogGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateLogGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLogGroupError {
    fn code(&self) -> Option<&str> {
        CreateLogGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLogGroupError {
    /// Creates a new `CreateLogGroupError`.
    pub fn new(kind: CreateLogGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLogGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLogGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLogGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLogGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLogGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogGroupErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogGroupErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogGroupErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogGroupErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogGroupErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateLogGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLogGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateLogGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateLogGroupErrorKind::OperationAbortedException(_inner) => Some(_inner),
            CreateLogGroupErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateLogGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateLogGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLogStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLogStreamError {
    /// Kind of error that occurred.
    pub kind: CreateLogStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLogStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLogStreamErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLogStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLogStreamErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateLogStreamErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateLogStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateLogStreamErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateLogStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLogStreamError {
    fn code(&self) -> Option<&str> {
        CreateLogStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLogStreamError {
    /// Creates a new `CreateLogStreamError`.
    pub fn new(kind: CreateLogStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLogStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLogStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLogStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLogStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLogStreamErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogStreamErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogStreamErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogStreamErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLogStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLogStreamErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for CreateLogStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLogStreamErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateLogStreamErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateLogStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateLogStreamErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateLogStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDestinationErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDestinationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDestinationError {
    /// Creates a new `DeleteDestinationError`.
    pub fn new(kind: DeleteDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDestinationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDestinationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDestinationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::OperationAbortedException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLogGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteLogGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLogGroupErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLogGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLogGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteLogGroupErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            DeleteLogGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteLogGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteLogGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLogGroupError {
    fn code(&self) -> Option<&str> {
        DeleteLogGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLogGroupError {
    /// Creates a new `DeleteLogGroupError`.
    pub fn new(kind: DeleteLogGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLogGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLogGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLogGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLogGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLogGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogGroupErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogGroupErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogGroupErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteLogGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLogGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteLogGroupErrorKind::OperationAbortedException(_inner) => Some(_inner),
            DeleteLogGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteLogGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteLogGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLogStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLogStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteLogStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLogStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLogStreamErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLogStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLogStreamErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteLogStreamErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            DeleteLogStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteLogStreamErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteLogStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLogStreamError {
    fn code(&self) -> Option<&str> {
        DeleteLogStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLogStreamError {
    /// Creates a new `DeleteLogStreamError`.
    pub fn new(kind: DeleteLogStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLogStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLogStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLogStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLogStreamErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLogStreamErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogStreamErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogStreamErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogStreamErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogStreamErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLogStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLogStreamErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteLogStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLogStreamErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteLogStreamErrorKind::OperationAbortedException(_inner) => Some(_inner),
            DeleteLogStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteLogStreamErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteLogStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMetricFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMetricFilterError {
    /// Kind of error that occurred.
    pub kind: DeleteMetricFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMetricFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMetricFilterErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMetricFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMetricFilterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteMetricFilterErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            DeleteMetricFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteMetricFilterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteMetricFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMetricFilterError {
    fn code(&self) -> Option<&str> {
        DeleteMetricFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMetricFilterError {
    /// Creates a new `DeleteMetricFilterError`.
    pub fn new(kind: DeleteMetricFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMetricFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMetricFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMetricFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMetricFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMetricFilterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricFilterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMetricFilterErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricFilterErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMetricFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMetricFilterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricFilterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteMetricFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMetricFilterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteMetricFilterErrorKind::OperationAbortedException(_inner) => Some(_inner),
            DeleteMetricFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteMetricFilterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteMetricFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQueryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQueryDefinitionError {
    /// Kind of error that occurred.
    pub kind: DeleteQueryDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQueryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQueryDefinitionErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQueryDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQueryDefinitionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteQueryDefinitionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteQueryDefinitionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteQueryDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQueryDefinitionError {
    fn code(&self) -> Option<&str> {
        DeleteQueryDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQueryDefinitionError {
    /// Creates a new `DeleteQueryDefinitionError`.
    pub fn new(kind: DeleteQueryDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQueryDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQueryDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQueryDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQueryDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteQueryDefinitionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueryDefinitionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueryDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueryDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueryDefinitionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueryDefinitionErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteQueryDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQueryDefinitionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteQueryDefinitionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteQueryDefinitionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteQueryDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteResourcePolicyErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteResourcePolicyError {
    fn code(&self) -> Option<&str> {
        DeleteResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteResourcePolicyError {
    /// Creates a new `DeleteResourcePolicyError`.
    pub fn new(kind: DeleteResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteResourcePolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteResourcePolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteResourcePolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRetentionPolicyError {
    /// Kind of error that occurred.
    pub kind: DeleteRetentionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRetentionPolicyErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRetentionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRetentionPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteRetentionPolicyErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            DeleteRetentionPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRetentionPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteRetentionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRetentionPolicyError {
    fn code(&self) -> Option<&str> {
        DeleteRetentionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRetentionPolicyError {
    /// Creates a new `DeleteRetentionPolicyError`.
    pub fn new(kind: DeleteRetentionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRetentionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRetentionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRetentionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRetentionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRetentionPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRetentionPolicyErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionPolicyErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRetentionPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRetentionPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRetentionPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteRetentionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRetentionPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteRetentionPolicyErrorKind::OperationAbortedException(_inner) => Some(_inner),
            DeleteRetentionPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRetentionPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteRetentionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSubscriptionFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSubscriptionFilterError {
    /// Kind of error that occurred.
    pub kind: DeleteSubscriptionFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSubscriptionFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSubscriptionFilterErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSubscriptionFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSubscriptionFilterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteSubscriptionFilterErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            DeleteSubscriptionFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSubscriptionFilterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteSubscriptionFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSubscriptionFilterError {
    fn code(&self) -> Option<&str> {
        DeleteSubscriptionFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSubscriptionFilterError {
    /// Creates a new `DeleteSubscriptionFilterError`.
    pub fn new(kind: DeleteSubscriptionFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSubscriptionFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSubscriptionFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSubscriptionFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSubscriptionFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSubscriptionFilterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriptionFilterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriptionFilterErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriptionFilterErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriptionFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriptionFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSubscriptionFilterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSubscriptionFilterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DeleteSubscriptionFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSubscriptionFilterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteSubscriptionFilterErrorKind::OperationAbortedException(_inner) => Some(_inner),
            DeleteSubscriptionFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSubscriptionFilterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteSubscriptionFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDestinationsError {
    /// Kind of error that occurred.
    pub kind: DescribeDestinationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDestinationsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDestinationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDestinationsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeDestinationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeDestinationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDestinationsError {
    fn code(&self) -> Option<&str> {
        DescribeDestinationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDestinationsError {
    /// Creates a new `DescribeDestinationsError`.
    pub fn new(kind: DescribeDestinationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDestinationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDestinationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDestinationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDestinationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDestinationsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDestinationsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDestinationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDestinationsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeDestinationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDestinationsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeDestinationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeDestinationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExportTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExportTasksError {
    /// Kind of error that occurred.
    pub kind: DescribeExportTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExportTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExportTasksErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExportTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExportTasksErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeExportTasksErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeExportTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExportTasksError {
    fn code(&self) -> Option<&str> {
        DescribeExportTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExportTasksError {
    /// Creates a new `DescribeExportTasksError`.
    pub fn new(kind: DescribeExportTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExportTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExportTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExportTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExportTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExportTasksErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExportTasksErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeExportTasksErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExportTasksErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeExportTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExportTasksErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeExportTasksErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeExportTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLogGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLogGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeLogGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLogGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLogGroupsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLogGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLogGroupsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeLogGroupsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeLogGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLogGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeLogGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLogGroupsError {
    /// Creates a new `DescribeLogGroupsError`.
    pub fn new(kind: DescribeLogGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLogGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLogGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLogGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLogGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLogGroupsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogGroupsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLogGroupsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogGroupsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeLogGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLogGroupsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeLogGroupsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeLogGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLogStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLogStreamsError {
    /// Kind of error that occurred.
    pub kind: DescribeLogStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLogStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLogStreamsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLogStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLogStreamsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeLogStreamsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeLogStreamsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeLogStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLogStreamsError {
    fn code(&self) -> Option<&str> {
        DescribeLogStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLogStreamsError {
    /// Creates a new `DescribeLogStreamsError`.
    pub fn new(kind: DescribeLogStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLogStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLogStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLogStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLogStreamsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLogStreamsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogStreamsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLogStreamsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogStreamsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeLogStreamsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLogStreamsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeLogStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLogStreamsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeLogStreamsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeLogStreamsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeLogStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMetricFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMetricFiltersError {
    /// Kind of error that occurred.
    pub kind: DescribeMetricFiltersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMetricFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMetricFiltersErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMetricFiltersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMetricFiltersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeMetricFiltersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeMetricFiltersErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeMetricFiltersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMetricFiltersError {
    fn code(&self) -> Option<&str> {
        DescribeMetricFiltersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMetricFiltersError {
    /// Creates a new `DescribeMetricFiltersError`.
    pub fn new(kind: DescribeMetricFiltersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMetricFiltersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMetricFiltersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMetricFiltersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMetricFiltersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMetricFiltersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricFiltersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMetricFiltersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricFiltersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMetricFiltersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricFiltersErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeMetricFiltersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMetricFiltersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeMetricFiltersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeMetricFiltersErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeMetricFiltersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeQueriesError {
    /// Kind of error that occurred.
    pub kind: DescribeQueriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeQueries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeQueriesErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeQueriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeQueriesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeQueriesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeQueriesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeQueriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeQueriesError {
    fn code(&self) -> Option<&str> {
        DescribeQueriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeQueriesError {
    /// Creates a new `DescribeQueriesError`.
    pub fn new(kind: DescribeQueriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeQueriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeQueriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeQueriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeQueriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeQueriesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueriesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueriesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueriesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueriesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueriesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeQueriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeQueriesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeQueriesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeQueriesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeQueriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeQueryDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeQueryDefinitionsError {
    /// Kind of error that occurred.
    pub kind: DescribeQueryDefinitionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeQueryDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeQueryDefinitionsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeQueryDefinitionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeQueryDefinitionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeQueryDefinitionsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeQueryDefinitionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeQueryDefinitionsError {
    fn code(&self) -> Option<&str> {
        DescribeQueryDefinitionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeQueryDefinitionsError {
    /// Creates a new `DescribeQueryDefinitionsError`.
    pub fn new(kind: DescribeQueryDefinitionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeQueryDefinitionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeQueryDefinitionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeQueryDefinitionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeQueryDefinitionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeQueryDefinitionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryDefinitionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueryDefinitionsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueryDefinitionsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeQueryDefinitionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeQueryDefinitionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeQueryDefinitionsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeQueryDefinitionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResourcePoliciesError {
    /// Kind of error that occurred.
    pub kind: DescribeResourcePoliciesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResourcePolicies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResourcePoliciesErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResourcePoliciesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResourcePoliciesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeResourcePoliciesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeResourcePoliciesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResourcePoliciesError {
    fn code(&self) -> Option<&str> {
        DescribeResourcePoliciesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResourcePoliciesError {
    /// Creates a new `DescribeResourcePoliciesError`.
    pub fn new(kind: DescribeResourcePoliciesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResourcePoliciesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResourcePoliciesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResourcePoliciesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResourcePoliciesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResourcePoliciesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePoliciesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeResourcePoliciesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeResourcePoliciesErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeResourcePoliciesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResourcePoliciesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeResourcePoliciesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeResourcePoliciesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSubscriptionFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSubscriptionFiltersError {
    /// Kind of error that occurred.
    pub kind: DescribeSubscriptionFiltersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSubscriptionFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSubscriptionFiltersErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSubscriptionFiltersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSubscriptionFiltersErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscriptionFiltersErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscriptionFiltersErrorKind::ServiceUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            DescribeSubscriptionFiltersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSubscriptionFiltersError {
    fn code(&self) -> Option<&str> {
        DescribeSubscriptionFiltersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSubscriptionFiltersError {
    /// Creates a new `DescribeSubscriptionFiltersError`.
    pub fn new(kind: DescribeSubscriptionFiltersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSubscriptionFiltersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSubscriptionFiltersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSubscriptionFiltersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSubscriptionFiltersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSubscriptionFiltersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscriptionFiltersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscriptionFiltersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscriptionFiltersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSubscriptionFiltersErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSubscriptionFiltersErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DescribeSubscriptionFiltersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSubscriptionFiltersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeSubscriptionFiltersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSubscriptionFiltersErrorKind::ServiceUnavailableException(_inner) => {
                Some(_inner)
            }
            DescribeSubscriptionFiltersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateKmsKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateKmsKeyError {
    /// Kind of error that occurred.
    pub kind: DisassociateKmsKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateKmsKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateKmsKeyErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateKmsKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateKmsKeyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateKmsKeyErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            DisassociateKmsKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateKmsKeyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DisassociateKmsKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateKmsKeyError {
    fn code(&self) -> Option<&str> {
        DisassociateKmsKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateKmsKeyError {
    /// Creates a new `DisassociateKmsKeyError`.
    pub fn new(kind: DisassociateKmsKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateKmsKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateKmsKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateKmsKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateKmsKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateKmsKeyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateKmsKeyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateKmsKeyErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateKmsKeyErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateKmsKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateKmsKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateKmsKeyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateKmsKeyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for DisassociateKmsKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateKmsKeyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateKmsKeyErrorKind::OperationAbortedException(_inner) => Some(_inner),
            DisassociateKmsKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateKmsKeyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DisassociateKmsKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FilterLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FilterLogEventsError {
    /// Kind of error that occurred.
    pub kind: FilterLogEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FilterLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FilterLogEventsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FilterLogEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FilterLogEventsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            FilterLogEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            FilterLogEventsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            FilterLogEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FilterLogEventsError {
    fn code(&self) -> Option<&str> {
        FilterLogEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FilterLogEventsError {
    /// Creates a new `FilterLogEventsError`.
    pub fn new(kind: FilterLogEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FilterLogEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FilterLogEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FilterLogEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FilterLogEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `FilterLogEventsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            FilterLogEventsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `FilterLogEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            FilterLogEventsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `FilterLogEventsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            FilterLogEventsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for FilterLogEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FilterLogEventsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            FilterLogEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            FilterLogEventsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            FilterLogEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLogEventsError {
    /// Kind of error that occurred.
    pub kind: GetLogEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLogEventsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLogEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLogEventsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetLogEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLogEventsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetLogEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLogEventsError {
    fn code(&self) -> Option<&str> {
        GetLogEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLogEventsError {
    /// Creates a new `GetLogEventsError`.
    pub fn new(kind: GetLogEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLogEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLogEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLogEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLogEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLogEventsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogEventsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogEventsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogEventsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogEventsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetLogEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLogEventsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetLogEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLogEventsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetLogEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLogGroupFields` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLogGroupFieldsError {
    /// Kind of error that occurred.
    pub kind: GetLogGroupFieldsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLogGroupFields` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLogGroupFieldsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLogGroupFieldsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLogGroupFieldsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetLogGroupFieldsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetLogGroupFieldsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLogGroupFieldsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetLogGroupFieldsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLogGroupFieldsError {
    fn code(&self) -> Option<&str> {
        GetLogGroupFieldsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLogGroupFieldsError {
    /// Creates a new `GetLogGroupFieldsError`.
    pub fn new(kind: GetLogGroupFieldsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLogGroupFieldsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLogGroupFieldsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLogGroupFieldsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLogGroupFieldsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLogGroupFieldsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogGroupFieldsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogGroupFieldsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogGroupFieldsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogGroupFieldsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogGroupFieldsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogGroupFieldsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogGroupFieldsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetLogGroupFieldsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLogGroupFieldsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetLogGroupFieldsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetLogGroupFieldsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLogGroupFieldsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetLogGroupFieldsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLogRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLogRecordError {
    /// Kind of error that occurred.
    pub kind: GetLogRecordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLogRecord` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLogRecordErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLogRecordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLogRecordErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetLogRecordErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetLogRecordErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetLogRecordErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetLogRecordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLogRecordError {
    fn code(&self) -> Option<&str> {
        GetLogRecordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLogRecordError {
    /// Creates a new `GetLogRecordError`.
    pub fn new(kind: GetLogRecordErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLogRecordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLogRecordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLogRecordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLogRecordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLogRecordErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogRecordErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogRecordErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetLogRecordErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetLogRecordErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogRecordErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLogRecordErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLogRecordErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetLogRecordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLogRecordErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetLogRecordErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetLogRecordErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetLogRecordErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetLogRecordErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueryResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueryResultsError {
    /// Kind of error that occurred.
    pub kind: GetQueryResultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueryResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueryResultsErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueryResultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueryResultsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GetQueryResultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueryResultsError {
    fn code(&self) -> Option<&str> {
        GetQueryResultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueryResultsError {
    /// Creates a new `GetQueryResultsError`.
    pub fn new(kind: GetQueryResultsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueryResultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueryResultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueryResultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueryResultsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueryResultsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueryResultsErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for GetQueryResultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueryResultsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GetQueryResultsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsLogGroupError {
    /// Kind of error that occurred.
    pub kind: ListTagsLogGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsLogGroupErrorKind {
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsLogGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsLogGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsLogGroupErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListTagsLogGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsLogGroupError {
    fn code(&self) -> Option<&str> {
        ListTagsLogGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsLogGroupError {
    /// Creates a new `ListTagsLogGroupError`.
    pub fn new(kind: ListTagsLogGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsLogGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsLogGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsLogGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsLogGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsLogGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsLogGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsLogGroupErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsLogGroupErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for ListTagsLogGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsLogGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsLogGroupErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListTagsLogGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDestinationError {
    /// Kind of error that occurred.
    pub kind: PutDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDestinationErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDestinationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutDestinationErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            PutDestinationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDestinationError {
    fn code(&self) -> Option<&str> {
        PutDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDestinationError {
    /// Creates a new `PutDestinationError`.
    pub fn new(kind: PutDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDestinationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDestinationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDestinationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDestinationErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDestinationErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDestinationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDestinationErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDestinationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutDestinationErrorKind::OperationAbortedException(_inner) => Some(_inner),
            PutDestinationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDestinationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDestinationPolicyError {
    /// Kind of error that occurred.
    pub kind: PutDestinationPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDestinationPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDestinationPolicyErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDestinationPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDestinationPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutDestinationPolicyErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            PutDestinationPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutDestinationPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDestinationPolicyError {
    fn code(&self) -> Option<&str> {
        PutDestinationPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDestinationPolicyError {
    /// Creates a new `PutDestinationPolicyError`.
    pub fn new(kind: PutDestinationPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDestinationPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDestinationPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDestinationPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDestinationPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDestinationPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDestinationPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDestinationPolicyErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDestinationPolicyErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutDestinationPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutDestinationPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutDestinationPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDestinationPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutDestinationPolicyErrorKind::OperationAbortedException(_inner) => Some(_inner),
            PutDestinationPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutDestinationPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutLogEventsError {
    /// Kind of error that occurred.
    pub kind: PutLogEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutLogEventsErrorKind {
    /// <p>The event was already logged.</p>
    DataAlreadyAcceptedException(crate::error::DataAlreadyAcceptedException),
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The sequence token is not valid. You can get the correct sequence token in
    /// the <code>expectedSequenceToken</code> field in the <code>InvalidSequenceTokenException</code>
    /// message. </p>
    InvalidSequenceTokenException(crate::error::InvalidSequenceTokenException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// <p>The most likely cause is an invalid Amazon Web Services access key ID or secret key.</p>
    UnrecognizedClientException(crate::error::UnrecognizedClientException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutLogEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutLogEventsErrorKind::DataAlreadyAcceptedException(_inner) => _inner.fmt(f),
            PutLogEventsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutLogEventsErrorKind::InvalidSequenceTokenException(_inner) => _inner.fmt(f),
            PutLogEventsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutLogEventsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutLogEventsErrorKind::UnrecognizedClientException(_inner) => _inner.fmt(f),
            PutLogEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutLogEventsError {
    fn code(&self) -> Option<&str> {
        PutLogEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutLogEventsError {
    /// Creates a new `PutLogEventsError`.
    pub fn new(kind: PutLogEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutLogEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutLogEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutLogEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutLogEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutLogEventsErrorKind::DataAlreadyAcceptedException`.
    pub fn is_data_already_accepted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLogEventsErrorKind::DataAlreadyAcceptedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLogEventsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLogEventsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLogEventsErrorKind::InvalidSequenceTokenException`.
    pub fn is_invalid_sequence_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLogEventsErrorKind::InvalidSequenceTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLogEventsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLogEventsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLogEventsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLogEventsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PutLogEventsErrorKind::UnrecognizedClientException`.
    pub fn is_unrecognized_client_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutLogEventsErrorKind::UnrecognizedClientException(_)
        )
    }
}
impl std::error::Error for PutLogEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutLogEventsErrorKind::DataAlreadyAcceptedException(_inner) => Some(_inner),
            PutLogEventsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutLogEventsErrorKind::InvalidSequenceTokenException(_inner) => Some(_inner),
            PutLogEventsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutLogEventsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutLogEventsErrorKind::UnrecognizedClientException(_inner) => Some(_inner),
            PutLogEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMetricFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMetricFilterError {
    /// Kind of error that occurred.
    pub kind: PutMetricFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMetricFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMetricFilterErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMetricFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMetricFilterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutMetricFilterErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutMetricFilterErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            PutMetricFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutMetricFilterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutMetricFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMetricFilterError {
    fn code(&self) -> Option<&str> {
        PutMetricFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMetricFilterError {
    /// Creates a new `PutMetricFilterError`.
    pub fn new(kind: PutMetricFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMetricFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMetricFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMetricFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMetricFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutMetricFilterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricFilterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricFilterErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricFilterErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricFilterErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricFilterErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricFilterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricFilterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutMetricFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMetricFilterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutMetricFilterErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutMetricFilterErrorKind::OperationAbortedException(_inner) => Some(_inner),
            PutMetricFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutMetricFilterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutMetricFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutQueryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutQueryDefinitionError {
    /// Kind of error that occurred.
    pub kind: PutQueryDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutQueryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutQueryDefinitionErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutQueryDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutQueryDefinitionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutQueryDefinitionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutQueryDefinitionErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutQueryDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutQueryDefinitionError {
    fn code(&self) -> Option<&str> {
        PutQueryDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutQueryDefinitionError {
    /// Creates a new `PutQueryDefinitionError`.
    pub fn new(kind: PutQueryDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutQueryDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutQueryDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutQueryDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutQueryDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutQueryDefinitionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutQueryDefinitionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutQueryDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutQueryDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutQueryDefinitionErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutQueryDefinitionErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutQueryDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutQueryDefinitionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutQueryDefinitionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutQueryDefinitionErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutQueryDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutResourcePolicyError {
    /// Kind of error that occurred.
    pub kind: PutResourcePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutResourcePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutResourcePolicyErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutResourcePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutResourcePolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutResourcePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutResourcePolicyError {
    fn code(&self) -> Option<&str> {
        PutResourcePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutResourcePolicyError {
    /// Creates a new `PutResourcePolicyError`.
    pub fn new(kind: PutResourcePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutResourcePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutResourcePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutResourcePolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutResourcePolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutResourcePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutResourcePolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutResourcePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRetentionPolicyError {
    /// Kind of error that occurred.
    pub kind: PutRetentionPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRetentionPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRetentionPolicyErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRetentionPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRetentionPolicyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutRetentionPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRetentionPolicyError {
    fn code(&self) -> Option<&str> {
        PutRetentionPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRetentionPolicyError {
    /// Creates a new `PutRetentionPolicyError`.
    pub fn new(kind: PutRetentionPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRetentionPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRetentionPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRetentionPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRetentionPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRetentionPolicyErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRetentionPolicyErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutRetentionPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRetentionPolicyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::OperationAbortedException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutRetentionPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutSubscriptionFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutSubscriptionFilterError {
    /// Kind of error that occurred.
    pub kind: PutSubscriptionFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutSubscriptionFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutSubscriptionFilterErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Multiple requests to update the same resource were in conflict.</p>
    OperationAbortedException(crate::error::OperationAbortedException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutSubscriptionFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutSubscriptionFilterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            PutSubscriptionFilterErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutSubscriptionFilterErrorKind::OperationAbortedException(_inner) => _inner.fmt(f),
            PutSubscriptionFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutSubscriptionFilterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PutSubscriptionFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutSubscriptionFilterError {
    fn code(&self) -> Option<&str> {
        PutSubscriptionFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutSubscriptionFilterError {
    /// Creates a new `PutSubscriptionFilterError`.
    pub fn new(kind: PutSubscriptionFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutSubscriptionFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutSubscriptionFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutSubscriptionFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutSubscriptionFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutSubscriptionFilterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSubscriptionFilterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSubscriptionFilterErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSubscriptionFilterErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSubscriptionFilterErrorKind::OperationAbortedException`.
    pub fn is_operation_aborted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSubscriptionFilterErrorKind::OperationAbortedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSubscriptionFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSubscriptionFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutSubscriptionFilterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutSubscriptionFilterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for PutSubscriptionFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutSubscriptionFilterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            PutSubscriptionFilterErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutSubscriptionFilterErrorKind::OperationAbortedException(_inner) => Some(_inner),
            PutSubscriptionFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutSubscriptionFilterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PutSubscriptionFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartQueryError {
    /// Kind of error that occurred.
    pub kind: StartQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartQueryErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>You have reached the maximum number of resources that can be created.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The query string is not valid. Details about this error are displayed in a
    /// <code>QueryCompileError</code> object. For more information, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_QueryCompileError.html">QueryCompileError</a>.</p>
    /// <p>For more information about valid query syntax, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
    MalformedQueryException(crate::error::MalformedQueryException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartQueryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::MalformedQueryException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartQueryError {
    fn code(&self) -> Option<&str> {
        StartQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartQueryError {
    /// Creates a new `StartQueryError`.
    pub fn new(kind: StartQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StartQueryErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::MalformedQueryException`.
    pub fn is_malformed_query_exception(&self) -> bool {
        matches!(&self.kind, StartQueryErrorKind::MalformedQueryException(_))
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartQueryErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartQueryErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for StartQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartQueryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartQueryErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartQueryErrorKind::MalformedQueryException(_inner) => Some(_inner),
            StartQueryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartQueryErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopQueryError {
    /// Kind of error that occurred.
    pub kind: StopQueryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopQuery` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopQueryErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopQueryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopQueryErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StopQueryErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopQueryErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StopQueryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopQueryError {
    fn code(&self) -> Option<&str> {
        StopQueryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopQueryError {
    /// Creates a new `StopQueryError`.
    pub fn new(kind: StopQueryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopQueryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopQueryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopQueryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopQueryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopQueryErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, StopQueryErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `StopQueryErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopQueryErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopQueryErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopQueryErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for StopQueryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopQueryErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StopQueryErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopQueryErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StopQueryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagLogGroupError {
    /// Kind of error that occurred.
    pub kind: TagLogGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagLogGroupErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagLogGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagLogGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagLogGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagLogGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagLogGroupError {
    fn code(&self) -> Option<&str> {
        TagLogGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagLogGroupError {
    /// Creates a new `TagLogGroupError`.
    pub fn new(kind: TagLogGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagLogGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagLogGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagLogGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagLogGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagLogGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagLogGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagLogGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagLogGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagLogGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagLogGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagLogGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagLogGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestMetricFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestMetricFilterError {
    /// Kind of error that occurred.
    pub kind: TestMetricFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestMetricFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestMetricFilterErrorKind {
    /// <p>A parameter is specified incorrectly.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The service cannot complete the request.</p>
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestMetricFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestMetricFilterErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TestMetricFilterErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            TestMetricFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestMetricFilterError {
    fn code(&self) -> Option<&str> {
        TestMetricFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestMetricFilterError {
    /// Creates a new `TestMetricFilterError`.
    pub fn new(kind: TestMetricFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestMetricFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestMetricFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestMetricFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestMetricFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestMetricFilterErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestMetricFilterErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TestMetricFilterErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestMetricFilterErrorKind::ServiceUnavailableException(_)
        )
    }
}
impl std::error::Error for TestMetricFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestMetricFilterErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TestMetricFilterErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            TestMetricFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagLogGroupError {
    /// Kind of error that occurred.
    pub kind: UntagLogGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagLogGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagLogGroupErrorKind {
    /// <p>The specified resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagLogGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagLogGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagLogGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagLogGroupError {
    fn code(&self) -> Option<&str> {
        UntagLogGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagLogGroupError {
    /// Creates a new `UntagLogGroupError`.
    pub fn new(kind: UntagLogGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagLogGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagLogGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagLogGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagLogGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagLogGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagLogGroupErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagLogGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagLogGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagLogGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The specified resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The service cannot complete the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// <p>A parameter is specified incorrectly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>The query string is not valid. Details about this error are displayed in a
/// <code>QueryCompileError</code> object. For more information, see
/// <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_QueryCompileError.html">QueryCompileError</a>.</p>
/// <p>For more information about valid query syntax, see
/// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights Query Syntax</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MalformedQueryException {
    /// <p>Reserved.</p>
    pub query_compile_error: std::option::Option<crate::model::QueryCompileError>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl MalformedQueryException {
    /// <p>Reserved.</p>
    pub fn query_compile_error(&self) -> std::option::Option<&crate::model::QueryCompileError> {
        self.query_compile_error.as_ref()
    }
}
impl std::fmt::Debug for MalformedQueryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MalformedQueryException");
        formatter.field("query_compile_error", &self.query_compile_error);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MalformedQueryException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MalformedQueryException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MalformedQueryException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for MalformedQueryException {}
/// See [`MalformedQueryException`](crate::error::MalformedQueryException)
pub mod malformed_query_exception {
    /// A builder for [`MalformedQueryException`](crate::error::MalformedQueryException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) query_compile_error: std::option::Option<crate::model::QueryCompileError>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Reserved.</p>
        pub fn query_compile_error(mut self, input: crate::model::QueryCompileError) -> Self {
            self.query_compile_error = Some(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_query_compile_error(
            mut self,
            input: std::option::Option<crate::model::QueryCompileError>,
        ) -> Self {
            self.query_compile_error = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MalformedQueryException`](crate::error::MalformedQueryException)
        pub fn build(self) -> crate::error::MalformedQueryException {
            crate::error::MalformedQueryException {
                query_compile_error: self.query_compile_error,
                message: self.message,
            }
        }
    }
}
impl MalformedQueryException {
    /// Creates a new builder-style object to manufacture [`MalformedQueryException`](crate::error::MalformedQueryException)
    pub fn builder() -> crate::error::malformed_query_exception::Builder {
        crate::error::malformed_query_exception::Builder::default()
    }
}

/// <p>You have reached the maximum number of resources that can be created.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Multiple requests to update the same resource were in conflict.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationAbortedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationAbortedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationAbortedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationAbortedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationAbortedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationAbortedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationAbortedException {}
/// See [`OperationAbortedException`](crate::error::OperationAbortedException)
pub mod operation_aborted_exception {
    /// A builder for [`OperationAbortedException`](crate::error::OperationAbortedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationAbortedException`](crate::error::OperationAbortedException)
        pub fn build(self) -> crate::error::OperationAbortedException {
            crate::error::OperationAbortedException {
                message: self.message,
            }
        }
    }
}
impl OperationAbortedException {
    /// Creates a new builder-style object to manufacture [`OperationAbortedException`](crate::error::OperationAbortedException)
    pub fn builder() -> crate::error::operation_aborted_exception::Builder {
        crate::error::operation_aborted_exception::Builder::default()
    }
}

/// <p>The most likely cause is an invalid Amazon Web Services access key ID or secret key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnrecognizedClientException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnrecognizedClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnrecognizedClientException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnrecognizedClientException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnrecognizedClientException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnrecognizedClientException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnrecognizedClientException {}
/// See [`UnrecognizedClientException`](crate::error::UnrecognizedClientException)
pub mod unrecognized_client_exception {
    /// A builder for [`UnrecognizedClientException`](crate::error::UnrecognizedClientException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnrecognizedClientException`](crate::error::UnrecognizedClientException)
        pub fn build(self) -> crate::error::UnrecognizedClientException {
            crate::error::UnrecognizedClientException {
                message: self.message,
            }
        }
    }
}
impl UnrecognizedClientException {
    /// Creates a new builder-style object to manufacture [`UnrecognizedClientException`](crate::error::UnrecognizedClientException)
    pub fn builder() -> crate::error::unrecognized_client_exception::Builder {
        crate::error::unrecognized_client_exception::Builder::default()
    }
}

/// <p>The sequence token is not valid. You can get the correct sequence token in
/// the <code>expectedSequenceToken</code> field in the <code>InvalidSequenceTokenException</code>
/// message. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSequenceTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub expected_sequence_token: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidSequenceTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn expected_sequence_token(&self) -> std::option::Option<&str> {
        self.expected_sequence_token.as_deref()
    }
}
impl std::fmt::Debug for InvalidSequenceTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSequenceTokenException");
        formatter.field("expected_sequence_token", &self.expected_sequence_token);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSequenceTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSequenceTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSequenceTokenException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSequenceTokenException {}
/// See [`InvalidSequenceTokenException`](crate::error::InvalidSequenceTokenException)
pub mod invalid_sequence_token_exception {
    /// A builder for [`InvalidSequenceTokenException`](crate::error::InvalidSequenceTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expected_sequence_token: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn expected_sequence_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_sequence_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_expected_sequence_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_sequence_token = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSequenceTokenException`](crate::error::InvalidSequenceTokenException)
        pub fn build(self) -> crate::error::InvalidSequenceTokenException {
            crate::error::InvalidSequenceTokenException {
                expected_sequence_token: self.expected_sequence_token,
                message: self.message,
            }
        }
    }
}
impl InvalidSequenceTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidSequenceTokenException`](crate::error::InvalidSequenceTokenException)
    pub fn builder() -> crate::error::invalid_sequence_token_exception::Builder {
        crate::error::invalid_sequence_token_exception::Builder::default()
    }
}

/// <p>The event was already logged.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataAlreadyAcceptedException {
    #[allow(missing_docs)] // documentation missing in model
    pub expected_sequence_token: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl DataAlreadyAcceptedException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn expected_sequence_token(&self) -> std::option::Option<&str> {
        self.expected_sequence_token.as_deref()
    }
}
impl std::fmt::Debug for DataAlreadyAcceptedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataAlreadyAcceptedException");
        formatter.field("expected_sequence_token", &self.expected_sequence_token);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DataAlreadyAcceptedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DataAlreadyAcceptedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DataAlreadyAcceptedException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for DataAlreadyAcceptedException {}
/// See [`DataAlreadyAcceptedException`](crate::error::DataAlreadyAcceptedException)
pub mod data_already_accepted_exception {
    /// A builder for [`DataAlreadyAcceptedException`](crate::error::DataAlreadyAcceptedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) expected_sequence_token: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn expected_sequence_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_sequence_token = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_expected_sequence_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_sequence_token = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataAlreadyAcceptedException`](crate::error::DataAlreadyAcceptedException)
        pub fn build(self) -> crate::error::DataAlreadyAcceptedException {
            crate::error::DataAlreadyAcceptedException {
                expected_sequence_token: self.expected_sequence_token,
                message: self.message,
            }
        }
    }
}
impl DataAlreadyAcceptedException {
    /// Creates a new builder-style object to manufacture [`DataAlreadyAcceptedException`](crate::error::DataAlreadyAcceptedException)
    pub fn builder() -> crate::error::data_already_accepted_exception::Builder {
        crate::error::data_already_accepted_exception::Builder::default()
    }
}

/// <p>The specified resource already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>The operation is not valid on the specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOperationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOperationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOperationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOperationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOperationException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOperationException {}
/// See [`InvalidOperationException`](crate::error::InvalidOperationException)
pub mod invalid_operation_exception {
    /// A builder for [`InvalidOperationException`](crate::error::InvalidOperationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOperationException`](crate::error::InvalidOperationException)
        pub fn build(self) -> crate::error::InvalidOperationException {
            crate::error::InvalidOperationException {
                message: self.message,
            }
        }
    }
}
impl InvalidOperationException {
    /// Creates a new builder-style object to manufacture [`InvalidOperationException`](crate::error::InvalidOperationException)
    pub fn builder() -> crate::error::invalid_operation_exception::Builder {
        crate::error::invalid_operation_exception::Builder::default()
    }
}
