// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ActivateEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ActivateEventSourceError {
    /// Kind of error that occurred.
    pub kind: ActivateEventSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ActivateEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ActivateEventSourceErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The specified state is not a valid state for an event source.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ActivateEventSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ActivateEventSourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            ActivateEventSourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            ActivateEventSourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            ActivateEventSourceErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            ActivateEventSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ActivateEventSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ActivateEventSourceError {
    fn code(&self) -> Option<&str> {
        ActivateEventSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ActivateEventSourceError {
    /// Creates a new `ActivateEventSourceError`.
    pub fn new(kind: ActivateEventSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ActivateEventSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ActivateEventSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ActivateEventSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ActivateEventSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ActivateEventSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateEventSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateEventSourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateEventSourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateEventSourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateEventSourceErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateEventSourceErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateEventSourceErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateEventSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateEventSourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ActivateEventSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ActivateEventSourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            ActivateEventSourceErrorKind::InternalException(_inner) => Some(_inner),
            ActivateEventSourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            ActivateEventSourceErrorKind::OperationDisabledException(_inner) => Some(_inner),
            ActivateEventSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ActivateEventSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelReplay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelReplayError {
    /// Kind of error that occurred.
    pub kind: CancelReplayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelReplay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelReplayErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>An error occurred because a replay can be canceled only when the state is Running or Starting.</p>
    IllegalStatusException(crate::error::IllegalStatusException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelReplayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelReplayErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CancelReplayErrorKind::IllegalStatusException(_inner) => _inner.fmt(f),
            CancelReplayErrorKind::InternalException(_inner) => _inner.fmt(f),
            CancelReplayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CancelReplayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelReplayError {
    fn code(&self) -> Option<&str> {
        CancelReplayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelReplayError {
    /// Creates a new `CancelReplayError`.
    pub fn new(kind: CancelReplayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelReplayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelReplayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelReplayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelReplayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelReplayErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelReplayErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelReplayErrorKind::IllegalStatusException`.
    pub fn is_illegal_status_exception(&self) -> bool {
        matches!(&self.kind, CancelReplayErrorKind::IllegalStatusException(_))
    }
    /// Returns `true` if the error kind is `CancelReplayErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CancelReplayErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CancelReplayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelReplayErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CancelReplayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelReplayErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CancelReplayErrorKind::IllegalStatusException(_inner) => Some(_inner),
            CancelReplayErrorKind::InternalException(_inner) => Some(_inner),
            CancelReplayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CancelReplayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateApiDestinationError {
    /// Kind of error that occurred.
    pub kind: CreateApiDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateApiDestinationErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateApiDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateApiDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateApiDestinationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateApiDestinationErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateApiDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateApiDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateApiDestinationError {
    fn code(&self) -> Option<&str> {
        CreateApiDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateApiDestinationError {
    /// Creates a new `CreateApiDestinationError`.
    pub fn new(kind: CreateApiDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateApiDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateApiDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateApiDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateApiDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateApiDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApiDestinationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiDestinationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApiDestinationErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiDestinationErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateApiDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateApiDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateApiDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateApiDestinationErrorKind::InternalException(_inner) => Some(_inner),
            CreateApiDestinationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateApiDestinationErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateApiDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateApiDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateArchiveError {
    /// Kind of error that occurred.
    pub kind: CreateArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateArchiveErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The event pattern is not valid.</p>
    InvalidEventPatternException(crate::error::InvalidEventPatternException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateArchiveErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateArchiveErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateArchiveErrorKind::InvalidEventPatternException(_inner) => _inner.fmt(f),
            CreateArchiveErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateArchiveErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateArchiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateArchiveError {
    fn code(&self) -> Option<&str> {
        CreateArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateArchiveError {
    /// Creates a new `CreateArchiveError`.
    pub fn new(kind: CreateArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateArchiveErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateArchiveErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateArchiveErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateArchiveErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateArchiveErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateArchiveErrorKind::InvalidEventPatternException`.
    pub fn is_invalid_event_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateArchiveErrorKind::InvalidEventPatternException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateArchiveErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateArchiveErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateArchiveErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateArchiveErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateArchiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateArchiveErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateArchiveErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateArchiveErrorKind::InternalException(_inner) => Some(_inner),
            CreateArchiveErrorKind::InvalidEventPatternException(_inner) => Some(_inner),
            CreateArchiveErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateArchiveErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateArchiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateConnectionError {
    /// Kind of error that occurred.
    pub kind: CreateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateConnectionErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateConnectionErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateConnectionError {
    fn code(&self) -> Option<&str> {
        CreateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateConnectionError {
    /// Creates a new `CreateConnectionError`.
    pub fn new(kind: CreateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateConnectionErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateConnectionErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateConnectionErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateConnectionErrorKind::InternalException(_inner) => Some(_inner),
            CreateConnectionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateConnectionErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventBus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventBusError {
    /// Kind of error that occurred.
    pub kind: CreateEventBusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventBus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventBusErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The specified state is not a valid state for an event source.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>The resource you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventBusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventBusErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            CreateEventBusErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreateEventBusErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            CreateEventBusErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateEventBusErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            CreateEventBusErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateEventBusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateEventBusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventBusError {
    fn code(&self) -> Option<&str> {
        CreateEventBusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventBusError {
    /// Creates a new `CreateEventBusError`.
    pub fn new(kind: CreateEventBusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventBusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventBusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventBusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventBusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventBusErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventBusErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventBusErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateEventBusErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `CreateEventBusErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventBusErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventBusErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventBusErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventBusErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventBusErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventBusErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventBusErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventBusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventBusErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateEventBusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventBusErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            CreateEventBusErrorKind::InternalException(_inner) => Some(_inner),
            CreateEventBusErrorKind::InvalidStateException(_inner) => Some(_inner),
            CreateEventBusErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateEventBusErrorKind::OperationDisabledException(_inner) => Some(_inner),
            CreateEventBusErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateEventBusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateEventBusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePartnerEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePartnerEventSourceError {
    /// Kind of error that occurred.
    pub kind: CreatePartnerEventSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePartnerEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePartnerEventSourceErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>The resource you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePartnerEventSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePartnerEventSourceErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            CreatePartnerEventSourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            CreatePartnerEventSourceErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreatePartnerEventSourceErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            CreatePartnerEventSourceErrorKind::ResourceAlreadyExistsException(_inner) => {
                _inner.fmt(f)
            }
            CreatePartnerEventSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePartnerEventSourceError {
    fn code(&self) -> Option<&str> {
        CreatePartnerEventSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePartnerEventSourceError {
    /// Creates a new `CreatePartnerEventSourceError`.
    pub fn new(kind: CreatePartnerEventSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePartnerEventSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePartnerEventSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePartnerEventSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePartnerEventSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePartnerEventSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerEventSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerEventSourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerEventSourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerEventSourceErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerEventSourceErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerEventSourceErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerEventSourceErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePartnerEventSourceErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePartnerEventSourceErrorKind::ResourceAlreadyExistsException(_)
        )
    }
}
impl std::error::Error for CreatePartnerEventSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePartnerEventSourceErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            CreatePartnerEventSourceErrorKind::InternalException(_inner) => Some(_inner),
            CreatePartnerEventSourceErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreatePartnerEventSourceErrorKind::OperationDisabledException(_inner) => Some(_inner),
            CreatePartnerEventSourceErrorKind::ResourceAlreadyExistsException(_inner) => {
                Some(_inner)
            }
            CreatePartnerEventSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeactivateEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeactivateEventSourceError {
    /// Kind of error that occurred.
    pub kind: DeactivateEventSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeactivateEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeactivateEventSourceErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The specified state is not a valid state for an event source.</p>
    InvalidStateException(crate::error::InvalidStateException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeactivateEventSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeactivateEventSourceErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeactivateEventSourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeactivateEventSourceErrorKind::InvalidStateException(_inner) => _inner.fmt(f),
            DeactivateEventSourceErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            DeactivateEventSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeactivateEventSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeactivateEventSourceError {
    fn code(&self) -> Option<&str> {
        DeactivateEventSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeactivateEventSourceError {
    /// Creates a new `DeactivateEventSourceError`.
    pub fn new(kind: DeactivateEventSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeactivateEventSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeactivateEventSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeactivateEventSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeactivateEventSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeactivateEventSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateEventSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateEventSourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateEventSourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateEventSourceErrorKind::InvalidStateException`.
    pub fn is_invalid_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateEventSourceErrorKind::InvalidStateException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateEventSourceErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateEventSourceErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateEventSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateEventSourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeactivateEventSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeactivateEventSourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeactivateEventSourceErrorKind::InternalException(_inner) => Some(_inner),
            DeactivateEventSourceErrorKind::InvalidStateException(_inner) => Some(_inner),
            DeactivateEventSourceErrorKind::OperationDisabledException(_inner) => Some(_inner),
            DeactivateEventSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeactivateEventSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeauthorizeConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeauthorizeConnectionError {
    /// Kind of error that occurred.
    pub kind: DeauthorizeConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeauthorizeConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeauthorizeConnectionErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeauthorizeConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeauthorizeConnectionErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeauthorizeConnectionErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeauthorizeConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeauthorizeConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeauthorizeConnectionError {
    fn code(&self) -> Option<&str> {
        DeauthorizeConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeauthorizeConnectionError {
    /// Creates a new `DeauthorizeConnectionError`.
    pub fn new(kind: DeauthorizeConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeauthorizeConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeauthorizeConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeauthorizeConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeauthorizeConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeauthorizeConnectionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeauthorizeConnectionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeauthorizeConnectionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeauthorizeConnectionErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeauthorizeConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeauthorizeConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeauthorizeConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeauthorizeConnectionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeauthorizeConnectionErrorKind::InternalException(_inner) => Some(_inner),
            DeauthorizeConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeauthorizeConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteApiDestinationError {
    /// Kind of error that occurred.
    pub kind: DeleteApiDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteApiDestinationErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteApiDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteApiDestinationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteApiDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteApiDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteApiDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteApiDestinationError {
    fn code(&self) -> Option<&str> {
        DeleteApiDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteApiDestinationError {
    /// Creates a new `DeleteApiDestinationError`.
    pub fn new(kind: DeleteApiDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteApiDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteApiDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteApiDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteApiDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteApiDestinationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiDestinationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApiDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteApiDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteApiDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteApiDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteApiDestinationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteApiDestinationErrorKind::InternalException(_inner) => Some(_inner),
            DeleteApiDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteApiDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteArchiveError {
    /// Kind of error that occurred.
    pub kind: DeleteArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteArchiveErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteArchiveErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteArchiveErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteArchiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteArchiveError {
    fn code(&self) -> Option<&str> {
        DeleteArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteArchiveError {
    /// Creates a new `DeleteArchiveError`.
    pub fn new(kind: DeleteArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteArchiveErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteArchiveErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteArchiveErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteArchiveErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteArchiveErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteArchiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteArchiveErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteArchiveErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteArchiveErrorKind::InternalException(_inner) => Some(_inner),
            DeleteArchiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectionErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectionError {
    /// Creates a new `DeleteConnectionError`.
    pub fn new(kind: DeleteConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteConnectionErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::InternalException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventBus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventBusError {
    /// Kind of error that occurred.
    pub kind: DeleteEventBusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventBus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventBusErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventBusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventBusErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteEventBusErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteEventBusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventBusError {
    fn code(&self) -> Option<&str> {
        DeleteEventBusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventBusError {
    /// Creates a new `DeleteEventBusError`.
    pub fn new(kind: DeleteEventBusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventBusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventBusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventBusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventBusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventBusErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventBusErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventBusErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteEventBusErrorKind::InternalException(_))
    }
}
impl std::error::Error for DeleteEventBusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventBusErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteEventBusErrorKind::InternalException(_inner) => Some(_inner),
            DeleteEventBusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePartnerEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePartnerEventSourceError {
    /// Kind of error that occurred.
    pub kind: DeletePartnerEventSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePartnerEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePartnerEventSourceErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePartnerEventSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePartnerEventSourceErrorKind::ConcurrentModificationException(_inner) => {
                _inner.fmt(f)
            }
            DeletePartnerEventSourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeletePartnerEventSourceErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            DeletePartnerEventSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePartnerEventSourceError {
    fn code(&self) -> Option<&str> {
        DeletePartnerEventSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePartnerEventSourceError {
    /// Creates a new `DeletePartnerEventSourceError`.
    pub fn new(kind: DeletePartnerEventSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePartnerEventSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePartnerEventSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePartnerEventSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePartnerEventSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePartnerEventSourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartnerEventSourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartnerEventSourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartnerEventSourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePartnerEventSourceErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartnerEventSourceErrorKind::OperationDisabledException(_)
        )
    }
}
impl std::error::Error for DeletePartnerEventSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePartnerEventSourceErrorKind::ConcurrentModificationException(_inner) => {
                Some(_inner)
            }
            DeletePartnerEventSourceErrorKind::InternalException(_inner) => Some(_inner),
            DeletePartnerEventSourceErrorKind::OperationDisabledException(_inner) => Some(_inner),
            DeletePartnerEventSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRuleError {
    /// Kind of error that occurred.
    pub kind: DeleteRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRuleErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRuleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRuleError {
    fn code(&self) -> Option<&str> {
        DeleteRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRuleError {
    /// Creates a new `DeleteRuleError`.
    pub fn new(kind: DeleteRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, DeleteRuleErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `DeleteRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRuleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRuleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DeleteRuleErrorKind::InternalException(_inner) => Some(_inner),
            DeleteRuleErrorKind::ManagedRuleException(_inner) => Some(_inner),
            DeleteRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApiDestinationError {
    /// Kind of error that occurred.
    pub kind: DescribeApiDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApiDestinationErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApiDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApiDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeApiDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeApiDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApiDestinationError {
    fn code(&self) -> Option<&str> {
        DescribeApiDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApiDestinationError {
    /// Creates a new `DescribeApiDestinationError`.
    pub fn new(kind: DescribeApiDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApiDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApiDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApiDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApiDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApiDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApiDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApiDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApiDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeApiDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApiDestinationErrorKind::InternalException(_inner) => Some(_inner),
            DescribeApiDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeApiDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeArchiveError {
    /// Kind of error that occurred.
    pub kind: DescribeArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeArchiveErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The resource you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeArchiveErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeArchiveErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            DescribeArchiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeArchiveError {
    fn code(&self) -> Option<&str> {
        DescribeArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeArchiveError {
    /// Creates a new `DescribeArchiveError`.
    pub fn new(kind: DescribeArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeArchiveErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeArchiveErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeArchiveErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeArchiveErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeArchiveErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeArchiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeArchiveErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeArchiveErrorKind::InternalException(_inner) => Some(_inner),
            DescribeArchiveErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            DescribeArchiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectionError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectionErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectionErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectionError {
    fn code(&self) -> Option<&str> {
        DescribeConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectionError {
    /// Creates a new `DescribeConnectionError`.
    pub fn new(kind: DescribeConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectionErrorKind::InternalException(_inner) => Some(_inner),
            DescribeConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventBus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventBusError {
    /// Kind of error that occurred.
    pub kind: DescribeEventBusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventBus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventBusErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventBusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventBusErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeEventBusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeEventBusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventBusError {
    fn code(&self) -> Option<&str> {
        DescribeEventBusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventBusError {
    /// Creates a new `DescribeEventBusError`.
    pub fn new(kind: DescribeEventBusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventBusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventBusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventBusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventBusErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventBusErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeEventBusErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeEventBusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventBusErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeEventBusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventBusErrorKind::InternalException(_inner) => Some(_inner),
            DescribeEventBusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeEventBusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventSourceError {
    /// Kind of error that occurred.
    pub kind: DescribeEventSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventSourceErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventSourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeEventSourceErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            DescribeEventSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeEventSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventSourceError {
    fn code(&self) -> Option<&str> {
        DescribeEventSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventSourceError {
    /// Creates a new `DescribeEventSourceError`.
    pub fn new(kind: DescribeEventSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventSourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventSourceErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSourceErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeEventSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventSourceErrorKind::InternalException(_inner) => Some(_inner),
            DescribeEventSourceErrorKind::OperationDisabledException(_inner) => Some(_inner),
            DescribeEventSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeEventSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePartnerEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePartnerEventSourceError {
    /// Kind of error that occurred.
    pub kind: DescribePartnerEventSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePartnerEventSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePartnerEventSourceErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePartnerEventSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePartnerEventSourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribePartnerEventSourceErrorKind::OperationDisabledException(_inner) => {
                _inner.fmt(f)
            }
            DescribePartnerEventSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribePartnerEventSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePartnerEventSourceError {
    fn code(&self) -> Option<&str> {
        DescribePartnerEventSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePartnerEventSourceError {
    /// Creates a new `DescribePartnerEventSourceError`.
    pub fn new(kind: DescribePartnerEventSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePartnerEventSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePartnerEventSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePartnerEventSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePartnerEventSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePartnerEventSourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePartnerEventSourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePartnerEventSourceErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePartnerEventSourceErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePartnerEventSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribePartnerEventSourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribePartnerEventSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePartnerEventSourceErrorKind::InternalException(_inner) => Some(_inner),
            DescribePartnerEventSourceErrorKind::OperationDisabledException(_inner) => Some(_inner),
            DescribePartnerEventSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribePartnerEventSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReplay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplayError {
    /// Kind of error that occurred.
    pub kind: DescribeReplayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplayErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplayErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeReplayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeReplayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplayError {
    fn code(&self) -> Option<&str> {
        DescribeReplayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplayError {
    /// Creates a new `DescribeReplayError`.
    pub fn new(kind: DescribeReplayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplayErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeReplayErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeReplayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplayErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeReplayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplayErrorKind::InternalException(_inner) => Some(_inner),
            DescribeReplayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeReplayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRuleError {
    /// Kind of error that occurred.
    pub kind: DescribeRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRuleErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            DescribeRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRuleError {
    fn code(&self) -> Option<&str> {
        DescribeRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRuleError {
    /// Creates a new `DescribeRuleError`.
    pub fn new(kind: DescribeRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DescribeRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DescribeRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRuleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRuleErrorKind::InternalException(_inner) => Some(_inner),
            DescribeRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableRuleError {
    /// Kind of error that occurred.
    pub kind: DisableRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableRuleErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableRuleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            DisableRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            DisableRuleErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            DisableRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableRuleError {
    fn code(&self) -> Option<&str> {
        DisableRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableRuleError {
    /// Creates a new `DisableRuleError`.
    pub fn new(kind: DisableRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableRuleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableRuleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, DisableRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `DisableRuleErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, DisableRuleErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `DisableRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableRuleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DisableRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableRuleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            DisableRuleErrorKind::InternalException(_inner) => Some(_inner),
            DisableRuleErrorKind::ManagedRuleException(_inner) => Some(_inner),
            DisableRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableRuleError {
    /// Kind of error that occurred.
    pub kind: EnableRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableRuleErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableRuleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            EnableRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            EnableRuleErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            EnableRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableRuleError {
    fn code(&self) -> Option<&str> {
        EnableRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableRuleError {
    /// Creates a new `EnableRuleError`.
    pub fn new(kind: EnableRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableRuleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableRuleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, EnableRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `EnableRuleErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, EnableRuleErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `EnableRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableRuleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for EnableRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableRuleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            EnableRuleErrorKind::InternalException(_inner) => Some(_inner),
            EnableRuleErrorKind::ManagedRuleException(_inner) => Some(_inner),
            EnableRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApiDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApiDestinationsError {
    /// Kind of error that occurred.
    pub kind: ListApiDestinationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApiDestinations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApiDestinationsErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApiDestinationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApiDestinationsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListApiDestinationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApiDestinationsError {
    fn code(&self) -> Option<&str> {
        ListApiDestinationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApiDestinationsError {
    /// Creates a new `ListApiDestinationsError`.
    pub fn new(kind: ListApiDestinationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApiDestinationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApiDestinationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApiDestinationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApiDestinationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApiDestinationsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApiDestinationsErrorKind::InternalException(_)
        )
    }
}
impl std::error::Error for ListApiDestinationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApiDestinationsErrorKind::InternalException(_inner) => Some(_inner),
            ListApiDestinationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListArchives` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListArchivesError {
    /// Kind of error that occurred.
    pub kind: ListArchivesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListArchives` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListArchivesErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListArchivesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListArchivesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListArchivesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListArchivesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListArchivesError {
    fn code(&self) -> Option<&str> {
        ListArchivesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListArchivesError {
    /// Creates a new `ListArchivesError`.
    pub fn new(kind: ListArchivesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListArchivesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListArchivesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListArchivesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListArchivesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListArchivesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListArchivesErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListArchivesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListArchivesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListArchivesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListArchivesErrorKind::InternalException(_inner) => Some(_inner),
            ListArchivesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListArchivesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListConnectionsError {
    /// Kind of error that occurred.
    pub kind: ListConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListConnectionsErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListConnectionsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListConnectionsError {
    fn code(&self) -> Option<&str> {
        ListConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListConnectionsError {
    /// Creates a new `ListConnectionsError`.
    pub fn new(kind: ListConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListConnectionsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListConnectionsErrorKind::InternalException(_))
    }
}
impl std::error::Error for ListConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListConnectionsErrorKind::InternalException(_inner) => Some(_inner),
            ListConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventBuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventBusesError {
    /// Kind of error that occurred.
    pub kind: ListEventBusesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventBuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventBusesErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventBusesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventBusesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListEventBusesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventBusesError {
    fn code(&self) -> Option<&str> {
        ListEventBusesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventBusesError {
    /// Creates a new `ListEventBusesError`.
    pub fn new(kind: ListEventBusesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventBusesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventBusesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventBusesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventBusesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventBusesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListEventBusesErrorKind::InternalException(_))
    }
}
impl std::error::Error for ListEventBusesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventBusesErrorKind::InternalException(_inner) => Some(_inner),
            ListEventBusesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEventSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEventSourcesError {
    /// Kind of error that occurred.
    pub kind: ListEventSourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEventSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEventSourcesErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEventSourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEventSourcesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListEventSourcesErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            ListEventSourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEventSourcesError {
    fn code(&self) -> Option<&str> {
        ListEventSourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEventSourcesError {
    /// Creates a new `ListEventSourcesError`.
    pub fn new(kind: ListEventSourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEventSourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEventSourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEventSourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEventSourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEventSourcesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListEventSourcesErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListEventSourcesErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEventSourcesErrorKind::OperationDisabledException(_)
        )
    }
}
impl std::error::Error for ListEventSourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEventSourcesErrorKind::InternalException(_inner) => Some(_inner),
            ListEventSourcesErrorKind::OperationDisabledException(_inner) => Some(_inner),
            ListEventSourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPartnerEventSourceAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPartnerEventSourceAccountsError {
    /// Kind of error that occurred.
    pub kind: ListPartnerEventSourceAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPartnerEventSourceAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPartnerEventSourceAccountsErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPartnerEventSourceAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPartnerEventSourceAccountsErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListPartnerEventSourceAccountsErrorKind::OperationDisabledException(_inner) => {
                _inner.fmt(f)
            }
            ListPartnerEventSourceAccountsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListPartnerEventSourceAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPartnerEventSourceAccountsError {
    fn code(&self) -> Option<&str> {
        ListPartnerEventSourceAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPartnerEventSourceAccountsError {
    /// Creates a new `ListPartnerEventSourceAccountsError`.
    pub fn new(
        kind: ListPartnerEventSourceAccountsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPartnerEventSourceAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPartnerEventSourceAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPartnerEventSourceAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPartnerEventSourceAccountsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPartnerEventSourceAccountsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerEventSourceAccountsErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartnerEventSourceAccountsErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerEventSourceAccountsErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartnerEventSourceAccountsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerEventSourceAccountsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListPartnerEventSourceAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPartnerEventSourceAccountsErrorKind::InternalException(_inner) => Some(_inner),
            ListPartnerEventSourceAccountsErrorKind::OperationDisabledException(_inner) => {
                Some(_inner)
            }
            ListPartnerEventSourceAccountsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListPartnerEventSourceAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPartnerEventSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPartnerEventSourcesError {
    /// Kind of error that occurred.
    pub kind: ListPartnerEventSourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPartnerEventSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPartnerEventSourcesErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPartnerEventSourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPartnerEventSourcesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListPartnerEventSourcesErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            ListPartnerEventSourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPartnerEventSourcesError {
    fn code(&self) -> Option<&str> {
        ListPartnerEventSourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPartnerEventSourcesError {
    /// Creates a new `ListPartnerEventSourcesError`.
    pub fn new(kind: ListPartnerEventSourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPartnerEventSourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPartnerEventSourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPartnerEventSourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPartnerEventSourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPartnerEventSourcesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerEventSourcesErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPartnerEventSourcesErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPartnerEventSourcesErrorKind::OperationDisabledException(_)
        )
    }
}
impl std::error::Error for ListPartnerEventSourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPartnerEventSourcesErrorKind::InternalException(_inner) => Some(_inner),
            ListPartnerEventSourcesErrorKind::OperationDisabledException(_inner) => Some(_inner),
            ListPartnerEventSourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReplays` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReplaysError {
    /// Kind of error that occurred.
    pub kind: ListReplaysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReplays` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReplaysErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReplaysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReplaysErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListReplaysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReplaysError {
    fn code(&self) -> Option<&str> {
        ListReplaysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReplaysError {
    /// Creates a new `ListReplaysError`.
    pub fn new(kind: ListReplaysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReplaysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReplaysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReplaysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReplaysErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReplaysErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListReplaysErrorKind::InternalException(_))
    }
}
impl std::error::Error for ListReplaysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReplaysErrorKind::InternalException(_inner) => Some(_inner),
            ListReplaysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRuleNamesByTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRuleNamesByTargetError {
    /// Kind of error that occurred.
    pub kind: ListRuleNamesByTargetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRuleNamesByTarget` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRuleNamesByTargetErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRuleNamesByTargetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRuleNamesByTargetErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListRuleNamesByTargetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRuleNamesByTargetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRuleNamesByTargetError {
    fn code(&self) -> Option<&str> {
        ListRuleNamesByTargetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRuleNamesByTargetError {
    /// Creates a new `ListRuleNamesByTargetError`.
    pub fn new(kind: ListRuleNamesByTargetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRuleNamesByTargetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRuleNamesByTargetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRuleNamesByTargetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRuleNamesByTargetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRuleNamesByTargetErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleNamesByTargetErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRuleNamesByTargetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRuleNamesByTargetErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListRuleNamesByTargetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRuleNamesByTargetErrorKind::InternalException(_inner) => Some(_inner),
            ListRuleNamesByTargetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRuleNamesByTargetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRulesError {
    /// Kind of error that occurred.
    pub kind: ListRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRulesErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRulesErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRulesError {
    fn code(&self) -> Option<&str> {
        ListRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRulesError {
    /// Creates a new `ListRulesError`.
    pub fn new(kind: ListRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListRulesErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListRulesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListRulesErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for ListRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRulesErrorKind::InternalException(_inner) => Some(_inner),
            ListRulesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTargetsByRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTargetsByRuleError {
    /// Kind of error that occurred.
    pub kind: ListTargetsByRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTargetsByRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTargetsByRuleErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTargetsByRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTargetsByRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            ListTargetsByRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTargetsByRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTargetsByRuleError {
    fn code(&self) -> Option<&str> {
        ListTargetsByRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTargetsByRuleError {
    /// Creates a new `ListTargetsByRuleError`.
    pub fn new(kind: ListTargetsByRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTargetsByRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTargetsByRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTargetsByRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTargetsByRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTargetsByRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, ListTargetsByRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `ListTargetsByRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTargetsByRuleErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTargetsByRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTargetsByRuleErrorKind::InternalException(_inner) => Some(_inner),
            ListTargetsByRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTargetsByRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutEventsError {
    /// Kind of error that occurred.
    pub kind: PutEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutEventsErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutEventsErrorKind::InternalException(_inner) => _inner.fmt(f),
            PutEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutEventsError {
    fn code(&self) -> Option<&str> {
        PutEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutEventsError {
    /// Creates a new `PutEventsError`.
    pub fn new(kind: PutEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutEventsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, PutEventsErrorKind::InternalException(_))
    }
}
impl std::error::Error for PutEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutEventsErrorKind::InternalException(_inner) => Some(_inner),
            PutEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPartnerEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPartnerEventsError {
    /// Kind of error that occurred.
    pub kind: PutPartnerEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPartnerEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPartnerEventsErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPartnerEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPartnerEventsErrorKind::InternalException(_inner) => _inner.fmt(f),
            PutPartnerEventsErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            PutPartnerEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPartnerEventsError {
    fn code(&self) -> Option<&str> {
        PutPartnerEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPartnerEventsError {
    /// Creates a new `PutPartnerEventsError`.
    pub fn new(kind: PutPartnerEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPartnerEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPartnerEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPartnerEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPartnerEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPartnerEventsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, PutPartnerEventsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `PutPartnerEventsErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPartnerEventsErrorKind::OperationDisabledException(_)
        )
    }
}
impl std::error::Error for PutPartnerEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPartnerEventsErrorKind::InternalException(_inner) => Some(_inner),
            PutPartnerEventsErrorKind::OperationDisabledException(_inner) => Some(_inner),
            PutPartnerEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPermissionError {
    /// Kind of error that occurred.
    pub kind: PutPermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPermissionErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>The event bus policy is too long. For more information, see the limits.</p>
    PolicyLengthExceededException(crate::error::PolicyLengthExceededException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPermissionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::InternalException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::PolicyLengthExceededException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutPermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPermissionError {
    fn code(&self) -> Option<&str> {
        PutPermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPermissionError {
    /// Creates a new `PutPermissionError`.
    pub fn new(kind: PutPermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, PutPermissionErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::PolicyLengthExceededException`.
    pub fn is_policy_length_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionErrorKind::PolicyLengthExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPermissionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutPermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPermissionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutPermissionErrorKind::InternalException(_inner) => Some(_inner),
            PutPermissionErrorKind::OperationDisabledException(_inner) => Some(_inner),
            PutPermissionErrorKind::PolicyLengthExceededException(_inner) => Some(_inner),
            PutPermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutPermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutRuleError {
    /// Kind of error that occurred.
    pub kind: PutRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutRuleErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The event pattern is not valid.</p>
    InvalidEventPatternException(crate::error::InvalidEventPatternException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutRuleErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            PutRuleErrorKind::InternalException(_inner) => _inner.fmt(f),
            PutRuleErrorKind::InvalidEventPatternException(_inner) => _inner.fmt(f),
            PutRuleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutRuleErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            PutRuleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutRuleError {
    fn code(&self) -> Option<&str> {
        PutRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutRuleError {
    /// Creates a new `PutRuleError`.
    pub fn new(kind: PutRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutRuleErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, PutRuleErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `PutRuleErrorKind::InvalidEventPatternException`.
    pub fn is_invalid_event_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutRuleErrorKind::InvalidEventPatternException(_)
        )
    }
    /// Returns `true` if the error kind is `PutRuleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutRuleErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutRuleErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, PutRuleErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `PutRuleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutRuleErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for PutRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutRuleErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutRuleErrorKind::InternalException(_inner) => Some(_inner),
            PutRuleErrorKind::InvalidEventPatternException(_inner) => Some(_inner),
            PutRuleErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutRuleErrorKind::ManagedRuleException(_inner) => Some(_inner),
            PutRuleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutTargetsError {
    /// Kind of error that occurred.
    pub kind: PutTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutTargetsErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutTargetsErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            PutTargetsErrorKind::InternalException(_inner) => _inner.fmt(f),
            PutTargetsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutTargetsErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            PutTargetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutTargetsError {
    fn code(&self) -> Option<&str> {
        PutTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutTargetsError {
    /// Creates a new `PutTargetsError`.
    pub fn new(kind: PutTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutTargetsErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutTargetsErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutTargetsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, PutTargetsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `PutTargetsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PutTargetsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PutTargetsErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, PutTargetsErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `PutTargetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutTargetsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for PutTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutTargetsErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutTargetsErrorKind::InternalException(_inner) => Some(_inner),
            PutTargetsErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutTargetsErrorKind::ManagedRuleException(_inner) => Some(_inner),
            PutTargetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemovePermissionError {
    /// Kind of error that occurred.
    pub kind: RemovePermissionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemovePermission` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemovePermissionErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The operation you are attempting is not available in this region.</p>
    OperationDisabledException(crate::error::OperationDisabledException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemovePermissionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemovePermissionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::InternalException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::OperationDisabledException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemovePermissionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemovePermissionError {
    fn code(&self) -> Option<&str> {
        RemovePermissionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemovePermissionError {
    /// Creates a new `RemovePermissionError`.
    pub fn new(kind: RemovePermissionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemovePermissionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemovePermissionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, RemovePermissionErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::OperationDisabledException`.
    pub fn is_operation_disabled_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::OperationDisabledException(_)
        )
    }
    /// Returns `true` if the error kind is `RemovePermissionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemovePermissionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RemovePermissionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemovePermissionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RemovePermissionErrorKind::InternalException(_inner) => Some(_inner),
            RemovePermissionErrorKind::OperationDisabledException(_inner) => Some(_inner),
            RemovePermissionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemovePermissionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTargetsError {
    /// Kind of error that occurred.
    pub kind: RemoveTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTargetsErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTargetsErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            RemoveTargetsErrorKind::InternalException(_inner) => _inner.fmt(f),
            RemoveTargetsErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            RemoveTargetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RemoveTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTargetsError {
    fn code(&self) -> Option<&str> {
        RemoveTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTargetsError {
    /// Creates a new `RemoveTargetsError`.
    pub fn new(kind: RemoveTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTargetsErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTargetsErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTargetsErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, RemoveTargetsErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `RemoveTargetsErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, RemoveTargetsErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `RemoveTargetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTargetsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for RemoveTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTargetsErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            RemoveTargetsErrorKind::InternalException(_inner) => Some(_inner),
            RemoveTargetsErrorKind::ManagedRuleException(_inner) => Some(_inner),
            RemoveTargetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RemoveTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartReplay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartReplayError {
    /// Kind of error that occurred.
    pub kind: StartReplayErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartReplay` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartReplayErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The event pattern is not valid.</p>
    InvalidEventPatternException(crate::error::InvalidEventPatternException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The resource you are trying to create already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartReplayError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartReplayErrorKind::InternalException(_inner) => _inner.fmt(f),
            StartReplayErrorKind::InvalidEventPatternException(_inner) => _inner.fmt(f),
            StartReplayErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartReplayErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            StartReplayErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartReplayErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartReplayError {
    fn code(&self) -> Option<&str> {
        StartReplayError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartReplayError {
    /// Creates a new `StartReplayError`.
    pub fn new(kind: StartReplayErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartReplayError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartReplayErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartReplayError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartReplayErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartReplayErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, StartReplayErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `StartReplayErrorKind::InvalidEventPatternException`.
    pub fn is_invalid_event_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReplayErrorKind::InvalidEventPatternException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplayErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, StartReplayErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `StartReplayErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReplayErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplayErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartReplayErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartReplayError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartReplayErrorKind::InternalException(_inner) => Some(_inner),
            StartReplayErrorKind::InvalidEventPatternException(_inner) => Some(_inner),
            StartReplayErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartReplayErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            StartReplayErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartReplayErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalException(_inner) => Some(_inner),
            TagResourceErrorKind::ManagedRuleException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestEventPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestEventPatternError {
    /// Kind of error that occurred.
    pub kind: TestEventPatternErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestEventPattern` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestEventPatternErrorKind {
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The event pattern is not valid.</p>
    InvalidEventPatternException(crate::error::InvalidEventPatternException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestEventPatternError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestEventPatternErrorKind::InternalException(_inner) => _inner.fmt(f),
            TestEventPatternErrorKind::InvalidEventPatternException(_inner) => _inner.fmt(f),
            TestEventPatternErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestEventPatternError {
    fn code(&self) -> Option<&str> {
        TestEventPatternError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestEventPatternError {
    /// Creates a new `TestEventPatternError`.
    pub fn new(kind: TestEventPatternErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestEventPatternError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestEventPatternErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestEventPatternError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestEventPatternErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestEventPatternErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, TestEventPatternErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `TestEventPatternErrorKind::InvalidEventPatternException`.
    pub fn is_invalid_event_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestEventPatternErrorKind::InvalidEventPatternException(_)
        )
    }
}
impl std::error::Error for TestEventPatternError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestEventPatternErrorKind::InternalException(_inner) => Some(_inner),
            TestEventPatternErrorKind::InvalidEventPatternException(_inner) => Some(_inner),
            TestEventPatternErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
    ManagedRuleException(crate::error::ManagedRuleException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ManagedRuleException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ManagedRuleException`.
    pub fn is_managed_rule_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ManagedRuleException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalException(_inner) => Some(_inner),
            UntagResourceErrorKind::ManagedRuleException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateApiDestinationError {
    /// Kind of error that occurred.
    pub kind: UpdateApiDestinationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateApiDestination` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateApiDestinationErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateApiDestinationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateApiDestinationErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateApiDestinationErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateApiDestinationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateApiDestinationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateApiDestinationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateApiDestinationError {
    fn code(&self) -> Option<&str> {
        UpdateApiDestinationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateApiDestinationError {
    /// Creates a new `UpdateApiDestinationError`.
    pub fn new(kind: UpdateApiDestinationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateApiDestinationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateApiDestinationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateApiDestinationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateApiDestinationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateApiDestinationErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiDestinationErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApiDestinationErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiDestinationErrorKind::InternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApiDestinationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiDestinationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateApiDestinationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateApiDestinationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateApiDestinationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateApiDestinationErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateApiDestinationErrorKind::InternalException(_inner) => Some(_inner),
            UpdateApiDestinationErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateApiDestinationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateApiDestinationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateArchiveError {
    /// Kind of error that occurred.
    pub kind: UpdateArchiveErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateArchive` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateArchiveErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The event pattern is not valid.</p>
    InvalidEventPatternException(crate::error::InvalidEventPatternException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateArchiveError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateArchiveErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateArchiveErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateArchiveErrorKind::InvalidEventPatternException(_inner) => _inner.fmt(f),
            UpdateArchiveErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateArchiveErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateArchiveErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateArchiveError {
    fn code(&self) -> Option<&str> {
        UpdateArchiveError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateArchiveError {
    /// Creates a new `UpdateArchiveError`.
    pub fn new(kind: UpdateArchiveErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateArchiveError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateArchiveErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateArchiveError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateArchiveErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateArchiveErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateArchiveErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateArchiveErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdateArchiveErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateArchiveErrorKind::InvalidEventPatternException`.
    pub fn is_invalid_event_pattern_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateArchiveErrorKind::InvalidEventPatternException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateArchiveErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateArchiveErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateArchiveErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateArchiveErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateArchiveError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateArchiveErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateArchiveErrorKind::InternalException(_inner) => Some(_inner),
            UpdateArchiveErrorKind::InvalidEventPatternException(_inner) => Some(_inner),
            UpdateArchiveErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateArchiveErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateArchiveErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateConnectionError {
    /// Kind of error that occurred.
    pub kind: UpdateConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateConnectionErrorKind {
    /// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>This exception occurs due to unexpected causes.</p>
    InternalException(crate::error::InternalException),
    /// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An entity that you specified does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateConnectionErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::InternalException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateConnectionError {
    fn code(&self) -> Option<&str> {
        UpdateConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateConnectionError {
    /// Creates a new `UpdateConnectionError`.
    pub fn new(kind: UpdateConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateConnectionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::InternalException`.
    pub fn is_internal_exception(&self) -> bool {
        matches!(&self.kind, UpdateConnectionErrorKind::InternalException(_))
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateConnectionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateConnectionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateConnectionErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::InternalException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An entity that you specified does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request failed because it attempted to create resource beyond the allowed service quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>This exception occurs due to unexpected causes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalException {}
/// See [`InternalException`](crate::error::InternalException)
pub mod internal_exception {
    /// A builder for [`InternalException`](crate::error::InternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalException`](crate::error::InternalException)
        pub fn build(self) -> crate::error::InternalException {
            crate::error::InternalException {
                message: self.message,
            }
        }
    }
}
impl InternalException {
    /// Creates a new builder-style object to manufacture [`InternalException`](crate::error::InternalException)
    pub fn builder() -> crate::error::internal_exception::Builder {
        crate::error::internal_exception::Builder::default()
    }
}

/// <p>There is concurrent modification on a rule, target, archive, or replay.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>The event pattern is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEventPatternException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEventPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEventPatternException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEventPatternException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEventPatternException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEventPatternException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEventPatternException {}
/// See [`InvalidEventPatternException`](crate::error::InvalidEventPatternException)
pub mod invalid_event_pattern_exception {
    /// A builder for [`InvalidEventPatternException`](crate::error::InvalidEventPatternException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEventPatternException`](crate::error::InvalidEventPatternException)
        pub fn build(self) -> crate::error::InvalidEventPatternException {
            crate::error::InvalidEventPatternException {
                message: self.message,
            }
        }
    }
}
impl InvalidEventPatternException {
    /// Creates a new builder-style object to manufacture [`InvalidEventPatternException`](crate::error::InvalidEventPatternException)
    pub fn builder() -> crate::error::invalid_event_pattern_exception::Builder {
        crate::error::invalid_event_pattern_exception::Builder::default()
    }
}

/// <p>This rule was created by an Amazon Web Services service on behalf of your account. It is managed by that service. If you see this error in response to <code>DeleteRule</code> or <code>RemoveTargets</code>, you can use the <code>Force</code> parameter in those calls to delete the rule or remove targets from the rule. You cannot modify these managed rules by using <code>DisableRule</code>, <code>EnableRule</code>, <code>PutTargets</code>, <code>PutRule</code>, <code>TagResource</code>, or <code>UntagResource</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedRuleException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ManagedRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedRuleException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ManagedRuleException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ManagedRuleException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ManagedRuleException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ManagedRuleException {}
/// See [`ManagedRuleException`](crate::error::ManagedRuleException)
pub mod managed_rule_exception {
    /// A builder for [`ManagedRuleException`](crate::error::ManagedRuleException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedRuleException`](crate::error::ManagedRuleException)
        pub fn build(self) -> crate::error::ManagedRuleException {
            crate::error::ManagedRuleException {
                message: self.message,
            }
        }
    }
}
impl ManagedRuleException {
    /// Creates a new builder-style object to manufacture [`ManagedRuleException`](crate::error::ManagedRuleException)
    pub fn builder() -> crate::error::managed_rule_exception::Builder {
        crate::error::managed_rule_exception::Builder::default()
    }
}

/// <p>The resource you are trying to create already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}

/// <p>The operation you are attempting is not available in this region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OperationDisabledException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OperationDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OperationDisabledException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OperationDisabledException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OperationDisabledException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OperationDisabledException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for OperationDisabledException {}
/// See [`OperationDisabledException`](crate::error::OperationDisabledException)
pub mod operation_disabled_exception {
    /// A builder for [`OperationDisabledException`](crate::error::OperationDisabledException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OperationDisabledException`](crate::error::OperationDisabledException)
        pub fn build(self) -> crate::error::OperationDisabledException {
            crate::error::OperationDisabledException {
                message: self.message,
            }
        }
    }
}
impl OperationDisabledException {
    /// Creates a new builder-style object to manufacture [`OperationDisabledException`](crate::error::OperationDisabledException)
    pub fn builder() -> crate::error::operation_disabled_exception::Builder {
        crate::error::operation_disabled_exception::Builder::default()
    }
}

/// <p>The event bus policy is too long. For more information, see the limits.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyLengthExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PolicyLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyLengthExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PolicyLengthExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PolicyLengthExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PolicyLengthExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for PolicyLengthExceededException {}
/// See [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
pub mod policy_length_exceeded_exception {
    /// A builder for [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
        pub fn build(self) -> crate::error::PolicyLengthExceededException {
            crate::error::PolicyLengthExceededException {
                message: self.message,
            }
        }
    }
}
impl PolicyLengthExceededException {
    /// Creates a new builder-style object to manufacture [`PolicyLengthExceededException`](crate::error::PolicyLengthExceededException)
    pub fn builder() -> crate::error::policy_length_exceeded_exception::Builder {
        crate::error::policy_length_exceeded_exception::Builder::default()
    }
}

/// <p>The specified state is not a valid state for an event source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidStateException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidStateException {}
/// See [`InvalidStateException`](crate::error::InvalidStateException)
pub mod invalid_state_exception {
    /// A builder for [`InvalidStateException`](crate::error::InvalidStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidStateException`](crate::error::InvalidStateException)
        pub fn build(self) -> crate::error::InvalidStateException {
            crate::error::InvalidStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidStateException {
    /// Creates a new builder-style object to manufacture [`InvalidStateException`](crate::error::InvalidStateException)
    pub fn builder() -> crate::error::invalid_state_exception::Builder {
        crate::error::invalid_state_exception::Builder::default()
    }
}

/// <p>An error occurred because a replay can be canceled only when the state is Running or Starting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalStatusException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IllegalStatusException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalStatusException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalStatusException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IllegalStatusException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalStatusException {}
/// See [`IllegalStatusException`](crate::error::IllegalStatusException)
pub mod illegal_status_exception {
    /// A builder for [`IllegalStatusException`](crate::error::IllegalStatusException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalStatusException`](crate::error::IllegalStatusException)
        pub fn build(self) -> crate::error::IllegalStatusException {
            crate::error::IllegalStatusException {
                message: self.message,
            }
        }
    }
}
impl IllegalStatusException {
    /// Creates a new builder-style object to manufacture [`IllegalStatusException`](crate::error::IllegalStatusException)
    pub fn builder() -> crate::error::illegal_status_exception::Builder {
        crate::error::illegal_status_exception::Builder::default()
    }
}
