// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon CloudWatch Events
///
/// Client for invoking operations on Amazon CloudWatch Events. Each operation on Amazon CloudWatch Events is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_cloudwatchevents::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_cloudwatchevents::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_cloudwatchevents::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ActivateEventSource` operation.
    ///
    /// See [`ActivateEventSource`](crate::client::fluent_builders::ActivateEventSource) for more information about the
    /// operation and its arguments.
    pub fn activate_event_source(&self) -> fluent_builders::ActivateEventSource<C, M, R> {
        fluent_builders::ActivateEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelReplay` operation.
    ///
    /// See [`CancelReplay`](crate::client::fluent_builders::CancelReplay) for more information about the
    /// operation and its arguments.
    pub fn cancel_replay(&self) -> fluent_builders::CancelReplay<C, M, R> {
        fluent_builders::CancelReplay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateApiDestination` operation.
    ///
    /// See [`CreateApiDestination`](crate::client::fluent_builders::CreateApiDestination) for more information about the
    /// operation and its arguments.
    pub fn create_api_destination(&self) -> fluent_builders::CreateApiDestination<C, M, R> {
        fluent_builders::CreateApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateArchive` operation.
    ///
    /// See [`CreateArchive`](crate::client::fluent_builders::CreateArchive) for more information about the
    /// operation and its arguments.
    pub fn create_archive(&self) -> fluent_builders::CreateArchive<C, M, R> {
        fluent_builders::CreateArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateConnection` operation.
    ///
    /// See [`CreateConnection`](crate::client::fluent_builders::CreateConnection) for more information about the
    /// operation and its arguments.
    pub fn create_connection(&self) -> fluent_builders::CreateConnection<C, M, R> {
        fluent_builders::CreateConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventBus` operation.
    ///
    /// See [`CreateEventBus`](crate::client::fluent_builders::CreateEventBus) for more information about the
    /// operation and its arguments.
    pub fn create_event_bus(&self) -> fluent_builders::CreateEventBus<C, M, R> {
        fluent_builders::CreateEventBus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePartnerEventSource` operation.
    ///
    /// See [`CreatePartnerEventSource`](crate::client::fluent_builders::CreatePartnerEventSource) for more information about the
    /// operation and its arguments.
    pub fn create_partner_event_source(
        &self,
    ) -> fluent_builders::CreatePartnerEventSource<C, M, R> {
        fluent_builders::CreatePartnerEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeactivateEventSource` operation.
    ///
    /// See [`DeactivateEventSource`](crate::client::fluent_builders::DeactivateEventSource) for more information about the
    /// operation and its arguments.
    pub fn deactivate_event_source(&self) -> fluent_builders::DeactivateEventSource<C, M, R> {
        fluent_builders::DeactivateEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeauthorizeConnection` operation.
    ///
    /// See [`DeauthorizeConnection`](crate::client::fluent_builders::DeauthorizeConnection) for more information about the
    /// operation and its arguments.
    pub fn deauthorize_connection(&self) -> fluent_builders::DeauthorizeConnection<C, M, R> {
        fluent_builders::DeauthorizeConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteApiDestination` operation.
    ///
    /// See [`DeleteApiDestination`](crate::client::fluent_builders::DeleteApiDestination) for more information about the
    /// operation and its arguments.
    pub fn delete_api_destination(&self) -> fluent_builders::DeleteApiDestination<C, M, R> {
        fluent_builders::DeleteApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteArchive` operation.
    ///
    /// See [`DeleteArchive`](crate::client::fluent_builders::DeleteArchive) for more information about the
    /// operation and its arguments.
    pub fn delete_archive(&self) -> fluent_builders::DeleteArchive<C, M, R> {
        fluent_builders::DeleteArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnection` operation.
    ///
    /// See [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection<C, M, R> {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventBus` operation.
    ///
    /// See [`DeleteEventBus`](crate::client::fluent_builders::DeleteEventBus) for more information about the
    /// operation and its arguments.
    pub fn delete_event_bus(&self) -> fluent_builders::DeleteEventBus<C, M, R> {
        fluent_builders::DeleteEventBus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePartnerEventSource` operation.
    ///
    /// See [`DeletePartnerEventSource`](crate::client::fluent_builders::DeletePartnerEventSource) for more information about the
    /// operation and its arguments.
    pub fn delete_partner_event_source(
        &self,
    ) -> fluent_builders::DeletePartnerEventSource<C, M, R> {
        fluent_builders::DeletePartnerEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRule` operation.
    ///
    /// See [`DeleteRule`](crate::client::fluent_builders::DeleteRule) for more information about the
    /// operation and its arguments.
    pub fn delete_rule(&self) -> fluent_builders::DeleteRule<C, M, R> {
        fluent_builders::DeleteRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApiDestination` operation.
    ///
    /// See [`DescribeApiDestination`](crate::client::fluent_builders::DescribeApiDestination) for more information about the
    /// operation and its arguments.
    pub fn describe_api_destination(&self) -> fluent_builders::DescribeApiDestination<C, M, R> {
        fluent_builders::DescribeApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeArchive` operation.
    ///
    /// See [`DescribeArchive`](crate::client::fluent_builders::DescribeArchive) for more information about the
    /// operation and its arguments.
    pub fn describe_archive(&self) -> fluent_builders::DescribeArchive<C, M, R> {
        fluent_builders::DescribeArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnection` operation.
    ///
    /// See [`DescribeConnection`](crate::client::fluent_builders::DescribeConnection) for more information about the
    /// operation and its arguments.
    pub fn describe_connection(&self) -> fluent_builders::DescribeConnection<C, M, R> {
        fluent_builders::DescribeConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventBus` operation.
    ///
    /// See [`DescribeEventBus`](crate::client::fluent_builders::DescribeEventBus) for more information about the
    /// operation and its arguments.
    pub fn describe_event_bus(&self) -> fluent_builders::DescribeEventBus<C, M, R> {
        fluent_builders::DescribeEventBus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventSource` operation.
    ///
    /// See [`DescribeEventSource`](crate::client::fluent_builders::DescribeEventSource) for more information about the
    /// operation and its arguments.
    pub fn describe_event_source(&self) -> fluent_builders::DescribeEventSource<C, M, R> {
        fluent_builders::DescribeEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePartnerEventSource` operation.
    ///
    /// See [`DescribePartnerEventSource`](crate::client::fluent_builders::DescribePartnerEventSource) for more information about the
    /// operation and its arguments.
    pub fn describe_partner_event_source(
        &self,
    ) -> fluent_builders::DescribePartnerEventSource<C, M, R> {
        fluent_builders::DescribePartnerEventSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplay` operation.
    ///
    /// See [`DescribeReplay`](crate::client::fluent_builders::DescribeReplay) for more information about the
    /// operation and its arguments.
    pub fn describe_replay(&self) -> fluent_builders::DescribeReplay<C, M, R> {
        fluent_builders::DescribeReplay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRule` operation.
    ///
    /// See [`DescribeRule`](crate::client::fluent_builders::DescribeRule) for more information about the
    /// operation and its arguments.
    pub fn describe_rule(&self) -> fluent_builders::DescribeRule<C, M, R> {
        fluent_builders::DescribeRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableRule` operation.
    ///
    /// See [`DisableRule`](crate::client::fluent_builders::DisableRule) for more information about the
    /// operation and its arguments.
    pub fn disable_rule(&self) -> fluent_builders::DisableRule<C, M, R> {
        fluent_builders::DisableRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableRule` operation.
    ///
    /// See [`EnableRule`](crate::client::fluent_builders::EnableRule) for more information about the
    /// operation and its arguments.
    pub fn enable_rule(&self) -> fluent_builders::EnableRule<C, M, R> {
        fluent_builders::EnableRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApiDestinations` operation.
    ///
    /// See [`ListApiDestinations`](crate::client::fluent_builders::ListApiDestinations) for more information about the
    /// operation and its arguments.
    pub fn list_api_destinations(&self) -> fluent_builders::ListApiDestinations<C, M, R> {
        fluent_builders::ListApiDestinations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListArchives` operation.
    ///
    /// See [`ListArchives`](crate::client::fluent_builders::ListArchives) for more information about the
    /// operation and its arguments.
    pub fn list_archives(&self) -> fluent_builders::ListArchives<C, M, R> {
        fluent_builders::ListArchives::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListConnections` operation.
    ///
    /// See [`ListConnections`](crate::client::fluent_builders::ListConnections) for more information about the
    /// operation and its arguments.
    pub fn list_connections(&self) -> fluent_builders::ListConnections<C, M, R> {
        fluent_builders::ListConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventBuses` operation.
    ///
    /// See [`ListEventBuses`](crate::client::fluent_builders::ListEventBuses) for more information about the
    /// operation and its arguments.
    pub fn list_event_buses(&self) -> fluent_builders::ListEventBuses<C, M, R> {
        fluent_builders::ListEventBuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEventSources` operation.
    ///
    /// See [`ListEventSources`](crate::client::fluent_builders::ListEventSources) for more information about the
    /// operation and its arguments.
    pub fn list_event_sources(&self) -> fluent_builders::ListEventSources<C, M, R> {
        fluent_builders::ListEventSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPartnerEventSourceAccounts` operation.
    ///
    /// See [`ListPartnerEventSourceAccounts`](crate::client::fluent_builders::ListPartnerEventSourceAccounts) for more information about the
    /// operation and its arguments.
    pub fn list_partner_event_source_accounts(
        &self,
    ) -> fluent_builders::ListPartnerEventSourceAccounts<C, M, R> {
        fluent_builders::ListPartnerEventSourceAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPartnerEventSources` operation.
    ///
    /// See [`ListPartnerEventSources`](crate::client::fluent_builders::ListPartnerEventSources) for more information about the
    /// operation and its arguments.
    pub fn list_partner_event_sources(&self) -> fluent_builders::ListPartnerEventSources<C, M, R> {
        fluent_builders::ListPartnerEventSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReplays` operation.
    ///
    /// See [`ListReplays`](crate::client::fluent_builders::ListReplays) for more information about the
    /// operation and its arguments.
    pub fn list_replays(&self) -> fluent_builders::ListReplays<C, M, R> {
        fluent_builders::ListReplays::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRuleNamesByTarget` operation.
    ///
    /// See [`ListRuleNamesByTarget`](crate::client::fluent_builders::ListRuleNamesByTarget) for more information about the
    /// operation and its arguments.
    pub fn list_rule_names_by_target(&self) -> fluent_builders::ListRuleNamesByTarget<C, M, R> {
        fluent_builders::ListRuleNamesByTarget::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRules` operation.
    ///
    /// See [`ListRules`](crate::client::fluent_builders::ListRules) for more information about the
    /// operation and its arguments.
    pub fn list_rules(&self) -> fluent_builders::ListRules<C, M, R> {
        fluent_builders::ListRules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTargetsByRule` operation.
    ///
    /// See [`ListTargetsByRule`](crate::client::fluent_builders::ListTargetsByRule) for more information about the
    /// operation and its arguments.
    pub fn list_targets_by_rule(&self) -> fluent_builders::ListTargetsByRule<C, M, R> {
        fluent_builders::ListTargetsByRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutEvents` operation.
    ///
    /// See [`PutEvents`](crate::client::fluent_builders::PutEvents) for more information about the
    /// operation and its arguments.
    pub fn put_events(&self) -> fluent_builders::PutEvents<C, M, R> {
        fluent_builders::PutEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPartnerEvents` operation.
    ///
    /// See [`PutPartnerEvents`](crate::client::fluent_builders::PutPartnerEvents) for more information about the
    /// operation and its arguments.
    pub fn put_partner_events(&self) -> fluent_builders::PutPartnerEvents<C, M, R> {
        fluent_builders::PutPartnerEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPermission` operation.
    ///
    /// See [`PutPermission`](crate::client::fluent_builders::PutPermission) for more information about the
    /// operation and its arguments.
    pub fn put_permission(&self) -> fluent_builders::PutPermission<C, M, R> {
        fluent_builders::PutPermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutRule` operation.
    ///
    /// See [`PutRule`](crate::client::fluent_builders::PutRule) for more information about the
    /// operation and its arguments.
    pub fn put_rule(&self) -> fluent_builders::PutRule<C, M, R> {
        fluent_builders::PutRule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutTargets` operation.
    ///
    /// See [`PutTargets`](crate::client::fluent_builders::PutTargets) for more information about the
    /// operation and its arguments.
    pub fn put_targets(&self) -> fluent_builders::PutTargets<C, M, R> {
        fluent_builders::PutTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemovePermission` operation.
    ///
    /// See [`RemovePermission`](crate::client::fluent_builders::RemovePermission) for more information about the
    /// operation and its arguments.
    pub fn remove_permission(&self) -> fluent_builders::RemovePermission<C, M, R> {
        fluent_builders::RemovePermission::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTargets` operation.
    ///
    /// See [`RemoveTargets`](crate::client::fluent_builders::RemoveTargets) for more information about the
    /// operation and its arguments.
    pub fn remove_targets(&self) -> fluent_builders::RemoveTargets<C, M, R> {
        fluent_builders::RemoveTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartReplay` operation.
    ///
    /// See [`StartReplay`](crate::client::fluent_builders::StartReplay) for more information about the
    /// operation and its arguments.
    pub fn start_replay(&self) -> fluent_builders::StartReplay<C, M, R> {
        fluent_builders::StartReplay::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestEventPattern` operation.
    ///
    /// See [`TestEventPattern`](crate::client::fluent_builders::TestEventPattern) for more information about the
    /// operation and its arguments.
    pub fn test_event_pattern(&self) -> fluent_builders::TestEventPattern<C, M, R> {
        fluent_builders::TestEventPattern::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateApiDestination` operation.
    ///
    /// See [`UpdateApiDestination`](crate::client::fluent_builders::UpdateApiDestination) for more information about the
    /// operation and its arguments.
    pub fn update_api_destination(&self) -> fluent_builders::UpdateApiDestination<C, M, R> {
        fluent_builders::UpdateApiDestination::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateArchive` operation.
    ///
    /// See [`UpdateArchive`](crate::client::fluent_builders::UpdateArchive) for more information about the
    /// operation and its arguments.
    pub fn update_archive(&self) -> fluent_builders::UpdateArchive<C, M, R> {
        fluent_builders::UpdateArchive::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateConnection` operation.
    ///
    /// See [`UpdateConnection`](crate::client::fluent_builders::UpdateConnection) for more information about the
    /// operation and its arguments.
    pub fn update_connection(&self) -> fluent_builders::UpdateConnection<C, M, R> {
        fluent_builders::UpdateConnection::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateEventSource`.
    ///
    /// <p>Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ActivateEventSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_event_source_input::Builder,
    }
    impl<C, M, R> ActivateEventSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateEventSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateEventSourceInputOperationOutputAlias,
                crate::output::ActivateEventSourceOutput,
                crate::error::ActivateEventSourceError,
                crate::input::ActivateEventSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to activate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source to activate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelReplay`.
    ///
    /// <p>Cancels the specified replay.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelReplay<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_replay_input::Builder,
    }
    impl<C, M, R> CancelReplay<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelReplay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelReplayOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelReplayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelReplayInputOperationOutputAlias,
                crate::output::CancelReplayOutput,
                crate::error::CancelReplayError,
                crate::input::CancelReplayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replay to cancel.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replay_name(input.into());
            self
        }
        /// <p>The name of the replay to cancel.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_replay_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateApiDestination`.
    ///
    /// <p>Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateApiDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_api_destination_input::Builder,
    }
    impl<C, M, R> CreateApiDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateApiDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateApiDestinationInputOperationOutputAlias,
                crate::output::CreateApiDestinationOutput,
                crate::error::CreateApiDestinationError,
                crate::input::CreateApiDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the API destination to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the API destination to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the API destination to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the API destination to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the connection to use for the API destination. The destination endpoint must support the authorization type specified for the connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(input.into());
            self
        }
        /// <p>The ARN of the connection to use for the API destination. The destination endpoint must support the authorization type specified for the connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
        /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invocation_endpoint(input.into());
            self
        }
        /// <p>The URL to the HTTP invocation endpoint for the API destination.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invocation_endpoint(input);
            self
        }
        /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.inner = self.inner.http_method(input);
            self
        }
        /// <p>The method to use for the request to the HTTP invocation endpoint.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.inner = self.inner.invocation_rate_limit_per_second(input);
            self
        }
        /// <p>The maximum number of requests per second to send to the HTTP invocation endpoint.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_invocation_rate_limit_per_second(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateArchive`.
    ///
    /// <p>Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateArchive<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_archive_input::Builder,
    }
    impl<C, M, R> CreateArchive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateArchiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateArchiveInputOperationOutputAlias,
                crate::output::CreateArchiveOutput,
                crate::error::CreateArchiveError,
                crate::input::CreateArchiveInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the archive to create.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name for the archive to create.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
        /// <p>The ARN of the event bus that sends events to the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the event bus that sends events to the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>A description for the archive.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the archive.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>An event pattern to use to filter events sent to the archive.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>An event pattern to use to filter events sent to the archive.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_days(input);
            self
        }
        /// <p>The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateConnection`.
    ///
    /// <p>Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_connection_input::Builder,
    }
    impl<C, M, R> CreateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateConnectionInputOperationOutputAlias,
                crate::output::CreateConnectionOutput,
                crate::error::CreateConnectionError,
                crate::input::CreateConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the connection to create.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name for the connection to create.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the connection to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the connection to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the authorization parameters to use to authorize with the endpoint. </p>
        pub fn auth_parameters(
            mut self,
            input: crate::model::CreateConnectionAuthRequestParameters,
        ) -> Self {
            self.inner = self.inner.auth_parameters(input);
            self
        }
        /// <p>A <code>CreateConnectionAuthRequestParameters</code> object that contains the authorization parameters to use to authorize with the endpoint. </p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::CreateConnectionAuthRequestParameters>,
        ) -> Self {
            self.inner = self.inner.set_auth_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventBus`.
    ///
    /// <p>Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventBus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_bus_input::Builder,
    }
    impl<C, M, R> CreateEventBus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventBus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventBusOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventBusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventBusInputOperationOutputAlias,
                crate::output::CreateEventBusOutput,
                crate::error::CreateEventBusError,
                crate::input::CreateEventBusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the new event bus. </p>
        /// <p>Event bus names cannot contain the / character. You can't use the name <code>default</code> for a custom event bus, as this name is already used for your account's default event bus.</p>
        /// <p>If this is a partner event bus, the name must exactly match the name of the partner event source that this event bus is matched to.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the new event bus. </p>
        /// <p>Event bus names cannot contain the / character. You can't use the name <code>default</code> for a custom event bus, as this name is already used for your account's default event bus.</p>
        /// <p>If this is a partner event bus, the name must exactly match the name of the partner event source that this event bus is matched to.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>If you are creating a partner event bus, this specifies the partner event source that the new event bus will be matched with.</p>
        pub fn event_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_name(input.into());
            self
        }
        /// <p>If you are creating a partner event bus, this specifies the partner event source that the new event bus will be matched with.</p>
        pub fn set_event_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to associate with the event bus.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to associate with the event bus.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePartnerEventSource`.
    ///
    /// <p>Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.</p>
    /// <p>Each partner event source can be used by one Amazon Web Services account to create a matching partner event bus in that Amazon Web Services account. A SaaS partner must create one partner event source for each Amazon Web Services account that wants to receive those event types. </p>
    /// <p>A partner event source creates events based on resources within the SaaS partner's service or application.</p>
    /// <p>An Amazon Web Services account that creates a partner event bus that matches the partner event source can use that event bus to receive events from the partner, and then process them using Amazon Web Services Events rules and targets.</p>
    /// <p>Partner event source names follow this format:</p>
    /// <p> <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code> </p>
    /// <p> <i>partner_name</i> is determined during partner registration and identifies the partner to Amazon Web Services customers. <i>event_namespace</i> is determined by the partner and is a way for the partner to categorize their events. <i>event_name</i> is determined by the partner, and should uniquely identify an event-generating resource within the partner system. The combination of <i>event_namespace</i> and <i>event_name</i> should help Amazon Web Services customers decide whether to create an event bus to receive these events.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePartnerEventSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_partner_event_source_input::Builder,
    }
    impl<C, M, R> CreatePartnerEventSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePartnerEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePartnerEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePartnerEventSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePartnerEventSourceInputOperationOutputAlias,
                crate::output::CreatePartnerEventSourceOutput,
                crate::error::CreatePartnerEventSourceError,
                crate::input::CreatePartnerEventSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source. This name must be unique and must be in the format <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>. The Amazon Web Services account that wants to use this partner event source must create a partner event bus with a name that matches the name of the partner event source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source. This name must be unique and must be in the format <code> <i>partner_name</i>/<i>event_namespace</i>/<i>event_name</i> </code>. The Amazon Web Services account that wants to use this partner event source must create a partner event bus with a name that matches the name of the partner event source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this partner event source.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that is permitted to create a matching partner event bus for this partner event source.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeactivateEventSource`.
    ///
    /// <p>You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted. </p>
    /// <p>When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state for more than two weeks, it is deleted.</p>
    /// <p>To activate a deactivated partner event source, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ActivateEventSource.html">ActivateEventSource</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeactivateEventSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deactivate_event_source_input::Builder,
    }
    impl<C, M, R> DeactivateEventSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeactivateEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeactivateEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeactivateEventSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeactivateEventSourceInputOperationOutputAlias,
                crate::output::DeactivateEventSourceOutput,
                crate::error::DeactivateEventSourceError,
                crate::input::DeactivateEventSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to deactivate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source to deactivate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeauthorizeConnection`.
    ///
    /// <p>Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeauthorizeConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deauthorize_connection_input::Builder,
    }
    impl<C, M, R> DeauthorizeConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeauthorizeConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeauthorizeConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeauthorizeConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeauthorizeConnectionInputOperationOutputAlias,
                crate::output::DeauthorizeConnectionOutput,
                crate::error::DeauthorizeConnectionError,
                crate::input::DeauthorizeConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to remove authorization from.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to remove authorization from.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteApiDestination`.
    ///
    /// <p>Deletes the specified API destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteApiDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_api_destination_input::Builder,
    }
    impl<C, M, R> DeleteApiDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteApiDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteApiDestinationInputOperationOutputAlias,
                crate::output::DeleteApiDestinationOutput,
                crate::error::DeleteApiDestinationError,
                crate::input::DeleteApiDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the destination to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the destination to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteArchive`.
    ///
    /// <p>Deletes the specified archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteArchive<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_archive_input::Builder,
    }
    impl<C, M, R> DeleteArchive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteArchiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteArchiveInputOperationOutputAlias,
                crate::output::DeleteArchiveOutput,
                crate::error::DeleteArchiveError,
                crate::input::DeleteArchiveInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the archive to delete.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name of the archive to delete.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes a connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl<C, M, R> DeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionInputOperationOutputAlias,
                crate::output::DeleteConnectionOutput,
                crate::error::DeleteConnectionError,
                crate::input::DeleteConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventBus`.
    ///
    /// <p>Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can't delete your account's default event bus.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventBus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_bus_input::Builder,
    }
    impl<C, M, R> DeleteEventBus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventBus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventBusOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventBusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventBusInputOperationOutputAlias,
                crate::output::DeleteEventBusOutput,
                crate::error::DeleteEventBusError,
                crate::input::DeleteEventBusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event bus to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event bus to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePartnerEventSource`.
    ///
    /// <p>This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon Web Services customers.</p>
    /// <p>When you delete an event source, the status of the corresponding partner event bus in the Amazon Web Services customer account becomes DELETED.</p>
    /// <p></p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePartnerEventSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_partner_event_source_input::Builder,
    }
    impl<C, M, R> DeletePartnerEventSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePartnerEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePartnerEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePartnerEventSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePartnerEventSourceInputOperationOutputAlias,
                crate::output::DeletePartnerEventSourceOutput,
                crate::error::DeletePartnerEventSourceError,
                crate::input::DeletePartnerEventSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event source to delete.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event source to delete.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the Amazon Web Services customer that the event source was created for.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRule`.
    ///
    /// <p>Deletes the specified rule.</p>
    /// <p>Before you can delete the rule, you must remove all targets, using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemoveTargets.html">RemoveTargets</a>.</p>
    /// <p>When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time for changes to take effect.</p>
    /// <p>If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a non-existent custom eventbus, <code>ResourceNotFoundException</code> is returned.</p>
    /// <p>Managed rules are rules created and managed by another Amazon Web Services service on your behalf. These rules are created by those other Amazon Web Services services to support functionality in those services. You can delete these rules using the <code>Force</code> option, but you should do so only if you are sure the other service is not still using that rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_rule_input::Builder,
    }
    impl<C, M, R> DeleteRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRuleInputOperationOutputAlias,
                crate::output::DeleteRuleOutput,
                crate::error::DeleteRuleError,
                crate::input::DeleteRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to delete the rule. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeApiDestination`.
    ///
    /// <p>Retrieves details about an API destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeApiDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_api_destination_input::Builder,
    }
    impl<C, M, R> DescribeApiDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeApiDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApiDestinationInputOperationOutputAlias,
                crate::output::DescribeApiDestinationOutput,
                crate::error::DescribeApiDestinationError,
                crate::input::DescribeApiDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the API destination to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API destination to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeArchive`.
    ///
    /// <p>Retrieves details about an archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeArchive<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_archive_input::Builder,
    }
    impl<C, M, R> DescribeArchive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeArchiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeArchiveInputOperationOutputAlias,
                crate::output::DescribeArchiveOutput,
                crate::error::DescribeArchiveError,
                crate::input::DescribeArchiveInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the archive to retrieve.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name of the archive to retrieve.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnection`.
    ///
    /// <p>Retrieves details about a connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connection_input::Builder,
    }
    impl<C, M, R> DescribeConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectionInputOperationOutputAlias,
                crate::output::DescribeConnectionOutput,
                crate::error::DescribeConnectionError,
                crate::input::DescribeConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to retrieve.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to retrieve.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventBus`.
    ///
    /// <p>Displays details about an event bus in your account. This can include the external Amazon Web Services accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.</p>
    /// <p> To enable your account to receive events from other accounts on its default event bus, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.</p>
    /// <p>For more information about partner event buses, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventBus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_bus_input::Builder,
    }
    impl<C, M, R> DescribeEventBus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventBus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventBusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventBusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventBusInputOperationOutputAlias,
                crate::output::DescribeEventBusOutput,
                crate::error::DescribeEventBusError,
                crate::input::DescribeEventBusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event bus is displayed.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to show details for. If you omit this, the default event bus is displayed.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSource`.
    ///
    /// <p>This operation lists details about a partner event source that is shared with your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_source_input::Builder,
    }
    impl<C, M, R> DescribeEventSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventSourceInputOperationOutputAlias,
                crate::output::DescribeEventSourceOutput,
                crate::error::DescribeEventSourceError,
                crate::input::DescribeEventSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to display the details of.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the partner event source to display the details of.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePartnerEventSource`.
    ///
    /// <p>An SaaS partner can use this operation to list details about a partner event source that they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventSource.html">DescribeEventSource</a> to see details about a partner event source that is shared with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePartnerEventSource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_partner_event_source_input::Builder,
    }
    impl<C, M, R> DescribePartnerEventSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePartnerEventSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePartnerEventSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePartnerEventSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePartnerEventSourceInputOperationOutputAlias,
                crate::output::DescribePartnerEventSourceOutput,
                crate::error::DescribePartnerEventSourceError,
                crate::input::DescribePartnerEventSourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event source to display.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the event source to display.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplay`.
    ///
    /// <p>Retrieves details about a replay. Use <code>DescribeReplay</code> to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use <code>StartReplay</code> and specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range associated with the last event replayed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReplay<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replay_input::Builder,
    }
    impl<C, M, R> DescribeReplay<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplayOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplayInputOperationOutputAlias,
                crate::output::DescribeReplayOutput,
                crate::error::DescribeReplayError,
                crate::input::DescribeReplayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replay to retrieve.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replay_name(input.into());
            self
        }
        /// <p>The name of the replay to retrieve.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_replay_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRule`.
    ///
    /// <p>Describes the specified rule.</p>
    /// <p>DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_rule_input::Builder,
    }
    impl<C, M, R> DescribeRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRuleInputOperationOutputAlias,
                crate::output::DescribeRuleOutput,
                crate::error::DescribeRuleError,
                crate::input::DescribeRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableRule`.
    ///
    /// <p>Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule expression.</p>
    /// <p>When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of time for changes to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_rule_input::Builder,
    }
    impl<C, M, R> DisableRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableRuleInputOperationOutputAlias,
                crate::output::DisableRuleOutput,
                crate::error::DisableRuleError,
                crate::input::DisableRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableRule`.
    ///
    /// <p>Enables the specified rule. If the rule does not exist, the operation fails.</p>
    /// <p>When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a short period of time for changes to take effect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_rule_input::Builder,
    }
    impl<C, M, R> EnableRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableRuleInputOperationOutputAlias,
                crate::output::EnableRuleOutput,
                crate::error::EnableRuleError,
                crate::input::EnableRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApiDestinations`.
    ///
    /// <p>Retrieves a list of API destination in the account in the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApiDestinations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_api_destinations_input::Builder,
    }
    impl<C, M, R> ListApiDestinations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApiDestinations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApiDestinationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApiDestinationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApiDestinationsInputOperationOutputAlias,
                crate::output::ListApiDestinationsOutput,
                crate::error::ListApiDestinationsError,
                crate::input::ListApiDestinationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter results returned. Only API destinations with a name that starts with the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter results returned. Only API destinations with a name that starts with the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(input.into());
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of API destinations to include in the response.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of API destinations to include in the response.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListArchives`.
    ///
    /// <p>Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListArchives<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_archives_input::Builder,
    }
    impl<C, M, R> ListArchives<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListArchives`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListArchivesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListArchivesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListArchivesInputOperationOutputAlias,
                crate::output::ListArchivesOutput,
                crate::error::ListArchivesError,
                crate::input::ListArchivesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter the archives returned. Only archives with name that match the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the event source associated with the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The state of the archive.</p>
        pub fn state(mut self, input: crate::model::ArchiveState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the archive.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ArchiveState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListConnections`.
    ///
    /// <p>Retrieves a list of connections from the account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_connections_input::Builder,
    }
    impl<C, M, R> ListConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListConnectionsInputOperationOutputAlias,
                crate::output::ListConnectionsOutput,
                crate::error::ListConnectionsError,
                crate::input::ListConnectionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter results returned. Only connections with a name that starts with the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter results returned. Only connections with a name that starts with the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.inner = self.inner.connection_state(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.inner = self.inner.set_connection_state(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of connections to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of connections to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventBuses`.
    ///
    /// <p>Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventBuses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_event_buses_input::Builder,
    }
    impl<C, M, R> ListEventBuses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventBuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventBusesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventBusesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventBusesInputOperationOutputAlias,
                crate::output::ListEventBusesOutput,
                crate::error::ListEventBusesError,
                crate::input::ListEventBusesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifying this limits the results to only those event buses with names that start with the specified prefix.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those event buses with names that start with the specified prefix.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEventSources`.
    ///
    /// <p>You can use this to see all the partner event sources that have been shared with your Amazon Web Services account. For more information about partner event sources, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEventSources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_event_sources_input::Builder,
    }
    impl<C, M, R> ListEventSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEventSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEventSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEventSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEventSourcesInputOperationOutputAlias,
                crate::output::ListEventSourcesOutput,
                crate::error::ListEventSourcesError,
                crate::input::ListEventSourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifying this limits the results to only those partner event sources with names that start with the specified prefix.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>Specifying this limits the results to only those partner event sources with names that start with the specified prefix.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPartnerEventSourceAccounts`.
    ///
    /// <p>An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner event source name is associated with. This operation is not used by Amazon Web Services customers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPartnerEventSourceAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_partner_event_source_accounts_input::Builder,
    }
    impl<C, M, R> ListPartnerEventSourceAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPartnerEventSourceAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPartnerEventSourceAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPartnerEventSourceAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPartnerEventSourceAccountsInputOperationOutputAlias,
                crate::output::ListPartnerEventSourceAccountsOutput,
                crate::error::ListPartnerEventSourceAccountsError,
                crate::input::ListPartnerEventSourceAccountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the partner event source to display account information about.</p>
        pub fn event_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_name(input.into());
            self
        }
        /// <p>The name of the partner event source to display account information about.</p>
        pub fn set_event_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_name(input);
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPartnerEventSources`.
    ///
    /// <p>An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by Amazon Web Services customers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPartnerEventSources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_partner_event_sources_input::Builder,
    }
    impl<C, M, R> ListPartnerEventSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPartnerEventSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPartnerEventSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPartnerEventSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPartnerEventSourcesInputOperationOutputAlias,
                crate::output::ListPartnerEventSourcesOutput,
                crate::error::ListPartnerEventSourcesError,
                crate::input::ListPartnerEventSourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>If you specify this, the results are limited to only those partner event sources that start with the string you specify.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>If you specify this, the results are limited to only those partner event sources that start with the string you specify.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to this operation. Specifying this retrieves the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>pecifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>pecifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReplays`.
    ///
    /// <p>Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReplays<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_replays_input::Builder,
    }
    impl<C, M, R> ListReplays<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReplays`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReplaysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReplaysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReplaysInputOperationOutputAlias,
                crate::output::ListReplaysOutput,
                crate::error::ListReplaysError,
                crate::input::ListReplaysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix are returned.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>A name prefix to filter the replays returned. Only replays with name that match the prefix are returned.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The state of the replay.</p>
        pub fn state(mut self, input: crate::model::ReplayState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the replay.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ReplayState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The ARN of the archive from which the events are replayed.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the archive from which the events are replayed.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of replays to retrieve.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of replays to retrieve.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRuleNamesByTarget`.
    ///
    /// <p>Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRuleNamesByTarget<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rule_names_by_target_input::Builder,
    }
    impl<C, M, R> ListRuleNamesByTarget<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRuleNamesByTarget`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRuleNamesByTargetOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRuleNamesByTargetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRuleNamesByTargetInputOperationOutputAlias,
                crate::output::ListRuleNamesByTargetOutput,
                crate::error::ListRuleNamesByTargetError,
                crate::input::ListRuleNamesByTargetInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target resource.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_target_arn(input);
            self
        }
        /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to list rules for. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRules`.
    ///
    /// <p>Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.</p>
    /// <p>ListRules does not list the targets of a rule. To see the targets associated with a rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_ListTargetsByRule.html">ListTargetsByRule</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_rules_input::Builder,
    }
    impl<C, M, R> ListRules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRulesInputOperationOutputAlias,
                crate::output::ListRulesOutput,
                crate::error::ListRulesError,
                crate::input::ListRulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The prefix matching the rule name.</p>
        pub fn name_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_prefix(input.into());
            self
        }
        /// <p>The prefix matching the rule name.</p>
        pub fn set_name_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name_prefix(input);
            self
        }
        /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to list the rules for. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource for which you want to view tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTargetsByRule`.
    ///
    /// <p>Lists the targets assigned to the specified rule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTargetsByRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_targets_by_rule_input::Builder,
    }
    impl<C, M, R> ListTargetsByRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTargetsByRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTargetsByRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTargetsByRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTargetsByRuleInputOperationOutputAlias,
                crate::output::ListTargetsByRuleOutput,
                crate::error::ListTargetsByRuleError,
                crate::input::ListTargetsByRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token returned by a previous call to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutEvents`.
    ///
    /// <p>Sends custom events to Amazon EventBridge so that they can be matched to rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_events_input::Builder,
    }
    impl<C, M, R> PutEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutEventsInputOperationOutputAlias,
                crate::output::PutEventsOutput,
                crate::error::PutEventsError,
                crate::input::PutEventsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The entry that defines an event in your system. You can specify several parameters for the entry such as the source and type of the event, resources associated with the event, and so on.</p>
        pub fn entries(mut self, input: crate::model::PutEventsRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The entry that defines an event in your system. You can specify several parameters for the entry such as the source and type of the event, resources associated with the event, and so on.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutEventsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPartnerEvents`.
    ///
    /// <p>This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do not use this operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPartnerEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_partner_events_input::Builder,
    }
    impl<C, M, R> PutPartnerEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPartnerEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPartnerEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPartnerEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPartnerEventsInputOperationOutputAlias,
                crate::output::PutPartnerEventsOutput,
                crate::error::PutPartnerEventsError,
                crate::input::PutPartnerEventsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The list of events to write to the event bus.</p>
        pub fn entries(mut self, input: crate::model::PutPartnerEventsRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The list of events to write to the event bus.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PutPartnerEventsRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPermission`.
    ///
    /// <p>Running <code>PutPermission</code> permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified <i>event bus</i>. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account. </p>
    /// <p>For another account to send events to your account, that external account must have an EventBridge rule with your account's event bus as a target.</p>
    /// <p>To enable multiple Amazon Web Services accounts to put events to your event bus, run <code>PutPermission</code> once for each of these accounts. Or, if all the accounts are members of the same Amazon Web Services organization, you can run <code>PutPermission</code> once specifying <code>Principal</code> as "*" and specifying the Amazon Web Services organization ID in <code>Condition</code>, to grant permissions to all accounts in that organization.</p>
    /// <p>If you grant permissions using an organization, then accounts in that organization must specify a <code>RoleArn</code> with proper permissions when they use <code>PutTarget</code> to add your account's event bus as a target. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    /// <p>The permission policy on the event bus cannot exceed 10 KB in size.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutPermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_permission_input::Builder,
    }
    impl<C, M, R> PutPermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPermissionInputOperationOutputAlias,
                crate::output::PutPermissionOutput,
                crate::error::PutPermissionError,
                crate::input::PutPermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// <p>The action that you are enabling the other account to perform.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.action(input.into());
            self
        }
        /// <p>The action that you are enabling the other account to perform.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.</p>
        /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principal(input.into());
            self
        }
        /// <p>The 12-digit Amazon Web Services account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus.</p>
        /// <p>If you specify "*" without specifying <code>Condition</code>, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an <code>account</code> field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_principal(input);
            self
        }
        /// <p>An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this <code>StatementId</code> when you run <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_RemovePermission.html">RemovePermission</a>.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
        /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value for <code>Principal</code>, you grant permission to all the accounts in the named organization.</p>
        /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and <code>Value</code> fields.</p>
        pub fn condition(mut self, input: crate::model::Condition) -> Self {
            self.inner = self.inner.condition(input);
            self
        }
        /// <p>This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain Amazon Web Services organization. For more information about Amazon Web Services Organizations, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html">What Is Amazon Web Services Organizations</a> in the <i>Amazon Web Services Organizations User Guide</i>.</p>
        /// <p>If you specify <code>Condition</code> with an Amazon Web Services organization ID, and specify "*" as the value for <code>Principal</code>, you grant permission to all the accounts in the named organization.</p>
        /// <p>The <code>Condition</code> is a JSON string which must contain <code>Type</code>, <code>Key</code>, and <code>Value</code> fields.</p>
        pub fn set_condition(
            mut self,
            input: std::option::Option<crate::model::Condition>,
        ) -> Self {
            self.inner = self.inner.set_condition(input);
            self
        }
        /// <p>A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.policy(input.into());
            self
        }
        /// <p>A JSON string that describes the permission policy statement. You can include a <code>Policy</code> parameter in the request instead of using the <code>StatementId</code>, <code>Action</code>, <code>Principal</code>, or <code>Condition</code> parameters.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutRule`.
    ///
    /// <p>Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DisableRule.html">DisableRule</a>.</p>
    /// <p>A single rule watches for events from a single event bus. Events generated by Amazon Web Services services go to your account's default event bus. Events generated by SaaS partner services or applications go to the matching partner event bus. If you have custom applications or services, you can specify whether their events go to your default event bus or a custom event bus that you have created. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_CreateEventBus.html">CreateEventBus</a>.</p>
    /// <p>If you are updating an existing rule, the rule is replaced with what you specify in this <code>PutRule</code> command. If you omit arguments in <code>PutRule</code>, the old values for those arguments are not kept. Instead, they are replaced with null values.</p>
    /// <p>When you create or update a rule, incoming events might not immediately start matching to new or updated rules. Allow a short period of time for changes to take effect.</p>
    /// <p>A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as on a schedule.</p>
    /// <p>When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only rules with certain tag values. To use the <code>PutRule</code> operation and assign tags, you must have both the <code>events:PutRule</code> and <code>events:TagResource</code> permissions.</p>
    /// <p>If you are updating an existing rule, any tags you specify in the <code>PutRule</code> operation are ignored. To update the tags of an existing rule, use <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_UntagResource.html">UntagResource</a>.</p>
    /// <p>Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.</p>
    /// <p>In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again, creating an infinite loop.</p>
    /// <p>To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead of after any change. </p>
    /// <p>An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which alerts you when charges exceed your specified limit. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html">Managing Your Costs with Budgets</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutRule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_rule_input::Builder,
    }
    impl<C, M, R> PutRule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutRule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutRuleOutput,
            aws_smithy_http::result::SdkError<crate::error::PutRuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutRuleInputOperationOutputAlias,
                crate::output::PutRuleOutput,
                crate::error::PutRuleError,
                crate::input::PutRuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule that you are creating or updating.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the rule that you are creating or updating.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_expression(input.into());
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)".</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_expression(input);
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn state(mut self, input: crate::model::RuleState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RuleState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>A description of the rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role associated with the rule.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted permission to your account through an organization instead of directly by the account ID, you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure, instead of here in this parameter.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the rule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of key-value pairs to associate with the rule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutTargets`.
    ///
    /// <p>Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.</p>
    /// <p>Targets are the resources that are invoked when a rule is triggered.</p>
    /// <p>You can configure the following as targets for Events:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-api-destinations.html">API destination</a> </p> </li>
    /// <li> <p>Amazon API Gateway REST API endpoints</p> </li>
    /// <li> <p>API Gateway</p> </li>
    /// <li> <p>Batch job queue</p> </li>
    /// <li> <p>CloudWatch Logs group</p> </li>
    /// <li> <p>CodeBuild project</p> </li>
    /// <li> <p>CodePipeline</p> </li>
    /// <li> <p>Amazon EC2 <code>CreateSnapshot</code> API call</p> </li>
    /// <li> <p>Amazon EC2 <code>RebootInstances</code> API call</p> </li>
    /// <li> <p>Amazon EC2 <code>StopInstances</code> API call</p> </li>
    /// <li> <p>Amazon EC2 <code>TerminateInstances</code> API call</p> </li>
    /// <li> <p>Amazon ECS tasks</p> </li>
    /// <li> <p>Event bus in a different Amazon Web Services account or Region.</p> <p>You can use an event bus in the US East (N. Virginia) us-east-1, US West (Oregon) us-west-2, or Europe (Ireland) eu-west-1 Regions as a target for a rule.</p> </li>
    /// <li> <p>Firehose delivery stream (Kinesis Data Firehose)</p> </li>
    /// <li> <p>Inspector assessment template (Amazon Inspector)</p> </li>
    /// <li> <p>Kinesis stream (Kinesis Data Stream)</p> </li>
    /// <li> <p>Lambda function</p> </li>
    /// <li> <p>Redshift clusters (Data API statement execution)</p> </li>
    /// <li> <p>Amazon SNS topic</p> </li>
    /// <li> <p>Amazon SQS queues (includes FIFO queues</p> </li>
    /// <li> <p>SSM Automation</p> </li>
    /// <li> <p>SSM OpsItem</p> </li>
    /// <li> <p>SSM Run Command</p> </li>
    /// <li> <p>Step Functions state machines</p> </li>
    /// </ul>
    /// <p>Creating rules with built-in targets is supported only in the Management Console. The built-in targets are <code>EC2 CreateSnapshot API call</code>, <code>EC2 RebootInstances API call</code>, <code>EC2 StopInstances API call</code>, and <code>EC2 TerminateInstances API call</code>. </p>
    /// <p>For some target types, <code>PutTargets</code> provides target-specific parameters. If the target is a Kinesis data stream, you can optionally specify which shard the event goes to by using the <code>KinesisParameters</code> argument. To invoke a command on multiple EC2 instances with one rule, you can use the <code>RunCommandParameters</code> field.</p>
    /// <p>To be able to make API calls against the resources that you own, Amazon EventBridge needs the appropriate permissions. For Lambda and Amazon SNS resources, EventBridge relies on resource-based policies. For EC2 instances, Kinesis Data Streams, Step Functions state machines and API Gateway REST APIs, EventBridge relies on IAM roles that you specify in the <code>RoleARN</code> argument in <code>PutTargets</code>. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/auth-and-access-control-eventbridge.html">Authentication and Access Control</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    /// <p>If another Amazon Web Services account is in the same region and has granted you permission (using <code>PutPermission</code>), you can send events to that account. Set that account's event bus as a target of the rules in your account. To send the matched events to the other account, specify that account's event bus as the <code>Arn</code> value when you run <code>PutTargets</code>. If your account sends events to another account, your account is charged for each sent event. Each event sent to another account is charged as a custom event. The account receiving the event is not charged. For more information, see <a href="http://aws.amazon.com/eventbridge/pricing/">Amazon EventBridge Pricing</a>.</p> <note>
    /// <p> <code>Input</code>, <code>InputPath</code>, and <code>InputTransformer</code> are not available with <code>PutTarget</code> if the target is an event bus of a different Amazon Web Services account.</p>
    /// </note>
    /// <p>If you are setting the event bus of another account as the target, and that account granted permission to your account through an organization instead of directly by the account ID, then you must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    /// <p>For more information about enabling cross-account events, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutPermission.html">PutPermission</a>.</p>
    /// <p> <b>Input</b>, <b>InputPath</b>, and <b>InputTransformer</b> are mutually exclusive and optional parameters of a target. When a rule is triggered due to a matched event:</p>
    /// <ul>
    /// <li> <p>If none of the following arguments are specified for a target, then the entire event is passed to the target in JSON format (unless the target is Amazon EC2 Run Command or Amazon ECS task, in which case nothing from the event is passed to the target).</p> </li>
    /// <li> <p>If <b>Input</b> is specified in the form of valid JSON, then the matched event is overridden with this constant.</p> </li>
    /// <li> <p>If <b>InputPath</b> is specified in the form of JSONPath (for example, <code>$.detail</code>), then only the part of the event specified in the path is passed to the target (for example, only the detail part of the event is passed).</p> </li>
    /// <li> <p>If <b>InputTransformer</b> is specified, then one or more specified JSONPaths are extracted from the event and used as values in a template that you specify as the input to the target.</p> </li>
    /// </ul>
    /// <p>When you specify <code>InputPath</code> or <code>InputTransformer</code>, you must use JSON dot notation, not bracket notation.</p>
    /// <p>When you add targets to a rule and the associated rule triggers soon after, new or updated targets might not be immediately invoked. Allow a short period of time for changes to take effect.</p>
    /// <p>This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_targets_input::Builder,
    }
    impl<C, M, R> PutTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutTargetsInputOperationOutputAlias,
                crate::output::PutTargetsOutput,
                crate::error::PutTargetsError,
                crate::input::PutTargetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// Appends an item to `Targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The targets to update or add to the rule.</p>
        pub fn targets(mut self, input: crate::model::Target) -> Self {
            self.inner = self.inner.targets(input);
            self
        }
        /// <p>The targets to update or add to the rule.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Target>>,
        ) -> Self {
            self.inner = self.inner.set_targets(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemovePermission`.
    ///
    /// <p>Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the <code>StatementId</code> value that you associated with the account when you granted it permission with <code>PutPermission</code>. You can find the <code>StatementId</code> by using <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_DescribeEventBus.html">DescribeEventBus</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemovePermission<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_permission_input::Builder,
    }
    impl<C, M, R> RemovePermission<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemovePermission`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemovePermissionOutput,
            aws_smithy_http::result::SdkError<crate::error::RemovePermissionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemovePermissionInputOperationOutputAlias,
                crate::output::RemovePermissionOutput,
                crate::error::RemovePermissionError,
                crate::input::RemovePermissionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.</p>
        pub fn statement_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.statement_id(input.into());
            self
        }
        /// <p>The statement ID corresponding to the account that is no longer allowed to put events to the default event bus.</p>
        pub fn set_statement_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_statement_id(input);
            self
        }
        /// <p>Specifies whether to remove all permissions.</p>
        pub fn remove_all_permissions(mut self, input: bool) -> Self {
            self.inner = self.inner.remove_all_permissions(input);
            self
        }
        /// <p>Specifies whether to remove all permissions.</p>
        pub fn set_remove_all_permissions(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_remove_all_permissions(input);
            self
        }
        /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name of the event bus to revoke permissions for. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTargets`.
    ///
    /// <p>Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be invoked.</p>
    /// <p>When you remove a target, when the associated rule triggers, removed targets might continue to be invoked. Allow a short period of time for changes to take effect.</p>
    /// <p>This action can partially fail if too many requests are made at the same time. If that happens, <code>FailedEntryCount</code> is non-zero in the response and each entry in <code>FailedEntries</code> provides the ID of the failed target and the error code.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveTargets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_targets_input::Builder,
    }
    impl<C, M, R> RemoveTargets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTargets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTargetsOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTargetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTargetsInputOperationOutputAlias,
                crate::output::RemoveTargetsOutput,
                crate::error::RemoveTargetsError,
                crate::input::RemoveTargetsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the rule.</p>
        pub fn rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.rule(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_rule(input);
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_bus_name(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_bus_name(input);
            self
        }
        /// Appends an item to `Ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>The IDs of the targets to remove from the rule.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>The IDs of the targets to remove from the rule.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>If this is a managed rule, created by an Amazon Web Services service on your behalf, you must specify <code>Force</code> as <code>True</code> to remove targets. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using <code>DescribeRule</code> or <code>ListRules</code> and checking the <code>ManagedBy</code> field of the response.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplay`.
    ///
    /// <p>Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an <code>EventStartTime</code> and an <code>EventEndTime</code> that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use <code>DescribeReplay</code> to determine the progress of a replay. The value returned for <code>EventLastReplayedTime</code> indicates the time within the specified time range associated with the last event replayed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartReplay<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_replay_input::Builder,
    }
    impl<C, M, R> StartReplay<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartReplay`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplayOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplayError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartReplayInputOperationOutputAlias,
                crate::output::StartReplayOutput,
                crate::error::StartReplayError,
                crate::input::StartReplayInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replay to start.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replay_name(input.into());
            self
        }
        /// <p>The name of the replay to start.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_replay_name(input);
            self
        }
        /// <p>A description for the replay to start.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the replay to start.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the archive to replay events from.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_source_arn(input.into());
            self
        }
        /// <p>The ARN of the archive to replay events from.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_source_arn(input);
            self
        }
        /// <p>A time stamp for the time to start replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn event_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.event_start_time(input);
            self
        }
        /// <p>A time stamp for the time to start replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn set_event_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_event_start_time(input);
            self
        }
        /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn event_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.event_end_time(input);
            self
        }
        /// <p>A time stamp for the time to stop replaying events. Only events that occurred between the <code>EventStartTime</code> and <code>EventEndTime</code> are replayed.</p>
        pub fn set_event_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_event_end_time(input);
            self
        }
        /// <p>A <code>ReplayDestination</code> object that includes details about the destination for the replay.</p>
        pub fn destination(mut self, input: crate::model::ReplayDestination) -> Self {
            self.inner = self.inner.destination(input);
            self
        }
        /// <p>A <code>ReplayDestination</code> object that includes details about the destination for the replay.</p>
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::ReplayDestination>,
        ) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.</p>
    /// <p>Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p>
    /// <p>You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The list of key-value pairs to associate with the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestEventPattern`.
    ///
    /// <p>Tests whether the specified event pattern matches the provided event.</p>
    /// <p>Most services in Amazon Web Services treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestEventPattern<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_event_pattern_input::Builder,
    }
    impl<C, M, R> TestEventPattern<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestEventPattern`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestEventPatternOutput,
            aws_smithy_http::result::SdkError<crate::error::TestEventPatternError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestEventPatternInputOperationOutputAlias,
                crate::output::TestEventPatternOutput,
                crate::error::TestEventPatternError,
                crate::input::TestEventPatternInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>The event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following fields are mandatory:</p>
        /// <ul>
        /// <li> <p> <code>id</code> </p> </li>
        /// <li> <p> <code>account</code> </p> </li>
        /// <li> <p> <code>source</code> </p> </li>
        /// <li> <p> <code>time</code> </p> </li>
        /// <li> <p> <code>region</code> </p> </li>
        /// <li> <p> <code>resources</code> </p> </li>
        /// <li> <p> <code>detail-type</code> </p> </li>
        /// </ul>
        pub fn event(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event(input.into());
            self
        }
        /// <p>The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/aws-events.html">Amazon Web Services Events</a>, and the following fields are mandatory:</p>
        /// <ul>
        /// <li> <p> <code>id</code> </p> </li>
        /// <li> <p> <code>account</code> </p> </li>
        /// <li> <p> <code>source</code> </p> </li>
        /// <li> <p> <code>time</code> </p> </li>
        /// <li> <p> <code>region</code> </p> </li>
        /// <li> <p> <code>resources</code> </p> </li>
        /// <li> <p> <code>detail-type</code> </p> </li>
        /// </ul>
        pub fn set_event(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_event(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events), rules and event buses can be tagged.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the EventBridge resource from which you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateApiDestination`.
    ///
    /// <p>Updates an API destination.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateApiDestination<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_api_destination_input::Builder,
    }
    impl<C, M, R> UpdateApiDestination<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateApiDestination`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateApiDestinationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateApiDestinationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateApiDestinationInputOperationOutputAlias,
                crate::output::UpdateApiDestinationOutput,
                crate::error::UpdateApiDestinationError,
                crate::input::UpdateApiDestinationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the API destination to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The name of the API destination to update.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The ARN of the connection to use for the API destination.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_arn(input.into());
            self
        }
        /// <p>The ARN of the connection to use for the API destination.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_arn(input);
            self
        }
        /// <p>The URL to the endpoint to use for the API destination.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invocation_endpoint(input.into());
            self
        }
        /// <p>The URL to the endpoint to use for the API destination.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invocation_endpoint(input);
            self
        }
        /// <p>The method to use for the API destination.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.inner = self.inner.http_method(input);
            self
        }
        /// <p>The method to use for the API destination.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.inner = self.inner.set_http_method(input);
            self
        }
        /// <p>The maximum number of invocations per second to send to the API destination.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.inner = self.inner.invocation_rate_limit_per_second(input);
            self
        }
        /// <p>The maximum number of invocations per second to send to the API destination.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_invocation_rate_limit_per_second(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateArchive`.
    ///
    /// <p>Updates the specified archive.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateArchive<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_archive_input::Builder,
    }
    impl<C, M, R> UpdateArchive<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateArchive`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateArchiveOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateArchiveError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateArchiveInputOperationOutputAlias,
                crate::output::UpdateArchiveOutput,
                crate::error::UpdateArchiveError,
                crate::input::UpdateArchiveInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the archive to update.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.archive_name(input.into());
            self
        }
        /// <p>The name of the archive to update.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_archive_name(input);
            self
        }
        /// <p>The description for the archive.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the archive.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The event pattern to use to filter events sent to the archive.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_pattern(input.into());
            self
        }
        /// <p>The event pattern to use to filter events sent to the archive.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_event_pattern(input);
            self
        }
        /// <p>The number of days to retain events in the archive.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_days(input);
            self
        }
        /// <p>The number of days to retain events in the archive.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_days(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateConnection`.
    ///
    /// <p>Updates settings for a connection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_connection_input::Builder,
    }
    impl<C, M, R> UpdateConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateConnectionInputOperationOutputAlias,
                crate::output::UpdateConnectionOutput,
                crate::error::UpdateConnectionError,
                crate::input::UpdateConnectionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the connection to update.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the connection to update.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>A description for the connection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the connection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.inner = self.inner.authorization_type(input);
            self
        }
        /// <p>The type of authorization to use for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.inner = self.inner.set_authorization_type(input);
            self
        }
        /// <p>The authorization parameters to use for the connection.</p>
        pub fn auth_parameters(
            mut self,
            input: crate::model::UpdateConnectionAuthRequestParameters,
        ) -> Self {
            self.inner = self.inner.auth_parameters(input);
            self
        }
        /// <p>The authorization parameters to use for the connection.</p>
        pub fn set_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::UpdateConnectionAuthRequestParameters>,
        ) -> Self {
            self.inner = self.inner.set_auth_parameters(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
