// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionState {
    #[allow(missing_docs)] // documentation missing in model
    Authorized,
    #[allow(missing_docs)] // documentation missing in model
    Authorizing,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deauthorized,
    #[allow(missing_docs)] // documentation missing in model
    Deauthorizing,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionState {
    fn from(s: &str) -> Self {
        match s {
            "AUTHORIZED" => ConnectionState::Authorized,
            "AUTHORIZING" => ConnectionState::Authorizing,
            "CREATING" => ConnectionState::Creating,
            "DEAUTHORIZED" => ConnectionState::Deauthorized,
            "DEAUTHORIZING" => ConnectionState::Deauthorizing,
            "DELETING" => ConnectionState::Deleting,
            "UPDATING" => ConnectionState::Updating,
            other => ConnectionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionState::from(s))
    }
}
impl ConnectionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionState::Authorized => "AUTHORIZED",
            ConnectionState::Authorizing => "AUTHORIZING",
            ConnectionState::Creating => "CREATING",
            ConnectionState::Deauthorized => "DEAUTHORIZED",
            ConnectionState::Deauthorizing => "DEAUTHORIZING",
            ConnectionState::Deleting => "DELETING",
            ConnectionState::Updating => "UPDATING",
            ConnectionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTHORIZED",
            "AUTHORIZING",
            "CREATING",
            "DEAUTHORIZED",
            "DEAUTHORIZING",
            "DELETING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ConnectionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the additional parameters to use for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionAuthRequestParameters {
    /// <p>A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the
    /// authorization parameters for Basic authorization.</p>
    pub basic_auth_parameters:
        std::option::Option<crate::model::UpdateConnectionBasicAuthRequestParameters>,
    /// <p>A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the
    /// authorization parameters for OAuth authorization.</p>
    pub o_auth_parameters:
        std::option::Option<crate::model::UpdateConnectionOAuthRequestParameters>,
    /// <p>A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the
    /// authorization parameters for API key authorization.</p>
    pub api_key_auth_parameters:
        std::option::Option<crate::model::UpdateConnectionApiKeyAuthRequestParameters>,
    /// <p>A <code>ConnectionHttpParameters</code> object that contains the additional parameters to
    /// use for the connection.</p>
    pub invocation_http_parameters: std::option::Option<crate::model::ConnectionHttpParameters>,
}
impl std::fmt::Debug for UpdateConnectionAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionAuthRequestParameters");
        formatter.field("basic_auth_parameters", &self.basic_auth_parameters);
        formatter.field("o_auth_parameters", &self.o_auth_parameters);
        formatter.field("api_key_auth_parameters", &self.api_key_auth_parameters);
        formatter.field(
            "invocation_http_parameters",
            &self.invocation_http_parameters,
        );
        formatter.finish()
    }
}
/// See [`UpdateConnectionAuthRequestParameters`](crate::model::UpdateConnectionAuthRequestParameters)
pub mod update_connection_auth_request_parameters {
    /// A builder for [`UpdateConnectionAuthRequestParameters`](crate::model::UpdateConnectionAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) basic_auth_parameters:
            std::option::Option<crate::model::UpdateConnectionBasicAuthRequestParameters>,
        pub(crate) o_auth_parameters:
            std::option::Option<crate::model::UpdateConnectionOAuthRequestParameters>,
        pub(crate) api_key_auth_parameters:
            std::option::Option<crate::model::UpdateConnectionApiKeyAuthRequestParameters>,
        pub(crate) invocation_http_parameters:
            std::option::Option<crate::model::ConnectionHttpParameters>,
    }
    impl Builder {
        /// <p>A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the
        /// authorization parameters for Basic authorization.</p>
        pub fn basic_auth_parameters(
            mut self,
            input: crate::model::UpdateConnectionBasicAuthRequestParameters,
        ) -> Self {
            self.basic_auth_parameters = Some(input);
            self
        }
        /// <p>A <code>UpdateConnectionBasicAuthRequestParameters</code> object that contains the
        /// authorization parameters for Basic authorization.</p>
        pub fn set_basic_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::UpdateConnectionBasicAuthRequestParameters>,
        ) -> Self {
            self.basic_auth_parameters = input;
            self
        }
        /// <p>A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the
        /// authorization parameters for OAuth authorization.</p>
        pub fn o_auth_parameters(
            mut self,
            input: crate::model::UpdateConnectionOAuthRequestParameters,
        ) -> Self {
            self.o_auth_parameters = Some(input);
            self
        }
        /// <p>A <code>UpdateConnectionOAuthRequestParameters</code> object that contains the
        /// authorization parameters for OAuth authorization.</p>
        pub fn set_o_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::UpdateConnectionOAuthRequestParameters>,
        ) -> Self {
            self.o_auth_parameters = input;
            self
        }
        /// <p>A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the
        /// authorization parameters for API key authorization.</p>
        pub fn api_key_auth_parameters(
            mut self,
            input: crate::model::UpdateConnectionApiKeyAuthRequestParameters,
        ) -> Self {
            self.api_key_auth_parameters = Some(input);
            self
        }
        /// <p>A <code>UpdateConnectionApiKeyAuthRequestParameters</code> object that contains the
        /// authorization parameters for API key authorization.</p>
        pub fn set_api_key_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::UpdateConnectionApiKeyAuthRequestParameters>,
        ) -> Self {
            self.api_key_auth_parameters = input;
            self
        }
        /// <p>A <code>ConnectionHttpParameters</code> object that contains the additional parameters to
        /// use for the connection.</p>
        pub fn invocation_http_parameters(
            mut self,
            input: crate::model::ConnectionHttpParameters,
        ) -> Self {
            self.invocation_http_parameters = Some(input);
            self
        }
        /// <p>A <code>ConnectionHttpParameters</code> object that contains the additional parameters to
        /// use for the connection.</p>
        pub fn set_invocation_http_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionHttpParameters>,
        ) -> Self {
            self.invocation_http_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionAuthRequestParameters`](crate::model::UpdateConnectionAuthRequestParameters)
        pub fn build(self) -> crate::model::UpdateConnectionAuthRequestParameters {
            crate::model::UpdateConnectionAuthRequestParameters {
                basic_auth_parameters: self.basic_auth_parameters,
                o_auth_parameters: self.o_auth_parameters,
                api_key_auth_parameters: self.api_key_auth_parameters,
                invocation_http_parameters: self.invocation_http_parameters,
            }
        }
    }
}
impl UpdateConnectionAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionAuthRequestParameters`](crate::model::UpdateConnectionAuthRequestParameters)
    pub fn builder() -> crate::model::update_connection_auth_request_parameters::Builder {
        crate::model::update_connection_auth_request_parameters::Builder::default()
    }
}

/// <p>Contains additional parameters for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionHttpParameters {
    /// <p>Contains additional header parameters for the connection.</p>
    pub header_parameters:
        std::option::Option<std::vec::Vec<crate::model::ConnectionHeaderParameter>>,
    /// <p>Contains additional query string parameters for the connection.</p>
    pub query_string_parameters:
        std::option::Option<std::vec::Vec<crate::model::ConnectionQueryStringParameter>>,
    /// <p>Contains additional body string parameters for the connection.</p>
    pub body_parameters: std::option::Option<std::vec::Vec<crate::model::ConnectionBodyParameter>>,
}
impl std::fmt::Debug for ConnectionHttpParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionHttpParameters");
        formatter.field("header_parameters", &self.header_parameters);
        formatter.field("query_string_parameters", &self.query_string_parameters);
        formatter.field("body_parameters", &self.body_parameters);
        formatter.finish()
    }
}
/// See [`ConnectionHttpParameters`](crate::model::ConnectionHttpParameters)
pub mod connection_http_parameters {
    /// A builder for [`ConnectionHttpParameters`](crate::model::ConnectionHttpParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header_parameters:
            std::option::Option<std::vec::Vec<crate::model::ConnectionHeaderParameter>>,
        pub(crate) query_string_parameters:
            std::option::Option<std::vec::Vec<crate::model::ConnectionQueryStringParameter>>,
        pub(crate) body_parameters:
            std::option::Option<std::vec::Vec<crate::model::ConnectionBodyParameter>>,
    }
    impl Builder {
        /// Appends an item to `header_parameters`.
        ///
        /// To override the contents of this collection use [`set_header_parameters`](Self::set_header_parameters).
        ///
        /// <p>Contains additional header parameters for the connection.</p>
        pub fn header_parameters(
            mut self,
            input: impl Into<crate::model::ConnectionHeaderParameter>,
        ) -> Self {
            let mut v = self.header_parameters.unwrap_or_default();
            v.push(input.into());
            self.header_parameters = Some(v);
            self
        }
        /// <p>Contains additional header parameters for the connection.</p>
        pub fn set_header_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectionHeaderParameter>>,
        ) -> Self {
            self.header_parameters = input;
            self
        }
        /// Appends an item to `query_string_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_string_parameters`](Self::set_query_string_parameters).
        ///
        /// <p>Contains additional query string parameters for the connection.</p>
        pub fn query_string_parameters(
            mut self,
            input: impl Into<crate::model::ConnectionQueryStringParameter>,
        ) -> Self {
            let mut v = self.query_string_parameters.unwrap_or_default();
            v.push(input.into());
            self.query_string_parameters = Some(v);
            self
        }
        /// <p>Contains additional query string parameters for the connection.</p>
        pub fn set_query_string_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectionQueryStringParameter>>,
        ) -> Self {
            self.query_string_parameters = input;
            self
        }
        /// Appends an item to `body_parameters`.
        ///
        /// To override the contents of this collection use [`set_body_parameters`](Self::set_body_parameters).
        ///
        /// <p>Contains additional body string parameters for the connection.</p>
        pub fn body_parameters(
            mut self,
            input: impl Into<crate::model::ConnectionBodyParameter>,
        ) -> Self {
            let mut v = self.body_parameters.unwrap_or_default();
            v.push(input.into());
            self.body_parameters = Some(v);
            self
        }
        /// <p>Contains additional body string parameters for the connection.</p>
        pub fn set_body_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectionBodyParameter>>,
        ) -> Self {
            self.body_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionHttpParameters`](crate::model::ConnectionHttpParameters)
        pub fn build(self) -> crate::model::ConnectionHttpParameters {
            crate::model::ConnectionHttpParameters {
                header_parameters: self.header_parameters,
                query_string_parameters: self.query_string_parameters,
                body_parameters: self.body_parameters,
            }
        }
    }
}
impl ConnectionHttpParameters {
    /// Creates a new builder-style object to manufacture [`ConnectionHttpParameters`](crate::model::ConnectionHttpParameters)
    pub fn builder() -> crate::model::connection_http_parameters::Builder {
        crate::model::connection_http_parameters::Builder::default()
    }
}

/// <p>Additional parameter included in the body. You can include up to 100 additional body
/// parameters per request. An event payload cannot exceed 64 KB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionBodyParameter {
    /// <p>The key for the parameter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value associated with the key.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Specified whether the value is secret.</p>
    pub is_value_secret: bool,
}
impl std::fmt::Debug for ConnectionBodyParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionBodyParameter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("is_value_secret", &self.is_value_secret);
        formatter.finish()
    }
}
/// See [`ConnectionBodyParameter`](crate::model::ConnectionBodyParameter)
pub mod connection_body_parameter {
    /// A builder for [`ConnectionBodyParameter`](crate::model::ConnectionBodyParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) is_value_secret: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The key for the parameter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the parameter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value associated with the key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value associated with the key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Specified whether the value is secret.</p>
        pub fn is_value_secret(mut self, input: bool) -> Self {
            self.is_value_secret = Some(input);
            self
        }
        /// <p>Specified whether the value is secret.</p>
        pub fn set_is_value_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.is_value_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionBodyParameter`](crate::model::ConnectionBodyParameter)
        pub fn build(self) -> crate::model::ConnectionBodyParameter {
            crate::model::ConnectionBodyParameter {
                key: self.key,
                value: self.value,
                is_value_secret: self.is_value_secret.unwrap_or_default(),
            }
        }
    }
}
impl ConnectionBodyParameter {
    /// Creates a new builder-style object to manufacture [`ConnectionBodyParameter`](crate::model::ConnectionBodyParameter)
    pub fn builder() -> crate::model::connection_body_parameter::Builder {
        crate::model::connection_body_parameter::Builder::default()
    }
}

/// <p>Additional query string parameter for the connection. You can include up to 100 additional
/// query string parameters per request. Each additional parameter counts towards the event
/// payload size, which cannot exceed 64 KB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionQueryStringParameter {
    /// <p>The key for a query string parameter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value associated with the key for the query string parameter.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Specifies whether the value is secret.</p>
    pub is_value_secret: bool,
}
impl std::fmt::Debug for ConnectionQueryStringParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionQueryStringParameter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("is_value_secret", &self.is_value_secret);
        formatter.finish()
    }
}
/// See [`ConnectionQueryStringParameter`](crate::model::ConnectionQueryStringParameter)
pub mod connection_query_string_parameter {
    /// A builder for [`ConnectionQueryStringParameter`](crate::model::ConnectionQueryStringParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) is_value_secret: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The key for a query string parameter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for a query string parameter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value associated with the key for the query string parameter.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value associated with the key for the query string parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Specifies whether the value is secret.</p>
        pub fn is_value_secret(mut self, input: bool) -> Self {
            self.is_value_secret = Some(input);
            self
        }
        /// <p>Specifies whether the value is secret.</p>
        pub fn set_is_value_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.is_value_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionQueryStringParameter`](crate::model::ConnectionQueryStringParameter)
        pub fn build(self) -> crate::model::ConnectionQueryStringParameter {
            crate::model::ConnectionQueryStringParameter {
                key: self.key,
                value: self.value,
                is_value_secret: self.is_value_secret.unwrap_or_default(),
            }
        }
    }
}
impl ConnectionQueryStringParameter {
    /// Creates a new builder-style object to manufacture [`ConnectionQueryStringParameter`](crate::model::ConnectionQueryStringParameter)
    pub fn builder() -> crate::model::connection_query_string_parameter::Builder {
        crate::model::connection_query_string_parameter::Builder::default()
    }
}

/// <p>Additional parameter included in the header. You can include up to 100 additional header
/// parameters per request. An event payload cannot exceed 64 KB.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionHeaderParameter {
    /// <p>The key for the parameter.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value associated with the key.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>Specified whether the value is a secret.</p>
    pub is_value_secret: bool,
}
impl std::fmt::Debug for ConnectionHeaderParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionHeaderParameter");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("is_value_secret", &self.is_value_secret);
        formatter.finish()
    }
}
/// See [`ConnectionHeaderParameter`](crate::model::ConnectionHeaderParameter)
pub mod connection_header_parameter {
    /// A builder for [`ConnectionHeaderParameter`](crate::model::ConnectionHeaderParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) is_value_secret: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The key for the parameter.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the parameter.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value associated with the key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value associated with the key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>Specified whether the value is a secret.</p>
        pub fn is_value_secret(mut self, input: bool) -> Self {
            self.is_value_secret = Some(input);
            self
        }
        /// <p>Specified whether the value is a secret.</p>
        pub fn set_is_value_secret(mut self, input: std::option::Option<bool>) -> Self {
            self.is_value_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionHeaderParameter`](crate::model::ConnectionHeaderParameter)
        pub fn build(self) -> crate::model::ConnectionHeaderParameter {
            crate::model::ConnectionHeaderParameter {
                key: self.key,
                value: self.value,
                is_value_secret: self.is_value_secret.unwrap_or_default(),
            }
        }
    }
}
impl ConnectionHeaderParameter {
    /// Creates a new builder-style object to manufacture [`ConnectionHeaderParameter`](crate::model::ConnectionHeaderParameter)
    pub fn builder() -> crate::model::connection_header_parameter::Builder {
        crate::model::connection_header_parameter::Builder::default()
    }
}

/// <p>Contains the API key authorization parameters to use to update the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionApiKeyAuthRequestParameters {
    /// <p>The name of the API key to use for authorization.</p>
    pub api_key_name: std::option::Option<std::string::String>,
    /// <p>The value associated with teh API key to use for authorization.</p>
    pub api_key_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectionApiKeyAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionApiKeyAuthRequestParameters");
        formatter.field("api_key_name", &self.api_key_name);
        formatter.field("api_key_value", &self.api_key_value);
        formatter.finish()
    }
}
/// See [`UpdateConnectionApiKeyAuthRequestParameters`](crate::model::UpdateConnectionApiKeyAuthRequestParameters)
pub mod update_connection_api_key_auth_request_parameters {
    /// A builder for [`UpdateConnectionApiKeyAuthRequestParameters`](crate::model::UpdateConnectionApiKeyAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key_name: std::option::Option<std::string::String>,
        pub(crate) api_key_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the API key to use for authorization.</p>
        pub fn api_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key_name = Some(input.into());
            self
        }
        /// <p>The name of the API key to use for authorization.</p>
        pub fn set_api_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key_name = input;
            self
        }
        /// <p>The value associated with teh API key to use for authorization.</p>
        pub fn api_key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key_value = Some(input.into());
            self
        }
        /// <p>The value associated with teh API key to use for authorization.</p>
        pub fn set_api_key_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_value = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionApiKeyAuthRequestParameters`](crate::model::UpdateConnectionApiKeyAuthRequestParameters)
        pub fn build(self) -> crate::model::UpdateConnectionApiKeyAuthRequestParameters {
            crate::model::UpdateConnectionApiKeyAuthRequestParameters {
                api_key_name: self.api_key_name,
                api_key_value: self.api_key_value,
            }
        }
    }
}
impl UpdateConnectionApiKeyAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionApiKeyAuthRequestParameters`](crate::model::UpdateConnectionApiKeyAuthRequestParameters)
    pub fn builder() -> crate::model::update_connection_api_key_auth_request_parameters::Builder {
        crate::model::update_connection_api_key_auth_request_parameters::Builder::default()
    }
}

/// <p>Contains the OAuth request parameters to use for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionOAuthRequestParameters {
    /// <p>A <code>UpdateConnectionOAuthClientRequestParameters</code> object that contains the
    /// client parameters to use for the connection when OAuth is specified as the authorization
    /// type.</p>
    pub client_parameters:
        std::option::Option<crate::model::UpdateConnectionOAuthClientRequestParameters>,
    /// <p>The URL to the authorization endpoint when OAuth is specified as the authorization
    /// type.</p>
    pub authorization_endpoint: std::option::Option<std::string::String>,
    /// <p>The method used to connect to the HTTP endpoint.</p>
    pub http_method: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
    /// <p>The additional HTTP parameters used for the OAuth authorization request.</p>
    pub o_auth_http_parameters: std::option::Option<crate::model::ConnectionHttpParameters>,
}
impl std::fmt::Debug for UpdateConnectionOAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionOAuthRequestParameters");
        formatter.field("client_parameters", &self.client_parameters);
        formatter.field("authorization_endpoint", &self.authorization_endpoint);
        formatter.field("http_method", &self.http_method);
        formatter.field("o_auth_http_parameters", &self.o_auth_http_parameters);
        formatter.finish()
    }
}
/// See [`UpdateConnectionOAuthRequestParameters`](crate::model::UpdateConnectionOAuthRequestParameters)
pub mod update_connection_o_auth_request_parameters {
    /// A builder for [`UpdateConnectionOAuthRequestParameters`](crate::model::UpdateConnectionOAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_parameters:
            std::option::Option<crate::model::UpdateConnectionOAuthClientRequestParameters>,
        pub(crate) authorization_endpoint: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
        pub(crate) o_auth_http_parameters:
            std::option::Option<crate::model::ConnectionHttpParameters>,
    }
    impl Builder {
        /// <p>A <code>UpdateConnectionOAuthClientRequestParameters</code> object that contains the
        /// client parameters to use for the connection when OAuth is specified as the authorization
        /// type.</p>
        pub fn client_parameters(
            mut self,
            input: crate::model::UpdateConnectionOAuthClientRequestParameters,
        ) -> Self {
            self.client_parameters = Some(input);
            self
        }
        /// <p>A <code>UpdateConnectionOAuthClientRequestParameters</code> object that contains the
        /// client parameters to use for the connection when OAuth is specified as the authorization
        /// type.</p>
        pub fn set_client_parameters(
            mut self,
            input: std::option::Option<crate::model::UpdateConnectionOAuthClientRequestParameters>,
        ) -> Self {
            self.client_parameters = input;
            self
        }
        /// <p>The URL to the authorization endpoint when OAuth is specified as the authorization
        /// type.</p>
        pub fn authorization_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_endpoint = Some(input.into());
            self
        }
        /// <p>The URL to the authorization endpoint when OAuth is specified as the authorization
        /// type.</p>
        pub fn set_authorization_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_endpoint = input;
            self
        }
        /// <p>The method used to connect to the HTTP endpoint.</p>
        pub fn http_method(mut self, input: crate::model::ConnectionOAuthHttpMethod) -> Self {
            self.http_method = Some(input);
            self
        }
        /// <p>The method used to connect to the HTTP endpoint.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
        ) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The additional HTTP parameters used for the OAuth authorization request.</p>
        pub fn o_auth_http_parameters(
            mut self,
            input: crate::model::ConnectionHttpParameters,
        ) -> Self {
            self.o_auth_http_parameters = Some(input);
            self
        }
        /// <p>The additional HTTP parameters used for the OAuth authorization request.</p>
        pub fn set_o_auth_http_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionHttpParameters>,
        ) -> Self {
            self.o_auth_http_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionOAuthRequestParameters`](crate::model::UpdateConnectionOAuthRequestParameters)
        pub fn build(self) -> crate::model::UpdateConnectionOAuthRequestParameters {
            crate::model::UpdateConnectionOAuthRequestParameters {
                client_parameters: self.client_parameters,
                authorization_endpoint: self.authorization_endpoint,
                http_method: self.http_method,
                o_auth_http_parameters: self.o_auth_http_parameters,
            }
        }
    }
}
impl UpdateConnectionOAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionOAuthRequestParameters`](crate::model::UpdateConnectionOAuthRequestParameters)
    pub fn builder() -> crate::model::update_connection_o_auth_request_parameters::Builder {
        crate::model::update_connection_o_auth_request_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionOAuthHttpMethod {
    #[allow(missing_docs)] // documentation missing in model
    Get,
    #[allow(missing_docs)] // documentation missing in model
    Post,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionOAuthHttpMethod {
    fn from(s: &str) -> Self {
        match s {
            "GET" => ConnectionOAuthHttpMethod::Get,
            "POST" => ConnectionOAuthHttpMethod::Post,
            "PUT" => ConnectionOAuthHttpMethod::Put,
            other => ConnectionOAuthHttpMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionOAuthHttpMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionOAuthHttpMethod::from(s))
    }
}
impl ConnectionOAuthHttpMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionOAuthHttpMethod::Get => "GET",
            ConnectionOAuthHttpMethod::Post => "POST",
            ConnectionOAuthHttpMethod::Put => "PUT",
            ConnectionOAuthHttpMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GET", "POST", "PUT"]
    }
}
impl AsRef<str> for ConnectionOAuthHttpMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the OAuth authorization parameters to use for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionOAuthClientRequestParameters {
    /// <p>The client ID to use for OAuth authorization.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The client secret assciated with the client ID to use for OAuth authorization.</p>
    pub client_secret: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectionOAuthClientRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionOAuthClientRequestParameters");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &self.client_secret);
        formatter.finish()
    }
}
/// See [`UpdateConnectionOAuthClientRequestParameters`](crate::model::UpdateConnectionOAuthClientRequestParameters)
pub mod update_connection_o_auth_client_request_parameters {
    /// A builder for [`UpdateConnectionOAuthClientRequestParameters`](crate::model::UpdateConnectionOAuthClientRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The client ID to use for OAuth authorization.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID to use for OAuth authorization.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The client secret assciated with the client ID to use for OAuth authorization.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p>The client secret assciated with the client ID to use for OAuth authorization.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionOAuthClientRequestParameters`](crate::model::UpdateConnectionOAuthClientRequestParameters)
        pub fn build(self) -> crate::model::UpdateConnectionOAuthClientRequestParameters {
            crate::model::UpdateConnectionOAuthClientRequestParameters {
                client_id: self.client_id,
                client_secret: self.client_secret,
            }
        }
    }
}
impl UpdateConnectionOAuthClientRequestParameters {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionOAuthClientRequestParameters`](crate::model::UpdateConnectionOAuthClientRequestParameters)
    pub fn builder() -> crate::model::update_connection_o_auth_client_request_parameters::Builder {
        crate::model::update_connection_o_auth_client_request_parameters::Builder::default()
    }
}

/// <p>Contains the Basic authorization parameters for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateConnectionBasicAuthRequestParameters {
    /// <p>The user name to use for Basic authorization.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The password associated with the user name to use for Basic authorization.</p>
    pub password: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateConnectionBasicAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateConnectionBasicAuthRequestParameters");
        formatter.field("username", &self.username);
        formatter.field("password", &self.password);
        formatter.finish()
    }
}
/// See [`UpdateConnectionBasicAuthRequestParameters`](crate::model::UpdateConnectionBasicAuthRequestParameters)
pub mod update_connection_basic_auth_request_parameters {
    /// A builder for [`UpdateConnectionBasicAuthRequestParameters`](crate::model::UpdateConnectionBasicAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name to use for Basic authorization.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name to use for Basic authorization.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password associated with the user name to use for Basic authorization.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password associated with the user name to use for Basic authorization.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateConnectionBasicAuthRequestParameters`](crate::model::UpdateConnectionBasicAuthRequestParameters)
        pub fn build(self) -> crate::model::UpdateConnectionBasicAuthRequestParameters {
            crate::model::UpdateConnectionBasicAuthRequestParameters {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl UpdateConnectionBasicAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`UpdateConnectionBasicAuthRequestParameters`](crate::model::UpdateConnectionBasicAuthRequestParameters)
    pub fn builder() -> crate::model::update_connection_basic_auth_request_parameters::Builder {
        crate::model::update_connection_basic_auth_request_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ConnectionAuthorizationType {
    #[allow(missing_docs)] // documentation missing in model
    ApiKey,
    #[allow(missing_docs)] // documentation missing in model
    Basic,
    #[allow(missing_docs)] // documentation missing in model
    OauthClientCredentials,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ConnectionAuthorizationType {
    fn from(s: &str) -> Self {
        match s {
            "API_KEY" => ConnectionAuthorizationType::ApiKey,
            "BASIC" => ConnectionAuthorizationType::Basic,
            "OAUTH_CLIENT_CREDENTIALS" => ConnectionAuthorizationType::OauthClientCredentials,
            other => ConnectionAuthorizationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ConnectionAuthorizationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ConnectionAuthorizationType::from(s))
    }
}
impl ConnectionAuthorizationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ConnectionAuthorizationType::ApiKey => "API_KEY",
            ConnectionAuthorizationType::Basic => "BASIC",
            ConnectionAuthorizationType::OauthClientCredentials => "OAUTH_CLIENT_CREDENTIALS",
            ConnectionAuthorizationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["API_KEY", "BASIC", "OAUTH_CLIENT_CREDENTIALS"]
    }
}
impl AsRef<str> for ConnectionAuthorizationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ArchiveState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ArchiveState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => ArchiveState::CreateFailed,
            "CREATING" => ArchiveState::Creating,
            "DISABLED" => ArchiveState::Disabled,
            "ENABLED" => ArchiveState::Enabled,
            "UPDATE_FAILED" => ArchiveState::UpdateFailed,
            "UPDATING" => ArchiveState::Updating,
            other => ArchiveState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ArchiveState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ArchiveState::from(s))
    }
}
impl ArchiveState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ArchiveState::CreateFailed => "CREATE_FAILED",
            ArchiveState::Creating => "CREATING",
            ArchiveState::Disabled => "DISABLED",
            ArchiveState::Enabled => "ENABLED",
            ArchiveState::UpdateFailed => "UPDATE_FAILED",
            ArchiveState::Updating => "UPDATING",
            ArchiveState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATING",
            "DISABLED",
            "ENABLED",
            "UPDATE_FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ArchiveState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiDestinationState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiDestinationState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ApiDestinationState::Active,
            "INACTIVE" => ApiDestinationState::Inactive,
            other => ApiDestinationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiDestinationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiDestinationState::from(s))
    }
}
impl ApiDestinationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiDestinationState::Active => "ACTIVE",
            ApiDestinationState::Inactive => "INACTIVE",
            ApiDestinationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for ApiDestinationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApiDestinationHttpMethod {
    #[allow(missing_docs)] // documentation missing in model
    Delete,
    #[allow(missing_docs)] // documentation missing in model
    Get,
    #[allow(missing_docs)] // documentation missing in model
    Head,
    #[allow(missing_docs)] // documentation missing in model
    Options,
    #[allow(missing_docs)] // documentation missing in model
    Patch,
    #[allow(missing_docs)] // documentation missing in model
    Post,
    #[allow(missing_docs)] // documentation missing in model
    Put,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApiDestinationHttpMethod {
    fn from(s: &str) -> Self {
        match s {
            "DELETE" => ApiDestinationHttpMethod::Delete,
            "GET" => ApiDestinationHttpMethod::Get,
            "HEAD" => ApiDestinationHttpMethod::Head,
            "OPTIONS" => ApiDestinationHttpMethod::Options,
            "PATCH" => ApiDestinationHttpMethod::Patch,
            "POST" => ApiDestinationHttpMethod::Post,
            "PUT" => ApiDestinationHttpMethod::Put,
            other => ApiDestinationHttpMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApiDestinationHttpMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApiDestinationHttpMethod::from(s))
    }
}
impl ApiDestinationHttpMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApiDestinationHttpMethod::Delete => "DELETE",
            ApiDestinationHttpMethod::Get => "GET",
            ApiDestinationHttpMethod::Head => "HEAD",
            ApiDestinationHttpMethod::Options => "OPTIONS",
            ApiDestinationHttpMethod::Patch => "PATCH",
            ApiDestinationHttpMethod::Post => "POST",
            ApiDestinationHttpMethod::Put => "PUT",
            ApiDestinationHttpMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT"]
    }
}
impl AsRef<str> for ApiDestinationHttpMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A key-value pair associated with an Amazon Web Services resource. In EventBridge, rules and event buses
/// support tagging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A string you can use to assign a value. The combination of tag keys and values can help
    /// you organize and categorize your resources.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for the specified tag key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string you can use to assign a value. The combination of tag keys and values can help
        /// you organize and categorize your resources.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A string you can use to assign a value. The combination of tag keys and values can help
        /// you organize and categorize your resources.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for the specified tag key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the specified tag key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplayState {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplayState {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => ReplayState::Cancelled,
            "CANCELLING" => ReplayState::Cancelling,
            "COMPLETED" => ReplayState::Completed,
            "FAILED" => ReplayState::Failed,
            "RUNNING" => ReplayState::Running,
            "STARTING" => ReplayState::Starting,
            other => ReplayState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplayState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplayState::from(s))
    }
}
impl ReplayState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplayState::Cancelled => "CANCELLED",
            ReplayState::Cancelling => "CANCELLING",
            ReplayState::Completed => "COMPLETED",
            ReplayState::Failed => "FAILED",
            ReplayState::Running => "RUNNING",
            ReplayState::Starting => "STARTING",
            ReplayState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "CANCELLING",
            "COMPLETED",
            "FAILED",
            "RUNNING",
            "STARTING",
        ]
    }
}
impl AsRef<str> for ReplayState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A <code>ReplayDestination</code> object that contains details about a replay.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplayDestination {
    /// <p>The ARN of the event bus to replay event to. You can replay events only to the event bus
    /// specified to create the archive.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>A list of ARNs for rules to replay events to.</p>
    pub filter_arns: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ReplayDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplayDestination");
        formatter.field("arn", &self.arn);
        formatter.field("filter_arns", &self.filter_arns);
        formatter.finish()
    }
}
/// See [`ReplayDestination`](crate::model::ReplayDestination)
pub mod replay_destination {
    /// A builder for [`ReplayDestination`](crate::model::ReplayDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) filter_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the event bus to replay event to. You can replay events only to the event bus
        /// specified to create the archive.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus to replay event to. You can replay events only to the event bus
        /// specified to create the archive.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `filter_arns`.
        ///
        /// To override the contents of this collection use [`set_filter_arns`](Self::set_filter_arns).
        ///
        /// <p>A list of ARNs for rules to replay events to.</p>
        pub fn filter_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.filter_arns.unwrap_or_default();
            v.push(input.into());
            self.filter_arns = Some(v);
            self
        }
        /// <p>A list of ARNs for rules to replay events to.</p>
        pub fn set_filter_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.filter_arns = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplayDestination`](crate::model::ReplayDestination)
        pub fn build(self) -> crate::model::ReplayDestination {
            crate::model::ReplayDestination {
                arn: self.arn,
                filter_arns: self.filter_arns,
            }
        }
    }
}
impl ReplayDestination {
    /// Creates a new builder-style object to manufacture [`ReplayDestination`](crate::model::ReplayDestination)
    pub fn builder() -> crate::model::replay_destination::Builder {
        crate::model::replay_destination::Builder::default()
    }
}

/// <p>Represents a target that failed to be removed from a rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTargetsResultEntry {
    /// <p>The ID of the target.</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The error code that indicates why the target removal failed. If the value is
    /// <code>ConcurrentModificationException</code>, too many requests were made at the same
    /// time.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message that explains why the target removal failed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveTargetsResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTargetsResultEntry");
        formatter.field("target_id", &self.target_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`RemoveTargetsResultEntry`](crate::model::RemoveTargetsResultEntry)
pub mod remove_targets_result_entry {
    /// A builder for [`RemoveTargetsResultEntry`](crate::model::RemoveTargetsResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the target.</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The ID of the target.</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The error code that indicates why the target removal failed. If the value is
        /// <code>ConcurrentModificationException</code>, too many requests were made at the same
        /// time.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that indicates why the target removal failed. If the value is
        /// <code>ConcurrentModificationException</code>, too many requests were made at the same
        /// time.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message that explains why the target removal failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message that explains why the target removal failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTargetsResultEntry`](crate::model::RemoveTargetsResultEntry)
        pub fn build(self) -> crate::model::RemoveTargetsResultEntry {
            crate::model::RemoveTargetsResultEntry {
                target_id: self.target_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl RemoveTargetsResultEntry {
    /// Creates a new builder-style object to manufacture [`RemoveTargetsResultEntry`](crate::model::RemoveTargetsResultEntry)
    pub fn builder() -> crate::model::remove_targets_result_entry::Builder {
        crate::model::remove_targets_result_entry::Builder::default()
    }
}

/// <p>Represents a target that failed to be added to a rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutTargetsResultEntry {
    /// <p>The ID of the target.</p>
    pub target_id: std::option::Option<std::string::String>,
    /// <p>The error code that indicates why the target addition failed. If the value is
    /// <code>ConcurrentModificationException</code>, too many requests were made at the same
    /// time.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message that explains why the target addition failed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutTargetsResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutTargetsResultEntry");
        formatter.field("target_id", &self.target_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PutTargetsResultEntry`](crate::model::PutTargetsResultEntry)
pub mod put_targets_result_entry {
    /// A builder for [`PutTargetsResultEntry`](crate::model::PutTargetsResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the target.</p>
        pub fn target_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_id = Some(input.into());
            self
        }
        /// <p>The ID of the target.</p>
        pub fn set_target_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_id = input;
            self
        }
        /// <p>The error code that indicates why the target addition failed. If the value is
        /// <code>ConcurrentModificationException</code>, too many requests were made at the same
        /// time.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that indicates why the target addition failed. If the value is
        /// <code>ConcurrentModificationException</code>, too many requests were made at the same
        /// time.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message that explains why the target addition failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message that explains why the target addition failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PutTargetsResultEntry`](crate::model::PutTargetsResultEntry)
        pub fn build(self) -> crate::model::PutTargetsResultEntry {
            crate::model::PutTargetsResultEntry {
                target_id: self.target_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PutTargetsResultEntry {
    /// Creates a new builder-style object to manufacture [`PutTargetsResultEntry`](crate::model::PutTargetsResultEntry)
    pub fn builder() -> crate::model::put_targets_result_entry::Builder {
        crate::model::put_targets_result_entry::Builder::default()
    }
}

/// <p>Targets are the resources to be invoked when a rule is triggered. For a complete list of
/// services and resources that can be set as a target, see <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutTargets.html">PutTargets</a>.</p>
///
/// <p>If you are setting the event bus of another account as the target, and that account
/// granted permission to your account through an organization instead of directly by the account
/// ID, then you must specify a <code>RoleArn</code> with proper permissions in the
/// <code>Target</code> structure. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-cross-account-event-delivery.html">Sending and
/// Receiving Events Between Amazon Web Services Accounts</a> in the <i>Amazon EventBridge User
/// Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Target {
    /// <p>The ID of the target. We recommend using a memorable and unique string.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the target.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is
    /// triggered. If one rule triggers multiple targets, you can use a different IAM role for each
    /// target.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Valid JSON text passed to the target. In this case, nothing from the event itself is
    /// passed to the target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data
    /// Interchange Format</a>.</p>
    pub input: std::option::Option<std::string::String>,
    /// <p>The value of the JSONPath that is used for extracting part of the matched event when
    /// passing it to the target. You must use JSON dot notation, not bracket notation. For more
    /// information about JSON paths, see <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.</p>
    pub input_path: std::option::Option<std::string::String>,
    /// <p>Settings to enable you to provide custom input to a target based on certain event data.
    /// You can extract one or more key-value pairs from the event and then use that data to send
    /// customized input to the target.</p>
    pub input_transformer: std::option::Option<crate::model::InputTransformer>,
    /// <p>The custom parameter you can use to control the shard assignment, when the target is a
    /// Kinesis data stream. If you do not include this parameter, the default is to use the
    /// <code>eventId</code> as the partition key.</p>
    pub kinesis_parameters: std::option::Option<crate::model::KinesisParameters>,
    /// <p>Parameters used when you are using the rule to invoke Amazon EC2 Run Command.</p>
    pub run_command_parameters: std::option::Option<crate::model::RunCommandParameters>,
    /// <p>Contains the Amazon ECS task definition and task count to be used, if the event target is
    /// an Amazon ECS task. For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task
    /// Definitions </a> in the <i>Amazon EC2 Container Service Developer
    /// Guide</i>.</p>
    pub ecs_parameters: std::option::Option<crate::model::EcsParameters>,
    /// <p>If the event target is an Batch job, this contains the job definition, job name, and
    /// other parameters. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <i>Batch User
    /// Guide</i>.</p>
    pub batch_parameters: std::option::Option<crate::model::BatchParameters>,
    /// <p>Contains the message group ID to use when the target is a FIFO queue.</p>
    /// <p>If you specify an SQS FIFO queue as a target, the queue must have content-based
    /// deduplication enabled.</p>
    pub sqs_parameters: std::option::Option<crate::model::SqsParameters>,
    /// <p>Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or
    /// EventBridge ApiDestination.</p>
    /// <p>If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can
    /// use this parameter to specify headers, path parameters, and query string keys/values as part
    /// of your target invoking request. If you're using ApiDestinations, the corresponding Connection
    /// can also have these values configured. In case of any conflicting keys, values from the
    /// Connection take precedence.</p>
    pub http_parameters: std::option::Option<crate::model::HttpParameters>,
    /// <p>Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift
    /// cluster.</p>
    /// <p>If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to
    /// invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.</p>
    pub redshift_data_parameters: std::option::Option<crate::model::RedshiftDataParameters>,
    /// <p>Contains the SageMaker Model Building Pipeline parameters to start execution of a
    /// SageMaker Model Building Pipeline.</p>
    /// <p>If you specify a SageMaker Model Building Pipeline as a target, you can use this to
    /// specify parameters to start a pipeline execution based on EventBridge events.</p>
    pub sage_maker_pipeline_parameters:
        std::option::Option<crate::model::SageMakerPipelineParameters>,
    /// <p>The <code>DeadLetterConfig</code> that defines the target queue to send dead-letter queue
    /// events to.</p>
    pub dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
    /// <p>The <code>RetryPolicy</code> object that contains the retry policy configuration to use
    /// for the dead-letter queue.</p>
    pub retry_policy: std::option::Option<crate::model::RetryPolicy>,
}
impl std::fmt::Debug for Target {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Target");
        formatter.field("id", &self.id);
        formatter.field("arn", &self.arn);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("input", &self.input);
        formatter.field("input_path", &self.input_path);
        formatter.field("input_transformer", &self.input_transformer);
        formatter.field("kinesis_parameters", &self.kinesis_parameters);
        formatter.field("run_command_parameters", &self.run_command_parameters);
        formatter.field("ecs_parameters", &self.ecs_parameters);
        formatter.field("batch_parameters", &self.batch_parameters);
        formatter.field("sqs_parameters", &self.sqs_parameters);
        formatter.field("http_parameters", &self.http_parameters);
        formatter.field("redshift_data_parameters", &self.redshift_data_parameters);
        formatter.field(
            "sage_maker_pipeline_parameters",
            &self.sage_maker_pipeline_parameters,
        );
        formatter.field("dead_letter_config", &self.dead_letter_config);
        formatter.field("retry_policy", &self.retry_policy);
        formatter.finish()
    }
}
/// See [`Target`](crate::model::Target)
pub mod target {
    /// A builder for [`Target`](crate::model::Target)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) input: std::option::Option<std::string::String>,
        pub(crate) input_path: std::option::Option<std::string::String>,
        pub(crate) input_transformer: std::option::Option<crate::model::InputTransformer>,
        pub(crate) kinesis_parameters: std::option::Option<crate::model::KinesisParameters>,
        pub(crate) run_command_parameters: std::option::Option<crate::model::RunCommandParameters>,
        pub(crate) ecs_parameters: std::option::Option<crate::model::EcsParameters>,
        pub(crate) batch_parameters: std::option::Option<crate::model::BatchParameters>,
        pub(crate) sqs_parameters: std::option::Option<crate::model::SqsParameters>,
        pub(crate) http_parameters: std::option::Option<crate::model::HttpParameters>,
        pub(crate) redshift_data_parameters:
            std::option::Option<crate::model::RedshiftDataParameters>,
        pub(crate) sage_maker_pipeline_parameters:
            std::option::Option<crate::model::SageMakerPipelineParameters>,
        pub(crate) dead_letter_config: std::option::Option<crate::model::DeadLetterConfig>,
        pub(crate) retry_policy: std::option::Option<crate::model::RetryPolicy>,
    }
    impl Builder {
        /// <p>The ID of the target. We recommend using a memorable and unique string.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the target. We recommend using a memorable and unique string.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the target.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is
        /// triggered. If one rule triggers multiple targets, you can use a different IAM role for each
        /// target.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is
        /// triggered. If one rule triggers multiple targets, you can use a different IAM role for each
        /// target.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Valid JSON text passed to the target. In this case, nothing from the event itself is
        /// passed to the target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data
        /// Interchange Format</a>.</p>
        pub fn input(mut self, input: impl Into<std::string::String>) -> Self {
            self.input = Some(input.into());
            self
        }
        /// <p>Valid JSON text passed to the target. In this case, nothing from the event itself is
        /// passed to the target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data
        /// Interchange Format</a>.</p>
        pub fn set_input(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input = input;
            self
        }
        /// <p>The value of the JSONPath that is used for extracting part of the matched event when
        /// passing it to the target. You must use JSON dot notation, not bracket notation. For more
        /// information about JSON paths, see <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.</p>
        pub fn input_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_path = Some(input.into());
            self
        }
        /// <p>The value of the JSONPath that is used for extracting part of the matched event when
        /// passing it to the target. You must use JSON dot notation, not bracket notation. For more
        /// information about JSON paths, see <a href="http://goessner.net/articles/JsonPath/">JSONPath</a>.</p>
        pub fn set_input_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_path = input;
            self
        }
        /// <p>Settings to enable you to provide custom input to a target based on certain event data.
        /// You can extract one or more key-value pairs from the event and then use that data to send
        /// customized input to the target.</p>
        pub fn input_transformer(mut self, input: crate::model::InputTransformer) -> Self {
            self.input_transformer = Some(input);
            self
        }
        /// <p>Settings to enable you to provide custom input to a target based on certain event data.
        /// You can extract one or more key-value pairs from the event and then use that data to send
        /// customized input to the target.</p>
        pub fn set_input_transformer(
            mut self,
            input: std::option::Option<crate::model::InputTransformer>,
        ) -> Self {
            self.input_transformer = input;
            self
        }
        /// <p>The custom parameter you can use to control the shard assignment, when the target is a
        /// Kinesis data stream. If you do not include this parameter, the default is to use the
        /// <code>eventId</code> as the partition key.</p>
        pub fn kinesis_parameters(mut self, input: crate::model::KinesisParameters) -> Self {
            self.kinesis_parameters = Some(input);
            self
        }
        /// <p>The custom parameter you can use to control the shard assignment, when the target is a
        /// Kinesis data stream. If you do not include this parameter, the default is to use the
        /// <code>eventId</code> as the partition key.</p>
        pub fn set_kinesis_parameters(
            mut self,
            input: std::option::Option<crate::model::KinesisParameters>,
        ) -> Self {
            self.kinesis_parameters = input;
            self
        }
        /// <p>Parameters used when you are using the rule to invoke Amazon EC2 Run Command.</p>
        pub fn run_command_parameters(mut self, input: crate::model::RunCommandParameters) -> Self {
            self.run_command_parameters = Some(input);
            self
        }
        /// <p>Parameters used when you are using the rule to invoke Amazon EC2 Run Command.</p>
        pub fn set_run_command_parameters(
            mut self,
            input: std::option::Option<crate::model::RunCommandParameters>,
        ) -> Self {
            self.run_command_parameters = input;
            self
        }
        /// <p>Contains the Amazon ECS task definition and task count to be used, if the event target is
        /// an Amazon ECS task. For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task
        /// Definitions </a> in the <i>Amazon EC2 Container Service Developer
        /// Guide</i>.</p>
        pub fn ecs_parameters(mut self, input: crate::model::EcsParameters) -> Self {
            self.ecs_parameters = Some(input);
            self
        }
        /// <p>Contains the Amazon ECS task definition and task count to be used, if the event target is
        /// an Amazon ECS task. For more information about Amazon ECS tasks, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Task
        /// Definitions </a> in the <i>Amazon EC2 Container Service Developer
        /// Guide</i>.</p>
        pub fn set_ecs_parameters(
            mut self,
            input: std::option::Option<crate::model::EcsParameters>,
        ) -> Self {
            self.ecs_parameters = input;
            self
        }
        /// <p>If the event target is an Batch job, this contains the job definition, job name, and
        /// other parameters. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <i>Batch User
        /// Guide</i>.</p>
        pub fn batch_parameters(mut self, input: crate::model::BatchParameters) -> Self {
            self.batch_parameters = Some(input);
            self
        }
        /// <p>If the event target is an Batch job, this contains the job definition, job name, and
        /// other parameters. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/jobs.html">Jobs</a> in the <i>Batch User
        /// Guide</i>.</p>
        pub fn set_batch_parameters(
            mut self,
            input: std::option::Option<crate::model::BatchParameters>,
        ) -> Self {
            self.batch_parameters = input;
            self
        }
        /// <p>Contains the message group ID to use when the target is a FIFO queue.</p>
        /// <p>If you specify an SQS FIFO queue as a target, the queue must have content-based
        /// deduplication enabled.</p>
        pub fn sqs_parameters(mut self, input: crate::model::SqsParameters) -> Self {
            self.sqs_parameters = Some(input);
            self
        }
        /// <p>Contains the message group ID to use when the target is a FIFO queue.</p>
        /// <p>If you specify an SQS FIFO queue as a target, the queue must have content-based
        /// deduplication enabled.</p>
        pub fn set_sqs_parameters(
            mut self,
            input: std::option::Option<crate::model::SqsParameters>,
        ) -> Self {
            self.sqs_parameters = input;
            self
        }
        /// <p>Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or
        /// EventBridge ApiDestination.</p>
        /// <p>If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can
        /// use this parameter to specify headers, path parameters, and query string keys/values as part
        /// of your target invoking request. If you're using ApiDestinations, the corresponding Connection
        /// can also have these values configured. In case of any conflicting keys, values from the
        /// Connection take precedence.</p>
        pub fn http_parameters(mut self, input: crate::model::HttpParameters) -> Self {
            self.http_parameters = Some(input);
            self
        }
        /// <p>Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or
        /// EventBridge ApiDestination.</p>
        /// <p>If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can
        /// use this parameter to specify headers, path parameters, and query string keys/values as part
        /// of your target invoking request. If you're using ApiDestinations, the corresponding Connection
        /// can also have these values configured. In case of any conflicting keys, values from the
        /// Connection take precedence.</p>
        pub fn set_http_parameters(
            mut self,
            input: std::option::Option<crate::model::HttpParameters>,
        ) -> Self {
            self.http_parameters = input;
            self
        }
        /// <p>Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift
        /// cluster.</p>
        /// <p>If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to
        /// invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.</p>
        pub fn redshift_data_parameters(
            mut self,
            input: crate::model::RedshiftDataParameters,
        ) -> Self {
            self.redshift_data_parameters = Some(input);
            self
        }
        /// <p>Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift
        /// cluster.</p>
        /// <p>If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to
        /// invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.</p>
        pub fn set_redshift_data_parameters(
            mut self,
            input: std::option::Option<crate::model::RedshiftDataParameters>,
        ) -> Self {
            self.redshift_data_parameters = input;
            self
        }
        /// <p>Contains the SageMaker Model Building Pipeline parameters to start execution of a
        /// SageMaker Model Building Pipeline.</p>
        /// <p>If you specify a SageMaker Model Building Pipeline as a target, you can use this to
        /// specify parameters to start a pipeline execution based on EventBridge events.</p>
        pub fn sage_maker_pipeline_parameters(
            mut self,
            input: crate::model::SageMakerPipelineParameters,
        ) -> Self {
            self.sage_maker_pipeline_parameters = Some(input);
            self
        }
        /// <p>Contains the SageMaker Model Building Pipeline parameters to start execution of a
        /// SageMaker Model Building Pipeline.</p>
        /// <p>If you specify a SageMaker Model Building Pipeline as a target, you can use this to
        /// specify parameters to start a pipeline execution based on EventBridge events.</p>
        pub fn set_sage_maker_pipeline_parameters(
            mut self,
            input: std::option::Option<crate::model::SageMakerPipelineParameters>,
        ) -> Self {
            self.sage_maker_pipeline_parameters = input;
            self
        }
        /// <p>The <code>DeadLetterConfig</code> that defines the target queue to send dead-letter queue
        /// events to.</p>
        pub fn dead_letter_config(mut self, input: crate::model::DeadLetterConfig) -> Self {
            self.dead_letter_config = Some(input);
            self
        }
        /// <p>The <code>DeadLetterConfig</code> that defines the target queue to send dead-letter queue
        /// events to.</p>
        pub fn set_dead_letter_config(
            mut self,
            input: std::option::Option<crate::model::DeadLetterConfig>,
        ) -> Self {
            self.dead_letter_config = input;
            self
        }
        /// <p>The <code>RetryPolicy</code> object that contains the retry policy configuration to use
        /// for the dead-letter queue.</p>
        pub fn retry_policy(mut self, input: crate::model::RetryPolicy) -> Self {
            self.retry_policy = Some(input);
            self
        }
        /// <p>The <code>RetryPolicy</code> object that contains the retry policy configuration to use
        /// for the dead-letter queue.</p>
        pub fn set_retry_policy(
            mut self,
            input: std::option::Option<crate::model::RetryPolicy>,
        ) -> Self {
            self.retry_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`Target`](crate::model::Target)
        pub fn build(self) -> crate::model::Target {
            crate::model::Target {
                id: self.id,
                arn: self.arn,
                role_arn: self.role_arn,
                input: self.input,
                input_path: self.input_path,
                input_transformer: self.input_transformer,
                kinesis_parameters: self.kinesis_parameters,
                run_command_parameters: self.run_command_parameters,
                ecs_parameters: self.ecs_parameters,
                batch_parameters: self.batch_parameters,
                sqs_parameters: self.sqs_parameters,
                http_parameters: self.http_parameters,
                redshift_data_parameters: self.redshift_data_parameters,
                sage_maker_pipeline_parameters: self.sage_maker_pipeline_parameters,
                dead_letter_config: self.dead_letter_config,
                retry_policy: self.retry_policy,
            }
        }
    }
}
impl Target {
    /// Creates a new builder-style object to manufacture [`Target`](crate::model::Target)
    pub fn builder() -> crate::model::target::Builder {
        crate::model::target::Builder::default()
    }
}

/// <p>A <code>RetryPolicy</code> object that includes information about the retry policy
/// settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RetryPolicy {
    /// <p>The maximum number of retry attempts to make before the request fails. Retry attempts
    /// continue until either the maximum number of attempts is made or until the duration of the
    /// <code>MaximumEventAgeInSeconds</code> is met.</p>
    pub maximum_retry_attempts: std::option::Option<i32>,
    /// <p>The maximum amount of time, in seconds, to continue to make retry attempts.</p>
    pub maximum_event_age_in_seconds: std::option::Option<i32>,
}
impl std::fmt::Debug for RetryPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RetryPolicy");
        formatter.field("maximum_retry_attempts", &self.maximum_retry_attempts);
        formatter.field(
            "maximum_event_age_in_seconds",
            &self.maximum_event_age_in_seconds,
        );
        formatter.finish()
    }
}
/// See [`RetryPolicy`](crate::model::RetryPolicy)
pub mod retry_policy {
    /// A builder for [`RetryPolicy`](crate::model::RetryPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_retry_attempts: std::option::Option<i32>,
        pub(crate) maximum_event_age_in_seconds: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum number of retry attempts to make before the request fails. Retry attempts
        /// continue until either the maximum number of attempts is made or until the duration of the
        /// <code>MaximumEventAgeInSeconds</code> is met.</p>
        pub fn maximum_retry_attempts(mut self, input: i32) -> Self {
            self.maximum_retry_attempts = Some(input);
            self
        }
        /// <p>The maximum number of retry attempts to make before the request fails. Retry attempts
        /// continue until either the maximum number of attempts is made or until the duration of the
        /// <code>MaximumEventAgeInSeconds</code> is met.</p>
        pub fn set_maximum_retry_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_retry_attempts = input;
            self
        }
        /// <p>The maximum amount of time, in seconds, to continue to make retry attempts.</p>
        pub fn maximum_event_age_in_seconds(mut self, input: i32) -> Self {
            self.maximum_event_age_in_seconds = Some(input);
            self
        }
        /// <p>The maximum amount of time, in seconds, to continue to make retry attempts.</p>
        pub fn set_maximum_event_age_in_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_event_age_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`RetryPolicy`](crate::model::RetryPolicy)
        pub fn build(self) -> crate::model::RetryPolicy {
            crate::model::RetryPolicy {
                maximum_retry_attempts: self.maximum_retry_attempts,
                maximum_event_age_in_seconds: self.maximum_event_age_in_seconds,
            }
        }
    }
}
impl RetryPolicy {
    /// Creates a new builder-style object to manufacture [`RetryPolicy`](crate::model::RetryPolicy)
    pub fn builder() -> crate::model::retry_policy::Builder {
        crate::model::retry_policy::Builder::default()
    }
}

/// <p>A <code>DeadLetterConfig</code> object that contains information about a dead-letter queue
/// configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeadLetterConfig {
    /// <p>The ARN of the SQS queue specified as the target for the dead-letter queue.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeadLetterConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeadLetterConfig");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`DeadLetterConfig`](crate::model::DeadLetterConfig)
pub mod dead_letter_config {
    /// A builder for [`DeadLetterConfig`](crate::model::DeadLetterConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the SQS queue specified as the target for the dead-letter queue.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the SQS queue specified as the target for the dead-letter queue.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeadLetterConfig`](crate::model::DeadLetterConfig)
        pub fn build(self) -> crate::model::DeadLetterConfig {
            crate::model::DeadLetterConfig { arn: self.arn }
        }
    }
}
impl DeadLetterConfig {
    /// Creates a new builder-style object to manufacture [`DeadLetterConfig`](crate::model::DeadLetterConfig)
    pub fn builder() -> crate::model::dead_letter_config::Builder {
        crate::model::dead_letter_config::Builder::default()
    }
}

/// <p>These are custom parameters to use when the target is a SageMaker Model Building Pipeline
/// that starts based on EventBridge events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SageMakerPipelineParameters {
    /// <p>List of Parameter names and values for SageMaker Model Building Pipeline execution.</p>
    pub pipeline_parameter_list:
        std::option::Option<std::vec::Vec<crate::model::SageMakerPipelineParameter>>,
}
impl std::fmt::Debug for SageMakerPipelineParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SageMakerPipelineParameters");
        formatter.field("pipeline_parameter_list", &self.pipeline_parameter_list);
        formatter.finish()
    }
}
/// See [`SageMakerPipelineParameters`](crate::model::SageMakerPipelineParameters)
pub mod sage_maker_pipeline_parameters {
    /// A builder for [`SageMakerPipelineParameters`](crate::model::SageMakerPipelineParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pipeline_parameter_list:
            std::option::Option<std::vec::Vec<crate::model::SageMakerPipelineParameter>>,
    }
    impl Builder {
        /// Appends an item to `pipeline_parameter_list`.
        ///
        /// To override the contents of this collection use [`set_pipeline_parameter_list`](Self::set_pipeline_parameter_list).
        ///
        /// <p>List of Parameter names and values for SageMaker Model Building Pipeline execution.</p>
        pub fn pipeline_parameter_list(
            mut self,
            input: impl Into<crate::model::SageMakerPipelineParameter>,
        ) -> Self {
            let mut v = self.pipeline_parameter_list.unwrap_or_default();
            v.push(input.into());
            self.pipeline_parameter_list = Some(v);
            self
        }
        /// <p>List of Parameter names and values for SageMaker Model Building Pipeline execution.</p>
        pub fn set_pipeline_parameter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SageMakerPipelineParameter>>,
        ) -> Self {
            self.pipeline_parameter_list = input;
            self
        }
        /// Consumes the builder and constructs a [`SageMakerPipelineParameters`](crate::model::SageMakerPipelineParameters)
        pub fn build(self) -> crate::model::SageMakerPipelineParameters {
            crate::model::SageMakerPipelineParameters {
                pipeline_parameter_list: self.pipeline_parameter_list,
            }
        }
    }
}
impl SageMakerPipelineParameters {
    /// Creates a new builder-style object to manufacture [`SageMakerPipelineParameters`](crate::model::SageMakerPipelineParameters)
    pub fn builder() -> crate::model::sage_maker_pipeline_parameters::Builder {
        crate::model::sage_maker_pipeline_parameters::Builder::default()
    }
}

/// <p>Name/Value pair of a parameter to start execution of a SageMaker Model Building
/// Pipeline.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SageMakerPipelineParameter {
    /// <p>Name of parameter to start execution of a SageMaker Model Building Pipeline.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Value of parameter to start execution of a SageMaker Model Building Pipeline.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SageMakerPipelineParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SageMakerPipelineParameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SageMakerPipelineParameter`](crate::model::SageMakerPipelineParameter)
pub mod sage_maker_pipeline_parameter {
    /// A builder for [`SageMakerPipelineParameter`](crate::model::SageMakerPipelineParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Name of parameter to start execution of a SageMaker Model Building Pipeline.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of parameter to start execution of a SageMaker Model Building Pipeline.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Value of parameter to start execution of a SageMaker Model Building Pipeline.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Value of parameter to start execution of a SageMaker Model Building Pipeline.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SageMakerPipelineParameter`](crate::model::SageMakerPipelineParameter)
        pub fn build(self) -> crate::model::SageMakerPipelineParameter {
            crate::model::SageMakerPipelineParameter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl SageMakerPipelineParameter {
    /// Creates a new builder-style object to manufacture [`SageMakerPipelineParameter`](crate::model::SageMakerPipelineParameter)
    pub fn builder() -> crate::model::sage_maker_pipeline_parameter::Builder {
        crate::model::sage_maker_pipeline_parameter::Builder::default()
    }
}

/// <p>These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the
/// Amazon Redshift Data API ExecuteStatement based on EventBridge events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftDataParameters {
    /// <p>The name or ARN of the secret that enables access to the database. Required when
    /// authenticating using Amazon Web Services Secrets Manager.</p>
    pub secret_manager_arn: std::option::Option<std::string::String>,
    /// <p>The name of the database. Required when authenticating using temporary credentials.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The database user name. Required when authenticating using temporary credentials.</p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>The SQL statement text to run.</p>
    pub sql: std::option::Option<std::string::String>,
    /// <p>The name of the SQL statement. You can name the SQL statement when you create it to
    /// identify the query.</p>
    pub statement_name: std::option::Option<std::string::String>,
    /// <p>Indicates whether to send an event back to EventBridge after the SQL statement
    /// runs.</p>
    pub with_event: bool,
}
impl std::fmt::Debug for RedshiftDataParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftDataParameters");
        formatter.field("secret_manager_arn", &self.secret_manager_arn);
        formatter.field("database", &self.database);
        formatter.field("db_user", &self.db_user);
        formatter.field("sql", &self.sql);
        formatter.field("statement_name", &self.statement_name);
        formatter.field("with_event", &self.with_event);
        formatter.finish()
    }
}
/// See [`RedshiftDataParameters`](crate::model::RedshiftDataParameters)
pub mod redshift_data_parameters {
    /// A builder for [`RedshiftDataParameters`](crate::model::RedshiftDataParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) secret_manager_arn: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) sql: std::option::Option<std::string::String>,
        pub(crate) statement_name: std::option::Option<std::string::String>,
        pub(crate) with_event: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name or ARN of the secret that enables access to the database. Required when
        /// authenticating using Amazon Web Services Secrets Manager.</p>
        pub fn secret_manager_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_manager_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the database. Required when
        /// authenticating using Amazon Web Services Secrets Manager.</p>
        pub fn set_secret_manager_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_manager_arn = input;
            self
        }
        /// <p>The name of the database. Required when authenticating using temporary credentials.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database. Required when authenticating using temporary credentials.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The database user name. Required when authenticating using temporary credentials.</p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>The database user name. Required when authenticating using temporary credentials.</p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>The SQL statement text to run.</p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql = Some(input.into());
            self
        }
        /// <p>The SQL statement text to run.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql = input;
            self
        }
        /// <p>The name of the SQL statement. You can name the SQL statement when you create it to
        /// identify the query.</p>
        pub fn statement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.statement_name = Some(input.into());
            self
        }
        /// <p>The name of the SQL statement. You can name the SQL statement when you create it to
        /// identify the query.</p>
        pub fn set_statement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.statement_name = input;
            self
        }
        /// <p>Indicates whether to send an event back to EventBridge after the SQL statement
        /// runs.</p>
        pub fn with_event(mut self, input: bool) -> Self {
            self.with_event = Some(input);
            self
        }
        /// <p>Indicates whether to send an event back to EventBridge after the SQL statement
        /// runs.</p>
        pub fn set_with_event(mut self, input: std::option::Option<bool>) -> Self {
            self.with_event = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftDataParameters`](crate::model::RedshiftDataParameters)
        pub fn build(self) -> crate::model::RedshiftDataParameters {
            crate::model::RedshiftDataParameters {
                secret_manager_arn: self.secret_manager_arn,
                database: self.database,
                db_user: self.db_user,
                sql: self.sql,
                statement_name: self.statement_name,
                with_event: self.with_event.unwrap_or_default(),
            }
        }
    }
}
impl RedshiftDataParameters {
    /// Creates a new builder-style object to manufacture [`RedshiftDataParameters`](crate::model::RedshiftDataParameters)
    pub fn builder() -> crate::model::redshift_data_parameters::Builder {
        crate::model::redshift_data_parameters::Builder::default()
    }
}

/// <p>These are custom parameter to be used when the target is an API Gateway REST APIs or
/// EventBridge ApiDestinations. In the latter case, these are merged with any
/// InvocationParameters specified on the Connection, with any values from the Connection taking
/// precedence.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HttpParameters {
    /// <p>The path parameter values to be used to populate API Gateway REST API or EventBridge
    /// ApiDestination path wildcards ("*").</p>
    pub path_parameter_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The headers that need to be sent as part of request invoking the API Gateway REST API or
    /// EventBridge ApiDestination.</p>
    pub header_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The query string keys/values that need to be sent as part of request invoking the API Gateway
    /// REST API or EventBridge ApiDestination.</p>
    pub query_string_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for HttpParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HttpParameters");
        formatter.field("path_parameter_values", &self.path_parameter_values);
        formatter.field("header_parameters", &self.header_parameters);
        formatter.field("query_string_parameters", &self.query_string_parameters);
        formatter.finish()
    }
}
/// See [`HttpParameters`](crate::model::HttpParameters)
pub mod http_parameters {
    /// A builder for [`HttpParameters`](crate::model::HttpParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path_parameter_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) header_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) query_string_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Appends an item to `path_parameter_values`.
        ///
        /// To override the contents of this collection use [`set_path_parameter_values`](Self::set_path_parameter_values).
        ///
        /// <p>The path parameter values to be used to populate API Gateway REST API or EventBridge
        /// ApiDestination path wildcards ("*").</p>
        pub fn path_parameter_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.path_parameter_values.unwrap_or_default();
            v.push(input.into());
            self.path_parameter_values = Some(v);
            self
        }
        /// <p>The path parameter values to be used to populate API Gateway REST API or EventBridge
        /// ApiDestination path wildcards ("*").</p>
        pub fn set_path_parameter_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.path_parameter_values = input;
            self
        }
        /// Adds a key-value pair to `header_parameters`.
        ///
        /// To override the contents of this collection use [`set_header_parameters`](Self::set_header_parameters).
        ///
        /// <p>The headers that need to be sent as part of request invoking the API Gateway REST API or
        /// EventBridge ApiDestination.</p>
        pub fn header_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.header_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.header_parameters = Some(hash_map);
            self
        }
        /// <p>The headers that need to be sent as part of request invoking the API Gateway REST API or
        /// EventBridge ApiDestination.</p>
        pub fn set_header_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.header_parameters = input;
            self
        }
        /// Adds a key-value pair to `query_string_parameters`.
        ///
        /// To override the contents of this collection use [`set_query_string_parameters`](Self::set_query_string_parameters).
        ///
        /// <p>The query string keys/values that need to be sent as part of request invoking the API Gateway
        /// REST API or EventBridge ApiDestination.</p>
        pub fn query_string_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.query_string_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.query_string_parameters = Some(hash_map);
            self
        }
        /// <p>The query string keys/values that need to be sent as part of request invoking the API Gateway
        /// REST API or EventBridge ApiDestination.</p>
        pub fn set_query_string_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.query_string_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`HttpParameters`](crate::model::HttpParameters)
        pub fn build(self) -> crate::model::HttpParameters {
            crate::model::HttpParameters {
                path_parameter_values: self.path_parameter_values,
                header_parameters: self.header_parameters,
                query_string_parameters: self.query_string_parameters,
            }
        }
    }
}
impl HttpParameters {
    /// Creates a new builder-style object to manufacture [`HttpParameters`](crate::model::HttpParameters)
    pub fn builder() -> crate::model::http_parameters::Builder {
        crate::model::http_parameters::Builder::default()
    }
}

/// <p>This structure includes the custom parameter to be used when the target is an SQS FIFO
/// queue.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqsParameters {
    /// <p>The FIFO message group ID to use as the target.</p>
    pub message_group_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SqsParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqsParameters");
        formatter.field("message_group_id", &self.message_group_id);
        formatter.finish()
    }
}
/// See [`SqsParameters`](crate::model::SqsParameters)
pub mod sqs_parameters {
    /// A builder for [`SqsParameters`](crate::model::SqsParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message_group_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The FIFO message group ID to use as the target.</p>
        pub fn message_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.message_group_id = Some(input.into());
            self
        }
        /// <p>The FIFO message group ID to use as the target.</p>
        pub fn set_message_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.message_group_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SqsParameters`](crate::model::SqsParameters)
        pub fn build(self) -> crate::model::SqsParameters {
            crate::model::SqsParameters {
                message_group_id: self.message_group_id,
            }
        }
    }
}
impl SqsParameters {
    /// Creates a new builder-style object to manufacture [`SqsParameters`](crate::model::SqsParameters)
    pub fn builder() -> crate::model::sqs_parameters::Builder {
        crate::model::sqs_parameters::Builder::default()
    }
}

/// <p>The custom parameters to be used when the target is an Batch job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchParameters {
    /// <p>The ARN or name of the job definition to use if the event target is an Batch job. This
    /// job definition must already exist.</p>
    pub job_definition: std::option::Option<std::string::String>,
    /// <p>The name to use for this execution of the job, if the target is an Batch job.</p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The array properties for the submitted job, such as the size of the array. The array size
    /// can be between 2 and 10,000. If you specify array properties for a job, it becomes an array
    /// job. This parameter is used only if the target is an Batch job.</p>
    pub array_properties: std::option::Option<crate::model::BatchArrayProperties>,
    /// <p>The retry strategy to use for failed jobs, if the target is an Batch job. The retry
    /// strategy is the number of times to retry the failed job execution. Valid values are 1–10. When
    /// you specify a retry strategy here, it overrides the retry strategy defined in the job
    /// definition.</p>
    pub retry_strategy: std::option::Option<crate::model::BatchRetryStrategy>,
}
impl std::fmt::Debug for BatchParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchParameters");
        formatter.field("job_definition", &self.job_definition);
        formatter.field("job_name", &self.job_name);
        formatter.field("array_properties", &self.array_properties);
        formatter.field("retry_strategy", &self.retry_strategy);
        formatter.finish()
    }
}
/// See [`BatchParameters`](crate::model::BatchParameters)
pub mod batch_parameters {
    /// A builder for [`BatchParameters`](crate::model::BatchParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_definition: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) array_properties: std::option::Option<crate::model::BatchArrayProperties>,
        pub(crate) retry_strategy: std::option::Option<crate::model::BatchRetryStrategy>,
    }
    impl Builder {
        /// <p>The ARN or name of the job definition to use if the event target is an Batch job. This
        /// job definition must already exist.</p>
        pub fn job_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_definition = Some(input.into());
            self
        }
        /// <p>The ARN or name of the job definition to use if the event target is an Batch job. This
        /// job definition must already exist.</p>
        pub fn set_job_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_definition = input;
            self
        }
        /// <p>The name to use for this execution of the job, if the target is an Batch job.</p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The name to use for this execution of the job, if the target is an Batch job.</p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The array properties for the submitted job, such as the size of the array. The array size
        /// can be between 2 and 10,000. If you specify array properties for a job, it becomes an array
        /// job. This parameter is used only if the target is an Batch job.</p>
        pub fn array_properties(mut self, input: crate::model::BatchArrayProperties) -> Self {
            self.array_properties = Some(input);
            self
        }
        /// <p>The array properties for the submitted job, such as the size of the array. The array size
        /// can be between 2 and 10,000. If you specify array properties for a job, it becomes an array
        /// job. This parameter is used only if the target is an Batch job.</p>
        pub fn set_array_properties(
            mut self,
            input: std::option::Option<crate::model::BatchArrayProperties>,
        ) -> Self {
            self.array_properties = input;
            self
        }
        /// <p>The retry strategy to use for failed jobs, if the target is an Batch job. The retry
        /// strategy is the number of times to retry the failed job execution. Valid values are 1–10. When
        /// you specify a retry strategy here, it overrides the retry strategy defined in the job
        /// definition.</p>
        pub fn retry_strategy(mut self, input: crate::model::BatchRetryStrategy) -> Self {
            self.retry_strategy = Some(input);
            self
        }
        /// <p>The retry strategy to use for failed jobs, if the target is an Batch job. The retry
        /// strategy is the number of times to retry the failed job execution. Valid values are 1–10. When
        /// you specify a retry strategy here, it overrides the retry strategy defined in the job
        /// definition.</p>
        pub fn set_retry_strategy(
            mut self,
            input: std::option::Option<crate::model::BatchRetryStrategy>,
        ) -> Self {
            self.retry_strategy = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchParameters`](crate::model::BatchParameters)
        pub fn build(self) -> crate::model::BatchParameters {
            crate::model::BatchParameters {
                job_definition: self.job_definition,
                job_name: self.job_name,
                array_properties: self.array_properties,
                retry_strategy: self.retry_strategy,
            }
        }
    }
}
impl BatchParameters {
    /// Creates a new builder-style object to manufacture [`BatchParameters`](crate::model::BatchParameters)
    pub fn builder() -> crate::model::batch_parameters::Builder {
        crate::model::batch_parameters::Builder::default()
    }
}

/// <p>The retry strategy to use for failed jobs, if the target is an Batch job. If you
/// specify a retry strategy here, it overrides the retry strategy defined in the job
/// definition.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchRetryStrategy {
    /// <p>The number of times to attempt to retry, if the job fails. Valid values are 1–10.</p>
    pub attempts: i32,
}
impl std::fmt::Debug for BatchRetryStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchRetryStrategy");
        formatter.field("attempts", &self.attempts);
        formatter.finish()
    }
}
/// See [`BatchRetryStrategy`](crate::model::BatchRetryStrategy)
pub mod batch_retry_strategy {
    /// A builder for [`BatchRetryStrategy`](crate::model::BatchRetryStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attempts: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of times to attempt to retry, if the job fails. Valid values are 1–10.</p>
        pub fn attempts(mut self, input: i32) -> Self {
            self.attempts = Some(input);
            self
        }
        /// <p>The number of times to attempt to retry, if the job fails. Valid values are 1–10.</p>
        pub fn set_attempts(mut self, input: std::option::Option<i32>) -> Self {
            self.attempts = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchRetryStrategy`](crate::model::BatchRetryStrategy)
        pub fn build(self) -> crate::model::BatchRetryStrategy {
            crate::model::BatchRetryStrategy {
                attempts: self.attempts.unwrap_or_default(),
            }
        }
    }
}
impl BatchRetryStrategy {
    /// Creates a new builder-style object to manufacture [`BatchRetryStrategy`](crate::model::BatchRetryStrategy)
    pub fn builder() -> crate::model::batch_retry_strategy::Builder {
        crate::model::batch_retry_strategy::Builder::default()
    }
}

/// <p>The array properties for the submitted job, such as the size of the array. The array size
/// can be between 2 and 10,000. If you specify array properties for a job, it becomes an array
/// job. This parameter is used only if the target is an Batch job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchArrayProperties {
    /// <p>The size of the array, if this is an array batch job. Valid values are integers between 2
    /// and 10,000.</p>
    pub size: i32,
}
impl std::fmt::Debug for BatchArrayProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchArrayProperties");
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`BatchArrayProperties`](crate::model::BatchArrayProperties)
pub mod batch_array_properties {
    /// A builder for [`BatchArrayProperties`](crate::model::BatchArrayProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The size of the array, if this is an array batch job. Valid values are integers between 2
        /// and 10,000.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the array, if this is an array batch job. Valid values are integers between 2
        /// and 10,000.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchArrayProperties`](crate::model::BatchArrayProperties)
        pub fn build(self) -> crate::model::BatchArrayProperties {
            crate::model::BatchArrayProperties {
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl BatchArrayProperties {
    /// Creates a new builder-style object to manufacture [`BatchArrayProperties`](crate::model::BatchArrayProperties)
    pub fn builder() -> crate::model::batch_array_properties::Builder {
        crate::model::batch_array_properties::Builder::default()
    }
}

/// <p>The custom parameters to be used when the target is an Amazon ECS task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EcsParameters {
    /// <p>The ARN of the task definition to use if the event target is an Amazon ECS task. </p>
    pub task_definition_arn: std::option::Option<std::string::String>,
    /// <p>The number of tasks to create based on <code>TaskDefinition</code>. The default is
    /// 1.</p>
    pub task_count: std::option::Option<i32>,
    /// <p>Specifies the launch type on which your task is running. The launch type that you specify
    /// here must match one of the launch type (compatibilities) of the target task. The
    /// <code>FARGATE</code> value is supported only in the Regions where Fargate witt Amazon ECS
    /// is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">Fargate on Amazon ECS</a> in
    /// the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
    pub launch_type: std::option::Option<crate::model::LaunchType>,
    /// <p>Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode. This
    /// structure specifies the VPC subnets and security groups associated with the task, and whether
    /// a public IP address is to be used. This structure is required if <code>LaunchType</code> is
    /// <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate
    /// tasks.</p>
    /// <p>If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the
    /// <code>awsvpc</code> network mode, the task fails.</p>
    pub network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
    /// <p>Specifies the platform version for the task. Specify only the numeric portion of the
    /// platform version, such as <code>1.1.0</code>.</p>
    /// <p>This structure is used only if <code>LaunchType</code> is <code>FARGATE</code>. For more
    /// information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
    /// Versions</a> in the <i>Amazon Elastic Container Service Developer
    /// Guide</i>.</p>
    pub platform_version: std::option::Option<std::string::String>,
    /// <p>Specifies an ECS task group for the task. The maximum length is 255 characters.</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The capacity provider strategy to use for the task.</p>
    /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
    /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is
    /// specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used. </p>
    pub capacity_provider_strategy:
        std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
    /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information,
    /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer
    /// Guide. </p>
    pub enable_ecs_managed_tags: bool,
    /// <p>Whether or not to enable the execute command functionality for the containers in this
    /// task. If true, this enables execute command functionality on all containers in the
    /// task.</p>
    pub enable_execute_command: bool,
    /// <p>An array of placement constraint objects to use for the task. You can specify up to 10
    /// constraints per task (including constraints in the task definition and those specified at
    /// runtime).</p>
    pub placement_constraints:
        std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
    /// <p>The placement strategy objects to use for the task. You can specify a maximum of five
    /// strategy rules per task. </p>
    pub placement_strategy: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
    /// <p>Specifies whether to propagate the tags from the task definition to the task. If no value
    /// is specified, the tags are not propagated. Tags can only be propagated to the task during task
    /// creation. To add tags to a task after task creation, use the TagResource API action. </p>
    pub propagate_tags: std::option::Option<crate::model::PropagateTags>,
    /// <p>The reference ID to use for the task.</p>
    pub reference_id: std::option::Option<std::string::String>,
    /// <p>The metadata that you apply to the task to help you categorize and organize them. Each tag
    /// consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for EcsParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EcsParameters");
        formatter.field("task_definition_arn", &self.task_definition_arn);
        formatter.field("task_count", &self.task_count);
        formatter.field("launch_type", &self.launch_type);
        formatter.field("network_configuration", &self.network_configuration);
        formatter.field("platform_version", &self.platform_version);
        formatter.field("group", &self.group);
        formatter.field(
            "capacity_provider_strategy",
            &self.capacity_provider_strategy,
        );
        formatter.field("enable_ecs_managed_tags", &self.enable_ecs_managed_tags);
        formatter.field("enable_execute_command", &self.enable_execute_command);
        formatter.field("placement_constraints", &self.placement_constraints);
        formatter.field("placement_strategy", &self.placement_strategy);
        formatter.field("propagate_tags", &self.propagate_tags);
        formatter.field("reference_id", &self.reference_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`EcsParameters`](crate::model::EcsParameters)
pub mod ecs_parameters {
    /// A builder for [`EcsParameters`](crate::model::EcsParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) task_definition_arn: std::option::Option<std::string::String>,
        pub(crate) task_count: std::option::Option<i32>,
        pub(crate) launch_type: std::option::Option<crate::model::LaunchType>,
        pub(crate) network_configuration: std::option::Option<crate::model::NetworkConfiguration>,
        pub(crate) platform_version: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) capacity_provider_strategy:
            std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        pub(crate) enable_ecs_managed_tags: std::option::Option<bool>,
        pub(crate) enable_execute_command: std::option::Option<bool>,
        pub(crate) placement_constraints:
            std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        pub(crate) placement_strategy:
            std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        pub(crate) propagate_tags: std::option::Option<crate::model::PropagateTags>,
        pub(crate) reference_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ARN of the task definition to use if the event target is an Amazon ECS task. </p>
        pub fn task_definition_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_definition_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the task definition to use if the event target is an Amazon ECS task. </p>
        pub fn set_task_definition_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.task_definition_arn = input;
            self
        }
        /// <p>The number of tasks to create based on <code>TaskDefinition</code>. The default is
        /// 1.</p>
        pub fn task_count(mut self, input: i32) -> Self {
            self.task_count = Some(input);
            self
        }
        /// <p>The number of tasks to create based on <code>TaskDefinition</code>. The default is
        /// 1.</p>
        pub fn set_task_count(mut self, input: std::option::Option<i32>) -> Self {
            self.task_count = input;
            self
        }
        /// <p>Specifies the launch type on which your task is running. The launch type that you specify
        /// here must match one of the launch type (compatibilities) of the target task. The
        /// <code>FARGATE</code> value is supported only in the Regions where Fargate witt Amazon ECS
        /// is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">Fargate on Amazon ECS</a> in
        /// the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn launch_type(mut self, input: crate::model::LaunchType) -> Self {
            self.launch_type = Some(input);
            self
        }
        /// <p>Specifies the launch type on which your task is running. The launch type that you specify
        /// here must match one of the launch type (compatibilities) of the target task. The
        /// <code>FARGATE</code> value is supported only in the Regions where Fargate witt Amazon ECS
        /// is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">Fargate on Amazon ECS</a> in
        /// the <i>Amazon Elastic Container Service Developer Guide</i>.</p>
        pub fn set_launch_type(
            mut self,
            input: std::option::Option<crate::model::LaunchType>,
        ) -> Self {
            self.launch_type = input;
            self
        }
        /// <p>Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode. This
        /// structure specifies the VPC subnets and security groups associated with the task, and whether
        /// a public IP address is to be used. This structure is required if <code>LaunchType</code> is
        /// <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate
        /// tasks.</p>
        /// <p>If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the
        /// <code>awsvpc</code> network mode, the task fails.</p>
        pub fn network_configuration(mut self, input: crate::model::NetworkConfiguration) -> Self {
            self.network_configuration = Some(input);
            self
        }
        /// <p>Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode. This
        /// structure specifies the VPC subnets and security groups associated with the task, and whether
        /// a public IP address is to be used. This structure is required if <code>LaunchType</code> is
        /// <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate
        /// tasks.</p>
        /// <p>If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the
        /// <code>awsvpc</code> network mode, the task fails.</p>
        pub fn set_network_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkConfiguration>,
        ) -> Self {
            self.network_configuration = input;
            self
        }
        /// <p>Specifies the platform version for the task. Specify only the numeric portion of the
        /// platform version, such as <code>1.1.0</code>.</p>
        /// <p>This structure is used only if <code>LaunchType</code> is <code>FARGATE</code>. For more
        /// information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer
        /// Guide</i>.</p>
        pub fn platform_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform_version = Some(input.into());
            self
        }
        /// <p>Specifies the platform version for the task. Specify only the numeric portion of the
        /// platform version, such as <code>1.1.0</code>.</p>
        /// <p>This structure is used only if <code>LaunchType</code> is <code>FARGATE</code>. For more
        /// information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
        /// Versions</a> in the <i>Amazon Elastic Container Service Developer
        /// Guide</i>.</p>
        pub fn set_platform_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.platform_version = input;
            self
        }
        /// <p>Specifies an ECS task group for the task. The maximum length is 255 characters.</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>Specifies an ECS task group for the task. The maximum length is 255 characters.</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// Appends an item to `capacity_provider_strategy`.
        ///
        /// To override the contents of this collection use [`set_capacity_provider_strategy`](Self::set_capacity_provider_strategy).
        ///
        /// <p>The capacity provider strategy to use for the task.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is
        /// specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used. </p>
        pub fn capacity_provider_strategy(
            mut self,
            input: impl Into<crate::model::CapacityProviderStrategyItem>,
        ) -> Self {
            let mut v = self.capacity_provider_strategy.unwrap_or_default();
            v.push(input.into());
            self.capacity_provider_strategy = Some(v);
            self
        }
        /// <p>The capacity provider strategy to use for the task.</p>
        /// <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code>
        /// parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is
        /// specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used. </p>
        pub fn set_capacity_provider_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CapacityProviderStrategyItem>>,
        ) -> Self {
            self.capacity_provider_strategy = input;
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer
        /// Guide. </p>
        pub fn enable_ecs_managed_tags(mut self, input: bool) -> Self {
            self.enable_ecs_managed_tags = Some(input);
            self
        }
        /// <p>Specifies whether to enable Amazon ECS managed tags for the task. For more information,
        /// see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer
        /// Guide. </p>
        pub fn set_enable_ecs_managed_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_ecs_managed_tags = input;
            self
        }
        /// <p>Whether or not to enable the execute command functionality for the containers in this
        /// task. If true, this enables execute command functionality on all containers in the
        /// task.</p>
        pub fn enable_execute_command(mut self, input: bool) -> Self {
            self.enable_execute_command = Some(input);
            self
        }
        /// <p>Whether or not to enable the execute command functionality for the containers in this
        /// task. If true, this enables execute command functionality on all containers in the
        /// task.</p>
        pub fn set_enable_execute_command(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_execute_command = input;
            self
        }
        /// Appends an item to `placement_constraints`.
        ///
        /// To override the contents of this collection use [`set_placement_constraints`](Self::set_placement_constraints).
        ///
        /// <p>An array of placement constraint objects to use for the task. You can specify up to 10
        /// constraints per task (including constraints in the task definition and those specified at
        /// runtime).</p>
        pub fn placement_constraints(
            mut self,
            input: impl Into<crate::model::PlacementConstraint>,
        ) -> Self {
            let mut v = self.placement_constraints.unwrap_or_default();
            v.push(input.into());
            self.placement_constraints = Some(v);
            self
        }
        /// <p>An array of placement constraint objects to use for the task. You can specify up to 10
        /// constraints per task (including constraints in the task definition and those specified at
        /// runtime).</p>
        pub fn set_placement_constraints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementConstraint>>,
        ) -> Self {
            self.placement_constraints = input;
            self
        }
        /// Appends an item to `placement_strategy`.
        ///
        /// To override the contents of this collection use [`set_placement_strategy`](Self::set_placement_strategy).
        ///
        /// <p>The placement strategy objects to use for the task. You can specify a maximum of five
        /// strategy rules per task. </p>
        pub fn placement_strategy(
            mut self,
            input: impl Into<crate::model::PlacementStrategy>,
        ) -> Self {
            let mut v = self.placement_strategy.unwrap_or_default();
            v.push(input.into());
            self.placement_strategy = Some(v);
            self
        }
        /// <p>The placement strategy objects to use for the task. You can specify a maximum of five
        /// strategy rules per task. </p>
        pub fn set_placement_strategy(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlacementStrategy>>,
        ) -> Self {
            self.placement_strategy = input;
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no value
        /// is specified, the tags are not propagated. Tags can only be propagated to the task during task
        /// creation. To add tags to a task after task creation, use the TagResource API action. </p>
        pub fn propagate_tags(mut self, input: crate::model::PropagateTags) -> Self {
            self.propagate_tags = Some(input);
            self
        }
        /// <p>Specifies whether to propagate the tags from the task definition to the task. If no value
        /// is specified, the tags are not propagated. Tags can only be propagated to the task during task
        /// creation. To add tags to a task after task creation, use the TagResource API action. </p>
        pub fn set_propagate_tags(
            mut self,
            input: std::option::Option<crate::model::PropagateTags>,
        ) -> Self {
            self.propagate_tags = input;
            self
        }
        /// <p>The reference ID to use for the task.</p>
        pub fn reference_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reference_id = Some(input.into());
            self
        }
        /// <p>The reference ID to use for the task.</p>
        pub fn set_reference_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reference_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each tag
        /// consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The metadata that you apply to the task to help you categorize and organize them. Each tag
        /// consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`EcsParameters`](crate::model::EcsParameters)
        pub fn build(self) -> crate::model::EcsParameters {
            crate::model::EcsParameters {
                task_definition_arn: self.task_definition_arn,
                task_count: self.task_count,
                launch_type: self.launch_type,
                network_configuration: self.network_configuration,
                platform_version: self.platform_version,
                group: self.group,
                capacity_provider_strategy: self.capacity_provider_strategy,
                enable_ecs_managed_tags: self.enable_ecs_managed_tags.unwrap_or_default(),
                enable_execute_command: self.enable_execute_command.unwrap_or_default(),
                placement_constraints: self.placement_constraints,
                placement_strategy: self.placement_strategy,
                propagate_tags: self.propagate_tags,
                reference_id: self.reference_id,
                tags: self.tags,
            }
        }
    }
}
impl EcsParameters {
    /// Creates a new builder-style object to manufacture [`EcsParameters`](crate::model::EcsParameters)
    pub fn builder() -> crate::model::ecs_parameters::Builder {
        crate::model::ecs_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PropagateTags {
    #[allow(missing_docs)] // documentation missing in model
    TaskDefinition,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PropagateTags {
    fn from(s: &str) -> Self {
        match s {
            "TASK_DEFINITION" => PropagateTags::TaskDefinition,
            other => PropagateTags::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PropagateTags {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PropagateTags::from(s))
    }
}
impl PropagateTags {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PropagateTags::TaskDefinition => "TASK_DEFINITION",
            PropagateTags::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TASK_DEFINITION"]
    }
}
impl AsRef<str> for PropagateTags {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The task placement strategy for a task or service. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the Amazon Elastic Container Service Service Developer
/// Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacementStrategy {
    /// <p>The type of placement strategy. The random placement strategy randomly places tasks on
    /// available candidates. The spread placement strategy spreads placement across available
    /// candidates evenly based on the field parameter. The binpack strategy places tasks on available
    /// candidates that have the least available amount of the resource that is specified with the
    /// field parameter. For example, if you binpack on memory, a task is placed on the instance with
    /// the least amount of remaining memory (but still enough to run the task). </p>
    pub r#type: std::option::Option<crate::model::PlacementStrategyType>,
    /// <p>The field to apply the placement strategy against. For the spread placement strategy,
    /// valid values are instanceId (or host, which has the same effect), or any platform or custom
    /// attribute that is applied to a container instance, such as attribute:ecs.availability-zone.
    /// For the binpack placement strategy, valid values are cpu and memory. For the random placement
    /// strategy, this field is not used. </p>
    pub field: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlacementStrategy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacementStrategy");
        formatter.field("r#type", &self.r#type);
        formatter.field("field", &self.field);
        formatter.finish()
    }
}
/// See [`PlacementStrategy`](crate::model::PlacementStrategy)
pub mod placement_strategy {
    /// A builder for [`PlacementStrategy`](crate::model::PlacementStrategy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::PlacementStrategyType>,
        pub(crate) field: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of placement strategy. The random placement strategy randomly places tasks on
        /// available candidates. The spread placement strategy spreads placement across available
        /// candidates evenly based on the field parameter. The binpack strategy places tasks on available
        /// candidates that have the least available amount of the resource that is specified with the
        /// field parameter. For example, if you binpack on memory, a task is placed on the instance with
        /// the least amount of remaining memory (but still enough to run the task). </p>
        pub fn r#type(mut self, input: crate::model::PlacementStrategyType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of placement strategy. The random placement strategy randomly places tasks on
        /// available candidates. The spread placement strategy spreads placement across available
        /// candidates evenly based on the field parameter. The binpack strategy places tasks on available
        /// candidates that have the least available amount of the resource that is specified with the
        /// field parameter. For example, if you binpack on memory, a task is placed on the instance with
        /// the least amount of remaining memory (but still enough to run the task). </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PlacementStrategyType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The field to apply the placement strategy against. For the spread placement strategy,
        /// valid values are instanceId (or host, which has the same effect), or any platform or custom
        /// attribute that is applied to a container instance, such as attribute:ecs.availability-zone.
        /// For the binpack placement strategy, valid values are cpu and memory. For the random placement
        /// strategy, this field is not used. </p>
        pub fn field(mut self, input: impl Into<std::string::String>) -> Self {
            self.field = Some(input.into());
            self
        }
        /// <p>The field to apply the placement strategy against. For the spread placement strategy,
        /// valid values are instanceId (or host, which has the same effect), or any platform or custom
        /// attribute that is applied to a container instance, such as attribute:ecs.availability-zone.
        /// For the binpack placement strategy, valid values are cpu and memory. For the random placement
        /// strategy, this field is not used. </p>
        pub fn set_field(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.field = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacementStrategy`](crate::model::PlacementStrategy)
        pub fn build(self) -> crate::model::PlacementStrategy {
            crate::model::PlacementStrategy {
                r#type: self.r#type,
                field: self.field,
            }
        }
    }
}
impl PlacementStrategy {
    /// Creates a new builder-style object to manufacture [`PlacementStrategy`](crate::model::PlacementStrategy)
    pub fn builder() -> crate::model::placement_strategy::Builder {
        crate::model::placement_strategy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlacementStrategyType {
    #[allow(missing_docs)] // documentation missing in model
    Binpack,
    #[allow(missing_docs)] // documentation missing in model
    Random,
    #[allow(missing_docs)] // documentation missing in model
    Spread,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlacementStrategyType {
    fn from(s: &str) -> Self {
        match s {
            "binpack" => PlacementStrategyType::Binpack,
            "random" => PlacementStrategyType::Random,
            "spread" => PlacementStrategyType::Spread,
            other => PlacementStrategyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlacementStrategyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlacementStrategyType::from(s))
    }
}
impl PlacementStrategyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlacementStrategyType::Binpack => "binpack",
            PlacementStrategyType::Random => "random",
            PlacementStrategyType::Spread => "spread",
            PlacementStrategyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["binpack", "random", "spread"]
    }
}
impl AsRef<str> for PlacementStrategyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An object representing a constraint on task placement. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints</a> in the Amazon Elastic Container Service Developer
/// Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlacementConstraint {
    /// <p>The type of constraint. Use distinctInstance to ensure that each task in a particular
    /// group is running on a different container instance. Use memberOf to restrict the selection to
    /// a group of valid candidates. </p>
    pub r#type: std::option::Option<crate::model::PlacementConstraintType>,
    /// <p>A cluster query language expression to apply to the constraint. You cannot specify an
    /// expression if the constraint type is <code>distinctInstance</code>. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide.
    /// </p>
    pub expression: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PlacementConstraint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlacementConstraint");
        formatter.field("r#type", &self.r#type);
        formatter.field("expression", &self.expression);
        formatter.finish()
    }
}
/// See [`PlacementConstraint`](crate::model::PlacementConstraint)
pub mod placement_constraint {
    /// A builder for [`PlacementConstraint`](crate::model::PlacementConstraint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::PlacementConstraintType>,
        pub(crate) expression: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of constraint. Use distinctInstance to ensure that each task in a particular
        /// group is running on a different container instance. Use memberOf to restrict the selection to
        /// a group of valid candidates. </p>
        pub fn r#type(mut self, input: crate::model::PlacementConstraintType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of constraint. Use distinctInstance to ensure that each task in a particular
        /// group is running on a different container instance. Use memberOf to restrict the selection to
        /// a group of valid candidates. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::PlacementConstraintType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A cluster query language expression to apply to the constraint. You cannot specify an
        /// expression if the constraint type is <code>distinctInstance</code>. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide.
        /// </p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>A cluster query language expression to apply to the constraint. You cannot specify an
        /// expression if the constraint type is <code>distinctInstance</code>. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide.
        /// </p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// Consumes the builder and constructs a [`PlacementConstraint`](crate::model::PlacementConstraint)
        pub fn build(self) -> crate::model::PlacementConstraint {
            crate::model::PlacementConstraint {
                r#type: self.r#type,
                expression: self.expression,
            }
        }
    }
}
impl PlacementConstraint {
    /// Creates a new builder-style object to manufacture [`PlacementConstraint`](crate::model::PlacementConstraint)
    pub fn builder() -> crate::model::placement_constraint::Builder {
        crate::model::placement_constraint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlacementConstraintType {
    #[allow(missing_docs)] // documentation missing in model
    DistinctInstance,
    #[allow(missing_docs)] // documentation missing in model
    MemberOf,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlacementConstraintType {
    fn from(s: &str) -> Self {
        match s {
            "distinctInstance" => PlacementConstraintType::DistinctInstance,
            "memberOf" => PlacementConstraintType::MemberOf,
            other => PlacementConstraintType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlacementConstraintType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlacementConstraintType::from(s))
    }
}
impl PlacementConstraintType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlacementConstraintType::DistinctInstance => "distinctInstance",
            PlacementConstraintType::MemberOf => "memberOf",
            PlacementConstraintType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["distinctInstance", "memberOf"]
    }
}
impl AsRef<str> for PlacementConstraintType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of a capacity provider strategy. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html">CapacityProviderStrategyItem</a> in the Amazon ECS API Reference.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CapacityProviderStrategyItem {
    /// <p>The short name of the capacity provider.</p>
    pub capacity_provider: std::option::Option<std::string::String>,
    /// <p>The weight value designates the relative percentage of the total number of tasks launched
    /// that should use the specified capacity provider. The weight value is taken into consideration
    /// after the base value, if defined, is satisfied.</p>
    pub weight: i32,
    /// <p>The base value designates how many tasks, at a minimum, to run on the specified capacity
    /// provider. Only one capacity provider in a capacity provider strategy can have a base defined.
    /// If no value is specified, the default value of 0 is used. </p>
    pub base: i32,
}
impl std::fmt::Debug for CapacityProviderStrategyItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CapacityProviderStrategyItem");
        formatter.field("capacity_provider", &self.capacity_provider);
        formatter.field("weight", &self.weight);
        formatter.field("base", &self.base);
        formatter.finish()
    }
}
/// See [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
pub mod capacity_provider_strategy_item {
    /// A builder for [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capacity_provider: std::option::Option<std::string::String>,
        pub(crate) weight: std::option::Option<i32>,
        pub(crate) base: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The short name of the capacity provider.</p>
        pub fn capacity_provider(mut self, input: impl Into<std::string::String>) -> Self {
            self.capacity_provider = Some(input.into());
            self
        }
        /// <p>The short name of the capacity provider.</p>
        pub fn set_capacity_provider(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.capacity_provider = input;
            self
        }
        /// <p>The weight value designates the relative percentage of the total number of tasks launched
        /// that should use the specified capacity provider. The weight value is taken into consideration
        /// after the base value, if defined, is satisfied.</p>
        pub fn weight(mut self, input: i32) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>The weight value designates the relative percentage of the total number of tasks launched
        /// that should use the specified capacity provider. The weight value is taken into consideration
        /// after the base value, if defined, is satisfied.</p>
        pub fn set_weight(mut self, input: std::option::Option<i32>) -> Self {
            self.weight = input;
            self
        }
        /// <p>The base value designates how many tasks, at a minimum, to run on the specified capacity
        /// provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        /// If no value is specified, the default value of 0 is used. </p>
        pub fn base(mut self, input: i32) -> Self {
            self.base = Some(input);
            self
        }
        /// <p>The base value designates how many tasks, at a minimum, to run on the specified capacity
        /// provider. Only one capacity provider in a capacity provider strategy can have a base defined.
        /// If no value is specified, the default value of 0 is used. </p>
        pub fn set_base(mut self, input: std::option::Option<i32>) -> Self {
            self.base = input;
            self
        }
        /// Consumes the builder and constructs a [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
        pub fn build(self) -> crate::model::CapacityProviderStrategyItem {
            crate::model::CapacityProviderStrategyItem {
                capacity_provider: self.capacity_provider,
                weight: self.weight.unwrap_or_default(),
                base: self.base.unwrap_or_default(),
            }
        }
    }
}
impl CapacityProviderStrategyItem {
    /// Creates a new builder-style object to manufacture [`CapacityProviderStrategyItem`](crate::model::CapacityProviderStrategyItem)
    pub fn builder() -> crate::model::capacity_provider_strategy_item::Builder {
        crate::model::capacity_provider_strategy_item::Builder::default()
    }
}

/// <p>This structure specifies the network configuration for an ECS task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkConfiguration {
    /// <p>Use this structure to specify the VPC subnets and security groups for the task, and
    /// whether a public IP address is to be used. This structure is relevant only for ECS tasks that
    /// use the <code>awsvpc</code> network mode.</p>
    pub awsvpc_configuration: std::option::Option<crate::model::AwsVpcConfiguration>,
}
impl std::fmt::Debug for NetworkConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkConfiguration");
        formatter.field("awsvpc_configuration", &self.awsvpc_configuration);
        formatter.finish()
    }
}
/// See [`NetworkConfiguration`](crate::model::NetworkConfiguration)
pub mod network_configuration {
    /// A builder for [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) awsvpc_configuration: std::option::Option<crate::model::AwsVpcConfiguration>,
    }
    impl Builder {
        /// <p>Use this structure to specify the VPC subnets and security groups for the task, and
        /// whether a public IP address is to be used. This structure is relevant only for ECS tasks that
        /// use the <code>awsvpc</code> network mode.</p>
        pub fn awsvpc_configuration(mut self, input: crate::model::AwsVpcConfiguration) -> Self {
            self.awsvpc_configuration = Some(input);
            self
        }
        /// <p>Use this structure to specify the VPC subnets and security groups for the task, and
        /// whether a public IP address is to be used. This structure is relevant only for ECS tasks that
        /// use the <code>awsvpc</code> network mode.</p>
        pub fn set_awsvpc_configuration(
            mut self,
            input: std::option::Option<crate::model::AwsVpcConfiguration>,
        ) -> Self {
            self.awsvpc_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkConfiguration`](crate::model::NetworkConfiguration)
        pub fn build(self) -> crate::model::NetworkConfiguration {
            crate::model::NetworkConfiguration {
                awsvpc_configuration: self.awsvpc_configuration,
            }
        }
    }
}
impl NetworkConfiguration {
    /// Creates a new builder-style object to manufacture [`NetworkConfiguration`](crate::model::NetworkConfiguration)
    pub fn builder() -> crate::model::network_configuration::Builder {
        crate::model::network_configuration::Builder::default()
    }
}

/// <p>This structure specifies the VPC subnets and security groups for the task, and whether a
/// public IP address is to be used. This structure is relevant only for ECS tasks that use the
/// <code>awsvpc</code> network mode.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsVpcConfiguration {
    /// <p>Specifies the subnets associated with the task. These subnets must all be in the same VPC.
    /// You can specify as many as 16 subnets.</p>
    pub subnets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the security groups associated with the task. These security groups must all be
    /// in the same VPC. You can specify as many as five security groups. If you do not specify a
    /// security group, the default security group for the VPC is used.</p>
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether the task's elastic network interface receives a public IP address. You
    /// can specify <code>ENABLED</code> only when <code>LaunchType</code> in
    /// <code>EcsParameters</code> is set to <code>FARGATE</code>.</p>
    pub assign_public_ip: std::option::Option<crate::model::AssignPublicIp>,
}
impl std::fmt::Debug for AwsVpcConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsVpcConfiguration");
        formatter.field("subnets", &self.subnets);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("assign_public_ip", &self.assign_public_ip);
        formatter.finish()
    }
}
/// See [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
pub mod aws_vpc_configuration {
    /// A builder for [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) assign_public_ip: std::option::Option<crate::model::AssignPublicIp>,
    }
    impl Builder {
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>Specifies the subnets associated with the task. These subnets must all be in the same VPC.
        /// You can specify as many as 16 subnets.</p>
        pub fn subnets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>Specifies the subnets associated with the task. These subnets must all be in the same VPC.
        /// You can specify as many as 16 subnets.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// <p>Specifies the security groups associated with the task. These security groups must all be
        /// in the same VPC. You can specify as many as five security groups. If you do not specify a
        /// security group, the default security group for the VPC is used.</p>
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// <p>Specifies the security groups associated with the task. These security groups must all be
        /// in the same VPC. You can specify as many as five security groups. If you do not specify a
        /// security group, the default security group for the VPC is used.</p>
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// <p>Specifies whether the task's elastic network interface receives a public IP address. You
        /// can specify <code>ENABLED</code> only when <code>LaunchType</code> in
        /// <code>EcsParameters</code> is set to <code>FARGATE</code>.</p>
        pub fn assign_public_ip(mut self, input: crate::model::AssignPublicIp) -> Self {
            self.assign_public_ip = Some(input);
            self
        }
        /// <p>Specifies whether the task's elastic network interface receives a public IP address. You
        /// can specify <code>ENABLED</code> only when <code>LaunchType</code> in
        /// <code>EcsParameters</code> is set to <code>FARGATE</code>.</p>
        pub fn set_assign_public_ip(
            mut self,
            input: std::option::Option<crate::model::AssignPublicIp>,
        ) -> Self {
            self.assign_public_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
        pub fn build(self) -> crate::model::AwsVpcConfiguration {
            crate::model::AwsVpcConfiguration {
                subnets: self.subnets,
                security_groups: self.security_groups,
                assign_public_ip: self.assign_public_ip,
            }
        }
    }
}
impl AwsVpcConfiguration {
    /// Creates a new builder-style object to manufacture [`AwsVpcConfiguration`](crate::model::AwsVpcConfiguration)
    pub fn builder() -> crate::model::aws_vpc_configuration::Builder {
        crate::model::aws_vpc_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AssignPublicIp {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AssignPublicIp {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => AssignPublicIp::Disabled,
            "ENABLED" => AssignPublicIp::Enabled,
            other => AssignPublicIp::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AssignPublicIp {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AssignPublicIp::from(s))
    }
}
impl AssignPublicIp {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AssignPublicIp::Disabled => "DISABLED",
            AssignPublicIp::Enabled => "ENABLED",
            AssignPublicIp::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for AssignPublicIp {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LaunchType {
    #[allow(missing_docs)] // documentation missing in model
    Ec2,
    #[allow(missing_docs)] // documentation missing in model
    External,
    #[allow(missing_docs)] // documentation missing in model
    Fargate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LaunchType {
    fn from(s: &str) -> Self {
        match s {
            "EC2" => LaunchType::Ec2,
            "EXTERNAL" => LaunchType::External,
            "FARGATE" => LaunchType::Fargate,
            other => LaunchType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LaunchType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LaunchType::from(s))
    }
}
impl LaunchType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LaunchType::Ec2 => "EC2",
            LaunchType::External => "EXTERNAL",
            LaunchType::Fargate => "FARGATE",
            LaunchType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EC2", "EXTERNAL", "FARGATE"]
    }
}
impl AsRef<str> for LaunchType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This parameter contains the criteria (either InstanceIds or a tag) used to specify which
/// EC2 instances are to be sent the command. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RunCommandParameters {
    /// <p>Currently, we support including only one RunCommandTarget block, which specifies either an
    /// array of InstanceIds or a tag.</p>
    pub run_command_targets: std::option::Option<std::vec::Vec<crate::model::RunCommandTarget>>,
}
impl std::fmt::Debug for RunCommandParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RunCommandParameters");
        formatter.field("run_command_targets", &self.run_command_targets);
        formatter.finish()
    }
}
/// See [`RunCommandParameters`](crate::model::RunCommandParameters)
pub mod run_command_parameters {
    /// A builder for [`RunCommandParameters`](crate::model::RunCommandParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) run_command_targets:
            std::option::Option<std::vec::Vec<crate::model::RunCommandTarget>>,
    }
    impl Builder {
        /// Appends an item to `run_command_targets`.
        ///
        /// To override the contents of this collection use [`set_run_command_targets`](Self::set_run_command_targets).
        ///
        /// <p>Currently, we support including only one RunCommandTarget block, which specifies either an
        /// array of InstanceIds or a tag.</p>
        pub fn run_command_targets(
            mut self,
            input: impl Into<crate::model::RunCommandTarget>,
        ) -> Self {
            let mut v = self.run_command_targets.unwrap_or_default();
            v.push(input.into());
            self.run_command_targets = Some(v);
            self
        }
        /// <p>Currently, we support including only one RunCommandTarget block, which specifies either an
        /// array of InstanceIds or a tag.</p>
        pub fn set_run_command_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RunCommandTarget>>,
        ) -> Self {
            self.run_command_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`RunCommandParameters`](crate::model::RunCommandParameters)
        pub fn build(self) -> crate::model::RunCommandParameters {
            crate::model::RunCommandParameters {
                run_command_targets: self.run_command_targets,
            }
        }
    }
}
impl RunCommandParameters {
    /// Creates a new builder-style object to manufacture [`RunCommandParameters`](crate::model::RunCommandParameters)
    pub fn builder() -> crate::model::run_command_parameters::Builder {
        crate::model::run_command_parameters::Builder::default()
    }
}

/// <p>Information about the EC2 instances that are to be sent the command, specified as
/// key-value pairs. Each <code>RunCommandTarget</code> block can include only one key, but this
/// key may specify multiple values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RunCommandTarget {
    /// <p>Can be either <code>tag:</code>
    /// <i>tag-key</i> or
    /// <code>InstanceIds</code>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>If <code>Key</code> is <code>tag:</code>
    /// <i>tag-key</i>, <code>Values</code>
    /// is a list of tag values. If <code>Key</code> is <code>InstanceIds</code>, <code>Values</code>
    /// is a list of Amazon EC2 instance IDs.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for RunCommandTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RunCommandTarget");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`RunCommandTarget`](crate::model::RunCommandTarget)
pub mod run_command_target {
    /// A builder for [`RunCommandTarget`](crate::model::RunCommandTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Can be either <code>tag:</code>
        /// <i>tag-key</i> or
        /// <code>InstanceIds</code>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Can be either <code>tag:</code>
        /// <i>tag-key</i> or
        /// <code>InstanceIds</code>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>If <code>Key</code> is <code>tag:</code>
        /// <i>tag-key</i>, <code>Values</code>
        /// is a list of tag values. If <code>Key</code> is <code>InstanceIds</code>, <code>Values</code>
        /// is a list of Amazon EC2 instance IDs.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>If <code>Key</code> is <code>tag:</code>
        /// <i>tag-key</i>, <code>Values</code>
        /// is a list of tag values. If <code>Key</code> is <code>InstanceIds</code>, <code>Values</code>
        /// is a list of Amazon EC2 instance IDs.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`RunCommandTarget`](crate::model::RunCommandTarget)
        pub fn build(self) -> crate::model::RunCommandTarget {
            crate::model::RunCommandTarget {
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl RunCommandTarget {
    /// Creates a new builder-style object to manufacture [`RunCommandTarget`](crate::model::RunCommandTarget)
    pub fn builder() -> crate::model::run_command_target::Builder {
        crate::model::run_command_target::Builder::default()
    }
}

/// <p>This object enables you to specify a JSON path to extract from the event and use as the
/// partition key for the Amazon Kinesis data stream, so that you can control the shard to which
/// the event goes. If you do not include this parameter, the default is to use the
/// <code>eventId</code> as the partition key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisParameters {
    /// <p>The JSON path to be extracted from the event and used as the partition key. For more
    /// information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key
    /// Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.</p>
    pub partition_key_path: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KinesisParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisParameters");
        formatter.field("partition_key_path", &self.partition_key_path);
        formatter.finish()
    }
}
/// See [`KinesisParameters`](crate::model::KinesisParameters)
pub mod kinesis_parameters {
    /// A builder for [`KinesisParameters`](crate::model::KinesisParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partition_key_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The JSON path to be extracted from the event and used as the partition key. For more
        /// information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key
        /// Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.</p>
        pub fn partition_key_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition_key_path = Some(input.into());
            self
        }
        /// <p>The JSON path to be extracted from the event and used as the partition key. For more
        /// information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key">Amazon Kinesis Streams Key
        /// Concepts</a> in the <i>Amazon Kinesis Streams Developer Guide</i>.</p>
        pub fn set_partition_key_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.partition_key_path = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisParameters`](crate::model::KinesisParameters)
        pub fn build(self) -> crate::model::KinesisParameters {
            crate::model::KinesisParameters {
                partition_key_path: self.partition_key_path,
            }
        }
    }
}
impl KinesisParameters {
    /// Creates a new builder-style object to manufacture [`KinesisParameters`](crate::model::KinesisParameters)
    pub fn builder() -> crate::model::kinesis_parameters::Builder {
        crate::model::kinesis_parameters::Builder::default()
    }
}

/// <p>Contains the parameters needed for you to provide custom input to a target based on one or
/// more pieces of data extracted from the event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputTransformer {
    /// <p>Map of JSON paths to be extracted from the event. You can then insert these in the
    /// template in <code>InputTemplate</code> to produce the output you want to be sent to the
    /// target.</p>
    /// <p>
    /// <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON
    /// path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket
    /// notation.</p>
    /// <p>The keys cannot start with "Amazon Web Services." </p>
    pub input_paths_map:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Input template where you specify placeholders that will be filled with the values of the
    /// keys from <code>InputPathsMap</code> to customize the data sent to the target. Enclose each
    /// <code>InputPathsMaps</code> value in brackets: <<i>value</i>> The
    /// InputTemplate must be valid JSON.</p>
    ///
    /// <p>If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following
    /// restrictions apply:</p>
    /// <ul>
    /// <li>
    /// <p>The placeholder cannot be used as an object key.</p>
    /// </li>
    /// </ul>
    /// <p>The following example shows the syntax for using <code>InputPathsMap</code> and
    /// <code>InputTemplate</code>.</p>
    /// <p>
    /// <code> "InputTransformer":</code>
    /// </p>
    /// <p>
    /// <code>{</code>
    /// </p>
    /// <p>
    /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
    /// "$.detail.status"},</code>
    /// </p>
    /// <p>
    /// <code>"InputTemplate": "<instance> is in state <status>"</code>
    /// </p>
    /// <p>
    /// <code>}</code>
    /// </p>
    /// <p>To have the <code>InputTemplate</code> include quote marks within a JSON string, escape
    /// each quote marks with a slash, as in the following example:</p>
    /// <p>
    /// <code> "InputTransformer":</code>
    /// </p>
    /// <p>
    /// <code>{</code>
    /// </p>
    /// <p>
    /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
    /// "$.detail.status"},</code>
    /// </p>
    /// <p>
    /// <code>"InputTemplate": "<instance> is in state \"<status>\""</code>
    /// </p>
    /// <p>
    /// <code>}</code>
    /// </p>
    /// <p>The <code>InputTemplate</code> can also be valid JSON with varibles in quotes or out, as
    /// in the following example:</p>
    /// <p>
    /// <code> "InputTransformer":</code>
    /// </p>
    /// <p>
    /// <code>{</code>
    /// </p>
    /// <p>
    /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
    /// "$.detail.status"},</code>
    /// </p>
    /// <p>
    /// <code>"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is
    /// in state \"<status>\""}'</code>
    /// </p>
    /// <p>
    /// <code>}</code>
    /// </p>
    pub input_template: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputTransformer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputTransformer");
        formatter.field("input_paths_map", &self.input_paths_map);
        formatter.field("input_template", &self.input_template);
        formatter.finish()
    }
}
/// See [`InputTransformer`](crate::model::InputTransformer)
pub mod input_transformer {
    /// A builder for [`InputTransformer`](crate::model::InputTransformer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_paths_map: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) input_template: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Adds a key-value pair to `input_paths_map`.
        ///
        /// To override the contents of this collection use [`set_input_paths_map`](Self::set_input_paths_map).
        ///
        /// <p>Map of JSON paths to be extracted from the event. You can then insert these in the
        /// template in <code>InputTemplate</code> to produce the output you want to be sent to the
        /// target.</p>
        /// <p>
        /// <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON
        /// path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket
        /// notation.</p>
        /// <p>The keys cannot start with "Amazon Web Services." </p>
        pub fn input_paths_map(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.input_paths_map.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.input_paths_map = Some(hash_map);
            self
        }
        /// <p>Map of JSON paths to be extracted from the event. You can then insert these in the
        /// template in <code>InputTemplate</code> to produce the output you want to be sent to the
        /// target.</p>
        /// <p>
        /// <code>InputPathsMap</code> is an array key-value pairs, where each value is a valid JSON
        /// path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket
        /// notation.</p>
        /// <p>The keys cannot start with "Amazon Web Services." </p>
        pub fn set_input_paths_map(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.input_paths_map = input;
            self
        }
        /// <p>Input template where you specify placeholders that will be filled with the values of the
        /// keys from <code>InputPathsMap</code> to customize the data sent to the target. Enclose each
        /// <code>InputPathsMaps</code> value in brackets: <<i>value</i>> The
        /// InputTemplate must be valid JSON.</p>
        ///
        /// <p>If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following
        /// restrictions apply:</p>
        /// <ul>
        /// <li>
        /// <p>The placeholder cannot be used as an object key.</p>
        /// </li>
        /// </ul>
        /// <p>The following example shows the syntax for using <code>InputPathsMap</code> and
        /// <code>InputTemplate</code>.</p>
        /// <p>
        /// <code> "InputTransformer":</code>
        /// </p>
        /// <p>
        /// <code>{</code>
        /// </p>
        /// <p>
        /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
        /// "$.detail.status"},</code>
        /// </p>
        /// <p>
        /// <code>"InputTemplate": "<instance> is in state <status>"</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        /// <p>To have the <code>InputTemplate</code> include quote marks within a JSON string, escape
        /// each quote marks with a slash, as in the following example:</p>
        /// <p>
        /// <code> "InputTransformer":</code>
        /// </p>
        /// <p>
        /// <code>{</code>
        /// </p>
        /// <p>
        /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
        /// "$.detail.status"},</code>
        /// </p>
        /// <p>
        /// <code>"InputTemplate": "<instance> is in state \"<status>\""</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        /// <p>The <code>InputTemplate</code> can also be valid JSON with varibles in quotes or out, as
        /// in the following example:</p>
        /// <p>
        /// <code> "InputTransformer":</code>
        /// </p>
        /// <p>
        /// <code>{</code>
        /// </p>
        /// <p>
        /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
        /// "$.detail.status"},</code>
        /// </p>
        /// <p>
        /// <code>"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is
        /// in state \"<status>\""}'</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        pub fn input_template(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_template = Some(input.into());
            self
        }
        /// <p>Input template where you specify placeholders that will be filled with the values of the
        /// keys from <code>InputPathsMap</code> to customize the data sent to the target. Enclose each
        /// <code>InputPathsMaps</code> value in brackets: <<i>value</i>> The
        /// InputTemplate must be valid JSON.</p>
        ///
        /// <p>If <code>InputTemplate</code> is a JSON object (surrounded by curly braces), the following
        /// restrictions apply:</p>
        /// <ul>
        /// <li>
        /// <p>The placeholder cannot be used as an object key.</p>
        /// </li>
        /// </ul>
        /// <p>The following example shows the syntax for using <code>InputPathsMap</code> and
        /// <code>InputTemplate</code>.</p>
        /// <p>
        /// <code> "InputTransformer":</code>
        /// </p>
        /// <p>
        /// <code>{</code>
        /// </p>
        /// <p>
        /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
        /// "$.detail.status"},</code>
        /// </p>
        /// <p>
        /// <code>"InputTemplate": "<instance> is in state <status>"</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        /// <p>To have the <code>InputTemplate</code> include quote marks within a JSON string, escape
        /// each quote marks with a slash, as in the following example:</p>
        /// <p>
        /// <code> "InputTransformer":</code>
        /// </p>
        /// <p>
        /// <code>{</code>
        /// </p>
        /// <p>
        /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
        /// "$.detail.status"},</code>
        /// </p>
        /// <p>
        /// <code>"InputTemplate": "<instance> is in state \"<status>\""</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        /// <p>The <code>InputTemplate</code> can also be valid JSON with varibles in quotes or out, as
        /// in the following example:</p>
        /// <p>
        /// <code> "InputTransformer":</code>
        /// </p>
        /// <p>
        /// <code>{</code>
        /// </p>
        /// <p>
        /// <code>"InputPathsMap": {"instance": "$.detail.instance","status":
        /// "$.detail.status"},</code>
        /// </p>
        /// <p>
        /// <code>"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is
        /// in state \"<status>\""}'</code>
        /// </p>
        /// <p>
        /// <code>}</code>
        /// </p>
        pub fn set_input_template(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_template = input;
            self
        }
        /// Consumes the builder and constructs a [`InputTransformer`](crate::model::InputTransformer)
        pub fn build(self) -> crate::model::InputTransformer {
            crate::model::InputTransformer {
                input_paths_map: self.input_paths_map,
                input_template: self.input_template,
            }
        }
    }
}
impl InputTransformer {
    /// Creates a new builder-style object to manufacture [`InputTransformer`](crate::model::InputTransformer)
    pub fn builder() -> crate::model::input_transformer::Builder {
        crate::model::input_transformer::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RuleState {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RuleState {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => RuleState::Disabled,
            "ENABLED" => RuleState::Enabled,
            other => RuleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RuleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RuleState::from(s))
    }
}
impl RuleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RuleState::Disabled => "DISABLED",
            RuleState::Enabled => "ENABLED",
            RuleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for RuleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A JSON string which you can use to limit the event bus permissions you are granting to
/// only accounts that fulfill the condition. Currently, the only supported condition is
/// membership in a certain Amazon Web Services organization. The string must contain <code>Type</code>,
/// <code>Key</code>, and <code>Value</code> fields. The <code>Value</code> field specifies the
/// ID of the Amazon Web Services organization. Following is an example value for <code>Condition</code>:</p>
/// <p>
/// <code>'{"Type" : "StringEquals", "Key": "aws:PrincipalOrgID", "Value":
/// "o-1234567890"}'</code>
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Condition {
    /// <p>Specifies the type of condition. Currently the only supported value is
    /// <code>StringEquals</code>.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>Specifies the key for the condition. Currently the only supported key is
    /// <code>aws:PrincipalOrgID</code>.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>Specifies the value for the key. Currently, this must be the ID of the
    /// organization.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Condition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Condition");
        formatter.field("r#type", &self.r#type);
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Condition`](crate::model::Condition)
pub mod condition {
    /// A builder for [`Condition`](crate::model::Condition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the type of condition. Currently the only supported value is
        /// <code>StringEquals</code>.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>Specifies the type of condition. Currently the only supported value is
        /// <code>StringEquals</code>.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Specifies the key for the condition. Currently the only supported key is
        /// <code>aws:PrincipalOrgID</code>.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>Specifies the key for the condition. Currently the only supported key is
        /// <code>aws:PrincipalOrgID</code>.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>Specifies the value for the key. Currently, this must be the ID of the
        /// organization.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>Specifies the value for the key. Currently, this must be the ID of the
        /// organization.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Condition`](crate::model::Condition)
        pub fn build(self) -> crate::model::Condition {
            crate::model::Condition {
                r#type: self.r#type,
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Condition {
    /// Creates a new builder-style object to manufacture [`Condition`](crate::model::Condition)
    pub fn builder() -> crate::model::condition::Builder {
        crate::model::condition::Builder::default()
    }
}

/// <p>Represents an event that a partner tried to generate, but failed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPartnerEventsResultEntry {
    /// <p>The ID of the event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The error code that indicates why the event submission failed.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message that explains why the event submission failed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutPartnerEventsResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPartnerEventsResultEntry");
        formatter.field("event_id", &self.event_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PutPartnerEventsResultEntry`](crate::model::PutPartnerEventsResultEntry)
pub mod put_partner_events_result_entry {
    /// A builder for [`PutPartnerEventsResultEntry`](crate::model::PutPartnerEventsResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The error code that indicates why the event submission failed.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that indicates why the event submission failed.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message that explains why the event submission failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message that explains why the event submission failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPartnerEventsResultEntry`](crate::model::PutPartnerEventsResultEntry)
        pub fn build(self) -> crate::model::PutPartnerEventsResultEntry {
            crate::model::PutPartnerEventsResultEntry {
                event_id: self.event_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PutPartnerEventsResultEntry {
    /// Creates a new builder-style object to manufacture [`PutPartnerEventsResultEntry`](crate::model::PutPartnerEventsResultEntry)
    pub fn builder() -> crate::model::put_partner_events_result_entry::Builder {
        crate::model::put_partner_events_result_entry::Builder::default()
    }
}

/// <p>The details about an event generated by an SaaS partner.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPartnerEventsRequestEntry {
    /// <p>The date and time of the event.</p>
    pub time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The event source that is generating the entry.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily
    /// concerns. Any number, including zero, may be present.</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A free-form string used to decide what fields to expect in the event detail.</p>
    pub detail_type: std::option::Option<std::string::String>,
    /// <p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields
    /// and nested subobjects.</p>
    pub detail: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutPartnerEventsRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPartnerEventsRequestEntry");
        formatter.field("time", &self.time);
        formatter.field("source", &self.source);
        formatter.field("resources", &self.resources);
        formatter.field("detail_type", &self.detail_type);
        formatter.field("detail", &self.detail);
        formatter.finish()
    }
}
/// See [`PutPartnerEventsRequestEntry`](crate::model::PutPartnerEventsRequestEntry)
pub mod put_partner_events_request_entry {
    /// A builder for [`PutPartnerEventsRequestEntry`](crate::model::PutPartnerEventsRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) detail_type: std::option::Option<std::string::String>,
        pub(crate) detail: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time of the event.</p>
        pub fn time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.time = Some(input);
            self
        }
        /// <p>The date and time of the event.</p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.time = input;
            self
        }
        /// <p>The event source that is generating the entry.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The event source that is generating the entry.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily
        /// concerns. Any number, including zero, may be present.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily
        /// concerns. Any number, including zero, may be present.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>A free-form string used to decide what fields to expect in the event detail.</p>
        pub fn detail_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail_type = Some(input.into());
            self
        }
        /// <p>A free-form string used to decide what fields to expect in the event detail.</p>
        pub fn set_detail_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail_type = input;
            self
        }
        /// <p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields
        /// and nested subobjects.</p>
        pub fn detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail = Some(input.into());
            self
        }
        /// <p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields
        /// and nested subobjects.</p>
        pub fn set_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPartnerEventsRequestEntry`](crate::model::PutPartnerEventsRequestEntry)
        pub fn build(self) -> crate::model::PutPartnerEventsRequestEntry {
            crate::model::PutPartnerEventsRequestEntry {
                time: self.time,
                source: self.source,
                resources: self.resources,
                detail_type: self.detail_type,
                detail: self.detail,
            }
        }
    }
}
impl PutPartnerEventsRequestEntry {
    /// Creates a new builder-style object to manufacture [`PutPartnerEventsRequestEntry`](crate::model::PutPartnerEventsRequestEntry)
    pub fn builder() -> crate::model::put_partner_events_request_entry::Builder {
        crate::model::put_partner_events_request_entry::Builder::default()
    }
}

/// <p>Represents an event that failed to be submitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventsResultEntry {
    /// <p>The ID of the event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The error code that indicates why the event submission failed.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message that explains why the event submission failed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutEventsResultEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventsResultEntry");
        formatter.field("event_id", &self.event_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`PutEventsResultEntry`](crate::model::PutEventsResultEntry)
pub mod put_events_result_entry {
    /// A builder for [`PutEventsResultEntry`](crate::model::PutEventsResultEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The ID of the event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// <p>The error code that indicates why the event submission failed.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that indicates why the event submission failed.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message that explains why the event submission failed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message that explains why the event submission failed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventsResultEntry`](crate::model::PutEventsResultEntry)
        pub fn build(self) -> crate::model::PutEventsResultEntry {
            crate::model::PutEventsResultEntry {
                event_id: self.event_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl PutEventsResultEntry {
    /// Creates a new builder-style object to manufacture [`PutEventsResultEntry`](crate::model::PutEventsResultEntry)
    pub fn builder() -> crate::model::put_events_result_entry::Builder {
        crate::model::put_events_result_entry::Builder::default()
    }
}

/// <p>Represents an event to be submitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutEventsRequestEntry {
    /// <p>The time stamp of the event, per <a href="https://www.rfc-editor.org/rfc/rfc3339.txt">RFC3339</a>. If no time stamp is provided, the time stamp of the <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html">PutEvents</a> call is used.</p>
    pub time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The source of the event.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily
    /// concerns. Any number, including zero, may be present.</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Free-form string used to decide what fields to expect in the event detail.</p>
    pub detail_type: std::option::Option<std::string::String>,
    /// <p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields
    /// and nested subobjects.</p>
    pub detail: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus to receive the event. Only the rules that are associated
    /// with this event bus are used to match the event. If you omit this, the default event bus is
    /// used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
    /// <p>An X-Ray trade header, which is an http header (X-Amzn-Trace-Id) that contains the
    /// trace-id associated with the event.</p>
    /// <p>To learn more about X-Ray trace headers, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader">Tracing header</a> in the X-Ray Developer Guide.</p>
    pub trace_header: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PutEventsRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutEventsRequestEntry");
        formatter.field("time", &self.time);
        formatter.field("source", &self.source);
        formatter.field("resources", &self.resources);
        formatter.field("detail_type", &self.detail_type);
        formatter.field("detail", &self.detail);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.field("trace_header", &self.trace_header);
        formatter.finish()
    }
}
/// See [`PutEventsRequestEntry`](crate::model::PutEventsRequestEntry)
pub mod put_events_request_entry {
    /// A builder for [`PutEventsRequestEntry`](crate::model::PutEventsRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) detail_type: std::option::Option<std::string::String>,
        pub(crate) detail: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
        pub(crate) trace_header: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time stamp of the event, per <a href="https://www.rfc-editor.org/rfc/rfc3339.txt">RFC3339</a>. If no time stamp is provided, the time stamp of the <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html">PutEvents</a> call is used.</p>
        pub fn time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.time = Some(input);
            self
        }
        /// <p>The time stamp of the event, per <a href="https://www.rfc-editor.org/rfc/rfc3339.txt">RFC3339</a>. If no time stamp is provided, the time stamp of the <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html">PutEvents</a> call is used.</p>
        pub fn set_time(mut self, input: std::option::Option<aws_smithy_types::Instant>) -> Self {
            self.time = input;
            self
        }
        /// <p>The source of the event.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the event.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily
        /// concerns. Any number, including zero, may be present.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily
        /// concerns. Any number, including zero, may be present.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// <p>Free-form string used to decide what fields to expect in the event detail.</p>
        pub fn detail_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail_type = Some(input.into());
            self
        }
        /// <p>Free-form string used to decide what fields to expect in the event detail.</p>
        pub fn set_detail_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail_type = input;
            self
        }
        /// <p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields
        /// and nested subobjects.</p>
        pub fn detail(mut self, input: impl Into<std::string::String>) -> Self {
            self.detail = Some(input.into());
            self
        }
        /// <p>A valid JSON string. There is no other schema imposed. The JSON string may contain fields
        /// and nested subobjects.</p>
        pub fn set_detail(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.detail = input;
            self
        }
        /// <p>The name or ARN of the event bus to receive the event. Only the rules that are associated
        /// with this event bus are used to match the event. If you omit this, the default event bus is
        /// used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus to receive the event. Only the rules that are associated
        /// with this event bus are used to match the event. If you omit this, the default event bus is
        /// used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// <p>An X-Ray trade header, which is an http header (X-Amzn-Trace-Id) that contains the
        /// trace-id associated with the event.</p>
        /// <p>To learn more about X-Ray trace headers, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader">Tracing header</a> in the X-Ray Developer Guide.</p>
        pub fn trace_header(mut self, input: impl Into<std::string::String>) -> Self {
            self.trace_header = Some(input.into());
            self
        }
        /// <p>An X-Ray trade header, which is an http header (X-Amzn-Trace-Id) that contains the
        /// trace-id associated with the event.</p>
        /// <p>To learn more about X-Ray trace headers, see <a href="https://docs.aws.amazon.com/xray/latest/devguide/xray-concepts.html#xray-concepts-tracingheader">Tracing header</a> in the X-Ray Developer Guide.</p>
        pub fn set_trace_header(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.trace_header = input;
            self
        }
        /// Consumes the builder and constructs a [`PutEventsRequestEntry`](crate::model::PutEventsRequestEntry)
        pub fn build(self) -> crate::model::PutEventsRequestEntry {
            crate::model::PutEventsRequestEntry {
                time: self.time,
                source: self.source,
                resources: self.resources,
                detail_type: self.detail_type,
                detail: self.detail,
                event_bus_name: self.event_bus_name,
                trace_header: self.trace_header,
            }
        }
    }
}
impl PutEventsRequestEntry {
    /// Creates a new builder-style object to manufacture [`PutEventsRequestEntry`](crate::model::PutEventsRequestEntry)
    pub fn builder() -> crate::model::put_events_request_entry::Builder {
        crate::model::put_events_request_entry::Builder::default()
    }
}

/// <p>Contains information about a rule in Amazon EventBridge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rule {
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the rule.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The event pattern of the rule. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
    /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
    pub event_pattern: std::option::Option<std::string::String>,
    /// <p>The state of the rule.</p>
    pub state: std::option::Option<crate::model::RuleState>,
    /// <p>The description of the rule.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html">Creating an Amazon EventBridge rule that runs on a schedule</a>.</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role that is used for target invocation.</p>
    /// <p>If you're setting an event bus in another account as the target and that account granted
    /// permission to your account through an organization instead of directly by the account ID, you
    /// must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code>
    /// structure, instead of here in this parameter.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>If the rule was created on behalf of your account by an Amazon Web Services service, this field displays
    /// the principal name of the service that created the rule.</p>
    pub managed_by: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
    /// event bus is used.</p>
    pub event_bus_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Rule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rule");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("event_pattern", &self.event_pattern);
        formatter.field("state", &self.state);
        formatter.field("description", &self.description);
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("managed_by", &self.managed_by);
        formatter.field("event_bus_name", &self.event_bus_name);
        formatter.finish()
    }
}
/// See [`Rule`](crate::model::Rule)
pub mod rule {
    /// A builder for [`Rule`](crate::model::Rule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) event_pattern: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::RuleState>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
        pub(crate) event_bus_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the rule.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The event pattern of the rule. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn event_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_pattern = Some(input.into());
            self
        }
        /// <p>The event pattern of the rule. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event
        /// Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>
        pub fn set_event_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_pattern = input;
            self
        }
        /// <p>The state of the rule.</p>
        pub fn state(mut self, input: crate::model::RuleState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the rule.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RuleState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The description of the rule.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the rule.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html">Creating an Amazon EventBridge rule that runs on a schedule</a>.</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>The scheduling expression. For example, "cron(0 20 * * ? *)", "rate(5 minutes)". For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-rule-schedule.html">Creating an Amazon EventBridge rule that runs on a schedule</a>.</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that is used for target invocation.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted
        /// permission to your account through an organization instead of directly by the account ID, you
        /// must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code>
        /// structure, instead of here in this parameter.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role that is used for target invocation.</p>
        /// <p>If you're setting an event bus in another account as the target and that account granted
        /// permission to your account through an organization instead of directly by the account ID, you
        /// must specify a <code>RoleArn</code> with proper permissions in the <code>Target</code>
        /// structure, instead of here in this parameter.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>If the rule was created on behalf of your account by an Amazon Web Services service, this field displays
        /// the principal name of the service that created the rule.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>If the rule was created on behalf of your account by an Amazon Web Services service, this field displays
        /// the principal name of the service that created the rule.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn event_bus_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_bus_name = Some(input.into());
            self
        }
        /// <p>The name or ARN of the event bus associated with the rule. If you omit this, the default
        /// event bus is used.</p>
        pub fn set_event_bus_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_bus_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Rule`](crate::model::Rule)
        pub fn build(self) -> crate::model::Rule {
            crate::model::Rule {
                name: self.name,
                arn: self.arn,
                event_pattern: self.event_pattern,
                state: self.state,
                description: self.description,
                schedule_expression: self.schedule_expression,
                role_arn: self.role_arn,
                managed_by: self.managed_by,
                event_bus_name: self.event_bus_name,
            }
        }
    }
}
impl Rule {
    /// Creates a new builder-style object to manufacture [`Rule`](crate::model::Rule)
    pub fn builder() -> crate::model::rule::Builder {
        crate::model::rule::Builder::default()
    }
}

/// <p>A <code>Replay</code> object that contains details about a replay.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Replay {
    /// <p>The name of the replay.</p>
    pub replay_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the archive to replay event from.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The current state of the replay.</p>
    pub state: std::option::Option<crate::model::ReplayState>,
    /// <p>A description of why the replay is in the current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>A time stamp for the time to start replaying events. This is determined by the time in the
    /// event as described in <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time">Time</a>.</p>
    pub event_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time to start replaying events. Any event with a creation time prior
    /// to the <code>EventEndTime</code> specified is replayed.</p>
    pub event_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the last event was replayed.</p>
    pub event_last_replayed_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the replay started.</p>
    pub replay_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the replay completed.</p>
    pub replay_end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Replay {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Replay");
        formatter.field("replay_name", &self.replay_name);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("event_start_time", &self.event_start_time);
        formatter.field("event_end_time", &self.event_end_time);
        formatter.field("event_last_replayed_time", &self.event_last_replayed_time);
        formatter.field("replay_start_time", &self.replay_start_time);
        formatter.field("replay_end_time", &self.replay_end_time);
        formatter.finish()
    }
}
/// See [`Replay`](crate::model::Replay)
pub mod replay {
    /// A builder for [`Replay`](crate::model::Replay)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replay_name: std::option::Option<std::string::String>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReplayState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) event_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) event_last_replayed_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) replay_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) replay_end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the replay.</p>
        pub fn replay_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.replay_name = Some(input.into());
            self
        }
        /// <p>The name of the replay.</p>
        pub fn set_replay_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.replay_name = input;
            self
        }
        /// <p>The ARN of the archive to replay event from.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the archive to replay event from.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The current state of the replay.</p>
        pub fn state(mut self, input: crate::model::ReplayState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the replay.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ReplayState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A description of why the replay is in the current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>A description of why the replay is in the current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>A time stamp for the time to start replaying events. This is determined by the time in the
        /// event as described in <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time">Time</a>.</p>
        pub fn event_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_start_time = Some(input);
            self
        }
        /// <p>A time stamp for the time to start replaying events. This is determined by the time in the
        /// event as described in <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEventsRequestEntry.html#eventbridge-Type-PutEventsRequestEntry-Time">Time</a>.</p>
        pub fn set_event_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_start_time = input;
            self
        }
        /// <p>A time stamp for the time to start replaying events. Any event with a creation time prior
        /// to the <code>EventEndTime</code> specified is replayed.</p>
        pub fn event_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_end_time = Some(input);
            self
        }
        /// <p>A time stamp for the time to start replaying events. Any event with a creation time prior
        /// to the <code>EventEndTime</code> specified is replayed.</p>
        pub fn set_event_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_end_time = input;
            self
        }
        /// <p>A time stamp for the time that the last event was replayed.</p>
        pub fn event_last_replayed_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.event_last_replayed_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the last event was replayed.</p>
        pub fn set_event_last_replayed_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.event_last_replayed_time = input;
            self
        }
        /// <p>A time stamp for the time that the replay started.</p>
        pub fn replay_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.replay_start_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the replay started.</p>
        pub fn set_replay_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.replay_start_time = input;
            self
        }
        /// <p>A time stamp for the time that the replay completed.</p>
        pub fn replay_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.replay_end_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the replay completed.</p>
        pub fn set_replay_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.replay_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Replay`](crate::model::Replay)
        pub fn build(self) -> crate::model::Replay {
            crate::model::Replay {
                replay_name: self.replay_name,
                event_source_arn: self.event_source_arn,
                state: self.state,
                state_reason: self.state_reason,
                event_start_time: self.event_start_time,
                event_end_time: self.event_end_time,
                event_last_replayed_time: self.event_last_replayed_time,
                replay_start_time: self.replay_start_time,
                replay_end_time: self.replay_end_time,
            }
        }
    }
}
impl Replay {
    /// Creates a new builder-style object to manufacture [`Replay`](crate::model::Replay)
    pub fn builder() -> crate::model::replay::Builder {
        crate::model::replay::Builder::default()
    }
}

/// <p>A partner event source is created by an SaaS partner. If a customer creates a partner
/// event bus that matches this event source, that Amazon Web Services account can receive events from the
/// partner's applications or services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartnerEventSource {
    /// <p>The ARN of the partner event source.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the partner event source.</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PartnerEventSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartnerEventSource");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`PartnerEventSource`](crate::model::PartnerEventSource)
pub mod partner_event_source {
    /// A builder for [`PartnerEventSource`](crate::model::PartnerEventSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the partner event source.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the partner event source.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the partner event source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the partner event source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`PartnerEventSource`](crate::model::PartnerEventSource)
        pub fn build(self) -> crate::model::PartnerEventSource {
            crate::model::PartnerEventSource {
                arn: self.arn,
                name: self.name,
            }
        }
    }
}
impl PartnerEventSource {
    /// Creates a new builder-style object to manufacture [`PartnerEventSource`](crate::model::PartnerEventSource)
    pub fn builder() -> crate::model::partner_event_source::Builder {
        crate::model::partner_event_source::Builder::default()
    }
}

/// <p>The Amazon Web Services account that a partner event source has been offered to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartnerEventSourceAccount {
    /// <p>The Amazon Web Services account ID that the partner event source was offered to.</p>
    pub account: std::option::Option<std::string::String>,
    /// <p>The date and time the event source was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
    /// matching event bus for it.</p>
    pub expiration_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
    /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
    /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
    /// created a matching event bus, but the event source has since been deleted.</p>
    pub state: std::option::Option<crate::model::EventSourceState>,
}
impl std::fmt::Debug for PartnerEventSourceAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartnerEventSourceAccount");
        formatter.field("account", &self.account);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`PartnerEventSourceAccount`](crate::model::PartnerEventSourceAccount)
pub mod partner_event_source_account {
    /// A builder for [`PartnerEventSourceAccount`](crate::model::PartnerEventSourceAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state: std::option::Option<crate::model::EventSourceState>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID that the partner event source was offered to.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.account = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that the partner event source was offered to.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account = input;
            self
        }
        /// <p>The date and time the event source was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time the event source was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
        /// matching event bus for it.</p>
        pub fn expiration_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
        /// matching event bus for it.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
        /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
        /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
        /// created a matching event bus, but the event source has since been deleted.</p>
        pub fn state(mut self, input: crate::model::EventSourceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
        /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
        /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
        /// created a matching event bus, but the event source has since been deleted.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EventSourceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`PartnerEventSourceAccount`](crate::model::PartnerEventSourceAccount)
        pub fn build(self) -> crate::model::PartnerEventSourceAccount {
            crate::model::PartnerEventSourceAccount {
                account: self.account,
                creation_time: self.creation_time,
                expiration_time: self.expiration_time,
                state: self.state,
            }
        }
    }
}
impl PartnerEventSourceAccount {
    /// Creates a new builder-style object to manufacture [`PartnerEventSourceAccount`](crate::model::PartnerEventSourceAccount)
    pub fn builder() -> crate::model::partner_event_source_account::Builder {
        crate::model::partner_event_source_account::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EventSourceState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EventSourceState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => EventSourceState::Active,
            "DELETED" => EventSourceState::Deleted,
            "PENDING" => EventSourceState::Pending,
            other => EventSourceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EventSourceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EventSourceState::from(s))
    }
}
impl EventSourceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EventSourceState::Active => "ACTIVE",
            EventSourceState::Deleted => "DELETED",
            EventSourceState::Pending => "PENDING",
            EventSourceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DELETED", "PENDING"]
    }
}
impl AsRef<str> for EventSourceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A partner event source is created by an SaaS partner. If a customer creates a partner
/// event bus that matches this event source, that Amazon Web Services account can receive events from the
/// partner's applications or services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSource {
    /// <p>The ARN of the event source.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the partner that created the event source.</p>
    pub created_by: std::option::Option<std::string::String>,
    /// <p>The date and time the event source was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
    /// matching event bus for it.</p>
    pub expiration_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the event source.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
    /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
    /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
    /// created a matching event bus, but the event source has since been deleted.</p>
    pub state: std::option::Option<crate::model::EventSourceState>,
}
impl std::fmt::Debug for EventSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSource");
        formatter.field("arn", &self.arn);
        formatter.field("created_by", &self.created_by);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("expiration_time", &self.expiration_time);
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`EventSource`](crate::model::EventSource)
pub mod event_source {
    /// A builder for [`EventSource`](crate::model::EventSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_by: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::EventSourceState>,
    }
    impl Builder {
        /// <p>The ARN of the event source.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event source.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the partner that created the event source.</p>
        pub fn created_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by = Some(input.into());
            self
        }
        /// <p>The name of the partner that created the event source.</p>
        pub fn set_created_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.created_by = input;
            self
        }
        /// <p>The date and time the event source was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The date and time the event source was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
        /// matching event bus for it.</p>
        pub fn expiration_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_time = Some(input);
            self
        }
        /// <p>The date and time that the event source will expire, if the Amazon Web Services account doesn't create a
        /// matching event bus for it.</p>
        pub fn set_expiration_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_time = input;
            self
        }
        /// <p>The name of the event source.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event source.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
        /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
        /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
        /// created a matching event bus, but the event source has since been deleted.</p>
        pub fn state(mut self, input: crate::model::EventSourceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the event source. If it is ACTIVE, you have already created a matching event
        /// bus for this event source, and that event bus is active. If it is PENDING, either you haven't
        /// yet created a matching event bus, or that event bus is deactivated. If it is DELETED, you have
        /// created a matching event bus, but the event source has since been deleted.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::EventSourceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSource`](crate::model::EventSource)
        pub fn build(self) -> crate::model::EventSource {
            crate::model::EventSource {
                arn: self.arn,
                created_by: self.created_by,
                creation_time: self.creation_time,
                expiration_time: self.expiration_time,
                name: self.name,
                state: self.state,
            }
        }
    }
}
impl EventSource {
    /// Creates a new builder-style object to manufacture [`EventSource`](crate::model::EventSource)
    pub fn builder() -> crate::model::event_source::Builder {
        crate::model::event_source::Builder::default()
    }
}

/// <p>An event bus receives events from a source and routes them to rules associated with that
/// event bus. Your account's default event bus receives events from Amazon Web Services services. A custom event
/// bus can receive events from your custom applications and services. A partner event bus
/// receives events from an event source created by an SaaS partner. These events come from the
/// partners services or applications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventBus {
    /// <p>The name of the event bus.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the event bus.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The permissions policy of the event bus, describing which other Amazon Web Services accounts can write
    /// events to this event bus.</p>
    pub policy: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventBus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventBus");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`EventBus`](crate::model::EventBus)
pub mod event_bus {
    /// A builder for [`EventBus`](crate::model::EventBus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) policy: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the event bus.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the event bus.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The permissions policy of the event bus, describing which other Amazon Web Services accounts can write
        /// events to this event bus.</p>
        pub fn policy(mut self, input: impl Into<std::string::String>) -> Self {
            self.policy = Some(input.into());
            self
        }
        /// <p>The permissions policy of the event bus, describing which other Amazon Web Services accounts can write
        /// events to this event bus.</p>
        pub fn set_policy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`EventBus`](crate::model::EventBus)
        pub fn build(self) -> crate::model::EventBus {
            crate::model::EventBus {
                name: self.name,
                arn: self.arn,
                policy: self.policy,
            }
        }
    }
}
impl EventBus {
    /// Creates a new builder-style object to manufacture [`EventBus`](crate::model::EventBus)
    pub fn builder() -> crate::model::event_bus::Builder {
        crate::model::event_bus::Builder::default()
    }
}

/// <p>Contains information about a connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The ARN of the connection.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The name of the connection.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the connection.</p>
    pub connection_state: std::option::Option<crate::model::ConnectionState>,
    /// <p>The reason that the connection is in the connection state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The authorization type specified for the connection.</p>
    pub authorization_type: std::option::Option<crate::model::ConnectionAuthorizationType>,
    /// <p>A time stamp for the time that the connection was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the connection was last authorized.</p>
    pub last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("name", &self.name);
        formatter.field("connection_state", &self.connection_state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("authorization_type", &self.authorization_type);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.field("last_authorized_time", &self.last_authorized_time);
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) connection_state: std::option::Option<crate::model::ConnectionState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) authorization_type:
            std::option::Option<crate::model::ConnectionAuthorizationType>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_authorized_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the connection.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The name of the connection.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the connection.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the connection.</p>
        pub fn connection_state(mut self, input: crate::model::ConnectionState) -> Self {
            self.connection_state = Some(input);
            self
        }
        /// <p>The state of the connection.</p>
        pub fn set_connection_state(
            mut self,
            input: std::option::Option<crate::model::ConnectionState>,
        ) -> Self {
            self.connection_state = input;
            self
        }
        /// <p>The reason that the connection is in the connection state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>The reason that the connection is in the connection state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The authorization type specified for the connection.</p>
        pub fn authorization_type(
            mut self,
            input: crate::model::ConnectionAuthorizationType,
        ) -> Self {
            self.authorization_type = Some(input);
            self
        }
        /// <p>The authorization type specified for the connection.</p>
        pub fn set_authorization_type(
            mut self,
            input: std::option::Option<crate::model::ConnectionAuthorizationType>,
        ) -> Self {
            self.authorization_type = input;
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn last_authorized_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_authorized_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the connection was last authorized.</p>
        pub fn set_last_authorized_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_authorized_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                connection_arn: self.connection_arn,
                name: self.name,
                connection_state: self.connection_state,
                state_reason: self.state_reason,
                authorization_type: self.authorization_type,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
                last_authorized_time: self.last_authorized_time,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}

/// <p>An <code>Archive</code> object that contains details about an archive.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Archive {
    /// <p>The name of the archive.</p>
    pub archive_name: std::option::Option<std::string::String>,
    /// <p>The ARN of the event bus associated with the archive. Only events from this event bus are
    /// sent to the archive.</p>
    pub event_source_arn: std::option::Option<std::string::String>,
    /// <p>The current state of the archive.</p>
    pub state: std::option::Option<crate::model::ArchiveState>,
    /// <p>A description for the reason that the archive is in the current state.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>The number of days to retain events in the archive before they are deleted.</p>
    pub retention_days: std::option::Option<i32>,
    /// <p>The size of the archive, in bytes.</p>
    pub size_bytes: i64,
    /// <p>The number of events in the archive.</p>
    pub event_count: i64,
    /// <p>The time stamp for the time that the archive was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for Archive {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Archive");
        formatter.field("archive_name", &self.archive_name);
        formatter.field("event_source_arn", &self.event_source_arn);
        formatter.field("state", &self.state);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("retention_days", &self.retention_days);
        formatter.field("size_bytes", &self.size_bytes);
        formatter.field("event_count", &self.event_count);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`Archive`](crate::model::Archive)
pub mod archive {
    /// A builder for [`Archive`](crate::model::Archive)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_name: std::option::Option<std::string::String>,
        pub(crate) event_source_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ArchiveState>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) retention_days: std::option::Option<i32>,
        pub(crate) size_bytes: std::option::Option<i64>,
        pub(crate) event_count: std::option::Option<i64>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the archive.</p>
        pub fn archive_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.archive_name = Some(input.into());
            self
        }
        /// <p>The name of the archive.</p>
        pub fn set_archive_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.archive_name = input;
            self
        }
        /// <p>The ARN of the event bus associated with the archive. Only events from this event bus are
        /// sent to the archive.</p>
        pub fn event_source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_source_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the event bus associated with the archive. Only events from this event bus are
        /// sent to the archive.</p>
        pub fn set_event_source_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_source_arn = input;
            self
        }
        /// <p>The current state of the archive.</p>
        pub fn state(mut self, input: crate::model::ArchiveState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the archive.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::ArchiveState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A description for the reason that the archive is in the current state.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>A description for the reason that the archive is in the current state.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>The number of days to retain events in the archive before they are deleted.</p>
        pub fn retention_days(mut self, input: i32) -> Self {
            self.retention_days = Some(input);
            self
        }
        /// <p>The number of days to retain events in the archive before they are deleted.</p>
        pub fn set_retention_days(mut self, input: std::option::Option<i32>) -> Self {
            self.retention_days = input;
            self
        }
        /// <p>The size of the archive, in bytes.</p>
        pub fn size_bytes(mut self, input: i64) -> Self {
            self.size_bytes = Some(input);
            self
        }
        /// <p>The size of the archive, in bytes.</p>
        pub fn set_size_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.size_bytes = input;
            self
        }
        /// <p>The number of events in the archive.</p>
        pub fn event_count(mut self, input: i64) -> Self {
            self.event_count = Some(input);
            self
        }
        /// <p>The number of events in the archive.</p>
        pub fn set_event_count(mut self, input: std::option::Option<i64>) -> Self {
            self.event_count = input;
            self
        }
        /// <p>The time stamp for the time that the archive was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time stamp for the time that the archive was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Archive`](crate::model::Archive)
        pub fn build(self) -> crate::model::Archive {
            crate::model::Archive {
                archive_name: self.archive_name,
                event_source_arn: self.event_source_arn,
                state: self.state,
                state_reason: self.state_reason,
                retention_days: self.retention_days,
                size_bytes: self.size_bytes.unwrap_or_default(),
                event_count: self.event_count.unwrap_or_default(),
                creation_time: self.creation_time,
            }
        }
    }
}
impl Archive {
    /// Creates a new builder-style object to manufacture [`Archive`](crate::model::Archive)
    pub fn builder() -> crate::model::archive::Builder {
        crate::model::archive::Builder::default()
    }
}

/// <p>Contains details about an API destination.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiDestination {
    /// <p>The ARN of the API destination.</p>
    pub api_destination_arn: std::option::Option<std::string::String>,
    /// <p>The name of the API destination.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The state of the API destination.</p>
    pub api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
    /// <p>The ARN of the connection specified for the API destination.</p>
    pub connection_arn: std::option::Option<std::string::String>,
    /// <p>The URL to the endpoint for the API destination.</p>
    pub invocation_endpoint: std::option::Option<std::string::String>,
    /// <p>The method to use to connect to the HTTP endpoint.</p>
    pub http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
    /// <p>The maximum number of invocations per second to send to the HTTP endpoint.</p>
    pub invocation_rate_limit_per_second: std::option::Option<i32>,
    /// <p>A time stamp for the time that the API destination was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A time stamp for the time that the API destination was last modified.</p>
    pub last_modified_time: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ApiDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiDestination");
        formatter.field("api_destination_arn", &self.api_destination_arn);
        formatter.field("name", &self.name);
        formatter.field("api_destination_state", &self.api_destination_state);
        formatter.field("connection_arn", &self.connection_arn);
        formatter.field("invocation_endpoint", &self.invocation_endpoint);
        formatter.field("http_method", &self.http_method);
        formatter.field(
            "invocation_rate_limit_per_second",
            &self.invocation_rate_limit_per_second,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modified_time", &self.last_modified_time);
        formatter.finish()
    }
}
/// See [`ApiDestination`](crate::model::ApiDestination)
pub mod api_destination {
    /// A builder for [`ApiDestination`](crate::model::ApiDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_destination_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) api_destination_state: std::option::Option<crate::model::ApiDestinationState>,
        pub(crate) connection_arn: std::option::Option<std::string::String>,
        pub(crate) invocation_endpoint: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        pub(crate) invocation_rate_limit_per_second: std::option::Option<i32>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_modified_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The ARN of the API destination.</p>
        pub fn api_destination_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_destination_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the API destination.</p>
        pub fn set_api_destination_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_destination_arn = input;
            self
        }
        /// <p>The name of the API destination.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the API destination.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The state of the API destination.</p>
        pub fn api_destination_state(mut self, input: crate::model::ApiDestinationState) -> Self {
            self.api_destination_state = Some(input);
            self
        }
        /// <p>The state of the API destination.</p>
        pub fn set_api_destination_state(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationState>,
        ) -> Self {
            self.api_destination_state = input;
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn connection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.connection_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the connection specified for the API destination.</p>
        pub fn set_connection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connection_arn = input;
            self
        }
        /// <p>The URL to the endpoint for the API destination.</p>
        pub fn invocation_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.invocation_endpoint = Some(input.into());
            self
        }
        /// <p>The URL to the endpoint for the API destination.</p>
        pub fn set_invocation_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invocation_endpoint = input;
            self
        }
        /// <p>The method to use to connect to the HTTP endpoint.</p>
        pub fn http_method(mut self, input: crate::model::ApiDestinationHttpMethod) -> Self {
            self.http_method = Some(input);
            self
        }
        /// <p>The method to use to connect to the HTTP endpoint.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ApiDestinationHttpMethod>,
        ) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The maximum number of invocations per second to send to the HTTP endpoint.</p>
        pub fn invocation_rate_limit_per_second(mut self, input: i32) -> Self {
            self.invocation_rate_limit_per_second = Some(input);
            self
        }
        /// <p>The maximum number of invocations per second to send to the HTTP endpoint.</p>
        pub fn set_invocation_rate_limit_per_second(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.invocation_rate_limit_per_second = input;
            self
        }
        /// <p>A time stamp for the time that the API destination was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the API destination was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>A time stamp for the time that the API destination was last modified.</p>
        pub fn last_modified_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified_time = Some(input);
            self
        }
        /// <p>A time stamp for the time that the API destination was last modified.</p>
        pub fn set_last_modified_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiDestination`](crate::model::ApiDestination)
        pub fn build(self) -> crate::model::ApiDestination {
            crate::model::ApiDestination {
                api_destination_arn: self.api_destination_arn,
                name: self.name,
                api_destination_state: self.api_destination_state,
                connection_arn: self.connection_arn,
                invocation_endpoint: self.invocation_endpoint,
                http_method: self.http_method,
                invocation_rate_limit_per_second: self.invocation_rate_limit_per_second,
                creation_time: self.creation_time,
                last_modified_time: self.last_modified_time,
            }
        }
    }
}
impl ApiDestination {
    /// Creates a new builder-style object to manufacture [`ApiDestination`](crate::model::ApiDestination)
    pub fn builder() -> crate::model::api_destination::Builder {
        crate::model::api_destination::Builder::default()
    }
}

/// <p>Contains the authorization parameters to use for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionAuthResponseParameters {
    /// <p>The authorization parameters for Basic authorization.</p>
    pub basic_auth_parameters:
        std::option::Option<crate::model::ConnectionBasicAuthResponseParameters>,
    /// <p>The OAuth parameters to use for authorization.</p>
    pub o_auth_parameters: std::option::Option<crate::model::ConnectionOAuthResponseParameters>,
    /// <p>The API Key parameters to use for authorization.</p>
    pub api_key_auth_parameters:
        std::option::Option<crate::model::ConnectionApiKeyAuthResponseParameters>,
    /// <p>Additional parameters for the connection that are passed through with every invocation to
    /// the HTTP endpoint.</p>
    pub invocation_http_parameters: std::option::Option<crate::model::ConnectionHttpParameters>,
}
impl std::fmt::Debug for ConnectionAuthResponseParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionAuthResponseParameters");
        formatter.field("basic_auth_parameters", &self.basic_auth_parameters);
        formatter.field("o_auth_parameters", &self.o_auth_parameters);
        formatter.field("api_key_auth_parameters", &self.api_key_auth_parameters);
        formatter.field(
            "invocation_http_parameters",
            &self.invocation_http_parameters,
        );
        formatter.finish()
    }
}
/// See [`ConnectionAuthResponseParameters`](crate::model::ConnectionAuthResponseParameters)
pub mod connection_auth_response_parameters {
    /// A builder for [`ConnectionAuthResponseParameters`](crate::model::ConnectionAuthResponseParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) basic_auth_parameters:
            std::option::Option<crate::model::ConnectionBasicAuthResponseParameters>,
        pub(crate) o_auth_parameters:
            std::option::Option<crate::model::ConnectionOAuthResponseParameters>,
        pub(crate) api_key_auth_parameters:
            std::option::Option<crate::model::ConnectionApiKeyAuthResponseParameters>,
        pub(crate) invocation_http_parameters:
            std::option::Option<crate::model::ConnectionHttpParameters>,
    }
    impl Builder {
        /// <p>The authorization parameters for Basic authorization.</p>
        pub fn basic_auth_parameters(
            mut self,
            input: crate::model::ConnectionBasicAuthResponseParameters,
        ) -> Self {
            self.basic_auth_parameters = Some(input);
            self
        }
        /// <p>The authorization parameters for Basic authorization.</p>
        pub fn set_basic_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionBasicAuthResponseParameters>,
        ) -> Self {
            self.basic_auth_parameters = input;
            self
        }
        /// <p>The OAuth parameters to use for authorization.</p>
        pub fn o_auth_parameters(
            mut self,
            input: crate::model::ConnectionOAuthResponseParameters,
        ) -> Self {
            self.o_auth_parameters = Some(input);
            self
        }
        /// <p>The OAuth parameters to use for authorization.</p>
        pub fn set_o_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionOAuthResponseParameters>,
        ) -> Self {
            self.o_auth_parameters = input;
            self
        }
        /// <p>The API Key parameters to use for authorization.</p>
        pub fn api_key_auth_parameters(
            mut self,
            input: crate::model::ConnectionApiKeyAuthResponseParameters,
        ) -> Self {
            self.api_key_auth_parameters = Some(input);
            self
        }
        /// <p>The API Key parameters to use for authorization.</p>
        pub fn set_api_key_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionApiKeyAuthResponseParameters>,
        ) -> Self {
            self.api_key_auth_parameters = input;
            self
        }
        /// <p>Additional parameters for the connection that are passed through with every invocation to
        /// the HTTP endpoint.</p>
        pub fn invocation_http_parameters(
            mut self,
            input: crate::model::ConnectionHttpParameters,
        ) -> Self {
            self.invocation_http_parameters = Some(input);
            self
        }
        /// <p>Additional parameters for the connection that are passed through with every invocation to
        /// the HTTP endpoint.</p>
        pub fn set_invocation_http_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionHttpParameters>,
        ) -> Self {
            self.invocation_http_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionAuthResponseParameters`](crate::model::ConnectionAuthResponseParameters)
        pub fn build(self) -> crate::model::ConnectionAuthResponseParameters {
            crate::model::ConnectionAuthResponseParameters {
                basic_auth_parameters: self.basic_auth_parameters,
                o_auth_parameters: self.o_auth_parameters,
                api_key_auth_parameters: self.api_key_auth_parameters,
                invocation_http_parameters: self.invocation_http_parameters,
            }
        }
    }
}
impl ConnectionAuthResponseParameters {
    /// Creates a new builder-style object to manufacture [`ConnectionAuthResponseParameters`](crate::model::ConnectionAuthResponseParameters)
    pub fn builder() -> crate::model::connection_auth_response_parameters::Builder {
        crate::model::connection_auth_response_parameters::Builder::default()
    }
}

/// <p>Contains the authorization parameters for the connection if API Key is specified as the
/// authorization type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionApiKeyAuthResponseParameters {
    /// <p>The name of the header to use for the <code>APIKeyValue</code> used for
    /// authorization.</p>
    pub api_key_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectionApiKeyAuthResponseParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionApiKeyAuthResponseParameters");
        formatter.field("api_key_name", &self.api_key_name);
        formatter.finish()
    }
}
/// See [`ConnectionApiKeyAuthResponseParameters`](crate::model::ConnectionApiKeyAuthResponseParameters)
pub mod connection_api_key_auth_response_parameters {
    /// A builder for [`ConnectionApiKeyAuthResponseParameters`](crate::model::ConnectionApiKeyAuthResponseParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the header to use for the <code>APIKeyValue</code> used for
        /// authorization.</p>
        pub fn api_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key_name = Some(input.into());
            self
        }
        /// <p>The name of the header to use for the <code>APIKeyValue</code> used for
        /// authorization.</p>
        pub fn set_api_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionApiKeyAuthResponseParameters`](crate::model::ConnectionApiKeyAuthResponseParameters)
        pub fn build(self) -> crate::model::ConnectionApiKeyAuthResponseParameters {
            crate::model::ConnectionApiKeyAuthResponseParameters {
                api_key_name: self.api_key_name,
            }
        }
    }
}
impl ConnectionApiKeyAuthResponseParameters {
    /// Creates a new builder-style object to manufacture [`ConnectionApiKeyAuthResponseParameters`](crate::model::ConnectionApiKeyAuthResponseParameters)
    pub fn builder() -> crate::model::connection_api_key_auth_response_parameters::Builder {
        crate::model::connection_api_key_auth_response_parameters::Builder::default()
    }
}

/// <p>Contains the response parameters when OAuth is specified as the authorization type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionOAuthResponseParameters {
    /// <p>A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about
    /// the client parameters returned when OAuth is specified as the authorization type.</p>
    pub client_parameters:
        std::option::Option<crate::model::ConnectionOAuthClientResponseParameters>,
    /// <p>The URL to the HTTP endpoint that authorized the request.</p>
    pub authorization_endpoint: std::option::Option<std::string::String>,
    /// <p>The method used to connect to the HTTP endpoint.</p>
    pub http_method: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
    /// <p>The additional HTTP parameters used for the OAuth authorization request.</p>
    pub o_auth_http_parameters: std::option::Option<crate::model::ConnectionHttpParameters>,
}
impl std::fmt::Debug for ConnectionOAuthResponseParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionOAuthResponseParameters");
        formatter.field("client_parameters", &self.client_parameters);
        formatter.field("authorization_endpoint", &self.authorization_endpoint);
        formatter.field("http_method", &self.http_method);
        formatter.field("o_auth_http_parameters", &self.o_auth_http_parameters);
        formatter.finish()
    }
}
/// See [`ConnectionOAuthResponseParameters`](crate::model::ConnectionOAuthResponseParameters)
pub mod connection_o_auth_response_parameters {
    /// A builder for [`ConnectionOAuthResponseParameters`](crate::model::ConnectionOAuthResponseParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_parameters:
            std::option::Option<crate::model::ConnectionOAuthClientResponseParameters>,
        pub(crate) authorization_endpoint: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
        pub(crate) o_auth_http_parameters:
            std::option::Option<crate::model::ConnectionHttpParameters>,
    }
    impl Builder {
        /// <p>A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about
        /// the client parameters returned when OAuth is specified as the authorization type.</p>
        pub fn client_parameters(
            mut self,
            input: crate::model::ConnectionOAuthClientResponseParameters,
        ) -> Self {
            self.client_parameters = Some(input);
            self
        }
        /// <p>A <code>ConnectionOAuthClientResponseParameters</code> object that contains details about
        /// the client parameters returned when OAuth is specified as the authorization type.</p>
        pub fn set_client_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionOAuthClientResponseParameters>,
        ) -> Self {
            self.client_parameters = input;
            self
        }
        /// <p>The URL to the HTTP endpoint that authorized the request.</p>
        pub fn authorization_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_endpoint = Some(input.into());
            self
        }
        /// <p>The URL to the HTTP endpoint that authorized the request.</p>
        pub fn set_authorization_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_endpoint = input;
            self
        }
        /// <p>The method used to connect to the HTTP endpoint.</p>
        pub fn http_method(mut self, input: crate::model::ConnectionOAuthHttpMethod) -> Self {
            self.http_method = Some(input);
            self
        }
        /// <p>The method used to connect to the HTTP endpoint.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
        ) -> Self {
            self.http_method = input;
            self
        }
        /// <p>The additional HTTP parameters used for the OAuth authorization request.</p>
        pub fn o_auth_http_parameters(
            mut self,
            input: crate::model::ConnectionHttpParameters,
        ) -> Self {
            self.o_auth_http_parameters = Some(input);
            self
        }
        /// <p>The additional HTTP parameters used for the OAuth authorization request.</p>
        pub fn set_o_auth_http_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionHttpParameters>,
        ) -> Self {
            self.o_auth_http_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionOAuthResponseParameters`](crate::model::ConnectionOAuthResponseParameters)
        pub fn build(self) -> crate::model::ConnectionOAuthResponseParameters {
            crate::model::ConnectionOAuthResponseParameters {
                client_parameters: self.client_parameters,
                authorization_endpoint: self.authorization_endpoint,
                http_method: self.http_method,
                o_auth_http_parameters: self.o_auth_http_parameters,
            }
        }
    }
}
impl ConnectionOAuthResponseParameters {
    /// Creates a new builder-style object to manufacture [`ConnectionOAuthResponseParameters`](crate::model::ConnectionOAuthResponseParameters)
    pub fn builder() -> crate::model::connection_o_auth_response_parameters::Builder {
        crate::model::connection_o_auth_response_parameters::Builder::default()
    }
}

/// <p>Contains the client response parameters for the connection when OAuth is specified as the
/// authorization type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionOAuthClientResponseParameters {
    /// <p>The client ID associated with the response to the connection request.</p>
    pub client_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectionOAuthClientResponseParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionOAuthClientResponseParameters");
        formatter.field("client_id", &self.client_id);
        formatter.finish()
    }
}
/// See [`ConnectionOAuthClientResponseParameters`](crate::model::ConnectionOAuthClientResponseParameters)
pub mod connection_o_auth_client_response_parameters {
    /// A builder for [`ConnectionOAuthClientResponseParameters`](crate::model::ConnectionOAuthClientResponseParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The client ID associated with the response to the connection request.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID associated with the response to the connection request.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionOAuthClientResponseParameters`](crate::model::ConnectionOAuthClientResponseParameters)
        pub fn build(self) -> crate::model::ConnectionOAuthClientResponseParameters {
            crate::model::ConnectionOAuthClientResponseParameters {
                client_id: self.client_id,
            }
        }
    }
}
impl ConnectionOAuthClientResponseParameters {
    /// Creates a new builder-style object to manufacture [`ConnectionOAuthClientResponseParameters`](crate::model::ConnectionOAuthClientResponseParameters)
    pub fn builder() -> crate::model::connection_o_auth_client_response_parameters::Builder {
        crate::model::connection_o_auth_client_response_parameters::Builder::default()
    }
}

/// <p>Contains the authorization parameters for the connection if Basic is specified as the
/// authorization type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionBasicAuthResponseParameters {
    /// <p>The user name to use for Basic authorization.</p>
    pub username: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConnectionBasicAuthResponseParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionBasicAuthResponseParameters");
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`ConnectionBasicAuthResponseParameters`](crate::model::ConnectionBasicAuthResponseParameters)
pub mod connection_basic_auth_response_parameters {
    /// A builder for [`ConnectionBasicAuthResponseParameters`](crate::model::ConnectionBasicAuthResponseParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name to use for Basic authorization.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name to use for Basic authorization.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionBasicAuthResponseParameters`](crate::model::ConnectionBasicAuthResponseParameters)
        pub fn build(self) -> crate::model::ConnectionBasicAuthResponseParameters {
            crate::model::ConnectionBasicAuthResponseParameters {
                username: self.username,
            }
        }
    }
}
impl ConnectionBasicAuthResponseParameters {
    /// Creates a new builder-style object to manufacture [`ConnectionBasicAuthResponseParameters`](crate::model::ConnectionBasicAuthResponseParameters)
    pub fn builder() -> crate::model::connection_basic_auth_response_parameters::Builder {
        crate::model::connection_basic_auth_response_parameters::Builder::default()
    }
}

/// <p>Contains the authorization parameters for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionAuthRequestParameters {
    /// <p>A <code>CreateConnectionBasicAuthRequestParameters</code> object that contains the Basic
    /// authorization parameters to use for the connection.</p>
    pub basic_auth_parameters:
        std::option::Option<crate::model::CreateConnectionBasicAuthRequestParameters>,
    /// <p>A <code>CreateConnectionOAuthRequestParameters</code> object that contains the OAuth
    /// authorization parameters to use for the connection.</p>
    pub o_auth_parameters:
        std::option::Option<crate::model::CreateConnectionOAuthRequestParameters>,
    /// <p>A <code>CreateConnectionApiKeyAuthRequestParameters</code> object that contains the API
    /// key authorization parameters to use for the connection.</p>
    pub api_key_auth_parameters:
        std::option::Option<crate::model::CreateConnectionApiKeyAuthRequestParameters>,
    /// <p>A <code>ConnectionHttpParameters</code> object that contains the API key authorization
    /// parameters to use for the connection. Note that if you include additional parameters for the
    /// target of a rule via <code>HttpParameters</code>, including query strings, the parameters
    /// added for the connection take precedence.</p>
    pub invocation_http_parameters: std::option::Option<crate::model::ConnectionHttpParameters>,
}
impl std::fmt::Debug for CreateConnectionAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionAuthRequestParameters");
        formatter.field("basic_auth_parameters", &self.basic_auth_parameters);
        formatter.field("o_auth_parameters", &self.o_auth_parameters);
        formatter.field("api_key_auth_parameters", &self.api_key_auth_parameters);
        formatter.field(
            "invocation_http_parameters",
            &self.invocation_http_parameters,
        );
        formatter.finish()
    }
}
/// See [`CreateConnectionAuthRequestParameters`](crate::model::CreateConnectionAuthRequestParameters)
pub mod create_connection_auth_request_parameters {
    /// A builder for [`CreateConnectionAuthRequestParameters`](crate::model::CreateConnectionAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) basic_auth_parameters:
            std::option::Option<crate::model::CreateConnectionBasicAuthRequestParameters>,
        pub(crate) o_auth_parameters:
            std::option::Option<crate::model::CreateConnectionOAuthRequestParameters>,
        pub(crate) api_key_auth_parameters:
            std::option::Option<crate::model::CreateConnectionApiKeyAuthRequestParameters>,
        pub(crate) invocation_http_parameters:
            std::option::Option<crate::model::ConnectionHttpParameters>,
    }
    impl Builder {
        /// <p>A <code>CreateConnectionBasicAuthRequestParameters</code> object that contains the Basic
        /// authorization parameters to use for the connection.</p>
        pub fn basic_auth_parameters(
            mut self,
            input: crate::model::CreateConnectionBasicAuthRequestParameters,
        ) -> Self {
            self.basic_auth_parameters = Some(input);
            self
        }
        /// <p>A <code>CreateConnectionBasicAuthRequestParameters</code> object that contains the Basic
        /// authorization parameters to use for the connection.</p>
        pub fn set_basic_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::CreateConnectionBasicAuthRequestParameters>,
        ) -> Self {
            self.basic_auth_parameters = input;
            self
        }
        /// <p>A <code>CreateConnectionOAuthRequestParameters</code> object that contains the OAuth
        /// authorization parameters to use for the connection.</p>
        pub fn o_auth_parameters(
            mut self,
            input: crate::model::CreateConnectionOAuthRequestParameters,
        ) -> Self {
            self.o_auth_parameters = Some(input);
            self
        }
        /// <p>A <code>CreateConnectionOAuthRequestParameters</code> object that contains the OAuth
        /// authorization parameters to use for the connection.</p>
        pub fn set_o_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::CreateConnectionOAuthRequestParameters>,
        ) -> Self {
            self.o_auth_parameters = input;
            self
        }
        /// <p>A <code>CreateConnectionApiKeyAuthRequestParameters</code> object that contains the API
        /// key authorization parameters to use for the connection.</p>
        pub fn api_key_auth_parameters(
            mut self,
            input: crate::model::CreateConnectionApiKeyAuthRequestParameters,
        ) -> Self {
            self.api_key_auth_parameters = Some(input);
            self
        }
        /// <p>A <code>CreateConnectionApiKeyAuthRequestParameters</code> object that contains the API
        /// key authorization parameters to use for the connection.</p>
        pub fn set_api_key_auth_parameters(
            mut self,
            input: std::option::Option<crate::model::CreateConnectionApiKeyAuthRequestParameters>,
        ) -> Self {
            self.api_key_auth_parameters = input;
            self
        }
        /// <p>A <code>ConnectionHttpParameters</code> object that contains the API key authorization
        /// parameters to use for the connection. Note that if you include additional parameters for the
        /// target of a rule via <code>HttpParameters</code>, including query strings, the parameters
        /// added for the connection take precedence.</p>
        pub fn invocation_http_parameters(
            mut self,
            input: crate::model::ConnectionHttpParameters,
        ) -> Self {
            self.invocation_http_parameters = Some(input);
            self
        }
        /// <p>A <code>ConnectionHttpParameters</code> object that contains the API key authorization
        /// parameters to use for the connection. Note that if you include additional parameters for the
        /// target of a rule via <code>HttpParameters</code>, including query strings, the parameters
        /// added for the connection take precedence.</p>
        pub fn set_invocation_http_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionHttpParameters>,
        ) -> Self {
            self.invocation_http_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionAuthRequestParameters`](crate::model::CreateConnectionAuthRequestParameters)
        pub fn build(self) -> crate::model::CreateConnectionAuthRequestParameters {
            crate::model::CreateConnectionAuthRequestParameters {
                basic_auth_parameters: self.basic_auth_parameters,
                o_auth_parameters: self.o_auth_parameters,
                api_key_auth_parameters: self.api_key_auth_parameters,
                invocation_http_parameters: self.invocation_http_parameters,
            }
        }
    }
}
impl CreateConnectionAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`CreateConnectionAuthRequestParameters`](crate::model::CreateConnectionAuthRequestParameters)
    pub fn builder() -> crate::model::create_connection_auth_request_parameters::Builder {
        crate::model::create_connection_auth_request_parameters::Builder::default()
    }
}

/// <p>Contains the API key authorization parameters for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionApiKeyAuthRequestParameters {
    /// <p>The name of the API key to use for authorization.</p>
    pub api_key_name: std::option::Option<std::string::String>,
    /// <p>The value for the API key to use for authorization.</p>
    pub api_key_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateConnectionApiKeyAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionApiKeyAuthRequestParameters");
        formatter.field("api_key_name", &self.api_key_name);
        formatter.field("api_key_value", &self.api_key_value);
        formatter.finish()
    }
}
/// See [`CreateConnectionApiKeyAuthRequestParameters`](crate::model::CreateConnectionApiKeyAuthRequestParameters)
pub mod create_connection_api_key_auth_request_parameters {
    /// A builder for [`CreateConnectionApiKeyAuthRequestParameters`](crate::model::CreateConnectionApiKeyAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api_key_name: std::option::Option<std::string::String>,
        pub(crate) api_key_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the API key to use for authorization.</p>
        pub fn api_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key_name = Some(input.into());
            self
        }
        /// <p>The name of the API key to use for authorization.</p>
        pub fn set_api_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api_key_name = input;
            self
        }
        /// <p>The value for the API key to use for authorization.</p>
        pub fn api_key_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_key_value = Some(input.into());
            self
        }
        /// <p>The value for the API key to use for authorization.</p>
        pub fn set_api_key_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_key_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionApiKeyAuthRequestParameters`](crate::model::CreateConnectionApiKeyAuthRequestParameters)
        pub fn build(self) -> crate::model::CreateConnectionApiKeyAuthRequestParameters {
            crate::model::CreateConnectionApiKeyAuthRequestParameters {
                api_key_name: self.api_key_name,
                api_key_value: self.api_key_value,
            }
        }
    }
}
impl CreateConnectionApiKeyAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`CreateConnectionApiKeyAuthRequestParameters`](crate::model::CreateConnectionApiKeyAuthRequestParameters)
    pub fn builder() -> crate::model::create_connection_api_key_auth_request_parameters::Builder {
        crate::model::create_connection_api_key_auth_request_parameters::Builder::default()
    }
}

/// <p>Contains the OAuth authorization parameters to use for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOAuthRequestParameters {
    /// <p>A <code>CreateConnectionOAuthClientRequestParameters</code> object that contains the
    /// client parameters for OAuth authorization.</p>
    pub client_parameters:
        std::option::Option<crate::model::CreateConnectionOAuthClientRequestParameters>,
    /// <p>The URL to the authorization endpoint when OAuth is specified as the authorization
    /// type.</p>
    pub authorization_endpoint: std::option::Option<std::string::String>,
    /// <p>The method to use for the authorization request.</p>
    pub http_method: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
    /// <p>A <code>ConnectionHttpParameters</code> object that contains details about the additional
    /// parameters to use for the connection.</p>
    pub o_auth_http_parameters: std::option::Option<crate::model::ConnectionHttpParameters>,
}
impl std::fmt::Debug for CreateConnectionOAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOAuthRequestParameters");
        formatter.field("client_parameters", &self.client_parameters);
        formatter.field("authorization_endpoint", &self.authorization_endpoint);
        formatter.field("http_method", &self.http_method);
        formatter.field("o_auth_http_parameters", &self.o_auth_http_parameters);
        formatter.finish()
    }
}
/// See [`CreateConnectionOAuthRequestParameters`](crate::model::CreateConnectionOAuthRequestParameters)
pub mod create_connection_o_auth_request_parameters {
    /// A builder for [`CreateConnectionOAuthRequestParameters`](crate::model::CreateConnectionOAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_parameters:
            std::option::Option<crate::model::CreateConnectionOAuthClientRequestParameters>,
        pub(crate) authorization_endpoint: std::option::Option<std::string::String>,
        pub(crate) http_method: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
        pub(crate) o_auth_http_parameters:
            std::option::Option<crate::model::ConnectionHttpParameters>,
    }
    impl Builder {
        /// <p>A <code>CreateConnectionOAuthClientRequestParameters</code> object that contains the
        /// client parameters for OAuth authorization.</p>
        pub fn client_parameters(
            mut self,
            input: crate::model::CreateConnectionOAuthClientRequestParameters,
        ) -> Self {
            self.client_parameters = Some(input);
            self
        }
        /// <p>A <code>CreateConnectionOAuthClientRequestParameters</code> object that contains the
        /// client parameters for OAuth authorization.</p>
        pub fn set_client_parameters(
            mut self,
            input: std::option::Option<crate::model::CreateConnectionOAuthClientRequestParameters>,
        ) -> Self {
            self.client_parameters = input;
            self
        }
        /// <p>The URL to the authorization endpoint when OAuth is specified as the authorization
        /// type.</p>
        pub fn authorization_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.authorization_endpoint = Some(input.into());
            self
        }
        /// <p>The URL to the authorization endpoint when OAuth is specified as the authorization
        /// type.</p>
        pub fn set_authorization_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authorization_endpoint = input;
            self
        }
        /// <p>The method to use for the authorization request.</p>
        pub fn http_method(mut self, input: crate::model::ConnectionOAuthHttpMethod) -> Self {
            self.http_method = Some(input);
            self
        }
        /// <p>The method to use for the authorization request.</p>
        pub fn set_http_method(
            mut self,
            input: std::option::Option<crate::model::ConnectionOAuthHttpMethod>,
        ) -> Self {
            self.http_method = input;
            self
        }
        /// <p>A <code>ConnectionHttpParameters</code> object that contains details about the additional
        /// parameters to use for the connection.</p>
        pub fn o_auth_http_parameters(
            mut self,
            input: crate::model::ConnectionHttpParameters,
        ) -> Self {
            self.o_auth_http_parameters = Some(input);
            self
        }
        /// <p>A <code>ConnectionHttpParameters</code> object that contains details about the additional
        /// parameters to use for the connection.</p>
        pub fn set_o_auth_http_parameters(
            mut self,
            input: std::option::Option<crate::model::ConnectionHttpParameters>,
        ) -> Self {
            self.o_auth_http_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionOAuthRequestParameters`](crate::model::CreateConnectionOAuthRequestParameters)
        pub fn build(self) -> crate::model::CreateConnectionOAuthRequestParameters {
            crate::model::CreateConnectionOAuthRequestParameters {
                client_parameters: self.client_parameters,
                authorization_endpoint: self.authorization_endpoint,
                http_method: self.http_method,
                o_auth_http_parameters: self.o_auth_http_parameters,
            }
        }
    }
}
impl CreateConnectionOAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOAuthRequestParameters`](crate::model::CreateConnectionOAuthRequestParameters)
    pub fn builder() -> crate::model::create_connection_o_auth_request_parameters::Builder {
        crate::model::create_connection_o_auth_request_parameters::Builder::default()
    }
}

/// <p>Contains the Basic authorization parameters to use for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionOAuthClientRequestParameters {
    /// <p>The client ID to use for OAuth authorization for the connection.</p>
    pub client_id: std::option::Option<std::string::String>,
    /// <p>The client secret associated with the client ID to use for OAuth authorization for the
    /// connection.</p>
    pub client_secret: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateConnectionOAuthClientRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionOAuthClientRequestParameters");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &self.client_secret);
        formatter.finish()
    }
}
/// See [`CreateConnectionOAuthClientRequestParameters`](crate::model::CreateConnectionOAuthClientRequestParameters)
pub mod create_connection_o_auth_client_request_parameters {
    /// A builder for [`CreateConnectionOAuthClientRequestParameters`](crate::model::CreateConnectionOAuthClientRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_id: std::option::Option<std::string::String>,
        pub(crate) client_secret: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The client ID to use for OAuth authorization for the connection.</p>
        pub fn client_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_id = Some(input.into());
            self
        }
        /// <p>The client ID to use for OAuth authorization for the connection.</p>
        pub fn set_client_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_id = input;
            self
        }
        /// <p>The client secret associated with the client ID to use for OAuth authorization for the
        /// connection.</p>
        pub fn client_secret(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_secret = Some(input.into());
            self
        }
        /// <p>The client secret associated with the client ID to use for OAuth authorization for the
        /// connection.</p>
        pub fn set_client_secret(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_secret = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionOAuthClientRequestParameters`](crate::model::CreateConnectionOAuthClientRequestParameters)
        pub fn build(self) -> crate::model::CreateConnectionOAuthClientRequestParameters {
            crate::model::CreateConnectionOAuthClientRequestParameters {
                client_id: self.client_id,
                client_secret: self.client_secret,
            }
        }
    }
}
impl CreateConnectionOAuthClientRequestParameters {
    /// Creates a new builder-style object to manufacture [`CreateConnectionOAuthClientRequestParameters`](crate::model::CreateConnectionOAuthClientRequestParameters)
    pub fn builder() -> crate::model::create_connection_o_auth_client_request_parameters::Builder {
        crate::model::create_connection_o_auth_client_request_parameters::Builder::default()
    }
}

/// <p>Contains the Basic authorization parameters to use for the connection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateConnectionBasicAuthRequestParameters {
    /// <p>The user name to use for Basic authorization.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The password associated with the user name to use for Basic authorization.</p>
    pub password: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateConnectionBasicAuthRequestParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateConnectionBasicAuthRequestParameters");
        formatter.field("username", &self.username);
        formatter.field("password", &self.password);
        formatter.finish()
    }
}
/// See [`CreateConnectionBasicAuthRequestParameters`](crate::model::CreateConnectionBasicAuthRequestParameters)
pub mod create_connection_basic_auth_request_parameters {
    /// A builder for [`CreateConnectionBasicAuthRequestParameters`](crate::model::CreateConnectionBasicAuthRequestParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name to use for Basic authorization.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name to use for Basic authorization.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password associated with the user name to use for Basic authorization.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password associated with the user name to use for Basic authorization.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateConnectionBasicAuthRequestParameters`](crate::model::CreateConnectionBasicAuthRequestParameters)
        pub fn build(self) -> crate::model::CreateConnectionBasicAuthRequestParameters {
            crate::model::CreateConnectionBasicAuthRequestParameters {
                username: self.username,
                password: self.password,
            }
        }
    }
}
impl CreateConnectionBasicAuthRequestParameters {
    /// Creates a new builder-style object to manufacture [`CreateConnectionBasicAuthRequestParameters`](crate::model::CreateConnectionBasicAuthRequestParameters)
    pub fn builder() -> crate::model::create_connection_basic_auth_request_parameters::Builder {
        crate::model::create_connection_basic_auth_request_parameters::Builder::default()
    }
}
