// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `DeleteAlarms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_alarms`](crate::client::Client::delete_alarms).
///
/// See [`crate::client::fluent_builders::DeleteAlarms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlarms {
    _private: (),
}
impl DeleteAlarms {
    /// Creates a new builder-style object to manufacture [`DeleteAlarmsInput`](crate::input::DeleteAlarmsInput)
    pub fn builder() -> crate::input::delete_alarms_input::Builder {
        crate::input::delete_alarms_input::Builder::default()
    }
    /// Creates a new `DeleteAlarms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlarms {
    type Output =
        std::result::Result<crate::output::DeleteAlarmsOutput, crate::error::DeleteAlarmsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_alarms_error(response)
        } else {
            crate::operation_deser::parse_delete_alarms_response(response)
        }
    }
}

/// Operation shape for `DeleteAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_anomaly_detector`](crate::client::Client::delete_anomaly_detector).
///
/// See [`crate::client::fluent_builders::DeleteAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAnomalyDetector {
    _private: (),
}
impl DeleteAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`DeleteAnomalyDetectorInput`](crate::input::DeleteAnomalyDetectorInput)
    pub fn builder() -> crate::input::delete_anomaly_detector_input::Builder {
        crate::input::delete_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `DeleteAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAnomalyDetector {
    type Output = std::result::Result<
        crate::output::DeleteAnomalyDetectorOutput,
        crate::error::DeleteAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_delete_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `DeleteDashboards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dashboards`](crate::client::Client::delete_dashboards).
///
/// See [`crate::client::fluent_builders::DeleteDashboards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDashboards {
    _private: (),
}
impl DeleteDashboards {
    /// Creates a new builder-style object to manufacture [`DeleteDashboardsInput`](crate::input::DeleteDashboardsInput)
    pub fn builder() -> crate::input::delete_dashboards_input::Builder {
        crate::input::delete_dashboards_input::Builder::default()
    }
    /// Creates a new `DeleteDashboards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDashboards {
    type Output = std::result::Result<
        crate::output::DeleteDashboardsOutput,
        crate::error::DeleteDashboardsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_dashboards_error(response)
        } else {
            crate::operation_deser::parse_delete_dashboards_response(response)
        }
    }
}

/// Operation shape for `DeleteInsightRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_insight_rules`](crate::client::Client::delete_insight_rules).
///
/// See [`crate::client::fluent_builders::DeleteInsightRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInsightRules {
    _private: (),
}
impl DeleteInsightRules {
    /// Creates a new builder-style object to manufacture [`DeleteInsightRulesInput`](crate::input::DeleteInsightRulesInput)
    pub fn builder() -> crate::input::delete_insight_rules_input::Builder {
        crate::input::delete_insight_rules_input::Builder::default()
    }
    /// Creates a new `DeleteInsightRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInsightRules {
    type Output = std::result::Result<
        crate::output::DeleteInsightRulesOutput,
        crate::error::DeleteInsightRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_insight_rules_error(response)
        } else {
            crate::operation_deser::parse_delete_insight_rules_response(response)
        }
    }
}

/// Operation shape for `DeleteMetricStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_metric_stream`](crate::client::Client::delete_metric_stream).
///
/// See [`crate::client::fluent_builders::DeleteMetricStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMetricStream {
    _private: (),
}
impl DeleteMetricStream {
    /// Creates a new builder-style object to manufacture [`DeleteMetricStreamInput`](crate::input::DeleteMetricStreamInput)
    pub fn builder() -> crate::input::delete_metric_stream_input::Builder {
        crate::input::delete_metric_stream_input::Builder::default()
    }
    /// Creates a new `DeleteMetricStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMetricStream {
    type Output = std::result::Result<
        crate::output::DeleteMetricStreamOutput,
        crate::error::DeleteMetricStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_metric_stream_error(response)
        } else {
            crate::operation_deser::parse_delete_metric_stream_response(response)
        }
    }
}

/// Operation shape for `DescribeAlarmHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_alarm_history`](crate::client::Client::describe_alarm_history).
///
/// See [`crate::client::fluent_builders::DescribeAlarmHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAlarmHistory {
    _private: (),
}
impl DescribeAlarmHistory {
    /// Creates a new builder-style object to manufacture [`DescribeAlarmHistoryInput`](crate::input::DescribeAlarmHistoryInput)
    pub fn builder() -> crate::input::describe_alarm_history_input::Builder {
        crate::input::describe_alarm_history_input::Builder::default()
    }
    /// Creates a new `DescribeAlarmHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAlarmHistory {
    type Output = std::result::Result<
        crate::output::DescribeAlarmHistoryOutput,
        crate::error::DescribeAlarmHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_alarm_history_error(response)
        } else {
            crate::operation_deser::parse_describe_alarm_history_response(response)
        }
    }
}

/// Operation shape for `DescribeAlarms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_alarms`](crate::client::Client::describe_alarms).
///
/// See [`crate::client::fluent_builders::DescribeAlarms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAlarms {
    _private: (),
}
impl DescribeAlarms {
    /// Creates a new builder-style object to manufacture [`DescribeAlarmsInput`](crate::input::DescribeAlarmsInput)
    pub fn builder() -> crate::input::describe_alarms_input::Builder {
        crate::input::describe_alarms_input::Builder::default()
    }
    /// Creates a new `DescribeAlarms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAlarms {
    type Output =
        std::result::Result<crate::output::DescribeAlarmsOutput, crate::error::DescribeAlarmsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_alarms_error(response)
        } else {
            crate::operation_deser::parse_describe_alarms_response(response)
        }
    }
}

/// Operation shape for `DescribeAlarmsForMetric`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_alarms_for_metric`](crate::client::Client::describe_alarms_for_metric).
///
/// See [`crate::client::fluent_builders::DescribeAlarmsForMetric`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAlarmsForMetric {
    _private: (),
}
impl DescribeAlarmsForMetric {
    /// Creates a new builder-style object to manufacture [`DescribeAlarmsForMetricInput`](crate::input::DescribeAlarmsForMetricInput)
    pub fn builder() -> crate::input::describe_alarms_for_metric_input::Builder {
        crate::input::describe_alarms_for_metric_input::Builder::default()
    }
    /// Creates a new `DescribeAlarmsForMetric` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAlarmsForMetric {
    type Output = std::result::Result<
        crate::output::DescribeAlarmsForMetricOutput,
        crate::error::DescribeAlarmsForMetricError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_alarms_for_metric_error(response)
        } else {
            crate::operation_deser::parse_describe_alarms_for_metric_response(response)
        }
    }
}

/// Operation shape for `DescribeAnomalyDetectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_anomaly_detectors`](crate::client::Client::describe_anomaly_detectors).
///
/// See [`crate::client::fluent_builders::DescribeAnomalyDetectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAnomalyDetectors {
    _private: (),
}
impl DescribeAnomalyDetectors {
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyDetectorsInput`](crate::input::DescribeAnomalyDetectorsInput)
    pub fn builder() -> crate::input::describe_anomaly_detectors_input::Builder {
        crate::input::describe_anomaly_detectors_input::Builder::default()
    }
    /// Creates a new `DescribeAnomalyDetectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAnomalyDetectors {
    type Output = std::result::Result<
        crate::output::DescribeAnomalyDetectorsOutput,
        crate::error::DescribeAnomalyDetectorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_anomaly_detectors_error(response)
        } else {
            crate::operation_deser::parse_describe_anomaly_detectors_response(response)
        }
    }
}

/// Operation shape for `DescribeInsightRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_insight_rules`](crate::client::Client::describe_insight_rules).
///
/// See [`crate::client::fluent_builders::DescribeInsightRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInsightRules {
    _private: (),
}
impl DescribeInsightRules {
    /// Creates a new builder-style object to manufacture [`DescribeInsightRulesInput`](crate::input::DescribeInsightRulesInput)
    pub fn builder() -> crate::input::describe_insight_rules_input::Builder {
        crate::input::describe_insight_rules_input::Builder::default()
    }
    /// Creates a new `DescribeInsightRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInsightRules {
    type Output = std::result::Result<
        crate::output::DescribeInsightRulesOutput,
        crate::error::DescribeInsightRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_insight_rules_error(response)
        } else {
            crate::operation_deser::parse_describe_insight_rules_response(response)
        }
    }
}

/// Operation shape for `DisableAlarmActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_alarm_actions`](crate::client::Client::disable_alarm_actions).
///
/// See [`crate::client::fluent_builders::DisableAlarmActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableAlarmActions {
    _private: (),
}
impl DisableAlarmActions {
    /// Creates a new builder-style object to manufacture [`DisableAlarmActionsInput`](crate::input::DisableAlarmActionsInput)
    pub fn builder() -> crate::input::disable_alarm_actions_input::Builder {
        crate::input::disable_alarm_actions_input::Builder::default()
    }
    /// Creates a new `DisableAlarmActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableAlarmActions {
    type Output = std::result::Result<
        crate::output::DisableAlarmActionsOutput,
        crate::error::DisableAlarmActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_alarm_actions_error(response)
        } else {
            crate::operation_deser::parse_disable_alarm_actions_response(response)
        }
    }
}

/// Operation shape for `DisableInsightRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_insight_rules`](crate::client::Client::disable_insight_rules).
///
/// See [`crate::client::fluent_builders::DisableInsightRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableInsightRules {
    _private: (),
}
impl DisableInsightRules {
    /// Creates a new builder-style object to manufacture [`DisableInsightRulesInput`](crate::input::DisableInsightRulesInput)
    pub fn builder() -> crate::input::disable_insight_rules_input::Builder {
        crate::input::disable_insight_rules_input::Builder::default()
    }
    /// Creates a new `DisableInsightRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableInsightRules {
    type Output = std::result::Result<
        crate::output::DisableInsightRulesOutput,
        crate::error::DisableInsightRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_insight_rules_error(response)
        } else {
            crate::operation_deser::parse_disable_insight_rules_response(response)
        }
    }
}

/// Operation shape for `EnableAlarmActions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_alarm_actions`](crate::client::Client::enable_alarm_actions).
///
/// See [`crate::client::fluent_builders::EnableAlarmActions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableAlarmActions {
    _private: (),
}
impl EnableAlarmActions {
    /// Creates a new builder-style object to manufacture [`EnableAlarmActionsInput`](crate::input::EnableAlarmActionsInput)
    pub fn builder() -> crate::input::enable_alarm_actions_input::Builder {
        crate::input::enable_alarm_actions_input::Builder::default()
    }
    /// Creates a new `EnableAlarmActions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableAlarmActions {
    type Output = std::result::Result<
        crate::output::EnableAlarmActionsOutput,
        crate::error::EnableAlarmActionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_alarm_actions_error(response)
        } else {
            crate::operation_deser::parse_enable_alarm_actions_response(response)
        }
    }
}

/// Operation shape for `EnableInsightRules`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_insight_rules`](crate::client::Client::enable_insight_rules).
///
/// See [`crate::client::fluent_builders::EnableInsightRules`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableInsightRules {
    _private: (),
}
impl EnableInsightRules {
    /// Creates a new builder-style object to manufacture [`EnableInsightRulesInput`](crate::input::EnableInsightRulesInput)
    pub fn builder() -> crate::input::enable_insight_rules_input::Builder {
        crate::input::enable_insight_rules_input::Builder::default()
    }
    /// Creates a new `EnableInsightRules` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableInsightRules {
    type Output = std::result::Result<
        crate::output::EnableInsightRulesOutput,
        crate::error::EnableInsightRulesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_insight_rules_error(response)
        } else {
            crate::operation_deser::parse_enable_insight_rules_response(response)
        }
    }
}

/// Operation shape for `GetDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dashboard`](crate::client::Client::get_dashboard).
///
/// See [`crate::client::fluent_builders::GetDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDashboard {
    _private: (),
}
impl GetDashboard {
    /// Creates a new builder-style object to manufacture [`GetDashboardInput`](crate::input::GetDashboardInput)
    pub fn builder() -> crate::input::get_dashboard_input::Builder {
        crate::input::get_dashboard_input::Builder::default()
    }
    /// Creates a new `GetDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDashboard {
    type Output =
        std::result::Result<crate::output::GetDashboardOutput, crate::error::GetDashboardError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dashboard_error(response)
        } else {
            crate::operation_deser::parse_get_dashboard_response(response)
        }
    }
}

/// Operation shape for `GetInsightRuleReport`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_insight_rule_report`](crate::client::Client::get_insight_rule_report).
///
/// See [`crate::client::fluent_builders::GetInsightRuleReport`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInsightRuleReport {
    _private: (),
}
impl GetInsightRuleReport {
    /// Creates a new builder-style object to manufacture [`GetInsightRuleReportInput`](crate::input::GetInsightRuleReportInput)
    pub fn builder() -> crate::input::get_insight_rule_report_input::Builder {
        crate::input::get_insight_rule_report_input::Builder::default()
    }
    /// Creates a new `GetInsightRuleReport` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInsightRuleReport {
    type Output = std::result::Result<
        crate::output::GetInsightRuleReportOutput,
        crate::error::GetInsightRuleReportError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_insight_rule_report_error(response)
        } else {
            crate::operation_deser::parse_get_insight_rule_report_response(response)
        }
    }
}

/// Operation shape for `GetMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_metric_data`](crate::client::Client::get_metric_data).
///
/// See [`crate::client::fluent_builders::GetMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMetricData {
    _private: (),
}
impl GetMetricData {
    /// Creates a new builder-style object to manufacture [`GetMetricDataInput`](crate::input::GetMetricDataInput)
    pub fn builder() -> crate::input::get_metric_data_input::Builder {
        crate::input::get_metric_data_input::Builder::default()
    }
    /// Creates a new `GetMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMetricData {
    type Output =
        std::result::Result<crate::output::GetMetricDataOutput, crate::error::GetMetricDataError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetMetricStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_metric_statistics`](crate::client::Client::get_metric_statistics).
///
/// See [`crate::client::fluent_builders::GetMetricStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMetricStatistics {
    _private: (),
}
impl GetMetricStatistics {
    /// Creates a new builder-style object to manufacture [`GetMetricStatisticsInput`](crate::input::GetMetricStatisticsInput)
    pub fn builder() -> crate::input::get_metric_statistics_input::Builder {
        crate::input::get_metric_statistics_input::Builder::default()
    }
    /// Creates a new `GetMetricStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMetricStatistics {
    type Output = std::result::Result<
        crate::output::GetMetricStatisticsOutput,
        crate::error::GetMetricStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_metric_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_metric_statistics_response(response)
        }
    }
}

/// Operation shape for `GetMetricStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_metric_stream`](crate::client::Client::get_metric_stream).
///
/// See [`crate::client::fluent_builders::GetMetricStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMetricStream {
    _private: (),
}
impl GetMetricStream {
    /// Creates a new builder-style object to manufacture [`GetMetricStreamInput`](crate::input::GetMetricStreamInput)
    pub fn builder() -> crate::input::get_metric_stream_input::Builder {
        crate::input::get_metric_stream_input::Builder::default()
    }
    /// Creates a new `GetMetricStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMetricStream {
    type Output = std::result::Result<
        crate::output::GetMetricStreamOutput,
        crate::error::GetMetricStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_metric_stream_error(response)
        } else {
            crate::operation_deser::parse_get_metric_stream_response(response)
        }
    }
}

/// Operation shape for `GetMetricWidgetImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_metric_widget_image`](crate::client::Client::get_metric_widget_image).
///
/// See [`crate::client::fluent_builders::GetMetricWidgetImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMetricWidgetImage {
    _private: (),
}
impl GetMetricWidgetImage {
    /// Creates a new builder-style object to manufacture [`GetMetricWidgetImageInput`](crate::input::GetMetricWidgetImageInput)
    pub fn builder() -> crate::input::get_metric_widget_image_input::Builder {
        crate::input::get_metric_widget_image_input::Builder::default()
    }
    /// Creates a new `GetMetricWidgetImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMetricWidgetImage {
    type Output = std::result::Result<
        crate::output::GetMetricWidgetImageOutput,
        crate::error::GetMetricWidgetImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_metric_widget_image_error(response)
        } else {
            crate::operation_deser::parse_get_metric_widget_image_response(response)
        }
    }
}

/// Operation shape for `ListDashboards`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dashboards`](crate::client::Client::list_dashboards).
///
/// See [`crate::client::fluent_builders::ListDashboards`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDashboards {
    _private: (),
}
impl ListDashboards {
    /// Creates a new builder-style object to manufacture [`ListDashboardsInput`](crate::input::ListDashboardsInput)
    pub fn builder() -> crate::input::list_dashboards_input::Builder {
        crate::input::list_dashboards_input::Builder::default()
    }
    /// Creates a new `ListDashboards` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDashboards {
    type Output =
        std::result::Result<crate::output::ListDashboardsOutput, crate::error::ListDashboardsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dashboards_error(response)
        } else {
            crate::operation_deser::parse_list_dashboards_response(response)
        }
    }
}

/// Operation shape for `ListMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_metrics`](crate::client::Client::list_metrics).
///
/// See [`crate::client::fluent_builders::ListMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMetrics {
    _private: (),
}
impl ListMetrics {
    /// Creates a new builder-style object to manufacture [`ListMetricsInput`](crate::input::ListMetricsInput)
    pub fn builder() -> crate::input::list_metrics_input::Builder {
        crate::input::list_metrics_input::Builder::default()
    }
    /// Creates a new `ListMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMetrics {
    type Output =
        std::result::Result<crate::output::ListMetricsOutput, crate::error::ListMetricsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_metrics_error(response)
        } else {
            crate::operation_deser::parse_list_metrics_response(response)
        }
    }
}

/// Operation shape for `ListMetricStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_metric_streams`](crate::client::Client::list_metric_streams).
///
/// See [`crate::client::fluent_builders::ListMetricStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMetricStreams {
    _private: (),
}
impl ListMetricStreams {
    /// Creates a new builder-style object to manufacture [`ListMetricStreamsInput`](crate::input::ListMetricStreamsInput)
    pub fn builder() -> crate::input::list_metric_streams_input::Builder {
        crate::input::list_metric_streams_input::Builder::default()
    }
    /// Creates a new `ListMetricStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMetricStreams {
    type Output = std::result::Result<
        crate::output::ListMetricStreamsOutput,
        crate::error::ListMetricStreamsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_metric_streams_error(response)
        } else {
            crate::operation_deser::parse_list_metric_streams_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_anomaly_detector`](crate::client::Client::put_anomaly_detector).
///
/// See [`crate::client::fluent_builders::PutAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAnomalyDetector {
    _private: (),
}
impl PutAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`PutAnomalyDetectorInput`](crate::input::PutAnomalyDetectorInput)
    pub fn builder() -> crate::input::put_anomaly_detector_input::Builder {
        crate::input::put_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `PutAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAnomalyDetector {
    type Output = std::result::Result<
        crate::output::PutAnomalyDetectorOutput,
        crate::error::PutAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_put_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `PutCompositeAlarm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_composite_alarm`](crate::client::Client::put_composite_alarm).
///
/// See [`crate::client::fluent_builders::PutCompositeAlarm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutCompositeAlarm {
    _private: (),
}
impl PutCompositeAlarm {
    /// Creates a new builder-style object to manufacture [`PutCompositeAlarmInput`](crate::input::PutCompositeAlarmInput)
    pub fn builder() -> crate::input::put_composite_alarm_input::Builder {
        crate::input::put_composite_alarm_input::Builder::default()
    }
    /// Creates a new `PutCompositeAlarm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutCompositeAlarm {
    type Output = std::result::Result<
        crate::output::PutCompositeAlarmOutput,
        crate::error::PutCompositeAlarmError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_composite_alarm_error(response)
        } else {
            crate::operation_deser::parse_put_composite_alarm_response(response)
        }
    }
}

/// Operation shape for `PutDashboard`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_dashboard`](crate::client::Client::put_dashboard).
///
/// See [`crate::client::fluent_builders::PutDashboard`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutDashboard {
    _private: (),
}
impl PutDashboard {
    /// Creates a new builder-style object to manufacture [`PutDashboardInput`](crate::input::PutDashboardInput)
    pub fn builder() -> crate::input::put_dashboard_input::Builder {
        crate::input::put_dashboard_input::Builder::default()
    }
    /// Creates a new `PutDashboard` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutDashboard {
    type Output =
        std::result::Result<crate::output::PutDashboardOutput, crate::error::PutDashboardError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_dashboard_error(response)
        } else {
            crate::operation_deser::parse_put_dashboard_response(response)
        }
    }
}

/// Operation shape for `PutInsightRule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_insight_rule`](crate::client::Client::put_insight_rule).
///
/// See [`crate::client::fluent_builders::PutInsightRule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutInsightRule {
    _private: (),
}
impl PutInsightRule {
    /// Creates a new builder-style object to manufacture [`PutInsightRuleInput`](crate::input::PutInsightRuleInput)
    pub fn builder() -> crate::input::put_insight_rule_input::Builder {
        crate::input::put_insight_rule_input::Builder::default()
    }
    /// Creates a new `PutInsightRule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutInsightRule {
    type Output =
        std::result::Result<crate::output::PutInsightRuleOutput, crate::error::PutInsightRuleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_insight_rule_error(response)
        } else {
            crate::operation_deser::parse_put_insight_rule_response(response)
        }
    }
}

/// Operation shape for `PutMetricAlarm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_metric_alarm`](crate::client::Client::put_metric_alarm).
///
/// See [`crate::client::fluent_builders::PutMetricAlarm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMetricAlarm {
    _private: (),
}
impl PutMetricAlarm {
    /// Creates a new builder-style object to manufacture [`PutMetricAlarmInput`](crate::input::PutMetricAlarmInput)
    pub fn builder() -> crate::input::put_metric_alarm_input::Builder {
        crate::input::put_metric_alarm_input::Builder::default()
    }
    /// Creates a new `PutMetricAlarm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMetricAlarm {
    type Output =
        std::result::Result<crate::output::PutMetricAlarmOutput, crate::error::PutMetricAlarmError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_metric_alarm_error(response)
        } else {
            crate::operation_deser::parse_put_metric_alarm_response(response)
        }
    }
}

/// Operation shape for `PutMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_metric_data`](crate::client::Client::put_metric_data).
///
/// See [`crate::client::fluent_builders::PutMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMetricData {
    _private: (),
}
impl PutMetricData {
    /// Creates a new builder-style object to manufacture [`PutMetricDataInput`](crate::input::PutMetricDataInput)
    pub fn builder() -> crate::input::put_metric_data_input::Builder {
        crate::input::put_metric_data_input::Builder::default()
    }
    /// Creates a new `PutMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMetricData {
    type Output =
        std::result::Result<crate::output::PutMetricDataOutput, crate::error::PutMetricDataError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_metric_data_error(response)
        } else {
            crate::operation_deser::parse_put_metric_data_response(response)
        }
    }
}

/// Operation shape for `PutMetricStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_metric_stream`](crate::client::Client::put_metric_stream).
///
/// See [`crate::client::fluent_builders::PutMetricStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutMetricStream {
    _private: (),
}
impl PutMetricStream {
    /// Creates a new builder-style object to manufacture [`PutMetricStreamInput`](crate::input::PutMetricStreamInput)
    pub fn builder() -> crate::input::put_metric_stream_input::Builder {
        crate::input::put_metric_stream_input::Builder::default()
    }
    /// Creates a new `PutMetricStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutMetricStream {
    type Output = std::result::Result<
        crate::output::PutMetricStreamOutput,
        crate::error::PutMetricStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_metric_stream_error(response)
        } else {
            crate::operation_deser::parse_put_metric_stream_response(response)
        }
    }
}

/// Operation shape for `SetAlarmState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_alarm_state`](crate::client::Client::set_alarm_state).
///
/// See [`crate::client::fluent_builders::SetAlarmState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetAlarmState {
    _private: (),
}
impl SetAlarmState {
    /// Creates a new builder-style object to manufacture [`SetAlarmStateInput`](crate::input::SetAlarmStateInput)
    pub fn builder() -> crate::input::set_alarm_state_input::Builder {
        crate::input::set_alarm_state_input::Builder::default()
    }
    /// Creates a new `SetAlarmState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetAlarmState {
    type Output =
        std::result::Result<crate::output::SetAlarmStateOutput, crate::error::SetAlarmStateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_alarm_state_error(response)
        } else {
            crate::operation_deser::parse_set_alarm_state_response(response)
        }
    }
}

/// Operation shape for `StartMetricStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_metric_streams`](crate::client::Client::start_metric_streams).
///
/// See [`crate::client::fluent_builders::StartMetricStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMetricStreams {
    _private: (),
}
impl StartMetricStreams {
    /// Creates a new builder-style object to manufacture [`StartMetricStreamsInput`](crate::input::StartMetricStreamsInput)
    pub fn builder() -> crate::input::start_metric_streams_input::Builder {
        crate::input::start_metric_streams_input::Builder::default()
    }
    /// Creates a new `StartMetricStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMetricStreams {
    type Output = std::result::Result<
        crate::output::StartMetricStreamsOutput,
        crate::error::StartMetricStreamsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_metric_streams_error(response)
        } else {
            crate::operation_deser::parse_start_metric_streams_response(response)
        }
    }
}

/// Operation shape for `StopMetricStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_metric_streams`](crate::client::Client::stop_metric_streams).
///
/// See [`crate::client::fluent_builders::StopMetricStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopMetricStreams {
    _private: (),
}
impl StopMetricStreams {
    /// Creates a new builder-style object to manufacture [`StopMetricStreamsInput`](crate::input::StopMetricStreamsInput)
    pub fn builder() -> crate::input::stop_metric_streams_input::Builder {
        crate::input::stop_metric_streams_input::Builder::default()
    }
    /// Creates a new `StopMetricStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopMetricStreams {
    type Output = std::result::Result<
        crate::output::StopMetricStreamsOutput,
        crate::error::StopMetricStreamsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_metric_streams_error(response)
        } else {
            crate::operation_deser::parse_stop_metric_streams_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}
