// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `DeleteAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAlarmsError {
    /// Kind of error that occurred.
    pub kind: DeleteAlarmsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAlarmsErrorKind {
    /// <p>The named resource does not exist.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAlarmsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAlarmsErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            DeleteAlarmsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAlarmsError {
    fn code(&self) -> Option<&str> {
        DeleteAlarmsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAlarmsError {
    /// Creates a new `DeleteAlarmsError`.
    pub fn new(kind: DeleteAlarmsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAlarmsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAlarmsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAlarmsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAlarmsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAlarmsErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(&self.kind, DeleteAlarmsErrorKind::ResourceNotFound(_))
    }
}
impl std::error::Error for DeleteAlarmsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAlarmsErrorKind::ResourceNotFound(_inner) => Some(_inner),
            DeleteAlarmsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: DeleteAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAnomalyDetectorErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>Parameters were used together that cannot be used together.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>The named resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAnomalyDetectorErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAnomalyDetectorErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        DeleteAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAnomalyDetectorError {
    /// Creates a new `DeleteAnomalyDetectorError`.
    pub fn new(kind: DeleteAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAnomalyDetectorErrorKind::InternalServiceFault(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DeleteAnomalyDetectorErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            DeleteAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDashboardsError {
    /// Kind of error that occurred.
    pub kind: DeleteDashboardsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDashboardsErrorKind {
    /// <p>The specified dashboard does not exist.</p>
    DashboardNotFoundError(crate::error::DashboardNotFoundError),
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDashboardsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDashboardsErrorKind::DashboardNotFoundError(_inner) => _inner.fmt(f),
            DeleteDashboardsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            DeleteDashboardsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteDashboardsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDashboardsError {
    fn code(&self) -> Option<&str> {
        DeleteDashboardsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDashboardsError {
    /// Creates a new `DeleteDashboardsError`.
    pub fn new(kind: DeleteDashboardsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDashboardsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDashboardsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDashboardsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDashboardsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDashboardsErrorKind::DashboardNotFoundError`.
    pub fn is_dashboard_not_found_error(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardsErrorKind::DashboardNotFoundError(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDashboardsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardsErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDashboardsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDashboardsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DeleteDashboardsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDashboardsErrorKind::DashboardNotFoundError(_inner) => Some(_inner),
            DeleteDashboardsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            DeleteDashboardsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteDashboardsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInsightRulesError {
    /// Kind of error that occurred.
    pub kind: DeleteInsightRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInsightRulesErrorKind {
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInsightRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInsightRulesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteInsightRulesErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            DeleteInsightRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInsightRulesError {
    fn code(&self) -> Option<&str> {
        DeleteInsightRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInsightRulesError {
    /// Creates a new `DeleteInsightRulesError`.
    pub fn new(kind: DeleteInsightRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInsightRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInsightRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInsightRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInsightRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInsightRulesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInsightRulesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInsightRulesErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInsightRulesErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for DeleteInsightRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInsightRulesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteInsightRulesErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            DeleteInsightRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMetricStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMetricStreamError {
    /// Kind of error that occurred.
    pub kind: DeleteMetricStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMetricStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMetricStreamErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMetricStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMetricStreamErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            DeleteMetricStreamErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteMetricStreamErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            DeleteMetricStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMetricStreamError {
    fn code(&self) -> Option<&str> {
        DeleteMetricStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMetricStreamError {
    /// Creates a new `DeleteMetricStreamError`.
    pub fn new(kind: DeleteMetricStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMetricStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMetricStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMetricStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMetricStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMetricStreamErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricStreamErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMetricStreamErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricStreamErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMetricStreamErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMetricStreamErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for DeleteMetricStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMetricStreamErrorKind::InternalServiceFault(_inner) => Some(_inner),
            DeleteMetricStreamErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteMetricStreamErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            DeleteMetricStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlarmHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAlarmHistoryError {
    /// Kind of error that occurred.
    pub kind: DescribeAlarmHistoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlarmHistory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAlarmHistoryErrorKind {
    /// <p>The next token specified is invalid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAlarmHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAlarmHistoryErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAlarmHistoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAlarmHistoryError {
    fn code(&self) -> Option<&str> {
        DescribeAlarmHistoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAlarmHistoryError {
    /// Creates a new `DescribeAlarmHistoryError`.
    pub fn new(kind: DescribeAlarmHistoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAlarmHistoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAlarmHistoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAlarmHistoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAlarmHistoryErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAlarmHistoryErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlarmHistoryErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeAlarmHistoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAlarmHistoryErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAlarmHistoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAlarmsError {
    /// Kind of error that occurred.
    pub kind: DescribeAlarmsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAlarmsErrorKind {
    /// <p>The next token specified is invalid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAlarmsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAlarmsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAlarmsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAlarmsError {
    fn code(&self) -> Option<&str> {
        DescribeAlarmsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAlarmsError {
    /// Creates a new `DescribeAlarmsError`.
    pub fn new(kind: DescribeAlarmsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAlarmsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAlarmsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAlarmsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAlarmsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAlarmsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, DescribeAlarmsErrorKind::InvalidNextToken(_))
    }
}
impl std::error::Error for DescribeAlarmsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAlarmsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAlarmsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlarmsForMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAlarmsForMetricError {
    /// Kind of error that occurred.
    pub kind: DescribeAlarmsForMetricErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlarmsForMetric` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAlarmsForMetricErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAlarmsForMetricError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAlarmsForMetricErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAlarmsForMetricError {
    fn code(&self) -> Option<&str> {
        DescribeAlarmsForMetricError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAlarmsForMetricError {
    /// Creates a new `DescribeAlarmsForMetricError`.
    pub fn new(kind: DescribeAlarmsForMetricErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAlarmsForMetricError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAlarmsForMetricErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAlarmsForMetricError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAlarmsForMetricErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAlarmsForMetricError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAlarmsForMetricErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAnomalyDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAnomalyDetectorsError {
    /// Kind of error that occurred.
    pub kind: DescribeAnomalyDetectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAnomalyDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAnomalyDetectorsErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The next token specified is invalid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>Parameters were used together that cannot be used together.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAnomalyDetectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAnomalyDetectorsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            DescribeAnomalyDetectorsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeAnomalyDetectorsErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnomalyDetectorsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnomalyDetectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAnomalyDetectorsError {
    fn code(&self) -> Option<&str> {
        DescribeAnomalyDetectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAnomalyDetectorsError {
    /// Creates a new `DescribeAnomalyDetectorsError`.
    pub fn new(kind: DescribeAnomalyDetectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAnomalyDetectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAnomalyDetectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAnomalyDetectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAnomalyDetectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorsErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorsErrorKind::InvalidNextToken(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for DescribeAnomalyDetectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAnomalyDetectorsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            DescribeAnomalyDetectorsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeAnomalyDetectorsErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            DescribeAnomalyDetectorsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DescribeAnomalyDetectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInsightRulesError {
    /// Kind of error that occurred.
    pub kind: DescribeInsightRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInsightRulesErrorKind {
    /// <p>The next token specified is invalid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInsightRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInsightRulesErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            DescribeInsightRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInsightRulesError {
    fn code(&self) -> Option<&str> {
        DescribeInsightRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInsightRulesError {
    /// Creates a new `DescribeInsightRulesError`.
    pub fn new(kind: DescribeInsightRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInsightRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInsightRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInsightRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInsightRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInsightRulesErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInsightRulesErrorKind::InvalidNextToken(_)
        )
    }
}
impl std::error::Error for DescribeInsightRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInsightRulesErrorKind::InvalidNextToken(_inner) => Some(_inner),
            DescribeInsightRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableAlarmActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableAlarmActionsError {
    /// Kind of error that occurred.
    pub kind: DisableAlarmActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableAlarmActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableAlarmActionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableAlarmActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableAlarmActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableAlarmActionsError {
    fn code(&self) -> Option<&str> {
        DisableAlarmActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableAlarmActionsError {
    /// Creates a new `DisableAlarmActionsError`.
    pub fn new(kind: DisableAlarmActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableAlarmActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableAlarmActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableAlarmActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableAlarmActionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DisableAlarmActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableAlarmActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableInsightRulesError {
    /// Kind of error that occurred.
    pub kind: DisableInsightRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableInsightRulesErrorKind {
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableInsightRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableInsightRulesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DisableInsightRulesErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisableInsightRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableInsightRulesError {
    fn code(&self) -> Option<&str> {
        DisableInsightRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableInsightRulesError {
    /// Creates a new `DisableInsightRulesError`.
    pub fn new(kind: DisableInsightRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableInsightRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableInsightRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableInsightRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableInsightRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableInsightRulesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableInsightRulesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableInsightRulesErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableInsightRulesErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for DisableInsightRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableInsightRulesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DisableInsightRulesErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            DisableInsightRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableAlarmActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableAlarmActionsError {
    /// Kind of error that occurred.
    pub kind: EnableAlarmActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableAlarmActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableAlarmActionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableAlarmActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableAlarmActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableAlarmActionsError {
    fn code(&self) -> Option<&str> {
        EnableAlarmActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableAlarmActionsError {
    /// Creates a new `EnableAlarmActionsError`.
    pub fn new(kind: EnableAlarmActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableAlarmActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableAlarmActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableAlarmActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableAlarmActionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for EnableAlarmActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableAlarmActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableInsightRulesError {
    /// Kind of error that occurred.
    pub kind: EnableInsightRulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableInsightRules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableInsightRulesErrorKind {
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The operation exceeded one or more limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableInsightRulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableInsightRulesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            EnableInsightRulesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            EnableInsightRulesErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            EnableInsightRulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableInsightRulesError {
    fn code(&self) -> Option<&str> {
        EnableInsightRulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableInsightRulesError {
    /// Creates a new `EnableInsightRulesError`.
    pub fn new(kind: EnableInsightRulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableInsightRulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableInsightRulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableInsightRulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableInsightRulesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableInsightRulesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableInsightRulesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableInsightRulesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableInsightRulesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableInsightRulesErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableInsightRulesErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for EnableInsightRulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableInsightRulesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            EnableInsightRulesErrorKind::LimitExceededException(_inner) => Some(_inner),
            EnableInsightRulesErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            EnableInsightRulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDashboardError {
    /// Kind of error that occurred.
    pub kind: GetDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDashboardErrorKind {
    /// <p>The specified dashboard does not exist.</p>
    DashboardNotFoundError(crate::error::DashboardNotFoundError),
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDashboardErrorKind::DashboardNotFoundError(_inner) => _inner.fmt(f),
            GetDashboardErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            GetDashboardErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDashboardError {
    fn code(&self) -> Option<&str> {
        GetDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDashboardError {
    /// Creates a new `GetDashboardError`.
    pub fn new(kind: GetDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDashboardErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDashboardErrorKind::DashboardNotFoundError`.
    pub fn is_dashboard_not_found_error(&self) -> bool {
        matches!(&self.kind, GetDashboardErrorKind::DashboardNotFoundError(_))
    }
    /// Returns `true` if the error kind is `GetDashboardErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(&self.kind, GetDashboardErrorKind::InternalServiceFault(_))
    }
    /// Returns `true` if the error kind is `GetDashboardErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDashboardErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for GetDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDashboardErrorKind::DashboardNotFoundError(_inner) => Some(_inner),
            GetDashboardErrorKind::InternalServiceFault(_inner) => Some(_inner),
            GetDashboardErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInsightRuleReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInsightRuleReportError {
    /// Kind of error that occurred.
    pub kind: GetInsightRuleReportErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInsightRuleReport` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInsightRuleReportErrorKind {
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>The named resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInsightRuleReportError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInsightRuleReportErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetInsightRuleReportErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetInsightRuleReportErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetInsightRuleReportErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInsightRuleReportError {
    fn code(&self) -> Option<&str> {
        GetInsightRuleReportError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInsightRuleReportError {
    /// Creates a new `GetInsightRuleReportError`.
    pub fn new(kind: GetInsightRuleReportErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInsightRuleReportError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInsightRuleReportErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInsightRuleReportError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInsightRuleReportErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInsightRuleReportErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightRuleReportErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightRuleReportErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightRuleReportErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInsightRuleReportErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInsightRuleReportErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetInsightRuleReportError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInsightRuleReportErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetInsightRuleReportErrorKind::MissingRequiredParameterException(_inner) => {
                Some(_inner)
            }
            GetInsightRuleReportErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetInsightRuleReportErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMetricDataErrorKind {
    /// <p>The next token specified is invalid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMetricDataErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            GetMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMetricDataError {
    fn code(&self) -> Option<&str> {
        GetMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMetricDataError {
    /// Creates a new `GetMetricDataError`.
    pub fn new(kind: GetMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMetricDataErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, GetMetricDataErrorKind::InvalidNextToken(_))
    }
}
impl std::error::Error for GetMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMetricDataErrorKind::InvalidNextToken(_inner) => Some(_inner),
            GetMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMetricStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMetricStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetMetricStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMetricStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMetricStatisticsErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>Parameters were used together that cannot be used together.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMetricStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMetricStatisticsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            GetMetricStatisticsErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            GetMetricStatisticsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetMetricStatisticsErrorKind::MissingRequiredParameterException(_inner) => {
                _inner.fmt(f)
            }
            GetMetricStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMetricStatisticsError {
    fn code(&self) -> Option<&str> {
        GetMetricStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMetricStatisticsError {
    /// Creates a new `GetMetricStatisticsError`.
    pub fn new(kind: GetMetricStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMetricStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMetricStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMetricStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMetricStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMetricStatisticsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStatisticsErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricStatisticsErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStatisticsErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricStatisticsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStatisticsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricStatisticsErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStatisticsErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for GetMetricStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMetricStatisticsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            GetMetricStatisticsErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            GetMetricStatisticsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetMetricStatisticsErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GetMetricStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMetricStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMetricStreamError {
    /// Kind of error that occurred.
    pub kind: GetMetricStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMetricStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMetricStreamErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>Parameters were used together that cannot be used together.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// <p>The named resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMetricStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMetricStreamErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            GetMetricStreamErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            GetMetricStreamErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetMetricStreamErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            GetMetricStreamErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMetricStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMetricStreamError {
    fn code(&self) -> Option<&str> {
        GetMetricStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMetricStreamError {
    /// Creates a new `GetMetricStreamError`.
    pub fn new(kind: GetMetricStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMetricStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMetricStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMetricStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMetricStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMetricStreamErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStreamErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricStreamErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStreamErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricStreamErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStreamErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricStreamErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStreamErrorKind::MissingRequiredParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricStreamErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricStreamErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetMetricStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMetricStreamErrorKind::InternalServiceFault(_inner) => Some(_inner),
            GetMetricStreamErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            GetMetricStreamErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetMetricStreamErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            GetMetricStreamErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMetricStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMetricWidgetImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMetricWidgetImageError {
    /// Kind of error that occurred.
    pub kind: GetMetricWidgetImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMetricWidgetImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMetricWidgetImageErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMetricWidgetImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMetricWidgetImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMetricWidgetImageError {
    fn code(&self) -> Option<&str> {
        GetMetricWidgetImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMetricWidgetImageError {
    /// Creates a new `GetMetricWidgetImageError`.
    pub fn new(kind: GetMetricWidgetImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMetricWidgetImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMetricWidgetImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMetricWidgetImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMetricWidgetImageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for GetMetricWidgetImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMetricWidgetImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDashboardsError {
    /// Kind of error that occurred.
    pub kind: ListDashboardsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDashboards` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDashboardsErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDashboardsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDashboardsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListDashboardsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDashboardsError {
    fn code(&self) -> Option<&str> {
        ListDashboardsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDashboardsError {
    /// Creates a new `ListDashboardsError`.
    pub fn new(kind: ListDashboardsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDashboardsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDashboardsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDashboardsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDashboardsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDashboardsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(&self.kind, ListDashboardsErrorKind::InternalServiceFault(_))
    }
    /// Returns `true` if the error kind is `ListDashboardsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDashboardsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for ListDashboardsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDashboardsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            ListDashboardsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListDashboardsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMetricsError {
    /// Kind of error that occurred.
    pub kind: ListMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMetricsErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMetricsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            ListMetricsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMetricsError {
    fn code(&self) -> Option<&str> {
        ListMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMetricsError {
    /// Creates a new `ListMetricsError`.
    pub fn new(kind: ListMetricsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMetricsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMetricsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(&self.kind, ListMetricsErrorKind::InternalServiceFault(_))
    }
    /// Returns `true` if the error kind is `ListMetricsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricsErrorKind::InvalidParameterValueException(_)
        )
    }
}
impl std::error::Error for ListMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMetricsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            ListMetricsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMetricStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMetricStreamsError {
    /// Kind of error that occurred.
    pub kind: ListMetricStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMetricStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMetricStreamsErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The next token specified is invalid.</p>
    InvalidNextToken(crate::error::InvalidNextToken),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMetricStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMetricStreamsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            ListMetricStreamsErrorKind::InvalidNextToken(_inner) => _inner.fmt(f),
            ListMetricStreamsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListMetricStreamsErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            ListMetricStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMetricStreamsError {
    fn code(&self) -> Option<&str> {
        ListMetricStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMetricStreamsError {
    /// Creates a new `ListMetricStreamsError`.
    pub fn new(kind: ListMetricStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMetricStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMetricStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMetricStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMetricStreamsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMetricStreamsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricStreamsErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricStreamsErrorKind::InvalidNextToken`.
    pub fn is_invalid_next_token(&self) -> bool {
        matches!(&self.kind, ListMetricStreamsErrorKind::InvalidNextToken(_))
    }
    /// Returns `true` if the error kind is `ListMetricStreamsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricStreamsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricStreamsErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricStreamsErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for ListMetricStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMetricStreamsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            ListMetricStreamsErrorKind::InvalidNextToken(_inner) => Some(_inner),
            ListMetricStreamsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListMetricStreamsErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            ListMetricStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The named resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: PutAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAnomalyDetectorErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>Parameters were used together that cannot be used together.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The operation exceeded one or more limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAnomalyDetectorErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            PutAnomalyDetectorErrorKind::InvalidParameterCombinationException(_inner) => {
                _inner.fmt(f)
            }
            PutAnomalyDetectorErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutAnomalyDetectorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutAnomalyDetectorErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            PutAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        PutAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAnomalyDetectorError {
    /// Creates a new `PutAnomalyDetectorError`.
    pub fn new(kind: PutAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAnomalyDetectorErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutAnomalyDetectorErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `PutAnomalyDetectorErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAnomalyDetectorErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAnomalyDetectorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAnomalyDetectorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAnomalyDetectorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAnomalyDetectorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutAnomalyDetectorErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutAnomalyDetectorErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for PutAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAnomalyDetectorErrorKind::InternalServiceFault(_inner) => Some(_inner),
            PutAnomalyDetectorErrorKind::InvalidParameterCombinationException(_inner) => {
                Some(_inner)
            }
            PutAnomalyDetectorErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutAnomalyDetectorErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutAnomalyDetectorErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            PutAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutCompositeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutCompositeAlarmError {
    /// Kind of error that occurred.
    pub kind: PutCompositeAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutCompositeAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutCompositeAlarmErrorKind {
    /// <p>The quota for alarms for this customer has already been reached.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutCompositeAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutCompositeAlarmErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PutCompositeAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutCompositeAlarmError {
    fn code(&self) -> Option<&str> {
        PutCompositeAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutCompositeAlarmError {
    /// Creates a new `PutCompositeAlarmError`.
    pub fn new(kind: PutCompositeAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutCompositeAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutCompositeAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutCompositeAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutCompositeAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutCompositeAlarmErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutCompositeAlarmErrorKind::LimitExceededFault(_)
        )
    }
}
impl std::error::Error for PutCompositeAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutCompositeAlarmErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PutCompositeAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutDashboardError {
    /// Kind of error that occurred.
    pub kind: PutDashboardErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutDashboard` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutDashboardErrorKind {
    /// <p>Some part of the dashboard data is invalid.</p>
    DashboardInvalidInputError(crate::error::DashboardInvalidInputError),
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutDashboardError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutDashboardErrorKind::DashboardInvalidInputError(_inner) => _inner.fmt(f),
            PutDashboardErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            PutDashboardErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutDashboardError {
    fn code(&self) -> Option<&str> {
        PutDashboardError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutDashboardError {
    /// Creates a new `PutDashboardError`.
    pub fn new(kind: PutDashboardErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutDashboardError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutDashboardErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutDashboardError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutDashboardErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutDashboardErrorKind::DashboardInvalidInputError`.
    pub fn is_dashboard_invalid_input_error(&self) -> bool {
        matches!(
            &self.kind,
            PutDashboardErrorKind::DashboardInvalidInputError(_)
        )
    }
    /// Returns `true` if the error kind is `PutDashboardErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(&self.kind, PutDashboardErrorKind::InternalServiceFault(_))
    }
}
impl std::error::Error for PutDashboardError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutDashboardErrorKind::DashboardInvalidInputError(_inner) => Some(_inner),
            PutDashboardErrorKind::InternalServiceFault(_inner) => Some(_inner),
            PutDashboardErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutInsightRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutInsightRuleError {
    /// Kind of error that occurred.
    pub kind: PutInsightRuleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutInsightRule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutInsightRuleErrorKind {
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The operation exceeded one or more limits.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutInsightRuleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutInsightRuleErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutInsightRuleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PutInsightRuleErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            PutInsightRuleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutInsightRuleError {
    fn code(&self) -> Option<&str> {
        PutInsightRuleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutInsightRuleError {
    /// Creates a new `PutInsightRuleError`.
    pub fn new(kind: PutInsightRuleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutInsightRuleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutInsightRuleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutInsightRuleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutInsightRuleErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutInsightRuleErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightRuleErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightRuleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightRuleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInsightRuleErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInsightRuleErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for PutInsightRuleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutInsightRuleErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutInsightRuleErrorKind::LimitExceededException(_inner) => Some(_inner),
            PutInsightRuleErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            PutInsightRuleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMetricAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMetricAlarmError {
    /// Kind of error that occurred.
    pub kind: PutMetricAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMetricAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMetricAlarmErrorKind {
    /// <p>The quota for alarms for this customer has already been reached.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMetricAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMetricAlarmErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            PutMetricAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMetricAlarmError {
    fn code(&self) -> Option<&str> {
        PutMetricAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMetricAlarmError {
    /// Creates a new `PutMetricAlarmError`.
    pub fn new(kind: PutMetricAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMetricAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMetricAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMetricAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMetricAlarmErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutMetricAlarmErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, PutMetricAlarmErrorKind::LimitExceededFault(_))
    }
}
impl std::error::Error for PutMetricAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMetricAlarmErrorKind::LimitExceededFault(_inner) => Some(_inner),
            PutMetricAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMetricDataError {
    /// Kind of error that occurred.
    pub kind: PutMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMetricDataErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>Parameters were used together that cannot be used together.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMetricDataErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            PutMetricDataErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            PutMetricDataErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutMetricDataErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            PutMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMetricDataError {
    fn code(&self) -> Option<&str> {
        PutMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMetricDataError {
    /// Creates a new `PutMetricDataError`.
    pub fn new(kind: PutMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutMetricDataErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(&self.kind, PutMetricDataErrorKind::InternalServiceFault(_))
    }
    /// Returns `true` if the error kind is `PutMetricDataErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricDataErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricDataErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricDataErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricDataErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricDataErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for PutMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMetricDataErrorKind::InternalServiceFault(_inner) => Some(_inner),
            PutMetricDataErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            PutMetricDataErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutMetricDataErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            PutMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutMetricStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutMetricStreamError {
    /// Kind of error that occurred.
    pub kind: PutMetricStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutMetricStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutMetricStreamErrorKind {
    /// <p>More than one process tried to modify a resource at the same time.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>Parameters were used together that cannot be used together.</p>
    InvalidParameterCombinationException(crate::error::InvalidParameterCombinationException),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutMetricStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutMetricStreamErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            PutMetricStreamErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            PutMetricStreamErrorKind::InvalidParameterCombinationException(_inner) => _inner.fmt(f),
            PutMetricStreamErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            PutMetricStreamErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            PutMetricStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutMetricStreamError {
    fn code(&self) -> Option<&str> {
        PutMetricStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutMetricStreamError {
    /// Creates a new `PutMetricStreamError`.
    pub fn new(kind: PutMetricStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutMetricStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutMetricStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutMetricStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutMetricStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutMetricStreamErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricStreamErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricStreamErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricStreamErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricStreamErrorKind::InvalidParameterCombinationException`.
    pub fn is_invalid_parameter_combination_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricStreamErrorKind::InvalidParameterCombinationException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricStreamErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricStreamErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `PutMetricStreamErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutMetricStreamErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for PutMetricStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutMetricStreamErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            PutMetricStreamErrorKind::InternalServiceFault(_inner) => Some(_inner),
            PutMetricStreamErrorKind::InvalidParameterCombinationException(_inner) => Some(_inner),
            PutMetricStreamErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            PutMetricStreamErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            PutMetricStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetAlarmState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetAlarmStateError {
    /// Kind of error that occurred.
    pub kind: SetAlarmStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetAlarmState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetAlarmStateErrorKind {
    /// <p>Data was not syntactically valid JSON.</p>
    InvalidFormatFault(crate::error::InvalidFormatFault),
    /// <p>The named resource does not exist.</p>
    ResourceNotFound(crate::error::ResourceNotFound),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetAlarmStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetAlarmStateErrorKind::InvalidFormatFault(_inner) => _inner.fmt(f),
            SetAlarmStateErrorKind::ResourceNotFound(_inner) => _inner.fmt(f),
            SetAlarmStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetAlarmStateError {
    fn code(&self) -> Option<&str> {
        SetAlarmStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetAlarmStateError {
    /// Creates a new `SetAlarmStateError`.
    pub fn new(kind: SetAlarmStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetAlarmStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetAlarmStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetAlarmStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetAlarmStateErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetAlarmStateErrorKind::InvalidFormatFault`.
    pub fn is_invalid_format_fault(&self) -> bool {
        matches!(&self.kind, SetAlarmStateErrorKind::InvalidFormatFault(_))
    }
    /// Returns `true` if the error kind is `SetAlarmStateErrorKind::ResourceNotFound`.
    pub fn is_resource_not_found(&self) -> bool {
        matches!(&self.kind, SetAlarmStateErrorKind::ResourceNotFound(_))
    }
}
impl std::error::Error for SetAlarmStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetAlarmStateErrorKind::InvalidFormatFault(_inner) => Some(_inner),
            SetAlarmStateErrorKind::ResourceNotFound(_inner) => Some(_inner),
            SetAlarmStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartMetricStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartMetricStreamsError {
    /// Kind of error that occurred.
    pub kind: StartMetricStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartMetricStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartMetricStreamsErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartMetricStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartMetricStreamsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            StartMetricStreamsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            StartMetricStreamsErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            StartMetricStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartMetricStreamsError {
    fn code(&self) -> Option<&str> {
        StartMetricStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartMetricStreamsError {
    /// Creates a new `StartMetricStreamsError`.
    pub fn new(kind: StartMetricStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartMetricStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartMetricStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartMetricStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartMetricStreamsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartMetricStreamsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartMetricStreamsErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartMetricStreamsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMetricStreamsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StartMetricStreamsErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartMetricStreamsErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for StartMetricStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartMetricStreamsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            StartMetricStreamsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            StartMetricStreamsErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            StartMetricStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopMetricStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopMetricStreamsError {
    /// Kind of error that occurred.
    pub kind: StopMetricStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopMetricStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopMetricStreamsErrorKind {
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>An input parameter that is required is missing.</p>
    MissingRequiredParameterException(crate::error::MissingRequiredParameterException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopMetricStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopMetricStreamsErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            StopMetricStreamsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            StopMetricStreamsErrorKind::MissingRequiredParameterException(_inner) => _inner.fmt(f),
            StopMetricStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopMetricStreamsError {
    fn code(&self) -> Option<&str> {
        StopMetricStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopMetricStreamsError {
    /// Creates a new `StopMetricStreamsError`.
    pub fn new(kind: StopMetricStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopMetricStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopMetricStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopMetricStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopMetricStreamsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopMetricStreamsErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopMetricStreamsErrorKind::InternalServiceFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopMetricStreamsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMetricStreamsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `StopMetricStreamsErrorKind::MissingRequiredParameterException`.
    pub fn is_missing_required_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopMetricStreamsErrorKind::MissingRequiredParameterException(_)
        )
    }
}
impl std::error::Error for StopMetricStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopMetricStreamsErrorKind::InternalServiceFault(_inner) => Some(_inner),
            StopMetricStreamsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            StopMetricStreamsErrorKind::MissingRequiredParameterException(_inner) => Some(_inner),
            StopMetricStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>More than one process tried to modify a resource at the same time.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The named resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServiceFault(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServiceFault(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>More than one process tried to modify a resource at the same time.</p>
    ConcurrentModificationException(crate::error::ConcurrentModificationException),
    /// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
    InternalServiceFault(crate::error::InternalServiceFault),
    /// <p>The value of an input parameter is bad or out-of-range.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>The named resource does not exist.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServiceFault(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConcurrentModificationException`.
    pub fn is_concurrent_modification_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ConcurrentModificationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServiceFault`.
    pub fn is_internal_service_fault(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::InternalServiceFault(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::ConcurrentModificationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServiceFault(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The named resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub resource_type: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_id: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                resource_type: self.resource_type,
                resource_id: self.resource_id,
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The value of an input parameter is bad or out-of-range.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>Request processing has failed due to some unknown error, exception, or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceFault")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceFault {}
/// See [`InternalServiceFault`](crate::error::InternalServiceFault)
pub mod internal_service_fault {
    /// A builder for [`InternalServiceFault`](crate::error::InternalServiceFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceFault`](crate::error::InternalServiceFault)
        pub fn build(self) -> crate::error::InternalServiceFault {
            crate::error::InternalServiceFault {
                message: self.message,
            }
        }
    }
}
impl InternalServiceFault {
    /// Creates a new builder-style object to manufacture [`InternalServiceFault`](crate::error::InternalServiceFault)
    pub fn builder() -> crate::error::internal_service_fault::Builder {
        crate::error::internal_service_fault::Builder::default()
    }
}

/// <p>More than one process tried to modify a resource at the same time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConcurrentModificationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConcurrentModificationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConcurrentModificationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConcurrentModificationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConcurrentModificationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConcurrentModificationException {}
/// See [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
pub mod concurrent_modification_exception {
    /// A builder for [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
        pub fn build(self) -> crate::error::ConcurrentModificationException {
            crate::error::ConcurrentModificationException {
                message: self.message,
            }
        }
    }
}
impl ConcurrentModificationException {
    /// Creates a new builder-style object to manufacture [`ConcurrentModificationException`](crate::error::ConcurrentModificationException)
    pub fn builder() -> crate::error::concurrent_modification_exception::Builder {
        crate::error::concurrent_modification_exception::Builder::default()
    }
}

/// <p>An input parameter that is required is missing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MissingRequiredParameterException {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MissingRequiredParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MissingRequiredParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl MissingRequiredParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for MissingRequiredParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "MissingRequiredParameterException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for MissingRequiredParameterException {}
/// See [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
pub mod missing_required_parameter_exception {
    /// A builder for [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
        pub fn build(self) -> crate::error::MissingRequiredParameterException {
            crate::error::MissingRequiredParameterException {
                message: self.message,
            }
        }
    }
}
impl MissingRequiredParameterException {
    /// Creates a new builder-style object to manufacture [`MissingRequiredParameterException`](crate::error::MissingRequiredParameterException)
    pub fn builder() -> crate::error::missing_required_parameter_exception::Builder {
        crate::error::missing_required_parameter_exception::Builder::default()
    }
}

/// <p>The named resource does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFound {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFound");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFound {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFound {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFound")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFound {}
/// See [`ResourceNotFound`](crate::error::ResourceNotFound)
pub mod resource_not_found {
    /// A builder for [`ResourceNotFound`](crate::error::ResourceNotFound)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFound`](crate::error::ResourceNotFound)
        pub fn build(self) -> crate::error::ResourceNotFound {
            crate::error::ResourceNotFound {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFound {
    /// Creates a new builder-style object to manufacture [`ResourceNotFound`](crate::error::ResourceNotFound)
    pub fn builder() -> crate::error::resource_not_found::Builder {
        crate::error::resource_not_found::Builder::default()
    }
}

/// <p>Data was not syntactically valid JSON.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidFormatFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidFormatFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidFormatFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidFormatFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidFormatFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidFormatFault")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidFormatFault {}
/// See [`InvalidFormatFault`](crate::error::InvalidFormatFault)
pub mod invalid_format_fault {
    /// A builder for [`InvalidFormatFault`](crate::error::InvalidFormatFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidFormatFault`](crate::error::InvalidFormatFault)
        pub fn build(self) -> crate::error::InvalidFormatFault {
            crate::error::InvalidFormatFault {
                message: self.message,
            }
        }
    }
}
impl InvalidFormatFault {
    /// Creates a new builder-style object to manufacture [`InvalidFormatFault`](crate::error::InvalidFormatFault)
    pub fn builder() -> crate::error::invalid_format_fault::Builder {
        crate::error::invalid_format_fault::Builder::default()
    }
}

/// <p>Parameters were used together that cannot be used together.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterCombinationException {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterCombinationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterCombinationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterCombinationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterCombinationException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterCombinationException {}
/// See [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
pub mod invalid_parameter_combination_exception {
    /// A builder for [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
        pub fn build(self) -> crate::error::InvalidParameterCombinationException {
            crate::error::InvalidParameterCombinationException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterCombinationException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterCombinationException`](crate::error::InvalidParameterCombinationException)
    pub fn builder() -> crate::error::invalid_parameter_combination_exception::Builder {
        crate::error::invalid_parameter_combination_exception::Builder::default()
    }
}

/// <p>The quota for alarms for this customer has already been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededFault")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededFault {}
/// See [`LimitExceededFault`](crate::error::LimitExceededFault)
pub mod limit_exceeded_fault {
    /// A builder for [`LimitExceededFault`](crate::error::LimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededFault`](crate::error::LimitExceededFault)
        pub fn build(self) -> crate::error::LimitExceededFault {
            crate::error::LimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl LimitExceededFault {
    /// Creates a new builder-style object to manufacture [`LimitExceededFault`](crate::error::LimitExceededFault)
    pub fn builder() -> crate::error::limit_exceeded_fault::Builder {
        crate::error::limit_exceeded_fault::Builder::default()
    }
}

/// <p>The operation exceeded one or more limits.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>Some part of the dashboard data is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardInvalidInputError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub dashboard_validation_messages:
        std::option::Option<std::vec::Vec<crate::model::DashboardValidationMessage>>,
}
impl DashboardInvalidInputError {
    #[allow(missing_docs)] // documentation missing in model
    pub fn dashboard_validation_messages(
        &self,
    ) -> std::option::Option<&[crate::model::DashboardValidationMessage]> {
        self.dashboard_validation_messages.as_deref()
    }
}
impl std::fmt::Debug for DashboardInvalidInputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardInvalidInputError");
        formatter.field("message", &self.message);
        formatter.field(
            "dashboard_validation_messages",
            &self.dashboard_validation_messages,
        );
        formatter.finish()
    }
}
impl DashboardInvalidInputError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DashboardInvalidInputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DashboardInvalidInputError")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for DashboardInvalidInputError {}
/// See [`DashboardInvalidInputError`](crate::error::DashboardInvalidInputError)
pub mod dashboard_invalid_input_error {
    /// A builder for [`DashboardInvalidInputError`](crate::error::DashboardInvalidInputError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) dashboard_validation_messages:
            std::option::Option<std::vec::Vec<crate::model::DashboardValidationMessage>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `dashboard_validation_messages`.
        ///
        /// To override the contents of this collection use [`set_dashboard_validation_messages`](Self::set_dashboard_validation_messages).
        ///
        pub fn dashboard_validation_messages(
            mut self,
            input: crate::model::DashboardValidationMessage,
        ) -> Self {
            let mut v = self.dashboard_validation_messages.unwrap_or_default();
            v.push(input);
            self.dashboard_validation_messages = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_dashboard_validation_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DashboardValidationMessage>>,
        ) -> Self {
            self.dashboard_validation_messages = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardInvalidInputError`](crate::error::DashboardInvalidInputError)
        pub fn build(self) -> crate::error::DashboardInvalidInputError {
            crate::error::DashboardInvalidInputError {
                message: self.message,
                dashboard_validation_messages: self.dashboard_validation_messages,
            }
        }
    }
}
impl DashboardInvalidInputError {
    /// Creates a new builder-style object to manufacture [`DashboardInvalidInputError`](crate::error::DashboardInvalidInputError)
    pub fn builder() -> crate::error::dashboard_invalid_input_error::Builder {
        crate::error::dashboard_invalid_input_error::Builder::default()
    }
}

/// <p>The next token specified is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextToken {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextToken");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextToken {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextToken {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextToken")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextToken {}
/// See [`InvalidNextToken`](crate::error::InvalidNextToken)
pub mod invalid_next_token {
    /// A builder for [`InvalidNextToken`](crate::error::InvalidNextToken)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextToken`](crate::error::InvalidNextToken)
        pub fn build(self) -> crate::error::InvalidNextToken {
            crate::error::InvalidNextToken {
                message: self.message,
            }
        }
    }
}
impl InvalidNextToken {
    /// Creates a new builder-style object to manufacture [`InvalidNextToken`](crate::error::InvalidNextToken)
    pub fn builder() -> crate::error::invalid_next_token::Builder {
        crate::error::invalid_next_token::Builder::default()
    }
}

/// <p>The specified dashboard does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardNotFoundError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DashboardNotFoundError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardNotFoundError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DashboardNotFoundError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DashboardNotFoundError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DashboardNotFoundError")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for DashboardNotFoundError {}
/// See [`DashboardNotFoundError`](crate::error::DashboardNotFoundError)
pub mod dashboard_not_found_error {
    /// A builder for [`DashboardNotFoundError`](crate::error::DashboardNotFoundError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardNotFoundError`](crate::error::DashboardNotFoundError)
        pub fn build(self) -> crate::error::DashboardNotFoundError {
            crate::error::DashboardNotFoundError {
                message: self.message,
            }
        }
    }
}
impl DashboardNotFoundError {
    /// Creates a new builder-style object to manufacture [`DashboardNotFoundError`](crate::error::DashboardNotFoundError)
    pub fn builder() -> crate::error::dashboard_not_found_error::Builder {
        crate::error::dashboard_not_found_error::Builder::default()
    }
}
