// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alarms_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAlarmsOutput, crate::error::DeleteAlarmsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAlarmsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAlarmsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => {
            crate::error::DeleteAlarmsError {
                meta: generic,
                kind: crate::error::DeleteAlarmsErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_not_found_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAlarmsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DeleteAlarmsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alarms_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAlarmsOutput, crate::error::DeleteAlarmsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_alarms_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_anomaly_detector_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnomalyDetectorOutput,
    crate::error::DeleteAnomalyDetectorError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAnomalyDetectorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAnomalyDetectorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DeleteAnomalyDetectorError {
            meta: generic,
            kind: crate::error::DeleteAnomalyDetectorErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalyDetectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::DeleteAnomalyDetectorError {
            meta: generic,
            kind:
                crate::error::DeleteAnomalyDetectorErrorKind::InvalidParameterCombinationException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalyDetectorError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidParameterValue" => crate::error::DeleteAnomalyDetectorError {
            meta: generic,
            kind: crate::error::DeleteAnomalyDetectorErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalyDetectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::DeleteAnomalyDetectorError {
            meta: generic,
            kind: crate::error::DeleteAnomalyDetectorErrorKind::MissingRequiredParameterException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::missing_required_parameter_exception::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalyDetectorError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundException" => crate::error::DeleteAnomalyDetectorError {
            meta: generic,
            kind: crate::error::DeleteAnomalyDetectorErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalyDetectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAnomalyDetectorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_anomaly_detector_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnomalyDetectorOutput,
    crate::error::DeleteAnomalyDetectorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_anomaly_detector_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_dashboards_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDashboardsOutput, crate::error::DeleteDashboardsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDashboardsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDashboardsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => crate::error::DeleteDashboardsError {
            meta: generic,
            kind: crate::error::DeleteDashboardsErrorKind::DashboardNotFoundError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dashboard_not_found_error::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dashboard_not_found_error_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDashboardsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceError" => crate::error::DeleteDashboardsError {
            meta: generic,
            kind: crate::error::DeleteDashboardsErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDashboardsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::DeleteDashboardsError {
            meta: generic,
            kind: crate::error::DeleteDashboardsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDashboardsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDashboardsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_dashboards_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDashboardsOutput, crate::error::DeleteDashboardsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_dashboards_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_insight_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInsightRulesOutput,
    crate::error::DeleteInsightRulesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteInsightRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteInsightRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::DeleteInsightRulesError {
            meta: generic,
            kind: crate::error::DeleteInsightRulesErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteInsightRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::DeleteInsightRulesError {
            meta: generic,
            kind: crate::error::DeleteInsightRulesErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteInsightRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteInsightRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_insight_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInsightRulesOutput,
    crate::error::DeleteInsightRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_insight_rules_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_insight_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteInsightRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_metric_stream_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMetricStreamOutput,
    crate::error::DeleteMetricStreamError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMetricStreamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteMetricStreamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DeleteMetricStreamError {
            meta: generic,
            kind: crate::error::DeleteMetricStreamErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::DeleteMetricStreamError {
            meta: generic,
            kind: crate::error::DeleteMetricStreamErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::DeleteMetricStreamError {
            meta: generic,
            kind: crate::error::DeleteMetricStreamErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteMetricStreamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_metric_stream_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteMetricStreamOutput,
    crate::error::DeleteMetricStreamError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_metric_stream_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_alarm_history_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAlarmHistoryOutput,
    crate::error::DescribeAlarmHistoryError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAlarmHistoryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAlarmHistoryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeAlarmHistoryError {
                meta: generic,
                kind: crate::error::DescribeAlarmHistoryErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAlarmHistoryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeAlarmHistoryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_alarm_history_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAlarmHistoryOutput,
    crate::error::DescribeAlarmHistoryError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_alarm_history_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_alarm_history(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAlarmHistoryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_alarms_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAlarmsOutput, crate::error::DescribeAlarmsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAlarmsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeAlarmsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeAlarmsError {
                meta: generic,
                kind: crate::error::DescribeAlarmsErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAlarmsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeAlarmsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_alarms_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeAlarmsOutput, crate::error::DescribeAlarmsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_alarms_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_alarms(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAlarmsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_alarms_for_metric_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAlarmsForMetricOutput,
    crate::error::DescribeAlarmsForMetricError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAlarmsForMetricError::unhandled)?;
    Err(crate::error::DescribeAlarmsForMetricError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_alarms_for_metric_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAlarmsForMetricOutput,
    crate::error::DescribeAlarmsForMetricError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_alarms_for_metric_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_alarms_for_metric(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAlarmsForMetricError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_anomaly_detectors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAnomalyDetectorsOutput,
    crate::error::DescribeAnomalyDetectorsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAnomalyDetectorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeAnomalyDetectorsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::DescribeAnomalyDetectorsError { meta: generic, kind: crate::error::DescribeAnomalyDetectorsErrorKind::InternalServiceFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAnomalyDetectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidNextToken" => crate::error::DescribeAnomalyDetectorsError { meta: generic, kind: crate::error::DescribeAnomalyDetectorsErrorKind::InvalidNextToken({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_next_token::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAnomalyDetectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterCombination" => crate::error::DescribeAnomalyDetectorsError { meta: generic, kind: crate::error::DescribeAnomalyDetectorsErrorKind::InvalidParameterCombinationException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAnomalyDetectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidParameterValue" => crate::error::DescribeAnomalyDetectorsError { meta: generic, kind: crate::error::DescribeAnomalyDetectorsErrorKind::InvalidParameterValueException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeAnomalyDetectorsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeAnomalyDetectorsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_anomaly_detectors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAnomalyDetectorsOutput,
    crate::error::DescribeAnomalyDetectorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_anomaly_detectors_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_anomaly_detectors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAnomalyDetectorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_insight_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInsightRulesOutput,
    crate::error::DescribeInsightRulesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeInsightRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeInsightRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::DescribeInsightRulesError {
                meta: generic,
                kind: crate::error::DescribeInsightRulesErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeInsightRulesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::DescribeInsightRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_insight_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeInsightRulesOutput,
    crate::error::DescribeInsightRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_insight_rules_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_insight_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeInsightRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_alarm_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAlarmActionsOutput,
    crate::error::DisableAlarmActionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableAlarmActionsError::unhandled)?;
    Err(crate::error::DisableAlarmActionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_alarm_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableAlarmActionsOutput,
    crate::error::DisableAlarmActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_alarm_actions_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_insight_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableInsightRulesOutput,
    crate::error::DisableInsightRulesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableInsightRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableInsightRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::DisableInsightRulesError {
            meta: generic,
            kind: crate::error::DisableInsightRulesErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableInsightRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::DisableInsightRulesError {
            meta: generic,
            kind: crate::error::DisableInsightRulesErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::DisableInsightRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableInsightRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_insight_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisableInsightRulesOutput,
    crate::error::DisableInsightRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_insight_rules_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_disable_insight_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisableInsightRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_alarm_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAlarmActionsOutput,
    crate::error::EnableAlarmActionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableAlarmActionsError::unhandled)?;
    Err(crate::error::EnableAlarmActionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_alarm_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableAlarmActionsOutput,
    crate::error::EnableAlarmActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_alarm_actions_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_insight_rules_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableInsightRulesOutput,
    crate::error::EnableInsightRulesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableInsightRulesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableInsightRulesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::EnableInsightRulesError {
            meta: generic,
            kind: crate::error::EnableInsightRulesErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableInsightRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::EnableInsightRulesError {
            meta: generic,
            kind: crate::error::EnableInsightRulesErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableInsightRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::EnableInsightRulesError {
            meta: generic,
            kind: crate::error::EnableInsightRulesErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::EnableInsightRulesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableInsightRulesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_insight_rules_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::EnableInsightRulesOutput,
    crate::error::EnableInsightRulesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_insight_rules_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_enable_insight_rules(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EnableInsightRulesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_dashboard_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDashboardOutput, crate::error::GetDashboardError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDashboardError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDashboardError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFound" => crate::error::GetDashboardError {
            meta: generic,
            kind: crate::error::GetDashboardErrorKind::DashboardNotFoundError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::dashboard_not_found_error::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dashboard_not_found_error_xml_err(response.body().as_ref(), output).map_err(crate::error::GetDashboardError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceError" => crate::error::GetDashboardError {
            meta: generic,
            kind: crate::error::GetDashboardErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetDashboardError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::GetDashboardError {
            meta: generic,
            kind: crate::error::GetDashboardErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetDashboardError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDashboardError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_dashboard_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDashboardOutput, crate::error::GetDashboardError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_dashboard_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_dashboard(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDashboardError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_insight_rule_report_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInsightRuleReportOutput,
    crate::error::GetInsightRuleReportError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInsightRuleReportError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInsightRuleReportError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::GetInsightRuleReportError {
            meta: generic,
            kind: crate::error::GetInsightRuleReportErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetInsightRuleReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::GetInsightRuleReportError {
            meta: generic,
            kind: crate::error::GetInsightRuleReportErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetInsightRuleReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetInsightRuleReportError {
            meta: generic,
            kind: crate::error::GetInsightRuleReportErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetInsightRuleReportError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInsightRuleReportError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_insight_rule_report_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInsightRuleReportOutput,
    crate::error::GetInsightRuleReportError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_insight_rule_report_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_insight_rule_report(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInsightRuleReportError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetMetricDataOutput, crate::error::GetMetricDataError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetMetricDataError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextToken" => {
            crate::error::GetMetricDataError {
                meta: generic,
                kind: crate::error::GetMetricDataErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricDataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::GetMetricDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetMetricDataOutput, crate::error::GetMetricDataError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_metric_data_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_metric_data(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetMetricDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_statistics_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMetricStatisticsOutput,
    crate::error::GetMetricStatisticsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMetricStatisticsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetMetricStatisticsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::GetMetricStatisticsError {
            meta: generic,
            kind: crate::error::GetMetricStatisticsErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStatisticsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => {
            crate::error::GetMetricStatisticsError {
                meta: generic,
                kind:
                    crate::error::GetMetricStatisticsErrorKind::InvalidParameterCombinationException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStatisticsError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidParameterValue" => crate::error::GetMetricStatisticsError {
            meta: generic,
            kind: crate::error::GetMetricStatisticsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStatisticsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::GetMetricStatisticsError {
            meta: generic,
            kind: crate::error::GetMetricStatisticsErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStatisticsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetMetricStatisticsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_statistics_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMetricStatisticsOutput,
    crate::error::GetMetricStatisticsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_metric_statistics_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_metric_statistics(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetMetricStatisticsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_stream_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetMetricStreamOutput, crate::error::GetMetricStreamError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMetricStreamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetMetricStreamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::GetMetricStreamError {
            meta: generic,
            kind: crate::error::GetMetricStreamErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::GetMetricStreamError {
            meta: generic,
            kind: crate::error::GetMetricStreamErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::GetMetricStreamError {
            meta: generic,
            kind: crate::error::GetMetricStreamErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::GetMetricStreamError {
            meta: generic,
            kind: crate::error::GetMetricStreamErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetMetricStreamError {
            meta: generic,
            kind: crate::error::GetMetricStreamErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::GetMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetMetricStreamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_stream_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetMetricStreamOutput, crate::error::GetMetricStreamError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_metric_stream_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_metric_stream(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetMetricStreamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_widget_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMetricWidgetImageOutput,
    crate::error::GetMetricWidgetImageError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMetricWidgetImageError::unhandled)?;
    Err(crate::error::GetMetricWidgetImageError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_metric_widget_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetMetricWidgetImageOutput,
    crate::error::GetMetricWidgetImageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_metric_widget_image_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_get_metric_widget_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetMetricWidgetImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_dashboards_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDashboardsOutput, crate::error::ListDashboardsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListDashboardsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListDashboardsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ListDashboardsError {
            meta: generic,
            kind: crate::error::ListDashboardsErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDashboardsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::ListDashboardsError {
            meta: generic,
            kind: crate::error::ListDashboardsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListDashboardsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListDashboardsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_dashboards_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListDashboardsOutput, crate::error::ListDashboardsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_dashboards_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_dashboards(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListDashboardsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_metrics_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMetricsOutput, crate::error::ListMetricsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMetricsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListMetricsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ListMetricsError {
            meta: generic,
            kind: crate::error::ListMetricsErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMetricsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::ListMetricsError {
            meta: generic,
            kind: crate::error::ListMetricsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMetricsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListMetricsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_metrics_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMetricsOutput, crate::error::ListMetricsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_metrics_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_metrics(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMetricsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_metric_streams_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMetricStreamsOutput, crate::error::ListMetricStreamsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListMetricStreamsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListMetricStreamsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ListMetricStreamsError {
            meta: generic,
            kind: crate::error::ListMetricStreamsErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextToken" => {
            crate::error::ListMetricStreamsError {
                meta: generic,
                kind: crate::error::ListMetricStreamsErrorKind::InvalidNextToken({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_next_token::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_next_token_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMetricStreamsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InvalidParameterValue" => crate::error::ListMetricStreamsError {
            meta: generic,
            kind: crate::error::ListMetricStreamsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::ListMetricStreamsError {
            meta: generic,
            kind: crate::error::ListMetricStreamsErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListMetricStreamsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_metric_streams_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ListMetricStreamsOutput, crate::error::ListMetricStreamsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_metric_streams_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_metric_streams(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListMetricStreamsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_anomaly_detector_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAnomalyDetectorOutput,
    crate::error::PutAnomalyDetectorError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAnomalyDetectorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutAnomalyDetectorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::PutAnomalyDetectorError {
            meta: generic,
            kind: crate::error::PutAnomalyDetectorErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutAnomalyDetectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => {
            crate::error::PutAnomalyDetectorError {
                meta: generic,
                kind:
                    crate::error::PutAnomalyDetectorErrorKind::InvalidParameterCombinationException(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_parameter_combination_exception::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutAnomalyDetectorError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidParameterValue" => crate::error::PutAnomalyDetectorError {
            meta: generic,
            kind: crate::error::PutAnomalyDetectorErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutAnomalyDetectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PutAnomalyDetectorError {
            meta: generic,
            kind: crate::error::PutAnomalyDetectorErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutAnomalyDetectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::PutAnomalyDetectorError {
            meta: generic,
            kind: crate::error::PutAnomalyDetectorErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutAnomalyDetectorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutAnomalyDetectorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_anomaly_detector_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutAnomalyDetectorOutput,
    crate::error::PutAnomalyDetectorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_anomaly_detector_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_composite_alarm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutCompositeAlarmOutput, crate::error::PutCompositeAlarmError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutCompositeAlarmError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutCompositeAlarmError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::PutCompositeAlarmError {
                meta: generic,
                kind: crate::error::PutCompositeAlarmErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutCompositeAlarmError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutCompositeAlarmError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_composite_alarm_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutCompositeAlarmOutput, crate::error::PutCompositeAlarmError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_composite_alarm_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_dashboard_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutDashboardOutput, crate::error::PutDashboardError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutDashboardError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutDashboardError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterInput" => crate::error::PutDashboardError {
            meta: generic,
            kind: crate::error::PutDashboardErrorKind::DashboardInvalidInputError({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::dashboard_invalid_input_error::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_dashboard_invalid_input_error_xml_err(response.body().as_ref(), output).map_err(crate::error::PutDashboardError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceError" => crate::error::PutDashboardError {
            meta: generic,
            kind: crate::error::PutDashboardErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutDashboardError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutDashboardError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_dashboard_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutDashboardOutput, crate::error::PutDashboardError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_dashboard_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_put_dashboard(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutDashboardError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_insight_rule_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutInsightRuleOutput, crate::error::PutInsightRuleError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutInsightRuleError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutInsightRuleError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidParameterValue" => crate::error::PutInsightRuleError {
            meta: generic,
            kind: crate::error::PutInsightRuleErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutInsightRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PutInsightRuleError {
            meta: generic,
            kind: crate::error::PutInsightRuleErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutInsightRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::PutInsightRuleError {
            meta: generic,
            kind: crate::error::PutInsightRuleErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutInsightRuleError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutInsightRuleError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_insight_rule_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutInsightRuleOutput, crate::error::PutInsightRuleError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_insight_rule_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_metric_alarm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutMetricAlarmOutput, crate::error::PutMetricAlarmError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutMetricAlarmError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutMetricAlarmError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceeded" => {
            crate::error::PutMetricAlarmError {
                meta: generic,
                kind: crate::error::PutMetricAlarmErrorKind::LimitExceededFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_limit_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricAlarmError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::PutMetricAlarmError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_metric_alarm_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutMetricAlarmOutput, crate::error::PutMetricAlarmError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_metric_alarm_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutMetricDataOutput, crate::error::PutMetricDataError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutMetricDataError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::PutMetricDataError {
            meta: generic,
            kind: crate::error::PutMetricDataErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::PutMetricDataError {
            meta: generic,
            kind: crate::error::PutMetricDataErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::PutMetricDataError {
            meta: generic,
            kind: crate::error::PutMetricDataErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::PutMetricDataError {
            meta: generic,
            kind: crate::error::PutMetricDataErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutMetricDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutMetricDataOutput, crate::error::PutMetricDataError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_metric_data_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_metric_stream_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutMetricStreamOutput, crate::error::PutMetricStreamError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutMetricStreamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutMetricStreamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::PutMetricStreamError {
            meta: generic,
            kind: crate::error::PutMetricStreamErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceError" => crate::error::PutMetricStreamError {
            meta: generic,
            kind: crate::error::PutMetricStreamErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterCombination" => crate::error::PutMetricStreamError {
            meta: generic,
            kind: crate::error::PutMetricStreamErrorKind::InvalidParameterCombinationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_combination_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::PutMetricStreamError {
            meta: generic,
            kind: crate::error::PutMetricStreamErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::PutMetricStreamError {
            meta: generic,
            kind: crate::error::PutMetricStreamErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::PutMetricStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutMetricStreamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_metric_stream_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutMetricStreamOutput, crate::error::PutMetricStreamError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_metric_stream_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_put_metric_stream(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutMetricStreamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_alarm_state_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetAlarmStateOutput, crate::error::SetAlarmStateError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetAlarmStateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetAlarmStateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidFormat" => {
            crate::error::SetAlarmStateError {
                meta: generic,
                kind: crate::error::SetAlarmStateErrorKind::InvalidFormatFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_format_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_format_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::SetAlarmStateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "ResourceNotFound" => {
            crate::error::SetAlarmStateError {
                meta: generic,
                kind: crate::error::SetAlarmStateErrorKind::ResourceNotFound({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_not_found_xml_err(response.body().as_ref(), output).map_err(crate::error::SetAlarmStateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        _ => crate::error::SetAlarmStateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_alarm_state_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetAlarmStateOutput, crate::error::SetAlarmStateError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_alarm_state_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_metric_streams_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartMetricStreamsOutput,
    crate::error::StartMetricStreamsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartMetricStreamsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartMetricStreamsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::StartMetricStreamsError {
            meta: generic,
            kind: crate::error::StartMetricStreamsErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::StartMetricStreamsError {
            meta: generic,
            kind: crate::error::StartMetricStreamsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StartMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::StartMetricStreamsError {
            meta: generic,
            kind: crate::error::StartMetricStreamsErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StartMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartMetricStreamsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_metric_streams_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartMetricStreamsOutput,
    crate::error::StartMetricStreamsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_metric_streams_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_metric_streams_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopMetricStreamsOutput, crate::error::StopMetricStreamsError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopMetricStreamsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopMetricStreamsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServiceError" => crate::error::StopMetricStreamsError {
            meta: generic,
            kind: crate::error::StopMetricStreamsErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::StopMetricStreamsError {
            meta: generic,
            kind: crate::error::StopMetricStreamsErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StopMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "MissingParameter" => crate::error::StopMetricStreamsError {
            meta: generic,
            kind: crate::error::StopMetricStreamsErrorKind::MissingRequiredParameterException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::missing_required_parameter_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_missing_required_parameter_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::StopMetricStreamsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopMetricStreamsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_metric_streams_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopMetricStreamsOutput, crate::error::StopMetricStreamsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_metric_streams_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceError" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ConcurrentModificationException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ConcurrentModificationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::concurrent_modification_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_concurrent_modification_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServiceError" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InternalServiceFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_service_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_internal_service_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidParameterValue" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::InvalidParameterValueException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_parameter_value_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_parameter_value_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_exception_xml_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}
