// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>A key-value pair associated with a CloudWatch resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A string that you can use to assign a value. The combination of tag keys and values can help you organize and categorize your
    /// resources.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for the specified tag key.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A string that you can use to assign a value. The combination of tag keys and values can help you organize and categorize your
    /// resources.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value for the specified tag key.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A string that you can use to assign a value. The combination of tag keys and values can help you organize and categorize your
        /// resources.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A string that you can use to assign a value. The combination of tag keys and values can help you organize and categorize your
        /// resources.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for the specified tag key.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the specified tag key.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StateValue {
    #[allow(missing_docs)] // documentation missing in model
    Alarm,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientData,
    #[allow(missing_docs)] // documentation missing in model
    Ok,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StateValue {
    fn from(s: &str) -> Self {
        match s {
            "ALARM" => StateValue::Alarm,
            "INSUFFICIENT_DATA" => StateValue::InsufficientData,
            "OK" => StateValue::Ok,
            other => StateValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StateValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StateValue::from(s))
    }
}
impl StateValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StateValue::Alarm => "ALARM",
            StateValue::InsufficientData => "INSUFFICIENT_DATA",
            StateValue::Ok => "OK",
            StateValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALARM", "INSUFFICIENT_DATA", "OK"]
    }
}
impl AsRef<str> for StateValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricStreamOutputFormat {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    OpenTelemetry07,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricStreamOutputFormat {
    fn from(s: &str) -> Self {
        match s {
            "json" => MetricStreamOutputFormat::Json,
            "opentelemetry0.7" => MetricStreamOutputFormat::OpenTelemetry07,
            other => MetricStreamOutputFormat::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricStreamOutputFormat {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricStreamOutputFormat::from(s))
    }
}
impl MetricStreamOutputFormat {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricStreamOutputFormat::Json => "json",
            MetricStreamOutputFormat::OpenTelemetry07 => "opentelemetry0.7",
            MetricStreamOutputFormat::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["json", "opentelemetry0.7"]
    }
}
impl AsRef<str> for MetricStreamOutputFormat {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure contains the name of one of the metric namespaces that is listed in
/// a filter of a metric stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricStreamFilter {
    /// <p>The name of the metric namespace in the filter.</p>
    pub namespace: std::option::Option<std::string::String>,
}
impl MetricStreamFilter {
    /// <p>The name of the metric namespace in the filter.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
}
impl std::fmt::Debug for MetricStreamFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricStreamFilter");
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`MetricStreamFilter`](crate::model::MetricStreamFilter)
pub mod metric_stream_filter {
    /// A builder for [`MetricStreamFilter`](crate::model::MetricStreamFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric namespace in the filter.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The name of the metric namespace in the filter.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricStreamFilter`](crate::model::MetricStreamFilter)
        pub fn build(self) -> crate::model::MetricStreamFilter {
            crate::model::MetricStreamFilter {
                namespace: self.namespace,
            }
        }
    }
}
impl MetricStreamFilter {
    /// Creates a new builder-style object to manufacture [`MetricStreamFilter`](crate::model::MetricStreamFilter)
    pub fn builder() -> crate::model::metric_stream_filter::Builder {
        crate::model::metric_stream_filter::Builder::default()
    }
}

/// <p>Encapsulates the information sent to either create a metric or add new values
/// to be aggregated into an existing metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDatum {
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The dimensions associated with the metric.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
    /// <p>The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The value for the metric.</p>
    /// <p>Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or
    /// too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity)
    /// are not supported.</p>
    pub value: std::option::Option<f64>,
    /// <p>The statistical values for the metric.</p>
    pub statistic_values: std::option::Option<crate::model::StatisticSet>,
    /// <p>Array of numbers representing the values for the metric during the period. Each unique value is listed just once
    /// in this array, and the corresponding number in the <code>Counts</code> array specifies the number of times that value occurred during the period.
    /// You can include up to 150 unique values in each <code>PutMetricData</code> action that specifies a <code>Values</code> array.</p>
    /// <p>Although the <code>Values</code> array accepts numbers of type
    /// <code>Double</code>, CloudWatch rejects values that are either too small
    /// or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity,
    /// -Infinity) are not supported.</p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
    /// <p>Array of numbers that is used along with the <code>Values</code> array. Each number in the <code>Count</code> array
    /// is the number of times the corresponding value in the <code>Values</code> array occurred during the period. </p>
    /// <p>If you omit the <code>Counts</code> array, the default of 1 is used as the value for each count. If you
    /// include a <code>Counts</code> array, it must include the same amount of values as the <code>Values</code> array.</p>
    pub counts: std::option::Option<std::vec::Vec<f64>>,
    /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
    /// <p>In
    /// a <code>Get</code> operation, this displays the unit that is used for the metric.</p>
    pub unit: std::option::Option<crate::model::StandardUnit>,
    /// <p>Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with
    /// sub-minute resolution down to one second.
    /// Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available
    /// only for custom metrics. For more information about high-resolution metrics,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the
    /// <i>Amazon CloudWatch User Guide</i>.
    /// </p>
    /// <p>This field is optional, if you do not specify it the default of 60 is used.</p>
    pub storage_resolution: std::option::Option<i32>,
}
impl MetricDatum {
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The dimensions associated with the metric.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::Dimension]> {
        self.dimensions.as_deref()
    }
    /// <p>The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The value for the metric.</p>
    /// <p>Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or
    /// too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity)
    /// are not supported.</p>
    pub fn value(&self) -> std::option::Option<f64> {
        self.value
    }
    /// <p>The statistical values for the metric.</p>
    pub fn statistic_values(&self) -> std::option::Option<&crate::model::StatisticSet> {
        self.statistic_values.as_ref()
    }
    /// <p>Array of numbers representing the values for the metric during the period. Each unique value is listed just once
    /// in this array, and the corresponding number in the <code>Counts</code> array specifies the number of times that value occurred during the period.
    /// You can include up to 150 unique values in each <code>PutMetricData</code> action that specifies a <code>Values</code> array.</p>
    /// <p>Although the <code>Values</code> array accepts numbers of type
    /// <code>Double</code>, CloudWatch rejects values that are either too small
    /// or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity,
    /// -Infinity) are not supported.</p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
    /// <p>Array of numbers that is used along with the <code>Values</code> array. Each number in the <code>Count</code> array
    /// is the number of times the corresponding value in the <code>Values</code> array occurred during the period. </p>
    /// <p>If you omit the <code>Counts</code> array, the default of 1 is used as the value for each count. If you
    /// include a <code>Counts</code> array, it must include the same amount of values as the <code>Values</code> array.</p>
    pub fn counts(&self) -> std::option::Option<&[f64]> {
        self.counts.as_deref()
    }
    /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
    /// <p>In
    /// a <code>Get</code> operation, this displays the unit that is used for the metric.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::StandardUnit> {
        self.unit.as_ref()
    }
    /// <p>Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with
    /// sub-minute resolution down to one second.
    /// Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available
    /// only for custom metrics. For more information about high-resolution metrics,
    /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the
    /// <i>Amazon CloudWatch User Guide</i>.
    /// </p>
    /// <p>This field is optional, if you do not specify it the default of 60 is used.</p>
    pub fn storage_resolution(&self) -> std::option::Option<i32> {
        self.storage_resolution
    }
}
impl std::fmt::Debug for MetricDatum {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDatum");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("value", &self.value);
        formatter.field("statistic_values", &self.statistic_values);
        formatter.field("values", &self.values);
        formatter.field("counts", &self.counts);
        formatter.field("unit", &self.unit);
        formatter.field("storage_resolution", &self.storage_resolution);
        formatter.finish()
    }
}
/// See [`MetricDatum`](crate::model::MetricDatum)
pub mod metric_datum {
    /// A builder for [`MetricDatum`](crate::model::MetricDatum)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) value: std::option::Option<f64>,
        pub(crate) statistic_values: std::option::Option<crate::model::StatisticSet>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) counts: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) unit: std::option::Option<crate::model::StandardUnit>,
        pub(crate) storage_resolution: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions associated with the metric.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::Dimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions associated with the metric.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time the metric data was received, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The value for the metric.</p>
        /// <p>Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or
        /// too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity)
        /// are not supported.</p>
        pub fn value(mut self, input: f64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value for the metric.</p>
        /// <p>Although the parameter accepts numbers of type Double, CloudWatch rejects values that are either too small or
        /// too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity, -Infinity)
        /// are not supported.</p>
        pub fn set_value(mut self, input: std::option::Option<f64>) -> Self {
            self.value = input;
            self
        }
        /// <p>The statistical values for the metric.</p>
        pub fn statistic_values(mut self, input: crate::model::StatisticSet) -> Self {
            self.statistic_values = Some(input);
            self
        }
        /// <p>The statistical values for the metric.</p>
        pub fn set_statistic_values(
            mut self,
            input: std::option::Option<crate::model::StatisticSet>,
        ) -> Self {
            self.statistic_values = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>Array of numbers representing the values for the metric during the period. Each unique value is listed just once
        /// in this array, and the corresponding number in the <code>Counts</code> array specifies the number of times that value occurred during the period.
        /// You can include up to 150 unique values in each <code>PutMetricData</code> action that specifies a <code>Values</code> array.</p>
        /// <p>Although the <code>Values</code> array accepts numbers of type
        /// <code>Double</code>, CloudWatch rejects values that are either too small
        /// or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity,
        /// -Infinity) are not supported.</p>
        pub fn values(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>Array of numbers representing the values for the metric during the period. Each unique value is listed just once
        /// in this array, and the corresponding number in the <code>Counts</code> array specifies the number of times that value occurred during the period.
        /// You can include up to 150 unique values in each <code>PutMetricData</code> action that specifies a <code>Values</code> array.</p>
        /// <p>Although the <code>Values</code> array accepts numbers of type
        /// <code>Double</code>, CloudWatch rejects values that are either too small
        /// or too large. Values must be in the range of -2^360 to 2^360. In addition, special values (for example, NaN, +Infinity,
        /// -Infinity) are not supported.</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `counts`.
        ///
        /// To override the contents of this collection use [`set_counts`](Self::set_counts).
        ///
        /// <p>Array of numbers that is used along with the <code>Values</code> array. Each number in the <code>Count</code> array
        /// is the number of times the corresponding value in the <code>Values</code> array occurred during the period. </p>
        /// <p>If you omit the <code>Counts</code> array, the default of 1 is used as the value for each count. If you
        /// include a <code>Counts</code> array, it must include the same amount of values as the <code>Values</code> array.</p>
        pub fn counts(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.counts.unwrap_or_default();
            v.push(input.into());
            self.counts = Some(v);
            self
        }
        /// <p>Array of numbers that is used along with the <code>Values</code> array. Each number in the <code>Count</code> array
        /// is the number of times the corresponding value in the <code>Values</code> array occurred during the period. </p>
        /// <p>If you omit the <code>Counts</code> array, the default of 1 is used as the value for each count. If you
        /// include a <code>Counts</code> array, it must include the same amount of values as the <code>Values</code> array.</p>
        pub fn set_counts(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.counts = input;
            self
        }
        /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
        /// <p>In
        /// a <code>Get</code> operation, this displays the unit that is used for the metric.</p>
        pub fn unit(mut self, input: crate::model::StandardUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
        /// <p>In
        /// a <code>Get</code> operation, this displays the unit that is used for the metric.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::StandardUnit>) -> Self {
            self.unit = input;
            self
        }
        /// <p>Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with
        /// sub-minute resolution down to one second.
        /// Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available
        /// only for custom metrics. For more information about high-resolution metrics,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the
        /// <i>Amazon CloudWatch User Guide</i>.
        /// </p>
        /// <p>This field is optional, if you do not specify it the default of 60 is used.</p>
        pub fn storage_resolution(mut self, input: i32) -> Self {
            self.storage_resolution = Some(input);
            self
        }
        /// <p>Valid values are 1 and 60. Setting this to 1 specifies this metric as a high-resolution metric, so that CloudWatch stores the metric with
        /// sub-minute resolution down to one second.
        /// Setting this to 60 specifies this metric as a regular-resolution metric, which CloudWatch stores at 1-minute resolution. Currently, high resolution is available
        /// only for custom metrics. For more information about high-resolution metrics,
        /// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#high-resolution-metrics">High-Resolution Metrics</a> in the
        /// <i>Amazon CloudWatch User Guide</i>.
        /// </p>
        /// <p>This field is optional, if you do not specify it the default of 60 is used.</p>
        pub fn set_storage_resolution(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDatum`](crate::model::MetricDatum)
        pub fn build(self) -> crate::model::MetricDatum {
            crate::model::MetricDatum {
                metric_name: self.metric_name,
                dimensions: self.dimensions,
                timestamp: self.timestamp,
                value: self.value,
                statistic_values: self.statistic_values,
                values: self.values,
                counts: self.counts,
                unit: self.unit,
                storage_resolution: self.storage_resolution,
            }
        }
    }
}
impl MetricDatum {
    /// Creates a new builder-style object to manufacture [`MetricDatum`](crate::model::MetricDatum)
    pub fn builder() -> crate::model::metric_datum::Builder {
        crate::model::metric_datum::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StandardUnit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabits,
    #[allow(missing_docs)] // documentation missing in model
    GigabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabytes,
    #[allow(missing_docs)] // documentation missing in model
    GigabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobits,
    #[allow(missing_docs)] // documentation missing in model
    KilobitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    #[allow(missing_docs)] // documentation missing in model
    KilobytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabits,
    #[allow(missing_docs)] // documentation missing in model
    MegabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabytes,
    #[allow(missing_docs)] // documentation missing in model
    MegabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Microseconds,
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    Terabits,
    #[allow(missing_docs)] // documentation missing in model
    TerabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    #[allow(missing_docs)] // documentation missing in model
    TerabytesSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StandardUnit {
    fn from(s: &str) -> Self {
        match s {
            "Bits" => StandardUnit::Bits,
            "Bits/Second" => StandardUnit::BitsSecond,
            "Bytes" => StandardUnit::Bytes,
            "Bytes/Second" => StandardUnit::BytesSecond,
            "Count" => StandardUnit::Count,
            "Count/Second" => StandardUnit::CountSecond,
            "Gigabits" => StandardUnit::Gigabits,
            "Gigabits/Second" => StandardUnit::GigabitsSecond,
            "Gigabytes" => StandardUnit::Gigabytes,
            "Gigabytes/Second" => StandardUnit::GigabytesSecond,
            "Kilobits" => StandardUnit::Kilobits,
            "Kilobits/Second" => StandardUnit::KilobitsSecond,
            "Kilobytes" => StandardUnit::Kilobytes,
            "Kilobytes/Second" => StandardUnit::KilobytesSecond,
            "Megabits" => StandardUnit::Megabits,
            "Megabits/Second" => StandardUnit::MegabitsSecond,
            "Megabytes" => StandardUnit::Megabytes,
            "Megabytes/Second" => StandardUnit::MegabytesSecond,
            "Microseconds" => StandardUnit::Microseconds,
            "Milliseconds" => StandardUnit::Milliseconds,
            "None" => StandardUnit::None,
            "Percent" => StandardUnit::Percent,
            "Seconds" => StandardUnit::Seconds,
            "Terabits" => StandardUnit::Terabits,
            "Terabits/Second" => StandardUnit::TerabitsSecond,
            "Terabytes" => StandardUnit::Terabytes,
            "Terabytes/Second" => StandardUnit::TerabytesSecond,
            other => StandardUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StandardUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StandardUnit::from(s))
    }
}
impl StandardUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StandardUnit::Bits => "Bits",
            StandardUnit::BitsSecond => "Bits/Second",
            StandardUnit::Bytes => "Bytes",
            StandardUnit::BytesSecond => "Bytes/Second",
            StandardUnit::Count => "Count",
            StandardUnit::CountSecond => "Count/Second",
            StandardUnit::Gigabits => "Gigabits",
            StandardUnit::GigabitsSecond => "Gigabits/Second",
            StandardUnit::Gigabytes => "Gigabytes",
            StandardUnit::GigabytesSecond => "Gigabytes/Second",
            StandardUnit::Kilobits => "Kilobits",
            StandardUnit::KilobitsSecond => "Kilobits/Second",
            StandardUnit::Kilobytes => "Kilobytes",
            StandardUnit::KilobytesSecond => "Kilobytes/Second",
            StandardUnit::Megabits => "Megabits",
            StandardUnit::MegabitsSecond => "Megabits/Second",
            StandardUnit::Megabytes => "Megabytes",
            StandardUnit::MegabytesSecond => "Megabytes/Second",
            StandardUnit::Microseconds => "Microseconds",
            StandardUnit::Milliseconds => "Milliseconds",
            StandardUnit::None => "None",
            StandardUnit::Percent => "Percent",
            StandardUnit::Seconds => "Seconds",
            StandardUnit::Terabits => "Terabits",
            StandardUnit::TerabitsSecond => "Terabits/Second",
            StandardUnit::Terabytes => "Terabytes",
            StandardUnit::TerabytesSecond => "Terabytes/Second",
            StandardUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bits",
            "Bits/Second",
            "Bytes",
            "Bytes/Second",
            "Count",
            "Count/Second",
            "Gigabits",
            "Gigabits/Second",
            "Gigabytes",
            "Gigabytes/Second",
            "Kilobits",
            "Kilobits/Second",
            "Kilobytes",
            "Kilobytes/Second",
            "Megabits",
            "Megabits/Second",
            "Megabytes",
            "Megabytes/Second",
            "Microseconds",
            "Milliseconds",
            "None",
            "Percent",
            "Seconds",
            "Terabits",
            "Terabits/Second",
            "Terabytes",
            "Terabytes/Second",
        ]
    }
}
impl AsRef<str> for StandardUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a set of statistics that describes a specific metric. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatisticSet {
    /// <p>The number of samples used for the statistic set.</p>
    pub sample_count: std::option::Option<f64>,
    /// <p>The sum of values for the sample set.</p>
    pub sum: std::option::Option<f64>,
    /// <p>The minimum value of the sample set.</p>
    pub minimum: std::option::Option<f64>,
    /// <p>The maximum value of the sample set.</p>
    pub maximum: std::option::Option<f64>,
}
impl StatisticSet {
    /// <p>The number of samples used for the statistic set.</p>
    pub fn sample_count(&self) -> std::option::Option<f64> {
        self.sample_count
    }
    /// <p>The sum of values for the sample set.</p>
    pub fn sum(&self) -> std::option::Option<f64> {
        self.sum
    }
    /// <p>The minimum value of the sample set.</p>
    pub fn minimum(&self) -> std::option::Option<f64> {
        self.minimum
    }
    /// <p>The maximum value of the sample set.</p>
    pub fn maximum(&self) -> std::option::Option<f64> {
        self.maximum
    }
}
impl std::fmt::Debug for StatisticSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatisticSet");
        formatter.field("sample_count", &self.sample_count);
        formatter.field("sum", &self.sum);
        formatter.field("minimum", &self.minimum);
        formatter.field("maximum", &self.maximum);
        formatter.finish()
    }
}
/// See [`StatisticSet`](crate::model::StatisticSet)
pub mod statistic_set {
    /// A builder for [`StatisticSet`](crate::model::StatisticSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sample_count: std::option::Option<f64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
        pub(crate) maximum: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The number of samples used for the statistic set.</p>
        pub fn sample_count(mut self, input: f64) -> Self {
            self.sample_count = Some(input);
            self
        }
        /// <p>The number of samples used for the statistic set.</p>
        pub fn set_sample_count(mut self, input: std::option::Option<f64>) -> Self {
            self.sample_count = input;
            self
        }
        /// <p>The sum of values for the sample set.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The sum of values for the sample set.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The minimum value of the sample set.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>The minimum value of the sample set.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>The maximum value of the sample set.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum value of the sample set.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// Consumes the builder and constructs a [`StatisticSet`](crate::model::StatisticSet)
        pub fn build(self) -> crate::model::StatisticSet {
            crate::model::StatisticSet {
                sample_count: self.sample_count,
                sum: self.sum,
                minimum: self.minimum,
                maximum: self.maximum,
            }
        }
    }
}
impl StatisticSet {
    /// Creates a new builder-style object to manufacture [`StatisticSet`](crate::model::StatisticSet)
    pub fn builder() -> crate::model::statistic_set::Builder {
        crate::model::statistic_set::Builder::default()
    }
}

/// <p>A dimension is a name/value pair that is part of the identity of a metric. You
/// can assign up to 10 dimensions to a metric. Because dimensions are part of the unique
/// identifier for a metric, whenever you add a unique name/value pair to one of
/// your metrics, you are creating a new variation of that metric. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Dimension {
    /// <p>The name of the dimension. Dimension names must contain only ASCII characters and must include
    /// at least one non-whitespace character.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the dimension. Dimension values must contain only ASCII characters and must include
    /// at least one non-whitespace character.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Dimension {
    /// <p>The name of the dimension. Dimension names must contain only ASCII characters and must include
    /// at least one non-whitespace character.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the dimension. Dimension values must contain only ASCII characters and must include
    /// at least one non-whitespace character.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Dimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Dimension");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Dimension`](crate::model::Dimension)
pub mod dimension {
    /// A builder for [`Dimension`](crate::model::Dimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dimension. Dimension names must contain only ASCII characters and must include
        /// at least one non-whitespace character.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the dimension. Dimension names must contain only ASCII characters and must include
        /// at least one non-whitespace character.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the dimension. Dimension values must contain only ASCII characters and must include
        /// at least one non-whitespace character.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the dimension. Dimension values must contain only ASCII characters and must include
        /// at least one non-whitespace character.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Dimension`](crate::model::Dimension)
        pub fn build(self) -> crate::model::Dimension {
            crate::model::Dimension {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl Dimension {
    /// Creates a new builder-style object to manufacture [`Dimension`](crate::model::Dimension)
    pub fn builder() -> crate::model::dimension::Builder {
        crate::model::dimension::Builder::default()
    }
}

/// <p>This structure is used in both <code>GetMetricData</code> and <code>PutMetricAlarm</code>. The supported
/// use of this structure is different for those two operations.</p>
/// <p>When used in <code>GetMetricData</code>, it indicates the metric data to return, and whether this call is just retrieving
/// a batch set of data for one metric, or is performing a math expression on metric data. A
/// single <code>GetMetricData</code> call can include up to 500 <code>MetricDataQuery</code>
/// structures.</p>
/// <p>When used in <code>PutMetricAlarm</code>, it enables you to create an alarm based on a
/// metric math expression. Each <code>MetricDataQuery</code> in the array specifies either
/// a metric to retrieve, or a math expression to be performed on retrieved metrics. A
/// single <code>PutMetricAlarm</code> call can include up to 20
/// <code>MetricDataQuery</code> structures in the array. The 20 structures can include
/// as many as 10 structures that contain a <code>MetricStat</code> parameter to retrieve a
/// metric, and as many as 10 structures that contain the <code>Expression</code> parameter
/// to perform a math expression. Of those <code>Expression</code> structures, one must have <code>True</code>
/// as the value for <code>ReturnData</code>. The result of this expression is the value the alarm watches.</p>
///
/// <p>Any expression used in a <code>PutMetricAlarm</code>
/// operation must return a single time series. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User
/// Guide</i>.</p>
///
/// <p>Some of the parameters of this structure also have different uses whether you are using this structure in a <code>GetMetricData</code>
/// operation or a <code>PutMetricAlarm</code> operation. These differences are explained in the following parameter list.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDataQuery {
    /// <p>A short name used to tie this object to the results in the response. This name must be
    /// unique within a single call to <code>GetMetricData</code>. If you are performing math
    /// expressions on this set of data, this name represents that data and can serve as a
    /// variable in the mathematical expression. The valid characters are letters, numbers, and
    /// underscore. The first character must be a lowercase letter.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric
    /// and not performing a math expression on returned data.</p>
    /// <p>Within one MetricDataQuery object, you must specify either
    /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
    pub metric_stat: std::option::Option<crate::model::MetricStat>,
    /// <p>The math expression to be performed on the returned data, if this object is performing a math expression. This expression
    /// can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other
    /// expressions to use the result of those expressions. For more information about metric math expressions, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the
    /// <i>Amazon CloudWatch User Guide</i>.</p>
    /// <p>Within each MetricDataQuery object, you must specify either
    /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
    pub expression: std::option::Option<std::string::String>,
    /// <p>A human-readable label for this metric or expression. This is especially useful
    /// if this is an expression, so that you know
    /// what the value represents. If the metric or expression is shown in a
    /// CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch
    /// generates a default.</p>
    /// <p>You can put dynamic expressions into a label, so that it is more descriptive.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a>.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>When used in <code>GetMetricData</code>, this option indicates whether to return the
    /// timestamps and raw data values of this metric. If you are performing this call just to
    /// do math expressions and do not also need the raw data returned, you can specify
    /// <code>False</code>. If you omit this, the default of <code>True</code> is
    /// used.</p>
    /// <p>When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use as the alarm. For all
    /// other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.</p>
    pub return_data: std::option::Option<bool>,
    /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a
    /// period can be as short as one minute (60 seconds) and must be a multiple of 60.
    /// For high-resolution metrics that are collected at intervals of less than one minute,
    /// the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics
    /// stored by a <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code>.</p>
    pub period: std::option::Option<i32>,
    /// <p>The ID of the account where the metrics are located, if this is a cross-account alarm.</p>
    /// <p>Use this field only for <code>PutMetricAlarm</code> operations. It is not used in
    /// <code>GetMetricData</code> operations.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl MetricDataQuery {
    /// <p>A short name used to tie this object to the results in the response. This name must be
    /// unique within a single call to <code>GetMetricData</code>. If you are performing math
    /// expressions on this set of data, this name represents that data and can serve as a
    /// variable in the mathematical expression. The valid characters are letters, numbers, and
    /// underscore. The first character must be a lowercase letter.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric
    /// and not performing a math expression on returned data.</p>
    /// <p>Within one MetricDataQuery object, you must specify either
    /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
    pub fn metric_stat(&self) -> std::option::Option<&crate::model::MetricStat> {
        self.metric_stat.as_ref()
    }
    /// <p>The math expression to be performed on the returned data, if this object is performing a math expression. This expression
    /// can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other
    /// expressions to use the result of those expressions. For more information about metric math expressions, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the
    /// <i>Amazon CloudWatch User Guide</i>.</p>
    /// <p>Within each MetricDataQuery object, you must specify either
    /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
    pub fn expression(&self) -> std::option::Option<&str> {
        self.expression.as_deref()
    }
    /// <p>A human-readable label for this metric or expression. This is especially useful
    /// if this is an expression, so that you know
    /// what the value represents. If the metric or expression is shown in a
    /// CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch
    /// generates a default.</p>
    /// <p>You can put dynamic expressions into a label, so that it is more descriptive.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a>.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>When used in <code>GetMetricData</code>, this option indicates whether to return the
    /// timestamps and raw data values of this metric. If you are performing this call just to
    /// do math expressions and do not also need the raw data returned, you can specify
    /// <code>False</code>. If you omit this, the default of <code>True</code> is
    /// used.</p>
    /// <p>When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use as the alarm. For all
    /// other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.</p>
    pub fn return_data(&self) -> std::option::Option<bool> {
        self.return_data
    }
    /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a
    /// period can be as short as one minute (60 seconds) and must be a multiple of 60.
    /// For high-resolution metrics that are collected at intervals of less than one minute,
    /// the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics
    /// stored by a <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code>.</p>
    pub fn period(&self) -> std::option::Option<i32> {
        self.period
    }
    /// <p>The ID of the account where the metrics are located, if this is a cross-account alarm.</p>
    /// <p>Use this field only for <code>PutMetricAlarm</code> operations. It is not used in
    /// <code>GetMetricData</code> operations.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for MetricDataQuery {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDataQuery");
        formatter.field("id", &self.id);
        formatter.field("metric_stat", &self.metric_stat);
        formatter.field("expression", &self.expression);
        formatter.field("label", &self.label);
        formatter.field("return_data", &self.return_data);
        formatter.field("period", &self.period);
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`MetricDataQuery`](crate::model::MetricDataQuery)
pub mod metric_data_query {
    /// A builder for [`MetricDataQuery`](crate::model::MetricDataQuery)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) metric_stat: std::option::Option<crate::model::MetricStat>,
        pub(crate) expression: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) return_data: std::option::Option<bool>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A short name used to tie this object to the results in the response. This name must be
        /// unique within a single call to <code>GetMetricData</code>. If you are performing math
        /// expressions on this set of data, this name represents that data and can serve as a
        /// variable in the mathematical expression. The valid characters are letters, numbers, and
        /// underscore. The first character must be a lowercase letter.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>A short name used to tie this object to the results in the response. This name must be
        /// unique within a single call to <code>GetMetricData</code>. If you are performing math
        /// expressions on this set of data, this name represents that data and can serve as a
        /// variable in the mathematical expression. The valid characters are letters, numbers, and
        /// underscore. The first character must be a lowercase letter.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric
        /// and not performing a math expression on returned data.</p>
        /// <p>Within one MetricDataQuery object, you must specify either
        /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
        pub fn metric_stat(mut self, input: crate::model::MetricStat) -> Self {
            self.metric_stat = Some(input);
            self
        }
        /// <p>The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric
        /// and not performing a math expression on returned data.</p>
        /// <p>Within one MetricDataQuery object, you must specify either
        /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
        pub fn set_metric_stat(
            mut self,
            input: std::option::Option<crate::model::MetricStat>,
        ) -> Self {
            self.metric_stat = input;
            self
        }
        /// <p>The math expression to be performed on the returned data, if this object is performing a math expression. This expression
        /// can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other
        /// expressions to use the result of those expressions. For more information about metric math expressions, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the
        /// <i>Amazon CloudWatch User Guide</i>.</p>
        /// <p>Within each MetricDataQuery object, you must specify either
        /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
        pub fn expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.expression = Some(input.into());
            self
        }
        /// <p>The math expression to be performed on the returned data, if this object is performing a math expression. This expression
        /// can use the <code>Id</code> of the other metrics to refer to those metrics, and can also use the <code>Id</code> of other
        /// expressions to use the result of those expressions. For more information about metric math expressions, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax">Metric Math Syntax and Functions</a> in the
        /// <i>Amazon CloudWatch User Guide</i>.</p>
        /// <p>Within each MetricDataQuery object, you must specify either
        /// <code>Expression</code> or <code>MetricStat</code> but not both.</p>
        pub fn set_expression(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.expression = input;
            self
        }
        /// <p>A human-readable label for this metric or expression. This is especially useful
        /// if this is an expression, so that you know
        /// what the value represents. If the metric or expression is shown in a
        /// CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch
        /// generates a default.</p>
        /// <p>You can put dynamic expressions into a label, so that it is more descriptive.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a>.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>A human-readable label for this metric or expression. This is especially useful
        /// if this is an expression, so that you know
        /// what the value represents. If the metric or expression is shown in a
        /// CloudWatch dashboard widget, the label is shown. If Label is omitted, CloudWatch
        /// generates a default.</p>
        /// <p>You can put dynamic expressions into a label, so that it is more descriptive.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a>.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>When used in <code>GetMetricData</code>, this option indicates whether to return the
        /// timestamps and raw data values of this metric. If you are performing this call just to
        /// do math expressions and do not also need the raw data returned, you can specify
        /// <code>False</code>. If you omit this, the default of <code>True</code> is
        /// used.</p>
        /// <p>When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use as the alarm. For all
        /// other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.</p>
        pub fn return_data(mut self, input: bool) -> Self {
            self.return_data = Some(input);
            self
        }
        /// <p>When used in <code>GetMetricData</code>, this option indicates whether to return the
        /// timestamps and raw data values of this metric. If you are performing this call just to
        /// do math expressions and do not also need the raw data returned, you can specify
        /// <code>False</code>. If you omit this, the default of <code>True</code> is
        /// used.</p>
        /// <p>When used in <code>PutMetricAlarm</code>, specify <code>True</code> for the one expression result to use as the alarm. For all
        /// other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify <code>ReturnData</code> as False.</p>
        pub fn set_return_data(mut self, input: std::option::Option<bool>) -> Self {
            self.return_data = input;
            self
        }
        /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a
        /// period can be as short as one minute (60 seconds) and must be a multiple of 60.
        /// For high-resolution metrics that are collected at intervals of less than one minute,
        /// the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics
        /// stored by a <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code>.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a
        /// period can be as short as one minute (60 seconds) and must be a multiple of 60.
        /// For high-resolution metrics that are collected at intervals of less than one minute,
        /// the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics are those metrics
        /// stored by a <code>PutMetricData</code> operation that includes a <code>StorageResolution of 1 second</code>.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The ID of the account where the metrics are located, if this is a cross-account alarm.</p>
        /// <p>Use this field only for <code>PutMetricAlarm</code> operations. It is not used in
        /// <code>GetMetricData</code> operations.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The ID of the account where the metrics are located, if this is a cross-account alarm.</p>
        /// <p>Use this field only for <code>PutMetricAlarm</code> operations. It is not used in
        /// <code>GetMetricData</code> operations.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDataQuery`](crate::model::MetricDataQuery)
        pub fn build(self) -> crate::model::MetricDataQuery {
            crate::model::MetricDataQuery {
                id: self.id,
                metric_stat: self.metric_stat,
                expression: self.expression,
                label: self.label,
                return_data: self.return_data,
                period: self.period,
                account_id: self.account_id,
            }
        }
    }
}
impl MetricDataQuery {
    /// Creates a new builder-style object to manufacture [`MetricDataQuery`](crate::model::MetricDataQuery)
    pub fn builder() -> crate::model::metric_data_query::Builder {
        crate::model::metric_data_query::Builder::default()
    }
}

/// <p>This structure defines the metric to be returned, along with the statistics, period, and units.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricStat {
    /// <p>The metric to return, including the metric name, namespace, and dimensions.</p>
    pub metric: std::option::Option<crate::model::Metric>,
    /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can
    /// be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected
    /// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics
    /// are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>
    /// <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than
    /// 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p>
    /// <ul>
    /// <li>
    /// <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p>
    /// </li>
    /// <li>
    /// <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p>
    /// </li>
    /// <li>
    /// <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p>
    /// </li>
    /// </ul>
    pub period: std::option::Option<i32>,
    /// <p>The statistic to return. It can include any CloudWatch statistic or extended statistic.</p>
    pub stat: std::option::Option<std::string::String>,
    /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
    /// <p>In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified
    /// when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified.
    /// If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>
    pub unit: std::option::Option<crate::model::StandardUnit>,
}
impl MetricStat {
    /// <p>The metric to return, including the metric name, namespace, and dimensions.</p>
    pub fn metric(&self) -> std::option::Option<&crate::model::Metric> {
        self.metric.as_ref()
    }
    /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can
    /// be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected
    /// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics
    /// are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>
    /// <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than
    /// 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p>
    /// <ul>
    /// <li>
    /// <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p>
    /// </li>
    /// <li>
    /// <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p>
    /// </li>
    /// <li>
    /// <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p>
    /// </li>
    /// </ul>
    pub fn period(&self) -> std::option::Option<i32> {
        self.period
    }
    /// <p>The statistic to return. It can include any CloudWatch statistic or extended statistic.</p>
    pub fn stat(&self) -> std::option::Option<&str> {
        self.stat.as_deref()
    }
    /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
    /// <p>In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified
    /// when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified.
    /// If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::StandardUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for MetricStat {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricStat");
        formatter.field("metric", &self.metric);
        formatter.field("period", &self.period);
        formatter.field("stat", &self.stat);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`MetricStat`](crate::model::MetricStat)
pub mod metric_stat {
    /// A builder for [`MetricStat`](crate::model::MetricStat)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric: std::option::Option<crate::model::Metric>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) stat: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<crate::model::StandardUnit>,
    }
    impl Builder {
        /// <p>The metric to return, including the metric name, namespace, and dimensions.</p>
        pub fn metric(mut self, input: crate::model::Metric) -> Self {
            self.metric = Some(input);
            self
        }
        /// <p>The metric to return, including the metric name, namespace, and dimensions.</p>
        pub fn set_metric(mut self, input: std::option::Option<crate::model::Metric>) -> Self {
            self.metric = input;
            self
        }
        /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can
        /// be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected
        /// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics
        /// are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>
        /// <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than
        /// 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p>
        /// <ul>
        /// <li>
        /// <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p>
        /// </li>
        /// <li>
        /// <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p>
        /// </li>
        /// <li>
        /// <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p>
        /// </li>
        /// </ul>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can
        /// be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected
        /// at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution metrics
        /// are those metrics stored by a <code>PutMetricData</code> call that includes a <code>StorageResolution</code> of 1 second.</p>
        /// <p>If the <code>StartTime</code> parameter specifies a time stamp that is greater than
        /// 3 hours ago, you must specify the period as follows or no data points in that time range is returned:</p>
        /// <ul>
        /// <li>
        /// <p>Start time between 3 hours and 15 days ago - Use a multiple of 60 seconds (1 minute).</p>
        /// </li>
        /// <li>
        /// <p>Start time between 15 and 63 days ago - Use a multiple of 300 seconds (5 minutes).</p>
        /// </li>
        /// <li>
        /// <p>Start time greater than 63 days ago - Use a multiple of 3600 seconds (1 hour).</p>
        /// </li>
        /// </ul>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The statistic to return. It can include any CloudWatch statistic or extended statistic.</p>
        pub fn stat(mut self, input: impl Into<std::string::String>) -> Self {
            self.stat = Some(input.into());
            self
        }
        /// <p>The statistic to return. It can include any CloudWatch statistic or extended statistic.</p>
        pub fn set_stat(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stat = input;
            self
        }
        /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
        /// <p>In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified
        /// when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified.
        /// If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>
        pub fn unit(mut self, input: crate::model::StandardUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>When you are using a <code>Put</code> operation, this defines what unit you want to use when storing the metric.</p>
        /// <p>In a <code>Get</code> operation, if you omit <code>Unit</code> then all data that was collected with any unit is returned, along with the corresponding units that were specified
        /// when the data was reported to CloudWatch. If you specify a unit, the operation returns only data that was collected with that unit specified.
        /// If you specify a unit that does not match the data collected, the results of the operation are null. CloudWatch does not perform unit conversions.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::StandardUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricStat`](crate::model::MetricStat)
        pub fn build(self) -> crate::model::MetricStat {
            crate::model::MetricStat {
                metric: self.metric,
                period: self.period,
                stat: self.stat,
                unit: self.unit,
            }
        }
    }
}
impl MetricStat {
    /// Creates a new builder-style object to manufacture [`MetricStat`](crate::model::MetricStat)
    pub fn builder() -> crate::model::metric_stat::Builder {
        crate::model::metric_stat::Builder::default()
    }
}

/// <p>Represents a specific metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metric {
    /// <p>The namespace of the metric.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the metric. This is a required field.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The dimensions for the metric.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
}
impl Metric {
    /// <p>The namespace of the metric.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The name of the metric. This is a required field.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The dimensions for the metric.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::Dimension]> {
        self.dimensions.as_deref()
    }
}
impl std::fmt::Debug for Metric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metric");
        formatter.field("namespace", &self.namespace);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("dimensions", &self.dimensions);
        formatter.finish()
    }
}
/// See [`Metric`](crate::model::Metric)
pub mod metric {
    /// A builder for [`Metric`](crate::model::Metric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
    }
    impl Builder {
        /// <p>The namespace of the metric.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the metric. This is a required field.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric. This is a required field.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions for the metric.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::Dimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions for the metric.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// Consumes the builder and constructs a [`Metric`](crate::model::Metric)
        pub fn build(self) -> crate::model::Metric {
            crate::model::Metric {
                namespace: self.namespace,
                metric_name: self.metric_name,
                dimensions: self.dimensions,
            }
        }
    }
}
impl Metric {
    /// Creates a new builder-style object to manufacture [`Metric`](crate::model::Metric)
    pub fn builder() -> crate::model::metric::Builder {
        crate::model::metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualToThreshold,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanThreshold,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanUpperThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanLowerOrGreaterThanUpperThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanLowerThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualToThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanThreshold,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "GreaterThanOrEqualToThreshold" => ComparisonOperator::GreaterThanOrEqualToThreshold,
            "GreaterThanThreshold" => ComparisonOperator::GreaterThanThreshold,
            "GreaterThanUpperThreshold" => ComparisonOperator::GreaterThanUpperThreshold,
            "LessThanLowerOrGreaterThanUpperThreshold" => {
                ComparisonOperator::LessThanLowerOrGreaterThanUpperThreshold
            }
            "LessThanLowerThreshold" => ComparisonOperator::LessThanLowerThreshold,
            "LessThanOrEqualToThreshold" => ComparisonOperator::LessThanOrEqualToThreshold,
            "LessThanThreshold" => ComparisonOperator::LessThanThreshold,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::GreaterThanOrEqualToThreshold => "GreaterThanOrEqualToThreshold",
            ComparisonOperator::GreaterThanThreshold => "GreaterThanThreshold",
            ComparisonOperator::GreaterThanUpperThreshold => "GreaterThanUpperThreshold",
            ComparisonOperator::LessThanLowerOrGreaterThanUpperThreshold => {
                "LessThanLowerOrGreaterThanUpperThreshold"
            }
            ComparisonOperator::LessThanLowerThreshold => "LessThanLowerThreshold",
            ComparisonOperator::LessThanOrEqualToThreshold => "LessThanOrEqualToThreshold",
            ComparisonOperator::LessThanThreshold => "LessThanThreshold",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "GreaterThanOrEqualToThreshold",
            "GreaterThanThreshold",
            "GreaterThanUpperThreshold",
            "LessThanLowerOrGreaterThanUpperThreshold",
            "LessThanLowerThreshold",
            "LessThanOrEqualToThreshold",
            "LessThanThreshold",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Statistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Statistic {
    fn from(s: &str) -> Self {
        match s {
            "Average" => Statistic::Average,
            "Maximum" => Statistic::Maximum,
            "Minimum" => Statistic::Minimum,
            "SampleCount" => Statistic::SampleCount,
            "Sum" => Statistic::Sum,
            other => Statistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Statistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Statistic::from(s))
    }
}
impl Statistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Statistic::Average => "Average",
            Statistic::Maximum => "Maximum",
            Statistic::Minimum => "Minimum",
            Statistic::SampleCount => "SampleCount",
            Statistic::Sum => "Sum",
            Statistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum", "Minimum", "SampleCount", "Sum"]
    }
}
impl AsRef<str> for Statistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An error or warning for the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardValidationMessage {
    /// <p>The data path related to the message.</p>
    pub data_path: std::option::Option<std::string::String>,
    /// <p>A message describing the error or warning.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DashboardValidationMessage {
    /// <p>The data path related to the message.</p>
    pub fn data_path(&self) -> std::option::Option<&str> {
        self.data_path.as_deref()
    }
    /// <p>A message describing the error or warning.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DashboardValidationMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardValidationMessage");
        formatter.field("data_path", &self.data_path);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DashboardValidationMessage`](crate::model::DashboardValidationMessage)
pub mod dashboard_validation_message {
    /// A builder for [`DashboardValidationMessage`](crate::model::DashboardValidationMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_path: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The data path related to the message.</p>
        pub fn data_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_path = Some(input.into());
            self
        }
        /// <p>The data path related to the message.</p>
        pub fn set_data_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_path = input;
            self
        }
        /// <p>A message describing the error or warning.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message describing the error or warning.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardValidationMessage`](crate::model::DashboardValidationMessage)
        pub fn build(self) -> crate::model::DashboardValidationMessage {
            crate::model::DashboardValidationMessage {
                data_path: self.data_path,
                message: self.message,
            }
        }
    }
}
impl DashboardValidationMessage {
    /// Creates a new builder-style object to manufacture [`DashboardValidationMessage`](crate::model::DashboardValidationMessage)
    pub fn builder() -> crate::model::dashboard_validation_message::Builder {
        crate::model::dashboard_validation_message::Builder::default()
    }
}

/// <p>The configuration specifies details about how the anomaly detection model is to be trained,
/// including time ranges to exclude from use for training the model and the time zone to
/// use for the metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyDetectorConfiguration {
    /// <p>An array of time ranges to exclude from use when the anomaly detection model is trained. Use
    /// this to make sure that events that could cause unusual values for the metric, such as
    /// deployments, aren't used when CloudWatch creates the model.</p>
    pub excluded_time_ranges: std::option::Option<std::vec::Vec<crate::model::Range>>,
    /// <p>The time zone to use for the metric. This is useful to enable the model to automatically
    /// account for daylight savings time changes if the metric is sensitive to such time
    /// changes.</p>
    /// <p>To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information,
    /// see <a href="https://en.wikipedia.org/wiki/Tz_database">tz database</a>.</p>
    pub metric_timezone: std::option::Option<std::string::String>,
}
impl AnomalyDetectorConfiguration {
    /// <p>An array of time ranges to exclude from use when the anomaly detection model is trained. Use
    /// this to make sure that events that could cause unusual values for the metric, such as
    /// deployments, aren't used when CloudWatch creates the model.</p>
    pub fn excluded_time_ranges(&self) -> std::option::Option<&[crate::model::Range]> {
        self.excluded_time_ranges.as_deref()
    }
    /// <p>The time zone to use for the metric. This is useful to enable the model to automatically
    /// account for daylight savings time changes if the metric is sensitive to such time
    /// changes.</p>
    /// <p>To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information,
    /// see <a href="https://en.wikipedia.org/wiki/Tz_database">tz database</a>.</p>
    pub fn metric_timezone(&self) -> std::option::Option<&str> {
        self.metric_timezone.as_deref()
    }
}
impl std::fmt::Debug for AnomalyDetectorConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyDetectorConfiguration");
        formatter.field("excluded_time_ranges", &self.excluded_time_ranges);
        formatter.field("metric_timezone", &self.metric_timezone);
        formatter.finish()
    }
}
/// See [`AnomalyDetectorConfiguration`](crate::model::AnomalyDetectorConfiguration)
pub mod anomaly_detector_configuration {
    /// A builder for [`AnomalyDetectorConfiguration`](crate::model::AnomalyDetectorConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) excluded_time_ranges: std::option::Option<std::vec::Vec<crate::model::Range>>,
        pub(crate) metric_timezone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `excluded_time_ranges`.
        ///
        /// To override the contents of this collection use [`set_excluded_time_ranges`](Self::set_excluded_time_ranges).
        ///
        /// <p>An array of time ranges to exclude from use when the anomaly detection model is trained. Use
        /// this to make sure that events that could cause unusual values for the metric, such as
        /// deployments, aren't used when CloudWatch creates the model.</p>
        pub fn excluded_time_ranges(mut self, input: impl Into<crate::model::Range>) -> Self {
            let mut v = self.excluded_time_ranges.unwrap_or_default();
            v.push(input.into());
            self.excluded_time_ranges = Some(v);
            self
        }
        /// <p>An array of time ranges to exclude from use when the anomaly detection model is trained. Use
        /// this to make sure that events that could cause unusual values for the metric, such as
        /// deployments, aren't used when CloudWatch creates the model.</p>
        pub fn set_excluded_time_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Range>>,
        ) -> Self {
            self.excluded_time_ranges = input;
            self
        }
        /// <p>The time zone to use for the metric. This is useful to enable the model to automatically
        /// account for daylight savings time changes if the metric is sensitive to such time
        /// changes.</p>
        /// <p>To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information,
        /// see <a href="https://en.wikipedia.org/wiki/Tz_database">tz database</a>.</p>
        pub fn metric_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_timezone = Some(input.into());
            self
        }
        /// <p>The time zone to use for the metric. This is useful to enable the model to automatically
        /// account for daylight savings time changes if the metric is sensitive to such time
        /// changes.</p>
        /// <p>To specify a time zone, use the name of the time zone as specified in the standard tz database. For more information,
        /// see <a href="https://en.wikipedia.org/wiki/Tz_database">tz database</a>.</p>
        pub fn set_metric_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_timezone = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyDetectorConfiguration`](crate::model::AnomalyDetectorConfiguration)
        pub fn build(self) -> crate::model::AnomalyDetectorConfiguration {
            crate::model::AnomalyDetectorConfiguration {
                excluded_time_ranges: self.excluded_time_ranges,
                metric_timezone: self.metric_timezone,
            }
        }
    }
}
impl AnomalyDetectorConfiguration {
    /// Creates a new builder-style object to manufacture [`AnomalyDetectorConfiguration`](crate::model::AnomalyDetectorConfiguration)
    pub fn builder() -> crate::model::anomaly_detector_configuration::Builder {
        crate::model::anomaly_detector_configuration::Builder::default()
    }
}

/// <p>Specifies one range of days or times to exclude from use for training an
/// anomaly detection model.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Range {
    /// <p>The start time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
    /// <code>2019-07-01T23:59:59</code>.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
    /// <code>2019-07-01T23:59:59</code>.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
}
impl Range {
    /// <p>The start time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
    /// <code>2019-07-01T23:59:59</code>.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.start_time.as_ref()
    }
    /// <p>The end time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
    /// <code>2019-07-01T23:59:59</code>.</p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for Range {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Range");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`Range`](crate::model::Range)
pub mod range {
    /// A builder for [`Range`](crate::model::Range)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The start time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
        /// <code>2019-07-01T23:59:59</code>.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
        /// <code>2019-07-01T23:59:59</code>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
        /// <code>2019-07-01T23:59:59</code>.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the range to exclude. The format is <code>yyyy-MM-dd'T'HH:mm:ss</code>. For example,
        /// <code>2019-07-01T23:59:59</code>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Range`](crate::model::Range)
        pub fn build(self) -> crate::model::Range {
            crate::model::Range {
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl Range {
    /// Creates a new builder-style object to manufacture [`Range`](crate::model::Range)
    pub fn builder() -> crate::model::range::Builder {
        crate::model::range::Builder::default()
    }
}

/// <p>This structure contains the configuration information about one metric stream.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricStreamEntry {
    /// <p>The ARN of the metric stream.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date that the metric stream was originally created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date that the configuration of this metric stream was most recently updated.</p>
    pub last_update_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the metric stream.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.</p>
    pub firehose_arn: std::option::Option<std::string::String>,
    /// <p>The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The output format of this metric stream. Valid values are
    /// <code>json</code>
    /// and <code>opentelemetry0.7</code>.</p>
    pub output_format: std::option::Option<crate::model::MetricStreamOutputFormat>,
}
impl MetricStreamEntry {
    /// <p>The ARN of the metric stream.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date that the metric stream was originally created.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.creation_date.as_ref()
    }
    /// <p>The date that the configuration of this metric stream was most recently updated.</p>
    pub fn last_update_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_update_date.as_ref()
    }
    /// <p>The name of the metric stream.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.</p>
    pub fn firehose_arn(&self) -> std::option::Option<&str> {
        self.firehose_arn.as_deref()
    }
    /// <p>The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The output format of this metric stream. Valid values are
    /// <code>json</code>
    /// and <code>opentelemetry0.7</code>.</p>
    pub fn output_format(&self) -> std::option::Option<&crate::model::MetricStreamOutputFormat> {
        self.output_format.as_ref()
    }
}
impl std::fmt::Debug for MetricStreamEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricStreamEntry");
        formatter.field("arn", &self.arn);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_update_date", &self.last_update_date);
        formatter.field("name", &self.name);
        formatter.field("firehose_arn", &self.firehose_arn);
        formatter.field("state", &self.state);
        formatter.field("output_format", &self.output_format);
        formatter.finish()
    }
}
/// See [`MetricStreamEntry`](crate::model::MetricStreamEntry)
pub mod metric_stream_entry {
    /// A builder for [`MetricStreamEntry`](crate::model::MetricStreamEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_update_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) firehose_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) output_format: std::option::Option<crate::model::MetricStreamOutputFormat>,
    }
    impl Builder {
        /// <p>The ARN of the metric stream.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The ARN of the metric stream.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date that the metric stream was originally created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date that the metric stream was originally created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date that the configuration of this metric stream was most recently updated.</p>
        pub fn last_update_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_update_date = Some(input);
            self
        }
        /// <p>The date that the configuration of this metric stream was most recently updated.</p>
        pub fn set_last_update_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_update_date = input;
            self
        }
        /// <p>The name of the metric stream.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the metric stream.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.</p>
        pub fn firehose_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.firehose_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Kinesis Firehose devlivery stream that is used for this metric stream.</p>
        pub fn set_firehose_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.firehose_arn = input;
            self
        }
        /// <p>The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The current state of this stream. Valid values are <code>running</code> and <code>stopped</code>.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The output format of this metric stream. Valid values are
        /// <code>json</code>
        /// and <code>opentelemetry0.7</code>.</p>
        pub fn output_format(mut self, input: crate::model::MetricStreamOutputFormat) -> Self {
            self.output_format = Some(input);
            self
        }
        /// <p>The output format of this metric stream. Valid values are
        /// <code>json</code>
        /// and <code>opentelemetry0.7</code>.</p>
        pub fn set_output_format(
            mut self,
            input: std::option::Option<crate::model::MetricStreamOutputFormat>,
        ) -> Self {
            self.output_format = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricStreamEntry`](crate::model::MetricStreamEntry)
        pub fn build(self) -> crate::model::MetricStreamEntry {
            crate::model::MetricStreamEntry {
                arn: self.arn,
                creation_date: self.creation_date,
                last_update_date: self.last_update_date,
                name: self.name,
                firehose_arn: self.firehose_arn,
                state: self.state,
                output_format: self.output_format,
            }
        }
    }
}
impl MetricStreamEntry {
    /// Creates a new builder-style object to manufacture [`MetricStreamEntry`](crate::model::MetricStreamEntry)
    pub fn builder() -> crate::model::metric_stream_entry::Builder {
        crate::model::metric_stream_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecentlyActive {
    #[allow(missing_docs)] // documentation missing in model
    Pt3H,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecentlyActive {
    fn from(s: &str) -> Self {
        match s {
            "PT3H" => RecentlyActive::Pt3H,
            other => RecentlyActive::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecentlyActive {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecentlyActive::from(s))
    }
}
impl RecentlyActive {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecentlyActive::Pt3H => "PT3H",
            RecentlyActive::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PT3H"]
    }
}
impl AsRef<str> for RecentlyActive {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents filters for a dimension.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionFilter {
    /// <p>The dimension name to be matched.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the dimension to be matched.</p>
    pub value: std::option::Option<std::string::String>,
}
impl DimensionFilter {
    /// <p>The dimension name to be matched.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the dimension to be matched.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for DimensionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionFilter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`DimensionFilter`](crate::model::DimensionFilter)
pub mod dimension_filter {
    /// A builder for [`DimensionFilter`](crate::model::DimensionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The dimension name to be matched.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The dimension name to be matched.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the dimension to be matched.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the dimension to be matched.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionFilter`](crate::model::DimensionFilter)
        pub fn build(self) -> crate::model::DimensionFilter {
            crate::model::DimensionFilter {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl DimensionFilter {
    /// Creates a new builder-style object to manufacture [`DimensionFilter`](crate::model::DimensionFilter)
    pub fn builder() -> crate::model::dimension_filter::Builder {
        crate::model::dimension_filter::Builder::default()
    }
}

/// <p>Represents a specific dashboard.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DashboardEntry {
    /// <p>The name of the dashboard.</p>
    pub dashboard_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub dashboard_arn: std::option::Option<std::string::String>,
    /// <p>The time stamp of when the dashboard was last modified, either by an API call or
    /// through the console. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
    pub last_modified: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The size of the dashboard, in bytes.</p>
    pub size: i64,
}
impl DashboardEntry {
    /// <p>The name of the dashboard.</p>
    pub fn dashboard_name(&self) -> std::option::Option<&str> {
        self.dashboard_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
    pub fn dashboard_arn(&self) -> std::option::Option<&str> {
        self.dashboard_arn.as_deref()
    }
    /// <p>The time stamp of when the dashboard was last modified, either by an API call or
    /// through the console. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_modified.as_ref()
    }
    /// <p>The size of the dashboard, in bytes.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
}
impl std::fmt::Debug for DashboardEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DashboardEntry");
        formatter.field("dashboard_name", &self.dashboard_name);
        formatter.field("dashboard_arn", &self.dashboard_arn);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`DashboardEntry`](crate::model::DashboardEntry)
pub mod dashboard_entry {
    /// A builder for [`DashboardEntry`](crate::model::DashboardEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dashboard_name: std::option::Option<std::string::String>,
        pub(crate) dashboard_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the dashboard.</p>
        pub fn dashboard_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_name = Some(input.into());
            self
        }
        /// <p>The name of the dashboard.</p>
        pub fn set_dashboard_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn dashboard_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.dashboard_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the dashboard.</p>
        pub fn set_dashboard_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dashboard_arn = input;
            self
        }
        /// <p>The time stamp of when the dashboard was last modified, either by an API call or
        /// through the console. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The time stamp of when the dashboard was last modified, either by an API call or
        /// through the console. This number is expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The size of the dashboard, in bytes.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size of the dashboard, in bytes.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// Consumes the builder and constructs a [`DashboardEntry`](crate::model::DashboardEntry)
        pub fn build(self) -> crate::model::DashboardEntry {
            crate::model::DashboardEntry {
                dashboard_name: self.dashboard_name,
                dashboard_arn: self.dashboard_arn,
                last_modified: self.last_modified,
                size: self.size.unwrap_or_default(),
            }
        }
    }
}
impl DashboardEntry {
    /// Creates a new builder-style object to manufacture [`DashboardEntry`](crate::model::DashboardEntry)
    pub fn builder() -> crate::model::dashboard_entry::Builder {
        crate::model::dashboard_entry::Builder::default()
    }
}

/// <p>Encapsulates the statistical data that CloudWatch computes from metric data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Datapoint {
    /// <p>The time stamp used for the data point.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of metric values that contributed to the aggregate value of this
    /// data point.</p>
    pub sample_count: std::option::Option<f64>,
    /// <p>The average of the metric values that correspond to the data point.</p>
    pub average: std::option::Option<f64>,
    /// <p>The sum of the metric values for the data point.</p>
    pub sum: std::option::Option<f64>,
    /// <p>The minimum metric value for the data point.</p>
    pub minimum: std::option::Option<f64>,
    /// <p>The maximum metric value for the data point.</p>
    pub maximum: std::option::Option<f64>,
    /// <p>The standard unit for the data point.</p>
    pub unit: std::option::Option<crate::model::StandardUnit>,
    /// <p>The percentile statistic for the data point.</p>
    pub extended_statistics:
        std::option::Option<std::collections::HashMap<std::string::String, f64>>,
}
impl Datapoint {
    /// <p>The time stamp used for the data point.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The number of metric values that contributed to the aggregate value of this
    /// data point.</p>
    pub fn sample_count(&self) -> std::option::Option<f64> {
        self.sample_count
    }
    /// <p>The average of the metric values that correspond to the data point.</p>
    pub fn average(&self) -> std::option::Option<f64> {
        self.average
    }
    /// <p>The sum of the metric values for the data point.</p>
    pub fn sum(&self) -> std::option::Option<f64> {
        self.sum
    }
    /// <p>The minimum metric value for the data point.</p>
    pub fn minimum(&self) -> std::option::Option<f64> {
        self.minimum
    }
    /// <p>The maximum metric value for the data point.</p>
    pub fn maximum(&self) -> std::option::Option<f64> {
        self.maximum
    }
    /// <p>The standard unit for the data point.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::StandardUnit> {
        self.unit.as_ref()
    }
    /// <p>The percentile statistic for the data point.</p>
    pub fn extended_statistics(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, f64>> {
        self.extended_statistics.as_ref()
    }
}
impl std::fmt::Debug for Datapoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Datapoint");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("sample_count", &self.sample_count);
        formatter.field("average", &self.average);
        formatter.field("sum", &self.sum);
        formatter.field("minimum", &self.minimum);
        formatter.field("maximum", &self.maximum);
        formatter.field("unit", &self.unit);
        formatter.field("extended_statistics", &self.extended_statistics);
        formatter.finish()
    }
}
/// See [`Datapoint`](crate::model::Datapoint)
pub mod datapoint {
    /// A builder for [`Datapoint`](crate::model::Datapoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) sample_count: std::option::Option<f64>,
        pub(crate) average: std::option::Option<f64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
        pub(crate) maximum: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<crate::model::StandardUnit>,
        pub(crate) extended_statistics:
            std::option::Option<std::collections::HashMap<std::string::String, f64>>,
    }
    impl Builder {
        /// <p>The time stamp used for the data point.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time stamp used for the data point.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The number of metric values that contributed to the aggregate value of this
        /// data point.</p>
        pub fn sample_count(mut self, input: f64) -> Self {
            self.sample_count = Some(input);
            self
        }
        /// <p>The number of metric values that contributed to the aggregate value of this
        /// data point.</p>
        pub fn set_sample_count(mut self, input: std::option::Option<f64>) -> Self {
            self.sample_count = input;
            self
        }
        /// <p>The average of the metric values that correspond to the data point.</p>
        pub fn average(mut self, input: f64) -> Self {
            self.average = Some(input);
            self
        }
        /// <p>The average of the metric values that correspond to the data point.</p>
        pub fn set_average(mut self, input: std::option::Option<f64>) -> Self {
            self.average = input;
            self
        }
        /// <p>The sum of the metric values for the data point.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The sum of the metric values for the data point.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The minimum metric value for the data point.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>The minimum metric value for the data point.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>The maximum metric value for the data point.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum metric value for the data point.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// <p>The standard unit for the data point.</p>
        pub fn unit(mut self, input: crate::model::StandardUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The standard unit for the data point.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::StandardUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Adds a key-value pair to `extended_statistics`.
        ///
        /// To override the contents of this collection use [`set_extended_statistics`](Self::set_extended_statistics).
        ///
        /// <p>The percentile statistic for the data point.</p>
        pub fn extended_statistics(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<f64>,
        ) -> Self {
            let mut hash_map = self.extended_statistics.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.extended_statistics = Some(hash_map);
            self
        }
        /// <p>The percentile statistic for the data point.</p>
        pub fn set_extended_statistics(
            mut self,
            input: std::option::Option<std::collections::HashMap<std::string::String, f64>>,
        ) -> Self {
            self.extended_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`Datapoint`](crate::model::Datapoint)
        pub fn build(self) -> crate::model::Datapoint {
            crate::model::Datapoint {
                timestamp: self.timestamp,
                sample_count: self.sample_count,
                average: self.average,
                sum: self.sum,
                minimum: self.minimum,
                maximum: self.maximum,
                unit: self.unit,
                extended_statistics: self.extended_statistics,
            }
        }
    }
}
impl Datapoint {
    /// Creates a new builder-style object to manufacture [`Datapoint`](crate::model::Datapoint)
    pub fn builder() -> crate::model::datapoint::Builder {
        crate::model::datapoint::Builder::default()
    }
}

/// <p>A message returned by the <code>GetMetricData</code>API, including a code and a description.</p>
/// <p>If a cross-Region <code>GetMetricData</code> operation fails with a code of <code>Forbidden</code> and a
/// value of <code>Authentication too complex to
/// retrieve cross region data</code>, you can correct the problem by running the <code>GetMetricData</code>
/// operation in the same Region where the metric data is.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MessageData {
    /// <p>The error code or status code associated with the message.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The message text.</p>
    pub value: std::option::Option<std::string::String>,
}
impl MessageData {
    /// <p>The error code or status code associated with the message.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The message text.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for MessageData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MessageData");
        formatter.field("code", &self.code);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`MessageData`](crate::model::MessageData)
pub mod message_data {
    /// A builder for [`MessageData`](crate::model::MessageData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code or status code associated with the message.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The error code or status code associated with the message.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The message text.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The message text.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`MessageData`](crate::model::MessageData)
        pub fn build(self) -> crate::model::MessageData {
            crate::model::MessageData {
                code: self.code,
                value: self.value,
            }
        }
    }
}
impl MessageData {
    /// Creates a new builder-style object to manufacture [`MessageData`](crate::model::MessageData)
    pub fn builder() -> crate::model::message_data::Builder {
        crate::model::message_data::Builder::default()
    }
}

/// <p>A <code>GetMetricData</code> call returns an array of <code>MetricDataResult</code>
/// structures. Each of these structures includes the data points for that metric, along
/// with the timestamps of those data points and other identifying information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDataResult {
    /// <p>The short name you specified to represent this metric.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The human-readable label associated with the data.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The timestamps for the data points, formatted in Unix timestamp format. The number of
    /// timestamps always matches the number of values and the value for Timestamps[x] is
    /// Values[x].</p>
    pub timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
    /// <p>The data points for the metric corresponding to <code>Timestamps</code>. The number of
    /// values always matches the number of timestamps and the timestamp for Values[x] is
    /// Timestamps[x].</p>
    pub values: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The status of the returned data. <code>Complete</code> indicates that all data points in the requested time range were returned.
    /// <code>PartialData</code> means that an incomplete set of data points were returned.
    /// You can use the <code>NextToken</code> value that was returned and repeat your request to get more data points.
    /// <code>NextToken</code> is not returned if you are performing a math expression. <code>InternalError</code>  
    /// indicates that an error occurred. Retry your request using <code>NextToken</code>, if present.</p>
    pub status_code: std::option::Option<crate::model::StatusCode>,
    /// <p>A list of messages with additional information about the data returned.</p>
    pub messages: std::option::Option<std::vec::Vec<crate::model::MessageData>>,
}
impl MetricDataResult {
    /// <p>The short name you specified to represent this metric.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The human-readable label associated with the data.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>The timestamps for the data points, formatted in Unix timestamp format. The number of
    /// timestamps always matches the number of values and the value for Timestamps[x] is
    /// Values[x].</p>
    pub fn timestamps(&self) -> std::option::Option<&[aws_smithy_types::Instant]> {
        self.timestamps.as_deref()
    }
    /// <p>The data points for the metric corresponding to <code>Timestamps</code>. The number of
    /// values always matches the number of timestamps and the timestamp for Values[x] is
    /// Timestamps[x].</p>
    pub fn values(&self) -> std::option::Option<&[f64]> {
        self.values.as_deref()
    }
    /// <p>The status of the returned data. <code>Complete</code> indicates that all data points in the requested time range were returned.
    /// <code>PartialData</code> means that an incomplete set of data points were returned.
    /// You can use the <code>NextToken</code> value that was returned and repeat your request to get more data points.
    /// <code>NextToken</code> is not returned if you are performing a math expression. <code>InternalError</code>  
    /// indicates that an error occurred. Retry your request using <code>NextToken</code>, if present.</p>
    pub fn status_code(&self) -> std::option::Option<&crate::model::StatusCode> {
        self.status_code.as_ref()
    }
    /// <p>A list of messages with additional information about the data returned.</p>
    pub fn messages(&self) -> std::option::Option<&[crate::model::MessageData]> {
        self.messages.as_deref()
    }
}
impl std::fmt::Debug for MetricDataResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDataResult");
        formatter.field("id", &self.id);
        formatter.field("label", &self.label);
        formatter.field("timestamps", &self.timestamps);
        formatter.field("values", &self.values);
        formatter.field("status_code", &self.status_code);
        formatter.field("messages", &self.messages);
        formatter.finish()
    }
}
/// See [`MetricDataResult`](crate::model::MetricDataResult)
pub mod metric_data_result {
    /// A builder for [`MetricDataResult`](crate::model::MetricDataResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) timestamps: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        pub(crate) values: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) status_code: std::option::Option<crate::model::StatusCode>,
        pub(crate) messages: std::option::Option<std::vec::Vec<crate::model::MessageData>>,
    }
    impl Builder {
        /// <p>The short name you specified to represent this metric.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The short name you specified to represent this metric.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The human-readable label associated with the data.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The human-readable label associated with the data.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// Appends an item to `timestamps`.
        ///
        /// To override the contents of this collection use [`set_timestamps`](Self::set_timestamps).
        ///
        /// <p>The timestamps for the data points, formatted in Unix timestamp format. The number of
        /// timestamps always matches the number of values and the value for Timestamps[x] is
        /// Values[x].</p>
        pub fn timestamps(mut self, input: impl Into<aws_smithy_types::Instant>) -> Self {
            let mut v = self.timestamps.unwrap_or_default();
            v.push(input.into());
            self.timestamps = Some(v);
            self
        }
        /// <p>The timestamps for the data points, formatted in Unix timestamp format. The number of
        /// timestamps always matches the number of values and the value for Timestamps[x] is
        /// Values[x].</p>
        pub fn set_timestamps(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::Instant>>,
        ) -> Self {
            self.timestamps = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The data points for the metric corresponding to <code>Timestamps</code>. The number of
        /// values always matches the number of timestamps and the timestamp for Values[x] is
        /// Timestamps[x].</p>
        pub fn values(mut self, input: impl Into<f64>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The data points for the metric corresponding to <code>Timestamps</code>. The number of
        /// values always matches the number of timestamps and the timestamp for Values[x] is
        /// Timestamps[x].</p>
        pub fn set_values(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.values = input;
            self
        }
        /// <p>The status of the returned data. <code>Complete</code> indicates that all data points in the requested time range were returned.
        /// <code>PartialData</code> means that an incomplete set of data points were returned.
        /// You can use the <code>NextToken</code> value that was returned and repeat your request to get more data points.
        /// <code>NextToken</code> is not returned if you are performing a math expression. <code>InternalError</code>  
        /// indicates that an error occurred. Retry your request using <code>NextToken</code>, if present.</p>
        pub fn status_code(mut self, input: crate::model::StatusCode) -> Self {
            self.status_code = Some(input);
            self
        }
        /// <p>The status of the returned data. <code>Complete</code> indicates that all data points in the requested time range were returned.
        /// <code>PartialData</code> means that an incomplete set of data points were returned.
        /// You can use the <code>NextToken</code> value that was returned and repeat your request to get more data points.
        /// <code>NextToken</code> is not returned if you are performing a math expression. <code>InternalError</code>  
        /// indicates that an error occurred. Retry your request using <code>NextToken</code>, if present.</p>
        pub fn set_status_code(
            mut self,
            input: std::option::Option<crate::model::StatusCode>,
        ) -> Self {
            self.status_code = input;
            self
        }
        /// Appends an item to `messages`.
        ///
        /// To override the contents of this collection use [`set_messages`](Self::set_messages).
        ///
        /// <p>A list of messages with additional information about the data returned.</p>
        pub fn messages(mut self, input: impl Into<crate::model::MessageData>) -> Self {
            let mut v = self.messages.unwrap_or_default();
            v.push(input.into());
            self.messages = Some(v);
            self
        }
        /// <p>A list of messages with additional information about the data returned.</p>
        pub fn set_messages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MessageData>>,
        ) -> Self {
            self.messages = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDataResult`](crate::model::MetricDataResult)
        pub fn build(self) -> crate::model::MetricDataResult {
            crate::model::MetricDataResult {
                id: self.id,
                label: self.label,
                timestamps: self.timestamps,
                values: self.values,
                status_code: self.status_code,
                messages: self.messages,
            }
        }
    }
}
impl MetricDataResult {
    /// Creates a new builder-style object to manufacture [`MetricDataResult`](crate::model::MetricDataResult)
    pub fn builder() -> crate::model::metric_data_result::Builder {
        crate::model::metric_data_result::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    #[allow(missing_docs)] // documentation missing in model
    PartialData,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusCode {
    fn from(s: &str) -> Self {
        match s {
            "Complete" => StatusCode::Complete,
            "InternalError" => StatusCode::InternalError,
            "PartialData" => StatusCode::PartialData,
            other => StatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusCode::from(s))
    }
}
impl StatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusCode::Complete => "Complete",
            StatusCode::InternalError => "InternalError",
            StatusCode::PartialData => "PartialData",
            StatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Complete", "InternalError", "PartialData"]
    }
}
impl AsRef<str> for StatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This structure includes the <code>Timezone</code> parameter, which you can use
/// to specify your time zone so that the labels that are associated with returned metrics display the
/// correct time
/// for your time zone. </p>
/// <p>The <code>Timezone</code> value affects a label only if you have a time-based
/// dynamic expression in the label. For more information about dynamic expressions in labels,
/// see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic Labels</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LabelOptions {
    /// <p>The time zone to use for metric data return in this operation.
    /// The format is <code>+</code> or <code>-</code> followed by four digits.
    /// The first two digits indicate the number of hours ahead or behind of UTC, and
    /// the final two digits are the number of minutes. For example, +0130 indicates a time zone that is 1 hour
    /// and 30 minutes ahead of UTC. The default is +0000. </p>
    pub timezone: std::option::Option<std::string::String>,
}
impl LabelOptions {
    /// <p>The time zone to use for metric data return in this operation.
    /// The format is <code>+</code> or <code>-</code> followed by four digits.
    /// The first two digits indicate the number of hours ahead or behind of UTC, and
    /// the final two digits are the number of minutes. For example, +0130 indicates a time zone that is 1 hour
    /// and 30 minutes ahead of UTC. The default is +0000. </p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
}
impl std::fmt::Debug for LabelOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LabelOptions");
        formatter.field("timezone", &self.timezone);
        formatter.finish()
    }
}
/// See [`LabelOptions`](crate::model::LabelOptions)
pub mod label_options {
    /// A builder for [`LabelOptions`](crate::model::LabelOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timezone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The time zone to use for metric data return in this operation.
        /// The format is <code>+</code> or <code>-</code> followed by four digits.
        /// The first two digits indicate the number of hours ahead or behind of UTC, and
        /// the final two digits are the number of minutes. For example, +0130 indicates a time zone that is 1 hour
        /// and 30 minutes ahead of UTC. The default is +0000. </p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone to use for metric data return in this operation.
        /// The format is <code>+</code> or <code>-</code> followed by four digits.
        /// The first two digits indicate the number of hours ahead or behind of UTC, and
        /// the final two digits are the number of minutes. For example, +0130 indicates a time zone that is 1 hour
        /// and 30 minutes ahead of UTC. The default is +0000. </p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// Consumes the builder and constructs a [`LabelOptions`](crate::model::LabelOptions)
        pub fn build(self) -> crate::model::LabelOptions {
            crate::model::LabelOptions {
                timezone: self.timezone,
            }
        }
    }
}
impl LabelOptions {
    /// Creates a new builder-style object to manufacture [`LabelOptions`](crate::model::LabelOptions)
    pub fn builder() -> crate::model::label_options::Builder {
        crate::model::label_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScanBy {
    #[allow(missing_docs)] // documentation missing in model
    TimestampAscending,
    #[allow(missing_docs)] // documentation missing in model
    TimestampDescending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScanBy {
    fn from(s: &str) -> Self {
        match s {
            "TimestampAscending" => ScanBy::TimestampAscending,
            "TimestampDescending" => ScanBy::TimestampDescending,
            other => ScanBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScanBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScanBy::from(s))
    }
}
impl ScanBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScanBy::TimestampAscending => "TimestampAscending",
            ScanBy::TimestampDescending => "TimestampDescending",
            ScanBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TimestampAscending", "TimestampDescending"]
    }
}
impl AsRef<str> for ScanBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>One data point from the metric time series returned in a Contributor Insights rule report.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html">GetInsightRuleReport</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightRuleMetricDatapoint {
    /// <p>The timestamp of the data point.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of unique contributors who published data during this timestamp.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub unique_contributors: std::option::Option<f64>,
    /// <p>The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately,
    /// so the identity of the max contributor
    /// could be different for each timestamp.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub max_contributor_value: std::option::Option<f64>,
    /// <p>The number of occurrences that matched the rule during this data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub sample_count: std::option::Option<f64>,
    /// <p>The average value from all contributors during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub average: std::option::Option<f64>,
    /// <p>The sum of the values from all contributors during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub sum: std::option::Option<f64>,
    /// <p>The minimum value from a single contributor during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub minimum: std::option::Option<f64>,
    /// <p>The maximum value from a single occurence from a single contributor during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub maximum: std::option::Option<f64>,
}
impl InsightRuleMetricDatapoint {
    /// <p>The timestamp of the data point.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The number of unique contributors who published data during this timestamp.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub fn unique_contributors(&self) -> std::option::Option<f64> {
        self.unique_contributors
    }
    /// <p>The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately,
    /// so the identity of the max contributor
    /// could be different for each timestamp.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub fn max_contributor_value(&self) -> std::option::Option<f64> {
        self.max_contributor_value
    }
    /// <p>The number of occurrences that matched the rule during this data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub fn sample_count(&self) -> std::option::Option<f64> {
        self.sample_count
    }
    /// <p>The average value from all contributors during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub fn average(&self) -> std::option::Option<f64> {
        self.average
    }
    /// <p>The sum of the values from all contributors during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub fn sum(&self) -> std::option::Option<f64> {
        self.sum
    }
    /// <p>The minimum value from a single contributor during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub fn minimum(&self) -> std::option::Option<f64> {
        self.minimum
    }
    /// <p>The maximum value from a single occurence from a single contributor during the time period represented by that data point.</p>
    /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
    pub fn maximum(&self) -> std::option::Option<f64> {
        self.maximum
    }
}
impl std::fmt::Debug for InsightRuleMetricDatapoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightRuleMetricDatapoint");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("unique_contributors", &self.unique_contributors);
        formatter.field("max_contributor_value", &self.max_contributor_value);
        formatter.field("sample_count", &self.sample_count);
        formatter.field("average", &self.average);
        formatter.field("sum", &self.sum);
        formatter.field("minimum", &self.minimum);
        formatter.field("maximum", &self.maximum);
        formatter.finish()
    }
}
/// See [`InsightRuleMetricDatapoint`](crate::model::InsightRuleMetricDatapoint)
pub mod insight_rule_metric_datapoint {
    /// A builder for [`InsightRuleMetricDatapoint`](crate::model::InsightRuleMetricDatapoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) unique_contributors: std::option::Option<f64>,
        pub(crate) max_contributor_value: std::option::Option<f64>,
        pub(crate) sample_count: std::option::Option<f64>,
        pub(crate) average: std::option::Option<f64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
        pub(crate) maximum: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The timestamp of the data point.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the data point.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The number of unique contributors who published data during this timestamp.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn unique_contributors(mut self, input: f64) -> Self {
            self.unique_contributors = Some(input);
            self
        }
        /// <p>The number of unique contributors who published data during this timestamp.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn set_unique_contributors(mut self, input: std::option::Option<f64>) -> Self {
            self.unique_contributors = input;
            self
        }
        /// <p>The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately,
        /// so the identity of the max contributor
        /// could be different for each timestamp.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn max_contributor_value(mut self, input: f64) -> Self {
            self.max_contributor_value = Some(input);
            self
        }
        /// <p>The maximum value provided by one contributor during this timestamp. Each timestamp is evaluated separately,
        /// so the identity of the max contributor
        /// could be different for each timestamp.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn set_max_contributor_value(mut self, input: std::option::Option<f64>) -> Self {
            self.max_contributor_value = input;
            self
        }
        /// <p>The number of occurrences that matched the rule during this data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn sample_count(mut self, input: f64) -> Self {
            self.sample_count = Some(input);
            self
        }
        /// <p>The number of occurrences that matched the rule during this data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn set_sample_count(mut self, input: std::option::Option<f64>) -> Self {
            self.sample_count = input;
            self
        }
        /// <p>The average value from all contributors during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn average(mut self, input: f64) -> Self {
            self.average = Some(input);
            self
        }
        /// <p>The average value from all contributors during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn set_average(mut self, input: std::option::Option<f64>) -> Self {
            self.average = input;
            self
        }
        /// <p>The sum of the values from all contributors during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The sum of the values from all contributors during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The minimum value from a single contributor during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>The minimum value from a single contributor during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>The maximum value from a single occurence from a single contributor during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum value from a single occurence from a single contributor during the time period represented by that data point.</p>
        /// <p>This statistic is returned only if you included it in the <code>Metrics</code> array in your request.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightRuleMetricDatapoint`](crate::model::InsightRuleMetricDatapoint)
        pub fn build(self) -> crate::model::InsightRuleMetricDatapoint {
            crate::model::InsightRuleMetricDatapoint {
                timestamp: self.timestamp,
                unique_contributors: self.unique_contributors,
                max_contributor_value: self.max_contributor_value,
                sample_count: self.sample_count,
                average: self.average,
                sum: self.sum,
                minimum: self.minimum,
                maximum: self.maximum,
            }
        }
    }
}
impl InsightRuleMetricDatapoint {
    /// Creates a new builder-style object to manufacture [`InsightRuleMetricDatapoint`](crate::model::InsightRuleMetricDatapoint)
    pub fn builder() -> crate::model::insight_rule_metric_datapoint::Builder {
        crate::model::insight_rule_metric_datapoint::Builder::default()
    }
}

/// <p>One of the unique contributors found by a Contributor Insights rule. If the rule contains multiple keys, then
/// a unique contributor is a unique combination of values from all the keys in the rule.</p>
/// <p>If the rule contains a single key, then each unique contributor is each unique value for this key.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html">GetInsightRuleReport</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightRuleContributor {
    /// <p>One of the log entry field keywords that is used to define contributors for this rule.</p>
    pub keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An approximation of the aggregate value that comes from this contributor.</p>
    pub approximate_aggregate_value: std::option::Option<f64>,
    /// <p>An array of the data points where this contributor is present. Only the data points when this contributor appeared are included in the array.</p>
    pub datapoints:
        std::option::Option<std::vec::Vec<crate::model::InsightRuleContributorDatapoint>>,
}
impl InsightRuleContributor {
    /// <p>One of the log entry field keywords that is used to define contributors for this rule.</p>
    pub fn keys(&self) -> std::option::Option<&[std::string::String]> {
        self.keys.as_deref()
    }
    /// <p>An approximation of the aggregate value that comes from this contributor.</p>
    pub fn approximate_aggregate_value(&self) -> std::option::Option<f64> {
        self.approximate_aggregate_value
    }
    /// <p>An array of the data points where this contributor is present. Only the data points when this contributor appeared are included in the array.</p>
    pub fn datapoints(
        &self,
    ) -> std::option::Option<&[crate::model::InsightRuleContributorDatapoint]> {
        self.datapoints.as_deref()
    }
}
impl std::fmt::Debug for InsightRuleContributor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightRuleContributor");
        formatter.field("keys", &self.keys);
        formatter.field(
            "approximate_aggregate_value",
            &self.approximate_aggregate_value,
        );
        formatter.field("datapoints", &self.datapoints);
        formatter.finish()
    }
}
/// See [`InsightRuleContributor`](crate::model::InsightRuleContributor)
pub mod insight_rule_contributor {
    /// A builder for [`InsightRuleContributor`](crate::model::InsightRuleContributor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) approximate_aggregate_value: std::option::Option<f64>,
        pub(crate) datapoints:
            std::option::Option<std::vec::Vec<crate::model::InsightRuleContributorDatapoint>>,
    }
    impl Builder {
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>One of the log entry field keywords that is used to define contributors for this rule.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>One of the log entry field keywords that is used to define contributors for this rule.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>An approximation of the aggregate value that comes from this contributor.</p>
        pub fn approximate_aggregate_value(mut self, input: f64) -> Self {
            self.approximate_aggregate_value = Some(input);
            self
        }
        /// <p>An approximation of the aggregate value that comes from this contributor.</p>
        pub fn set_approximate_aggregate_value(mut self, input: std::option::Option<f64>) -> Self {
            self.approximate_aggregate_value = input;
            self
        }
        /// Appends an item to `datapoints`.
        ///
        /// To override the contents of this collection use [`set_datapoints`](Self::set_datapoints).
        ///
        /// <p>An array of the data points where this contributor is present. Only the data points when this contributor appeared are included in the array.</p>
        pub fn datapoints(
            mut self,
            input: impl Into<crate::model::InsightRuleContributorDatapoint>,
        ) -> Self {
            let mut v = self.datapoints.unwrap_or_default();
            v.push(input.into());
            self.datapoints = Some(v);
            self
        }
        /// <p>An array of the data points where this contributor is present. Only the data points when this contributor appeared are included in the array.</p>
        pub fn set_datapoints(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::InsightRuleContributorDatapoint>,
            >,
        ) -> Self {
            self.datapoints = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightRuleContributor`](crate::model::InsightRuleContributor)
        pub fn build(self) -> crate::model::InsightRuleContributor {
            crate::model::InsightRuleContributor {
                keys: self.keys,
                approximate_aggregate_value: self.approximate_aggregate_value,
                datapoints: self.datapoints,
            }
        }
    }
}
impl InsightRuleContributor {
    /// Creates a new builder-style object to manufacture [`InsightRuleContributor`](crate::model::InsightRuleContributor)
    pub fn builder() -> crate::model::insight_rule_contributor::Builder {
        crate::model::insight_rule_contributor::Builder::default()
    }
}

/// <p>One data point related to one contributor.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetInsightRuleReport.html">GetInsightRuleReport</a> and
/// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_InsightRuleContributor.html">InsightRuleContributor</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightRuleContributorDatapoint {
    /// <p>The timestamp of the data point.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The approximate value that this contributor added during this timestamp.</p>
    pub approximate_value: std::option::Option<f64>,
}
impl InsightRuleContributorDatapoint {
    /// <p>The timestamp of the data point.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The approximate value that this contributor added during this timestamp.</p>
    pub fn approximate_value(&self) -> std::option::Option<f64> {
        self.approximate_value
    }
}
impl std::fmt::Debug for InsightRuleContributorDatapoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightRuleContributorDatapoint");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("approximate_value", &self.approximate_value);
        formatter.finish()
    }
}
/// See [`InsightRuleContributorDatapoint`](crate::model::InsightRuleContributorDatapoint)
pub mod insight_rule_contributor_datapoint {
    /// A builder for [`InsightRuleContributorDatapoint`](crate::model::InsightRuleContributorDatapoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) approximate_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The timestamp of the data point.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp of the data point.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The approximate value that this contributor added during this timestamp.</p>
        pub fn approximate_value(mut self, input: f64) -> Self {
            self.approximate_value = Some(input);
            self
        }
        /// <p>The approximate value that this contributor added during this timestamp.</p>
        pub fn set_approximate_value(mut self, input: std::option::Option<f64>) -> Self {
            self.approximate_value = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightRuleContributorDatapoint`](crate::model::InsightRuleContributorDatapoint)
        pub fn build(self) -> crate::model::InsightRuleContributorDatapoint {
            crate::model::InsightRuleContributorDatapoint {
                timestamp: self.timestamp,
                approximate_value: self.approximate_value,
            }
        }
    }
}
impl InsightRuleContributorDatapoint {
    /// Creates a new builder-style object to manufacture [`InsightRuleContributorDatapoint`](crate::model::InsightRuleContributorDatapoint)
    pub fn builder() -> crate::model::insight_rule_contributor_datapoint::Builder {
        crate::model::insight_rule_contributor_datapoint::Builder::default()
    }
}

/// <p>This array is empty if the API operation was successful for all the rules specified in the request. If the operation could
/// not process one of the rules, the following data is returned for each of those rules.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartialFailure {
    /// <p>The specified rule that could not be deleted.</p>
    pub failure_resource: std::option::Option<std::string::String>,
    /// <p>The type of error.</p>
    pub exception_type: std::option::Option<std::string::String>,
    /// <p>The code of the error.</p>
    pub failure_code: std::option::Option<std::string::String>,
    /// <p>A description of the error.</p>
    pub failure_description: std::option::Option<std::string::String>,
}
impl PartialFailure {
    /// <p>The specified rule that could not be deleted.</p>
    pub fn failure_resource(&self) -> std::option::Option<&str> {
        self.failure_resource.as_deref()
    }
    /// <p>The type of error.</p>
    pub fn exception_type(&self) -> std::option::Option<&str> {
        self.exception_type.as_deref()
    }
    /// <p>The code of the error.</p>
    pub fn failure_code(&self) -> std::option::Option<&str> {
        self.failure_code.as_deref()
    }
    /// <p>A description of the error.</p>
    pub fn failure_description(&self) -> std::option::Option<&str> {
        self.failure_description.as_deref()
    }
}
impl std::fmt::Debug for PartialFailure {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartialFailure");
        formatter.field("failure_resource", &self.failure_resource);
        formatter.field("exception_type", &self.exception_type);
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_description", &self.failure_description);
        formatter.finish()
    }
}
/// See [`PartialFailure`](crate::model::PartialFailure)
pub mod partial_failure {
    /// A builder for [`PartialFailure`](crate::model::PartialFailure)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failure_resource: std::option::Option<std::string::String>,
        pub(crate) exception_type: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<std::string::String>,
        pub(crate) failure_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The specified rule that could not be deleted.</p>
        pub fn failure_resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_resource = Some(input.into());
            self
        }
        /// <p>The specified rule that could not be deleted.</p>
        pub fn set_failure_resource(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_resource = input;
            self
        }
        /// <p>The type of error.</p>
        pub fn exception_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.exception_type = Some(input.into());
            self
        }
        /// <p>The type of error.</p>
        pub fn set_exception_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exception_type = input;
            self
        }
        /// <p>The code of the error.</p>
        pub fn failure_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_code = Some(input.into());
            self
        }
        /// <p>The code of the error.</p>
        pub fn set_failure_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>A description of the error.</p>
        pub fn failure_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_description = Some(input.into());
            self
        }
        /// <p>A description of the error.</p>
        pub fn set_failure_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_description = input;
            self
        }
        /// Consumes the builder and constructs a [`PartialFailure`](crate::model::PartialFailure)
        pub fn build(self) -> crate::model::PartialFailure {
            crate::model::PartialFailure {
                failure_resource: self.failure_resource,
                exception_type: self.exception_type,
                failure_code: self.failure_code,
                failure_description: self.failure_description,
            }
        }
    }
}
impl PartialFailure {
    /// Creates a new builder-style object to manufacture [`PartialFailure`](crate::model::PartialFailure)
    pub fn builder() -> crate::model::partial_failure::Builder {
        crate::model::partial_failure::Builder::default()
    }
}

/// <p>This structure contains the definition for a Contributor Insights rule.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsightRule {
    /// <p>The name of the rule.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Indicates whether the rule is enabled or disabled.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For built-in rules,
    /// this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
    /// </p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors,
    /// the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the valid syntax, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html">Contributor Insights
    /// Rule Syntax</a>.</p>
    pub definition: std::option::Option<std::string::String>,
}
impl InsightRule {
    /// <p>The name of the rule.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Indicates whether the rule is enabled or disabled.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For built-in rules,
    /// this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
    /// </p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors,
    /// the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the valid syntax, see
    /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html">Contributor Insights
    /// Rule Syntax</a>.</p>
    pub fn definition(&self) -> std::option::Option<&str> {
        self.definition.as_deref()
    }
}
impl std::fmt::Debug for InsightRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsightRule");
        formatter.field("name", &self.name);
        formatter.field("state", &self.state);
        formatter.field("schema", &self.schema);
        formatter.field("definition", &self.definition);
        formatter.finish()
    }
}
/// See [`InsightRule`](crate::model::InsightRule)
pub mod insight_rule {
    /// A builder for [`InsightRule`](crate::model::InsightRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) definition: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the rule.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the rule.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>Indicates whether the rule is enabled or disabled.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For built-in rules,
        /// this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
        /// </p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>For rules that you create, this is always <code>{"Name": "CloudWatchLogRule", "Version": 1}</code>. For built-in rules,
        /// this is <code>{"Name": "ServiceLogRule", "Version": 1}</code>
        /// </p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// <p>The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors,
        /// the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the valid syntax, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html">Contributor Insights
        /// Rule Syntax</a>.</p>
        pub fn definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.definition = Some(input.into());
            self
        }
        /// <p>The definition of the rule, as a JSON object. The definition contains the keywords used to define contributors,
        /// the value to aggregate on if this rule returns a sum instead of a count, and the filters. For details on the valid syntax, see
        /// <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/ContributorInsights-RuleSyntax.html">Contributor Insights
        /// Rule Syntax</a>.</p>
        pub fn set_definition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.definition = input;
            self
        }
        /// Consumes the builder and constructs a [`InsightRule`](crate::model::InsightRule)
        pub fn build(self) -> crate::model::InsightRule {
            crate::model::InsightRule {
                name: self.name,
                state: self.state,
                schema: self.schema,
                definition: self.definition,
            }
        }
    }
}
impl InsightRule {
    /// Creates a new builder-style object to manufacture [`InsightRule`](crate::model::InsightRule)
    pub fn builder() -> crate::model::insight_rule::Builder {
        crate::model::insight_rule::Builder::default()
    }
}

/// <p>An anomaly detection model associated with a particular CloudWatch metric and statistic. You
/// can use the model to display a band of expected normal values when the metric is
/// graphed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyDetector {
    /// <p>The namespace of the metric associated with the anomaly detection model.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The name of the metric associated with the anomaly detection model.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The metric dimensions associated with the anomaly detection model.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
    /// <p>The statistic associated with the anomaly detection model.</p>
    pub stat: std::option::Option<std::string::String>,
    /// <p>The configuration specifies details about how the
    /// anomaly detection model is to be trained, including time ranges to
    /// exclude from use for training the model, and the time zone to use for
    /// the metric.</p>
    pub configuration: std::option::Option<crate::model::AnomalyDetectorConfiguration>,
    /// <p>The current status of the anomaly detector's training. The possible values are <code>TRAINED | PENDING_TRAINING | TRAINED_INSUFFICIENT_DATA</code>
    /// </p>
    pub state_value: std::option::Option<crate::model::AnomalyDetectorStateValue>,
}
impl AnomalyDetector {
    /// <p>The namespace of the metric associated with the anomaly detection model.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The name of the metric associated with the anomaly detection model.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The metric dimensions associated with the anomaly detection model.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::Dimension]> {
        self.dimensions.as_deref()
    }
    /// <p>The statistic associated with the anomaly detection model.</p>
    pub fn stat(&self) -> std::option::Option<&str> {
        self.stat.as_deref()
    }
    /// <p>The configuration specifies details about how the
    /// anomaly detection model is to be trained, including time ranges to
    /// exclude from use for training the model, and the time zone to use for
    /// the metric.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyDetectorConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The current status of the anomaly detector's training. The possible values are <code>TRAINED | PENDING_TRAINING | TRAINED_INSUFFICIENT_DATA</code>
    /// </p>
    pub fn state_value(&self) -> std::option::Option<&crate::model::AnomalyDetectorStateValue> {
        self.state_value.as_ref()
    }
}
impl std::fmt::Debug for AnomalyDetector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyDetector");
        formatter.field("namespace", &self.namespace);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("stat", &self.stat);
        formatter.field("configuration", &self.configuration);
        formatter.field("state_value", &self.state_value);
        formatter.finish()
    }
}
/// See [`AnomalyDetector`](crate::model::AnomalyDetector)
pub mod anomaly_detector {
    /// A builder for [`AnomalyDetector`](crate::model::AnomalyDetector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        pub(crate) stat: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::AnomalyDetectorConfiguration>,
        pub(crate) state_value: std::option::Option<crate::model::AnomalyDetectorStateValue>,
    }
    impl Builder {
        /// <p>The namespace of the metric associated with the anomaly detection model.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric associated with the anomaly detection model.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The name of the metric associated with the anomaly detection model.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric associated with the anomaly detection model.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The metric dimensions associated with the anomaly detection model.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::Dimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>The metric dimensions associated with the anomaly detection model.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The statistic associated with the anomaly detection model.</p>
        pub fn stat(mut self, input: impl Into<std::string::String>) -> Self {
            self.stat = Some(input.into());
            self
        }
        /// <p>The statistic associated with the anomaly detection model.</p>
        pub fn set_stat(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stat = input;
            self
        }
        /// <p>The configuration specifies details about how the
        /// anomaly detection model is to be trained, including time ranges to
        /// exclude from use for training the model, and the time zone to use for
        /// the metric.</p>
        pub fn configuration(mut self, input: crate::model::AnomalyDetectorConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration specifies details about how the
        /// anomaly detection model is to be trained, including time ranges to
        /// exclude from use for training the model, and the time zone to use for
        /// the metric.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The current status of the anomaly detector's training. The possible values are <code>TRAINED | PENDING_TRAINING | TRAINED_INSUFFICIENT_DATA</code>
        /// </p>
        pub fn state_value(mut self, input: crate::model::AnomalyDetectorStateValue) -> Self {
            self.state_value = Some(input);
            self
        }
        /// <p>The current status of the anomaly detector's training. The possible values are <code>TRAINED | PENDING_TRAINING | TRAINED_INSUFFICIENT_DATA</code>
        /// </p>
        pub fn set_state_value(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorStateValue>,
        ) -> Self {
            self.state_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyDetector`](crate::model::AnomalyDetector)
        pub fn build(self) -> crate::model::AnomalyDetector {
            crate::model::AnomalyDetector {
                namespace: self.namespace,
                metric_name: self.metric_name,
                dimensions: self.dimensions,
                stat: self.stat,
                configuration: self.configuration,
                state_value: self.state_value,
            }
        }
    }
}
impl AnomalyDetector {
    /// Creates a new builder-style object to manufacture [`AnomalyDetector`](crate::model::AnomalyDetector)
    pub fn builder() -> crate::model::anomaly_detector::Builder {
        crate::model::anomaly_detector::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalyDetectorStateValue {
    #[allow(missing_docs)] // documentation missing in model
    PendingTraining,
    #[allow(missing_docs)] // documentation missing in model
    Trained,
    #[allow(missing_docs)] // documentation missing in model
    TrainedInsufficientData,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalyDetectorStateValue {
    fn from(s: &str) -> Self {
        match s {
            "PENDING_TRAINING" => AnomalyDetectorStateValue::PendingTraining,
            "TRAINED" => AnomalyDetectorStateValue::Trained,
            "TRAINED_INSUFFICIENT_DATA" => AnomalyDetectorStateValue::TrainedInsufficientData,
            other => AnomalyDetectorStateValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalyDetectorStateValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalyDetectorStateValue::from(s))
    }
}
impl AnomalyDetectorStateValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalyDetectorStateValue::PendingTraining => "PENDING_TRAINING",
            AnomalyDetectorStateValue::Trained => "TRAINED",
            AnomalyDetectorStateValue::TrainedInsufficientData => "TRAINED_INSUFFICIENT_DATA",
            AnomalyDetectorStateValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PENDING_TRAINING", "TRAINED", "TRAINED_INSUFFICIENT_DATA"]
    }
}
impl AsRef<str> for AnomalyDetectorStateValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details about a metric alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricAlarm {
    /// <p>The name of the alarm.</p>
    pub alarm_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub alarm_arn: std::option::Option<std::string::String>,
    /// <p>The description of the alarm.</p>
    pub alarm_description: std::option::Option<std::string::String>,
    /// <p>The time stamp of the last update to the alarm configuration.</p>
    pub alarm_configuration_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
    pub actions_enabled: std::option::Option<bool>,
    /// <p>The actions to execute when this alarm transitions to the <code>OK</code> state
    /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub ok_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The actions to execute when this alarm transitions to the <code>ALARM</code> state
    /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub alarm_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state
    /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub insufficient_data_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The state value for the alarm.</p>
    pub state_value: std::option::Option<crate::model::StateValue>,
    /// <p>An explanation for the alarm state, in text format.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>An explanation for the alarm state, in JSON format.</p>
    pub state_reason_data: std::option::Option<std::string::String>,
    /// <p>The time stamp of the last update to the alarm state.</p>
    pub state_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the metric associated with the alarm, if this is an alarm
    /// based on a single metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The namespace of the metric associated with the alarm.</p>
    pub namespace: std::option::Option<std::string::String>,
    /// <p>The statistic for the metric associated with the alarm, other than percentile.
    /// For percentile statistics, use <code>ExtendedStatistic</code>.</p>
    pub statistic: std::option::Option<crate::model::Statistic>,
    /// <p>The percentile statistic for the metric associated with the alarm. Specify a value between
    /// p0.0 and p100.</p>
    pub extended_statistic: std::option::Option<std::string::String>,
    /// <p>The dimensions for the metric associated with the alarm.</p>
    pub dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
    /// <p>The period, in seconds, over which the statistic is applied.</p>
    pub period: std::option::Option<i32>,
    /// <p>The unit of the metric associated with the alarm.</p>
    pub unit: std::option::Option<crate::model::StandardUnit>,
    /// <p>The number of periods over which data is compared to the specified threshold.</p>
    pub evaluation_periods: std::option::Option<i32>,
    /// <p>The number of data points that must be breaching to trigger the alarm.</p>
    pub datapoints_to_alarm: std::option::Option<i32>,
    /// <p>The value to compare with the specified statistic.</p>
    pub threshold: std::option::Option<f64>,
    /// <p>The arithmetic operation to use when comparing the specified
    /// statistic and threshold. The specified statistic value is used as the first operand.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of <code>missing</code> is used.</p>
    pub treat_missing_data: std::option::Option<std::string::String>,
    /// <p>Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change
    /// during periods with too few data points to be statistically significant. If <code>evaluate</code> or this
    /// parameter is not used, the alarm is always evaluated and possibly changes state no matter
    /// how many data points are available.</p>
    pub evaluate_low_sample_count_percentile: std::option::Option<std::string::String>,
    /// <p>An array of MetricDataQuery structures, used in an alarm based on a
    /// metric math expression. Each structure either retrieves a
    /// metric or performs a math expression.
    ///
    /// One item in the Metrics array is the math expression that the alarm watches.
    /// This expression by designated by having <code>ReturnData</code> set to
    /// true.</p>
    pub metrics: std::option::Option<std::vec::Vec<crate::model::MetricDataQuery>>,
    /// <p>In an alarm based on an anomaly detection model, this is the ID of the
    /// <code>ANOMALY_DETECTION_BAND</code> function
    /// used as the threshold for the alarm.</p>
    pub threshold_metric_id: std::option::Option<std::string::String>,
}
impl MetricAlarm {
    /// <p>The name of the alarm.</p>
    pub fn alarm_name(&self) -> std::option::Option<&str> {
        self.alarm_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub fn alarm_arn(&self) -> std::option::Option<&str> {
        self.alarm_arn.as_deref()
    }
    /// <p>The description of the alarm.</p>
    pub fn alarm_description(&self) -> std::option::Option<&str> {
        self.alarm_description.as_deref()
    }
    /// <p>The time stamp of the last update to the alarm configuration.</p>
    pub fn alarm_configuration_updated_timestamp(
        &self,
    ) -> std::option::Option<&aws_smithy_types::Instant> {
        self.alarm_configuration_updated_timestamp.as_ref()
    }
    /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
    pub fn actions_enabled(&self) -> std::option::Option<bool> {
        self.actions_enabled
    }
    /// <p>The actions to execute when this alarm transitions to the <code>OK</code> state
    /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub fn ok_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.ok_actions.as_deref()
    }
    /// <p>The actions to execute when this alarm transitions to the <code>ALARM</code> state
    /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub fn alarm_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.alarm_actions.as_deref()
    }
    /// <p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state
    /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub fn insufficient_data_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.insufficient_data_actions.as_deref()
    }
    /// <p>The state value for the alarm.</p>
    pub fn state_value(&self) -> std::option::Option<&crate::model::StateValue> {
        self.state_value.as_ref()
    }
    /// <p>An explanation for the alarm state, in text format.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>An explanation for the alarm state, in JSON format.</p>
    pub fn state_reason_data(&self) -> std::option::Option<&str> {
        self.state_reason_data.as_deref()
    }
    /// <p>The time stamp of the last update to the alarm state.</p>
    pub fn state_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.state_updated_timestamp.as_ref()
    }
    /// <p>The name of the metric associated with the alarm, if this is an alarm
    /// based on a single metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The namespace of the metric associated with the alarm.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
    /// <p>The statistic for the metric associated with the alarm, other than percentile.
    /// For percentile statistics, use <code>ExtendedStatistic</code>.</p>
    pub fn statistic(&self) -> std::option::Option<&crate::model::Statistic> {
        self.statistic.as_ref()
    }
    /// <p>The percentile statistic for the metric associated with the alarm. Specify a value between
    /// p0.0 and p100.</p>
    pub fn extended_statistic(&self) -> std::option::Option<&str> {
        self.extended_statistic.as_deref()
    }
    /// <p>The dimensions for the metric associated with the alarm.</p>
    pub fn dimensions(&self) -> std::option::Option<&[crate::model::Dimension]> {
        self.dimensions.as_deref()
    }
    /// <p>The period, in seconds, over which the statistic is applied.</p>
    pub fn period(&self) -> std::option::Option<i32> {
        self.period
    }
    /// <p>The unit of the metric associated with the alarm.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::StandardUnit> {
        self.unit.as_ref()
    }
    /// <p>The number of periods over which data is compared to the specified threshold.</p>
    pub fn evaluation_periods(&self) -> std::option::Option<i32> {
        self.evaluation_periods
    }
    /// <p>The number of data points that must be breaching to trigger the alarm.</p>
    pub fn datapoints_to_alarm(&self) -> std::option::Option<i32> {
        self.datapoints_to_alarm
    }
    /// <p>The value to compare with the specified statistic.</p>
    pub fn threshold(&self) -> std::option::Option<f64> {
        self.threshold
    }
    /// <p>The arithmetic operation to use when comparing the specified
    /// statistic and threshold. The specified statistic value is used as the first operand.</p>
    pub fn comparison_operator(&self) -> std::option::Option<&crate::model::ComparisonOperator> {
        self.comparison_operator.as_ref()
    }
    /// <p>Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of <code>missing</code> is used.</p>
    pub fn treat_missing_data(&self) -> std::option::Option<&str> {
        self.treat_missing_data.as_deref()
    }
    /// <p>Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change
    /// during periods with too few data points to be statistically significant. If <code>evaluate</code> or this
    /// parameter is not used, the alarm is always evaluated and possibly changes state no matter
    /// how many data points are available.</p>
    pub fn evaluate_low_sample_count_percentile(&self) -> std::option::Option<&str> {
        self.evaluate_low_sample_count_percentile.as_deref()
    }
    /// <p>An array of MetricDataQuery structures, used in an alarm based on a
    /// metric math expression. Each structure either retrieves a
    /// metric or performs a math expression.
    ///
    /// One item in the Metrics array is the math expression that the alarm watches.
    /// This expression by designated by having <code>ReturnData</code> set to
    /// true.</p>
    pub fn metrics(&self) -> std::option::Option<&[crate::model::MetricDataQuery]> {
        self.metrics.as_deref()
    }
    /// <p>In an alarm based on an anomaly detection model, this is the ID of the
    /// <code>ANOMALY_DETECTION_BAND</code> function
    /// used as the threshold for the alarm.</p>
    pub fn threshold_metric_id(&self) -> std::option::Option<&str> {
        self.threshold_metric_id.as_deref()
    }
}
impl std::fmt::Debug for MetricAlarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricAlarm");
        formatter.field("alarm_name", &self.alarm_name);
        formatter.field("alarm_arn", &self.alarm_arn);
        formatter.field("alarm_description", &self.alarm_description);
        formatter.field(
            "alarm_configuration_updated_timestamp",
            &self.alarm_configuration_updated_timestamp,
        );
        formatter.field("actions_enabled", &self.actions_enabled);
        formatter.field("ok_actions", &self.ok_actions);
        formatter.field("alarm_actions", &self.alarm_actions);
        formatter.field("insufficient_data_actions", &self.insufficient_data_actions);
        formatter.field("state_value", &self.state_value);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_data", &self.state_reason_data);
        formatter.field("state_updated_timestamp", &self.state_updated_timestamp);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("namespace", &self.namespace);
        formatter.field("statistic", &self.statistic);
        formatter.field("extended_statistic", &self.extended_statistic);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("period", &self.period);
        formatter.field("unit", &self.unit);
        formatter.field("evaluation_periods", &self.evaluation_periods);
        formatter.field("datapoints_to_alarm", &self.datapoints_to_alarm);
        formatter.field("threshold", &self.threshold);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("treat_missing_data", &self.treat_missing_data);
        formatter.field(
            "evaluate_low_sample_count_percentile",
            &self.evaluate_low_sample_count_percentile,
        );
        formatter.field("metrics", &self.metrics);
        formatter.field("threshold_metric_id", &self.threshold_metric_id);
        formatter.finish()
    }
}
/// See [`MetricAlarm`](crate::model::MetricAlarm)
pub mod metric_alarm {
    /// A builder for [`MetricAlarm`](crate::model::MetricAlarm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_name: std::option::Option<std::string::String>,
        pub(crate) alarm_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_description: std::option::Option<std::string::String>,
        pub(crate) alarm_configuration_updated_timestamp:
            std::option::Option<aws_smithy_types::Instant>,
        pub(crate) actions_enabled: std::option::Option<bool>,
        pub(crate) ok_actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) alarm_actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) insufficient_data_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state_value: std::option::Option<crate::model::StateValue>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_data: std::option::Option<std::string::String>,
        pub(crate) state_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) namespace: std::option::Option<std::string::String>,
        pub(crate) statistic: std::option::Option<crate::model::Statistic>,
        pub(crate) extended_statistic: std::option::Option<std::string::String>,
        pub(crate) dimensions: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) unit: std::option::Option<crate::model::StandardUnit>,
        pub(crate) evaluation_periods: std::option::Option<i32>,
        pub(crate) datapoints_to_alarm: std::option::Option<i32>,
        pub(crate) threshold: std::option::Option<f64>,
        pub(crate) comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
        pub(crate) treat_missing_data: std::option::Option<std::string::String>,
        pub(crate) evaluate_low_sample_count_percentile: std::option::Option<std::string::String>,
        pub(crate) metrics: std::option::Option<std::vec::Vec<crate::model::MetricDataQuery>>,
        pub(crate) threshold_metric_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn alarm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn set_alarm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_arn = input;
            self
        }
        /// <p>The description of the alarm.</p>
        pub fn alarm_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_description = Some(input.into());
            self
        }
        /// <p>The description of the alarm.</p>
        pub fn set_alarm_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_description = input;
            self
        }
        /// <p>The time stamp of the last update to the alarm configuration.</p>
        pub fn alarm_configuration_updated_timestamp(
            mut self,
            input: aws_smithy_types::Instant,
        ) -> Self {
            self.alarm_configuration_updated_timestamp = Some(input);
            self
        }
        /// <p>The time stamp of the last update to the alarm configuration.</p>
        pub fn set_alarm_configuration_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.alarm_configuration_updated_timestamp = input;
            self
        }
        /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
        pub fn actions_enabled(mut self, input: bool) -> Self {
            self.actions_enabled = Some(input);
            self
        }
        /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
        pub fn set_actions_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.actions_enabled = input;
            self
        }
        /// Appends an item to `ok_actions`.
        ///
        /// To override the contents of this collection use [`set_ok_actions`](Self::set_ok_actions).
        ///
        /// <p>The actions to execute when this alarm transitions to the <code>OK</code> state
        /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn ok_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ok_actions.unwrap_or_default();
            v.push(input.into());
            self.ok_actions = Some(v);
            self
        }
        /// <p>The actions to execute when this alarm transitions to the <code>OK</code> state
        /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn set_ok_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ok_actions = input;
            self
        }
        /// Appends an item to `alarm_actions`.
        ///
        /// To override the contents of this collection use [`set_alarm_actions`](Self::set_alarm_actions).
        ///
        /// <p>The actions to execute when this alarm transitions to the <code>ALARM</code> state
        /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn alarm_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.alarm_actions.unwrap_or_default();
            v.push(input.into());
            self.alarm_actions = Some(v);
            self
        }
        /// <p>The actions to execute when this alarm transitions to the <code>ALARM</code> state
        /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn set_alarm_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.alarm_actions = input;
            self
        }
        /// Appends an item to `insufficient_data_actions`.
        ///
        /// To override the contents of this collection use [`set_insufficient_data_actions`](Self::set_insufficient_data_actions).
        ///
        /// <p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state
        /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn insufficient_data_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.insufficient_data_actions.unwrap_or_default();
            v.push(input.into());
            self.insufficient_data_actions = Some(v);
            self
        }
        /// <p>The actions to execute when this alarm transitions to the <code>INSUFFICIENT_DATA</code> state
        /// from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn set_insufficient_data_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.insufficient_data_actions = input;
            self
        }
        /// <p>The state value for the alarm.</p>
        pub fn state_value(mut self, input: crate::model::StateValue) -> Self {
            self.state_value = Some(input);
            self
        }
        /// <p>The state value for the alarm.</p>
        pub fn set_state_value(
            mut self,
            input: std::option::Option<crate::model::StateValue>,
        ) -> Self {
            self.state_value = input;
            self
        }
        /// <p>An explanation for the alarm state, in text format.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>An explanation for the alarm state, in text format.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>An explanation for the alarm state, in JSON format.</p>
        pub fn state_reason_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason_data = Some(input.into());
            self
        }
        /// <p>An explanation for the alarm state, in JSON format.</p>
        pub fn set_state_reason_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_reason_data = input;
            self
        }
        /// <p>The time stamp of the last update to the alarm state.</p>
        pub fn state_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.state_updated_timestamp = Some(input);
            self
        }
        /// <p>The time stamp of the last update to the alarm state.</p>
        pub fn set_state_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.state_updated_timestamp = input;
            self
        }
        /// <p>The name of the metric associated with the alarm, if this is an alarm
        /// based on a single metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric associated with the alarm, if this is an alarm
        /// based on a single metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The namespace of the metric associated with the alarm.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace of the metric associated with the alarm.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// <p>The statistic for the metric associated with the alarm, other than percentile.
        /// For percentile statistics, use <code>ExtendedStatistic</code>.</p>
        pub fn statistic(mut self, input: crate::model::Statistic) -> Self {
            self.statistic = Some(input);
            self
        }
        /// <p>The statistic for the metric associated with the alarm, other than percentile.
        /// For percentile statistics, use <code>ExtendedStatistic</code>.</p>
        pub fn set_statistic(
            mut self,
            input: std::option::Option<crate::model::Statistic>,
        ) -> Self {
            self.statistic = input;
            self
        }
        /// <p>The percentile statistic for the metric associated with the alarm. Specify a value between
        /// p0.0 and p100.</p>
        pub fn extended_statistic(mut self, input: impl Into<std::string::String>) -> Self {
            self.extended_statistic = Some(input.into());
            self
        }
        /// <p>The percentile statistic for the metric associated with the alarm. Specify a value between
        /// p0.0 and p100.</p>
        pub fn set_extended_statistic(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extended_statistic = input;
            self
        }
        /// Appends an item to `dimensions`.
        ///
        /// To override the contents of this collection use [`set_dimensions`](Self::set_dimensions).
        ///
        /// <p>The dimensions for the metric associated with the alarm.</p>
        pub fn dimensions(mut self, input: impl Into<crate::model::Dimension>) -> Self {
            let mut v = self.dimensions.unwrap_or_default();
            v.push(input.into());
            self.dimensions = Some(v);
            self
        }
        /// <p>The dimensions for the metric associated with the alarm.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Dimension>>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The period, in seconds, over which the statistic is applied.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The period, in seconds, over which the statistic is applied.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The unit of the metric associated with the alarm.</p>
        pub fn unit(mut self, input: crate::model::StandardUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit of the metric associated with the alarm.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::StandardUnit>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The number of periods over which data is compared to the specified threshold.</p>
        pub fn evaluation_periods(mut self, input: i32) -> Self {
            self.evaluation_periods = Some(input);
            self
        }
        /// <p>The number of periods over which data is compared to the specified threshold.</p>
        pub fn set_evaluation_periods(mut self, input: std::option::Option<i32>) -> Self {
            self.evaluation_periods = input;
            self
        }
        /// <p>The number of data points that must be breaching to trigger the alarm.</p>
        pub fn datapoints_to_alarm(mut self, input: i32) -> Self {
            self.datapoints_to_alarm = Some(input);
            self
        }
        /// <p>The number of data points that must be breaching to trigger the alarm.</p>
        pub fn set_datapoints_to_alarm(mut self, input: std::option::Option<i32>) -> Self {
            self.datapoints_to_alarm = input;
            self
        }
        /// <p>The value to compare with the specified statistic.</p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The value to compare with the specified statistic.</p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>The arithmetic operation to use when comparing the specified
        /// statistic and threshold. The specified statistic value is used as the first operand.</p>
        pub fn comparison_operator(mut self, input: crate::model::ComparisonOperator) -> Self {
            self.comparison_operator = Some(input);
            self
        }
        /// <p>The arithmetic operation to use when comparing the specified
        /// statistic and threshold. The specified statistic value is used as the first operand.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.comparison_operator = input;
            self
        }
        /// <p>Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of <code>missing</code> is used.</p>
        pub fn treat_missing_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.treat_missing_data = Some(input.into());
            self
        }
        /// <p>Sets how this alarm is to handle missing data points. If this parameter is omitted, the default behavior of <code>missing</code> is used.</p>
        pub fn set_treat_missing_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.treat_missing_data = input;
            self
        }
        /// <p>Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change
        /// during periods with too few data points to be statistically significant. If <code>evaluate</code> or this
        /// parameter is not used, the alarm is always evaluated and possibly changes state no matter
        /// how many data points are available.</p>
        pub fn evaluate_low_sample_count_percentile(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.evaluate_low_sample_count_percentile = Some(input.into());
            self
        }
        /// <p>Used only for alarms based on percentiles. If <code>ignore</code>, the alarm state does not change
        /// during periods with too few data points to be statistically significant. If <code>evaluate</code> or this
        /// parameter is not used, the alarm is always evaluated and possibly changes state no matter
        /// how many data points are available.</p>
        pub fn set_evaluate_low_sample_count_percentile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluate_low_sample_count_percentile = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>An array of MetricDataQuery structures, used in an alarm based on a
        /// metric math expression. Each structure either retrieves a
        /// metric or performs a math expression.
        ///
        /// One item in the Metrics array is the math expression that the alarm watches.
        /// This expression by designated by having <code>ReturnData</code> set to
        /// true.</p>
        pub fn metrics(mut self, input: impl Into<crate::model::MetricDataQuery>) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>An array of MetricDataQuery structures, used in an alarm based on a
        /// metric math expression. Each structure either retrieves a
        /// metric or performs a math expression.
        ///
        /// One item in the Metrics array is the math expression that the alarm watches.
        /// This expression by designated by having <code>ReturnData</code> set to
        /// true.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricDataQuery>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>In an alarm based on an anomaly detection model, this is the ID of the
        /// <code>ANOMALY_DETECTION_BAND</code> function
        /// used as the threshold for the alarm.</p>
        pub fn threshold_metric_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.threshold_metric_id = Some(input.into());
            self
        }
        /// <p>In an alarm based on an anomaly detection model, this is the ID of the
        /// <code>ANOMALY_DETECTION_BAND</code> function
        /// used as the threshold for the alarm.</p>
        pub fn set_threshold_metric_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.threshold_metric_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricAlarm`](crate::model::MetricAlarm)
        pub fn build(self) -> crate::model::MetricAlarm {
            crate::model::MetricAlarm {
                alarm_name: self.alarm_name,
                alarm_arn: self.alarm_arn,
                alarm_description: self.alarm_description,
                alarm_configuration_updated_timestamp: self.alarm_configuration_updated_timestamp,
                actions_enabled: self.actions_enabled,
                ok_actions: self.ok_actions,
                alarm_actions: self.alarm_actions,
                insufficient_data_actions: self.insufficient_data_actions,
                state_value: self.state_value,
                state_reason: self.state_reason,
                state_reason_data: self.state_reason_data,
                state_updated_timestamp: self.state_updated_timestamp,
                metric_name: self.metric_name,
                namespace: self.namespace,
                statistic: self.statistic,
                extended_statistic: self.extended_statistic,
                dimensions: self.dimensions,
                period: self.period,
                unit: self.unit,
                evaluation_periods: self.evaluation_periods,
                datapoints_to_alarm: self.datapoints_to_alarm,
                threshold: self.threshold,
                comparison_operator: self.comparison_operator,
                treat_missing_data: self.treat_missing_data,
                evaluate_low_sample_count_percentile: self.evaluate_low_sample_count_percentile,
                metrics: self.metrics,
                threshold_metric_id: self.threshold_metric_id,
            }
        }
    }
}
impl MetricAlarm {
    /// Creates a new builder-style object to manufacture [`MetricAlarm`](crate::model::MetricAlarm)
    pub fn builder() -> crate::model::metric_alarm::Builder {
        crate::model::metric_alarm::Builder::default()
    }
}

/// <p>The details about a composite alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompositeAlarm {
    /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
    pub actions_enabled: std::option::Option<bool>,
    /// <p>The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub alarm_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub alarm_arn: std::option::Option<std::string::String>,
    /// <p>The time stamp of the last update to the alarm configuration.</p>
    pub alarm_configuration_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The description of the alarm.</p>
    pub alarm_description: std::option::Option<std::string::String>,
    /// <p>The name of the alarm.</p>
    pub alarm_name: std::option::Option<std::string::String>,
    /// <p>The rule that this alarm uses to evaluate its alarm state.</p>
    pub alarm_rule: std::option::Option<std::string::String>,
    /// <p>The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub insufficient_data_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub ok_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An explanation for the alarm state, in text format.</p>
    pub state_reason: std::option::Option<std::string::String>,
    /// <p>An explanation for the alarm state, in JSON format.</p>
    pub state_reason_data: std::option::Option<std::string::String>,
    /// <p>The time stamp of the last update to the alarm state.</p>
    pub state_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The state value for the alarm.</p>
    pub state_value: std::option::Option<crate::model::StateValue>,
}
impl CompositeAlarm {
    /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
    pub fn actions_enabled(&self) -> std::option::Option<bool> {
        self.actions_enabled
    }
    /// <p>The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub fn alarm_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.alarm_actions.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub fn alarm_arn(&self) -> std::option::Option<&str> {
        self.alarm_arn.as_deref()
    }
    /// <p>The time stamp of the last update to the alarm configuration.</p>
    pub fn alarm_configuration_updated_timestamp(
        &self,
    ) -> std::option::Option<&aws_smithy_types::Instant> {
        self.alarm_configuration_updated_timestamp.as_ref()
    }
    /// <p>The description of the alarm.</p>
    pub fn alarm_description(&self) -> std::option::Option<&str> {
        self.alarm_description.as_deref()
    }
    /// <p>The name of the alarm.</p>
    pub fn alarm_name(&self) -> std::option::Option<&str> {
        self.alarm_name.as_deref()
    }
    /// <p>The rule that this alarm uses to evaluate its alarm state.</p>
    pub fn alarm_rule(&self) -> std::option::Option<&str> {
        self.alarm_rule.as_deref()
    }
    /// <p>The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub fn insufficient_data_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.insufficient_data_actions.as_deref()
    }
    /// <p>The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
    pub fn ok_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.ok_actions.as_deref()
    }
    /// <p>An explanation for the alarm state, in text format.</p>
    pub fn state_reason(&self) -> std::option::Option<&str> {
        self.state_reason.as_deref()
    }
    /// <p>An explanation for the alarm state, in JSON format.</p>
    pub fn state_reason_data(&self) -> std::option::Option<&str> {
        self.state_reason_data.as_deref()
    }
    /// <p>The time stamp of the last update to the alarm state.</p>
    pub fn state_updated_timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.state_updated_timestamp.as_ref()
    }
    /// <p>The state value for the alarm.</p>
    pub fn state_value(&self) -> std::option::Option<&crate::model::StateValue> {
        self.state_value.as_ref()
    }
}
impl std::fmt::Debug for CompositeAlarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompositeAlarm");
        formatter.field("actions_enabled", &self.actions_enabled);
        formatter.field("alarm_actions", &self.alarm_actions);
        formatter.field("alarm_arn", &self.alarm_arn);
        formatter.field(
            "alarm_configuration_updated_timestamp",
            &self.alarm_configuration_updated_timestamp,
        );
        formatter.field("alarm_description", &self.alarm_description);
        formatter.field("alarm_name", &self.alarm_name);
        formatter.field("alarm_rule", &self.alarm_rule);
        formatter.field("insufficient_data_actions", &self.insufficient_data_actions);
        formatter.field("ok_actions", &self.ok_actions);
        formatter.field("state_reason", &self.state_reason);
        formatter.field("state_reason_data", &self.state_reason_data);
        formatter.field("state_updated_timestamp", &self.state_updated_timestamp);
        formatter.field("state_value", &self.state_value);
        formatter.finish()
    }
}
/// See [`CompositeAlarm`](crate::model::CompositeAlarm)
pub mod composite_alarm {
    /// A builder for [`CompositeAlarm`](crate::model::CompositeAlarm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) actions_enabled: std::option::Option<bool>,
        pub(crate) alarm_actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) alarm_arn: std::option::Option<std::string::String>,
        pub(crate) alarm_configuration_updated_timestamp:
            std::option::Option<aws_smithy_types::Instant>,
        pub(crate) alarm_description: std::option::Option<std::string::String>,
        pub(crate) alarm_name: std::option::Option<std::string::String>,
        pub(crate) alarm_rule: std::option::Option<std::string::String>,
        pub(crate) insufficient_data_actions:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ok_actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state_reason: std::option::Option<std::string::String>,
        pub(crate) state_reason_data: std::option::Option<std::string::String>,
        pub(crate) state_updated_timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) state_value: std::option::Option<crate::model::StateValue>,
    }
    impl Builder {
        /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
        pub fn actions_enabled(mut self, input: bool) -> Self {
            self.actions_enabled = Some(input);
            self
        }
        /// <p>Indicates whether actions should be executed during any changes to the alarm state.</p>
        pub fn set_actions_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.actions_enabled = input;
            self
        }
        /// Appends an item to `alarm_actions`.
        ///
        /// To override the contents of this collection use [`set_alarm_actions`](Self::set_alarm_actions).
        ///
        /// <p>The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn alarm_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.alarm_actions.unwrap_or_default();
            v.push(input.into());
            self.alarm_actions = Some(v);
            self
        }
        /// <p>The actions to execute when this alarm transitions to the ALARM state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn set_alarm_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.alarm_actions = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn alarm_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
        pub fn set_alarm_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_arn = input;
            self
        }
        /// <p>The time stamp of the last update to the alarm configuration.</p>
        pub fn alarm_configuration_updated_timestamp(
            mut self,
            input: aws_smithy_types::Instant,
        ) -> Self {
            self.alarm_configuration_updated_timestamp = Some(input);
            self
        }
        /// <p>The time stamp of the last update to the alarm configuration.</p>
        pub fn set_alarm_configuration_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.alarm_configuration_updated_timestamp = input;
            self
        }
        /// <p>The description of the alarm.</p>
        pub fn alarm_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_description = Some(input.into());
            self
        }
        /// <p>The description of the alarm.</p>
        pub fn set_alarm_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alarm_description = input;
            self
        }
        /// <p>The name of the alarm.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// <p>The rule that this alarm uses to evaluate its alarm state.</p>
        pub fn alarm_rule(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_rule = Some(input.into());
            self
        }
        /// <p>The rule that this alarm uses to evaluate its alarm state.</p>
        pub fn set_alarm_rule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_rule = input;
            self
        }
        /// Appends an item to `insufficient_data_actions`.
        ///
        /// To override the contents of this collection use [`set_insufficient_data_actions`](Self::set_insufficient_data_actions).
        ///
        /// <p>The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn insufficient_data_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.insufficient_data_actions.unwrap_or_default();
            v.push(input.into());
            self.insufficient_data_actions = Some(v);
            self
        }
        /// <p>The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn set_insufficient_data_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.insufficient_data_actions = input;
            self
        }
        /// Appends an item to `ok_actions`.
        ///
        /// To override the contents of this collection use [`set_ok_actions`](Self::set_ok_actions).
        ///
        /// <p>The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn ok_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ok_actions.unwrap_or_default();
            v.push(input.into());
            self.ok_actions = Some(v);
            self
        }
        /// <p>The actions to execute when this alarm transitions to the OK state from any other state. Each action is specified as an Amazon Resource Name (ARN).</p>
        pub fn set_ok_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ok_actions = input;
            self
        }
        /// <p>An explanation for the alarm state, in text format.</p>
        pub fn state_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason = Some(input.into());
            self
        }
        /// <p>An explanation for the alarm state, in text format.</p>
        pub fn set_state_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state_reason = input;
            self
        }
        /// <p>An explanation for the alarm state, in JSON format.</p>
        pub fn state_reason_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.state_reason_data = Some(input.into());
            self
        }
        /// <p>An explanation for the alarm state, in JSON format.</p>
        pub fn set_state_reason_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.state_reason_data = input;
            self
        }
        /// <p>The time stamp of the last update to the alarm state.</p>
        pub fn state_updated_timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.state_updated_timestamp = Some(input);
            self
        }
        /// <p>The time stamp of the last update to the alarm state.</p>
        pub fn set_state_updated_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.state_updated_timestamp = input;
            self
        }
        /// <p>The state value for the alarm.</p>
        pub fn state_value(mut self, input: crate::model::StateValue) -> Self {
            self.state_value = Some(input);
            self
        }
        /// <p>The state value for the alarm.</p>
        pub fn set_state_value(
            mut self,
            input: std::option::Option<crate::model::StateValue>,
        ) -> Self {
            self.state_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CompositeAlarm`](crate::model::CompositeAlarm)
        pub fn build(self) -> crate::model::CompositeAlarm {
            crate::model::CompositeAlarm {
                actions_enabled: self.actions_enabled,
                alarm_actions: self.alarm_actions,
                alarm_arn: self.alarm_arn,
                alarm_configuration_updated_timestamp: self.alarm_configuration_updated_timestamp,
                alarm_description: self.alarm_description,
                alarm_name: self.alarm_name,
                alarm_rule: self.alarm_rule,
                insufficient_data_actions: self.insufficient_data_actions,
                ok_actions: self.ok_actions,
                state_reason: self.state_reason,
                state_reason_data: self.state_reason_data,
                state_updated_timestamp: self.state_updated_timestamp,
                state_value: self.state_value,
            }
        }
    }
}
impl CompositeAlarm {
    /// Creates a new builder-style object to manufacture [`CompositeAlarm`](crate::model::CompositeAlarm)
    pub fn builder() -> crate::model::composite_alarm::Builder {
        crate::model::composite_alarm::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlarmType {
    #[allow(missing_docs)] // documentation missing in model
    CompositeAlarm,
    #[allow(missing_docs)] // documentation missing in model
    MetricAlarm,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlarmType {
    fn from(s: &str) -> Self {
        match s {
            "CompositeAlarm" => AlarmType::CompositeAlarm,
            "MetricAlarm" => AlarmType::MetricAlarm,
            other => AlarmType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlarmType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlarmType::from(s))
    }
}
impl AlarmType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlarmType::CompositeAlarm => "CompositeAlarm",
            AlarmType::MetricAlarm => "MetricAlarm",
            AlarmType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CompositeAlarm", "MetricAlarm"]
    }
}
impl AsRef<str> for AlarmType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents the history of a specific alarm.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlarmHistoryItem {
    /// <p>The descriptive name for the alarm.</p>
    pub alarm_name: std::option::Option<std::string::String>,
    /// <p>The type of alarm, either metric alarm or composite alarm.</p>
    pub alarm_type: std::option::Option<crate::model::AlarmType>,
    /// <p>The time stamp for the alarm history item.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The type of alarm history item.</p>
    pub history_item_type: std::option::Option<crate::model::HistoryItemType>,
    /// <p>A summary of the alarm history, in text format.</p>
    pub history_summary: std::option::Option<std::string::String>,
    /// <p>Data about the alarm, in JSON format.</p>
    pub history_data: std::option::Option<std::string::String>,
}
impl AlarmHistoryItem {
    /// <p>The descriptive name for the alarm.</p>
    pub fn alarm_name(&self) -> std::option::Option<&str> {
        self.alarm_name.as_deref()
    }
    /// <p>The type of alarm, either metric alarm or composite alarm.</p>
    pub fn alarm_type(&self) -> std::option::Option<&crate::model::AlarmType> {
        self.alarm_type.as_ref()
    }
    /// <p>The time stamp for the alarm history item.</p>
    pub fn timestamp(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.timestamp.as_ref()
    }
    /// <p>The type of alarm history item.</p>
    pub fn history_item_type(&self) -> std::option::Option<&crate::model::HistoryItemType> {
        self.history_item_type.as_ref()
    }
    /// <p>A summary of the alarm history, in text format.</p>
    pub fn history_summary(&self) -> std::option::Option<&str> {
        self.history_summary.as_deref()
    }
    /// <p>Data about the alarm, in JSON format.</p>
    pub fn history_data(&self) -> std::option::Option<&str> {
        self.history_data.as_deref()
    }
}
impl std::fmt::Debug for AlarmHistoryItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlarmHistoryItem");
        formatter.field("alarm_name", &self.alarm_name);
        formatter.field("alarm_type", &self.alarm_type);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("history_item_type", &self.history_item_type);
        formatter.field("history_summary", &self.history_summary);
        formatter.field("history_data", &self.history_data);
        formatter.finish()
    }
}
/// See [`AlarmHistoryItem`](crate::model::AlarmHistoryItem)
pub mod alarm_history_item {
    /// A builder for [`AlarmHistoryItem`](crate::model::AlarmHistoryItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_name: std::option::Option<std::string::String>,
        pub(crate) alarm_type: std::option::Option<crate::model::AlarmType>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) history_item_type: std::option::Option<crate::model::HistoryItemType>,
        pub(crate) history_summary: std::option::Option<std::string::String>,
        pub(crate) history_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The descriptive name for the alarm.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The descriptive name for the alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// <p>The type of alarm, either metric alarm or composite alarm.</p>
        pub fn alarm_type(mut self, input: crate::model::AlarmType) -> Self {
            self.alarm_type = Some(input);
            self
        }
        /// <p>The type of alarm, either metric alarm or composite alarm.</p>
        pub fn set_alarm_type(
            mut self,
            input: std::option::Option<crate::model::AlarmType>,
        ) -> Self {
            self.alarm_type = input;
            self
        }
        /// <p>The time stamp for the alarm history item.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The time stamp for the alarm history item.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The type of alarm history item.</p>
        pub fn history_item_type(mut self, input: crate::model::HistoryItemType) -> Self {
            self.history_item_type = Some(input);
            self
        }
        /// <p>The type of alarm history item.</p>
        pub fn set_history_item_type(
            mut self,
            input: std::option::Option<crate::model::HistoryItemType>,
        ) -> Self {
            self.history_item_type = input;
            self
        }
        /// <p>A summary of the alarm history, in text format.</p>
        pub fn history_summary(mut self, input: impl Into<std::string::String>) -> Self {
            self.history_summary = Some(input.into());
            self
        }
        /// <p>A summary of the alarm history, in text format.</p>
        pub fn set_history_summary(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.history_summary = input;
            self
        }
        /// <p>Data about the alarm, in JSON format.</p>
        pub fn history_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.history_data = Some(input.into());
            self
        }
        /// <p>Data about the alarm, in JSON format.</p>
        pub fn set_history_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.history_data = input;
            self
        }
        /// Consumes the builder and constructs a [`AlarmHistoryItem`](crate::model::AlarmHistoryItem)
        pub fn build(self) -> crate::model::AlarmHistoryItem {
            crate::model::AlarmHistoryItem {
                alarm_name: self.alarm_name,
                alarm_type: self.alarm_type,
                timestamp: self.timestamp,
                history_item_type: self.history_item_type,
                history_summary: self.history_summary,
                history_data: self.history_data,
            }
        }
    }
}
impl AlarmHistoryItem {
    /// Creates a new builder-style object to manufacture [`AlarmHistoryItem`](crate::model::AlarmHistoryItem)
    pub fn builder() -> crate::model::alarm_history_item::Builder {
        crate::model::alarm_history_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HistoryItemType {
    #[allow(missing_docs)] // documentation missing in model
    Action,
    #[allow(missing_docs)] // documentation missing in model
    ConfigurationUpdate,
    #[allow(missing_docs)] // documentation missing in model
    StateUpdate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HistoryItemType {
    fn from(s: &str) -> Self {
        match s {
            "Action" => HistoryItemType::Action,
            "ConfigurationUpdate" => HistoryItemType::ConfigurationUpdate,
            "StateUpdate" => HistoryItemType::StateUpdate,
            other => HistoryItemType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HistoryItemType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HistoryItemType::from(s))
    }
}
impl HistoryItemType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HistoryItemType::Action => "Action",
            HistoryItemType::ConfigurationUpdate => "ConfigurationUpdate",
            HistoryItemType::StateUpdate => "StateUpdate",
            HistoryItemType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Action", "ConfigurationUpdate", "StateUpdate"]
    }
}
impl AsRef<str> for HistoryItemType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
