// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub fn parse_http_generic_error(
    response: &http::Response<bytes::Bytes>,
) -> Result<aws_smithy_types::Error, aws_smithy_xml::decode::XmlError> {
    crate::rest_xml_wrapped_errors::parse_generic_error(response.body().as_ref())
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resource_not_found_xml_err(
    inp: &[u8],
    mut builder: crate::error::resource_not_found::Builder,
) -> Result<crate::error::resource_not_found::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#ResourceNotFound$message */ =>  {
                let var_1 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_1);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_internal_service_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::internal_service_fault::Builder,
) -> Result<crate::error::internal_service_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudwatch#InternalServiceFault$Message */ =>  {
                let var_2 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_2);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_parameter_value_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_parameter_value_exception::Builder,
) -> Result<
    crate::error::invalid_parameter_value_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#InvalidParameterValueException$message */ =>  {
                let var_3 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_3);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_missing_required_parameter_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::missing_required_parameter_exception::Builder,
) -> Result<
    crate::error::missing_required_parameter_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#MissingRequiredParameterException$message */ =>  {
                let var_4 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_4);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_resource_not_found_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::resource_not_found_exception::Builder,
) -> Result<crate::error::resource_not_found_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudwatch#ResourceNotFoundException$Message */ =>  {
                let var_5 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_5);
            }
            ,
            s if s.matches("ResourceId") /* ResourceId com.amazonaws.cloudwatch#ResourceNotFoundException$ResourceId */ =>  {
                let var_6 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_id(var_6);
            }
            ,
            s if s.matches("ResourceType") /* ResourceType com.amazonaws.cloudwatch#ResourceNotFoundException$ResourceType */ =>  {
                let var_7 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_resource_type(var_7);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_dashboard_not_found_error_xml_err(
    inp: &[u8],
    mut builder: crate::error::dashboard_not_found_error::Builder,
) -> Result<crate::error::dashboard_not_found_error::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#DashboardNotFoundError$message */ =>  {
                let var_8 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_8);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_delete_insight_rules(
    inp: &[u8],
    mut builder: crate::output::delete_insight_rules_output::Builder,
) -> Result<crate::output::delete_insight_rules_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DeleteInsightRulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DeleteInsightRulesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DeleteInsightRulesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DeleteInsightRulesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Failures") /* Failures com.amazonaws.cloudwatch.synthetic#DeleteInsightRulesOutput$Failures */ =>  {
                let var_9 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_batch_failures(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_failures(var_9);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DeleteInsightRulesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_next_token_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_next_token::Builder,
) -> Result<crate::error::invalid_next_token::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#InvalidNextToken$message */ =>  {
                let var_10 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_10);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_alarm_history(
    inp: &[u8],
    mut builder: crate::output::describe_alarm_history_output::Builder,
) -> Result<crate::output::describe_alarm_history_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAlarmHistoryResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAlarmHistoryResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAlarmHistoryResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAlarmHistoryResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AlarmHistoryItems") /* AlarmHistoryItems com.amazonaws.cloudwatch.synthetic#DescribeAlarmHistoryOutput$AlarmHistoryItems */ =>  {
                let var_11 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_alarm_history_items(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_alarm_history_items(var_11);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#DescribeAlarmHistoryOutput$NextToken */ =>  {
                let var_12 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_12);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAlarmHistoryResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_alarms(
    inp: &[u8],
    mut builder: crate::output::describe_alarms_output::Builder,
) -> Result<crate::output::describe_alarms_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAlarmsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAlarmsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAlarmsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAlarmsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("CompositeAlarms") /* CompositeAlarms com.amazonaws.cloudwatch.synthetic#DescribeAlarmsOutput$CompositeAlarms */ =>  {
                let var_13 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_composite_alarms(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_composite_alarms(var_13);
            }
            ,
            s if s.matches("MetricAlarms") /* MetricAlarms com.amazonaws.cloudwatch.synthetic#DescribeAlarmsOutput$MetricAlarms */ =>  {
                let var_14 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_alarms(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metric_alarms(var_14);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#DescribeAlarmsOutput$NextToken */ =>  {
                let var_15 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_15);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAlarmsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_alarms_for_metric(
    inp: &[u8],
    mut builder: crate::output::describe_alarms_for_metric_output::Builder,
) -> Result<
    crate::output::describe_alarms_for_metric_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAlarmsForMetricResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAlarmsForMetricResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAlarmsForMetricResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAlarmsForMetricResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MetricAlarms") /* MetricAlarms com.amazonaws.cloudwatch.synthetic#DescribeAlarmsForMetricOutput$MetricAlarms */ =>  {
                let var_16 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_alarms(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metric_alarms(var_16);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAlarmsForMetricResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_anomaly_detectors(
    inp: &[u8],
    mut builder: crate::output::describe_anomaly_detectors_output::Builder,
) -> Result<
    crate::output::describe_anomaly_detectors_output::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeAnomalyDetectorsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeAnomalyDetectorsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeAnomalyDetectorsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeAnomalyDetectorsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("AnomalyDetectors") /* AnomalyDetectors com.amazonaws.cloudwatch.synthetic#DescribeAnomalyDetectorsOutput$AnomalyDetectors */ =>  {
                let var_17 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_anomaly_detectors(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_anomaly_detectors(var_17);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#DescribeAnomalyDetectorsOutput$NextToken */ =>  {
                let var_18 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_18);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeAnomalyDetectorsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_describe_insight_rules(
    inp: &[u8],
    mut builder: crate::output::describe_insight_rules_output::Builder,
) -> Result<crate::output::describe_insight_rules_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DescribeInsightRulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DescribeInsightRulesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DescribeInsightRulesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DescribeInsightRulesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#DescribeInsightRulesOutput$NextToken */ =>  {
                let var_19 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_19);
            }
            ,
            s if s.matches("InsightRules") /* InsightRules com.amazonaws.cloudwatch.synthetic#DescribeInsightRulesOutput$InsightRules */ =>  {
                let var_20 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_insight_rules(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_insight_rules(var_20);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DescribeInsightRulesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_disable_insight_rules(
    inp: &[u8],
    mut builder: crate::output::disable_insight_rules_output::Builder,
) -> Result<crate::output::disable_insight_rules_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("DisableInsightRulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected DisableInsightRulesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("DisableInsightRulesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected DisableInsightRulesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Failures") /* Failures com.amazonaws.cloudwatch.synthetic#DisableInsightRulesOutput$Failures */ =>  {
                let var_21 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_batch_failures(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_failures(var_21);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected DisableInsightRulesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_limit_exceeded_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::limit_exceeded_exception::Builder,
) -> Result<crate::error::limit_exceeded_exception::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudwatch#LimitExceededException$Message */ =>  {
                let var_22 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_22);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_enable_insight_rules(
    inp: &[u8],
    mut builder: crate::output::enable_insight_rules_output::Builder,
) -> Result<crate::output::enable_insight_rules_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("EnableInsightRulesResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected EnableInsightRulesResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("EnableInsightRulesResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected EnableInsightRulesResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Failures") /* Failures com.amazonaws.cloudwatch.synthetic#EnableInsightRulesOutput$Failures */ =>  {
                let var_23 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_batch_failures(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_failures(var_23);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected EnableInsightRulesResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_dashboard(
    inp: &[u8],
    mut builder: crate::output::get_dashboard_output::Builder,
) -> Result<crate::output::get_dashboard_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetDashboardResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetDashboardResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetDashboardResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetDashboardResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DashboardArn") /* DashboardArn com.amazonaws.cloudwatch.synthetic#GetDashboardOutput$DashboardArn */ =>  {
                let var_24 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dashboard_arn(var_24);
            }
            ,
            s if s.matches("DashboardBody") /* DashboardBody com.amazonaws.cloudwatch.synthetic#GetDashboardOutput$DashboardBody */ =>  {
                let var_25 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dashboard_body(var_25);
            }
            ,
            s if s.matches("DashboardName") /* DashboardName com.amazonaws.cloudwatch.synthetic#GetDashboardOutput$DashboardName */ =>  {
                let var_26 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dashboard_name(var_26);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetDashboardResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_insight_rule_report(
    inp: &[u8],
    mut builder: crate::output::get_insight_rule_report_output::Builder,
) -> Result<crate::output::get_insight_rule_report_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetInsightRuleReportResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetInsightRuleReportResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetInsightRuleReportResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetInsightRuleReportResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("KeyLabels") /* KeyLabels com.amazonaws.cloudwatch.synthetic#GetInsightRuleReportOutput$KeyLabels */ =>  {
                let var_27 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_insight_rule_contributor_key_labels(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_key_labels(var_27);
            }
            ,
            s if s.matches("AggregationStatistic") /* AggregationStatistic com.amazonaws.cloudwatch.synthetic#GetInsightRuleReportOutput$AggregationStatistic */ =>  {
                let var_28 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_aggregation_statistic(var_28);
            }
            ,
            s if s.matches("AggregateValue") /* AggregateValue com.amazonaws.cloudwatch.synthetic#GetInsightRuleReportOutput$AggregateValue */ =>  {
                let var_29 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_aggregate_value(var_29);
            }
            ,
            s if s.matches("ApproximateUniqueCount") /* ApproximateUniqueCount com.amazonaws.cloudwatch.synthetic#GetInsightRuleReportOutput$ApproximateUniqueCount */ =>  {
                let var_30 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.cloudwatch#InsightRuleUnboundLong`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_approximate_unique_count(var_30);
            }
            ,
            s if s.matches("Contributors") /* Contributors com.amazonaws.cloudwatch.synthetic#GetInsightRuleReportOutput$Contributors */ =>  {
                let var_31 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_insight_rule_contributors(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_contributors(var_31);
            }
            ,
            s if s.matches("MetricDatapoints") /* MetricDatapoints com.amazonaws.cloudwatch.synthetic#GetInsightRuleReportOutput$MetricDatapoints */ =>  {
                let var_32 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_insight_rule_metric_datapoints(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metric_datapoints(var_32);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetInsightRuleReportResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_metric_data(
    inp: &[u8],
    mut builder: crate::output::get_metric_data_output::Builder,
) -> Result<crate::output::get_metric_data_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetMetricDataResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetMetricDataResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetMetricDataResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetMetricDataResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MetricDataResults") /* MetricDataResults com.amazonaws.cloudwatch.synthetic#GetMetricDataOutput$MetricDataResults */ =>  {
                let var_33 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_data_results(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metric_data_results(var_33);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#GetMetricDataOutput$NextToken */ =>  {
                let var_34 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_34);
            }
            ,
            s if s.matches("Messages") /* Messages com.amazonaws.cloudwatch.synthetic#GetMetricDataOutput$Messages */ =>  {
                let var_35 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_data_result_messages(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_messages(var_35);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetMetricDataResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_parameter_combination_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_parameter_combination_exception::Builder,
) -> Result<
    crate::error::invalid_parameter_combination_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#InvalidParameterCombinationException$message */ =>  {
                let var_36 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_36);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_metric_statistics(
    inp: &[u8],
    mut builder: crate::output::get_metric_statistics_output::Builder,
) -> Result<crate::output::get_metric_statistics_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetMetricStatisticsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetMetricStatisticsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetMetricStatisticsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetMetricStatisticsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Label") /* Label com.amazonaws.cloudwatch.synthetic#GetMetricStatisticsOutput$Label */ =>  {
                let var_37 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_label(var_37);
            }
            ,
            s if s.matches("Datapoints") /* Datapoints com.amazonaws.cloudwatch.synthetic#GetMetricStatisticsOutput$Datapoints */ =>  {
                let var_38 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_datapoints(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_datapoints(var_38);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetMetricStatisticsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_metric_stream(
    inp: &[u8],
    mut builder: crate::output::get_metric_stream_output::Builder,
) -> Result<crate::output::get_metric_stream_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetMetricStreamResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetMetricStreamResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetMetricStreamResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetMetricStreamResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Arn") /* Arn com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$Arn */ =>  {
                let var_39 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_39);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$Name */ =>  {
                let var_40 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_40);
            }
            ,
            s if s.matches("IncludeFilters") /* IncludeFilters com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$IncludeFilters */ =>  {
                let var_41 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_stream_filters(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_include_filters(var_41);
            }
            ,
            s if s.matches("ExcludeFilters") /* ExcludeFilters com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$ExcludeFilters */ =>  {
                let var_42 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_stream_filters(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_exclude_filters(var_42);
            }
            ,
            s if s.matches("FirehoseArn") /* FirehoseArn com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$FirehoseArn */ =>  {
                let var_43 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_firehose_arn(var_43);
            }
            ,
            s if s.matches("RoleArn") /* RoleArn com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$RoleArn */ =>  {
                let var_44 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_role_arn(var_44);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$State */ =>  {
                let var_45 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_45);
            }
            ,
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$CreationDate */ =>  {
                let var_46 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_46);
            }
            ,
            s if s.matches("LastUpdateDate") /* LastUpdateDate com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$LastUpdateDate */ =>  {
                let var_47 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_update_date(var_47);
            }
            ,
            s if s.matches("OutputFormat") /* OutputFormat com.amazonaws.cloudwatch.synthetic#GetMetricStreamOutput$OutputFormat */ =>  {
                let var_48 =
                    Some(
                        Result::<crate::model::MetricStreamOutputFormat, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::MetricStreamOutputFormat::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_output_format(var_48);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetMetricStreamResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_get_metric_widget_image(
    inp: &[u8],
    mut builder: crate::output::get_metric_widget_image_output::Builder,
) -> Result<crate::output::get_metric_widget_image_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("GetMetricWidgetImageResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected GetMetricWidgetImageResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("GetMetricWidgetImageResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected GetMetricWidgetImageResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("MetricWidgetImage") /* MetricWidgetImage com.amazonaws.cloudwatch.synthetic#GetMetricWidgetImageOutput$MetricWidgetImage */ =>  {
                let var_49 =
                    Some(
                        aws_smithy_types::base64::decode(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|err|aws_smithy_xml::decode::XmlError::custom(format!("invalid base64: {:?}", err))).map(aws_smithy_types::Blob::new)
                        ?
                    )
                ;
                builder = builder.set_metric_widget_image(var_49);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected GetMetricWidgetImageResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_dashboards(
    inp: &[u8],
    mut builder: crate::output::list_dashboards_output::Builder,
) -> Result<crate::output::list_dashboards_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListDashboardsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListDashboardsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListDashboardsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListDashboardsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DashboardEntries") /* DashboardEntries com.amazonaws.cloudwatch.synthetic#ListDashboardsOutput$DashboardEntries */ =>  {
                let var_50 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_dashboard_entries(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dashboard_entries(var_50);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#ListDashboardsOutput$NextToken */ =>  {
                let var_51 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_51);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListDashboardsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_metrics(
    inp: &[u8],
    mut builder: crate::output::list_metrics_output::Builder,
) -> Result<crate::output::list_metrics_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListMetricsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListMetricsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListMetricsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListMetricsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Metrics") /* Metrics com.amazonaws.cloudwatch.synthetic#ListMetricsOutput$Metrics */ =>  {
                let var_52 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metrics(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metrics(var_52);
            }
            ,
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#ListMetricsOutput$NextToken */ =>  {
                let var_53 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_53);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListMetricsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_metric_streams(
    inp: &[u8],
    mut builder: crate::output::list_metric_streams_output::Builder,
) -> Result<crate::output::list_metric_streams_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListMetricStreamsResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListMetricStreamsResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListMetricStreamsResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListMetricStreamsResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("NextToken") /* NextToken com.amazonaws.cloudwatch.synthetic#ListMetricStreamsOutput$NextToken */ =>  {
                let var_54 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_next_token(var_54);
            }
            ,
            s if s.matches("Entries") /* Entries com.amazonaws.cloudwatch.synthetic#ListMetricStreamsOutput$Entries */ =>  {
                let var_55 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_stream_entries(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_entries(var_55);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListMetricStreamsResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_list_tags_for_resource(
    inp: &[u8],
    mut builder: crate::output::list_tags_for_resource_output::Builder,
) -> Result<crate::output::list_tags_for_resource_output::Builder, aws_smithy_xml::decode::XmlError>
{
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("ListTagsForResourceResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected ListTagsForResourceResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("ListTagsForResourceResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected ListTagsForResourceResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Tags") /* Tags com.amazonaws.cloudwatch.synthetic#ListTagsForResourceOutput$Tags */ =>  {
                let var_56 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_tag_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_tags(var_56);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected ListTagsForResourceResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_limit_exceeded_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::limit_exceeded_fault::Builder,
) -> Result<crate::error::limit_exceeded_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#LimitExceededFault$message */ =>  {
                let var_57 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_57);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_dashboard_invalid_input_error_xml_err(
    inp: &[u8],
    mut builder: crate::error::dashboard_invalid_input_error::Builder,
) -> Result<crate::error::dashboard_invalid_input_error::Builder, aws_smithy_xml::decode::XmlError>
{
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("dashboardValidationMessages") /* dashboardValidationMessages com.amazonaws.cloudwatch#DashboardInvalidInputError$dashboardValidationMessages */ =>  {
                let var_58 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_dashboard_validation_messages(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dashboard_validation_messages(var_58);
            }
            ,
            s if s.matches("message") /* message com.amazonaws.cloudwatch#DashboardInvalidInputError$message */ =>  {
                let var_59 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_59);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_put_dashboard(
    inp: &[u8],
    mut builder: crate::output::put_dashboard_output::Builder,
) -> Result<crate::output::put_dashboard_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PutDashboardResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PutDashboardResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("PutDashboardResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected PutDashboardResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("DashboardValidationMessages") /* DashboardValidationMessages com.amazonaws.cloudwatch.synthetic#PutDashboardOutput$DashboardValidationMessages */ =>  {
                let var_60 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_dashboard_validation_messages(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dashboard_validation_messages(var_60);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected PutDashboardResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_concurrent_modification_exception_xml_err(
    inp: &[u8],
    mut builder: crate::error::concurrent_modification_exception::Builder,
) -> Result<
    crate::error::concurrent_modification_exception::Builder,
    aws_smithy_xml::decode::XmlError,
> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Message") /* Message com.amazonaws.cloudwatch#ConcurrentModificationException$Message */ =>  {
                let var_61 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_61);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_operation_crate_operation_put_metric_stream(
    inp: &[u8],
    mut builder: crate::output::put_metric_stream_output::Builder,
) -> Result<crate::output::put_metric_stream_output::Builder, aws_smithy_xml::decode::XmlError> {
    use std::convert::TryFrom;
    let mut doc = aws_smithy_xml::decode::Document::try_from(inp)?;

    #[allow(unused_mut)]
    let mut decoder = doc.root_element()?;
    let start_el = decoder.start_el();
    if !(start_el.matches("PutMetricStreamResponse")) {
        return Err(aws_smithy_xml::decode::XmlError::custom(format!(
            "invalid root, expected PutMetricStreamResponse got {:?}",
            start_el
        )));
    }
    if let Some(mut result_tag) = decoder.next_tag() {
        let start_el = result_tag.start_el();
        if !(start_el.matches("PutMetricStreamResult")) {
            return Err(aws_smithy_xml::decode::XmlError::custom(format!(
                "invalid result, expected PutMetricStreamResult got {:?}",
                start_el
            )));
        }
        while let Some(mut tag) = result_tag.next_tag() {
            match tag.start_el() {
            s if s.matches("Arn") /* Arn com.amazonaws.cloudwatch.synthetic#PutMetricStreamOutput$Arn */ =>  {
                let var_62 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_62);
            }
            ,
            _ => {}
        }
        }
    } else {
        return Err(aws_smithy_xml::decode::XmlError::custom(
            "expected PutMetricStreamResult tag",
        ));
    };
    Ok(builder)
}

#[allow(unused_mut)]
pub fn deser_structure_crate_error_invalid_format_fault_xml_err(
    inp: &[u8],
    mut builder: crate::error::invalid_format_fault::Builder,
) -> Result<crate::error::invalid_format_fault::Builder, aws_smithy_xml::decode::XmlError> {
    if inp.is_empty() {
        return Ok(builder);
    }
    use std::convert::TryFrom;
    let mut document = aws_smithy_xml::decode::Document::try_from(inp)?;
    #[allow(unused_mut)]
    let mut error_decoder = crate::rest_xml_wrapped_errors::error_scope(&mut document)?;
    while let Some(mut tag) = error_decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("message") /* message com.amazonaws.cloudwatch#InvalidFormatFault$message */ =>  {
                let var_63 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_63);
            }
            ,
            _ => {}
        }
    }
    Ok(builder)
}

pub fn deser_list_com_amazonaws_cloudwatch_batch_failures(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::PartialFailure>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#BatchFailures$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_partial_failure(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_alarm_history_items(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AlarmHistoryItem>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#AlarmHistoryItems$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_alarm_history_item(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_composite_alarms(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::CompositeAlarm>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#CompositeAlarms$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_composite_alarm(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_metric_alarms(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MetricAlarm>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#MetricAlarms$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_metric_alarm(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_anomaly_detectors(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::AnomalyDetector>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#AnomalyDetectors$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_anomaly_detector(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_insight_rules(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::InsightRule>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#InsightRules$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_insight_rule(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_insight_rule_contributor_key_labels(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#InsightRuleContributorKeyLabels$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_insight_rule_contributors(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::InsightRuleContributor>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#InsightRuleContributors$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_insight_rule_contributor(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_insight_rule_metric_datapoints(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::InsightRuleMetricDatapoint>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#InsightRuleMetricDatapoints$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_insight_rule_metric_datapoint(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_metric_data_results(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MetricDataResult>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#MetricDataResults$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_metric_data_result(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_metric_data_result_messages(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MessageData>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#MetricDataResultMessages$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_message_data(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_datapoints(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Datapoint>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#Datapoints$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_datapoint(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_metric_stream_filters(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MetricStreamFilter>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#MetricStreamFilters$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_metric_stream_filter(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_dashboard_entries(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::DashboardEntry>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#DashboardEntries$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_dashboard_entry(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_metrics(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Metric>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#Metrics$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_metric(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_metric_stream_entries(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MetricStreamEntry>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#MetricStreamEntries$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_metric_stream_entry(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_tag_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Tag>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#TagList$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_tag(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_dashboard_validation_messages(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::DashboardValidationMessage>, aws_smithy_xml::decode::XmlError>
{
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#DashboardValidationMessages$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_dashboard_validation_message(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_partial_failure(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::PartialFailure, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::PartialFailure::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("FailureResource") /* FailureResource com.amazonaws.cloudwatch#PartialFailure$FailureResource */ =>  {
                let var_64 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_resource(var_64);
            }
            ,
            s if s.matches("ExceptionType") /* ExceptionType com.amazonaws.cloudwatch#PartialFailure$ExceptionType */ =>  {
                let var_65 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_exception_type(var_65);
            }
            ,
            s if s.matches("FailureCode") /* FailureCode com.amazonaws.cloudwatch#PartialFailure$FailureCode */ =>  {
                let var_66 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_code(var_66);
            }
            ,
            s if s.matches("FailureDescription") /* FailureDescription com.amazonaws.cloudwatch#PartialFailure$FailureDescription */ =>  {
                let var_67 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_failure_description(var_67);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_alarm_history_item(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AlarmHistoryItem, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AlarmHistoryItem::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AlarmName") /* AlarmName com.amazonaws.cloudwatch#AlarmHistoryItem$AlarmName */ =>  {
                let var_68 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_name(var_68);
            }
            ,
            s if s.matches("AlarmType") /* AlarmType com.amazonaws.cloudwatch#AlarmHistoryItem$AlarmType */ =>  {
                let var_69 =
                    Some(
                        Result::<crate::model::AlarmType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AlarmType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_type(var_69);
            }
            ,
            s if s.matches("Timestamp") /* Timestamp com.amazonaws.cloudwatch#AlarmHistoryItem$Timestamp */ =>  {
                let var_70 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_70);
            }
            ,
            s if s.matches("HistoryItemType") /* HistoryItemType com.amazonaws.cloudwatch#AlarmHistoryItem$HistoryItemType */ =>  {
                let var_71 =
                    Some(
                        Result::<crate::model::HistoryItemType, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::HistoryItemType::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_history_item_type(var_71);
            }
            ,
            s if s.matches("HistorySummary") /* HistorySummary com.amazonaws.cloudwatch#AlarmHistoryItem$HistorySummary */ =>  {
                let var_72 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_history_summary(var_72);
            }
            ,
            s if s.matches("HistoryData") /* HistoryData com.amazonaws.cloudwatch#AlarmHistoryItem$HistoryData */ =>  {
                let var_73 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_history_data(var_73);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_composite_alarm(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::CompositeAlarm, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::CompositeAlarm::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ActionsEnabled") /* ActionsEnabled com.amazonaws.cloudwatch#CompositeAlarm$ActionsEnabled */ =>  {
                let var_74 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudwatch#ActionsEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_actions_enabled(var_74);
            }
            ,
            s if s.matches("AlarmActions") /* AlarmActions com.amazonaws.cloudwatch#CompositeAlarm$AlarmActions */ =>  {
                let var_75 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_resource_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_alarm_actions(var_75);
            }
            ,
            s if s.matches("AlarmArn") /* AlarmArn com.amazonaws.cloudwatch#CompositeAlarm$AlarmArn */ =>  {
                let var_76 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_arn(var_76);
            }
            ,
            s if s.matches("AlarmConfigurationUpdatedTimestamp") /* AlarmConfigurationUpdatedTimestamp com.amazonaws.cloudwatch#CompositeAlarm$AlarmConfigurationUpdatedTimestamp */ =>  {
                let var_77 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_alarm_configuration_updated_timestamp(var_77);
            }
            ,
            s if s.matches("AlarmDescription") /* AlarmDescription com.amazonaws.cloudwatch#CompositeAlarm$AlarmDescription */ =>  {
                let var_78 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_description(var_78);
            }
            ,
            s if s.matches("AlarmName") /* AlarmName com.amazonaws.cloudwatch#CompositeAlarm$AlarmName */ =>  {
                let var_79 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_name(var_79);
            }
            ,
            s if s.matches("AlarmRule") /* AlarmRule com.amazonaws.cloudwatch#CompositeAlarm$AlarmRule */ =>  {
                let var_80 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_rule(var_80);
            }
            ,
            s if s.matches("InsufficientDataActions") /* InsufficientDataActions com.amazonaws.cloudwatch#CompositeAlarm$InsufficientDataActions */ =>  {
                let var_81 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_resource_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_insufficient_data_actions(var_81);
            }
            ,
            s if s.matches("OKActions") /* OKActions com.amazonaws.cloudwatch#CompositeAlarm$OKActions */ =>  {
                let var_82 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_resource_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ok_actions(var_82);
            }
            ,
            s if s.matches("StateReason") /* StateReason com.amazonaws.cloudwatch#CompositeAlarm$StateReason */ =>  {
                let var_83 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state_reason(var_83);
            }
            ,
            s if s.matches("StateReasonData") /* StateReasonData com.amazonaws.cloudwatch#CompositeAlarm$StateReasonData */ =>  {
                let var_84 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state_reason_data(var_84);
            }
            ,
            s if s.matches("StateUpdatedTimestamp") /* StateUpdatedTimestamp com.amazonaws.cloudwatch#CompositeAlarm$StateUpdatedTimestamp */ =>  {
                let var_85 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_state_updated_timestamp(var_85);
            }
            ,
            s if s.matches("StateValue") /* StateValue com.amazonaws.cloudwatch#CompositeAlarm$StateValue */ =>  {
                let var_86 =
                    Some(
                        Result::<crate::model::StateValue, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StateValue::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state_value(var_86);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metric_alarm(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricAlarm, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricAlarm::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("AlarmName") /* AlarmName com.amazonaws.cloudwatch#MetricAlarm$AlarmName */ =>  {
                let var_87 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_name(var_87);
            }
            ,
            s if s.matches("AlarmArn") /* AlarmArn com.amazonaws.cloudwatch#MetricAlarm$AlarmArn */ =>  {
                let var_88 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_arn(var_88);
            }
            ,
            s if s.matches("AlarmDescription") /* AlarmDescription com.amazonaws.cloudwatch#MetricAlarm$AlarmDescription */ =>  {
                let var_89 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_alarm_description(var_89);
            }
            ,
            s if s.matches("AlarmConfigurationUpdatedTimestamp") /* AlarmConfigurationUpdatedTimestamp com.amazonaws.cloudwatch#MetricAlarm$AlarmConfigurationUpdatedTimestamp */ =>  {
                let var_90 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_alarm_configuration_updated_timestamp(var_90);
            }
            ,
            s if s.matches("ActionsEnabled") /* ActionsEnabled com.amazonaws.cloudwatch#MetricAlarm$ActionsEnabled */ =>  {
                let var_91 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudwatch#ActionsEnabled`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_actions_enabled(var_91);
            }
            ,
            s if s.matches("OKActions") /* OKActions com.amazonaws.cloudwatch#MetricAlarm$OKActions */ =>  {
                let var_92 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_resource_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_ok_actions(var_92);
            }
            ,
            s if s.matches("AlarmActions") /* AlarmActions com.amazonaws.cloudwatch#MetricAlarm$AlarmActions */ =>  {
                let var_93 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_resource_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_alarm_actions(var_93);
            }
            ,
            s if s.matches("InsufficientDataActions") /* InsufficientDataActions com.amazonaws.cloudwatch#MetricAlarm$InsufficientDataActions */ =>  {
                let var_94 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_resource_list(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_insufficient_data_actions(var_94);
            }
            ,
            s if s.matches("StateValue") /* StateValue com.amazonaws.cloudwatch#MetricAlarm$StateValue */ =>  {
                let var_95 =
                    Some(
                        Result::<crate::model::StateValue, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StateValue::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state_value(var_95);
            }
            ,
            s if s.matches("StateReason") /* StateReason com.amazonaws.cloudwatch#MetricAlarm$StateReason */ =>  {
                let var_96 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state_reason(var_96);
            }
            ,
            s if s.matches("StateReasonData") /* StateReasonData com.amazonaws.cloudwatch#MetricAlarm$StateReasonData */ =>  {
                let var_97 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state_reason_data(var_97);
            }
            ,
            s if s.matches("StateUpdatedTimestamp") /* StateUpdatedTimestamp com.amazonaws.cloudwatch#MetricAlarm$StateUpdatedTimestamp */ =>  {
                let var_98 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_state_updated_timestamp(var_98);
            }
            ,
            s if s.matches("MetricName") /* MetricName com.amazonaws.cloudwatch#MetricAlarm$MetricName */ =>  {
                let var_99 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_metric_name(var_99);
            }
            ,
            s if s.matches("Namespace") /* Namespace com.amazonaws.cloudwatch#MetricAlarm$Namespace */ =>  {
                let var_100 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_namespace(var_100);
            }
            ,
            s if s.matches("Statistic") /* Statistic com.amazonaws.cloudwatch#MetricAlarm$Statistic */ =>  {
                let var_101 =
                    Some(
                        Result::<crate::model::Statistic, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::Statistic::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_statistic(var_101);
            }
            ,
            s if s.matches("ExtendedStatistic") /* ExtendedStatistic com.amazonaws.cloudwatch#MetricAlarm$ExtendedStatistic */ =>  {
                let var_102 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_extended_statistic(var_102);
            }
            ,
            s if s.matches("Dimensions") /* Dimensions com.amazonaws.cloudwatch#MetricAlarm$Dimensions */ =>  {
                let var_103 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_dimensions(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dimensions(var_103);
            }
            ,
            s if s.matches("Period") /* Period com.amazonaws.cloudwatch#MetricAlarm$Period */ =>  {
                let var_104 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudwatch#Period`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_period(var_104);
            }
            ,
            s if s.matches("Unit") /* Unit com.amazonaws.cloudwatch#MetricAlarm$Unit */ =>  {
                let var_105 =
                    Some(
                        Result::<crate::model::StandardUnit, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StandardUnit::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_unit(var_105);
            }
            ,
            s if s.matches("EvaluationPeriods") /* EvaluationPeriods com.amazonaws.cloudwatch#MetricAlarm$EvaluationPeriods */ =>  {
                let var_106 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudwatch#EvaluationPeriods`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_evaluation_periods(var_106);
            }
            ,
            s if s.matches("DatapointsToAlarm") /* DatapointsToAlarm com.amazonaws.cloudwatch#MetricAlarm$DatapointsToAlarm */ =>  {
                let var_107 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudwatch#DatapointsToAlarm`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_datapoints_to_alarm(var_107);
            }
            ,
            s if s.matches("Threshold") /* Threshold com.amazonaws.cloudwatch#MetricAlarm$Threshold */ =>  {
                let var_108 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#Threshold`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_threshold(var_108);
            }
            ,
            s if s.matches("ComparisonOperator") /* ComparisonOperator com.amazonaws.cloudwatch#MetricAlarm$ComparisonOperator */ =>  {
                let var_109 =
                    Some(
                        Result::<crate::model::ComparisonOperator, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::ComparisonOperator::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_comparison_operator(var_109);
            }
            ,
            s if s.matches("TreatMissingData") /* TreatMissingData com.amazonaws.cloudwatch#MetricAlarm$TreatMissingData */ =>  {
                let var_110 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_treat_missing_data(var_110);
            }
            ,
            s if s.matches("EvaluateLowSampleCountPercentile") /* EvaluateLowSampleCountPercentile com.amazonaws.cloudwatch#MetricAlarm$EvaluateLowSampleCountPercentile */ =>  {
                let var_111 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_evaluate_low_sample_count_percentile(var_111);
            }
            ,
            s if s.matches("Metrics") /* Metrics com.amazonaws.cloudwatch#MetricAlarm$Metrics */ =>  {
                let var_112 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_data_queries(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metrics(var_112);
            }
            ,
            s if s.matches("ThresholdMetricId") /* ThresholdMetricId com.amazonaws.cloudwatch#MetricAlarm$ThresholdMetricId */ =>  {
                let var_113 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_threshold_metric_id(var_113);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_anomaly_detector(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnomalyDetector, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnomalyDetector::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Namespace") /* Namespace com.amazonaws.cloudwatch#AnomalyDetector$Namespace */ =>  {
                let var_114 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_namespace(var_114);
            }
            ,
            s if s.matches("MetricName") /* MetricName com.amazonaws.cloudwatch#AnomalyDetector$MetricName */ =>  {
                let var_115 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_metric_name(var_115);
            }
            ,
            s if s.matches("Dimensions") /* Dimensions com.amazonaws.cloudwatch#AnomalyDetector$Dimensions */ =>  {
                let var_116 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_dimensions(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dimensions(var_116);
            }
            ,
            s if s.matches("Stat") /* Stat com.amazonaws.cloudwatch#AnomalyDetector$Stat */ =>  {
                let var_117 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_stat(var_117);
            }
            ,
            s if s.matches("Configuration") /* Configuration com.amazonaws.cloudwatch#AnomalyDetector$Configuration */ =>  {
                let var_118 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_anomaly_detector_configuration(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_configuration(var_118);
            }
            ,
            s if s.matches("StateValue") /* StateValue com.amazonaws.cloudwatch#AnomalyDetector$StateValue */ =>  {
                let var_119 =
                    Some(
                        Result::<crate::model::AnomalyDetectorStateValue, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::AnomalyDetectorStateValue::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_state_value(var_119);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_insight_rule(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InsightRule, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InsightRule::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.cloudwatch#InsightRule$Name */ =>  {
                let var_120 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_120);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.cloudwatch#InsightRule$State */ =>  {
                let var_121 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_121);
            }
            ,
            s if s.matches("Schema") /* Schema com.amazonaws.cloudwatch#InsightRule$Schema */ =>  {
                let var_122 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_schema(var_122);
            }
            ,
            s if s.matches("Definition") /* Definition com.amazonaws.cloudwatch#InsightRule$Definition */ =>  {
                let var_123 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_definition(var_123);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_insight_rule_contributor(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InsightRuleContributor, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InsightRuleContributor::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Keys") /* Keys com.amazonaws.cloudwatch#InsightRuleContributor$Keys */ =>  {
                let var_124 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_insight_rule_contributor_keys(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_keys(var_124);
            }
            ,
            s if s.matches("ApproximateAggregateValue") /* ApproximateAggregateValue com.amazonaws.cloudwatch#InsightRuleContributor$ApproximateAggregateValue */ =>  {
                let var_125 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_approximate_aggregate_value(var_125);
            }
            ,
            s if s.matches("Datapoints") /* Datapoints com.amazonaws.cloudwatch#InsightRuleContributor$Datapoints */ =>  {
                let var_126 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_insight_rule_contributor_datapoints(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_datapoints(var_126);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_insight_rule_metric_datapoint(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InsightRuleMetricDatapoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InsightRuleMetricDatapoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Timestamp") /* Timestamp com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$Timestamp */ =>  {
                let var_127 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_127);
            }
            ,
            s if s.matches("UniqueContributors") /* UniqueContributors com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$UniqueContributors */ =>  {
                let var_128 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_unique_contributors(var_128);
            }
            ,
            s if s.matches("MaxContributorValue") /* MaxContributorValue com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$MaxContributorValue */ =>  {
                let var_129 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_max_contributor_value(var_129);
            }
            ,
            s if s.matches("SampleCount") /* SampleCount com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$SampleCount */ =>  {
                let var_130 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sample_count(var_130);
            }
            ,
            s if s.matches("Average") /* Average com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$Average */ =>  {
                let var_131 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_average(var_131);
            }
            ,
            s if s.matches("Sum") /* Sum com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$Sum */ =>  {
                let var_132 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sum(var_132);
            }
            ,
            s if s.matches("Minimum") /* Minimum com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$Minimum */ =>  {
                let var_133 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_minimum(var_133);
            }
            ,
            s if s.matches("Maximum") /* Maximum com.amazonaws.cloudwatch#InsightRuleMetricDatapoint$Maximum */ =>  {
                let var_134 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_maximum(var_134);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metric_data_result(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricDataResult, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricDataResult::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.cloudwatch#MetricDataResult$Id */ =>  {
                let var_135 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_135);
            }
            ,
            s if s.matches("Label") /* Label com.amazonaws.cloudwatch#MetricDataResult$Label */ =>  {
                let var_136 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_label(var_136);
            }
            ,
            s if s.matches("Timestamps") /* Timestamps com.amazonaws.cloudwatch#MetricDataResult$Timestamps */ =>  {
                let var_137 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_timestamps(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_timestamps(var_137);
            }
            ,
            s if s.matches("Values") /* Values com.amazonaws.cloudwatch#MetricDataResult$Values */ =>  {
                let var_138 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_datapoint_values(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_values(var_138);
            }
            ,
            s if s.matches("StatusCode") /* StatusCode com.amazonaws.cloudwatch#MetricDataResult$StatusCode */ =>  {
                let var_139 =
                    Some(
                        Result::<crate::model::StatusCode, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StatusCode::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_status_code(var_139);
            }
            ,
            s if s.matches("Messages") /* Messages com.amazonaws.cloudwatch#MetricDataResult$Messages */ =>  {
                let var_140 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_metric_data_result_messages(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_messages(var_140);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_message_data(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MessageData, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MessageData::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Code") /* Code com.amazonaws.cloudwatch#MessageData$Code */ =>  {
                let var_141 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_code(var_141);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.cloudwatch#MessageData$Value */ =>  {
                let var_142 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_142);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_datapoint(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Datapoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Datapoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Timestamp") /* Timestamp com.amazonaws.cloudwatch#Datapoint$Timestamp */ =>  {
                let var_143 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_143);
            }
            ,
            s if s.matches("SampleCount") /* SampleCount com.amazonaws.cloudwatch#Datapoint$SampleCount */ =>  {
                let var_144 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#DatapointValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sample_count(var_144);
            }
            ,
            s if s.matches("Average") /* Average com.amazonaws.cloudwatch#Datapoint$Average */ =>  {
                let var_145 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#DatapointValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_average(var_145);
            }
            ,
            s if s.matches("Sum") /* Sum com.amazonaws.cloudwatch#Datapoint$Sum */ =>  {
                let var_146 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#DatapointValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_sum(var_146);
            }
            ,
            s if s.matches("Minimum") /* Minimum com.amazonaws.cloudwatch#Datapoint$Minimum */ =>  {
                let var_147 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#DatapointValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_minimum(var_147);
            }
            ,
            s if s.matches("Maximum") /* Maximum com.amazonaws.cloudwatch#Datapoint$Maximum */ =>  {
                let var_148 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#DatapointValue`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_maximum(var_148);
            }
            ,
            s if s.matches("Unit") /* Unit com.amazonaws.cloudwatch#Datapoint$Unit */ =>  {
                let var_149 =
                    Some(
                        Result::<crate::model::StandardUnit, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StandardUnit::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_unit(var_149);
            }
            ,
            s if s.matches("ExtendedStatistics") /* ExtendedStatistics com.amazonaws.cloudwatch#Datapoint$ExtendedStatistics */ =>  {
                let var_150 =
                    Some(
                        crate::xml_deser::deser_map_com_amazonaws_cloudwatch_datapoint_value_map(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_extended_statistics(var_150);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metric_stream_filter(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricStreamFilter, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricStreamFilter::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Namespace") /* Namespace com.amazonaws.cloudwatch#MetricStreamFilter$Namespace */ =>  {
                let var_151 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_namespace(var_151);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_dashboard_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DashboardEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DashboardEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DashboardName") /* DashboardName com.amazonaws.cloudwatch#DashboardEntry$DashboardName */ =>  {
                let var_152 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dashboard_name(var_152);
            }
            ,
            s if s.matches("DashboardArn") /* DashboardArn com.amazonaws.cloudwatch#DashboardEntry$DashboardArn */ =>  {
                let var_153 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_dashboard_arn(var_153);
            }
            ,
            s if s.matches("LastModified") /* LastModified com.amazonaws.cloudwatch#DashboardEntry$LastModified */ =>  {
                let var_154 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#LastModified`)"))
                        ?
                    )
                ;
                builder = builder.set_last_modified(var_154);
            }
            ,
            s if s.matches("Size") /* Size com.amazonaws.cloudwatch#DashboardEntry$Size */ =>  {
                let var_155 =
                    Some(
                         {
                            <i64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (long: `com.amazonaws.cloudwatch#Size`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_size(var_155);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metric(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Metric, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Metric::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Namespace") /* Namespace com.amazonaws.cloudwatch#Metric$Namespace */ =>  {
                let var_156 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_namespace(var_156);
            }
            ,
            s if s.matches("MetricName") /* MetricName com.amazonaws.cloudwatch#Metric$MetricName */ =>  {
                let var_157 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_metric_name(var_157);
            }
            ,
            s if s.matches("Dimensions") /* Dimensions com.amazonaws.cloudwatch#Metric$Dimensions */ =>  {
                let var_158 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_dimensions(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_dimensions(var_158);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metric_stream_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricStreamEntry, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricStreamEntry::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Arn") /* Arn com.amazonaws.cloudwatch#MetricStreamEntry$Arn */ =>  {
                let var_159 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_arn(var_159);
            }
            ,
            s if s.matches("CreationDate") /* CreationDate com.amazonaws.cloudwatch#MetricStreamEntry$CreationDate */ =>  {
                let var_160 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_creation_date(var_160);
            }
            ,
            s if s.matches("LastUpdateDate") /* LastUpdateDate com.amazonaws.cloudwatch#MetricStreamEntry$LastUpdateDate */ =>  {
                let var_161 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_last_update_date(var_161);
            }
            ,
            s if s.matches("Name") /* Name com.amazonaws.cloudwatch#MetricStreamEntry$Name */ =>  {
                let var_162 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_162);
            }
            ,
            s if s.matches("FirehoseArn") /* FirehoseArn com.amazonaws.cloudwatch#MetricStreamEntry$FirehoseArn */ =>  {
                let var_163 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_firehose_arn(var_163);
            }
            ,
            s if s.matches("State") /* State com.amazonaws.cloudwatch#MetricStreamEntry$State */ =>  {
                let var_164 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_state(var_164);
            }
            ,
            s if s.matches("OutputFormat") /* OutputFormat com.amazonaws.cloudwatch#MetricStreamEntry$OutputFormat */ =>  {
                let var_165 =
                    Some(
                        Result::<crate::model::MetricStreamOutputFormat, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::MetricStreamOutputFormat::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_output_format(var_165);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_tag(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Tag, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Tag::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Key") /* Key com.amazonaws.cloudwatch#Tag$Key */ =>  {
                let var_166 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_key(var_166);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.cloudwatch#Tag$Value */ =>  {
                let var_167 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_167);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_dashboard_validation_message(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::DashboardValidationMessage, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::DashboardValidationMessage::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("DataPath") /* DataPath com.amazonaws.cloudwatch#DashboardValidationMessage$DataPath */ =>  {
                let var_168 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_data_path(var_168);
            }
            ,
            s if s.matches("Message") /* Message com.amazonaws.cloudwatch#DashboardValidationMessage$Message */ =>  {
                let var_169 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_message(var_169);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_cloudwatch_resource_list(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#ResourceList$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_dimensions(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Dimension>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#Dimensions$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_dimension(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_metric_data_queries(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::MetricDataQuery>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#MetricDataQueries$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_metric_data_query(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_anomaly_detector_configuration(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::AnomalyDetectorConfiguration, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::AnomalyDetectorConfiguration::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("ExcludedTimeRanges") /* ExcludedTimeRanges com.amazonaws.cloudwatch#AnomalyDetectorConfiguration$ExcludedTimeRanges */ =>  {
                let var_170 =
                    Some(
                        crate::xml_deser::deser_list_com_amazonaws_cloudwatch_anomaly_detector_excluded_time_ranges(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_excluded_time_ranges(var_170);
            }
            ,
            s if s.matches("MetricTimezone") /* MetricTimezone com.amazonaws.cloudwatch#AnomalyDetectorConfiguration$MetricTimezone */ =>  {
                let var_171 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_metric_timezone(var_171);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_cloudwatch_insight_rule_contributor_keys(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<std::string::String>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#InsightRuleContributorKeys$member */ =>  {
                out.push(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_insight_rule_contributor_datapoints(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<
    std::vec::Vec<crate::model::InsightRuleContributorDatapoint>,
    aws_smithy_xml::decode::XmlError,
> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#InsightRuleContributorDatapoints$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_insight_rule_contributor_datapoint(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_timestamps(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<aws_smithy_types::Instant>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#Timestamps$member */ =>  {
                out.push(
                    aws_smithy_types::Instant::from_str(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        , aws_smithy_types::instant::Format::DateTime
                    )
                    .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_list_com_amazonaws_cloudwatch_datapoint_values(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<f64>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#DatapointValues$member */ =>  {
                out.push(
                     {
                        <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#DatapointValue`)"))
                    }
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_map_com_amazonaws_cloudwatch_datapoint_value_map(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::collections::HashMap<std::string::String, f64>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::collections::HashMap::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("entry") => {
                crate::xml_deser::deser_map_com_amazonaws_cloudwatch_datapoint_value_map_entry(
                    &mut tag, &mut out,
                )?;
            }
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_dimension(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Dimension, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Dimension::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Name") /* Name com.amazonaws.cloudwatch#Dimension$Name */ =>  {
                let var_172 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_name(var_172);
            }
            ,
            s if s.matches("Value") /* Value com.amazonaws.cloudwatch#Dimension$Value */ =>  {
                let var_173 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_value(var_173);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_metric_data_query(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricDataQuery, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricDataQuery::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Id") /* Id com.amazonaws.cloudwatch#MetricDataQuery$Id */ =>  {
                let var_174 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_id(var_174);
            }
            ,
            s if s.matches("MetricStat") /* MetricStat com.amazonaws.cloudwatch#MetricDataQuery$MetricStat */ =>  {
                let var_175 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_metric_stat(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metric_stat(var_175);
            }
            ,
            s if s.matches("Expression") /* Expression com.amazonaws.cloudwatch#MetricDataQuery$Expression */ =>  {
                let var_176 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_expression(var_176);
            }
            ,
            s if s.matches("Label") /* Label com.amazonaws.cloudwatch#MetricDataQuery$Label */ =>  {
                let var_177 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_label(var_177);
            }
            ,
            s if s.matches("ReturnData") /* ReturnData com.amazonaws.cloudwatch#MetricDataQuery$ReturnData */ =>  {
                let var_178 =
                    Some(
                         {
                            <bool as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (boolean: `com.amazonaws.cloudwatch#ReturnData`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_return_data(var_178);
            }
            ,
            s if s.matches("Period") /* Period com.amazonaws.cloudwatch#MetricDataQuery$Period */ =>  {
                let var_179 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudwatch#Period`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_period(var_179);
            }
            ,
            s if s.matches("AccountId") /* AccountId com.amazonaws.cloudwatch#MetricDataQuery$AccountId */ =>  {
                let var_180 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_account_id(var_180);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_list_com_amazonaws_cloudwatch_anomaly_detector_excluded_time_ranges(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<std::vec::Vec<crate::model::Range>, aws_smithy_xml::decode::XmlError> {
    let mut out = std::vec::Vec::new();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("member") /* member com.amazonaws.cloudwatch#AnomalyDetectorExcludedTimeRanges$member */ =>  {
                out.push(
                    crate::xml_deser::deser_structure_crate_model_range(&mut tag)
                    ?
                );
            }
            ,
            _ => {}
        }
    }
    Ok(out)
}

pub fn deser_structure_crate_model_insight_rule_contributor_datapoint(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::InsightRuleContributorDatapoint, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::InsightRuleContributorDatapoint::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Timestamp") /* Timestamp com.amazonaws.cloudwatch#InsightRuleContributorDatapoint$Timestamp */ =>  {
                let var_181 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_timestamp(var_181);
            }
            ,
            s if s.matches("ApproximateValue") /* ApproximateValue com.amazonaws.cloudwatch#InsightRuleContributorDatapoint$ApproximateValue */ =>  {
                let var_182 =
                    Some(
                         {
                            <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#InsightRuleUnboundDouble`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_approximate_value(var_182);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_map_com_amazonaws_cloudwatch_datapoint_value_map_entry(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
    out: &mut std::collections::HashMap<std::string::String, f64>,
) -> Result<(), aws_smithy_xml::decode::XmlError> {
    let mut k: Option<std::string::String> = None;
    let mut v: Option<f64> = None;
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("key") /* key com.amazonaws.cloudwatch#DatapointValueMap$key */ =>  {
                k = Some(
                    Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                        aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        .into()
                    )
                    ?
                )
            }
            ,
            s if s.matches("value") /* value com.amazonaws.cloudwatch#DatapointValueMap$value */ =>  {
                v = Some(
                     {
                        <f64 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (double: `com.amazonaws.cloudwatch#DatapointValue`)"))
                    }
                    ?
                )
            }
            ,
            _ => {}
        }
    }
    let k = k.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing key map entry"))?;
    let v = v.ok_or_else(|| aws_smithy_xml::decode::XmlError::custom("missing value map entry"))?;
    out.insert(k, v);
    Ok(())
}

pub fn deser_structure_crate_model_metric_stat(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::MetricStat, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::MetricStat::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("Metric") /* Metric com.amazonaws.cloudwatch#MetricStat$Metric */ =>  {
                let var_183 =
                    Some(
                        crate::xml_deser::deser_structure_crate_model_metric(&mut tag)
                        ?
                    )
                ;
                builder = builder.set_metric(var_183);
            }
            ,
            s if s.matches("Period") /* Period com.amazonaws.cloudwatch#MetricStat$Period */ =>  {
                let var_184 =
                    Some(
                         {
                            <i32 as aws_smithy_types::primitive::Parse>::parse_smithy_primitive(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                            .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (integer: `com.amazonaws.cloudwatch#Period`)"))
                        }
                        ?
                    )
                ;
                builder = builder.set_period(var_184);
            }
            ,
            s if s.matches("Stat") /* Stat com.amazonaws.cloudwatch#MetricStat$Stat */ =>  {
                let var_185 =
                    Some(
                        Result::<std::string::String, aws_smithy_xml::decode::XmlError>::Ok(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            .into()
                        )
                        ?
                    )
                ;
                builder = builder.set_stat(var_185);
            }
            ,
            s if s.matches("Unit") /* Unit com.amazonaws.cloudwatch#MetricStat$Unit */ =>  {
                let var_186 =
                    Some(
                        Result::<crate::model::StandardUnit, aws_smithy_xml::decode::XmlError>::Ok(
                            crate::model::StandardUnit::from(
                                aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            )
                        )
                        ?
                    )
                ;
                builder = builder.set_unit(var_186);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}

pub fn deser_structure_crate_model_range(
    decoder: &mut aws_smithy_xml::decode::ScopedDecoder,
) -> Result<crate::model::Range, aws_smithy_xml::decode::XmlError> {
    #[allow(unused_mut)]
    let mut builder = crate::model::Range::builder();
    while let Some(mut tag) = decoder.next_tag() {
        match tag.start_el() {
            s if s.matches("StartTime") /* StartTime com.amazonaws.cloudwatch#Range$StartTime */ =>  {
                let var_187 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_start_time(var_187);
            }
            ,
            s if s.matches("EndTime") /* EndTime com.amazonaws.cloudwatch#Range$EndTime */ =>  {
                let var_188 =
                    Some(
                        aws_smithy_types::Instant::from_str(
                            aws_smithy_xml::decode::try_data(&mut tag)?.as_ref()
                            , aws_smithy_types::instant::Format::DateTime
                        )
                        .map_err(|_|aws_smithy_xml::decode::XmlError::custom("expected (timestamp: `com.amazonaws.cloudwatch#Timestamp`)"))
                        ?
                    )
                ;
                builder = builder.set_end_time(var_188);
            }
            ,
            _ => {}
        }
    }
    Ok(builder.build())
}
